/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.ir2tree;

import fr.inria.tapenade.ir2tree.ControlStruct;
import fr.inria.tapenade.ir2tree.TreeGen;
import fr.inria.tapenade.representation.BasicBlock;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.HeaderBlock;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.InstructionMask;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.ToObject;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

final class UnitStruct
extends ControlStruct {
    private final Unit unit;
    private final boolean isInterface;
    private final SymbolTable symbolTableInside;
    protected TapList<ControlStruct> body;
    private FGArrow entryArrow;
    private Tree paramsListTree = ILUtils.build(200);
    private TapList<Instruction> publicDeclarationsInstructions;
    private boolean traceThisUnit;

    protected UnitStruct(Unit unit, boolean isInterface) {
        this.unit = unit;
        this.controlStructBlock = unit.entryBlock;
        this.symbolTableInside = unit.bodySymbolTable();
        if (unit.entryBlock != null && unit.entryBlock.flow() != null) {
            this.entryArrow = (FGArrow)unit.entryBlock.flow().head;
        }
        this.isInterface = isInterface;
    }

    protected void setTraceThisUnit(boolean traceThisUnit) {
        this.traceThisUnit = traceThisUnit;
    }

    @Override
    protected ControlStruct getBlock(Block block) {
        ControlStruct result = null;
        if (this.controlStructBlock == block) {
            result = this;
        } else {
            TapList<ControlStruct> inBody = this.body;
            while (inBody != null && result == null) {
                result = ((ControlStruct)inBody.head).getBlock(block);
                inBody = inBody.tail;
            }
        }
        return result;
    }

    @Override
    protected void addControlStruct(ControlStruct struct, FGArrow arrow) {
        this.body = new TapList<ControlStruct>(struct, this.body);
    }

    @Override
    protected void insertLetStructure() {
        this.body = UnitStruct.insertLetStructureChained(this.body, this.symbolTableInside);
    }

    @Override
    protected void reorderBody() {
        this.body = UnitStruct.reorderBodyChained(this.body);
    }

    @Override
    protected void propagateNaturalNext(Block naturalNext) {
        UnitStruct.propagateNaturalNextChained(this.body, null);
        this.naturalNext = null;
    }

    @Override
    protected TapList<FGArrow> propagateNaturalFlow() {
        this.naturalFlow = UnitStruct.propagateNaturalFlowChained(this.body);
        return null;
    }

    @Override
    protected TapList<FGArrow> preGenerateTree(TapList<FGArrow> naturalArrows, TapList<TapTriplet<Tree, Tree, Integer>> toFutureIncludes, TapList<Tree> fileUserHelpStrings, TapList<ControlStruct> enclosingStructs, boolean skipSubUnits) {
        Block declBlock;
        TapList<Block> allBlocks;
        this.unit.publicSymbolTable().declarationsBlock.checkUnusedDeclaration(this.unit);
        this.publicDeclarationsInstructions = this.unit.publicSymbolTable().declarationsBlock.instructions;
        TapList<Block> tapList = allBlocks = this.isInterface || TapEnv.get().createStub ? null : this.unit.allBlocks;
        if ((this.isInterface || TapEnv.get().createStub || this.unit.isModule()) && this.unit.privateSymbolTable() != null) {
            declBlock = this.symbolTableInside.declarationsBlock;
            allBlocks = TapList.addUnlessPresent(allBlocks, declBlock);
        }
        if ((this.isInterface || TapEnv.get().createStub || this.unit.isModule()) && this.unit.publicSymbolTable() != null) {
            declBlock = this.unit.publicSymbolTable().declarationsBlock;
            allBlocks = TapList.addUnlessPresent(allBlocks, declBlock);
        }
        if (!this.unit.isClass()) {
            TapList<Block> blocks = allBlocks;
            while (blocks != null) {
                Block block;
                block.instructions = this.preGenerateListOfInstructions(block, toFutureIncludes, (block = (Block)blocks.head) == allBlocks.head);
                blocks = blocks.tail;
            }
        }
        TapList<FGArrow> afterBody = UnitStruct.preGenerateTreeChained(this.body, toFutureIncludes, fileUserHelpStrings, new TapList<FGArrow>(this.entryArrow, null), new TapList<ControlStruct>(this, enclosingStructs), skipSubUnits);
        this.buildStructuredTree();
        if (this.unit.preComments != null) {
            this.structuredTree.setAnnotation("preComments", ILUtils.copy(this.unit.preComments));
        }
        if (this.unit.postComments != null) {
            this.structuredTree.setAnnotation("postComments", ILUtils.copy(this.unit.postComments));
        }
        if (this.unit.preCommentsBlock != null) {
            this.structuredTree.setAnnotation("preCommentsBlock", ILUtils.copy(this.unit.preCommentsBlock));
        }
        if (this.unit.postCommentsBlock != null) {
            this.structuredTree.setAnnotation("postCommentsBlock", ILUtils.copy(this.unit.postCommentsBlock));
        }
        this.insertInstructionTree(this.structuredTree, true);
        return afterBody;
    }

    private TapList<Instruction> preGenerateListOfInstructions(Block block, TapList<TapTriplet<Tree, Tree, Integer>> toFutureIncludes, boolean onFirstBlock) {
        if (!this.unit.isC()) {
            block.sortDeclarationsAndOperations();
        }
        if (!(!onFirstBlock || this.unit.isTranslationUnit() && this.unit.isFortran())) {
            TapPair missingInfo;
            assert (this.unit.publicSymbolTable() != null);
            Block publicDeclarationBlock = this.unit.publicSymbolTable().declarationsBlock;
            TapList<TapPair<Tree, SymbolDecl>> missingDecls = TreeGen.generateMissingDeclarations(this.unit, this.unit.publicSymbolTable(), false, true, publicDeclarationBlock, this.traceThisUnit);
            while (missingDecls != null) {
                missingInfo = (TapPair)missingDecls.head;
                if (this.unit.isModule()) {
                    publicDeclarationBlock.addInstrDeclTlBeforeUse(new Instruction((Tree)missingInfo.first), new TapList<SymbolDecl>((SymbolDecl)missingInfo.second, null), null, this.unit.publicSymbolTable(), true);
                } else {
                    publicDeclarationBlock.addInstrHd(new Instruction((Tree)missingInfo.first));
                }
                missingDecls = missingDecls.tail;
            }
            if (publicDeclarationBlock != block && publicDeclarationBlock.instructions != null && !this.unit.isTranslationUnit()) {
                if (!(block instanceof BasicBlock)) {
                    TapEnv.fileWarning(-1, null, "Unit should start with a plain controlStructBlock for declarations!");
                }
                TapList<Instruction> publicDeclInstructions = publicDeclarationBlock.instructions;
                if (this.traceThisUnit) {
                    TapEnv.printlnOnTrace("  Inserting public declarations from " + publicDeclarationBlock + '@' + Integer.toHexString(publicDeclarationBlock.hashCode()) + " -> " + publicDeclInstructions);
                }
                while (publicDeclInstructions != null) {
                    Instruction publicDeclInstr = (Instruction)publicDeclInstructions.head;
                    if (publicDeclInstr.tree != null && publicDeclInstr.tree.getAnnotation("Unit") == null && publicDeclInstr.tree.opCode() != 31) {
                        if (publicDeclInstr.tree.opCode() == 197) {
                            block.addInstrHd(publicDeclInstr);
                        } else {
                            block.addInstrDeclTlBeforeUse(publicDeclInstr, block.symbolDeclDeclared(publicDeclInstr), null, this.unit.publicSymbolTable(), true);
                        }
                    }
                    publicDeclInstructions = publicDeclInstructions.tail;
                }
            }
            this.publicDeclarationsInstructions = publicDeclarationBlock.instructions;
            if (publicDeclarationBlock != block) {
                publicDeclarationBlock.instructions = null;
            }
            if (this.symbolTableInside.declarationsBlock.rank == -2) {
                TapList<Instruction> privateDeclInstructions = this.symbolTableInside.declarationsBlock.instructions;
                block.addInstrDeclTl(privateDeclInstructions);
            }
            if (!this.unit.isTranslationUnit()) {
                missingDecls = TreeGen.generateMissingDeclarations(this.unit, this.symbolTableInside, false, false, block, this.traceThisUnit);
            }
            while (missingDecls != null) {
                missingInfo = (TapPair)missingDecls.head;
                block.addInstrDeclTlBeforeUse(new Instruction((Tree)missingInfo.first), new TapList<SymbolDecl>((SymbolDecl)missingInfo.second, null), null, this.symbolTableInside, true);
                missingDecls = missingDecls.tail;
            }
        }
        TapList<Instruction> insts = block.instructions;
        TapList<Object> newInsts = new TapList<Object>(null, null);
        TapList<Object> toNewInsts = newInsts;
        Instruction previousInstruction = null;
        boolean containsInclude = false;
        TapList<Object> toIncludesBeingBuilt = new TapList<Object>(null, null);
        while (insts != null) {
            Instruction instruction = (Instruction)insts.head;
            if (!(instruction.tree != null && !instruction.isAWhereControl() || instruction.preComments == null && instruction.preCommentsBlock == null)) {
                Instruction dummyInstr = new Instruction(ILUtils.build(138));
                dummyInstr.preComments = instruction.preComments;
                dummyInstr.preCommentsBlock = instruction.preCommentsBlock;
                instruction = dummyInstr;
            }
            if (ILUtils.isAUnitPlaceHolder(instruction.tree)) {
                newInsts = TreeGen.insertInstructionWatchingIncludes(instruction, newInsts, this.unit == this.unit.origUnit, toIncludesBeingBuilt, toFutureIncludes);
            } else if (!(instruction.tree == null || instruction.isAWhereControl() || instruction.tree.opCode() == 199 && instruction.tree.down(3).length() == 0 || TapEnv.get().createStub)) {
                TapList<TapPair<Tree, Boolean>> reversedMask = this.reverseMask(instruction.whereMask());
                if (reversedMask != null) {
                    if (previousInstruction != null && previousInstruction.whereMask() != null && !previousInstruction.whereMask().isEmpty() && this.insertInPreviousWhere(instruction.tree, reversedMask, previousInstruction.tree)) {
                        instruction.tree = null;
                    } else {
                        instruction.tree = this.buildWhereTree(reversedMask, instruction.tree);
                        newInsts = TreeGen.insertInstructionWatchingIncludes(null, newInsts, this.unit == this.unit.origUnit, toIncludesBeingBuilt, toFutureIncludes);
                        newInsts = newInsts.placdl(instruction);
                        previousInstruction = instruction;
                    }
                } else if (instruction.isInStdCInclude()) {
                    if (instruction.tree.opCode() == 101 && instruction.fromIncludeRootName() != null && instruction.fromIncludeRootName().equals(instruction.tree.stringValue())) {
                        newInsts = newInsts.placdl(instruction);
                        previousInstruction = instruction;
                    }
                } else if (TapEnv.get().expandAllIncludeFile || instruction.fromInclude() == null || instruction.fromInclude().tree == null || instruction.fromInclude().tree.opCode() == 101 && instruction.fromInclude().tree.stringValue().isEmpty()) {
                    newInsts = TreeGen.insertInstructionWatchingIncludes(null, newInsts, this.unit == this.unit.origUnit, toIncludesBeingBuilt, toFutureIncludes);
                    if (!TapEnv.get().expandAllIncludeFile || instruction.tree.opCode() != 101 || TapEnv.isStdIncludeName(instruction.tree.stringValue())) {
                        newInsts = newInsts.placdl(instruction);
                        previousInstruction = instruction;
                    }
                } else {
                    containsInclude = true;
                    if (instruction.tree != null && instruction.tree.equalsTree(instruction.fromInclude().tree)) {
                        instruction.fromInclude().preComments = instruction.preComments;
                        instruction.fromInclude().preCommentsBlock = instruction.preCommentsBlock;
                        instruction.fromInclude().postComments = instruction.postComments;
                        instruction.fromInclude().postCommentsBlock = instruction.postCommentsBlock;
                    }
                    newInsts = TreeGen.insertInstructionWatchingIncludes(instruction, newInsts, this.unit == this.unit.origUnit, toIncludesBeingBuilt, toFutureIncludes);
                    previousInstruction = instruction;
                }
            }
            insts = insts.tail;
        }
        newInsts = TreeGen.insertInstructionWatchingIncludes(null, newInsts, this.unit == this.unit.origUnit, toIncludesBeingBuilt, toFutureIncludes);
        newInsts = toNewInsts.tail;
        if (containsInclude) {
            TapList<Object> inNewInsts = toNewInsts = new TapList<Object>(null, newInsts);
            TapList<Tree> seenIncludes = null;
            while (inNewInsts.tail != null) {
                Instruction curInstr = (Instruction)inNewInsts.tail.head;
                if (curInstr.tree != null && curInstr.tree.opCode() == 101) {
                    if (TapList.containsTreeEquals(seenIncludes, curInstr.tree)) {
                        inNewInsts.tail = inNewInsts.tail.tail;
                        continue;
                    }
                    seenIncludes = new TapList<Tree>(curInstr.tree, seenIncludes);
                    inNewInsts = inNewInsts.tail;
                    continue;
                }
                inNewInsts = inNewInsts.tail;
            }
            newInsts = toNewInsts.tail;
        }
        return newInsts;
    }

    private TapList<Instruction> buildIncludeChain(Instruction instruction) {
        Instruction includeInstr = instruction.fromInclude();
        if (instruction.tree.opCode() == 101 && includeInstr != null && instruction.tree.stringValue().equals(includeInstr.tree.stringValue())) {
            instruction = includeInstr;
        }
        TapList<Instruction> chain = new TapList<Instruction>(instruction, null);
        for (Instruction fromInclude = instruction.fromInclude(); fromInclude != null; fromInclude = fromInclude.fromInclude()) {
            chain = new TapList<Instruction>(fromInclude, chain);
        }
        return chain;
    }

    private void buildStructuredTree() {
        this.structuredTree = this.unit.isModule() ? ILUtils.build(131) : (this.unit.isClass() ? ILUtils.copy(this.unit.entryBlock.lastInstr().tree) : (this.unit == this.unit.callGraph().getMainUnit() && this.unit.language() != 4 ? ILUtils.build(159) : (this.unit.isProcedure() ? ILUtils.build(89) : ILUtils.build(27))));
    }

    protected void preGenerateForwardTree() {
        this.buildStructuredTree();
    }

    @Override
    protected void generateTree(boolean delayGoto, TapList<TapTriplet<Tree, Tree, Integer>> toFutureIncludes, TapList<Tree> fileUserHelpStrings) {
        Block publicDeclBlock = this.unit.publicSymbolTable().declarationsBlock;
        Block privateDeclBlock = this.symbolTableInside.declarationsBlock;
        TapList<Tree> declsAndStats = null;
        ToObject<Object> toFunctionTypeDeclTree = new ToObject<Object>(null);
        if ((!this.isInterface && !this.unit.isPackage() || this.unit.allBlocks == null || publicDeclBlock != this.unit.allBlocks.head) && !this.unit.isTranslationUnit() && this.unit.isC() && TapList.length(publicDeclBlock.instructions) != 0) {
            declsAndStats = TapList.reverse(TreeGen.generateReverseListOfTree(publicDeclBlock, toFutureIncludes, fileUserHelpStrings, this.isInterface));
        }
        Tree returnTypeTree = null;
        TapList<SymbolDecl> externalTypes = null;
        if (this.unit.externalSymbolTable() != null) {
            externalTypes = this.unit.externalSymbolTable().getAllTypeDecls();
        }
        if (this.structuredTree.opCode() == 89) {
            returnTypeTree = this.unit.buildReturnTypeTree(privateDeclBlock, externalTypes, toFunctionTypeDeclTree, this.publicDeclarationsInstructions);
        }
        if (this.traceThisUnit) {
            System.out.println("BUILD RETURN TYPE TREE OF " + this.unit + " FTS:" + this.unit.functionTypeSpec() + " ==> " + returnTypeTree);
        }
        TapList<Tree> bodyDeclsAndStats = UnitStruct.generateTreeChained(this.body, false, null, toFutureIncludes, fileUserHelpStrings);
        declsAndStats = TapList.append(declsAndStats, bodyDeclsAndStats);
        TapList<Tree> formats = TapList.reverse(this.unit.formats());
        if (!this.isInterface && !this.unit.isModule() && formats != null) {
            while (formats != null) {
                declsAndStats = TapList.addLast(declsAndStats, formats.head);
                formats = formats.tail;
            }
        }
        if (toFunctionTypeDeclTree.obj() != null) {
            declsAndStats = Block.addTreeDeclTl(declsAndStats, new TapList<Object>(toFunctionTypeDeclTree.obj(), null));
        }
        if (!this.unit.isCPlusPlus() && !this.unit.isTranslationUnit()) {
            TapList<Instruction> nonFlowInstructions = this.unit.nonFlowInstructions;
            while (nonFlowInstructions != null) {
                Tree unitTree;
                Unit subUnit;
                Tree nonFlowTree = ((Instruction)nonFlowInstructions.head).tree;
                if ((nonFlowTree.opCode() == 36 || nonFlowTree.opCode() == 46 || nonFlowTree.opCode() == 89) && (subUnit = (Unit)nonFlowTree.getAnnotation("Unit")) != null && (unitTree = TreeGen.generate(subUnit, false, false, false, toFutureIncludes, this.unit.isC() ? fileUserHelpStrings : null)) != null) {
                    Tree[] newTrees;
                    for (Tree newTree : newTrees = unitTree.children()) {
                        declsAndStats = TapList.addLast(declsAndStats, newTree);
                    }
                }
                nonFlowInstructions = nonFlowInstructions.tail;
            }
        }
        if (this.unit.isModule()) {
            this.structuredTree.setChild(ILUtils.build(96, this.unit.name()), 1);
            this.structuredTree.setChild(ILUtils.build(53, declsAndStats), 2);
        } else if (this.unit.isClass()) {
            this.structuredTree.setChild(ILUtils.build(53, declsAndStats), 4);
        } else if (this.unit.isProcedure()) {
            if (this.unit.modifiers != null) {
                this.structuredTree.setChild(ILUtils.copy(this.unit.modifiers), 1);
            } else {
                this.structuredTree.setChild(ILUtils.build(130), 1);
            }
            int rank = 2;
            if (this.structuredTree.opCode() == 89) {
                if (returnTypeTree != null) {
                    this.structuredTree.setChild(returnTypeTree, rank);
                }
                this.structuredTree.setChild(ILUtils.build(138), ++rank);
                ++rank;
            }
            this.structuredTree.setChild(ILUtils.build(96, this.unit.name()), rank);
            Tree explicitReturnTree = null;
            if (this.unit.publicSymbolTable().getFunctionDecl(this.unit.name(), null, null, false) != null && this.unit.otherReturnVar() != null) {
                explicitReturnTree = ILUtils.build(96, this.unit.otherReturnVar().symbol);
            }
            Tree unitHeader = this.unit.headTree();
            if (explicitReturnTree == null && unitHeader != null) {
                explicitReturnTree = unitHeader.opCode() == 31 ? (Tree)ILUtils.getCalledName(unitHeader).getAnnotation("explicitReturnVar") : (Tree)unitHeader.down(1).getAnnotation("explicitReturnVar");
            }
            if (explicitReturnTree != null) {
                this.structuredTree.down(rank).setAnnotation("explicitReturnVar", explicitReturnTree);
            }
            this.structuredTree.setChild(this.paramsListTree, ++rank);
            this.structuredTree.setChild(ILUtils.build(27, declsAndStats), ++rank);
        } else {
            while (declsAndStats != null) {
                this.structuredTree.addChild((Tree)declsAndStats.head, -1);
                declsAndStats = declsAndStats.tail;
            }
        }
    }

    protected void generateForwardTree() {
        Block privateDeclBlock = null;
        if (this.unit.privateSymbolTable() != null) {
            privateDeclBlock = this.symbolTableInside.declarationsBlock;
        }
        Tree returnTypeTree = null;
        if (this.structuredTree.opCode() == 89) {
            returnTypeTree = this.unit.buildReturnTypeTree(privateDeclBlock, null, null, this.publicDeclarationsInstructions);
        }
        if (this.unit.modifiers != null) {
            this.structuredTree.setChild(this.unit.modifiers, 1);
        } else {
            this.structuredTree.setChild(ILUtils.build(130), 1);
        }
        int rank = 2;
        if (this.structuredTree.opCode() == 89) {
            if (returnTypeTree != null) {
                this.structuredTree.setChild(returnTypeTree, 2);
            }
            ++rank;
            this.structuredTree.setChild(ILUtils.build(138), 3);
            ++rank;
        }
        this.structuredTree.setChild(ILUtils.build(96, this.unit.name()), rank);
        this.structuredTree.setChild(this.paramsListTree, ++rank);
        this.structuredTree.setChild(ILUtils.build(138), ++rank);
    }

    protected void generateParameterList() {
        if (!this.unit.isModule()) {
            this.paramsListTree = ILUtils.build(200, this.unit.generateHeaderParamsList(this.unit.publicSymbolTable()));
        }
    }

    protected void findUsedLabels() {
        TapEnv.get().nextNewLabel = 100;
        TapEnv.get().usedLabels = null;
        TapList<Block> allBlocks = new TapList<Block>(this.unit.exitBlock(), this.unit.allBlocks());
        while (allBlocks != null) {
            Block block = (Block)allBlocks.head;
            String label = block.origLabel();
            if (label != null) {
                TapEnv.get().usedLabels = new TapList<String>(label, TapEnv.get().usedLabels);
            }
            if (block instanceof HeaderBlock && (label = ((HeaderBlock)block).origCycleLabel()) != null) {
                TapEnv.get().usedLabels = new TapList<String>(label, TapEnv.get().usedLabels);
            }
            allBlocks = allBlocks.tail;
        }
        TapList<Tree> formats = this.unit.formats();
        while (formats != null) {
            Tree formatTree = (Tree)formats.head;
            TapEnv.get().usedLabels = new TapList<String>(formatTree.down(1).stringValue(), TapEnv.get().usedLabels);
            formats = formats.tail;
        }
    }

    private TapList<TapPair<Tree, Boolean>> reverseMask(InstructionMask mask) {
        TapList<TapPair<Tree, Boolean>> result = null;
        while (mask != null && !mask.isEmpty()) {
            boolean neg = !mask.isTrueBranch;
            Tree maskTest = mask.getControlTree();
            while (maskTest.opCode() == 139) {
                neg = !neg;
                maskTest = maskTest.down(1);
            }
            result = new TapList<TapPair<Tree, Boolean>>(new TapPair<Tree, Boolean>(maskTest, neg ? Boolean.TRUE : Boolean.FALSE), result);
            mask = mask.enclosingMask;
        }
        return result;
    }

    private boolean insertInPreviousWhere(Tree newTree, TapList<TapPair<Tree, Boolean>> newMask, Tree previousWhere) {
        if (newTree.opCode() == 121 ? previousWhere.opCode() != 121 : previousWhere.opCode() == 121) {
            return false;
        }
        int targetCase = this.getCaseOfTest((TapPair)newMask.head, previousWhere);
        if (targetCase == 3 || targetCase == 2 && ILUtils.isNullOrNoneOrEmptyList(previousWhere.down(3))) {
            this.insertInWhereBranch(newTree, newMask.tail, previousWhere, targetCase);
            return true;
        }
        return false;
    }

    private void insertInWhereBranch(Tree newTree, TapList<TapPair<Tree, Boolean>> newMask, Tree whereTree, int caseRank) {
        Tree caseTree;
        if (whereTree.opCode() == 121) {
            whereTree = whereTree.down(4);
        }
        if (newTree.opCode() == 121) {
            newTree = newTree.cutChild(4);
        }
        if (ILUtils.isNullOrNoneOrEmptyList(caseTree = whereTree.down(caseRank))) {
            whereTree.setChild(ILUtils.build(27, this.buildWhereTree(newMask, newTree)), caseRank);
        } else {
            if (caseTree.opCode() != 27) {
                caseTree = ILUtils.build(27, whereTree.cutChild(caseRank));
                whereTree.setChild(caseTree, caseRank);
            }
            int caseLength = caseTree.length();
            Tree lastInCase = caseTree.down(caseLength);
            if (newMask == null || lastInCase.opCode() != 205 || !this.insertInPreviousWhere(newTree, newMask, lastInCase)) {
                caseTree.addChild(this.buildWhereTree(newMask, newTree), caseLength + 1);
            }
        }
    }

    private int getCaseOfTest(TapPair<Tree, Boolean> oneMask, Tree whereTree) {
        if (whereTree.opCode() == 121) {
            whereTree = whereTree.down(4);
        }
        Tree whereTest = whereTree.down(1);
        Tree maskTree = (Tree)oneMask.first;
        boolean neg = Boolean.TRUE.equals(oneMask.second);
        while (whereTest.opCode() == 139) {
            neg = !neg;
            whereTest = whereTest.down(1);
        }
        if (whereTest.equalsTree(maskTree)) {
            return neg ? 3 : 2;
        }
        return -1;
    }

    private Tree buildWhereTree(TapList<TapPair<Tree, Boolean>> newMask, Tree newTree) {
        Tree doTree = null;
        if (newTree.opCode() == 121) {
            doTree = newTree.cutChild(3);
            newTree = newTree.cutChild(4);
        }
        if (newMask != null) {
            newTree = this.buildWhereTree(newMask.tail, newTree);
            TapPair oneMask = (TapPair)newMask.head;
            Tree testTree = ILUtils.copy((Tree)oneMask.first);
            newTree = ILUtils.build(205, Boolean.TRUE.equals(oneMask.second) ? ILUtils.build(139, testTree) : testTree, ILUtils.build(27, newTree), ILUtils.build(138), ILUtils.copy((Tree)testTree.getAnnotation("namedWhere")));
            testTree.removeAnnotation("namedWhere");
        }
        if (doTree != null) {
            newTree = ILUtils.build(121, ILUtils.build(138), ILUtils.build(138), doTree, newTree);
        }
        return newTree;
    }

    @Override
    public void dump(int indent) throws IOException {
        TapEnv.print("Unit ");
        super.dump(indent);
        TapEnv.print(" Contents:{");
        TapEnv.println();
        TapList<ControlStruct> inBody = this.body;
        while (inBody != null) {
            TapEnv.indent(indent + 2);
            ((ControlStruct)inBody.head).dump(indent + 2);
            TapEnv.println();
            inBody = inBody.tail;
        }
        TapEnv.print("}");
        TapEnv.println();
    }

    @Override
    public String toString() {
        return "UNIT:" + this.controlStructBlock + " @" + Integer.toHexString(this.controlStructBlock.hashCode()) + " INSTRS:" + this.controlStructBlock.instructions + ":(" + this.body + ')';
    }
}

