/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.ir2tree;

import fr.inria.tapenade.ir2tree.ControlStruct;
import fr.inria.tapenade.ir2tree.DeclStruct;
import fr.inria.tapenade.ir2tree.FunctionDeclStruct;
import fr.inria.tapenade.ir2tree.IfThenElseStruct;
import fr.inria.tapenade.ir2tree.InterfaceDeclStruct;
import fr.inria.tapenade.ir2tree.LoopStruct;
import fr.inria.tapenade.ir2tree.NameSpaceStruct;
import fr.inria.tapenade.ir2tree.ParallelControlStruct;
import fr.inria.tapenade.ir2tree.PlainStruct;
import fr.inria.tapenade.ir2tree.SwitchStruct;
import fr.inria.tapenade.ir2tree.TypeDeclStruct;
import fr.inria.tapenade.ir2tree.UnitStruct;
import fr.inria.tapenade.ir2tree.VariableDeclStruct;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.CompositeTypeSpec;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.FunctionTypeSpec;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.InterfaceDecl;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.PositionAndMessage;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeDecl;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public final class TreeGen {
    public static void cleanBeforeGenerate(CallGraph callGraph) {
        if (callGraph != null) {
            TapList<Unit> units = callGraph.units();
            while (units != null) {
                Unit unit = (Unit)units.head;
                if (unit.publicSymbolTable() != null && (unit.isStandard() || unit.isModule())) {
                    TreeGen.cleanBeforeGenerate(unit);
                }
                units = units.tail;
            }
        }
    }

    public static void addHeader(Tree tree, int language, String versionString) {
        Tree oldComments;
        int commentsOperator = 37;
        String preComments = "preComments";
        if (language == 4) {
            commentsOperator = 38;
            preComments = "preCommentsBlock";
        }
        Tree genComments = ILUtils.build(commentsOperator, ILUtils.build(180, "        Generated by TAPENADE     (INRIA, Ecuador team)"), ILUtils.build(180, (language == 4 ? "    " : "  ") + versionString), ILUtils.build(180, ""));
        if (tree == null) {
            tree = ILUtils.build(96, "TODO");
        }
        if ((oldComments = (Tree)tree.getAnnotation(preComments)) != null) {
            genComments = ILUtils.appendComments(genComments, oldComments);
        }
        tree.setAnnotation(preComments, genComments);
    }

    public static boolean generateGlobalDeclarations(CallGraph callGraph, TapList<TapTriplet<Tree, Tree, Integer>> toFutureIncludes, TapList<Tree> fileUserHelpStrings, Tree fileTree, int lang, boolean addTranslationUnitDeclarations) {
        if (lang == 4 || lang == 100) {
            int i = 1;
            i = TreeGen.insertGlobalDeclarationsOfBlock(callGraph, callGraph.cRootSymbolTable().declarationsBlock, toFutureIncludes, fileUserHelpStrings, fileTree, i);
            TapEnv.setRelatedLanguage(4);
            if (addTranslationUnitDeclarations) {
                TapList<SymbolTable> tuSTs = callGraph.getTranslationUnitSymbolTables();
                while (tuSTs != null) {
                    i = TreeGen.insertGlobalDeclarationsOfBlock(callGraph, ((SymbolTable)tuSTs.head).declarationsBlock, toFutureIncludes, fileUserHelpStrings, fileTree, i);
                    if (TapEnv.get().srcUnitsToTraceInTreeGen != null && TapEnv.get().srcUnitsToTraceInTreeGen.head == null) {
                        String fileName = ((SymbolTable)tuSTs.head).containerFileName;
                        if (callGraph == TapEnv.get().origCallGraph()) {
                            fileName = TapEnv.extendStringWithSuffix(fileName, TapEnv.get().preprocessFileSuffix);
                        }
                        TapEnv.printlnOnTrace(15, "@@ Generated declarations of translation unit " + fileName);
                    }
                    tuSTs = tuSTs.tail;
                }
            }
        }
        boolean onlyIncludes = true;
        if (fileTree != null) {
            for (int i = fileTree.length() - 1; i >= 0 && onlyIncludes; --i) {
                if (ILUtils.isNullOrNone(fileTree.down(i)) || fileTree.down(i).opCode() == 101) continue;
                onlyIncludes = false;
            }
        }
        return !onlyIncludes;
    }

    private static void generateForwardDeclarations(TapList<Unit> forwardDeclaredUnits, Block block, TapList<TapTriplet<Tree, Tree, Integer>> toFutureIncludes, Tree fileTree) {
        while (forwardDeclaredUnits != null) {
            Unit unit = (Unit)forwardDeclaredUnits.head;
            if (unit.isC() && unit.publicSymbolTable() != null && unit.getForwardDeclaration() == null) {
                Tree unitTree = TreeGen.generate(unit, true, false, false, toFutureIncludes, new TapList<Object>(null, null));
                if (unitTree != null) {
                    unitTree = unitTree.down(1);
                }
                if (unitTree != null) {
                    int rank = block.findRankToInsert(fileTree, unitTree);
                    if (rank == 0) {
                        rank = 1;
                    }
                    fileTree.addChild(unitTree, rank);
                }
            }
            forwardDeclaredUnits = forwardDeclaredUnits.tail;
        }
    }

    public static Tree generate(Unit unit, boolean forwardDeclaration, boolean isInterface, boolean skipSubUnits, TapList<TapTriplet<Tree, Tree, Integer>> toFutureIncludes, TapList<Tree> fileUserHelpStrings) {
        Block bodyBlock;
        TapEnv.pushRelatedUnit(unit);
        Unit refUnit = unit;
        while (refUnit.origUnit != null && refUnit.origUnit != refUnit) {
            refUnit = refUnit.origUnit;
        }
        boolean traceThisUnit = TapEnv.get().srcUnitsToTraceInTreeGen != null && (TapEnv.get().srcUnitsToTraceInTreeGen.head == null || TapList.contains(TapEnv.get().srcUnitsToTraceInTreeGen, refUnit));
        UnitStruct structTree = null;
        if (unit.isTranslationUnit()) {
            TapEnv.printlnOnTrace(15, "@@ Rebuilding syntactic structure of file " + unit.name());
            TreeGen.checkStructure(unit);
            unit.computeDominatorArrows();
            structTree = TreeGen.structurate(unit, false, traceThisUnit);
        } else if (forwardDeclaration && !unit.isRenamed()) {
            TapEnv.printlnOnTrace(15, "@@ Rebuilding header of procedure " + unit.name());
            structTree = new UnitStruct(unit, false);
            structTree.setTraceThisUnit(traceThisUnit);
        } else if ((unit.isInterface() || isInterface || TapEnv.get().createStub) && !unit.isRenamed() && unit.allBlocks() != null) {
            String sort = "interface";
            if (TapEnv.get().createStub && !unit.isInterface()) {
                sort = "stub";
            }
            TapEnv.printlnOnTrace(15, "@@ Rebuilding syntactic structure of " + sort + " " + unit.name());
            structTree = new UnitStruct(unit, isInterface);
            structTree.setTraceThisUnit(traceThisUnit);
            PlainStruct bodyStruct = new PlainStruct((Block)unit.allBlocks.head);
            bodyStruct.aboveControlStruct = structTree;
            structTree.body = new TapList<PlainStruct>(bodyStruct, null);
        } else if (unit.isClass()) {
            TapEnv.printlnOnTrace(15, "@@ Rebuilding syntactic structure of class " + unit.name());
            structTree = new UnitStruct(unit, false);
            structTree.setTraceThisUnit(traceThisUnit);
            bodyBlock = (Block)unit.allBlocks.head;
            structTree.body = new TapList<PlainStruct>(new PlainStruct(bodyBlock), new TapList<PlainStruct>(new PlainStruct(unit.exitBlock()), null));
        } else if (unit.isModule()) {
            if (!unit.isPredefinedModuleOrTranslationUnit() && unit.publicSymbolTable() != null) {
                TapEnv.printlnOnTrace(15, "@@ Rebuilding syntactic structure of module " + unit.name());
                structTree = new UnitStruct(unit, false);
                structTree.setTraceThisUnit(traceThisUnit);
                if (unit.allBlocks != null) {
                    bodyBlock = (Block)unit.allBlocks.head;
                    structTree.body = new TapList<PlainStruct>(new PlainStruct(bodyBlock), new TapList<PlainStruct>(new PlainStruct(unit.exitBlock()), null));
                }
            }
        } else if (unit.entryBlock() != null && !unit.isRenamed()) {
            TapEnv.printlnOnTrace(15, "@@ Rebuilding syntactic structure of procedure " + unit.name());
            TreeGen.checkStructure(unit);
            unit.computeDominatorArrows();
            structTree = TreeGen.structurate(unit, isInterface, traceThisUnit);
            structTree.findUsedLabels();
        } else if (unit.publicSymbolTable() != null) {
            TapEnv.printlnOnTrace(15, "@@ Rebuilding syntactic structure of dumm-procedure " + unit.name());
            structTree = new UnitStruct(unit, isInterface);
            structTree.setTraceThisUnit(traceThisUnit);
        }
        if (traceThisUnit) {
            try {
                TapEnv.print("TreeGen structure of " + unit + " is:" + System.lineSeparator() + "  ");
                structTree.dump(2);
                TapEnv.println();
            }
            catch (IOException e) {
                TapEnv.printlnOnTrace("IO error while dumping TreeGen structure" + e);
            }
        }
        Tree unitTree = null;
        if (structTree != null && unit.publicSymbolTable() != null) {
            SymbolTable tuSymbolTable;
            boolean addUseDiffSizesHere = false;
            if (fileUserHelpStrings == null) {
                addUseDiffSizesHere = true;
                fileUserHelpStrings = new TapList<Object>(null, null);
            }
            if (!unit.isPackage()) {
                structTree.generateParameterList();
            }
            if (forwardDeclaration) {
                structTree.preGenerateForwardTree();
                structTree.generateForwardTree();
            } else {
                structTree.propagateNaturalNext(null);
                structTree.propagateNaturalFlow();
                structTree.preGenerateTree(null, toFutureIncludes, fileUserHelpStrings, null, skipSubUnits);
                structTree.generateTree(false, toFutureIncludes, fileUserHelpStrings);
                if (unit.entryBlock() != null && !unit.isInterface() && !isInterface) {
                    TreeGen.checkCarry(unit);
                }
            }
            unitTree = structTree.structuredTree;
            if (unit.isTranslationUnit() && unit.isC() && (tuSymbolTable = unit.translationUnitSymbolTable()) != null) {
                TreeGen.generateForwardDeclarations(tuSymbolTable.nonPrivForwardDeclarations, tuSymbolTable.declarationsBlock, toFutureIncludes, unitTree);
                TreeGen.generateForwardDeclarations(tuSymbolTable.privateForwardDeclarations, tuSymbolTable.declarationsBlock, toFutureIncludes, unitTree);
            }
            if (unitTree != null) {
                Tree targetUnitTree;
                if (unit.isInterface() || isInterface) {
                    unitTree.setAnnotation("preComments", null);
                    unitTree.setAnnotation("preCommentsBlock", null);
                }
                if (unit.otherName() != null) {
                    unitTree.setAnnotation("toOtherTags", new TapPair<String, String>(unit.name(), unit.otherName().name()));
                }
                TapList msgs = unit.messages.tail;
                while (msgs != null) {
                    PositionAndMessage msg = (PositionAndMessage)msgs.head;
                    if (msg.position() == -1) {
                        TapEnv.addMessageAnnotation(unitTree, msg.message());
                    }
                    msgs = msgs.tail;
                }
                if (unitTree.opCode() != 27) {
                    unitTree = ILUtils.build(27, unitTree);
                }
                if (unit.userHelp != null && !forwardDeclaration) {
                    while (unit.userHelp.tail != null) {
                        Tree oneHintStringTree;
                        TapPair oneHint = (TapPair)unit.userHelp.tail.head;
                        if (oneHint != null && oneHint.first != null && oneHint.second != null && !TapList.containsTreeEquals(fileUserHelpStrings, oneHintStringTree = ILUtils.build(180, "  Hint: " + (String)oneHint.second + " should be " + (String)oneHint.first))) {
                            fileUserHelpStrings.placdl(oneHintStringTree);
                        }
                        unit.userHelp.tail = unit.userHelp.tail.tail;
                    }
                }
                if (addUseDiffSizesHere) {
                    TreeGen.addUseDiffSizesAndUserHelp(unitTree, fileUserHelpStrings.tail, unit.language());
                }
                if (unit.isFortran() && !unit.isInterface() && !isInterface && (unit.isStandard() || unit.isModule())) {
                    TreeGen.addImplicitNone(unitTree.down(1));
                }
                Tree tree = targetUnitTree = unit.isTranslationUnit() ? unitTree : unitTree.down(1);
                if (unit.lostComments() != null) {
                    TreeGen.insertLostComments(unit, targetUnitTree, unit.language());
                }
                if (unit.fromInclude() != null) {
                    unitTree = null;
                }
                TapEnv.popRelatedUnit();
            }
        }
        if (traceThisUnit) {
            try {
                TapEnv.print("Generated Tree for " + unit + ':');
                if (unitTree == null) {
                    TapEnv.println(" null!");
                } else {
                    TapEnv.println();
                    TapEnv.indent(5);
                    ILUtils.dump(unitTree, 5);
                    TapEnv.println();
                }
                TapEnv.println("fileUserHelpStrings:" + fileUserHelpStrings);
            }
            catch (IOException e) {
                TapEnv.printlnOnTrace("IO error while dumping generated tree:" + e);
            }
        }
        return unitTree;
    }

    public static void addUseDiffSizesAndUserHelp(Tree unitTree, TapList<Tree> unitUserHelpStrings, int language) {
        if (unitTree != null && unitUserHelpStrings != null) {
            Tree includeTree;
            int commentsOperator = 37;
            String postComments = "postComments";
            String diffSizeFileName = "DIFFSIZES";
            if (language == 4) {
                commentsOperator = 38;
                postComments = "postCommentsBlock";
                if (TapEnv.inputLanguage() == 100) {
                    diffSizeFileName = diffSizeFileName + "C";
                }
                includeTree = ILUtils.build(101, "\"" + diffSizeFileName + ".inc\"");
            } else if (language == 1) {
                if (TapEnv.inputLanguage() == 100) {
                    diffSizeFileName = diffSizeFileName + "F";
                }
                includeTree = ILUtils.build(101, diffSizeFileName + ".inc");
            } else {
                includeTree = ILUtils.build(197, ILUtils.build(96, diffSizeFileName), ILUtils.build(166));
            }
            Tree comments = ILUtils.build(commentsOperator, unitUserHelpStrings);
            includeTree.setAnnotation(postComments, comments);
            if (TapEnv.isC(language)) {
                unitTree.addChild(includeTree, 1);
            } else {
                Tree receivingTree = null;
                Tree[] contents = unitTree.children();
                block5: for (int i = 0; i < contents.length && receivingTree == null; ++i) {
                    switch (contents[i].opCode()) {
                        case 159: {
                            receivingTree = contents[i].down(4);
                            continue block5;
                        }
                        case 89: {
                            receivingTree = contents[i].down(6);
                            continue block5;
                        }
                        case 131: {
                            receivingTree = contents[i].down(2);
                            continue block5;
                        }
                    }
                }
                if (receivingTree != null) {
                    int lastUseDeclRank;
                    for (lastUseDeclRank = 1; lastUseDeclRank <= receivingTree.length() && receivingTree.down(lastUseDeclRank).opCode() == 197; ++lastUseDeclRank) {
                    }
                    receivingTree.addChild(includeTree, lastUseDeclRank);
                } else {
                    TapEnv.toolError("Internal error: lost one DIFFSIZE inclusion for " + unitUserHelpStrings);
                }
            }
        }
    }

    public static TapList<TapTriplet<Tree, Tree, Integer>> generateInclude(TapList<TapTriplet<Tree, Tree, Integer>> toFutureIncludes, String versionString) {
        TapList<Object> result = new TapList<Object>(null, null);
        TapList<Object> toResult = result;
        toFutureIncludes = toFutureIncludes.tail;
        Tree curTree = null;
        while (toFutureIncludes != null) {
            TapTriplet curTriplet = (TapTriplet)toFutureIncludes.head;
            Tree curIncludeTree = (Tree)curTriplet.first;
            String curInclude = curIncludeTree.stringValue();
            int lang = (Integer)curTriplet.third;
            if (!TapEnv.relatedLanguageIsC() || !TapEnv.isStdIncludeName(curInclude)) {
                String curDiffInclude = TapEnv.getDiffIncludeName(curInclude);
                boolean addInclude = true;
                if (curDiffInclude != null) {
                    curInclude = curDiffInclude;
                    curIncludeTree = ILUtils.build(101, curDiffInclude);
                    if (((Tree)curTriplet.second).opCode() == 101 && ILUtils.equalsInclude(((Tree)curTriplet.first).stringValue(), (Tree)curTriplet.second)) {
                        addInclude = false;
                    }
                }
                boolean bl = addInclude = addInclude && !ILUtils.equalsInclude(curInclude, (Tree)curTriplet.second);
                if (addInclude) {
                    TapList<Tree> sonsList;
                    if (result.head == null || !curInclude.equals(((Tree)((TapTriplet)result.head).first).stringValue())) {
                        TapList<TapTriplet<Tree, Tree, Integer>> currentResult = TreeGen.findCurrentObjectTriplet(curInclude, toResult);
                        if (currentResult != null) {
                            result = currentResult;
                            curTree = (Tree)((TapTriplet)result.head).second;
                        } else {
                            curTree = ILUtils.build(27);
                            TreeGen.addHeader(curTree, lang, versionString);
                            result = result.placdl(new TapTriplet<Tree, Tree, Integer>(curIncludeTree, curTree, lang));
                        }
                    }
                    TapList<Tree> tapList = sonsList = curTree == null ? null : curTree.childrenList();
                    if (curTriplet.second != null && !TapList.containsTreeEquals(sonsList, (Tree)curTriplet.second)) {
                        if (((Tree)curTriplet.second).opCode() == 27) {
                            Tree[] sons = ((Tree)curTriplet.second).children();
                            int length = sons.length;
                            for (int i = 0; i < length; ++i) {
                                assert (curTree != null);
                                curTree.addChild(ILUtils.copy(sons[i]), curTree.length() + 1);
                            }
                        } else {
                            assert (curTree != null);
                            curTree.addChild(ILUtils.copy((Tree)curTriplet.second), curTree.length() + 1);
                        }
                    }
                }
            }
            toFutureIncludes = toFutureIncludes.tail;
        }
        return toResult.tail;
    }

    private static int insertGlobalDeclarationsOfBlock(CallGraph callGraph, Block block, TapList<TapTriplet<Tree, Tree, Integer>> toFutureIncludes, TapList<Tree> fileUserHelpStrings, Tree fileTree, int rank) {
        if (TapList.length(block.instructions) != 0) {
            TapList<Tree> ltree = TreeGen.generateReverseListOfTree(block, toFutureIncludes, fileUserHelpStrings, false);
            ltree = TapList.reverse(ltree);
            int prevRank = rank - 1;
            while (ltree != null) {
                String curDiffInclude;
                TapList<Tree> includes = TreeGen.findIncludes(fileTree);
                Tree curTree = (Tree)ltree.head;
                if (curTree.opCode() == 101 && (curDiffInclude = TapEnv.getDiffIncludeName(curTree.stringValue())) != null && callGraph != TapEnv.get().origCallGraph()) {
                    curTree = ILUtils.build(101, TapEnv.stripPath(curDiffInclude));
                }
                if (!(TapList.containsTreeEquals(includes, curTree) && curTree.opCode() == 101 || ILUtils.isAUnitPlaceHolder(curTree))) {
                    int rankToInsert = block.findRankToInsert(fileTree, curTree);
                    if (rankToInsert == 0) {
                        rankToInsert = rank;
                    }
                    if (prevRank != 0) {
                        rankToInsert = Math.max(prevRank + 1, rankToInsert);
                    }
                    fileTree.addChild(ILUtils.copy(curTree), rankToInsert);
                    prevRank = rankToInsert;
                    ++rank;
                }
                ltree = ltree.tail;
            }
        }
        if (TapEnv.get().srcUnitsToTraceInTreeGen != null) {
            try {
                TapEnv.print("Generated global declarations of block " + block + "(@" + Integer.toHexString(block.hashCode()) + ") :");
                if (fileTree == null) {
                    TapEnv.print(" null!");
                    TapEnv.println();
                } else {
                    TapEnv.println();
                    TapEnv.indent(5);
                    ILUtils.dump(fileTree, 5);
                    TapEnv.println();
                }
            }
            catch (IOException e) {
                TapEnv.printlnOnTrace("IO error while dumping generated tree " + e);
            }
        }
        return rank;
    }

    protected static TapList<Tree> generateReverseListOfTree(Block block, TapList<TapTriplet<Tree, Tree, Integer>> toFutureIncludes, TapList<Tree> fileUserHelpStrings, boolean addOnlyPublicDeclForInterface) {
        TapList<Tree> result = null;
        TapList<Instruction> listInst = block.instructions;
        TapList<Tree> listInclude = null;
        boolean addInstruction = true;
        TapList<Object> toIncludesBeingBuilt = new TapList<Object>(null, null);
        while (listInst != null) {
            Instruction instr = (Instruction)listInst.head;
            if (ILUtils.isAUnitPlaceHolder(instr.tree)) {
                Tree unitTree;
                if (block.symbolTable != null && block.symbolTable.language() == 5 && (unitTree = TreeGen.generate((Unit)instr.tree.getAnnotation("Unit"), false, false, false, toFutureIncludes, TapEnv.isC(TapEnv.relatedLanguage()) ? fileUserHelpStrings : null)) != null) {
                    Tree[] newTrees;
                    for (Tree newTree : newTrees = unitTree.children()) {
                        result = new TapList<Tree>(newTree, result);
                    }
                }
            } else {
                if (addOnlyPublicDeclForInterface) {
                    TapList<SymbolDecl> symbDecls = instr.declaredSymbolDecls(block.unit().publicSymbolTable(), null);
                    boolean bl = addInstruction = symbDecls != null;
                }
                if (addInstruction) {
                    if (instr.fromInclude() == null || instr.fromInclude().fromInclude() == null) {
                        if (!(TapEnv.get().expandAllIncludeFile && !instr.isInStdCInclude() || instr.fromInclude() == null || instr.fromInclude().tree == null || instr.fromInclude().tree.stringValue().isEmpty())) {
                            if (!(TapList.containsTreeEquals(listInclude, instr.fromInclude().tree) || instr.tree.opCode() == 192 && instr.tree.down(1).opCode() == 96 && instr.tree.down(1).stringValue() == null)) {
                                result = new TapList<Tree>(instr.fromInclude().tree, result);
                                listInclude = new TapList<Tree>(instr.fromInclude().tree, listInclude);
                            }
                            toFutureIncludes = toFutureIncludes.placdl(new TapTriplet<Tree, Tree, Integer>(instr.fromInclude().tree, instr.copyTreePlusComments(), TapEnv.relatedLanguage()));
                        } else if (!(instr.isInStdCInclude() || instr.tree.opCode() == 192 && instr.tree.down(1).opCode() == 96 && instr.tree.down(1).stringValue() == null || instr.tree.opCode() == 101 && instr.tree.stringValue().isEmpty())) {
                            result = new TapList<Tree>(instr.copyTreePlusComments(), result);
                        }
                    } else if (!instr.isInStdCInclude()) {
                        if (TapEnv.get().expandAllIncludeFile) {
                            result = new TapList<Tree>(instr.copyTreePlusComments(), result);
                        } else {
                            TreeGen.insertInstructionWatchingIncludes(instr, null, false, toIncludesBeingBuilt, toFutureIncludes);
                        }
                    }
                }
            }
            listInst = listInst.tail;
        }
        TreeGen.insertInstructionWatchingIncludes(null, null, false, toIncludesBeingBuilt, toFutureIncludes);
        return result;
    }

    private static TapList<Tree> findIncludes(Tree fileTree) {
        TapList<Tree> result = null;
        if (fileTree != null) {
            for (int i = fileTree.length(); i >= 1; --i) {
                if (fileTree.down(i).opCode() != 101) continue;
                result = new TapList<Tree>(fileTree.down(i), result);
            }
        }
        return result;
    }

    public static TapList<Instruction> insertInstructionWatchingIncludes(Instruction instruction, TapList<Instruction> tlNewInsts, boolean onSourceUnit, TapList<TapPair<Instruction, TapList<Instruction>>> toIncludesBeingBuilt, TapList<TapTriplet<Tree, Tree, Integer>> toFutureIncludes) {
        boolean includeStarts;
        Instruction newInclude = instruction == null ? null : instruction.fromInclude();
        boolean bl = includeStarts = instruction != null && instruction.tree.opCode() == 101;
        if (includeStarts && newInclude != null && TapEnv.sameFinalIncludeFile(instruction.tree.stringValue(), newInclude.tree.stringValue())) {
            newInclude = newInclude.fromInclude();
        }
        if (newInclude != null && !TreeGen.containsOpenedInclude(toIncludesBeingBuilt.tail, newInclude.tree.stringValue())) {
            TreeGen.insertInstructionWatchingIncludes(newInclude, tlNewInsts, onSourceUnit, toIncludesBeingBuilt, toFutureIncludes);
        }
        while (!(toIncludesBeingBuilt.tail == null || newInclude != null && TapEnv.sameFinalIncludeFile(((Instruction)((TapPair)toIncludesBeingBuilt.tail.head).first).tree.stringValue(), newInclude.tree.stringValue()))) {
            TreeGen.emitIncludeFileContents((TapPair)toIncludesBeingBuilt.tail.head, toFutureIncludes);
            Instruction addedInstr = null;
            String includedName = ((Instruction)((TapPair)toIncludesBeingBuilt.tail.head).first).tree.stringValue();
            addedInstr = (Instruction)((TapPair)toIncludesBeingBuilt.tail.head).first;
            if (!onSourceUnit) {
                addedInstr = addedInstr.copy(null);
                String diffIncludeName = TapEnv.getDiffIncludeName(includedName);
                if (diffIncludeName != null) {
                    addedInstr.tree.setValue(diffIncludeName);
                }
            }
            toIncludesBeingBuilt.tail = toIncludesBeingBuilt.tail.tail;
            if (addedInstr == null) continue;
            if (toIncludesBeingBuilt.tail == null) {
                tlNewInsts = tlNewInsts.placdl(addedInstr);
                continue;
            }
            ((TapPair)toIncludesBeingBuilt.tail.head).second = TapList.addLast((TapList)((TapPair)toIncludesBeingBuilt.tail.head).second, addedInstr);
        }
        if (includeStarts) {
            toIncludesBeingBuilt.tail = new TapList<TapPair<Instruction, Object>>(new TapPair<Instruction, Object>(instruction, null), toIncludesBeingBuilt.tail);
        } else if (instruction != null) {
            if (newInclude == null) {
                tlNewInsts = tlNewInsts.placdl(instruction);
            } else {
                ((TapPair)toIncludesBeingBuilt.tail.head).second = TapList.addLast((TapList)((TapPair)toIncludesBeingBuilt.tail.head).second, instruction);
            }
        }
        return tlNewInsts;
    }

    private static boolean containsOpenedInclude(TapList<TapPair<Instruction, TapList<Instruction>>> includesBeingBuilt, String requiredContext) {
        boolean found = false;
        while (!found && includesBeingBuilt != null) {
            found = TapEnv.sameFinalIncludeFile(requiredContext, ((Instruction)((TapPair)includesBeingBuilt.head).first).tree.stringValue());
            includesBeingBuilt = includesBeingBuilt.tail;
        }
        return found;
    }

    private static void emitIncludeFileContents(TapPair<Instruction, TapList<Instruction>> includeAndContents, TapList<TapTriplet<Tree, Tree, Integer>> toFutureIncludes) {
        TapTriplet found = null;
        Tree newIncludeTree = ((Instruction)includeAndContents.first).tree;
        while (found == null && toFutureIncludes.tail != null) {
            if (TapEnv.sameFinalIncludeFile(((Tree)((TapTriplet)toFutureIncludes.tail.head).first).stringValue(), newIncludeTree.stringValue())) {
                found = (TapTriplet)toFutureIncludes.tail.head;
            }
            toFutureIncludes = toFutureIncludes.tail;
        }
        if (found == null) {
            int lang = TapEnv.outputLanguage() != -1 ? TapEnv.outputLanguage() : TapEnv.relatedLanguage();
            found = new TapTriplet(newIncludeTree, null, lang);
            toFutureIncludes.tail = new TapList<TapTriplet>(found, toFutureIncludes.tail);
        }
        if (includeAndContents.second != null) {
            TapList<Object> hdContentsList;
            TapList newIncludeContentsList = (TapList)includeAndContents.second;
            TapList<Object> tlContentsList = hdContentsList = new TapList<Object>(null, null);
            while (newIncludeContentsList != null) {
                tlContentsList = tlContentsList.placdl(((Instruction)newIncludeContentsList.head).copyTreePlusComments());
                newIncludeContentsList = newIncludeContentsList.tail;
            }
            found.second = ILUtils.isNullOrNoneOrEmptyList((Tree)found.second) ? ILUtils.build(27, hdContentsList.tail) : ILUtils.build(27, TreeGen.fuseSameIncludes(((Tree)found.second).childrenList(), hdContentsList.tail, (Tree)found.first));
        }
    }

    private static TapList<Tree> fuseSameIncludes(TapList<Tree> oldContents, TapList<Tree> newContents, Tree newIncludeTree) {
        TapList<Object> hdFused;
        TapList<Object> tlFused = hdFused = new TapList<Object>(null, null);
        int nbSkips = 0;
        while (oldContents != null || newContents != null) {
            Tree newTree;
            Tree oldTree = oldContents == null ? null : (Tree)oldContents.head;
            Tree tree = newTree = newContents == null ? null : (Tree)newContents.head;
            if (oldTree != null && newTree != null && TreeGen.sameTreesInInclude(oldTree, newTree)) {
                tlFused = tlFused.placdl(TreeGen.keepComments(newTree, oldTree));
                oldContents = oldContents.tail;
                newContents = newContents.tail;
                continue;
            }
            if (newTree != null && (nbSkips = TreeGen.containsSameTreeInInclude(newContents.tail, oldTree)) >= 0) {
                while (nbSkips >= 0) {
                    tlFused = tlFused.placdl(newTree);
                    newContents = newContents.tail;
                    --nbSkips;
                    newTree = newContents == null ? null : (Tree)newContents.head;
                }
                if (oldTree == null) continue;
                tlFused = tlFused.placdl(TreeGen.keepComments(oldTree, newTree));
                newContents = newContents.tail;
                oldContents = oldContents.tail;
                continue;
            }
            if (oldTree != null && (nbSkips = TreeGen.containsSameTreeInInclude(oldContents.tail, newTree)) >= 0) {
                while (nbSkips >= 0) {
                    tlFused = tlFused.placdl(oldTree);
                    oldContents = oldContents.tail;
                    --nbSkips;
                    oldTree = oldContents == null ? null : (Tree)oldContents.head;
                }
                if (newTree == null) continue;
                tlFused = tlFused.placdl(TreeGen.keepComments(newTree, oldTree));
                oldContents = oldContents.tail;
                newContents = newContents.tail;
                continue;
            }
            if (newTree != null && TreeGen.containsSameTreeInInclude(hdFused.tail, newTree) >= 0) {
                newContents = newContents.tail;
                continue;
            }
            System.out.println("INCLUDE FILE FUSION DOUBTFUL FOR FUTURE " + newIncludeTree + " :");
            System.out.println("  OLD:" + oldContents);
            System.out.println("  NEW:" + newContents);
            tlFused = tlFused.placdl(oldTree);
            tlFused = tlFused.placdl(newTree);
            oldContents = oldContents.tail;
            newContents = newContents.tail;
        }
        return hdFused.tail;
    }

    private static int containsSameTreeInInclude(TapList<Tree> listTrees, Tree tree) {
        if (tree == null) {
            return TapList.length(listTrees);
        }
        int contains = -1;
        int skipped = 0;
        while (contains == -1 && listTrees != null) {
            if (TreeGen.sameTreesInInclude((Tree)listTrees.head, tree)) {
                contains = skipped;
            }
            listTrees = listTrees.tail;
            ++skipped;
        }
        return contains;
    }

    private static boolean sameTreesInInclude(Tree oldTree, Tree newTree) {
        return oldTree.equalsTree(newTree) || oldTree.opCode() == 101 && newTree.opCode() == 101 && TreeGen.probablySameIncludeFiles(oldTree.stringValue(), newTree.stringValue());
    }

    private static Tree keepComments(Tree refTree, Tree otherTree) {
        Tree otherComment = (Tree)otherTree.getAnnotation("preComments");
        if (otherComment != null && refTree.getAnnotation("preComments") == null) {
            refTree.setAnnotation("preComments", otherComment);
        }
        if ((otherComment = (Tree)otherTree.getAnnotation("preCommentsBlock")) != null && refTree.getAnnotation("preCommentsBlock") == null) {
            refTree.setAnnotation("preCommentsBlock", otherComment);
        }
        if ((otherComment = (Tree)otherTree.getAnnotation("postComments")) != null && refTree.getAnnotation("postComments") == null) {
            refTree.setAnnotation("postComments", otherComment);
        }
        if ((otherComment = (Tree)otherTree.getAnnotation("postCommentsBlock")) != null && refTree.getAnnotation("postCommentsBlock") == null) {
            refTree.setAnnotation("postCommentsBlock", otherComment);
        }
        return refTree;
    }

    private static boolean probablySameIncludeFiles(String oldFile, String newFile) {
        if (oldFile.startsWith("\"")) {
            oldFile = oldFile.substring(1, oldFile.length() - 1);
        }
        if (newFile.startsWith("\"")) {
            newFile = newFile.substring(1, newFile.length() - 1);
        }
        return newFile.endsWith(oldFile) || oldFile.endsWith(newFile);
    }

    private static void checkStructure(Unit unit) {
        TapList<Block> inAllBlocks = unit.allBlocks();
        while (inAllBlocks != null) {
            Block block = (Block)inAllBlocks.head;
            if (block.instructions == null && (block.flow() == null || block.flow().tail != null)) {
                TapEnv.toolWarning(-1, "(Tree regeneration) Wrong flow graph structure after block " + block);
            }
            inAllBlocks = inAllBlocks.tail;
        }
    }

    private static UnitStruct structurate(Unit unit, boolean isInterface, boolean traceThisUnit) {
        UnitStruct unitStruct = new UnitStruct(unit, isInterface);
        unitStruct.setTraceThisUnit(traceThisUnit);
        TapList<Block> inAllBlocks = unit.allBlocks();
        while (inAllBlocks != null) {
            Block block = (Block)inAllBlocks.head;
            TreeGen.insertInControlStruct(block, unit, unitStruct);
            inAllBlocks = inAllBlocks.tail;
        }
        TreeGen.insertInControlStruct(unit.exitBlock(), unit, unitStruct);
        unitStruct.insertLetStructure();
        unitStruct.reorderBody();
        return unitStruct;
    }

    private static ControlStruct insertInControlStruct(Block block, Unit unit, UnitStruct unitStruct) {
        ControlStruct result = block.getControlStruct();
        if (result == null) {
            ControlStruct bstOrigin;
            BoolVector dom = block.getDominatorArrows();
            int rank = TreeGen.makTrueRankWithEnclosingScope(dom, unit.nbArrows, block, unit);
            FGArrow arrow = null;
            if (rank <= 0 || unit.isStandard() && block.isOutsideFlow()) {
                bstOrigin = unitStruct;
            } else {
                arrow = unit.getArrow(rank);
                if (arrow != null) {
                    Block origin = arrow.origin;
                    bstOrigin = TreeGen.insertInControlStruct(origin, unit, unitStruct);
                } else {
                    bstOrigin = unitStruct;
                }
            }
            result = TreeGen.createControlStruct(block);
            block.setControlStruct(result);
            result.aboveControlStruct = bstOrigin;
            ((ControlStruct)bstOrigin).addControlStruct(result, arrow);
        }
        return result;
    }

    private static int makTrueRankWithEnclosingScope(BoolVector dominatorRanks, int nbRanks, Block block, Unit unit) {
        int found = -1;
        for (int rank = nbRanks - 1; found == -1 && rank >= 0; --rank) {
            if (!dominatorRanks.get(rank)) continue;
            FGArrow arrow = unit.getArrow(rank);
            if (!block.symbolTable.nestedIn(arrow.origin.symbolTable)) continue;
            found = rank;
        }
        return found;
    }

    private static ControlStruct createControlStruct(Block block) {
        boolean isAWhere;
        boolean bl = isAWhere = block.lastTest() == 205 && block.lastInstr().tree.down(2).opCode() == 138;
        ControlStruct result = isAWhere || block.isAnIf() ? new IfThenElseStruct(block) : (block.isALoop() ? new LoopStruct(block) : (block.lastTest() == 184 ? new SwitchStruct(block) : (block.isANameSpace() ? new NameSpaceStruct(block) : (block.isParallelController() ? new ParallelControlStruct(block) : new PlainStruct(block)))));
        return result;
    }

    private static void cleanBeforeGenerate(Unit unit) {
        TapList<Block> inAllBlocks = unit.allBlocks;
        if (unit.publicSymbolTable() != null) {
            inAllBlocks = TapList.addUnlessPresent(inAllBlocks, unit.publicSymbolTable().declarationsBlock);
        }
        if (unit.privateSymbolTable() != null) {
            inAllBlocks = TapList.addUnlessPresent(inAllBlocks, unit.privateSymbolTable().declarationsBlock);
        }
        while (inAllBlocks != null) {
            Block block = (Block)inAllBlocks.head;
            SymbolTable symbolTable = block.symbolTable;
            TapList<Instruction> instructions = block.instructions;
            while (instructions != null) {
                Instruction instruction = (Instruction)instructions.head;
                if (unit.language() == 2 || unit.language() == 3 || unit.hasArrayNotation()) {
                    boolean isAWhere;
                    boolean bl = isAWhere = instruction.tree.opCode() == 205;
                    if (!instruction.isADeclaration() && instruction.tree.opCode() != 51) {
                        instruction.tree = TreeGen.changeVectorIfsIntoWheres(instruction.tree, symbolTable);
                    }
                    if (!isAWhere) {
                        instruction.tree = TreeGen.changeToFortranStylePointers(instruction.tree, symbolTable, null);
                    }
                }
                if (unit.language() == 4) {
                    TreeGen.reinstallMPIdefined(instruction.tree, null, 0);
                }
                instructions = instructions.tail;
            }
            inAllBlocks = inAllBlocks.tail;
        }
    }

    private static void reinstallMPIdefined(Tree tree, Tree parent, int rank) {
        if (tree != null) {
            if (!tree.isAtom()) {
                Tree[] subTrees = tree.children();
                for (int i = subTrees.length - 1; i >= 0; --i) {
                    TreeGen.reinstallMPIdefined(subTrees[i], tree, i + 1);
                }
            }
            if (parent != null) {
                Tree newTree = null;
                if (tree.opCode() == 32 && tree.down(1) != null && tree.down(2) != null) {
                    if (tree.down(1).opCode() == 96 && "MPI_Comm".equals(ILUtils.getIdentString(tree.down(1)))) {
                        if (tree.down(2).opCode() == 20 && "0x44000000".equals(tree.down(2).stringValue())) {
                            newTree = ILUtils.build(96, "MPI_COMM_WORLD");
                        }
                    } else if (tree.down(1).opCode() == 96 && "MPI_Datatype".equals(ILUtils.getIdentString(tree.down(1)))) {
                        if (tree.down(2).opCode() == 20 && "0x4c00080b".equals(tree.down(2).stringValue())) {
                            newTree = ILUtils.build(96, "MPI_DOUBLE");
                        } else if (tree.down(2).opCode() == 103 && 1275069468 == tree.down(2).intValue()) {
                            newTree = ILUtils.build(96, "MPI_REAL");
                        }
                    } else if (tree.down(1).opCode() == 154 && tree.down(1).down(1) != null && tree.down(1).down(1).opCode() == 96 && "MPI_Status".equals(ILUtils.getIdentString(tree.down(1).down(1)))) {
                        if (tree.down(2).opCode() == 103 && tree.down(2).intValue() == 1) {
                            newTree = ILUtils.build(96, "MPI_STATUS_IGNORE");
                        }
                    } else if (tree.down(1).opCode() == 96 && "MPI_Op".equals(ILUtils.getIdentString(tree.down(1))) && tree.down(2).opCode() == 20 && "0x58000003".equals(tree.down(2).stringValue())) {
                        newTree = ILUtils.build(96, "MPI_SUM");
                    }
                }
                if (newTree != null) {
                    parent.setChild(newTree, rank);
                }
            }
        }
    }

    private static Tree changeVectorIfsIntoWheres(Tree tree, SymbolTable symbolTable) {
        WrapperTypeSpec testTypeSpec;
        Tree result = tree;
        if (!tree.isAtom()) {
            Tree[] subTrees = tree.children();
            for (int i = subTrees.length - 1; i >= 0; --i) {
                Tree oldSubTree = subTrees[i];
                Tree newSubTree = TreeGen.changeVectorIfsIntoWheres(oldSubTree, symbolTable);
                if (newSubTree == oldSubTree) continue;
                tree.cutChild(i + 1);
                tree.setChild(newSubTree, i + 1);
            }
        }
        if (tree.opCode() == 98 && (testTypeSpec = symbolTable.typeOf(tree.down(1))) != null && (TypeSpec.isA(testTypeSpec, 2) || TypeSpec.isA(testTypeSpec, 6) && TypeSpec.isA(((PointerTypeSpec)testTypeSpec.wrappedType).destinationType, 2))) {
            result = ILUtils.build(205, TreeGen.changeVectorIfsIntoWheres(tree.cutChild(1), symbolTable), TreeGen.changeVectorIfsIntoWheres(tree.cutChild(2), symbolTable), TreeGen.changeVectorIfsIntoWheres(tree.cutChild(3), symbolTable), ILUtils.build(138));
            result.setAnnotation("notemptywhere", new ToBool(true));
        }
        return result;
    }

    private static Tree changeToFortranStylePointers(Tree tree, SymbolTable symbolTable, CompositeTypeSpec compositeType) {
        if (tree.opCode() == 14) {
            boolean isNullCall = false;
            WrapperTypeSpec lType = compositeType != null ? compositeType.namedFieldType(ILUtils.getIdentString(tree.down(1))) : symbolTable.typeOf(tree.down(1));
            if (lType == null) {
                boolean bl = isNullCall = tree.down(2).opCode() == 31 && ILUtils.getCalledName(tree.down(2)).opCode() == 96 && ILUtils.getCalledNameString(tree.down(2)).toLowerCase().equals("null");
            }
            if (WrapperTypeSpec.isPointerOrArrayOfPointer(lType) || isNullCall) {
                Tree resultTree = ILUtils.build(152, tree.cutChild(1), tree.cutChild(2));
                resultTree.copyAnnotations(tree);
                tree = resultTree;
            }
        }
        CompositeTypeSpec newCompositeType = compositeType;
        if ((tree.opCode() == 161 || tree.opCode() == 195) && tree.getAnnotation("WrapperTypeSpec") != null) {
            newCompositeType = (CompositeTypeSpec)((WrapperTypeSpec)tree.getAnnotation((String)"WrapperTypeSpec")).wrappedType;
        }
        if (tree.length() > 0) {
            int i;
            Tree[] subTrees = tree.children();
            Tree[] newSubTrees = new Tree[subTrees.length];
            boolean subTreeChanged = false;
            for (i = subTrees.length - 1; i >= 0; --i) {
                Tree annot;
                newSubTrees[i] = subTrees[i];
                if (newSubTrees[i] == null) continue;
                if (newSubTrees[i].opCode() == 4 && (annot = (Tree)newSubTrees[i].getAnnotation("sourcetree")) != null && annot.opCode() == 31 && annot.down(2).opCode() == 96 && annot.down(2).stringValue().equals("c_loc")) {
                    tree.setChild(ILUtils.copy(annot), i + 1);
                    newSubTrees[i] = tree.down(i + 1);
                }
                while (newSubTrees[i].opCode() == 151 || newSubTrees[i].opCode() == 4) {
                    ILUtils.incorporateAnnotations(newSubTrees[i].down(1), newSubTrees[i]);
                    newSubTrees[i] = newSubTrees[i].cutChild(1);
                }
                newSubTrees[i] = TreeGen.changeToFortranStylePointers(newSubTrees[i], symbolTable, newCompositeType);
                if (newSubTrees[i] == subTrees[i]) continue;
                subTreeChanged = true;
            }
            if (subTreeChanged) {
                for (i = subTrees.length - 1; i >= 0; --i) {
                    if (newSubTrees[i] != subTrees[i]) continue;
                    tree.cutChild(i + 1);
                }
                Tree newTree = ILUtils.build(tree.opCode(), newSubTrees);
                newTree.copyAnnotations(tree);
                tree = newTree;
            }
        }
        return tree;
    }

    private static void addImplicitNone(Tree tree) {
        Tree receivingTree = null;
        switch (tree.opCode()) {
            case 159: {
                receivingTree = tree.down(4);
                break;
            }
            case 89: {
                receivingTree = tree.down(6);
                break;
            }
            case 131: {
                receivingTree = tree.down(2);
                break;
            }
        }
        Tree implicitTree = ILUtils.build(100);
        if (receivingTree != null) {
            int lastUseDeclRank;
            for (lastUseDeclRank = 1; lastUseDeclRank <= receivingTree.length() && receivingTree.down((int)lastUseDeclRank).operator().code == 197; ++lastUseDeclRank) {
            }
            receivingTree.addChild(implicitTree, lastUseDeclRank);
        }
    }

    private static void insertLostComments(Unit unit, Tree tree, int outputLanguage) {
        int commentsOperator = 37;
        String postComments = "postComments";
        if (outputLanguage == 4) {
            commentsOperator = 38;
            postComments = "postCommentsBlock";
        }
        Tree receivingTree = null;
        switch (tree.opCode()) {
            case 159: {
                receivingTree = tree.down(4);
                break;
            }
            case 89: {
                receivingTree = tree.down(6);
                break;
            }
            case 131: {
                receivingTree = tree.down(2);
                break;
            }
        }
        if (receivingTree == null) {
            receivingTree = tree;
        } else {
            int lastUseDeclRank;
            for (lastUseDeclRank = 1; lastUseDeclRank <= receivingTree.length() && receivingTree.down((int)lastUseDeclRank).operator().code == 197; ++lastUseDeclRank) {
            }
            if (receivingTree.down(lastUseDeclRank) != null) {
                receivingTree = receivingTree.down(lastUseDeclRank);
            } else if (lastUseDeclRank != 1) {
                receivingTree = receivingTree.down(lastUseDeclRank - 1);
            }
        }
        Tree genComments = ILUtils.build(commentsOperator);
        while (unit.lostComments() != null) {
            genComments = ILUtils.appendComments(genComments, ((Tree)unit.lostComments().head).copy());
            unit.setLostComments(unit.lostComments().tail);
        }
        if (receivingTree.getAnnotation(postComments) != null) {
            Tree allPostComments = ILUtils.appendComments((Tree)receivingTree.getAnnotation(postComments), genComments);
            receivingTree.setAnnotation(postComments, allPostComments);
        } else {
            receivingTree.setAnnotation(postComments, genComments);
        }
    }

    private static void checkCarry(Unit unit) {
        TapList<Block> allBlocks = new TapList<Block>(unit.entryBlock(), unit.allBlocks);
        while (allBlocks != null) {
            TapList<FGArrow> arrows = ((Block)allBlocks.head).flow();
            while (arrows != null) {
                FGArrow arrow = (FGArrow)arrows.head;
                if (arrow.carry != null) {
                    TapEnv.toolWarning(-1, "(Tree regeneration) Forgotten arrow carry of " + arrow + " " + arrow.carry);
                }
                arrows = arrows.tail;
            }
            allBlocks = allBlocks.tail;
        }
    }

    protected static TapList<TapPair<Tree, SymbolDecl>> generateMissingDeclarations(Unit forUnit, SymbolTable symbolTable, boolean globalDecls, boolean inPublicSymbolTable, Block insertInBlock, boolean traceThisUnit) {
        TapList<Object> toResult;
        SymbolTable paramSymbolTableAbove;
        TapList<SymbolDecl> externalTypes = symbolTable.getAllTypeDecls();
        TapList<DeclStruct> declStructs = null;
        for (paramSymbolTableAbove = symbolTable.basisSymbolTable(); paramSymbolTableAbove != null && !paramSymbolTableAbove.isFormalParamsLevel(); paramSymbolTableAbove = paramSymbolTableAbove.basisSymbolTable()) {
        }
        TapList<SymbolDecl> symbolDecls = symbolTable.getAllTopSymbolDecls();
        TapList<Unit> interfaceDecls = TreeGen.listOfInterfaceDecl(symbolDecls);
        while (symbolDecls != null) {
            boolean mustBeDeclaredHere;
            boolean isReturnTypeDecl = false;
            SymbolDecl symbolDecl = (SymbolDecl)symbolDecls.head;
            boolean variableAlreadyDeclared = false;
            if (symbolDecl.isA(1) || symbolDecl.isA(5)) {
                FunctionDecl declaredAsFunction;
                TapList<FunctionDecl> declaredAsFunctions = symbolTable.getFunctionDecl(symbolDecl.symbol, null, null, false);
                FunctionDecl functionDecl = declaredAsFunction = declaredAsFunctions == null ? null : (FunctionDecl)declaredAsFunctions.head;
                if (declaredAsFunction != null && forUnit != null && (declaredAsFunction.unit() == forUnit || TapEnv.associationByAddress() && declaredAsFunction.unit() == forUnit.origUnit)) {
                    isReturnTypeDecl = true;
                } else {
                    boolean bl = variableAlreadyDeclared = symbolDecl.hasMainInstruction() || symbolDecl.hasOtherInstruction();
                }
            }
            if (!variableAlreadyDeclared && TapEnv.relatedLanguage() == 4 && symbolDecl instanceof VariableDecl) {
                boolean bl = variableAlreadyDeclared = inPublicSymbolTable && ((VariableDecl)symbolDecl).formalArgRank >= 0;
            }
            if (!variableAlreadyDeclared && TapEnv.associationByAddress() && !symbolDecl.isA(4) && isReturnTypeDecl) {
                variableAlreadyDeclared = symbolDecl.isActiveSymbolDecl();
            }
            if (!variableAlreadyDeclared && (symbolDecl.hasInterfaceInstruction() || symbolDecl.isA(16))) {
                variableAlreadyDeclared = true;
            }
            if (!variableAlreadyDeclared && symbolDecl.isA(3) && forUnit != null) {
                variableAlreadyDeclared = symbolDecl.hasInstructionWithRootOperator(106, null);
            }
            Instruction instr = null;
            if (symbolTable.declarationsBlock != null) {
                instr = symbolTable.declarationsBlock.getOperatorDeclarationInstruction(symbolDecl, 199, null);
            }
            if (instr == null && symbolTable.isFormalParamsLevel() && forUnit != null && forUnit.privateSymbolTable() != null) {
                instr = forUnit.privateSymbolTable().declarationsBlock.getOperatorDeclarationInstruction(symbolDecl, 199, null);
            }
            if (instr != null && !variableAlreadyDeclared) {
                if (symbolDecl.isA(3)) {
                    assert (symbolDecl instanceof FunctionDecl);
                    if (((FunctionDecl)symbolDecl).unit() == null) {
                        TapEnv.toolWarning(-1, "null unit for function declaration " + symbolDecl);
                    } else {
                        variableAlreadyDeclared = symbolDecl.isExternal() || ((FunctionDecl)symbolDecl).isVarFunction() ? symbolDecl.isExternalDeclared(instr) || symbolDecl.isIntrinsicDeclared(instr) || symbolDecl.hasInstructionWithRootOperator(74, null) || symbolDecl.hasInstructionWithRootOperator(108, null) : true;
                    }
                } else {
                    variableAlreadyDeclared = true;
                }
            }
            boolean bl = mustBeDeclaredHere = !(!symbolDecl.isATrueSymbolDecl || isReturnTypeDecl || variableAlreadyDeclared || symbolDecl.isSystemPredefined() || symbolDecl.isConsideredRemoved || symbolDecl.isA(3) && ((FunctionDecl)symbolDecl).isIntrinsic() && symbolDecl.symbol.equals("null") || symbolDecl.isA(3) && (globalDecls || symbolTable.unit != null && symbolTable.unit.isC()));
            if (mustBeDeclaredHere) {
                boolean addDecl = true;
                boolean doAddDecl = false;
                if (symbolDecl.isA(3) && ((FunctionDecl)symbolDecl).isInterface()) {
                    boolean bl2 = addDecl = !TapList.contains(interfaceDecls, ((FunctionDecl)symbolDecl).unit());
                    if (addDecl) {
                        doAddDecl = true;
                    }
                }
                if (addDecl) {
                    Unit subUnit;
                    if (symbolDecl.isA(3) && ((FunctionDecl)symbolDecl).isModule() || paramSymbolTableAbove == null || !symbolDecl.isA(3) || paramSymbolTableAbove.getTopFunctionDecl(symbolDecl.symbol, null, null, false) == null) {
                        if (symbolDecl.isA(3) && ((FunctionDecl)symbolDecl).isModule()) {
                            addDecl = false;
                        }
                        if (symbolDecl.isA(3) && ((FunctionDecl)symbolDecl).isIntrinsic()) {
                            if (forUnit.isModule()) {
                                addDecl = false;
                            } else {
                                boolean bl3 = addDecl = !TapEnv.get().createStub && !TreeGen.duplicatedIntrinsic((FunctionDecl)symbolDecl, declStructs, symbolTable, insertInBlock);
                            }
                        }
                        if (addDecl) {
                            doAddDecl = true;
                        }
                    } else if (symbolDecl.isA(3) && (subUnit = ((FunctionDecl)symbolDecl).unit()) != null && subUnit.isInterface() && symbolTable.isFormalParamsLevel()) {
                        assert (symbolDecl instanceof FunctionDecl);
                        if (traceThisUnit || forUnit == null && TapEnv.get().srcUnitsToTraceInTreeGen != null) {
                            TapEnv.printlnOnTrace("  !! Declaration instruction Missing for " + symbolDecl);
                        }
                        declStructs = new TapList<DeclStruct>(new FunctionDeclStruct((FunctionDecl)symbolDecl), declStructs);
                    }
                    if (symbolDecl.isA(3)) {
                        Instruction interfaceInstr = insertInBlock.getOperatorDeclarationInstruction(symbolDecl, 106, symbolTable);
                        if (interfaceInstr == null && forUnit != null && forUnit.privateSymbolTable() != null) {
                            Block inBlock = forUnit.privateSymbolTable().declarationsBlock;
                            interfaceInstr = inBlock.getOperatorDeclarationInstruction(symbolDecl, 106, symbolTable);
                        }
                        if (interfaceInstr != null) {
                            doAddDecl = false;
                        }
                    }
                }
                if (symbolDecl.isA(4)) {
                    if (symbolDecl.hasInstructionWithRootOperator(192, null) || symbolDecl.hasInstructionWithRootOperator(2, "bind")) {
                        doAddDecl = false;
                    }
                    if (TapEnv.associationByAddress() && TapEnv.assocAddressDiffTypesUnit(symbolTable.unit.language()) != null) {
                        boolean bl4 = doAddDecl = symbolTable == TapEnv.assocAddressDiffTypesUnit(symbolTable.unit.language()).publicSymbolTable();
                    }
                }
                if (doAddDecl) {
                    if (traceThisUnit || forUnit == null && TapEnv.get().srcUnitsToTraceInTreeGen != null) {
                        TapEnv.printlnOnTrace("  !! Declaration instructions possibly Missing for " + symbolDecl);
                    }
                    declStructs = TreeGen.addSymbolDeclStructs(symbolDecl, declStructs, symbolTable, insertInBlock, null);
                }
            }
            symbolDecls = symbolDecls.tail;
        }
        if ((traceThisUnit || forUnit == null && TapEnv.get().srcUnitsToTraceInTreeGen != null) && declStructs != null) {
            TapEnv.printlnOnTrace("   === Regenerate " + TapList.length(declStructs) + " Missing declarations IN UNIT:" + forUnit + " SYMBOLTABLE:" + symbolTable.addressChain());
        }
        TapList<Object> inResult = toResult = new TapList<Object>(null, null);
        while (declStructs != null) {
            DeclStruct declStruct = (DeclStruct)declStructs.head;
            Tree declTree = declStruct.generateTree(externalTypes, symbolTable);
            if (traceThisUnit || forUnit == null && TapEnv.get().srcUnitsToTraceInTreeGen != null) {
                TapEnv.printlnOnTrace("  Regenerating Missing Declaration Of " + declStruct.symbolDecl + "    ==> " + declTree);
            }
            if (declTree != null) {
                Instruction newInstr;
                if (declStruct.kind == 2 || declStruct.kind == 3) {
                    VariableDecl varDecl = ((VariableDeclStruct)declStruct).getFirstVariableDecl();
                    newInstr = new Instruction(declTree);
                    newInstr.block = insertInBlock;
                    varDecl.setInstruction(newInstr);
                } else if (declStruct.kind == 1) {
                    TypeDecl typeDecl = ((TypeDeclStruct)declStruct).typeDecl();
                    newInstr = new Instruction(declTree);
                    newInstr.block = insertInBlock;
                    typeDecl.setInstruction(newInstr);
                }
                inResult = inResult.placdl(new TapPair<Tree, SymbolDecl>(declTree, declStruct.symbolDecl));
            }
            declStructs = declStructs.tail;
        }
        return toResult.tail;
    }

    private static TapList<Unit> listOfInterfaceDecl(TapList<SymbolDecl> symbolDecls) {
        TapList<Unit> result = null;
        while (symbolDecls != null) {
            SymbolDecl symbolDecl = (SymbolDecl)symbolDecls.head;
            if (symbolDecl.isA(16) && ((InterfaceDecl)symbolDecl).interfaceUnits() != null) {
                result = TapList.append(result, ((InterfaceDecl)symbolDecl).interfaceUnits());
            }
            symbolDecls = symbolDecls.tail;
        }
        return result;
    }

    private static boolean duplicatedIntrinsic(FunctionDecl symbolDecl, TapList<DeclStruct> declStructs, SymbolTable symbolTable, Block insertInBlock) {
        TapList<DeclStruct> decls = declStructs;
        boolean isDeclared = symbolDecl.isIntrinsicDeclared(insertInBlock.instructions);
        while (decls != null && !isDeclared) {
            if (((DeclStruct)decls.head).kind == 6) {
                FunctionDeclStruct functionDeclStruct = (FunctionDeclStruct)decls.head;
                FunctionDecl functionDecl = (FunctionDecl)functionDeclStruct.functionDecls.head;
                if (functionDecl.isIntrinsic() && functionDecl.symbol.equals(symbolDecl.symbol)) {
                    isDeclared = true;
                }
            }
            decls = decls.tail;
        }
        if (!isDeclared) {
            isDeclared = symbolTable.unit.isUseAssociatedIntrinsic(symbolDecl);
        }
        return isDeclared;
    }

    public static TapList<DeclStruct> addSymbolDeclStructs(SymbolDecl symbolDecl, TapList<DeclStruct> declStructs, SymbolTable publicSymbolTable, Block insertInBlock, Tree generatedTree) {
        SymbolTable privateSymbolTable = null;
        if (symbolDecl != null && symbolDecl.isATrueSymbolDecl) {
            if (symbolDecl.isA(5) || symbolDecl.isA(1)) {
                if (!((VariableDecl)symbolDecl).isReturnVar) {
                    declStructs = new TapList<DeclStruct>(new VariableDeclStruct((VariableDecl)symbolDecl, generatedTree), declStructs);
                } else if (TapEnv.relatedLanguageIsFortran9x()) {
                    if (symbolDecl.extraInfo() != null) {
                        symbolDecl.setExtraInfo(null);
                    }
                    declStructs = new TapList<DeclStruct>(new VariableDeclStruct((VariableDecl)symbolDecl, generatedTree), declStructs);
                } else if (TapEnv.relatedLanguageIsFortran()) {
                    if (TypeSpec.isA(symbolDecl.type(), 21)) {
                        declStructs = new TapList<DeclStruct>(new VariableDeclStruct((VariableDecl)symbolDecl, generatedTree), declStructs);
                    }
                } else {
                    declStructs = new TapList<DeclStruct>(new VariableDeclStruct((VariableDecl)symbolDecl, generatedTree), declStructs);
                }
            } else if (symbolDecl.isA(3)) {
                boolean notYetExternalDeclared;
                FunctionDecl functionDecl = (FunctionDecl)symbolDecl;
                if (!(functionDecl.unit() == null || functionDecl.isIntrinsic() || functionDecl.isInterface() || functionDecl.isRenamed() || functionDecl.unit().upperLevelUnit() != null || functionDecl.unit().otherReturnVar() != null || functionDecl.unit().functionTypeSpec() == null)) {
                    boolean notYetVarDeclared;
                    WrapperTypeSpec returnTypeSpec = functionDecl.functionTypeSpec().returnType;
                    if (functionDecl.unit().language() != 4 && TypeSpec.isA(returnTypeSpec, 2) && !returnTypeSpec.isString()) {
                        returnTypeSpec = returnTypeSpec.wrappedType.elementType();
                    }
                    if (TapEnv.relatedUnit() != null) {
                        privateSymbolTable = TapEnv.relatedUnit().privateSymbolTable();
                    }
                    boolean bl = notYetVarDeclared = !(publicSymbolTable.declarationsBlock != null && publicSymbolTable.declarationsBlock.isVarDeclaredInBlock(functionDecl) || privateSymbolTable != null && privateSymbolTable.declarationsBlock != null && privateSymbolTable.declarationsBlock.isVarDeclaredInBlock(functionDecl) || insertInBlock != null && insertInBlock.isVarDeclaredInBlock(functionDecl));
                    if (notYetVarDeclared && !TapEnv.relatedLanguageIsC()) {
                        VariableDecl functionNameTypeDecl = new VariableDecl(ILUtils.build(96, symbolDecl.symbol), returnTypeSpec);
                        functionNameTypeDecl.isFunctionName = true;
                        if (functionNameTypeDecl.type() != null && functionNameTypeDecl.type().wrappedType != null && !TypeSpec.isA(functionNameTypeDecl.type(), 9)) {
                            functionNameTypeDecl.dependsOn = symbolDecl.dependsOn;
                            declStructs = new TapList<DeclStruct>(new VariableDeclStruct(functionNameTypeDecl, generatedTree), declStructs);
                        }
                    }
                }
                if (privateSymbolTable == null && TapEnv.relatedUnit() != null) {
                    privateSymbolTable = TapEnv.relatedUnit().privateSymbolTable();
                }
                boolean bl = notYetExternalDeclared = !(insertInBlock != null && functionDecl.isExternalDeclared(insertInBlock.instructions) || publicSymbolTable != null && publicSymbolTable.declarationsBlock != null && functionDecl.isExternalDeclared(publicSymbolTable.declarationsBlock.instructions) || privateSymbolTable != null && privateSymbolTable.declarationsBlock != null && functionDecl.isExternalDeclared(privateSymbolTable.declarationsBlock.instructions));
                if (notYetExternalDeclared && (TapEnv.relatedUnit() != null && TapEnv.relatedUnit().getImportedDecl(symbolDecl.symbol, 3) == null && TapEnv.relatedUnit() != functionDecl.unit() && !TapList.contains(TapEnv.relatedUnit().lowerLevelUnits, functionDecl.unit()) || functionDecl.isInterface())) {
                    declStructs = new TapList<DeclStruct>(new FunctionDeclStruct(functionDecl), declStructs);
                }
            } else if (symbolDecl.isA(4)) {
                if (symbolDecl.importedFrom == null) {
                    declStructs = new TapList<DeclStruct>(new TypeDeclStruct((TypeDecl)symbolDecl), declStructs);
                }
            } else if (symbolDecl.isA(6)) {
                WrapperTypeSpec returnType = ((FunctionTypeSpec)symbolDecl.type().wrappedType).returnType;
                if (!TypeSpec.isA(returnType, 9)) {
                    VariableDecl funcNameDecl = new VariableDecl(ILUtils.build(96, symbolDecl.symbol), returnType);
                    funcNameDecl.isFunctionName = true;
                    declStructs = new TapList<DeclStruct>(new VariableDeclStruct(funcNameDecl, generatedTree), declStructs);
                }
            } else if (symbolDecl.isA(16)) {
                declStructs = new TapList<DeclStruct>(new InterfaceDeclStruct((InterfaceDecl)symbolDecl), declStructs);
            } else {
                TapEnv.toolWarning(-1, "(Regeneration of declaration) Unexpected kind of SymbolDecl for " + symbolDecl.symbol + " (" + symbolDecl.kind() + ')');
            }
        }
        return declStructs;
    }

    private static TapList<TapTriplet<Tree, Tree, Integer>> findCurrentObjectTriplet(String includeName, TapList<TapTriplet<Tree, Tree, Integer>> toResult) {
        boolean found = false;
        TapList<TapTriplet<Tree, Tree, Integer>> result = null;
        toResult = toResult.tail;
        while (!found && toResult != null) {
            found = includeName.equals(((Tree)((TapTriplet)toResult.head).first).stringValue());
            if (found) {
                result = toResult;
            }
            toResult = toResult.tail;
        }
        return result;
    }

    private TreeGen() {
    }
}

