/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.ir2tree;

import fr.inria.tapenade.ir2tree.ControlStruct;
import fr.inria.tapenade.ir2tree.SwitchStruct;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.HeaderBlock;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

final class PlainStruct
extends ControlStruct {
    protected PlainStruct(Block block) {
        this.controlStructBlock = block;
    }

    @Override
    protected void addControlStruct(ControlStruct struct, FGArrow arrow) {
    }

    @Override
    protected void insertLetStructure() {
    }

    @Override
    protected void reorderBody() {
    }

    @Override
    protected void propagateNaturalNext(Block naturalNext) {
        this.naturalNext = naturalNext;
    }

    @Override
    protected TapList<FGArrow> propagateNaturalFlow() {
        Tree lastTree;
        this.naturalFlow = this.controlStructBlock.flow();
        Instruction lastInstr = this.controlStructBlock.lastInstr();
        if (lastInstr != null && (lastTree = lastInstr.tree) != null && lastTree.opCode() == 30) {
            this.naturalFlow = null;
        }
        return this.naturalFlow;
    }

    @Override
    protected TapList<FGArrow> preGenerateTree(TapList<FGArrow> naturalArrows, TapList<TapTriplet<Tree, Tree, Integer>> toFutureIncludes, TapList<Tree> fileUserHelpStrings, TapList<ControlStruct> enclosingStructs, boolean skipSubUnits) {
        TapList<Instruction> nextInstructions = this.controlStructBlock.instructions;
        TapList<FGArrow> natArrows = null;
        if (TapEnv.get().createStub) {
            TapList<Instruction> declarationsInstructions = null;
            while (nextInstructions != null) {
                Instruction curInstruction = (Instruction)nextInstructions.head;
                if (curInstruction.isADeclaration()) {
                    declarationsInstructions = new TapList<Instruction>(curInstruction, declarationsInstructions);
                }
                nextInstructions = nextInstructions.tail;
            }
            nextInstructions = TapList.reverse(declarationsInstructions);
            if (nextInstructions != null) {
                this.preGenerateBody(nextInstructions, naturalArrows, toFutureIncludes, fileUserHelpStrings, skipSubUnits);
            }
        } else {
            Tree lastInstructionTree = this.preGenerateBody(nextInstructions, naturalArrows, toFutureIncludes, fileUserHelpStrings, skipSubUnits);
            TapList<FGArrow> arrows = this.controlStructBlock.flow();
            if (lastInstructionTree != null && lastInstructionTree.opCode() == 30) {
                while (enclosingStructs != null && !(enclosingStructs.head instanceof SwitchStruct)) {
                    enclosingStructs = enclosingStructs.tail;
                }
                if (enclosingStructs != null) {
                    SwitchStruct switchStruct = (SwitchStruct)enclosingStructs.head;
                    switchStruct.naturalArrowsAfterSwitch = TapList.append(switchStruct.naturalArrowsAfterSwitch, arrows);
                    arrows = null;
                }
            }
            while (arrows != null) {
                FGArrow arrow = (FGArrow)arrows.head;
                if (arrow.mayBeNatural()) {
                    natArrows = new TapList<FGArrow>(arrow, natArrows);
                }
                arrows = arrows.tail;
            }
        }
        return natArrows;
    }

    @Override
    protected void generateTree(boolean delayGoto, TapList<TapTriplet<Tree, Tree, Integer>> toFutureIncludes, TapList<Tree> fileUserHelpStrings) {
        Tree lastInstructionTree;
        TapList<FGArrow> arrows = this.controlStructBlock.flow();
        int lastOperator = -1;
        Tree tree = lastInstructionTree = this.treesReverse == null ? null : (Tree)this.treesReverse.head;
        if (arrows != null) {
            FGArrow defaultArrow;
            if (lastInstructionTree != null && lastInstructionTree.opCode() == 112) {
                lastInstructionTree = lastInstructionTree.down(2);
            }
            if (lastInstructionTree != null) {
                lastOperator = lastInstructionTree.opCode();
            }
            switch (lastOperator) {
                case 40: {
                    assert (lastInstructionTree != null);
                    this.checkCompGoto(lastInstructionTree);
                    defaultArrow = this.controlStructBlock.getFGArrowTestCase(10, -1);
                    break;
                }
                case 31: {
                    if (((FGArrow)arrows.head).test == 15) {
                        this.checkCallGoto(lastInstructionTree);
                        defaultArrow = this.controlStructBlock.getFGArrowTestCase(15, -1);
                        break;
                    }
                    defaultArrow = (FGArrow)arrows.head;
                    break;
                }
                case 109: {
                    if (((FGArrow)arrows.head).test == 12) {
                        assert (lastInstructionTree != null);
                        this.checkIoGoto(lastInstructionTree);
                        defaultArrow = this.controlStructBlock.getFGArrowTestCase(12, -1);
                        break;
                    }
                    defaultArrow = (FGArrow)arrows.head;
                    break;
                }
                case 94: {
                    this.checkGotoLabelVar();
                    defaultArrow = null;
                    break;
                }
                default: {
                    defaultArrow = (FGArrow)arrows.head;
                }
            }
            if (defaultArrow != null && defaultArrow.carry != null && !delayGoto) {
                this.insertInstructionTree(this.turnCarryIntoJump(defaultArrow), false);
            }
        }
    }

    private void checkCompGoto(Tree instTree) {
        Tree[] compGotoLabels = instTree.down(1).children();
        for (int i = compGotoLabels.length - 1; i >= 0; --i) {
            FGArrow arrow = this.controlStructBlock.getFGArrowTestCase(10, i + 1);
            compGotoLabels[i].setValue(this.getDestinationLabel(arrow));
        }
    }

    private void checkGotoLabelVar() {
        TapList<FGArrow> arrows = this.controlStructBlock.flow();
        while (arrows != null) {
            FGArrow arrow = (FGArrow)arrows.head;
            arrow.carry = null;
            arrows = arrows.tail;
        }
    }

    private void checkIoGoto(Tree instTree) {
        Tree[] ioStats = instTree.down(2).children();
        for (int i = ioStats.length - 1; i >= 0; --i) {
            FGArrow arrow;
            String name;
            if (ioStats[i].opCode() != 134) continue;
            switch (name = ioStats[i].down(1).stringValue()) {
                case "end": {
                    arrow = this.controlStructBlock.getFGArrowTestCase(12, 14);
                    break;
                }
                case "err": {
                    arrow = this.controlStructBlock.getFGArrowTestCase(12, 13);
                    break;
                }
                case "eor": {
                    arrow = this.controlStructBlock.getFGArrowTestCase(12, 15);
                    break;
                }
                default: {
                    arrow = null;
                }
            }
            if (arrow == null) continue;
            ioStats[i].setChild(ILUtils.build(111, this.getDestinationLabel(arrow)), 2);
        }
    }

    private void checkCallGoto(Tree instTree) {
        Tree[] callArgs = ILUtils.getArguments(instTree).children();
        int labelRank = 0;
        for (Tree callArg : callArgs) {
            if (callArg.opCode() != 111) continue;
            FGArrow arrow = this.controlStructBlock.getFGArrowTestCase(15, ++labelRank);
            callArg.setValue(this.getDestinationLabel(arrow));
        }
    }

    private String getDestinationLabel(FGArrow arrow) {
        String label = null;
        if (arrow != null) {
            if (arrow.carry != null) {
                label = ((Tree)arrow.carry).stringValue();
            }
            if (label == null) {
                label = arrow.inACycle && arrow.destination instanceof HeaderBlock ? ((HeaderBlock)arrow.destination).origCycleLabel() : arrow.destination.origLabel();
            }
            if (!arrow.containsCase(-1)) {
                arrow.carry = null;
            }
        }
        return label;
    }

    @Override
    public void dump(int indent) throws IOException {
        TapEnv.print("Plain ");
        super.dump(indent);
    }

    @Override
    public String toString() {
        return "PLAIN:" + this.controlStructBlock + " @" + Integer.toHexString(this.controlStructBlock.hashCode()) + " INSTRS:" + this.controlStructBlock.instructions;
    }
}

