/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.ir2tree;

import fr.inria.tapenade.ir2tree.DeclStruct;
import fr.inria.tapenade.ir2tree.TreeGen;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.InterfaceDecl;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.utils.Tree;

final class InterfaceDeclStruct
extends DeclStruct {
    private final TapList<InterfaceDecl> interfaceDecls;

    protected InterfaceDeclStruct(InterfaceDecl interfaceDecl) {
        this.interfaceDecls = new TapList<InterfaceDecl>(interfaceDecl, null);
        this.usedNames = interfaceDecl.dependsOn();
        this.kind = 7;
        this.symbolDecl = interfaceDecl;
    }

    @Override
    protected Tree generateTree(TapList<SymbolDecl> declaredTypes, SymbolTable symbolTable) {
        TapList<InterfaceDecl> inInterfaceDecls = this.interfaceDecls;
        Tree result = null;
        while (inInterfaceDecls != null) {
            InterfaceDecl interfaceDecl = (InterfaceDecl)inInterfaceDecls.head;
            if (interfaceDecl.contents != null) {
                result = ILUtils.build(106, interfaceDecl.nameTree, ILUtils.build(107, interfaceDecl.contents));
            } else {
                TapList<Object> hdTrees;
                TapList<Unit> interfaceUnits = interfaceDecl.interfaceUnits();
                if (interfaceUnits != null && ((Unit)interfaceUnits.head).rank() == -1) {
                    interfaceUnits = null;
                }
                if (interfaceUnits == null) {
                    TapList<FunctionDecl> functionDecls = interfaceDecl.functionDecls;
                    while (functionDecls != null) {
                        FunctionDecl functionDecl = (FunctionDecl)functionDecls.head;
                        if (functionDecl != null && functionDecl.unit() != null) {
                            interfaceUnits = new TapList<Unit>(functionDecl.unit(), interfaceUnits);
                        }
                        functionDecls = functionDecls.tail;
                    }
                    interfaceUnits = TapList.nreverse(interfaceUnits);
                }
                TapList<Object> tlTrees = hdTrees = new TapList<Object>(null, null);
                while (interfaceUnits != null) {
                    Unit interfaceUnit = (Unit)interfaceUnits.head;
                    TapEnv.pushRelatedUnit(interfaceUnit);
                    Tree unitTree = TreeGen.generate(interfaceUnit, false, true, false, new TapList<Object>(null, null), new TapList<Object>(null, null));
                    if (unitTree != null) {
                        unitTree = unitTree.cutChild(1);
                    }
                    tlTrees = tlTrees.placdl(ILUtils.build(105, unitTree));
                    TapEnv.popRelatedUnit();
                    interfaceUnits = interfaceUnits.tail;
                }
                result = ILUtils.build(106, interfaceDecl.nameTree, ILUtils.build(107, hdTrees.tail));
            }
            inInterfaceDecls = inInterfaceDecls.tail;
        }
        return result;
    }

    @Override
    public String toString() {
        return "declaration of Interface " + ((InterfaceDecl)this.interfaceDecls.head).symbol;
    }
}

