/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.ir2tree;

import fr.inria.tapenade.ir2tree.LetStruct;
import fr.inria.tapenade.ir2tree.LoopStruct;
import fr.inria.tapenade.ir2tree.SwitchStruct;
import fr.inria.tapenade.ir2tree.TreeGen;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.CStuff;
import fr.inria.tapenade.representation.Directive;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.HeaderBlock;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public abstract class ControlStruct {
    protected Block controlStructBlock;
    protected TapList<Tree> treesReverse;
    protected Tree structuredTree;
    protected Block naturalNext;
    protected TapList<FGArrow> naturalFlow;
    protected ControlStruct aboveControlStruct;
    private TapList<Tree> danglingCommentsReverse;

    protected static TapList<ControlStruct> insertLetStructureChained(TapList<ControlStruct> chainedStructs, SymbolTable refSymbolTable) {
        LetStruct dummyLetStruct = new LetStruct(refSymbolTable);
        TapList<TapPair<SymbolTable, LetStruct>> allLetStructs = new TapList<TapPair<SymbolTable, LetStruct>>(new TapPair<SymbolTable, LetStruct>(refSymbolTable, dummyLetStruct), null);
        while (chainedStructs != null) {
            ControlStruct controlStruct = (ControlStruct)chainedStructs.head;
            controlStruct.insertLetStructure();
            SymbolTable targetSymbolTable = controlStruct.controlStructBlock.symbolTable;
            LetStruct targetLetStruct = ControlStruct.getSetLetStructOfSymbolTable(targetSymbolTable, allLetStructs, refSymbolTable, controlStruct.controlStructBlock);
            if (targetLetStruct == null) {
                targetLetStruct = dummyLetStruct;
            }
            targetLetStruct.addControlStructAtTail(controlStruct);
            chainedStructs = chainedStructs.tail;
        }
        return dummyLetStruct.body;
    }

    private static LetStruct getSetLetStructOfSymbolTable(SymbolTable symbolTable, TapList<TapPair<SymbolTable, LetStruct>> allLetStructs, SymbolTable refSymbolTable, Block block) {
        LetStruct found;
        if (symbolTable == null || refSymbolTable.nestedIn(symbolTable)) {
            found = (LetStruct)TapList.cassq(refSymbolTable, allLetStructs);
        } else {
            found = (LetStruct)TapList.cassq(symbolTable, allLetStructs);
            if (found == null) {
                LetStruct above = ControlStruct.getSetLetStructOfSymbolTable(symbolTable.basisSymbolTable(), allLetStructs, refSymbolTable, block);
                found = new LetStruct(symbolTable);
                found.controlStructBlock = block;
                allLetStructs.newR(new TapPair<SymbolTable, LetStruct>(symbolTable, found));
                above.addControlStructAtTail(found);
            }
        }
        return found;
    }

    protected static TapList<ControlStruct> reorderBodyChained(TapList<ControlStruct> chainedStructs) {
        TapList<Object> toSortedStructs = new TapList<Object>(null, null);
        while (chainedStructs != null) {
            ControlStruct controlStruct = (ControlStruct)chainedStructs.head;
            controlStruct.reorderBody();
            TapList<Object> inSortedStructs = toSortedStructs;
            while (inSortedStructs.tail != null && ControlStruct.mustReorderAfter(controlStruct, (ControlStruct)inSortedStructs.tail.head)) {
                inSortedStructs = inSortedStructs.tail;
            }
            inSortedStructs.tail = new TapList<ControlStruct>(controlStruct, inSortedStructs.tail);
            chainedStructs = chainedStructs.tail;
        }
        return toSortedStructs.tail;
    }

    private static boolean mustReorderAfter(ControlStruct str1, ControlStruct str2) {
        return str1.controlStructBlock.rank > str2.controlStructBlock.rank;
    }

    protected static void propagateNaturalNextChained(TapList<ControlStruct> chainedStructs, Block lastNaturalNext) {
        while (chainedStructs != null) {
            ControlStruct controlStruct = (ControlStruct)chainedStructs.head;
            chainedStructs = chainedStructs.tail;
            controlStruct.propagateNaturalNext(chainedStructs != null ? ((ControlStruct)chainedStructs.head).controlStructBlock : lastNaturalNext);
        }
    }

    protected static TapList<FGArrow> propagateNaturalFlowChained(TapList<ControlStruct> chainedStructs) {
        TapList<FGArrow> naturalFlow = null;
        while (chainedStructs != null) {
            ControlStruct controlStruct = (ControlStruct)chainedStructs.head;
            naturalFlow = controlStruct.propagateNaturalFlow();
            chainedStructs = chainedStructs.tail;
        }
        return naturalFlow;
    }

    protected static TapList<FGArrow> preGenerateTreeChained(TapList<ControlStruct> chainedStructs, TapList<TapTriplet<Tree, Tree, Integer>> toFutureIncludes, TapList<Tree> fileUserHelpStrings, TapList<FGArrow> naturalArrows, TapList<ControlStruct> enclosingStructs, boolean skipSubUnits) {
        while (chainedStructs != null) {
            naturalArrows = ((ControlStruct)chainedStructs.head).preGenerateTree(naturalArrows, toFutureIncludes, fileUserHelpStrings, enclosingStructs, skipSubUnits);
            chainedStructs = chainedStructs.tail;
        }
        return naturalArrows;
    }

    private static Tree generatedTreeFor(Instruction instr, TapList<TapTriplet<Tree, Tree, Integer>> toFutureIncludes, TapList<Tree> fileUserHelpStrings, boolean skipSubUnits) {
        boolean traceThisUnit = TapEnv.get().srcUnitsToTraceInTreeGen != null && (TapEnv.get().srcUnitsToTraceInTreeGen.head == null || TapList.contains(TapEnv.get().srcUnitsToTraceInTreeGen, TapEnv.relatedUnit()));
        Unit definedUnit = instr.isUnitDefinitionStub();
        if (definedUnit != null) {
            Tree unitTree;
            if (skipSubUnits) {
                return null;
            }
            if (definedUnit.rank() == -1) {
                TapEnv.toolWarning(0, "Warning: regenerated sub-unit seems external (rank==-1): " + definedUnit);
            }
            if ((unitTree = TreeGen.generate(definedUnit, false, false, false, toFutureIncludes, definedUnit.isC() ? fileUserHelpStrings : null)) != null) {
                unitTree = unitTree.cutChild(1);
            }
            return unitTree;
        }
        if (instr.tree != null) {
            if (instr.tree.opCode() == 101 && instr.fromInclude() != null && instr.fromInclude().tree == null) {
                if (traceThisUnit) {
                    TapEnv.printlnOnTrace("Skipping include instruction because inlined: " + ILUtils.toString(instr.tree));
                }
                return null;
            }
            if (TapEnv.relatedUnit().isC() && ControlStruct.isOrContainsAnAssignedAllocate(instr.tree)) {
                Tree newTree = ILUtils.copy(instr.tree);
                if (newTree.opCode() == 199) {
                    Tree[] declarators = newTree.down(3).children();
                    for (int i = declarators.length - 1; i >= 0; --i) {
                        declarators[i].setChild(CStuff.buildMalloc(declarators[i].down(2), null), 2);
                    }
                } else {
                    Tree newMalloc = CStuff.buildMalloc(newTree.down(2), newTree.down(1));
                    if (ILUtils.isCallingString(newMalloc, "cudaMalloc", true)) {
                        newTree = newMalloc;
                    } else {
                        newTree.setChild(newMalloc, 2);
                    }
                }
                if (traceThisUnit) {
                    TapEnv.printlnOnTrace("Transform IL " + instr.tree + " into C " + newTree);
                }
                instr.copyCommentsToTree(newTree);
                return newTree;
            }
            if (TapEnv.relatedUnit().isC() && instr.tree.opCode() == 52) {
                Tree sourceTree;
                for (sourceTree = (Tree)instr.tree.getAnnotation("sourcetree"); sourceTree != null && sourceTree.opCode() == 32; sourceTree = sourceTree.down(2)) {
                }
                if (ILUtils.isCallingString(sourceTree, "cudaMalloc", true) || ILUtils.isCallingString(sourceTree, "cudaFree", true)) {
                    Tree newCudaFree = ILUtils.buildCall(null, ILUtils.build(96, "cudaFree"), ILUtils.build(71, ILUtils.copy(instr.tree.down(1))));
                    if (traceThisUnit) {
                        TapEnv.printlnOnTrace("Transform IL " + instr.tree + " into Cuda " + newCudaFree);
                    }
                    instr.copyCommentsToTree(newCudaFree);
                    return newCudaFree;
                }
                Tree newFree = ILUtils.buildCall(null, ILUtils.build(96, "free"), ILUtils.build(71, ILUtils.copy(instr.tree.down(1))));
                if (traceThisUnit) {
                    TapEnv.printlnOnTrace("Transform IL " + instr.tree + " into C " + newFree);
                }
                instr.copyCommentsToTree(newFree);
                return newFree;
            }
            return instr.copyTreePlusComments();
        }
        return null;
    }

    private static boolean isOrContainsAnAssignedAllocate(Tree tree) {
        boolean result = false;
        if (tree.opCode() == 199) {
            Tree[] declarators = tree.down(3).children();
            for (int i = declarators.length - 1; i >= 0 && !result; --i) {
                result = declarators[i].opCode() == 14 && ILUtils.isAllocate(declarators[i].down(2));
            }
        } else {
            result = tree.opCode() == 14 && ILUtils.isAllocate(tree.down(2));
        }
        return result;
    }

    protected static TapList<Tree> generateTreeChained(TapList<ControlStruct> chainedStructs, boolean delayGoto, String lastLabel, TapList<TapTriplet<Tree, Tree, Integer>> toFutureIncludes, TapList<Tree> fileUserHelpStrings) {
        TapList<Object> topInstrList;
        TapList<Object> tailInstrList = topInstrList = new TapList<Object>(null, null);
        while (chainedStructs != null) {
            ControlStruct chainedStruct = (ControlStruct)chainedStructs.head;
            chainedStruct.generateTree(chainedStructs.tail == null && delayGoto, toFutureIncludes, fileUserHelpStrings);
            TapList<Tree> subTreeList = TapList.reverse(chainedStruct.treesReverse);
            chainedStruct.treesReverse = null;
            while (subTreeList != null) {
                tailInstrList = tailInstrList.placdl(subTreeList.head);
                subTreeList = subTreeList.tail;
            }
            chainedStructs = chainedStructs.tail;
        }
        if (lastLabel != null) {
            tailInstrList.placdl(ControlStruct.setLabelAround(lastLabel, ILUtils.build(138)));
        }
        return topInstrList.tail;
    }

    private static Tree setLabelAround(String label, Tree tree) {
        Tree labelledTree = ILUtils.build(112, ILUtils.build(111, label), tree);
        Tree comments = (Tree)tree.getAnnotation("preComments");
        if (comments != null) {
            tree.removeAnnotation("preComments");
            labelledTree.setAnnotation("preComments", comments);
        }
        if ((comments = (Tree)tree.getAnnotation("postComments")) != null) {
            tree.removeAnnotation("postComments");
            labelledTree.setAnnotation("postComments", comments);
        }
        return labelledTree;
    }

    protected ControlStruct getBlock(Block block) {
        ControlStruct result = this.controlStructBlock == block ? this : null;
        return result;
    }

    protected abstract void addControlStruct(ControlStruct var1, FGArrow var2);

    protected abstract void insertLetStructure();

    protected abstract void reorderBody();

    protected abstract void propagateNaturalNext(Block var1);

    protected abstract TapList<FGArrow> propagateNaturalFlow();

    protected abstract TapList<FGArrow> preGenerateTree(TapList<FGArrow> var1, TapList<TapTriplet<Tree, Tree, Integer>> var2, TapList<Tree> var3, TapList<ControlStruct> var4, boolean var5);

    protected Tree preGenerateBody(TapList<Instruction> instructions, TapList<FGArrow> naturalArrows, TapList<TapTriplet<Tree, Tree, Integer>> toFutureIncludes, TapList<Tree> fileUserHelpStrings, boolean skipSubUnits) {
        Instruction instruction;
        Tree instructionTree;
        this.danglingCommentsReverse = null;
        if (!TapEnv.get().createStub) {
            if (instructions == null) {
                instructionTree = ILUtils.build(TapEnv.relatedLanguageIsC() ? 138 : 49);
                instruction = new Instruction(instructionTree, null, this.controlStructBlock);
            } else {
                instruction = (Instruction)instructions.head;
                instructionTree = ControlStruct.generatedTreeFor(instruction, toFutureIncludes, fileUserHelpStrings, skipSubUnits);
                instructions = instructions.tail;
            }
            instructionTree = this.checkLabels(instructionTree, naturalArrows, null, null);
        } else {
            instruction = (Instruction)instructions.head;
            instructionTree = ControlStruct.generatedTreeFor(instruction, toFutureIncludes, fileUserHelpStrings, skipSubUnits);
            instructions = instructions.tail;
        }
        while (true) {
            if ((instructions != null || this.treesReverse != null || !this.hasComments(instruction)) && (instructionTree == null || instructionTree.opCode() == 49 || instructionTree.opCode() == 138 || instruction.isPhantom && instructionTree.opCode() == 108 && ILUtils.isIdent(instructionTree.down(1), "%val", false) || instruction.isPhantom && instructionTree.opCode() == 199 && ILUtils.isIdent(instructionTree.down(3).down(1), "%val", false) || instruction.isPhantom && ControlStruct.hasOwnScope(instruction.block) || instruction.isPhantom)) {
                this.dontLooseComments(instruction);
            } else {
                this.putDirectivesBackAsComments(instruction.directives);
                this.insertInstructionTree(instructionTree, true);
            }
            if (instructions == null) break;
            instruction = (Instruction)instructions.head;
            instructionTree = ControlStruct.generatedTreeFor(instruction, toFutureIncludes, fileUserHelpStrings, skipSubUnits);
            instructions = instructions.tail;
        }
        if (this.treesReverse == null && this.danglingCommentsReverse != null) {
            Tree emptyTree = ILUtils.build(138);
            emptyTree.setAnnotation("preComments", ILUtils.listReversedToComments(this.danglingCommentsReverse));
            this.treesReverse = new TapList<Tree>(emptyTree, null);
            this.danglingCommentsReverse = null;
        }
        return instructionTree;
    }

    private static boolean hasOwnScope(Block block) {
        return block.unit() == null || block.symbolTable != block.unit().privateSymbolTable();
    }

    protected abstract void generateTree(boolean var1, TapList<TapTriplet<Tree, Tree, Integer>> var2, TapList<Tree> var3);

    protected Tree checkLabels(Tree structTree, TapList<FGArrow> naturalArrows, TapList<FGArrow> naturalCycleArrows, TapList<FGArrow> ignoredArrows) {
        boolean isALoopHeader;
        TapList<FGArrow> arrows = this.controlStructBlock.backFlow();
        String externalLabel = null;
        String internalLabel = null;
        boolean bl = isALoopHeader = this.controlStructBlock.instructions != null && this.controlStructBlock.headInstr().isALoop();
        while (arrows != null) {
            FGArrow arrow = (FGArrow)arrows.head;
            if (!TapList.contains(ignoredArrows, arrow)) {
                boolean arrowCanBreak;
                boolean labelDeepInside;
                boolean loopCycle = isALoopHeader && arrow.inACycle;
                boolean bl2 = labelDeepInside = !arrow.containsCase(-1) && (arrow.test == 10 || arrow.test == 12 || arrow.test == 15);
                boolean arrowMustJump = !(!labelDeepInside && TapList.contains(loopCycle ? naturalCycleArrows : naturalArrows, arrow) || arrow.cases != null && arrow.cases.head == 9 || arrow.origin.lastTest() == 168);
                ControlStruct aroundOriginBreakable = arrow.origin.getControlStruct();
                while (!(aroundOriginBreakable == null || aroundOriginBreakable instanceof SwitchStruct && TapEnv.relatedLanguageIsC() || aroundOriginBreakable instanceof LoopStruct)) {
                    aroundOriginBreakable = aroundOriginBreakable.aboveControlStruct;
                }
                boolean bl3 = arrowCanBreak = !labelDeepInside && aroundOriginBreakable != null && aroundOriginBreakable.naturalNext == arrow.destination;
                if (this instanceof LetStruct && loopCycle) {
                    arrowMustJump = false;
                }
                if (arrowMustJump) {
                    if (arrowCanBreak) {
                        arrow.carry = ILUtils.build(30);
                    } else if (loopCycle) {
                        if (internalLabel == null) {
                            if (this.controlStructBlock instanceof HeaderBlock) {
                                internalLabel = ((HeaderBlock)this.controlStructBlock).origCycleLabel();
                            }
                            if (internalLabel == null) {
                                if (this.controlStructBlock.isALoop()) {
                                    internalLabel = this.mkNewLabel();
                                    ((HeaderBlock)this.controlStructBlock).setOrigCycleLabel(internalLabel);
                                } else {
                                    internalLabel = this.controlStructBlock.origLabel();
                                    if (internalLabel == null) {
                                        internalLabel = this.mkNewLabel();
                                        this.controlStructBlock.setOrigLabel(internalLabel);
                                    }
                                }
                            }
                        }
                        arrow.carry = ILUtils.build(111, internalLabel);
                    } else {
                        if (externalLabel == null && (externalLabel = this.controlStructBlock.origLabel()) == null) {
                            externalLabel = this.mkNewLabel();
                            this.controlStructBlock.setOrigLabel(externalLabel);
                        }
                        arrow.carry = ILUtils.build(111, externalLabel);
                    }
                }
            }
            arrows = arrows.tail;
        }
        boolean alreadySet = false;
        if (internalLabel != null && structTree.opCode() == 121) {
            structTree.setChild(ILUtils.build(111, internalLabel), 2);
            alreadySet = true;
        }
        if (!(externalLabel == null || alreadySet && externalLabel.equals(internalLabel))) {
            if (structTree.opCode() == 89) {
                Tree continueTree = ILUtils.build(TapEnv.relatedLanguageIsC() ? 138 : 49);
                continueTree = ControlStruct.setLabelAround(externalLabel, continueTree);
                this.insertInstructionTree(continueTree, false);
            } else {
                structTree = ControlStruct.setLabelAround(externalLabel, structTree);
            }
        }
        return structTree;
    }

    private String mkNewLabel() {
        while (TapList.containsEquals(TapEnv.get().usedLabels, Integer.toString(TapEnv.get().nextNewLabel))) {
            TapEnv.get().nextNewLabel += 10;
        }
        String newLabel = Integer.toString(TapEnv.get().nextNewLabel);
        TapEnv.get().usedLabels = new TapList<String>(newLabel, TapEnv.get().usedLabels);
        TapEnv.get().nextNewLabel += 10;
        return newLabel;
    }

    protected Tree turnCarryIntoJump(FGArrow arrow) {
        Tree labelTree = (Tree)arrow.carry;
        arrow.carry = null;
        if (labelTree == null) {
            return null;
        }
        if (labelTree.opCode() == 30) {
            return labelTree;
        }
        return ILUtils.build(93, labelTree);
    }

    protected void insertInstructionTree(Tree instructionTree, boolean atTheEnd) {
        if (this.danglingCommentsReverse != null) {
            Tree preCommentsTree = (Tree)instructionTree.getAnnotation("preComments");
            TapList<Tree> preCommentsListReversed = preCommentsTree == null ? null : ILUtils.commentsToListReversed(ILUtils.copy(preCommentsTree));
            preCommentsListReversed = TapList.append(preCommentsListReversed, this.danglingCommentsReverse);
            instructionTree.setAnnotation("preComments", ILUtils.listReversedToComments(preCommentsListReversed));
            this.danglingCommentsReverse = null;
        }
        if (atTheEnd) {
            this.treesReverse = new TapList<Tree>(instructionTree, this.treesReverse);
        } else {
            TapList<Tree> trees = this.treesReverse;
            TapList funTrees = null;
            while (trees != null && (((Tree)trees.head).opCode() == 89 || ((Tree)trees.head).opCode() == 159)) {
                funTrees = new TapList(trees.head, funTrees);
                trees = trees.tail;
            }
            this.treesReverse = new TapList<Tree>(instructionTree, trees);
            while (funTrees != null) {
                this.treesReverse = new TapList<Tree>((Tree)funTrees.head, this.treesReverse);
                funTrees = funTrees.tail;
            }
        }
    }

    private boolean hasComments(Instruction instruction) {
        return !ILUtils.isNullOrNoneOrEmptyList(instruction.preComments) || !ILUtils.isNullOrNoneOrEmptyList(instruction.postComments);
    }

    private void dontLooseComments(Instruction emptyInstruction) {
        TapList<Tree> commentsListReversed;
        Tree commentsTree = emptyInstruction.preComments;
        if (commentsTree != null) {
            commentsTree = ILUtils.copy(commentsTree);
            commentsListReversed = ILUtils.commentsToListReversed(commentsTree);
            this.danglingCommentsReverse = TapList.append(commentsListReversed, this.danglingCommentsReverse);
        }
        this.putDirectivesBackAsComments(emptyInstruction.directives);
        commentsTree = emptyInstruction.postComments;
        if (commentsTree != null) {
            commentsTree = ILUtils.copy(commentsTree);
            commentsListReversed = ILUtils.commentsToListReversed(commentsTree);
            this.danglingCommentsReverse = TapList.append(commentsListReversed, this.danglingCommentsReverse);
        }
        if (this.danglingCommentsReverse != null && this.treesReverse != null && this.treesReverse.head != null) {
            Tree receiver = (Tree)this.treesReverse.head;
            commentsTree = (Tree)receiver.getAnnotation("postComments");
            commentsListReversed = commentsTree == null ? null : ILUtils.commentsToListReversed(ILUtils.copy(commentsTree));
            commentsListReversed = TapList.append(this.danglingCommentsReverse, commentsListReversed);
            receiver.setAnnotation("postComments", ILUtils.listReversedToComments(commentsListReversed));
            this.danglingCommentsReverse = null;
        }
    }

    protected void putDirectivesBackAsComments(TapList<Directive> directives) {
        while (directives != null) {
            if (directives.head != null) {
                this.danglingCommentsReverse = new TapList<Tree>(ILUtils.build(180, ((Directive)directives.head).rebuildFullDirective()), this.danglingCommentsReverse);
            }
            directives = directives.tail;
        }
    }

    public void dump(int indent) throws IOException {
        if (this.controlStructBlock == null) {
            TapEnv.print(" no CB");
        } else {
            TapEnv.print(" CB: ");
            this.controlStructBlock.cite();
            TapEnv.print(" Instructions:" + this.controlStructBlock.instructions);
        }
    }

    public String toString() {
        return "Unspecified ControlStruct:" + this.controlStructBlock;
    }
}

