/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.gui;

import fr.inria.tapenade.gui.TapenadeFrame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;

class TopUnitPanel
extends JPanel {
    private static final long serialVersionUID = 7774299994054L;
    private JComboBox<String> units;
    private boolean recompute;

    protected TopUnitPanel() {
        this.initialize();
    }

    private final void initialize() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Top Procedure :"), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        GridBagConstraints constraintsUnits = new GridBagConstraints();
        constraintsUnits.gridx = 0;
        constraintsUnits.gridy = 0;
        constraintsUnits.fill = 2;
        constraintsUnits.weightx = 0.2;
        constraintsUnits.weighty = 1.0;
        constraintsUnits.insets = new Insets(4, 4, 4, 4);
        this.add(this.getUnits(), constraintsUnits);
    }

    protected JComboBox<String> getUnits() {
        if (this.units == null) {
            this.units = new JComboBox();
            TapenadeFrame.setBackground(this.units);
            TapenadeFrame.setFont(this.units);
            this.units.setModel(new DefaultComboBoxModel());
            this.units.setPrototypeDisplayValue("Empty  ");
            this.units.addActionListener(e -> {
                if (!this.recompute) {
                    ((DefaultListModel)TapenadeFrame.getInstance().getInputVariablesPanel().getVariablesList().getModel()).removeAllElements();
                    ((DefaultListModel)TapenadeFrame.getInstance().getOutputVariablesPanel().getVariablesList().getModel()).removeAllElements();
                    Object obj = TapenadeFrame.getInstance().getTopUnitPanel().getUnits().getSelectedItem();
                    if (obj != null) {
                        String unitName = obj.toString();
                        TapenadeFrame.getInstance().setTopUnitName(unitName);
                    }
                }
            });
        }
        return this.units;
    }

    protected void setRecompute(boolean recompute) {
        this.recompute = recompute;
    }
}

