/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.gui;

import fr.inria.tapenade.gui.AnalyseModePanel;
import fr.inria.tapenade.gui.ControlPanel;
import fr.inria.tapenade.gui.ExtFilesPanel;
import fr.inria.tapenade.gui.FilesPanel;
import fr.inria.tapenade.gui.InitFrame;
import fr.inria.tapenade.gui.InputLanguagePanel;
import fr.inria.tapenade.gui.MyActionListener;
import fr.inria.tapenade.gui.OptionPanel;
import fr.inria.tapenade.gui.OutputLanguagePanel;
import fr.inria.tapenade.gui.OutputPanel;
import fr.inria.tapenade.gui.TopUnitPanel;
import fr.inria.tapenade.gui.VariablesPanel;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.toplevel.Tapenade;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;

public final class TapenadeFrame
extends JFrame {
    private static final long serialVersionUID = 43734299994054L;
    private static TapenadeFrame frame;
    private InitFrame tapenadeInit;
    private InputLanguagePanel inputLanguagePanel;
    private FilesPanel filesPanel;
    private TopUnitPanel topUnitPanel;
    private VariablesPanel outputVariablesPanel;
    private VariablesPanel inputVariablesPanel;
    private AnalyseModePanel analyseModePanel;
    private ControlPanel controlPanel;
    private JMenu menu;
    private JPanel advancedPanel;
    private JPanel mainPanel;
    private CallGraph callGraph;
    private String topUnitName = "";
    private List<String> variables;
    private JPanel advancedFilesPanel;
    private JPanel advancedVariablesPanel;
    private JPanel advancedAnalysePanel;
    private JPanel integerPanel;
    private JPanel realPanel;
    private JPanel doublePanel;
    private OutputPanel outputPanel;
    private OptionPanel optionPanel;
    private JPanel outputLanguagePanel;
    private ExtFilesPanel extFilePanel;
    private ExtFilesPanel extAdFilePanel;
    private JTabbedPane tabs;
    private JSplitPane split;
    private JRadioButton integerTwoBytesButton;
    private JRadioButton integerEightBytesButton;
    private JRadioButton realEightBytesButton;
    private JRadioButton doubleFourBytesButton;
    private JRadioButton doubleEightBytesButton;
    private int filesArgsIndex;

    private TapenadeFrame() {
        System.setProperty("java.util.prefs.syncInterval", "2000000");
        this.tapenadeInit = new InitFrame();
    }

    public static TapenadeFrame getInstance() {
        if (frame == null) {
            frame = new TapenadeFrame();
            frame.init();
        }
        return frame;
    }

    protected static void setBackground(Component c) {
        c.setBackground(new Color(204, 204, 255));
    }

    protected static void setFont(Component c) {
        c.setFont(new Font("dialog", 0, 11));
    }

    protected static int[] center(Window window) {
        int[] i = new int[2];
        Dimension dim = window.getToolkit().getScreenSize();
        Rectangle abounds = window.getBounds();
        i[0] = (dim.width - abounds.width) / 2;
        i[1] = (dim.height - abounds.height) / 2;
        return i;
    }

    private void init() {
        this.initialize();
        this.toFront();
        this.tapenadeInit.setVisible(false);
        this.tapenadeInit = null;
    }

    private void initialize() {
        TapenadeFrame.setBackground(this);
        this.setTitle("Tapenade");
        this.setName("Tapenade");
        TapenadeFrame.setFont(this);
        this.setSize(450, 500);
        this.setResizable(false);
        this.setJMenuBar(new JMenuBar());
        this.getJMenuBar().setBorder(BorderFactory.createBevelBorder(0));
        this.getJMenuBar().add(this.getMenu());
        TapenadeFrame.setBackground(this.getJMenuBar());
        this.setDefaultCloseOperation(3);
        InputStream in = this.getClass().getResourceAsStream("/images/tapenadelogo.gif");
        byte[] buffer = null;
        try {
            buffer = new byte[in.available()];
            int n = in.available();
            for (int i = 0; i < n; ++i) {
                buffer[i] = (byte)in.read();
            }
        }
        catch (IOException e) {
            System.out.println("File not found: tapenadelogo.gif " + e);
        }
        if (buffer != null) {
            this.setIconImage(new ImageIcon(buffer).getImage());
        }
        this.getAdvancedPanel();
        this.setContentPane(this.getMainPanel());
        int[] center = TapenadeFrame.center(this);
        this.setLocation(center[0], center[1]);
        this.setVisible(true);
        this.pack();
        this.validate();
    }

    private JMenu getMenu() {
        if (this.menu == null) {
            this.menu = new JMenu();
            this.menu.setText("File");
            this.menu.setOpaque(false);
            JMenuItem exitItem = new JMenuItem();
            exitItem.setText("Quit");
            TapenadeFrame.setBackground(exitItem);
            exitItem.addActionListener(new MyActionListener());
            this.menu.add(exitItem);
        }
        return this.menu;
    }

    private JPanel getAdvancedPanel() {
        if (this.advancedPanel == null) {
            this.advancedPanel = new JPanel();
            this.tabs = new JTabbedPane();
            TapenadeFrame.setBackground(this.advancedPanel);
            TapenadeFrame.setBackground(this.tabs);
            this.advancedPanel.setLayout(new GridBagLayout());
        }
        this.tabs.addTab("Files", this.getAdvancedFilesPanel());
        this.tabs.addTab("Variables", this.getAdvancedVariablesPanel());
        this.tabs.addTab("Analysis", this.getAdvancedAnalysePanel());
        GridBagConstraints constraintsTabsPanel = new GridBagConstraints();
        constraintsTabsPanel.gridx = 0;
        constraintsTabsPanel.gridy = 0;
        constraintsTabsPanel.gridwidth = 1;
        constraintsTabsPanel.fill = 1;
        constraintsTabsPanel.weightx = 1.0;
        constraintsTabsPanel.weighty = 1.0;
        constraintsTabsPanel.insets = new Insets(4, 4, 4, 4);
        this.advancedPanel.add((Component)this.tabs, constraintsTabsPanel);
        GridBagConstraints constraintsControlPanel = new GridBagConstraints();
        constraintsControlPanel.gridx = 0;
        constraintsControlPanel.gridy = 1;
        constraintsControlPanel.gridwidth = 1;
        constraintsControlPanel.fill = 1;
        constraintsControlPanel.weightx = 1.0;
        constraintsControlPanel.weighty = 0.3;
        constraintsControlPanel.insets = new Insets(4, 4, 4, 4);
        this.advancedPanel.add((Component)this.getControlPanel(), constraintsControlPanel);
        this.advancedPanel.updateUI();
        return this.advancedPanel;
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            TapenadeFrame.setBackground(this.mainPanel);
            TapenadeFrame.setFont(this.mainPanel);
            this.split.setDividerSize(0);
            this.split.setOpaque(false);
        }
        GridBagConstraints constraintsInputLanguagePanel = new GridBagConstraints();
        constraintsInputLanguagePanel.gridx = 0;
        constraintsInputLanguagePanel.gridy = 0;
        constraintsInputLanguagePanel.gridwidth = 2;
        constraintsInputLanguagePanel.fill = 1;
        constraintsInputLanguagePanel.weightx = 1.0;
        constraintsInputLanguagePanel.weighty = 0.3;
        constraintsInputLanguagePanel.insets = new Insets(4, 4, 4, 4);
        this.mainPanel.add((Component)this.getInputLanguagePanel(), constraintsInputLanguagePanel);
        GridBagConstraints constraintsTopUnitPanel = new GridBagConstraints();
        constraintsTopUnitPanel.gridx = 0;
        constraintsTopUnitPanel.gridy = 1;
        constraintsTopUnitPanel.fill = 1;
        constraintsTopUnitPanel.weightx = 0.2;
        constraintsTopUnitPanel.weighty = 0.9;
        constraintsTopUnitPanel.insets = new Insets(4, 4, 4, 4);
        this.split.setRightComponent(this.getTopUnitPanel());
        GridBagConstraints constraintsIncludesPanel = new GridBagConstraints();
        constraintsIncludesPanel.gridx = 1;
        constraintsIncludesPanel.gridy = 1;
        constraintsIncludesPanel.fill = 1;
        constraintsIncludesPanel.weightx = 1.8;
        constraintsIncludesPanel.weighty = 0.9;
        constraintsIncludesPanel.insets = new Insets(4, 4, 4, 4);
        this.split.setLeftComponent(this.getFilesPanel());
        GridBagConstraints constraintsSplitPanel = new GridBagConstraints();
        constraintsSplitPanel.gridx = 0;
        constraintsSplitPanel.gridy = 1;
        constraintsSplitPanel.fill = 1;
        constraintsSplitPanel.gridwidth = 2;
        constraintsSplitPanel.weightx = 1.0;
        constraintsSplitPanel.weighty = 1.0;
        constraintsSplitPanel.insets = new Insets(4, 4, 4, 4);
        this.mainPanel.add((Component)this.split, constraintsSplitPanel);
        GridBagConstraints constraintsInputVariablesPanel = new GridBagConstraints();
        constraintsInputVariablesPanel.gridx = 0;
        constraintsInputVariablesPanel.gridy = 2;
        constraintsInputVariablesPanel.fill = 1;
        constraintsInputVariablesPanel.weightx = 0.5;
        constraintsInputVariablesPanel.weighty = 0.9;
        constraintsInputVariablesPanel.insets = new Insets(4, 4, 4, 4);
        this.mainPanel.add((Component)this.getInputVariablesPanel(), constraintsInputVariablesPanel);
        GridBagConstraints constraintsOutputVariablesPanel = new GridBagConstraints();
        constraintsOutputVariablesPanel.gridx = 1;
        constraintsOutputVariablesPanel.gridy = 2;
        constraintsOutputVariablesPanel.fill = 1;
        constraintsOutputVariablesPanel.weightx = 0.5;
        constraintsOutputVariablesPanel.weighty = 0.9;
        constraintsOutputVariablesPanel.insets = new Insets(4, 4, 4, 4);
        this.mainPanel.add((Component)this.getOutputVariablesPanel(), constraintsOutputVariablesPanel);
        GridBagConstraints constraintsAnalyseModePanel = new GridBagConstraints();
        constraintsAnalyseModePanel.gridx = 0;
        constraintsAnalyseModePanel.gridy = 3;
        constraintsAnalyseModePanel.gridwidth = 2;
        constraintsAnalyseModePanel.fill = 1;
        constraintsAnalyseModePanel.weightx = 1.0;
        constraintsAnalyseModePanel.weighty = 0.3;
        constraintsAnalyseModePanel.insets = new Insets(4, 4, 4, 4);
        this.mainPanel.add((Component)this.getAnalyseModePanel(), constraintsAnalyseModePanel);
        GridBagConstraints constraintsControlPanel = new GridBagConstraints();
        constraintsControlPanel.gridx = 0;
        constraintsControlPanel.gridy = 4;
        constraintsControlPanel.gridwidth = 2;
        constraintsControlPanel.fill = 1;
        constraintsControlPanel.weightx = 1.0;
        constraintsControlPanel.weighty = 0.3;
        constraintsControlPanel.insets = new Insets(4, 4, 4, 4);
        this.mainPanel.add((Component)this.getControlPanel(), constraintsControlPanel);
        return this.mainPanel;
    }

    private JPanel getAdvancedFilesPanel() {
        if (this.advancedFilesPanel == null) {
            this.advancedFilesPanel = new JPanel();
            TapenadeFrame.setBackground(this.advancedFilesPanel);
            this.advancedFilesPanel.setLayout(new GridBagLayout());
            this.split = new JSplitPane();
            this.split.setDividerSize(0);
            this.split.setOpaque(false);
        }
        GridBagConstraints constraintsInputLanguagePanel = new GridBagConstraints();
        constraintsInputLanguagePanel.gridx = 0;
        constraintsInputLanguagePanel.gridy = 0;
        constraintsInputLanguagePanel.gridwidth = 2;
        constraintsInputLanguagePanel.fill = 2;
        constraintsInputLanguagePanel.weightx = 1.0;
        constraintsInputLanguagePanel.weighty = 0.3;
        constraintsInputLanguagePanel.insets = new Insets(4, 4, 4, 4);
        this.advancedFilesPanel.add((Component)this.getInputLanguagePanel(), constraintsInputLanguagePanel);
        this.split.setLeftComponent(this.getTopUnitPanel());
        this.split.setRightComponent(this.getFilesPanel());
        GridBagConstraints constraintsSplitPanel = new GridBagConstraints();
        constraintsSplitPanel.gridx = 0;
        constraintsSplitPanel.gridy = 1;
        constraintsSplitPanel.fill = 2;
        constraintsSplitPanel.gridwidth = 2;
        constraintsSplitPanel.weightx = 1.0;
        constraintsSplitPanel.weighty = 1.0;
        constraintsSplitPanel.insets = new Insets(4, 4, 4, 4);
        this.advancedFilesPanel.add((Component)this.split, constraintsSplitPanel);
        GridBagConstraints constraintsExtFilesPanel = new GridBagConstraints();
        constraintsExtFilesPanel.gridx = 0;
        constraintsExtFilesPanel.gridy = 2;
        constraintsExtFilesPanel.fill = 2;
        constraintsExtFilesPanel.gridwidth = 1;
        constraintsExtFilesPanel.weightx = 1.0;
        constraintsExtFilesPanel.weighty = 1.0;
        constraintsExtFilesPanel.insets = new Insets(4, 4, 4, 4);
        this.advancedFilesPanel.add((Component)this.getExtFilesPanel(), constraintsExtFilesPanel);
        GridBagConstraints constraintsExtAdFilesPanel = new GridBagConstraints();
        constraintsExtAdFilesPanel.gridx = 1;
        constraintsExtAdFilesPanel.gridy = 2;
        constraintsExtAdFilesPanel.fill = 2;
        constraintsExtAdFilesPanel.gridwidth = 1;
        constraintsExtAdFilesPanel.weightx = 1.0;
        constraintsExtAdFilesPanel.weighty = 1.0;
        constraintsExtAdFilesPanel.insets = new Insets(4, 4, 4, 4);
        this.advancedFilesPanel.add((Component)this.getExtAdFilesPanel(), constraintsExtAdFilesPanel);
        return this.advancedFilesPanel;
    }

    private JPanel getAdvancedVariablesPanel() {
        if (this.advancedVariablesPanel == null) {
            this.advancedVariablesPanel = new JPanel();
            this.advancedVariablesPanel.setLayout(new GridBagLayout());
            TapenadeFrame.setBackground(this.advancedVariablesPanel);
        }
        GridBagConstraints constraintsInputVariablesPanel = new GridBagConstraints();
        constraintsInputVariablesPanel.gridx = 0;
        constraintsInputVariablesPanel.gridy = 0;
        constraintsInputVariablesPanel.fill = 2;
        constraintsInputVariablesPanel.weightx = 0.5;
        constraintsInputVariablesPanel.weighty = 0.9;
        constraintsInputVariablesPanel.insets = new Insets(4, 4, 4, 4);
        this.advancedVariablesPanel.add((Component)this.getInputVariablesPanel(), constraintsInputVariablesPanel);
        GridBagConstraints constraintsOutputVariablesPanel = new GridBagConstraints();
        constraintsOutputVariablesPanel.gridx = 1;
        constraintsOutputVariablesPanel.gridy = 0;
        constraintsOutputVariablesPanel.fill = 2;
        constraintsOutputVariablesPanel.weightx = 0.5;
        constraintsOutputVariablesPanel.weighty = 0.9;
        constraintsOutputVariablesPanel.insets = new Insets(4, 4, 4, 4);
        this.advancedVariablesPanel.add((Component)this.getOutputVariablesPanel(), constraintsOutputVariablesPanel);
        GridBagConstraints constraintsIntegerPanel = new GridBagConstraints();
        constraintsIntegerPanel.gridx = 0;
        constraintsIntegerPanel.gridy = 1;
        constraintsIntegerPanel.fill = 2;
        constraintsIntegerPanel.weightx = 1.0;
        constraintsIntegerPanel.weighty = 0.3;
        constraintsIntegerPanel.insets = new Insets(4, 4, 4, 4);
        this.advancedVariablesPanel.add((Component)this.getIntegerPanel(), constraintsIntegerPanel);
        GridBagConstraints constraintsRealPanel = new GridBagConstraints();
        constraintsRealPanel.gridx = 1;
        constraintsRealPanel.gridy = 1;
        constraintsRealPanel.fill = 2;
        constraintsRealPanel.weightx = 1.0;
        constraintsRealPanel.weighty = 0.3;
        constraintsRealPanel.insets = new Insets(4, 4, 4, 4);
        this.advancedVariablesPanel.add((Component)this.getRealPanel(), constraintsRealPanel);
        GridBagConstraints constraintsDoublePanel = new GridBagConstraints();
        constraintsDoublePanel.gridx = 0;
        constraintsDoublePanel.gridy = 2;
        constraintsDoublePanel.fill = 2;
        constraintsDoublePanel.weightx = 1.0;
        constraintsDoublePanel.weighty = 0.3;
        constraintsDoublePanel.insets = new Insets(4, 4, 4, 4);
        this.advancedVariablesPanel.add((Component)this.getDoublePanel(), constraintsDoublePanel);
        return this.advancedVariablesPanel;
    }

    private JPanel getAdvancedAnalysePanel() {
        if (this.advancedAnalysePanel == null) {
            this.advancedAnalysePanel = new JPanel();
            TapenadeFrame.setBackground(this.advancedAnalysePanel);
            this.advancedAnalysePanel.setLayout(new GridBagLayout());
        }
        GridBagConstraints constraintsAnalyseModePanel = new GridBagConstraints();
        constraintsAnalyseModePanel.gridx = 0;
        constraintsAnalyseModePanel.gridy = 0;
        constraintsAnalyseModePanel.gridwidth = 1;
        constraintsAnalyseModePanel.fill = 2;
        constraintsAnalyseModePanel.weightx = 1.0;
        constraintsAnalyseModePanel.weighty = 0.9;
        constraintsAnalyseModePanel.insets = new Insets(4, 4, 4, 4);
        this.advancedAnalysePanel.add((Component)this.getAnalyseModePanel(), constraintsAnalyseModePanel);
        GridBagConstraints constraintsOutputLanguagePanel = new GridBagConstraints();
        constraintsOutputLanguagePanel.gridx = 0;
        constraintsOutputLanguagePanel.gridy = 1;
        constraintsOutputLanguagePanel.gridwidth = 1;
        constraintsOutputLanguagePanel.fill = 2;
        constraintsOutputLanguagePanel.weightx = 1.0;
        constraintsOutputLanguagePanel.weighty = 0.9;
        constraintsOutputLanguagePanel.insets = new Insets(4, 4, 4, 4);
        this.advancedAnalysePanel.add((Component)this.getOutputLanguagePanel(), constraintsOutputLanguagePanel);
        JSplitPane splitPane = new JSplitPane();
        splitPane.setDividerSize(0);
        splitPane.setOpaque(false);
        splitPane.setBorder(null);
        splitPane.setLeftComponent(this.getOutputPanel());
        splitPane.setRightComponent(this.getOptionPanel());
        GridBagConstraints constraintsSplit = new GridBagConstraints();
        constraintsSplit.gridx = 0;
        constraintsSplit.gridy = 2;
        constraintsSplit.gridwidth = 1;
        constraintsSplit.gridheight = 1;
        constraintsSplit.fill = 2;
        constraintsSplit.weightx = 1.0;
        constraintsSplit.weighty = 1.0;
        constraintsSplit.insets = new Insets(4, 4, 4, 4);
        this.advancedAnalysePanel.add((Component)splitPane, constraintsSplit);
        return this.advancedAnalysePanel;
    }

    protected ControlPanel getControlPanel() {
        if (this.controlPanel == null) {
            this.controlPanel = new ControlPanel();
        }
        return this.controlPanel;
    }

    private InputLanguagePanel getInputLanguagePanel() {
        if (this.inputLanguagePanel == null) {
            this.inputLanguagePanel = new InputLanguagePanel();
        }
        return this.inputLanguagePanel;
    }

    protected TopUnitPanel getTopUnitPanel() {
        if (this.topUnitPanel == null) {
            this.topUnitPanel = new TopUnitPanel();
        }
        return this.topUnitPanel;
    }

    private FilesPanel getFilesPanel() {
        if (this.filesPanel == null) {
            this.filesPanel = new FilesPanel();
        }
        return this.filesPanel;
    }

    protected VariablesPanel getInputVariablesPanel() {
        if (this.inputVariablesPanel == null) {
            this.inputVariablesPanel = new VariablesPanel(1);
        }
        return this.inputVariablesPanel;
    }

    protected VariablesPanel getOutputVariablesPanel() {
        if (this.outputVariablesPanel == null) {
            this.outputVariablesPanel = new VariablesPanel(0);
        }
        return this.outputVariablesPanel;
    }

    protected AnalyseModePanel getAnalyseModePanel() {
        if (this.analyseModePanel == null) {
            this.analyseModePanel = new AnalyseModePanel();
        }
        return this.analyseModePanel;
    }

    private JPanel getExtFilesPanel() {
        if (this.extFilePanel == null) {
            this.extFilePanel = new ExtFilesPanel(0);
        }
        return this.extFilePanel;
    }

    private JPanel getExtAdFilesPanel() {
        if (this.extAdFilePanel == null) {
            this.extAdFilePanel = new ExtFilesPanel(1);
        }
        return this.extAdFilePanel;
    }

    private JPanel getIntegerPanel() {
        if (this.integerPanel == null) {
            this.integerPanel = new JPanel();
            this.integerPanel.setOpaque(false);
            this.integerPanel.setLayout(new FlowLayout(1));
            this.integerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Integer Precision"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.integerTwoBytesButton = new JRadioButton("2 bytes");
            JRadioButton integerFourBytesButton = new JRadioButton("4 bytes");
            this.integerEightBytesButton = new JRadioButton("8 bytes");
            TapenadeFrame.setFont(this.integerTwoBytesButton);
            TapenadeFrame.setFont(integerFourBytesButton);
            TapenadeFrame.setFont(this.integerEightBytesButton);
            integerFourBytesButton.setSelected(true);
            this.integerTwoBytesButton.setSelected(false);
            this.integerEightBytesButton.setSelected(false);
            integerFourBytesButton.setOpaque(false);
            this.integerTwoBytesButton.setOpaque(false);
            this.integerEightBytesButton.setOpaque(false);
            ButtonGroup integerButtonGroup = new ButtonGroup();
            integerButtonGroup.add(this.integerTwoBytesButton);
            integerButtonGroup.add(integerFourBytesButton);
            integerButtonGroup.add(this.integerEightBytesButton);
            this.integerPanel.add(this.integerTwoBytesButton);
            this.integerPanel.add(integerFourBytesButton);
            this.integerPanel.add(this.integerEightBytesButton);
        }
        return this.integerPanel;
    }

    private JPanel getRealPanel() {
        if (this.realPanel == null) {
            this.realPanel = new JPanel();
            this.realPanel.setOpaque(false);
            this.realPanel.setLayout(new FlowLayout(1));
            this.realPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Real Precision"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            JRadioButton realFourBytesButton = new JRadioButton("4 bytes");
            this.realEightBytesButton = new JRadioButton("8 bytes");
            TapenadeFrame.setFont(realFourBytesButton);
            TapenadeFrame.setFont(this.realEightBytesButton);
            realFourBytesButton.setSelected(true);
            this.realEightBytesButton.setSelected(false);
            realFourBytesButton.setOpaque(false);
            this.realEightBytesButton.setOpaque(false);
            ButtonGroup realButtonGroup = new ButtonGroup();
            realButtonGroup.add(realFourBytesButton);
            realButtonGroup.add(this.realEightBytesButton);
            this.realPanel.add(realFourBytesButton);
            this.realPanel.add(this.realEightBytesButton);
        }
        return this.realPanel;
    }

    private JPanel getDoublePanel() {
        if (this.doublePanel == null) {
            this.doublePanel = new JPanel();
            this.doublePanel.setOpaque(false);
            this.doublePanel.setLayout(new FlowLayout(1));
            this.doublePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Double Precision"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.doubleFourBytesButton = new JRadioButton("4 bytes");
            this.doubleEightBytesButton = new JRadioButton("8 bytes");
            JRadioButton doubleSixteenBytesButton = new JRadioButton("16 bytes");
            TapenadeFrame.setFont(doubleSixteenBytesButton);
            TapenadeFrame.setFont(this.doubleFourBytesButton);
            TapenadeFrame.setFont(this.doubleEightBytesButton);
            this.doubleFourBytesButton.setSelected(false);
            doubleSixteenBytesButton.setSelected(false);
            this.doubleEightBytesButton.setSelected(true);
            this.doubleFourBytesButton.setOpaque(false);
            doubleSixteenBytesButton.setOpaque(false);
            this.doubleEightBytesButton.setOpaque(false);
            ButtonGroup doubleButtonGroup = new ButtonGroup();
            doubleButtonGroup.add(this.doubleFourBytesButton);
            doubleButtonGroup.add(this.doubleEightBytesButton);
            doubleButtonGroup.add(doubleSixteenBytesButton);
            this.doublePanel.add(this.doubleFourBytesButton);
            this.doublePanel.add(this.doubleEightBytesButton);
            this.doublePanel.add(doubleSixteenBytesButton);
        }
        return this.doublePanel;
    }

    private JPanel getOutputLanguagePanel() {
        if (this.outputLanguagePanel == null) {
            this.outputLanguagePanel = new OutputLanguagePanel();
        }
        return this.outputLanguagePanel;
    }

    private JPanel getOutputPanel() {
        if (this.outputPanel == null) {
            this.outputPanel = new OutputPanel();
        }
        return this.outputPanel;
    }

    private JPanel getOptionPanel() {
        if (this.optionPanel == null) {
            this.optionPanel = new OptionPanel();
        }
        return this.optionPanel;
    }

    protected void setTopUnitName(String name) {
        this.topUnitName = name;
    }

    protected CallGraph getCallGraph() {
        return this.callGraph;
    }

    protected void runTapenade() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-parserfileseparator");
        args.add(File.separator);
        this.selectOutput(args);
        this.selectInputLanguage(args);
        this.selectOutputVariables(args);
        this.selectInputVariables(args);
        this.selectTopUnit(args);
        this.selectAnalyseMode(args);
        this.selectOutputLanguage(args);
        this.selectPreprocess(args);
        this.selectOutputFileName(args);
        this.selectOutputDirectory(args);
        this.selectExtFiles(args);
        this.selectExtAdFiles(args);
        this.selectNoLib(args);
        this.selectNoAdLib(args);
        this.selectDiffVarName(args);
        this.selectDiffFuncName(args);
        this.selectInteger(args);
        this.selectDouble(args);
        this.selectReal(args);
        this.selectMsgLevel(args);
        this.selectView(args);
        this.selectDump(args);
        this.selectFiles(args);
        StringBuilder tapCommand = new StringBuilder("tapenade ");
        String prefix = null;
        String suffix = null;
        for (int i = 0; i < args.size(); ++i) {
            if (prefix == null) {
                if (i < this.filesArgsIndex && args.get(i).startsWith("-") && !args.get(i + 1).startsWith("-") && i + 1 < this.filesArgsIndex) {
                    prefix = "\"";
                    suffix = "\"";
                }
                tapCommand.append(args.get(i));
                tapCommand.append(' ');
                continue;
            }
            tapCommand.append(prefix);
            tapCommand.append(args.get(i));
            tapCommand.append(suffix);
            tapCommand.append(' ');
            suffix = null;
            prefix = null;
        }
        System.out.println(tapCommand);
        Tapenade.main(args.toArray(new String[0]));
    }

    private void selectOutput(List<String> args) {
        if (this.getControlPanel().getHtmlCheckBox().isSelected()) {
            args.add("-html");
        }
    }

    private void selectInputLanguage(List<String> args) {
        Enumeration<AbstractButton> enumeration = this.getInputLanguagePanel().getInputLanguageButtons().getElements();
        while (enumeration.hasMoreElements()) {
            JRadioButton button = (JRadioButton)enumeration.nextElement();
            if (!button.isSelected()) continue;
            if (button.getName().equals("suffix")) break;
            args.add("-inputlanguage");
            args.add(button.getText());
            break;
        }
    }

    private void selectOutputVariables(List<String> args) {
        StringBuilder outputVariables = new StringBuilder();
        DefaultListModel model = (DefaultListModel)this.getOutputVariablesPanel().getVariablesList().getModel();
        Enumeration e = model.elements();
        while (e.hasMoreElements()) {
            outputVariables.append((String)e.nextElement());
            if (!e.hasMoreElements()) continue;
            outputVariables.append(' ');
        }
        if (outputVariables.length() != 0) {
            args.add("-outvars");
            args.add(outputVariables.toString());
        }
    }

    private void selectInputVariables(List<String> args) {
        StringBuilder inputVariables = new StringBuilder();
        DefaultListModel model = (DefaultListModel)this.getInputVariablesPanel().getVariablesList().getModel();
        Enumeration e = model.elements();
        while (e.hasMoreElements()) {
            inputVariables.append((String)e.nextElement());
            if (!e.hasMoreElements()) continue;
            inputVariables.append(' ');
        }
        if (inputVariables.length() != 0) {
            args.add("-vars");
            args.add(inputVariables.toString());
        }
    }

    private void selectTopUnit(List<String> args) {
        String unitName = (String)this.getTopUnitPanel().getUnits().getSelectedItem();
        if (!Objects.requireNonNull(unitName).isEmpty()) {
            args.add("-head");
            args.add(unitName);
        }
    }

    private void selectAnalyseMode(List<String> args) {
        Enumeration<AbstractButton> differentiateEnum = this.getAnalyseModePanel().getDifferentiateButtons().getElements();
        while (differentiateEnum.hasMoreElements()) {
            JRadioButton button = (JRadioButton)differentiateEnum.nextElement();
            if (!button.isSelected()) continue;
            switch (button.getName()) {
                case "tangent": {
                    args.add("-tangent");
                    break;
                }
                case "reverse": {
                    args.add("-reverse");
                    break;
                }
                case "tangentVector": {
                    args.add("-tangent");
                    args.add("-multi");
                    break;
                }
                case "reverseVector": {
                    args.add("-reverse");
                    args.add("-multi");
                    break;
                }
            }
        }
    }

    private void selectOutputLanguage(List<String> args) {
        Enumeration<AbstractButton> outputLanguageEnum = ((OutputLanguagePanel)this.getOutputLanguagePanel()).getOutputLanguageButtons().getElements();
        while (outputLanguageEnum.hasMoreElements()) {
            JRadioButton button = (JRadioButton)outputLanguageEnum.nextElement();
            if (!button.isSelected()) continue;
            args.add("-outputlanguage");
            args.add(button.getName());
            break;
        }
    }

    private void selectPreprocess(List<String> args) {
        if (((OptionPanel)this.getOptionPanel()).getPreprocessCheckBox().isSelected()) {
            args.add("-p");
        }
    }

    private void selectOutputFileName(List<String> args) {
        String filename;
        if (((OutputPanel)this.getOutputPanel()).getOutputFileNameCheckBox().isSelected() && !(filename = ((OutputPanel)this.getOutputPanel()).getOutputFileNameTextField().getText()).isEmpty()) {
            args.add("-o");
            args.add(filename);
        }
    }

    private void selectOutputDirectory(List<String> args) {
        if (!((OutputPanel)this.getOutputPanel()).getOutputDirectoryTextField().getText().isEmpty()) {
            args.add("-O");
            args.add(((OutputPanel)this.getOutputPanel()).getOutputDirectoryTextField().getText());
        }
    }

    private void selectExtFiles(List<String> args) {
        Enumeration e = ((DefaultListModel)((ExtFilesPanel)this.getExtFilesPanel()).getFilesList().getModel()).elements();
        if (!e.hasMoreElements()) {
            return;
        }
        args.add("-ext");
        StringBuilder files = new StringBuilder();
        while (e.hasMoreElements()) {
            File file = (File)e.nextElement();
            files.append(file.getPath());
            if (!e.hasMoreElements()) continue;
            files.append('+');
        }
        args.add(files.toString());
    }

    private void selectExtAdFiles(List<String> args) {
        Enumeration e = ((DefaultListModel)((ExtFilesPanel)this.getExtAdFilesPanel()).getFilesList().getModel()).elements();
        if (!e.hasMoreElements()) {
            return;
        }
        args.add("-ext");
        StringBuilder files = new StringBuilder();
        while (e.hasMoreElements()) {
            File file = (File)e.nextElement();
            files.append(file.getPath());
            if (!e.hasMoreElements()) continue;
            files.append('+');
        }
        args.add(files.toString());
    }

    private void selectNoLib(List<String> args) {
        if (((ExtFilesPanel)this.getExtFilesPanel()).getNoLibCheckBox().isSelected()) {
            args.add("-nolib");
        }
    }

    private void selectNoAdLib(List<String> args) {
        if (((ExtFilesPanel)this.getExtFilesPanel()).getNoLibCheckBox().isSelected()) {
            args.add("-noADlib");
        }
    }

    private void selectDiffVarName(List<String> args) {
        String diffVarname;
        if (((OutputPanel)this.getOutputPanel()).getDiffVarNameCheckBox().isSelected() && !(diffVarname = ((OutputPanel)this.getOutputPanel()).getdiffVarNameTextField().getText()).isEmpty()) {
            args.add("-diffvarname");
            args.add(diffVarname);
        }
    }

    private void selectDiffFuncName(List<String> args) {
        String diffFuncname;
        if (((OutputPanel)this.getOutputPanel()).getDiffFuncNameCheckBox().isSelected() && !(diffFuncname = ((OutputPanel)this.getOutputPanel()).getDiffFuncNameTextField().getText()).isEmpty()) {
            args.add("-difffuncname");
            args.add(diffFuncname);
        }
    }

    private void selectInteger(List<String> args) {
        String integer = this.integerEightBytesButton.isSelected() ? "8" : (this.integerTwoBytesButton.isSelected() ? "2" : "4");
        args.add("-i" + integer);
    }

    private void selectDouble(List<String> args) {
        String doubleString = this.doubleEightBytesButton.isSelected() ? "8" : (this.doubleFourBytesButton.isSelected() ? "4" : "16");
        args.add("-dr" + doubleString);
    }

    private void selectReal(List<String> args) {
        String real = this.realEightBytesButton.isSelected() ? "8" : "4";
        args.add("-r" + real);
    }

    private void selectMsgLevel(List<String> args) {
        if (((OptionPanel)this.getOptionPanel()).getMsgLevelCheckBox().isSelected()) {
            args.add("-msglevel");
            String level = Objects.requireNonNull(((OptionPanel)this.getOptionPanel()).getMsgLevelComboBox().getSelectedItem()).toString();
            args.add(level);
        }
    }

    private void selectView(List<String> args) {
        if (((OptionPanel)this.getOptionPanel()).getViewCheckBox().isSelected()) {
            args.add("-view");
        }
    }

    private void selectDump(List<String> args) {
        String filename;
        if (((OptionPanel)this.getOptionPanel()).getDump().isSelected() && !(filename = ((OptionPanel)this.getOptionPanel()).getDumpFile().getText()).isEmpty()) {
            args.add("-dump");
            args.add(filename);
        }
    }

    private void selectFiles(List<String> args) {
        Enumeration filesEnum = ((DefaultListModel)this.getFilesPanel().getFilesList().getModel()).elements();
        this.filesArgsIndex = args.size();
        while (filesEnum.hasMoreElements()) {
            File file = (File)filesEnum.nextElement();
            args.add(file.getPath());
        }
    }

    protected void preprocess() {
        ArrayList<String> args = new ArrayList<String>();
        this.selectInputLanguage(args);
        this.selectFiles(args);
        this.callGraph = Tapenade.preProcess(args.toArray(new String[0]));
        TapList<Unit> units = this.callGraph.units();
        while (units != null) {
            Unit unit = (Unit)units.head;
            if (!unit.isExternal() && !unit.isTranslationUnit()) {
                this.getTopUnitPanel().getUnits().addItem(((Unit)units.head).name());
            }
            units = units.tail;
        }
        if (!this.topUnitName.isEmpty()) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.getTopUnitPanel().getUnits().getModel();
            int size = model.getSize();
            boolean presence = false;
            for (int i = 0; i < size; ++i) {
                String unitName = (String)model.getElementAt(i);
                if (!unitName.equals(this.topUnitName)) continue;
                this.getTopUnitPanel().getUnits().setSelectedIndex(i);
                presence = true;
                break;
            }
            if (!presence) {
                ((DefaultListModel)this.getInputVariablesPanel().getVariablesList().getModel()).removeAllElements();
                ((DefaultListModel)this.getOutputVariablesPanel().getVariablesList().getModel()).removeAllElements();
            }
        } else {
            String unitName = "";
            TapList<Unit> topUnits = this.callGraph.topUnits();
            while (topUnits != null) {
                Unit topUnit = (Unit)topUnits.head;
                if (topUnit.isStandard()) {
                    unitName = topUnit.name();
                    break;
                }
                topUnits = topUnits.tail;
            }
            this.topUnitName = unitName;
        }
    }

    protected void buildExternalContext(Unit unit) {
        List<String> vars = this.getVariables();
        vars.clear();
        for (int i = 0; i < unit.paramElemsNb(); ++i) {
            ZoneInfo zi = unit.paramElemZoneInfo(i);
            if (!zi.isCommon() && !zi.isParameter() && !zi.isGlobal()) continue;
            TapList<String> varNames = zi.variableNames();
            while (varNames != null) {
                vars.add((String)varNames.head);
                varNames = varNames.tail;
            }
        }
    }

    protected List<String> getVariables() {
        if (this.variables == null) {
            this.variables = new ArrayList<String>();
        }
        return this.variables;
    }

    protected void changeMode(boolean mode) {
        if (mode) {
            this.setContentPane(this.getAdvancedPanel());
        } else {
            this.setContentPane(this.getMainPanel());
        }
        this.pack();
    }
}

