/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.graphicsutils;

import fr.inria.tapenade.graphicsutils.Node;
import fr.inria.tapenade.representation.CallArrow;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;

class UnitNode
extends Node {
    private static Color fg = new Color(0, 0, 0);
    private String text;
    private Color bg;
    private int topOrBottom;

    protected UnitNode(Unit unit) {
        String nodeName = unit.name();
        for (Unit containerUnit = unit.upperLevelUnit(); containerUnit != null; containerUnit = containerUnit.upperLevelUnit()) {
            nodeName = containerUnit.name() + ":" + nodeName;
        }
        this.text = nodeName;
        if (!UnitNode.callsOneCall(unit)) {
            this.topOrBottom = -1;
            this.bg = new Color(255, 255, 150);
        } else if (!UnitNode.calledByCall(unit)) {
            this.topOrBottom = 1;
            this.bg = new Color(255, 180, 180);
        } else {
            this.topOrBottom = 0;
            this.bg = new Color(150, 255, 250);
        }
    }

    private static boolean callsOneCall(Unit unit) {
        boolean calls = false;
        TapList<CallArrow> arrows = unit.callees();
        while (!calls && arrows != null) {
            calls = ((CallArrow)arrows.head).isCall();
            arrows = arrows.tail;
        }
        return calls;
    }

    private static boolean calledByCall(Unit unit) {
        boolean called = false;
        TapList<CallArrow> arrows = unit.callers();
        while (!called && arrows != null) {
            called = ((CallArrow)arrows.head).isCall();
            arrows = arrows.tail;
        }
        return called;
    }

    @Override
    protected void draw(Graphics graphics) {
        FontMetrics fm = graphics.getFontMetrics();
        graphics.setColor(this.bg);
        int w = fm.stringWidth(this.text) + 10;
        int h = fm.getHeight() + 2;
        this.w2 = (double)w / 2.0;
        this.h2 = (double)h / 2.0;
        graphics.fillRect((int)(this.x - (double)w / 2.0), (int)(this.y - (double)h / 2.0), w, h);
        graphics.setColor(fg);
        graphics.drawRect((int)(this.x - (double)w / 2.0), (int)(this.y - (double)h / 2.0), w, h);
        graphics.drawString(this.text, (int)(this.x - (double)(w - 10) / 2.0), (int)(this.y - (double)(h - 1) / 2.0) + fm.getAscent());
    }

    protected boolean isTopNode() {
        return this.topOrBottom == 1;
    }

    protected boolean isBottomNode() {
        return this.topOrBottom == -1;
    }
}

