/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.graphicsutils;

import fr.inria.tapenade.differentiation.NewBlockGraph;
import fr.inria.tapenade.differentiation.NewBlockGraphArrow;
import fr.inria.tapenade.differentiation.NewBlockGraphNode;
import fr.inria.tapenade.graphicsutils.BlockNode;
import fr.inria.tapenade.graphicsutils.DGNodeNode;
import fr.inria.tapenade.graphicsutils.Edge;
import fr.inria.tapenade.graphicsutils.EntryBlockNode;
import fr.inria.tapenade.graphicsutils.ExitBlockNode;
import fr.inria.tapenade.graphicsutils.GraphPanel;
import fr.inria.tapenade.graphicsutils.HeaderBlockNode;
import fr.inria.tapenade.graphicsutils.Node;
import fr.inria.tapenade.graphicsutils.UnitNode;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.CallArrow;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.HeaderBlock;
import fr.inria.tapenade.representation.LoopBlock;
import fr.inria.tapenade.representation.MPIcallInfo;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Panel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

class TapWindow {
    private final JLabel label = new JLabel();
    private final GraphPanel graphPanel = new GraphPanel();
    private Object displayedObject;
    private Object aboveObject;
    private int[] nodeIndexes;

    protected TapWindow() {
    }

    protected Component createComponents() {
        this.label.setText("Tapenade display");
        JPanel mainPanel = new JPanel();
        Panel controlPanel = new Panel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add((Component)this.label, "North");
        mainPanel.add((Component)this.graphPanel, "Center");
        mainPanel.add((Component)controlPanel, "South");
        JButton buttonDown = new JButton();
        buttonDown.setText("Down");
        controlPanel.add(buttonDown);
        buttonDown.addActionListener(e -> this.view(this.selectedObject()));
        JButton buttonUp = new JButton();
        buttonUp.setText("Up");
        controlPanel.add(buttonUp);
        buttonUp.addActionListener(e -> this.view(this.aboveObject));
        return mainPanel;
    }

    protected void view(Object tapObject) {
        this.graphPanel.reset();
        if (tapObject instanceof CallGraph) {
            CallArrow arrow;
            Unit unit;
            CallGraph callGraph = (CallGraph)tapObject;
            this.label.setText("CallGraph: " + callGraph.name());
            this.aboveObject = callGraph;
            this.displayedObject = callGraph;
            this.nodeIndexes = new int[callGraph.nbUnits()];
            TapList<Object> unitsToDump = null;
            for (int i = callGraph.nbUnits() - 1; i >= 0; --i) {
                unit = callGraph.sortedUnit(i);
                this.nodeIndexes[i] = -1;
                assert (unit != null);
                if (MPIcallInfo.isMessagePassingFunction(unit.name(), unit.language()) || unit.inStdCIncludeFile() || !unit.isStandard() && !unit.isExternal() && !unit.isModule()) continue;
                unitsToDump = new TapList<Unit>(unit, unitsToDump);
            }
            int nbUnitsToDump = TapList.length(unitsToDump);
            int nbEdgesToDump = 0;
            TapList inUnitsToDump = unitsToDump;
            while (inUnitsToDump != null) {
                unit = (Unit)inUnitsToDump.head;
                TapList<CallArrow> callArrows = unit.callees();
                while (callArrows != null) {
                    arrow = (CallArrow)callArrows.head;
                    Unit arrowDest = arrow.destination;
                    if (arrow.isCall() && (arrowDest.isStandard() || arrowDest.isExternal())) {
                        ++nbEdgesToDump;
                    }
                    callArrows = callArrows.tail;
                }
                inUnitsToDump = inUnitsToDump.tail;
            }
            this.graphPanel.nodes = new Node[callGraph.nbUnits()];
            this.graphPanel.edges = new Edge[nbEdgesToDump];
            inUnitsToDump = unitsToDump;
            int unitNb = 1;
            while (inUnitsToDump != null) {
                unit = (Unit)inUnitsToDump.head;
                if (unit.isStandard() || unit.isExternal()) {
                    this.nodeIndexes[unit.rank()] = this.graphPanel.addNode(new UnitNode(unit), 0.5, (double)unitNb / (double)nbUnitsToDump);
                    ++unitNb;
                }
                inUnitsToDump = inUnitsToDump.tail;
            }
            inUnitsToDump = unitsToDump;
            while (inUnitsToDump != null) {
                unit = (Unit)inUnitsToDump.head;
                int nbArrows = 0;
                TapList<CallArrow> callArrows = unit.callees();
                while (callArrows != null) {
                    arrow = (CallArrow)callArrows.head;
                    if (arrow.isCall() && this.nodeIndexes[arrow.destination().rank()] != -1) {
                        ++nbArrows;
                    }
                    callArrows = callArrows.tail;
                }
                unitNb = 1;
                callArrows = unit.callees();
                while (callArrows != null) {
                    arrow = (CallArrow)callArrows.head;
                    if (arrow.isCall() && this.nodeIndexes[arrow.destination().rank()] != -1) {
                        this.graphPanel.addEdge(this.nodeIndexes[arrow.origin().rank()], this.nodeIndexes[arrow.destination().rank()], new Edge(), 50 * (2 * unitNb - nbArrows - 1), 50);
                    }
                    callArrows = callArrows.tail;
                    ++unitNb;
                }
                inUnitsToDump = inUnitsToDump.tail;
            }
            this.graphPanel.start();
        } else if (tapObject instanceof Unit) {
            Unit unit = (Unit)tapObject;
            this.aboveObject = unit.callGraph();
            this.displayedObject = unit;
            this.nodeIndexes = new int[unit.nbBlocks + 2];
            TapList<Block> allBlocks = unit.allBlocks();
            this.graphPanel.nodes = new Node[100];
            this.graphPanel.edges = new Edge[200];
            if (unit.entryBlock() != null) {
                TapList<SymbolTable> displayedSymbolTables = new TapList<SymbolTable>(unit.entryBlock().symbolTable, null);
                try {
                    Block block;
                    ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                    TapEnv.pushOutputStream(byteStream);
                    this.label.setText("Unit : " + unit.name());
                    this.nodeIndexes[0] = this.graphPanel.addNode(new EntryBlockNode(unit.entryBlock(), byteStream, true), 0.5, 1.0 / (double)(unit.nbBlocks + 3));
                    while (allBlocks != null) {
                        boolean withDecls;
                        block = (Block)allBlocks.head;
                        if (TapList.contains(displayedSymbolTables, block.symbolTable)) {
                            withDecls = false;
                        } else {
                            withDecls = true;
                            displayedSymbolTables = new TapList<SymbolTable>(block.symbolTable, displayedSymbolTables);
                        }
                        BlockNode newNode = block instanceof HeaderBlock ? new HeaderBlockNode((HeaderBlock)block, byteStream, withDecls) : new BlockNode(block, byteStream, withDecls);
                        this.nodeIndexes[block.rank + 1] = this.graphPanel.addNode(newNode, 0.5, (double)(block.rank + 2) / (double)(unit.nbBlocks + 3));
                        allBlocks = allBlocks.tail;
                    }
                    this.nodeIndexes[unit.nbBlocks + 1] = this.graphPanel.addNode(new ExitBlockNode(unit.exitBlock()), 0.5, (double)(unit.nbBlocks + 2) / (double)(unit.nbBlocks + 3));
                    allBlocks = new TapList<Block>(unit.entryBlock(), unit.allBlocks());
                    while (allBlocks != null) {
                        block = (Block)allBlocks.head;
                        TapList<FGArrow> arrows = block.flow();
                        int nbArrows = TapList.length(arrows);
                        int i = 1;
                        while (arrows != null) {
                            FGArrow arrow = (FGArrow)arrows.head;
                            boolean loopsInLoop = arrow.destination instanceof HeaderBlock && this.isInLoop(block, (HeaderBlock)arrow.destination);
                            this.graphPanel.addEdge(this.nodeIndexes[block.rank + 1], this.nodeIndexes[arrow.destination.rank + 1], new Edge(), loopsInLoop ? 0 : 50 * (2 * i - nbArrows - 1), loopsInLoop ? 0 : 60);
                            arrows = arrows.tail;
                            ++i;
                        }
                        allBlocks = allBlocks.tail;
                    }
                    TapEnv.popOutputStream();
                    byteStream.close();
                    this.graphPanel.start();
                }
                catch (IOException e) {
                    System.out.println("byteStream broken " + e);
                }
            }
        } else if (tapObject instanceof NewBlockGraph) {
            NewBlockGraphNode node;
            int i;
            NewBlockGraph graph = (NewBlockGraph)tapObject;
            TapList<NewBlockGraphNode> nodes = graph.nodes;
            int nbNodes = TapList.length(nodes);
            this.aboveObject = graph;
            this.displayedObject = graph;
            this.nodeIndexes = new int[nbNodes];
            this.graphPanel.nodes = new Node[100];
            this.graphPanel.edges = new Edge[200];
            this.label.setText("Adjoint graph");
            for (i = 0; i < nbNodes; ++i) {
                node = (NewBlockGraphNode)nodes.head;
                nodes = nodes.tail;
                node.rank = i;
                this.nodeIndexes[i] = this.graphPanel.addNode(new DGNodeNode(node), 0.5, (double)(i + 1) / (double)(nbNodes + 1));
            }
            nodes = graph.nodes;
            for (i = 0; i < nbNodes; ++i) {
                node = (NewBlockGraphNode)nodes.head;
                nodes = nodes.tail;
                TapList<NewBlockGraphArrow> arrows = node.flow;
                while (arrows != null) {
                    NewBlockGraphArrow arrow = (NewBlockGraphArrow)arrows.head;
                    this.graphPanel.addEdge(this.nodeIndexes[arrow.origin().rank], this.nodeIndexes[arrow.destination().rank], new Edge(), 0, 50);
                    arrows = arrows.tail;
                }
            }
            this.graphPanel.start();
        } else {
            this.aboveObject = this.displayedObject;
            this.displayedObject = null;
            this.nodeIndexes = null;
        }
    }

    private Object selectedObject() {
        if (this.nodeIndexes != null && this.graphPanel.selectedIndex() >= 0) {
            int tapRank = -1;
            int graphRank = this.graphPanel.selectedIndex();
            for (int i = 0; i < this.nodeIndexes.length && tapRank == -1; ++i) {
                if (this.nodeIndexes[i] != graphRank) continue;
                tapRank = i;
            }
            if (tapRank >= 0) {
                if (this.displayedObject instanceof CallGraph) {
                    return ((CallGraph)this.displayedObject).sortedUnit(tapRank);
                }
                if (this.displayedObject instanceof Unit) {
                    Unit unit = (Unit)this.displayedObject;
                    if (tapRank <= 0) {
                        return unit.entryBlock();
                    }
                    if (tapRank >= unit.nbBlocks + 1) {
                        return unit.exitBlock();
                    }
                    return TapList.nth(unit.allBlocks(), tapRank - 1);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private boolean isInLoop(Block block, HeaderBlock header) {
        LoopBlock loop1 = header.enclosingLoop();
        boolean result = false;
        for (LoopBlock loop2 = block.enclosingLoop(); !result && loop2 != null; loop2 = loop2.enclosingLoop()) {
            if (loop2 != loop1) continue;
            result = true;
        }
        return result;
    }
}

