/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.graphicsutils;

import fr.inria.tapenade.graphicsutils.Edge;
import fr.inria.tapenade.graphicsutils.Node;
import fr.inria.tapenade.graphicsutils.UnitNode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

final class GraphPanel
extends Panel
implements Runnable,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1234056794876L;
    private int nnodes;
    protected Node[] nodes;
    private int nedges;
    protected Edge[] edges;
    private Thread relaxer;
    private Node selected;
    private Node pick;
    private boolean pickfixed;
    private Image offscreen;
    private Dimension offscreensize;
    private Graphics offgraphics;

    protected GraphPanel() {
        this.addMouseListener(this);
    }

    protected int selectedIndex() {
        if (this.selected != null) {
            for (int i = 0; i < this.nnodes; ++i) {
                if (this.nodes[i] != this.selected) continue;
                return i;
            }
        }
        return -1;
    }

    protected void reset() {
        this.nodes = null;
        this.edges = null;
        this.nnodes = 0;
        this.nedges = 0;
        this.repaint();
        this.selected = null;
        this.relaxer = null;
    }

    protected int addNode(Node n, double rx, double ry) {
        Dimension d = this.getSize();
        n.x = rx * (double)d.width + 20.0 * (Math.random() - 0.5);
        n.y = ry * (double)d.height + 20.0 * (Math.random() - 0.5);
        this.nodes[this.nnodes] = n;
        return this.nnodes++;
    }

    protected void addEdge(int fromIndex, int toIndex, Edge e, int idealX, int idealY) {
        e.from = this.nodes[fromIndex];
        e.to = this.nodes[toIndex];
        e.idealX = idealX;
        e.idealY = idealY;
        this.edges[this.nedges++] = e;
    }

    protected void start() {
        this.relaxer = new Thread(this);
        this.relaxer.start();
    }

    @Override
    public void run() {
        Thread me = Thread.currentThread();
        this.repaint();
        while (this.relaxer == me) {
            this.relax();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                System.out.println("GraphPanel InterruptedException");
                Thread.currentThread().interrupt();
            }
        }
    }

    private synchronized void relax() {
        Node node1;
        double deltaY;
        double deltaX;
        int i;
        Dimension d = this.getSize();
        int width = d.width;
        int height = d.height;
        for (i = 0; i < this.nedges; ++i) {
            Edge edge = this.edges[i];
            if (edge.idealX == 0 && edge.idealY == 0) continue;
            deltaX = edge.to.x - edge.from.x - (double)edge.idealX;
            if (deltaX > 1.0 || deltaX < -1.0) {
                edge.from.speedX += (deltaX /= 10.0) / 5.0;
                edge.to.speedX -= deltaX / 5.0;
            }
            if (!((deltaY = edge.to.y - edge.to.h2 - edge.from.y - edge.from.h2 - (double)edge.idealY) > 1.0) && !(deltaY < -1.0)) continue;
            edge.from.speedY += (deltaY /= 10.0) / 5.0;
            edge.to.speedY -= deltaY / 5.0;
        }
        for (i = 0; i < this.nnodes; ++i) {
            node1 = this.nodes[i];
            for (int j = i + 1; j < this.nnodes; ++j) {
                Node node2 = this.nodes[j];
                if (node1.y - 3.0 < node2.y + 3.0 && node2.y - 3.0 < node1.y + 3.0) {
                    deltaX = node2.x - node1.x;
                    if (deltaX > 0.0) {
                        if ((deltaX = 30.0 - deltaX) > 30.0) {
                            deltaX = 30.0;
                        }
                        if (deltaX < 0.0) {
                            deltaX = 0.0;
                        }
                        deltaX *= deltaX;
                    } else {
                        if ((deltaX = -30.0 - deltaX) < -30.0) {
                            deltaX = -30.0;
                        }
                        if (deltaX > 0.0) {
                            deltaX = 0.0;
                        }
                        deltaX *= -deltaX;
                    }
                    node1.speedX -= deltaX / 20.0;
                    node2.speedX += deltaX / 20.0;
                }
                if (!(node1.x - 3.0 < node2.x + 3.0) || !(node2.x - 3.0 < node1.x + 3.0)) continue;
                deltaY = node2.y - node1.y;
                if (deltaY > 0.0) {
                    if ((deltaY = 30.0 - deltaY) > 30.0) {
                        deltaY = 30.0;
                    }
                    if (deltaY < 0.0) {
                        deltaY = 0.0;
                    }
                    deltaY *= deltaY;
                } else {
                    if ((deltaY = -30.0 - deltaY) < -30.0) {
                        deltaY = -30.0;
                    }
                    if (deltaY > 0.0) {
                        deltaY = 0.0;
                    }
                    deltaY *= -deltaY;
                }
                node1.speedY -= deltaY / 20.0;
                node2.speedY += deltaY / 20.0;
            }
            if (node1.x - node1.w2 - 15.0 < 0.0) {
                deltaX = node1.w2 + 15.0 - node1.x;
                deltaX *= deltaX;
            } else if (node1.x + node1.w2 + 15.0 > (double)width) {
                deltaX = (double)width - node1.x - node1.w2 - 15.0;
                deltaX *= -deltaX;
            } else {
                deltaX = 0.0;
            }
            node1.speedX += deltaX / 10.0;
            if (node1.y - node1.h2 - 15.0 < 0.0) {
                deltaY = node1.h2 + 15.0 - node1.y;
                deltaY *= deltaY;
            } else if (node1.y + node1.h2 + 15.0 > (double)height) {
                deltaY = (double)height - node1.y - node1.h2 - 15.0;
                deltaY *= -deltaY;
            } else {
                deltaY = 0.0;
            }
            node1.speedY += deltaY / 10.0;
            if (!(node1 instanceof UnitNode)) continue;
            UnitNode unitNode1 = (UnitNode)node1;
            if (unitNode1.isTopNode()) {
                unitNode1.speedY -= 5.0;
                continue;
            }
            if (!unitNode1.isBottomNode()) continue;
            unitNode1.speedY += 5.0;
        }
        boolean needRepaint = false;
        for (i = 0; i < this.nnodes; ++i) {
            node1 = this.nodes[i];
            if (node1.speedX * node1.speedX + node1.speedY * node1.speedY < 0.01) {
                node1.speedX = 0.0;
                node1.speedY = 0.0;
                continue;
            }
            needRepaint = true;
            node1.x += Math.max(-5.0, Math.min(5.0, node1.speedX));
            node1.y += Math.max(-5.0, Math.min(5.0, node1.speedY));
            node1.speedX /= 3.0;
            node1.speedY /= 3.0;
        }
        if (needRepaint) {
            this.repaint();
        }
    }

    @Override
    public synchronized void update(Graphics g) {
        int i;
        Dimension d = this.getSize();
        if (this.offscreen == null || d.width != this.offscreensize.width || d.height != this.offscreensize.height) {
            this.offscreen = this.createImage(d.width, d.height);
            this.offscreensize = d;
            if (this.offgraphics != null) {
                this.offgraphics.dispose();
            }
            this.offgraphics = this.offscreen.getGraphics();
            this.offgraphics.setFont(this.getFont());
        }
        this.offgraphics.setColor(Color.white);
        this.offgraphics.fillRect(0, 0, d.width, d.height);
        for (i = 0; i < this.nedges; ++i) {
            this.edges[i].draw(this.offgraphics);
        }
        for (i = 0; i < this.nnodes; ++i) {
            this.nodes[i].draw(this.offgraphics);
        }
        g.drawImage(this.offscreen, 0, 0, null);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.addMouseMotionListener(this);
        double bestdist = Double.MAX_VALUE;
        int x = e.getX();
        int y = e.getY();
        for (int i = 0; i < this.nnodes; ++i) {
            Node n = this.nodes[i];
            double dist = (n.x - (double)x) * (n.x - (double)x) + (n.y - (double)y) * (n.y - (double)y);
            if (!(dist < bestdist)) continue;
            this.pick = n;
            bestdist = dist;
        }
        if (this.pick != null) {
            if (this.selected != null) {
                this.selected.setSelected(false);
            }
            this.selected = this.pick;
            this.selected.setSelected(true);
            this.pickfixed = this.pick.fixed;
            this.pick.fixed = true;
            this.pick.x = x;
            this.pick.y = y;
        }
        this.repaint();
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.removeMouseMotionListener(this);
        if (this.pick != null) {
            this.pick.x = e.getX();
            this.pick.y = e.getY();
            this.pick.fixed = this.pickfixed;
            this.pick = null;
        }
        this.repaint();
        e.consume();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.pick != null) {
            this.pick.x = e.getX();
            this.pick.y = e.getY();
        }
        this.repaint();
        e.consume();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

