/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.frontend;

import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapEnvForThread;
import fr.inria.tapenade.representation.TapList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;

public final class Parser {
    private Parser() {
    }

    public static synchronized BufferedReader parse(String[] ppCommands, String[] commands, String file) throws IOException {
        File inputFile = new File(file);
        if (!inputFile.exists()) {
            throw new FileNotFoundException((TapEnv.isServlet() ? inputFile.getName() : file) + " (No such file or directory)");
        }
        TapEnv.printlnOnTrace(15, "@@ Parsing " + file);
        TapEnv.setCurrentParsedFile(file);
        Runtime rt = Runtime.getRuntime();
        TapEnvForThread tapEnvForThread = TapEnv.get();
        if (ppCommands != null) {
            if (tapEnvForThread.traceParser) {
                TapEnv.printOnTrace("PREPROCESSING COMMAND=");
                for (String ppCommand : ppCommands) {
                    TapEnv.printOnTrace(" " + ppCommand);
                }
                TapEnv.printlnOnTrace();
            }
            try {
                Process preproc = rt.exec(ppCommands);
                BufferedReader errorPreproc = new BufferedReader(new InputStreamReader(preproc.getErrorStream()));
                new Thread(() -> {
                    try {
                        String line;
                        while ((line = errorPreproc.readLine()) != null) {
                            tapEnvForThread.parserError(line);
                            tapEnvForThread.flushOutputStream();
                        }
                    }
                    catch (IOException exc) {
                        tapEnvForThread.parserError("Parsing interrupted " + file);
                    }
                }).start();
                try {
                    int returnValue = preproc.waitFor();
                    if (returnValue != 0) {
                        TapEnv.parserError(ppCommands[0] + " preprocessor error, return value " + returnValue);
                    }
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                }
                preproc.getOutputStream().close();
            }
            catch (IOException e) {
                TapEnv.parserError(ppCommands[0] + " command not found");
            }
            if (TapEnv.relatedLanguageIsC()) {
                int indexOfPreprocessedFileName = 4;
                File preprocessedFile = new File(commands[indexOfPreprocessedFileName]);
                if (!preprocessedFile.exists()) {
                    TapEnv.parserError(ppCommands[0] + " preprocessor error, temporary file not created: " + preprocessedFile);
                    TapEnv.parserError(ppCommands[0] + " try recover by parsing directly: " + file);
                    commands[indexOfPreprocessedFileName] = file;
                }
            } else if (TapEnv.relatedLanguageIsCPLUSPLUS()) {
                File jsonFile = new File("o.json");
                File cPlusPlusParserFile = new File(commands[0]);
                if (!cPlusPlusParserFile.exists()) {
                    TapEnv.toolError("No parser for C++");
                    return null;
                }
                if (!jsonFile.exists()) {
                    TapEnv.parserError(ppCommands[0] + " parser warning, compile_commands.json not found");
                } else {
                    try (BufferedReader input = new BufferedReader(new FileReader(jsonFile));){
                        Parser.modifyJsonFile(ppCommands, input);
                    }
                }
            }
        }
        if (tapEnvForThread.traceParser) {
            TapEnv.printOnTrace("PARSING COMMAND=");
            for (String command : commands) {
                TapEnv.printOnTrace(" " + command);
            }
            TapEnv.printlnOnTrace();
        }
        Process p = rt.exec(commands);
        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        BufferedReader errorReader = new BufferedReader(new InputStreamReader(p.getErrorStream()));
        new Thread(() -> {
            try {
                String line;
                while ((line = errorReader.readLine()) != null) {
                    tapEnvForThread.parserError(line);
                    tapEnvForThread.flushOutputStream();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }).start();
        new Thread(() -> {
            try {
                p.waitFor();
            }
            catch (InterruptedException e) {
                tapEnvForThread.parserError("Parsing interrupted " + file);
                Thread.currentThread().interrupt();
            }
        }).start();
        p.getOutputStream().close();
        return reader;
    }

    private static void modifyJsonFile(String[] ppCommands, BufferedReader input) {
        File compileJsonFile = new File("compile_commands.json");
        if (compileJsonFile.exists() && !compileJsonFile.renameTo(new File("compile_commands.json~"))) {
            TapEnv.parserError("Parsing interrupted compile_commands.json~");
        }
        try (FileWriter toFile = new FileWriter("compile_commands.json");){
            int nbLine = ppCommands.length - 6;
            String firstLine = input.readLine();
            if (nbLine == 1) {
                firstLine = firstLine.replace("{", "[{");
                firstLine = firstLine.replace("},", "}]");
                toFile.write(firstLine);
            } else if (nbLine == 2) {
                firstLine = firstLine.replace("{", "[{");
                toFile.write(firstLine);
                toFile.write(System.lineSeparator());
                String lastLine = input.readLine();
                lastLine = lastLine.replace("},", "}]");
                toFile.write(lastLine);
            } else {
                firstLine = firstLine.replace("{", "[{");
                toFile.write(firstLine);
                toFile.write(System.lineSeparator());
                for (int i = 2; i < nbLine; ++i) {
                    String line = input.readLine();
                    toFile.write(line);
                    toFile.write(System.lineSeparator());
                }
                String lastLine = input.readLine();
                lastLine = lastLine.replace("},", "}]");
                toFile.write(lastLine);
            }
            toFile.write(System.lineSeparator());
        }
        catch (IOException e) {
            TapEnv.parserError("Parsing interrupted compile_commands.json");
        }
    }

    public static void cleanJsonFiles(TapList<String> fileNames) {
        File jsonFile = new File("o.json");
        if (jsonFile.exists() && !jsonFile.delete()) {
            TapEnv.parserError("Cannot remove o.json");
        }
        if ((jsonFile = new File("compile_commands.json")).exists() && !jsonFile.delete()) {
            TapEnv.parserError("Cannot remove compile_commands.json");
        }
        if ((jsonFile = new File("compile_commands.json~")).exists() && !jsonFile.renameTo(new File("compile_commands.json"))) {
            TapEnv.parserError("Cannot rename compile_commands.json");
        }
        while (fileNames != null) {
            String fileName = TapEnv.stripLanguageExtension(TapEnv.stripPath((String)fileNames.head)) + ".o";
            jsonFile = new File(fileName);
            if (jsonFile.exists() && !jsonFile.delete()) {
                TapEnv.parserError("Cannot remove " + fileName);
            }
            fileNames = fileNames.tail;
        }
    }
}

