/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.frontend;

import fr.inria.tapenade.frontend.LibReader;
import fr.inria.tapenade.frontend.TreeProtocol;
import fr.inria.tapenade.representation.AtomFuncDerivative;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.FlowGraphBuilder;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.FunctionTypeSpec;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.MemMap;
import fr.inria.tapenade.representation.MetaTypeSpec;
import fr.inria.tapenade.representation.ModifiedTypeSpec;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.PrimitiveTypeSpec;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.VoidTypeSpec;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.BoolMatrix;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.ToObject;
import fr.inria.tapenade.utils.Tree;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class GeneralLibReader {
    private static final String FUNCTION = "function";
    private static final String SUBROUTINE = "subroutine";
    private static final String CONSTANT = "constant";
    private static final String EXTERNAL = "external";
    private static final String INTRINSIC = "intrinsic";
    private static final String SHAPE = "shape";
    private static final String TYPE = "type";
    private static final String NOT_READ_NOT_WRITTEN = "NotReadNotWritten";
    private static final String READ_NOT_WRITTEN = "ReadNotWritten";
    private static final String NOT_READ_THEN_WRITTEN = "NotReadThenWritten";
    private static final String READ_THEN_WRITTEN = "ReadThenWritten";
    private static final String DERIVATIVE = "derivative";
    private static final String DEPENDENCIES = "deps";
    private static final String INLINE = "inline";
    private static final String RESULT = "result";
    private static final String COMMON = "common";
    private static final String GLOBAL = "global";
    private static final String PARAM = "param";
    private static final String DESTOFPARAM = "destofparam";
    private int icountSubWithNoNameDefined;
    private int nbArgShape;
    private String name;
    private boolean decodedFunction;
    private boolean decodedSubroutine;
    private boolean decodedConst;
    private boolean decodedIntrinsic;
    private boolean decodedExternal;
    private boolean decodedShape;
    private boolean decodedType;
    private boolean decodedN;
    private boolean decodedR;
    private boolean decodedW;
    private boolean decodedRW;
    private boolean decodedInline;
    private Unit unit;
    private int returnIndex;
    private BoolVector decodUnitN;
    private BoolVector decodUnitR;
    private BoolVector decodUnitW;
    private BoolVector decodUnitRW;
    private int nbArgN;
    private int nbArgR;
    private int nbArgW;
    private int nbArgRW;
    private TapList<Tree> decodType;
    private int nbArgType;
    private TapList<ZoneInfo> decodShape;
    private boolean okToArchive;
    private int vectorLength;
    private int libraryLanguage = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeneralLibReader(String directory, String fileName, CallGraph callGraph, int language) {
        GeneralLibReader generalLibReader = this;
        synchronized (generalLibReader) {
            try {
                this.libraryLanguage = language;
                TapEnv.setInputLanguage(language);
                String libDirectory = directory;
                if (!TapEnv.isServlet() && !libDirectory.isEmpty()) {
                    libDirectory = System.getProperty("tapenade_home") + File.separator + "resources" + File.separator + directory;
                }
                File libFile = new File(libDirectory + fileName);
                LibReader libReader = null;
                if (libFile.exists()) {
                    libReader = new LibReader(new BufferedReader(new FileReader(libDirectory + fileName)));
                    TapEnv.printlnOnTrace(15, "@@ Loading information from library " + libDirectory + fileName + " (" + TapEnv.languageName(language) + ')');
                } else if (!libDirectory.isEmpty()) {
                    TapEnv.printlnOnTrace(15, "@@ Loading information from tapenade.jar" + File.separator + directory + fileName + " (" + TapEnv.languageName(language) + ')');
                    InputStream in = this.getClass().getResourceAsStream(File.separator + directory + fileName);
                    if (in != null) {
                        libReader = new LibReader(new BufferedReader(new InputStreamReader(in)));
                    } else {
                        TapEnv.systemError("(Reading library " + fileName + ") File not found");
                    }
                } else {
                    TapEnv.systemError("(Reading library " + fileName + ") File not found");
                }
                if (libReader != null) {
                    libReader.setLineCommentChar('#');
                    this.decodLibReader(directory, fileName, libReader, callGraph);
                }
            }
            catch (FileNotFoundException e) {
                TapEnv.systemError("(Reading library " + fileName + ") File not found");
            }
            catch (IOException e) {
                TapEnv.systemError("(Reading library " + fileName + ") I-O Error " + e.getMessage());
            }
        }
    }

    private final void decodLibReader(String directory, String fileName, LibReader libReader, CallGraph callGraph) throws IOException {
        TreeProtocol treeProtocol = new TreeProtocol(libReader);
        if (TapEnv.traceInputIL()) {
            treeProtocol.setTraceOn(true);
        }
        int nextToken = libReader.readNextToken();
        String nextValue = libReader.sval;
        while (nextToken != -1) {
            if (nextValue.equals(FUNCTION) || nextValue.equals(SUBROUTINE)) {
                ToBool inlined = new ToBool(false);
                this.subOrFuncDefine(directory + fileName, libReader, treeProtocol, nextValue, callGraph, inlined);
            } else if (nextValue.equals(CONSTANT)) {
                this.constDefine(directory + fileName, libReader, treeProtocol);
            } else {
                TapEnv.systemWarning(14, "(Reading library " + fileName + ") unrecognized token:" + nextValue);
            }
            this.okToArchive &= this.decodedInline || this.allDefine(directory + fileName);
            if (this.okToArchive) {
                this.archive(fileName, callGraph);
            } else if (this.unit != null) {
                TapEnv.systemWarning(-1, "(Reading library " + fileName + ") Error while reading definition of " + this.name);
                callGraph.deleteUnit(this.unit);
                this.unit = null;
            }
            this.decodShape = null;
            this.decodedIntrinsic = false;
            this.decodedExternal = false;
            this.decodedInline = false;
            this.decodedShape = false;
            this.decodedType = false;
            this.decodedN = false;
            this.decodedR = false;
            this.decodedW = false;
            this.decodedRW = false;
            this.decodedFunction = false;
            this.decodedSubroutine = false;
            this.decodedConst = false;
            nextToken = libReader.readNextToken();
            nextValue = libReader.sval;
        }
    }

    private void subOrFuncDefine(String fileName, LibReader libReader, TreeProtocol treeProtocol, String subOrFunc, CallGraph callGraph, ToBool inlined) throws IOException {
        this.okToArchive = true;
        this.returnIndex = -1;
        this.nbArgN = 0;
        this.nbArgR = 0;
        this.nbArgW = 0;
        this.nbArgRW = 0;
        this.nbArgType = 0;
        this.nbArgShape = 0;
        this.name = this.nameDefine(fileName, libReader, subOrFunc);
        int nextToken = libReader.seeNextToken();
        String nextValue = libReader.sval;
        this.unit = Unit.makeExternalOrIntrinsic(this.name, callGraph, this.libraryLanguage);
        FunctionDecl functionDecl = new FunctionDecl(ILUtils.build(96, this.name), this.unit, callGraph.languageRootSymbolTable(this.libraryLanguage));
        if (subOrFunc.equals(FUNCTION)) {
            this.decodedFunction = true;
        } else {
            this.decodedSubroutine = true;
        }
        while (!(nextToken == -1 || nextValue.equals(FUNCTION) || nextValue.equals(SUBROUTINE) || nextValue.equals(CONSTANT))) {
            nextToken = libReader.readNextToken();
            switch (nextValue = libReader.sval) {
                case "intrinsic": {
                    this.decodedIntrinsic = true;
                    nextToken = libReader.seeNextToken();
                    nextValue = libReader.sval;
                    if (!":".equals(nextValue)) break;
                    libReader.readNextToken();
                    break;
                }
                case "external": {
                    this.decodedExternal = true;
                    nextToken = libReader.seeNextToken();
                    nextValue = libReader.sval;
                    if (!":".equals(nextValue)) break;
                    libReader.readNextToken();
                    break;
                }
                case "shape": {
                    this.decodShape = this.shapeDecoding(libReader);
                    this.nbArgShape = TapList.length(this.decodShape);
                    this.decodedShape = true;
                    break;
                }
                case "type": {
                    this.decodType = this.typeDecoding(libReader, treeProtocol);
                    this.nbArgType = TapList.length(this.decodType);
                    this.decodedType = true;
                    break;
                }
                case "inline": {
                    nextToken = libReader.seeNextToken();
                    if (nextToken == 1) {
                        libReader.readNextToken();
                    }
                    libReader.eliminateSpaces();
                    FlowGraphBuilder.build(treeProtocol, callGraph.languageRootSymbolTable(this.libraryLanguage), callGraph, this.libraryLanguage, this.unit, true);
                    this.decodedInline = true;
                    inlined.set(true);
                    break;
                }
                case "NotReadNotWritten": 
                case "NotReadNorWritten": {
                    this.decodUnitN = this.publicZoneVectorDecoding(libReader);
                    this.nbArgN = this.vectorLength;
                    this.decodedN = true;
                    break;
                }
                case "ReadNotWritten": {
                    this.decodUnitR = this.publicZoneVectorDecoding(libReader);
                    this.nbArgR = this.vectorLength;
                    this.decodedR = true;
                    break;
                }
                case "NotReadThenWritten": {
                    this.decodUnitW = this.publicZoneVectorDecoding(libReader);
                    this.nbArgW = this.vectorLength;
                    this.decodedW = true;
                    break;
                }
                case "ReadThenWritten": {
                    this.decodUnitRW = this.publicZoneVectorDecoding(libReader);
                    this.nbArgRW = this.vectorLength;
                    this.decodedRW = true;
                    break;
                }
                case "deps": {
                    if (libReader.seeNextToken() == 1) {
                        libReader.readNextToken();
                    }
                    BoolMatrix depsDefinedByUser = this.boolMatrixDecoding(libReader);
                    if (this.okToArchive) {
                        this.unit.unitADDependencies = depsDefinedByUser;
                        break;
                    }
                    TapEnv.systemWarning(-1, "(Reading A.D. library " + fileName + ") Error while reading dependence info on " + this.unit.name());
                    break;
                }
                case "derivative": {
                    Tree jacobianInfo;
                    if (libReader.seeNextToken() == 1) {
                        libReader.readNextToken();
                    }
                    try {
                        jacobianInfo = treeProtocol.readPrefixTree();
                    }
                    catch (IOException e) {
                        TapEnv.systemError("(Reading A.D. library " + fileName + ") Error " + e.getMessage() + " while reading derivative info on " + this.unit.name());
                        jacobianInfo = null;
                    }
                    if (jacobianInfo == null) break;
                    AtomFuncDerivative.incorporateNewAtomFunc(jacobianInfo, this.unit);
                    break;
                }
                default: {
                    TapEnv.systemWarning(14, "(Reading library " + fileName + ") unrecognized keyword:" + nextValue);
                }
            }
            nextToken = libReader.seeNextToken();
            nextValue = libReader.sval;
        }
    }

    private TapList<Tree> typeDecoding(LibReader libReader, TreeProtocol treeProtocol) throws IOException {
        TapList<Object> types;
        TapList<Object> typesTail = types = new TapList<Object>(null, null);
        int nextToken = libReader.readNextToken();
        while (nextToken != -1 && nextToken != 2) {
            nextToken = libReader.readNextToken();
        }
        nextToken = libReader.seeNextToken();
        while (nextToken != -1 && nextToken != 4) {
            if (nextToken == 3) {
                libReader.readNextToken();
                nextToken = libReader.seeNextToken();
            }
            typesTail = typesTail.placdl(treeProtocol.readPrefixTree());
            nextToken = libReader.seeNextToken();
        }
        libReader.readNextToken();
        return types.tail;
    }

    private BoolVector publicZoneVectorDecoding(LibReader libReader) throws IOException {
        TapIntList elements;
        TapIntList elementsTail = elements = new TapIntList(0, null);
        int nextToken = libReader.readNextToken();
        while (nextToken != -1 && nextToken != 2) {
            nextToken = libReader.readNextToken();
        }
        nextToken = libReader.readNextToken();
        while (nextToken != -1 && nextToken != 4) {
            if (nextToken == 3) {
                nextToken = libReader.readNextToken();
            }
            elementsTail = elementsTail.placdl(Integer.parseInt(libReader.sval));
            nextToken = libReader.readNextToken();
        }
        elements = elements.tail;
        this.vectorLength = TapIntList.length(elements);
        BoolVector result = new BoolVector(this.vectorLength);
        int index = 0;
        while (elements != null) {
            result.set(index, elements.head != 0);
            ++index;
            elements = elements.tail;
        }
        return result;
    }

    private TapList<ZoneInfo> shapeDecoding(LibReader libReader) throws IOException {
        TapList<Object> llistShape;
        int nbZoneParam = 0;
        TapList<Object> llistShapeTail = llistShape = new TapList<Object>(null, null);
        int startInterval = 0;
        int endInterval = 0;
        boolean infiniteEndOffset = false;
        int nextToken = libReader.readNextToken();
        while (nextToken != -1 && nextToken != 2) {
            nextToken = libReader.readNextToken();
        }
        nextToken = libReader.readNextToken();
        while (nextToken != -1 && nextToken != 4) {
            if (nextToken == 5) {
                ZoneInfo zoneInfoParam;
                String nextValue;
                switch (nextValue = libReader.sval) {
                    case "param": {
                        nextToken = libReader.readNextToken();
                        int indexParam = libReader.sval.equals("*") ? -1 : Integer.parseInt(libReader.sval);
                        zoneInfoParam = new ZoneInfo(-1, -1, false);
                        zoneInfoParam.index = indexParam;
                        zoneInfoParam.description = "arg#" + indexParam;
                        zoneInfoParam.setKind(7);
                        zoneInfoParam.declarationUnit = this.unit;
                        break;
                    }
                    case "destofparam": {
                        nextToken = libReader.readNextToken();
                        int indexParam = Integer.parseInt(libReader.sval);
                        zoneInfoParam = new ZoneInfo(-1, -1, false);
                        zoneInfoParam.index = indexParam;
                        zoneInfoParam.description = "*arg#" + indexParam;
                        zoneInfoParam.accessTree = ILUtils.build(151);
                        zoneInfoParam.setKind(7);
                        zoneInfoParam.declarationUnit = this.unit;
                        break;
                    }
                    case "result": {
                        zoneInfoParam = new ZoneInfo(-1, -1, false);
                        zoneInfoParam.description = RESULT;
                        zoneInfoParam.setKind(10);
                        zoneInfoParam.index = 0;
                        zoneInfoParam.declarationUnit = this.unit;
                        this.returnIndex = nbZoneParam;
                        break;
                    }
                    case "common": {
                        StringBuilder commonName = new StringBuilder();
                        nextToken = libReader.readNextToken();
                        while (nextToken != 6) {
                            if (nextToken == 7) {
                                commonName.append('/');
                            }
                            if (nextToken == 5) {
                                commonName.append(libReader.sval);
                            }
                            nextToken = libReader.readNextToken();
                        }
                        nextToken = libReader.readNextToken();
                        while (nextToken != 5) {
                            nextToken = libReader.readNextToken();
                        }
                        startInterval = Integer.parseInt(libReader.sval);
                        nextToken = libReader.readNextToken();
                        while (nextToken != 5) {
                            nextToken = libReader.readNextToken();
                        }
                        if (libReader.sval.equals("*")) {
                            endInterval = -1;
                            infiniteEndOffset = true;
                        } else {
                            endInterval = Integer.parseInt(libReader.sval);
                            infiniteEndOffset = false;
                        }
                        zoneInfoParam = new ZoneInfo(startInterval, endInterval, infiniteEndOffset);
                        zoneInfoParam.setKind(13);
                        zoneInfoParam.commonName = commonName.toString();
                        zoneInfoParam.description = zoneInfoParam.commonName + "[" + startInterval + "," + (infiniteEndOffset ? "+inf" : Integer.valueOf(endInterval)) + "[";
                        zoneInfoParam.declarationUnit = this.unit;
                        break;
                    }
                    case "global": {
                        nextToken = libReader.readNextToken();
                        while (nextToken != 5) {
                            nextToken = libReader.readNextToken();
                        }
                        String globalName = libReader.sval;
                        zoneInfoParam = new ZoneInfo(startInterval, endInterval, infiniteEndOffset);
                        zoneInfoParam.setKind(13);
                        zoneInfoParam.commonName = globalName;
                        zoneInfoParam.description = "global:" + globalName;
                        zoneInfoParam.declarationUnit = this.unit;
                        break;
                    }
                    default: {
                        TapEnv.fileWarning(10, 0, "(LB01) Error in library file: unknown keyword in shape: " + nextValue);
                        zoneInfoParam = null;
                    }
                }
                if (zoneInfoParam != null) {
                    zoneInfoParam.zoneNb = nbZoneParam;
                }
                llistShapeTail = llistShapeTail.placdl(zoneInfoParam);
                ++nbZoneParam;
            }
            nextToken = libReader.readNextToken();
        }
        return llistShape.tail;
    }

    private void constDefine(String fileName, LibReader libReader, TreeProtocol treeProtocol) throws IOException {
        this.okToArchive = true;
        this.decodedConst = true;
        this.name = this.nameDefine(fileName, libReader, CONSTANT);
        int nextToken = libReader.seeNextToken();
        String nextValue = libReader.sval;
        while (!(nextToken == -1 || nextValue.equals(FUNCTION) || nextValue.equals(SUBROUTINE) || nextValue.equals(CONSTANT))) {
            nextToken = libReader.readNextToken();
            nextValue = libReader.sval;
            if (nextValue.equals(TYPE)) {
                nextToken = libReader.seeNextToken();
                if (nextToken == 1) {
                    libReader.readNextToken();
                }
                this.decodType = new TapList<Tree>(treeProtocol.readPrefixTree(), null);
                this.decodedType = true;
            }
            nextToken = libReader.seeNextToken();
            nextValue = libReader.sval;
        }
    }

    private String nameDefine(String fileName, LibReader libReader, String subOrFuncOrConst) throws IOException {
        String functionName = null;
        int nextToken = libReader.readNextToken();
        while (nextToken != 1 && functionName == null) {
            if (nextToken == 5) {
                functionName = libReader.sval;
            }
            nextToken = libReader.readNextToken();
        }
        if (functionName == null && !subOrFuncOrConst.equals(CONSTANT)) {
            this.okToArchive = false;
            functionName = "sub" + this.icountSubWithNoNameDefined;
            ++this.icountSubWithNoNameDefined;
            TapEnv.systemWarning(14, "(Reading library " + fileName + ") a " + subOrFuncOrConst + " has no name");
        }
        return functionName;
    }

    private boolean allDefine(String fileName) {
        boolean ok = true;
        int ncountClefsManquantes = 0;
        String clefsManquantes = "";
        int ncountClefsAvecDefaut = 0;
        String clefsAvecDefaut = "";
        if (this.decodedConst && !this.decodedType) {
            clefsManquantes = clefsManquantes + " TYPE ";
            ++ncountClefsManquantes;
            ok = false;
        }
        if (this.decodedFunction || this.decodedSubroutine) {
            if (!this.decodedShape) {
                clefsManquantes = clefsManquantes + " SHAPE ";
                ++ncountClefsManquantes;
                ok = false;
            }
            if (this.decodedShape && this.decodedType && this.nbArgType != this.nbArgShape) {
                ok = false;
                TapEnv.systemWarning(14, "(Reading library " + fileName + ") Wrong number of values, TYPE: " + this.nbArgType + ", SHAPE: " + this.nbArgShape);
            }
            if (!this.decodedN) {
                clefsAvecDefaut = clefsAvecDefaut + " N ";
                ++ncountClefsAvecDefaut;
                if (ok) {
                    this.decodUnitN = new BoolVector(this.nbArgShape);
                    this.decodUnitN.setTrue();
                    this.nbArgN = this.nbArgType;
                }
            }
            if (!this.decodedR) {
                clefsAvecDefaut = clefsAvecDefaut + " R ";
                ++ncountClefsAvecDefaut;
                if (ok) {
                    this.decodUnitR = new BoolVector(this.nbArgShape);
                    this.decodUnitR.setTrue();
                    this.nbArgR = this.nbArgType;
                }
            }
            if (!this.decodedW) {
                clefsAvecDefaut = clefsAvecDefaut + " W ";
                ++ncountClefsAvecDefaut;
                if (ok) {
                    this.decodUnitW = new BoolVector(this.nbArgShape);
                    if (!this.decodedIntrinsic) {
                        this.decodUnitW.setFalse();
                    }
                    this.nbArgW = this.nbArgType;
                }
            }
            if (!this.decodedRW) {
                clefsAvecDefaut = clefsAvecDefaut + " RW ";
                ++ncountClefsAvecDefaut;
                if (ok) {
                    this.decodUnitRW = new BoolVector(this.nbArgShape);
                    this.decodUnitRW.setFalse();
                    this.nbArgRW = this.nbArgType;
                }
            }
            if (ok && this.returnIndex != -1) {
                this.decodUnitN.set(this.returnIndex, false);
                this.decodUnitR.set(this.returnIndex, false);
                this.decodUnitW.set(this.returnIndex, true);
                this.decodUnitRW.set(this.returnIndex, false);
            }
        }
        if (ncountClefsManquantes > 0) {
            String information = "";
            if (ncountClefsManquantes != 1) {
                information = information + "s :";
            }
            information = information + clefsManquantes;
            if (this.decodedFunction) {
                information = information + " in function ";
            }
            if (this.decodedSubroutine) {
                information = information + " in subroutine ";
            }
            if (this.decodedConst) {
                information = information + " in constant ";
            }
            information = information + this.name;
            TapEnv.systemWarning(14, "(Reading library " + fileName + ") Missing key" + information);
        }
        if (this.returnIndex == -1 ? this.decodedFunction : this.decodedSubroutine) {
            if (this.returnIndex == -1) {
                TapEnv.systemWarning(14, "(Reading library " + fileName + ") Missing return value in function " + this.name);
            } else {
                TapEnv.systemWarning(14, "(Reading library " + fileName + ") Return value in subroutine " + this.name);
            }
        }
        if (ok && (this.decodedFunction || this.decodedSubroutine) && (this.nbArgN != this.nbArgType || this.nbArgR != this.nbArgType || this.nbArgW != this.nbArgType || this.nbArgRW != this.nbArgType)) {
            ok = false;
            TapEnv.systemWarning(14, "(Reading library " + fileName + ") Incomplete information for arrays N, R, W and RW, " + this.nbArgType + " values are needed");
        }
        return ok;
    }

    private void archive(String fileName, CallGraph callGraph) {
        SymbolTable symbolTable = callGraph.languageRootSymbolTable(this.libraryLanguage);
        if (this.decodedConst) {
            TapList<Object> toAccess = new TapList<Object>(null, null);
            ToBool isPointer = new ToBool(false);
            WrapperTypeSpec argType = TypeSpec.build((Tree)this.decodType.head, symbolTable, new Instruction((Tree)this.decodType.head), new TapList<Object>(null, null), new TapList<Object>(null, null), toAccess, isPointer, null);
            SymbolDecl symbolDecl = SymbolDecl.build(argType, toAccess.tail, isPointer.get(), ILUtils.build(96, this.name), 5, symbolTable, null, null);
            symbolDecl.addExtraInfo(new TapList<String>("extern", null));
            symbolTable.addSymbolDecl(symbolDecl);
            TapEnv.printlnOnTrace(20, "@@ Added info on constant " + symbolDecl.symbol);
        } else if (this.decodedFunction || this.decodedSubroutine) {
            FunctionDecl prevFunctionDecl;
            if (this.decodedIntrinsic) {
                this.unit.turnIntrinsic();
            }
            if (this.decodedExternal) {
                this.unit.turnExternal();
            }
            TapEnv.get().inlinedFunctions.addLibraryUnit(this.unit);
            if (this.decodedInline) {
                this.unit.isMadeForInline = true;
                this.unit.fixImplicits();
                this.unit.exportFunctionTypeSpec();
            } else {
                int n = TapList.length(this.decodShape);
                int nZoneInt = 0;
                int nZoneReal = 0;
                int nZonePtr = 0;
                WrapperTypeSpec[] paramTypes = new WrapperTypeSpec[n];
                WrapperTypeSpec resultType = new WrapperTypeSpec(new VoidTypeSpec());
                int nbParams = 0;
                ZoneInfo[] externalShape = new ZoneInfo[n];
                this.unit.globalZonesNumber4 = new int[]{0, 0, 0, 0};
                for (int i = 0; i < n; ++i) {
                    String baseTypeName;
                    WrapperTypeSpec argType;
                    ZoneInfo zoneInfo;
                    externalShape[i] = zoneInfo = (ZoneInfo)this.decodShape.head;
                    if (this.decodType == null) {
                        argType = new WrapperTypeSpec(null);
                    } else {
                        ToBool isPointer = new ToBool(false);
                        argType = TypeSpec.build((Tree)this.decodType.head, symbolTable, new Instruction((Tree)this.decodType.head), new TapList<Object>(null, null), new TapList<Object>(null, null), new TapList<Object>(null, null), isPointer, null);
                        if (isPointer.get()) {
                            argType = new WrapperTypeSpec(new PointerTypeSpec(argType, null));
                        }
                        this.decodType = this.decodType.tail;
                    }
                    if (zoneInfo.commonName != null) {
                        MemMap commonMap = callGraph.globalFortranMaps.getSetMemMap(zoneInfo.commonName);
                        Tree dummyIdentTree = ILUtils.build(96, "dummyVar");
                        dummyIdentTree.setAnnotation("zoneInfo", zoneInfo);
                        VariableDecl varDecl = new VariableDecl(dummyIdentTree, argType);
                        commonMap.insertVariableAt(zoneInfo.startOffset, zoneInfo.infiniteEndOffset ? 0 : zoneInfo.endOffset - zoneInfo.startOffset, varDecl, null, callGraph.globalFortranMaps);
                    }
                    if (zoneInfo.isParameter()) {
                        int index = zoneInfo.index;
                        paramTypes[index - 1] = argType;
                        if (index > nbParams) {
                            nbParams = index;
                        }
                    } else if (zoneInfo.isResult()) {
                        resultType = argType;
                    }
                    ToObject<Object> toModifiedType = new ToObject<Object>(null);
                    argType = TypeSpec.peelSizeModifier(argType, toModifiedType);
                    if (zoneInfo.isParameter() && zoneInfo.accessTree != null && zoneInfo.accessTree.opCode() == 151) {
                        int index = zoneInfo.index;
                        paramTypes[index - 1] = new WrapperTypeSpec(new PointerTypeSpec(paramTypes[index - 1], null));
                    }
                    zoneInfo.type = argType;
                    zoneInfo.typeSizeModifier = toModifiedType.obj() == null ? -1 : ((ModifiedTypeSpec)toModifiedType.obj()).sizeModifierValue();
                    boolean isInt = false;
                    boolean isReal = false;
                    boolean isPtr = false;
                    if (TypeSpec.isA(argType.wrappedType, 7)) {
                        baseTypeName = ((PrimitiveTypeSpec)argType.wrappedType).name();
                        if (baseTypeName.equals("integer")) {
                            isReal = false;
                            isInt = true;
                        } else if (baseTypeName.equals("float") || baseTypeName.equals("complex")) {
                            isReal = true;
                            isInt = false;
                        }
                    } else if (TypeSpec.isA(argType.wrappedType, 6)) {
                        isPtr = true;
                    } else if (TypeSpec.isA(argType.wrappedType, 10)) {
                        baseTypeName = ((MetaTypeSpec)argType.wrappedType).name;
                        if (baseTypeName.startsWith("float") || baseTypeName.startsWith("complex")) {
                            isReal = true;
                            isInt = false;
                        } else {
                            isReal = true;
                            isInt = true;
                        }
                    } else if (argType.wrappedType == null) {
                        isReal = true;
                        isInt = true;
                    } else {
                        isReal = false;
                        isInt = false;
                    }
                    if (isInt) {
                        zoneInfo.intZoneNb = nZoneInt++;
                    }
                    if (isReal) {
                        zoneInfo.realZoneNb = nZoneReal++;
                    }
                    if (isPtr) {
                        zoneInfo.ptrZoneNb = nZonePtr++;
                    }
                    if (zoneInfo.isGlobal() && zoneInfo.zoneNb >= this.unit.globalZonesNumber4[0]) {
                        this.unit.globalZonesNumber4[0] = 1 + zoneInfo.zoneNb;
                        this.unit.globalZonesNumber4[1] = 1 + zoneInfo.realZoneNb;
                        this.unit.globalZonesNumber4[2] = 1 + zoneInfo.intZoneNb;
                        this.unit.globalZonesNumber4[3] = 1 + zoneInfo.ptrZoneNb;
                    }
                    this.decodShape = this.decodShape.tail;
                }
                WrapperTypeSpec[] finalParamTypes = new WrapperTypeSpec[nbParams];
                System.arraycopy(paramTypes, 0, finalParamTypes, 0, nbParams);
                this.unit.setFunctionTypeSpec(new FunctionTypeSpec(resultType, finalParamTypes));
                this.unit.externalShape = externalShape;
                this.unit.globalZonesNumber4 = new int[]{0, 0, 0, 0};
                this.unit.publicZonesNumber4 = new int[]{n, nZoneReal, nZoneInt, nZonePtr};
                this.unit.unitInOutN = this.decodUnitN;
                this.unit.unitInOutR = this.decodUnitR;
                this.unit.unitInOutW = this.decodUnitW;
                this.unit.unitInOutRW = this.decodUnitRW;
                this.unit.precomputeTmpPublicInOutInfos();
            }
            FunctionDecl functionDecl = new FunctionDecl(ILUtils.build(96, this.name), this.unit, symbolTable);
            TapList<FunctionDecl> prevFunctionDecls = symbolTable.getFunctionDecl(this.name, functionDecl.returnTypeSpec(), functionDecl.argumentsTypesSpec(), false);
            FunctionDecl functionDecl2 = prevFunctionDecl = prevFunctionDecls == null ? null : (FunctionDecl)prevFunctionDecls.head;
            if (!(prevFunctionDecl == null || prevFunctionDecl.unit() == this.unit || prevFunctionDecl.isIntrinsic() && WrapperTypeSpec.isFree(prevFunctionDecl.functionTypeSpec().returnType) && prevFunctionDecl.functionTypeSpec().argumentsTypes == null || !prevFunctionDecl.sameTypes(this.unit.functionTypeSpec().returnType, this.unit.functionTypeSpec().argumentsTypes) || prevFunctionDecl.isExternal() || prevFunctionDecl.unit().language() != this.unit.language())) {
                TapEnv.fileWarning(15, null, "(DD11) Duplicate declaration of function " + this.name + " in library file " + fileName);
                if (prevFunctionDecl.unit().diffInfo == null) {
                    prevFunctionDecl.unit().diffInfo = this.unit.diffInfo;
                }
                if (!prevFunctionDecl.unit().isMadeForInline && this.unit.isMadeForInline) {
                    TapEnv.fileWarning(15, null, "(DD11) Inline definition of " + this.name + " may be lost");
                }
                if (prevFunctionDecl.unit().unitADDependencies == null) {
                    prevFunctionDecl.unit().unitADDependencies = this.unit.unitADDependencies;
                }
                if (prevFunctionDecl.unit().unitInOutN == null) {
                    prevFunctionDecl.unit().unitInOutN = this.unit.unitInOutN;
                }
                if (prevFunctionDecl.unit().unitInOutR == null) {
                    prevFunctionDecl.unit().unitInOutR = this.unit.unitInOutR;
                }
                if (prevFunctionDecl.unit().unitInOutW == null) {
                    prevFunctionDecl.unit().unitInOutW = this.unit.unitInOutW;
                }
                if (prevFunctionDecl.unit().unitInOutRW == null) {
                    prevFunctionDecl.unit().unitInOutRW = this.unit.unitInOutRW;
                }
                prevFunctionDecl.unit().precomputeTmpPublicInOutInfos();
                this.unit = null;
            } else {
                symbolTable.addSymbolDecl(functionDecl);
                TapEnv.printlnOnTrace(20, "@@ Added info on procedure " + functionDecl.symbol);
            }
        } else {
            TapEnv.systemWarning(14, "(Reading library " + fileName + ") lost part of lib file. name:" + this.name);
        }
    }

    private BoolMatrix boolMatrixDecoding(LibReader libReader) throws IOException {
        int nextToken = libReader.readNextToken();
        while (nextToken != -1 && nextToken != 2) {
            nextToken = libReader.readNextToken();
        }
        nextToken = libReader.readNextToken();
        BoolMatrix result = new BoolMatrix(this.nbArgShape, this.nbArgShape);
        result.setIdentity();
        int line = 0;
        int column = 0;
        BoolVector tmpRow = null;
        while (nextToken != -1 && nextToken != 4) {
            if (nextToken == 3) {
                nextToken = libReader.readNextToken();
            }
            if (libReader.sval.equalsIgnoreCase("id")) {
                ++line;
                column = 0;
            } else {
                if (tmpRow == null) {
                    tmpRow = new BoolVector(this.nbArgShape);
                }
                if (!libReader.sval.equals("0")) {
                    tmpRow.set(column, true);
                }
                if (++column == this.nbArgShape) {
                    if (line < this.nbArgShape) {
                        result.setRow(line, tmpRow);
                    }
                    ++line;
                    tmpRow = null;
                    column = 0;
                }
            }
            nextToken = libReader.readNextToken();
        }
        if (line == this.nbArgShape && column == 0) {
            return result;
        }
        this.okToArchive = false;
        return null;
    }
}

