/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.differentiation;

import fr.inria.tapenade.differentiation.NewBlockGraph;
import fr.inria.tapenade.differentiation.NewBlockGraphNode;
import fr.inria.tapenade.representation.TapList;

public class NewBlockGraphArrow {
    private NewBlockGraphNode origin;
    private NewBlockGraphNode destination;

    public NewBlockGraphNode origin() {
        return this.origin;
    }

    public NewBlockGraphNode destination() {
        return this.destination;
    }

    protected NewBlockGraphArrow(NewBlockGraphNode origin, NewBlockGraphNode destination) {
        this.origin = origin;
        origin.flow = new TapList<NewBlockGraphArrow>(this, origin.flow);
        this.destination = destination;
        destination.backFlow = new TapList<NewBlockGraphArrow>(this, destination.backFlow);
    }

    protected void redirectDestination(NewBlockGraphNode newDest) {
        if (this.destination != null) {
            this.destination.backFlow = TapList.delete(this, this.destination.backFlow);
        }
        if (newDest != null) {
            if (NewBlockGraph.existsArrow(this.origin, newDest)) {
                this.origin.flow = TapList.delete(this, this.origin.flow);
            } else {
                newDest.backFlow = new TapList<NewBlockGraphArrow>(this, newDest.backFlow);
            }
        }
        this.destination = newDest;
    }

    protected void redirectOrigin(NewBlockGraphNode newOrig) {
        if (this.origin != null) {
            this.origin.flow = TapList.delete(this, this.origin.flow);
        }
        if (newOrig != null) {
            if (NewBlockGraph.existsArrow(newOrig, this.destination)) {
                this.destination.backFlow = TapList.delete(this, this.destination.backFlow);
            } else {
                newOrig.flow = new TapList<NewBlockGraphArrow>(this, newOrig.flow);
            }
        }
        this.origin = newOrig;
    }

    public String toString() {
        return "(" + this.origin + "->" + this.destination + ')';
    }
}

