/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.differentiation;

import fr.inria.tapenade.analysis.DataFlowAnalyzer;
import fr.inria.tapenade.differentiation.DifferentiationEnv;
import fr.inria.tapenade.differentiation.NewBlockGraphArrow;
import fr.inria.tapenade.differentiation.NewBlockGraphNode;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.Tree;

public final class NewBlockGraph {
    public TapList<NewBlockGraphNode> nodes;
    private int nodeCount;
    protected boolean debug;
    protected DifferentiationEnv adEnv;
    private SymbolTable symbolTable;
    private final int nbZones;
    private int inGroupLevel;
    private TapList<TapPair<Tree, NewBlockGraphNode>>[] visibleSrcUses;
    private TapList<TapPair<Tree, NewBlockGraphNode>>[] visibleSrcDefs;
    private TapList<TapPair<Tree, NewBlockGraphNode>>[] visibleBisUses;
    private TapList<TapPair<Tree, NewBlockGraphNode>>[] visibleBisDefs;
    private NewBlockGraphNode lastNodeInGroup;
    private NewBlockGraphNode lastNodeInChain;

    protected NewBlockGraph(DifferentiationEnv adEnv, SymbolTable symbolTable, int nbZones) {
        this.adEnv = adEnv;
        this.symbolTable = symbolTable;
        this.nbZones = nbZones;
        this.visibleSrcUses = new TapList[nbZones + 1];
        this.visibleSrcDefs = new TapList[nbZones + 1];
        this.visibleBisUses = new TapList[nbZones + 1];
        this.visibleBisDefs = new TapList[nbZones + 1];
        this.reset();
    }

    protected static boolean existsArrow(NewBlockGraphNode node1, NewBlockGraphNode node2) {
        TapList<NewBlockGraphArrow> flow = node1.flow;
        boolean exists = false;
        while (!exists && flow != null) {
            exists = ((NewBlockGraphArrow)flow.head).destination() == node2;
            flow = flow.tail;
        }
        return exists;
    }

    protected void reset() {
        for (int i = this.nbZones; i >= 0; --i) {
            this.visibleSrcUses[i] = null;
            this.visibleSrcDefs[i] = null;
            this.visibleBisUses[i] = null;
            this.visibleBisDefs[i] = null;
        }
        this.inGroupLevel = 0;
        this.lastNodeInGroup = null;
        this.lastNodeInChain = null;
        this.nodes = null;
        this.nodeCount = 0;
    }

    protected void buildInstructions(SymbolTable srcSymbolTable, SymbolTable revSymbolTable, DifferentiationEnv adEnv, Unit diffUnit) {
        TapList<NewBlockGraphNode> inNodes = this.nodes;
        while (inNodes != null) {
            ((NewBlockGraphNode)inNodes.head).buildInstruction(srcSymbolTable, revSymbolTable, adEnv, diffUnit);
            inNodes = inNodes.tail;
        }
    }

    private TapList<NewBlockGraphNode> notAllowedFuseNodesAfter(NewBlockGraphNode from) {
        TapList<NewBlockGraphArrow> justAfter = from.flow;
        TapList<NewBlockGraphArrow> justBefore = from.backFlow;
        TapList<NewBlockGraphNode> notAllowed = new TapList<NewBlockGraphNode>(from, null);
        while (justAfter != null) {
            NewBlockGraphNode next = ((NewBlockGraphArrow)justAfter.head).destination();
            TapList<NewBlockGraphArrow> justAfterNext = next.flow;
            while (justAfterNext != null) {
                this.accumulateNodeAndSuccessors(((NewBlockGraphArrow)justAfterNext.head).destination(), notAllowed);
                justAfterNext = justAfterNext.tail;
            }
            justAfter = justAfter.tail;
        }
        while (justBefore != null) {
            this.accumulateNodeAndPredecessors(((NewBlockGraphArrow)justBefore.head).origin(), notAllowed);
            justBefore = justBefore.tail;
        }
        return notAllowed;
    }

    private void accumulateNodeAndSuccessors(NewBlockGraphNode node, TapList<NewBlockGraphNode> accumulator) {
        if (node != null && !TapList.contains(accumulator, node)) {
            accumulator.placdl(node);
            TapList<NewBlockGraphArrow> justAfter = node.flow;
            while (justAfter != null) {
                this.accumulateNodeAndSuccessors(((NewBlockGraphArrow)justAfter.head).destination(), accumulator);
                justAfter = justAfter.tail;
            }
        }
    }

    private void accumulateNodeAndPredecessors(NewBlockGraphNode node, TapList<NewBlockGraphNode> accumulator) {
        if (!TapList.contains(accumulator, node)) {
            accumulator.placdl(node);
            TapList<NewBlockGraphArrow> justBefore = node.backFlow;
            while (justBefore != null) {
                this.accumulateNodeAndPredecessors(((NewBlockGraphArrow)justBefore.head).origin(), accumulator);
                justBefore = justBefore.tail;
            }
        }
    }

    protected void condense(Unit unit) {
        if (TapList.length(this.nodes) < 1000) {
            while (this.doOneCondensation()) {
                TapEnv.printlnOnTrace(35, "Condensing; " + TapList.length(this.nodes) + " nodes remaining...");
            }
        } else {
            TapEnv.fileWarning(15, unit.headTree(), "(ADxx) Too many nodes for instruction condensation:" + TapList.length(this.nodes) + " while differentiating " + unit.name());
        }
    }

    private boolean doOneCondensation() {
        TapList<NewBlockGraphNode> nodesList = this.nodes;
        while (nodesList != null) {
            NewBlockGraphNode origin = (NewBlockGraphNode)nodesList.head;
            TapList<NewBlockGraphNode> notAllowedFuseTargets = this.notAllowedFuseNodesAfter(origin);
            TapList<NewBlockGraphNode> allNodes = this.nodes;
            while (allNodes != null) {
                NewBlockGraphNode target = (NewBlockGraphNode)allNodes.head;
                if (!TapList.contains(notAllowedFuseTargets, target) && origin.interestingFuseWith(target, this)) {
                    boolean originDisappears;
                    if (this.debug) {
                        TapEnv.printlnOnTrace("FUSE " + origin + " WITH " + target);
                    }
                    if (originDisappears = origin.fuseWith(target)) {
                        this.skipNodeInto(origin, target);
                        if (this.debug) {
                            TapEnv.printlnOnTrace("  origin disappearing into target " + target);
                        }
                    } else {
                        this.skipNodeInto(target, origin);
                        if (this.debug) {
                            TapEnv.printlnOnTrace("  target disappearing into origin " + origin);
                        }
                    }
                    return true;
                }
                allNodes = allNodes.tail;
            }
            nodesList = nodesList.tail;
        }
        return false;
    }

    private TapPair<NewBlockGraphNode, NewBlockGraphNode> condenseNewNode(NewBlockGraphNode newNode, boolean atTail) {
        TapList<NewBlockGraphNode> notAllowedList = new TapList<NewBlockGraphNode>(newNode, null);
        NewBlockGraphNode fuseOrigin = null;
        NewBlockGraphNode fuseTarget = null;
        if (atTail) {
            fuseTarget = newNode;
            TapList<NewBlockGraphArrow> before = newNode.backFlow;
            while (before != null) {
                TapList<NewBlockGraphArrow> beforeBefore = ((NewBlockGraphArrow)before.head).origin().backFlow;
                while (beforeBefore != null) {
                    this.accumulateNodeAndPredecessors(((NewBlockGraphArrow)beforeBefore.head).origin(), notAllowedList);
                    beforeBefore = beforeBefore.tail;
                }
                before = before.tail;
            }
        } else {
            fuseOrigin = newNode;
            TapList<NewBlockGraphArrow> after = newNode.flow;
            while (after != null) {
                TapList<NewBlockGraphArrow> afterAfter = ((NewBlockGraphArrow)after.head).destination().flow;
                while (afterAfter != null) {
                    this.accumulateNodeAndSuccessors(((NewBlockGraphArrow)afterAfter.head).destination(), notAllowedList);
                    afterAfter = afterAfter.tail;
                }
                after = after.tail;
            }
        }
        TapList<NewBlockGraphNode> allNodes = this.nodes;
        while (allNodes != null) {
            if (!TapList.contains(notAllowedList, allNodes.head)) {
                if (atTail) {
                    fuseOrigin = (NewBlockGraphNode)allNodes.head;
                } else {
                    fuseTarget = (NewBlockGraphNode)allNodes.head;
                }
                if (fuseOrigin.interestingFuseWith(fuseTarget, this)) {
                    boolean originDisappears;
                    if (this.debug) {
                        TapEnv.printlnOnTrace("FUSE " + fuseOrigin + " WITH " + fuseTarget);
                    }
                    if (originDisappears = fuseOrigin.fuseWith(fuseTarget)) {
                        this.skipNodeInto(fuseOrigin, fuseTarget);
                        if (this.debug) {
                            TapEnv.printlnOnTrace("  origin disappearing into target " + fuseTarget);
                        }
                        return new TapPair<NewBlockGraphNode, NewBlockGraphNode>(fuseOrigin, fuseTarget);
                    }
                    this.skipNodeInto(fuseTarget, fuseOrigin);
                    if (this.debug) {
                        TapEnv.printlnOnTrace("  target disappearing into origin " + fuseOrigin);
                    }
                    return new TapPair<NewBlockGraphNode, NewBlockGraphNode>(fuseTarget, fuseOrigin);
                }
            }
            allNodes = allNodes.tail;
        }
        return null;
    }

    private void skipNodeInto(NewBlockGraphNode skippedNode, NewBlockGraphNode intoNode) {
        NewBlockGraphArrow arrow;
        this.nodes = TapList.delete(skippedNode, this.nodes);
        TapList<NewBlockGraphArrow> arrows = skippedNode.backFlow;
        while (arrows != null) {
            arrow = (NewBlockGraphArrow)arrows.head;
            if (arrow.origin() == intoNode) {
                arrow.redirectOrigin(null);
            } else {
                arrow.redirectDestination(intoNode);
            }
            arrows = arrows.tail;
        }
        arrows = skippedNode.flow;
        while (arrows != null) {
            arrow = (NewBlockGraphArrow)arrows.head;
            if (arrow.destination() == intoNode) {
                arrow.redirectDestination(null);
            } else {
                arrow.redirectOrigin(intoNode);
            }
            arrows = arrows.tail;
        }
    }

    protected void openGroup() {
        if (this.inGroupLevel == 0) {
            this.lastNodeInGroup = null;
        }
        ++this.inGroupLevel;
    }

    protected void closeGroup() {
        --this.inGroupLevel;
        if (this.inGroupLevel == 0) {
            this.lastNodeInGroup = null;
        }
    }

    protected void addDataDepNode(NewBlockGraphNode newNode, boolean atTail, boolean chain, boolean followPointers, boolean incrementalCondense, TapList<Tree> localUses, TapList<Tree> localDefs, TapList<Tree> localBisUses, TapList<Tree> localBisDefs) {
        TapPair<NewBlockGraphNode, NewBlockGraphNode> mergedPair;
        if (atTail) {
            if (this.nodes == null) {
                this.nodes = new TapList<NewBlockGraphNode>(newNode, null);
            } else {
                TapList<NewBlockGraphNode> inNodes = this.nodes;
                while (inNodes.tail != null) {
                    inNodes = inNodes.tail;
                }
                inNodes.tail = new TapList<NewBlockGraphNode>(newNode, null);
            }
            newNode.subOrder = this.nodeCount;
        } else {
            this.nodes = new TapList<NewBlockGraphNode>(newNode, this.nodes);
            newNode.subOrder = -this.nodeCount;
        }
        ++this.nodeCount;
        if (chain) {
            if (this.lastNodeInChain != null) {
                if (atTail) {
                    new NewBlockGraphArrow(this.lastNodeInChain, newNode);
                } else {
                    new NewBlockGraphArrow(newNode, this.lastNodeInChain);
                }
            }
            this.lastNodeInChain = newNode;
        }
        if (this.inGroupLevel > 0) {
            if (this.lastNodeInGroup != null) {
                if (atTail) {
                    new NewBlockGraphArrow(this.lastNodeInGroup, newNode);
                } else {
                    new NewBlockGraphArrow(newNode, this.lastNodeInGroup);
                }
            }
            this.lastNodeInGroup = newNode;
        }
        if (this.debug) {
            TapEnv.printlnOnTrace("ADDING NODE :" + newNode + (chain ? " CHAINED!" : ""));
            TapEnv.printlnOnTrace(" READS  Src  :" + localUses + " AND Bis " + localBisUses + " following pointers:" + followPointers);
            TapEnv.printlnOnTrace(" WRITES Src  :" + localDefs + " AND Bis " + localBisDefs + " following pointers:" + followPointers);
        }
        this.reallocateIfNeeded(localUses, localDefs, localBisUses, localBisDefs, newNode.srcInstruction, followPointers);
        this.setDepends(newNode, atTail, followPointers, false, localUses, localDefs, this.visibleSrcUses, this.visibleSrcDefs);
        this.setDepends(newNode, atTail, followPointers, true, localBisUses, localBisDefs, this.visibleBisUses, this.visibleBisDefs);
        if (incrementalCondense && (mergedPair = this.condenseNewNode(newNode, atTail)) != null) {
            NewBlockGraphNode mergedNode = (NewBlockGraphNode)mergedPair.first;
            NewBlockGraphNode intoNode = (NewBlockGraphNode)mergedPair.second;
            this.replaceInUseDefs(mergedNode, intoNode, this.visibleSrcUses);
            this.replaceInUseDefs(mergedNode, intoNode, this.visibleBisUses);
            this.replaceInUseDefs(mergedNode, intoNode, this.visibleSrcDefs);
            this.replaceInUseDefs(mergedNode, intoNode, this.visibleBisDefs);
            if (this.lastNodeInChain == mergedNode) {
                this.lastNodeInChain = intoNode;
            }
            if (this.lastNodeInGroup == mergedNode) {
                this.lastNodeInGroup = intoNode;
            }
        }
    }

    private void reallocateIfNeeded(TapList<Tree> nodeUses, TapList<Tree> nodeDefs, TapList<Tree> nodeBisUses, TapList<Tree> nodeBisDefs, Instruction instruction, boolean followPointers) {
        TapIntList zones;
        Tree newTree;
        int maxZone = -1;
        while (nodeDefs != null) {
            newTree = (Tree)nodeDefs.head;
            zones = this.listAllZonesPossiblyFollowingPointers(newTree, instruction, followPointers);
            while (zones != null) {
                if (zones.head > maxZone) {
                    maxZone = zones.head;
                }
                zones = zones.tail;
            }
            nodeDefs = nodeDefs.tail;
        }
        while (nodeUses != null) {
            newTree = (Tree)nodeUses.head;
            zones = this.listAllZonesPossiblyFollowingPointers(newTree, instruction, followPointers);
            while (zones != null) {
                if (zones.head > maxZone) {
                    maxZone = zones.head;
                }
                zones = zones.tail;
            }
            nodeUses = nodeUses.tail;
        }
        while (nodeBisDefs != null) {
            newTree = (Tree)nodeBisDefs.head;
            zones = this.listAllZonesPossiblyFollowingPointers(newTree, instruction, followPointers);
            while (zones != null) {
                if (zones.head > maxZone) {
                    maxZone = zones.head;
                }
                zones = zones.tail;
            }
            nodeBisDefs = nodeBisDefs.tail;
        }
        while (nodeBisUses != null) {
            newTree = (Tree)nodeBisUses.head;
            zones = this.listAllZonesPossiblyFollowingPointers(newTree, instruction, followPointers);
            while (zones != null) {
                if (zones.head > maxZone) {
                    maxZone = zones.head;
                }
                zones = zones.tail;
            }
            nodeBisUses = nodeBisUses.tail;
        }
        int oldMaxZone = this.visibleSrcUses.length - 2;
        if (maxZone > oldMaxZone) {
            int i;
            int oldLen = this.visibleSrcUses.length;
            int newLen = maxZone + 6;
            TapList[] newVisibleSrcUses = new TapList[newLen];
            TapList[] newVisibleBisUses = new TapList[newLen];
            TapList[] newVisibleSrcDefs = new TapList[newLen];
            TapList[] newVisibleBisDefs = new TapList[newLen];
            for (i = newLen - 1; i >= oldLen; --i) {
                newVisibleSrcUses[i] = null;
                newVisibleBisUses[i] = null;
                newVisibleSrcDefs[i] = null;
                newVisibleBisDefs[i] = null;
            }
            for (i = oldLen - 1; i >= 0; --i) {
                newVisibleSrcUses[i] = this.visibleSrcUses[i];
                newVisibleBisUses[i] = this.visibleBisUses[i];
                newVisibleSrcDefs[i] = this.visibleSrcDefs[i];
                newVisibleBisDefs[i] = this.visibleBisDefs[i];
            }
            this.visibleSrcUses = newVisibleSrcUses;
            this.visibleBisUses = newVisibleBisUses;
            this.visibleSrcDefs = newVisibleSrcDefs;
            this.visibleBisDefs = newVisibleBisDefs;
        }
    }

    private void replaceInUseDefs(NewBlockGraphNode mergedNode, NewBlockGraphNode intoNode, TapList<TapPair<Tree, NewBlockGraphNode>>[] visibleNodes) {
        for (int i = visibleNodes.length - 1; i >= 0; --i) {
            TapList<TapPair<Tree, NewBlockGraphNode>> visib = visibleNodes[i];
            while (visib != null) {
                NewBlockGraphNode oldNode = (NewBlockGraphNode)((TapPair)visib.head).second;
                if (oldNode == mergedNode) {
                    ((TapPair)visib.head).second = intoNode;
                }
                visib = visib.tail;
            }
        }
    }

    private void setDepends(NewBlockGraphNode newNode, boolean atTail, boolean followPointers, boolean isDiff, TapList<Tree> nodeUses, TapList<Tree> nodeDefs, TapList<TapPair<Tree, NewBlockGraphNode>>[] visibleUses, TapList<TapPair<Tree, NewBlockGraphNode>>[] visibleDefs) {
        TapList<Tree> inNodeUses;
        int zone;
        TapIntList zones;
        Tree newTree;
        Instruction instruction = newNode.srcInstruction;
        Unit curUnit = instruction == null ? null : instruction.block.unit();
        int nbPublicZones = curUnit == null ? 0 : curUnit.publicSymbolTable().declaredZonesNb(0);
        TapList<Tree> inNodeDefs = nodeDefs;
        while (inNodeDefs != null) {
            newTree = (Tree)inNodeDefs.head;
            zones = this.listAllZonesPossiblyFollowingPointers(newTree, instruction, followPointers);
            if (this.debug) {
                TapEnv.printlnOnTrace((isDiff ? "Bis " : "Src ") + newTree + " writes " + zones);
            }
            while (zones != null) {
                zone = zones.head;
                if (zone >= -1) {
                    this.setDepsForOneZone(newNode, newTree, zone + 1, visibleUses, isDiff ? "visibleBisUses" : "visibleSrcUses", nbPublicZones, atTail);
                    this.setDepsForOneZone(newNode, newTree, zone + 1, visibleDefs, isDiff ? "visibleBisDefs" : "visibleSrcDefs", nbPublicZones, atTail);
                }
                zones = zones.tail;
            }
            inNodeDefs = inNodeDefs.tail;
        }
        if (atTail) {
            inNodeUses = nodeUses;
            while (inNodeUses != null) {
                newTree = (Tree)inNodeUses.head;
                zones = this.listAllZonesPossiblyFollowingPointers(newTree, instruction, followPointers);
                if (this.debug) {
                    TapEnv.printlnOnTrace((isDiff ? "Bis " : "Src ") + newTree + "  reads " + zones);
                }
                while (zones != null) {
                    zone = zones.head;
                    if (zone >= -1) {
                        this.setDepsForOneZone(newNode, newTree, zone + 1, visibleDefs, isDiff ? "visibleBisDefs" : "visibleSrcDefs", nbPublicZones, atTail);
                        if (this.debug) {
                            TapEnv.printlnOnTrace("                " + (isDiff ? "visibleBisUses" : "visibleSrcUses") + " of zone <" + zone + "> receive " + newTree + " from node " + newNode);
                        }
                        visibleUses[zone + 1] = new TapList<TapPair<Tree, NewBlockGraphNode>>(new TapPair<Tree, NewBlockGraphNode>(newTree, newNode), visibleUses[zone + 1]);
                    }
                    zones = zones.tail;
                }
                inNodeUses = inNodeUses.tail;
            }
        }
        inNodeDefs = nodeDefs;
        while (inNodeDefs != null) {
            newTree = (Tree)inNodeDefs.head;
            zones = this.listAllZonesPossiblyFollowingPointers(newTree, instruction, followPointers);
            while (zones != null) {
                zone = zones.head;
                if (zone >= -1) {
                    if (this.debug) {
                        TapEnv.printlnOnTrace("                " + (isDiff ? "visibleBisDefs" : "visibleSrcDefs") + " of zone <" + zone + "> receive " + newTree + " from node " + newNode);
                    }
                    visibleDefs[zone + 1] = new TapList<TapPair<Tree, NewBlockGraphNode>>(new TapPair<Tree, NewBlockGraphNode>(newTree, newNode), visibleDefs[zone + 1]);
                }
                zones = zones.tail;
            }
            inNodeDefs = inNodeDefs.tail;
        }
        if (!atTail) {
            inNodeUses = nodeUses;
            while (inNodeUses != null) {
                newTree = (Tree)inNodeUses.head;
                zones = this.listAllZonesPossiblyFollowingPointers(newTree, instruction, followPointers);
                if (this.debug) {
                    TapEnv.printlnOnTrace((isDiff ? "Bis " : "Src ") + newTree + "  reads " + zones);
                }
                while (zones != null) {
                    zone = zones.head;
                    if (zone >= -1) {
                        this.setDepsForOneZone(newNode, newTree, zone + 1, visibleDefs, isDiff ? "visibleBisDefs" : "visibleSrcDefs", nbPublicZones, atTail);
                        if (this.debug) {
                            TapEnv.printlnOnTrace("                " + (isDiff ? "visibleBisUses" : "visibleSrcUses") + " of zone <" + zone + "> receive " + newTree + " from node " + newNode);
                        }
                        visibleUses[zone + 1] = new TapList<TapPair<Tree, NewBlockGraphNode>>(new TapPair<Tree, NewBlockGraphNode>(newTree, newNode), visibleUses[zone + 1]);
                    }
                    zones = zones.tail;
                }
                inNodeUses = inNodeUses.tail;
            }
        }
    }

    private TapIntList listAllZonesPossiblyFollowingPointers(Tree expression, Instruction instruction, boolean followPointers) {
        TapList<?> zonesTree = this.symbolTable.treeOfZonesOfValue(expression, null, instruction, null);
        if (followPointers) {
            zonesTree = TapList.copyTree(zonesTree);
            DataFlowAnalyzer.includePointedElementsInTree(zonesTree, null, null, true, this.symbolTable, instruction, null, false, false);
        }
        return ZoneInfo.listAllZones(zonesTree, true);
    }

    private void setDepsForOneZone(NewBlockGraphNode newNode, Tree newTree, int newZoneRk, TapList<TapPair<Tree, NewBlockGraphNode>>[] visibleRefs, String visibleName, int nbPublicZones, boolean atTail) {
        for (int zrk = visibleRefs.length - 1; zrk >= 0; --zrk) {
            boolean isUndefCase;
            boolean bl = isUndefCase = zrk == 0 && visibleRefs[0] != null && newZoneRk <= nbPublicZones || newZoneRk == 0 && zrk <= nbPublicZones;
            if (this.debug && isUndefCase) {
                TapEnv.printlnOnTrace("     Warning: undef case " + newZoneRk + "->" + zrk + " full deps!");
            }
            if (!isUndefCase && zrk != newZoneRk) continue;
            TapList<TapPair<Tree, NewBlockGraphNode>> oldRefs = visibleRefs[zrk];
            if (this.debug) {
                TapEnv.printlnOnTrace("                " + visibleName + " of zone <" + (zrk - 1) + "> are " + oldRefs);
            }
            while (oldRefs != null) {
                NewBlockGraphNode oldNode = (NewBlockGraphNode)((TapPair)oldRefs.head).second;
                Tree oldTree = (Tree)((TapPair)oldRefs.head).first;
                if (newNode != oldNode) {
                    if (atTail) {
                        if (!NewBlockGraph.existsArrow(oldNode, newNode) && (isUndefCase || this.refsMayOverlap(newTree, newNode.srcInstruction, oldTree, oldNode.srcInstruction))) {
                            new NewBlockGraphArrow(oldNode, newNode);
                            if (this.debug) {
                                TapEnv.printlnOnTrace(" [" + oldNode.subOrder + "]->[" + newNode.subOrder + "]");
                            }
                        }
                    } else if (!NewBlockGraph.existsArrow(newNode, oldNode) && (isUndefCase || this.refsMayOverlap(oldTree, oldNode.srcInstruction, newTree, newNode.srcInstruction))) {
                        new NewBlockGraphArrow(newNode, oldNode);
                        if (this.debug) {
                            TapEnv.printlnOnTrace(" [" + newNode.subOrder + "]->[" + oldNode.subOrder + "]");
                        }
                    }
                }
                oldRefs = oldRefs.tail;
            }
        }
    }

    private boolean refsMayOverlap(Tree tree1, Instruction instr1, Tree tree2, Instruction instr2) {
        return ILUtils.eqOrDisjointRef(tree1, tree2, instr1, instr2) != -1;
    }

    protected TapList<NewBlockGraphNode> topoSort() {
        NewBlockGraphNode node;
        TapList<NewBlockGraphNode> result = null;
        TapList<NewBlockGraphNode> inNodes = this.nodes;
        TapList<Object> freeList = new TapList<Object>(null, null);
        while (inNodes != null) {
            node = (NewBlockGraphNode)inNodes.head;
            node.nbDeps = TapList.length(node.flow);
            if (node.nbDeps == 0) {
                this.insertNodeIntoFreeList(node, freeList);
            }
            inNodes = inNodes.tail;
        }
        while (freeList.tail != null) {
            node = (NewBlockGraphNode)freeList.tail.head;
            freeList.tail = freeList.tail.tail;
            result = new TapList<NewBlockGraphNode>(node, result);
            TapList<NewBlockGraphArrow> origins = node.backFlow;
            while (origins != null) {
                NewBlockGraphNode origNode = ((NewBlockGraphArrow)origins.head).origin();
                --origNode.nbDeps;
                if (origNode.nbDeps == 0) {
                    this.insertNodeIntoFreeList(origNode, freeList);
                }
                origins = origins.tail;
            }
        }
        if (TapList.length(result) != TapList.length(this.nodes)) {
            TapEnv.printlnOnTrace("WARNING lost nodes from " + this.nodes);
            TapEnv.printlnOnTrace("     TO " + result);
        }
        return result;
    }

    private void insertNodeIntoFreeList(NewBlockGraphNode node, TapList<NewBlockGraphNode> freeList) {
        while (freeList.tail != null && ((NewBlockGraphNode)freeList.tail.head).subOrder > node.subOrder) {
            freeList = freeList.tail;
        }
        freeList.placdl(node);
    }
}

