/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.differentiation;

import fr.inria.tapenade.analysis.ADActivityAnalyzer;
import fr.inria.tapenade.analysis.ADTBRAnalyzer;
import fr.inria.tapenade.analysis.ActivityPattern;
import fr.inria.tapenade.analysis.DataFlowAnalyzer;
import fr.inria.tapenade.analysis.DiffLivenessAnalyzer;
import fr.inria.tapenade.analysis.InOutAnalyzer;
import fr.inria.tapenade.analysis.ReqExplicit;
import fr.inria.tapenade.differentiation.BlockDifferentiator;
import fr.inria.tapenade.differentiation.CallGraphDifferentiator;
import fr.inria.tapenade.differentiation.DifferentiationEnv;
import fr.inria.tapenade.differentiation.ProcedureCallDifferentiator;
import fr.inria.tapenade.differentiation.UnitCreationContext;
import fr.inria.tapenade.differentiation.UnitDiffInfo;
import fr.inria.tapenade.differentiation.VarRefDifferentiator;
import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.BasicBlock;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.BlockStorage;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.Directive;
import fr.inria.tapenade.representation.EntryBlock;
import fr.inria.tapenade.representation.ExitBlock;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.FunctionTypeSpec;
import fr.inria.tapenade.representation.HeaderBlock;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.IterDescriptor;
import fr.inria.tapenade.representation.LoopBlock;
import fr.inria.tapenade.representation.ModifiedTypeSpec;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.PublicInfo;
import fr.inria.tapenade.representation.RefDescriptor;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TemporaryBlock;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.BoolMatrix;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.ToObject;
import fr.inria.tapenade.utils.Tree;

public final class FlowGraphDifferentiator {
    private final DifferentiationEnv adEnv;
    protected TapPair<NewSymbolHolder, WrapperTypeSpec> toBranchVariable;
    protected TapList<NewSymbolHolder> toChunklengthVariable;
    protected TapList<NewSymbolHolder> toFwdChunklengthVariable;
    protected TapList<NewSymbolHolder> toChunkoldVariable;
    protected TapList<NewSymbolHolder> toDiffchunkoldVariable;
    private FwdBwdVarTool adOmpChunkStartVarTool;
    private FwdBwdVarTool adOmpChunkEndVarTool;
    private NewSymbolHolder ompChunksNumVariable;
    private NewSymbolHolder ompChunksIndexVariable;
    private Tree ompChunksOriginalIndex;
    private Tree ompChunksOriginalIndexFwd;
    private String adToStr;
    private String adFromStr;
    private String adStrideStr;
    private String adCountStr;
    private String adOmpChunkStartStr;
    private String adOmpChunkEndStr;
    protected boolean keepEmptyDiffBlocks;
    private boolean alteredStaticAnalysis;
    protected int debugPointsCounter;
    private BoolVector tangentDiffReinitChecker;
    private TapList<TapPair<Tree, Tree>> toDuplicateVars;
    private BlockStorage<FlowGraphLevel> blockToPlainLevel;
    private TapList<TapPair<Block, FlowGraphLevel>> additionalBlockToPlainLevel;
    protected Tree returnedVariable;
    private HeaderBlock naturalLoopHeader = null;
    private TapList<TapPair<Instruction, Block>> realOrigBlockOfReturns;

    private CallGraphDifferentiator callGraphDifferentiator() {
        return this.adEnv.callGraphDifferentiator;
    }

    private BlockDifferentiator blockDifferentiator() {
        return this.adEnv.blockDifferentiator;
    }

    private ProcedureCallDifferentiator procedureCallDifferentiator() {
        return this.adEnv.procedureCallDifferentiator;
    }

    private VarRefDifferentiator varRefDifferentiator() {
        return this.adEnv.varRefDifferentiator;
    }

    private boolean multiDirMode() {
        return this.adEnv.multiDirMode;
    }

    private String[][] suffixes() {
        return this.adEnv.suffixes;
    }

    private ADActivityAnalyzer activityAnalyzer() {
        return TapEnv.adActivityAnalyzer();
    }

    private Unit curDiffUnit() {
        return this.adEnv.curDiffUnit;
    }

    private Unit curFwdDiffUnit() {
        return this.adEnv.curFwdDiffUnit;
    }

    private int curDiffUnitSort() {
        return this.adEnv.curDiffUnitSort;
    }

    private int curDiffVarSort() {
        return this.adEnv.curDiffVarSort;
    }

    private int[] curVectorMap() {
        return this.adEnv.curVectorMap;
    }

    private int[] curPtrVectorMap() {
        return this.adEnv.curPtrVectorMap;
    }

    protected FlowGraphDifferentiator(DifferentiationEnv adEnv) {
        this.adEnv = adEnv;
    }

    protected void differentiateProcedure() {
        Unit unit = this.adEnv.curActivity().unit();
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace(" ================== DIFFERENTIATION OF UNIT " + unit.name() + " : ==================");
            TapEnv.printlnOnTrace("                    FOR ACTIVITY PATTERN:" + this.adEnv.curActivity());
            TapEnv.setTraceIndent(0);
        }
        if (unit.publicSymbolTable().isCaseDependent()) {
            this.adFromStr = "adFrom";
            this.adStrideStr = "adStride";
            this.adToStr = "adTo";
            this.adCountStr = "adCount";
            this.adOmpChunkStartStr = "chunkStart";
            this.adOmpChunkEndStr = "chunkEnd";
        } else {
            this.adFromStr = "ad_from";
            this.adStrideStr = "ad_stride";
            this.adToStr = "ad_to";
            this.adCountStr = "ad_count";
            this.adOmpChunkStartStr = "chunk_start";
            this.adOmpChunkEndStr = "chunk_end";
        }
        this.adEnv.unitUsefulnesses = this.adEnv.curActivity().usefulnesses();
        this.adEnv.unitActivities = this.adEnv.curActivity().activities();
        this.adEnv.unitReqXs = this.adEnv.curActivity().reqXs();
        this.adEnv.unitAvlXs = this.adEnv.curActivity().avlXs();
        if (TapEnv.adTbrAnalyzer() != null) {
            this.adEnv.unitTBRs = this.adEnv.curActivity().tbrs();
            this.adEnv.unitRecomputations = this.adEnv.curActivity().recomps();
        } else {
            this.adEnv.unitTBRs = null;
            this.adEnv.unitRecomputations = null;
        }
        this.adEnv.setCurSymbolTable(unit.publicSymbolTable());
        this.adEnv.hiddenPushPopVariables.tail = null;
        this.adEnv.hiddenInstrumentedVariables.tail = null;
        this.blockToPlainLevel = new BlockStorage(unit);
        this.additionalBlockToPlainLevel = null;
        FlowGraphLevel topFlowGraphLevel = this.buildTreeOfDiffLevels(new TapList<Block>(unit.entryBlock(), unit.topBlocks()), 2);
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printlnOnTrace(" ----------- Tree of FlowGraphLevel's: --------------------------");
            this.tracePrintFlowGraphLevel(topFlowGraphLevel, 0);
            TapEnv.printlnOnTrace();
        }
        if (TapEnv.mustTangent()) {
            this.callGraphDifferentiator().unitDiffTimer.reset();
            TapEnv.printOnTrace(15, "@@ Tangent" + (this.adEnv.curActivity().isContext() ? "-context" : "") + " differentiation of procedure: " + unit.name() + " for activity pattern " + this.adEnv.curActivity());
            this.adEnv.setCurDiffSorts(1, 1);
            this.keepEmptyDiffBlocks = TapEnv.debugAdMode() == 1 || TapEnv.debugAdMode() == -1;
            this.differentiateProcedureInMode(1, topFlowGraphLevel);
            TapEnv.printlnOnTrace(15, ", time " + this.callGraphDifferentiator().unitDiffTimer.elapsed() + " s");
        }
        if (TapEnv.mustAdjoint()) {
            this.adEnv.setCurDiffSorts(2, 2);
            if (TapEnv.doOpenMP()) {
                TapEnv.multithreadAnalyzer().analyzeSharedAdjointConflicts(this.adEnv.curUnit(), this.adEnv.curActivity(), this.adEnv.callGraphDifferentiator);
            }
            boolean bl = this.keepEmptyDiffBlocks = !this.adEnv.curActivity().isContext() && (TapEnv.debugAdMode() == -1 || !TapEnv.removeDeadControl() || !TapEnv.removeDeadPrimal());
            if (unit.mustDifferentiateSplit() && !this.adEnv.curActivity().isContext()) {
                this.callGraphDifferentiator().unitDiffTimer.reset();
                TapEnv.printOnTrace(15, "@@ Reverse differentiation (split) of procedure: " + unit.name() + " for activity pattern " + this.adEnv.curActivity());
                this.differentiateProcedureInMode(-2, topFlowGraphLevel);
                TapEnv.printlnOnTrace(15, ", time " + this.callGraphDifferentiator().unitDiffTimer.elapsed() + " s");
            }
            if (unit.mustDifferentiateJoint() || !unit.mustDifferentiateSplit() || this.adEnv.curActivity().isContext()) {
                this.callGraphDifferentiator().unitDiffTimer.reset();
                TapEnv.printOnTrace(15, "@@ Reverse" + (this.adEnv.curActivity().isContext() ? "-context" : "") + " differentiation" + (this.adEnv.curActivity().isContext() ? "" : " (joint)") + " of procedure: " + unit.name() + " for activity pattern " + this.adEnv.curActivity());
                this.differentiateProcedureInMode(-1, topFlowGraphLevel);
                TapEnv.printlnOnTrace(15, ", time " + this.callGraphDifferentiator().unitDiffTimer.elapsed() + " s");
            }
        }
        this.summarizeHiddenVariables(this.adEnv.hiddenDiffInitVariables, "initialize derivative of");
        this.summarizeHiddenVariables(this.adEnv.hiddenPushPopVariables, "save");
        this.summarizeHiddenVariables(this.adEnv.hiddenInstrumentedVariables, "instrument");
        this.blockToPlainLevel = null;
        this.additionalBlockToPlainLevel = null;
    }

    private void summarizeHiddenVariables(TapList<TapPair<Object, TapList<String>>> toHiddenVariables, String actionName) {
        while (toHiddenVariables.tail != null) {
            TapList rootNames = (TapList)((TapPair)toHiddenVariables.tail.head).second;
            if (rootNames != null) {
                Object key = ((TapPair)toHiddenVariables.tail.head).first;
                String fromPlace = key instanceof String ? "COMMON " + key : (key instanceof Unit ? (((Unit)key).isModule() ? "MODULE " + ((Unit)key).name() : (((Unit)key).isStandard() ? "PROCEDURE " + ((Unit)key).name() : "UNIT " + ((Unit)key).name())) : "?? " + key);
                String varNames = "";
                while (rootNames != null) {
                    if (!((String)rootNames.head).equals("%all_io_streams%") && !CallGraph.isMessagePassingChannelName((String)rootNames.head)) {
                        varNames = varNames + (String)rootNames.head + ", ";
                    }
                    rootNames = rootNames.tail;
                }
                if (!varNames.isEmpty()) {
                    TapEnv.fileWarning(15, null, "(AD14) Summary: differentiated procedure of " + this.adEnv.curUnit().name() + " needs to " + actionName + " hidden variables " + varNames + "from " + fromPlace);
                }
            }
            toHiddenVariables.tail = toHiddenVariables.tail.tail;
        }
    }

    private FlowGraphLevel buildTreeOfDiffLevels(TapList<Block> levelBlocks, int levelKind) {
        TapList<Object> toContents;
        FlowGraphLevel result = new FlowGraphLevel(levelKind);
        Block block = (Block)levelBlocks.head;
        result.entryPoint = new FlowGraphLevel(block instanceof EntryBlock ? 1 : 0);
        result.entryPoint.entryBlock = block;
        result.entryPoint.entryArrows = block.backFlow();
        result.entryPoint.exitArrows = block.flow();
        result.entryPoint.enclosing = result;
        result.entryPoint.trueEnclosing = result;
        result.entryBlock = block;
        this.blockToPlainLevel.store(block, result.entryPoint);
        levelBlocks = levelBlocks.tail;
        TapList<Object> tlContents = toContents = new TapList<Object>(null, null);
        while (levelBlocks != null) {
            FlowGraphLevel subLevel;
            int subLevelKind;
            block = (Block)levelBlocks.head;
            if (block instanceof LoopBlock) {
                block = (Block)((LoopBlock)block).inside.head;
            }
            if ((subLevelKind = this.findBlockLoopKind(block, this.adEnv.curUnitIsContext)) == 0 || subLevelKind == 5) {
                subLevel = new FlowGraphLevel(0);
                subLevel.entryBlock = block;
                subLevel.entryArrows = block.backFlow();
                subLevel.exitArrows = block.flow();
                this.blockToPlainLevel.store(block, subLevel);
                if (subLevelKind == 5) {
                    levelBlocks = TapList.append(block.enclosingLoop().inside, levelBlocks.tail);
                }
            } else {
                subLevel = this.buildTreeOfDiffLevels(block.enclosingLoop().inside, subLevelKind);
            }
            subLevel.enclosing = result;
            subLevel.trueEnclosing = result;
            tlContents = tlContents.placdl(subLevel);
            levelBlocks = levelBlocks.tail;
        }
        result.contents = toContents.tail;
        this.insertLevelStructuredLevels(result);
        if (!this.adEnv.curUnitIsContext) {
            this.insertLevelStartEndLevelsRec(result);
        }
        this.collectLevelEntryExitArrows(result);
        return result;
    }

    private void insertLevelStructuredLevels(FlowGraphLevel containerLevel) {
        TapList flatContents = containerLevel.contents;
        containerLevel.contents = null;
        TapList inContents = flatContents;
        while (inContents != null) {
            Block block = ((FlowGraphLevel)inContents.head).entryBlock;
            TapList<Instruction> blockControls = block.parallelControls;
            FlowGraphLevel controllerLevel = this.getSetParallelLevels(blockControls, containerLevel, ((FlowGraphLevel)containerLevel).entryBlock.parallelControls);
            if (block.isParallelController()) {
                this.getSetParallelLevel(block, controllerLevel);
            } else {
                this.addOtherLevel((FlowGraphLevel)inContents.head, controllerLevel);
            }
            inContents = inContents.tail;
        }
    }

    private FlowGraphLevel getSetParallelLevels(TapList<Instruction> blockControls, FlowGraphLevel containerLevel, TapList<Instruction> outsideBlockControls) {
        if (blockControls != outsideBlockControls) {
            containerLevel = this.getSetParallelLevels(blockControls.tail, containerLevel, outsideBlockControls);
            containerLevel = this.getSetParallelLevel(((Instruction)blockControls.head).block, containerLevel);
        }
        return containerLevel;
    }

    private FlowGraphLevel getSetParallelLevel(Block controlBlock, FlowGraphLevel containerLevel) {
        TapList<Object> toContents = new TapList<Object>(null, containerLevel.contents);
        TapList<Object> inContents = toContents;
        FlowGraphLevel found = null;
        while (found == null && inContents.tail != null) {
            if (((FlowGraphLevel)inContents.tail.head).entryBlock == controlBlock) {
                found = (FlowGraphLevel)inContents.tail.head;
            }
            inContents = inContents.tail;
        }
        if (found == null) {
            found = new FlowGraphLevel(14);
            found.entryPoint = this.blockToPlainLevel.retrieve(controlBlock);
            found.entryPoint.enclosing = found;
            found.entryPoint.trueEnclosing = found;
            found.entryBlock = controlBlock;
            found.enclosing = containerLevel;
            found.trueEnclosing = containerLevel;
            inContents.placdl(found);
            containerLevel.contents = toContents.tail;
        }
        return found;
    }

    private void addOtherLevel(FlowGraphLevel otherLevel, FlowGraphLevel containerLevel) {
        if (!TapList.contains(containerLevel.contents, otherLevel)) {
            containerLevel.contents = TapList.addLast(containerLevel.contents, otherLevel);
            otherLevel.enclosing = containerLevel;
            otherLevel.trueEnclosing = containerLevel;
        }
    }

    private boolean oneExitOutside(LoopBlock loopBlock) {
        TapList<FGArrow> exitFlow = loopBlock.flow();
        boolean exitsOutside = false;
        while (exitFlow != null && !exitsOutside) {
            exitsOutside = ((FGArrow)exitFlow.head).topmostPop() != loopBlock;
            exitFlow = exitFlow.tail;
        }
        return exitsOutside;
    }

    private int findBlockLoopKind(Block block, boolean unitIsContext) {
        int kind = 0;
        if (block instanceof HeaderBlock) {
            Instruction loopInstr = block.headInstr();
            LoopBlock loopBlock = block.enclosingLoop();
            if (loopBlock.entryBlocks == null || loopBlock.entryBlocks.tail != null || loopBlock.flow() == null) {
                kind = 5;
            } else if (loopBlock.exitBlocks.tail == null && loopBlock.exitBlocks.head == block && block.instructions != null && block.instructions.tail == null && block.headInstr().tree.opCode() == 121) {
                switch (loopInstr.tree.down(3).opCode()) {
                    case 189: {
                        if (!unitIsContext && loopInstr.hasDirective(13) != null) {
                            kind = 11;
                            break;
                        }
                        kind = 8;
                        break;
                    }
                    case 196: 
                    case 206: {
                        if (!unitIsContext && loopInstr.hasDirective(13) != null) {
                            kind = 11;
                            break;
                        }
                        kind = 9;
                        break;
                    }
                    case 64: {
                        if (!unitIsContext && loopInstr.hasDirective(13) != null) {
                            kind = 11;
                            break;
                        }
                        kind = 10;
                        break;
                    }
                    case 79: {
                        if (!unitIsContext && loopInstr.hasDirective(13) != null) {
                            kind = 11;
                            break;
                        }
                        kind = 6;
                        break;
                    }
                    default: {
                        kind = 5;
                        break;
                    }
                }
            } else {
                kind = ((Block)loopBlock.exitBlocks.head).enclosingLoop() == loopBlock ? 6 : 5;
            }
            if (TapEnv.mustAdjoint() && !unitIsContext && loopInstr != null && loopInstr.hasDirective(23) != null && kind != 11 && kind != 5 && (kind != 6 || loopBlock.exitBlocks.tail == null)) {
                kind = 13;
                loopBlock.isFixedPoint = true;
            }
        }
        return kind;
    }

    private void insertLevelStartEndLevelsRec(FlowGraphLevel fgLevel) {
        TapList inContents = fgLevel.contents;
        while (inContents != null) {
            FlowGraphLevel insideLevel = (FlowGraphLevel)inContents.head;
            if (insideLevel.levelKind == 14) {
                this.insertLevelStartEndLevelsRec(insideLevel);
            }
            inContents = inContents.tail;
        }
        this.insertLevelStartEndLevels(fgLevel);
    }

    private void insertLevelStartEndLevels(FlowGraphLevel level) {
        TapList<Directive> directives;
        Block arrowOrig;
        TapList<Directive> newRegionList;
        FlowGraphLevel destSubLevel;
        FlowGraphLevel origSubLevel;
        TapList<FGArrow> backFlow;
        TapList<Directive> incomingRegionList;
        Block block;
        FlowGraphLevel curSubLevel;
        TapList flatContents = level.contents;
        level.contents = null;
        BlockStorage<TapList<Directive>> regionLists = new BlockStorage<TapList<Directive>>(this.adEnv.curUnit());
        TapList<FlowGraphLevel> workList = new TapList<FlowGraphLevel>(level.entryPoint, null);
        while (workList != null) {
            curSubLevel = (FlowGraphLevel)workList.head;
            block = curSubLevel.entryBlock;
            workList = workList.tail;
            if (curSubLevel == level.entryPoint) {
                incomingRegionList = new TapList<Directive>(null, null);
            } else {
                backFlow = curSubLevel.entryBlock.backFlow();
                incomingRegionList = null;
                while (backFlow != null) {
                    origSubLevel = level.getRepresentantInLevel(((FGArrow)backFlow.head).origin);
                    destSubLevel = level.getRepresentantInLevel(((FGArrow)backFlow.head).destination);
                    if (!(origSubLevel == null || destSubLevel == level.entryPoint && ((FGArrow)backFlow.head).isCyclingArrow() || (newRegionList = (TapList<Directive>)regionLists.retrieve(arrowOrig = origSubLevel.entryBlock)) == null)) {
                        incomingRegionList = incomingRegionList == null ? newRegionList : FlowGraphDifferentiator.intersectEnclosingStartEndRegions(incomingRegionList, newRegionList);
                    }
                    backFlow = backFlow.tail;
                }
                if (incomingRegionList != null && block != null && block.instructions != null) {
                    TapList<Directive> directives2 = block.headInstr().directives;
                    while (directives2 != null) {
                        Directive directive = (Directive)directives2.head;
                        switch (directive.type) {
                            case 16: 
                            case 21: 
                            case 28: {
                                if (TapList.contains(incomingRegionList, directive)) break;
                                incomingRegionList = new TapList<Object>(directive, (TapList<Object>)incomingRegionList);
                                break;
                            }
                            case 17: 
                            case 22: 
                            case 29: {
                                Directive startDir = Directive.hasDirective(incomingRegionList, Directive.startKind(directive.type), directive.label);
                                if (startDir == null) break;
                                incomingRegionList = TapList.safeDelete(startDir, incomingRegionList);
                                break;
                            }
                        }
                        directives2 = directives2.tail;
                    }
                }
            }
            if (incomingRegionList == null || FlowGraphDifferentiator.equalEnclosingStartEndRegions(incomingRegionList, (TapList)regionLists.retrieve(block))) continue;
            regionLists.store(block, incomingRegionList);
            TapList<FGArrow> flow = curSubLevel.entryBlock.flow();
            while (flow != null) {
                destSubLevel = level.getRepresentantInLevel(((FGArrow)flow.head).destination);
                if (destSubLevel != null) {
                    workList = new TapList<FlowGraphLevel>(destSubLevel, workList);
                }
                flow = flow.tail;
            }
        }
        TapList inContents = flatContents;
        while (inContents != null) {
            curSubLevel = (FlowGraphLevel)inContents.head;
            block = curSubLevel.entryBlock;
            backFlow = block.backFlow();
            TapList<FGArrow> flow = block.flow();
            incomingRegionList = null;
            boolean nestingPb = false;
            while (backFlow != null) {
                origSubLevel = level.getRepresentantInLevel(((FGArrow)backFlow.head).origin);
                destSubLevel = level.getRepresentantInLevel(((FGArrow)backFlow.head).destination);
                Block block2 = arrowOrig = origSubLevel == null ? null : origSubLevel.entryBlock;
                if (arrowOrig != null && (destSubLevel != level.entryPoint && destSubLevel != origSubLevel || !((FGArrow)backFlow.head).isCyclingArrow()) && (newRegionList = (TapList<Directive>)regionLists.retrieve(arrowOrig)) != null) {
                    if (incomingRegionList == null) {
                        incomingRegionList = newRegionList;
                    } else {
                        nestingPb = !FlowGraphDifferentiator.equalEnclosingStartEndRegions(incomingRegionList, newRegionList);
                        incomingRegionList = FlowGraphDifferentiator.intersectEnclosingStartEndRegions(incomingRegionList, newRegionList);
                    }
                }
                backFlow = backFlow.tail;
            }
            if (nestingPb) {
                TapEnv.fileWarning(15, block.headInstr().tree, "(AD18) Inconsistent program region nesting here");
            }
            if (incomingRegionList != null && block != null && block.instructions != null) {
                directives = block.headInstr().directives;
                while (directives != null) {
                    Directive directive = (Directive)directives.head;
                    switch (directive.type) {
                        case 16: 
                        case 21: 
                        case 28: {
                            if (!TapList.contains(incomingRegionList, directive)) {
                                incomingRegionList = new TapList<Object>(directive, (TapList<Object>)incomingRegionList);
                                break;
                            }
                            TapEnv.fileWarning(15, block.headInstr().tree, "(AD18) Cannot enter into program region " + directive + " twice");
                            break;
                        }
                        case 17: 
                        case 22: 
                        case 29: {
                            Directive startDir = Directive.hasDirective(incomingRegionList, Directive.startKind(directive.type), directive.label);
                            if (startDir != null) {
                                if (startDir != incomingRegionList.head) {
                                    TapEnv.fileWarning(15, block.headInstr().tree, "(AD18) Wrong nesting while exiting " + directive);
                                }
                                incomingRegionList = TapList.safeDelete(startDir, incomingRegionList);
                                break;
                            }
                            TapEnv.fileWarning(15, block.headInstr().tree, "(AD18) Cannot exit from program region " + directive + " twice");
                            break;
                        }
                    }
                    directives = directives.tail;
                }
            }
            boolean exitingPb = false;
            if (incomingRegionList != null && incomingRegionList.head != null) {
                while (flow != null) {
                    destSubLevel = level.getRepresentantInLevel(((FGArrow)flow.head).destination);
                    if (destSubLevel == null || destSubLevel == level.entryPoint) {
                        exitingPb = true;
                    }
                    flow = flow.tail;
                }
            }
            if (exitingPb) {
                TapEnv.fileWarning(15, block.headInstr().tree, "(AD18) Program region not closed in enclosing level");
            }
            inContents = inContents.tail;
        }
        TapList<TapPair<Directive, Block>> directiveEntryBlocks = null;
        TapList<FlowGraphLevel> subLevels = new TapList<FlowGraphLevel>(level.entryPoint, flatContents);
        while (subLevels != null) {
            curSubLevel = (FlowGraphLevel)subLevels.head;
            block = curSubLevel.entryBlock;
            if (block.instructions != null) {
                directives = block.headInstr().directives;
                while (directives != null) {
                    Directive directive = (Directive)directives.head;
                    switch (directive.type) {
                        case 16: 
                        case 21: 
                        case 28: {
                            directiveEntryBlocks = new TapList<TapPair<Directive, Block>>(new TapPair<Directive, Block>(directive, block), directiveEntryBlocks);
                        }
                    }
                    directives = directives.tail;
                }
            }
            subLevels = subLevels.tail;
        }
        TapList<Object> newRegionLevels = new TapList<Object>(null, null);
        TapList reverseContents = TapList.reverse(flatContents);
        while (reverseContents != null) {
            curSubLevel = (FlowGraphLevel)reverseContents.head;
            curSubLevel.enclosing = null;
            incomingRegionList = (TapList<Directive>)regionLists.retrieve(curSubLevel.entryBlock);
            if (incomingRegionList == null) {
                incomingRegionList = new TapList<Directive>(null, null);
            }
            while (incomingRegionList != null && curSubLevel != level && curSubLevel.enclosing == null) {
                Directive directive = (Directive)incomingRegionList.head;
                FlowGraphLevel aboveLevel = this.buildOrRetrieveStartEndLevel(directive, newRegionLevels, level, directiveEntryBlocks);
                if (aboveLevel != level && TapList.contains(((FlowGraphLevel)curSubLevel).entryBlock.headInstr().directives, directive)) {
                    aboveLevel.entryPoint = curSubLevel;
                    aboveLevel.entryBlock = curSubLevel.entryBlock;
                } else {
                    aboveLevel.contents = new TapList<FlowGraphLevel>(curSubLevel, aboveLevel.contents);
                }
                curSubLevel.enclosing = aboveLevel;
                curSubLevel.trueEnclosing = aboveLevel;
                curSubLevel = aboveLevel;
                incomingRegionList = incomingRegionList.tail;
            }
            reverseContents = reverseContents.tail;
        }
    }

    private static TapList<Directive> intersectEnclosingStartEndRegions(TapList<Directive> directives1, TapList<Directive> directives2) {
        TapList<Object> hdResult;
        TapList<Object> tlResult = hdResult = new TapList<Object>(null, null);
        while (directives1 != null) {
            if (TapList.contains(directives2, directives1.head)) {
                tlResult = tlResult.placdl(directives1.head);
            }
            directives1 = directives1.tail;
        }
        return hdResult.tail;
    }

    private static boolean equalEnclosingStartEndRegions(TapList<Directive> directives1, TapList<Directive> directives2) {
        if (directives1 == null && directives2 == null) {
            return true;
        }
        if (directives1 == null || directives2 == null || directives1.head != directives2.head) {
            return false;
        }
        return FlowGraphDifferentiator.equalEnclosingStartEndRegions(directives1.tail, directives2.tail);
    }

    private FlowGraphLevel buildOrRetrieveStartEndLevel(Directive directive, TapList<TapPair<Directive, FlowGraphLevel>> newRegionLevels, FlowGraphLevel outerLevel, TapList<TapPair<Directive, Block>> directiveEntryBlocks) {
        if (directive == null) {
            return outerLevel;
        }
        FlowGraphLevel result = (FlowGraphLevel)TapList.cassq(directive, newRegionLevels);
        if (result == null) {
            int kind;
            switch (directive.type) {
                case 28: {
                    kind = 15;
                    break;
                }
                case 21: {
                    kind = 12;
                    break;
                }
                case 16: {
                    kind = 4;
                    break;
                }
                default: {
                    kind = 15;
                }
            }
            result = new FlowGraphLevel(kind);
            result.label = directive.label;
            result.entryBlock = (Block)TapList.cassq(directive, directiveEntryBlocks);
            newRegionLevels.placdl(new TapPair<Directive, FlowGraphLevel>(directive, result));
        }
        return result;
    }

    private void collectLevelEntryExitArrows(FlowGraphLevel level) {
        TapList<Object> toExitArrows = new TapList<Object>(null, null);
        TapList<Object> toEntryArrows = new TapList<Object>(null, null);
        TapList<FlowGraphLevel> levelAllContents = new TapList<FlowGraphLevel>(level.entryPoint, level.contents);
        while (levelAllContents != null) {
            FlowGraphLevel subLevel = (FlowGraphLevel)levelAllContents.head;
            if (subLevel.levelKind != 0 && subLevel.levelKind != 1) {
                this.collectLevelEntryExitArrows(subLevel);
            }
            this.collectArrowsEnteringAndExitingLevel(subLevel == level.entryPoint ? subLevel.entryArrows : null, subLevel.exitArrows, level, toExitArrows, toEntryArrows);
            levelAllContents = levelAllContents.tail;
        }
        level.exitArrows = toExitArrows.tail;
        level.entryArrows = toEntryArrows.tail;
    }

    private void collectArrowsEnteringAndExitingLevel(TapList<FGArrow> arrowsTo, TapList<FGArrow> arrowsFrom, FlowGraphLevel level, TapList<FGArrow> toExitArrows, TapList<FGArrow> toEntryArrows) {
        FGArrow arrow;
        while (arrowsFrom != null) {
            arrow = (FGArrow)arrowsFrom.head;
            FlowGraphLevel destSubLevel = level.getRepresentantInLevel(arrow.destination);
            if (destSubLevel == null) {
                toExitArrows.placdl(arrow);
            } else if (destSubLevel == level.entryPoint && !arrow.isCyclingArrow()) {
                toEntryArrows.placdl(arrow);
                toExitArrows.placdl(arrow);
            }
            arrowsFrom = arrowsFrom.tail;
        }
        while (arrowsTo != null) {
            arrow = (FGArrow)arrowsTo.head;
            FlowGraphLevel origSubLevel = level.getRepresentantInLevel(arrow.origin);
            if (origSubLevel == null) {
                toEntryArrows.placdl(arrow);
            }
            arrowsTo = arrowsTo.tail;
        }
    }

    private void tracePrintFlowGraphLevel(FlowGraphLevel revDiffLevel, int indent) {
        TapEnv.indentOnTrace(indent);
        if (revDiffLevel.levelKind == 0) {
            TapEnv.printOnTrace("PLAIN_BLOCK: " + revDiffLevel.entryBlock);
        } else if (revDiffLevel.levelKind == 1) {
            TapEnv.printOnTrace("ENTRY_BLOCK: " + revDiffLevel.entryBlock);
        } else {
            switch (revDiffLevel.levelKind) {
                case 2: {
                    TapEnv.printOnTrace("TOP LEVEL");
                    break;
                }
                case 3: {
                    TapEnv.printOnTrace("PLAIN GROUP");
                    break;
                }
                case 4: {
                    TapEnv.printOnTrace("CHECKPOINT LEVEL [" + revDiffLevel.label + "]");
                    break;
                }
                case 6: {
                    TapEnv.printOnTrace("NATURAL_LOOP");
                    break;
                }
                case 7: {
                    TapEnv.printOnTrace("BINOMIAL_LOOP");
                    break;
                }
                case 8: {
                    TapEnv.printOnTrace("TIMES_LOOP");
                    break;
                }
                case 9: {
                    TapEnv.printOnTrace("WHILE_LOOP");
                    break;
                }
                case 10: {
                    TapEnv.printOnTrace("DO_LOOP");
                    break;
                }
                case 11: {
                    TapEnv.printOnTrace("II_LOOP");
                    break;
                }
                case 13: {
                    TapEnv.printOnTrace("FIXEDPOINT_LOOP");
                    break;
                }
                case 12: {
                    TapEnv.printOnTrace("NODIFF_LEVEL [" + revDiffLevel.label + "]");
                    break;
                }
                case 15: {
                    TapEnv.printOnTrace("LABELLED_REGION [" + revDiffLevel.label + "]");
                    break;
                }
                case 14: {
                    TapEnv.printOnTrace("MULTITHREAD_REGION");
                    break;
                }
                default: {
                    TapEnv.printOnTrace(revDiffLevel.levelKind + "?");
                }
            }
        }
        TapEnv.printOnTrace(" " + revDiffLevel + "   enclosed in:" + revDiffLevel.enclosing);
        if (revDiffLevel.levelKind == 0) {
            TapEnv.printOnTrace("  instructions: " + ((FlowGraphLevel)revDiffLevel).entryBlock.instructions);
        }
        TapEnv.printlnOnTrace();
        TapEnv.indentOnTrace(indent);
        TapEnv.printOnTrace(">>entryArrows: ");
        TapList arrows = revDiffLevel.entryArrows;
        while (arrows != null) {
            TapEnv.printOnTrace(arrows.head + ", ");
            arrows = arrows.tail;
        }
        TapEnv.printlnOnTrace();
        if (revDiffLevel.levelKind != 0 && revDiffLevel.levelKind != 1) {
            TapEnv.indentOnTrace(indent);
            TapEnv.printlnOnTrace(">>entryPoint:");
            this.tracePrintFlowGraphLevel(revDiffLevel.entryPoint, indent + 4);
            TapEnv.indentOnTrace(indent);
            TapEnv.printlnOnTrace(">>contents:");
            TapList contents = revDiffLevel.contents;
            while (contents != null) {
                this.tracePrintFlowGraphLevel((FlowGraphLevel)contents.head, indent + 4);
                contents = contents.tail;
            }
        }
        TapEnv.indentOnTrace(indent);
        TapEnv.printOnTrace(">>exitArrows: ");
        arrows = revDiffLevel.exitArrows;
        while (arrows != null) {
            TapEnv.printOnTrace(arrows.head + ", ");
            arrows = arrows.tail;
        }
        TapEnv.printlnOnTrace();
    }

    private void tracePrintBlock(Block block) {
        TapEnv.printOnTrace(this.traceBlockName(block) + " [");
        TapList<FGArrow> arrows = block.backFlow();
        while (arrows != null) {
            if (((FGArrow)arrows.head).origin == null || ((FGArrow)arrows.head).destination != block) {
                TapEnv.printOnTrace("!!PROBLEMATIC ARROW:" + arrows.head + "!! ");
            }
            this.tracePrintArrowTo((FGArrow)arrows.head, block);
            arrows = arrows.tail;
            if (arrows == null) continue;
            TapEnv.printOnTrace(", ");
        }
        TapEnv.printOnTrace("] --> [");
        arrows = block.flow();
        while (arrows != null) {
            if (!(block instanceof ExitBlock || ((FGArrow)arrows.head).origin == block && ((FGArrow)arrows.head).destination != null)) {
                TapEnv.printOnTrace("!!PROBLEMATIC ARROW:" + arrows.head + "!! ");
            }
            this.tracePrintArrowFrom((FGArrow)arrows.head, block);
            arrows = arrows.tail;
            if (arrows == null) continue;
            TapEnv.printOnTrace(", ");
        }
        TapEnv.printlnOnTrace("]");
        if (block.parallelControls != null) {
            TapEnv.printlnOnTrace("       Controlled by:" + block.parallelControls);
        }
        TapEnv.printOnTrace("       [");
        TapList<Instruction> instrs = block.instructions;
        while (instrs != null) {
            TapEnv.printOnTrace(ILUtils.toString(((Instruction)instrs.head).tree));
            instrs = instrs.tail;
            if (instrs == null) continue;
            TapEnv.printOnTrace(", ");
        }
        TapEnv.printlnOnTrace("]" + block.symbolTable.addressChain());
        TapEnv.printlnOnTrace();
    }

    private void tracePrintArrowTo(FGArrow arrow, Block block) {
        String origStr = "()";
        if (arrow.origin != null) {
            origStr = this.traceBlockName(arrow.origin);
        }
        String correct = arrow.destination == block ? "." : "BUG" + arrow.destination;
        TapEnv.printOnTrace(origStr + "==" + arrow.test + arrow.cases + (arrow.inACycle ? "*" : "=") + "=>" + correct);
    }

    private void tracePrintArrowFrom(FGArrow arrow, Block block) {
        String correct = arrow.origin == block ? "." : "BUG" + arrow.origin;
        String destStr = "()";
        if (arrow.destination != null) {
            destStr = this.traceBlockName(arrow.destination);
        }
        TapEnv.printOnTrace(correct + "==" + arrow.test + arrow.cases + (arrow.inACycle ? "*" : "=") + "=>" + destStr);
    }

    private String traceBlockName(Block block) {
        if (block.symbolicRk != null) {
            return block.toString();
        }
        return "B@" + Integer.toHexString(block.hashCode());
    }

    private void differentiateProcedureInMode(int adDiffMode, FlowGraphLevel topFlowGraphLevel) {
        Directive scopingsDirective;
        if (this.adEnv.someUnitsAreTraced()) {
            TapEnv.printlnOnTrace(15);
        }
        boolean modeIsTangent = adDiffMode == 1;
        boolean modeIsSplit = !this.adEnv.curActivity().isContext() && adDiffMode == -2;
        Unit unit = this.adEnv.curActivity().unit();
        UnitDiffInfo diffInfo = this.callGraphDifferentiator().getUnitDiffInfo(unit);
        this.alteredStaticAnalysis = false;
        this.returnedVariable = null;
        this.adEnv.adDiffMode = adDiffMode;
        this.adEnv.curDiffUnitPushesPointers = false;
        this.adEnv.setCurDiffUnit(modeIsTangent ? diffInfo.getTangent(this.adEnv.curActivity()) : (modeIsSplit ? diffInfo.getSplitBackward(this.adEnv.curActivity()) : diffInfo.getAdjoint(this.adEnv.curActivity())));
        this.adEnv.setCurFwdDiffUnit(modeIsSplit ? diffInfo.getSplitForward(this.adEnv.curActivity()) : this.curDiffUnit());
        this.toBranchVariable = new TapPair<Object, WrapperTypeSpec>(null, this.curDiffUnit().isFortran() ? this.adEnv.integer4TypeSpec : this.adEnv.integerTypeSpec);
        if (adDiffMode == -1 || adDiffMode == -2) {
            this.toChunklengthVariable = new TapList<Object>(null, null);
            this.toFwdChunklengthVariable = adDiffMode == -2 ? new TapList<NewSymbolHolder>(null, null) : this.toChunklengthVariable;
            this.toChunkoldVariable = new TapList<Object>(null, null);
            this.toDiffchunkoldVariable = new TapList<Object>(null, null);
            this.adOmpChunkStartVarTool = null;
            this.adOmpChunkEndVarTool = null;
            this.ompChunksNumVariable = null;
            this.ompChunksIndexVariable = null;
            this.ompChunksOriginalIndex = null;
            this.ompChunksOriginalIndexFwd = null;
        }
        if ((scopingsDirective = Directive.hasDirective(unit.directives, modeIsTangent ? 25 : 26)) != null) {
            TapList<Object> toClausesGivenScoping = new TapList<Object>(null, null);
            TapList<Object> toForcedAtomicScopingNames = new TapList<Object>(null, null);
            TapList<Object> toForcedOtherScopingNames = new TapList<Object>(null, null);
            Directive.analyzeMultithreadScopings(scopingsDirective.arguments[0], !unit.isFortran(), toClausesGivenScoping, toForcedAtomicScopingNames, toForcedOtherScopingNames);
            SymbolTable unitPrivST = unit.privateSymbolTable();
            int[] unitMap = DataFlowAnalyzer.makeMap3(unitPrivST, 0);
            BoolVector onlyReadSmallActivePrimals = new BoolVector(DataFlowAnalyzer.mapSize(unitMap));
            TapList forcedNotAtomic = toForcedOtherScopingNames.tail;
            while (forcedNotAtomic != null) {
                String varName = (String)forcedNotAtomic.head;
                TapIntList varZones = unitPrivST.listOfZonesOfValue(ILUtils.build(96, varName), null, null);
                while (varZones != null) {
                    onlyReadSmallActivePrimals.set(varZones.head, true);
                    ZoneInfo zi = DataFlowAnalyzer.extendedDeclaredToZoneInfo(varZones.head, unitPrivST, null);
                    if (zi != null) {
                        TapIntList pointerDestsList = ZoneInfo.listAllZones(zi.targetZonesTree, false);
                        onlyReadSmallActivePrimals.set(pointerDestsList, true);
                    }
                    varZones = varZones.tail;
                }
                forcedNotAtomic = forcedNotAtomic.tail;
            }
            unitPrivST.needNoAtomic = onlyReadSmallActivePrimals;
        }
        this.curDiffUnit().privateSymbolTable().nestedIntIndexSymbolHolders = new TapList<Object>(null, null);
        if (modeIsSplit) {
            this.curFwdDiffUnit().privateSymbolTable().nestedIntIndexSymbolHolders = new TapList<Object>(null, null);
        }
        this.initializeMultiDirMode();
        TapEnv.resetPushPopNumber();
        this.resetIsDifferentiatedDeclInstructions(unit);
        this.debugPointsCounter = 1;
        if (adDiffMode == 1) {
            this.tangentDiffReinitChecker = new BoolVector(unit.nbArrows);
        }
        this.toDuplicateVars = new TapList<Object>(null, null);
        FlowGraphDifferentiationEnv diffEnv = new FlowGraphDifferentiationEnv(adDiffMode);
        diffEnv.initialize();
        this.realOrigBlockOfReturns = null;
        diffEnv.turningArrows = modeIsSplit ? null : topFlowGraphLevel.exitArrows;
        diffEnv.middleSymbolTables = modeIsSplit ? null : this.collectMiddleSymbolTables(TapEnv.debugAdMode() != 0 ? null : diffEnv.turningArrows, unit.allBlocks());
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printlnOnTrace(" ----------- Differentiation of individual Blocks:");
        }
        this.precomputeDifferentiatedBlocksIn(topFlowGraphLevel, diffEnv);
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printlnOnTrace(" ----------- Connecting differentiated Blocks:");
        }
        FlowGraphDifferentiation differentiation = this.differentiateFlowGraphLevel(topFlowGraphLevel, diffEnv);
        BoolVector reqXRequired = TapEnv.reqExplicitAnalyzer().diffZonesRequired(this.adEnv.curActivity());
        BoolVector reqXManaged = TapEnv.reqExplicitAnalyzer().diffZonesManaged(this.adEnv.curActivity());
        this.insertADBanner(unit, this.curDiffUnit(), this.adEnv.curActivity(), modeIsTangent ? (this.adEnv.curActivity().isContext() ? " as a context to call tangent code" : " in forward (tangent) mode") : (modeIsSplit ? " in reverse (adjoint) mode, backward sweep" : (this.adEnv.curActivity().isContext() ? " as a context to call adjoint code" : " in reverse (adjoint) mode")), modeIsTangent ? "   variations   of useful results:" : "   gradient     of useful results:", this.adEnv.curActivity().exitActivity(), "   with respect to varying inputs:", this.adEnv.curActivity().callActivity(), reqXRequired, reqXManaged, true);
        if (modeIsSplit) {
            this.insertADBanner(unit, this.curFwdDiffUnit(), this.adEnv.curActivity(), " in reverse (adjoint) mode, forward sweep", "   gradient     of useful results:", this.adEnv.curActivity().exitActivity(), "   with respect to varying inputs:", this.adEnv.curActivity().callActivity(), reqXRequired, reqXManaged, false);
        }
        Block centerEntry = null;
        TapList<FGArrow> centerExits = null;
        if (!this.adEnv.curActivity().isContext() && (modeIsSplit || TapEnv.get().profile || TapEnv.debugAdMode() == -1)) {
            Block incomingBwdBlock = centerEntry = this.buildFwdBlock("centerTurn", this.curFwdDiffUnit().privateSymbolTable(), this.adEnv.curUnit().exitBlock(), diffEnv);
            if (modeIsSplit) {
                Block privateDeclBlock = this.curDiffUnit().privateSymbolTable().declarationsBlock;
                if (privateDeclBlock.symbolicRk == null) {
                    privateDeclBlock.symbolicRk = "PrivDeclBlock";
                }
                if (((FlowGraphDifferentiationEnv)diffEnv).diffCtxt.toAllBlocks != null) {
                    ((FlowGraphDifferentiationEnv)diffEnv).diffCtxt.toAllBlocks.placdl(privateDeclBlock);
                }
                incomingBwdBlock = privateDeclBlock;
                this.checkFreeThenSetNewFGArrow(centerEntry, 0, 0, (Block)this.curFwdDiffUnit().exitBlock(), false);
                this.checkFreeThenSetNewFGArrow((Block)this.curDiffUnit().entryBlock(), 0, 0, incomingBwdBlock, false);
            }
            centerExits = new TapList<FGArrow>(this.checkFreeThenSetNewFGArrow(incomingBwdBlock, 0, 0, null, false), null);
        }
        PushPopNode pushPopTree = this.buildFwdBwdTreeFromExitFwdBwd(differentiation.exitArrowsFwdBwds);
        this.connectFwdBwd(pushPopTree, centerEntry, centerExits, unit.exitBlock(), null, diffEnv, topFlowGraphLevel);
        TapList<SymbolTable> newDiffSymbolTables = this.curDiffUnit().symbolTablesBottomUp();
        while (newDiffSymbolTables != null) {
            SymbolTable newDiffSymbolTable = (SymbolTable)newDiffSymbolTables.head;
            if (newDiffSymbolTable.declarationsBlock != null) {
                newDiffSymbolTable.declarationsBlock.symbolTable = newDiffSymbolTable;
            }
            newDiffSymbolTables = newDiffSymbolTables.tail;
        }
        TapList<Object> toDiffSubUnitsFwd = new TapList<Object>(null, null);
        TapList<Object> toDiffSubUnitsBwd = new TapList<Object>(null, null);
        TapList<Instruction> origNonFlow = unit.nonFlowInstructions;
        while (origNonFlow != null) {
            Unit subUnit = (Unit)((Instruction)origNonFlow.head).tree.getAnnotation("Unit");
            if (subUnit != null) {
                if (this.adEnv.traceCurDifferentiation) {
                    TapEnv.printlnOnTrace("    --- differentiating non-flow definition of " + subUnit);
                }
                this.callGraphDifferentiator().collectDiffSubUnits(subUnit, adDiffMode, toDiffSubUnitsFwd, toDiffSubUnitsBwd);
            }
            origNonFlow = origNonFlow.tail;
        }
        toDiffSubUnitsFwd = toDiffSubUnitsFwd.tail;
        toDiffSubUnitsBwd = toDiffSubUnitsBwd.tail;
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printlnOnTrace("       Cumul contained Units for fwd:" + toDiffSubUnitsFwd);
            TapEnv.printlnOnTrace("       Cumul contained Units for bwd:" + toDiffSubUnitsBwd);
        }
        while (toDiffSubUnitsFwd != null) {
            this.curFwdDiffUnit().addNonFlowInstruction(Instruction.createUnitDefinitionStub((Unit)toDiffSubUnitsFwd.head, null));
            toDiffSubUnitsFwd = toDiffSubUnitsFwd.tail;
        }
        while (toDiffSubUnitsBwd != null) {
            this.curDiffUnit().addNonFlowInstruction(Instruction.createUnitDefinitionStub((Unit)toDiffSubUnitsBwd.head, null));
            toDiffSubUnitsBwd = toDiffSubUnitsBwd.tail;
        }
        if (TapEnv.debugAdMode() != 0 && this.adEnv.unitActivities != null) {
            Block downstreamDebugPoint;
            Block upstreamDebugPoint;
            Block diffUnitFirstBlock;
            TapList<FGArrow> flow = this.curDiffUnit().entryBlock().flow();
            Block block = diffUnitFirstBlock = flow == null ? null : ((FGArrow)flow.head).destination;
            if (modeIsTangent) {
                upstreamDebugPoint = diffUnitFirstBlock;
                downstreamDebugPoint = this.buildBwdBlock("traceExitBlock", this.curDiffUnit().privateSymbolTable(), this.adEnv.curUnit().exitBlock(), diffEnv);
                this.curDiffUnit().exitBlock().insertBlockBefore(downstreamDebugPoint);
            } else {
                upstreamDebugPoint = this.buildBwdBlock("traceEntryBlock", this.curDiffUnit().privateSymbolTable(), this.adEnv.curUnit().entryBlock(), diffEnv);
                this.curDiffUnit().exitBlock().insertBlockBefore(upstreamDebugPoint);
                downstreamDebugPoint = modeIsSplit ? diffUnitFirstBlock : centerEntry;
            }
            this.instrumentTraceOnUnit(unit, upstreamDebugPoint, downstreamDebugPoint, diffEnv);
        }
        if (this.toDuplicateVars != null && this.toDuplicateVars.tail != null) {
            Block updateBlock = this.buildBwdBlock("passByValueUpdate", this.curDiffUnit().privateSymbolTable(), this.adEnv.curUnit().exitBlock(), diffEnv);
            this.toDuplicateVars = this.toDuplicateVars.tail;
            while (this.toDuplicateVars != null) {
                TapPair publicLocal = (TapPair)this.toDuplicateVars.head;
                Tree publicExpr = (Tree)publicLocal.first;
                Tree localExpr = (Tree)publicLocal.second;
                Tree assign = ILUtils.build(14, ILUtils.copy(publicExpr), ILUtils.build(3, ILUtils.copy(publicExpr), localExpr));
                updateBlock.addInstrHdAfterDecls(assign);
                this.toDuplicateVars = this.toDuplicateVars.tail;
            }
            this.insertBlockBefore(this.curDiffUnit().exitBlock(), updateBlock);
        }
        if (unit.isAFunction() && this.returnedVariable == null && this.curDiffUnit().isFortran()) {
            this.returnedVariable = ILUtils.build(96, unit.otherReturnVar() != null ? unit.otherReturnVar().symbol : unit.name());
        }
        boolean[] formalArgsActivity = this.callGraphDifferentiator().getUnitFormalArgsActivityS(this.adEnv.curActivity());
        boolean resultIsActive = formalArgsActivity[formalArgsActivity.length - 1];
        if (unit.isAFunction() && this.returnedVariable != null && (adDiffMode == -2 || this.adEnv.curActivity().isContext() && adDiffMode == -1)) {
            VariableDecl fwdFuncNameDecl;
            NewSymbolHolder newReturnVarSH;
            Tree newReturnVarName;
            Tree newAssignOrReturn = null;
            int nbArgs = unit.functionTypeSpec().argumentsTypes.length;
            boolean[] formalArgsPointerActivity = ReqExplicit.formalArgsPointerActivity(this.adEnv.curActivity(), nbArgs);
            boolean resultIsPtrActive = formalArgsPointerActivity[nbArgs];
            if (resultIsPtrActive) {
                newReturnVarName = this.varRefDifferentiator().diffSymbolTree(this.adEnv.curActivity(), this.returnedVariable, this.curFwdDiffUnit().publicSymbolTable(), true, false, false, null, false, 2, 3, 0, null);
                newReturnVarSH = NewSymbolHolder.getNewSymbolHolder(newReturnVarName);
            } else {
                newReturnVarName = ILUtils.copy(this.returnedVariable);
                newReturnVarSH = null;
            }
            if (unit.isC()) {
                newAssignOrReturn = ILUtils.build(168, newReturnVarName);
                if (newReturnVarSH != null && newReturnVarSH.typeSpec() == null) {
                    WrapperTypeSpec origReturnType = unit.functionTypeSpec().returnType;
                    newReturnVarSH.setAsVariable(new WrapperTypeSpec(new PointerTypeSpec(origReturnType, null)), null);
                    fwdFuncNameDecl = new VariableDecl(ILUtils.copy(newReturnVarName), newReturnVarSH.typeSpec());
                    fwdFuncNameDecl.formalArgRank = -2;
                    newReturnVarSH.accumulateSymbolDecl(fwdFuncNameDecl, this.curFwdDiffUnit().privateSymbolTable());
                }
            } else {
                Tree fwdFuncName = ILUtils.copy(ILUtils.getCalledName(this.curFwdDiffUnit().entryBlock().headInstr().tree));
                fwdFuncName.setAnnotation("isFunctionName", Boolean.TRUE);
                NewSymbolHolder fwdFuncVarSH = NewSymbolHolder.getNewSymbolHolder(fwdFuncName);
                VariableDecl origDecl = unit.publicSymbolTable().getTopVariableDecl(ILUtils.getIdentString(this.returnedVariable));
                fwdFuncVarSH.setAsVariable(origDecl.type(), null);
                fwdFuncNameDecl = new VariableDecl(ILUtils.copy(fwdFuncName), origDecl.type());
                fwdFuncNameDecl.isReturnVar = true;
                fwdFuncVarSH.accumulateSymbolDecl(fwdFuncNameDecl, this.curFwdDiffUnit().privateSymbolTable());
            }
            if (newAssignOrReturn != null) {
                Block returnBlock = this.buildFwdBlock("fwdReturnBlock", this.curFwdDiffUnit().entryBlock().symbolTable, this.adEnv.curUnit().exitBlock(), diffEnv);
                returnBlock.addInstrHdAfterDecls(newAssignOrReturn);
                if (this.adEnv.traceCurDifferentiation) {
                    TapEnv.printlnOnTrace("     -> (FwdReturnBlock+) final return : " + ILUtils.toString(newAssignOrReturn, this.adEnv.curActivity()));
                }
                this.insertBlockBefore(this.curFwdDiffUnit().exitBlock(), returnBlock);
            }
        }
        if (this.curDiffUnit().isAFunction() && resultIsActive && this.curDiffUnit().isFortran() && (modeIsTangent && !this.multiDirMode() || this.adEnv.curUnitIsContext)) {
            VariableDecl returnVarDecl = this.curDiffUnit().publicSymbolTable().getTopVariableDecl(unit.name());
            if (returnVarDecl == null) {
                String otherReturnVarName = unit.otherReturnVar().symbol;
                returnVarDecl = this.curDiffUnit().publicSymbolTable().getTopVariableDecl(otherReturnVarName);
            }
            if (returnVarDecl != null) {
                this.declareDiffIsReturnVar(returnVarDecl, unit, this.curDiffUnit());
            }
        }
        this.blockDifferentiator().differentiateDeclarationsOfBlock(this.curDiffUnit().publicSymbolTable().declarationsBlock, adDiffMode, unit, unit.publicSymbolTable(), this.curDiffUnit().privateSymbolTable(), unit.language(), false);
        this.adEnv.toIndexSymbolHolders.tail = null;
        if (this.adEnv.traceCurDifferentiation) {
            TapList inToAll;
            TapEnv.printlnOnTrace(" ----------- List of all differentiated Blocks created:");
            if (modeIsSplit) {
                TapEnv.printOnTrace("[FWD ENTRY:]");
                this.tracePrintBlock(this.curFwdDiffUnit().entryBlock());
                inToAll = ((FlowGraphDifferentiationEnv)diffEnv).diffCtxtFwd.toAllBlocks.tail;
                while (inToAll != null) {
                    this.tracePrintBlock((Block)inToAll.head);
                    inToAll = inToAll.tail;
                }
                TapEnv.printOnTrace("[FWD EXIT:]");
                this.tracePrintBlock(this.curFwdDiffUnit().exitBlock());
                TapEnv.printlnOnTrace();
            }
            TapEnv.printOnTrace("[ENTRY:]");
            this.tracePrintBlock(this.curDiffUnit().entryBlock());
            inToAll = ((FlowGraphDifferentiationEnv)diffEnv).diffCtxt.toAllBlocks.tail;
            while (inToAll != null) {
                this.tracePrintBlock((Block)inToAll.head);
                inToAll = inToAll.tail;
            }
            TapEnv.printOnTrace("[EXIT:]");
            this.tracePrintBlock(this.curDiffUnit().exitBlock());
            TapEnv.printlnOnTrace();
        }
        if (adDiffMode == 1) {
            TapList<FGArrow> fgArrows = unit.allArrows;
            while (fgArrows != null) {
                FGArrow fgArrow = (FGArrow)fgArrows.head;
                if (!this.tangentDiffReinitChecker.get(fgArrow.rank) && this.mustCheckActivitySwitches(fgArrow.origin, fgArrow.destination)) {
                    TapEnv.toolWarning(-1, "(Tangent mode AD): Lost reinitialization of derivatives on flow arrow " + fgArrow);
                }
                fgArrows = fgArrows.tail;
            }
            this.tangentDiffReinitChecker = null;
        }
        if (modeIsSplit) {
            this.differentiateSaveList(this.curFwdDiffUnit().privateSymbolTable());
            CallGraphDifferentiator.solveNewSymbolHoldersOfUnit(this.curFwdDiffUnit(), this.adEnv.emptyCopiedUnitSuffix);
            if ((this.adEnv.curDiffUnitPushesPointers || this.adEnv.usesADMM || this.curFwdDiffUnit().usesISO_C_BINDING) && TapEnv.relatedLanguageIsFortran9x()) {
                this.declareStackPointerInterface(this.curFwdDiffUnit());
            }
            this.curFwdDiffUnit().makeFlowGraph(this.curFwdDiffUnit().entryBlock(), ((FlowGraphDifferentiationEnv)diffEnv).diffCtxtFwd.toAllBlocks.tail, this.curFwdDiffUnit().exitBlock(), true);
        }
        this.differentiateSaveList(this.curDiffUnit().privateSymbolTable());
        CallGraphDifferentiator.solveNewSymbolHoldersOfUnit(this.curDiffUnit(), this.adEnv.emptyCopiedUnitSuffix);
        if ((this.adEnv.curDiffUnitPushesPointers || this.adEnv.usesADMM || this.curDiffUnit().usesISO_C_BINDING) && TapEnv.relatedLanguageIsFortran9x()) {
            this.declareStackPointerInterface(this.curDiffUnit());
        }
        this.adEnv.curDiffUnitPushesPointers = false;
        this.curDiffUnit().makeFlowGraph(this.curDiffUnit().entryBlock(), ((FlowGraphDifferentiationEnv)diffEnv).diffCtxt.toAllBlocks.tail, this.curDiffUnit().exitBlock(), true);
        if (this.alteredStaticAnalysis) {
            this.restoreStaticAnalysis(!modeIsSplit);
        }
        if ((this.adEnv.curActivity().isContext() || TapEnv.associationByAddress()) && unit.isAFunction() && unit.isFortran() && this.curDiffUnit().isAFunction() && this.curDiffUnit().otherReturnVar() == null) {
            Tree returnTree = ILUtils.build(96, unit.name());
            if (unit.otherReturnVar() != null) {
                returnTree = ILUtils.build(96, unit.otherReturnVar().symbol);
            }
            Tree diffReturnVar = TapEnv.associationByAddress() ? ILUtils.copy(ILUtils.getCalledName(this.curDiffUnit().headTree())) : this.varRefDifferentiator().diffSymbolTree(this.adEnv.curActivity(), returnTree, this.adEnv.curFwdSymbolTable, true, false, false, unit.headTree(), true, this.curDiffVarSort(), this.adEnv.curDiffUnitSort, 0, null);
            diffReturnVar.setAnnotation("isFunctionName", Boolean.TRUE);
            NewSymbolHolder newSH = NewSymbolHolder.getNewSymbolHolder(diffReturnVar);
            if (newSH != null) {
                newSH.declarationLevelMustInclude(this.adEnv.curFwdSymbolTable);
            }
            this.callGraphDifferentiator().updateAllUsagesDiffFuncResultName(unit, ILUtils.baseName(returnTree), this.curDiffUnit(), diffReturnVar);
        }
    }

    private void precomputeDifferentiatedBlocksIn(FlowGraphLevel level, FlowGraphDifferentiationEnv diffEnv) {
        TapList<FlowGraphLevel> subLevels = new TapList<FlowGraphLevel>(level.entryPoint, level.contents);
        while (subLevels != null) {
            this.precomputeDifferentiatedBlocks((FlowGraphLevel)subLevels.head, diffEnv);
            subLevels = subLevels.tail;
        }
    }

    private void precomputeDifferentiatedBlocks(FlowGraphLevel level, FlowGraphDifferentiationEnv diffEnv) {
        int kind = level.levelKind;
        if (!(kind != 10 && kind != 9 && kind != 8 && kind != 6 && kind != 7 || level.entryBlock.headInstr() == null || level.entryBlock.headInstr().hasDirective(15) == null || diffEnv.adDiffMode != -1 || this.adEnv.curUnitIsContext)) {
            kind = 7;
        }
        if (diffEnv.adDiffMode == 1) {
            if (kind == 7 || kind == 11) {
                kind = 10;
            }
            if (kind == 4) {
                kind = 3;
            }
        }
        switch (kind) {
            case 6: 
            case 7: {
                this.precomputeDifferentiatedBlocksIn(level.createNoCycle(), diffEnv);
                level.restoreChildrenParent();
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                Block block = level.entryBlock;
                this.precomputeDifferentiatedBlocksIn(level.createLoopBody(), diffEnv);
                Block fwdDiffBlock = this.createFwdDiffBlock(block, diffEnv, true);
                Block bwdDiffBlock = this.createBwdDiffBlock(block, diffEnv, true);
                this.blockDifferentiator().differentiateBlock(block, fwdDiffBlock, bwdDiffBlock, diffEnv.adDiffMode, null);
                diffEnv.storeDiffBlocks(block, fwdDiffBlock, bwdDiffBlock, true);
                level.restoreChildrenParent();
                break;
            }
            case 11: 
            case 13: {
                Block block = level.entryBlock;
                diffEnv.markBwdControllersLive(block);
                Block fwdDiffBlock = this.createFwdDiffBlock(block, diffEnv, true);
                Block bwdDiffBlock = this.createBwdDiffBlock(block, diffEnv, true);
                this.blockDifferentiator().differentiateBlock(block, fwdDiffBlock, bwdDiffBlock, diffEnv.adDiffMode, null);
                diffEnv.storeDiffBlocks(block, fwdDiffBlock, bwdDiffBlock, true);
                break;
            }
            case 4: 
            case 12: 
            case 14: {
                diffEnv.markBwdControllersLive(level.entryBlock);
                break;
            }
            case 3: 
            case 15: {
                this.precomputeDifferentiatedBlocksIn(level, diffEnv);
                break;
            }
            case 0: {
                Tree pragma;
                Block block = level.entryBlock;
                boolean vanishingLoopHeader = false;
                if (block instanceof HeaderBlock && block == level.enclosing.headerBlockPlain) {
                    Instruction loopInstr = block.headInstr();
                    if (loopInstr.tree.opCode() == 121) {
                        vanishingLoopHeader = true;
                    }
                }
                Block fwdDiffBlock = this.createFwdDiffBlock(block, diffEnv, block instanceof HeaderBlock && block != level.enclosing.headerBlockPlain);
                Block bwdDiffBlock = this.createBwdDiffBlock(block, diffEnv, false);
                ToBool lastTestLive = null;
                if (diffEnv.adDiffMode == 1 || block.isControl()) {
                    lastTestLive = new ToBool(false);
                }
                this.blockDifferentiator().differentiateBlock(block, fwdDiffBlock, bwdDiffBlock, diffEnv.adDiffMode, lastTestLive);
                diffEnv.storeDiffBlocks(block, fwdDiffBlock, bwdDiffBlock, lastTestLive != null && lastTestLive.get());
                if (vanishingLoopHeader) {
                    fwdDiffBlock.instructions = TapList.removeLast(fwdDiffBlock.instructions);
                }
                if (block.instructions == null || diffEnv.adDiffMode != -1 && diffEnv.adDiffMode != -2 || (pragma = block.headInstr().tree).opCode() != 144 || !ILUtils.isIdent(pragma.down(1), "omp", false)) break;
                Tree srcSchedule = (Tree)pragma.getAnnotation("srcSchedule");
                bwdDiffBlock.instructions = null;
                if (!ILUtils.isStaticSchedule(srcSchedule)) break;
                fwdDiffBlock.instructions = null;
                break;
            }
            case 1: {
                EntryBlock entryBlock = (EntryBlock)level.entryBlock;
                if (this.adEnv.traceCurDifferentiation) {
                    int n = TapEnv.get().traceBlockRk == -99 ? 1 : (this.adEnv.traceCurBlock = entryBlock.rank == TapEnv.get().traceBlockRk ? 2 : 0);
                    if (this.adEnv.traceCurBlock != 0) {
                        TapEnv.printlnOnTrace("*** NOW Differentiating EntryBlock:" + entryBlock + " : " + entryBlock.instructions);
                    }
                }
                SymbolTable sourcePublicSymbolTable = entryBlock.symbolTable;
                boolean modeIsSplit = !this.adEnv.curUnitIsContext && diffEnv.adDiffMode == -2;
                SymbolTable fwdDiffSymbolTable = sourcePublicSymbolTable.smartCopy(((FlowGraphDifferentiationEnv)diffEnv).diffCtxtFwd.listST, ((FlowGraphDifferentiationEnv)diffEnv).diffCtxtFwd.unit, this.adEnv.diffCallGraph(), this.adEnv.copiedUnits, "FwdDiff of ");
                CallGraphDifferentiator.declareDiffSymbolTableIfNew(((FlowGraphDifferentiationEnv)diffEnv).diffCtxtFwd.unit, fwdDiffSymbolTable);
                SymbolTable diffSymbolTable = fwdDiffSymbolTable;
                if (modeIsSplit) {
                    diffSymbolTable = sourcePublicSymbolTable.smartCopy(((FlowGraphDifferentiationEnv)diffEnv).diffCtxt.listST, ((FlowGraphDifferentiationEnv)diffEnv).diffCtxt.unit, this.adEnv.diffCallGraph(), this.adEnv.copiedUnits, "Diff of ");
                    CallGraphDifferentiator.declareDiffSymbolTableIfNew(((FlowGraphDifferentiationEnv)diffEnv).diffCtxt.unit, diffSymbolTable);
                }
                EntryBlock entryOfFwdSweep = new EntryBlock(fwdDiffSymbolTable);
                entryOfFwdSweep.symbolicRk = "+E";
                this.adEnv.setCurSymbolTable(entryBlock.symbolTable);
                Tree fwdDiffCallTree = this.adEnv.curUnitIsActiveUnit ? this.procedureCallDifferentiator().differentiateProcedureHeader(entryBlock.headTree(), null, null, null, fwdDiffSymbolTable, fwdDiffSymbolTable, diffEnv.adDiffMode == 1 ? 1 : (modeIsSplit ? 3 : 2), this.toDuplicateVars) : ILUtils.copy(entryBlock.headTree());
                entryOfFwdSweep.addInstrTl(fwdDiffCallTree);
                this.curFwdDiffUnit().setEntryBlock(entryOfFwdSweep);
                this.curFwdDiffUnit().setName(ILUtils.getCalledNameString(fwdDiffCallTree));
                ExitBlock exitOfBwdSweep = new ExitBlock(diffSymbolTable);
                exitOfBwdSweep.symbolicRk = "-X";
                this.curDiffUnit().setExitBlock(exitOfBwdSweep);
                diffEnv.storeDiffBlocks(entryBlock, entryOfFwdSweep, exitOfBwdSweep, true);
                if (this.adEnv.traceCurDifferentiation) {
                    TapEnv.printlnOnTrace(" -> fwdBlock:" + entryOfFwdSweep + " : " + entryOfFwdSweep.instructions);
                    TapEnv.printlnOnTrace(" -> bwdBlock:" + exitOfBwdSweep + " : " + exitOfBwdSweep.instructions);
                }
                if (modeIsSplit) {
                    ExitBlock exitOfFwdSweep = new ExitBlock(fwdDiffSymbolTable);
                    exitOfFwdSweep.symbolicRk = "+X";
                    this.curFwdDiffUnit().setExitBlock(exitOfFwdSweep);
                    EntryBlock entryOfBwdSweep = new EntryBlock(diffSymbolTable);
                    entryOfBwdSweep.symbolicRk = "-E";
                    Tree diffCallTree = this.procedureCallDifferentiator().differentiateProcedureHeader(entryBlock.headTree(), null, null, null, diffSymbolTable, diffSymbolTable, 4, this.toDuplicateVars);
                    entryOfBwdSweep.addInstrTl(diffCallTree);
                    this.curDiffUnit().setEntryBlock(entryOfBwdSweep);
                    this.curDiffUnit().setName(ILUtils.getCalledNameString(diffCallTree));
                    if (this.adEnv.traceCurDifferentiation) {
                        TapEnv.printlnOnTrace(" -> fwdBlock:" + exitOfFwdSweep + " : " + exitOfFwdSweep.instructions);
                        TapEnv.printlnOnTrace(" -> bwdBlock:" + entryOfBwdSweep + " : " + entryOfBwdSweep.instructions);
                    }
                }
                if (!this.adEnv.traceCurDifferentiation) break;
                this.adEnv.traceCurBlock = 0;
                break;
            }
            default: {
                TapEnv.toolWarning(-1, "(Precompute differentiated Blocks) Not implemented for groups of kind: " + kind);
            }
        }
    }

    private FlowGraphDifferentiation differentiateFlowGraphLevel(FlowGraphLevel level, FlowGraphDifferentiationEnv diffEnv) {
        FlowGraphDifferentiation subResult;
        FlowGraphLevel subLevel;
        TapList<Object> hdSubResults;
        TapList<FlowGraphLevel> subLevels;
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.indentprintlnOnTrace("BEGIN DIFF FGL " + level + " CONTAINING " + level.entryPoint + "+" + level.contents);
            TapEnv.incrTraceIndent(2);
        }
        TapList<FlowGraphLevel> inSubLevels = subLevels = new TapList<FlowGraphLevel>(level.entryPoint, level.contents);
        TapList<Object> tlSubResults = hdSubResults = new TapList<Object>(null, null);
        FlowGraphLevel entrySubLevel = null;
        FlowGraphDifferentiation entrySubResult = null;
        while (inSubLevels != null) {
            subLevel = (FlowGraphLevel)inSubLevels.head;
            int kind = subLevel.levelKind;
            if (!TapEnv.associationByAddress()) {
                if ((kind == 10 || kind == 9 || kind == 8 || kind == 6 || kind == 7) && subLevel.entryBlock.headInstr() != null && subLevel.entryBlock.headInstr().hasDirective(15) != null && diffEnv.adDiffMode == -1) {
                    kind = subLevel.levelKind = 7;
                    if (subLevel.entryBlock.headInstr().hasDirective(15) != null && kind != 7) {
                        TapEnv.fileWarning(15, ((FlowGraphLevel)subLevel).entryBlock.headInstr().tree, "(AD19) Cannot use binomial checkpointing here");
                    }
                }
            } else if (kind == 13) {
                TapEnv.fileWarning(15, ((FlowGraphLevel)subLevel).entryBlock.headInstr().tree, "(AD19) Cannot use FIXEDPOINT_LOOP with association by address");
                TapEnv.tapenadeExit(1);
            }
            if (subLevel.entryBlock != null && ((FlowGraphLevel)subLevel).entryBlock.instructions != null && subLevel.entryBlock.headInstr().hasDirective(13) != null && kind != 11) {
                TapEnv.fileWarning(15, ((FlowGraphLevel)subLevel).entryBlock.headInstr().tree, "(AD20) Cannot use II-LOOP directive here");
            }
            if (diffEnv.adDiffMode == 1) {
                if (kind == 7 || kind == 11) {
                    kind = 10;
                }
                if (kind == 4) {
                    kind = 3;
                }
            }
            switch (kind) {
                case 7: {
                    subResult = this.differentiateBinomialLoop(subLevel, diffEnv);
                    break;
                }
                case 6: {
                    subResult = this.differentiateNaturalLoop(subLevel, diffEnv);
                    break;
                }
                case 13: {
                    subResult = this.differentiateFixedPointLoop(subLevel, diffEnv);
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    subResult = this.differentiateStructuredLoop(subLevel, diffEnv);
                    break;
                }
                case 11: {
                    subResult = this.differentiateIILoop(subLevel, diffEnv);
                    break;
                }
                case 14: {
                    subResult = this.differentiateMultithreadRegion(subLevel, diffEnv);
                    break;
                }
                case 4: {
                    subResult = this.differentiateCkpPiece(subLevel, diffEnv);
                    break;
                }
                case 12: {
                    subResult = this.differentiateNoDiffPiece(subLevel, diffEnv);
                    break;
                }
                case 15: {
                    subResult = this.differentiateLabelledRegion(subLevel, diffEnv);
                    break;
                }
                case 3: {
                    subResult = this.differentiateFlowGraphLevel(subLevel, diffEnv);
                    break;
                }
                case 0: {
                    subResult = this.differentiatePlainBlockLevel(subLevel, diffEnv);
                    break;
                }
                case 1: {
                    subResult = this.differentiateEntryBlockLevel(subLevel, diffEnv);
                    entrySubLevel = subLevel;
                    entrySubResult = subResult;
                    break;
                }
                default: {
                    TapEnv.toolWarning(-1, "(Differentiate groups of Blocks) Not implemented for groups of kind: " + kind);
                    subResult = new FlowGraphDifferentiation(subLevel);
                }
            }
            tlSubResults = tlSubResults.placdl(subResult);
            inSubLevels = inSubLevels.tail;
        }
        hdSubResults = hdSubResults.tail;
        if (entrySubLevel != null && diffEnv.adDiffMode != 1) {
            FlowGraphLevel nextLevel;
            FlowGraphDifferentiation nextResult;
            Block entryBlock = entrySubLevel.entryBlock;
            Block nextBlock = ((FGArrow)entryBlock.flow().head).destination;
            if (nextBlock.backFlow().tail == null && nextBlock.flow() != null && nextBlock.flow().tail == null && !(nextResult = this.getSubLevelDifferentiation(nextLevel = level.getRepresentantInLevel(nextBlock), level, hdSubResults)).hasBwd() && nextResult.hasFwd()) {
                TapPair entryOneFwdBwd = (TapPair)((FlowGraphDifferentiation)entrySubResult).getFwdBwdsOfExitArrow((FGArrow)((FGArrow)entryBlock.flow().head)).head;
                BwdSwitchCase entryBwdSwitchCase = (BwdSwitchCase)((TapList)entryOneFwdBwd.second).head;
                TapPair nextOneFwdBwd = (TapPair)((FlowGraphDifferentiation)nextResult).getFwdBwdsOfExitArrow((FGArrow)((FGArrow)nextBlock.flow().head)).head;
                entryBwdSwitchCase.fwdArrow = (FGArrow)nextOneFwdBwd.first;
            }
        }
        FlowGraphDifferentiation result = new FlowGraphDifferentiation(level);
        result.upstreamFwdBwdDefined = false;
        result.specialTopUsed = false;
        result.specialTopBwdArrow = null;
        result.specialTopFwdArrow = null;
        if (level.hasCyclingArrows() && (subResult = (FlowGraphDifferentiation)hdSubResults.head).hasFwd()) {
            Block emptyFwdBlock = this.createFwdDiffBlock(level.entryBlock, diffEnv, false);
            emptyFwdBlock.symbolicRk = emptyFwdBlock.symbolicRk + "Cy";
            result.specialTopFwdArrow = this.checkFreeThenSetNewFGArrow(emptyFwdBlock, 0, 0, null, false);
            if (subResult.hasBwd()) {
                Block emptyBwdBlock = this.createBwdDiffBlock(level.entryBlock, diffEnv, false);
                emptyBwdBlock.symbolicRk = emptyBwdBlock.symbolicRk + "Cy";
                result.specialTopBwdArrow = this.checkFreeThenSetNewFGArrow(emptyBwdBlock, 0, 0, null, false);
            }
        }
        boolean[] arrowVisited = new boolean[this.adEnv.curUnit().nbArrows];
        TapList<Object> inSubResults = hdSubResults;
        inSubLevels = subLevels;
        while (inSubLevels != null) {
            subLevel = (FlowGraphLevel)inSubLevels.head;
            subResult = (FlowGraphDifferentiation)inSubResults.head;
            if (this.keepEmptyDiffBlocks || subLevel.exitArrows == null || subResult.hasBwd() || diffEnv.adDiffMode == 1) {
                Tree firstLoopInstr;
                TapList totalBwdSwitchCases = null;
                TapList entryArrows = subLevel.entryArrows;
                if (this.adEnv.traceCurDifferentiation) {
                    TapEnv.indentOnTrace();
                    TapEnv.printlnOnTrace("Connecting entries " + entryArrows + " of " + subLevel + " (upstream result for " + level + " Fwd:" + result.fwdBlockUS + " Bwd:" + result.bwdArrowsUS + ')');
                }
                while (entryArrows != null) {
                    for (int i = arrowVisited.length - 1; i >= 0; --i) {
                        arrowVisited[i] = false;
                    }
                    TapList<TapPair<FGArrow, TapList<BwdSwitchCase>>> manyFwdBwds = this.exploreConvergingBackFlow((FGArrow)entryArrows.head, true, level, result, diffEnv, hdSubResults, arrowVisited, subResult.fwdBlockUS, subResult.bwdArrowsUS);
                    while (manyFwdBwds != null) {
                        TapPair oneFwdBwd = (TapPair)manyFwdBwds.head;
                        totalBwdSwitchCases = TapList.union(totalBwdSwitchCases, (TapList)oneFwdBwd.second);
                        manyFwdBwds = manyFwdBwds.tail;
                    }
                    entryArrows = entryArrows.tail;
                }
                if (this.adEnv.traceCurDifferentiation) {
                    TapEnv.indentOnTrace();
                    TapEnv.printlnOnTrace("==> collected BwdSwitchCases: " + totalBwdSwitchCases);
                }
                Block sourceDest = subLevel.entryBlock;
                Tree doIndexToSave = null;
                if (subLevel.levelKind == 0 && sourceDest.instructions != null && (firstLoopInstr = sourceDest.headInstr().tree).opCode() == 121 && firstLoopInstr.down(3).opCode() == 64 && ADTBRAnalyzer.isTBRindex(this.adEnv.curActivity(), firstLoopInstr.down(3).down(1))) {
                    doIndexToSave = firstLoopInstr.down(3).down(1);
                }
                this.connectFwdBwd(this.buildFwdBwdTreeFromOneFwdBwd(null, totalBwdSwitchCases), subResult.fwdBlockUS, subResult.bwdArrowsUS, subLevel.entryBlock, doIndexToSave, diffEnv, level);
            } else if (this.adEnv.traceCurDifferentiation) {
                TapEnv.indentOnTrace();
                TapEnv.printlnOnTrace("Skipping connections detection up from subLevel:" + subLevel + " because its bwd is empty");
            }
            inSubLevels = inSubLevels.tail;
            inSubResults = inSubResults.tail;
        }
        TapList exitArrowsFwdBwds = result.exitArrowsFwdBwds;
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.indentOnTrace();
            TapEnv.printlnOnTrace("Exploring exits " + level.exitArrows + " of level " + level + " (upstream result for " + level + " Fwd:" + result.fwdBlockUS + " Bwd:" + result.bwdArrowsUS + ')');
        }
        while (exitArrowsFwdBwds != null) {
            TapPair arrowFwdBwds = (TapPair)exitArrowsFwdBwds.head;
            FGArrow exitArrow = (FGArrow)arrowFwdBwds.first;
            if (!(exitArrow.origin instanceof HeaderBlock) || exitArrow.origin != level.headerBlockPlain || exitArrow.origin.headInstr().tree.opCode() != 121) {
                for (int i = arrowVisited.length - 1; i >= 0; --i) {
                    arrowVisited[i] = false;
                }
                arrowFwdBwds.second = this.exploreConvergingBackFlow(exitArrow, false, level, result, diffEnv, hdSubResults, arrowVisited, null, null);
            }
            exitArrowsFwdBwds = exitArrowsFwdBwds.tail;
        }
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.decrTraceIndent(2);
            TapEnv.indentprintlnOnTrace(">>END DIFF FGL " + level);
            TapEnv.indentprintlnOnTrace("  -UPSTREAM: " + result.fwdBlockUS + " ; " + result.bwdArrowsUS);
            exitArrowsFwdBwds = result.exitArrowsFwdBwds;
            TapEnv.indentprintOnTrace("  -DNSTREAM: (");
            while (exitArrowsFwdBwds != null) {
                TapEnv.printlnOnTrace("-" + exitArrowsFwdBwds.head);
                exitArrowsFwdBwds = exitArrowsFwdBwds.tail;
                TapEnv.indentprintOnTrace("             " + (exitArrowsFwdBwds == null ? "" : Character.valueOf(' ')));
            }
            TapEnv.printlnOnTrace(")");
        }
        return result;
    }

    private FlowGraphCopy copyFlowGraphLevel(FlowGraphLevel level, FlowGraphCopyEnv copyEnv) {
        Block origCopy;
        FGArrow arrow;
        Block copyBlock;
        Block block;
        Instruction loopInstr;
        TapList allBlocks;
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.indentprintlnOnTrace("BEGIN COPY FGL " + level + " CONTAINING " + level.entryPoint + "+" + level.contents);
            TapEnv.incrTraceIndent(2);
        }
        TapList inAllBlocks = allBlocks = level.allBlocksInside();
        TapList toCopies = null;
        HeaderBlock vanishingLoopHeader = null;
        if (level.headerBlockPlain != null && (loopInstr = level.headerBlockPlain.headInstr()) != null && loopInstr.tree.opCode() == 121) {
            vanishingLoopHeader = level.headerBlockPlain;
        }
        while (inAllBlocks != null) {
            block = (Block)inAllBlocks.head;
            copyBlock = this.createCopyBlock(block, copyEnv);
            copyBlock.copyInstructions(block, this.adEnv.copiedIncludes);
            this.setCopyCallArrows(block);
            if (block == vanishingLoopHeader) {
                this.turnVanishingLoopIntoIf(copyBlock);
            }
            toCopies = new TapList(new TapPair<Block, Block>(block, copyBlock), toCopies);
            inAllBlocks = inAllBlocks.tail;
        }
        FlowGraphCopy result = new FlowGraphCopy(level);
        result.copyBlockUS = (Block)TapList.cassq(level.entryBlock, toCopies);
        inAllBlocks = allBlocks;
        while (inAllBlocks != null) {
            block = (Block)inAllBlocks.head;
            copyBlock = (Block)TapList.cassq(block, toCopies);
            TapList<FGArrow> arrows = block.backFlow();
            while (arrows != null) {
                arrow = (FGArrow)arrows.head;
                if (level.containsArrowFlow(arrow)) {
                    origCopy = (Block)TapList.cassq(arrow.origin, toCopies);
                    FGArrow fGArrow = this.buildCopiedArrow(arrow, origCopy, copyBlock, vanishingLoopHeader);
                }
                arrows = arrows.tail;
            }
            inAllBlocks = inAllBlocks.tail;
        }
        TapList inExitArrowsCopy = result.exitArrowsCopy;
        while (inExitArrowsCopy != null) {
            TapPair exitArrowCopy = (TapPair)inExitArrowsCopy.head;
            arrow = (FGArrow)exitArrowCopy.first;
            origCopy = (Block)TapList.cassq(arrow.origin, toCopies);
            FGArrow copyArrow = this.buildCopiedArrow(arrow, origCopy, null, vanishingLoopHeader);
            exitArrowCopy.second = copyArrow;
            inExitArrowsCopy = inExitArrowsCopy.tail;
        }
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.decrTraceIndent(2);
            TapEnv.indentprintlnOnTrace(">>END COPY FGL " + level + " copyEntry:" + result.copyBlockUS + " exitArrowsCopy:" + result.exitArrowsCopy);
        }
        return result;
    }

    private void setCopyCallArrows(Block sourceBlock) {
        TapList<Instruction> inInstructions = sourceBlock.instructions;
        while (inInstructions != null) {
            Unit calledUnit;
            Tree instrTree = ((Instruction)inInstructions.head).tree;
            Tree callTree = instrTree.opCode() == 31 ? instrTree : (instrTree.opCode() == 14 && instrTree.down(2).opCode() == 31 ? instrTree.down(2) : null);
            if (callTree != null && !(calledUnit = DataFlowAnalyzer.getCalledUnit(callTree, sourceBlock.symbolTable)).isIntrinsic()) {
                Unit primalCalledUnit = this.adEnv.getPrimalCopyOfOrigUnit(calledUnit);
                if (primalCalledUnit == null) {
                    primalCalledUnit = calledUnit;
                }
                CallGraph.addCallArrow(this.curDiffUnit(), 1, primalCalledUnit);
            }
            inInstructions = inInstructions.tail;
        }
    }

    private FlowGraphDifferentiation differentiateEntryBlockLevel(FlowGraphLevel entryBlockLevel, FlowGraphDifferentiationEnv diffEnv) {
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.indentprintlnOnTrace("begin diff ENTRY_BLOCK " + entryBlockLevel);
            TapEnv.incrTraceIndent(2);
        }
        EntryBlock entryBlock = (EntryBlock)entryBlockLevel.entryBlock;
        EntryBlock entryOfFwdSweep = (EntryBlock)diffEnv.fwdDiffBlocks.retrieve(entryBlock);
        ExitBlock exitOfBwdSweep = (ExitBlock)diffEnv.bwdDiffBlocks.retrieve(entryBlock);
        FlowGraphDifferentiation result = new FlowGraphDifferentiation(entryBlockLevel);
        result.fwdBlockUS = entryOfFwdSweep;
        result.bwdArrowsUS = new TapList<FGArrow>(this.checkFreeThenSetNewFGArrow((Block)exitOfBwdSweep, 0, 0, null, false), null);
        TapList exitArrowsFwdBwds = result.exitArrowsFwdBwds;
        while (exitArrowsFwdBwds != null) {
            TapPair arrowFwdBwds = (TapPair)exitArrowsFwdBwds.head;
            FGArrow exitArrow = (FGArrow)arrowFwdBwds.first;
            FGArrow fwdArrow = this.checkFreeThenSetNewFGArrow((Block)entryOfFwdSweep, exitArrow.test, exitArrow.cases, null, false);
            this.insertTangentDiffReinits(fwdArrow, exitArrow, this.curFwdDiffUnit().publicSymbolTable(), null, diffEnv);
            arrowFwdBwds.second = new TapList<TapPair<FGArrow, TapList<BwdSwitchCase>>>(new TapPair<FGArrow, TapList<BwdSwitchCase>>(fwdArrow, new TapList<BwdSwitchCase>(new BwdSwitchCase(fwdArrow, exitOfBwdSweep, new TapList<EntryBlock>(entryBlock, null), exitArrow.destination), null)), null);
            exitArrowsFwdBwds = exitArrowsFwdBwds.tail;
        }
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.decrTraceIndent(2);
            TapEnv.indentprintlnOnTrace(">>end diff ENTRY_BLOCK " + entryBlockLevel);
            TapEnv.indentprintlnOnTrace("  -upstream: " + result.fwdBlockUS + " ; " + result.bwdArrowsUS);
            exitArrowsFwdBwds = result.exitArrowsFwdBwds;
            TapEnv.indentprintOnTrace("  -dnstream: (");
            while (exitArrowsFwdBwds != null) {
                TapEnv.printlnOnTrace("-" + exitArrowsFwdBwds.head);
                exitArrowsFwdBwds = exitArrowsFwdBwds.tail;
                TapEnv.indentprintOnTrace("             " + (exitArrowsFwdBwds == null ? "" : Character.valueOf(' ')));
            }
            TapEnv.printlnOnTrace(")");
        }
        return result;
    }

    private FlowGraphDifferentiation differentiatePlainBlockLevel(FlowGraphLevel plainLeafLevel, FlowGraphDifferentiationEnv diffEnv) {
        TapList exitArrowsFwdBwds;
        boolean lastTestIsLive;
        Block bwdDiffBlock;
        Block fwdDiffBlock;
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.indentprintlnOnTrace("begin diff PLAIN_BLOCK " + plainLeafLevel + " instrs:" + ((FlowGraphLevel)plainLeafLevel).entryBlock.instructions);
            TapEnv.incrTraceIndent(2);
        }
        Block block = plainLeafLevel.entryBlock;
        boolean vanishingLoopHeader = false;
        if (block instanceof HeaderBlock && block == plainLeafLevel.enclosing.headerBlockPlain) {
            Instruction loopInstr = block.headInstr();
            if (loopInstr.tree.opCode() == 121) {
                vanishingLoopHeader = true;
            }
        }
        if (block.rank == -99) {
            fwdDiffBlock = this.createFwdDiffBlock(block, diffEnv, block instanceof HeaderBlock && block != plainLeafLevel.enclosing.headerBlockPlain);
            bwdDiffBlock = this.createBwdDiffBlock(block, diffEnv, false);
            this.blockDifferentiator().differentiateBlock(block, fwdDiffBlock, bwdDiffBlock, diffEnv.adDiffMode, null);
            if (vanishingLoopHeader) {
                fwdDiffBlock.instructions = TapList.removeLast(fwdDiffBlock.instructions);
            }
            lastTestIsLive = true;
        } else {
            fwdDiffBlock = (Block)diffEnv.fwdDiffBlocks.retrieve(block);
            bwdDiffBlock = (Block)diffEnv.bwdDiffBlocks.retrieve(block);
            lastTestIsLive = this.adEnv.curUnitIsContext || diffEnv.blockHasLastTestLive(block);
        }
        boolean hasBwd = diffEnv.adDiffMode != 1 && !this.adEnv.curUnitIsContext && (this.keepEmptyDiffBlocks || diffEnv.blockMustBeActive(block) || bwdDiffBlock.instructions != null || this.keepBwdBecauseOfTwoExits(block, fwdDiffBlock, diffEnv) || this.keepBwdBecauseOfDiffReinits(block));
        boolean hasFwd = hasBwd || diffEnv.blockMustBeLive(block) || diffEnv.adDiffMode == 1 || this.adEnv.curUnitIsContext || fwdDiffBlock.instructions != null;
        FlowGraphDifferentiation result = new FlowGraphDifferentiation(plainLeafLevel);
        if (vanishingLoopHeader) {
            result.removeLoopExitArrow();
        }
        if (hasBwd) {
            result.bwdArrowsUS = new TapList<FGArrow>(this.checkFreeThenSetNewFGArrow(bwdDiffBlock, 0, 0, null, false), null);
        }
        if (hasFwd) {
            result.fwdBlockUS = fwdDiffBlock;
            exitArrowsFwdBwds = result.exitArrowsFwdBwds;
            FGArrow uniqueArrow = null;
            boolean diffInitDoneUnique = false;
            if (exitArrowsFwdBwds != null) {
                if (vanishingLoopHeader || !lastTestIsLive) {
                    uniqueArrow = this.checkFreeThenSetNewFGArrow(fwdDiffBlock, 0, 0, null, false);
                }
                while (exitArrowsFwdBwds != null) {
                    FGArrow fwdArrow;
                    TapPair arrowFwdBwds = (TapPair)exitArrowsFwdBwds.head;
                    FGArrow exitArrow = (FGArrow)arrowFwdBwds.first;
                    if (uniqueArrow != null) {
                        fwdArrow = uniqueArrow;
                    } else {
                        fwdArrow = this.checkFreeThenSetNewFGArrow(fwdDiffBlock, exitArrow.test, exitArrow.cases, null, exitArrow.inACycle);
                        fwdArrow.isAJumpIntoNextCase = exitArrow.isAJumpIntoNextCase;
                        fwdArrow.turnNomatchIntoDefault();
                    }
                    if (!diffInitDoneUnique) {
                        this.insertTangentDiffReinits(fwdArrow, exitArrow, fwdDiffBlock.symbolTable, fwdDiffBlock, diffEnv);
                        if (uniqueArrow != null) {
                            diffInitDoneUnique = true;
                        }
                    }
                    arrowFwdBwds.second = new TapList<TapPair<FGArrow, TapList>>(new TapPair<FGArrow, TapList>(fwdArrow, hasBwd ? new TapList<BwdSwitchCase>(new BwdSwitchCase(fwdArrow, bwdDiffBlock, new TapList<Block>(block, null), exitArrow.destination), null) : null), null);
                    exitArrowsFwdBwds = exitArrowsFwdBwds.tail;
                }
            }
        }
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.decrTraceIndent(2);
            TapEnv.indentprintlnOnTrace(">>end diff PLAIN_BLOCK " + plainLeafLevel);
            TapEnv.indentprintlnOnTrace("  -upstream: " + result.fwdBlockUS + " ; " + result.bwdArrowsUS);
            exitArrowsFwdBwds = result.exitArrowsFwdBwds;
            TapEnv.indentprintOnTrace("  -dnstream: (");
            while (exitArrowsFwdBwds != null) {
                TapEnv.printlnOnTrace("-" + exitArrowsFwdBwds.head);
                exitArrowsFwdBwds = exitArrowsFwdBwds.tail;
                TapEnv.indentprintOnTrace("             " + (exitArrowsFwdBwds == null ? "" : Character.valueOf(' ')));
            }
            TapEnv.printlnOnTrace(")");
        }
        return result;
    }

    private FlowGraphDifferentiation differentiateMultithreadRegion(FlowGraphLevel regionLevel, FlowGraphDifferentiationEnv diffEnv) {
        TapList exitArrowsFwdBwds;
        FlowGraphDifferentiation result;
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.indentprintlnOnTrace("begin diff MULTITHREAD REGION " + regionLevel);
            TapEnv.incrTraceIndent(2);
        }
        Block block = regionLevel.entryBlock;
        Tree pragma = block.headInstr().tree;
        boolean modeIsAdjoint = diffEnv.adDiffMode == -1 || diffEnv.adDiffMode == -2;
        this.precomputeDifferentiatedBlocksIn(regionLevel, diffEnv);
        FlowGraphDifferentiation regionBodyDifferentiation = this.differentiateFlowGraphLevel(regionLevel.createRegionBody(), diffEnv);
        regionLevel.restoreChildrenParent();
        Tree srcSchedule = (Tree)pragma.getAnnotation("srcSchedule");
        if (modeIsAdjoint && regionBodyDifferentiation.hasBwd() && pragma.opCode() == 144 && ILUtils.isIdent(pragma.down(1), "omp", false)) {
            result = ILUtils.isStaticSchedule(srcSchedule) ? this.differentiateOMPLoopScheduleAdjointStatic(regionLevel, diffEnv, regionBodyDifferentiation) : this.differentiateOMPLoopScheduleAdjointDynamic(regionLevel, diffEnv, regionBodyDifferentiation, srcSchedule);
        } else if (pragma.opCode() == 144 && ILUtils.isIdent(pragma.down(1), "omp", false)) {
            result = this.differentiateOMPLoopTangent(regionLevel, diffEnv, regionBodyDifferentiation, srcSchedule);
        } else {
            TapPair arrowFwdBwds;
            Block fwdDiffBlock = (Block)diffEnv.fwdDiffBlocks.retrieve(block);
            Block bwdDiffBlock = (Block)diffEnv.bwdDiffBlocks.retrieve(block);
            SymbolTable fwdDiffSymbolTable = fwdDiffBlock.symbolTable;
            SymbolTable diffSymbolTable = bwdDiffBlock == null ? null : bwdDiffBlock.symbolTable;
            Block firstBlockInRegion = ((FGArrow)block.flow().head).destination;
            Block fwdPreExit = this.buildFwdBlock(block.rank + "+preX", fwdDiffSymbolTable, firstBlockInRegion, diffEnv);
            Block bwdPostExit = null;
            if (modeIsAdjoint) {
                bwdPostExit = this.buildBwdBlock(block.rank + "-postX", diffSymbolTable, block, diffEnv);
            }
            if (srcSchedule != null && fwdDiffBlock.headInstr() != null) {
                ILUtils.addSchedule(ILUtils.copy(srcSchedule), fwdDiffBlock.headInstr().tree);
            }
            result = new FlowGraphDifferentiation(regionLevel);
            if (regionBodyDifferentiation.hasBwd()) {
                assert (bwdDiffBlock != null);
                this.checkFreeThenSetNewFGArrow(fwdDiffBlock, 0, 0, regionBodyDifferentiation.fwdBlockUS, false);
                TapList privatePreInits = null;
                TapList privatePostInits = null;
                if (bwdDiffBlock.headInstr() != null) {
                    TapPair privateInitsAnnotation = (TapPair)bwdDiffBlock.headInstr().tree.getRemoveAnnotation("bwdOMPPrivateInits");
                    if (privateInitsAnnotation != null) {
                        privatePreInits = (TapList)privateInitsAnnotation.first;
                        privatePostInits = (TapList)privateInitsAnnotation.second;
                    }
                    if (srcSchedule != null) {
                        ILUtils.addSchedule(ILUtils.copy(srcSchedule), bwdDiffBlock.headInstr().tree);
                    }
                }
                while (privatePostInits != null) {
                    bwdPostExit.addInstrTl((Tree)privatePostInits.head);
                    privatePostInits = privatePostInits.tail;
                }
                Block afterBwdEntry = bwdDiffBlock;
                if (privatePreInits != null || pragma.opCode() == 145) {
                    Block bwdPostEntry = this.buildBwdBlock(block.rank + "-postE", diffSymbolTable, firstBlockInRegion, diffEnv);
                    while (privatePreInits != null) {
                        bwdPostEntry.addInstrTl((Tree)privatePreInits.head);
                        privatePreInits = privatePreInits.tail;
                    }
                    this.checkFreeThenSetNewFGArrow(afterBwdEntry, 0, 0, bwdPostEntry, false);
                    this.savePrivatesBeforeTheyVanish(fwdPreExit, bwdPostEntry, regionLevel);
                    afterBwdEntry = bwdPostEntry;
                }
                if (pragma.opCode() == 145) {
                    TapList<Tree> newSumReductionVars;
                    TapList<Tree> newPrivateVars;
                    Tree fwdParallelRegion = fwdDiffBlock.headInstr().tree;
                    Tree bwdParallelRegion = bwdDiffBlock.headInstr().tree;
                    if (this.ompChunksOriginalIndexFwd != null) {
                        this.makeSurePrivate(this.ompChunksOriginalIndexFwd, fwdParallelRegion.down(2));
                    }
                    if ((newPrivateVars = ILUtils.extractPrivateTrees(pragma, fwdDiffSymbolTable, true, false)) != null) {
                        fwdParallelRegion.down(2).addChild(ILUtils.build(157, ILUtils.build(97, newPrivateVars)), -1);
                    }
                    if (this.ompChunksOriginalIndex != null) {
                        this.makeSurePrivate(this.ompChunksOriginalIndex, bwdParallelRegion.down(2));
                    }
                    if ((newPrivateVars = ILUtils.extractPrivateTrees(pragma, diffSymbolTable, false, false)) != null) {
                        bwdParallelRegion.down(2).addChild(ILUtils.build(157, ILUtils.build(97, newPrivateVars)), -1);
                    }
                    newPrivateVars = ILUtils.extractPrivateTrees(pragma, diffSymbolTable, false, true);
                    newPrivateVars = this.varRefDifferentiator().mapDiffVarRef(this.adEnv.curActivity(), newPrivateVars, diffSymbolTable);
                    if (newPrivateVars != null) {
                        bwdParallelRegion.down(2).addChild(ILUtils.build(157, ILUtils.build(97, newPrivateVars)), -1);
                    }
                    if ((newSumReductionVars = ILUtils.extractSumReductionTrees(pragma, diffSymbolTable)) != null) {
                        bwdParallelRegion.down(2).addChild(ILUtils.build(162, ILUtils.build(96, "+"), ILUtils.build(97, newSumReductionVars)), -1);
                    }
                }
                Block newFwdEntry = fwdDiffBlock;
                Block newBwdEntry = bwdDiffBlock;
                if (ILUtils.isIdent(pragma.down(1), "cuda", false)) {
                    Block srcCudaCallBlock = ((FlowGraphLevel)((FlowGraphLevel)regionLevel).contents.head).entryBlock;
                    Block fwdPreCuda = this.buildFwdBlock(block.rank + "+preCuda", fwdDiffSymbolTable, block, diffEnv);
                    this.movePreCudaCode((Block)diffEnv.fwdDiffBlocks.retrieve(srcCudaCallBlock), fwdPreCuda);
                    this.checkFreeThenSetNewFGArrow(fwdPreCuda, 0, 0, fwdDiffBlock, false);
                    newFwdEntry = fwdPreCuda;
                    Block bwdPreCuda = this.buildBwdBlock(block.rank + "-preCuda", diffSymbolTable, block, diffEnv);
                    this.movePreCudaCode((Block)diffEnv.bwdDiffBlocks.retrieve(srcCudaCallBlock), bwdPreCuda);
                    this.checkFreeThenSetNewFGArrow(bwdPreCuda, 0, 0, bwdDiffBlock, false);
                    newBwdEntry = bwdPreCuda;
                }
                PushPopNode pushPopTree = this.buildFwdBwdTreeFromExitFwdBwd(regionBodyDifferentiation.exitArrowsFwdBwds);
                this.connectFwdBwd(pushPopTree, fwdPreExit, new TapList<FGArrow>(this.checkFreeThenSetNewFGArrow(afterBwdEntry, 0, 0, null, false), null), null, null, diffEnv, regionLevel);
                this.connectBwd(regionBodyDifferentiation.bwdArrowsUS, bwdPostExit, false, block, block, diffEnv);
                result.fwdBlockUS = newFwdEntry;
                result.bwdArrowsUS = new TapList<FGArrow>(this.checkFreeThenSetNewFGArrow(bwdPostExit, 0, 0, null, false), null);
                exitArrowsFwdBwds = result.exitArrowsFwdBwds;
                FGArrow fwdArrow = this.checkFreeThenSetNewFGArrow(fwdPreExit, 0, 0, null, false);
                while (exitArrowsFwdBwds != null) {
                    arrowFwdBwds = (TapPair)exitArrowsFwdBwds.head;
                    FGArrow exitArrow = (FGArrow)arrowFwdBwds.first;
                    arrowFwdBwds.second = new TapList<TapPair<FGArrow, TapList<BwdSwitchCase>>>(new TapPair<FGArrow, TapList<BwdSwitchCase>>(fwdArrow, new TapList<BwdSwitchCase>(new BwdSwitchCase(fwdArrow, newBwdEntry, new TapList<Block>(exitArrow.origin, null), exitArrow.destination), null)), null);
                    exitArrowsFwdBwds = exitArrowsFwdBwds.tail;
                }
            } else if (regionBodyDifferentiation.reallyHasFwd()) {
                this.checkFreeThenSetNewFGArrow(fwdDiffBlock, 0, 0, regionBodyDifferentiation.fwdBlockUS, false);
                Block fwdPostExit = this.buildFwdBlock(block.rank + "+postX", fwdDiffSymbolTable, block, diffEnv);
                exitArrowsFwdBwds = regionBodyDifferentiation.exitArrowsFwdBwds;
                while (exitArrowsFwdBwds != null) {
                    arrowFwdBwds = (TapPair)exitArrowsFwdBwds.head;
                    TapList manyFwdBwds = (TapList)arrowFwdBwds.second;
                    while (manyFwdBwds != null) {
                        this.checkFreeThenRedirectDestination((FGArrow)((TapPair)manyFwdBwds.head).first, fwdPostExit, false);
                        manyFwdBwds = manyFwdBwds.tail;
                    }
                    exitArrowsFwdBwds = exitArrowsFwdBwds.tail;
                }
                if (pragma.opCode() == 145) {
                    TapList<Tree> newPrivateVars;
                    Tree fwdParallelRegion = fwdDiffBlock.headInstr().tree;
                    if (this.ompChunksOriginalIndexFwd != null) {
                        this.makeSurePrivate(this.ompChunksOriginalIndexFwd, fwdParallelRegion.down(2));
                    }
                    if ((newPrivateVars = ILUtils.extractPrivateTrees(pragma, fwdDiffSymbolTable, true, false)) != null) {
                        fwdParallelRegion.down(2).addChild(ILUtils.build(157, ILUtils.build(97, newPrivateVars)), -1);
                    }
                }
                result.fwdBlockUS = fwdDiffBlock;
                exitArrowsFwdBwds = result.exitArrowsFwdBwds;
                FGArrow fwdArrow = this.checkFreeThenSetNewFGArrow(fwdPostExit, 0, 0, null, false);
                while (exitArrowsFwdBwds != null) {
                    arrowFwdBwds = (TapPair)exitArrowsFwdBwds.head;
                    FGArrow exitArrow = (FGArrow)arrowFwdBwds.first;
                    arrowFwdBwds.second = new TapList<TapPair<FGArrow, Object>>(new TapPair<FGArrow, Object>(fwdArrow, null), null);
                    exitArrowsFwdBwds = exitArrowsFwdBwds.tail;
                }
            } else {
                result.fwdBlockUS = null;
                result.bwdArrowsUS = null;
            }
        }
        pragma.removeAnnotation("onlyReadSmallActivePrimals");
        pragma.removeAnnotation("forcedScopingNames");
        pragma.removeAnnotation("srcSchedule");
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.decrTraceIndent(2);
            TapEnv.indentprintlnOnTrace(">>end diff MULTITHREAD REGION " + regionLevel + " hasFwd:" + regionBodyDifferentiation.reallyHasFwd() + " hasBwd:" + regionBodyDifferentiation.hasBwd());
            TapEnv.indentprintlnOnTrace("  -upstream: " + result.fwdBlockUS + " ; " + result.bwdArrowsUS);
            exitArrowsFwdBwds = result.exitArrowsFwdBwds;
            TapEnv.indentprintOnTrace("  -dnstream: (");
            while (exitArrowsFwdBwds != null) {
                TapEnv.printlnOnTrace("-" + exitArrowsFwdBwds.head);
                exitArrowsFwdBwds = exitArrowsFwdBwds.tail;
                TapEnv.indentprintOnTrace("             " + (exitArrowsFwdBwds == null ? "" : Character.valueOf(' ')));
            }
            TapEnv.printlnOnTrace(")");
        }
        return result;
    }

    private void movePreCudaCode(Block cudaCallBlock, Block preBlock) {
        if (cudaCallBlock.instructions != null) {
            while (cudaCallBlock.instructions.tail != null) {
                Instruction moved = (Instruction)cudaCallBlock.instructions.head;
                cudaCallBlock.instructions = cudaCallBlock.instructions.tail;
                moved.block = preBlock;
                preBlock.instructions = TapList.addLast(preBlock.instructions, moved);
            }
        }
    }

    private FlowGraphDifferentiation differentiateOMPLoopTangent(FlowGraphLevel regionLevel, FlowGraphDifferentiationEnv diffEnv, FlowGraphDifferentiation regionBodyDifferentiation, Tree srcSchedule) {
        Block block = regionLevel.entryBlock;
        Block fwdDiffBlock = (Block)diffEnv.fwdDiffBlocks.retrieve(block);
        if (srcSchedule != null && fwdDiffBlock != null && fwdDiffBlock.headInstr() != null) {
            ILUtils.addSchedule(ILUtils.copy(srcSchedule), fwdDiffBlock.headInstr().tree);
        }
        if (regionBodyDifferentiation.reallyHasFwd()) {
            HeaderBlock insideLoopHeader = (HeaderBlock)((FGArrow)((FlowGraphLevel)regionLevel).entryBlock.flow().head).destination;
            HeaderBlock insideLoopFwdDiffBlock = (HeaderBlock)diffEnv.fwdDiffBlocks.retrieve(insideLoopHeader);
            if (regionBodyDifferentiation.fwdBlockUS == insideLoopFwdDiffBlock) {
                this.checkFreeThenSetNewFGArrow(fwdDiffBlock, 0, 0, (Block)insideLoopFwdDiffBlock, false);
                regionBodyDifferentiation.fwdBlockUS = fwdDiffBlock;
            } else {
                insideLoopFwdDiffBlock.insertBlockBeforeLoopEntry(fwdDiffBlock);
            }
        }
        return regionBodyDifferentiation;
    }

    private FlowGraphDifferentiation differentiateOMPLoopScheduleAdjointStatic(FlowGraphLevel regionLevel, FlowGraphDifferentiationEnv diffEnv, FlowGraphDifferentiation regionBodyDifferentiation) {
        SymbolTable diffSymbolTable;
        Block block = regionLevel.entryBlock;
        Block fwdDiffBlock = (Block)diffEnv.fwdDiffBlocks.retrieve(block);
        Block bwdDiffBlock = (Block)diffEnv.bwdDiffBlocks.retrieve(block);
        SymbolTable fwdDiffSymbolTable = fwdDiffBlock.symbolTable;
        SymbolTable symbolTable = diffSymbolTable = bwdDiffBlock == null ? null : bwdDiffBlock.symbolTable;
        if (this.adOmpChunkStartVarTool == null) {
            this.adOmpChunkStartVarTool = new FwdBwdVarTool(this.adOmpChunkStartStr, null, block, this.curFwdDiffUnit().privateSymbolTable(), this.curDiffUnit().privateSymbolTable());
        }
        if (this.adOmpChunkEndVarTool == null) {
            this.adOmpChunkEndVarTool = new FwdBwdVarTool(this.adOmpChunkEndStr, null, block, this.curFwdDiffUnit().privateSymbolTable(), this.curDiffUnit().privateSymbolTable());
        }
        HeaderBlock insideLoopHeader = (HeaderBlock)((FGArrow)((FlowGraphLevel)regionLevel).entryBlock.flow().head).destination;
        HeaderBlock insideLoopFwdDiffBlock = (HeaderBlock)diffEnv.fwdDiffBlocks.retrieve(insideLoopHeader);
        Tree insideFwdLoopDoTree = insideLoopFwdDiffBlock.headInstr().tree.down(3);
        Tree staticScheduleCall = ILUtils.buildCall(ILUtils.build(96, "getStaticSchedule"), ILUtils.build(71, ILUtils.copy(insideFwdLoopDoTree.down(2)), ILUtils.copy(insideFwdLoopDoTree.down(3)), ILUtils.isNullOrNone(insideFwdLoopDoTree.down(4)) ? ILUtils.build(103, 1) : ILUtils.copy(insideFwdLoopDoTree.down(4)), this.adOmpChunkStartVarTool.makeFwdRef(block), this.adOmpChunkEndVarTool.makeFwdRef(block)));
        insideFwdLoopDoTree.setChild(this.adOmpChunkStartVarTool.makeFwdRef(block), 2);
        insideFwdLoopDoTree.setChild(this.adOmpChunkEndVarTool.makeFwdRef(block), 3);
        this.ompChunksOriginalIndexFwd = insideFwdLoopDoTree.down(1);
        HeaderBlock insideLoopBwdDiffBlock = (HeaderBlock)diffEnv.bwdDiffBlocks.retrieve(insideLoopHeader);
        Tree insideBwdLoopDoTree = insideLoopBwdDiffBlock.headInstr().tree.down(3);
        insideBwdLoopDoTree.setChild(this.adOmpChunkEndVarTool.makeRef(block), 2);
        insideBwdLoopDoTree.setChild(this.adOmpChunkStartVarTool.makeRef(block), 3);
        this.ompChunksOriginalIndex = insideBwdLoopDoTree.down(1);
        Block fwdPreEntry = this.buildFwdBlock(block.rank + "+preE", fwdDiffSymbolTable, block, diffEnv);
        fwdPreEntry.addInstrTl(staticScheduleCall);
        Block bwdPreEntry = this.buildBwdBlock(block.rank + "-preE", diffSymbolTable, block, diffEnv);
        bwdPreEntry.addInstrTl(ILUtils.copy(staticScheduleCall));
        if (regionBodyDifferentiation.fwdBlockUS == insideLoopFwdDiffBlock) {
            this.checkFreeThenSetNewFGArrow(fwdPreEntry, 0, 0, (Block)insideLoopFwdDiffBlock, false);
            regionBodyDifferentiation.fwdBlockUS = fwdPreEntry;
        } else {
            insideLoopFwdDiffBlock.insertBlockBeforeLoopEntry(fwdPreEntry);
        }
        BwdSwitchCase singleBwdSwitchCase = (BwdSwitchCase)((TapList)((TapPair)((TapList)((TapPair)((FlowGraphDifferentiation)regionBodyDifferentiation).exitArrowsFwdBwds.head).second).head).second).head;
        if (singleBwdSwitchCase.bwdBlock == insideLoopBwdDiffBlock) {
            this.checkFreeThenSetNewFGArrow(bwdPreEntry, 0, 0, (Block)insideLoopBwdDiffBlock, false);
            singleBwdSwitchCase.bwdBlock = bwdPreEntry;
        } else {
            insideLoopBwdDiffBlock.insertBlockBeforeLoopEntry(bwdPreEntry);
        }
        return regionBodyDifferentiation;
    }

    private FlowGraphDifferentiation differentiateOMPLoopScheduleAdjointDynamic(FlowGraphLevel regionLevel, FlowGraphDifferentiationEnv diffEnv, FlowGraphDifferentiation regionBodyDifferentiation, Tree srcSchedule) {
        Tree newStrideTree;
        Block block = regionLevel.entryBlock;
        Block fwdDiffBlock = (Block)diffEnv.fwdDiffBlocks.retrieve(block);
        Block bwdDiffBlock = (Block)diffEnv.bwdDiffBlocks.retrieve(block);
        SymbolTable fwdDiffSymbolTable = fwdDiffBlock.symbolTable;
        SymbolTable diffSymbolTable = bwdDiffBlock == null ? null : bwdDiffBlock.symbolTable;
        Instruction parallelRegionInstr = TapList.last(block.parallelControls);
        if (this.ompChunksNumVariable == null) {
            this.ompChunksNumVariable = new NewSymbolHolder("numchunks", this.curDiffUnit(), this.adEnv.integerTypeSpec, -1);
        }
        this.ompChunksNumVariable.declarationLevelMustInclude(this.curDiffUnit().privateSymbolTable());
        this.ompChunksNumVariable.preparePrivateClause(block, this.adEnv.curUnit().privateSymbolTable(), false, false);
        if (this.ompChunksIndexVariable == null) {
            this.ompChunksIndexVariable = new NewSymbolHolder("ichunk", this.curDiffUnit(), this.adEnv.integerTypeSpec, -1);
        }
        this.ompChunksIndexVariable.declarationLevelMustInclude(this.curDiffUnit().privateSymbolTable());
        this.ompChunksIndexVariable.preparePrivateClause(block, this.adEnv.curUnit().privateSymbolTable(), false, false);
        if (this.adOmpChunkStartVarTool == null) {
            this.adOmpChunkStartVarTool = new FwdBwdVarTool(this.adOmpChunkStartStr, null, block, null, this.curDiffUnit().privateSymbolTable());
        }
        if (this.adOmpChunkEndVarTool == null) {
            this.adOmpChunkEndVarTool = new FwdBwdVarTool(this.adOmpChunkEndStr, null, block, null, this.curDiffUnit().privateSymbolTable());
        }
        Block fwdPreEntry = this.buildFwdBlock(block.rank + "+preE", fwdDiffSymbolTable, block, diffEnv);
        fwdPreEntry.addInstrTl(ILUtils.buildCall(ILUtils.build(96, "initDynamicSchedule"), ILUtils.build(71)));
        HeaderBlock insideLoopHeader = (HeaderBlock)((FGArrow)((FlowGraphLevel)regionLevel).entryBlock.flow().head).destination;
        HeaderBlock insideLoopFwdDiffBlock = (HeaderBlock)diffEnv.fwdDiffBlocks.retrieve(insideLoopHeader);
        Tree insideFwdLoopIndex = insideLoopFwdDiffBlock.headInstr().tree.down(3).down(1);
        Tree strideTree = insideLoopFwdDiffBlock.headInstr().tree.down(3).down(4);
        if (ILUtils.isNullOrNone(strideTree)) {
            strideTree = ILUtils.build(103, 1);
        }
        if (InOutAnalyzer.isCheapDuplicableConstant(strideTree, insideLoopHeader, insideLoopHeader.headInstr())) {
            newStrideTree = ILUtils.copy(strideTree);
        } else {
            FwdBwdVarTool adStrideVarTool = new FwdBwdVarTool(this.adStrideStr, null, insideLoopHeader, fwdDiffSymbolTable, diffSymbolTable);
            fwdPreEntry.addInstrHdAfterDecls(ILUtils.build(14, adStrideVarTool.makeFwdRef(block), ILUtils.copy(strideTree)));
            insideLoopFwdDiffBlock.headInstr().tree.down(3).setChild(adStrideVarTool.makeFwdRef(block), 4);
            newStrideTree = adStrideVarTool.makeFwdRef(block);
        }
        FGArrow loopNextArrow = insideLoopFwdDiffBlock.getFGArrowTestCase(30, 1);
        Block insideFwdLoopPreNext = this.buildFwdBlock(block.rank + "+preIter", fwdDiffSymbolTable, insideLoopHeader, diffEnv);
        insideFwdLoopPreNext.addInstrTl(ILUtils.buildCall(ILUtils.build(96, "recordDynamicSchedule"), ILUtils.build(71, ILUtils.copy(insideFwdLoopIndex), newStrideTree)));
        this.insertBlockAtDest(loopNextArrow, insideFwdLoopPreNext, 0, 0);
        HeaderBlock insideLoopBwdDiffBlock = (HeaderBlock)diffEnv.bwdDiffBlocks.retrieve(insideLoopHeader);
        Tree insideBwdLoopDoTree = insideLoopBwdDiffBlock.headInstr().tree.down(3);
        insideBwdLoopDoTree.setChild(this.adOmpChunkEndVarTool.makeRef(block), 2);
        insideBwdLoopDoTree.setChild(this.adOmpChunkStartVarTool.makeRef(block), 3);
        this.ompChunksOriginalIndex = insideBwdLoopDoTree.down(1);
        Block fwdPostExit = this.buildFwdBlock(block.rank + "+postX", fwdDiffSymbolTable, block, diffEnv);
        fwdPostExit.addInstrTl(ILUtils.buildCall(ILUtils.build(96, "finalizeDynamicSchedule"), ILUtils.build(71)));
        HeaderBlock bwdNewHeaderBlock = this.buildBwdHeaderBlock(block.rank + "-NewHd", diffSymbolTable, block, diffEnv);
        bwdNewHeaderBlock.addInstrTl(ILUtils.build(121, null, null, ILUtils.build(64, this.ompChunksIndexVariable.makeNewRef(diffSymbolTable), ILUtils.build(103, 1), this.ompChunksNumVariable.makeNewRef(diffSymbolTable))));
        Block bwdPreEntry = this.buildBwdBlock(block.rank + "-preE", diffSymbolTable, block, diffEnv);
        assert (diffSymbolTable != null);
        RefDescriptor chunksNumRefDescriptor = new RefDescriptor(this.ompChunksNumVariable.makeNewRef(diffSymbolTable), null, diffSymbolTable, diffSymbolTable, null, null, false, null, this.curDiffUnit());
        this.blockDifferentiator().prepareRestoreOperations(chunksNumRefDescriptor, chunksNumRefDescriptor, 1, diffSymbolTable, diffSymbolTable);
        bwdPreEntry.addInstrTl(chunksNumRefDescriptor.makePop());
        Block bwdPreNext = this.buildBwdBlock(block.rank + "-preNext", diffSymbolTable, block, diffEnv);
        bwdPreNext.addInstrTl(this.adOmpChunkEndVarTool.makePop(block));
        bwdPreNext.addInstrTl(this.adOmpChunkStartVarTool.makePop(block));
        if (regionBodyDifferentiation.fwdBlockUS == insideLoopFwdDiffBlock) {
            this.checkFreeThenSetNewFGArrow(fwdPreEntry, 0, 0, fwdDiffBlock, false);
            this.checkFreeThenSetNewFGArrow(fwdDiffBlock, 0, 0, (Block)insideLoopFwdDiffBlock, false);
            regionBodyDifferentiation.fwdBlockUS = fwdPreEntry;
        } else {
            insideLoopFwdDiffBlock.insertBlockBeforeLoopEntry(fwdPreEntry);
            insideLoopFwdDiffBlock.insertBlockBeforeLoopEntry(fwdDiffBlock);
        }
        this.insertBlockAtOrig(insideLoopFwdDiffBlock.getFGArrowTestCase(30, 0), fwdPostExit, 0, 0);
        this.checkFreeThenSetNewFGArrow(bwdPreEntry, 0, 0, (Block)bwdNewHeaderBlock, false);
        this.checkFreeThenSetNewFGArrow((Block)bwdNewHeaderBlock, 30, 1, bwdPreNext, false);
        insideLoopBwdDiffBlock.getFGArrowTestCase(30, 0).redirectOrigin(bwdNewHeaderBlock);
        this.checkFreeThenSetNewFGArrow((Block)insideLoopBwdDiffBlock, 30, 0, (Block)bwdNewHeaderBlock, true);
        this.checkFreeThenSetNewFGArrow(bwdPreNext, 0, 0, (Block)insideLoopBwdDiffBlock, false);
        BwdSwitchCase singleBwdSwitchCase = (BwdSwitchCase)((TapList)((TapPair)((TapList)((TapPair)((FlowGraphDifferentiation)regionBodyDifferentiation).exitArrowsFwdBwds.head).second).head).second).head;
        Block bodyBwdDS = singleBwdSwitchCase.bwdBlock;
        if (bodyBwdDS == insideLoopBwdDiffBlock) {
            singleBwdSwitchCase.bwdBlock = bwdPreEntry;
        } else {
            bodyBwdDS.getFGArrowTo(insideLoopBwdDiffBlock).redirectDestination(bwdPreEntry);
        }
        return regionBodyDifferentiation;
    }

    private FlowGraphDifferentiation differentiateCkpPiece(FlowGraphLevel checkpointedPiece, FlowGraphDifferentiationEnv diffEnv) {
        TapList exitArrowsFwdBwds;
        boolean hasFwd;
        boolean hasBwd;
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.indentprintlnOnTrace("begin diff CHECKPOINT " + checkpointedPiece);
            TapEnv.incrTraceIndent(2);
        }
        Block block = checkpointedPiece.entryBlock;
        this.adEnv.setCurVectorMap(DataFlowAnalyzer.makeMap3(this.adEnv.curUnit(), block, 0));
        this.adEnv.setCurPtrVectorMap(DataFlowAnalyzer.makeMap3(this.adEnv.curUnit(), block, 3));
        boolean modeIsJoint = diffEnv.adDiffMode == -1;
        TapPair<BoolVector[], BoolVector[]> dataFlowSetsWithDiffPtr7 = this.recomputeDataFlowCheckpointed(checkpointedPiece, null, modeIsJoint);
        ToBool needCopy = new ToBool(false);
        TapPair<BoolVector, BoolVector> checkpointingSets = this.computeCheckpointingSets(checkpointedPiece, (BoolVector[])dataFlowSetsWithDiffPtr7.first, needCopy, 0, this.curVectorMap());
        TapPair<BoolVector, BoolVector> checkpointingSetsOnDiffPtr = this.computeCheckpointingSets(checkpointedPiece, (BoolVector[])dataFlowSetsWithDiffPtr7.second, needCopy, 3, this.curPtrVectorMap());
        FlowGraphCopy ckpPieceCopy = needCopy.get() ? this.copyFlowGraphLevel(checkpointedPiece, new FlowGraphCopyEnv(diffEnv.diffCtxtFwd)) : null;
        FlowGraphDifferentiationEnv jointReversalEnv = diffEnv.deriveForNewJointDiff();
        jointReversalEnv.turningArrows = checkpointedPiece.exitArrows;
        jointReversalEnv.middleSymbolTables = this.collectMiddleSymbolTables(jointReversalEnv.turningArrows, checkpointedPiece.allBlocksInside());
        this.precomputeDifferentiatedBlocksIn(checkpointedPiece, jointReversalEnv);
        FlowGraphDifferentiation ckpPieceReversal = this.differentiateFlowGraphLevel(checkpointedPiece, jointReversalEnv);
        SymbolTable fwdDiffSymbolTable = block.symbolTable.smartCopy(((FlowGraphDifferentiationEnv)diffEnv).diffCtxtFwd.listST, ((FlowGraphDifferentiationEnv)diffEnv).diffCtxtFwd.unit, this.adEnv.diffCallGraph(), this.adEnv.copiedUnits, "FwdDiff of ");
        block.symbolTable.cleanCopySymbolDecls();
        SymbolTable diffSymbolTable = block.symbolTable.smartCopy(((FlowGraphDifferentiationEnv)diffEnv).diffCtxt.listST, ((FlowGraphDifferentiationEnv)diffEnv).diffCtxt.unit, this.adEnv.diffCallGraph(), this.adEnv.copiedUnits, "Diff of ");
        block.symbolTable.cleanCopySymbolDecls();
        Block fwdPreEntry = this.buildFwdBlock(block.rank + "+preCkpE", fwdDiffSymbolTable, block, diffEnv);
        Block bwdPreEntry = this.buildBwdBlock(block.rank + "-preCkpE", diffSymbolTable, block, diffEnv);
        Block bwdPostExit = this.buildBwdBlock(block.rank + "-postCkpX", diffSymbolTable, block, diffEnv);
        this.fillSnapshotInstructions((BoolVector)checkpointingSets.first, (BoolVector)checkpointingSets.second, this.curVectorMap(), (BoolVector)checkpointingSetsOnDiffPtr.first, (BoolVector)checkpointingSetsOnDiffPtr.second, this.curPtrVectorMap(), block, new TapList<Block>(fwdPreEntry, null), new TapList<Block>(bwdPreEntry, null), new TapList<Block>(bwdPostExit, null), diffEnv.adDiffMode == -1);
        if (ckpPieceReversal.hasBwd()) {
            this.mapConnectFwdBwd(ckpPieceReversal.exitArrowsFwdBwds, diffEnv, checkpointedPiece);
            this.checkFreeThenSetNewFGArrow(bwdPreEntry, 0, 0, ckpPieceReversal.fwdBlockUS, false);
            this.connectBwd(ckpPieceReversal.bwdArrowsUS, bwdPostExit, false, block, block, diffEnv);
            hasBwd = true;
        } else {
            this.checkFreeThenSetNewFGArrow(bwdPreEntry, 0, 0, bwdPostExit, false);
            hasBwd = fwdPreEntry.instructions != null;
        }
        FGArrow arrowFromPreEntry = null;
        if (needCopy.get()) {
            this.checkFreeThenSetNewFGArrow(fwdPreEntry, 0, 0, ckpPieceCopy.copyBlockUS, false);
            hasFwd = true;
        } else {
            arrowFromPreEntry = this.checkFreeThenSetNewFGArrow(fwdPreEntry, 0, 0, null, false);
            hasFwd = hasBwd || fwdPreEntry.instructions != null;
        }
        FlowGraphDifferentiation result = new FlowGraphDifferentiation(checkpointedPiece);
        if (hasBwd) {
            result.bwdArrowsUS = new TapList<FGArrow>(this.checkFreeThenSetNewFGArrow(bwdPostExit, 0, 0, null, false), null);
        }
        if (hasFwd) {
            result.fwdBlockUS = fwdPreEntry;
            exitArrowsFwdBwds = result.exitArrowsFwdBwds;
            while (exitArrowsFwdBwds != null) {
                TapPair arrowFwdBwds = (TapPair)exitArrowsFwdBwds.head;
                FGArrow exitArrow = (FGArrow)arrowFwdBwds.first;
                FGArrow fwdArrow = needCopy.get() ? ckpPieceCopy.getCopyOfExitArrow(exitArrow) : arrowFromPreEntry;
                arrowFwdBwds.second = new TapList<TapPair<FGArrow, TapList>>(new TapPair<FGArrow, TapList>(fwdArrow, hasBwd ? new TapList<BwdSwitchCase>(new BwdSwitchCase(fwdArrow, bwdPreEntry, new TapList<Block>(exitArrow.origin, null), exitArrow.destination), null) : null), null);
                exitArrowsFwdBwds = exitArrowsFwdBwds.tail;
            }
        }
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.decrTraceIndent(2);
            TapEnv.indentprintlnOnTrace(">>end diff CHECKPOINT " + checkpointedPiece + " hasFwd:" + hasFwd + " hasBwd:" + hasBwd);
            TapEnv.indentprintlnOnTrace("  -upstream: " + result.fwdBlockUS + " ; " + result.bwdArrowsUS);
            exitArrowsFwdBwds = result.exitArrowsFwdBwds;
            TapEnv.indentprintOnTrace("  -dnstream: (");
            while (exitArrowsFwdBwds != null) {
                TapEnv.printlnOnTrace("-" + exitArrowsFwdBwds.head);
                exitArrowsFwdBwds = exitArrowsFwdBwds.tail;
                TapEnv.indentprintOnTrace("             " + (exitArrowsFwdBwds == null ? "" : Character.valueOf(' ')));
            }
            TapEnv.printlnOnTrace(")");
        }
        return result;
    }

    private FlowGraphDifferentiation differentiateNoDiffPiece(FlowGraphLevel noDiffPiece, FlowGraphDifferentiationEnv diffEnv) {
        TapList exitArrowsFwdBwds;
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.indentprintlnOnTrace("begin diff NODIFF " + noDiffPiece);
            TapEnv.incrTraceIndent(2);
        }
        Block block = noDiffPiece.entryBlock;
        this.adEnv.setCurVectorMap(DataFlowAnalyzer.makeMap3(this.adEnv.curUnit(), block, 0));
        this.adEnv.setCurPtrVectorMap(DataFlowAnalyzer.makeMap3(this.adEnv.curUnit(), block, 3));
        String noDiffLabel = block.headInstr().hasDirective((int)21).label;
        boolean modeIsJoint = diffEnv.adDiffMode == -1;
        TapPair<BoolVector[], BoolVector[]> dataFlowSetsWithDiffPtr7 = diffEnv.adDiffMode != 1 ? this.recomputeDataFlowCheckpointed(noDiffPiece, null, modeIsJoint) : null;
        ToBool needCopy = new ToBool(false);
        TapPair<BoolVector, BoolVector> checkpointingSets = null;
        TapPair<BoolVector, BoolVector> checkpointingSetsOnDiffPtr = null;
        if (diffEnv.adDiffMode == 1) {
            needCopy.set(true);
        } else {
            checkpointingSets = this.computeCheckpointingSets(noDiffPiece, (BoolVector[])dataFlowSetsWithDiffPtr7.first, needCopy, 0, this.curVectorMap());
            checkpointingSetsOnDiffPtr = this.computeCheckpointingSets(noDiffPiece, (BoolVector[])dataFlowSetsWithDiffPtr7.second, needCopy, 3, this.curPtrVectorMap());
        }
        FlowGraphCopy noDiffPieceCopy = needCopy.get() ? this.copyFlowGraphLevel(noDiffPiece, new FlowGraphCopyEnv(diffEnv.diffCtxtFwd)) : null;
        SymbolTable fwdDiffSymbolTable = block.symbolTable.smartCopy(((FlowGraphDifferentiationEnv)diffEnv).diffCtxtFwd.listST, ((FlowGraphDifferentiationEnv)diffEnv).diffCtxtFwd.unit, this.adEnv.diffCallGraph(), this.adEnv.copiedUnits, "FwdDiff of ");
        block.symbolTable.cleanCopySymbolDecls();
        SymbolTable diffSymbolTable = block.symbolTable.smartCopy(((FlowGraphDifferentiationEnv)diffEnv).diffCtxt.listST, ((FlowGraphDifferentiationEnv)diffEnv).diffCtxt.unit, this.adEnv.diffCallGraph(), this.adEnv.copiedUnits, "Diff of ");
        block.symbolTable.cleanCopySymbolDecls();
        boolean hasBwd = diffEnv.adDiffMode != 1 && !this.adEnv.curUnitIsContext;
        Block fwdPreEntry = this.buildFwdBlock(block.rank + "+preNdE", fwdDiffSymbolTable, block, diffEnv);
        Block fwdPostCommentBlock = this.buildFwdBlock(block.rank + "+postNdX", fwdDiffSymbolTable, block, diffEnv);
        Block bwdPreEntry = this.buildBwdBlock(block.rank + "-preNdE", diffSymbolTable, block, diffEnv);
        Block bwdPostExit = null;
        if (hasBwd) {
            bwdPostExit = this.buildBwdBlock(block.rank + "-postNdX", diffSymbolTable, block, diffEnv);
            assert (checkpointingSets != null);
            this.fillSnapshotInstructions((BoolVector)checkpointingSets.first, (BoolVector)checkpointingSets.second, this.curVectorMap(), (BoolVector)checkpointingSetsOnDiffPtr.first, (BoolVector)checkpointingSetsOnDiffPtr.second, this.curPtrVectorMap(), block, new TapList<Block>(fwdPreEntry, null), new TapList<Block>(bwdPreEntry, null), new TapList<Block>(bwdPostExit, null), diffEnv.adDiffMode == -1);
            this.checkFreeThenSetNewFGArrow(bwdPreEntry, 0, 0, bwdPostExit, false);
            if (bwdPostExit.instructions == null) {
                bwdPostExit.addInstrHdAfterDecls(ILUtils.build(138));
            }
            bwdPostExit.headInstr().addPreComments("$END-BWD-OF DO-NOT-DIFF " + noDiffLabel);
            bwdPostExit.headInstr().addPreComments("$BWD-OF DO-NOT-DIFF " + noDiffLabel);
        }
        fwdPostCommentBlock.addInstrHdAfterDecls(ILUtils.build(138));
        fwdPostCommentBlock.headInstr().addPreComments((diffEnv.adDiffMode == 1 ? "$END-TGT" : "$END-FWD") + "-OF DO-NOT-DIFF " + noDiffLabel);
        FGArrow fwdPostCommentArrow = this.checkFreeThenSetNewFGArrow(fwdPostCommentBlock, 0, 0, null, false);
        FGArrow arrowFromPreEntry = null;
        if (needCopy.get()) {
            this.checkFreeThenSetNewFGArrow(fwdPreEntry, 0, 0, noDiffPieceCopy.copyBlockUS, false);
            noDiffPieceCopy.copyBlockUS.headInstr().addPreComments((diffEnv.adDiffMode == 1 ? "$TGT" : "$FWD") + "-OF DO-NOT-DIFF " + noDiffLabel);
        } else {
            fwdPostCommentBlock.headInstr().addPreComments((diffEnv.adDiffMode == 1 ? "$TGT" : "$FWD") + "-OF DO-NOT-DIFF " + noDiffLabel);
            arrowFromPreEntry = this.checkFreeThenSetNewFGArrow(fwdPreEntry, 0, 0, null, false);
        }
        boolean hasFwd = true;
        FlowGraphDifferentiation result = new FlowGraphDifferentiation(noDiffPiece);
        if (hasBwd) {
            result.bwdArrowsUS = new TapList<FGArrow>(this.checkFreeThenSetNewFGArrow(bwdPostExit, 0, 0, null, false), null);
        }
        if (hasFwd) {
            result.fwdBlockUS = fwdPreEntry;
            exitArrowsFwdBwds = result.exitArrowsFwdBwds;
            while (exitArrowsFwdBwds != null) {
                TapPair arrowFwdBwds = (TapPair)exitArrowsFwdBwds.head;
                FGArrow exitArrow = (FGArrow)arrowFwdBwds.first;
                FGArrow fwdArrow = needCopy.get() ? noDiffPieceCopy.getCopyOfExitArrow(exitArrow) : arrowFromPreEntry;
                this.checkFreeThenRedirectDestination(fwdArrow, fwdPostCommentBlock, false);
                fwdArrow = fwdPostCommentArrow;
                arrowFwdBwds.second = new TapList<TapPair<FGArrow, TapList>>(new TapPair<FGArrow, TapList>(fwdArrow, hasBwd ? new TapList<BwdSwitchCase>(new BwdSwitchCase(fwdArrow, bwdPreEntry, new TapList<Block>(exitArrow.origin, null), exitArrow.destination), null) : null), null);
                exitArrowsFwdBwds = exitArrowsFwdBwds.tail;
            }
        }
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.decrTraceIndent(2);
            TapEnv.indentprintlnOnTrace(">>end diff NODIFF " + noDiffPiece);
            TapEnv.indentprintlnOnTrace("  -upstream: " + result.fwdBlockUS + " ; " + result.bwdArrowsUS);
            exitArrowsFwdBwds = result.exitArrowsFwdBwds;
            TapEnv.indentprintOnTrace("  -dnstream: (");
            while (exitArrowsFwdBwds != null) {
                TapEnv.printlnOnTrace("-" + exitArrowsFwdBwds.head);
                exitArrowsFwdBwds = exitArrowsFwdBwds.tail;
                TapEnv.indentprintOnTrace("             " + (exitArrowsFwdBwds == null ? "" : Character.valueOf(' ')));
            }
            TapEnv.printlnOnTrace(")");
        }
        return result;
    }

    private FlowGraphDifferentiation differentiateLabelledRegion(FlowGraphLevel labelledPiece, FlowGraphDifferentiationEnv diffEnv) {
        FGArrow exitArrow;
        TapPair arrowFwdBwds;
        TapList exitArrowsFwdBwds;
        FGArrow uniqueArrow;
        Block regionEntryBlock = labelledPiece.entryBlock;
        String primalLabel = labelledPiece.label;
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.indentprintlnOnTrace("begin diff LABELLED (" + primalLabel + ") " + labelledPiece);
            TapEnv.incrTraceIndent(2);
        }
        boolean modeIsAdjoint = diffEnv.adDiffMode == -1 || diffEnv.adDiffMode == -2;
        String fwdDiffLabel = (modeIsAdjoint ? "FWD" : "TGT") + "-OF " + primalLabel;
        FlowGraphDifferentiation labelledBodyDifferentiation = this.differentiateFlowGraphLevel(labelledPiece, diffEnv);
        SymbolTable fwdDiffSymbolTable = regionEntryBlock.symbolTable.smartCopy(((FlowGraphDifferentiationEnv)diffEnv).diffCtxtFwd.listST, ((FlowGraphDifferentiationEnv)diffEnv).diffCtxtFwd.unit, this.adEnv.diffCallGraph(), this.adEnv.copiedUnits, "FwdDiff of ");
        regionEntryBlock.symbolTable.cleanCopySymbolDecls();
        SymbolTable diffSymbolTable = regionEntryBlock.symbolTable.smartCopy(((FlowGraphDifferentiationEnv)diffEnv).diffCtxt.listST, ((FlowGraphDifferentiationEnv)diffEnv).diffCtxt.unit, this.adEnv.diffCallGraph(), this.adEnv.copiedUnits, "Diff of ");
        regionEntryBlock.symbolTable.cleanCopySymbolDecls();
        Block fwdPostExit = this.buildFwdBlock(regionEntryBlock.rank + "+postXR", fwdDiffSymbolTable, regionEntryBlock, diffEnv);
        fwdPostExit.addInstrHd(ILUtils.build(138));
        fwdPostExit.headInstr().addPreComments("$AD END-LABEL " + fwdDiffLabel);
        FlowGraphDifferentiation result = new FlowGraphDifferentiation(labelledPiece);
        TapList<TapPair<FGArrow, TapList<TapPair<FGArrow, TapList<BwdSwitchCase>>>>> bodyExitArrowsFwdBwds = labelledBodyDifferentiation.exitArrowsFwdBwds;
        if (labelledBodyDifferentiation.hasBwd()) {
            Block bwdPreEntry = this.buildBwdBlock(regionEntryBlock.rank + "-preER", diffSymbolTable, regionEntryBlock, diffEnv);
            bwdPreEntry.addInstrHd(ILUtils.build(138));
            bwdPreEntry.headInstr().addPreComments("$AD LABEL BWD-OF " + primalLabel);
            Block bwdPostExit = this.buildBwdBlock(regionEntryBlock.rank + "-postXR", diffSymbolTable, regionEntryBlock, diffEnv);
            bwdPostExit.addInstrHd(ILUtils.build(138));
            bwdPostExit.headInstr().addPreComments("$AD END-LABEL BWD-OF " + primalLabel);
            PushPopNode pushPopTree = this.buildFwdBwdTreeFromExitFwdBwd(bodyExitArrowsFwdBwds);
            this.connectFwdBwd(pushPopTree, fwdPostExit, new TapList<FGArrow>(this.checkFreeThenSetNewFGArrow(bwdPreEntry, 0, 0, null, false), null), null, null, diffEnv, labelledPiece);
            result.fwdBlockUS = labelledBodyDifferentiation.fwdBlockUS;
            if (((FlowGraphDifferentiation)result).fwdBlockUS.instructions == null) {
                result.fwdBlockUS.addInstrHd(ILUtils.build(138));
            }
            result.fwdBlockUS.headInstr().addPreComments("$AD LABEL " + fwdDiffLabel);
            this.connectBwd(labelledBodyDifferentiation.bwdArrowsUS, bwdPostExit, false, regionEntryBlock, regionEntryBlock, diffEnv);
            result.bwdArrowsUS = new TapList<FGArrow>(this.checkFreeThenSetNewFGArrow(bwdPostExit, 0, 0, null, false), null);
            uniqueArrow = this.checkFreeThenSetNewFGArrow(fwdPostExit, 0, 0, null, false);
            exitArrowsFwdBwds = result.exitArrowsFwdBwds;
            while (exitArrowsFwdBwds != null) {
                arrowFwdBwds = (TapPair)exitArrowsFwdBwds.head;
                exitArrow = (FGArrow)arrowFwdBwds.first;
                arrowFwdBwds.second = new TapList<TapPair<FGArrow, TapList<BwdSwitchCase>>>(new TapPair<FGArrow, TapList<BwdSwitchCase>>(uniqueArrow, new TapList<BwdSwitchCase>(new BwdSwitchCase(uniqueArrow, bwdPreEntry, new TapList<Block>(exitArrow.origin, null), exitArrow.destination), null)), null);
                exitArrowsFwdBwds = exitArrowsFwdBwds.tail;
            }
        } else if (labelledBodyDifferentiation.hasFwd()) {
            while (bodyExitArrowsFwdBwds != null) {
                arrowFwdBwds = (TapPair)bodyExitArrowsFwdBwds.head;
                TapList manyFwdBwds = (TapList)arrowFwdBwds.second;
                while (manyFwdBwds != null) {
                    this.checkFreeThenRedirectDestination((FGArrow)((TapPair)manyFwdBwds.head).first, fwdPostExit, false);
                    manyFwdBwds = manyFwdBwds.tail;
                }
                bodyExitArrowsFwdBwds = bodyExitArrowsFwdBwds.tail;
            }
            result.fwdBlockUS = labelledBodyDifferentiation.fwdBlockUS;
            if (((FlowGraphDifferentiation)result).fwdBlockUS.instructions == null) {
                result.fwdBlockUS.addInstrHd(ILUtils.build(138));
            }
            result.fwdBlockUS.headInstr().addPreComments("$AD LABEL " + fwdDiffLabel);
            uniqueArrow = this.checkFreeThenSetNewFGArrow(fwdPostExit, 0, 0, null, false);
            exitArrowsFwdBwds = result.exitArrowsFwdBwds;
            while (exitArrowsFwdBwds != null) {
                arrowFwdBwds = (TapPair)exitArrowsFwdBwds.head;
                exitArrow = (FGArrow)arrowFwdBwds.first;
                arrowFwdBwds.second = new TapList<TapPair<FGArrow, Object>>(new TapPair<FGArrow, Object>(uniqueArrow, null), null);
                exitArrowsFwdBwds = exitArrowsFwdBwds.tail;
            }
        } else {
            result.fwdBlockUS = null;
            result.bwdArrowsUS = null;
        }
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.decrTraceIndent(2);
            TapEnv.indentprintlnOnTrace(">>end diff LABELLED (" + primalLabel + ") " + labelledPiece);
            TapEnv.indentprintlnOnTrace("  -upstream: " + result.fwdBlockUS + " ; " + result.bwdArrowsUS);
            exitArrowsFwdBwds = result.exitArrowsFwdBwds;
            TapEnv.indentprintOnTrace("  -dnstream: (");
            while (exitArrowsFwdBwds != null) {
                TapEnv.printlnOnTrace("-" + exitArrowsFwdBwds.head);
                exitArrowsFwdBwds = exitArrowsFwdBwds.tail;
                TapEnv.indentprintOnTrace("             " + (exitArrowsFwdBwds == null ? "" : Character.valueOf(' ')));
            }
            TapEnv.printlnOnTrace(")");
        }
        return result;
    }

    private FlowGraphDifferentiation differentiateBinomialLoop(FlowGraphLevel diffSubLevel, FlowGraphDifferentiationEnv diffEnv) {
        FGArrow fwdArrow;
        TapPair resultArrowFwdBwds;
        FGArrow copyExit;
        FGArrow exitArrow;
        Block joiningBlock;
        TapPair arrowFwdBwds;
        boolean loopIsTimes;
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.indentprintlnOnTrace("begin diff BINOMIAL_LOOP " + diffSubLevel);
            TapEnv.incrTraceIndent(2);
        }
        FlowGraphDifferentiation result = new FlowGraphDifferentiation(diffSubLevel);
        HeaderBlock block = (HeaderBlock)diffSubLevel.entryBlock;
        this.adEnv.setCurVectorMap(DataFlowAnalyzer.makeMap3(this.adEnv.curUnit(), block, 0));
        this.adEnv.setCurPtrVectorMap(DataFlowAnalyzer.makeMap3(this.adEnv.curUnit(), block, 3));
        boolean modeIsJoint = true;
        Tree loopTree = null;
        Tree oldLoopControlTree = null;
        boolean loopIsDo = block.isADoLoop();
        Tree initIndexTree = null;
        if (loopIsDo) {
            loopTree = ((Instruction)block.instructions.head).tree;
            oldLoopControlTree = loopTree.down(3);
            initIndexTree = ILUtils.build(14, ILUtils.copy(oldLoopControlTree.down(1)), ILUtils.copy(oldLoopControlTree.down(2)));
            Tree stride = oldLoopControlTree.down(4);
            if (stride == null || stride.opCode() == 138) {
                stride = ILUtils.build(103, 1);
            }
            Tree incrementTree = ILUtils.build(14, ILUtils.copy(oldLoopControlTree.down(1)), ILUtils.build(3, ILUtils.copy(oldLoopControlTree.down(1)), ILUtils.copy(stride)));
            initIndexTree.down(1).setAnnotation("TBR", null);
            incrementTree.down(1).setAnnotation("TBR", null);
            incrementTree.down(2).down(1).setAnnotation("TBR", null);
            ActivityPattern.setAnnotationForActivityPattern(incrementTree.down(1), this.adEnv.curActivity(), "TBR", new boolean[]{true, false});
            DiffLivenessAnalyzer.setTreeRequiredInDiff(this.adEnv.curActivity(), incrementTree, true, false);
            Object diffLivenessAnnot = oldLoopControlTree.getAnnotation("RequiredInDiff");
            Tree newLoopControlTree = ILUtils.build(206, this.buildTestFromDo(oldLoopControlTree));
            newLoopControlTree.setAnnotation("RequiredInDiff", diffLivenessAnnot);
            loopTree.setChild(newLoopControlTree, 3);
            FlowGraphLevel headerLevel = diffSubLevel.entryPoint;
            TapList<FGArrow> cycleArrows = TapList.append(block.backFlow(), null);
            while (cycleArrows != null) {
                FGArrow oldCycleArrow = (FGArrow)cycleArrows.head;
                if (oldCycleArrow.inACycle) {
                    int jj;
                    Block origBlock = oldCycleArrow.origin;
                    TemporaryBlock incrementBlock = new TemporaryBlock(origBlock);
                    if (this.adEnv.unitActivities != null) {
                        TapList<BoolVector> la = this.adEnv.unitActivities.retrieve(origBlock);
                        for (jj = TapList.length(la) - 2; jj > 0; --jj) {
                            la = la.tail;
                        }
                        incrementBlock.blockActivities = la;
                    }
                    if (this.adEnv.unitUsefulnesses != null) {
                        TapList<BoolVector> lu = this.adEnv.unitUsefulnesses.retrieve(origBlock);
                        for (jj = TapList.length(lu) - 2; jj > 0; --jj) {
                            lu = lu.tail;
                        }
                        incrementBlock.blockUsefulnesses = lu;
                    }
                    if (this.adEnv.unitTBRs != null) {
                        TapList<TapPair<BoolVector, BoolVector>> lt = this.adEnv.unitTBRs.retrieve(origBlock);
                        for (jj = TapList.length(lt) - 2; jj > 0; --jj) {
                            lt = lt.tail;
                        }
                        incrementBlock.blockTBRs = lt;
                    } else {
                        incrementBlock.blockTBRs = null;
                    }
                    incrementBlock.blockReqXs = new TapList<Object>(null, new TapList<Object>(null, null));
                    incrementBlock.blockAvlXs = new TapList<Object>(null, new TapList<Object>(null, null));
                    incrementBlock.blockRecomputations = new TapList<Object>(null, new TapList<Object>(null, null));
                    Instruction incrementInstruction = new Instruction(ILUtils.copy(incrementTree));
                    incrementBlock.instructions = new TapList<Instruction>(incrementInstruction, null);
                    incrementInstruction.block = incrementBlock;
                    FGArrow newCycleArrow = this.insertBlockAtDest(oldCycleArrow, incrementBlock, 0, 0);
                    newCycleArrow.iter = oldCycleArrow.iter;
                    FlowGraphLevel incrementLevel = new FlowGraphLevel(0);
                    incrementLevel.entryBlock = incrementBlock;
                    incrementLevel.entryArrows = new TapList<FGArrow>(oldCycleArrow, null);
                    incrementLevel.exitArrows = new TapList<FGArrow>(newCycleArrow, null);
                    incrementLevel.enclosing = diffSubLevel;
                    incrementLevel.trueEnclosing = diffSubLevel;
                    diffSubLevel.contents = new TapList<FlowGraphLevel>(incrementLevel, diffSubLevel.contents);
                    this.additionalBlockToPlainLevel = new TapList<TapPair<Block, FlowGraphLevel>>(new TapPair<TemporaryBlock, FlowGraphLevel>(incrementBlock, incrementLevel), this.additionalBlockToPlainLevel);
                    TapList.replace(headerLevel.entryArrows, oldCycleArrow, newCycleArrow);
                }
                cycleArrows = cycleArrows.tail;
            }
        }
        if (loopIsTimes = block.isATimesLoop()) {
            loopTree = ((Instruction)block.instructions.head).tree;
            ((Instruction)block.instructions.head).tree = ILUtils.build(138);
        }
        if (loopIsDo || loopIsTimes) {
            this.precomputeDifferentiatedBlocks(diffSubLevel.entryPoint, diffEnv);
        }
        diffSubLevel.levelKind = 6;
        FlowGraphDifferentiation firstTurnDiffResult = this.differentiateNaturalLoop(diffSubLevel, diffEnv);
        diffSubLevel.levelKind = 7;
        SymbolTable diffSymbolTable = block.symbolTable.smartCopy(((FlowGraphDifferentiationEnv)diffEnv).diffCtxt.listST, ((FlowGraphDifferentiationEnv)diffEnv).diffCtxt.unit, this.adEnv.diffCallGraph(), this.adEnv.copiedUnits, "Diff of ");
        block.symbolTable.cleanCopySymbolDecls();
        NewSymbolHolder actionVariable = new NewSymbolHolder("action", this.curDiffUnit(), this.adEnv.integerTypeSpec, -1);
        actionVariable.declarationLevelMustInclude(diffSymbolTable);
        actionVariable.preparePrivateClause(block, this.adEnv.curUnit().privateSymbolTable(), false, false);
        NewSymbolHolder stepVariable = new NewSymbolHolder("step", this.curDiffUnit(), this.adEnv.integerTypeSpec, -1);
        stepVariable.declarationLevelMustInclude(diffSymbolTable);
        stepVariable.preparePrivateClause(block, this.adEnv.curUnit().privateSymbolTable(), false, false);
        Instruction srcDoInstruction = block.headInstr();
        Directive binomialDirective = srcDoInstruction.hasDirective(15);
        Tree[] binomialArgs = binomialDirective.arguments;
        Block trvInitBlock = this.buildBwdBlock(block.rank + "_TrvInit", diffSymbolTable, block, diffEnv);
        trvInitBlock.addInstrHdAfterDecls(ILUtils.buildCall(ILUtils.build(96, "adBinomial_init"), ILUtils.build(71, ILUtils.copy(binomialArgs[0]), ILUtils.copy(binomialArgs[1]), ILUtils.copy(binomialArgs[2]))));
        if (initIndexTree != null) {
            trvInitBlock.addInstrHdAfterDecls(initIndexTree);
        }
        HeaderBlock trvWhileBlock = this.buildBwdHeaderBlock(block.rank + "TrvLoop", diffSymbolTable, block, diffEnv);
        trvWhileBlock.addInstrHdAfterDecls(ILUtils.build(121, null, null, ILUtils.build(206, ILUtils.buildCall(ILUtils.build(96, "adBinomial_next"), ILUtils.build(71, actionVariable.makeNewRef(diffSymbolTable), stepVariable.makeNewRef(diffSymbolTable)))), null));
        Unit diffFile = this.curDiffUnit().translationUnit();
        if (diffFile != null && !TapList.containsString(diffFile.newDiffCIncludes, "adBinomial.h", true)) {
            diffFile.newDiffCIncludes = new TapList<String>("adBinomial.h", diffFile.newDiffCIncludes);
        }
        WrapperTypeSpec booleanTypeSpec = diffSymbolTable.getTypeDecl((String)"boolean").typeSpec;
        this.forceDeclareDiffUtilityFunction("adBinomial_next", booleanTypeSpec);
        Block trvExitBlock = this.buildBwdBlock(block.rank + "_TrvExit", diffSymbolTable, block, diffEnv);
        Block trvSwitchBlock = this.buildBwdBlock(block.rank + "_TrvSwitch", diffSymbolTable, block, diffEnv);
        Tree[] switchCases = new Tree[6];
        switchCases[0] = ILUtils.build(185, ILUtils.build(71, ILUtils.build(103, 1)), ILUtils.build(138));
        switchCases[0].down(1).setAnnotation("postComments", ILUtils.build(37, ILUtils.build(180, "    Push Snapshot:")));
        switchCases[1] = ILUtils.build(185, ILUtils.build(71, ILUtils.build(103, 2)), ILUtils.build(138));
        switchCases[1].down(1).setAnnotation("postComments", ILUtils.build(37, ILUtils.build(180, "    Look Snapshot:")));
        switchCases[2] = ILUtils.build(185, ILUtils.build(71, ILUtils.build(103, 3)), ILUtils.build(138));
        switchCases[2].down(1).setAnnotation("postComments", ILUtils.build(37, ILUtils.build(180, "    Pop Snapshot:")));
        switchCases[3] = ILUtils.build(185, ILUtils.build(71, ILUtils.build(103, 4)), ILUtils.build(138));
        switchCases[3].down(1).setAnnotation("postComments", ILUtils.build(37, ILUtils.build(180, "    Advance:")));
        switchCases[4] = ILUtils.build(185, ILUtils.build(71, ILUtils.build(103, 5)), ILUtils.build(138));
        switchCases[4].down(1).setAnnotation("postComments", ILUtils.build(37, ILUtils.build(180, "    First Turn:")));
        switchCases[5] = ILUtils.build(185, ILUtils.build(71, ILUtils.build(103, 6)), ILUtils.build(138));
        switchCases[5].down(1).setAnnotation("postComments", ILUtils.build(37, ILUtils.build(180, "    Turn:")));
        trvSwitchBlock.addInstrHdAfterDecls(ILUtils.build(184, actionVariable.makeNewRef(diffSymbolTable), ILUtils.build(186, switchCases)));
        FlowGraphLevel binomialLoopNoCycle = diffSubLevel.createNoCycle();
        binomialLoopNoCycle.headerBlockPlain = block;
        FlowGraphCopy loopBodyCopy = this.copyFlowGraphLevel(binomialLoopNoCycle, new FlowGraphCopyEnv(diffEnv.diffCtxtFwd));
        this.checkFreeThenSetNewFGArrow(trvSwitchBlock, 21, 3, loopBodyCopy.copyBlockUS, false);
        TapList<FGArrow> cyclingArrows = block.cyclingArrows();
        while (cyclingArrows != null) {
            FGArrow cyclingArrow = (FGArrow)cyclingArrows.head;
            FGArrow copyCycling = loopBodyCopy.getCopyOfExitArrow(cyclingArrow);
            this.checkFreeThenRedirectDestination(copyCycling, trvWhileBlock, true);
            cyclingArrows = cyclingArrows.tail;
        }
        TapList exitArrowsFwdBwds = firstTurnDiffResult.exitArrowsFwdBwds;
        TapList resultExitArrowsFwdBwds = result.exitArrowsFwdBwds;
        TapList<Block> joiningBlocks = null;
        Block reentryBlockBwd = this.buildBwdBlock(block.rank + "_TrvReentryTest", diffSymbolTable, block, diffEnv);
        if (firstTurnDiffResult.hasFwd()) {
            TapPair oneFwdBwd;
            TapList manyFwdBwds;
            this.checkFreeThenSetNewFGArrow(trvSwitchBlock, 21, 4, firstTurnDiffResult.fwdBlockUS, false);
            if (firstTurnDiffResult.hasBwd()) {
                this.mapCheckFreeThenRedirectDestination(firstTurnDiffResult.bwdArrowsUS, trvWhileBlock, true);
            }
            Block popCtBlock = null;
            if (exitArrowsFwdBwds != null) {
                arrowFwdBwds = (TapPair)exitArrowsFwdBwds.head;
                manyFwdBwds = (TapList)arrowFwdBwds.second;
                while (popCtBlock == null && manyFwdBwds != null) {
                    oneFwdBwd = (TapPair)manyFwdBwds.head;
                    popCtBlock = ((BwdSwitchCase)((TapList)oneFwdBwd.second).head).bwdBlock;
                    manyFwdBwds = manyFwdBwds.tail;
                }
                this.checkFreeThenSetNewFGArrow(reentryBlockBwd, 20, 5, popCtBlock, false);
                this.checkFreeThenSetNewFGArrow(reentryBlockBwd, 20, 2, (Block)trvWhileBlock, true);
            }
            while (exitArrowsFwdBwds != null) {
                arrowFwdBwds = (TapPair)exitArrowsFwdBwds.head;
                joiningBlock = this.buildBwdBlock(block.rank + "_TrvJoin", diffSymbolTable, block, diffEnv);
                joiningBlocks = new TapList<Block>(joiningBlock, joiningBlocks);
                exitArrow = (FGArrow)arrowFwdBwds.first;
                manyFwdBwds = (TapList)arrowFwdBwds.second;
                while (manyFwdBwds != null) {
                    oneFwdBwd = (TapPair)manyFwdBwds.head;
                    FGArrow pushCtArrow = (FGArrow)oneFwdBwd.first;
                    this.checkFreeThenRedirectDestination(pushCtArrow, joiningBlock, false);
                    manyFwdBwds = manyFwdBwds.tail;
                }
                copyExit = loopBodyCopy.getCopyOfExitArrow(exitArrow);
                Block trvResizeBlock = this.buildBwdBlock(block.rank + "_TrvResize", diffSymbolTable, block, diffEnv);
                trvResizeBlock.addInstrHdAfterDecls(ILUtils.buildCall(ILUtils.build(96, "adBinomial_resize"), ILUtils.build(71)));
                this.checkFreeThenRedirectDestination(copyExit, trvResizeBlock, false);
                this.checkFreeThenSetNewFGArrow(trvResizeBlock, 0, 0, joiningBlock, false);
                resultArrowFwdBwds = (TapPair)resultExitArrowsFwdBwds.head;
                fwdArrow = this.checkFreeThenSetNewFGArrow(joiningBlock, 0, 0, null, false);
                resultArrowFwdBwds.second = new TapList<TapPair<FGArrow, TapList<BwdSwitchCase>>>(new TapPair<FGArrow, TapList<BwdSwitchCase>>(fwdArrow, new TapList<BwdSwitchCase>(new BwdSwitchCase(fwdArrow, reentryBlockBwd, new TapList<Block>(exitArrow.origin, null), exitArrow.destination), null)), null);
                exitArrowsFwdBwds = exitArrowsFwdBwds.tail;
                resultExitArrowsFwdBwds = resultExitArrowsFwdBwds.tail;
            }
        } else {
            joiningBlock = this.buildBwdBlock(block.rank + "_TrvJoin", diffSymbolTable, block, diffEnv);
            joiningBlocks = new TapList<Block>(joiningBlock, null);
            this.checkFreeThenSetNewFGArrow(trvSwitchBlock, 21, 4, joiningBlock, false);
            Block trvResizeBlock = this.buildBwdBlock(block.rank + "_TrvResize", diffSymbolTable, block, diffEnv);
            trvResizeBlock.addInstrHdAfterDecls(ILUtils.buildCall(ILUtils.build(96, "adBinomial_resize"), ILUtils.build(71)));
            if (exitArrowsFwdBwds != null) {
                this.checkFreeThenSetNewFGArrow(trvResizeBlock, 0, 0, joiningBlock, false);
            }
            fwdArrow = this.checkFreeThenSetNewFGArrow(joiningBlock, 0, 0, null, false);
            this.checkFreeThenSetNewFGArrow(reentryBlockBwd, 0, 0, (Block)trvWhileBlock, true);
            while (exitArrowsFwdBwds != null) {
                arrowFwdBwds = (TapPair)exitArrowsFwdBwds.head;
                exitArrow = (FGArrow)arrowFwdBwds.first;
                copyExit = loopBodyCopy.getCopyOfExitArrow(exitArrow);
                this.checkFreeThenRedirectDestination(copyExit, trvResizeBlock, false);
                resultArrowFwdBwds = (TapPair)resultExitArrowsFwdBwds.head;
                resultArrowFwdBwds.second = new TapList<TapPair<FGArrow, TapList<BwdSwitchCase>>>(new TapPair<FGArrow, TapList<BwdSwitchCase>>(fwdArrow, new TapList<BwdSwitchCase>(new BwdSwitchCase(fwdArrow, reentryBlockBwd, new TapList<Block>(exitArrow.origin, null), exitArrow.destination), null)), null);
                exitArrowsFwdBwds = exitArrowsFwdBwds.tail;
                resultExitArrowsFwdBwds = resultExitArrowsFwdBwds.tail;
            }
        }
        diffSubLevel.restoreChildrenParent();
        if (loopIsDo) {
            FlowGraphLevel headerLevel = diffSubLevel.entryPoint;
            TapList<FGArrow> cycleArrows = TapList.append(block.backFlow(), null);
            while (cycleArrows != null) {
                FGArrow newCycleArrow = (FGArrow)cycleArrows.head;
                if (newCycleArrow.inACycle) {
                    Block incrementBlock = newCycleArrow.origin;
                    FGArrow oldCycleArrow = (FGArrow)incrementBlock.backFlow().head;
                    incrementBlock.removeAndShunt();
                    TapPair association = TapList.assq(incrementBlock, this.additionalBlockToPlainLevel);
                    FlowGraphLevel incrementLevel = (FlowGraphLevel)association.second;
                    this.additionalBlockToPlainLevel = TapList.delete(association, this.additionalBlockToPlainLevel);
                    diffSubLevel.contents = TapList.delete(incrementLevel, diffSubLevel.contents);
                    TapList.replace(headerLevel.entryArrows, newCycleArrow, oldCycleArrow);
                }
                cycleArrows = cycleArrows.tail;
            }
            loopTree.setChild(ILUtils.copy(oldLoopControlTree), 3);
        }
        if (loopIsTimes) {
            ((Instruction)block.instructions.head).tree = loopTree;
        }
        binomialLoopNoCycle = diffSubLevel.createNoCycle();
        binomialLoopNoCycle.headerBlockPlain = block;
        TapPair<BoolVector[], BoolVector[]> dataFlowSetsWithDiffPtr7 = this.recomputeDataFlowCheckpointed(binomialLoopNoCycle, block, modeIsJoint);
        TapTriplet<BoolVector, BoolVector, BoolVector> checkpointingSets = this.computeBinomialSets(block, (BoolVector[])dataFlowSetsWithDiffPtr7.first, 0, this.curVectorMap());
        TapTriplet<BoolVector, BoolVector, BoolVector> checkpointingSetsOnDiffPtr = this.computeBinomialSets(block, (BoolVector[])dataFlowSetsWithDiffPtr7.second, 3, this.curPtrVectorMap());
        FlowGraphDifferentiationEnv jointReversalEnv = diffEnv.deriveForNewJointDiff();
        jointReversalEnv.turningArrows = binomialLoopNoCycle.exitArrows;
        jointReversalEnv.middleSymbolTables = this.collectMiddleSymbolTables(jointReversalEnv.turningArrows, binomialLoopNoCycle.allBlocksInside());
        this.precomputeDifferentiatedBlocksIn(binomialLoopNoCycle, jointReversalEnv);
        FlowGraphDifferentiation loopBodySlicedReversal = this.differentiateFlowGraphLevel(binomialLoopNoCycle, jointReversalEnv);
        if (loopBodySlicedReversal.hasBwd()) {
            this.checkFreeThenSetNewFGArrow(trvSwitchBlock, 21, 5, loopBodySlicedReversal.fwdBlockUS, false);
            this.mapConnectFwdBwd(loopBodySlicedReversal.exitArrowsFwdBwds, diffEnv, diffSubLevel);
            this.mapCheckFreeThenRedirectDestination(loopBodySlicedReversal.bwdArrowsUS, trvWhileBlock, true);
        } else {
            this.checkFreeThenSetNewFGArrow(trvSwitchBlock, 21, 5, (Block)trvWhileBlock, true);
        }
        Block pushBlock = this.buildBwdBlock(block.rank + "_TrvPush", diffSymbolTable, block, diffEnv);
        this.checkFreeThenSetNewFGArrow(trvSwitchBlock, 21, 0, pushBlock, false);
        this.checkFreeThenSetNewFGArrow(pushBlock, 0, 0, (Block)trvWhileBlock, true);
        Block lookBlock = this.buildBwdBlock(block.rank + "_TrvLook", diffSymbolTable, block, diffEnv);
        this.checkFreeThenSetNewFGArrow(trvSwitchBlock, 21, 1, lookBlock, false);
        this.checkFreeThenSetNewFGArrow(lookBlock, 0, 0, (Block)trvWhileBlock, true);
        Block popBlock = this.buildBwdBlock(block.rank + "_TrvPop", diffSymbolTable, block, diffEnv);
        this.checkFreeThenSetNewFGArrow(trvSwitchBlock, 21, 2, popBlock, false);
        this.checkFreeThenSetNewFGArrow(popBlock, 0, 0, (Block)trvWhileBlock, true);
        BoolVector snp = (BoolVector)checkpointingSets.second;
        if (loopIsDo) {
            TapIntList indexZones = block.symbolTable.listOfZonesOfValue(oldLoopControlTree.down(1), null, block.headInstr());
            snp.setDeclared(indexZones, this.curVectorMap(), true);
        }
        this.fillBinomialCheckpoint(snp, this.curVectorMap(), (BoolVector)checkpointingSetsOnDiffPtr.second, this.curPtrVectorMap(), block, pushBlock, lookBlock, popBlock, diffEnv.adDiffMode == -1);
        this.fillSnapshotInstructions((BoolVector)checkpointingSets.first, null, this.curVectorMap(), (BoolVector)checkpointingSetsOnDiffPtr.first, null, this.curPtrVectorMap(), block, new TapList<Block>(trvInitBlock, null), null, new TapList<Block>(trvExitBlock, null), diffEnv.adDiffMode == -1);
        if (firstTurnDiffResult.hasFwd()) {
            this.fillSnapshotInstructions((BoolVector)checkpointingSets.third, null, this.curVectorMap(), (BoolVector)checkpointingSetsOnDiffPtr.third, null, this.curPtrVectorMap(), block, joiningBlocks, null, new TapList<Block>(reentryBlockBwd, null), diffEnv.adDiffMode == -1);
            reentryBlockBwd.addInstrTl(ILUtils.build(98, ILUtils.build(68, actionVariable.makeNewRef(diffSymbolTable), ILUtils.build(103, 4)), null, null));
        }
        this.checkFreeThenSetNewFGArrow(trvInitBlock, 0, 0, (Block)trvWhileBlock, false);
        this.checkFreeThenSetNewFGArrow((Block)trvWhileBlock, 30, 1, trvSwitchBlock, false);
        this.checkFreeThenSetNewFGArrow((Block)trvWhileBlock, 30, 0, trvExitBlock, false);
        result.fwdBlockUS = trvInitBlock;
        result.bwdArrowsUS = new TapList<FGArrow>(this.checkFreeThenSetNewFGArrow(trvExitBlock, 30, 0, null, false), null);
        diffSubLevel.restoreChildrenParent();
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.decrTraceIndent(2);
            TapEnv.indentprintlnOnTrace(">>end diff BINOMIAL_LOOP " + diffSubLevel);
            TapEnv.indentprintlnOnTrace("  -upstream: " + result.fwdBlockUS + " ; " + result.bwdArrowsUS);
            exitArrowsFwdBwds = result.exitArrowsFwdBwds;
            TapEnv.indentprintOnTrace("  -dnstream: (");
            while (exitArrowsFwdBwds != null) {
                TapEnv.printlnOnTrace("-" + exitArrowsFwdBwds.head);
                exitArrowsFwdBwds = exitArrowsFwdBwds.tail;
                TapEnv.indentprintOnTrace("             " + (exitArrowsFwdBwds == null ? "" : Character.valueOf(' ')));
            }
            TapEnv.printlnOnTrace(")");
        }
        return result;
    }

    private FlowGraphDifferentiation differentiateIILoop(FlowGraphLevel diffSubLevel, FlowGraphDifferentiationEnv diffEnv) {
        boolean hasFwd;
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.indentprintlnOnTrace("begin diff II_LOOP " + diffSubLevel);
            TapEnv.incrTraceIndent(2);
        }
        HeaderBlock block = (HeaderBlock)diffSubLevel.entryBlock;
        Instruction primalDoInstruction = block.headInstr();
        this.adEnv.setCurVectorMap(DataFlowAnalyzer.makeMap3(this.adEnv.curUnit(), block, 0));
        this.adEnv.setCurPtrVectorMap(DataFlowAnalyzer.makeMap3(this.adEnv.curUnit(), block, 3));
        String noDiffLabel = primalDoInstruction.hasDirective((int)13).label;
        boolean modeIsJoint = diffEnv.adDiffMode == -1;
        FlowGraphLevel loopBodyPiece = diffSubLevel.createLoopBody();
        TapPair<BoolVector[], BoolVector[]> dataFlowSetsWithDiffPtr7 = this.recomputeDataFlowCheckpointed(loopBodyPiece, block, modeIsJoint);
        ToBool needCopy = new ToBool(false);
        TapPair<BoolVector, BoolVector> checkpointingSets = this.computeCheckpointingSets(loopBodyPiece, (BoolVector[])dataFlowSetsWithDiffPtr7.first, needCopy, 0, this.curVectorMap());
        TapPair<BoolVector, BoolVector> checkpointingSetsOnDiffPtr = this.computeCheckpointingSets(loopBodyPiece, (BoolVector[])dataFlowSetsWithDiffPtr7.second, needCopy, 3, this.curPtrVectorMap());
        FlowGraphCopy loopBodyCopy = needCopy.get() ? this.copyFlowGraphLevel(loopBodyPiece, new FlowGraphCopyEnv(diffEnv.diffCtxtFwd)) : null;
        FlowGraphDifferentiationEnv jointReversalEnv = diffEnv.deriveForNewJointDiff();
        jointReversalEnv.turningArrows = loopBodyPiece.exitArrows;
        jointReversalEnv.middleSymbolTables = this.collectMiddleSymbolTables(jointReversalEnv.turningArrows, loopBodyPiece.allBlocksInside());
        this.precomputeDifferentiatedBlocksIn(loopBodyPiece, jointReversalEnv);
        FlowGraphDifferentiation loopBodyReversal = this.differentiateFlowGraphLevel(loopBodyPiece, jointReversalEnv);
        HeaderBlock fwdBlock = (HeaderBlock)diffEnv.fwdDiffBlocks.retrieve(block);
        HeaderBlock bwdBlock = (HeaderBlock)diffEnv.bwdDiffBlocks.retrieve(block);
        SymbolTable fwdDiffSymbolTable = fwdBlock.symbolTable;
        SymbolTable diffSymbolTable = bwdBlock == null ? null : bwdBlock.symbolTable;
        Block fwdPreEntry = this.buildFwdBlock(block.rank + "+IIPreE", fwdDiffSymbolTable, block, diffEnv);
        if (fwdDiffSymbolTable.declarationsBlock == fwdBlock) {
            fwdDiffSymbolTable.declarationsBlock = fwdPreEntry;
        }
        Block fwdPostExit = this.buildFwdBlock(block.rank + "+IIPostX", fwdDiffSymbolTable, block, diffEnv);
        Block bwdPreEntry = this.buildBwdBlock(block.rank + "-IIPreE", diffSymbolTable, block, diffEnv);
        if (diffSymbolTable != null && diffSymbolTable.declarationsBlock == bwdBlock) {
            diffSymbolTable.declarationsBlock = bwdPreEntry;
        }
        Block bwdPostExit = this.buildBwdBlock(block.rank + "-IIPostX", diffSymbolTable, block, diffEnv);
        Instruction fwdDoInstruction = fwdBlock.headInstr();
        Tree bwdLoopControl = null;
        if (loopBodyCopy != null && fwdDoInstruction.tree.down(3).opCode() == 64) {
            Tree fwdLoopControl = fwdDoInstruction.tree.down(3);
            Tree fromTree = fwdLoopControl.down(2);
            bwdLoopControl = ILUtils.copy(fwdLoopControl);
            if (InOutAnalyzer.isCheapDuplicableConstant(fromTree, block, primalDoInstruction) || !loopBodyReversal.hasBwd() || this.adEnv.curUnitIsContext) {
                bwdLoopControl.setChild(ILUtils.copy(fromTree), 2);
            } else {
                FwdBwdVarTool adFromVarTool = new FwdBwdVarTool(this.adFromStr, null, block, fwdDiffSymbolTable, diffSymbolTable);
                fwdPreEntry.addInstrHdAfterDecls(ILUtils.build(14, adFromVarTool.makeFwdRef(block), ILUtils.copy(fromTree)));
                fwdLoopControl.setChild(adFromVarTool.makeFwdRef(block), 2);
                fwdPostExit.addInstrTl(adFromVarTool.makePush(block));
                bwdPreEntry.addInstrHdAfterDecls(adFromVarTool.makePop(block));
                bwdLoopControl.setChild(adFromVarTool.makeRef(block), 2);
            }
            Tree toTree = fwdLoopControl.down(3);
            if (InOutAnalyzer.isCheapDuplicableConstant(toTree, block, primalDoInstruction) || !loopBodyReversal.hasBwd() || this.adEnv.curUnitIsContext) {
                bwdLoopControl.setChild(ILUtils.copy(toTree), 3);
            } else {
                FwdBwdVarTool adToVarTool = new FwdBwdVarTool(this.adToStr, null, block, fwdDiffSymbolTable, diffSymbolTable);
                fwdPreEntry.addInstrHdAfterDecls(ILUtils.build(14, adToVarTool.makeFwdRef(block), ILUtils.copy(toTree)));
                fwdLoopControl.setChild(adToVarTool.makeFwdRef(block), 3);
                fwdPostExit.addInstrTl(adToVarTool.makePush(block));
                bwdPreEntry.addInstrHdAfterDecls(adToVarTool.makePop(block));
                bwdLoopControl.setChild(adToVarTool.makeRef(block), 3);
            }
            Tree strideTree = fwdLoopControl.down(4);
            if (InOutAnalyzer.isCheapDuplicableConstant(strideTree, block, primalDoInstruction) || !loopBodyReversal.hasBwd() || this.adEnv.curUnitIsContext) {
                bwdLoopControl.setChild(ILUtils.copy(strideTree), 4);
            } else {
                FwdBwdVarTool adStrideVarTool = new FwdBwdVarTool(this.adStrideStr, null, block, fwdDiffSymbolTable, diffSymbolTable);
                fwdPreEntry.addInstrHdAfterDecls(ILUtils.build(14, adStrideVarTool.makeFwdRef(block), ILUtils.copy(strideTree)));
                fwdLoopControl.setChild(adStrideVarTool.makeFwdRef(block), 4);
                fwdPostExit.addInstrTl(adStrideVarTool.makePush(block));
                bwdPreEntry.addInstrHdAfterDecls(adStrideVarTool.makePop(block));
                bwdLoopControl.setChild(adStrideVarTool.makeRef(block), 4);
            }
            this.checkFreeThenSetNewFGArrow((Block)fwdBlock, 30, 1, loopBodyCopy.copyBlockUS, false);
            this.checkFreeThenSetNewFGArrow((Block)fwdBlock, 30, 0, fwdPostExit, false);
            fwdDoInstruction.addPreComments("$FWD-OF II-LOOP " + noDiffLabel);
        } else {
            fwdBlock.instructions = null;
            this.checkFreeThenSetNewFGArrow((Block)fwdBlock, 0, 0, fwdPostExit, false);
            if (loopBodyReversal.hasBwd()) {
                bwdLoopControl = ILUtils.copy(fwdDoInstruction.tree.down(3));
            }
        }
        if (loopBodyReversal.hasBwd()) {
            assert (bwdBlock != null);
            this.checkFreeThenSetNewFGArrow(bwdPreEntry, 0, 0, (Block)bwdBlock, false);
            Instruction bwdDoInstruction = bwdBlock.addInstrHdAfterDecls(ILUtils.build(121, null, null, bwdLoopControl, null));
            String ivdepPragma = primalDoInstruction.containsPreComment("dir$ ivdep");
            if (ivdepPragma != null) {
                bwdDoInstruction.addPreComments(ivdepPragma);
            }
            bwdDoInstruction.addPreComments("$BWD-OF II-LOOP " + noDiffLabel);
            this.checkFreeThenSetNewFGArrow((Block)bwdBlock, 30, 1, loopBodyReversal.fwdBlockUS, false);
            this.connectBwd(loopBodyReversal.bwdArrowsUS, bwdBlock, true, block, loopBodyPiece.entryBlock, diffEnv);
            this.checkFreeThenSetNewFGArrow((Block)bwdBlock, 30, 0, bwdPostExit, false);
            this.mapConnectFwdBwd(loopBodyReversal.exitArrowsFwdBwds, diffEnv, diffSubLevel);
        } else {
            this.checkFreeThenSetNewFGArrow(bwdPreEntry, 0, 0, bwdPostExit, false);
        }
        if (loopBodyCopy != null) {
            TapList<FGArrow> cyclingArrows = block.cyclingArrows();
            while (cyclingArrows != null) {
                FGArrow copyCycling = loopBodyCopy.getCopyOfExitArrow((FGArrow)cyclingArrows.head);
                if (copyCycling != null) {
                    this.checkFreeThenRedirectDestination(copyCycling, fwdBlock, true);
                }
                cyclingArrows = cyclingArrows.tail;
            }
        }
        this.checkFreeThenSetNewFGArrow(fwdPreEntry, 0, 0, (Block)fwdBlock, false);
        this.fillSnapshotInstructions((BoolVector)checkpointingSets.first, (BoolVector)checkpointingSets.second, this.curVectorMap(), (BoolVector)checkpointingSetsOnDiffPtr.first, (BoolVector)checkpointingSetsOnDiffPtr.second, this.curPtrVectorMap(), block, new TapList<Block>(fwdPreEntry, null), new TapList<Block>(bwdPreEntry, null), new TapList<Block>(bwdPostExit, null), diffEnv.adDiffMode == -1);
        Tree firstLoopInstr = primalDoInstruction.tree;
        if (firstLoopInstr.opCode() == 121 && firstLoopInstr.down(3).opCode() == 64) {
            Tree doIndexToSave = firstLoopInstr.down(3).down(1);
            if (ADTBRAnalyzer.isTBRindexOnLoopEntry(this.adEnv.curActivity(), doIndexToSave) && !this.adEnv.curUnitIsContext) {
                RefDescriptor indexSaveRefDescriptor = new RefDescriptor(ILUtils.copy(doIndexToSave), null, block.symbolTable, fwdBlock.symbolTable, null, null, false, null, this.curDiffUnit());
                this.adEnv.setCurBlock(block.enclosingLoop());
                this.blockDifferentiator().prepareRestoreOperations(indexSaveRefDescriptor, null, 1, fwdBlock.symbolTable, diffSymbolTable);
                fwdPreEntry.addInstrHdAfterDecls(indexSaveRefDescriptor.makePush());
                bwdPostExit.addInstrTl(indexSaveRefDescriptor.makePop());
            }
        }
        diffSubLevel.restoreChildrenParent();
        FlowGraphDifferentiation result = new FlowGraphDifferentiation(diffSubLevel);
        boolean hasBwd = loopBodyReversal.hasBwd() || bwdPreEntry.instructions != null || bwdPostExit.instructions != null;
        boolean bl = hasFwd = hasBwd || loopBodyCopy != null;
        if (hasFwd) {
            result.fwdBlockUS = fwdPreEntry;
        }
        if (hasBwd) {
            result.bwdArrowsUS = new TapList<FGArrow>(this.checkFreeThenSetNewFGArrow(bwdPostExit, 0, 0, null, false), null);
        }
        if (hasFwd) {
            TapPair exitArrowFwdBwds = (TapPair)((FlowGraphDifferentiation)result).exitArrowsFwdBwds.head;
            FGArrow exitArrow = (FGArrow)exitArrowFwdBwds.first;
            FGArrow fwdArrow = this.checkFreeThenSetNewFGArrow(fwdPostExit, 0, 0, null, false);
            exitArrowFwdBwds.second = new TapList<TapPair<FGArrow, TapList>>(new TapPair<FGArrow, TapList>(fwdArrow, hasBwd ? new TapList<BwdSwitchCase>(new BwdSwitchCase(fwdArrow, bwdPreEntry, new TapList<HeaderBlock>(block, null), exitArrow.destination), null) : null), null);
        }
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.decrTraceIndent(2);
            TapEnv.indentprintlnOnTrace(">>end diff II_LOOP " + diffSubLevel);
            TapEnv.indentprintlnOnTrace("  -upstream: " + result.fwdBlockUS + " ; " + result.bwdArrowsUS);
            TapList exitArrowsFwdBwds = result.exitArrowsFwdBwds;
            TapEnv.indentprintOnTrace("  -dnstream: (");
            while (exitArrowsFwdBwds != null) {
                TapEnv.printlnOnTrace("-" + exitArrowsFwdBwds.head);
                exitArrowsFwdBwds = exitArrowsFwdBwds.tail;
                TapEnv.indentprintOnTrace("             " + (exitArrowsFwdBwds == null ? "" : Character.valueOf(' ')));
            }
            TapEnv.printlnOnTrace(")");
        }
        return result;
    }

    private FlowGraphDifferentiation differentiateNaturalLoop(FlowGraphLevel diffSubLevel, FlowGraphDifferentiationEnv diffEnv) {
        FGArrow fwdArrow;
        TapPair resultExitArrowFwdBwds;
        TapPair arrowFwdBwds;
        HeaderBlock fwdHeaderBlock;
        Tree firstLoopInstr;
        Tree firstLoopInstr2;
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.indentprintlnOnTrace("begin diff NATURAL_LOOP " + diffSubLevel);
            TapEnv.incrTraceIndent(2);
        }
        HeaderBlock block = (HeaderBlock)diffSubLevel.entryBlock;
        SymbolTable primalSymbolTable = block.symbolTable;
        FlowGraphDifferentiation loopNoCycleDifferentiation = this.differentiateFlowGraphLevel(diffSubLevel.createNoCycle(), diffEnv);
        SymbolTable fwdDiffSymbolTable = primalSymbolTable.smartCopy(((FlowGraphDifferentiationEnv)diffEnv).diffCtxtFwd.listST, ((FlowGraphDifferentiationEnv)diffEnv).diffCtxtFwd.unit, this.adEnv.diffCallGraph(), this.adEnv.copiedUnits, "FwdDiff of ");
        primalSymbolTable.cleanCopySymbolDecls();
        SymbolTable diffSymbolTable = primalSymbolTable.smartCopy(((FlowGraphDifferentiationEnv)diffEnv).diffCtxt.listST, ((FlowGraphDifferentiationEnv)diffEnv).diffCtxt.unit, this.adEnv.diffCallGraph(), this.adEnv.copiedUnits, "Diff of ");
        primalSymbolTable.cleanCopySymbolDecls();
        Tree doIndexToSave = null;
        int ppLabelForIndex = -1;
        if (block.instructions != null && (firstLoopInstr2 = block.headInstr().tree).opCode() == 121 && firstLoopInstr2.down(3).opCode() == 64 && ADTBRAnalyzer.isTBRindex(this.adEnv.curActivity(), firstLoopInstr2.down(3).down(1)) && !this.adEnv.curUnitIsContext) {
            doIndexToSave = firstLoopInstr2.down(3).down(1);
            ppLabelForIndex = TapEnv.getNewPushPopNumber();
        }
        Block fwdPreEntry = this.buildFwdBlock(block.rank + "+NatPreE", fwdDiffSymbolTable, block, diffEnv);
        if (doIndexToSave != null) {
            fwdPreEntry.addInstrTl(RefDescriptor.makePush(this.curFwdDiffUnit(), ILUtils.copy(doIndexToSave), primalSymbolTable, fwdDiffSymbolTable, ppLabelForIndex));
        }
        Block bwdPreEntry = this.buildBwdBlock(block.rank + "-NatPreE", diffSymbolTable, block, diffEnv);
        Block bwdInit = null;
        Block bwdTest = null;
        Block bwdIncr = null;
        if (block.instructions != null && (firstLoopInstr = block.headInstr().tree).opCode() == 121 && firstLoopInstr.down(3).opCode() == 79) {
            Tree testTree;
            HeaderBlock fwdHeaderBlock2 = loopNoCycleDifferentiation.hasFwd() ? (HeaderBlock)loopNoCycleDifferentiation.fwdBlockUS : null;
            Tree fwdForHeader = fwdHeaderBlock2 != null && fwdHeaderBlock2.instructions != null ? fwdHeaderBlock2.headInstr().tree.down(3) : null;
            TapList savedBlockInstructions = block.instructions;
            TapList<Tree> forInstrs = ILUtils.getListOfStatements(firstLoopInstr.down(3).down(1));
            block.instructions = null;
            while (forInstrs != null) {
                block.addInstrTl((Tree)forInstrs.head);
                forInstrs = forInstrs.tail;
            }
            Block fwdForPartBlock = this.createFwdDiffBlock(block, diffEnv, false);
            fwdForPartBlock.symbolicRk = block.rank + "+InitFor";
            bwdInit = this.createBwdDiffBlock(block, diffEnv, false);
            if (bwdInit != null) {
                bwdInit.symbolicRk = block.rank + "-InitFor";
            }
            this.blockDifferentiator().differentiateBlock(block, fwdForPartBlock, bwdInit, diffEnv.adDiffMode, null);
            if (fwdForHeader != null) {
                forInstrs = fwdForPartBlock.listOfStatements();
                fwdForHeader.setChild(ILUtils.buildSingleStatement(forInstrs), 1);
            }
            forInstrs = ILUtils.getListOfStatements(firstLoopInstr.down(3).down(2));
            block.instructions = null;
            while (forInstrs != null) {
                testTree = (Tree)forInstrs.head;
                if (forInstrs.tail == null) {
                    testTree = ILUtils.copy(testTree);
                    DiffLivenessAnalyzer.setRequiredInDiff(this.adEnv.curActivity(), testTree);
                    testTree = ILUtils.build(98, testTree);
                }
                block.addInstrTl(testTree);
                forInstrs = forInstrs.tail;
            }
            fwdForPartBlock = this.createFwdDiffBlock(block, diffEnv, false);
            fwdForPartBlock.symbolicRk = block.rank + "+TestFor";
            bwdTest = this.createBwdDiffBlock(block, diffEnv, false);
            if (bwdTest != null) {
                bwdTest.symbolicRk = block.rank + "-TestFor";
            }
            this.blockDifferentiator().differentiateBlock(block, fwdForPartBlock, bwdTest, diffEnv.adDiffMode, null);
            if (fwdForHeader != null) {
                forInstrs = fwdForPartBlock.listOfStatements();
                TapList<Tree> toTail = TapList.toLast(forInstrs);
                if (toTail != null) {
                    testTree = (Tree)toTail.head;
                    if (testTree != null && testTree.opCode() == 98) {
                        testTree = testTree.cutChild(1);
                    }
                    toTail.head = testTree;
                }
                fwdForHeader.setChild(ILUtils.buildSingleStatement(forInstrs), 2);
            }
            forInstrs = ILUtils.getListOfStatements(firstLoopInstr.down(3).down(3));
            block.instructions = null;
            while (forInstrs != null) {
                block.addInstrTl((Tree)forInstrs.head);
                forInstrs = forInstrs.tail;
            }
            fwdForPartBlock = this.createFwdDiffBlock(block, diffEnv, false);
            fwdForPartBlock.symbolicRk = block.rank + "+IncrFor";
            bwdIncr = this.createBwdDiffBlock(block, diffEnv, false);
            if (bwdIncr != null) {
                bwdIncr.symbolicRk = block.rank + "-IncrFor";
            }
            this.blockDifferentiator().differentiateBlock(block, fwdForPartBlock, bwdIncr, diffEnv.adDiffMode, null);
            if (fwdForHeader != null) {
                forInstrs = fwdForPartBlock.listOfStatements();
                fwdForHeader.setChild(ILUtils.buildSingleStatement(forInstrs), 3);
            }
            block.instructions = savedBlockInstructions;
        }
        FlowGraphDifferentiation result = new FlowGraphDifferentiation(diffSubLevel);
        TapList resultExitArrowsFwdBwds = result.exitArrowsFwdBwds;
        TapList loopArrowsFwdBwds = loopNoCycleDifferentiation.exitArrowsFwdBwds;
        if (loopNoCycleDifferentiation.hasFwd() && loopNoCycleDifferentiation.hasBwd()) {
            FGArrow arrowToBwdUS;
            PushPopNode pushPopTree;
            TapList<Object> hdCyclingArrowsFwdBwds;
            TapList<Object> hdExitingArrowsFwdBwds;
            boolean allExitsTurn;
            fwdHeaderBlock = (HeaderBlock)loopNoCycleDifferentiation.fwdBlockUS;
            if (fwdDiffSymbolTable.declarationsBlock == fwdHeaderBlock) {
                fwdDiffSymbolTable.declarationsBlock = fwdPreEntry;
            }
            this.checkFreeThenSetNewFGArrow(fwdPreEntry, 0, 0, (Block)fwdHeaderBlock, false);
            FwdBwdVarTool adCountVarTool = new FwdBwdVarTool(this.adCountStr, null, block, fwdDiffSymbolTable, diffSymbolTable);
            NewSymbolHolder dummyIndex = new NewSymbolHolder("i", this.curDiffUnit(), this.adEnv.integerTypeSpec, -1);
            dummyIndex.declarationLevelMustInclude(diffSymbolTable);
            dummyIndex.preparePrivateClause(block, this.adEnv.curUnit().privateSymbolTable(), false, false);
            fwdPreEntry.addInstrTl(ILUtils.build(14, adCountVarTool.makeFwdRef(block), ILUtils.build(103, 1)));
            Block fwdPostCycle = this.buildFwdBlock(block.rank + "+NatPostCy", fwdDiffSymbolTable, block, diffEnv);
            this.checkFreeThenSetNewFGArrow(fwdPostCycle, 0, 0, (Block)fwdHeaderBlock, true);
            Block bwdPostCycle = this.buildBwdBlock(block.rank + "-NatPostCy", diffSymbolTable, block, diffEnv);
            this.mapCheckFreeThenRedirectDestination(loopNoCycleDifferentiation.bwdArrowsUS, bwdPostCycle, false);
            fwdPostCycle.addInstrHdAfterDecls(ILUtils.build(14, adCountVarTool.makeFwdRef(block), ILUtils.build(3, adCountVarTool.makeFwdRef(block), ILUtils.build(103, 1))));
            if (doIndexToSave != null) {
                fwdPostCycle.addInstrHdAfterDecls(RefDescriptor.makePush(this.curFwdDiffUnit(), ILUtils.copy(doIndexToSave), primalSymbolTable, fwdDiffSymbolTable, ppLabelForIndex));
                bwdPostCycle.addInstrTl(RefDescriptor.makePop(this.curDiffUnit(), ILUtils.copy(doIndexToSave), primalSymbolTable, diffSymbolTable, ppLabelForIndex, this.toBranchVariable));
            }
            boolean bl = allExitsTurn = this.adEnv.curUnitIsContext || this.allExitsTurn(diffSubLevel.exitArrows, diffEnv.turningArrows);
            if (!allExitsTurn) {
                bwdPreEntry.addInstrHdAfterDecls(adCountVarTool.makePop(block));
            }
            HeaderBlock bwdHeaderBlock = this.buildBwdHeaderBlock(block.rank + "-Hd", diffSymbolTable, block, diffEnv);
            bwdHeaderBlock.addInstrHdAfterDecls(ILUtils.build(121, null, null, ILUtils.build(64, dummyIndex.makeNewRef(diffSymbolTable), ILUtils.build(103, 1), adCountVarTool.makeRef(block), null), null));
            TapList<Object> tlExitingArrowsFwdBwds = hdExitingArrowsFwdBwds = new TapList<Object>(null, null);
            TapList<Object> tlCyclingArrowsFwdBwds = hdCyclingArrowsFwdBwds = new TapList<Object>(null, null);
            boolean cycleExitsFromInsideScope = false;
            boolean exitExitsFromInsideScope = false;
            while (loopArrowsFwdBwds != null) {
                arrowFwdBwds = (TapPair)loopArrowsFwdBwds.head;
                FGArrow loopArrow = (FGArrow)arrowFwdBwds.first;
                resultExitArrowFwdBwds = TapList.assq(loopArrow, resultExitArrowsFwdBwds);
                if (resultExitArrowFwdBwds != null) {
                    Block fwdPostExit = this.buildFwdBlock(block.rank + "+NatPostX", fwdDiffSymbolTable, block, diffEnv);
                    if (!allExitsTurn) {
                        fwdPostExit.addInstrHdAfterDecls(adCountVarTool.makePush(block));
                    }
                    fwdArrow = this.checkFreeThenSetNewFGArrow(fwdPostExit, 0, 0, null, false);
                    TapList manyFwdBwds = (TapList)arrowFwdBwds.second;
                    while (manyFwdBwds != null) {
                        TapPair oneFwdBwd = (TapPair)manyFwdBwds.head;
                        if (fwdHeaderBlock.instructions != null) {
                            this.checkFreeThenRedirectDestination((FGArrow)oneFwdBwd.first, fwdPostExit, false);
                        } else {
                            if (this.adEnv.traceCurDifferentiation) {
                                TapEnv.printlnOnTrace("!Reconnect (dangling?) arrow " + oneFwdBwd.first + " to " + fwdPostExit + "!");
                            }
                            ((FGArrow)oneFwdBwd.first).redirectDestination(fwdPostExit, false);
                        }
                        oneFwdBwd.first = fwdArrow;
                        manyFwdBwds = manyFwdBwds.tail;
                    }
                    resultExitArrowFwdBwds.second = new TapList<TapPair<FGArrow, TapList<BwdSwitchCase>>>(new TapPair<FGArrow, TapList<BwdSwitchCase>>(fwdArrow, new TapList<BwdSwitchCase>(new BwdSwitchCase(fwdArrow, bwdPreEntry, new TapList<Block>(loopArrow.origin, null), loopArrow.destination), null)), null);
                    tlExitingArrowsFwdBwds = tlExitingArrowsFwdBwds.placdl(arrowFwdBwds);
                    if (loopArrow.origin.symbolTable != primalSymbolTable) {
                        exitExitsFromInsideScope = true;
                    }
                } else {
                    tlCyclingArrowsFwdBwds = tlCyclingArrowsFwdBwds.placdl(arrowFwdBwds);
                    if (loopArrow.origin.symbolTable != primalSymbolTable) {
                        cycleExitsFromInsideScope = true;
                    }
                }
                loopArrowsFwdBwds = loopArrowsFwdBwds.tail;
            }
            TapList<TapPair<FGArrow, TapList<TapPair<FGArrow, TapList<BwdSwitchCase>>>>> exitingArrowsFwdBwds = hdExitingArrowsFwdBwds.tail;
            TapList<TapPair<FGArrow, TapList<TapPair<FGArrow, TapList<BwdSwitchCase>>>>> cyclingArrowsFwdBwds = hdCyclingArrowsFwdBwds.tail;
            if (cycleExitsFromInsideScope && exitExitsFromInsideScope) {
                FGArrow bwdLoopNextArrow = this.checkFreeThenSetNewFGArrow((Block)bwdHeaderBlock, 30, 1, null, false);
                TapList<FGArrow> arrowsBwdDownstream = null;
                if (bwdIncr != null && bwdIncr.instructions != null) {
                    Block bwdTestIter = this.buildBwdBlock(block.rank + "-NatTestIter", diffSymbolTable, block, diffEnv);
                    bwdTestIter.addInstrHdAfterDecls(ILUtils.build(98, ILUtils.build(68, dummyIndex.makeNewRef(diffSymbolTable), ILUtils.build(103, 1)), null, null));
                    this.checkFreeThenSetNewFGArrow((Block)bwdHeaderBlock, 30, 1, bwdTestIter, false);
                    this.checkFreeThenSetNewFGArrow(bwdTestIter, 20, 5, bwdIncr, false);
                    arrowsBwdDownstream = new TapList<FGArrow>(this.checkFreeThenSetNewFGArrow(bwdIncr, 0, 0, null, false), new TapList<FGArrow>(this.checkFreeThenSetNewFGArrow(bwdTestIter, 20, 2, null, false), null));
                } else {
                    arrowsBwdDownstream = new TapList<FGArrow>(bwdLoopNextArrow, null);
                }
                loopArrowsFwdBwds = loopNoCycleDifferentiation.exitArrowsFwdBwds;
                pushPopTree = this.buildFwdBwdTreeFromExitFwdBwd(loopArrowsFwdBwds);
                this.naturalLoopHeader = block;
                this.connectFwdBwd(pushPopTree, fwdPostCycle, arrowsBwdDownstream, block, null, diffEnv, diffSubLevel);
                this.naturalLoopHeader = null;
            } else if (cyclingArrowsFwdBwds == null) {
                pushPopTree = this.buildFwdBwdTreeFromExitFwdBwd(exitingArrowsFwdBwds);
                this.connectFwdBwd(pushPopTree, null, new TapList<FGArrow>(this.checkFreeThenSetNewFGArrow((Block)bwdHeaderBlock, 30, 1, null, false), null), null, null, diffEnv, diffSubLevel);
            } else if (exitingArrowsFwdBwds == null || this.sameUniqueBwdDestAndSameActivitySwitches(cyclingArrowsFwdBwds, exitingArrowsFwdBwds)) {
                pushPopTree = this.buildFwdBwdTreeFromExitFwdBwd(cyclingArrowsFwdBwds);
                this.connectFwdBwd(pushPopTree, fwdPostCycle, new TapList<FGArrow>(this.checkFreeThenSetNewFGArrow((Block)bwdHeaderBlock, 30, 1, null, false), null), block, null, diffEnv, diffSubLevel);
            } else {
                FGArrow arrowToBwdCycling;
                Block bwdTestIter = this.buildBwdBlock(block.rank + "-NatTestIter", diffSymbolTable, block, diffEnv);
                bwdTestIter.addInstrHdAfterDecls(ILUtils.build(98, ILUtils.build(68, dummyIndex.makeNewRef(diffSymbolTable), ILUtils.build(103, 1)), null, null));
                this.checkFreeThenSetNewFGArrow((Block)bwdHeaderBlock, 30, 1, bwdTestIter, false);
                pushPopTree = this.buildFwdBwdTreeFromExitFwdBwd(exitingArrowsFwdBwds);
                this.connectFwdBwd(pushPopTree, null, new TapList<FGArrow>(this.checkFreeThenSetNewFGArrow(bwdTestIter, 20, 2, null, false), null), null, null, diffEnv, diffSubLevel);
                pushPopTree = this.buildFwdBwdTreeFromExitFwdBwd(cyclingArrowsFwdBwds);
                if (bwdIncr != null && bwdIncr.instructions != null) {
                    this.checkFreeThenSetNewFGArrow(bwdTestIter, 20, 5, bwdIncr, false);
                    arrowToBwdCycling = this.checkFreeThenSetNewFGArrow(bwdIncr, 0, 0, null, false);
                } else {
                    arrowToBwdCycling = this.checkFreeThenSetNewFGArrow(bwdTestIter, 20, 5, null, false);
                }
                this.connectFwdBwd(pushPopTree, fwdPostCycle, new TapList<FGArrow>(arrowToBwdCycling, null), block, null, diffEnv, diffSubLevel);
            }
            if (bwdTest != null && bwdTest.instructions != null) {
                this.checkFreeThenSetNewFGArrow(bwdPostCycle, 0, 0, bwdTest, false);
                this.checkFreeThenSetNewFGArrow(bwdTest, 0, 0, (Block)bwdHeaderBlock, true);
            } else {
                this.checkFreeThenSetNewFGArrow(bwdPostCycle, 0, 0, (Block)bwdHeaderBlock, true);
            }
            this.checkFreeThenSetNewFGArrow(bwdPreEntry, 0, 0, (Block)bwdHeaderBlock, false);
            result.fwdBlockUS = fwdPreEntry;
            if (bwdInit != null && bwdInit.instructions != null) {
                this.checkFreeThenSetNewFGArrow((Block)bwdHeaderBlock, 30, 0, bwdInit, false);
                arrowToBwdUS = this.checkFreeThenSetNewFGArrow(bwdInit, 0, 0, null, false);
            } else {
                arrowToBwdUS = this.checkFreeThenSetNewFGArrow((Block)bwdHeaderBlock, 30, 0, null, false);
            }
            result.bwdArrowsUS = new TapList<FGArrow>(arrowToBwdUS, null);
        } else if (loopNoCycleDifferentiation.hasFwd() && !loopNoCycleDifferentiation.hasBwd()) {
            boolean hasBwd;
            fwdHeaderBlock = (HeaderBlock)loopNoCycleDifferentiation.fwdBlockUS;
            if (fwdDiffSymbolTable.declarationsBlock == fwdHeaderBlock) {
                fwdDiffSymbolTable.declarationsBlock = fwdPreEntry;
            }
            this.checkFreeThenSetNewFGArrow(fwdPreEntry, 0, 0, (Block)fwdHeaderBlock, false);
            if (doIndexToSave != null) {
                bwdPreEntry.addInstrTl(RefDescriptor.makePop(this.curDiffUnit(), ILUtils.copy(doIndexToSave), primalSymbolTable, diffSymbolTable, ppLabelForIndex, this.toBranchVariable));
            }
            boolean bl = hasBwd = bwdPreEntry.instructions != null;
            while (loopArrowsFwdBwds != null) {
                arrowFwdBwds = (TapPair)loopArrowsFwdBwds.head;
                FGArrow loopArrow = (FGArrow)arrowFwdBwds.first;
                resultExitArrowFwdBwds = TapList.assq(loopArrow, resultExitArrowsFwdBwds);
                if (resultExitArrowFwdBwds != null) {
                    resultExitArrowFwdBwds.second = null;
                }
                TapList manyFwdBwds = (TapList)arrowFwdBwds.second;
                while (manyFwdBwds != null) {
                    TapPair<FGArrow, TapList<BwdSwitchCase>> oneFwdBwd = (TapPair<FGArrow, TapList<BwdSwitchCase>>)manyFwdBwds.head;
                    if (resultExitArrowFwdBwds != null) {
                        if (hasBwd) {
                            FGArrow danglingFwd = (FGArrow)oneFwdBwd.first;
                            oneFwdBwd = new TapPair<FGArrow, TapList<BwdSwitchCase>>(danglingFwd, new TapList<BwdSwitchCase>(new BwdSwitchCase(danglingFwd, bwdPreEntry, new TapList<Block>(loopArrow.origin, null), loopArrow.destination), null));
                        }
                        resultExitArrowFwdBwds.second = TapList.addLast((TapList)resultExitArrowFwdBwds.second, oneFwdBwd);
                    } else {
                        this.checkFreeThenRedirectDestination((FGArrow)oneFwdBwd.first, fwdHeaderBlock, true);
                    }
                    manyFwdBwds = manyFwdBwds.tail;
                }
                loopArrowsFwdBwds = loopArrowsFwdBwds.tail;
            }
            result.fwdBlockUS = fwdPreEntry;
            if (hasBwd) {
                result.bwdArrowsUS = new TapList<FGArrow>(this.checkFreeThenSetNewFGArrow(bwdPreEntry, 0, 0, null, false), null);
            }
        } else if (doIndexToSave != null) {
            bwdPreEntry.addInstrTl(RefDescriptor.makePop(this.curDiffUnit(), ILUtils.copy(doIndexToSave), primalSymbolTable, diffSymbolTable, ppLabelForIndex, this.toBranchVariable));
            result.bwdArrowsUS = new TapList<FGArrow>(this.checkFreeThenSetNewFGArrow(bwdPreEntry, 0, 0, null, false), null);
            result.fwdBlockUS = fwdPreEntry;
            fwdArrow = this.checkFreeThenSetNewFGArrow(fwdPreEntry, 0, 0, null, false);
            while (resultExitArrowsFwdBwds != null) {
                resultExitArrowFwdBwds = (TapPair)resultExitArrowsFwdBwds.head;
                FGArrow exitArrow = (FGArrow)resultExitArrowFwdBwds.first;
                resultExitArrowFwdBwds.second = new TapList<TapPair<FGArrow, TapList<BwdSwitchCase>>>(new TapPair<FGArrow, TapList<BwdSwitchCase>>(fwdArrow, new TapList<BwdSwitchCase>(new BwdSwitchCase(fwdArrow, bwdPreEntry, new TapList<HeaderBlock>(block, null), exitArrow.destination), null)), null);
                resultExitArrowsFwdBwds = resultExitArrowsFwdBwds.tail;
            }
        } else {
            result.fwdBlockUS = null;
            result.bwdArrowsUS = null;
        }
        diffSubLevel.restoreChildrenParent();
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.decrTraceIndent(2);
            TapEnv.indentprintlnOnTrace(">>end diff NATURAL_LOOP " + diffSubLevel);
            TapEnv.indentprintlnOnTrace("  -upstream: " + result.fwdBlockUS + " ; " + result.bwdArrowsUS);
            TapList exitArrowsFwdBwds = result.exitArrowsFwdBwds;
            TapEnv.indentprintOnTrace("  -dnstream: (");
            while (exitArrowsFwdBwds != null) {
                TapEnv.printlnOnTrace("-" + exitArrowsFwdBwds.head);
                exitArrowsFwdBwds = exitArrowsFwdBwds.tail;
                TapEnv.indentprintOnTrace("             " + (exitArrowsFwdBwds == null ? "" : Character.valueOf(' ')));
            }
            TapEnv.printlnOnTrace(")");
        }
        return result;
    }

    private FlowGraphDifferentiation differentiateFixedPointLoop(FlowGraphLevel diffSubLevel, FlowGraphDifferentiationEnv diffEnv) {
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.indentprintlnOnTrace("begin diff FIXEDPOINT_LOOP " + diffSubLevel);
            TapEnv.incrTraceIndent(2);
        }
        HeaderBlock block = (HeaderBlock)diffSubLevel.entryBlock;
        Directive fixedPointDirective = block.headInstr().hasDirective(23);
        boolean modeIsAdjoint = diffEnv.adDiffMode == -1 || diffEnv.adDiffMode == -2;
        FlowGraphLevel loopBody = diffSubLevel.createLoopBody();
        int nDRZ = block.symbolTable.declaredZonesNb(this.adEnv.diffKind);
        int[] diffMap = DataFlowAnalyzer.makeMap3(0, 0, nDRZ);
        BoolVector stateVarsFromDirective = new BoolVector(nDRZ);
        BoolVector paramVars = new BoolVector(nDRZ);
        ToObject<Object> toAltStateVarsArray = new ToObject<Object>(null);
        Tree[] stateVariables = fixedPointDirective.arguments;
        this.detectFixedPointParamsAndState(stateVarsFromDirective, paramVars, diffMap, loopBody, block, block.symbolTable, stateVariables, toAltStateVarsArray);
        if (stateVariables.length == 0) {
            stateVariables = toAltStateVarsArray.obj();
        }
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.indentprintlnOnTrace("Special Re-differentiation of fixed-point body:");
            System.out.print(" state variables: [");
            for (int i = 0; i < stateVariables.length; ++i) {
                System.out.print(" " + stateVariables[i]);
            }
            System.out.println("]");
            TapEnv.indentprintlnOnTrace(" state:" + stateVarsFromDirective + " parameters:" + paramVars);
        }
        TapPair<TapList<BoolVector>, TapList<BoolVector>> loopBodyActivityMemo = null;
        if (TapEnv.doActivity()) {
            loopBodyActivityMemo = ADActivityAnalyzer.saveFrontierActivity(loopBody.entryArrows, loopBody.exitArrows, this.adEnv.curActivity());
        }
        FlowGraphDifferentiationEnv diffEnvRepeated = diffEnv.deriveForNewSplitDiff();
        if (TapEnv.doActivity()) {
            this.computeLocalActivity(loopBody, paramVars, loopBodyActivityMemo);
        }
        TapList<Tree> parameterVariablesDiffModified = this.collectActiveUsesOfParameters(new TapList<Block>(block, loopBody.allBlocksInside()), paramVars, diffMap, null);
        if (diffSubLevel.staticSaves == null) {
            TapList<Object> toStaticSavers = new TapList<Object>(null, null);
            diffSubLevel.staticSaves = new TapTriplet<Boolean, TapList<Object>, TapList<Object>>(Boolean.FALSE, toStaticSavers, toStaticSavers);
        } else {
            diffSubLevel.staticSaves.first = Boolean.TRUE;
            diffSubLevel.staticSaves.third = diffSubLevel.staticSaves.second;
        }
        this.blockDifferentiator().pushStaticSaves(diffSubLevel.staticSaves);
        this.precomputeDifferentiatedBlocksIn(loopBody, diffEnvRepeated);
        FlowGraphDifferentiation loopBodyDifferentiationRepeated = this.differentiateFlowGraphLevel(loopBody, diffEnvRepeated);
        if (TapEnv.doActivity()) {
            this.computeLocalActivity(loopBody, stateVarsFromDirective, loopBodyActivityMemo);
        }
        diffSubLevel.staticSaves.first = Boolean.TRUE;
        diffSubLevel.staticSaves.third = diffSubLevel.staticSaves.second;
        this.precomputeDifferentiatedBlocksIn(loopBody, diffEnv);
        FlowGraphDifferentiation loopBodyDifferentiationFinal = this.differentiateFlowGraphLevel(loopBody, diffEnv);
        this.blockDifferentiator().popStaticSaves();
        if (TapEnv.doActivity()) {
            this.computeLocalActivity(loopBody, null, loopBodyActivityMemo);
        }
        FlowGraphCopy loopBodyCopy = this.copyFlowGraphLevel(loopBody, new FlowGraphCopyEnv(diffEnv.diffCtxtFwd));
        HeaderBlock fwdBlock = (HeaderBlock)diffEnv.fwdDiffBlocks.retrieve(block);
        HeaderBlock bwdBlock = (HeaderBlock)diffEnv.bwdDiffBlocks.retrieve(block);
        SymbolTable fwdDiffSymbolTable = fwdBlock.symbolTable;
        SymbolTable diffSymbolTable = bwdBlock == null ? null : bwdBlock.symbolTable;
        Block fwdPreEntry = this.buildFwdBlock(block.rank + "+FPpreE", fwdDiffSymbolTable, block, diffEnv);
        if (fwdDiffSymbolTable.declarationsBlock == fwdBlock) {
            fwdDiffSymbolTable.declarationsBlock = fwdPreEntry;
        }
        Block fwdEnd = this.buildFwdBlock(block.rank + "+FPend", fwdDiffSymbolTable, block, diffEnv);
        Block bwdPreEntry = null;
        Block bwdPostExit = null;
        Block bwdPreCycle = null;
        Block bwdPostCycle = null;
        Block bwdEnd = null;
        if (modeIsAdjoint) {
            bwdPreEntry = this.buildBwdBlock(block.rank + "-FPpreE", diffSymbolTable, block, diffEnv);
            if (diffSymbolTable != null && diffSymbolTable.declarationsBlock == bwdBlock) {
                diffSymbolTable.declarationsBlock = bwdPreEntry;
            }
            bwdEnd = this.buildBwdBlock(block.rank + "-FPend", diffSymbolTable, block, diffEnv);
            bwdPreCycle = this.buildBwdBlock(block.rank + "-FPpreCy", diffSymbolTable, block, diffEnv);
            bwdPostCycle = this.buildBwdBlock(block.rank + "-FPpostCy", diffSymbolTable, block, diffEnv);
            bwdPostExit = this.buildBwdBlock(block.rank + "-FPpostX", diffSymbolTable, block, diffEnv);
        }
        if (fwdBlock.instructions == null) {
            fwdBlock.addInstrTl(ILUtils.copy(block.lastInstr().tree));
        }
        this.checkFreeThenSetNewFGArrow(fwdPreEntry, 0, 0, (Block)fwdBlock, false);
        this.checkFreeThenSetNewFGArrow((Block)fwdBlock, 30, 1, loopBodyCopy.copyBlockUS, false);
        TapList<FGArrow> cyclingArrows = block.cyclingArrows();
        while (cyclingArrows != null) {
            FGArrow copyCycling = loopBodyCopy.getCopyOfExitArrow((FGArrow)cyclingArrows.head);
            if (copyCycling != null) {
                this.checkFreeThenRedirectDestination(copyCycling, fwdBlock, true);
            }
            cyclingArrows = cyclingArrows.tail;
        }
        WrapperTypeSpec doubleType = new WrapperTypeSpec(new ModifiedTypeSpec(this.adEnv.realTypeSpec, ILUtils.build(103, 8), null));
        NewSymbolHolder cumulVar = new NewSymbolHolder("cumul", this.curDiffUnit(), doubleType, -1);
        cumulVar.declarationLevelMustInclude(diffSymbolTable);
        cumulVar.preparePrivateClause(block, this.adEnv.curUnit().privateSymbolTable(), false, false);
        if (modeIsAdjoint) {
            PushPopNode pushPopTree;
            IterDescriptor multiDirIterDescriptor;
            String testArg2;
            String testFunctionName;
            this.checkFreeThenSetNewFGArrow(bwdPreEntry, 0, 0, (Block)bwdBlock, false);
            this.checkFreeThenSetNewFGArrow((Block)bwdBlock, 30, 1, bwdPreCycle, false);
            this.checkFreeThenSetNewFGArrow(bwdPostCycle, 0, 0, (Block)bwdBlock, true);
            this.checkFreeThenSetNewFGArrow((Block)bwdBlock, 30, 0, bwdPostExit, false);
            Tree firstLoopInstr = block.headInstr().tree;
            if (firstLoopInstr.opCode() == 121 && firstLoopInstr.down(3).opCode() == 64) {
                Tree doIndexToSave = firstLoopInstr.down(3).down(1);
                if (ADTBRAnalyzer.isTBRindexOnLoopEntry(this.adEnv.curActivity(), doIndexToSave)) {
                    RefDescriptor indexSaveRefDescriptor = new RefDescriptor(ILUtils.copy(doIndexToSave), null, block.symbolTable, fwdBlock.symbolTable, null, null, false, null, this.curDiffUnit());
                    this.adEnv.setCurBlock(block.enclosingLoop());
                    this.blockDifferentiator().prepareRestoreOperations(indexSaveRefDescriptor, null, 1, fwdBlock.symbolTable, diffSymbolTable);
                    fwdPreEntry.addInstrHdAfterDecls(indexSaveRefDescriptor.makePush());
                    bwdEnd.addInstrTl(indexSaveRefDescriptor.makePop());
                }
            }
            if (fixedPointDirective.adjReduction != null) {
                testFunctionName = "adFixedPoint_notReduced";
                testArg2 = fixedPointDirective.adjReduction.toString();
            } else if (fixedPointDirective.adjResidual != null) {
                testFunctionName = "adFixedPoint_tooLarge";
                testArg2 = fixedPointDirective.adjResidual.toString();
            } else {
                testFunctionName = "adFixedPoint_tooLarge";
                testArg2 = "1.0e-6";
            }
            bwdBlock.addInstrHdAfterDecls(ILUtils.build(121, null, null, ILUtils.build(206, ILUtils.buildCall(ILUtils.build(96, testFunctionName), ILUtils.build(71, cumulVar.makeNewRef(diffSymbolTable), ILUtils.build(160, testArg2)))), null));
            Unit diffFile = this.curDiffUnit().translationUnit();
            if (diffFile != null && !TapList.containsString(diffFile.newDiffCIncludes, "adFixedPoint.h", true)) {
                diffFile.newDiffCIncludes = new TapList<String>("adFixedPoint.h", diffFile.newDiffCIncludes);
            }
            WrapperTypeSpec booleanTypeSpec = diffSymbolTable.getTypeDecl((String)"boolean").typeSpec;
            this.forceDeclareDiffUtilityFunction(testFunctionName, booleanTypeSpec);
            bwdPreEntry.addInstrHdAfterDecls(ILUtils.buildCall(ILUtils.build(96, "adStack_startRepeat"), ILUtils.build(71)));
            bwdPostCycle.addInstrHdAfterDecls(ILUtils.buildCall(ILUtils.build(96, "adStack_resetRepeat"), ILUtils.build(71)));
            bwdPostExit.addInstrHdAfterDecls(ILUtils.buildCall(ILUtils.build(96, "adStack_endRepeat"), ILUtils.build(71)));
            Tree[] diffStateVariables = new Tree[stateVariables.length];
            Tree[] initialDiffStateVariables = new Tree[stateVariables.length];
            Tree[] copyDiffStateVariables = new Tree[stateVariables.length];
            for (int i = 0; i < stateVariables.length; ++i) {
                diffStateVariables[i] = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), stateVariables[i], diffSymbolTable, false, stateVariables[i], false, true, stateVariables[i]);
            }
            for (int i = 0; i < stateVariables.length; ++i) {
                this.adEnv.pushCurDiffSorts(-1, 3);
                initialDiffStateVariables[i] = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), stateVariables[i], diffSymbolTable, false, stateVariables[i], false, true, stateVariables[i]);
                this.adEnv.popCurDiffSorts();
                this.adEnv.pushCurDiffSorts(-1, 4);
                copyDiffStateVariables[i] = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), stateVariables[i], diffSymbolTable, false, stateVariables[i], false, true, stateVariables[i]);
                this.adEnv.popCurDiffSorts();
                VariableDecl origVarDecl = diffSymbolTable.getVariableDecl(ILUtils.baseName(stateVariables[i]));
                origVarDecl.setDiffSymbolHolder(3, null, 0, null);
                origVarDecl.setDiffSymbolHolder(4, null, 0, null);
            }
            IterDescriptor iterDescriptor = multiDirIterDescriptor = this.multiDirMode() ? this.varRefDifferentiator().multiDirIterDescriptor : null;
            while (parameterVariablesDiffModified != null) {
                this.saveRestoreDiffRefExpression((Tree)parameterVariablesDiffModified.head, bwdPreEntry, bwdPostExit, block.symbolTable, diffSymbolTable, multiDirIterDescriptor);
                parameterVariablesDiffModified = parameterVariablesDiffModified.tail;
            }
            for (int i = 0; i < stateVariables.length; ++i) {
                bwdPreCycle.addInstrHd(RefDescriptor.makeAssign(this.curDiffUnit(), stateVariables[i], stateVariables[i], block.symbolTable, diffSymbolTable, copyDiffStateVariables[i], diffStateVariables[i], true, multiDirIterDescriptor));
                bwdPostCycle.addInstrHd(RefDescriptor.makeNormDiff(this.curDiffUnit(), cumulVar.makeNewRef(diffSymbolTable), stateVariables[i], stateVariables[i], block.symbolTable, diffSymbolTable, diffStateVariables[i], copyDiffStateVariables[i], true, multiDirIterDescriptor));
                bwdPreEntry.addInstrHdAfterDecls(RefDescriptor.makeAssign(this.curDiffUnit(), stateVariables[i], stateVariables[i], block.symbolTable, diffSymbolTable, initialDiffStateVariables[i], diffStateVariables[i], true, multiDirIterDescriptor));
                bwdPostCycle.addInstrHdAfterDecls(RefDescriptor.makeIncrement(this.curDiffUnit(), stateVariables[i], stateVariables[i], block.symbolTable, diffSymbolTable, diffStateVariables[i], initialDiffStateVariables[i], true, multiDirIterDescriptor));
                bwdEnd.addInstrHdAfterDecls(RefDescriptor.makeInitialize(this.curDiffUnit(), stateVariables[i], null, null, null, block.symbolTable, diffSymbolTable, null, diffStateVariables[i], true, multiDirIterDescriptor, null, false, null, true));
            }
            bwdPreEntry.addInstrHd(ILUtils.build(14, cumulVar.makeNewRef(diffSymbolTable), ILUtils.build(160, "-1.0")));
            bwdPostCycle.addInstrHd(ILUtils.build(14, cumulVar.makeNewRef(diffSymbolTable), ILUtils.build(160, "0.0")));
            if (loopBodyDifferentiationRepeated.hasBwd()) {
                this.mapCheckFreeThenRedirectDestination(loopBodyDifferentiationRepeated.bwdArrowsUS, bwdPostCycle, false);
                this.checkFreeThenSetNewFGArrow((Block)fwdBlock, 30, 0, loopBodyDifferentiationRepeated.fwdBlockUS, false);
                pushPopTree = this.buildFwdBwdTreeFromExitFwdBwd(loopBodyDifferentiationRepeated.exitArrowsFwdBwds);
                this.connectFwdBwd(pushPopTree, fwdEnd, new TapList<FGArrow>(this.checkFreeThenSetNewFGArrow(bwdPreCycle, 0, 0, null, false), null), block, null, diffEnv, diffSubLevel);
            } else if (loopBodyDifferentiationRepeated.hasFwd()) {
                this.checkFreeThenSetNewFGArrow((Block)fwdBlock, 30, 0, loopBodyDifferentiationRepeated.fwdBlockUS, false);
                TapList exitArrowsFwdBwds = loopBodyDifferentiationRepeated.exitArrowsFwdBwds;
                while (exitArrowsFwdBwds != null) {
                    TapPair exitArrowFwdBwds = (TapPair)exitArrowsFwdBwds.head;
                    TapList manyFwdBwds = (TapList)exitArrowFwdBwds.second;
                    while (manyFwdBwds != null) {
                        this.checkFreeThenRedirectDestination((FGArrow)((TapPair)manyFwdBwds.head).first, fwdEnd, false);
                        manyFwdBwds = manyFwdBwds.tail;
                    }
                    exitArrowsFwdBwds = exitArrowsFwdBwds.tail;
                }
                this.checkFreeThenSetNewFGArrow(bwdPreCycle, 0, 0, bwdPostCycle, false);
            } else {
                this.checkFreeThenSetNewFGArrow((Block)fwdBlock, 30, 0, fwdEnd, false);
                this.checkFreeThenSetNewFGArrow(bwdPreCycle, 0, 0, bwdPostCycle, false);
            }
            Block fwdDummy = this.buildFwdBlock(block.rank + "+FPdummy", fwdDiffSymbolTable, block, diffEnv);
            if (loopBodyDifferentiationFinal.hasBwd()) {
                this.mapCheckFreeThenRedirectDestination(loopBodyDifferentiationFinal.bwdArrowsUS, bwdEnd, false);
                pushPopTree = this.buildFwdBwdTreeFromExitFwdBwd(loopBodyDifferentiationFinal.exitArrowsFwdBwds);
                this.connectFwdBwd(pushPopTree, fwdDummy, new TapList<FGArrow>(this.checkFreeThenSetNewFGArrow(bwdPostExit, 0, 0, null, false), null), block, null, diffEnv, diffSubLevel);
            } else {
                this.checkFreeThenSetNewFGArrow(bwdPostExit, 0, 0, bwdEnd, false);
            }
        }
        diffSubLevel.restoreChildrenParent();
        FlowGraphDifferentiation result = new FlowGraphDifferentiation(diffSubLevel);
        result.fwdBlockUS = fwdPreEntry;
        assert (bwdEnd != null);
        result.bwdArrowsUS = new TapList<FGArrow>(this.checkFreeThenSetNewFGArrow(bwdEnd, 0, 0, null, false), null);
        TapPair exitArrowFwdBwds = (TapPair)((FlowGraphDifferentiation)result).exitArrowsFwdBwds.head;
        FGArrow exitArrow = (FGArrow)exitArrowFwdBwds.first;
        FGArrow fwdArrow = this.checkFreeThenSetNewFGArrow(fwdEnd, 0, 0, null, false);
        exitArrowFwdBwds.second = new TapList<TapPair<FGArrow, TapList<BwdSwitchCase>>>(new TapPair<FGArrow, TapList<BwdSwitchCase>>(fwdArrow, new TapList<BwdSwitchCase>(new BwdSwitchCase(fwdArrow, bwdPreEntry, new TapList<HeaderBlock>(block, null), exitArrow.destination), null)), null);
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.decrTraceIndent(2);
            TapEnv.indentprintlnOnTrace(">>end diff FIXEDPOINT_LOOP " + diffSubLevel);
            TapEnv.indentprintlnOnTrace("  -upstream: " + result.fwdBlockUS + " ; " + result.bwdArrowsUS);
            TapList exitArrowsFwdBwds = result.exitArrowsFwdBwds;
            TapEnv.indentprintOnTrace("  -dnstream: (");
            while (exitArrowsFwdBwds != null) {
                TapEnv.printlnOnTrace("-" + exitArrowsFwdBwds.head);
                exitArrowsFwdBwds = exitArrowsFwdBwds.tail;
                TapEnv.indentprintOnTrace("             " + (exitArrowsFwdBwds == null ? "" : Character.valueOf(' ')));
            }
            TapEnv.printlnOnTrace(")");
        }
        return result;
    }

    private FlowGraphDifferentiation differentiateStructuredLoop(FlowGraphLevel diffSubLevel, FlowGraphDifferentiationEnv diffEnv) {
        TapList exitArrowsFwdBwds;
        FGArrow exitArrow;
        FGArrow fwdArrow;
        boolean loopIsRequired;
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.indentprintlnOnTrace("begin diff STRUCTURED_LOOP " + diffSubLevel);
            TapEnv.incrTraceIndent(2);
        }
        HeaderBlock block = (HeaderBlock)diffSubLevel.entryBlock;
        boolean modeIsAdjoint = diffEnv.adDiffMode == -1 || diffEnv.adDiffMode == -2;
        boolean modeIsJoint = diffEnv.adDiffMode == -1;
        FlowGraphLevel loopBodyPiece = diffSubLevel.createLoopBody();
        FlowGraphDifferentiation loopBodyDifferentiation = this.differentiateFlowGraphLevel(loopBodyPiece, diffEnv);
        HeaderBlock fwdBlock = (HeaderBlock)diffEnv.fwdDiffBlocks.retrieve(block);
        HeaderBlock bwdBlock = (HeaderBlock)diffEnv.bwdDiffBlocks.retrieve(block);
        SymbolTable fwdDiffSymbolTable = fwdBlock.symbolTable;
        SymbolTable diffSymbolTable = bwdBlock == null ? null : bwdBlock.symbolTable;
        boolean opensCurrentControl = this.opensCurrentControl(block);
        Block fwdPreEntry = this.buildFwdBlock(block.rank + "+preE", fwdDiffSymbolTable, block, diffEnv);
        if (opensCurrentControl && ((Instruction)fwdPreEntry.parallelControls.head).tree.opCode() == 144) {
            fwdPreEntry.parallelControls = fwdPreEntry.parallelControls.tail;
        }
        if (fwdDiffSymbolTable.declarationsBlock == fwdBlock) {
            fwdDiffSymbolTable.declarationsBlock = fwdPreEntry;
        }
        Block fwdPostCycle = this.buildFwdBlock(block.rank + "+postCy", fwdDiffSymbolTable, block, diffEnv);
        Block fwdPostExit = this.buildFwdBlock(block.rank + "+postX", fwdDiffSymbolTable, block, diffEnv);
        if (opensCurrentControl && ((Instruction)fwdPostExit.parallelControls.head).tree.opCode() == 144) {
            fwdPostExit.parallelControls = fwdPostExit.parallelControls.tail;
        }
        Block bwdPreEntry = null;
        Block bwdPreCycle = null;
        Block bwdPostExit = null;
        if (modeIsAdjoint) {
            bwdPreEntry = this.buildBwdBlock(block.rank + "-preE", diffSymbolTable, block, diffEnv);
            if (opensCurrentControl && ((Instruction)bwdPreEntry.parallelControls.head).tree.opCode() == 144) {
                bwdPreEntry.parallelControls = bwdPreEntry.parallelControls.tail;
            }
            if (diffSymbolTable != null && diffSymbolTable.declarationsBlock == bwdBlock) {
                diffSymbolTable.declarationsBlock = bwdPreEntry;
            }
            bwdPreCycle = this.buildBwdBlock(block.rank + "-preCy", diffSymbolTable, block, diffEnv);
            bwdPostExit = this.buildBwdBlock(block.rank + "-postX", diffSymbolTable, block, diffEnv);
            if (opensCurrentControl && ((Instruction)bwdPostExit.parallelControls.head).tree.opCode() == 144) {
                bwdPostExit.parallelControls = bwdPostExit.parallelControls.tail;
            }
        }
        boolean bl = loopIsRequired = TapEnv.debugAdMode() == -1 || !TapEnv.removeDeadControl() && !this.adEnv.curUnitIsContext || DiffLivenessAnalyzer.isTreeRequiredInDiff(this.adEnv.curActivity(), block.lastInstr().tree, modeIsJoint, false);
        if (!modeIsAdjoint) {
            this.fillLoopTangentControls();
        } else if (loopIsRequired && !this.adEnv.curUnitIsContext && loopBodyDifferentiation.hasBwd()) {
            assert (bwdBlock != null);
            int blockLoopKind = diffSubLevel.levelKind;
            boolean allExitsTurn = this.allExitsTurn(diffSubLevel.exitArrows, diffEnv.turningArrows);
            if (blockLoopKind == 10) {
                this.fillDoLoopAdjointControls(block, fwdBlock, fwdPreEntry, fwdPostCycle, fwdPostExit, bwdBlock, bwdPreEntry, bwdPreCycle, bwdPostExit, allExitsTurn);
            } else if (blockLoopKind == 8) {
                this.fillTimesLoopAdjointControls(block, fwdBlock, fwdPreEntry, fwdPostExit, bwdBlock, bwdPreEntry, allExitsTurn);
            } else if (blockLoopKind == 9) {
                this.fillWhileLoopAdjointControls(block, fwdBlock, fwdPreEntry, fwdPostCycle, fwdPostExit, bwdBlock, bwdPreEntry, allExitsTurn);
            } else {
                bwdBlock.addInstrHdAfterDecls(ILUtils.build(121, null, null, null, null));
            }
        }
        if (modeIsAdjoint && loopIsRequired && !this.adEnv.curUnitIsContext && diffSubLevel.levelKind == 10) {
            this.restoreInitialDoIndex(block, fwdBlock, bwdBlock, fwdPreEntry, bwdPostExit);
        }
        FlowGraphDifferentiation result = new FlowGraphDifferentiation(diffSubLevel);
        if (loopBodyDifferentiation.hasBwd()) {
            this.checkFreeThenSetNewFGArrow(fwdPreEntry, 0, 0, (Block)fwdBlock, false);
            fwdArrow = this.checkFreeThenSetNewFGArrow((Block)fwdBlock, 30, 1, loopBodyDifferentiation.fwdBlockUS, false);
            this.insertTangentDiffReinits(fwdArrow, block.getFGArrowTestCase(30, 1), fwdDiffSymbolTable, null, diffEnv);
            this.checkFreeThenSetNewFGArrow((Block)fwdBlock, 30, 0, fwdPostExit, false);
            this.checkFreeThenSetNewFGArrow(fwdPostCycle, 0, 0, (Block)fwdBlock, true);
            PushPopNode pushPopTree = this.buildFwdBwdTreeFromExitFwdBwd(loopBodyDifferentiation.exitArrowsFwdBwds);
            this.connectFwdBwd(pushPopTree, fwdPostCycle, new TapList<FGArrow>(this.checkFreeThenSetNewFGArrow(bwdPreCycle, 0, 0, null, false), null), block, null, diffEnv, diffSubLevel);
            this.checkFreeThenSetNewFGArrow(bwdPreEntry, 0, 0, (Block)bwdBlock, false);
            this.checkFreeThenSetNewFGArrow((Block)bwdBlock, 30, 1, bwdPreCycle, false);
            this.checkFreeThenSetNewFGArrow((Block)bwdBlock, 30, 0, bwdPostExit, false);
            this.connectBwd(loopBodyDifferentiation.bwdArrowsUS, bwdBlock, true, block, loopBodyPiece.entryBlock, diffEnv);
            result.fwdBlockUS = fwdPreEntry;
            result.bwdArrowsUS = new TapList<FGArrow>(this.checkFreeThenSetNewFGArrow(bwdPostExit, 0, 0, null, false), null);
            TapPair exitArrowFwdBwds = (TapPair)((FlowGraphDifferentiation)result).exitArrowsFwdBwds.head;
            exitArrow = (FGArrow)exitArrowFwdBwds.first;
            fwdArrow = this.checkFreeThenSetNewFGArrow(fwdPostExit, 0, 0, null, false);
            this.insertTangentDiffReinits(fwdArrow, exitArrow, fwdDiffSymbolTable, null, diffEnv);
            exitArrowFwdBwds.second = new TapList<TapPair<FGArrow, TapList<BwdSwitchCase>>>(new TapPair<FGArrow, TapList<BwdSwitchCase>>(fwdArrow, new TapList<BwdSwitchCase>(new BwdSwitchCase(fwdArrow, bwdPreEntry, new TapList<HeaderBlock>(block, null), exitArrow.destination), null)), null);
        } else if (loopBodyDifferentiation.hasFwd()) {
            this.checkFreeThenSetNewFGArrow(fwdPreEntry, 0, 0, (Block)fwdBlock, false);
            fwdArrow = this.checkFreeThenSetNewFGArrow((Block)fwdBlock, 30, 1, loopBodyDifferentiation.fwdBlockUS, false);
            this.insertTangentDiffReinits(fwdArrow, block.getFGArrowTestCase(30, 1), fwdDiffSymbolTable, null, diffEnv);
            this.checkFreeThenSetNewFGArrow((Block)fwdBlock, 30, 0, fwdPostExit, false);
            this.checkFreeThenSetNewFGArrow(fwdPostCycle, 0, 0, (Block)fwdBlock, true);
            exitArrowsFwdBwds = loopBodyDifferentiation.exitArrowsFwdBwds;
            while (exitArrowsFwdBwds != null) {
                TapPair arrowFwdBwds = (TapPair)exitArrowsFwdBwds.head;
                TapList manyFwdBwds = (TapList)arrowFwdBwds.second;
                while (manyFwdBwds != null) {
                    this.checkFreeThenRedirectDestination((FGArrow)((TapPair)manyFwdBwds.head).first, fwdPostCycle, false);
                    manyFwdBwds = manyFwdBwds.tail;
                }
                exitArrowsFwdBwds = exitArrowsFwdBwds.tail;
            }
            boolean hasBwd = modeIsAdjoint && !this.adEnv.curUnitIsContext && bwdPostExit.instructions != null;
            result.fwdBlockUS = fwdPreEntry;
            if (hasBwd) {
                result.bwdArrowsUS = new TapList<FGArrow>(this.checkFreeThenSetNewFGArrow(bwdPostExit, 0, 0, null, false), null);
            }
            TapPair exitArrowFwdBwds = (TapPair)((FlowGraphDifferentiation)result).exitArrowsFwdBwds.head;
            FGArrow exitArrow2 = (FGArrow)exitArrowFwdBwds.first;
            fwdArrow = this.checkFreeThenSetNewFGArrow(fwdPostExit, 0, 0, null, false);
            this.insertTangentDiffReinits(fwdArrow, exitArrow2, fwdDiffSymbolTable, null, diffEnv);
            exitArrowFwdBwds.second = new TapList<TapPair<FGArrow, TapList>>(new TapPair<FGArrow, TapList>(fwdArrow, hasBwd ? new TapList<BwdSwitchCase>(new BwdSwitchCase(fwdArrow, bwdPostExit, new TapList<HeaderBlock>(block, null), exitArrow2.destination), null) : null), null);
        } else if (modeIsAdjoint && bwdPostExit.instructions != null) {
            result.fwdBlockUS = fwdPreEntry;
            result.bwdArrowsUS = new TapList<FGArrow>(this.checkFreeThenSetNewFGArrow(bwdPostExit, 0, 0, null, false), null);
            TapPair exitArrowFwdBwds = (TapPair)((FlowGraphDifferentiation)result).exitArrowsFwdBwds.head;
            exitArrow = (FGArrow)exitArrowFwdBwds.first;
            fwdArrow = this.checkFreeThenSetNewFGArrow(fwdPreEntry, 0, 0, null, false);
            this.insertTangentDiffReinits(fwdArrow, exitArrow, fwdDiffSymbolTable, null, diffEnv);
            exitArrowFwdBwds.second = new TapList<TapPair<FGArrow, TapList<BwdSwitchCase>>>(new TapPair<FGArrow, TapList<BwdSwitchCase>>(fwdArrow, new TapList<BwdSwitchCase>(new BwdSwitchCase(fwdArrow, bwdPostExit, new TapList<HeaderBlock>(block, null), exitArrow.destination), null)), null);
        } else {
            result.fwdBlockUS = null;
            result.bwdArrowsUS = null;
        }
        diffSubLevel.restoreChildrenParent();
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.decrTraceIndent(2);
            TapEnv.indentprintlnOnTrace(">>end diff STRUCTURED_LOOP " + diffSubLevel);
            TapEnv.indentprintlnOnTrace("  -upstream: " + result.fwdBlockUS + " ; " + result.bwdArrowsUS);
            exitArrowsFwdBwds = result.exitArrowsFwdBwds;
            TapEnv.indentprintOnTrace("  -dnstream: (");
            while (exitArrowsFwdBwds != null) {
                TapEnv.printlnOnTrace("-" + exitArrowsFwdBwds.head);
                exitArrowsFwdBwds = exitArrowsFwdBwds.tail;
                TapEnv.indentprintOnTrace("             " + (exitArrowsFwdBwds == null ? "" : Character.valueOf(' ')));
            }
            TapEnv.printlnOnTrace(")");
        }
        return result;
    }

    private void fillLoopTangentControls() {
    }

    private void fillDoLoopAdjointControls(HeaderBlock block, HeaderBlock fwdBlock, Block fwdPreEntry, Block fwdPostCycle, Block fwdPostExit, HeaderBlock bwdBlock, Block bwdPreEntry, Block bwdPreCycle, Block bwdPostExit, boolean allExitsTurn) {
        Instruction primalDoInstruction = block.headInstr();
        SymbolTable fwdDiffSymbolTable = fwdBlock.symbolTable;
        SymbolTable diffSymbolTable = bwdBlock.symbolTable;
        Instruction fwdDoInstruction = fwdBlock.headInstr();
        Tree fwdLoopControl = fwdDoInstruction.tree.down(3);
        Tree bwdLoopControl = ILUtils.build(64, ILUtils.copy(fwdLoopControl.down(1)));
        Tree fromTree = fwdLoopControl.down(2);
        if (InOutAnalyzer.isCheapDuplicableConstant(fromTree, block, primalDoInstruction)) {
            bwdLoopControl.setChild(ILUtils.copy(fromTree), 3);
        } else {
            FwdBwdVarTool adFromVarTool = new FwdBwdVarTool(this.adFromStr, null, block, fwdDiffSymbolTable, diffSymbolTable);
            fwdPreEntry.addInstrTl(ILUtils.build(14, adFromVarTool.makeFwdRef(block), ILUtils.copy(fromTree)));
            fwdLoopControl.setChild(adFromVarTool.makeFwdRef(block), 2);
            if (!allExitsTurn) {
                fwdPostExit.addInstrTl(adFromVarTool.makePush(block));
                bwdPreEntry.addInstrHdAfterDecls(adFromVarTool.makePop(block));
            }
            bwdLoopControl.setChild(adFromVarTool.makeRef(block), 3);
        }
        Tree strideTree = fwdLoopControl.down(4);
        if (ILUtils.isNullOrNone(strideTree)) {
            strideTree = ILUtils.build(103, 1);
        }
        if (InOutAnalyzer.isCheapDuplicableConstant(strideTree, block, primalDoInstruction)) {
            bwdLoopControl.setChild(ILUtils.minusTree(ILUtils.copy(strideTree)), 4);
        } else {
            FwdBwdVarTool adStrideVarTool = new FwdBwdVarTool(this.adStrideStr, null, block, fwdDiffSymbolTable, diffSymbolTable);
            fwdPreEntry.addInstrTl(ILUtils.build(14, adStrideVarTool.makeFwdRef(block), ILUtils.copy(strideTree)));
            strideTree = adStrideVarTool.makeFwdRef(block);
            fwdLoopControl.setChild(adStrideVarTool.makeFwdRef(block), 4);
            if (!allExitsTurn) {
                fwdPostExit.addInstrTl(adStrideVarTool.makePush(block));
                bwdPreEntry.addInstrHdAfterDecls(adStrideVarTool.makePop(block));
            }
            bwdLoopControl.setChild(ILUtils.minusTree(adStrideVarTool.makeRef(block)), 4);
        }
        Tree lastIndexTree = ILUtils.hasDuplicableLastIndex(fwdLoopControl, false);
        if (lastIndexTree != null && InOutAnalyzer.isCheapDuplicableConstant(lastIndexTree, block, primalDoInstruction)) {
            bwdLoopControl.setChild(lastIndexTree, 2);
        } else {
            fwdBlock.loopIndexUnusedAfterLoop = false;
            FwdBwdVarTool adToVarTool = new FwdBwdVarTool(this.adToStr, ILUtils.subTree(ILUtils.copy(fwdLoopControl.down(1)), strideTree), block, fwdDiffSymbolTable, diffSymbolTable);
            if (!allExitsTurn) {
                fwdPostExit.addInstrHdAfterDecls(adToVarTool.makePush(block));
                bwdPreEntry.addInstrTl(adToVarTool.makePop(block));
            } else {
                fwdPostExit.addInstrHdAfterDecls(ILUtils.build(14, adToVarTool.makeRef(block), ILUtils.subTree(ILUtils.copy(fwdLoopControl.down(1)), strideTree)));
            }
            bwdLoopControl.setChild(adToVarTool.makeRef(block), 2);
        }
        Tree doIndexToSave = fwdLoopControl.down(1);
        if (ADTBRAnalyzer.isTBRindexOnLoopCycle(this.adEnv.curActivity(), doIndexToSave) && !this.adEnv.curUnitIsContext) {
            int ppLabelForIndex = TapEnv.getNewPushPopNumber();
            fwdPostCycle.addInstrTl(RefDescriptor.makePush(this.curFwdDiffUnit(), ILUtils.copy(doIndexToSave), block.symbolTable, fwdDiffSymbolTable, ppLabelForIndex));
            bwdPreCycle.addInstrHdAfterDecls(RefDescriptor.makePop(this.curDiffUnit(), ILUtils.copy(doIndexToSave), block.symbolTable, diffSymbolTable, ppLabelForIndex, this.toBranchVariable));
        }
        bwdBlock.addInstrHdAfterDecls(ILUtils.build(121, null, null, bwdLoopControl, null));
    }

    private void restoreInitialDoIndex(HeaderBlock block, HeaderBlock fwdBlock, HeaderBlock bwdBlock, Block fwdPreEntry, Block bwdPostExit) {
        Tree doIndexToSave = fwdBlock.headInstr().tree.down(3).down(1);
        if (ADTBRAnalyzer.isTBRindexOnLoopEntry(this.adEnv.curActivity(), doIndexToSave)) {
            SymbolTable fwdDiffSymbolTable = fwdBlock.symbolTable;
            SymbolTable diffSymbolTable = bwdBlock.symbolTable;
            RefDescriptor indexSaveRefDescriptor = new RefDescriptor(ILUtils.copy(doIndexToSave), null, block.symbolTable, fwdDiffSymbolTable, null, null, false, null, this.curDiffUnit());
            this.adEnv.setCurBlock(block.enclosingLoop());
            this.blockDifferentiator().prepareRestoreOperations(indexSaveRefDescriptor, null, 1, fwdDiffSymbolTable, diffSymbolTable);
            fwdPreEntry.addInstrTl(indexSaveRefDescriptor.makePush());
            bwdPostExit.addInstrHdAfterDecls(indexSaveRefDescriptor.makePop());
        }
    }

    private void fillTimesLoopAdjointControls(HeaderBlock block, HeaderBlock fwdBlock, Block fwdPreEntry, Block fwdPostExit, HeaderBlock bwdBlock, Block bwdPreEntry, boolean allExitsTurn) {
        Instruction fwdTimesInstruction = fwdBlock.headInstr();
        Tree fwdLoopControl = fwdTimesInstruction.tree.down(3);
        Tree countTree = fwdLoopControl.down(1);
        if (InOutAnalyzer.isCheapDuplicableConstant(countTree, block, fwdTimesInstruction)) {
            bwdBlock.addInstrHdAfterDecls(ILUtils.build(121, null, null, ILUtils.build(189, ILUtils.copy(countTree)), null));
        } else {
            SymbolTable fwdDiffSymbolTable = fwdBlock.symbolTable;
            SymbolTable diffSymbolTable = bwdBlock.symbolTable;
            FwdBwdVarTool adCountVarTool = new FwdBwdVarTool(this.adCountStr, null, block, fwdDiffSymbolTable, diffSymbolTable);
            fwdPreEntry.addInstrHdAfterDecls(ILUtils.build(14, adCountVarTool.makeFwdRef(block), ILUtils.copy(countTree)));
            fwdLoopControl.setChild(adCountVarTool.makeFwdRef(block), 1);
            if (!allExitsTurn) {
                fwdPostExit.addInstrHdAfterDecls(adCountVarTool.makePush(block));
                bwdPreEntry.addInstrHdAfterDecls(adCountVarTool.makePop(block));
            }
            bwdBlock.addInstrHdAfterDecls(ILUtils.build(121, null, null, ILUtils.build(189, adCountVarTool.makeRef(block)), null));
        }
    }

    private void fillWhileLoopAdjointControls(HeaderBlock block, HeaderBlock fwdBlock, Block fwdPreEntry, Block fwdPostCycle, Block fwdPostExit, HeaderBlock bwdBlock, Block bwdPreEntry, boolean allExitsTurn) {
        SymbolTable fwdDiffSymbolTable = fwdBlock.symbolTable;
        SymbolTable diffSymbolTable = bwdBlock.symbolTable;
        FwdBwdVarTool adCountVarTool = new FwdBwdVarTool(this.adCountStr, null, block, fwdDiffSymbolTable, diffSymbolTable);
        fwdPreEntry.addInstrHdAfterDecls(ILUtils.build(14, adCountVarTool.makeFwdRef(block), ILUtils.build(103, 0)));
        fwdPostCycle.addInstrHdAfterDecls(ILUtils.build(14, adCountVarTool.makeFwdRef(block), ILUtils.build(3, adCountVarTool.makeFwdRef(block), ILUtils.build(103, 1))));
        if (!allExitsTurn) {
            fwdPostExit.addInstrHdAfterDecls(adCountVarTool.makePush(block));
            bwdPreEntry.addInstrHdAfterDecls(adCountVarTool.makePop(block));
        }
        NewSymbolHolder newSymbol = new NewSymbolHolder("i", this.curDiffUnit(), this.adEnv.integerTypeSpec, -1);
        newSymbol.declarationLevelMustInclude(diffSymbolTable);
        newSymbol.preparePrivateClause(block, this.adEnv.curUnit().privateSymbolTable(), false, false);
        bwdBlock.addInstrHdAfterDecls(ILUtils.build(121, null, null, ILUtils.build(64, newSymbol.makeNewRef(diffSymbolTable), ILUtils.build(103, 1), adCountVarTool.makeRef(block), ILUtils.build(138)), null));
    }

    private void forceDeclareDiffUtilityFunction(String funcName, WrapperTypeSpec resultType) {
        FunctionDecl funcDecl;
        SymbolTable diffSymbolTable = this.curDiffUnit().externalSymbolTable();
        TapList<FunctionDecl> funcDecls = diffSymbolTable.getFunctionDecl(funcName, null, null, false);
        FunctionDecl functionDecl = funcDecl = funcDecls == null ? null : (FunctionDecl)funcDecls.head;
        if (funcDecl == null) {
            Unit funcUnit = this.adEnv.diffCallGraph().createNewUnit(null, this.adEnv.curUnit().language());
            funcUnit.setExternalSymbolTable(this.adEnv.diffCallGraph().languageRootSymbolTable(TapEnv.relatedLanguage()));
            funcUnit.setExternal();
            funcUnit.setName(funcName);
            Tree nameTree = ILUtils.tapenadeUtilityFunctionName(this.curDiffUnit(), funcName);
            WrapperTypeSpec booleanTypeSpec = diffSymbolTable.getTypeDecl((String)"boolean").typeSpec;
            funcUnit.setFunctionTypeSpec(new FunctionTypeSpec(booleanTypeSpec));
            funcDecl = new FunctionDecl(nameTree, funcUnit);
            nameTree.setAnnotation("isFunctionName", Boolean.TRUE);
            Instruction declInstr = new Instruction(ILUtils.build(199, ILUtils.build(130), booleanTypeSpec.generateTree(null, null, null, true, null), ILUtils.build(54, nameTree)));
            if (this.curDiffUnit().isFortran()) {
                this.curDiffUnit().privateSymbolTable().declarationsBlock.addInstrDeclTlBeforeUse(declInstr, null, null, null, true);
            }
            funcDecl.setInstruction(declInstr);
            diffSymbolTable.addSymbolDecl(funcDecl);
        }
    }

    private void detectFixedPointParamsAndState(BoolVector stateVarsFromDirective, BoolVector paramVars, int[] diffMap, FlowGraphLevel fixedPointBody, HeaderBlock loopHeader, SymbolTable symbolTable, Tree[] directiveStateVars, ToObject<Tree[]> toAltStateVarsArray) {
        stateVarsFromDirective.setFalse();
        boolean stateGiven = directiveStateVars.length > 0;
        for (int i = directiveStateVars.length - 1; i >= 0; --i) {
            TapIntList zones = symbolTable.listOfZonesOfValue(directiveStateVars[i], null, loopHeader.headInstr());
            DataFlowAnalyzer.setExtendedDeclared(stateVarsFromDirective, diffMap, this.adEnv.diffKind, zones, true, symbolTable);
        }
        FGArrow exitFromHeader = loopHeader.getFGArrowTestCase(30, 0);
        TapList<Block> blocksInsideLoop = new TapList<Block>(loopHeader, fixedPointBody.allBlocksInside());
        TapList<FGArrow> entryFrontier = loopHeader.backFlow();
        TapList<FGArrow> exitFrontier = new TapList<FGArrow>(exitFromHeader, fixedPointBody.exitArrows);
        TapList<FGArrow> entryFrontierNoCycle = this.removeCyclingFrom(entryFrontier, blocksInsideLoop);
        BoolVector unusedAfterLoopVars = exitFromHeader.destination.unusedZones;
        InOutAnalyzer inOutAnalyzer = TapEnv.inOutAnalyzer();
        inOutAnalyzer.setCurUnitEtc(this.adEnv.curUnit());
        inOutAnalyzer.setFgPhase(1);
        inOutAnalyzer.analyzeBackward(entryFrontier, blocksInsideLoop, exitFrontier);
        BoolVector readVars = inOutAnalyzer.getFrontierPossiblyReadZones(entryFrontierNoCycle);
        inOutAnalyzer.setFgPhase(0);
        inOutAnalyzer.setFgSubPhase(2);
        inOutAnalyzer.analyzeBackward(entryFrontier, blocksInsideLoop, exitFrontier);
        BoolVector modifiedVars = inOutAnalyzer.getFrontierModifiedZones(entryFrontierNoCycle);
        inOutAnalyzer.setFgPhase(1);
        inOutAnalyzer.analyzeBackward(null, null, null);
        inOutAnalyzer.setFgPhase(0);
        inOutAnalyzer.setFgSubPhase(2);
        inOutAnalyzer.analyzeBackward(null, null, null);
        inOutAnalyzer.setCurUnitEtc(null);
        BoolVector paramVarsFromDataFlow = readVars.minus(modifiedVars);
        BoolVector stateVarsFromDataFlow = modifiedVars.minus(unusedAfterLoopVars);
        int nDZ = symbolTable.declaredZonesNb(0);
        int[] map = DataFlowAnalyzer.makeMap3(0, 0, nDZ);
        paramVars.setFalse();
        TapList<Tree> stateVarsList = null;
        TapList<Tree> paramVarsList = null;
        TapList<Object> altStateVarsList = null;
        for (int i = DataFlowAnalyzer.mapSize(map) - 1; i >= 0; --i) {
            boolean isState = stateVarsFromDataFlow.get(i);
            boolean isParam = paramVarsFromDataFlow.get(i);
            if (!isState && !isParam) continue;
            int zoneClass = DataFlowAnalyzer.getMapClass(i, map);
            ZoneInfo zi = DataFlowAnalyzer.vectorIndexToZoneInfo(i, zoneClass, 0, map, symbolTable);
            if (zi.realZoneNb < 0) continue;
            int diffIndex = DataFlowAnalyzer.zoneInfoToVectorIndex(zi, zoneClass, this.adEnv.diffKind, diffMap, null);
            Tree accessTree = ILUtils.stripArrayAccesses(zi.accessTree);
            if (isState) {
                stateVarsList = new TapList<Tree>(accessTree, stateVarsList);
            }
            if (isParam) {
                paramVarsList = new TapList<Tree>(accessTree, paramVarsList);
            }
            if (this.adEnv.traceCurDifferentiation) {
                System.out.println("Index (r)" + zi.realZoneNb + (isState ? " state" : "") + (isParam ? " param" : "") + " for Zone " + zi + " diffIndex:" + diffIndex);
            }
            if (stateVarsFromDirective.get(diffIndex)) {
                if (!modifiedVars.get(i)) {
                    TapEnv.fileWarning(5, loopHeader.lastInstr().tree, "(AD27) Variable " + accessTree + " is only read, therefore possibly should not be a state variable of this FIXEDPOINT loop");
                }
            } else if (isState) {
                TapEnv.fileWarning(5, loopHeader.lastInstr().tree, "(AD26) Variable " + accessTree + " is overwritten, therefore possibly should be a state variable of this FIXEDPOINT loop");
                if (!stateGiven) {
                    altStateVarsList = new TapList<Tree>(accessTree, altStateVarsList);
                    stateVarsFromDirective.set(diffIndex, true);
                }
            }
            if (!isParam) continue;
            paramVars.set(diffIndex, true);
        }
        if (this.adEnv.traceCurDifferentiation) {
            System.out.println("State variables from data-flow: " + stateVarsList);
            System.out.println("Param variables from data-flow: " + paramVarsList);
        }
        if (!stateGiven) {
            TapEnv.fileWarning(5, loopHeader.lastInstr().tree, "(AD26) taking default state variables: " + altStateVarsList);
            Tree[] treeArray = new Tree[TapList.length(altStateVarsList)];
            int index = 0;
            while (altStateVarsList != null) {
                treeArray[index] = (Tree)altStateVarsList.head;
                altStateVarsList = altStateVarsList.tail;
                ++index;
            }
            toAltStateVarsArray.setObj(treeArray);
        }
    }

    private TapList<Tree> collectActiveUsesOfParameters(TapList<Block> blocksInsideLoop, BoolVector parameterZones, int[] diffMap, TapList<Tree> paramUses) {
        while (blocksInsideLoop != null) {
            Block fpBlock = (Block)blocksInsideLoop.head;
            TapList<Instruction> fpInstrs = fpBlock.instructions;
            SymbolTable fpSymbolTable = fpBlock.symbolTable;
            while (fpInstrs != null) {
                paramUses = this.collectActiveUsesOfParameters(((Instruction)fpInstrs.head).tree, (Instruction)fpInstrs.head, fpSymbolTable, parameterZones, diffMap, paramUses);
                fpInstrs = fpInstrs.tail;
            }
            blocksInsideLoop = blocksInsideLoop.tail;
        }
        return paramUses;
    }

    private TapList<Tree> collectActiveUsesOfParameters(Tree tree, Instruction instr, SymbolTable symbolTable, BoolVector parameterZones, int[] diffMap, TapList<Tree> paramUses) {
        switch (tree.opCode()) {
            case 31: {
                ActivityPattern curCalledActivity = (ActivityPattern)ActivityPattern.getAnnotationForActivityPattern(tree, this.adEnv.curActivity(), "multiActivityCalleePatterns");
                Unit calledUnit = DataFlowAnalyzer.getCalledUnit(tree, symbolTable);
                Tree[] actualArgs = ILUtils.getArguments(tree).children();
                boolean[] formalArgsActivity = ADActivityAnalyzer.formalArgsActivity(curCalledActivity);
                if (formalArgsActivity != null) {
                    for (int i = actualArgs.length - 1; i >= 0; --i) {
                        Tree argTree = actualArgs[i];
                        int argTreeOpCode = argTree.opCode();
                        if (!formalArgsActivity[i]) continue;
                        if (!(calledUnit.isIntrinsic() || argTreeOpCode != 96 && argTreeOpCode != 9 && argTreeOpCode != 75 && argTreeOpCode != 151)) {
                            TapIntList argZones = symbolTable.listOfZonesOfValue(argTree, null, instr);
                            if (!parameterZones.intersects(argZones = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(argZones, this.adEnv.diffKind, diffMap, symbolTable, null)) || TapList.containsTree(paramUses, argTree)) continue;
                            paramUses = new TapList<Tree>(argTree, paramUses);
                            continue;
                        }
                        paramUses = this.collectActiveUsesOfParameters(argTree, instr, symbolTable, parameterZones, diffMap, paramUses);
                    }
                }
                if (curCalledActivity != null) {
                    BoolVector formalCallActive = new BoolVector(symbolTable.freeDeclaredZone(this.adEnv.diffKind));
                    TapList[] formalArgsEntryActive = DataFlowAnalyzer.propagateDataToCaller(curCalledActivity.callActivity(), null, null, actualArgs.length, formalCallActive, diffMap, null, instr, CallGraph.getCallArrow(this.adEnv.curUnit(), calledUnit), true, true, this.adEnv.diffKind);
                    formalCallActive.cumulAnd(parameterZones);
                    for (int i = symbolTable.freeDeclaredZone(this.adEnv.diffKind) - 1; i >= 0; --i) {
                        if (!formalCallActive.get(i)) continue;
                        ZoneInfo zi = symbolTable.declaredZoneInfo(i, this.adEnv.diffKind);
                        Tree accessTree = ILUtils.stripArrayAccesses(zi.accessTree);
                        if (TapList.containsTree(paramUses, accessTree)) continue;
                        paramUses = new TapList<Tree>(accessTree, paramUses);
                    }
                }
                return paramUses;
            }
            case 14: 
            case 152: {
                return this.collectActiveUsesOfParameters(tree.down(2), instr, symbolTable, parameterZones, diffMap, paramUses);
            }
            case 9: 
            case 75: 
            case 96: 
            case 151: {
                TapIntList treeZones = symbolTable.listOfZonesOfValue(tree, null, instr);
                treeZones = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(treeZones, this.adEnv.diffKind, diffMap, symbolTable, null);
                if (parameterZones.intersects(treeZones) && ADActivityAnalyzer.isAnnotatedActive(this.adEnv.curActivity(), tree, symbolTable) && !TapList.containsTree(paramUses, tree)) {
                    paramUses = new TapList<Tree>(tree, paramUses);
                }
                return paramUses;
            }
            case 3: 
            case 42: 
            case 62: 
            case 126: 
            case 133: 
            case 155: 
            case 182: {
                paramUses = this.collectActiveUsesOfParameters(tree.down(1), instr, symbolTable, parameterZones, diffMap, paramUses);
                return this.collectActiveUsesOfParameters(tree.down(2), instr, symbolTable, parameterZones, diffMap, paramUses);
            }
            case 17: {
                paramUses = this.collectActiveUsesOfParameters(tree.down(1), instr, symbolTable, parameterZones, diffMap, paramUses);
                return this.collectActiveUsesOfParameters(tree.down(3), instr, symbolTable, parameterZones, diffMap, paramUses);
            }
            case 10: 
            case 27: 
            case 54: 
            case 60: 
            case 71: 
            case 181: {
                Tree[] exps;
                for (Tree exp : exps = tree.children()) {
                    paramUses = this.collectActiveUsesOfParameters(exp, instr, symbolTable, parameterZones, diffMap, paramUses);
                }
                return paramUses;
            }
            case 4: {
                return this.collectActiveUsesOfParameters(tree.down(1), instr, symbolTable, parameterZones, diffMap, paramUses);
            }
            case 124: {
                return this.collectActiveUsesOfParameters(tree.down(1), instr, symbolTable, parameterZones, diffMap, paramUses);
            }
            case 32: 
            case 134: 
            case 168: 
            case 194: {
                return this.collectActiveUsesOfParameters(tree.down(2), instr, symbolTable, parameterZones, diffMap, paramUses);
            }
            case 47: 
            case 199: {
                return this.collectActiveUsesOfParameters(tree.down(3), instr, symbolTable, parameterZones, diffMap, paramUses);
            }
            case 2: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 35: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 49: 
            case 51: 
            case 52: 
            case 59: 
            case 64: 
            case 67: 
            case 68: 
            case 69: 
            case 74: 
            case 78: 
            case 91: 
            case 92: 
            case 94: 
            case 95: 
            case 98: 
            case 99: 
            case 101: 
            case 103: 
            case 104: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 115: 
            case 116: 
            case 118: 
            case 121: 
            case 122: 
            case 129: 
            case 135: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 143: 
            case 154: 
            case 160: 
            case 161: 
            case 169: 
            case 171: 
            case 176: 
            case 177: 
            case 179: 
            case 180: 
            case 184: 
            case 192: 
            case 195: 
            case 197: 
            case 202: 
            case 204: 
            case 205: 
            case 207: {
                return paramUses;
            }
        }
        TapEnv.toolWarning(-1, "(Collect differentiable parameter uses) Unexpected operator: " + tree.opName());
        return paramUses;
    }

    private void computeLocalActivity(FlowGraphLevel portion, BoolVector removedIndeps, TapPair<TapList<BoolVector>, TapList<BoolVector>> portionMemo) {
        int width;
        TapList blocksInsideLoop = portion.allBlocksInside();
        TapList<FGArrow> entryFrontier = portion.entryArrows;
        TapList exitFrontier = portion.exitArrows;
        TapList entryActivities = (TapList)portionMemo.first;
        TapList exitActivities = (TapList)portionMemo.second;
        this.activityAnalyzer().setCurUnitEtc(this.adEnv.curUnit());
        BoolVector variedEntries = null;
        while (entryFrontier != null) {
            BoolVector entryVector = (BoolVector)entryActivities.head;
            width = ((FGArrow)entryFrontier.head).commonSymbolTable().declaredZonesNb(this.adEnv.diffKind);
            if (variedEntries == null) {
                variedEntries = entryVector.copy(width, width);
            } else {
                variedEntries.cumulOr(entryVector, width);
            }
            entryActivities = entryActivities.tail;
            entryFrontier = entryFrontier.tail;
        }
        if (removedIndeps != null) {
            variedEntries.cumulMinus(removedIndeps);
        }
        entryFrontier = portion.entryArrows;
        BlockStorage<TapList<BoolVector>> curUnitVariednesses = this.adEnv.curActivity().activities();
        this.activityAnalyzer().setPhaseVaried(variedEntries, curUnitVariednesses);
        this.activityAnalyzer().analyzeForward(entryFrontier, blocksInsideLoop, exitFrontier);
        BoolVector usefulExits = null;
        while (exitFrontier != null) {
            BoolVector exitVector = (BoolVector)exitActivities.head;
            width = ((FGArrow)exitFrontier.head).commonSymbolTable().declaredZonesNb(this.adEnv.diffKind);
            if (usefulExits == null) {
                usefulExits = exitVector.copy(width, width);
            } else {
                usefulExits.cumulOr(exitVector, width);
            }
            exitActivities = exitActivities.tail;
            exitFrontier = exitFrontier.tail;
        }
        exitFrontier = portion.exitArrows;
        BlockStorage<TapList<BoolVector>> curUnitUsefulnesses = this.adEnv.curActivity().usefulnesses();
        this.activityAnalyzer().setPhaseUseful(usefulExits, curUnitUsefulnesses);
        this.activityAnalyzer().analyzeBackward(entryFrontier, blocksInsideLoop, exitFrontier);
        this.activityAnalyzer().reMergeAndAnnotate(blocksInsideLoop, this.adEnv.curActivity());
    }

    private void saveRestoreDiffRefExpression(Tree refExpr, Block storeBlock, Block restoreBlock, SymbolTable symbolTable, SymbolTable diffSymbolTable, IterDescriptor multiDirIterDescriptor) {
        Tree diffRefBase = ILUtils.baseTree(this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), refExpr, diffSymbolTable, false, refExpr, false, true, refExpr));
        RefDescriptor refDescriptor = new RefDescriptor(refExpr, null, symbolTable, diffSymbolTable, null, diffRefBase, true, multiDirIterDescriptor, this.curDiffUnit());
        WrapperTypeSpec refType = refDescriptor.completeType;
        NewSymbolHolder saveVarHolder = new NewSymbolHolder("diffparam_save");
        saveVarHolder.setAsVariable(refType, null);
        saveVarHolder.declarationLevelMustInclude(storeBlock.symbolTable);
        saveVarHolder.declarationLevelMustInclude(restoreBlock.symbolTable);
        Tree saveVarRef = saveVarHolder.makeNewRef(diffSymbolTable);
        RefDescriptor saveVarRefDescriptor = new RefDescriptor(saveVarRef, null, refType, null, diffSymbolTable, this.curDiffUnit().privateSymbolTable(), storeBlock.symbolTable, null, false, null, this.curDiffUnit());
        refDescriptor.forceStaticSave(saveVarRefDescriptor);
        refDescriptor.prepareForAssignOrNormDiff(saveVarRefDescriptor, this.curDiffUnit(), null, true);
        storeBlock.addInstrHdAfterDecls(refDescriptor.makePush());
        restoreBlock.addInstrHdAfterDecls(refDescriptor.makePop());
    }

    private void fillSnapshotInstructions(BoolVector sbk, BoolVector snp, int[] map3, BoolVector sbkOnDiffPtr, BoolVector snpOnDiffPtr, int[] map3OnDiffPtr, Block sourceBlock, TapList<Block> pushBlocks, TapList<Block> popBlocks, TapList<Block> popBackBlocks, boolean inJointDiffCode) {
        int zoneCase;
        ZoneInfo zoneInfo;
        SymbolTable sourceSymbolTable = sourceBlock.symbolTable;
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printlnOnTrace("   Filling snapshot instructions for SNP:" + DataFlowAnalyzer.infoToStringWithDiffPtr(snp, map3, snpOnDiffPtr, map3OnDiffPtr, this.adEnv.curUnit(), sourceSymbolTable) + " SBK:" + DataFlowAnalyzer.infoToStringWithDiffPtr(sbk, map3, sbkOnDiffPtr, map3OnDiffPtr, this.adEnv.curUnit(), sourceSymbolTable) + " into Blocks " + pushBlocks + popBlocks + popBackBlocks);
        }
        int nDZ = sourceSymbolTable.declaredZonesNb(0);
        boolean saveRestoreIO = false;
        TapList<Object> hdSnpOnly = new TapList<Object>(null, null);
        TapList<Object> hdSnpSbk = new TapList<Object>(null, null);
        TapList<Object> hdSbkOnly = new TapList<Object>(null, null);
        TapList<Object> tlSnpOnly = hdSnpOnly;
        TapList<Object> tlSnpSbk = hdSnpSbk;
        TapList<Object> tlSbkOnly = hdSbkOnly;
        for (int i = nDZ - 1; i >= 0; --i) {
            boolean sbkDiffPtr;
            zoneInfo = sourceSymbolTable.declaredZoneInfo(i, 0);
            if (zoneInfo == null) continue;
            int rk = DataFlowAnalyzer.zoneInfoToVectorIndex(zoneInfo, 3, 0, map3, null);
            boolean snpPrimal = snp != null && snp.get(rk);
            boolean sbkPrimal = sbk != null && sbk.get(rk);
            int rkOnDiffPtr = DataFlowAnalyzer.zoneInfoToVectorIndex(zoneInfo, 3, 3, map3OnDiffPtr, null);
            boolean snpDiffPtr = rkOnDiffPtr > 0 && snpOnDiffPtr != null && snpOnDiffPtr.get(rkOnDiffPtr);
            boolean bl = sbkDiffPtr = rkOnDiffPtr > 0 && sbkOnDiffPtr != null && sbkOnDiffPtr.get(rkOnDiffPtr);
            if (!snpPrimal && !sbkPrimal && !snpDiffPtr && !sbkDiffPtr) continue;
            if (zoneInfo.zoneNb == this.adEnv.srcCallGraph().zoneNbOfAllIOStreams) {
                saveRestoreIO = true;
                continue;
            }
            if (zoneInfo.isHidden) {
                if (zoneInfo.comesFromAllocate() || this.adEnv.srcCallGraph().isAMessagePassingChannelZone(zoneInfo.zoneNb)) continue;
                TapEnv.fileWarning(15, sourceBlock.lastInstr().tree, "(AD14) Checkpointing this piece of code needs to save " + ((snpDiffPtr || sbkDiffPtr) && !snpPrimal && !sbkPrimal ? "the derivative of " : "") + "a hidden variable: " + zoneInfo.description + (!(!snpDiffPtr && !sbkDiffPtr || !snpPrimal && !sbkPrimal) ? " and its derivative" : ""));
                this.adEnv.addInHiddenPushPopVariables(zoneInfo);
                continue;
            }
            if (snpPrimal) {
                if (sbkPrimal) {
                    if (snpDiffPtr) {
                        if (sbkDiffPtr) {
                            tlSnpSbk = tlSnpSbk.placdl(new TapPair<ZoneInfo, Integer>(zoneInfo, 0));
                            continue;
                        }
                        tlSnpSbk = tlSnpSbk.placdl(new TapPair<ZoneInfo, Integer>(zoneInfo, 1));
                        tlSnpOnly = tlSnpOnly.placdl(new TapPair<ZoneInfo, Integer>(zoneInfo, -1));
                        continue;
                    }
                    if (sbkDiffPtr) {
                        tlSnpSbk = tlSnpSbk.placdl(new TapPair<ZoneInfo, Integer>(zoneInfo, 1));
                        tlSbkOnly = tlSbkOnly.placdl(new TapPair<ZoneInfo, Integer>(zoneInfo, -1));
                        continue;
                    }
                    tlSnpSbk = tlSnpSbk.placdl(new TapPair<ZoneInfo, Integer>(zoneInfo, 1));
                    continue;
                }
                if (snpDiffPtr) {
                    if (sbkDiffPtr) {
                        tlSnpOnly = tlSnpOnly.placdl(new TapPair<ZoneInfo, Integer>(zoneInfo, 1));
                        tlSnpSbk = tlSnpSbk.placdl(new TapPair<ZoneInfo, Integer>(zoneInfo, -1));
                        continue;
                    }
                    tlSnpOnly = tlSnpOnly.placdl(new TapPair<ZoneInfo, Integer>(zoneInfo, 0));
                    continue;
                }
                if (sbkDiffPtr) {
                    tlSnpOnly = tlSnpOnly.placdl(new TapPair<ZoneInfo, Integer>(zoneInfo, 1));
                    tlSbkOnly = tlSbkOnly.placdl(new TapPair<ZoneInfo, Integer>(zoneInfo, -1));
                    continue;
                }
                tlSnpOnly = tlSnpOnly.placdl(new TapPair<ZoneInfo, Integer>(zoneInfo, 1));
                continue;
            }
            if (sbkPrimal) {
                if (snpDiffPtr) {
                    if (sbkDiffPtr) {
                        tlSbkOnly = tlSbkOnly.placdl(new TapPair<ZoneInfo, Integer>(zoneInfo, 1));
                        tlSnpSbk = tlSnpSbk.placdl(new TapPair<ZoneInfo, Integer>(zoneInfo, -1));
                        continue;
                    }
                    tlSbkOnly = tlSbkOnly.placdl(new TapPair<ZoneInfo, Integer>(zoneInfo, 1));
                    tlSnpOnly = tlSnpOnly.placdl(new TapPair<ZoneInfo, Integer>(zoneInfo, -1));
                    continue;
                }
                if (sbkDiffPtr) {
                    tlSbkOnly = tlSbkOnly.placdl(new TapPair<ZoneInfo, Integer>(zoneInfo, 0));
                    continue;
                }
                tlSbkOnly = tlSbkOnly.placdl(new TapPair<ZoneInfo, Integer>(zoneInfo, 1));
                continue;
            }
            if (snpDiffPtr) {
                if (sbkDiffPtr) {
                    tlSnpSbk = tlSnpSbk.placdl(new TapPair<ZoneInfo, Integer>(zoneInfo, -1));
                    continue;
                }
                tlSnpOnly = tlSnpOnly.placdl(new TapPair<ZoneInfo, Integer>(zoneInfo, -1));
                continue;
            }
            if (!sbkDiffPtr) continue;
            tlSbkOnly = tlSbkOnly.placdl(new TapPair<ZoneInfo, Integer>(zoneInfo, -1));
        }
        if (saveRestoreIO) {
            TapEnv.fileWarning(15, sourceBlock.lastInstr().tree, "(AD07) Checkpointing this piece of code needs to save the I-O state");
        }
        hdSnpOnly = hdSnpOnly.tail;
        while (hdSnpOnly != null) {
            zoneInfo = (ZoneInfo)((TapPair)hdSnpOnly.head).first;
            zoneCase = (Integer)((TapPair)hdSnpOnly.head).second;
            this.placePushPopLookOfZone(zoneInfo, zoneCase >= 0, false, zoneCase <= 0, false, sourceBlock, 0, pushBlocks, popBlocks, null, inJointDiffCode, null);
            hdSnpOnly = hdSnpOnly.tail;
        }
        hdSnpSbk = hdSnpSbk.tail;
        if (hdSnpSbk != null) {
            Block popBlock;
            TapIntList hdRanksInPopBlocks;
            TapList<Block> inPopBlocks = popBlocks;
            TapIntList tlRanksInPopBlocks = hdRanksInPopBlocks = new TapIntList(-1, null);
            while (inPopBlocks != null) {
                popBlock = (Block)inPopBlocks.head;
                tlRanksInPopBlocks = tlRanksInPopBlocks.placdl(TapList.length(popBlock.instructions));
                inPopBlocks = inPopBlocks.tail;
            }
            ToBool reallyNeedsToLook = new ToBool(false);
            while (hdSnpSbk != null) {
                zoneInfo = (ZoneInfo)((TapPair)hdSnpSbk.head).first;
                zoneCase = (Integer)((TapPair)hdSnpSbk.head).second;
                this.placePushPopLookOfZone(zoneInfo, zoneCase >= 0, zoneCase >= 0, zoneCase <= 0, zoneCase <= 0, sourceBlock, 0, pushBlocks, popBlocks, popBackBlocks, inJointDiffCode, reallyNeedsToLook);
                hdSnpSbk = hdSnpSbk.tail;
            }
            if (reallyNeedsToLook.get()) {
                inPopBlocks = popBlocks;
                TapIntList ranksOfStartRepeat = hdRanksInPopBlocks.tail;
                while (inPopBlocks != null) {
                    popBlock = (Block)inPopBlocks.head;
                    int rankOfStartRepeat = ranksOfStartRepeat.head;
                    popBlock.addInstructionAt(ILUtils.buildCall(ILUtils.build(96, "adStack_startRepeat"), ILUtils.build(71)), rankOfStartRepeat);
                    popBlock.addInstrTl(ILUtils.buildCall(ILUtils.build(96, "adStack_resetRepeat"), ILUtils.build(71)));
                    popBlock.addInstrTl(ILUtils.buildCall(ILUtils.build(96, "adStack_endRepeat"), ILUtils.build(71)));
                    inPopBlocks = inPopBlocks.tail;
                    ranksOfStartRepeat = ranksOfStartRepeat.tail;
                }
            }
        }
        hdSbkOnly = hdSbkOnly.tail;
        while (hdSbkOnly != null) {
            zoneInfo = (ZoneInfo)((TapPair)hdSbkOnly.head).first;
            zoneCase = (Integer)((TapPair)hdSbkOnly.head).second;
            this.placePushPopLookOfZone(zoneInfo, false, zoneCase >= 0, false, zoneCase <= 0, sourceBlock, 0, pushBlocks, null, popBackBlocks, inJointDiffCode, null);
            hdSbkOnly = hdSbkOnly.tail;
        }
    }

    private void fillBinomialCheckpoint(BoolVector ckp, int[] map3, BoolVector ckpOnDiffPtr, int[] map3OnDiffPtr, Block sourceBlock, Block pushBlock, Block lookBlock, Block popBlock, boolean inJointDiffCode) {
        SymbolTable sourceSymbolTable = sourceBlock.symbolTable;
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printlnOnTrace("   Filling binomial snapshot instructions for CKP:" + DataFlowAnalyzer.infoToStringWithDiffPtr(ckp, map3, ckpOnDiffPtr, map3OnDiffPtr, this.adEnv.curUnit(), sourceSymbolTable) + " into Blocks " + pushBlock + ";" + lookBlock + ";" + popBlock);
        }
        int nDZ = sourceSymbolTable.declaredZonesNb(0);
        boolean saveRestoreIO = false;
        ToBool reallyNeedsToLook = new ToBool(false);
        for (int i = nDZ - 1; i >= 0; --i) {
            boolean ckpDiffPtr;
            ZoneInfo zoneInfo = sourceSymbolTable.declaredZoneInfo(i, 0);
            if (zoneInfo == null) continue;
            int rk = DataFlowAnalyzer.zoneInfoToVectorIndex(zoneInfo, 3, 0, map3, null);
            boolean ckpPrimal = ckp != null && ckp.get(rk);
            int rkOnDiffPtr = DataFlowAnalyzer.zoneInfoToVectorIndex(zoneInfo, 3, 3, map3OnDiffPtr, null);
            boolean canHaveDiff = TypeSpec.isDifferentiableType(zoneInfo.type) && zoneInfo.isOnceActive();
            boolean bl = ckpDiffPtr = canHaveDiff && ckpOnDiffPtr != null && rkOnDiffPtr > 0 && ckpOnDiffPtr.get(rkOnDiffPtr);
            if (!ckpPrimal && !ckpDiffPtr) continue;
            if (zoneInfo.zoneNb == this.adEnv.srcCallGraph().zoneNbOfAllIOStreams) {
                saveRestoreIO = true;
                continue;
            }
            if (zoneInfo.isHidden) {
                if (zoneInfo.comesFromAllocate() || this.adEnv.srcCallGraph().isAMessagePassingChannelZone(zoneInfo.zoneNb)) continue;
                TapEnv.fileWarning(15, sourceBlock.lastInstr().tree, "(AD14) Binomial checkpointing of this piece of code needs to save " + (ckpDiffPtr && !ckpPrimal ? "the derivative of " : "") + "a hidden variable: " + zoneInfo.description + (ckpDiffPtr && ckpPrimal ? " and its derivative" : ""));
                this.adEnv.addInHiddenPushPopVariables(zoneInfo);
                continue;
            }
            if (!ckp.get(i)) continue;
            this.placePushPopLookOfZone(zoneInfo, ckpPrimal, ckpPrimal, ckpDiffPtr, ckpDiffPtr, sourceBlock, 2, new TapList<Block>(pushBlock, null), new TapList<Block>(lookBlock, null), new TapList<Block>(popBlock, null), inJointDiffCode, reallyNeedsToLook);
        }
        if (lookBlock.instructions != null && reallyNeedsToLook.get()) {
            lookBlock.addInstrHd(ILUtils.buildCall(ILUtils.build(96, "adStack_startRepeat"), ILUtils.build(71)));
            lookBlock.addInstrTl(ILUtils.buildCall(ILUtils.build(96, "adStack_resetRepeat"), ILUtils.build(71)));
            lookBlock.addInstrTl(ILUtils.buildCall(ILUtils.build(96, "adStack_endRepeat"), ILUtils.build(71)));
        }
        if (saveRestoreIO) {
            TapEnv.fileWarning(15, sourceBlock.lastInstr().tree, "(AD07) Binomial checkpointing of this piece of code needs to save the I-O state");
        }
    }

    private void placePushPopLookOfZone(ZoneInfo zoneInfo, boolean onPrimal1, boolean onPrimal2, boolean onDiffPtr1, boolean onDiffPtr2, Block sourceBlock, int knownMultiplicity, TapList<Block> pushBlocks, TapList<Block> popBlocks1, TapList<Block> popBlocks2, boolean inJointDiffCode, ToBool reallyNeedsToLook) {
        if (!(zoneInfo.isHidden || zoneInfo.isChannelOrIO || zoneInfo.isControl() || zoneInfo.isAllocatable || zoneInfo.comesFromAllocate())) {
            Tree zoneInfoVisibleAccessTree = sourceBlock.symbolTable.buildZoneVisibleAccessTree(zoneInfo);
            if (zoneInfoVisibleAccessTree == null) {
                TapEnv.fileWarning(10, null, "(ADxx) Can not access for push/pop " + zoneInfo);
            } else {
                Tree restoreTree;
                TapList<Block> inBlocks;
                Tree fwdDiffBaseVar = null;
                Tree bwdDiffBaseVar = null;
                RefDescriptor bwdRefDescriptor = null;
                SymbolTable pushingSymbolTable = ((Block)pushBlocks.head).symbolTable;
                SymbolTable poppingSymbolTable = ((Block)(popBlocks1 != null ? popBlocks1 : popBlocks2).head).symbolTable;
                if (onDiffPtr1 || onDiffPtr2) {
                    Tree baseVarTree = ILUtils.baseTree(zoneInfoVisibleAccessTree);
                    fwdDiffBaseVar = this.varRefDifferentiator().diffSymbolTree(this.adEnv.curActivity(), baseVarTree, pushingSymbolTable, true, false, false, null, false, this.curDiffVarSort(), this.curDiffUnitSort(), 0, baseVarTree);
                    bwdDiffBaseVar = this.varRefDifferentiator().diffSymbolTree(this.adEnv.curActivity(), baseVarTree, poppingSymbolTable, true, false, false, null, false, this.curDiffVarSort(), this.curDiffUnitSort(), 0, baseVarTree);
                }
                if (onPrimal1 || onPrimal2) {
                    RefDescriptor fwdRefDescriptor = new RefDescriptor(zoneInfo, zoneInfoVisibleAccessTree, sourceBlock.symbolTable, this.curFwdDiffUnit().privateSymbolTable(), null, null, false, null, this.curFwdDiffUnit());
                    bwdRefDescriptor = new RefDescriptor(zoneInfo, zoneInfoVisibleAccessTree, sourceBlock.symbolTable, this.curDiffUnit().privateSymbolTable(), null, null, false, null, this.curDiffUnit());
                    this.adEnv.setCurBlock(sourceBlock);
                    this.blockDifferentiator().prepareRestoreOperations(fwdRefDescriptor, bwdRefDescriptor, knownMultiplicity, pushingSymbolTable, poppingSymbolTable);
                    inBlocks = pushBlocks;
                    while (inBlocks != null) {
                        ((Block)inBlocks.head).addInstrHdAfterDecls(fwdRefDescriptor.makePush());
                        inBlocks = inBlocks.tail;
                    }
                    if (onPrimal1) {
                        inBlocks = popBlocks1;
                        while (inBlocks != null) {
                            bwdRefDescriptor.toBranchVariable = this.toBranchVariable;
                            restoreTree = bwdRefDescriptor.makePop();
                            if (reallyNeedsToLook != null && !bwdRefDescriptor.usesStaticSave()) {
                                reallyNeedsToLook.set(true);
                            }
                            ((Block)inBlocks.head).addInstrTl(restoreTree);
                            inBlocks = inBlocks.tail;
                        }
                    }
                    if (onPrimal2) {
                        inBlocks = popBlocks2;
                        while (inBlocks != null) {
                            bwdRefDescriptor.toBranchVariable = this.toBranchVariable;
                            restoreTree = bwdRefDescriptor.makePop();
                            ((Block)inBlocks.head).addInstrTl(restoreTree);
                            inBlocks = inBlocks.tail;
                        }
                    }
                }
                if (onDiffPtr1 || onDiffPtr2) {
                    NewSymbolHolder fwdDiffSymbolHolder = NewSymbolHolder.getNewSymbolHolder(fwdDiffBaseVar);
                    RefDescriptor fwdRefDescriptorOnDiff = new RefDescriptor(zoneInfo, zoneInfoVisibleAccessTree, sourceBlock.symbolTable, this.curFwdDiffUnit().privateSymbolTable(), null, fwdDiffBaseVar, true, null, this.curFwdDiffUnit());
                    NewSymbolHolder bwdDiffSymbolHolder = NewSymbolHolder.getNewSymbolHolder(bwdDiffBaseVar);
                    RefDescriptor bwdRefDescriptorOnDiff = new RefDescriptor(zoneInfo, zoneInfoVisibleAccessTree, sourceBlock.symbolTable, this.curDiffUnit().privateSymbolTable(), null, fwdDiffBaseVar, true, null, this.curDiffUnit());
                    this.adEnv.setCurBlock(sourceBlock);
                    this.blockDifferentiator().prepareRestoreOperations(fwdRefDescriptorOnDiff, bwdRefDescriptorOnDiff, knownMultiplicity, pushingSymbolTable, poppingSymbolTable);
                    inBlocks = pushBlocks;
                    while (inBlocks != null) {
                        fwdDiffSymbolHolder.declarationLevelMustInclude(((Block)inBlocks.head).symbolTable);
                        ((Block)inBlocks.head).addInstrHdAfterDecls(fwdRefDescriptorOnDiff.makePush());
                        inBlocks = inBlocks.tail;
                    }
                    if (onDiffPtr1) {
                        inBlocks = popBlocks1;
                        while (inBlocks != null) {
                            bwdDiffSymbolHolder.declarationLevelMustInclude(((Block)inBlocks.head).symbolTable);
                            bwdRefDescriptorOnDiff.toBranchVariable = this.toBranchVariable;
                            restoreTree = bwdRefDescriptorOnDiff.makePop();
                            if (reallyNeedsToLook != null && !bwdRefDescriptorOnDiff.usesStaticSave()) {
                                reallyNeedsToLook.set(true);
                            }
                            ((Block)inBlocks.head).addInstrTl(restoreTree);
                            inBlocks = inBlocks.tail;
                        }
                    }
                    if (onDiffPtr2) {
                        inBlocks = popBlocks2;
                        while (inBlocks != null) {
                            bwdDiffSymbolHolder.declarationLevelMustInclude(((Block)inBlocks.head).symbolTable);
                            bwdRefDescriptorOnDiff.toBranchVariable = this.toBranchVariable;
                            restoreTree = bwdRefDescriptorOnDiff.makePop();
                            ((Block)inBlocks.head).addInstrTl(restoreTree);
                            inBlocks = inBlocks.tail;
                        }
                    }
                }
                if (zoneInfo.ptrZoneNb != -1) {
                    Tree rebaseTree;
                    Tree refTree;
                    ++this.blockDifferentiator().numRebase;
                    Instruction firstInstruction = sourceBlock.headInstr();
                    if (onPrimal1 || onDiffPtr1) {
                        boolean rebaseDiffPtr1;
                        refTree = bwdRefDescriptor.refTree();
                        boolean rebasePrimal1 = onPrimal1 && DataFlowAnalyzer.mayPointToRelocated(refTree, false, firstInstruction, sourceBlock.symbolTable, inJointDiffCode);
                        boolean bl = rebaseDiffPtr1 = onDiffPtr1 && DataFlowAnalyzer.mayPointToRelocated(refTree, true, firstInstruction, sourceBlock.symbolTable, inJointDiffCode);
                        if (rebasePrimal1 || rebaseDiffPtr1) {
                            this.adEnv.usesADMM = true;
                            inBlocks = popBlocks1;
                            while (inBlocks != null) {
                                rebaseTree = bwdRefDescriptor.makeRebase(rebasePrimal1 ? null : new TapList<Boolean>(Boolean.TRUE, null), rebaseDiffPtr1 ? null : new TapList<Boolean>(Boolean.TRUE, null), rebaseDiffPtr1 ? bwdDiffBaseVar : null, TapEnv.debugAdMode() == -1 || TapEnv.debugADMM() ? this.blockDifferentiator().numRebase : -1);
                                if (rebaseTree != null) {
                                    ((Block)inBlocks.head).addInstrTl(rebaseTree);
                                }
                                inBlocks = inBlocks.tail;
                            }
                        }
                    }
                    if (onPrimal2 || onDiffPtr2) {
                        boolean rebaseDiffPtr2;
                        refTree = bwdRefDescriptor.refTree();
                        boolean rebasePrimal2 = onPrimal2 && DataFlowAnalyzer.mayPointToRelocated(refTree, false, firstInstruction, sourceBlock.symbolTable, inJointDiffCode);
                        boolean bl = rebaseDiffPtr2 = onDiffPtr2 && DataFlowAnalyzer.mayPointToRelocated(refTree, true, firstInstruction, sourceBlock.symbolTable, inJointDiffCode);
                        if (rebasePrimal2 || rebaseDiffPtr2) {
                            this.adEnv.usesADMM = true;
                            inBlocks = popBlocks2;
                            while (inBlocks != null) {
                                rebaseTree = bwdRefDescriptor.makeRebase(rebasePrimal2 ? null : new TapList<Boolean>(Boolean.TRUE, null), rebaseDiffPtr2 ? null : new TapList<Boolean>(Boolean.TRUE, null), rebaseDiffPtr2 ? bwdDiffBaseVar : null, TapEnv.debugAdMode() == -1 || TapEnv.debugADMM() ? this.blockDifferentiator().numRebase : -1);
                                if (rebaseTree != null) {
                                    ((Block)inBlocks.head).addInstrTl(rebaseTree);
                                }
                                inBlocks = inBlocks.tail;
                            }
                        }
                    }
                }
            }
        }
    }

    private void insertTangentDiffReinits(FGArrow fwdDiffArrow, FGArrow sourceArrow, SymbolTable fwdDiffSymbolTable, Block returnDangerBlock, FlowGraphDifferentiationEnv diffEnv) {
        if (diffEnv.adDiffMode == 1) {
            FGArrow activityCheckArrow = sourceArrow;
            if (!activityCheckArrow.origin.isParallelController() && activityCheckArrow.destination.isParallelController()) {
                while (activityCheckArrow.destination.isParallelController()) {
                    activityCheckArrow = (FGArrow)activityCheckArrow.destination.flow().head;
                }
            }
            this.tangentDiffReinitChecker.set(activityCheckArrow.rank, true);
            TapList<Object> toNewDeclaredInits = new TapList<Object>(null, null);
            Block diffInitBlock = this.checkActivitySwitches(activityCheckArrow.origin, activityCheckArrow.destination, fwdDiffSymbolTable, true, sourceArrow.origin, diffEnv, toNewDeclaredInits);
            if (diffInitBlock != null) {
                Instruction previousInstr;
                if (returnDangerBlock != null && sourceArrow.destination instanceof ExitBlock && (previousInstr = returnDangerBlock.lastInstr()) != null && previousInstr.tree.opCode() == 168) {
                    returnDangerBlock.removeInstr(previousInstr);
                    diffInitBlock.addInstrTl(previousInstr);
                    this.realOrigBlockOfReturns = new TapList<TapPair<Instruction, Block>>(new TapPair<Instruction, Block>(previousInstr, returnDangerBlock), this.realOrigBlockOfReturns);
                }
                if (activityCheckArrow.origin instanceof EntryBlock) {
                    Block block0 = sourceArrow.destination;
                    Block fwdDiffBlock0 = (Block)diffEnv.fwdDiffBlocks.retrieve(block0);
                    TapList<Instruction> addedInstrs = TapList.reverse(diffInitBlock.instructions);
                    while (addedInstrs != null) {
                        fwdDiffBlock0.addInstrHdAfterDecls((Instruction)addedInstrs.head);
                        addedInstrs = addedInstrs.tail;
                    }
                    diffInitBlock = null;
                    if (this.adEnv.traceCurDifferentiation) {
                        TapEnv.printlnOnTrace("      Initializations inserted directly inside " + fwdDiffBlock0);
                    }
                }
                if (diffInitBlock != null) {
                    this.insertBlockAtOrig(fwdDiffArrow, diffInitBlock, 0, 0);
                }
            }
        }
    }

    private Block createFwdDiffBlock(Block block, FlowGraphDifferentiationEnv diffEnv, boolean createAsHeader) {
        Block fwdDiffBlock;
        SymbolTable fwdDiffSymbolTable;
        if (diffEnv.adDiffMode == -2 || diffEnv.adDiffMode == -1 && TapList.contains(diffEnv.middleSymbolTables, block.symbolTable)) {
            fwdDiffSymbolTable = block.symbolTable.smartCopy(((FlowGraphDifferentiationEnv)diffEnv).diffCtxtFwd.listST, ((FlowGraphDifferentiationEnv)diffEnv).diffCtxtFwd.unit, this.adEnv.diffCallGraph(), this.adEnv.copiedUnits, "FwdDiff of ");
            block.symbolTable.cleanCopySymbolDecls();
        } else {
            fwdDiffSymbolTable = block.symbolTable.smartCopy(((FlowGraphDifferentiationEnv)diffEnv).diffCtxt.listST, ((FlowGraphDifferentiationEnv)diffEnv).diffCtxtFwd.unit, this.adEnv.diffCallGraph(), this.adEnv.copiedUnits, "Diff of ");
            block.symbolTable.cleanCopySymbolDecls();
            TapPair diffSTFwd = TapList.assq(block.symbolTable, ((FlowGraphDifferentiationEnv)diffEnv).diffCtxtFwd.listST);
            if (diffSTFwd != null && diffSTFwd.second != fwdDiffSymbolTable) {
                TapEnv.toolWarning(-1, "Bug in createFwdDiffBlock: fwdDiffSymbolTable already here");
            }
            if (TapList.assq(block.symbolTable, ((FlowGraphDifferentiationEnv)diffEnv).diffCtxtFwd.listST) == null) {
                ((FlowGraphDifferentiationEnv)diffEnv).diffCtxtFwd.listST.placdl(new TapPair<SymbolTable, SymbolTable>(block.symbolTable, fwdDiffSymbolTable));
            }
        }
        CallGraphDifferentiator.declareDiffSymbolTableIfNew(((FlowGraphDifferentiationEnv)diffEnv).diffCtxtFwd.unit, fwdDiffSymbolTable);
        if (createAsHeader) {
            HeaderBlock fwdDiffHeaderBlock = this.buildFwdHeaderBlock(block.rank + "+", fwdDiffSymbolTable, block, diffEnv);
            fwdDiffHeaderBlock.declaresItsIterator = ((HeaderBlock)block).declaresItsIterator;
            fwdDiffHeaderBlock.setOrigCycleLabel(((HeaderBlock)block).origCycleLabel());
            this.detectUnusedExitLoopIndices(fwdDiffHeaderBlock, block);
            fwdDiffBlock = fwdDiffHeaderBlock;
        } else {
            fwdDiffBlock = this.buildFwdBlock(block.rank + "+", fwdDiffSymbolTable, block, diffEnv);
        }
        if (block.symbolTable.declarationsBlock == block) {
            fwdDiffSymbolTable.declarationsBlock = fwdDiffBlock;
        }
        fwdDiffBlock.setOrigLabel(block.origLabel());
        return fwdDiffBlock;
    }

    private Block createBwdDiffBlock(Block block, FlowGraphDifferentiationEnv diffEnv, boolean createAsHeader) {
        Block diffBlock;
        if (diffEnv.adDiffMode == 1) {
            return null;
        }
        SymbolTable diffSymbolTable = block.symbolTable.smartCopy(((FlowGraphDifferentiationEnv)diffEnv).diffCtxt.listST, ((FlowGraphDifferentiationEnv)diffEnv).diffCtxt.unit, this.adEnv.diffCallGraph(), this.adEnv.copiedUnits, "Diff of ");
        block.symbolTable.cleanCopySymbolDecls();
        CallGraphDifferentiator.declareDiffSymbolTableIfNew(((FlowGraphDifferentiationEnv)diffEnv).diffCtxt.unit, diffSymbolTable);
        if (createAsHeader) {
            HeaderBlock diffHeaderBlock = this.buildBwdHeaderBlock(block.rank + "-", diffSymbolTable, block, diffEnv);
            diffHeaderBlock.declaresItsIterator = ((HeaderBlock)block).declaresItsIterator;
            diffBlock = diffHeaderBlock;
        } else {
            diffBlock = this.buildBwdBlock(block.rank + "-", diffSymbolTable, block, diffEnv);
        }
        return diffBlock;
    }

    private TapList<Instruction> bwdParallelControlsOf(TapList<Instruction> sourceParallelControls, FlowGraphDifferentiationEnv diffEnv) {
        return Unit.getSetNewParallelControls(sourceParallelControls, diffEnv.bwdDiffBlocks, diffEnv.bwdParallelControls);
    }

    private TapList<Instruction> fwdParallelControlsOf(TapList<Instruction> sourceParallelControls, FlowGraphDifferentiationEnv diffEnv) {
        return Unit.getSetNewParallelControls(sourceParallelControls, diffEnv.fwdDiffBlocks, diffEnv.fwdParallelControls);
    }

    private Block createCopyBlock(Block block, FlowGraphCopyEnv copyEnv) {
        Block copyBlock;
        SymbolTable copyDiffSymbolTable = block.symbolTable.smartCopy(((FlowGraphCopyEnv)copyEnv).copyCtxt.listST, ((FlowGraphCopyEnv)copyEnv).copyCtxt.unit, this.adEnv.diffCallGraph(), this.adEnv.copiedUnits, "Primal of ");
        block.symbolTable.cleanCopySymbolDecls();
        CallGraphDifferentiator.declareDiffSymbolTableIfNew(((FlowGraphCopyEnv)copyEnv).copyCtxt.unit, copyDiffSymbolTable);
        if (block instanceof HeaderBlock) {
            copyBlock = new HeaderBlock(copyDiffSymbolTable, null, ((FlowGraphCopyEnv)copyEnv).copyCtxt.toAllBlocks);
            copyBlock.declaresItsIterator = ((HeaderBlock)block).declaresItsIterator;
        } else {
            copyBlock = new BasicBlock(copyDiffSymbolTable, null, ((FlowGraphCopyEnv)copyEnv).copyCtxt.toAllBlocks);
        }
        if (block.symbolTable.declarationsBlock == block) {
            copyDiffSymbolTable.declarationsBlock = copyBlock;
        }
        copyBlock.symbolicRk = block.rank + "cp";
        return copyBlock;
    }

    private boolean allExitsTurn(TapList<FGArrow> exitArrows, TapList<FGArrow> turningArrows) {
        boolean allTurn = true;
        while (allTurn && exitArrows != null) {
            FGArrow nextExitArrow;
            FGArrow exitArrow = (FGArrow)exitArrows.head;
            FGArrow fGArrow = nextExitArrow = exitArrow.destination.containsNoCode() ? (FGArrow)exitArrow.destination.flow().head : null;
            if (!(TapList.contains(turningArrows, exitArrow) || nextExitArrow != null && TapList.contains(turningArrows, nextExitArrow))) {
                allTurn = false;
            }
            exitArrows = exitArrows.tail;
        }
        return allTurn;
    }

    private TapList<SymbolTable> collectMiddleSymbolTables(TapList<FGArrow> turningArrows, TapList<Block> allBlocks) {
        TapList<SymbolTable> result = null;
        SymbolTable privateSymbolTable = this.adEnv.curUnit().privateSymbolTable();
        while (allBlocks != null) {
            Block origBlock = (Block)allBlocks.head;
            SymbolTable origSymbolTable = origBlock.symbolTable;
            if (origSymbolTable != privateSymbolTable && !TapList.contains(result, origSymbolTable)) {
                TapList<FGArrow> flow = origBlock.flow();
                boolean isMiddle = false;
                while (!isMiddle && flow != null) {
                    if (!TapList.contains(turningArrows, flow.head) || ((FGArrow)flow.head).exitsFromLoopAndLoopSymbolTable()) {
                        Block destBlock = ((FGArrow)flow.head).destination;
                        SymbolTable destSymbolTable = destBlock.symbolTable;
                        if (!destSymbolTable.nestedIn(origSymbolTable)) {
                            isMiddle = true;
                        }
                    }
                    flow = flow.tail;
                }
                if (isMiddle) {
                    result = new TapList<SymbolTable>(origSymbolTable, result);
                }
            }
            allBlocks = allBlocks.tail;
        }
        return result;
    }

    private void turnVanishingLoopIntoIf(Block loopBlock) {
        Instruction loopInstr = loopBlock.headInstr();
        Tree ctrlTree = loopInstr.tree.down(3);
        loopInstr.tree = ctrlTree.opCode() == 206 ? ILUtils.build(98, ctrlTree.cutChild(1)) : ILUtils.build(138);
    }

    private Tree buildTestFromDo(Tree doTree) {
        if (doTree.down(4).opCode() == 138 || ILUtils.evalsToGEZero(doTree.down(4))) {
            return ILUtils.build(115, ILUtils.copy(doTree.down(1)), ILUtils.copy(doTree.down(3)));
        }
        if (ILUtils.evalsToLTZero(doTree.down(4))) {
            return ILUtils.build(92, ILUtils.copy(doTree.down(1)), ILUtils.copy(doTree.down(3)));
        }
        return ILUtils.build(115, ILUtils.mulTree(ILUtils.subTree(ILUtils.copy(doTree.down(1)), ILUtils.copy(doTree.down(3))), ILUtils.copy(doTree.down(4))), ILUtils.build(103, 0));
    }

    private FGArrow buildCopiedArrow(FGArrow sourceArrow, Block copyOrig, Block copyDest, Block vanishingLoopHeader) {
        int newTest = sourceArrow.test;
        TapIntList newCases = sourceArrow.cases;
        boolean newInACycle = sourceArrow.inACycle;
        if (sourceArrow.origin == vanishingLoopHeader) {
            if (((Instruction)copyOrig.instructions.head).tree.opCode() == 98) {
                newTest = 20;
                newCases = sourceArrow.containsCase(0) ? new TapIntList(5, null) : new TapIntList(2, null);
            } else {
                newTest = 0;
                if (sourceArrow.containsCase(0)) {
                    newTest = -999;
                } else {
                    newCases = null;
                }
            }
        }
        FGArrow copyArrow = null;
        if (newTest != -999) {
            copyArrow = this.checkFreeThenSetNewFGArrow(copyOrig, newTest, newCases, copyDest, newInACycle);
            copyArrow.isAJumpIntoNextCase = sourceArrow.isAJumpIntoNextCase;
        }
        return copyArrow;
    }

    private TapList<TapPair<FGArrow, TapList<BwdSwitchCase>>> exploreConvergingBackFlow(FGArrow arrow, boolean fromInside, FlowGraphLevel enclosingLevel, FlowGraphDifferentiation enclosingLevelDifferentiation, FlowGraphDifferentiationEnv diffEnv, TapList<FlowGraphDifferentiation> subDifferentiations, boolean[] arrowVisited, Block nextFwdBlock, TapList<FGArrow> nextBwdArrows) {
        TapList<Object> hdManyFwdBwds = new TapList<Object>(null, null);
        this.ecbfRec(new TapList<FGArrow>(arrow, null), fromInside, enclosingLevel, enclosingLevelDifferentiation, diffEnv, subDifferentiations, arrowVisited, new TapList<Object>(null, hdManyFwdBwds), null, arrow, arrow, nextFwdBlock, nextBwdArrows, null);
        return hdManyFwdBwds.tail;
    }

    private void ecbfRec(TapList<FGArrow> convergingArrows, boolean fromInside, FlowGraphLevel enclosingLevel, FlowGraphDifferentiation enclosingLevelDifferentiation, FlowGraphDifferentiationEnv diffEnv, TapList<FlowGraphDifferentiation> subDifferentiations, boolean[] arrowVisited, TapList<TapPair<FGArrow, TapList<BwdSwitchCase>>> toTlManyFwdBwds, TapPair<FGArrow, TapList<BwdSwitchCase>> currentOneFwdBwd, FGArrow tailArrow, FGArrow srcArrow, Block nextFwdBlock, TapList<FGArrow> nextBwdArrows, TapList<Block> sourcePath) {
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.incrTraceIndent(2);
        }
        while (convergingArrows != null) {
            FGArrow curTailArrow;
            FGArrow arrow = (FGArrow)convergingArrows.head;
            FGArrow fGArrow = curTailArrow = tailArrow != null ? tailArrow : arrow;
            if (this.adEnv.traceCurDifferentiation) {
                TapEnv.indentprintlnOnTrace("   explore through " + arrow + " (visited:" + arrowVisited[arrow.rank] + ')' + sourcePath);
            }
            if (!arrowVisited[arrow.rank]) {
                arrowVisited[arrow.rank] = true;
                FlowGraphLevel subLevel = null;
                FlowGraphDifferentiation subLevelDifferentiation = null;
                TapList manyFwdBwds = null;
                boolean subLevelIsLive = false;
                if (!fromInside || enclosingLevel.containsArrowFlow(arrow)) {
                    subLevel = enclosingLevel.getRepresentantInLevel(arrow.origin);
                }
                if (subLevel != null) {
                    subLevelDifferentiation = this.getSubLevelDifferentiation(subLevel, enclosingLevel, subDifferentiations);
                    assert (subLevelDifferentiation != null);
                    manyFwdBwds = subLevelDifferentiation.getFwdBwdsOfExitArrow(arrow);
                    subLevelIsLive = this.oneFirstIsNonNull(manyFwdBwds);
                }
                TapPair<FGArrow, TapList<BwdSwitchCase>> subLevelOneFwdBwd = currentOneFwdBwd;
                if (subLevel == null && enclosingLevelDifferentiation.specialTopFwdArrow != null) {
                    if (this.adEnv.traceCurDifferentiation) {
                        TapEnv.indentprintlnOnTrace("    jumping outside of " + enclosingLevel + " through special Fwd:" + enclosingLevelDifferentiation.specialTopFwdArrow + " and Bwd:" + enclosingLevelDifferentiation.specialTopBwdArrow);
                    }
                    if (!enclosingLevelDifferentiation.specialTopUsed) {
                        enclosingLevelDifferentiation.specialTopUsed = true;
                        FGArrow specialTopFwdArrow = enclosingLevelDifferentiation.specialTopFwdArrow;
                        FGArrow specialTopBwdArrow = enclosingLevelDifferentiation.specialTopBwdArrow;
                        if (subLevelOneFwdBwd == null) {
                            subLevelOneFwdBwd = new TapPair<Object, Object>(null, null);
                            toTlManyFwdBwds.tail = toTlManyFwdBwds.tail.placdl(subLevelOneFwdBwd);
                        }
                        if (nextFwdBlock != null) {
                            this.checkFreeThenRedirectDestination(specialTopFwdArrow, nextFwdBlock, false);
                        } else {
                            subLevelOneFwdBwd.first = specialTopFwdArrow;
                        }
                        if (specialTopBwdArrow != null) {
                            subLevelOneFwdBwd.second = TapList.addLast((TapList)subLevelOneFwdBwd.second, new BwdSwitchCase(specialTopFwdArrow, specialTopBwdArrow.origin, new TapList<Block>(enclosingLevel.entryBlock, new TapList<Block>(arrow.origin, sourcePath)), srcArrow.destination));
                            nextBwdArrows = new TapList<FGArrow>(specialTopBwdArrow, null);
                        }
                        enclosingLevelDifferentiation.accumulateFwdBwdUS(specialTopFwdArrow.origin, nextBwdArrows);
                    }
                } else if (subLevel == null) {
                    if (this.adEnv.traceCurDifferentiation) {
                        TapEnv.indentprintlnOnTrace("    jumping outside of " + enclosingLevel + " setting its connections Fwd:" + nextFwdBlock + " Bwd:" + nextBwdArrows);
                    }
                    enclosingLevelDifferentiation.accumulateFwdBwdUS(nextFwdBlock, nextBwdArrows);
                } else if (this.keepEmptyDiffBlocks || subLevelIsLive) {
                    if (this.adEnv.traceCurDifferentiation) {
                        TapEnv.indentprintlnOnTrace("    reaching differentiation of " + subLevel + " with manyFwdBwds:" + manyFwdBwds + " and nextFwdBlock:" + nextFwdBlock);
                    }
                    while (manyFwdBwds != null) {
                        FGArrow danglingFwd = (FGArrow)((TapPair)manyFwdBwds.head).first;
                        TapList subLevelBwdSwitchCases = (TapList)((TapPair)manyFwdBwds.head).second;
                        if (subLevelOneFwdBwd == null) {
                            subLevelOneFwdBwd = new TapPair<Object, Object>(null, null);
                            toTlManyFwdBwds.tail = toTlManyFwdBwds.tail.placdl(subLevelOneFwdBwd);
                        }
                        if (nextFwdBlock != null) {
                            if (danglingFwd.destination == null) {
                                this.checkFreeThenRedirectDestination(danglingFwd, nextFwdBlock, curTailArrow.inACycle);
                            }
                        } else {
                            subLevelOneFwdBwd.first = danglingFwd;
                        }
                        if (this.keepEmptyDiffBlocks && diffEnv.adDiffMode != 1 && !this.adEnv.curUnitIsContext || subLevelBwdSwitchCases != null) {
                            if (this.adEnv.traceCurDifferentiation) {
                                TapEnv.indentprintlnOnTrace("    " + subLevel + " is active with BwdSwitchCases " + subLevelBwdSwitchCases);
                            }
                            while (subLevelBwdSwitchCases != null) {
                                BwdSwitchCase subLevelBwdSwitchCase = (BwdSwitchCase)subLevelBwdSwitchCases.head;
                                subLevelBwdSwitchCase.sourceOrigPath = TapList.append(subLevelBwdSwitchCase.sourceOrigPath, sourcePath);
                                subLevelOneFwdBwd.second = TapList.addLast((TapList)subLevelOneFwdBwd.second, subLevelBwdSwitchCase);
                                subLevelBwdSwitchCases = subLevelBwdSwitchCases.tail;
                            }
                        } else {
                            this.ecbfRec(subLevel.entryArrows, true, enclosingLevel, enclosingLevelDifferentiation, diffEnv, subDifferentiations, arrowVisited, toTlManyFwdBwds, subLevelOneFwdBwd, null, srcArrow, subLevelDifferentiation.fwdBlockUS, nextBwdArrows, new TapList<Block>(subLevel.entryBlock, new TapList<Block>(arrow.origin, sourcePath)));
                        }
                        manyFwdBwds = manyFwdBwds.tail;
                    }
                } else {
                    this.ecbfRec(subLevel.entryArrows, true, enclosingLevel, enclosingLevelDifferentiation, diffEnv, subDifferentiations, arrowVisited, toTlManyFwdBwds, subLevelOneFwdBwd, curTailArrow, srcArrow, nextFwdBlock, nextBwdArrows, new TapList<Block>(subLevel.entryBlock, new TapList<Block>(arrow.origin, sourcePath)));
                }
            }
            convergingArrows = convergingArrows.tail;
        }
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.decrTraceIndent(2);
        }
    }

    private FlowGraphDifferentiation getSubLevelDifferentiation(FlowGraphLevel subLevel, FlowGraphLevel enclosingLevel, TapList<FlowGraphDifferentiation> subDifferentiations) {
        FlowGraphDifferentiation result = null;
        TapList<FlowGraphLevel> subLevels = new TapList<FlowGraphLevel>(enclosingLevel.entryPoint, enclosingLevel.contents);
        while (subLevels != null && result == null) {
            if (subLevels.head == subLevel) {
                result = (FlowGraphDifferentiation)subDifferentiations.head;
            }
            subDifferentiations = subDifferentiations.tail;
            subLevels = subLevels.tail;
        }
        return result;
    }

    private boolean sameUniqueBwdDestAndSameActivitySwitches(TapList<TapPair<FGArrow, TapList<TapPair<FGArrow, TapList<BwdSwitchCase>>>>> arrowsFwdBwds1, TapList<TapPair<FGArrow, TapList<TapPair<FGArrow, TapList<BwdSwitchCase>>>>> arrowsFwdBwds2) {
        if (arrowsFwdBwds1.tail == null && arrowsFwdBwds2.tail == null) {
            TapList manyFwdBwds1 = (TapList)((TapPair)arrowsFwdBwds1.head).second;
            TapList manyFwdBwds2 = (TapList)((TapPair)arrowsFwdBwds2.head).second;
            if (manyFwdBwds1.tail == null && manyFwdBwds2.tail == null) {
                TapPair oneFwdBwd1 = (TapPair)manyFwdBwds1.head;
                TapPair oneFwdBwd2 = (TapPair)manyFwdBwds2.head;
                if (oneFwdBwd1 != null && oneFwdBwd2 != null) {
                    TapList bwdSwitchCases1 = (TapList)oneFwdBwd1.second;
                    TapList bwdSwitchCases2 = (TapList)oneFwdBwd2.second;
                    if (bwdSwitchCases1 != null && bwdSwitchCases1.tail == null && bwdSwitchCases2 != null && bwdSwitchCases2.tail == null) {
                        return ((BwdSwitchCase)bwdSwitchCases1.head).bwdBlock == ((BwdSwitchCase)bwdSwitchCases2.head).bwdBlock && this.sameActivitySwitches((Block)((BwdSwitchCase)((BwdSwitchCase)bwdSwitchCases1.head)).sourceOrigPath.head, (FGArrow)((TapPair)arrowsFwdBwds1.head).first, (FGArrow)((TapPair)arrowsFwdBwds2.head).first);
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private void mapConnectFwdBwd(TapList<TapPair<FGArrow, TapList<TapPair<FGArrow, TapList<BwdSwitchCase>>>>> arrowsFwdBwdsUpstream, FlowGraphDifferentiationEnv diffEnv, FlowGraphLevel enclosingLevel) {
        while (arrowsFwdBwdsUpstream != null) {
            TapPair arrowFwdBwds = (TapPair)arrowsFwdBwdsUpstream.head;
            TapList manyFwdBwds = (TapList)arrowFwdBwds.second;
            while (manyFwdBwds != null) {
                TapPair oneFwdBwd = (TapPair)manyFwdBwds.head;
                if (oneFwdBwd != null) {
                    PushPopNode pushPopTree = this.buildFwdBwdTreeFromOneFwdBwd((FGArrow)oneFwdBwd.first, (TapList)oneFwdBwd.second);
                    this.connectFwdBwd(pushPopTree, null, null, ((FGArrow)arrowFwdBwds.first).destination, null, diffEnv, enclosingLevel);
                }
                manyFwdBwds = manyFwdBwds.tail;
            }
            arrowsFwdBwdsUpstream = arrowsFwdBwdsUpstream.tail;
        }
    }

    private void connectFwdBwd(PushPopNode pushPopTree, Block blockFwdDownstream, TapList<FGArrow> arrowsBwdDownstream, Block sourceDest, Tree doIndexToSave, FlowGraphDifferentiationEnv diffEnv, FlowGraphLevel enclosingLevel) {
        if (pushPopTree != null) {
            boolean deferDeclAndRestore;
            if (this.adEnv.traceCurDifferentiation && blockFwdDownstream == null && arrowsBwdDownstream == null) {
                TapEnv.indentprintlnOnTrace("*> This is a TURN point (connects FWD to BWD)");
            }
            DownstreamConnector center = new DownstreamConnector(blockFwdDownstream, sourceDest, arrowsBwdDownstream, null);
            boolean bl = deferDeclAndRestore = arrowsBwdDownstream != null && blockFwdDownstream == null;
            if (enclosingLevel.levelKind == 14 && ((FlowGraphLevel)enclosingLevel).entryBlock.headInstr().tree.opCode() == 145) {
                deferDeclAndRestore = true;
            }
            if (this.adEnv.traceCurDifferentiation) {
                TapEnv.indentprintOnTrace("*> before turn binary : ");
                TapEnv.incrTraceIndent(24);
                pushPopTree.dump(new TapList<Object>(null, null));
                TapEnv.printlnOnTrace();
                TapEnv.decrTraceIndent(24);
            }
            this.turnPushPopTreeBinary(pushPopTree);
            if (this.adEnv.traceCurDifferentiation) {
                TapEnv.indentprintOnTrace("*> Connect pushPopTree: ");
                TapEnv.incrTraceIndent(24);
                pushPopTree.dump(new TapList<Object>(null, null));
                TapEnv.printlnOnTrace(" which has " + pushPopTree.numberOfCases + " cases,");
                TapEnv.decrTraceIndent(24);
                TapEnv.indentprintlnOnTrace("   " + (center.isATurn ? "TURNING" : "") + " THROUGH " + center);
                TapEnv.incrTraceIndent(2);
            }
            this.connectPushPopTree(pushPopTree, center, deferDeclAndRestore, enclosingLevel, -1, 0, diffEnv, null, -1, doIndexToSave, doIndexToSave == null ? -1 : TapEnv.getNewPushPopNumber());
            if (this.adEnv.traceCurDifferentiation) {
                TapEnv.decrTraceIndent(2);
            }
        }
    }

    private PushPopNode buildFwdBwdTreeFromOneFwdBwd(FGArrow danglingFwd, TapList<BwdSwitchCase> bwdSwitchCases) {
        PushPopNode result = new PushPopNode(null, null, null, this.curDiffUnit().publicSymbolTable(), null, null, null);
        this.insertIntoPushPopTree(result, danglingFwd, bwdSwitchCases);
        return result;
    }

    private PushPopNode buildFwdBwdTreeFromExitFwdBwd(TapList<TapPair<FGArrow, TapList<TapPair<FGArrow, TapList<BwdSwitchCase>>>>> arrowsFwdBwds) {
        PushPopNode result = new PushPopNode(null, null, null, this.curDiffUnit().publicSymbolTable(), null, null, null);
        while (arrowsFwdBwds != null) {
            TapList manyFwdBwds = (TapList)((TapPair)arrowsFwdBwds.head).second;
            while (manyFwdBwds != null) {
                TapPair oneFwdBwd = (TapPair)manyFwdBwds.head;
                this.insertIntoPushPopTree(result, (FGArrow)oneFwdBwd.first, (TapList)oneFwdBwd.second);
                manyFwdBwds = manyFwdBwds.tail;
            }
            arrowsFwdBwds = arrowsFwdBwds.tail;
        }
        return result;
    }

    private void insertIntoPushPopTree(PushPopNode pushPopNode, FGArrow danglingFwd, TapList<BwdSwitchCase> bwdSwitchCases) {
        SymbolTable commonRoot = pushPopNode.bwdScope;
        while (bwdSwitchCases != null) {
            PushPopNode currentNode = pushPopNode;
            BwdSwitchCase oneBwdSwitchCase = (BwdSwitchCase)bwdSwitchCases.head;
            if (((BwdSwitchCase)oneBwdSwitchCase).bwdBlock.symbolTable == commonRoot && danglingFwd != null && oneBwdSwitchCase.fwdArrow != danglingFwd) {
                currentNode = this.getInsertDanglingFwdInPushPopTree(danglingFwd, currentNode);
            }
            TapList<SymbolTable> bwdStList = ((BwdSwitchCase)oneBwdSwitchCase).bwdBlock.symbolTable.allSymbolTableRoots(commonRoot);
            while (bwdStList != null) {
                currentNode = this.getInsertScopeNodeInPushPopTree((SymbolTable)bwdStList.head, currentNode);
                if (danglingFwd != null && oneBwdSwitchCase.fwdArrow != danglingFwd && bwdStList.head == ((BwdSwitchCase)oneBwdSwitchCase).bwdBlock.symbolTable) {
                    currentNode = this.getInsertDanglingFwdInPushPopTree(danglingFwd, currentNode);
                }
                bwdStList = bwdStList.tail;
            }
            this.insertOneBwdSwitchCaseInPushPopTree(oneBwdSwitchCase, currentNode);
            bwdSwitchCases = bwdSwitchCases.tail;
        }
    }

    private PushPopNode getInsertScopeNodeInPushPopTree(SymbolTable newScope, PushPopNode pushPopTree) {
        TapList subTrees = pushPopTree.subNodes;
        PushPopNode foundNode = null;
        while (subTrees != null && foundNode == null) {
            if (((PushPopNode)subTrees.head).bwdScope == newScope) {
                foundNode = (PushPopNode)subTrees.head;
            }
            subTrees = subTrees.tail;
        }
        if (foundNode == null) {
            foundNode = new PushPopNode(null, null, null, newScope, null, null, null);
            pushPopTree.subNodes = new TapList<PushPopNode>(foundNode, pushPopTree.subNodes);
        }
        return foundNode;
    }

    private PushPopNode getInsertDanglingFwdInPushPopTree(FGArrow danglingFwd, PushPopNode pushPopTree) {
        TapList subTrees = pushPopTree.subNodes;
        PushPopNode foundNode = null;
        while (subTrees != null && foundNode == null) {
            if (TapList.contains(((PushPopNode)subTrees.head).fwdArrows, danglingFwd)) {
                foundNode = (PushPopNode)subTrees.head;
            }
            subTrees = subTrees.tail;
        }
        if (foundNode == null) {
            foundNode = new PushPopNode(new TapList<FGArrow>(danglingFwd, null), null, null, null, null, null, null);
            pushPopTree.subNodes = new TapList<PushPopNode>(foundNode, pushPopTree.subNodes);
        }
        return foundNode;
    }

    private void insertOneBwdSwitchCaseInPushPopTree(BwdSwitchCase oneBwdSwitchCase, PushPopNode pushPopTree) {
        TapList subTrees = pushPopTree.subNodes;
        PushPopNode foundNode = null;
        while (subTrees != null && foundNode == null) {
            if (((PushPopNode)subTrees.head).bwdBlock == oneBwdSwitchCase.bwdBlock) {
                foundNode = (PushPopNode)subTrees.head;
            }
            subTrees = subTrees.tail;
        }
        if (foundNode == null) {
            Block bwdBlock = oneBwdSwitchCase.bwdBlock;
            foundNode = new PushPopNode(null, bwdBlock, oneBwdSwitchCase, bwdBlock.symbolTable, oneBwdSwitchCase.sourceOrigPath, null, null);
            pushPopTree.subNodes = new TapList<PushPopNode>(foundNode, pushPopTree.subNodes);
        }
        if (!TapList.contains(foundNode.fwdArrows, oneBwdSwitchCase.fwdArrow)) {
            foundNode.fwdArrows = new TapList<FGArrow>(oneBwdSwitchCase.fwdArrow, foundNode.fwdArrows);
        }
        if (foundNode.sourceDest == null) {
            foundNode.sourceDest = oneBwdSwitchCase.sourceDest;
        }
    }

    private void turnPushPopTreeBinary(PushPopNode pushPopTree) {
        TapList subNodes = pushPopTree.subNodes;
        while (subNodes != null) {
            this.turnPushPopTreeBinary((PushPopNode)subNodes.head);
            subNodes = subNodes.tail;
        }
        pushPopTree.subNodes = this.turnPushPopSubNodesBinary(pushPopTree.subNodes, pushPopTree.bwdScope);
        pushPopTree.computeNumberOfCases();
    }

    private TapList<PushPopNode> turnPushPopSubNodesBinary(TapList<PushPopNode> subNodes, SymbolTable scope) {
        int len = TapList.length(subNodes);
        if (len <= 2) {
            return subNodes;
        }
        TapList<PushPopNode> inSubNodes = subNodes;
        for (int i = len / 2; i > 1; --i) {
            inSubNodes = inSubNodes.tail;
        }
        TapList<PushPopNode> secondHalf = inSubNodes.tail;
        inSubNodes.tail = null;
        PushPopNode node1 = TapList.length(subNodes) == 1 ? (PushPopNode)subNodes.head : new PushPopNode(null, null, null, scope, null, null, this.turnPushPopSubNodesBinary(subNodes, scope));
        node1.computeNumberOfCases();
        PushPopNode node2 = TapList.length(secondHalf) == 1 ? (PushPopNode)secondHalf.head : new PushPopNode(null, null, null, scope, null, null, this.turnPushPopSubNodesBinary(secondHalf, scope));
        node2.computeNumberOfCases();
        return new TapList<PushPopNode>(node1, new TapList<PushPopNode>(node2, null));
    }

    private void connectPushPopTree(PushPopNode pushPopTree, DownstreamConnector center, boolean deferDeclAndRestore, FlowGraphLevel enclosingLevel, int offset, int totalNumberOfCases, FlowGraphDifferentiationEnv diffEnv, RefDescriptor branchSaveVarRefDescriptor, int ppLabel, Tree doIndexToSave, int ppLabelForIndex) {
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.indentprintOnTrace("[Knct:");
            TapEnv.incrTraceIndent(6);
            pushPopTree.dump(new TapList<Object>(null, null));
            TapEnv.decrTraceIndent(6);
            TapEnv.printlnOnTrace();
            TapEnv.indentprintlnOnTrace(" THROUGH " + center + " ; Save do index:" + doIndexToSave);
            TapEnv.incrTraceIndent(1);
        }
        Block sourceDest = center.sourceBlock;
        TapList fwdArrows = pushPopTree.fwdArrows;
        if (fwdArrows != null) {
            if (center.entry == null || this.naturalLoopHeader != null && pushPopTree.sourceDest != this.naturalLoopHeader) {
                if (center.exits == null) {
                    center.exits = fwdArrows;
                }
            } else {
                while (fwdArrows != null) {
                    FGArrow fwdArrow = (FGArrow)fwdArrows.head;
                    if (fwdArrow.destination == null) {
                        this.checkFreeThenRedirectDestination(fwdArrow, center.entry, false);
                    }
                    if (doIndexToSave != null) {
                        Block pushIndexBlock = this.buildFwdBlock("+PushIndex", ((DownstreamConnector)center).entry.symbolTable, center.sourceBlock, diffEnv);
                        pushIndexBlock.addInstrHdAfterDecls(RefDescriptor.makePush(this.curFwdDiffUnit(), ILUtils.copy(doIndexToSave), sourceDest.symbolTable, ((DownstreamConnector)center).entry.symbolTable, ppLabelForIndex));
                        this.insertBlockAtOrig(fwdArrow, pushIndexBlock, 0, 0);
                    }
                    fwdArrows = fwdArrows.tail;
                }
                TapList centerExits = center.exits;
                SymbolTable minST = null;
                while (centerExits != null) {
                    SymbolTable newST = ((FGArrow)centerExits.head).origin.symbolTable;
                    minST = minST == null ? newST : minST.getCommonRoot(newST);
                    centerExits = centerExits.tail;
                }
                center.bwdScope = minST;
                if (doIndexToSave != null) {
                    Block popIndexBlock = this.buildBwdBlock("-PopIndex", center.bwdScope, center.sourceBlock, diffEnv);
                    popIndexBlock.addInstrTl(RefDescriptor.makePop(this.curDiffUnit(), ILUtils.copy(doIndexToSave), sourceDest.symbolTable, center.bwdScope, ppLabelForIndex, this.toBranchVariable));
                    this.mapCheckFreeThenRedirectDestination(center.exits, popIndexBlock, false);
                    center.exits = new TapList<FGArrow>(this.checkFreeThenSetNewFGArrow(popIndexBlock, 0, 0, null, false), null);
                }
            }
        }
        TapList centerExits = center.exits;
        SymbolTable minST = null;
        while (centerExits != null) {
            SymbolTable newST = ((FGArrow)centerExits.head).origin.symbolTable;
            minST = minST == null ? newST : minST.getCommonRoot(newST);
            centerExits = centerExits.tail;
        }
        center.bwdScope = minST;
        if (!deferDeclAndRestore && center.bwdScope != null && pushPopTree.bwdScope != null && !center.bwdScope.nestedIn(pushPopTree.bwdScope)) {
            Block localDeclBlock = ((PushPopNode)pushPopTree).bwdScope.declarationsBlock;
            if (localDeclBlock != null) {
                if (localDeclBlock.flow() == null) {
                    localDeclBlock.symbolicRk = "declBlockOf@" + Integer.toHexString(pushPopTree.bwdScope.hashCode());
                    ((FlowGraphDifferentiationEnv)diffEnv).diffCtxt.toAllBlocks.placdl(localDeclBlock);
                    center.putBlockAtTail(localDeclBlock);
                    center.putArrowAtTail(0, 0);
                } else {
                    Instruction headInstr = sourceDest == null ? null : sourceDest.headInstr();
                    TapEnv.fileWarning(15, headInstr == null ? null : headInstr.tree, "(AD22) Irreducible exits from the same scope in procedure " + this.adEnv.curUnit().name());
                }
            }
            center.bwdScope = pushPopTree.bwdScope;
        }
        if (pushPopTree.subNodes == null) {
            if (pushPopTree.fwdArrows != null && pushPopTree.bwdBlock != null) {
                boolean deferReinit;
                SymbolTable fwdBwdSharedSymbolTable;
                SymbolTable passByValueSymbolTable;
                Block sourceOrig;
                TapList sourceOrigPath = pushPopTree.sourceOrigPath;
                Block sourceOrigForSaveLocals = sourceOrig = (Block)sourceOrigPath.head;
                FlowGraphLevel upstreamLevel = enclosingLevel.getRepresentantInLevel(sourceOrig);
                if (upstreamLevel.levelKind == 6) {
                    sourceOrigForSaveLocals = upstreamLevel.entryBlock;
                }
                int[] sourceTBRMap = DataFlowAnalyzer.makeMap3(this.adEnv.curUnit(), sourceOrig, 0);
                int[] sourceTBRMapOnDiffPtr = DataFlowAnalyzer.makeMap3(this.adEnv.curUnit(), sourceOrig, 3);
                if (sourceDest == null) {
                    sourceDest = pushPopTree.sourceDest;
                }
                if (sourceDest == null) {
                    sourceDest = (Block)TapList.last(sourceOrigPath);
                }
                fwdArrows = pushPopTree.fwdArrows;
                SymbolTable fwdOrigBlockSymbolTable = ((FGArrow)fwdArrows.head).origin.symbolTable;
                SymbolTable symbolTable = passByValueSymbolTable = this.adEnv.curUnit().isC() && (!center.isATurn || fwdOrigBlockSymbolTable != ((PushPopNode)pushPopTree).bwdBlock.symbolTable) && sourceDest == this.adEnv.curUnit().exitBlock() ? this.adEnv.curUnit().publicSymbolTable() : null;
                if (center.isATurn) {
                    for (fwdBwdSharedSymbolTable = sourceOrigForSaveLocals.symbolTable; fwdBwdSharedSymbolTable != this.adEnv.curUnit().publicSymbolTable() && !((PushPopNode)pushPopTree).bwdBlock.symbolTable.nestedIn((SymbolTable)TapList.cassq(fwdBwdSharedSymbolTable, ((FlowGraphDifferentiationEnv)diffEnv).diffCtxtFwd.listST)); fwdBwdSharedSymbolTable = fwdBwdSharedSymbolTable.basisSymbolTable()) {
                    }
                } else {
                    fwdBwdSharedSymbolTable = sourceDest.symbolTable.getCommonRoot(sourceOrigForSaveLocals.symbolTable);
                }
                BoolVector constantZones = passByValueSymbolTable == null ? null : this.adEnv.curUnit().entryBlock().constantZones;
                boolean mustSaveLocals = !deferDeclAndRestore && !this.adEnv.curActivity().isContext() && diffEnv.adDiffMode != 1 && this.mustSaveLocalsBeforeTheyVanish(sourceOrigForSaveLocals, sourceDest, fwdBwdSharedSymbolTable, sourceTBRMap, sourceTBRMapOnDiffPtr, passByValueSymbolTable, constantZones);
                RefDescriptor branchVarRefDescriptor = new RefDescriptor(ILUtils.build(103, offset), null, fwdOrigBlockSymbolTable, fwdOrigBlockSymbolTable, null, null, false, null, this.curDiffUnit());
                if (!TapEnv.get().staticTape && (TapEnv.multithreadAnalyzer() == null || !TapEnv.multithreadAnalyzer().isGPU(this.adEnv.curUnit())) || diffEnv.adDiffMode == -2 || branchSaveVarRefDescriptor == null) {
                    branchVarRefDescriptor.makeFixedControl(totalNumberOfCases);
                    branchVarRefDescriptor.prepareForStack(this.curDiffUnit(), ppLabel, null, true);
                } else {
                    branchVarRefDescriptor.forceStaticSave(branchSaveVarRefDescriptor);
                    branchVarRefDescriptor.prepareForAssignOrNormDiff(branchSaveVarRefDescriptor, this.curDiffUnit(), null, true);
                }
                TapList<Block> pushLocalsBlocks = null;
                Block parallelControlRef = sourceDest;
                if (sourceDest.parallelControls == null && sourceOrig.parallelControls != null && !ILUtils.isCudaController(((Instruction)sourceOrig.parallelControls.head).tree)) {
                    parallelControlRef = sourceOrig;
                }
                while (fwdArrows != null) {
                    FGArrow fwdChain = (FGArrow)fwdArrows.head;
                    if (mustSaveLocals) {
                        Block pushLocalsBlock = this.buildFwdBlock("+PushLocals", fwdOrigBlockSymbolTable, parallelControlRef, diffEnv);
                        pushLocalsBlocks = new TapList<Block>(pushLocalsBlock, pushLocalsBlocks);
                        this.insertBlockAtOrig(fwdChain, pushLocalsBlock, 0, 0);
                    }
                    if (totalNumberOfCases >= 2) {
                        Block setBranchBlock = this.buildFwdBlock("+PushBranch", fwdOrigBlockSymbolTable, parallelControlRef, diffEnv);
                        setBranchBlock.addInstrTl(branchVarRefDescriptor.makePush());
                        this.insertBlockAtOrig(fwdChain, setBranchBlock, 0, 0);
                    }
                    fwdArrows = fwdArrows.tail;
                }
                Block bwdSweepEntry = pushPopTree.bwdBlock;
                boolean bl = deferReinit = upstreamLevel != null && upstreamLevel.levelKind == 6;
                if (!deferReinit && diffEnv.adDiffMode != 1) {
                    bwdSweepEntry = this.placeChainOfDiffReinits(sourceOrigPath, sourceDest, bwdSweepEntry, diffEnv);
                }
                BoolVector zonesToTurn = this.adEnv.curActivity().zonesMPIiReceived();
                int zonesToTurnLength = this.adEnv.curActivity().zonesMPIiReceivedLength();
                int[] diffTurnMap = DataFlowAnalyzer.makeMap3(this.adEnv.curUnit(), sourceOrig, this.adEnv.diffKind);
                if (diffTurnMap[3] > zonesToTurnLength) {
                    diffTurnMap[3] = zonesToTurnLength;
                }
                if (center.isATurn && (this.adEnv.adDiffMode == -1 || this.adEnv.adDiffMode == -2) && !zonesToTurn.isFalse(DataFlowAnalyzer.mapSize(diffTurnMap))) {
                    Block ampiTurnsBlock = this.buildBwdBlock("-AMPITurns", bwdSweepEntry.symbolTable, sourceDest, diffEnv);
                    this.placeAMPITurns(zonesToTurn, diffTurnMap, ampiTurnsBlock, sourceOrig.symbolTable, diffEnv);
                    this.checkFreeThenSetNewFGArrow(ampiTurnsBlock, 0, 0, bwdSweepEntry, false);
                    bwdSweepEntry = ampiTurnsBlock;
                }
                if (mustSaveLocals) {
                    Block popLocalsBlock = this.buildBwdBlock("-PopLocals", bwdSweepEntry.symbolTable, parallelControlRef, diffEnv);
                    if (!this.adEnv.curUnitIsContext) {
                        this.saveLocalsBeforeTheyVanish(sourceOrigForSaveLocals, sourceDest, fwdBwdSharedSymbolTable, sourceTBRMap, sourceTBRMapOnDiffPtr, pushLocalsBlocks, popLocalsBlock, passByValueSymbolTable, constantZones, diffEnv.adDiffMode == -1);
                    }
                    this.checkFreeThenSetNewFGArrow(popLocalsBlock, 0, 0, bwdSweepEntry, false);
                    bwdSweepEntry = popLocalsBlock;
                }
                if (center.exits != null) {
                    this.mapCheckFreeThenRedirectDestination(center.exits, bwdSweepEntry, false);
                    bwdSweepEntry = center.entry != null ? center.entry : ((FGArrow)((DownstreamConnector)center).exits.head).origin;
                }
                if (bwdSweepEntry != null) {
                    fwdArrows = pushPopTree.fwdArrows;
                    while (fwdArrows != null) {
                        if (((FGArrow)fwdArrows.head).destination == null) {
                            this.checkFreeThenRedirectDestination((FGArrow)fwdArrows.head, bwdSweepEntry, false);
                        }
                        fwdArrows = fwdArrows.tail;
                    }
                }
            }
        } else {
            if (pushPopTree.bwdBlock != null) {
                center.putBlockAtTail(pushPopTree.bwdBlock);
                center.putArrowAtTail(0, 0);
            }
            if (center.exits == null || diffEnv.adDiffMode == 1) {
                TapList inSubNodes = pushPopTree.subNodes;
                while (inSubNodes != null) {
                    this.connectPushPopTree((PushPopNode)inSubNodes.head, new DownstreamConnector(center), deferDeclAndRestore, enclosingLevel, -1, 0, diffEnv, null, -1, doIndexToSave, ppLabelForIndex);
                    inSubNodes = inSubNodes.tail;
                }
            } else if (((PushPopNode)pushPopTree).subNodes.tail == null) {
                this.connectPushPopTree((PushPopNode)((PushPopNode)pushPopTree).subNodes.head, center, deferDeclAndRestore, enclosingLevel, offset, totalNumberOfCases, diffEnv, branchSaveVarRefDescriptor, ppLabel, doIndexToSave, ppLabelForIndex);
            } else {
                boolean popHere;
                boolean bl = popHere = offset == -1;
                if (diffEnv.adDiffMode != 1) {
                    Tree branchVarRef;
                    if (sourceDest == null) {
                        sourceDest = pushPopTree.pickFirstSourceDest();
                    }
                    if (popHere) {
                        SymbolTable fwdST = null;
                        if (center.entry != null) {
                            fwdST = ((DownstreamConnector)center).entry.symbolTable;
                        }
                        branchSaveVarRefDescriptor = this.blockDifferentiator().tryStaticTape(sourceDest, 0, "ad_branch", this.adEnv.integerTypeSpec, fwdST, center.bwdScope);
                        offset = 0;
                        totalNumberOfCases = pushPopTree.numberOfCases;
                    }
                    if (this.toBranchVariable.first == null) {
                        this.toBranchVariable.first = new NewSymbolHolder("branch", this.curDiffUnit(), (WrapperTypeSpec)this.toBranchVariable.second, -1);
                    }
                    ((NewSymbolHolder)this.toBranchVariable.first).declarationLevelMustInclude(this.curDiffUnit().privateSymbolTable());
                    ((NewSymbolHolder)this.toBranchVariable.first).preparePrivateClause(sourceDest, this.adEnv.curUnit().privateSymbolTable(), false, false);
                    if (branchSaveVarRefDescriptor != null) {
                        branchSaveVarRefDescriptor.prepareForInitialize(this.curDiffUnit(), null, true);
                        branchVarRef = branchSaveVarRefDescriptor.makeRef();
                    } else {
                        ppLabel = TapEnv.getNewPushPopNumber();
                        branchVarRef = ((NewSymbolHolder)this.toBranchVariable.first).makeNewRef(center.bwdScope);
                        ((NewSymbolHolder)this.toBranchVariable.first).declarationLevelMustInclude(center.bwdScope);
                    }
                    Block bwdIfBlock = this.buildBwdBlock(popHere ? "-PopSwPop" : "-SwPop", center.bwdScope, sourceDest, diffEnv);
                    int cutRank = ((PushPopNode)((PushPopNode)pushPopTree).subNodes.head).numberOfCases;
                    Tree test = cutRank == 1 ? ILUtils.build(68, branchVarRef, ILUtils.build(103, offset)) : ILUtils.build(122, branchVarRef, ILUtils.build(103, offset + cutRank));
                    bwdIfBlock.addInstrHdAfterDecls(ILUtils.build(98, test));
                    if (popHere && branchSaveVarRefDescriptor == null) {
                        bwdIfBlock.addInstrHdAfterDecls(RefDescriptor.makeFixedControlPop(this.curDiffUnit(), ((NewSymbolHolder)this.toBranchVariable.first).makeNewRef(center.bwdScope), totalNumberOfCases, center.bwdScope, center.bwdScope, ppLabel));
                        ((NewSymbolHolder)this.toBranchVariable.first).declarationLevelMustInclude(center.bwdScope);
                    }
                    center.putBlockAtTail(bwdIfBlock);
                    DownstreamConnector centerLeft = new DownstreamConnector(center);
                    centerLeft.putArrowAtTail(20, 2);
                    this.connectPushPopTree((PushPopNode)((PushPopNode)pushPopTree).subNodes.head, centerLeft, deferDeclAndRestore, enclosingLevel, offset, totalNumberOfCases, diffEnv, branchSaveVarRefDescriptor, ppLabel, doIndexToSave, ppLabelForIndex);
                    DownstreamConnector centerRight = new DownstreamConnector(center);
                    centerRight.putArrowAtTail(20, 5);
                    this.connectPushPopTree((PushPopNode)((PushPopNode)pushPopTree).subNodes.tail.head, centerRight, deferDeclAndRestore, enclosingLevel, offset + cutRank, totalNumberOfCases, diffEnv, branchSaveVarRefDescriptor, ppLabel, doIndexToSave, ppLabelForIndex);
                }
            }
        }
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.decrTraceIndent(1);
            TapEnv.indentprintlnOnTrace("]K");
        }
    }

    private void saveLocalsBeforeTheyVanish(Block origBlock, Block destBlock, SymbolTable sharedSymbolTable, int[] sourceTBRMap, int[] sourceTBRMapOnDiffPtr, TapList<Block> pushBlocks, Block popBlock, SymbolTable passByValueSymbolTable, BoolVector constantZones, boolean inJointDiffCode) {
        ZoneInfo zoneInfo;
        int i;
        BoolVector tbrAtTheEndOnDiffPtr;
        BoolVector tbrAtTheEnd;
        TapList<TapPair<BoolVector, BoolVector>> origBlockTbr = origBlock.rank == -99 ? ((TemporaryBlock)origBlock).blockTBRs : (this.adEnv.unitTBRs == null ? null : this.adEnv.unitTBRs.retrieve(origBlock));
        TapPair<BoolVector, BoolVector> tbrPairAtTheEnd = TapList.last(origBlockTbr);
        BoolVector boolVector = tbrAtTheEnd = tbrPairAtTheEnd == null ? null : (BoolVector)tbrPairAtTheEnd.first;
        if (!TapEnv.doTBR() && tbrAtTheEnd == null) {
            tbrAtTheEnd = new BoolVector(DataFlowAnalyzer.mapSize(sourceTBRMap));
            tbrAtTheEnd.setTrue();
        }
        if (origBlock.parallelControls != null && destBlock.parallelControls == null && ILUtils.isIdent(((Instruction)origBlock.parallelControls.head).tree.down(1), "omp", false)) {
            Block parallelRegionBlock = TapList.last(origBlock.parallelControls).block;
            BoolVector tbrBeforeRegion = (BoolVector)((TapPair)this.adEnv.unitTBRs.retrieve((Block)parallelRegionBlock).head).first;
            BoolVector sharedZones = TapEnv.multithreadAnalyzer().getSharedZonesOfBlock(parallelRegionBlock);
            tbrAtTheEnd = tbrAtTheEnd.and(sharedZones).or(tbrBeforeRegion.minus(sharedZones));
        }
        BoolVector boolVector2 = tbrAtTheEndOnDiffPtr = tbrPairAtTheEnd == null ? null : (BoolVector)tbrPairAtTheEnd.second;
        if (!TapEnv.doTBR() && tbrAtTheEndOnDiffPtr == null) {
            tbrAtTheEndOnDiffPtr = new BoolVector(DataFlowAnalyzer.mapSize(sourceTBRMapOnDiffPtr));
            tbrAtTheEndOnDiffPtr.setTrue();
        }
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printlnOnTrace("Save vanishing locals from " + origBlock + " to " + destBlock);
            TapEnv.printlnOnTrace("  TBR:" + DataFlowAnalyzer.infoToStringWithDiffPtr(tbrAtTheEnd, sourceTBRMap, tbrAtTheEndOnDiffPtr, sourceTBRMapOnDiffPtr, this.adEnv.curUnit(), origBlock.symbolTable));
        }
        SymbolTable origSymbolTable = origBlock.symbolTable;
        int maxDeclZonesNb = origSymbolTable.declaredZonesNb(0);
        TapList<ZoneInfo> vanishingZones = null;
        if (passByValueSymbolTable != null) {
            for (i = passByValueSymbolTable.firstDeclaredZone(0); i < passByValueSymbolTable.declaredZonesNb(0); ++i) {
                zoneInfo = passByValueSymbolTable.declaredZoneInfo(i, 0);
                if (zoneInfo == null || zoneInfo.isResult() || zoneInfo.isHidden || zoneInfo.targetZoneOf != null || zoneInfo.isControl() || constantZones.get(i)) continue;
                vanishingZones = new TapList<ZoneInfo>(zoneInfo, vanishingZones);
            }
        }
        for (i = sharedSymbolTable.declaredZonesNb(0); i < maxDeclZonesNb; ++i) {
            zoneInfo = origSymbolTable.declaredZoneInfo(i, 0);
            if (zoneInfo == null || zoneInfo.isHidden || zoneInfo.isAllocatable || zoneInfo.isConstant() || zoneInfo.isControl() || this.curDiffUnit().isC() && zoneInfo.isResult()) continue;
            vanishingZones = new TapList<ZoneInfo>(zoneInfo, vanishingZones);
        }
        while (vanishingZones != null) {
            Block pushBlock;
            TapList<Block> inPushBlocks;
            int ppLabelForLocalVar;
            zoneInfo = (ZoneInfo)vanishingZones.head;
            i = zoneInfo.zoneNb;
            int ip = zoneInfo.ptrZoneNb;
            Tree zoneInfoVisibleAccessTree = origSymbolTable.buildZoneVisibleAccessTree(zoneInfo);
            Tree baseVarTree = ILUtils.baseTree(zoneInfoVisibleAccessTree);
            Tree diffBaseVar = null;
            if (this.adEnv.traceCurDifferentiation) {
                TapEnv.printlnOnTrace("  - vanishing " + zoneInfo + " is TBR:" + tbrAtTheEnd.get(i) + (ip != -1 ? " and on diffPtr:" + tbrAtTheEndOnDiffPtr.get(ip) : ""));
            }
            boolean varIsTBR = tbrAtTheEnd.get(i);
            boolean diffPointerIsTBR = false;
            if (ip != -1) {
                diffPointerIsTBR = tbrAtTheEndOnDiffPtr.get(ip);
                if (diffPointerIsTBR) {
                    diffBaseVar = this.varRefDifferentiator().diffSymbolTree(this.adEnv.curActivity(), baseVarTree, popBlock.symbolTable, true, false, false, null, false, this.curDiffVarSort(), this.curDiffUnitSort(), 0, baseVarTree);
                }
                if (varIsTBR || diffPointerIsTBR) {
                    boolean rebaseOnDiffPtr;
                    Instruction dummyInstruction = new Instruction();
                    dummyInstruction.block = origBlock;
                    boolean rebasePrimal = varIsTBR && DataFlowAnalyzer.mayPointToRelocated(zoneInfoVisibleAccessTree, false, dummyInstruction, origSymbolTable, inJointDiffCode);
                    boolean bl = rebaseOnDiffPtr = diffPointerIsTBR && DataFlowAnalyzer.mayPointToRelocated(zoneInfoVisibleAccessTree, true, dummyInstruction, origSymbolTable, inJointDiffCode);
                    if (rebasePrimal || rebaseOnDiffPtr) {
                        this.adEnv.curDiffUnitPushesPointers = true;
                        ++this.blockDifferentiator().numRebase;
                        RefDescriptor ptrRefDescriptor = new RefDescriptor(zoneInfo, zoneInfoVisibleAccessTree, origSymbolTable, popBlock.symbolTable, null, null, false, null, this.curDiffUnit());
                        ptrRefDescriptor.prepareForStack(this.curDiffUnit(), -1, null, true);
                        ptrRefDescriptor.mayProtectAccesses = false;
                        Tree rebaseTree = ptrRefDescriptor.makeRebase(rebasePrimal ? null : new TapList<Boolean>(Boolean.TRUE, null), rebaseOnDiffPtr ? null : new TapList<Boolean>(Boolean.TRUE, null), rebaseOnDiffPtr ? diffBaseVar : null, TapEnv.debugAdMode() == -1 || TapEnv.debugADMM() ? this.blockDifferentiator().numRebase : -1);
                        if (rebaseTree != null) {
                            this.adEnv.usesADMM = true;
                            if (this.adEnv.traceCurDifferentiation) {
                                TapEnv.printlnOnTrace("     -> (+PopLocals) rebase: " + ILUtils.toString(rebaseTree));
                            }
                            popBlock.addInstrHdAfterDecls(new Instruction(rebaseTree, null, null));
                        }
                    }
                }
            }
            if (ip != -1 && diffPointerIsTBR) {
                ppLabelForLocalVar = TapEnv.getNewPushPopNumber();
                inPushBlocks = pushBlocks;
                if (this.adEnv.traceCurDifferentiation) {
                    TapEnv.printlnOnTrace("     -> (PushLocals+) push Diff pointer: " + zoneInfoVisibleAccessTree);
                }
                while (inPushBlocks != null) {
                    pushBlock = (Block)inPushBlocks.head;
                    Tree diffBaseVarForPush = this.varRefDifferentiator().diffSymbolTree(this.adEnv.curActivity(), baseVarTree, pushBlock.symbolTable, true, false, false, null, false, this.curDiffVarSort(), this.curDiffUnitSort(), 0, baseVarTree);
                    pushBlock.addInstrTl(RefDescriptor.makePushDiff(this.curFwdDiffUnit(), zoneInfoVisibleAccessTree, diffBaseVarForPush, origSymbolTable, pushBlock.symbolTable, ppLabelForLocalVar));
                    inPushBlocks = inPushBlocks.tail;
                }
                Instruction popDiffInstr = RefDescriptor.makePopDiff(this.curDiffUnit(), zoneInfoVisibleAccessTree, diffBaseVar, origSymbolTable, popBlock.symbolTable, ppLabelForLocalVar);
                if (this.adEnv.traceCurDifferentiation) {
                    TapEnv.printlnOnTrace("     -> (+PopLocals) pop Diff pointer: " + popDiffInstr);
                }
                popBlock.addInstrHdAfterDecls(popDiffInstr);
            }
            if (varIsTBR) {
                ppLabelForLocalVar = TapEnv.getNewPushPopNumber();
                inPushBlocks = pushBlocks;
                if (this.adEnv.traceCurDifferentiation) {
                    TapEnv.printlnOnTrace("     -> (PushLocals+) push: " + zoneInfoVisibleAccessTree);
                }
                while (inPushBlocks != null) {
                    pushBlock = (Block)inPushBlocks.head;
                    pushBlock.addInstrTl(RefDescriptor.makePush(this.curFwdDiffUnit(), zoneInfoVisibleAccessTree, origSymbolTable, pushBlock.symbolTable, ppLabelForLocalVar));
                    inPushBlocks = inPushBlocks.tail;
                }
                Instruction popInstr = RefDescriptor.makePop(this.curDiffUnit(), zoneInfoVisibleAccessTree, origSymbolTable, popBlock.symbolTable, ppLabelForLocalVar, this.toBranchVariable);
                if (this.adEnv.traceCurDifferentiation) {
                    TapEnv.printlnOnTrace("     -> (+PopLocals) pop: " + popInstr);
                }
                popBlock.addInstrHdAfterDecls(popInstr);
            }
            vanishingZones = vanishingZones.tail;
        }
    }

    private void savePrivatesBeforeTheyVanish(Block pushBlock, Block popBlock, FlowGraphLevel regionLevel) {
        ZoneInfo zoneInfo;
        SymbolTable origSymbolTable = ((FlowGraphLevel)regionLevel).entryBlock.symbolTable;
        int[] sourceTBRMap = DataFlowAnalyzer.makeMap3(this.adEnv.curUnit(), regionLevel.entryBlock, 0);
        int mapSize = DataFlowAnalyzer.mapSize(sourceTBRMap);
        BoolVector exitTBR = new BoolVector(mapSize);
        TapList sourceExitArrows = regionLevel.exitArrows;
        while (sourceExitArrows != null) {
            BoolVector tbrAtTheEnd;
            Block origBlock = ((FGArrow)sourceExitArrows.head).origin;
            TapList<TapPair<BoolVector, BoolVector>> origBlockTbr = origBlock.rank == -99 ? ((TemporaryBlock)origBlock).blockTBRs : (this.adEnv.unitTBRs == null ? null : this.adEnv.unitTBRs.retrieve(origBlock));
            TapPair<BoolVector, BoolVector> tbrPairAtTheEnd = TapList.last(origBlockTbr);
            BoolVector boolVector = tbrAtTheEnd = tbrPairAtTheEnd == null ? null : (BoolVector)tbrPairAtTheEnd.first;
            if (!TapEnv.doTBR() && tbrAtTheEnd == null) {
                exitTBR.setTrue();
            } else {
                exitTBR.cumulOr(tbrAtTheEnd, mapSize);
            }
            sourceExitArrows = sourceExitArrows.tail;
        }
        BoolVector zonesToSave = exitTBR;
        Instruction parallelControlInstr = regionLevel.entryBlock.lastInstr();
        if (parallelControlInstr != null && parallelControlInstr.tree.opCode() == 145 && ILUtils.isIdent(parallelControlInstr.tree.down(1), "CUDA", true)) {
            zonesToSave.setFalse();
        } else if (TapEnv.multithreadAnalyzer() != null) {
            BoolVector sharedZones = TapEnv.multithreadAnalyzer().getSharedZonesOfBlock(regionLevel.entryBlock);
            zonesToSave = zonesToSave.minus(sharedZones);
        }
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printlnOnTrace("Save vanishing privates. Privates TBR at exit:" + zonesToSave);
        }
        TapList<ZoneInfo> vanishingZones = null;
        for (int i = 0; i < ((FlowGraphLevel)regionLevel).entryBlock.symbolTable.declaredZonesNb(0); ++i) {
            int index = DataFlowAnalyzer.extendedDeclaredToVectorIndex(i, 0, sourceTBRMap, origSymbolTable, null);
            if (index < 0 || !zonesToSave.get(index) || (zoneInfo = DataFlowAnalyzer.extendedDeclaredToZoneInfo(i, origSymbolTable, null)) == null || zoneInfo.isHidden || zoneInfo.isAllocatable || zoneInfo.isConstant()) continue;
            vanishingZones = new TapList<ZoneInfo>(zoneInfo, vanishingZones);
        }
        while (vanishingZones != null) {
            zoneInfo = (ZoneInfo)vanishingZones.head;
            Tree zoneInfoVisibleAccessTree = origSymbolTable.buildZoneVisibleAccessTree(zoneInfo);
            Tree baseVarTree = ILUtils.baseTree(zoneInfoVisibleAccessTree);
            int ppLabelForPrivateVar = TapEnv.getNewPushPopNumber();
            if (this.adEnv.traceCurDifferentiation) {
                TapEnv.printlnOnTrace("     -> (BB\"" + pushBlock.symbolicRk + "\") push: " + zoneInfoVisibleAccessTree);
            }
            pushBlock.addInstrTl(RefDescriptor.makePush(this.curFwdDiffUnit(), zoneInfoVisibleAccessTree, origSymbolTable, pushBlock.symbolTable, ppLabelForPrivateVar));
            if (this.adEnv.traceCurDifferentiation) {
                TapEnv.printlnOnTrace("     -> (BB\"" + popBlock.symbolicRk + "\") pop: " + zoneInfoVisibleAccessTree);
            }
            popBlock.addInstrHdAfterDecls(RefDescriptor.makePop(this.curDiffUnit(), zoneInfoVisibleAccessTree, origSymbolTable, popBlock.symbolTable, ppLabelForPrivateVar, this.toBranchVariable));
            vanishingZones = vanishingZones.tail;
        }
    }

    private boolean mustSaveLocalsBeforeTheyVanish(Block origBlock, Block destBlock, SymbolTable sharedSymbolTable, int[] sourceTBRMap, int[] sourceTBRMapOnDiffPtr, SymbolTable passByValueSymbolTable, BoolVector constantZones) {
        int ip;
        ZoneInfo zoneInfo;
        int i;
        BoolVector tbrAtTheEndOnDiffPtr;
        BoolVector tbrAtTheEnd;
        TapList<TapPair<BoolVector, BoolVector>> origBlockTbr = origBlock.rank == -99 ? ((TemporaryBlock)origBlock).blockTBRs : (this.adEnv.unitTBRs == null ? null : this.adEnv.unitTBRs.retrieve(origBlock));
        TapPair<BoolVector, BoolVector> tbrPairAtTheEnd = TapList.last(origBlockTbr);
        BoolVector boolVector = tbrAtTheEnd = tbrPairAtTheEnd == null ? null : (BoolVector)tbrPairAtTheEnd.first;
        if (!TapEnv.doTBR() && tbrAtTheEnd == null) {
            tbrAtTheEnd = new BoolVector(DataFlowAnalyzer.mapSize(sourceTBRMap));
            tbrAtTheEnd.setTrue();
        }
        if (origBlock.parallelControls != null && destBlock.parallelControls == null && ILUtils.isIdent(((Instruction)origBlock.parallelControls.head).tree.down(1), "omp", false)) {
            Block parallelRegionBlock = TapList.last(origBlock.parallelControls).block;
            BoolVector tbrBeforeRegion = (BoolVector)((TapPair)this.adEnv.unitTBRs.retrieve((Block)parallelRegionBlock).head).first;
            BoolVector sharedZones = TapEnv.multithreadAnalyzer().getSharedZonesOfBlock(parallelRegionBlock);
            tbrAtTheEnd = tbrAtTheEnd.and(sharedZones).or(tbrBeforeRegion.minus(sharedZones));
        }
        BoolVector boolVector2 = tbrAtTheEndOnDiffPtr = tbrPairAtTheEnd == null ? null : (BoolVector)tbrPairAtTheEnd.second;
        if (!TapEnv.doTBR() && tbrAtTheEndOnDiffPtr == null) {
            tbrAtTheEndOnDiffPtr = new BoolVector(DataFlowAnalyzer.mapSize(sourceTBRMapOnDiffPtr));
            tbrAtTheEndOnDiffPtr.setTrue();
        }
        SymbolTable origSymbolTable = origBlock.symbolTable;
        int maxDeclZonesNb = origSymbolTable.declaredZonesNb(0);
        boolean mustSave = false;
        if (passByValueSymbolTable != null) {
            for (i = passByValueSymbolTable.firstDeclaredZone(0); !mustSave && i < passByValueSymbolTable.declaredZonesNb(0); ++i) {
                zoneInfo = passByValueSymbolTable.declaredZoneInfo(i, 0);
                if (zoneInfo == null || zoneInfo.isHidden || zoneInfo.targetZoneOf != null || constantZones.get(i)) continue;
                ip = zoneInfo.ptrZoneNb;
                if (!tbrAtTheEnd.get(i) && (ip == -1 || !tbrAtTheEndOnDiffPtr.get(ip))) continue;
                mustSave = true;
            }
        }
        for (i = sharedSymbolTable.declaredZonesNb(0); !mustSave && i < maxDeclZonesNb; ++i) {
            zoneInfo = origSymbolTable.declaredZoneInfo(i, 0);
            if (zoneInfo == null || zoneInfo.isHidden || zoneInfo.isAllocatable || zoneInfo.isConstant()) continue;
            ip = zoneInfo.ptrZoneNb;
            if (!tbrAtTheEnd.get(i) && (ip == -1 || !tbrAtTheEndOnDiffPtr.get(ip))) continue;
            mustSave = true;
        }
        return mustSave;
    }

    private TapPair<BoolVector[], BoolVector[]> recomputeDataFlowCheckpointed(FlowGraphLevel checkpointedPiece, HeaderBlock loopHeader, boolean modeIsJoint) {
        BoolVector notUnusedZones;
        TapEnv.printOnTrace(20, "@@ Recomputing data-flow for checkpointed piece " + checkpointedPiece + ": ");
        TapList blocksInsideLoop = checkpointedPiece.allBlocksInside();
        TapList<FGArrow> entryFrontier = checkpointedPiece.entryArrows;
        TapList<FGArrow> exitFrontier = checkpointedPiece.exitArrows;
        TapList<FGArrow> completeLoopEntryFrontier = loopHeader == null ? entryFrontier : loopHeader.enteringArrows();
        TapList<FGArrow> completeLoopExitFrontier = loopHeader == null ? exitFrontier : loopHeader.enclosingLoop().flow();
        TapList<FGArrow> entryFrontierNoCycle = this.removeCyclingFrom(entryFrontier, blocksInsideLoop);
        this.alteredStaticAnalysis = true;
        TapPair<BoolVector, BoolVector> useDb = null;
        TapPair<BoolVector, BoolVector> useCb = null;
        TapPair<BoolVector, BoolVector> outDb = null;
        TapPair<BoolVector, BoolVector> outCb = null;
        if (TapEnv.diffLivenessAnalyzer() != null) {
            TapEnv.diffLivenessAnalyzer().setCurUnitEtc(this.adEnv.curUnit());
            TapEnv.diffLivenessAnalyzer().setCurUnitActivity(this.adEnv.curActivity());
            TapEnv.diffLivenessAnalyzer().setCurUnitActivitiesLivenessesAndOverwrites(this.adEnv.curActivity(), modeIsJoint);
            useDb = TapEnv.diffLivenessAnalyzer().getFrontierLiveness(completeLoopExitFrontier);
            outDb = TapEnv.diffLivenessAnalyzer().getFrontierOverwrite(completeLoopExitFrontier);
            TapEnv.diffLivenessAnalyzer().setPhaseSubGraph();
            TapEnv.diffLivenessAnalyzer().resetLivenessInfo(blocksInsideLoop);
            TapEnv.diffLivenessAnalyzer().analyzeBackward(entryFrontier, blocksInsideLoop, exitFrontier);
            useCb = TapEnv.diffLivenessAnalyzer().getFrontierLiveness(entryFrontierNoCycle);
            outCb = TapEnv.diffLivenessAnalyzer().getFrontierOverwrite(entryFrontierNoCycle);
            TapEnv.diffLivenessAnalyzer().setCurUnitActivitiesLivenessesAndOverwrites(null, modeIsJoint);
            TapEnv.diffLivenessAnalyzer().setCurUnitActivity(null);
            TapEnv.diffLivenessAnalyzer().setCurUnitEtc(null);
        }
        ADTBRAnalyzer tbrAnalyzer = TapEnv.adTbrAnalyzer();
        tbrAnalyzer.setCurUnitEtc(this.adEnv.curUnit());
        tbrAnalyzer.setCurUnitActivity(this.adEnv.curActivity());
        TapPair<BoolVector, BoolVector> req = tbrAnalyzer.getFrontierTBR(completeLoopEntryFrontier);
        tbrAnalyzer.setPhaseSubGraph();
        tbrAnalyzer.prepareStorageForUnit(this.adEnv.curUnit());
        tbrAnalyzer.analyzeForward(entryFrontier, blocksInsideLoop, exitFrontier);
        InOutAnalyzer inOutAnalyzer = TapEnv.inOutAnalyzer();
        inOutAnalyzer.setCurUnitEtc(this.adEnv.curUnit());
        if (outDb == null) {
            BoolVector modifiedZones = inOutAnalyzer.getFrontierModifiedZones(completeLoopExitFrontier);
            outDb = new TapPair<BoolVector, BoolVector>(modifiedZones, this.restrictToPointers(modifiedZones, completeLoopExitFrontier));
        }
        if (useDb == null) {
            notUnusedZones = inOutAnalyzer.getFrontierUnusedZones(completeLoopExitFrontier).not();
            useDb = new TapPair<BoolVector, BoolVector>(notUnusedZones, this.restrictToPointers(notUnusedZones, completeLoopExitFrontier));
        }
        inOutAnalyzer.setFgPhase(1);
        inOutAnalyzer.analyzeBackward(entryFrontier, blocksInsideLoop, exitFrontier);
        BoolVector useC = inOutAnalyzer.getFrontierPossiblyReadZones(entryFrontierNoCycle);
        inOutAnalyzer.setFgPhase(0);
        inOutAnalyzer.setFgSubPhase(2);
        inOutAnalyzer.analyzeBackward(entryFrontier, blocksInsideLoop, exitFrontier);
        BoolVector outC = inOutAnalyzer.getFrontierModifiedZones(entryFrontierNoCycle);
        if (outCb == null) {
            outCb = new TapPair<BoolVector, BoolVector>(outC, this.restrictToPointers(outC, entryFrontierNoCycle));
        }
        if (useCb == null) {
            inOutAnalyzer.setFgSubPhase(3);
            inOutAnalyzer.analyzeBackward(entryFrontier, blocksInsideLoop, exitFrontier);
            notUnusedZones = inOutAnalyzer.getFrontierUnusedZones(entryFrontierNoCycle).not();
            useCb = new TapPair<BoolVector, BoolVector>(notUnusedZones, this.restrictToPointers(notUnusedZones, entryFrontierNoCycle));
        }
        if (loopHeader != null && loopHeader.isADoLoop()) {
            Instruction headerInstr = loopHeader.headInstr();
            this.adEnv.setCurInstruction(headerInstr);
            Tree doIndexTree = headerInstr.tree.down(3).down(1);
            TapIntList indexZones = ZoneInfo.listAllZones(loopHeader.symbolTable.treeOfZonesOfValue(doIndexTree, null, headerInstr, null), true);
            if (indexZones != null && indexZones.tail == null && indexZones.head >= 0) {
                outC.set(indexZones.head, true);
                ((BoolVector)outCb.first).set(indexZones.head, true);
                ((BoolVector)useCb.first).set(indexZones.head, false);
                if (ADTBRAnalyzer.isTBRindexOnLoopEntry(this.adEnv.curActivity(), doIndexTree)) {
                    ((BoolVector)req.first).set(indexZones.head, false);
                }
            }
        }
        inOutAnalyzer.setCurUnitEtc(null);
        tbrAnalyzer.setCurUnitActivity(null);
        tbrAnalyzer.setCurUnitEtc(null);
        TapEnv.printlnOnTrace(20);
        BoolVector[] result = new BoolVector[]{(BoolVector)req.first, (BoolVector)useCb.first, (BoolVector)outCb.first, useC, outC, (BoolVector)useDb.first, (BoolVector)outDb.first};
        BoolVector[] resultOnDiffPtr = new BoolVector[]{(BoolVector)req.second, (BoolVector)useCb.second, (BoolVector)outCb.second, this.restrictToPointers(useC, entryFrontierNoCycle), this.restrictToPointers(outC, entryFrontierNoCycle), (BoolVector)useDb.second, (BoolVector)outDb.second};
        return new TapPair<BoolVector[], BoolVector[]>(result, resultOnDiffPtr);
    }

    private void restoreStaticAnalysis(boolean modeIsJoint) {
        TapEnv.printOnTrace(20, "@@ Restoring data-flow for unit " + this.adEnv.curUnit().name() + ": ");
        if (TapEnv.diffLivenessAnalyzer() != null) {
            TapEnv.diffLivenessAnalyzer().setCurUnitEtc(this.adEnv.curUnit());
            TapEnv.diffLivenessAnalyzer().setCurUnitActivity(this.adEnv.curActivity());
            TapEnv.diffLivenessAnalyzer().setCurUnitActivitiesLivenessesAndOverwrites(this.adEnv.curActivity(), modeIsJoint);
            TapEnv.diffLivenessAnalyzer().setPhaseSubGraph();
            TapEnv.diffLivenessAnalyzer().resetLivenessInfo(this.adEnv.curUnit().allBlocks());
            TapEnv.diffLivenessAnalyzer().analyzeBackward(null, null, null);
            TapEnv.diffLivenessAnalyzer().setCurUnitActivitiesLivenessesAndOverwrites(null, modeIsJoint);
            TapEnv.diffLivenessAnalyzer().setCurUnitActivity(null);
            TapEnv.diffLivenessAnalyzer().setCurUnitEtc(null);
        }
        ADTBRAnalyzer tbrAnalyzer = TapEnv.adTbrAnalyzer();
        tbrAnalyzer.setCurUnitEtc(this.adEnv.curUnit());
        tbrAnalyzer.setCurUnitActivity(this.adEnv.curActivity());
        tbrAnalyzer.setPhaseSubGraph();
        tbrAnalyzer.prepareStorageForUnit(this.adEnv.curUnit());
        tbrAnalyzer.analyzeForward(null, null, null);
        InOutAnalyzer inOutAnalyzer = TapEnv.inOutAnalyzer();
        inOutAnalyzer.setCurUnitEtc(this.adEnv.curUnit());
        inOutAnalyzer.setFgPhase(1);
        inOutAnalyzer.analyzeBackward(null, null, null);
        inOutAnalyzer.setFgPhase(0);
        inOutAnalyzer.setFgSubPhase(2);
        inOutAnalyzer.analyzeBackward(null, null, null);
        inOutAnalyzer.setFgSubPhase(3);
        inOutAnalyzer.analyzeBackward(null, null, null);
        inOutAnalyzer.setCurUnitEtc(null);
        tbrAnalyzer.setCurUnitActivity(null);
        tbrAnalyzer.setCurUnitEtc(null);
        TapEnv.printlnOnTrace(20);
    }

    private BoolVector restrictToPointers(BoolVector info, TapList<FGArrow> frontier) {
        int commonNDZ = -1;
        int commonNDPZ = -1;
        Block destBlock = ((FGArrow)frontier.head).destination;
        while (frontier != null) {
            SymbolTable origST = ((FGArrow)frontier.head).origin.symbolTable;
            int newndz = origST.declaredZonesNb(0);
            if (commonNDZ == -1 || commonNDZ > newndz) {
                commonNDZ = newndz;
            }
            newndz = origST.declaredZonesNb(3);
            if (commonNDPZ == -1 || commonNDPZ > newndz) {
                commonNDPZ = newndz;
            }
            frontier = frontier.tail;
        }
        int[] vectorMap = DataFlowAnalyzer.makeMap3(0, 0, commonNDZ);
        int[] pointerVectorMap = DataFlowAnalyzer.makeMap3(0, 0, commonNDPZ);
        return DataFlowAnalyzer.changeKind(info, vectorMap, 0, pointerVectorMap, 3, destBlock.symbolTable);
    }

    private TapList<FGArrow> removeCyclingFrom(TapList<FGArrow> entryFrontier, TapList<Block> forbiddenOrigins) {
        TapList<Object> hdResult;
        TapList<Object> tlResult = hdResult = new TapList<Object>(null, null);
        while (entryFrontier != null) {
            if (!TapList.contains(forbiddenOrigins, ((FGArrow)entryFrontier.head).origin)) {
                tlResult = tlResult.placdl(entryFrontier.head);
            }
            entryFrontier = entryFrontier.tail;
        }
        return hdResult.tail;
    }

    private TapPair<BoolVector, BoolVector> computeCheckpointingSets(FlowGraphLevel flowGraphPiece, BoolVector[] dataFlowSets7, ToBool needCopy, int kind, int[] map3) {
        BoolVector req = dataFlowSets7[0];
        BoolVector useCb = dataFlowSets7[1];
        BoolVector outCb = dataFlowSets7[2];
        BoolVector outC = dataFlowSets7[4];
        BoolVector useDb = dataFlowSets7[5];
        BoolVector outDb = dataFlowSets7[6];
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printOnTrace("FOR CHECKPOINTED FLOW-GRAPH PIECE " + flowGraphPiece);
            TapEnv.printlnOnTrace(" with entryArrows:" + flowGraphPiece.entryArrows + " and exitArrows:" + flowGraphPiece.exitArrows + ':');
            for (int i = 0; i < DataFlowAnalyzer.mapSize(map3); ++i) {
                ZoneInfo zi = DataFlowAnalyzer.vectorIndexToZoneInfo(i, DataFlowAnalyzer.getMapClass(i, map3), kind, map3, ((FlowGraphLevel)flowGraphPiece).entryBlock.symbolTable);
                if (zi == null) continue;
                TapEnv.printOnTrace(" [" + i + "]" + zi.accessTreePrint(this.adEnv.curUnit().language()));
            }
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace(" req  =" + req);
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace(" useCb=" + useCb);
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace(" outCb=" + outCb);
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace(" outC =" + outC);
            TapEnv.printlnOnTrace(" useDb=" + useDb);
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace(" outDb=" + outDb);
        }
        BoolVector sbk = req.copy();
        sbk.cumulAnd(outCb);
        BoolVector tmp2 = outDb.copy();
        tmp2.cumulAnd(useCb);
        tmp2.cumulMinus(req);
        tmp2.cumulMinus(outC);
        BoolVector snp = req.copy();
        snp.cumulMinus(outCb);
        snp.cumulOr(useCb);
        snp.cumulAnd(outC);
        snp.cumulOr(tmp2);
        if (useDb.intersects(outC, DataFlowAnalyzer.mapSize(map3))) {
            needCopy.set(true);
        } else {
            snp.setFalse();
        }
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printlnOnTrace("==>  (needCopy:" + needCopy.get() + ')');
            TapEnv.printlnOnTrace(" sbk  =" + sbk);
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace(" snp  =" + snp);
        }
        return new TapPair<BoolVector, BoolVector>(sbk, snp);
    }

    private TapTriplet<BoolVector, BoolVector, BoolVector> computeBinomialSets(Block block, BoolVector[] dataFlowSets7, int kind, int[] map3) {
        int mapSize = DataFlowAnalyzer.mapSize(map3);
        BoolVector sbk = new BoolVector(mapSize);
        BoolVector snp = new BoolVector(mapSize);
        BoolVector sfw = new BoolVector(mapSize);
        BoolVector req = dataFlowSets7[0];
        BoolVector useCb = dataFlowSets7[1];
        BoolVector outCb = dataFlowSets7[2];
        BoolVector useC = dataFlowSets7[3];
        BoolVector outC = dataFlowSets7[4];
        BoolVector useDb = dataFlowSets7[5];
        BoolVector outDb = dataFlowSets7[6];
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printOnTrace("FOR BINOMIAL LOOP " + block);
            for (int i = 0; i < mapSize; ++i) {
                ZoneInfo zi = DataFlowAnalyzer.vectorIndexToZoneInfo(i, DataFlowAnalyzer.getMapClass(i, map3), kind, map3, block.symbolTable);
                if (zi == null) continue;
                TapEnv.printOnTrace(" [" + i + "]" + zi.accessTreePrint(this.adEnv.curUnit().language()));
            }
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace(" req  =" + req);
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace(" useCb=" + useCb);
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace(" useC =" + useC);
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace(" outC =" + outC);
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace(" outDb=" + outDb);
        }
        BoolVector tmp2 = outDb.copy();
        tmp2.cumulOr(outC);
        sbk.setCopy(req);
        sbk.cumulAnd(tmp2);
        snp.setCopy(useCb);
        snp.cumulOr(useC);
        snp.cumulAnd(outC);
        sfw.setCopy(useCb);
        sfw.cumulAnd(outDb);
        sfw.cumulMinus(outC);
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printlnOnTrace("==>");
            TapEnv.printlnOnTrace(" sbk  =" + sbk);
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace(" snp  =" + snp);
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace(" sfw  =" + sfw);
        }
        return new TapTriplet<BoolVector, BoolVector, BoolVector>(sbk, snp, sfw);
    }

    private void detectUnusedExitLoopIndices(Block fwdBlock, Block block) {
        Instruction headInstr = block.headInstr();
        if (headInstr != null && headInstr.tree.opCode() == 121 && headInstr.tree.down(3).opCode() == 64) {
            ((HeaderBlock)fwdBlock).loopIndexUnusedAfterLoop = this.loopIndexUnusedAfterLoop(headInstr.tree.down(3).down(1), block);
        }
    }

    private boolean loopIndexUnusedAfterLoop(Tree loopIndex, Block headerBlock) {
        if (headerBlock.unusedZones == null) {
            return true;
        }
        TapList<FGArrow> arrows = headerBlock.flow();
        int nDZ = headerBlock.symbolTable.declaredZonesNb(0);
        int[] localMap = DataFlowAnalyzer.makeMap3(0, 0, nDZ);
        BoolVector exitUnused = new BoolVector(nDZ);
        exitUnused.setTrue();
        while (arrows != null) {
            FGArrow arrow = (FGArrow)arrows.head;
            if (TapIntList.contains(arrow.cases, 0)) {
                Block destination = arrow.destination;
                if (destination.unusedZones != null) {
                    SymbolTable commonSymbolTable = headerBlock.symbolTable.getCommonRoot(destination.symbolTable);
                    int commonLength = commonSymbolTable.declaredZonesNb(0);
                    exitUnused.cumulAnd(destination.unusedZones, commonLength);
                }
            }
            arrows = arrows.tail;
        }
        TapIntList indexZones = headerBlock.symbolTable.listOfZonesOfValue(loopIndex, null, headerBlock.lastInstr());
        return DataFlowAnalyzer.containsExtendedDeclared(exitUnused, localMap, 0, indexZones, null, headerBlock.symbolTable, null);
    }

    private void connectBwd(TapList<FGArrow> bwdArrows, Block bwdDest, boolean cycle, Block sourceOrig, Block sourceDest, FlowGraphDifferentiationEnv diffEnv) {
        SymbolTable commonScope;
        SymbolTable origScope;
        Block diffInitBlock;
        if (diffEnv.adDiffMode != 1 && (diffInitBlock = this.checkActivitySwitches(sourceOrig, sourceDest, bwdDest.symbolTable, false, null, diffEnv, null)) != null) {
            this.checkFreeThenSetNewFGArrow(diffInitBlock, 0, 0, bwdDest, cycle);
            cycle = false;
            bwdDest = diffInitBlock;
        }
        if ((origScope = sourceOrig.symbolTable) != (commonScope = origScope.getCommonRoot(sourceDest.symbolTable))) {
            SymbolTable bwdOrigScope = origScope.smartCopy(((FlowGraphDifferentiationEnv)diffEnv).diffCtxt.listST, ((FlowGraphDifferentiationEnv)diffEnv).diffCtxt.unit, this.adEnv.diffCallGraph(), this.adEnv.copiedUnits, "Diff of ");
            origScope.cleanCopySymbolDecls();
            if (bwdOrigScope != null && bwdOrigScope.declarationsBlock != null) {
                if (bwdOrigScope.declarationsBlock.flow() == null) {
                    this.checkFreeThenSetNewFGArrow(bwdOrigScope.declarationsBlock, 0, 0, bwdDest, cycle);
                    cycle = false;
                    bwdDest = bwdOrigScope.declarationsBlock;
                } else {
                    Instruction headInstr = sourceDest.headInstr();
                    TapEnv.fileWarning(15, headInstr == null ? null : headInstr.tree, "(AD22) Irreducible exits from the same scope in procedure " + this.adEnv.curUnit().name());
                }
            }
        }
        this.mapCheckFreeThenRedirectDestination(bwdArrows, bwdDest, cycle);
    }

    private Block placeChainOfDiffReinits(TapList<Block> sourceOrigPath, Block sourceDest, Block bwdDest, FlowGraphDifferentiationEnv diffEnv) {
        TapList<Block> blocksChain = new TapList<Block>(sourceDest, TapList.reverse(sourceOrigPath));
        while (blocksChain.tail != null) {
            Block sourceOrig = (Block)blocksChain.tail.head;
            sourceDest = (Block)blocksChain.head;
            Block diffInitBlock = this.checkActivitySwitches(sourceOrig, sourceDest, bwdDest.symbolTable, false, null, diffEnv, null);
            if (diffInitBlock != null) {
                this.checkFreeThenSetNewFGArrow(diffInitBlock, 0, 0, bwdDest, false);
                bwdDest = diffInitBlock;
            }
            blocksChain = blocksChain.tail;
        }
        return bwdDest;
    }

    private Block buildFwdBlock(String symbolicRk, SymbolTable symbolTable, Block control, FlowGraphDifferentiationEnv diffEnv) {
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printlnOnTrace("!Build Fwd Block BB\"" + symbolicRk + "\"!");
        }
        BasicBlock fwdBlock = new BasicBlock(symbolTable, null, ((FlowGraphDifferentiationEnv)diffEnv).diffCtxtFwd.toAllBlocks);
        fwdBlock.symbolicRk = symbolicRk;
        fwdBlock.parallelControls = this.fwdParallelControlsOf(control.parallelControls, diffEnv);
        return fwdBlock;
    }

    private Block buildBwdBlock(String symbolicRk, SymbolTable symbolTable, Block control, FlowGraphDifferentiationEnv diffEnv) {
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printlnOnTrace("!Build Bwd Block BB\"" + symbolicRk + "\"!");
        }
        BasicBlock bwdBlock = new BasicBlock(symbolTable, null, ((FlowGraphDifferentiationEnv)diffEnv).diffCtxt.toAllBlocks);
        bwdBlock.symbolicRk = symbolicRk;
        bwdBlock.parallelControls = this.bwdParallelControlsOf(control.parallelControls, diffEnv);
        return bwdBlock;
    }

    private HeaderBlock buildFwdHeaderBlock(String symbolicRk, SymbolTable symbolTable, Block control, FlowGraphDifferentiationEnv diffEnv) {
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printlnOnTrace("!Build Fwd HeaderBlock HB\"" + symbolicRk + "\"!");
        }
        HeaderBlock fwdHeaderBlock = new HeaderBlock(symbolTable, null, ((FlowGraphDifferentiationEnv)diffEnv).diffCtxtFwd.toAllBlocks);
        fwdHeaderBlock.symbolicRk = symbolicRk;
        fwdHeaderBlock.parallelControls = this.fwdParallelControlsOf(control.parallelControls, diffEnv);
        return fwdHeaderBlock;
    }

    private HeaderBlock buildBwdHeaderBlock(String symbolicRk, SymbolTable symbolTable, Block control, FlowGraphDifferentiationEnv diffEnv) {
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printlnOnTrace("!Build Bwd HeaderBlock HB\"" + symbolicRk + "\"!");
        }
        HeaderBlock bwdHeaderBlock = new HeaderBlock(symbolTable, null, ((FlowGraphDifferentiationEnv)diffEnv).diffCtxt.toAllBlocks);
        bwdHeaderBlock.symbolicRk = symbolicRk;
        bwdHeaderBlock.parallelControls = this.bwdParallelControlsOf(control.parallelControls, diffEnv);
        return bwdHeaderBlock;
    }

    private void mapCheckFreeThenRedirectDestination(TapList<FGArrow> arrows, Block newDest, boolean wantToCycle) {
        while (arrows != null) {
            this.checkFreeThenRedirectDestination((FGArrow)arrows.head, newDest, wantToCycle);
            arrows = arrows.tail;
        }
    }

    private void checkFreeThenRedirectDestination(FGArrow arrow, Block newDest, boolean wantToCycle) {
        boolean inCycle;
        assert (arrow != null);
        if (arrow.destination != null && arrow.destination != newDest) {
            TapEnv.toolWarning(-1, "(Differentiation of a Flow Graph) Connecting a Flow Arrow twice! " + arrow + " now to " + newDest);
        }
        boolean bl = inCycle = wantToCycle && newDest.isALoop();
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printlnOnTrace("!Connect dangling arrow " + arrow + (inCycle ? " cycling" : "") + " to " + newDest + "!");
        }
        arrow.redirectDestination(newDest, inCycle);
    }

    private FGArrow checkFreeThenSetNewFGArrow(Block origin, int test, int cas, Block destination, boolean inCycle) {
        this.checkFreeTestCase(origin, test, cas, destination);
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printlnOnTrace("!Set " + (destination == null ? "dangling " : "") + "arrow " + origin + " (" + FGArrow.testAndCasesToString(test, new TapIntList(cas, null)) + ')' + (inCycle ? " cycling" : "") + (destination == null ? "" : " to " + destination) + '!');
        }
        return new FGArrow(origin, test, cas, destination, inCycle);
    }

    private FGArrow checkFreeThenSetNewFGArrow(Block origin, int test, TapIntList cases, Block destination, boolean inCycle) {
        TapIntList inCases = cases;
        while (inCases != null) {
            this.checkFreeTestCase(origin, test, inCases.head, destination);
            inCases = inCases.tail;
        }
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printlnOnTrace("!Set " + (destination == null ? "dangling " : "") + "arrow " + origin + " (" + FGArrow.testAndCasesToString(test, cases) + ')' + (inCycle ? " cycling" : "") + (destination == null ? "" : " to " + destination) + '!');
        }
        return new FGArrow(origin, test, cases, destination, inCycle);
    }

    private void checkFreeTestCase(Block origin, int test, int cas, Block destination) {
        FGArrow existingArrow = origin.getFGArrowTestCase(test, cas);
        if (existingArrow != null && test == 21 && cas != -1 && TapIntList.contains(existingArrow.cases, -1)) {
            existingArrow = null;
        }
        if (existingArrow != null && existingArrow.destination != null && existingArrow.destination != destination) {
            TapEnv.toolError("(Differentiation of a Flow Graph) Connecting a block destination twice! " + existingArrow + " now to " + destination);
        }
    }

    private void insertBlockBefore(Block block, Block newBlock) {
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printlnOnTrace("!Insert block " + newBlock + " before " + block + "!");
        }
        block.insertBlockBefore(newBlock);
    }

    private void insertBlockAtOrig(FGArrow arrow, Block newBlock, int test, int cas) {
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printlnOnTrace("!Insert block " + newBlock + " (" + FGArrow.testAndCasesToString(test, new TapIntList(cas, null)) + ") in the middle of " + arrow + "!");
        }
        arrow.insertBlockAtOrig(newBlock, test, cas);
    }

    private FGArrow insertBlockAtDest(FGArrow arrow, Block newBlock, int test, int cas) {
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printlnOnTrace("!Insert block " + newBlock + " (" + FGArrow.testAndCasesToString(test, new TapIntList(cas, null)) + ") in the middle of " + arrow + "!");
        }
        return arrow.insertBlockAtDest(newBlock, test, cas);
    }

    protected TapList<LoopBlock> getIterationsBetweenPushAndPop(Block block) {
        TapList<LoopBlock> result = null;
        FlowGraphLevel blockLevel = null;
        if (block instanceof LoopBlock) {
            block = ((LoopBlock)block).header();
        }
        if (this.additionalBlockToPlainLevel != null) {
            blockLevel = (FlowGraphLevel)TapList.cassq(block, this.additionalBlockToPlainLevel);
        }
        if (block.rank >= 0 && blockLevel == null) {
            blockLevel = this.blockToPlainLevel.retrieve(block);
        }
        block5: while (blockLevel != null) {
            LoopBlock loopAround = blockLevel.levelKind == 0 ? block.enclosingLoop() : blockLevel.entryBlock.enclosingLoop().enclosingLoop();
            blockLevel = blockLevel.trueEnclosing;
            while (loopAround != null && (blockLevel == null || blockLevel.entryPoint.entryBlock != loopAround.header())) {
                result = new TapList<LoopBlock>(loopAround, result);
                loopAround = loopAround.enclosingLoop();
            }
            if (blockLevel == null) continue;
            switch (blockLevel.levelKind) {
                case 0: 
                case 3: 
                case 12: {
                    continue block5;
                }
                case 2: {
                    result = new TapList<LoopBlock>(null, result);
                    blockLevel = null;
                    continue block5;
                }
                case 4: 
                case 7: 
                case 11: {
                    blockLevel = null;
                    continue block5;
                }
            }
            result = new TapList<LoopBlock>(blockLevel.entryBlock.enclosingLoop(), result);
        }
        return result;
    }

    private boolean keepBwdBecauseOfDiffReinits(Block block) {
        TapList<FGArrow> arrows = block.backFlow();
        if (arrows == null || arrows.tail != null) {
            return false;
        }
        FGArrow arrow = (FGArrow)arrows.head;
        return this.mustCheckActivitySwitches(arrow.origin, arrow.destination);
    }

    private boolean keepBwdBecauseOfTwoExits(Block block, Block fwdDiffBlock, FlowGraphDifferentiationEnv diffEnv) {
        return block.flow() != null && block.flow().tail != null && (fwdDiffBlock.instructions != null || diffEnv.blockMustBeLive(block));
    }

    private void declareStackPointerInterface(Unit diffUnit) {
        Block diffDeclarationsBlock;
        if (diffUnit != null && this.adEnv.curUnit().isStandard() && diffUnit.privateSymbolTable() != null && (diffDeclarationsBlock = diffUnit.privateSymbolTable().declarationsBlock) != null) {
            diffDeclarationsBlock.addUseDecl(ILUtils.build(197, ILUtils.build(96, "ISO_C_BINDING"), ILUtils.build(166)));
            diffDeclarationsBlock.addUseDecl(ILUtils.build(197, ILUtils.build(96, "ADMM_TAPENADE_INTERFACE"), ILUtils.build(166)));
        }
    }

    private void placeAMPITurns(BoolVector zonesToTurn, int[] diffTurnMap, Block turnBlock, SymbolTable destSymbolTable, FlowGraphDifferentiationEnv diffEnv) {
        if (diffEnv.adDiffMode == -2) {
            turnBlock = ((FGArrow)this.curDiffUnit().entryBlock().flow().head).destination;
        }
        for (int i = destSymbolTable.declaredZonesNb(this.adEnv.diffKind) - 1; i >= 0; --i) {
            int vi = DataFlowAnalyzer.zoneRkToVectorIndex(i, 3, this.adEnv.diffKind, diffTurnMap, null);
            if (vi == -1 || !zonesToTurn.get(vi)) continue;
            ZoneInfo zoneInfo = destSymbolTable.declaredZoneInfo(i, this.adEnv.diffKind);
            if (diffEnv.adDiffMode == -2 && i >= this.adEnv.curUnit().publicSymbolTable().declaredZonesNb(this.adEnv.diffKind)) {
                TapEnv.fileWarning(15, null, "(ADxx) Differentiated procedure of " + this.adEnv.curUnit().name() + " needs to run AMPI_Turn on renewed local variable " + ILUtils.toString(zoneInfo.accessTree));
                continue;
            }
            Tree varRef = ILUtils.copy(zoneInfo.accessTree);
            if (this.curDiffUnit().isC()) {
                varRef = ILUtils.addAddressOf(varRef);
            }
            Tree diffVarRef = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), varRef, turnBlock.symbolTable, false, varRef, false, false, varRef);
            Tree turnCall = ILUtils.buildCall(ILUtils.build(96, "ADTOOL_AMPI_Turn"), ILUtils.build(71, varRef, diffVarRef));
            if (this.adEnv.traceCurDifferentiation) {
                TapEnv.printlnOnTrace("!Augment " + turnBlock + " with AMPI_Turn: " + ILUtils.toString(turnCall));
            }
            turnBlock.addInstrHdAfterDecls(turnCall);
        }
    }

    private Block deepestController(Block toBlock, Block fromBlock) {
        Instruction firstTo = toBlock.headInstr();
        return firstTo != null && TapList.contains(fromBlock.parallelControls, firstTo) ? fromBlock : toBlock;
    }

    private Block checkActivitySwitches(Block fromBlock, Block toBlock, SymbolTable diffDestSymbolTable, boolean inFwd, Block parallelControlRef, FlowGraphDifferentiationEnv diffEnv, TapList<TapPair<ZoneInfo, TapList<Tree>>> toNewDeclaredInits) {
        TapList<BoolVector> originActivs;
        BoolVector originExitActiv;
        BoolVector destinationEntryActiv;
        if (!this.adEnv.curUnitIsActiveUnit || this.adEnv.curUnitIsContext) {
            return null;
        }
        SymbolTable commonSymbolTable = fromBlock.symbolTable.getCommonRoot(toBlock.symbolTable);
        if (diffDestSymbolTable == this.curDiffUnit().publicSymbolTable()) {
            diffDestSymbolTable = this.curDiffUnit().privateSymbolTable();
        }
        int nDRZ = commonSymbolTable.declaredZonesNb(this.adEnv.diffKind);
        int[] originInfoMap = DataFlowAnalyzer.makeMap3(this.adEnv.curUnit(), fromBlock, this.adEnv.diffKind);
        int[] destInfoMap = DataFlowAnalyzer.makeMap3(this.adEnv.curUnit(), toBlock, this.adEnv.diffKind);
        TapList<BoolVector> destActivs = toBlock.rank == -99 ? ((TemporaryBlock)toBlock).blockActivities : (this.adEnv.unitActivities == null ? null : this.adEnv.unitActivities.retrieve(toBlock));
        BoolVector boolVector = destinationEntryActiv = destActivs == null ? null : (BoolVector)destActivs.head;
        if (destinationEntryActiv == null) {
            destinationEntryActiv = new BoolVector(DataFlowAnalyzer.mapSize(destInfoMap));
            destinationEntryActiv.setTrue();
        }
        if (this.curDiffUnitSort() == 2 && toBlock instanceof ExitBlock) {
            destinationEntryActiv = this.removeActivePassedByValue(destinationEntryActiv, destInfoMap, toBlock.symbolTable);
        }
        if ((originExitActiv = TapList.last(originActivs = fromBlock.rank == -99 ? ((TemporaryBlock)fromBlock).blockActivities : (this.adEnv.unitActivities == null ? null : this.adEnv.unitActivities.retrieve(fromBlock)))) == null) {
            originExitActiv = new BoolVector(DataFlowAnalyzer.mapSize(originInfoMap));
            originExitActiv.setTrue();
        }
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printlnOnTrace("    Checking diff reinitialization due to activity switches,");
            TapEnv.printlnOnTrace("     " + (this.curDiffUnitSort() == 2 ? "back to" : "from") + ' ' + fromBlock + ' ' + originExitActiv);
            TapEnv.printlnOnTrace("     " + (this.curDiffUnitSort() == 2 ? "   from" : "  to") + ' ' + toBlock + ' ' + destinationEntryActiv);
        }
        boolean entersDiffUnit = this.curDiffUnitSort() == 2 ? toBlock instanceof ExitBlock : fromBlock instanceof EntryBlock;
        BoolVector activityBefore = this.curDiffUnitSort() == 2 ? destinationEntryActiv : originExitActiv;
        BoolVector activityAfter = this.curDiffUnitSort() == 2 ? originExitActiv : destinationEntryActiv;
        TapList<Object> allDiffInitTrees = null;
        SymbolTable commonUpSymbolTable = commonSymbolTable == this.adEnv.curUnit().publicSymbolTable() ? this.adEnv.curUnit().privateSymbolTable() : commonSymbolTable;
        SymbolTable postSymbolTable = this.curDiffUnitSort() == 2 ? fromBlock.symbolTable : toBlock.symbolTable;
        int postnDRZ = postSymbolTable.declaredZonesNb(this.adEnv.diffKind);
        BoolVector alreadyInitialized = new BoolVector(DataFlowAnalyzer.mapSize(this.curDiffUnitSort() == 2 ? originInfoMap : destInfoMap));
        for (int i = postnDRZ - 1; i >= 0; --i) {
            int vectorIndex;
            ZoneInfo zoneInfo = postSymbolTable.declaredZoneInfo(i, this.adEnv.diffKind);
            if (zoneInfo == null || !this.zoneActivitySwitches(zoneInfo, vectorIndex = DataFlowAnalyzer.zoneInfoToVectorIndex(zoneInfo, 3, this.adEnv.diffKind, originInfoMap, null), i >= nDRZ, entersDiffUnit, activityBefore, activityAfter)) continue;
            if (zoneInfo.isHidden || zoneInfo.accessTree == null) {
                if (!TapList.contains(this.adEnv.rootUnits, this.adEnv.curUnit())) continue;
                TapEnv.fileWarning(15, null, "(AD14) Differentiated procedure of " + this.adEnv.curUnit().name() + " needs to initialize derivative of hidden variable: " + zoneInfo.description);
                continue;
            }
            if (alreadyInitialized.get(i)) continue;
            Tree zoneAccessTree = zoneInfo.accessTree;
            ToBool total = new ToBool(false);
            TapIntList accessedZones = commonUpSymbolTable.listOfZonesOfValue(zoneAccessTree, total, null);
            if (total.get()) {
                accessedZones = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(accessedZones, this.adEnv.diffKind, originInfoMap, commonUpSymbolTable, null);
                alreadyInitialized.set(accessedZones, true);
            }
            SymbolTable postDeclSymbolTable = postSymbolTable == this.adEnv.curUnit().publicSymbolTable() ? this.adEnv.curUnit().privateSymbolTable() : postSymbolTable;
            Tree[] diffInitTreeR = this.blockDifferentiator().makeDiffInitialization(zoneAccessTree, postDeclSymbolTable, diffDestSymbolTable, null, zoneInfo, true, null, false);
            for (int iReplic = 0; iReplic < diffInitTreeR.length; ++iReplic) {
                Tree diffInitTree = diffInitTreeR[iReplic];
                if (i >= nDRZ && toNewDeclaredInits != null && this.curDiffUnit().isC()) {
                    TapPair<ZoneInfo, Object> initsForThisZone = TapList.assq(zoneInfo, toNewDeclaredInits.tail);
                    if (initsForThisZone != null) continue;
                    initsForThisZone = new TapPair<ZoneInfo, TapList>(zoneInfo, diffInitTree == null ? null : new TapList<Tree>(diffInitTree, null));
                    toNewDeclaredInits.placdl(initsForThisZone);
                    continue;
                }
                if (diffInitTree == null) continue;
                allDiffInitTrees = new TapList<Tree>(diffInitTree, allDiffInitTrees);
            }
        }
        Block diffInitBlock = null;
        if (allDiffInitTrees != null) {
            String switchName = "ActivitySwitch" + fromBlock.rank + "->" + toBlock.rank;
            if (inFwd) {
                if (parallelControlRef == null) {
                    parallelControlRef = fromBlock;
                }
                diffInitBlock = this.buildFwdBlock("+" + switchName, diffDestSymbolTable, parallelControlRef, diffEnv);
            } else {
                if (parallelControlRef == null) {
                    parallelControlRef = this.deepestController(fromBlock, toBlock);
                }
                diffInitBlock = this.buildBwdBlock("-" + switchName, diffDestSymbolTable, parallelControlRef, diffEnv);
            }
            while (allDiffInitTrees != null) {
                diffInitBlock.addInstrTl((Tree)allDiffInitTrees.head);
                allDiffInitTrees = allDiffInitTrees.tail;
            }
        }
        if (this.adEnv.traceCurDifferentiation) {
            if (diffInitBlock != null) {
                TapEnv.printlnOnTrace("      -> " + (this.curDiffUnitSort() == 2 ? "(+BWD)" : "") + " Diff Initialization: " + diffInitBlock.instructions);
            } else {
                TapEnv.printlnOnTrace("       -> no reinitialization needed");
            }
            if (toNewDeclaredInits != null && toNewDeclaredInits.tail != null) {
                TapEnv.printlnOnTrace("       => initializations before declaration:" + toNewDeclaredInits.tail);
            }
        }
        return diffInitBlock;
    }

    private boolean mustCheckActivitySwitches(Block fromBlock, Block toBlock) {
        TapList<BoolVector> originActivs;
        BoolVector originExitActiv;
        BoolVector destinationEntryActiv;
        if (!this.adEnv.curUnitIsActiveUnit || this.adEnv.curUnitIsContext) {
            return false;
        }
        SymbolTable commonSymbolTable = fromBlock.symbolTable.getCommonRoot(toBlock.symbolTable);
        int nDRZ = commonSymbolTable.declaredZonesNb(this.adEnv.diffKind);
        int[] originInfoMap = DataFlowAnalyzer.makeMap3(this.adEnv.curUnit(), fromBlock, this.adEnv.diffKind);
        int[] destInfoMap = DataFlowAnalyzer.makeMap3(this.adEnv.curUnit(), toBlock, this.adEnv.diffKind);
        TapList<BoolVector> destActivs = toBlock.rank == -99 ? ((TemporaryBlock)toBlock).blockActivities : (this.adEnv.unitActivities == null ? null : this.adEnv.unitActivities.retrieve(toBlock));
        BoolVector boolVector = destinationEntryActiv = destActivs == null ? null : (BoolVector)destActivs.head;
        if (destinationEntryActiv == null) {
            destinationEntryActiv = new BoolVector(DataFlowAnalyzer.mapSize(destInfoMap));
            destinationEntryActiv.setTrue();
        }
        if (this.curDiffUnitSort() == 2 && toBlock instanceof ExitBlock) {
            destinationEntryActiv = this.removeActivePassedByValue(destinationEntryActiv, destInfoMap, toBlock.symbolTable);
        }
        if ((originExitActiv = TapList.last(originActivs = fromBlock.rank == -99 ? ((TemporaryBlock)fromBlock).blockActivities : (this.adEnv.unitActivities == null ? null : this.adEnv.unitActivities.retrieve(fromBlock)))) == null) {
            originExitActiv = new BoolVector(DataFlowAnalyzer.mapSize(originInfoMap));
            originExitActiv.setTrue();
        }
        boolean entersDiffUnit = this.curDiffUnitSort() == 2 ? toBlock instanceof ExitBlock : fromBlock instanceof EntryBlock;
        BoolVector activityBefore = this.curDiffUnitSort() == 2 ? destinationEntryActiv : originExitActiv;
        BoolVector activityAfter = this.curDiffUnitSort() == 2 ? originExitActiv : destinationEntryActiv;
        SymbolTable postSymbolTable = this.curDiffUnitSort() == 2 ? fromBlock.symbolTable : toBlock.symbolTable;
        int postnDRZ = postSymbolTable.declaredZonesNb(this.adEnv.diffKind);
        for (int i = postnDRZ - 1; i >= 0; --i) {
            int vectorIndex;
            ZoneInfo zoneInfo = postSymbolTable.declaredZoneInfo(i, this.adEnv.diffKind);
            if (zoneInfo == null || zoneInfo.isHidden || !this.zoneActivitySwitches(zoneInfo, vectorIndex = DataFlowAnalyzer.zoneInfoToVectorIndex(zoneInfo, 3, this.adEnv.diffKind, originInfoMap, null), i >= nDRZ, entersDiffUnit, activityBefore, activityAfter)) continue;
            return true;
        }
        return false;
    }

    private boolean sameActivitySwitches(Block fromBlock, FGArrow arrow1, FGArrow arrow2) {
        TapList<BoolVector> originActivs;
        BoolVector originExitActiv;
        if (this.curDiffUnitSort() != 2) {
            TapEnv.toolWarning(-1, "sameActivitySwitches() is implemented only for reverse mode");
            return false;
        }
        if (!this.adEnv.curUnitIsActiveUnit || this.adEnv.curUnitIsContext) {
            return true;
        }
        Block toBlock1 = arrow1.destination;
        Block toBlock2 = arrow2.destination;
        SymbolTable srcSymbolTable = fromBlock.symbolTable;
        SymbolTable commonSymbolTable1 = fromBlock.symbolTable.getCommonRoot(toBlock1.symbolTable);
        SymbolTable commonSymbolTable2 = fromBlock.symbolTable.getCommonRoot(toBlock2.symbolTable);
        int srcnDRZ = srcSymbolTable.declaredZonesNb(this.adEnv.diffKind);
        int nDRZ1 = commonSymbolTable1.declaredZonesNb(this.adEnv.diffKind);
        int nDRZ2 = commonSymbolTable2.declaredZonesNb(this.adEnv.diffKind);
        boolean entersDiffUnit1 = this.curDiffUnitSort() == 2 ? toBlock1 instanceof ExitBlock : fromBlock instanceof EntryBlock;
        boolean entersDiffUnit2 = this.curDiffUnitSort() == 2 ? toBlock2 instanceof ExitBlock : fromBlock instanceof EntryBlock;
        int[] originInfoMap = DataFlowAnalyzer.makeMap3(this.adEnv.curUnit(), fromBlock, this.adEnv.diffKind);
        TapList<BoolVector> destActivs1 = toBlock1.rank == -99 ? ((TemporaryBlock)toBlock1).blockActivities : (this.adEnv.unitActivities == null ? null : this.adEnv.unitActivities.retrieve(toBlock1));
        BoolVector destinationEntryActiv1 = destActivs1 == null ? null : (BoolVector)destActivs1.head;
        int[] destInfoMap1 = DataFlowAnalyzer.makeMap3(this.adEnv.curUnit(), toBlock1, this.adEnv.diffKind);
        if (destinationEntryActiv1 == null) {
            destinationEntryActiv1 = new BoolVector(DataFlowAnalyzer.mapSize(destInfoMap1));
            destinationEntryActiv1.setTrue();
        }
        if (this.curDiffUnitSort() == 2 && toBlock1 instanceof ExitBlock) {
            destinationEntryActiv1 = this.removeActivePassedByValue(destinationEntryActiv1, destInfoMap1, toBlock1.symbolTable);
        }
        TapList<BoolVector> destActivs2 = toBlock2.rank == -99 ? ((TemporaryBlock)toBlock2).blockActivities : (this.adEnv.unitActivities == null ? null : this.adEnv.unitActivities.retrieve(toBlock2));
        BoolVector destinationEntryActiv2 = destActivs2 == null ? null : (BoolVector)destActivs2.head;
        int[] destInfoMap2 = DataFlowAnalyzer.makeMap3(this.adEnv.curUnit(), toBlock2, this.adEnv.diffKind);
        if (destinationEntryActiv2 == null) {
            destinationEntryActiv2 = new BoolVector(DataFlowAnalyzer.mapSize(destInfoMap2));
            destinationEntryActiv2.setTrue();
        }
        if (this.curDiffUnitSort() == 2 && toBlock2 instanceof ExitBlock) {
            destinationEntryActiv2 = this.removeActivePassedByValue(destinationEntryActiv2, destInfoMap2, toBlock2.symbolTable);
        }
        if ((originExitActiv = TapList.last(originActivs = fromBlock.rank == -99 ? ((TemporaryBlock)fromBlock).blockActivities : (this.adEnv.unitActivities == null ? null : this.adEnv.unitActivities.retrieve(fromBlock)))) == null) {
            originExitActiv = new BoolVector(DataFlowAnalyzer.mapSize(originInfoMap));
            originExitActiv.setTrue();
        }
        for (int i = srcnDRZ - 1; i >= 0; --i) {
            boolean mustReinitialize2;
            int vectorIndex;
            boolean mustReinitialize1;
            ZoneInfo zoneInfo = srcSymbolTable.declaredZoneInfo(i, this.adEnv.diffKind);
            if (zoneInfo == null || zoneInfo.isHidden || (mustReinitialize1 = this.zoneActivitySwitches(zoneInfo, vectorIndex = DataFlowAnalyzer.zoneInfoToVectorIndex(zoneInfo, 3, this.adEnv.diffKind, originInfoMap, null), i >= nDRZ1, entersDiffUnit1, destinationEntryActiv1, originExitActiv)) == (mustReinitialize2 = this.zoneActivitySwitches(zoneInfo, vectorIndex, i >= nDRZ2, entersDiffUnit2, destinationEntryActiv2, originExitActiv))) continue;
            return false;
        }
        return true;
    }

    private BoolVector removeActivePassedByValue(BoolVector destinationEntryActiv, int[] destInfoMap, SymbolTable destSymbolTable) {
        destinationEntryActiv = destinationEntryActiv.copy();
        int nbFormalArgs = this.adEnv.curUnit().functionTypeSpec().argumentsTypes == null ? 0 : this.adEnv.curUnit().functionTypeSpec().argumentsTypes.length;
        Tree[] args = ILUtils.getArguments(this.adEnv.curUnit().headTree()).children();
        UnitDiffInfo diffInfo = this.callGraphDifferentiator().getUnitDiffInfo(this.adEnv.curUnit());
        boolean[] diffArgsByValueNeedOverwrite = diffInfo.getUnitDiffArgsByValueNeedOverwriteInfoS(this.adEnv.curActivity());
        boolean[] diffArgsByValueNeedOnlyIncrement = diffInfo.getUnitDiffArgsByValueNeedOnlyIncrementInfoS(this.adEnv.curActivity());
        for (int j = nbFormalArgs; j > 0; --j) {
            if (!this.adEnv.curUnit().takesArgumentByValue(j, this.adEnv.curUnit().language()) || diffArgsByValueNeedOverwrite == null || !diffArgsByValueNeedOverwrite[j] || diffArgsByValueNeedOnlyIncrement == null || diffArgsByValueNeedOnlyIncrement[j]) continue;
            TapIntList topZonesOfArg = ZoneInfo.listAllZones(destSymbolTable.treeOfZonesOfValue(args[j - 1], null, null, null), false);
            while (topZonesOfArg != null) {
                int index = DataFlowAnalyzer.extendedDeclaredToVectorIndex(topZonesOfArg.head, this.adEnv.diffKind, destInfoMap, destSymbolTable, null);
                destinationEntryActiv.set(index, false);
                topZonesOfArg = topZonesOfArg.tail;
            }
        }
        return destinationEntryActiv;
    }

    private boolean zoneActivitySwitches(ZoneInfo zoneInfo, int vectorIndex, boolean entersScope, boolean entersDiffUnit, BoolVector activityBefore, BoolVector activityAfter) {
        boolean switches = false;
        if (!(zoneInfo.comesFromAllocate() || zoneInfo.isChannelOrIO || !zoneInfo.isOnceActive() && TapEnv.doActivity() || this.curDiffUnit().language() == 4 && zoneInfo.isResult())) {
            switches = !TapEnv.spareDiffReinitializations() ? entersScope || entersDiffUnit && !activityBefore.get(vectorIndex) && (zoneInfo.isParameter() || zoneInfo.isGlobal() && zoneInfo.commonName != null && !this.adEnv.commonActivityMemoryMap.getSetMemMap(zoneInfo.commonName).isActiveRegion(zoneInfo.startOffset, zoneInfo.endOffset, zoneInfo.infiniteEndOffset)) : (TapEnv.debugAdMode() != -1 ? (entersScope || !activityBefore.get(vectorIndex)) && (activityAfter.get(vectorIndex) || entersScope && TapEnv.get().absLinearForm) : entersScope || !activityBefore.get(vectorIndex) && activityAfter.get(vectorIndex));
        }
        return switches;
    }

    protected void differentiateSaveList(SymbolTable diffSymbolTable) {
        if (diffSymbolTable != null && diffSymbolTable.saveList != null && (this.adEnv.curUnit().isModule() || this.adEnv.curUnit().isInterface() || this.adEnv.curUnit().isStandard() && this.curDiffUnitSort() != 2)) {
            TapList<Tree> inNonDiffSaveList = diffSymbolTable.saveList;
            TapList<Tree> diffSaveList = null;
            while (inNonDiffSaveList != null) {
                Tree[] expressions = ((Tree)inNonDiffSaveList.head).children();
                TapList<Tree> diffExpressions = null;
                for (int i = expressions.length - 1; i >= 0; --i) {
                    Tree saveExpression = this.differentiateSaveVarRef(expressions[i], diffSymbolTable);
                    if (saveExpression == null) continue;
                    diffExpressions = new TapList<Tree>(saveExpression, diffExpressions);
                }
                if (diffExpressions != null) {
                    diffSaveList = new TapList<Tree>(ILUtils.build(171, diffExpressions), diffSaveList);
                }
                inNonDiffSaveList = inNonDiffSaveList.tail;
            }
            diffSymbolTable.saveList = TapList.append(diffSymbolTable.saveList, diffSaveList);
        }
    }

    private Tree differentiateSaveVarRef(Tree expression, SymbolTable diffSymbolTable) {
        switch (expression.opCode()) {
            case 9: 
            case 75: {
                return ILUtils.build(expression.opCode(), this.differentiateSaveVarRef(expression.down(1), diffSymbolTable), ILUtils.copy(expression.down(2)));
            }
            case 96: {
                VariableDecl varDecl = diffSymbolTable.getVariableDecl(ILUtils.getIdentString(expression));
                NewSymbolHolder diffSymbolHolder = null;
                if (varDecl != null) {
                    diffSymbolHolder = varDecl.getDiffSymbolHolder(this.curDiffVarSort(), null, 0);
                }
                if (diffSymbolHolder != null && diffSymbolHolder.newVariableDecl() != null) {
                    diffSymbolHolder.declarationLevelMustInclude(diffSymbolTable);
                    return diffSymbolHolder.makeNewRef(diffSymbolTable);
                }
                return null;
            }
        }
        TapEnv.toolWarning(-1, "(Differentiate reference in Save) Unexpected operator: " + expression.opName());
        return null;
    }

    protected void initializeMultiDirMode() {
        if (this.multiDirMode()) {
            NewSymbolHolder ndVar;
            SymbolTable diffPublicSymbolTable = this.curDiffUnit().publicSymbolTable();
            this.varRefDifferentiator().dirIndexSymbolHolder = ndVar = new NewSymbolHolder("nd");
            ndVar.setAsVariable(this.adEnv.integerTypeSpec, null);
            ndVar.prepareDeclarationInstr(this.curDiffUnit());
            if (!this.adEnv.curUnit().isPackage()) {
                Tree oneNbDirsTree;
                if (TapEnv.get().fixedNbdirsString != null) {
                    try {
                        int nbdirsint = Integer.parseInt(TapEnv.get().fixedNbdirsString);
                        TapEnv.get().fixedNbdirsTree = ILUtils.build(103, nbdirsint);
                    }
                    catch (NumberFormatException e) {
                        TapEnv.get().fixedNbdirsTree = ILUtils.build(96, TapEnv.get().fixedNbdirsString);
                    }
                    oneNbDirsTree = ILUtils.copy(TapEnv.get().fixedNbdirsTree);
                } else {
                    NewSymbolHolder nbdirsVar;
                    this.varRefDifferentiator().dirNumberSymbolHolder = nbdirsVar = new NewSymbolHolder("nbdirs");
                    nbdirsVar.setAsVariable(this.adEnv.integerTypeSpec, null);
                    if (!this.curDiffUnit().isC()) {
                        nbdirsVar.prepareDeclarationInstr(this.curDiffUnit());
                    }
                    nbdirsVar.declarationLevelMustInclude(diffPublicSymbolTable);
                    oneNbDirsTree = nbdirsVar.makeNewRef(diffPublicSymbolTable);
                }
                (this.varRefDifferentiator().multiDirIterDescriptor = new IterDescriptor(ndVar)).setInitTree(ILUtils.build(103, TapEnv.relatedLanguageIsC() ? 0 : 1));
                this.varRefDifferentiator().multiDirIterDescriptor.setLengthTree(oneNbDirsTree);
                this.varRefDifferentiator().multiDirIterDescriptor.isArray = this.adEnv.adDiffMode == 1 && TapEnv.relatedLanguageIsFortran9x();
                this.varRefDifferentiator().multiDirIterDescriptor.isImplicitCompleteDimension = false;
            }
            SymbolTable diffPrivateSymbolTable = this.curDiffUnit().privateSymbolTable();
            if (!this.adEnv.curUnit().isInterface() && diffPrivateSymbolTable != null) {
                ndVar.declarationLevelMustInclude(diffPrivateSymbolTable);
            }
            this.initializeMultiDirNumberMax();
            if (!this.adEnv.curUnit().isModule()) {
                this.varRefDifferentiator().multiDirMaxIterDescriptor = new IterDescriptor(ndVar);
                this.varRefDifferentiator().multiDirMaxIterDescriptor.setInitTree(ILUtils.build(103, TapEnv.relatedLanguageIsC() ? 0 : 1));
                this.varRefDifferentiator().multiDirMaxIterDescriptor.setLengthTree(ILUtils.copy(TapEnv.get().fixedNbdirsmaxTree));
                this.varRefDifferentiator().multiDirMaxIterDescriptor.isArray = TapEnv.relatedLanguageIsFortran9x();
            }
        }
    }

    protected void initializeMultiDirNumberMax() {
        if (TapEnv.get().fixedNbdirsmaxString != null) {
            try {
                int nbdirsmaxint = Integer.parseInt(TapEnv.get().fixedNbdirsmaxString);
                TapEnv.get().fixedNbdirsmaxTree = ILUtils.build(103, nbdirsmaxint);
            }
            catch (NumberFormatException e) {
                TapEnv.get().fixedNbdirsmaxTree = ILUtils.build(96, TapEnv.get().fixedNbdirsmaxString);
            }
            this.curDiffUnit().multiDirDimensionMax = new ArrayDim(ILUtils.buildDimColon(this.curDiffUnit().arrayDimMin, TapEnv.get().fixedNbdirsmaxTree), null, null, null, -1, 0, 0);
        } else if (this.curDiffUnit().dirNumberMaxSymbolHolder == null) {
            NewSymbolHolder nbDirsMaxVar;
            this.curDiffUnit().dirNumberMaxSymbolHolder = nbDirsMaxVar = new NewSymbolHolder("NBDirsMax");
            nbDirsMaxVar.setAsConstantVariable(this.adEnv.integerTypeSpec, null, ILUtils.build(96, "TO_BE_DEFINED"));
            nbDirsMaxVar.declarationLevelMustInclude(this.curDiffUnit().publicSymbolTable());
            nbDirsMaxVar.declare = false;
            TapEnv.get().fixedNbdirsmaxTree = nbDirsMaxVar.makeNewRef(this.curDiffUnit().publicSymbolTable());
            this.curDiffUnit().multiDirDimensionMax = new ArrayDim(ILUtils.buildDimColon(this.curDiffUnit().arrayDimMin, TapEnv.get().fixedNbdirsmaxTree), null, null, null, -1, 0, 0);
        }
    }

    private void resetIsDifferentiatedDeclInstructions(Unit unit) {
        TapList<Block> blocks = unit.allBlocks();
        while (blocks != null) {
            Block block = (Block)blocks.head;
            TapList<Instruction> instructions = block.instructions;
            while (instructions != null) {
                Instruction instruction = (Instruction)instructions.head;
                instruction.isDifferentiated = false;
                instructions = instructions.tail;
            }
            blocks = blocks.tail;
        }
    }

    private void insertADBanner(Unit unit, Unit diffUnit, ActivityPattern activityPattern, String modeString, String line1, BoolVector exitActives, String line2, BoolVector callActives, BoolVector reqXRequired, BoolVector reqXManaged, boolean noFwd) {
        TapList<Object> hdLines;
        BoolVector killedZones = null;
        if (!TapEnv.doActivity() && !this.adEnv.curUnitIsContext) {
            callActives = unit.getTmpALLKINDPossiblyR();
            exitActives = unit.getTmpALLKINDPossiblyW();
            killedZones = unit.getTmpALLKINDK();
        }
        BoolMatrix deps = this.activityAnalyzer().getPublicDeps(unit);
        if (exitActives != null && callActives != null && deps != null) {
            exitActives = exitActives.copy();
            callActives = callActives.copy();
            this.updateVariedUsefulWithDepsAndDiffMode(callActives, exitActives, unit, deps);
        }
        TapList<Object> tlLines = hdLines = new TapList<Object>(null, null);
        if (unit.language() == 4) {
            tlLines = tlLines.placdl(ILUtils.build(180, ""));
        }
        BoolVector diffFormalRequired = !TapEnv.doActivity() || this.activityAnalyzer() == null ? null : ADActivityAnalyzer.functionDiffFormalRequired(this.adEnv.curActivity(), false);
        String str = "  Differentiation of " + unit.name() + modeString;
        if (!TapEnv.optionsString().isEmpty()) {
            str = str + " (with options" + TapEnv.optionsString() + ')';
        }
        str = str + ':';
        tlLines = tlLines.placdl(ILUtils.build(180, str));
        TapList<String> callActiveNames = null;
        TapList<String> exitActiveNames = null;
        TapList<Object> reqXNames = null;
        TapList<String> rwStatus = null;
        int nbPubZ = unit.paramElemsNb();
        for (int i = nbPubZ - 1; i >= 0; --i) {
            boolean requrz;
            ZoneInfo zoneInfo = unit.paramElemZoneInfo(i);
            PublicInfo publicInfo = unit.paramElemPublicInfo(i);
            boolean isDiffType = zoneInfo.realZoneNb != -1;
            String varName = null;
            if (zoneInfo.zoneNb >= this.adEnv.srcCallGraph().numberOfDummyRootZones && !zoneInfo.isChannelOrIO) {
                if (zoneInfo.description != null && (zoneInfo.isHidden || unit.upperLevelUnit != null && !unit.upperLevelUnit.isPackage())) {
                    varName = zoneInfo.description;
                } else if (zoneInfo.accessTree != null) {
                    varName = zoneInfo.accessTreePrint(unit.language());
                    if (zoneInfo.isHidden) {
                        varName = "(Hidden)" + varName;
                    }
                }
            }
            if (varName == null || zoneInfo.ownerSymbolDecl != null && zoneInfo.ownerSymbolDecl.isSystemPredefined()) continue;
            boolean indepz = callActives != null && isDiffType && callActives.get(i);
            boolean depz = exitActives != null && isDiffType && exitActives.get(i);
            boolean killedz = killedZones != null && killedZones.get(i);
            String inStatus = null;
            String outStatus = null;
            if (this.curDiffUnitSort() == 2) {
                if (TapEnv.doActivity()) {
                    if (depz) {
                        inStatus = "in";
                    }
                    int columnType = -1;
                    if (deps != null) {
                        columnType = this.depsColumnType(deps, i);
                    }
                    switch (columnType) {
                        case 0: {
                            outStatus = indepz ? "zero" : (depz ? "killed" : null);
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            outStatus = indepz ? (depz ? "incr" : "out") : (depz ? "killed" : null);
                            inStatus = null;
                            break;
                        }
                        default: {
                            outStatus = indepz ? "out" : (depz ? "killed" : null);
                            break;
                        }
                    }
                } else {
                    String string = depz ? "in" : (inStatus = indepz ? "incr" : null);
                    outStatus = depz ? (!indepz && killedz ? "zero" : "out") : null;
                }
            } else if (TapEnv.doActivity()) {
                if (indepz) {
                    inStatus = "in";
                }
                if (deps == null || deps.getRow(i) != null && !zoneInfo.passesByValue(unit, unit.language())) {
                    outStatus = deps != null && deps.getRow(i).isFalse(nbPubZ) ? (depz ? "zero" : (indepz ? "killed" : null)) : (depz ? "out" : (indepz ? "killed" : null));
                }
            } else {
                inStatus = indepz ? "in" : null;
                String string = outStatus = depz ? "out" : null;
            }
            if (indepz) {
                callActiveNames = new TapList<String>(varName, callActiveNames);
            }
            if (depz) {
                exitActiveNames = new TapList<String>(varName, exitActiveNames);
            }
            String statusTxt = null;
            if (inStatus != null || outStatus != null) {
                statusTxt = inStatus == null ? outStatus : (outStatus == null ? inStatus : inStatus + "-" + outStatus);
            } else if (diffFormalRequired != null && diffFormalRequired.get(i) && !zoneInfo.comesFromAllocate()) {
                statusTxt = "(loc)";
            }
            if (statusTxt != null) {
                rwStatus = new TapList<String>(varName + ':' + statusTxt, rwStatus);
            }
            boolean managz = reqXManaged != null && reqXManaged.get(i);
            boolean bl = requrz = reqXRequired != null && reqXRequired.get(i);
            if (!managz && !requrz) continue;
            statusTxt = managz ? (requrz ? "in-out" : "out") : "in";
            reqXNames = new TapList<String>(varName + ':' + statusTxt, reqXNames);
        }
        if (!TapEnv.doActivity() && !this.adEnv.curUnitIsContext && exitActiveNames == null) {
            exitActiveNames = new TapList<String>("(none)", null);
        }
        if (exitActiveNames != null) {
            str = line1;
            while (exitActiveNames != null) {
                if (str.length() > 60) {
                    tlLines = tlLines.placdl(ILUtils.build(180, str));
                    str = "               ";
                }
                str = str + ' ' + (String)exitActiveNames.head;
                exitActiveNames = exitActiveNames.tail;
            }
            tlLines = tlLines.placdl(ILUtils.build(180, str));
        }
        if (!TapEnv.doActivity() && !this.adEnv.curUnitIsContext && callActiveNames == null) {
            callActiveNames = new TapList<String>("(none)", null);
        }
        if (callActiveNames != null) {
            str = line2;
            while (callActiveNames != null) {
                if (str.length() > 60) {
                    tlLines = tlLines.placdl(ILUtils.build(180, str));
                    str = "               ";
                }
                str = str + ' ' + (String)callActiveNames.head;
                callActiveNames = callActiveNames.tail;
            }
            tlLines = tlLines.placdl(ILUtils.build(180, str));
        }
        if (!TapEnv.doActivity() && !this.adEnv.curUnitIsContext && rwStatus == null) {
            rwStatus = new TapList<String>("(none)", null);
        }
        if (noFwd && rwStatus != null && (activityPattern.diffPattern() != null || TapList.contains(this.adEnv.rootUnits, unit))) {
            str = "   RW status of diff variables:";
            while (rwStatus != null) {
                if (str.length() > 60) {
                    tlLines = tlLines.placdl(ILUtils.build(180, str));
                    str = "               ";
                }
                str = str + ' ' + (String)rwStatus.head;
                rwStatus = rwStatus.tail;
            }
            tlLines = tlLines.placdl(ILUtils.build(180, str));
        }
        if (reqXNames != null) {
            str = "   Plus diff mem management of:";
            while (reqXNames != null) {
                if (str.length() > 60) {
                    tlLines = tlLines.placdl(ILUtils.build(180, str));
                    str = "               ";
                }
                str = str + ' ' + (String)reqXNames.head;
                reqXNames = reqXNames.tail;
            }
            tlLines = tlLines.placdl(ILUtils.build(180, str));
        }
        if (unit.language() == 4) {
            tlLines = tlLines.placdl(ILUtils.build(180, ""));
        }
        int commentsOperator = 37;
        if (unit.language() == 4) {
            commentsOperator = 38;
        }
        Tree preComments = diffUnit.preComments;
        if (diffUnit.language() == 4) {
            preComments = diffUnit.preCommentsBlock;
        }
        preComments = ILUtils.appendComments(ILUtils.build(commentsOperator, hdLines.tail), preComments);
        if (diffUnit.language() == 4) {
            diffUnit.preCommentsBlock = preComments;
        } else {
            diffUnit.preComments = preComments;
        }
    }

    private void updateVariedUsefulWithDepsAndDiffMode(BoolVector variedOnCall, BoolVector usefulOnExit, Unit unit, BoolMatrix deps) {
        if (this.curDiffUnitSort() == 2) {
            this.activityAnalyzer();
            BoolVector modifiedFromUseful = ADActivityAnalyzer.getUpdateModifiedZonesT(deps, usefulOnExit);
            usefulOnExit.cumulAnd(this.getReadZonesT(deps, variedOnCall, usefulOnExit));
            variedOnCall.cumulAnd(modifiedFromUseful);
        } else {
            this.activityAnalyzer();
            BoolVector modifiedFromVaried = ADActivityAnalyzer.getUpdateModifiedZones(deps, variedOnCall, unit);
            variedOnCall.cumulAnd(this.getReadZones(deps, usefulOnExit));
            if (TapEnv.debugAdMode() != -1) {
                usefulOnExit.cumulAnd(modifiedFromVaried);
            }
        }
        this.activityAnalyzer().putBackSharingZones(variedOnCall, usefulOnExit, unit);
    }

    private BoolVector getReadZones(BoolMatrix deps, BoolVector usefulOnExit) {
        BoolVector result = new BoolVector(deps.getNCols());
        for (int i = deps.getNRows() - 1; i >= 0; --i) {
            if (deps.getRow(i) == null || !usefulOnExit.get(i)) continue;
            result.cumulOr(deps.getRow(i));
        }
        return result;
    }

    private BoolVector getReadZonesT(BoolMatrix deps, BoolVector variedOnCall, BoolVector usefulOnExit) {
        BoolVector result = new BoolVector(deps.getNCols());
        BoolVector columnsRead = new BoolVector(deps.getNCols());
        for (int i = deps.getNRows() - 1; i >= 0; --i) {
            BoolVector variedRow;
            if (deps.getRow(i) == null || !usefulOnExit.get(i) || (variedRow = deps.getRow(i).and(variedOnCall)).isFalse(deps.getNCols())) continue;
            result.set(i, true);
            columnsRead.cumulOr(variedRow);
        }
        for (int j = deps.getNCols() - 1; j >= 0; --j) {
            if (deps.getRow(j) != null || !columnsRead.get(j)) continue;
            result.set(j, true);
        }
        return result;
    }

    private int depsColumnType(BoolMatrix deps, int j) {
        boolean hasId = false;
        boolean hasNonZero = false;
        for (int i = deps.getNRows() - 1; i >= 0; --i) {
            if (deps.isImplicitIdentityRow(i)) {
                if (i != j) continue;
                hasId = true;
                continue;
            }
            if (!deps.get(i, j)) continue;
            hasNonZero = true;
        }
        return hasNonZero ? (hasId ? 2 : 3) : (hasId ? 1 : 0);
    }

    private boolean oneFirstIsNonNull(TapList<TapPair<FGArrow, TapList<BwdSwitchCase>>> list) {
        boolean result = false;
        while (!result && list != null) {
            result = ((TapPair)list.head).first != null;
            list = list.tail;
        }
        return result;
    }

    protected void declareDiffIsReturnVar(VariableDecl returnVarDecl, Unit unit, Unit diffUnit) {
        VariableDecl diffReturnVarDecl;
        NewSymbolHolder symbolHolder = returnVarDecl.getDiffSymbolHolder(this.curDiffVarSort(), null, 0);
        if (symbolHolder == null) {
            this.varRefDifferentiator().diffSymbolName(this.adEnv.curActivity(), returnVarDecl.symbol, diffUnit.publicSymbolTable(), true, false, false, null, null, false, this.curDiffVarSort(), this.curDiffUnitSort(), 0, null);
            symbolHolder = returnVarDecl.getDiffSymbolHolder(this.curDiffVarSort(), null, 0);
            symbolHolder.declarationLevelMustInclude(diffUnit.publicSymbolTable());
            symbolHolder.solvingLevelMustInclude(diffUnit.publicSymbolTable());
            symbolHolder.makeNewRef(diffUnit.publicSymbolTable());
        }
        if ((diffReturnVarDecl = symbolHolder.newVariableDecl()) != null) {
            diffReturnVarDecl.setReturnVar();
            if (unit.otherReturnVar() != null) {
                diffUnit.setOtherReturnVar(diffReturnVarDecl);
            }
        }
    }

    private void makeSurePrivate(Tree ident, Tree clauses) {
        ident = ILUtils.baseTree(ident);
        String name = ILUtils.getIdentString(ident);
        boolean found = false;
        Tree[] allClauses = clauses.children();
        for (int i = allClauses.length - 1; i >= 0 && !found; --i) {
            if (allClauses[i].opCode() != 157) continue;
            found = ILUtils.contains(allClauses[i].down(1), name, false);
        }
        if (!found) {
            clauses.addChild(ILUtils.build(157, ILUtils.build(97, ILUtils.copy(ident))), -1);
        }
    }

    private boolean opensCurrentControl(HeaderBlock block) {
        if (block.parallelControls == null) {
            return false;
        }
        FGArrow entryArrow = null;
        TapList<FGArrow> arrivingArrows = block.backFlow();
        while (arrivingArrows != null && entryArrow == null) {
            if (!((FGArrow)arrivingArrows.head).inACycle) {
                entryArrow = (FGArrow)arrivingArrows.head;
            }
            arrivingArrows = arrivingArrows.tail;
        }
        return entryArrow != null && entryArrow.origin.isParallelController() && entryArrow.origin.instructions.head == block.parallelControls.head;
    }

    private void instrumentTraceOnUnit(Unit unit, Block upstreamBlock, Block downstreamBlock, FlowGraphDifferentiationEnv diffEnv) {
        Tree dbadTree;
        int[] vectorMap = DataFlowAnalyzer.makeMap3(unit, this.adEnv.diffKind);
        int[] allKindMap = DataFlowAnalyzer.makeMap3(unit, 0);
        SymbolTable symbolTable = unit.publicSymbolTable();
        if (upstreamBlock != null) {
            BoolVector activeAtBegin;
            int[] entryBlockInfoMap = DataFlowAnalyzer.makeMap3(unit, unit.entryBlock(), this.adEnv.diffKind);
            BoolVector boolVector = activeAtBegin = this.adEnv.unitActivities == null ? null : (BoolVector)this.adEnv.unitActivities.retrieve((Block)unit.entryBlock()).head;
            if (!TapEnv.doActivity() && activeAtBegin == null) {
                activeAtBegin = new BoolVector(DataFlowAnalyzer.mapSize(entryBlockInfoMap));
                activeAtBegin.setTrue();
            }
            if (TapEnv.debugAdMode() == 1 && !TapEnv.get().debugPassives) {
                BoolVector read = DataFlowAnalyzer.changeKind(unit.unitInOutPossiblyR(), allKindMap, 0, vectorMap, this.adEnv.diffKind, symbolTable);
                activeAtBegin = activeAtBegin.copy();
                activeAtBegin.cumulAnd(read);
            }
            this.adEnv.setCurInstruction(upstreamBlock.firstInstrAfterDecls());
            dbadTree = this.placeDebugADTests(this.curDiffUnit(), null, activeAtBegin, entryBlockInfoMap, -1, symbolTable, symbolTable.declaredZonesNb(this.adEnv.diffKind), "entry", null, ILUtils.build(28, this.curDiffUnit().isC() ? "1" : "TRUE"), ILUtils.build(28, this.curDiffUnit().isC() ? "0" : "FALSE"));
            if (this.adEnv.traceCurDifferentiation) {
                TapEnv.printlnOnTrace(" using activity vector at begin:" + activeAtBegin);
                TapEnv.printlnOnTrace("!Augment " + upstreamBlock + " with debug-instrument actives at upstream end : " + ILUtils.toString(dbadTree, this.adEnv.curActivity()));
            }
            upstreamBlock.addInstrHdAfterDecls(dbadTree);
        }
        if (downstreamBlock != null) {
            boolean needTerminationBlock = false;
            BoolVector overwritten = null;
            if (TapEnv.debugAdMode() == 1) {
                overwritten = DataFlowAnalyzer.changeKind(unit.unitInOutPossiblyW(), allKindMap, 0, vectorMap, this.adEnv.diffKind, symbolTable);
            }
            TapList<Block> lastNonEmptyBlocks = this.collectLastNonEmptyBlocks(downstreamBlock.backFlow(), null, new TapList<Object>(null, null));
            while (lastNonEmptyBlocks != null) {
                Block prevBlock = (Block)lastNonEmptyBlocks.head;
                if (prevBlock.lastTest() == 168) {
                    Block origOfPrevBlock = diffEnv.retrieveOrigBlockOf(prevBlock);
                    if (origOfPrevBlock == null) {
                        origOfPrevBlock = (Block)TapList.cassq(prevBlock.lastInstr(), this.realOrigBlockOfReturns);
                    }
                    int[] returnBlockInfoMap = DataFlowAnalyzer.makeMap3(unit, origOfPrevBlock, this.adEnv.diffKind);
                    BoolVector activeAtReturn = null;
                    if (this.adEnv.unitActivities != null) {
                        TapList<BoolVector> blockActivities = this.adEnv.unitActivities.retrieve(origOfPrevBlock);
                        activeAtReturn = TapList.last(blockActivities);
                    }
                    activeAtReturn = this.patchActivityForDebug(activeAtReturn, returnBlockInfoMap, overwritten, vectorMap);
                    this.adEnv.setCurInstruction(prevBlock.lastInstr());
                    dbadTree = this.placeDebugADTests(this.curDiffUnit(), null, activeAtReturn, returnBlockInfoMap, 1, origOfPrevBlock.symbolTable, symbolTable.declaredZonesNb(this.adEnv.diffKind), "exit", origOfPrevBlock.lastInstr(), ILUtils.build(28, this.curDiffUnit().isC() ? "1" : "TRUE"), ILUtils.build(28, this.curDiffUnit().isC() ? "0" : "FALSE"));
                    if (this.adEnv.traceCurDifferentiation) {
                        TapEnv.printlnOnTrace(" using activity vector at return:" + activeAtReturn);
                        TapEnv.printlnOnTrace("!Augment " + prevBlock + " with debug-instrument actives at downstream end, before return : " + ILUtils.toString(dbadTree, this.adEnv.curActivity()));
                    }
                    prevBlock.addInstructionAt(dbadTree, -2);
                } else {
                    needTerminationBlock = true;
                }
                lastNonEmptyBlocks = lastNonEmptyBlocks.tail;
            }
            if (needTerminationBlock) {
                BoolVector activeAtEnd = null;
                if (this.adEnv.unitActivities != null) {
                    activeAtEnd = (BoolVector)this.adEnv.unitActivities.retrieve((Block)unit.exitBlock()).head;
                }
                int[] exitBlockInfoMap = DataFlowAnalyzer.makeMap3(unit, unit.exitBlock(), this.adEnv.diffKind);
                activeAtEnd = this.patchActivityForDebug(activeAtEnd, exitBlockInfoMap, overwritten, vectorMap);
                this.adEnv.setCurInstruction(downstreamBlock.lastInstr());
                dbadTree = this.placeDebugADTests(this.curDiffUnit(), null, activeAtEnd, exitBlockInfoMap, 1, symbolTable, symbolTable.declaredZonesNb(this.adEnv.diffKind), "exit", null, ILUtils.build(28, this.curDiffUnit().isC() ? "1" : "TRUE"), ILUtils.build(28, this.curDiffUnit().isC() ? "0" : "FALSE"));
                if (this.adEnv.traceCurDifferentiation) {
                    TapEnv.printlnOnTrace(" using activity vector at end:" + activeAtEnd);
                    TapEnv.printlnOnTrace("!Augment " + downstreamBlock + " with debug-instrument actives at downstream end : " + ILUtils.toString(dbadTree, this.adEnv.curActivity()));
                }
                downstreamBlock.addInstrHdAfterDecls(dbadTree);
            }
        }
        this.adEnv.setCurInstruction(null);
    }

    private BoolVector patchActivityForDebug(BoolVector activity, int[] activityMap, BoolVector overwritten, int[] overwrittenMap) {
        if (!TapEnv.doActivity() && activity == null) {
            activity = new BoolVector(DataFlowAnalyzer.mapSize(activityMap));
            activity.setTrue();
        }
        if (TapEnv.debugAdMode() == 1 && !TapEnv.get().debugPassives) {
            assert (activity != null);
            activity = activity.copy();
            assert (overwritten != null);
            activity.cumulAnd(overwritten, DataFlowAnalyzer.mapSize(overwrittenMap));
        }
        return activity;
    }

    private TapList<Block> collectLastNonEmptyBlocks(TapList<FGArrow> backFlow, TapList<Block> collectList, TapList<Block> dejaVu) {
        while (backFlow != null) {
            Block prevBlock = ((FGArrow)backFlow.head).origin;
            if (prevBlock != null && !TapList.contains(dejaVu.tail, prevBlock)) {
                dejaVu.placdl(prevBlock);
                collectList = prevBlock.instructions == null ? this.collectLastNonEmptyBlocks(prevBlock.backFlow(), collectList, dejaVu) : new TapList<Block>(prevBlock, collectList);
            }
            backFlow = backFlow.tail;
        }
        return collectList;
    }

    protected Tree placeDebugADTests(Unit diffUnit, Tree callTree, BoolVector placeActiveZones, int[] map, int nature, SymbolTable srcSymbolTable, int lastDeclaredZone, String placeName, Instruction returnInstr, Tree okHere, Tree forcedOkHere) {
        SymbolTable diffSymbolTable = diffUnit.privateSymbolTable();
        boolean modifiesDiff = false;
        String traceFuncPrefix = "adDebug" + (TapEnv.debugAdMode() == 1 ? "Tgt_" : "Adj_");
        if (TapEnv.debugAdMode() == 1) {
            modifiesDiff = true;
        } else if (TapEnv.debugAdMode() == -1) {
            modifiesDiff = true;
            String extraFuncPrefix = nature == 0 ? "rw" : ((nature == -1 || nature == 2) && this.curDiffUnitSort() == 1 || (nature == 1 || nature == -2) && this.curDiffUnitSort() == 2 ? "w" : "r");
            traceFuncPrefix = traceFuncPrefix + extraFuncPrefix;
        }
        TapList<Tree> stackInstructions = this.instructionsOnDeclaredZones(callTree, srcSymbolTable, diffUnit.privateSymbolTable(), TapEnv.debugAdMode() == -1 ? traceFuncPrefix : traceFuncPrefix + "test", diffUnit, placeActiveZones, map, TapEnv.debugAdMode() == 1, false, modifiesDiff, lastDeclaredZone, returnInstr);
        int deltaIndent = 0;
        if (TapEnv.debugAdMode() == -1 && (nature == 2 || nature == -2)) {
            deltaIndent = -1;
        }
        TapList<Tree> displayArgs = null;
        if (TapEnv.debugAdMode() != 1) {
            displayArgs = new TapList<Tree>(ILUtils.build(103, deltaIndent), displayArgs);
        }
        Tree arg = ILUtils.build(180, placeName);
        if (diffUnit.isFortran()) {
            arg = ILUtils.concatWithNull(arg);
        }
        displayArgs = new TapList<Tree>(arg, displayArgs);
        Tree lastCall = ILUtils.buildCall(ILUtils.tapenadeUtilityFunctionName(diffUnit, traceFuncPrefix + (TapEnv.debugAdMode() == -1 ? "Display" : "display")), ILUtils.build(71, displayArgs));
        stackInstructions = TapList.append(stackInstructions, new TapList<Tree>(lastCall, null));
        Tree stackInstruction = ILUtils.build(27, stackInstructions);
        String testFuncName = TapEnv.debugAdMode() == 1 ? "adDebugTgt_here" : (this.curDiffUnitSort() == 1 ? "adDebugFwd_here" : "adDebugBwd_here");
        Tree testFuncIdent = ILUtils.tapenadeUtilityFunctionName(diffUnit, testFuncName);
        Unit debugUnit = this.adEnv.debugADHereUnit;
        if (debugUnit == null) {
            this.adEnv.debugADHereUnit = debugUnit = this.adEnv.diffCallGraph().createNewUnit(null, diffUnit.language());
            debugUnit.setExternalSymbolTable(this.adEnv.diffCallGraph().languageRootSymbolTable(diffUnit.language()));
            debugUnit.setExternal();
            debugUnit.setName(ILUtils.getIdentString(testFuncIdent));
            debugUnit.setFunctionTypeSpec(new FunctionTypeSpec(diffSymbolTable.getTypeDecl((String)"boolean").typeSpec));
        }
        diffSymbolTable.addSymbolDecl(new FunctionDecl(testFuncIdent, debugUnit));
        TapList<Tree> args = null;
        if (TapEnv.debugAdMode() == 1) {
            args = new TapList<Tree>(forcedOkHere, args);
        }
        arg = ILUtils.build(180, placeName);
        if (diffUnit.isFortran()) {
            arg = ILUtils.concatWithNull(arg);
        }
        args = new TapList<Tree>(arg, args);
        Tree testCall = ILUtils.buildCall(testFuncIdent, ILUtils.build(71, args));
        if (TapEnv.debugAdMode() == 1 || TapEnv.debugAdMode() == -1 && this.curDiffUnitSort() == 2 && nature == 0) {
            testCall = ILUtils.build(6, okHere, testCall);
        }
        stackInstruction = ILUtils.build(98, testCall, stackInstruction);
        if (TapEnv.debugAdMode() == -1 && this.curDiffUnitSort() == 2) {
            arg = ILUtils.build(180, placeName);
            if (diffUnit.isFortran()) {
                arg = ILUtils.concatWithNull(arg);
            }
            Tree elseSkip = ILUtils.buildCall(ILUtils.tapenadeUtilityFunctionName(diffUnit, "adDebugAdj_skip"), ILUtils.build(71, arg));
            stackInstruction.setChild(elseSkip, 3);
        }
        return stackInstruction;
    }

    protected TapList<Tree> instructionsOnDeclaredZones(Tree instrumentedSourceTree, SymbolTable srcSymbolTable, SymbolTable diffSymbolTable, String traceFuncPrefix, Unit diffUnit, BoolVector placeActiveZones, int[] map, boolean adaptForDD, boolean modifiesPrimal, boolean modifiesDiff, int lastDeclaredZone, Instruction returnInstr) {
        ZoneInfo zoneInfo;
        int z;
        TapList<Tree> stackInstructions = null;
        BoolVector remainToComplainAbout = placeActiveZones == null ? null : placeActiveZones.copy();
        Instruction instr = this.adEnv.curInstruction();
        if (instr == null || instr.block == null || instr.block.pointerInfosIn == null) {
            instr = null;
        }
        for (z = lastDeclaredZone - 1; z >= 0; --z) {
            Tree zoneInfoVisibleAccessTree;
            zoneInfo = srcSymbolTable.declaredZoneInfo(z, this.adEnv.diffKind);
            if (zoneInfo == null || zoneInfo.comesFromAllocate() || zoneInfo.isHidden) continue;
            TapIntList seenZones = this.adEnv.curUnitIsContext && this.adEnv.activeRootCalledFromContext || instr == null ? new TapIntList(zoneInfo.zoneNb, null) : srcSymbolTable.listOfZonesOfValue(zoneInfo.accessTree, null, instr);
            TapIntList seenZonesRanks = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(seenZones, this.adEnv.diffKind, map, srcSymbolTable, null);
            int instrumentIt = 0;
            if (placeActiveZones != null) {
                if (placeActiveZones.intersects(seenZonesRanks)) {
                    instrumentIt = 1;
                } else if (TapEnv.get().debugPassives && TapEnv.debugAdMode() == 1 && !this.adEnv.curUnitIsContext) {
                    instrumentIt = 2;
                }
            }
            if (instrumentIt == 0 || (zoneInfoVisibleAccessTree = zoneInfo.isResult() && diffUnit.isC() && this.curDiffUnitSort() == 1 ? returnInstr.tree.down(1) : srcSymbolTable.buildZoneVisibleAccessTree(zoneInfo)) == null) continue;
            remainToComplainAbout.set(seenZonesRanks, false);
            Tree baseVar = ILUtils.baseTree(zoneInfoVisibleAccessTree);
            String baseName = ILUtils.getIdentString(baseVar);
            Tree stackInstruction = RefDescriptor.makeStack(diffUnit, traceFuncPrefix + (instrumentIt == 1 ? "" : "passive"), false, zoneInfo, zoneInfoVisibleAccessTree, srcSymbolTable, diffSymbolTable, true, -1);
            if (stackInstruction == null) continue;
            if (instrumentIt == 1) {
                Tree diffBaseVar = this.varRefDifferentiator().diffSymbolTree(this.adEnv.curActivity(), baseVar, diffSymbolTable, true, false, false, null, false, this.curDiffVarSort(), this.curDiffUnitSort(), 0, null);
                if (adaptForDD) {
                    this.adaptForDD(stackInstruction, diffUnit, baseVar, diffBaseVar, baseName, modifiesPrimal, modifiesDiff);
                } else {
                    this.adaptForDP(stackInstruction, diffUnit, baseVar, diffBaseVar, modifiesPrimal, modifiesDiff);
                }
            } else if (instrumentIt == 2) {
                this.adaptForPassiveDD(stackInstruction, diffUnit, baseVar, baseName);
            }
            stackInstructions = new TapList<Tree>(stackInstruction, stackInstructions);
        }
        for (z = lastDeclaredZone - 1; z >= 0; --z) {
            if (remainToComplainAbout == null || !remainToComplainAbout.get(z) || (zoneInfo = srcSymbolTable.declaredZoneInfo(z, this.adEnv.diffKind)) == null || zoneInfo.isChannelOrIO || zoneInfo.comesFromAllocate()) continue;
            TapEnv.fileWarning(15, instrumentedSourceTree, "(AD14) Instrumenting differentiated call of " + ILUtils.toString(instrumentedSourceTree) + " needs to access hidden variable: " + zoneInfo.description);
            this.adEnv.addInHiddenInstrumentedVariables(zoneInfo);
        }
        return stackInstructions;
    }

    private void adaptForDP(Tree code, Unit diffUnit, Tree var, Tree diffVar, boolean modifiesPrimal, boolean modifiesDiff) {
        switch (code.opCode()) {
            case 121: {
                this.adaptForDP(code.down(4), diffUnit, var, diffVar, modifiesPrimal, modifiesDiff);
                break;
            }
            case 98: {
                this.adaptForDP(code.down(2), diffUnit, var, diffVar, modifiesPrimal, modifiesDiff);
                break;
            }
            case 27: {
                Tree[] statements = code.children();
                for (int i = statements.length - 1; i >= 0; --i) {
                    this.adaptForDP(statements[i], diffUnit, var, diffVar, modifiesPrimal, modifiesDiff);
                }
                break;
            }
            case 31: {
                Tree arg1 = ILUtils.getArguments(code).cutChild(1);
                arg1 = FlowGraphDifferentiator.changeRootByDiff(arg1, var, diffVar);
                if (diffUnit.isC() && !ILUtils.getCalledNameString(code).endsWith("Array") && modifiesDiff) {
                    arg1 = ILUtils.addAddressOf(arg1);
                }
                ILUtils.getArguments(code).setChild(arg1, 1);
                break;
            }
        }
    }

    private void adaptForDD(Tree code, Unit diffUnit, Tree var, Tree diffVar, String name, boolean modifiesPrimal, boolean modifiesDiff) {
        switch (code.opCode()) {
            case 121: {
                this.adaptForDD(code.down(4), diffUnit, var, diffVar, name, modifiesPrimal, modifiesDiff);
                break;
            }
            case 98: {
                this.adaptForDD(code.down(2), diffUnit, var, diffVar, name, modifiesPrimal, modifiesDiff);
                break;
            }
            case 27: {
                Tree[] statements = code.children();
                for (int i = statements.length - 1; i >= 0; --i) {
                    this.adaptForDD(statements[i], diffUnit, var, diffVar, name, modifiesPrimal, modifiesDiff);
                }
                break;
            }
            case 31: {
                Tree debugArguments = ILUtils.getArguments(code);
                if (!TapEnv.get().complexStep) {
                    Tree diffTree = ILUtils.copy(debugArguments.down(1));
                    Tree tree2 = FlowGraphDifferentiator.changeRootByDiff(diffTree, var, diffVar);
                    if (TapEnv.associationByAddress()) {
                        Tree tree1 = debugArguments.down(1);
                        tree1 = this.varRefDifferentiator().buildAAInstructionVORD(tree1, diffUnit.privateSymbolTable(), tree1, TapEnv.assocAddressValueSuffix(), false);
                        debugArguments.setChild(tree1, 1);
                        tree2 = this.varRefDifferentiator().buildAAInstructionVORD(tree2, diffUnit.privateSymbolTable(), tree2, TapEnv.assocAddressDiffSuffix(), false);
                    }
                    debugArguments.addChild(tree2, 2);
                }
                if (diffUnit.isC() && !ILUtils.getCalledNameString(code).endsWith("Array")) {
                    if (modifiesPrimal) {
                        debugArguments.setChild(ILUtils.addAddressOf(debugArguments.cutChild(1)), 1);
                    }
                    if (modifiesDiff && !TapEnv.get().complexStep) {
                        debugArguments.setChild(ILUtils.addAddressOf(debugArguments.cutChild(2)), 2);
                    }
                }
                Tree varName = ILUtils.build(180, name);
                if (diffUnit.isFortran()) {
                    varName = ILUtils.concatWithNull(varName);
                }
                debugArguments.addChild(varName, 1);
                break;
            }
        }
    }

    private void adaptForPassiveDD(Tree code, Unit diffUnit, Tree var, String name) {
        switch (code.opCode()) {
            case 121: {
                this.adaptForPassiveDD(code.down(4), diffUnit, var, name);
                break;
            }
            case 98: {
                this.adaptForPassiveDD(code.down(2), diffUnit, var, name);
                break;
            }
            case 27: {
                Tree[] statements = code.children();
                for (int i = statements.length - 1; i >= 0; --i) {
                    this.adaptForPassiveDD(statements[i], diffUnit, var, name);
                }
                break;
            }
            case 31: {
                Tree varName = ILUtils.build(180, name);
                if (diffUnit.isFortran()) {
                    varName = ILUtils.concatWithNull(varName);
                }
                ILUtils.getArguments(code).addChild(varName, 1);
                break;
            }
        }
    }

    private static Tree changeRootByDiff(Tree expr, Tree var, Tree diffVar) {
        switch (expr.opCode()) {
            case 9: 
            case 75: 
            case 151: {
                return ILUtils.build(expr.opCode(), FlowGraphDifferentiator.changeRootByDiff(expr.down(1), var, diffVar), ILUtils.copy(expr.down(2)));
            }
            case 96: {
                if (ILUtils.getIdentString(expr).equals(ILUtils.getIdentString(var))) {
                    return ILUtils.copy(diffVar);
                }
                return ILUtils.copy(expr);
            }
        }
        return ILUtils.copy(expr);
    }

    private final class FwdBwdVarTool {
        private final SymbolTable fwdDiffST;
        private final SymbolTable diffST;
        private NewSymbolHolder fwdHolder;
        private final NewSymbolHolder holder;
        private RefDescriptor fwdRefDescriptor;
        private final RefDescriptor refDescriptor;

        private FwdBwdVarTool(String name, Tree pushExpr, Block place, SymbolTable fwdDiffST, SymbolTable diffST) {
            WrapperTypeSpec pushExprType;
            this.fwdDiffST = fwdDiffST;
            this.diffST = diffST;
            int holderSize = -1;
            WrapperTypeSpec wrapperTypeSpec = pushExprType = pushExpr == null || fwdDiffST == null ? null : fwdDiffST.typeOf(pushExpr);
            if (TypeSpec.isA(pushExprType, 5)) {
                assert (pushExprType != null);
                if (((ModifiedTypeSpec)pushExprType.wrappedType).sizeModifierValue() == -1) {
                    pushExpr = ILUtils.buildCall(ILUtils.build(96, "int"), ILUtils.build(71, ILUtils.copy(pushExpr), ILUtils.build(103, 8)));
                    holderSize = 8;
                    pushExprType = new WrapperTypeSpec(new ModifiedTypeSpec(((FlowGraphDifferentiator)FlowGraphDifferentiator.this).adEnv.integerTypeSpec, ILUtils.build(103, holderSize), fwdDiffST));
                } else {
                    holderSize = pushExprType.wrappedType.size();
                }
            }
            this.holder = new NewSymbolHolder(name, FlowGraphDifferentiator.this.curDiffUnit(), ((FlowGraphDifferentiator)FlowGraphDifferentiator.this).adEnv.integerTypeSpec, holderSize);
            this.holder.declarationLevelMustInclude(diffST);
            this.fwdHolder = this.holder;
            if (fwdDiffST != null && fwdDiffST != diffST) {
                this.fwdHolder = new NewSymbolHolder(name, FlowGraphDifferentiator.this.curFwdDiffUnit(), ((FlowGraphDifferentiator)FlowGraphDifferentiator.this).adEnv.integerTypeSpec, holderSize);
                this.fwdHolder.declarationLevelMustInclude(fwdDiffST);
            }
            this.fwdRefDescriptor = this.refDescriptor = new RefDescriptor(this.holder.makeNewRef(diffST), null, diffST, diffST, null, null, false, null, FlowGraphDifferentiator.this.curDiffUnit());
            if (fwdDiffST != null) {
                if (pushExpr != null) {
                    this.fwdRefDescriptor = new RefDescriptor(pushExpr, pushExprType, null, fwdDiffST, fwdDiffST, null, null, false, null, FlowGraphDifferentiator.this.curFwdDiffUnit());
                } else if (fwdDiffST != diffST) {
                    this.fwdRefDescriptor = new RefDescriptor(this.fwdHolder.makeNewRef(fwdDiffST), null, fwdDiffST, fwdDiffST, null, null, false, null, FlowGraphDifferentiator.this.curFwdDiffUnit());
                }
            }
            FlowGraphDifferentiator.this.adEnv.setCurBlock(place.enclosingLoop());
            FlowGraphDifferentiator.this.blockDifferentiator().prepareRestoreOperations(this.fwdRefDescriptor, this.refDescriptor, 1, fwdDiffST, diffST);
        }

        private Tree makeFwdRef(Block srcOfUsageBlock) {
            this.fwdHolder.preparePrivateClause(srcOfUsageBlock, FlowGraphDifferentiator.this.adEnv.curUnit().privateSymbolTable(), true, false);
            return this.fwdHolder.makeNewRef(this.fwdDiffST);
        }

        private Tree makeRef(Block srcOfUsageBlock) {
            this.holder.preparePrivateClause(srcOfUsageBlock, FlowGraphDifferentiator.this.adEnv.curUnit().privateSymbolTable(), false, false);
            return this.holder.makeNewRef(this.diffST);
        }

        private Tree makePush(Block srcOfUsageBlock) {
            this.fwdHolder.preparePrivateClause(srcOfUsageBlock, FlowGraphDifferentiator.this.adEnv.curUnit().privateSymbolTable(), true, false);
            return this.fwdRefDescriptor.makePush();
        }

        private Tree makePop(Block srcOfUsageBlock) {
            this.holder.preparePrivateClause(srcOfUsageBlock, FlowGraphDifferentiator.this.adEnv.curUnit().privateSymbolTable(), false, false);
            return this.refDescriptor.makePop();
        }
    }

    private final class DownstreamConnector {
        private Block entry;
        private Block sourceBlock;
        private TapList<FGArrow> exits;
        private SymbolTable bwdScope;
        private Block exitBlock;
        private boolean isATurn;

        private DownstreamConnector(Block entry, Block sourceBlock, TapList<FGArrow> exits, SymbolTable bwdScope) {
            this.entry = entry;
            this.sourceBlock = sourceBlock;
            this.exits = exits;
            this.bwdScope = bwdScope;
            this.exitBlock = null;
            this.isATurn = entry == null && exits == null;
        }

        private DownstreamConnector(DownstreamConnector model) {
            this.entry = model.entry;
            this.sourceBlock = model.sourceBlock;
            this.exits = model.exits;
            this.bwdScope = model.bwdScope;
            this.exitBlock = model.exitBlock;
            this.isATurn = model.isATurn;
        }

        private void putBlockAtTail(Block newBlock) {
            if (this.exits == null) {
                this.entry = newBlock;
            } else {
                FlowGraphDifferentiator.this.mapCheckFreeThenRedirectDestination(this.exits, newBlock, false);
                this.exits = null;
            }
            this.exitBlock = newBlock;
        }

        private void putArrowAtTail(int test, int cas) {
            this.exits = new TapList<FGArrow>(FlowGraphDifferentiator.this.checkFreeThenSetNewFGArrow(this.exitBlock, test, cas, null, false), null);
            this.exitBlock = null;
        }

        public String toString() {
            return "[" + this.entry + " ; " + this.exits + " src:" + this.sourceBlock + "]";
        }
    }

    private static final class PushPopNode {
        private TapList<FGArrow> fwdArrows;
        private Block bwdBlock;
        private SymbolTable bwdScope;
        private TapList<Block> sourceOrigPath;
        private Block sourceDest;
        private TapList<PushPopNode> subNodes;
        private int numberOfCases = -1;
        private BwdSwitchCase referenceBwdSwitchCase;

        private PushPopNode(TapList<FGArrow> fwdArrows, Block bwdBlock, BwdSwitchCase bwdSwitchCase, SymbolTable bwdScope, TapList<Block> sourceOrigPath, Block sourceDest, TapList<PushPopNode> subNodes) {
            this.fwdArrows = fwdArrows;
            this.bwdBlock = bwdBlock;
            this.bwdScope = bwdScope;
            this.referenceBwdSwitchCase = bwdSwitchCase;
            this.sourceOrigPath = sourceOrigPath;
            this.sourceDest = sourceDest;
            this.subNodes = subNodes;
        }

        private void computeNumberOfCases() {
            if (this.subNodes == null) {
                this.numberOfCases = 1;
            } else {
                int sum = 0;
                TapList<PushPopNode> inSubNodes = this.subNodes;
                while (inSubNodes != null) {
                    sum += ((PushPopNode)inSubNodes.head).numberOfCases;
                    inSubNodes = inSubNodes.tail;
                }
                this.numberOfCases = sum;
            }
        }

        private boolean uniqueBwdDest() {
            TapList<Block> allBwdDests = this.collectBwdDests(null);
            return allBwdDests != null && allBwdDests.tail == null;
        }

        private TapList<Block> collectBwdDests(TapList<Block> collectedDests) {
            if (this.subNodes == null) {
                if (!TapList.contains(collectedDests, this.bwdBlock)) {
                    collectedDests = new TapList<Block>(this.bwdBlock, collectedDests);
                }
            } else {
                TapList<PushPopNode> inSubNodes = this.subNodes;
                while (inSubNodes != null) {
                    collectedDests = ((PushPopNode)inSubNodes.head).collectBwdDests(collectedDests);
                    inSubNodes = inSubNodes.tail;
                }
            }
            return collectedDests;
        }

        private Block pickFirstSourceDest() {
            Block found = this.sourceDest;
            TapList<PushPopNode> inSubNodes = this.subNodes;
            while (found == null && inSubNodes != null) {
                found = ((PushPopNode)inSubNodes.head).pickFirstSourceDest();
                inSubNodes = inSubNodes.tail;
            }
            return found;
        }

        private void dump(TapList<PushPopNode> dejaVu) {
            if (TapList.contains(dejaVu.tail, this)) {
                TapEnv.printOnTrace("[DEJAVU]");
            } else {
                TapEnv.printOnTrace("[" + this.fwdArrows + " ; " + this.bwdBlock + " ; bwdScope:" + (this.bwdScope == null ? "null" : "@" + Integer.toHexString(this.bwdScope.hashCode())) + " src:" + this.sourceOrigPath + "-->" + this.sourceDest + " refBwdSwitchCase:" + (this.referenceBwdSwitchCase == null ? "null" : "@" + Integer.toHexString(this.referenceBwdSwitchCase.hashCode())));
                dejaVu.placdl(this);
                if (this.subNodes != null) {
                    TapEnv.incrTraceIndent(2);
                    TapList<PushPopNode> inSubNodes = this.subNodes;
                    while (inSubNodes != null) {
                        TapEnv.printlnOnTrace();
                        TapEnv.indentOnTrace();
                        ((PushPopNode)inSubNodes.head).dump(dejaVu);
                        inSubNodes = inSubNodes.tail;
                    }
                    TapEnv.decrTraceIndent(2);
                }
                TapEnv.printOnTrace("]");
            }
        }

        public String toString() {
            return "[" + this.fwdArrows + " ; " + this.bwdBlock + " ;  src:" + this.sourceOrigPath + "-->" + this.sourceDest + " <" + this.subNodes + ">]";
        }
    }

    private static final class BwdSwitchCase {
        private FGArrow fwdArrow;
        private Block bwdBlock;
        private TapList<Block> sourceOrigPath;
        private Block sourceDest;

        private BwdSwitchCase(FGArrow fwdArrow, Block bwdBlock, TapList<Block> sourceOrigPath, Block sourceDest) {
            this.fwdArrow = fwdArrow;
            this.bwdBlock = bwdBlock;
            this.sourceOrigPath = sourceOrigPath;
            this.sourceDest = sourceDest;
        }

        public String toString() {
            return this.fwdArrow + " @" + Integer.toHexString(this.hashCode()) + " ?-->" + this.bwdBlock + " src:" + this.sourceOrigPath + "-->" + this.sourceDest;
        }
    }

    private static final class FlowGraphCopy {
        private Block copyBlockUS;
        private TapList<TapPair<FGArrow, FGArrow>> exitArrowsCopy;

        private FlowGraphCopy(FlowGraphLevel level) {
            TapList<Object> hdExitArrowsCopy;
            TapList<Object> tlExitArrowsCopy = hdExitArrowsCopy = new TapList<Object>(null, null);
            TapList exitArrows = level.exitArrows;
            while (exitArrows != null) {
                tlExitArrowsCopy = tlExitArrowsCopy.placdl(new TapPair(exitArrows.head, null));
                exitArrows = exitArrows.tail;
            }
            this.exitArrowsCopy = hdExitArrowsCopy.tail;
        }

        private FGArrow getCopyOfExitArrow(FGArrow exitArrow) {
            return (FGArrow)TapList.cassq(exitArrow, this.exitArrowsCopy);
        }
    }

    private static final class FlowGraphCopyEnv {
        private UnitCreationContext copyCtxt;

        private FlowGraphCopyEnv(UnitCreationContext copyCtxt) {
            this.copyCtxt = UnitCreationContext.copyListST(copyCtxt);
        }
    }

    private static final class FlowGraphDifferentiation {
        private Block fwdBlockUS;
        private TapList<FGArrow> bwdArrowsUS;
        private boolean upstreamFwdBwdDefined;
        private TapList<TapPair<FGArrow, TapList<TapPair<FGArrow, TapList<BwdSwitchCase>>>>> exitArrowsFwdBwds;
        private FGArrow specialTopFwdArrow;
        private FGArrow specialTopBwdArrow;
        private boolean specialTopUsed;

        private FlowGraphDifferentiation(FlowGraphLevel level) {
            TapList<Object> hdExitArrowsFwdBwds;
            TapList<Object> tlExitArrowsFwdBwds = hdExitArrowsFwdBwds = new TapList<Object>(null, null);
            TapList exitArrows = level.exitArrows;
            while (exitArrows != null) {
                tlExitArrowsFwdBwds = tlExitArrowsFwdBwds.placdl(new TapPair(exitArrows.head, null));
                exitArrows = exitArrows.tail;
            }
            this.exitArrowsFwdBwds = hdExitArrowsFwdBwds.tail;
        }

        private boolean hasFwd() {
            return this.fwdBlockUS != null;
        }

        private boolean reallyHasFwd() {
            if (this.fwdBlockUS == null) {
                return false;
            }
            return this.hasCodeAfter(this.fwdBlockUS, new TapList<Object>(null, null));
        }

        private boolean hasCodeAfter(Block block, TapList<Block> toDejaVu) {
            if (block == null || TapList.contains(toDejaVu.tail, block)) {
                return false;
            }
            if (block instanceof HeaderBlock ? !block.isDoWithIndexUnusedAfterLoop() : block.instructions != null) {
                return true;
            }
            toDejaVu.placdl(block);
            boolean hasCode = false;
            TapList<FGArrow> inFlow = block.flow();
            while (inFlow != null && !hasCode) {
                hasCode = this.hasCodeAfter(((FGArrow)inFlow.head).destination, toDejaVu);
                inFlow = inFlow.tail;
            }
            return hasCode;
        }

        private boolean hasBwd() {
            return this.bwdArrowsUS != null;
        }

        private TapList<TapPair<FGArrow, TapList<BwdSwitchCase>>> getFwdBwdsOfExitArrow(FGArrow exitArrow) {
            return (TapList)TapList.cassq(exitArrow, this.exitArrowsFwdBwds);
        }

        private void accumulateFwdBwdUS(Block newFwdBlockUS, TapList<FGArrow> newBwdArrowsUS) {
            if (!this.upstreamFwdBwdDefined) {
                this.upstreamFwdBwdDefined = true;
                this.fwdBlockUS = newFwdBlockUS;
                this.bwdArrowsUS = newBwdArrowsUS;
            } else {
                if (newFwdBlockUS != this.fwdBlockUS) {
                    TapEnv.toolWarning(-1, "(Differentiation of a Flow Graph) FlowGraphLevel with two Fwd entries");
                    if (newFwdBlockUS != null) {
                        this.fwdBlockUS = newFwdBlockUS;
                    }
                }
                while (newBwdArrowsUS != null) {
                    if (!TapList.contains(this.bwdArrowsUS, newBwdArrowsUS.head)) {
                        this.bwdArrowsUS = new TapList<FGArrow>((FGArrow)newBwdArrowsUS.head, this.bwdArrowsUS);
                    }
                    newBwdArrowsUS = newBwdArrowsUS.tail;
                }
            }
        }

        private void removeLoopExitArrow() {
            TapList<TapPair<FGArrow, TapList<TapPair<FGArrow, TapList<BwdSwitchCase>>>>> toExitArrowsFwdBwds;
            TapList<TapPair<FGArrow, TapList<TapPair<FGArrow, TapList<BwdSwitchCase>>>>> inExitArrowsFwdBwds = toExitArrowsFwdBwds = new TapList<TapPair<FGArrow, TapList<TapPair<FGArrow, TapList<BwdSwitchCase>>>>>(null, this.exitArrowsFwdBwds);
            while (inExitArrowsFwdBwds.tail != null) {
                FGArrow exitArrow = (FGArrow)((TapPair)inExitArrowsFwdBwds.tail.head).first;
                if (exitArrow.containsCase(0)) {
                    inExitArrowsFwdBwds.tail = inExitArrowsFwdBwds.tail.tail;
                    continue;
                }
                inExitArrowsFwdBwds = inExitArrowsFwdBwds.tail;
            }
            this.exitArrowsFwdBwds = toExitArrowsFwdBwds.tail;
        }
    }

    private final class FlowGraphDifferentiationEnv {
        private UnitCreationContext diffCtxt;
        private UnitCreationContext diffCtxtFwd;
        private int adDiffMode;
        private TapList<FGArrow> turningArrows;
        private TapList<SymbolTable> middleSymbolTables;
        private final boolean[] fwdLiveControl;
        private boolean[] bwdLiveControl;
        private final boolean[] lastTestLives;
        private final BlockStorage<Block> fwdDiffBlocks;
        private final BlockStorage<Block> bwdDiffBlocks;
        private BlockStorage<TapList<Instruction>> fwdParallelControls;
        private BlockStorage<TapList<Instruction>> bwdParallelControls;

        private FlowGraphDifferentiationEnv(int adDiffMode) {
            this.adDiffMode = adDiffMode;
            this.fwdLiveControl = new boolean[((FlowGraphDifferentiator)FlowGraphDifferentiator.this).adEnv.curUnit().nbBlocks];
            if (adDiffMode != 1) {
                this.bwdLiveControl = new boolean[((FlowGraphDifferentiator)FlowGraphDifferentiator.this).adEnv.curUnit().nbBlocks];
            }
            this.lastTestLives = new boolean[((FlowGraphDifferentiator)FlowGraphDifferentiator.this).adEnv.curUnit().nbBlocks];
            for (int i = ((FlowGraphDifferentiator)FlowGraphDifferentiator.this).adEnv.curUnit().nbBlocks - 1; i >= 0; --i) {
                this.fwdLiveControl[i] = false;
                if (adDiffMode != 1) {
                    this.bwdLiveControl[i] = false;
                }
                this.lastTestLives[i] = false;
            }
            this.fwdDiffBlocks = new BlockStorage(FlowGraphDifferentiator.this.adEnv.curUnit());
            this.bwdDiffBlocks = new BlockStorage(FlowGraphDifferentiator.this.adEnv.curUnit());
            this.fwdParallelControls = new BlockStorage(FlowGraphDifferentiator.this.adEnv.curUnit());
            this.bwdParallelControls = new BlockStorage(FlowGraphDifferentiator.this.adEnv.curUnit());
        }

        private void initialize() {
            if (((FlowGraphDifferentiator)FlowGraphDifferentiator.this).adEnv.traceCurDifferentiation) {
                TapEnv.printlnOnTrace("  Initialize SymbolTable's associations for diff unit " + FlowGraphDifferentiator.this.curDiffUnit() + " of " + FlowGraphDifferentiator.this.adEnv.curUnit() + " :");
                TapEnv.printlnOnTrace("   " + FlowGraphDifferentiator.this.adEnv.curUnit().privateSymbolTable());
                TapEnv.printlnOnTrace("   ==fwd==>> " + FlowGraphDifferentiator.this.curFwdDiffUnit().privateSymbolTable());
                TapEnv.printlnOnTrace("   =======>> " + FlowGraphDifferentiator.this.curDiffUnit().privateSymbolTable());
                TapEnv.printlnOnTrace("   " + FlowGraphDifferentiator.this.adEnv.curUnit().publicSymbolTable());
                TapEnv.printlnOnTrace("   ==fwd==>> " + FlowGraphDifferentiator.this.curFwdDiffUnit().publicSymbolTable());
                TapEnv.printlnOnTrace("   =======>> " + FlowGraphDifferentiator.this.curDiffUnit().publicSymbolTable());
            }
            TapList<Object> toAllDiffBlocks = new TapList<Object>(null, null);
            this.diffCtxt = new UnitCreationContext(FlowGraphDifferentiator.this.curDiffUnit(), toAllDiffBlocks, new TapList<TapPair<SymbolTable, SymbolTable>>(null, new TapList<TapPair<SymbolTable, SymbolTable>>(new TapPair<SymbolTable, SymbolTable>(FlowGraphDifferentiator.this.adEnv.curUnit().privateSymbolTable(), FlowGraphDifferentiator.this.curDiffUnit().privateSymbolTable()), new TapList<TapPair<SymbolTable, SymbolTable>>(new TapPair<SymbolTable, SymbolTable>(FlowGraphDifferentiator.this.adEnv.curUnit().publicSymbolTable(), FlowGraphDifferentiator.this.curDiffUnit().publicSymbolTable()), null))));
            this.diffCtxtFwd = new UnitCreationContext(FlowGraphDifferentiator.this.curFwdDiffUnit(), this.adDiffMode != -2 ? toAllDiffBlocks : new TapList<Object>(null, null), new TapList<TapPair<SymbolTable, SymbolTable>>(null, new TapList<TapPair<SymbolTable, SymbolTable>>(new TapPair<SymbolTable, SymbolTable>(FlowGraphDifferentiator.this.adEnv.curUnit().privateSymbolTable(), FlowGraphDifferentiator.this.curFwdDiffUnit().privateSymbolTable()), new TapList<TapPair<SymbolTable, SymbolTable>>(new TapPair<SymbolTable, SymbolTable>(FlowGraphDifferentiator.this.adEnv.curUnit().publicSymbolTable(), FlowGraphDifferentiator.this.curFwdDiffUnit().publicSymbolTable()), null))));
        }

        private FlowGraphDifferentiationEnv deriveForNewJointDiff() {
            FlowGraphDifferentiationEnv result = new FlowGraphDifferentiationEnv(-1);
            result.diffCtxtFwd = result.diffCtxt = UnitCreationContext.copyListST(this.diffCtxt);
            return result;
        }

        private FlowGraphDifferentiationEnv deriveForNewSplitDiff() {
            FlowGraphDifferentiationEnv result = new FlowGraphDifferentiationEnv(-2);
            result.diffCtxt = UnitCreationContext.copyListST(this.diffCtxt);
            result.diffCtxtFwd = UnitCreationContext.copyListST(this.diffCtxtFwd);
            return result;
        }

        private void storeDiffBlocks(Block block, Block fwdDiffBlock, Block bwdDiffBlock, boolean lastTestLive) {
            if (fwdDiffBlock.instructions != null) {
                if (block.rank >= 0) {
                    this.fwdLiveControl[block.rank] = true;
                }
                this.markControllersLive(block, this.fwdLiveControl);
            }
            if (this.adDiffMode != 1) {
                if (bwdDiffBlock.instructions != null) {
                    if (block.rank >= 0) {
                        this.bwdLiveControl[block.rank] = true;
                    }
                    this.markControllersLive(block, this.bwdLiveControl);
                } else {
                    this.markLiveDueToDiffReinits(block);
                }
            }
            this.fwdDiffBlocks.store(block, fwdDiffBlock);
            this.bwdDiffBlocks.store(block, bwdDiffBlock);
            if (block.rank >= 0) {
                this.lastTestLives[block.rank] = lastTestLive;
            }
        }

        private Block retrieveOrigBlockOf(Block diffBlock) {
            TapList<Block> origBlocks = new TapList<Block>(FlowGraphDifferentiator.this.adEnv.curUnit().entryBlock(), new TapList<Block>(FlowGraphDifferentiator.this.adEnv.curUnit().exitBlock(), FlowGraphDifferentiator.this.adEnv.curUnit().allBlocks()));
            Block found = null;
            while (found == null && origBlocks != null) {
                if (this.fwdDiffBlocks.retrieve((Block)origBlocks.head) == diffBlock || this.bwdDiffBlocks.retrieve((Block)origBlocks.head) == diffBlock) {
                    found = (Block)origBlocks.head;
                }
                origBlocks = origBlocks.tail;
            }
            return found;
        }

        private void markBwdControllersLive(Block block) {
            if (this.adDiffMode != 1) {
                this.markControllersLive(block, this.bwdLiveControl);
            }
        }

        private void markControllersLive(Block block, boolean[] liveControl) {
            TapList<Block> controllers = block.controllers;
            LoopBlock enclosingLoop = block.enclosingLoop();
            if (enclosingLoop != null) {
                controllers = new TapList<Block>(enclosingLoop.header(), controllers);
            }
            while (controllers != null) {
                Block controller = (Block)controllers.head;
                if (!liveControl[controller.rank]) {
                    liveControl[controller.rank] = true;
                    this.markControllersLive(controller, liveControl);
                }
                controllers = controllers.tail;
            }
        }

        private void markLiveDueToDiffReinits(Block block) {
            TapList<FGArrow> arrows = block.backFlow();
            if (arrows != null) {
                boolean onlyArrow;
                boolean bl = onlyArrow = arrows.tail == null;
                while (arrows != null) {
                    FGArrow arrow = (FGArrow)arrows.head;
                    if (FlowGraphDifferentiator.this.mustCheckActivitySwitches(arrow.origin, arrow.destination)) {
                        if (onlyArrow) {
                            this.bwdLiveControl[block.rank] = true;
                        }
                        this.markControllersLive(block, this.bwdLiveControl);
                    }
                    arrows = arrows.tail;
                }
            }
        }

        private boolean blockMustBeLive(Block block) {
            return block.rank >= 0 && this.fwdLiveControl[block.rank];
        }

        private boolean blockMustBeActive(Block block) {
            return block.rank >= 0 && this.bwdLiveControl[block.rank];
        }

        private boolean blockHasLastTestLive(Block block) {
            return block.rank >= 0 && this.lastTestLives[block.rank];
        }
    }

    private final class FlowGraphLevel {
        public int levelKind = 2;
        private FlowGraphLevel entryPoint;
        private Block entryBlock;
        private TapList<FGArrow> entryArrows;
        private TapList<FGArrow> exitArrows;
        private TapList<FlowGraphLevel> contents;
        private FlowGraphLevel enclosing;
        private FlowGraphLevel trueEnclosing;
        private HeaderBlock headerBlockPlain;
        public String label;
        public TapTriplet<Boolean, TapList<RefDescriptor>, TapList<RefDescriptor>> staticSaves = null;

        private FlowGraphLevel(int levelKind) {
            this.levelKind = levelKind;
        }

        private FlowGraphLevel createNoCycle() {
            FlowGraphLevel result = new FlowGraphLevel(3);
            result.entryPoint = this.entryPoint;
            this.entryPoint.enclosing = result;
            result.entryBlock = this.entryBlock;
            TapList levelCycleArrows = null;
            TapList<FGArrow> entryEntryArrows = this.entryPoint.entryArrows;
            while (entryEntryArrows != null) {
                if (!TapList.contains(this.entryArrows, entryEntryArrows.head)) {
                    levelCycleArrows = new TapList(entryEntryArrows.head, levelCycleArrows);
                }
                entryEntryArrows = entryEntryArrows.tail;
            }
            result.entryArrows = TapList.append(levelCycleArrows, this.entryArrows);
            result.exitArrows = TapList.append(levelCycleArrows, this.exitArrows);
            result.contents = this.contents;
            TapList<FlowGraphLevel> inContents = this.contents;
            while (inContents != null) {
                ((FlowGraphLevel)inContents.head).enclosing = result;
                inContents = inContents.tail;
            }
            result.enclosing = this;
            return result;
        }

        private FlowGraphLevel createLoopBody() {
            TapList<Object> hdNewContents;
            TapList<Object> hdNewExitArrows;
            FGArrow arrowToBody = this.entryBlock.getFGArrowTestCase(30, 1);
            FlowGraphLevel newEntryPoint = this.getRepresentantInLevel(arrowToBody.destination);
            FlowGraphLevel result = this.createNoCycle();
            result.entryPoint.enclosing = null;
            result.entryBlock = arrowToBody.destination;
            result.entryPoint = newEntryPoint;
            result.entryArrows = new TapList<FGArrow>(arrowToBody, null);
            TapList<Object> tlNewExitArrows = hdNewExitArrows = new TapList<Object>(null, null);
            TapList<FGArrow> inExitArrows = result.exitArrows;
            while (inExitArrows != null) {
                if (((FGArrow)inExitArrows.head).origin != this.entryBlock) {
                    tlNewExitArrows = tlNewExitArrows.placdl(inExitArrows.head);
                }
                inExitArrows = inExitArrows.tail;
            }
            result.exitArrows = hdNewExitArrows.tail;
            TapList<Object> tlNewContents = hdNewContents = new TapList<Object>(null, null);
            TapList<FlowGraphLevel> inContents = this.contents;
            while (inContents != null) {
                if (inContents.head != newEntryPoint) {
                    tlNewContents = tlNewContents.placdl(inContents.head);
                }
                inContents = inContents.tail;
            }
            result.contents = hdNewContents.tail;
            return result;
        }

        private FlowGraphLevel createRegionBody() {
            TapList<Object> hdNewContents;
            FGArrow arrowToBody = (FGArrow)this.entryBlock.flow().head;
            FlowGraphLevel newEntryPoint = this.getRepresentantInLevel(arrowToBody.destination);
            FlowGraphLevel result = new FlowGraphLevel(3);
            result.entryPoint = newEntryPoint;
            assert (newEntryPoint != null);
            newEntryPoint.enclosing = result;
            result.entryBlock = arrowToBody.destination;
            result.entryPoint = newEntryPoint;
            result.entryArrows = new TapList<FGArrow>(arrowToBody, null);
            result.exitArrows = TapList.append(this.exitArrows, null);
            TapList<Object> tlNewContents = hdNewContents = new TapList<Object>(null, null);
            TapList<FlowGraphLevel> inContents = this.contents;
            while (inContents != null) {
                ((FlowGraphLevel)inContents.head).enclosing = result;
                if (inContents.head != newEntryPoint) {
                    tlNewContents = tlNewContents.placdl(inContents.head);
                }
                inContents = inContents.tail;
            }
            result.contents = hdNewContents.tail;
            result.enclosing = this;
            return result;
        }

        private void restoreChildrenParent() {
            this.entryPoint.enclosing = this;
            TapList<FlowGraphLevel> inContents = this.contents;
            while (inContents != null) {
                ((FlowGraphLevel)inContents.head).enclosing = this;
                inContents = inContents.tail;
            }
        }

        private FlowGraphLevel getRepresentantInLevel(Block block) {
            FlowGraphLevel blockLevel = null;
            if (FlowGraphDifferentiator.this.additionalBlockToPlainLevel != null) {
                blockLevel = (FlowGraphLevel)TapList.cassq(block, FlowGraphDifferentiator.this.additionalBlockToPlainLevel);
            }
            if (blockLevel == null) {
                blockLevel = (FlowGraphLevel)FlowGraphDifferentiator.this.blockToPlainLevel.retrieve(block);
            }
            while (blockLevel != null && blockLevel.enclosing != this) {
                blockLevel = blockLevel.enclosing;
            }
            return blockLevel;
        }

        private TapList<Block> allBlocksInside() {
            TapList<Object> toResult = new TapList<Object>(null, null);
            this.abiRec(toResult);
            return toResult.tail;
        }

        private TapList<Block> abiRec(TapList<Block> tlResult) {
            if (this.levelKind == 0) {
                return tlResult.placdl(this.entryBlock);
            }
            tlResult = this.entryPoint.abiRec(tlResult);
            TapList<FlowGraphLevel> inContents = this.contents;
            while (inContents != null) {
                tlResult = ((FlowGraphLevel)inContents.head).abiRec(tlResult);
                inContents = inContents.tail;
            }
            return tlResult;
        }

        private boolean hasCyclingArrows() {
            TapList<FGArrow> entryEntries = this.entryPoint != null ? this.entryPoint.entryArrows : this.entryBlock.backFlow();
            boolean hasCyclingArrow = false;
            while (entryEntries != null && !hasCyclingArrow) {
                if (!TapList.contains(this.entryArrows, entryEntries.head)) {
                    hasCyclingArrow = true;
                }
                entryEntries = entryEntries.tail;
            }
            return hasCyclingArrow;
        }

        private boolean containsArrowFlow(FGArrow arrow) {
            return !TapList.contains(this.entryArrows, arrow);
        }

        private int getSubLevelRk(FlowGraphLevel subLevel) {
            if (subLevel == this.entryPoint) {
                return 0;
            }
            int ifound = -1;
            int i = 1;
            TapList<FlowGraphLevel> inContents = this.contents;
            while (inContents != null && ifound == -1) {
                if (inContents.head == subLevel) {
                    ifound = i;
                }
                ++i;
                inContents = inContents.tail;
            }
            return ifound;
        }

        public String toString() {
            if (this.trueEnclosing == null) {
                return "Top";
            }
            int rank = this.trueEnclosing.getSubLevelRk(this);
            return this.trueEnclosing.toString() + "." + (rank == -1 ? "?" : Integer.valueOf(rank));
        }
    }
}

