/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.differentiation;

import fr.inria.tapenade.analysis.ADActivityAnalyzer;
import fr.inria.tapenade.analysis.DataFlowAnalyzer;
import fr.inria.tapenade.differentiation.BlockDifferentiator;
import fr.inria.tapenade.differentiation.DiffAssignmentNode;
import fr.inria.tapenade.differentiation.DifferentiationEnv;
import fr.inria.tapenade.differentiation.NewBlockGraphNode;
import fr.inria.tapenade.differentiation.VarRefDifferentiator;
import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.ArrayTypeSpec;
import fr.inria.tapenade.representation.AtomFuncDerivative;
import fr.inria.tapenade.representation.CompositeTypeSpec;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.InstructionMask;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.PrimitiveTypeSpec;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeDecl;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.Operator;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.ToObject;
import fr.inria.tapenade.utils.Tree;

public class ExpressionDifferentiator {
    private final DifferentiationEnv adEnv;
    private int replicas = 1;
    private boolean tangentDiff = true;
    private static final int CST_COST = 0;
    private static final int VAR_COST = 1;
    private static final int ASS_COST = 1;
    private static final int ADD_COST = 1;
    private static final int SUB_COST = 1;
    private static final int MUL_COST = 4;
    private static final int DIV_COST = 6;
    private static final int REDUC_COST = 10;
    private static final int POW_COST = 15;
    private static final int CALL_COST = 20;
    private static final int NEW_TEMP_VAR_COST = 5;

    private BlockDifferentiator blockDifferentiator() {
        return this.adEnv.blockDifferentiator;
    }

    private VarRefDifferentiator varRefDifferentiator() {
        return this.adEnv.varRefDifferentiator;
    }

    private boolean multiDirMode() {
        return this.adEnv.multiDirMode;
    }

    private Unit curDiffUnit() {
        return this.adEnv.curDiffUnit;
    }

    protected ExpressionDifferentiator(DifferentiationEnv adEnv) {
        this.adEnv = adEnv;
        this.replicas = TapEnv.diffReplica();
    }

    protected Tree[] tangentDifferentiateAssignedExpression(Tree lhs, Tree expression, TapList<NewBlockGraphNode> toPrecomputes, TapList<DiffAssignmentNode> toPrecomputesDiff, Tree copySrcAssignment, BoolVector beforeActiv, TapPair<TapList<Tree>, TapList<Tree>> primRW, TapPair<TapList<Tree>, TapList<Tree>> diffRW, SymbolTable diffSymbolTable) {
        WrapperTypeSpec lhsType = this.adEnv.curSymbolTable().typeOf(lhs);
        TapList<ArrayDim> dimensions = ((TypeSpec)lhsType).getAllDimensions();
        Tree[] diffLhsR = new Tree[this.replicas];
        this.adEnv.iReplic = 0;
        while (this.adEnv.iReplic < this.replicas) {
            diffLhsR[this.adEnv.iReplic] = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), lhs, diffSymbolTable, this.varRefDifferentiator().isCurFunctionName(ILUtils.baseName(lhs)), lhs, false, true, lhs);
            ++this.adEnv.iReplic;
        }
        LinLeaf linLhs = new LinLeaf(lhs, diffLhsR, this.adEnv.curInstruction().whereMask(), true, null, -1);
        LinAssign mainRoot = new LinAssign(linLhs, null, lhsType, dimensions != null, null, -1);
        TapList<LinAssign> toLinTrees = new TapList<LinAssign>(mainRoot, null);
        expression = this.rebalanceExp(expression, beforeActiv, this.adEnv.curSymbolTable(), new ToBool(false), 1);
        this.tangentDiff = true;
        boolean cutInPrimal = this.findDiffOptimalCuts(expression, dimensions);
        if (this.activeExpr(expression)) {
            this.linearize(expression, mainRoot, -1, dimensions, this.adEnv.curInstruction().whereMask(), toLinTrees, toPrecomputes, diffSymbolTable);
        }
        if (this.adEnv.traceCurBlock == 2) {
            TapEnv.printlnOnTrace(" LINEARIZE RHS OF: " + ILUtils.toString(lhs) + " := " + ILUtils.toString(expression));
            TapEnv.printlnOnTrace("    PRIMAL PRECOMPUTES: " + toPrecomputes.tail);
            TapEnv.printlnOnTrace("    TANGENT PRECOMPUTES: " + toLinTrees.tail);
            TapEnv.printlnOnTrace("    LINEARIZATION TREE: " + mainRoot);
        }
        Tree[] tgtAssignTreeR = new Tree[this.replicas];
        Tree tgtAssignTree = null;
        this.adEnv.iReplic = 0;
        while (this.adEnv.iReplic < this.replicas) {
            TapList subLinTrees = toLinTrees.tail;
            while (subLinTrees != null) {
                LinAssign subLinTree = (LinAssign)subLinTrees.head;
                TapPair<Object, Object> subPrimRW = new TapPair<Object, Object>(null, null);
                TapPair<Object, Object> subDiffRW = new TapPair<Object, Object>(null, null);
                Tree tangentTempTree = subLinTree.buildTreeForward(subPrimRW, subDiffRW);
                DiffAssignmentNode futureDiffNode = new DiffAssignmentNode(tangentTempTree, 3, null, subLinTree.linLhs.ref, this.adEnv.iReplic, (TapList)subPrimRW.first, (TapList)subPrimRW.second, (TapList)subDiffRW.first, (TapList)subDiffRW.second);
                futureDiffNode.type = subLinTree.assignedType;
                toPrecomputesDiff.placdl(futureDiffNode);
                subLinTrees = subLinTrees.tail;
            }
            tgtAssignTree = mainRoot.buildTreeForward(primRW, diffRW);
            Tree zeroTree = ((TypeSpec)lhsType).buildConstantZero();
            if (ILUtils.isNullOrNone(tgtAssignTree.down(2)) && zeroTree != null) {
                tgtAssignTree.setChild(zeroTree, 2);
            }
            if (tgtAssignTree.down(2).opCode() == 99 && ILUtils.isNullOrNone(tgtAssignTree.down(2).down(2)) && zeroTree != null) {
                tgtAssignTree.down(2).setChild(zeroTree, 2);
            }
            if (1 == ILUtils.eqOrDisjointRef(tgtAssignTree.down(1), tgtAssignTree.down(2), this.adEnv.curInstruction(), this.adEnv.curInstruction())) {
                tgtAssignTree = null;
            }
            tgtAssignTreeR[this.adEnv.iReplic] = tgtAssignTree;
            ++this.adEnv.iReplic;
        }
        this.adEnv.iReplic = 0;
        if (copySrcAssignment != null && tgtAssignTree != null && cutInPrimal) {
            copySrcAssignment.setChild(this.replacePrecomputedAndCustomize(ILUtils.copy(expression)), 2);
            copySrcAssignment.removeAnnotation("sourcetree");
        }
        if (this.adEnv.traceCurBlock == 2) {
            TapEnv.printlnOnTrace("    MAIN TANGENT ASSIGN TREE:" + ILUtils.toString(tgtAssignTreeR[0]) + (tgtAssignTreeR.length == 1 ? "" : " *" + tgtAssignTreeR.length + "replicas"));
            TapEnv.printlnOnTrace("     primR:" + primRW.first + " primW:" + primRW.second + " diffR:" + diffRW.first + " diffW:" + diffRW.second);
            TapEnv.printlnOnTrace("    PRIMAL ASSIGNMENT:" + copySrcAssignment);
        }
        return tgtAssignTreeR;
    }

    protected Tree[] tangentDifferentiatePlainExpression(ToObject<Tree> toPrimalExp, TapList<NewBlockGraphNode> toPrecomputes, TapList<DiffAssignmentNode> toPrecomputesDiff, BoolVector beforeActiv, TapPair<TapList<Tree>, TapList<Tree>> primRW, TapPair<TapList<Tree>, TapList<Tree>> diffRW, SymbolTable diffSymbolTable) {
        Tree expr = toPrimalExp.obj();
        WrapperTypeSpec exprType = this.adEnv.curSymbolTable().typeOf(expr);
        TapList<ArrayDim> dimensions = ((TypeSpec)exprType).getAllDimensions();
        Tree[] dummyDiffLhsR = new Tree[this.replicas];
        LinLeaf linLhs = new LinLeaf(null, dummyDiffLhsR, this.adEnv.curInstruction().whereMask(), true, null, -1);
        LinAssign mainRoot = new LinAssign(linLhs, null, exprType, false, null, -1);
        TapList<LinAssign> toLinTrees = new TapList<LinAssign>(mainRoot, null);
        Tree expression = this.rebalanceExp(expr, beforeActiv, this.adEnv.curSymbolTable(), new ToBool(false), 1);
        this.tangentDiff = true;
        boolean cutInPrimal = this.findDiffOptimalCuts(expression, dimensions);
        if (this.activeExpr(expression)) {
            this.linearize(expression, mainRoot, -1, dimensions, this.adEnv.curInstruction().whereMask(), toLinTrees, toPrecomputes, diffSymbolTable);
        }
        if (this.adEnv.traceCurBlock == 2) {
            TapEnv.printlnOnTrace(" LINEARIZE EXPRESSION: " + expression + " (from expr: " + expr + ')');
            TapEnv.printlnOnTrace("    PRIMAL PRECOMPUTES: " + toPrecomputes.tail);
            TapEnv.printlnOnTrace("    TANGENT PRECOMPUTES: " + toLinTrees.tail);
            TapEnv.printlnOnTrace("    LINEARIZATION TREE: " + mainRoot);
        }
        if (this.multiDirMode()) {
            this.varRefDifferentiator().multiDirIterDescriptor.setJustAnIndex(true);
        }
        Tree[] tgtAssignTreeR = new Tree[this.replicas];
        this.adEnv.iReplic = 0;
        while (this.adEnv.iReplic < this.replicas) {
            TapList subLinTrees = toLinTrees.tail;
            while (subLinTrees != null) {
                LinAssign subLinTree = (LinAssign)toLinTrees.tail.head;
                TapPair<Object, Object> subPrimRW = new TapPair<Object, Object>(null, null);
                TapPair<Object, Object> subDiffRW = new TapPair<Object, Object>(null, null);
                Tree tangentTempTree = subLinTree.buildTreeForward(subPrimRW, subDiffRW);
                DiffAssignmentNode futureDiffNode = new DiffAssignmentNode(tangentTempTree, 3, null, subLinTree.linLhs.ref, this.adEnv.iReplic, (TapList)subPrimRW.first, (TapList)subPrimRW.second, (TapList)subDiffRW.first, (TapList)subDiffRW.second);
                futureDiffNode.type = subLinTree.assignedType;
                toPrecomputesDiff.placdl(futureDiffNode);
                subLinTrees = subLinTrees.tail;
            }
            Tree tgtAssignTree = mainRoot.buildTreeForward(primRW, diffRW);
            if (ILUtils.isNullOrNone(tgtAssignTree = tgtAssignTree.cutChild(2))) {
                tgtAssignTree = null;
            }
            tgtAssignTreeR[this.adEnv.iReplic] = tgtAssignTree;
            ++this.adEnv.iReplic;
        }
        this.adEnv.iReplic = 0;
        if (this.multiDirMode()) {
            this.varRefDifferentiator().multiDirIterDescriptor.setJustAnIndex(false);
        }
        if (cutInPrimal) {
            toPrimalExp.setObj(this.replacePrecomputedAndCustomize(ILUtils.copy(expression)));
        }
        if (this.adEnv.traceCurBlock == 2) {
            TapEnv.printlnOnTrace(" TANGENT DIFF EXPRESSION: " + ILUtils.toString(tgtAssignTreeR[0]) + (tgtAssignTreeR.length == 1 ? "" : " *" + tgtAssignTreeR.length + "replicas") + " (PRIMAL EXPRESSION:" + toPrimalExp.obj() + ')');
        }
        return tgtAssignTreeR;
    }

    protected TapList<DiffAssignmentNode>[] adjointDifferentiateAssignedExpression(Tree lhs, boolean needSetDiffLhs, Tree expression, boolean needDiffRhs, TapList<NewBlockGraphNode> toPrecomputes, BoolVector beforeActiv, SymbolTable diffSymbolTable) {
        WrapperTypeSpec lhsType = this.adEnv.curSymbolTable().typeOf(lhs);
        TapList<ArrayDim> dimensions = ((TypeSpec)lhsType).getAllDimensions();
        Tree[] diffLhsR = new Tree[this.replicas];
        this.adEnv.iReplic = 0;
        while (this.adEnv.iReplic < this.replicas) {
            diffLhsR[this.adEnv.iReplic] = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), lhs, diffSymbolTable, false, lhs, false, true, lhs);
            ++this.adEnv.iReplic;
        }
        LinLeaf linLhs = new LinLeaf(lhs, diffLhsR, this.adEnv.curInstruction().whereMask(), needSetDiffLhs, null, -1);
        LinAssign mainRoot = new LinAssign(linLhs, null, lhsType, dimensions != null, null, -1);
        TapList<LinAssign> toLinTrees = new TapList<LinAssign>(mainRoot, null);
        if (needDiffRhs) {
            expression = this.rebalanceExp(expression, beforeActiv, this.adEnv.curSymbolTable(), new ToBool(false), 1);
            this.tangentDiff = false;
            boolean cutInPrimal = this.findDiffOptimalCuts(expression, dimensions);
            if (this.activeExpr(expression)) {
                this.linearize(expression, mainRoot, -1, dimensions, this.adEnv.curInstruction().whereMask(), toLinTrees, toPrecomputes, diffSymbolTable);
            }
            if (this.adEnv.traceCurBlock == 2) {
                TapEnv.printlnOnTrace(" LINEARIZE RHS OF: " + ILUtils.toString(lhs) + " := " + ILUtils.toString(expression));
                TapEnv.printlnOnTrace("    LINEARIZATION TREE: " + mainRoot);
                TapEnv.printlnOnTrace("    ADDITIONAL LINEARIZATION TREES: " + toLinTrees.tail);
                TapEnv.printlnOnTrace("    PRIMAL PRECOMPUTES: " + toPrecomputes.tail);
            }
        }
        TapList[] adjAssignmentNodesR = new TapList[this.replicas];
        this.adEnv.iReplic = 0;
        while (this.adEnv.iReplic < this.replicas) {
            TapList<DiffAssignmentNode> adjAssignmentNodes = null;
            TapList<LinAssign> inLinTrees = toLinTrees;
            while (inLinTrees != null) {
                adjAssignmentNodes = TapList.append(((LinAssign)inLinTrees.head).buildTreesBackward(), adjAssignmentNodes);
                inLinTrees = inLinTrees.tail;
            }
            adjAssignmentNodesR[this.adEnv.iReplic] = adjAssignmentNodes;
            ++this.adEnv.iReplic;
        }
        this.adEnv.iReplic = 0;
        return adjAssignmentNodesR;
    }

    private Tree replacePrecomputedAndCustomize(Tree expr) {
        if (expr == null) {
            return null;
        }
        DiffCutSupport cutHere = ExpressionDifferentiator.getCutCosts(expr);
        if (cutHere != null) {
            expr.removeAnnotation("CutCosts");
        }
        if (cutHere != null && cutHere.cutPrimal) {
            NewSymbolHolder tmpVarHolder = cutHere.tmpVarHolder;
            expr = tmpVarHolder.makeNewRef(null);
        } else if (!expr.isAtom()) {
            Tree[] children = expr.children();
            for (int i = children.length - 1; i >= 0; --i) {
                expr.setChild(this.replacePrecomputedAndCustomize(children[i]), i + 1);
            }
            if (expr.opCode() == 155 && expr.down(2).opCode() == 103) {
                if (ILUtils.isIntCst(expr.down(2), 2)) {
                    expr = ILUtils.build(133, ILUtils.copy(expr.down(1)), ILUtils.copy(expr.down(1)));
                } else if (ILUtils.isIntCst(expr.down(2), 3)) {
                    expr = ILUtils.build(133, ILUtils.build(133, ILUtils.copy(expr.down(1)), ILUtils.copy(expr.down(1))), ILUtils.copy(expr.down(1)));
                }
            }
        }
        return expr;
    }

    private Tree rebalanceExp(Tree tree, BoolVector beforeActiv, SymbolTable symbolTable, ToBool toActive, int mode) {
        switch (tree.opCode()) {
            case 3: 
            case 124: 
            case 182: {
                Tree rebalancedTree = this.rebalanceTerms(tree, beforeActiv, symbolTable, toActive, mode);
                if (rebalancedTree == null) {
                    rebalancedTree = PrimitiveTypeSpec.buildRealConstantZero();
                }
                return rebalancedTree;
            }
            case 62: 
            case 133: {
                ToBool positive = new ToBool(true);
                Tree bTree = this.rebalanceFactors(tree, positive, beforeActiv, symbolTable, toActive, mode);
                boolean wasActive = ADActivityAnalyzer.isAnnotatedActive(this.adEnv.curActivity(), bTree, this.adEnv.curSymbolTable());
                if (!positive.get()) {
                    bTree = ILUtils.buildExpressionOpposite(bTree);
                }
                if (wasActive) {
                    ADActivityAnalyzer.setAnnotatedActive(this.adEnv.curActivity(), bTree);
                }
                return bTree;
            }
            case 99: {
                Tree rebalancedTrue = this.rebalanceExp(tree.down(2), beforeActiv, symbolTable, toActive, mode);
                Tree rebalancedFalse = this.rebalanceExp(tree.down(3), beforeActiv, symbolTable, toActive, mode);
                Tree newTree = ILUtils.build(99, ILUtils.copy(tree.down(1)), rebalancedTrue, rebalancedFalse);
                if (ADActivityAnalyzer.isAnnotatedActive(this.adEnv.curActivity(), tree, this.adEnv.curSymbolTable())) {
                    ADActivityAnalyzer.setAnnotatedActive(this.adEnv.curActivity(), newTree);
                }
                return newTree;
            }
            case 42: 
            case 155: {
                Tree result = ILUtils.build(tree.opCode(), this.rebalanceExp(tree.down(1), beforeActiv, symbolTable, toActive, mode), this.rebalanceExp(tree.down(2), beforeActiv, symbolTable, toActive, mode));
                if (ADActivityAnalyzer.isAnnotatedActive(this.adEnv.curActivity(), result.down(1), this.adEnv.curSymbolTable()) || ADActivityAnalyzer.isAnnotatedActive(this.adEnv.curActivity(), result.down(2), this.adEnv.curSymbolTable())) {
                    ADActivityAnalyzer.setAnnotatedActive(this.adEnv.curActivity(), result);
                }
                return result;
            }
            case 31: {
                Tree newTree = ILUtils.buildCall(ILUtils.copy(ILUtils.getCalledName(tree)), this.rebalanceExp(ILUtils.getArguments(tree), beforeActiv, symbolTable, toActive, mode));
                Object f = tree.getAnnotation("functionTypeSpec");
                if (f != null) {
                    newTree.setAnnotation("functionTypeSpec", f);
                }
                if ((f = tree.getAnnotation("arrayReturnTypeSpec")) != null) {
                    newTree.setAnnotation("arrayReturnTypeSpec", f);
                }
                if ((f = tree.getAnnotation("callArrow")) != null) {
                    newTree.setAnnotation("callArrow", f);
                }
                if (ADActivityAnalyzer.isAnnotatedActive(this.adEnv.curActivity(), tree, this.adEnv.curSymbolTable())) {
                    ADActivityAnalyzer.setAnnotatedActive(this.adEnv.curActivity(), newTree);
                }
                return newTree;
            }
            case 10: 
            case 71: {
                Tree resultTree = tree.operator().tree();
                Tree[] subTrees = tree.children();
                for (int i = subTrees.length - 1; i >= 0; --i) {
                    resultTree.setChild(this.rebalanceExp(subTrees[i], beforeActiv, symbolTable, toActive, mode), i + 1);
                }
                return resultTree;
            }
            case 4: 
            case 9: 
            case 75: 
            case 96: 
            case 151: {
                if (beforeActiv != null && ADActivityAnalyzer.isAnnotatedActive(this.adEnv.curActivity(), tree, this.adEnv.curSymbolTable())) {
                    toActive.set(true);
                }
                return ILUtils.copy(tree);
            }
            case 5: 
            case 6: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 28: 
            case 32: 
            case 43: 
            case 47: 
            case 55: 
            case 68: 
            case 92: 
            case 95: 
            case 102: 
            case 103: 
            case 110: 
            case 115: 
            case 116: 
            case 122: 
            case 126: 
            case 134: 
            case 137: 
            case 138: 
            case 139: 
            case 143: 
            case 160: 
            case 169: 
            case 176: 
            case 180: 
            case 181: 
            case 194: 
            case 207: {
                return ILUtils.copy(tree);
            }
        }
        TapEnv.toolWarning(-1, "(Balance expression before differentiation) Unexpected operator: " + tree.opName());
        return ILUtils.copy(tree);
    }

    private Tree rebalanceTerms(Tree tree, BoolVector beforeActiv, SymbolTable symbolTable, ToBool toActive, int mode) {
        TapList<Object> toPTerms = new TapList<Object>(null, null);
        TapIntList toPFactors = new TapIntList(1, null);
        TapList<Object> toATerms = new TapList<Object>(null, null);
        TapIntList toAFactors = new TapIntList(1, null);
        this.flattenBalancedTerms(tree, 1, toPTerms, toPFactors, toATerms, toAFactors, beforeActiv, symbolTable, mode);
        if (mode == 0) {
            Tree numCstTerm = (Tree)toPTerms.head;
            Tree allTerms = this.rebuildBalancedTerms(toPTerms, toPFactors, 0);
            if (numCstTerm != null) {
                allTerms = ExpressionDifferentiator.rebuildAddOneFlatTerm(allTerms, numCstTerm, 1);
            }
            return allTerms;
        }
        Tree numCstTerm = (Tree)toPTerms.head;
        Tree passiveTerms = this.rebuildBalancedTerms(toPTerms, toPFactors, 1);
        Tree activeTerms = this.rebuildBalancedTerms(toATerms, toAFactors, 1);
        if (activeTerms != null) {
            toActive.set(true);
        }
        if (numCstTerm != null) {
            passiveTerms = passiveTerms != null ? ILUtils.addTree(numCstTerm, passiveTerms) : numCstTerm;
        }
        Tree result = passiveTerms != null ? (activeTerms != null ? ILUtils.addTree(passiveTerms, activeTerms) : passiveTerms) : activeTerms;
        this.setSubExpsActive(result);
        return result;
    }

    private void flattenBalancedTerms(Tree tree, int factor, TapList<Tree> toPTerms, TapIntList toPFactors, TapList<Tree> toATerms, TapIntList toAFactors, BoolVector beforeActiv, SymbolTable symbolTable, int mode) {
        switch (tree.opCode()) {
            case 3: {
                this.flattenBalancedTerms(tree.down(1), factor, toPTerms, toPFactors, toATerms, toAFactors, beforeActiv, symbolTable, mode);
                this.flattenBalancedTerms(tree.down(2), factor, toPTerms, toPFactors, toATerms, toAFactors, beforeActiv, symbolTable, mode);
                break;
            }
            case 182: {
                this.flattenBalancedTerms(tree.down(1), factor, toPTerms, toPFactors, toATerms, toAFactors, beforeActiv, symbolTable, mode);
                this.flattenBalancedTerms(tree.down(2), -factor, toPTerms, toPFactors, toATerms, toAFactors, beforeActiv, symbolTable, mode);
                break;
            }
            case 124: {
                this.flattenBalancedTerms(tree.down(1), -factor, toPTerms, toPFactors, toATerms, toAFactors, beforeActiv, symbolTable, mode);
                break;
            }
            case 133: {
                if (ILUtils.isExpressionIntConstant(tree.down(1))) {
                    this.flattenBalancedTerms(tree.down(2), factor * ILUtils.intConstantValue(tree.down(1)), toPTerms, toPFactors, toATerms, toAFactors, beforeActiv, symbolTable, mode);
                    break;
                }
                if (ILUtils.isExpressionIntConstant(tree.down(2))) {
                    this.flattenBalancedTerms(tree.down(1), factor * ILUtils.intConstantValue(tree.down(2)), toPTerms, toPFactors, toATerms, toAFactors, beforeActiv, symbolTable, mode);
                    break;
                }
                ToBool positive = new ToBool(true);
                ToBool toActive = new ToBool(false);
                Tree bTree = this.rebalanceFactors(tree, positive, beforeActiv, symbolTable, toActive, mode);
                if (positive.get()) {
                    if (toActive.get()) {
                        this.insertBalancedTerm(bTree, factor, toATerms, toAFactors);
                        break;
                    }
                    this.insertBalancedTerm(bTree, factor, toPTerms, toPFactors);
                    break;
                }
                if (toActive.get()) {
                    this.insertBalancedTerm(bTree, -factor, toATerms, toAFactors);
                    break;
                }
                this.insertBalancedTerm(bTree, -factor, toPTerms, toPFactors);
                break;
            }
            default: {
                ToBool toActive = new ToBool(false);
                Tree bTree = this.rebalanceExp(tree, beforeActiv, symbolTable, toActive, mode);
                if (toActive.get()) {
                    this.insertBalancedTerm(bTree, factor, toATerms, toAFactors);
                    break;
                }
                this.insertBalancedTerm(bTree, factor, toPTerms, toPFactors);
                break;
            }
        }
    }

    private void insertBalancedTerm(Tree tree, int factor, TapList<Tree> toTerms, TapIntList toFactors) {
        if (factor != 0 && !ILUtils.evalsToZero(tree)) {
            if (tree.opCode() == 103) {
                tree = ILUtils.build(103, factor * tree.intValue());
                factor = 1;
            }
            if (ILUtils.isExpressionNumConstant(tree) && (factor == -1 || factor == 1)) {
                if (factor == -1) {
                    tree = ILUtils.buildExpressionOpposite(tree);
                }
                toTerms.head = toTerms.head == null ? tree : ILUtils.addExpressionsNumConstants((Tree)toTerms.head, tree);
            } else {
                this.insertTimesTree(tree, factor, toTerms, toFactors);
            }
        }
    }

    private Tree rebuildBalancedTerms(TapList<Tree> toTerms, TapIntList toFactors, int mode) {
        TapList<Tree> inTerms = toTerms;
        TapIntList inFactors = toFactors;
        while (inTerms.tail != null) {
            if (inTerms.tail.head == null || inFactors.tail.head == 0) {
                inTerms.tail = inTerms.tail.tail;
                inFactors.tail = inFactors.tail.tail;
                continue;
            }
            inTerms = inTerms.tail;
            inFactors = inFactors.tail;
        }
        if (mode == 1) {
            return this.rebuildBalancedTermsRec(toTerms, toFactors, TapList.length(toTerms) - 1);
        }
        return ExpressionDifferentiator.rebuildFlatTerms(toTerms.tail, toFactors.tail);
    }

    private Tree rebuildBalancedTermsRec(TapList<Tree> toTerms, TapIntList toFactors, int length) {
        switch (length) {
            case 0: {
                return null;
            }
            case 1: {
                int factor = toFactors.tail.head;
                Tree term = (Tree)toTerms.tail.head;
                if (factor < -1 || factor > 1) {
                    term = ILUtils.build(133, ILUtils.build(103, factor), term);
                } else if (factor == -1) {
                    term = ILUtils.build(124, term);
                }
                toFactors.tail = toFactors.tail.tail;
                toTerms.tail = toTerms.tail.tail;
                return term;
            }
        }
        Tree leftTree = this.rebuildBalancedTermsRec(toTerms, toFactors, length - length / 2);
        Tree rightTree = this.rebuildBalancedTermsRec(toTerms, toFactors, length / 2);
        return ILUtils.addTree(leftTree, rightTree);
    }

    private static Tree rebuildFlatTerms(TapList<Tree> terms, TapIntList factors) {
        Tree result = null;
        while (terms != null) {
            result = ExpressionDifferentiator.rebuildAddOneFlatTerm(result, (Tree)terms.head, factors.head);
            terms = terms.tail;
            factors = factors.tail;
        }
        return result;
    }

    private static Tree rebuildAddOneFlatTerm(Tree left, Tree right, int rightFactor) {
        if (left == null) {
            if (rightFactor < -1 || rightFactor > 1) {
                return ILUtils.build(133, ILUtils.build(103, rightFactor), right);
            }
            if (rightFactor == -1) {
                return ILUtils.build(124, right);
            }
            return right;
        }
        boolean isAdd = true;
        if (rightFactor < 0) {
            isAdd = !isAdd;
            rightFactor = -rightFactor;
        }
        if (ILUtils.isNegativeExpression(right)) {
            isAdd = !isAdd;
            right = ILUtils.buildNumericalOpposite(right);
        }
        if (rightFactor > 1) {
            right = ILUtils.build(133, ILUtils.build(103, rightFactor), right);
        }
        if (isAdd) {
            return ILUtils.build(3, left, right);
        }
        return ILUtils.build(182, left, right);
    }

    private Tree rebalanceFactors(Tree tree, ToBool positive, BoolVector beforeActiv, SymbolTable symbolTable, ToBool toActive, int mode) {
        Tree result;
        TapList<Object> toPFactors = new TapList<Object>(null, null);
        TapIntList toPPowers = new TapIntList(1, null);
        TapList<Object> toAFactors = new TapList<Object>(null, null);
        TapIntList toAPowers = new TapIntList(1, null);
        TapList<Object> toDPFactors = new TapList<Object>(null, null);
        TapIntList toDPPowers = new TapIntList(0, null);
        TapList<Object> toDAFactors = new TapList<Object>(null, null);
        TapIntList toDAPowers = new TapIntList(0, null);
        this.flattenBalancedFactors(tree, 1, positive, toPFactors, toPPowers, toAFactors, toAPowers, beforeActiv, symbolTable, mode);
        Tree numCstFactor = (Tree)toPFactors.head;
        if (numCstFactor != null && ILUtils.isNegativeExpression(numCstFactor)) {
            positive.not();
            numCstFactor = ILUtils.buildExpressionOpposite(numCstFactor);
        }
        if (mode == 0) {
            ExpressionDifferentiator.separateDenominator(toPFactors, toPPowers, toDPFactors, toDPPowers);
            if (numCstFactor != null) {
                toPFactors.placdl(numCstFactor);
                toPPowers.placdl(1);
            }
            Tree result2 = ExpressionDifferentiator.rebuildFlatFactors(toPFactors.tail, toPPowers.tail);
            Tree denominator = ExpressionDifferentiator.rebuildFlatFactors(toDPFactors.tail, toDPPowers.tail);
            if (denominator != null) {
                if (result2 == null) {
                    result2 = ILUtils.build(160, "1.0");
                }
                result2 = ILUtils.build(62, result2, denominator);
            }
            return result2;
        }
        if (toAFactors.tail != null) {
            toActive.set(true);
        }
        ExpressionDifferentiator.separateDenominator(toPFactors, toPPowers, toDPFactors, toDPPowers);
        ExpressionDifferentiator.separateDenominator(toAFactors, toAPowers, toDAFactors, toDAPowers);
        Tree denominator = ExpressionDifferentiator.rebuildBalancedFactorsRec(toDPFactors, toDPPowers, null);
        if (denominator != null) {
            toDAFactors.placdl(denominator);
            toDAPowers.placdl(1);
        }
        denominator = ExpressionDifferentiator.rebuildBalancedFactorsRec(toDAFactors, toDAPowers, null);
        if (numCstFactor != null) {
            toPFactors.newR(numCstFactor);
            toPPowers.newR(1);
        }
        if (toAFactors.tail == null) {
            result = ExpressionDifferentiator.rebuildBalancedFactorsRec(toPFactors, toPPowers, denominator);
        } else {
            result = ExpressionDifferentiator.rebuildBalancedFactorsRec(toAFactors, toAPowers, denominator);
            toPFactors.newR(result);
            toPPowers.newR(1);
            result = ExpressionDifferentiator.rebuildBalancedFactorsRec(toPFactors, toPPowers, null);
        }
        if (result == null) {
            result = ILUtils.build(160, "1.0");
        } else {
            this.setSubExpsActive(result);
        }
        return result;
    }

    private void flattenBalancedFactors(Tree tree, int power, ToBool positive, TapList<Tree> toPFactors, TapIntList toPPowers, TapList<Tree> toAFactors, TapIntList toAPowers, BoolVector beforeActiv, SymbolTable symbolTable, int mode) {
        switch (tree.opCode()) {
            case 133: {
                this.flattenBalancedFactors(tree.down(1), power, positive, toPFactors, toPPowers, toAFactors, toAPowers, beforeActiv, symbolTable, mode);
                this.flattenBalancedFactors(tree.down(2), power, positive, toPFactors, toPPowers, toAFactors, toAPowers, beforeActiv, symbolTable, mode);
                break;
            }
            case 62: {
                this.flattenBalancedFactors(tree.down(1), power, positive, toPFactors, toPPowers, toAFactors, toAPowers, beforeActiv, symbolTable, mode);
                this.flattenBalancedFactors(tree.down(2), -power, positive, toPFactors, toPPowers, toAFactors, toAPowers, beforeActiv, symbolTable, mode);
                break;
            }
            case 124: {
                if (power % 2 != 0) {
                    positive.not();
                }
                this.flattenBalancedFactors(tree.down(1), power, positive, toPFactors, toPPowers, toAFactors, toAPowers, beforeActiv, symbolTable, mode);
                break;
            }
            case 155: {
                if (ILUtils.isExpressionIntConstant(tree.down(2))) {
                    this.flattenBalancedFactors(tree.down(1), power * ILUtils.intConstantValue(tree.down(2)), positive, toPFactors, toPPowers, toAFactors, toAPowers, beforeActiv, symbolTable, mode);
                    break;
                }
                ToBool toActive = new ToBool(false);
                Tree bTree = this.rebalanceExp(tree, beforeActiv, symbolTable, toActive, mode);
                if (toActive.get()) {
                    this.insertBalancedFactor(bTree, power, toAFactors, toAPowers);
                    break;
                }
                this.insertBalancedFactor(bTree, power, toPFactors, toPPowers);
                break;
            }
            default: {
                ToBool toActive = new ToBool(false);
                Tree bTree = this.rebalanceExp(tree, beforeActiv, symbolTable, toActive, mode);
                if (toActive.get()) {
                    this.insertBalancedFactor(bTree, power, toAFactors, toAPowers);
                    break;
                }
                this.insertBalancedFactor(bTree, power, toPFactors, toPPowers);
                break;
            }
        }
    }

    private void insertBalancedFactor(Tree tree, int power, TapList<Tree> toFactors, TapIntList toPowers) {
        if (power != 0 && !ILUtils.evalsToOne(tree)) {
            if (ILUtils.isExpressionNumConstant(tree) && power == 1 && toFactors.head == null) {
                toFactors.head = tree;
            } else {
                this.insertTimesTree(tree, power, toFactors, toPowers);
            }
        }
    }

    private static void separateDenominator(TapList<Tree> toFactors, TapIntList toPowers, TapList<Tree> toDFactors, TapIntList toDPowers) {
        TapList<Tree> inFactors = toFactors;
        TapIntList inPowers = toPowers;
        TapList<Tree> inDFactors = toDFactors;
        TapIntList inDPowers = toDPowers;
        while (inFactors.tail != null) {
            if (inFactors.tail.head == null || inPowers.tail.head <= 0) {
                if (inFactors.tail.head != null && inPowers.tail.head < 0) {
                    inDFactors = inDFactors.placdl((Tree)inFactors.tail.head);
                    inDPowers = inDPowers.placdl(-inPowers.tail.head);
                }
                inFactors.tail = inFactors.tail.tail;
                inPowers.tail = inPowers.tail.tail;
                continue;
            }
            inFactors = inFactors.tail;
            inPowers = inPowers.tail;
        }
    }

    private static Tree rebuildBalancedFactorsRec(TapList<Tree> toFactors, TapIntList toPowers, Tree denominator) {
        TapIntList toWeights;
        TapList<Tree> inFactors = toFactors;
        TapIntList inWeights = toWeights = new TapIntList(-1, null);
        while (inFactors.tail != null) {
            int power = toPowers.tail.head;
            if (power > 1) {
                inFactors.tail.head = ILUtils.build(155, (Tree)inFactors.tail.head, ILUtils.build(103, power));
            }
            inWeights = inWeights.placdl(ExpressionDifferentiator.getCost((Tree)inFactors.tail.head));
            inFactors = inFactors.tail;
            toPowers = toPowers.tail;
        }
        if (denominator != null) {
            inFactors.tail = new TapList<Tree>(denominator, null);
            inWeights.tail = new TapIntList(ExpressionDifferentiator.getCost(denominator), null);
        }
        if (toFactors.tail != null) {
            while (toFactors.tail.tail != null) {
                TapList<Tree> toFactor1 = null;
                TapList<Tree> toFactor2 = null;
                TapIntList toWeight1 = null;
                TapIntList toWeight2 = null;
                inFactors = toFactors;
                inWeights = toWeights;
                boolean ordered = false;
                while (inFactors.tail != null) {
                    if (toWeight1 == null || inWeights.tail.head < toWeight1.tail.head) {
                        toFactor2 = toFactor1;
                        toWeight2 = toWeight1;
                        toFactor1 = inFactors;
                        toWeight1 = inWeights;
                        ordered = false;
                    } else if (toWeight2 == null || inWeights.tail.head < toWeight2.tail.head) {
                        toFactor2 = inFactors;
                        toWeight2 = inWeights;
                        ordered = true;
                    }
                    inFactors = inFactors.tail;
                    inWeights = inWeights.tail;
                }
                if (!ordered) {
                    TapList<Tree> tmp = toFactor2;
                    toFactor2 = toFactor1;
                    toFactor1 = tmp;
                    TapIntList tmpLInt = toWeight2;
                    toWeight2 = toWeight1;
                    toWeight1 = tmpLInt;
                }
                Tree combinedTree = toFactor2.tail.head == denominator ? ILUtils.build(62, (Tree)toFactor1.tail.head, (Tree)toFactor2.tail.head) : ILUtils.build(133, (Tree)toFactor1.tail.head, (Tree)toFactor2.tail.head);
                int combinedWeight = toWeight1.tail.head + toWeight2.tail.head + 4;
                if (ordered) {
                    toFactor2.tail.head = combinedTree;
                    toWeight2.tail.head = combinedWeight;
                    toFactor1.tail = toFactor1.tail.tail;
                    toWeight1.tail = toWeight1.tail.tail;
                    continue;
                }
                toFactor1.tail.head = combinedTree;
                toWeight1.tail.head = combinedWeight;
                toFactor2.tail = toFactor2.tail.tail;
                toWeight2.tail = toWeight2.tail.tail;
            }
        }
        if (toFactors.tail == null) {
            return null;
        }
        if (toFactors.tail.head == denominator) {
            return ILUtils.build(62, ILUtils.build(160, "1.0"), denominator);
        }
        return (Tree)toFactors.tail.head;
    }

    private static Tree rebuildFlatFactors(TapList<Tree> factors, TapIntList powers) {
        Tree result = null;
        while (factors != null) {
            result = ExpressionDifferentiator.rebuildMulOneFlatFactor(result, (Tree)factors.head, powers.head);
            factors = factors.tail;
            powers = powers.tail;
        }
        return result;
    }

    private static Tree rebuildMulOneFlatFactor(Tree left, Tree right, int rightPower) {
        if (rightPower > 1) {
            right = ILUtils.build(155, right, ILUtils.build(103, rightPower));
        }
        if (left == null) {
            return right;
        }
        return ILUtils.build(133, left, right);
    }

    private boolean setSubExpsActive(Tree expr) {
        if (expr != null) {
            switch (expr.opCode()) {
                case 3: 
                case 62: 
                case 133: 
                case 155: 
                case 182: {
                    boolean active1 = this.setSubExpsActive(expr.down(1));
                    boolean active2 = this.setSubExpsActive(expr.down(2));
                    if (active1 || active2) {
                        ADActivityAnalyzer.setAnnotatedActive(this.adEnv.curActivity(), expr);
                    }
                    return active1 || active2;
                }
                case 124: {
                    boolean active1 = this.setSubExpsActive(expr.down(1));
                    if (active1) {
                        ADActivityAnalyzer.setAnnotatedActive(this.adEnv.curActivity(), expr);
                    }
                    return active1;
                }
                case 6: 
                case 18: 
                case 20: 
                case 21: 
                case 22: 
                case 24: 
                case 28: 
                case 43: 
                case 55: 
                case 68: 
                case 92: 
                case 95: 
                case 102: 
                case 103: 
                case 115: 
                case 116: 
                case 122: 
                case 137: 
                case 138: 
                case 139: 
                case 143: 
                case 160: 
                case 169: 
                case 180: 
                case 181: 
                case 207: {
                    return false;
                }
            }
            return ADActivityAnalyzer.isAnnotatedActive(this.adEnv.curActivity(), expr, this.adEnv.curSymbolTable());
        }
        return false;
    }

    private void insertTimesTree(Tree tree, int times, TapList<Tree> toTrees, TapIntList toTimes) {
        while (toTrees.tail != null && !ILUtils.equalValues((Tree)toTrees.tail.head, tree, null, null)) {
            toTrees = toTrees.tail;
            toTimes = toTimes.tail;
        }
        if (toTrees.tail == null) {
            toTrees.tail = new TapList<Tree>(tree, null);
            toTimes.tail = new TapIntList(0, null);
        }
        toTimes.tail.head += times;
    }

    private boolean findDiffOptimalCuts(Tree tree, TapList<ArrayDim> dimensions) {
        if (this.adEnv.traceCurBlock == 2) {
            TapEnv.printlnOnTrace("ANALYZING " + (this.tangentDiff ? "TANGENT" : "ADJOINT") + " CUTS IN " + tree + ':');
        }
        DiffCutSupport topCutCosts = this.getSetCutCosts(tree);
        this.computeBottomUpCosts(tree, topCutCosts, true);
        boolean cutInPrimal = false;
        if (TapEnv.get().splitDiffExpressions) {
            block0: while (true) {
                boolean cutPrimal;
                TapList<Tree> mostProfitableCut;
                topCutCosts.primalTimes = this.tangentDiff ? 1 : 0;
                topCutCosts.adjCost = 1;
                this.computeTopDownCosts(tree, topCutCosts, dimensions);
                if (this.adEnv.traceCurBlock == 2) {
                    TapEnv.printlnOnTrace("    TREE WITH CUT SUPPORT: " + ILUtils.toString(tree, this.adEnv.curActivity()));
                }
                if ((mostProfitableCut = this.mostProfitableCut(tree, null, null)) == null) break;
                if (this.adEnv.traceCurBlock == 2) {
                    TapEnv.printlnOnTrace("    -> CUT " + this.showCutDecision(ExpressionDifferentiator.getCutCosts((Tree)mostProfitableCut.head)) + "  OF  " + ILUtils.toString((Tree)mostProfitableCut.head));
                }
                if (cutPrimal = ExpressionDifferentiator.getCutCosts((Tree)mostProfitableCut.head).doBestCut()) {
                    cutInPrimal = true;
                }
                TapList treesAbove = mostProfitableCut.tail;
                while (true) {
                    if (treesAbove == null) continue block0;
                    this.computeBottomUpCosts((Tree)treesAbove.head, this.getSetCutCosts((Tree)treesAbove.head), false);
                    treesAbove = treesAbove.tail;
                }
                break;
            }
        }
        return cutInPrimal;
    }

    private String showCutDecision(DiffCutSupport cc) {
        int p3;
        int p1 = (cc.primalTimes - 1) * cc.primalCost - (cc.primalTimes + 1) * 1;
        if (p1 > (p3 = (cc.adjTimes - 1) * cc.adjCost - (cc.adjTimes + 1) * 1)) {
            return "PRIMAL";
        }
        return "ADJOINT";
    }

    private void computeBottomUpCosts(Tree tree, DiffCutSupport cc, boolean recurse) {
        switch (tree.opCode()) {
            case 3: 
            case 182: {
                DiffCutSupport cc1 = this.getSetCutCosts(tree.down(1));
                DiffCutSupport cc2 = this.getSetCutCosts(tree.down(2));
                if (recurse) {
                    this.computeBottomUpCosts(tree.down(1), cc1, true);
                    this.computeBottomUpCosts(tree.down(2), cc2, true);
                }
                cc.isActive = cc1.isActive || cc2.isActive;
                int childrenCost = cc1.primalCost + cc2.primalCost;
                cc.primalCost = cc.cutPrimal ? 1 : (childrenCost == 0 ? 0 : childrenCost + 1);
                cc.adjTimes = this.tangentDiff ? 0 : (cc.cutAdj ? 1 : cc1.adjTimes + cc2.adjTimes);
                break;
            }
            case 126: 
            case 133: {
                DiffCutSupport cc1 = this.getSetCutCosts(tree.down(1));
                DiffCutSupport cc2 = this.getSetCutCosts(tree.down(2));
                if (recurse) {
                    this.computeBottomUpCosts(tree.down(1), cc1, true);
                    this.computeBottomUpCosts(tree.down(2), cc2, true);
                }
                cc.isActive = cc1.isActive || cc2.isActive;
                int childrenCost = cc1.primalCost + cc2.primalCost;
                cc.primalCost = cc.cutPrimal ? 1 : (childrenCost == 0 ? 0 : childrenCost + 4);
                cc.adjTimes = this.tangentDiff ? 0 : (cc.cutAdj ? 1 : cc1.adjTimes + cc2.adjTimes);
                break;
            }
            case 62: {
                DiffCutSupport cc1 = this.getSetCutCosts(tree.down(1));
                DiffCutSupport cc2 = this.getSetCutCosts(tree.down(2));
                if (recurse) {
                    this.computeBottomUpCosts(tree.down(1), cc1, true);
                    this.computeBottomUpCosts(tree.down(2), cc2, true);
                }
                cc.isActive = cc1.isActive || cc2.isActive;
                int childrenCost = cc1.primalCost + cc2.primalCost;
                cc.primalCost = cc.cutPrimal ? 1 : (childrenCost == 0 ? 0 : childrenCost + 6);
                cc.adjTimes = this.tangentDiff ? 0 : (cc.cutAdj ? 1 : cc1.adjTimes + cc2.adjTimes);
                break;
            }
            case 155: {
                DiffCutSupport cc1 = this.getSetCutCosts(tree.down(1));
                DiffCutSupport cc2 = this.getSetCutCosts(tree.down(2));
                if (recurse) {
                    this.computeBottomUpCosts(tree.down(1), cc1, true);
                    this.computeBottomUpCosts(tree.down(2), cc2, true);
                }
                cc.isActive = cc1.isActive || cc2.isActive;
                int childrenCost = cc1.primalCost + cc2.primalCost;
                cc.primalCost = cc.cutPrimal ? 1 : (childrenCost == 0 ? 0 : childrenCost + cc.dCostUp);
                cc.adjTimes = this.tangentDiff ? 0 : (cc.cutAdj ? 1 : cc1.adjTimes + cc2.adjTimes);
                break;
            }
            case 42: {
                DiffCutSupport cc1 = this.getSetCutCosts(tree.down(1));
                DiffCutSupport cc2 = this.getSetCutCosts(tree.down(2));
                if (recurse) {
                    this.computeBottomUpCosts(tree.down(1), cc1, true);
                    this.computeBottomUpCosts(tree.down(2), cc2, true);
                }
                cc.isActive = cc1.isActive || cc2.isActive;
                int childrenCost = cc1.primalCost + cc2.primalCost;
                cc.primalCost = cc.cutPrimal ? 1 : childrenCost;
                cc.adjTimes = this.tangentDiff ? 0 : (cc.cutAdj ? 1 : cc1.adjTimes + cc2.adjTimes);
                break;
            }
            case 99: {
                DiffCutSupport cc1 = this.getSetCutCosts(tree.down(2));
                DiffCutSupport cc2 = this.getSetCutCosts(tree.down(3));
                if (recurse) {
                    this.computeBottomUpCosts(tree.down(2), cc1, true);
                    this.computeBottomUpCosts(tree.down(3), cc2, true);
                }
                cc.isActive = cc1.isActive || cc2.isActive;
                cc.primalCost = cc.cutPrimal ? 1 : cc1.primalCost + cc2.primalCost + 1;
                cc.adjTimes = this.tangentDiff ? 0 : (cc.cutAdj ? 1 : cc1.adjTimes + cc2.adjTimes);
                break;
            }
            case 124: {
                DiffCutSupport cc1 = this.getSetCutCosts(tree.down(1));
                if (recurse) {
                    this.computeBottomUpCosts(tree.down(1), cc1, true);
                }
                cc.isActive = cc1.isActive;
                cc.primalCost = cc.cutPrimal ? 1 : cc1.primalCost;
                cc.adjTimes = this.tangentDiff ? 0 : (cc.cutAdj ? 1 : cc1.adjTimes);
                break;
            }
            case 32: 
            case 194: {
                DiffCutSupport cc1 = this.getSetCutCosts(tree.down(2));
                if (recurse) {
                    this.computeBottomUpCosts(tree.down(2), cc1, true);
                }
                cc.isActive = cc1.isActive;
                cc.primalCost = cc.cutPrimal ? 1 : cc1.primalCost;
                cc.adjTimes = this.tangentDiff ? 0 : (cc.cutAdj ? 1 : cc1.adjTimes);
                break;
            }
            case 31: {
                cc.primalCost = cc.cutPrimal ? 1 : 20;
                cc.adjTimes = cc.cutAdj && !this.tangentDiff ? 1 : 0;
                Tree[] args = ILUtils.getArguments(tree).children();
                for (int i = args.length - 1; i >= 0; --i) {
                    DiffCutSupport diffCutSupport;
                    DiffCutSupport cc1 = this.getSetCutCosts(args[i]);
                    if (recurse) {
                        this.computeBottomUpCosts(args[i], cc1, true);
                    }
                    if (cc1.isActive) {
                        cc.isActive = true;
                    }
                    if (!cc.cutPrimal) {
                        diffCutSupport = cc;
                        diffCutSupport.primalCost = diffCutSupport.primalCost + cc1.primalCost;
                    }
                    if (cc.cutAdj || this.tangentDiff) continue;
                    diffCutSupport = cc;
                    diffCutSupport.adjTimes = diffCutSupport.adjTimes + cc1.adjTimes;
                }
                break;
            }
            case 10: 
            case 47: 
            case 110: {
                Tree[] args = tree.opCode() == 110 ? tree.down(1).children() : (tree.opCode() == 47 ? tree.down(3).children() : tree.children());
                cc.primalCost = cc.cutPrimal ? args.length * 1 : 20;
                cc.adjTimes = cc.cutAdj && !this.tangentDiff ? 1 : 0;
                cc.isActive = false;
                for (int i = args.length - 1; i >= 0; --i) {
                    DiffCutSupport diffCutSupport;
                    DiffCutSupport cc1 = this.getSetCutCosts(args[i]);
                    if (recurse) {
                        this.computeBottomUpCosts(args[i], cc1, true);
                    }
                    if (cc1.isActive) {
                        cc.isActive = true;
                    }
                    if (!cc.cutPrimal) {
                        diffCutSupport = cc;
                        diffCutSupport.primalCost = diffCutSupport.primalCost + cc1.primalCost;
                    }
                    if (cc.cutAdj || this.tangentDiff) continue;
                    diffCutSupport = cc;
                    diffCutSupport.adjTimes = diffCutSupport.adjTimes + cc1.adjTimes;
                }
                break;
            }
            case 4: 
            case 9: 
            case 75: 
            case 96: 
            case 151: {
                cc.primalCost = cc.cutPrimal ? 1 : ExpressionDifferentiator.getCost(tree);
                cc.adjTimes = this.tangentDiff || !cc.isActive ? 0 : 1;
                break;
            }
            case 5: 
            case 6: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 28: 
            case 43: 
            case 55: 
            case 68: 
            case 92: 
            case 95: 
            case 102: 
            case 103: 
            case 115: 
            case 116: 
            case 122: 
            case 134: 
            case 137: 
            case 138: 
            case 139: 
            case 143: 
            case 160: 
            case 169: 
            case 176: 
            case 180: 
            case 181: 
            case 207: {
                cc.isActive = false;
                break;
            }
            default: {
                TapEnv.toolWarning(-1, "(Optimal cuts in reverse mode, bottom up) Unexpected operator: " + tree.opName());
                cc.isActive = false;
            }
        }
    }

    private void computeTopDownCosts(Tree tree, DiffCutSupport cc, TapList<ArrayDim> dimensions) {
        Object treeDims;
        if (cc.cutAdj) {
            cc.adjCost = 1;
        }
        if (dimensions != null) {
            treeDims = this.adEnv.curSymbolTable().typeOf(tree).getAllDimensions();
            if (TapList.length(dimensions) > TapList.length(treeDims)) {
                if (!cc.cutAdj) {
                    DiffCutSupport diffCutSupport = cc;
                    diffCutSupport.adjCost = diffCutSupport.adjCost + 10;
                }
                dimensions = treeDims;
            }
        }
        switch (tree.opCode()) {
            case 3: 
            case 42: 
            case 126: 
            case 182: {
                DiffCutSupport cc1 = this.getSetCutCosts(tree.down(1));
                DiffCutSupport cc2 = this.getSetCutCosts(tree.down(2));
                cc1.primalTimes = cc1.cutPrimal ? 1 : cc.primalTimes;
                cc2.primalTimes = cc2.cutPrimal ? 1 : cc.primalTimes;
                cc1.adjCost = cc.adjCost;
                cc2.adjCost = cc.adjCost;
                this.computeTopDownCosts(tree.down(1), cc1, dimensions);
                this.computeTopDownCosts(tree.down(2), cc2, dimensions);
                break;
            }
            case 99: {
                DiffCutSupport cc1 = this.getSetCutCosts(tree.down(2));
                DiffCutSupport cc2 = this.getSetCutCosts(tree.down(3));
                cc1.primalTimes = cc1.cutPrimal ? 1 : cc.primalTimes;
                cc2.primalTimes = cc2.cutPrimal ? 1 : cc.primalTimes;
                cc1.adjCost = cc.adjCost;
                cc2.adjCost = cc.adjCost;
                this.computeTopDownCosts(tree.down(2), cc1, dimensions);
                this.computeTopDownCosts(tree.down(3), cc2, dimensions);
                break;
            }
            case 133: {
                DiffCutSupport cc1 = this.getSetCutCosts(tree.down(1));
                DiffCutSupport cc2 = this.getSetCutCosts(tree.down(2));
                cc1.primalTimes = cc1.cutPrimal ? 1 : cc.primalTimes + (this.tangentDiff && cc2.isActive ? this.replicas : 0) + cc2.adjTimes;
                cc2.primalTimes = cc2.cutPrimal ? 1 : cc.primalTimes + (this.tangentDiff && cc1.isActive ? this.replicas : 0) + cc1.adjTimes;
                cc1.adjCost = cc.adjCost + cc2.primalCost + 4;
                cc2.adjCost = cc.adjCost + cc1.primalCost + 4;
                this.computeTopDownCosts(tree.down(1), cc1, dimensions);
                this.computeTopDownCosts(tree.down(2), cc2, dimensions);
                break;
            }
            case 62: {
                DiffCutSupport cc1 = this.getSetCutCosts(tree.down(1));
                DiffCutSupport cc2 = this.getSetCutCosts(tree.down(2));
                cc.primalTimes = cc.cutPrimal ? 1 : cc.primalTimes + (this.tangentDiff && cc2.isActive ? this.replicas : 0) + cc2.adjTimes;
                treeDims = cc;
                ((DiffCutSupport)treeDims).adjCost = ((DiffCutSupport)treeDims).adjCost + (cc.cutAdj ? 0 : cc2.primalCost + 6);
                cc1.primalTimes = cc1.cutPrimal ? 1 : cc.primalTimes;
                cc2.primalTimes = cc2.cutPrimal ? 1 : cc.primalTimes + (this.tangentDiff && cc1.isActive ? this.replicas : 0) + cc.adjTimes;
                cc1.adjCost = cc.adjCost;
                cc2.adjCost = cc.adjCost + cc.primalCost + 8;
                this.computeTopDownCosts(tree.down(1), cc1, dimensions);
                this.computeTopDownCosts(tree.down(2), cc2, dimensions);
                break;
            }
            case 155: {
                boolean needsProtectionB;
                DiffCutSupport cc1 = this.getSetCutCosts(tree.down(1));
                DiffCutSupport cc2 = this.getSetCutCosts(tree.down(2));
                cc.primalTimes = cc.cutPrimal ? 1 : cc.primalTimes + (this.tangentDiff && cc2.isActive ? this.replicas : 0) + cc2.adjTimes;
                boolean isComplex = this.adEnv.curSymbolTable().typeOf(tree).isComplexBase();
                boolean needsProtectionA = !isComplex && cc1.isActive && !ILUtils.isExpressionNumConstant(tree.down(2));
                boolean bl = needsProtectionB = !isComplex && cc2.isActive && !ILUtils.evalsToGTZero(tree.down(1));
                cc1.primalTimes = cc1.cutPrimal ? 1 : cc.primalTimes + cc1.adjTimes + cc2.adjTimes + (this.tangentDiff && cc2.isActive ? this.replicas : 0) + (this.tangentDiff && cc1.isActive ? this.replicas : 0) + (needsProtectionA ? 1 : 0) + (needsProtectionB ? 1 : 0);
                cc2.primalTimes = cc2.cutPrimal ? 1 : cc.primalTimes + 2 * cc1.adjTimes + (this.tangentDiff && cc1.isActive ? this.replicas : 0) + (needsProtectionA ? 2 : 0);
                cc1.adjCost = cc.adjCost + cc1.primalCost + 2 * cc2.primalCost + cc.dCostDiff1;
                cc2.adjCost = cc.adjCost + cc1.primalCost + cc.primalCost + cc.dCostDiff2;
                this.computeTopDownCosts(tree.down(1), cc1, dimensions);
                this.computeTopDownCosts(tree.down(2), cc2, dimensions);
                break;
            }
            case 124: {
                DiffCutSupport cc1 = this.getSetCutCosts(tree.down(1));
                cc1.primalTimes = cc1.cutPrimal ? 1 : cc.primalTimes;
                cc1.adjCost = cc.adjCost;
                this.computeTopDownCosts(tree.down(1), cc1, dimensions);
                break;
            }
            case 32: 
            case 194: {
                DiffCutSupport cc1 = this.getSetCutCosts(tree.down(2));
                cc1.primalTimes = cc1.cutPrimal ? 1 : cc.primalTimes;
                cc1.adjCost = cc.adjCost;
                this.computeTopDownCosts(tree.down(2), cc1, dimensions);
                break;
            }
            case 31: {
                TapList<DiffCutSupport> inCostArgs;
                DiffCutSupport costArg;
                Tree intrinsicName = ILUtils.getCalledName(tree);
                TapList<DiffCutSupport> argCosts = null;
                Tree[] args = ILUtils.getArguments(tree).children();
                for (int i = args.length - 1; i >= 0; --i) {
                    argCosts = new TapList<DiffCutSupport>(this.getSetCutCosts(args[i]), argCosts);
                }
                if (ILUtils.isIdentOf(intrinsicName, new String[]{"sqrt", "dsqrt", "csqrt"}, false)) {
                    costArg = (DiffCutSupport)argCosts.head;
                    DiffCutSupport i = cc;
                    i.primalTimes = i.primalTimes + (costArg.adjTimes + (this.tangentDiff && costArg.isActive ? this.replicas : 0));
                    costArg.primalTimes = costArg.cutPrimal ? 1 : cc.primalTimes;
                    costArg.adjCost = cc.adjCost + cc.primalCost + 6;
                } else if (this.adEnv.curUnit().isFortran9x() && ILUtils.isIdentOf(intrinsicName, new String[]{"sum", "spread"}, false) || (this.adEnv.curUnit().isFortran() ? ILUtils.isIdentOf(intrinsicName, new String[]{"sngl", "dble", "real", "dreal", "aimag", "dimag", "cmplx", "dcmplx", "complex"}, false) : ILUtils.isIdentOf(intrinsicName, new String[]{"creal", "cimag"}, true))) {
                    inCostArgs = argCosts;
                    while (inCostArgs != null) {
                        costArg.primalTimes = (costArg = (DiffCutSupport)inCostArgs.head).cutPrimal ? 1 : cc.primalTimes;
                        costArg.adjCost = cc.adjCost + 1;
                        inCostArgs = inCostArgs.tail;
                    }
                } else {
                    inCostArgs = argCosts;
                    int argTimes = 0;
                    int argCostDiff = 20;
                    while (inCostArgs != null) {
                        costArg = (DiffCutSupport)inCostArgs.head;
                        argTimes += costArg.adjTimes;
                        argCostDiff += costArg.primalCost;
                        inCostArgs = inCostArgs.tail;
                    }
                    inCostArgs = argCosts;
                    while (inCostArgs != null) {
                        costArg.primalTimes = (costArg = (DiffCutSupport)inCostArgs.head).cutPrimal ? 1 : cc.primalTimes + (this.tangentDiff && costArg.isActive ? this.replicas : 0) + argTimes;
                        costArg.adjCost = cc.adjCost + argCostDiff;
                        inCostArgs = inCostArgs.tail;
                    }
                }
                for (Tree arg : args) {
                    this.computeTopDownCosts(arg, (DiffCutSupport)argCosts.head, this.adEnv.curSymbolTable().typeOf(arg).getAllDimensions());
                    argCosts = argCosts.tail;
                }
                break;
            }
            case 10: 
            case 47: 
            case 110: {
                Tree[] args = tree.opCode() == 110 ? tree.down(1).children() : (tree.opCode() == 47 ? tree.down(3).children() : tree.children());
                TapList<DiffCutSupport> argCosts = null;
                for (int i = args.length - 1; i >= 0; --i) {
                    argCosts = new TapList<DiffCutSupport>(this.getSetCutCosts(args[i]), argCosts);
                }
                TapList<DiffCutSupport> inCostArgs = argCosts;
                while (inCostArgs != null) {
                    DiffCutSupport costArg;
                    costArg.primalTimes = (costArg = (DiffCutSupport)inCostArgs.head).cutPrimal ? 1 : cc.primalTimes;
                    costArg.adjCost = cc.adjCost;
                    inCostArgs = inCostArgs.tail;
                }
                for (Tree arg : args) {
                    this.computeTopDownCosts(arg, (DiffCutSupport)argCosts.head, null);
                    argCosts = argCosts.tail;
                }
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 28: 
            case 43: 
            case 55: 
            case 68: 
            case 75: 
            case 92: 
            case 95: 
            case 96: 
            case 102: 
            case 103: 
            case 115: 
            case 116: 
            case 122: 
            case 134: 
            case 137: 
            case 138: 
            case 139: 
            case 143: 
            case 151: 
            case 160: 
            case 169: 
            case 176: 
            case 180: 
            case 181: 
            case 207: {
                break;
            }
            default: {
                TapEnv.toolWarning(-1, "(Optimal cuts in reverse mode, top down) Unexpected operator: " + tree.opName());
            }
        }
    }

    private TapList<Tree> mostProfitableCut(Tree tree, TapList<Tree> curPath, TapList<Tree> bestPath) {
        DiffCutSupport cutCosts = ExpressionDifferentiator.getCutCosts(tree);
        if (cutCosts != null) {
            curPath = new TapList<Tree>(tree, curPath);
            int curCutProfit = cutCosts.bestCutProfit();
            if (this.adEnv.traceCurBlock == 2) {
                TapEnv.printlnOnTrace("CUTPROFIT FOR " + tree + " PRIMAL:" + cutCosts.primalTimes + "*" + cutCosts.primalCost + " ADJ:" + cutCosts.adjTimes + "*" + cutCosts.adjCost + " ===> " + curCutProfit);
            }
            if (curCutProfit > 0 && (bestPath == null || curCutProfit > ExpressionDifferentiator.getCutCosts((Tree)bestPath.head).bestCutProfit())) {
                bestPath = curPath;
            }
        }
        if (!tree.isAtom()) {
            Tree[] subTrees = tree.children();
            for (int i = subTrees.length - 1; i >= 0; --i) {
                bestPath = this.mostProfitableCut(subTrees[i], curPath, bestPath);
            }
        }
        return bestPath;
    }

    protected static int getCost(Tree expression) {
        switch (expression.opCode()) {
            case 14: {
                return ExpressionDifferentiator.getCost(expression.down(1)) + 1 + ExpressionDifferentiator.getCost(expression.down(2));
            }
            case 3: 
            case 116: 
            case 169: {
                int cost1 = ExpressionDifferentiator.getCost(expression.down(1));
                int cost2 = ExpressionDifferentiator.getCost(expression.down(2));
                return cost1 == 0 && cost2 == 0 ? 0 : cost1 + cost2 + 1;
            }
            case 182: {
                int cost1 = ExpressionDifferentiator.getCost(expression.down(1));
                int cost2 = ExpressionDifferentiator.getCost(expression.down(2));
                return cost1 == 0 && cost2 == 0 ? 0 : cost1 + cost2 + 1;
            }
            case 43: 
            case 126: 
            case 133: {
                int cost1 = ExpressionDifferentiator.getCost(expression.down(1));
                int cost2 = ExpressionDifferentiator.getCost(expression.down(2));
                return cost1 == 0 && cost2 == 0 ? 0 : cost1 + cost2 + 4;
            }
            case 62: {
                int cost1 = ExpressionDifferentiator.getCost(expression.down(1));
                int cost2 = ExpressionDifferentiator.getCost(expression.down(2));
                return cost1 == 0 && cost2 == 0 ? 0 : cost1 + cost2 + 6;
            }
            case 124: 
            case 176: {
                int cost1 = ExpressionDifferentiator.getCost(expression.down(1));
                return cost1 == 0 ? 0 : cost1 + 1;
            }
            case 155: {
                int intPowerCost = 15;
                if (ILUtils.isExpressionIntConstant(expression.down(2))) {
                    intPowerCost = ILUtils.intConstantValue(expression.down(2));
                    intPowerCost = intPowerCost <= 0 ? -intPowerCost + 1 : --intPowerCost;
                }
                if (intPowerCost * 4 <= 15) {
                    return ExpressionDifferentiator.getCost(expression.down(1)) + intPowerCost * 4;
                }
                return ExpressionDifferentiator.getCost(expression.down(1)) + 15 + ExpressionDifferentiator.getCost(expression.down(2));
            }
            case 31: {
                int paramsCost = 0;
                Tree[] params = ILUtils.getArguments(expression).children();
                for (int i = params.length - 1; i >= 0; --i) {
                    paramsCost += ExpressionDifferentiator.getCost(params[i]);
                }
                return paramsCost + 20;
            }
            case 99: {
                return ExpressionDifferentiator.getCost(expression.down(2)) + ExpressionDifferentiator.getCost(expression.down(3)) + 6;
            }
            case 5: 
            case 52: {
                return 2000;
            }
            case 4: 
            case 75: {
                return ExpressionDifferentiator.getCost(expression.down(1));
            }
            case 32: {
                return ExpressionDifferentiator.getCost(expression.down(2));
            }
            case 96: {
                return 1;
            }
            case 12: {
                return ExpressionDifferentiator.getCost(expression.down(1)) + ExpressionDifferentiator.getCost(expression.down(2));
            }
            case 151: {
                return ExpressionDifferentiator.getCost(expression.down(1)) + 1 + ExpressionDifferentiator.getCost(expression.down(2));
            }
            case 9: 
            case 10: 
            case 110: {
                Tree[] subTrees;
                int finalCost = 0;
                if (expression.opCode() == 110) {
                    subTrees = expression.down(1).children();
                } else if (expression.opCode() == 9) {
                    subTrees = expression.down(2).children();
                    finalCost = ExpressionDifferentiator.getCost(expression.down(1)) + subTrees.length;
                } else {
                    subTrees = expression.children();
                }
                for (int i = subTrees.length - 1; i >= 0; --i) {
                    finalCost += ExpressionDifferentiator.getCost(subTrees[i]);
                }
                return finalCost;
            }
            case 20: 
            case 28: 
            case 103: 
            case 160: 
            case 180: {
                return 0;
            }
            case 29: 
            case 35: 
            case 41: 
            case 78: 
            case 104: 
            case 111: 
            case 134: 
            case 138: {
                return 0;
            }
        }
        TapEnv.toolWarning(-1, "(Get cost of expression) Unexpected operator: " + expression.opName());
        return 0;
    }

    private DiffCutSupport getSetCutCosts(Tree tree) {
        DiffCutSupport cutCosts = (DiffCutSupport)tree.getAnnotation("CutCosts");
        if (cutCosts == null) {
            cutCosts = new DiffCutSupport(tree);
            WrapperTypeSpec treeType = this.adEnv.curSymbolTable().typeOf(tree);
            cutCosts.nbDimensions = treeType == null ? 0 : TapList.length(((TypeSpec)treeType).getAllDimensions());
            tree.setAnnotation("CutCosts", cutCosts);
        }
        return cutCosts;
    }

    private static DiffCutSupport getCutCosts(Tree tree) {
        return (DiffCutSupport)tree.getAnnotation("CutCosts");
    }

    public static String cutCostsString(Tree tree) {
        DiffCutSupport diffCutSupport = ExpressionDifferentiator.getCutCosts(tree);
        return diffCutSupport == null ? "" : diffCutSupport.toString();
    }

    private Tree mulProtectedTypedExprs(Tree expr1, Tree expr2, boolean mayConjugate) {
        TypeSpec productType;
        TypeSpec type2;
        TypeSpec type1 = expr1 == null ? null : (TypeSpec)expr1.getRemoveAnnotation("ExprType");
        TypeSpec typeSpec = type2 = expr2 == null ? null : (TypeSpec)expr2.getRemoveAnnotation("ExprType");
        if (mayConjugate && type1 != null && type1.isComplexBase()) {
            expr1 = this.conjugateProtectedExpr(expr1);
        }
        Tree productTree = ILUtils.mulProtectedExprs(expr1, type1, expr2, type2);
        TypeSpec typeSpec2 = type1 == null ? type2 : (productType = type2 == null ? type1 : this.adEnv.curSymbolTable().combineNumeric(type1, type2, productTree));
        if (productTree != null) {
            productTree.setAnnotation("ExprType", productType);
        }
        return productTree;
    }

    private Tree conjugateProtectedExpr(Tree expr) {
        String conjugationName;
        String string = conjugationName = this.adEnv.curUnit().isFortran() ? "conjg" : "conj";
        if (ILUtils.isIfExpression(expr)) {
            Tree case2;
            Tree case1 = expr.cutChild(2);
            if (!ILUtils.isNullOrNone(case1)) {
                case1 = ILUtils.buildCall(ILUtils.build(96, conjugationName), ILUtils.build(71, case1));
            }
            if (!ILUtils.isNullOrNone(case2 = expr.cutChild(3))) {
                case2 = ILUtils.buildCall(ILUtils.build(96, conjugationName), ILUtils.build(71, case2));
            }
            return ILUtils.build(99, expr.cutChild(1), case1, case2);
        }
        return ILUtils.buildCall(ILUtils.build(96, conjugationName), ILUtils.build(71, expr));
    }

    private void markAsVector(Tree expr, boolean value) {
        expr.setAnnotation("MarkedAsVector", value ? Boolean.TRUE : Boolean.FALSE);
    }

    private void markAsVectorInside(Tree expr) {
        this.markAsVector(expr, this.checkIsArrayExpression(expr));
        if (expr.opCode() == 133 || expr.opCode() == 62) {
            this.markAsVectorInside(expr.down(1));
            this.markAsVectorInside(expr.down(2));
        } else if (expr.opCode() == 124 || expr.opCode() == 155 && expr.down(2).opCode() == 103) {
            this.markAsVectorInside(expr.down(1));
        }
    }

    private boolean removeAllMarksAsVector(Tree expr) {
        if (ILUtils.isNullOrNone(expr)) {
            return false;
        }
        Boolean mark = (Boolean)expr.getAnnotation("MarkedAsVector");
        if (mark != null) {
            expr.removeAnnotation("MarkedAsVector");
            return mark == Boolean.TRUE;
        }
        if (expr.opCode() == 133) {
            boolean res1 = this.removeAllMarksAsVector(expr.down(1));
            boolean res2 = this.removeAllMarksAsVector(expr.down(2));
            return res1 || res2;
        }
        return false;
    }

    private void linearize(Tree expression, LinTree parent, int locInParent, TapList<ArrayDim> dimensions, InstructionMask iMask, TapList<LinAssign> toLinTrees, TapList<NewBlockGraphNode> toPrecomputes, SymbolTable diffSymbolTable) {
        DiffCutSupport cutHere;
        Tree deriv;
        WrapperTypeSpec exprTypeSpec = this.adEnv.curSymbolTable().typeOf(expression);
        if (dimensions != null && exprTypeSpec.isScalar()) {
            parent = parent.addLinSpread(dimensions, null, null, locInParent);
            locInParent = -1;
            dimensions = null;
            iMask = null;
        }
        if (expression.opCode() == 62) {
            deriv = ILUtils.divProtectedExprs(this.buildConstantOne(expression, this.adEnv.curSymbolTable()), this.cutPrimalIfRequired(expression.down(2), toPrecomputes, iMask, diffSymbolTable));
            parent = parent.addLinStd(deriv, this.adEnv.curSymbolTable().typeOf(expression.down(2)), locInParent);
            locInParent = -1;
        }
        if ((cutHere = ExpressionDifferentiator.getCutCosts(expression)) != null && (cutHere.cutAdj || this.tangentDiff && !(parent instanceof LinAssign) && expression.opCode() == 155 && this.powerNeedsProtection(expression))) {
            Tree[] diffTmpVarR;
            Tree tmpVar;
            if (this.adEnv.traceCurBlock == 2) {
                TapEnv.printlnOnTrace("SPLITTING ADJOINT OF: " + ILUtils.toString(expression));
            }
            if ((tmpVar = cutHere.tmpVar) == null) {
                NewSymbolHolder tmpVarHolder = cutHere.tmpVarHolder;
                if (tmpVarHolder == null) {
                    String name = TapEnv.disambigNewName("temp");
                    tmpVarHolder = diffSymbolTable.reuseNewSymbolHolder(name, exprTypeSpec = exprTypeSpec.checkNoneDimensionsOfNewSH(name, name, expression, diffSymbolTable, tmpVarHolder), this.blockDifferentiator().inUseNewSymbolHolders);
                    if (tmpVarHolder == null) {
                        tmpVarHolder = new NewSymbolHolder(name);
                        tmpVarHolder.setHintArrayTreeForCallSize(expression);
                        tmpVarHolder.setAsVariable(exprTypeSpec, null);
                        tmpVarHolder.zone = this.adEnv.allocateTmpZone();
                        this.adEnv.toActiveTmpZones.tail = new TapIntList(tmpVarHolder.zone, this.adEnv.toActiveTmpZones.tail);
                    }
                    cutHere.tmpVarHolder = tmpVarHolder;
                    if (TapEnv.doOpenMP() && this.adEnv.curBlock.parallelControls != null) {
                        tmpVarHolder.preparePrivateClause(this.adEnv.curBlock, this.adEnv.curUnit().privateSymbolTable(), false, true);
                    }
                    this.blockDifferentiator().addInUseNewSymbolHolder(tmpVarHolder);
                }
                if (this.adEnv.traceCurBlock == 2) {
                    TapEnv.printlnOnTrace("     FINALLY USING NSH " + tmpVarHolder + " TO HOLD DIFF " + toLinTrees.head);
                }
                tmpVar = tmpVarHolder.makeNewRef(diffSymbolTable);
                ADActivityAnalyzer.setAnnotatedActive(this.adEnv.curActivity(), tmpVar);
                cutHere.tmpVar = tmpVar;
            }
            if ((diffTmpVarR = cutHere.tmpAdjVarR) == null) {
                diffTmpVarR = new Tree[this.replicas];
                this.adEnv.iReplic = 0;
                while (this.adEnv.iReplic < this.replicas) {
                    boolean withAA = TapEnv.associationByAddress();
                    if (withAA) {
                        TapEnv.setAssociationByAddress(false);
                    }
                    diffTmpVarR[this.adEnv.iReplic] = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), tmpVar, diffSymbolTable, false, tmpVar, false, true, tmpVar);
                    NewSymbolHolder diffTmpSymbolHolder = NewSymbolHolder.getNewSymbolHolder(diffTmpVarR[this.adEnv.iReplic]);
                    if (withAA) {
                        diffTmpSymbolHolder.newVariableDecl.setType(((DiffCutSupport)cutHere).tmpVarHolder.newVariableDecl.type());
                        TapEnv.setAssociationByAddress(true);
                    }
                    ++this.adEnv.iReplic;
                }
                this.adEnv.iReplic = 0;
                DiffCutSupport.access$3202(cutHere, diffTmpVarR);
            }
            LinLeaf linUseSplit = parent.addLinLeaf(tmpVar, diffTmpVarR, iMask, false, locInParent);
            LinLeaf linLhs = new LinLeaf(tmpVar, diffTmpVarR, iMask, false, null, -1);
            LinAssign linAssign = new LinAssign(linLhs, null, exprTypeSpec, exprTypeSpec.isArray(), null, -1);
            linUseSplit.correspondingAssign = linAssign;
            toLinTrees = toLinTrees.placdl(linAssign);
            parent = linAssign;
            locInParent = -1;
            if (this.adEnv.traceCurBlock == 2) {
                TapEnv.printlnOnTrace("   -- RESUME BUILDING PARTIALS FROM NEW PARTIALS TREENODE: " + parent);
            }
        }
        switch (expression.opCode()) {
            case 31: {
                Tree mainExpr;
                Tree[] srcParamExprs;
                String calledName = ILUtils.getCalledNameString(expression);
                Unit calledUnit = DataFlowAnalyzer.getCalledUnit(expression, this.adEnv.curSymbolTable());
                AtomFuncDerivative funcDerivative = (AtomFuncDerivative)calledUnit.diffInfo;
                if (calledName.equals("spread") && this.adEnv.curUnit().isFortran()) {
                    srcParamExprs = ILUtils.getArguments(expression).children();
                    mainExpr = srcParamExprs[0];
                    if (!this.activeExpr(mainExpr)) break;
                    TapList<ArrayDim> argDimensions = this.adEnv.curSymbolTable().typeOf(mainExpr).getAllDimensions();
                    InstructionMask argMask = new InstructionMask(null, null);
                    if (this.adEnv.traceCurBlock == 2) {
                        TapEnv.printlnOnTrace("  GOING THROUGH SPREAD. ARG DIMS: " + argDimensions);
                    }
                    Tree splitVar = this.cutPrimalIfRequired(mainExpr, toPrecomputes, iMask, diffSymbolTable);
                    this.linearize(mainExpr, parent.addLinSpread(dimensions, srcParamExprs[1], srcParamExprs[2], locInParent), -1, argDimensions, argMask, toLinTrees, toPrecomputes, diffSymbolTable);
                    break;
                }
                if (calledName.equals("sum") && this.adEnv.curUnit().isFortran()) {
                    srcParamExprs = ILUtils.getArguments(expression).children();
                    mainExpr = srcParamExprs[0];
                    if (!this.activeExpr(mainExpr)) break;
                    TapList<ArrayDim> argDimensions = this.adEnv.curSymbolTable().typeOf(mainExpr).getAllDimensions();
                    Tree dim = ILUtils.getOptionalDim(srcParamExprs, this.adEnv.curSymbolTable());
                    Tree tMask = ILUtils.getOptionalMask(srcParamExprs, this.adEnv.curSymbolTable());
                    InstructionMask argMask = new InstructionMask(tMask, null);
                    if (this.adEnv.traceCurBlock == 2) {
                        TapEnv.printlnOnTrace("  GOING THROUGH SUM. ARG DIMS: " + argDimensions + " MASK: " + argMask);
                    }
                    Tree splitVar = this.cutPrimalIfRequired(mainExpr, toPrecomputes, iMask, diffSymbolTable);
                    this.linearize(mainExpr, parent.addLinReduce(argDimensions, dim, tMask, argMask, locInParent), -1, argDimensions, argMask, toLinTrees, toPrecomputes, diffSymbolTable);
                    break;
                }
                if (this.adEnv.curUnit().isFortran() && ILUtils.isIdentOf(ILUtils.getCalledName(expression), new String[]{"cmplx", "dcmplx", "complex"}, false)) {
                    Tree splitVar;
                    Tree argTree2;
                    Tree args = ILUtils.getArguments(expression);
                    Tree argTree1 = args.down(1);
                    Tree tree = argTree2 = args.length() == 1 ? null : args.down(2);
                    if (argTree2 != null && argTree2.opCode() == 134) {
                        argTree2 = null;
                    }
                    if (!this.activeExpr(argTree1) && !this.activeExpr(argTree2)) break;
                    parent = parent.addLinConvert(expression, locInParent);
                    if (this.activeExpr(argTree1)) {
                        splitVar = this.cutPrimalIfRequired(argTree1, toPrecomputes, iMask, diffSymbolTable);
                        this.linearize(argTree1, parent, 1, dimensions, iMask, toLinTrees, toPrecomputes, diffSymbolTable);
                    }
                    if (argTree2 == null || !this.activeExpr(argTree2)) break;
                    splitVar = this.cutPrimalIfRequired(argTree2, toPrecomputes, iMask, diffSymbolTable);
                    this.linearize(argTree2, parent, 2, dimensions, iMask, toLinTrees, toPrecomputes, diffSymbolTable);
                    break;
                }
                if (this.adEnv.curUnit().isFortran() ? ILUtils.isIdentOf(ILUtils.getCalledName(expression), new String[]{"sngl", "dble", "real", "dreal", "aimag", "dimag", "conjg", "dconjg"}, false) : ILUtils.isIdentOf(ILUtils.getCalledName(expression), new String[]{"creal", "cimag", "conj"}, true)) {
                    Tree argTree = ILUtils.getArguments(expression).down(1);
                    if (!this.activeExpr(argTree)) break;
                    Tree splitVar = this.cutPrimalIfRequired(argTree, toPrecomputes, iMask, diffSymbolTable);
                    this.linearize(argTree, parent.addLinConvert(expression, locInParent), 1, dimensions, iMask, toLinTrees, toPrecomputes, diffSymbolTable);
                    break;
                }
                if (funcDerivative == null) {
                    TapEnv.fileWarning(15, expression, "No derivatives defined for intrinsic function " + calledName);
                    break;
                }
                funcDerivative.matches(expression);
                Tree[] paramExprs = funcDerivative.getParamExprs();
                TapList<TapPair<Tree, Tree>> origKeyTreeList = funcDerivative.origKeyTreeList;
                while (origKeyTreeList != null) {
                    Tree origArg = (Tree)((TapPair)origKeyTreeList.head).second;
                    if (origArg != null) {
                        origArg = this.cutPrimalIfRequired(origArg, toPrecomputes, iMask, diffSymbolTable);
                        ((TapPair)origKeyTreeList.head).second = origArg;
                    }
                    origKeyTreeList = origKeyTreeList.tail;
                }
                for (int i = 0; i < paramExprs.length; ++i) {
                    if (!this.activeExpr(paramExprs[i])) continue;
                    Tree argi = ILUtils.getArguments(expression).down(i + 1);
                    deriv = funcDerivative.buildPartialDerivative(i);
                    if (i == 0 && (calledName.equals("sqrt") || calledName.equals("dsqrt") || calledName.equals("csqrt"))) {
                        deriv = ExpressionDifferentiator.protectExpr(deriv, ILUtils.build(68, this.cutPrimalIfRequired(argi, toPrecomputes, iMask, diffSymbolTable), PrimitiveTypeSpec.buildRealConstantZero()));
                        if (TapEnv.valid() && this.adEnv.adDiffMode == 1) {
                            TapPair<Object, Object> refsRW = new TapPair<Object, Object>(null, null);
                            TapPair<Object, Object> diffRefsRW = new TapPair<Object, Object>(null, null);
                            ToObject<Tree> toArg = new ToObject<Tree>(argi);
                            Tree[] diffArgR = this.blockDifferentiator().tangentDiffExpr(toArg, null, refsRW, diffRefsRW);
                            Tree diffArg = diffArgR[0];
                            if (diffArg != null) {
                                String typeName = this.adEnv.curSymbolTable().typeOf(expression).buildTypeNameForProcName(new TapList<Object>(null, null), this.adEnv.curSymbolTable());
                                Tree validityTest = ILUtils.buildCall(ILUtils.build(96, "validity_domain_" + typeName), ILUtils.build(71, ILUtils.copy(toArg.obj()), diffArg));
                                this.blockDifferentiator().addFuturePlainNodeFwd(validityTest, this.adEnv.curInstruction().whereMask(), false, new TapList<Tree>(argi, (TapList)refsRW.first), null, (TapList)diffRefsRW.first, null, false, false, "Domain of validity test for sqrt", false);
                            }
                        }
                    } else if (i == 0 && (calledName.equals("asin") || calledName.equals("dasin") || calledName.equals("acos") || calledName.equals("dacos"))) {
                        deriv = ExpressionDifferentiator.protectExpr(deriv, ILUtils.build(143, ILUtils.build(68, this.cutPrimalIfRequired(argi, toPrecomputes, iMask, diffSymbolTable), ILUtils.build(160, "1.0")), ILUtils.build(68, this.cutPrimalIfRequired(argi, toPrecomputes, iMask, diffSymbolTable), ILUtils.build(160, "-1.0"))));
                    }
                    this.linearize(paramExprs[i], parent.addLinStd(deriv, this.adEnv.curSymbolTable().typeOf(argi), locInParent), -1, dimensions, iMask, toLinTrees, toPrecomputes, diffSymbolTable);
                }
                break;
            }
            case 9: 
            case 75: 
            case 96: 
            case 151: {
                Tree[] diffExpressionR = new Tree[this.replicas];
                if (this.activeExpr(expression)) {
                    this.adEnv.iReplic = 0;
                    while (this.adEnv.iReplic < this.replicas) {
                        diffExpressionR[this.adEnv.iReplic] = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), expression, diffSymbolTable, this.varRefDifferentiator().isCurFunctionName(ILUtils.baseName(expression)), expression, false, true, expression);
                        ++this.adEnv.iReplic;
                    }
                } else {
                    this.adEnv.iReplic = 0;
                    while (this.adEnv.iReplic < this.replicas) {
                        diffExpressionR[this.adEnv.iReplic] = this.adEnv.curSymbolTable().typeOf(expression).buildConstantZero();
                        ++this.adEnv.iReplic;
                    }
                }
                this.adEnv.iReplic = 0;
                parent = parent.addLinLeaf(expression, diffExpressionR, iMask, true, locInParent);
                break;
            }
            case 99: {
                if (!this.activeExpr(expression.down(2)) && !this.activeExpr(expression.down(3))) break;
                Tree testTree = this.cutPrimalIfRequired(expression.down(1), toPrecomputes, iMask, diffSymbolTable);
                parent = parent.addLinIf(testTree, locInParent);
                this.linearize(expression.down(2), parent, 1, dimensions, iMask, toLinTrees, toPrecomputes, diffSymbolTable);
                this.linearize(expression.down(3), parent, 2, dimensions, iMask, toLinTrees, toPrecomputes, diffSymbolTable);
                break;
            }
            case 10: 
            case 47: 
            case 110: {
                int i;
                if (expression.opCode() == 47) {
                    this.varRefDifferentiator().pushDiffContext(1);
                }
                Tree[] expressions = expression.opCode() == 110 ? expression.down(1).children() : (expression.opCode() == 47 ? expression.down(3).children() : expression.children());
                boolean goInside = false;
                for (i = expressions.length - 1; i >= 0 && !goInside; --i) {
                    goInside = this.activeExpr(expressions[i]);
                }
                if (goInside) {
                    parent = parent.addLinCatenate(expression, expressions, locInParent);
                    for (i = 0; i < expressions.length; ++i) {
                        this.linearize(expressions[i], parent, i, null, null, toLinTrees, toPrecomputes, diffSymbolTable);
                    }
                }
                if (expression.opCode() != 47) break;
                this.varRefDifferentiator().popDiffContext();
                break;
            }
            case 3: {
                if (this.activeExpr(expression.down(1))) {
                    this.linearize(expression.down(1), parent, locInParent, dimensions, iMask, toLinTrees, toPrecomputes, diffSymbolTable);
                }
                if (!this.activeExpr(expression.down(2))) break;
                this.linearize(expression.down(2), parent, locInParent, dimensions, iMask, toLinTrees, toPrecomputes, diffSymbolTable);
                break;
            }
            case 182: {
                if (this.activeExpr(expression.down(1))) {
                    this.linearize(expression.down(1), parent, locInParent, dimensions, iMask, toLinTrees, toPrecomputes, diffSymbolTable);
                }
                if (!this.activeExpr(expression.down(2))) break;
                deriv = ILUtils.minusProtectedExpr(this.buildConstantOne(expression, this.adEnv.curSymbolTable()));
                this.linearize(expression.down(2), parent.addLinStd(deriv, this.adEnv.integerTypeSpec, locInParent), -1, dimensions, iMask, toLinTrees, toPrecomputes, diffSymbolTable);
                break;
            }
            case 133: {
                if (this.activeExpr(expression.down(1))) {
                    deriv = this.cutPrimalIfRequired(expression.down(2), toPrecomputes, iMask, diffSymbolTable);
                    this.linearize(expression.down(1), parent.addLinStd(deriv, this.adEnv.curSymbolTable().typeOf(expression.down(2)), locInParent), -1, dimensions, iMask, toLinTrees, toPrecomputes, diffSymbolTable);
                }
                if (!this.activeExpr(expression.down(2))) break;
                deriv = this.cutPrimalIfRequired(expression.down(1), toPrecomputes, iMask, diffSymbolTable);
                this.linearize(expression.down(2), parent.addLinStd(deriv, this.adEnv.curSymbolTable().typeOf(expression.down(1)), locInParent), -1, dimensions, iMask, toLinTrees, toPrecomputes, diffSymbolTable);
                break;
            }
            case 62: {
                if (this.activeExpr(expression.down(1))) {
                    this.linearize(expression.down(1), parent, locInParent, dimensions, iMask, toLinTrees, toPrecomputes, diffSymbolTable);
                }
                if (!this.activeExpr(expression.down(2))) break;
                deriv = ILUtils.minusProtectedExpr(this.cutPrimalIfRequired(expression, toPrecomputes, iMask, diffSymbolTable));
                this.linearize(expression.down(2), parent.addLinStd(deriv, this.adEnv.curSymbolTable().typeOf(expression), locInParent), -1, dimensions, iMask, toLinTrees, toPrecomputes, diffSymbolTable);
                break;
            }
            case 126: {
                if (this.activeExpr(expression.down(1))) {
                    this.linearize(expression.down(1), parent, locInParent, dimensions, iMask, toLinTrees, toPrecomputes, diffSymbolTable);
                }
                if (!this.activeExpr(expression.down(2))) break;
                deriv = ILUtils.minusProtectedExpr(ILUtils.divProtectedExprs(this.cutPrimalIfRequired(expression.down(1), toPrecomputes, iMask, diffSymbolTable), this.cutPrimalIfRequired(expression.down(2), toPrecomputes, iMask, diffSymbolTable)));
                this.linearize(expression.down(2), parent.addLinStd(deriv, this.adEnv.curSymbolTable().typeOf(expression.down(1)), locInParent), -1, dimensions, iMask, toLinTrees, toPrecomputes, diffSymbolTable);
                break;
            }
            case 124: {
                if (!this.activeExpr(expression.down(1))) break;
                deriv = ILUtils.minusProtectedExpr(this.buildConstantOne(expression, this.adEnv.curSymbolTable()));
                this.linearize(expression.down(1), parent.addLinStd(deriv, this.adEnv.integerTypeSpec, locInParent), -1, dimensions, iMask, toLinTrees, toPrecomputes, diffSymbolTable);
                break;
            }
            case 32: 
            case 194: {
                if (!this.activeExpr(expression.down(2))) break;
                this.linearize(expression.down(2), parent.addLinConvert(expression, locInParent), 1, dimensions, iMask, toLinTrees, toPrecomputes, diffSymbolTable);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 28: 
            case 42: 
            case 43: 
            case 68: 
            case 92: 
            case 95: 
            case 103: 
            case 111: 
            case 115: 
            case 116: 
            case 122: 
            case 137: 
            case 139: 
            case 143: 
            case 160: 
            case 169: 
            case 176: 
            case 180: 
            case 181: 
            case 207: {
                break;
            }
            case 155: {
                Tree xTree = this.cutPrimalIfRequired(expression.down(1), toPrecomputes, iMask, diffSymbolTable);
                if (this.activeExpr(expression.down(1))) {
                    Tree diffPower = xTree;
                    if (ILUtils.isExpressionNumConstant(expression.down(2))) {
                        Tree newPower = ILUtils.addExpressionsNumConstants(expression.down(2), ILUtils.build(103, -1));
                        if (!ILUtils.evalsToOne(newPower)) {
                            diffPower = ILUtils.powerTree(diffPower, newPower);
                        }
                    } else {
                        Tree yTree = this.cutPrimalIfRequired(expression.down(2), toPrecomputes, iMask, diffSymbolTable);
                        diffPower = ILUtils.powerTree(diffPower, ILUtils.buildSmartAddSub(yTree, -1, ILUtils.build(103, 1)));
                        if (!this.adEnv.curSymbolTable().typeOf(expression).isComplexBase()) {
                            Tree intTree = this.adEnv.curUnit().isFortran() ? ILUtils.buildCall(ILUtils.build(96, "INT"), ILUtils.build(71, ILUtils.copy(yTree))) : ILUtils.build(32, ILUtils.build(96, "int"), ILUtils.copy(yTree));
                            Tree testExpInPower = ILUtils.build(6, ILUtils.build(115, ILUtils.copy(xTree), PrimitiveTypeSpec.buildRealConstantZero()), ILUtils.build(143, ILUtils.build(68, ILUtils.copy(yTree), PrimitiveTypeSpec.buildRealConstantZero()), ILUtils.build(137, ILUtils.copy(yTree), intTree)));
                            diffPower = ExpressionDifferentiator.protectExpr(diffPower, testExpInPower);
                        }
                    }
                    WrapperTypeSpec type1 = this.adEnv.curSymbolTable().typeOf(expression.down(2));
                    WrapperTypeSpec type2 = this.adEnv.curSymbolTable().typeOf(expression.down(1));
                    deriv = ILUtils.mulProtectedExprs(this.cutPrimalIfRequired(expression.down(2), toPrecomputes, iMask, diffSymbolTable), type1, diffPower, type2);
                    TypeSpec derivType = this.adEnv.curSymbolTable().combineNumeric(type1, type2, deriv);
                    this.linearize(expression.down(1), parent.addLinStd(deriv, derivType, locInParent), -1, dimensions, iMask, toLinTrees, toPrecomputes, diffSymbolTable);
                }
                if (!this.activeExpr(expression.down(2))) break;
                Tree inLogExp = ILUtils.copy(xTree);
                Tree testExpInLog = null;
                if (!ILUtils.evalsToGTZero(inLogExp) && !this.adEnv.curSymbolTable().typeOf(expression).isComplexBase()) {
                    testExpInLog = ILUtils.build(115, ILUtils.copy(inLogExp), PrimitiveTypeSpec.buildRealConstantZero());
                }
                Tree subDerivTree = ILUtils.buildCall(ILUtils.build(96, "log"), ILUtils.build(71, inLogExp));
                WrapperTypeSpec type1 = this.adEnv.curSymbolTable().typeOf(expression);
                WrapperTypeSpec type2 = this.adEnv.realTypeSpec;
                deriv = ILUtils.mulProtectedExprs(this.cutPrimalIfRequired(expression, toPrecomputes, iMask, diffSymbolTable), type1, testExpInLog == null ? subDerivTree : ExpressionDifferentiator.protectExpr(subDerivTree, testExpInLog), type2);
                TypeSpec derivType = this.adEnv.curSymbolTable().combineNumeric(type1, type2, deriv);
                this.linearize(expression.down(2), parent.addLinStd(deriv, derivType, locInParent), -1, dimensions, iMask, toLinTrees, toPrecomputes, diffSymbolTable);
                break;
            }
            default: {
                TapEnv.toolWarning(-1, "(Linearize expression) Unexpected operator: " + expression.opName() + " in " + ILUtils.toString(expression));
            }
        }
    }

    private boolean checkIsArrayExpression(Tree expr) {
        WrapperTypeSpec exprType = this.adEnv.curSymbolTable().typeOf(expr);
        return exprType != null && exprType.isArray();
    }

    private boolean powerNeedsProtection(Tree expression) {
        return (this.activeExpr(expression.down(1)) && !ILUtils.isExpressionNumConstant(expression.down(2)) || this.activeExpr(expression.down(2)) && !ILUtils.evalsToGTZero(expression.down(1))) && !this.adEnv.curSymbolTable().typeOf(expression).isComplexBase();
    }

    private boolean activeExpr(Tree expression) {
        DiffCutSupport cutHere = ExpressionDifferentiator.getCutCosts(expression);
        return cutHere != null && cutHere.isActive;
    }

    private Tree cutPrimalIfRequired(Tree expression, TapList<NewBlockGraphNode> toPrecomputes, InstructionMask exprMask, SymbolTable diffSymbolTable) {
        Tree copiedExp;
        Operator operator = expression.operator();
        if (!expression.isAtom()) {
            copiedExp = operator.tree();
            Tree[] subTrees = expression.children();
            for (int i = subTrees.length - 1; i >= 0; --i) {
                copiedExp.setChild(this.cutPrimalIfRequired(subTrees[i], toPrecomputes, exprMask, diffSymbolTable), i + 1);
            }
        } else {
            copiedExp = ILUtils.copy(expression);
            copiedExp.removeAnnotation("CutCosts");
        }
        NewSymbolHolder.copySymbolHolderAnnotation(expression, copiedExp, null);
        DiffCutSupport cutHere = ExpressionDifferentiator.getCutCosts(expression);
        if (cutHere != null && cutHere.cutPrimal) {
            if (this.adEnv.traceCurBlock == 2) {
                TapEnv.printlnOnTrace("SPLITTING PRIMAL: " + ILUtils.toString(expression));
            }
            if (!cutHere.tmpPrimalVarInitialized) {
                NewSymbolHolder tmpVarHolder;
                WrapperTypeSpec exprTypeSpec = this.adEnv.curSymbolTable().typeOf(expression);
                Tree tmpVar = cutHere.tmpVar;
                if (tmpVar == null) {
                    tmpVarHolder = cutHere.tmpVarHolder;
                    if (tmpVarHolder == null) {
                        String name = TapEnv.disambigNewName("temp");
                        tmpVarHolder = diffSymbolTable.reuseNewSymbolHolder(name, exprTypeSpec, this.blockDifferentiator().inUseNewSymbolHolders);
                        if (tmpVarHolder == null) {
                            tmpVarHolder = new NewSymbolHolder(name);
                            exprTypeSpec = exprTypeSpec.checkNoneDimensionsOfNewSH(name, name, expression, diffSymbolTable, tmpVarHolder);
                            tmpVarHolder.setAsVariable(exprTypeSpec, null);
                            tmpVarHolder.prepareDeclarationInstr(this.curDiffUnit());
                            if (this.adEnv.traceCurBlock == 2) {
                                TapEnv.printlnOnTrace("PREPARED DECL INSTR FOR " + tmpVarHolder + ":" + tmpVarHolder.instruction());
                            }
                            tmpVarHolder.zone = this.adEnv.allocateTmpZone();
                            this.adEnv.toActiveTmpZones.tail = new TapIntList(tmpVarHolder.zone, this.adEnv.toActiveTmpZones.tail);
                        }
                        cutHere.tmpVarHolder = tmpVarHolder;
                        if (TapEnv.doOpenMP() && this.adEnv.curBlock.parallelControls != null) {
                            tmpVarHolder.preparePrivateClause(this.adEnv.curBlock, this.adEnv.curUnit().privateSymbolTable(), this.tangentDiff, false);
                        }
                        this.blockDifferentiator().addInUseNewSymbolHolder(tmpVarHolder);
                    }
                } else {
                    tmpVarHolder = NewSymbolHolder.getNewSymbolHolder(tmpVar);
                }
                if (this.adEnv.traceCurBlock == 2) {
                    TapEnv.printlnOnTrace("     FINALLY USING NSH " + tmpVarHolder + " TO HOLD " + copiedExp);
                }
                tmpVarHolder.solvingLevelMustInclude(diffSymbolTable);
                tmpVarHolder.declarationLevelMustInclude(diffSymbolTable);
                tmpVar = tmpVarHolder.makeNewRef(diffSymbolTable);
                ADActivityAnalyzer.setAnnotatedActive(this.adEnv.curActivity(), tmpVar);
                cutHere.tmpVar = tmpVar;
                copiedExp = this.rebalanceExp(copiedExp, null, null, new ToBool(false), 0);
                if (TapEnv.associationByAddress()) {
                    copiedExp = this.blockDifferentiator().turnAssociationByAddressPrimal(copiedExp, this.adEnv.curSymbolTable(), this.adEnv.curFwdSymbolTable, null, true);
                }
                if (this.adEnv.traceCurBlock == 2) {
                    TapEnv.printlnOnTrace("   -- PRECOMPUTING " + ILUtils.toString(copiedExp) + " INTO " + tmpVar);
                }
                Tree setSplitVar = ILUtils.build(14, tmpVar, this.replacePrecomputedAndCustomize(copiedExp));
                NewBlockGraphNode futureNode = new NewBlockGraphNode(4, setSplitVar, false, this.adEnv.curInstruction(), exprTypeSpec.isScalar() ? null : exprMask);
                toPrecomputes.placdl(futureNode);
                cutHere.tmpPrimalVarInitialized = true;
            }
            copiedExp = ILUtils.copy(cutHere.tmpVar);
            this.markAsVector(copiedExp, this.checkIsArrayExpression(expression));
            if (this.adEnv.traceCurBlock == 2) {
                TapEnv.printlnOnTrace("   -- USING PRECOMPUTED SUB-PRIMAL " + copiedExp);
            }
        }
        return copiedExp;
    }

    private Tree buildConstantOne(Tree expression, SymbolTable origSymbolTable) {
        WrapperTypeSpec typeSpec = origSymbolTable.typeOf(expression);
        Tree oneCstTree = null;
        if (typeSpec != null && typeSpec.wrappedType != null) {
            oneCstTree = typeSpec.wrappedType.buildConstantOne();
        }
        if (oneCstTree == null) {
            oneCstTree = ILUtils.build(160, "1.0");
        }
        return oneCstTree;
    }

    private static Tree protectExpr(Tree factor, Tree test) {
        if (factor.opCode() != 99) {
            factor = ILUtils.build(99, ILUtils.build(138), null, factor);
        }
        if (test != null) {
            Tree curTest = factor.cutChild(1);
            curTest = curTest.opCode() == 138 ? test : ILUtils.build(143, test, curTest);
            factor.setChild(curTest, 1);
        }
        return factor;
    }

    private class LinAssign
    extends LinTree {
        LinLeaf linLhs;
        private TypeSpec assignedType;
        private boolean isArrayLhs;
        private TapList<LinTree> linRhs;
        private MaskTree assignmentMask;

        protected LinAssign(LinLeaf linLhs, TapList<LinTree> linRhs, TypeSpec assignedType, boolean isArrayLhs, LinTree parent, int locInParent) {
            super(parent, locInParent);
            this.assignedType = assignedType;
            this.isArrayLhs = isArrayLhs;
            this.linLhs = linLhs;
            this.linRhs = linRhs;
        }

        @Override
        protected LinTree addNewChild(LinTree newChild, int locInThisUnused) {
            this.linRhs = TapList.addLast(this.linRhs, newChild);
            return newChild;
        }

        @Override
        protected Tree buildTreeForward(TapPair<TapList<Tree>, TapList<Tree>> primRW, TapPair<TapList<Tree>, TapList<Tree>> diffRW) {
            TypeSpec rhsType;
            Tree result = this.buildTreeForwardOnChildrenNodes(this.linRhs, primRW, diffRW);
            TypeSpec typeSpec = rhsType = result == null ? null : (TypeSpec)result.getRemoveAnnotation("ExprType");
            if (this.linLhs != null) {
                TapList<Object> toNewDiffR = new TapList<Object>(null, null);
                primRW.first = ILUtils.usedVarsInDiffExp(this.linLhs.ref, (TapList)primRW.first, toNewDiffR, false);
                diffRW.first = ILUtils.addListTreeInList(toNewDiffR.tail, (TapList)diffRW.first);
                diffRW.second = ILUtils.addTreeInList(this.linLhs.ref, (TapList)diffRW.second);
                Tree diffRefCopy = this.linLhs.diffRefR == null ? null : ILUtils.copy(this.linLhs.diffRefR[((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.iReplic]);
                result = ILUtils.setToProtectedExpr(((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.curDiffUnit.language(), diffRefCopy, result, this.assignedType);
            }
            return result;
        }

        protected TapList<DiffAssignmentNode> buildTreesBackward() {
            TapList<Object> toNewDiffR = new TapList<Object>(null, null);
            TapList<Tree> primR = ILUtils.usedVarsInDiffExp(this.linLhs.ref, null, toNewDiffR, false);
            DiffAssignmentNode lhsDiffAssignNode = new DiffAssignmentNode(ILUtils.copy(this.linLhs.diffRefR[((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.iReplic]), this.linLhs.normal ? 3 : 2, null, ExpressionDifferentiator.this.adEnv.curInstruction().whereMask(), this.linLhs.ref, ((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.iReplic, primR, null, toNewDiffR.tail, new TapList<Tree>(this.linLhs.ref, null));
            if (((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.traceCurBlock == 2) {
                TapEnv.printlnOnTrace("       INITIALIZED ADJOINT NODE TO RESET DIFF LHS:" + lhsDiffAssignNode);
            }
            TapList<DiffAssignmentNode> toResult = new TapList<DiffAssignmentNode>(lhsDiffAssignNode, null);
            this.buildTreesBackwardOnChildrenNodes(this.linRhs, this.buildMaskOfAssign(), toResult, primR);
            if (!this.linLhs.normal) {
                toResult = toResult.tail;
            }
            return toResult;
        }

        private MaskTree buildMaskOfAssign() {
            if (this.assignmentMask == null) {
                TapList<ArrayDim> dimensions = ExpressionDifferentiator.this.adEnv.curSymbolTable().typeOf(this.linLhs.ref).getAllDimensions();
                int nbDims = TapList.length(dimensions);
                InstructionMask iMask = ExpressionDifferentiator.this.adEnv.curInstruction().whereMask();
                MaskTree maskTree = this.assignmentMask = nbDims == 0 || iMask == null ? null : new MaskLeaf(iMask, nbDims);
            }
            if (((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.traceCurBlock == 2) {
                TapEnv.printlnOnTrace("         -> Push mask " + this.assignmentMask + " inside " + this);
            }
            return this.assignmentMask;
        }

        @Override
        protected void buildTreesBackwardOnNode(MaskTree mask, TapList<DiffAssignmentNode> toResult, TapList<Tree> primR) {
        }

        @Override
        protected Tree buildTreeBackward(Tree adjPrefix, int locInThisUnused, boolean mayImplicitSpread) {
            Tree adjExpr;
            if (((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.traceCurBlock == 2) {
                TapEnv.printlnOnTrace("CALL BTB [" + ++this.levelBTB + "] ON " + this + " WITH PREFIX " + adjPrefix);
            }
            Tree diffLhs = ILUtils.copy(this.linLhs.diffRefR[((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.iReplic]);
            ExpressionDifferentiator.this.markAsVector(diffLhs, this.isArrayLhs);
            diffLhs.setAnnotation("ExprType", this.assignedType);
            Tree tree = adjExpr = adjPrefix == null ? diffLhs : ExpressionDifferentiator.this.mulProtectedTypedExprs(adjPrefix, diffLhs, true);
            if (((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.traceCurBlock == 2) {
                TapEnv.printlnOnTrace("EXIT BTB [" + this.levelBTB-- + "] ON " + this + " RETURN " + adjExpr);
            }
            return adjExpr;
        }

        @Override
        public String toString() {
            return "LinAssign:" + this.linLhs + " := " + this.toStringOnChildrenNodes(this.linRhs);
        }
    }

    private class LinSpread
    extends LinTree {
        private TapList<LinTree> exp;
        private Tree dim;
        private int dimValue;
        private Tree nCopies;
        private TapList<ArrayDim> allDimensions;
        private MaskTree spreadMask;

        protected LinSpread(TapList<ArrayDim> allDimensions, Tree dim, Tree nCopies, TapList<LinTree> exp, LinTree parent, int locInParent) {
            super(parent, locInParent);
            this.dimValue = -1;
            if (ILUtils.isNullOrNone(dim)) {
                dim = null;
            }
            this.dim = dim;
            if (dim != null) {
                Integer dimI = ExpressionDifferentiator.this.adEnv.curSymbolTable().computeIntConstant(dim);
                int n = this.dimValue = dimI == null ? -1 : dimI;
                if (!ExpressionDifferentiator.this.tangentDiff && this.dimValue == -1) {
                    TapEnv.fileWarning(-1, dim, "(Adjoint differentiation of SPREAD) unknown DIM rank: " + dim);
                }
            }
            this.allDimensions = allDimensions;
            this.nCopies = nCopies;
            this.exp = exp;
        }

        @Override
        protected LinTree addNewChild(LinTree newChild, int locInThisUnused) {
            this.exp = TapList.addLast(this.exp, newChild);
            return newChild;
        }

        @Override
        protected Tree buildTreeForward(TapPair<TapList<Tree>, TapList<Tree>> primRW, TapPair<TapList<Tree>, TapList<Tree>> diffRW) {
            TypeSpec diffSpreadCallType;
            Tree diffSpreadCall;
            Tree diffSpreadArg = this.buildTreeForwardOnChildrenNodes(this.exp, primRW, diffRW);
            TypeSpec diffSpreadArgType = diffSpreadArg == null ? null : (TypeSpec)diffSpreadArg.getRemoveAnnotation("ExprType");
            TapList<Tree> diffSpreadArgs = null;
            if (this.dim != null) {
                primRW.first = ILUtils.usedVarsInExp(this.nCopies, (TapList)primRW.first, true);
                diffSpreadArgs = new TapList<Tree>(ILUtils.copy(this.nCopies), diffSpreadArgs);
                primRW.first = ILUtils.usedVarsInExp(this.dim, (TapList)primRW.first, true);
                diffSpreadArgs = new TapList<Tree>(ILUtils.copy(this.dim), diffSpreadArgs);
                diffSpreadArgs = new TapList<Tree>(diffSpreadArg, diffSpreadArgs);
                diffSpreadCall = ILUtils.buildCall(ILUtils.build(96, "SPREAD"), ILUtils.build(71, diffSpreadArgs));
                diffSpreadCall = ILUtils.pullProtectedArg(diffSpreadCall, 1);
                if (diffSpreadArgType != null && diffSpreadArgType.isArray()) {
                    diffSpreadArgType = diffSpreadArgType.elementType();
                }
                diffSpreadCallType = new WrapperTypeSpec(new ArrayTypeSpec((WrapperTypeSpec)diffSpreadArgType, ArrayTypeSpec.createDimensions(this.allDimensions)));
            } else {
                diffSpreadCall = diffSpreadArg;
                diffSpreadCallType = diffSpreadArgType;
            }
            diffSpreadCall.setAnnotation("ExprType", diffSpreadCallType);
            return diffSpreadCall;
        }

        @Override
        protected void buildTreesBackwardOnNode(MaskTree mask, TapList<DiffAssignmentNode> toResult, TapList<Tree> primR) {
            primR = ILUtils.usedVarsInExp(this.dim, primR, true);
            primR = ILUtils.usedVarsInExp(this.nCopies, primR, true);
            this.buildTreesBackwardOnChildrenNodes(this.exp, this.buildMaskOfSpreadArg(mask), toResult, primR);
        }

        private MaskTree buildMaskOfSpreadArg(MaskTree spreadResultMask) {
            this.spreadMask = spreadResultMask;
            MaskAny result = null;
            if (this.dim != null && spreadResultMask != null) {
                int dimVal = this.dimValue != -1 ? this.dimValue : spreadResultMask.nbDims;
                result = new MaskAny(spreadResultMask, dimVal, spreadResultMask.nbDims);
            }
            if (((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.traceCurBlock == 2) {
                TapEnv.printlnOnTrace("         -> push mask " + result + " inside " + this);
            }
            return result;
        }

        @Override
        protected Tree buildTreeBackward(Tree adjPrefix, int locInThisUnused, boolean mayImplicitSpread) {
            Tree adjExpr;
            TypeSpec diffSpreadArgType;
            Tree rebuiltMaskTree;
            if (((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.traceCurBlock == 2) {
                TapEnv.printlnOnTrace("CALL BTB [" + ++this.levelBTB + "] ON " + this + " WITH PREFIX " + adjPrefix);
            }
            Tree adjSuffix = this.parent.buildTreeBackward(null, this.locInParent, mayImplicitSpread);
            assert (adjSuffix != null);
            TypeSpec diffResultType = (TypeSpec)adjSuffix.getRemoveAnnotation("ExprType");
            ToObject<Object> takenOff = new ToObject<Object>(null);
            int nbDims = TapList.length(this.allDimensions);
            TapList<Tree> diffSumArgs = null;
            Tree tree = rebuiltMaskTree = this.spreadMask == null ? null : this.spreadMask.rebuildInstructionMaskTree();
            if (adjSuffix.opCode() == 99 && ILUtils.isNullOrNone(adjSuffix.down(2))) {
                Tree additionalMask = ILUtils.build(139, ILUtils.copy(adjSuffix.down(1)));
                adjSuffix = adjSuffix.down(3);
                Tree tree2 = rebuiltMaskTree = rebuiltMaskTree == null ? additionalMask : ILUtils.build(6, rebuiltMaskTree, additionalMask);
            }
            if (((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.traceCurBlock == 2) {
                TapEnv.printlnOnTrace("         <- rebuilt mask Tree " + rebuiltMaskTree + " from mask:" + this.spreadMask + " around ADJ SUM " + this);
            }
            if (rebuiltMaskTree != null) {
                diffSumArgs = new TapList<Tree>(ILUtils.build(134, ILUtils.build(96, "MASK"), rebuiltMaskTree), diffSumArgs);
            }
            if (!ILUtils.isNullOrNone(this.dim) && nbDims > 1) {
                diffSumArgs = new TapList<Tree>(ILUtils.build(134, ILUtils.build(96, "DIM"), ILUtils.copy(this.dim)), diffSumArgs);
            }
            adjSuffix = this.takeScalarsOff(adjSuffix, 1, takenOff);
            diffSumArgs = new TapList<Tree>(adjSuffix, diffSumArgs);
            adjSuffix = ILUtils.buildCall(ILUtils.build(96, "SUM"), ILUtils.build(71, diffSumArgs));
            adjSuffix = ILUtils.pullProtectedArg(adjSuffix, 1);
            ExpressionDifferentiator.this.markAsVector(adjSuffix, !ILUtils.isNullOrNone(this.dim) && nbDims > 1);
            if (takenOff.obj() != null) {
                adjSuffix = ILUtils.mulProtectedExprs(adjSuffix, null, takenOff.obj(), null);
            }
            if ((diffSpreadArgType = diffResultType) != null && diffSpreadArgType.isArray()) {
                diffSpreadArgType = diffSpreadArgType.elementType();
            }
            if (this.dim != null) {
                int dimVal = this.dimValue != -1 ? this.dimValue : nbDims;
                TapList<ArrayDim> allDimensionsButOne = TapList.deleteNth(this.allDimensions, nbDims - dimVal);
                diffSpreadArgType = new WrapperTypeSpec(new ArrayTypeSpec((WrapperTypeSpec)diffSpreadArgType, ArrayTypeSpec.createDimensions(allDimensionsButOne)));
            }
            adjSuffix.setAnnotation("ExprType", diffSpreadArgType);
            Tree tree3 = adjExpr = adjPrefix == null ? adjSuffix : ExpressionDifferentiator.this.mulProtectedTypedExprs(adjPrefix, adjSuffix, true);
            if (((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.traceCurBlock == 2) {
                TapEnv.printlnOnTrace("EXIT BTB [" + this.levelBTB-- + "] ON " + this + " RETURN " + adjExpr);
            }
            return adjExpr;
        }

        private Tree takeScalarsOff(Tree expression, int power, ToObject<Tree> takenOff) {
            Boolean isMarkedVector = (Boolean)expression.getAnnotation("MarkedAsVector");
            if (isMarkedVector == null) {
                if (expression.opCode() == 133) {
                    Tree new1 = this.takeScalarsOff(expression.down(1), power, takenOff);
                    Tree new2 = this.takeScalarsOff(expression.down(2), power, takenOff);
                    return new1 == null ? new2 : (new2 == null ? new1 : ILUtils.build(133, new1, new2));
                }
                if (expression.opCode() == 124) {
                    Tree new1 = this.takeScalarsOff(expression.down(1), power, takenOff);
                    takenOff.setObj(takenOff.obj() == null ? ILUtils.build(160, "-1.0") : ILUtils.build(124, takenOff.obj()));
                    return new1;
                }
                if (expression.opCode() == 62) {
                    Tree new1 = this.takeScalarsOff(expression.down(1), power, takenOff);
                    Tree new2 = this.takeScalarsOff(expression.down(2), -power, takenOff);
                    if (new1 == null) {
                        return ILUtils.build(62, ILUtils.build(160, "1.0"), new2);
                    }
                    if (new2 == null) {
                        return new1;
                    }
                    return ILUtils.build(62, new1, new2);
                }
                if (expression.opCode() == 155 && expression.down(2).opCode() == 103) {
                    int localPower = expression.down(2).intValue();
                    Tree new1 = this.takeScalarsOff(expression.down(1), power * localPower, takenOff);
                    return new1 == null ? null : ILUtils.build(155, new1, ILUtils.copy(expression.down(2)));
                }
                return expression;
            }
            if (isMarkedVector == Boolean.TRUE) {
                ExpressionDifferentiator.this.removeAllMarksAsVector(expression);
                return expression;
            }
            Tree scalarExpr = expression;
            boolean divide = false;
            if (power < 0) {
                divide = true;
                power = -power;
            }
            if (power > 1) {
                scalarExpr = ILUtils.build(155, scalarExpr, ILUtils.build(103, power));
            }
            if (divide && takenOff.obj() == null) {
                takenOff.setObj(ILUtils.build(160, "1.0"));
            }
            takenOff.setObj(takenOff.obj() == null ? scalarExpr : ILUtils.build(divide ? 62 : 133, takenOff.obj(), scalarExpr));
            return null;
        }

        @Override
        public String toString() {
            return "LinSpread:" + this.toStringOnChildrenNodes(this.exp);
        }
    }

    private class LinReduce
    extends LinTree {
        private TapList<LinTree> exp;
        private Tree dim;
        private int dimValue;
        private Tree tMask;
        private TapList<ArrayDim> allDimensions;
        private InstructionMask argMask;

        protected LinReduce(TapList<ArrayDim> allDimensions, Tree dim, Tree tMask, InstructionMask argMask, TapList<LinTree> exp, LinTree parent, int locInParent) {
            super(parent, locInParent);
            this.dimValue = -1;
            if (ILUtils.isNullOrNone(dim)) {
                dim = null;
            }
            this.dim = dim;
            if (dim != null) {
                Integer dimI = ExpressionDifferentiator.this.adEnv.curSymbolTable().computeIntConstant(dim);
                int n = this.dimValue = dimI == null ? -1 : dimI;
                if (!ExpressionDifferentiator.this.tangentDiff && this.dimValue == -1) {
                    TapEnv.fileWarning(-1, dim, "(Adjoint differentiation of SUM) statically unknown DIM rank: " + ILUtils.toString(dim));
                }
            }
            this.allDimensions = allDimensions;
            this.tMask = tMask;
            this.argMask = argMask;
            this.exp = exp;
        }

        @Override
        protected LinTree addNewChild(LinTree newChild, int locInThisUnused) {
            this.exp = TapList.addLast(this.exp, newChild);
            return newChild;
        }

        @Override
        protected Tree buildTreeForward(TapPair<TapList<Tree>, TapList<Tree>> primRW, TapPair<TapList<Tree>, TapList<Tree>> diffRW) {
            Tree diffReduceArg;
            TapList<Tree> diffSumArgs = null;
            if (this.tMask != null) {
                primRW.first = ILUtils.usedVarsInExp(this.tMask, (TapList)primRW.first, true);
                diffSumArgs = new TapList<Tree>(ILUtils.build(134, ILUtils.build(96, "MASK"), ILUtils.copy(this.tMask)), diffSumArgs);
            }
            if (this.dim != null) {
                primRW.first = ILUtils.usedVarsInExp(this.dim, (TapList)primRW.first, true);
                diffSumArgs = new TapList<Tree>(ILUtils.build(134, ILUtils.build(96, "DIM"), ILUtils.copy(this.dim)), diffSumArgs);
            }
            TypeSpec diffReduceArgType = (diffReduceArg = this.buildTreeForwardOnChildrenNodes(this.exp, primRW, diffRW)) == null ? null : (TypeSpec)diffReduceArg.getRemoveAnnotation("ExprType");
            diffSumArgs = new TapList<Tree>(diffReduceArg, diffSumArgs);
            WrapperTypeSpec diffReduceCallType = diffReduceArgType == null ? null : diffReduceArgType.elementType();
            int nbDims = TapList.length(this.allDimensions);
            if (!ILUtils.isNullOrNone(this.dim) && nbDims > 1) {
                int dimVal = this.dimValue != -1 ? this.dimValue : nbDims;
                TapList<ArrayDim> allDimensionsButOne = TapList.deleteNth(this.allDimensions, nbDims - dimVal);
                diffReduceCallType = new WrapperTypeSpec(new ArrayTypeSpec(diffReduceCallType, ArrayTypeSpec.createDimensions(allDimensionsButOne)));
            }
            Tree diffReduceCall = ILUtils.buildCall(ILUtils.build(96, "SUM"), ILUtils.build(71, diffSumArgs));
            diffReduceCall = ILUtils.pullProtectedArg(diffReduceCall, 1);
            diffReduceCall.setAnnotation("ExprType", diffReduceCallType);
            return diffReduceCall;
        }

        @Override
        protected void buildTreesBackwardOnNode(MaskTree mask, TapList<DiffAssignmentNode> toResult, TapList<Tree> primR) {
            primR = ILUtils.usedVarsInExp(this.dim, primR, true);
            primR = ILUtils.usedVarsInExp(this.tMask, primR, true);
            this.buildTreesBackwardOnChildrenNodes(this.exp, this.buildMaskOfSumArg(mask), toResult, primR);
        }

        private MaskTree buildMaskOfSumArg(MaskTree sumResultMask) {
            int nbDims = TapList.length(this.allDimensions);
            MaskTree result = null;
            if (this.argMask != null) {
                result = new MaskLeaf(this.argMask, nbDims);
            }
            if (sumResultMask != null) {
                int dimVal = this.dimValue != -1 ? this.dimValue : nbDims;
                ArrayDim arrayDim = (ArrayDim)TapList.nth(this.allDimensions, nbDims - dimVal);
                Tree dimLength = arrayDim.getSize();
                MaskSpread mask2 = new MaskSpread(sumResultMask, dimVal, dimLength, nbDims);
                MaskTree maskTree = result = result == null ? mask2 : new MaskAnd(mask2, result, nbDims);
            }
            if (((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.traceCurBlock == 2) {
                TapEnv.printlnOnTrace("         -> push mask " + result + " inside " + this);
            }
            return result;
        }

        @Override
        protected Tree buildTreeBackward(Tree adjPrefix, int locInThisUnused, boolean mayImplicitSpread) {
            Tree adjExpr;
            if (((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.traceCurBlock == 2) {
                TapEnv.printlnOnTrace("CALL BTB [" + ++this.levelBTB + "] ON " + this + " WITH PREFIX " + adjPrefix);
            }
            int nbDims = TapList.length(this.allDimensions);
            if (mayImplicitSpread && nbDims > 1 && !ILUtils.isNullOrNone(this.dim)) {
                mayImplicitSpread = false;
            }
            Tree adjSuffix = this.parent.buildTreeBackward(null, this.locInParent, mayImplicitSpread);
            assert (adjSuffix != null);
            TypeSpec diffResultType = (TypeSpec)adjSuffix.getRemoveAnnotation("ExprType");
            if (!mayImplicitSpread) {
                ExpressionDifferentiator.this.removeAllMarksAsVector(adjSuffix);
                int dimVal = this.dimValue != -1 ? this.dimValue : nbDims;
                ArrayDim arrayDim = (ArrayDim)TapList.nth(this.allDimensions, nbDims - dimVal);
                adjSuffix = ILUtils.buildCall(ILUtils.build(96, "SPREAD"), ILUtils.build(71, adjSuffix, ILUtils.copy(this.dim), arrayDim.getSize()));
                adjSuffix = ILUtils.pullProtectedArg(adjSuffix, 1);
                ExpressionDifferentiator.this.markAsVector(adjSuffix, true);
            }
            WrapperTypeSpec diffArgType = new WrapperTypeSpec(new ArrayTypeSpec(diffResultType.elementType(), ArrayTypeSpec.createDimensions(this.allDimensions)));
            adjSuffix.setAnnotation("ExprType", diffArgType);
            Tree tree = adjExpr = adjPrefix == null ? adjSuffix : ExpressionDifferentiator.this.mulProtectedTypedExprs(adjPrefix, adjSuffix, true);
            if (((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.traceCurBlock == 2) {
                TapEnv.printlnOnTrace("EXIT BTB [" + this.levelBTB-- + "] ON " + this + " RETURN " + adjExpr);
            }
            return adjExpr;
        }

        @Override
        public String toString() {
            return "LinReduce:" + this.toStringOnChildrenNodes(this.exp);
        }
    }

    private class LinCatenate
    extends LinTree {
        private Tree origExpression;
        private TapList<LinTree>[] elements;
        private int[] elementsOffset;

        protected LinCatenate(Tree expression, Tree[] expressions, LinTree parent, int locInParent) {
            super(parent, locInParent);
            this.origExpression = expression;
            int length = expressions.length;
            this.elements = new TapList[length];
            this.elementsOffset = null;
            if (!ExpressionDifferentiator.this.tangentDiff) {
                this.elementsOffset = new int[length + 1];
                int curOffset = ((ExpressionDifferentiator)ExpressionDifferentiator.this).curDiffUnit().arrayDimMin;
                for (int i = 0; i < length; ++i) {
                    this.elements[i] = null;
                    this.elementsOffset[i] = curOffset;
                    int elementLength = 1;
                    WrapperTypeSpec exprTypeSpec = ExpressionDifferentiator.this.adEnv.curSymbolTable().typeOf(expressions[i]);
                    TapList<ArrayDim> dimensions = exprTypeSpec.getAllDimensions();
                    while (dimensions != null) {
                        int dimSz = ((ArrayDim)dimensions.head).size();
                        if (dimSz == -1) {
                            TapEnv.fileWarning(-1, expressions[i], "(Adjoint differentiation of catenation) unknown size of element: " + expressions[i]);
                            dimSz = 1;
                        }
                        elementLength *= dimSz;
                        dimensions = dimensions.tail;
                    }
                    curOffset += elementLength;
                }
                this.elementsOffset[length] = curOffset;
            }
        }

        @Override
        protected LinTree addNewChild(LinTree newChild, int locInThis) {
            this.elements[locInThis] = TapList.addLast(this.elements[locInThis], newChild);
            return newChild;
        }

        private TapList<Tree> buildElementTrees(Tree[] elementTrees, TapPair<TapList<Tree>, TapList<Tree>> primRW, TapPair<TapList<Tree>, TapList<Tree>> diffRW) {
            TapList<Tree> diffElementsTrees = null;
            for (int i = this.elements.length - 1; i >= 0; --i) {
                TypeSpec diffElementType;
                Tree diffElement = this.buildTreeForwardOnChildrenNodes(this.elements[i], primRW, diffRW);
                TypeSpec typeSpec = diffElementType = diffElement == null ? null : (TypeSpec)diffElement.getRemoveAnnotation("ExprType");
                if (diffElement == null && this.origExpression.opCode() != 47) {
                    diffElement = ExpressionDifferentiator.this.adEnv.curSymbolTable().typeOf(elementTrees[i]).buildConstantZero();
                }
                if (diffElement == null) continue;
                diffElementsTrees = new TapList<Tree>(diffElement, diffElementsTrees);
            }
            return diffElementsTrees;
        }

        @Override
        protected Tree buildTreeForward(TapPair<TapList<Tree>, TapList<Tree>> primRW, TapPair<TapList<Tree>, TapList<Tree>> diffRW) {
            Tree diffExpr;
            if (this.origExpression.opCode() == 110) {
                diffExpr = ILUtils.build(110, ILUtils.build(71, this.buildElementTrees(this.origExpression.down(1).children(), primRW, diffRW)), ILUtils.copy(this.origExpression.down(2)));
            } else if (this.origExpression.opCode() == 47) {
                WrapperTypeSpec typeSpec = ExpressionDifferentiator.this.adEnv.curSymbolTable().typeOf(this.origExpression);
                boolean eqType = typeSpec.equalsCompilDep(typeSpec.wrappedType.diffTypeSpec) || typeSpec.wrappedType.diffTypeSpec == null || ((CompositeTypeSpec)typeSpec.wrappedType.diffTypeSpec.wrappedType).isEmpty();
                Tree diffTypeName = ILUtils.copy(this.origExpression.down(1));
                if (!eqType) {
                    TypeDecl typeDecl = ExpressionDifferentiator.this.adEnv.curSymbolTable().getTypeDecl(this.origExpression.down(1).stringValue());
                    NewSymbolHolder newSymbolHolder = typeDecl.getDiffSymbolHolder(0, null, 0);
                    diffTypeName = newSymbolHolder.makeNewRef(null);
                }
                diffExpr = ILUtils.build(47, diffTypeName, ILUtils.copy(diffTypeName), ILUtils.build(71, this.buildElementTrees(this.origExpression.down(3).children(), primRW, diffRW)));
            } else {
                diffExpr = ILUtils.build(10, this.buildElementTrees(this.origExpression.children(), primRW, diffRW));
            }
            diffExpr.setAnnotation("ExprType", ExpressionDifferentiator.this.adEnv.curSymbolTable().typeOf(this.origExpression));
            return diffExpr;
        }

        @Override
        protected void buildTreesBackwardOnNode(MaskTree mask, TapList<DiffAssignmentNode> toResult, TapList<Tree> primR) {
            for (TapList<LinTree> element : this.elements) {
                this.buildTreesBackwardOnChildrenNodes(element, null, toResult, primR);
            }
        }

        @Override
        protected Tree buildTreeBackward(Tree adjPrefix, int locInThis, boolean mayImplicitSpread) {
            Tree adjExpr;
            if (((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.traceCurBlock == 2) {
                TapEnv.printlnOnTrace("CALL BTB [" + ++this.levelBTB + "] ON " + this + " WITH PREFIX " + adjPrefix);
            }
            Tree adjSuffix = this.parent.buildTreeBackward(null, this.locInParent, mayImplicitSpread);
            assert (adjSuffix != null);
            TypeSpec diffResultType = (TypeSpec)adjSuffix.getRemoveAnnotation("ExprType");
            ExpressionDifferentiator.this.removeAllMarksAsVector(adjSuffix);
            adjSuffix = ILUtils.buildArrayTripletAccess(adjSuffix, ILUtils.build(103, this.elementsOffset[locInThis]), this.elementsOffset[locInThis + 1] - 1 > this.elementsOffset[locInThis] ? ILUtils.build(103, this.elementsOffset[locInThis + 1] - 1) : null, ((ExpressionDifferentiator)ExpressionDifferentiator.this).curDiffUnit().arrayDimMin);
            Tree[] elementTrees = this.origExpression.opCode() == 110 ? this.origExpression.down(1).children() : (this.origExpression.opCode() == 47 ? this.origExpression.down(3).children() : this.origExpression.children());
            adjSuffix.setAnnotation("ExprType", ExpressionDifferentiator.this.adEnv.curSymbolTable().typeOf(elementTrees[locInThis]));
            Tree tree = adjExpr = adjPrefix == null ? adjSuffix : ExpressionDifferentiator.this.mulProtectedTypedExprs(adjPrefix, adjSuffix, true);
            if (((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.traceCurBlock == 2) {
                TapEnv.printlnOnTrace("EXIT BTB [" + this.levelBTB-- + "] ON " + this + " RETURN " + adjExpr);
            }
            return adjExpr;
        }

        @Override
        public String toString() {
            String result = "";
            for (int i = 0; i < this.elements.length; ++i) {
                result = result + (i == 0 ? "" : ", ") + this.toStringOnChildrenNodes(this.elements[i]);
            }
            String offsetsStr = "";
            if (!ExpressionDifferentiator.this.tangentDiff) {
                for (int i = 0; i <= this.elements.length; ++i) {
                    if (i != 0) {
                        offsetsStr = offsetsStr + ";";
                    }
                    offsetsStr = offsetsStr + this.elementsOffset[i];
                }
            }
            return "LinCatenate:[" + offsetsStr + "](/" + result + "/)";
        }
    }

    private class LinIf
    extends LinTree {
        private Tree test;
        private TapList<LinTree> trueExp;
        private TapList<LinTree> falseExp;

        protected LinIf(Tree test, TapList<LinTree> trueExp, TapList<LinTree> falseExp, LinTree parent, int locInParent) {
            super(parent, locInParent);
            this.test = test;
            this.trueExp = trueExp;
            this.falseExp = falseExp;
        }

        @Override
        protected LinTree addNewChild(LinTree newChild, int locInThis) {
            if (locInThis == 1) {
                this.trueExp = TapList.addLast(this.trueExp, newChild);
            } else {
                this.falseExp = TapList.addLast(this.falseExp, newChild);
            }
            return newChild;
        }

        @Override
        protected Tree buildTreeForward(TapPair<TapList<Tree>, TapList<Tree>> primRW, TapPair<TapList<Tree>, TapList<Tree>> diffRW) {
            Tree diffExpr2;
            TypeSpec type2;
            Tree diffExpr1;
            TypeSpec type1;
            primRW.first = ILUtils.usedVarsInExp(this.test, (TapList)primRW.first, true);
            Tree aaTest = ILUtils.copy(this.test);
            if (TapEnv.associationByAddress()) {
                aaTest = ExpressionDifferentiator.this.blockDifferentiator().turnAssociationByAddressPrimal(aaTest, ExpressionDifferentiator.this.adEnv.curSymbolTable(), ((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.curFwdSymbolTable, null, true);
            }
            TypeSpec typeSpec = type1 = (diffExpr1 = this.buildTreeForwardOnChildrenNodes(this.trueExp, primRW, diffRW)) == null ? null : (TypeSpec)diffExpr1.getRemoveAnnotation("ExprType");
            if (diffExpr1 == null) {
                diffExpr1 = ILUtils.build(160, "0.0");
            }
            TypeSpec typeSpec2 = type2 = (diffExpr2 = this.buildTreeForwardOnChildrenNodes(this.falseExp, primRW, diffRW)) == null ? null : (TypeSpec)diffExpr2.getRemoveAnnotation("ExprType");
            if (diffExpr2 == null) {
                diffExpr2 = ILUtils.build(160, "0.0");
            }
            Tree diffIfTree = ILUtils.build(99, ILUtils.copy(aaTest), diffExpr1, diffExpr2);
            TypeSpec jointType = type1 == null ? type2 : (type2 == null ? type1 : ExpressionDifferentiator.this.adEnv.curSymbolTable().combineNumeric(type1, type2, diffIfTree));
            diffIfTree.setAnnotation("ExprType", jointType);
            return diffIfTree;
        }

        @Override
        protected void buildTreesBackwardOnNode(MaskTree mask, TapList<DiffAssignmentNode> toResult, TapList<Tree> primR) {
            primR = ILUtils.usedVarsInExp(this.test, primR, true);
            this.buildTreesBackwardOnChildrenNodes(this.trueExp, mask, toResult, primR);
            this.buildTreesBackwardOnChildrenNodes(this.falseExp, mask, toResult, primR);
        }

        @Override
        protected Tree buildTreeBackward(Tree adjPrefix, int locInThis, boolean mayImplicitSpread) {
            Tree adjExpr;
            if (((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.traceCurBlock == 2) {
                TapEnv.printlnOnTrace("CALL BTB [" + ++this.levelBTB + "] ON " + this + " WITH PREFIX " + adjPrefix);
            }
            Tree adjSuffix = this.parent.buildTreeBackward(null, this.locInParent, mayImplicitSpread);
            assert (adjSuffix != null);
            TypeSpec diffResultType = (TypeSpec)adjSuffix.getRemoveAnnotation("ExprType");
            boolean wasVector = ExpressionDifferentiator.this.removeAllMarksAsVector(adjSuffix);
            Tree zeroTree = diffResultType.buildConstantZero();
            Tree aaTest = ILUtils.copy(this.test);
            if (TapEnv.associationByAddress()) {
                aaTest = ExpressionDifferentiator.this.blockDifferentiator().turnAssociationByAddressPrimal(aaTest, ExpressionDifferentiator.this.adEnv.curSymbolTable(), ((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.curFwdSymbolTable, null, true);
            }
            adjSuffix = ILUtils.build(99, ILUtils.copy(aaTest), locInThis == 1 ? adjSuffix : zeroTree, locInThis == 1 ? zeroTree : adjSuffix);
            ExpressionDifferentiator.this.markAsVector(adjSuffix, wasVector);
            adjSuffix.setAnnotation("ExprType", diffResultType);
            Tree tree = adjExpr = adjPrefix == null ? adjSuffix : ExpressionDifferentiator.this.mulProtectedTypedExprs(adjPrefix, adjSuffix, true);
            if (((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.traceCurBlock == 2) {
                TapEnv.printlnOnTrace("EXIT BTB [" + this.levelBTB-- + "] ON " + this + " RETURN " + adjExpr);
            }
            return adjExpr;
        }

        @Override
        public String toString() {
            return "LinIf:" + ILUtils.toString(this.test) + " TT:" + this.toStringOnChildrenNodes(this.trueExp) + " FF:" + this.toStringOnChildrenNodes(this.falseExp);
        }
    }

    private class LinConvert
    extends LinTree {
        private Tree conversionExp;
        private TapList<LinTree> children1;
        private TapList<LinTree> children2;

        protected LinConvert(Tree conversionExp, TapList<LinTree> children1, TapList<LinTree> children2, LinTree parent, int locInParent) {
            super(parent, locInParent);
            this.conversionExp = conversionExp;
            this.children1 = children1;
            this.children2 = children2;
        }

        @Override
        protected LinTree addNewChild(LinTree newChild, int locInThis) {
            if (locInThis == 1) {
                this.children1 = TapList.addLast(this.children1, newChild);
            } else {
                this.children2 = TapList.addLast(this.children2, newChild);
            }
            return newChild;
        }

        @Override
        protected Tree buildTreeForward(TapPair<TapList<Tree>, TapList<Tree>> primRW, TapPair<TapList<Tree>, TapList<Tree>> diffRW) {
            Tree result;
            primRW.first = ILUtils.usedVarsInExp(this.conversionExp, (TapList)primRW.first, true);
            Tree diffArgument = this.buildTreeForwardOnChildrenNodes(this.children1, primRW, diffRW);
            if (this.conversionExp.opCode() == 32) {
                result = ILUtils.copy(this.conversionExp);
                TypeSpec diffArgType = diffArgument == null ? null : (TypeSpec)diffArgument.getRemoveAnnotation("ExprType");
                result.setChild(diffArgument, 2);
                result.setAnnotation("ExprType", ExpressionDifferentiator.this.adEnv.curSymbolTable().typeOf(this.conversionExp));
            } else if (this.conversionExp.opCode() == 31) {
                TypeSpec diffArgType;
                result = ILUtils.copy(this.conversionExp);
                TypeSpec typeSpec = diffArgType = diffArgument == null ? null : (TypeSpec)diffArgument.getRemoveAnnotation("ExprType");
                if (diffArgument == null) {
                    diffArgument = ILUtils.build(160, "0.0");
                }
                ILUtils.getArguments(result).setChild(diffArgument, 1);
                if (this.children2 != null) {
                    diffArgument = this.buildTreeForwardOnChildrenNodes(this.children2, primRW, diffRW);
                    TypeSpec typeSpec2 = diffArgType = diffArgument == null ? null : (TypeSpec)diffArgument.getRemoveAnnotation("ExprType");
                    if (diffArgument == null) {
                        diffArgument = ILUtils.build(160, "0.0");
                    }
                    ILUtils.getArguments(result).setChild(diffArgument, 2);
                }
                result = ILUtils.pullProtectedArg(result, 1);
                result.setAnnotation("ExprType", ExpressionDifferentiator.this.adEnv.curSymbolTable().typeOf(this.conversionExp));
            } else {
                result = diffArgument;
            }
            return result;
        }

        @Override
        protected void buildTreesBackwardOnNode(MaskTree mask, TapList<DiffAssignmentNode> toResult, TapList<Tree> primR) {
            primR = ILUtils.usedVarsInExp(this.conversionExp, primR, true);
            this.buildTreesBackwardOnChildrenNodes(this.children1, mask, toResult, primR);
            if (this.children2 != null) {
                this.buildTreesBackwardOnChildrenNodes(this.children2, mask, toResult, primR);
            }
        }

        @Override
        protected Tree buildTreeBackward(Tree adjPrefix, int locInThis, boolean mayImplicitSpread) {
            if (((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.traceCurBlock == 2) {
                TapEnv.printlnOnTrace("CALL BTB [" + ++this.levelBTB + "] ON " + this + " WITH PREFIX " + adjPrefix);
            }
            Tree adjExpr = this.parent.buildTreeBackward(null, this.locInParent, mayImplicitSpread);
            assert (adjExpr != null);
            TypeSpec adjExprType = (TypeSpec)adjExpr.getRemoveAnnotation("ExprType");
            Tree convertedArg = this.conversionExp.opCode() == 31 ? ILUtils.getArguments(this.conversionExp).down(1) : this.conversionExp.down(1);
            WrapperTypeSpec arg1Type = ExpressionDifferentiator.this.adEnv.curSymbolTable().typeOf(convertedArg);
            boolean isFortran = ExpressionDifferentiator.this.adEnv.curUnit().isFortran();
            if (this.conversionExp.opCode() == 31) {
                String conversionName = ILUtils.getCalledNameString(this.conversionExp).toLowerCase();
                if (isFortran && "sngl".equals(conversionName)) {
                    adjExpr = ILUtils.buildCall(ILUtils.build(96, "dble"), ILUtils.build(71, adjExpr));
                    adjExpr = ILUtils.pullProtectedArg(adjExpr, 1);
                } else if (isFortran && "dble".equals(conversionName)) {
                    adjExpr = ILUtils.buildCall(ILUtils.build(96, "sngl"), ILUtils.build(71, adjExpr));
                    adjExpr = ILUtils.pullProtectedArg(adjExpr, 1);
                } else if (isFortran ? "conjg".equals(conversionName) || "dconjg".equals(conversionName) : "conj".equals(conversionName)) {
                    adjExpr = ILUtils.buildCall(ILUtils.build(96, conversionName), ILUtils.build(71, adjExpr));
                    adjExpr = ILUtils.pullProtectedArg(adjExpr, 1);
                } else if (isFortran && "aimag".equals(conversionName)) {
                    adjExpr = ILUtils.buildCall(ILUtils.build(96, "cmplx"), ILUtils.build(71, ILUtils.build(160, "0.D0"), adjExpr, ILUtils.build(103, 8)));
                    adjExpr = ILUtils.pullProtectedArg(adjExpr, 2);
                } else if (!isFortran && "cimag".equals(conversionName)) {
                    adjExpr = ILUtils.build(133, ILUtils.build(160, "1.0iF"), adjExpr);
                } else if (isFortran && "dimag".equals(conversionName)) {
                    adjExpr = ILUtils.buildCall(ILUtils.build(96, "dcmplx"), ILUtils.build(71, ILUtils.build(160, "0.D0"), adjExpr));
                    adjExpr = ILUtils.pullProtectedArg(adjExpr, 2);
                } else if (isFortran ? ILUtils.isStringOf(conversionName, new String[]{"real", "dreal"}) : "creal".equals(conversionName)) {
                    if (arg1Type.isComplexBase()) {
                        // empty if block
                    }
                } else if (isFortran && "dcmplx".equals(conversionName)) {
                    if (!arg1Type.isComplexBase()) {
                        adjExpr = ILUtils.buildCall(ILUtils.build(96, locInThis == 1 ? "dreal" : "dimag"), ILUtils.build(71, adjExpr));
                        adjExpr = ILUtils.pullProtectedArg(adjExpr, 1);
                    }
                } else if (isFortran && ILUtils.isStringOf(conversionName, new String[]{"cmplx", "complex"}) && !arg1Type.isComplexBase()) {
                    adjExpr = ILUtils.buildCall(ILUtils.build(96, locInThis == 1 ? (isFortran ? "real" : "creal") : (isFortran ? "aimag" : "cimag")), ILUtils.build(71, adjExpr));
                    adjExpr = ILUtils.pullProtectedArg(adjExpr, 1);
                }
            }
            if (adjPrefix != null) {
                adjExpr = ExpressionDifferentiator.this.mulProtectedTypedExprs(adjPrefix, adjExpr, true);
            }
            adjExpr.setAnnotation("ExprType", arg1Type);
            if (((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.traceCurBlock == 2) {
                TapEnv.printlnOnTrace("EXIT BTB [" + this.levelBTB-- + "] ON " + this + " RETURN " + adjExpr);
            }
            return adjExpr;
        }

        @Override
        public String toString() {
            return "LinConvert:" + ILUtils.toString(this.conversionExp) + " * " + this.toStringOnChildrenNodes(this.children1) + (this.children2 == null ? "" : " & " + this.toStringOnChildrenNodes(this.children2));
        }
    }

    private class LinStd
    extends LinTree {
        private Tree factor;
        private TypeSpec factorType;
        private TapList<LinTree> children;

        protected LinStd(Tree factor, TypeSpec factorType, TapList<LinTree> children, LinTree parent, int locInParent) {
            super(parent, locInParent);
            this.factor = factor;
            this.factorType = factorType;
            this.children = children;
        }

        @Override
        protected LinTree addNewChild(LinTree newChild, int locInThisUnused) {
            this.children = TapList.addLast(this.children, newChild);
            return newChild;
        }

        @Override
        protected Tree buildTreeForward(TapPair<TapList<Tree>, TapList<Tree>> primRW, TapPair<TapList<Tree>, TapList<Tree>> diffRW) {
            primRW.first = ILUtils.usedVarsInExp(this.factor, (TapList)primRW.first, true);
            Tree aaFactor = ILUtils.copy(this.factor);
            if (TapEnv.associationByAddress()) {
                aaFactor = ExpressionDifferentiator.this.blockDifferentiator().turnAssociationByAddressPrimal(aaFactor, ExpressionDifferentiator.this.adEnv.curSymbolTable(), ((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.curFwdSymbolTable, null, true);
            }
            aaFactor.setAnnotation("ExprType", this.factorType);
            return ExpressionDifferentiator.this.mulProtectedTypedExprs(aaFactor, this.buildTreeForwardOnChildrenNodes(this.children, primRW, diffRW), false);
        }

        @Override
        protected void buildTreesBackwardOnNode(MaskTree mask, TapList<DiffAssignmentNode> toResult, TapList<Tree> primR) {
            primR = ILUtils.usedVarsInExp(this.factor, primR, true);
            this.buildTreesBackwardOnChildrenNodes(this.children, mask, toResult, primR);
        }

        @Override
        protected Tree buildTreeBackward(Tree adjPrefix, int locInThisUnused, boolean mayImplicitSpread) {
            if (((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.traceCurBlock == 2) {
                TapEnv.printlnOnTrace("CALL BTB [" + ++this.levelBTB + "] ON " + this + " WITH PREFIX " + adjPrefix);
            }
            Tree aaFactor = ILUtils.copy(this.factor);
            ExpressionDifferentiator.this.markAsVectorInside(aaFactor);
            ExpressionDifferentiator.this.markAsVector(aaFactor, this.factorType != null && this.factorType.isArray());
            if (TapEnv.associationByAddress()) {
                aaFactor = ExpressionDifferentiator.this.blockDifferentiator().turnAssociationByAddressPrimal(aaFactor, ExpressionDifferentiator.this.adEnv.curSymbolTable(), ((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.curFwdSymbolTable, null, true);
            }
            aaFactor.setAnnotation("ExprType", this.factorType);
            adjPrefix = adjPrefix == null ? aaFactor : ExpressionDifferentiator.this.mulProtectedTypedExprs(adjPrefix, aaFactor, false);
            Tree adjExpr = this.parent.buildTreeBackward(adjPrefix, this.locInParent, mayImplicitSpread);
            if (((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.traceCurBlock == 2) {
                TapEnv.printlnOnTrace("EXIT BTB [" + this.levelBTB-- + "] ON " + this + " RETURN " + adjExpr);
            }
            return adjExpr;
        }

        @Override
        public String toString() {
            return "LinStd:" + ILUtils.toString(this.factor) + " * " + this.toStringOnChildrenNodes(this.children);
        }
    }

    private class LinLeaf
    extends LinTree {
        Tree ref;
        private Tree[] diffRefR;
        private LinAssign correspondingAssign;
        private InstructionMask iMask;
        private boolean normal;

        protected LinLeaf(Tree ref, Tree[] diffRefR, InstructionMask iMask, boolean normal, LinTree parent, int locInParent) {
            super(parent, locInParent);
            this.normal = true;
            this.ref = ref;
            this.iMask = iMask;
            this.diffRefR = diffRefR;
            this.normal = normal;
        }

        @Override
        protected LinTree addNewChild(LinTree newChild, int locInThis) {
            TapEnv.toolError("addNewChild() forbidden on a linearization leaf:" + this);
            return null;
        }

        @Override
        protected Tree buildTreeForward(TapPair<TapList<Tree>, TapList<Tree>> primRW, TapPair<TapList<Tree>, TapList<Tree>> diffRW) {
            TapList<Object> toNewDiffR = new TapList<Object>(null, null);
            primRW.first = ILUtils.usedVarsInDiffExp(this.ref, (TapList)primRW.first, toNewDiffR, false);
            diffRW.first = ILUtils.addListTreeInList(toNewDiffR.tail, (TapList)diffRW.first);
            diffRW.first = ILUtils.addTreeInList(this.ref, (TapList)diffRW.first);
            Tree result = ILUtils.copy(this.diffRefR[((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.iReplic]);
            result.setAnnotation("ExprType", ExpressionDifferentiator.this.adEnv.curSymbolTable().typeOf(this.ref));
            return result;
        }

        @Override
        protected void buildTreesBackwardOnNode(MaskTree mask, TapList<DiffAssignmentNode> toResult, TapList<Tree> primR) {
            if (this.correspondingAssign != null) {
                this.correspondingAssign.assignmentMask = mask;
            }
            Tree backwardChain = this.parent.buildTreeBackward(null, this.locInParent, true);
            assert (backwardChain != null);
            TypeSpec diffBackwardChainType = (TypeSpec)backwardChain.getRemoveAnnotation("ExprType");
            ExpressionDifferentiator.this.removeAllMarksAsVector(backwardChain);
            if (diffBackwardChainType != null && diffBackwardChainType.isComplexBase() && !ExpressionDifferentiator.this.adEnv.curSymbolTable().typeOf(this.ref).isComplexBase()) {
                backwardChain = ILUtils.buildCall(ILUtils.build(96, ExpressionDifferentiator.this.adEnv.curUnit().isFortran() ? "real" : "creal"), ILUtils.build(71, backwardChain));
                backwardChain = ILUtils.pullProtectedArg(backwardChain, 1);
            }
            TapList<Object> toNewDiffR = new TapList<Object>(null, null);
            primR = ILUtils.usedVarsInDiffExp(this.ref, primR, toNewDiffR, false);
            DiffAssignmentNode diffLhsNode = (DiffAssignmentNode)toResult.head;
            if (1 == ILUtils.eqOrDisjointRef(this.ref, diffLhsNode.primRecv, ExpressionDifferentiator.this.adEnv.curInstruction(), ExpressionDifferentiator.this.adEnv.curInstruction()) && InstructionMask.equalMasks(this.iMask, diffLhsNode.mask)) {
                diffLhsNode.primR = ILUtils.addListTreeInList(primR, diffLhsNode.primR);
                diffLhsNode.diffR = ILUtils.addListTreeInList(toNewDiffR.tail, diffLhsNode.diffR);
                diffLhsNode.diffR = ILUtils.addTreeInList(this.ref, diffLhsNode.diffR);
                diffLhsNode.diffValue = ILUtils.addProtectedExprs(diffLhsNode.diffValue, backwardChain);
                if (((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.traceCurBlock == 2) {
                    TapEnv.printlnOnTrace("       UPDATED ADJOINT NODE OF DIFF LHS:" + diffLhsNode);
                }
            } else {
                InstructionMask rebuiltMask;
                TapList<Tree> diffR = diffLhsNode.diffW;
                diffR = ILUtils.addListTreeInList(toNewDiffR.tail, diffR);
                if (this.normal) {
                    diffR = ILUtils.addTreeInList(this.ref, diffR);
                }
                InstructionMask instructionMask = rebuiltMask = mask == null ? null : mask.rebuildInstructionMask();
                if (((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.traceCurBlock == 2) {
                    TapEnv.printlnOnTrace("         <- Rebuilt mask " + rebuiltMask + " from mask:" + mask + " around assignment of diff " + this);
                }
                toResult.placdl(new DiffAssignmentNode(ILUtils.copy(this.diffRefR[((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.iReplic]), this.normal ? 2 : 3, backwardChain, rebuiltMask, this.ref, ((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.iReplic, primR, null, diffR, new TapList<Tree>(this.ref, null)));
                if (((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.traceCurBlock == 2) {
                    TapEnv.printlnOnTrace("       BUILT ADJOINT NODE TO UPDATE DIFF FROM RHS:" + toResult.tail.head);
                }
            }
        }

        @Override
        protected Tree buildTreeBackward(Tree adjPrefix, int locInThisUnused, boolean mayImplicitSpread) {
            return null;
        }

        @Override
        public String toString() {
            return "LinLeaf:" + ILUtils.toString(this.diffRefR[0]) + (this.diffRefR.length == 1 ? "" : " *" + this.diffRefR.length + "replicas");
        }
    }

    private abstract class LinTree {
        protected LinTree parent;
        protected int locInParent;
        protected int levelBTB = 0;

        private LinTree(LinTree parent, int locInParent) {
            this.parent = parent;
            this.locInParent = locInParent;
        }

        protected abstract LinTree addNewChild(LinTree var1, int var2);

        private LinLeaf addLinLeaf(Tree ref, Tree[] diffRefR, InstructionMask iMask, boolean normal, int locInThis) {
            return (LinLeaf)this.addNewChild(new LinLeaf(ref, diffRefR, iMask, normal, this, locInThis), locInThis);
        }

        private LinStd addLinStd(Tree deriv, TypeSpec derivType, int locInThis) {
            return (LinStd)this.addNewChild(new LinStd(deriv, derivType, null, this, locInThis), locInThis);
        }

        private LinConvert addLinConvert(Tree conversionExp, int locInThis) {
            return (LinConvert)this.addNewChild(new LinConvert(conversionExp, null, null, this, locInThis), locInThis);
        }

        private LinIf addLinIf(Tree test, int locInThis) {
            return (LinIf)this.addNewChild(new LinIf(test, null, null, this, locInThis), locInThis);
        }

        private LinCatenate addLinCatenate(Tree expression, Tree[] expressions, int locInThis) {
            return (LinCatenate)this.addNewChild(new LinCatenate(expression, expressions, this, locInThis), locInThis);
        }

        private LinSpread addLinSpread(TapList<ArrayDim> allDimensions, Tree dim, Tree nCopies, int locInThis) {
            return (LinSpread)this.addNewChild(new LinSpread(allDimensions, dim, nCopies, null, this, locInThis), locInThis);
        }

        private LinReduce addLinReduce(TapList<ArrayDim> allDimensions, Tree dim, Tree tMask, InstructionMask argMask, int locInThis) {
            return (LinReduce)this.addNewChild(new LinReduce(allDimensions, dim, tMask, argMask, null, this, locInThis), locInThis);
        }

        protected Tree buildTreeForwardOnChildrenNodes(TapList<LinTree> linTrees, TapPair<TapList<Tree>, TapList<Tree>> primRW, TapPair<TapList<Tree>, TapList<Tree>> diffRW) {
            Tree result = null;
            TypeSpec resultType = null;
            while (linTrees != null) {
                Tree newTree = ((LinTree)linTrees.head).buildTreeForward(primRW, diffRW);
                TypeSpec newTreeType = newTree == null ? null : (TypeSpec)newTree.getRemoveAnnotation("ExprType");
                result = ILUtils.addProtectedExprs(result, newTree);
                resultType = resultType == null ? newTreeType : (newTreeType == null ? resultType : ExpressionDifferentiator.this.adEnv.curSymbolTable().combineNumeric(resultType, newTreeType, result));
                linTrees = linTrees.tail;
            }
            if (result != null) {
                result.setAnnotation("ExprType", resultType);
            }
            return result;
        }

        protected abstract Tree buildTreeForward(TapPair<TapList<Tree>, TapList<Tree>> var1, TapPair<TapList<Tree>, TapList<Tree>> var2);

        protected void buildTreesBackwardOnChildrenNodes(TapList<LinTree> linTrees, MaskTree mask, TapList<DiffAssignmentNode> toResult, TapList<Tree> primR) {
            while (linTrees != null) {
                ((LinTree)linTrees.head).buildTreesBackwardOnNode(mask, toResult, primR);
                linTrees = linTrees.tail;
            }
        }

        protected abstract void buildTreesBackwardOnNode(MaskTree var1, TapList<DiffAssignmentNode> var2, TapList<Tree> var3);

        protected abstract Tree buildTreeBackward(Tree var1, int var2, boolean var3);

        protected String toStringOnChildrenNodes(TapList<LinTree> linTrees) {
            String result = "";
            while (linTrees != null) {
                result = result + linTrees.head;
                linTrees = linTrees.tail;
                if (linTrees == null) continue;
                result = result + ",";
            }
            return "{" + result + "}";
        }

        public String toString() {
            return "LinTree@" + Integer.toHexString(this.hashCode());
        }
    }

    private static class MaskSpread
    extends MaskTree {
        private MaskTree mask;
        private int dimValue;
        private Tree dimLength;

        protected MaskSpread(MaskTree mask, int dimValue, Tree dimLength, int nbDims) {
            super(nbDims);
            this.mask = mask;
            this.dimValue = dimValue;
            this.dimLength = dimLength;
        }

        @Override
        protected InstructionMask rebuildInstructionMask() {
            return new InstructionMask(this.rebuildInstructionMaskTree(), null);
        }

        @Override
        protected Tree rebuildInstructionMaskTree() {
            Tree maskTree = this.mask.rebuildInstructionMaskTree();
            if (maskTree == null) {
                return null;
            }
            return ILUtils.buildCall(ILUtils.build(96, "spread"), ILUtils.build(71, maskTree, ILUtils.build(103, this.dimValue), ILUtils.copy(this.dimLength)));
        }

        @Override
        public String toString() {
            return "SPR:" + this.dimValue + ':' + ILUtils.toString(this.dimLength) + "(" + this.mask + ')';
        }
    }

    private static class MaskAny
    extends MaskTree {
        private MaskTree mask;
        private int dimValue;

        protected MaskAny(MaskTree mask, int dimValue, int nbDims) {
            super(nbDims);
            this.mask = mask;
            this.dimValue = dimValue;
        }

        @Override
        protected InstructionMask rebuildInstructionMask() {
            return null;
        }

        @Override
        protected Tree rebuildInstructionMaskTree() {
            return null;
        }

        @Override
        public String toString() {
            return "ANY:" + this.dimValue + "(" + this.mask + ')';
        }
    }

    private static class MaskAnd
    extends MaskTree {
        private MaskTree mask1;
        private MaskTree mask2;

        protected MaskAnd(MaskTree mask1, MaskTree mask2, int nbDims) {
            super(nbDims);
            this.mask1 = mask1;
            this.mask2 = mask2;
        }

        @Override
        protected InstructionMask rebuildInstructionMask() {
            return new InstructionMask(this.rebuildInstructionMaskTree(), null);
        }

        @Override
        protected Tree rebuildInstructionMaskTree() {
            Tree maskTree1 = this.mask1.rebuildInstructionMaskTree();
            Tree maskTree2 = this.mask2.rebuildInstructionMaskTree();
            if (maskTree1 == null) {
                return maskTree2;
            }
            if (maskTree2 == null) {
                return maskTree1;
            }
            return ILUtils.build(6, maskTree1, maskTree2);
        }

        @Override
        public String toString() {
            return this.mask1 + " AND " + this.mask2;
        }
    }

    private static class MaskLeaf
    extends MaskTree {
        protected InstructionMask iMask;

        protected MaskLeaf(InstructionMask iMask, int nbDims) {
            super(nbDims);
            this.iMask = iMask;
        }

        @Override
        protected InstructionMask rebuildInstructionMask() {
            return this.iMask;
        }

        @Override
        protected Tree rebuildInstructionMaskTree() {
            return this.iMask.rebuildTree();
        }

        @Override
        public String toString() {
            return "Mask" + this.iMask;
        }
    }

    private static abstract class MaskTree {
        private int nbDims;

        protected MaskTree(int nbDims) {
            this.nbDims = nbDims;
        }

        protected abstract InstructionMask rebuildInstructionMask();

        protected abstract Tree rebuildInstructionMaskTree();

        public String toString() {
            return "MaskTree@" + Integer.toHexString(this.hashCode());
        }
    }

    private final class DiffCutSupport {
        private int primalCost;
        private int primalTimes;
        private boolean cutPrimal;
        private int adjCost;
        private int adjTimes;
        private int nbDimensions;
        private boolean cutAdj;
        private boolean isActive;
        private int dCostUp;
        private int dCostDiff1;
        private int dCostDiff2;
        private NewSymbolHolder tmpVarHolder;
        private Tree tmpVar;
        private boolean tmpPrimalVarInitialized;
        private Tree[] tmpAdjVarR;

        public String toString() {
            return "{" + (this.cutPrimal ? " ! " : "") + this.primalTimes + "*" + this.primalCost + (this.isActive ? " active" : " passive") + (ExpressionDifferentiator.this.tangentDiff ? "" : " adj:" + this.adjTimes + "*" + this.adjCost) + "}";
        }

        private DiffCutSupport(Tree tree) {
            this.isActive = ((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.activeRootCalledFromContext || ADActivityAnalyzer.isAnnotatedActive(ExpressionDifferentiator.this.adEnv.curActivity(), tree, ExpressionDifferentiator.this.adEnv.curSymbolTable()) || TapIntList.intersects(ZoneInfo.listAllZones(ExpressionDifferentiator.this.adEnv.curSymbolTable().treeOfZonesOfValue(tree, null, ExpressionDifferentiator.this.adEnv.curInstruction(), null), true), ((ExpressionDifferentiator)ExpressionDifferentiator.this).adEnv.toActiveTmpZones.tail);
            switch (tree.opCode()) {
                case 3: 
                case 182: {
                    this.dCostUp = 1;
                    break;
                }
                case 133: {
                    this.dCostUp = 4;
                    break;
                }
                case 62: {
                    this.dCostUp = 6;
                    break;
                }
                case 155: {
                    if (ILUtils.isExpressionIntConstant(tree.down(2))) {
                        int intPower = ILUtils.intConstantValue(tree.down(2));
                        if (intPower < 0) {
                            this.dCostUp = (-1 - intPower) * 4 + 6;
                            this.dCostDiff1 = (1 - intPower) * 4 + 6;
                        } else {
                            this.dCostUp = (intPower - 1) * 4;
                            this.dCostDiff1 = intPower * 4;
                        }
                        this.dCostDiff2 = 0;
                        if (this.dCostUp > 15) {
                            this.dCostUp = 15;
                        }
                        if (this.dCostDiff1 <= 24) break;
                        this.dCostDiff1 = 24;
                        break;
                    }
                    this.dCostUp = 15;
                    this.dCostDiff1 = 24;
                    this.dCostDiff2 = 28;
                    break;
                }
                case 10: 
                case 42: 
                case 47: 
                case 110: {
                    this.dCostUp = 1;
                    break;
                }
                case 99: {
                    this.dCostUp = 1;
                    break;
                }
            }
        }

        private int bestCutProfit() {
            int p3 = (this.adjTimes - 1) * this.adjCost - (this.adjTimes + 1) * 1;
            int profit = (this.primalTimes - 1) * this.primalCost - (this.primalTimes + 1) * 1;
            if (p3 > profit) {
                profit = p3;
            }
            return profit - 5 - 3 * this.nbDimensions;
        }

        private boolean doBestCut() {
            int p1 = (this.primalTimes - 1) * this.primalCost - (this.primalTimes + 1) * 1;
            int p3 = (this.adjTimes - 1) * this.adjCost - (this.adjTimes + 1) * 1;
            if (p1 > p3) {
                this.cutPrimal = true;
                this.primalCost = 1;
                this.primalTimes = 1;
                return true;
            }
            this.cutAdj = true;
            this.adjCost = 1;
            this.adjTimes = 1;
            return false;
        }

        static /* synthetic */ Tree[] access$3202(DiffCutSupport x0, Tree[] x1) {
            x0.tmpAdjVarR = x1;
            return x1;
        }
    }
}

