/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.differentiation;

import fr.inria.tapenade.analysis.ActivityPattern;
import fr.inria.tapenade.differentiation.BlockDifferentiator;
import fr.inria.tapenade.differentiation.CallGraphDifferentiator;
import fr.inria.tapenade.differentiation.DynMemoryDifferentiator;
import fr.inria.tapenade.differentiation.ExpressionDifferentiator;
import fr.inria.tapenade.differentiation.FlowGraphDifferentiator;
import fr.inria.tapenade.differentiation.ProcedureCallDifferentiator;
import fr.inria.tapenade.differentiation.UnitDiffInfo;
import fr.inria.tapenade.differentiation.VarRefDifferentiator;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.BlockStorage;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.MemoryMaps;
import fr.inria.tapenade.representation.ModifiedTypeSpec;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.UnitStorage;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;

public final class DifferentiationEnv {
    private CallGraph srcCallGraph;
    private CallGraph diffCallGraph;
    protected TapList<Unit> rootUnits;
    protected TapList<Unit> callersOfRootUnits;
    protected boolean curUnitIsActiveUnit;
    protected boolean curUnitIsContext;
    protected UnitStorage<Unit> copiedUnits;
    protected UnitStorage<Unit> copiedUnitsBack;
    protected TapList<TapPair<Instruction, Instruction>> copiedIncludes = new TapList<Object>(null, null);
    protected BlockStorage<TapList<BoolVector>> unitActivities;
    protected BlockStorage<TapList<BoolVector>> unitUsefulnesses;
    protected BlockStorage<TapList<BoolVector>> unitReqXs;
    protected BlockStorage<TapList<BoolVector>> unitAvlXs;
    protected BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> unitTBRs;
    protected BlockStorage<TapList<TapPair<TapList<Instruction>, TapList<Instruction>>>> unitRecomputations;
    protected TapList<TapPair<Object, TapList<String>>> hiddenPushPopVariables = new TapList<Object>(null, null);
    protected TapList<TapPair<Object, TapList<String>>> hiddenInstrumentedVariables = new TapList<Object>(null, null);
    protected TapList<TapPair<Object, TapList<String>>> hiddenDiffInitVariables = new TapList<Object>(null, null);
    protected TapList<NewSymbolHolder> toIndexSymbolHolders = new TapList<Object>(null, null);
    protected boolean curDiffUnitPushesPointers;
    protected boolean usesADMM;
    protected boolean activeRootCalledFromContext;
    protected String[][] suffixes;
    protected boolean emptyCopiedUnitSuffix;
    protected int adDiffMode = 1;
    protected boolean multiDirMode;
    protected WrapperTypeSpec integerTypeSpec;
    protected WrapperTypeSpec integer4TypeSpec;
    protected WrapperTypeSpec realTypeSpec;
    protected int diffKind;
    protected TapIntList toActiveTmpZones = new TapIntList(-1, null);
    protected TapIntList toTotalZones = new TapIntList(0, null);
    protected MemoryMaps commonActivityMemoryMap;
    protected Unit debugADHereUnit;
    protected TapList<Unit> traceDifferentiationUnits;
    protected boolean traceCurDifferentiation;
    protected int traceCurBlock;
    protected CallGraphDifferentiator callGraphDifferentiator;
    protected FlowGraphDifferentiator flowGraphDifferentiator;
    protected BlockDifferentiator blockDifferentiator;
    protected ProcedureCallDifferentiator procedureCallDifferentiator;
    protected DynMemoryDifferentiator dynMemoryDifferentiator;
    protected ExpressionDifferentiator expressionDifferentiator;
    protected VarRefDifferentiator varRefDifferentiator;
    private Unit curUnit;
    private ActivityPattern curActivity;
    private Instruction curInstruction;
    protected Unit curDiffUnit;
    protected Unit curFwdDiffUnit;
    protected int curDiffUnitSort = -1;
    protected int curDiffVarSort = -1;
    protected int iReplic = 0;
    protected Block curBlock;
    private SymbolTable curSymbolTable;
    protected SymbolTable curFwdSymbolTable;
    protected SymbolTable curBwdSymbolTable;
    protected int[] curVectorMap;
    protected int[] curDiffVectorMap;
    protected int[] curPtrVectorMap;
    private TapIntList hiddenActiveTmpZones;
    private TapList<Unit> stackCurUnits;
    private TapList<Unit> stackCurDiffUnits;
    private TapIntList stackCurDiffUnitSorts;
    private TapIntList stackCurDiffVarSorts;
    private TapList<SymbolTable> stackCurSymbolTables;
    private TapList<int[]> stackCurVectorMaps;
    private TapList<int[]> stackCurDiffVectorMaps;

    protected CallGraph srcCallGraph() {
        return this.srcCallGraph;
    }

    private void setSrcCallGraph(CallGraph srcCallGraph) {
        this.srcCallGraph = srcCallGraph;
    }

    protected CallGraph diffCallGraph() {
        return this.diffCallGraph;
    }

    protected void setDiffCallGraph(CallGraph diffCallGraph) {
        this.diffCallGraph = diffCallGraph;
    }

    public boolean someUnitsAreTraced() {
        return this.traceDifferentiationUnits != null;
    }

    protected Unit curUnit() {
        return this.curUnit;
    }

    protected ActivityPattern curActivity() {
        return this.curActivity;
    }

    protected Instruction curInstruction() {
        return this.curInstruction;
    }

    protected SymbolTable curSymbolTable() {
        return this.curSymbolTable;
    }

    protected DifferentiationEnv(CallGraph srcCallGraph, String[][] suffixes) {
        this.setSrcCallGraph(srcCallGraph);
        this.suffixes = suffixes;
        this.diffKind = TapEnv.diffKind();
        this.multiDirMode = TapEnv.get().multiDirDiffMode;
        this.emptyCopiedUnitSuffix = suffixes[0][1] == null || suffixes[0][1].isEmpty();
        this.commonActivityMemoryMap = new MemoryMaps();
        this.integerTypeSpec = srcCallGraph.languageRootSymbolTable((int)TapEnv.inputLanguage()).getTypeDecl((String)"integer").typeSpec;
        this.integer4TypeSpec = new WrapperTypeSpec(new ModifiedTypeSpec(this.integerTypeSpec, ILUtils.build(103, 4), null));
        this.realTypeSpec = srcCallGraph.languageRootSymbolTable((int)TapEnv.inputLanguage()).getTypeDecl((String)"float").typeSpec;
        this.traceDifferentiationUnits = srcCallGraph.getUnits(TapEnv.get().traceDifferentiationUnitNames);
        this.copiedUnits = new UnitStorage(srcCallGraph);
        this.copiedUnitsBack = new UnitStorage(srcCallGraph);
        this.callGraphDifferentiator = new CallGraphDifferentiator(this);
        this.flowGraphDifferentiator = new FlowGraphDifferentiator(this);
        this.blockDifferentiator = new BlockDifferentiator(this);
        this.procedureCallDifferentiator = new ProcedureCallDifferentiator(this);
        this.dynMemoryDifferentiator = new DynMemoryDifferentiator(this);
        this.expressionDifferentiator = new ExpressionDifferentiator(this);
        this.varRefDifferentiator = new VarRefDifferentiator(this);
    }

    protected Unit getPrimalCopyOfOrigUnit(Unit unit) {
        if (unit.rank() == -1 || this.copiedUnits == null) {
            return null;
        }
        return this.copiedUnits.retrieve(unit);
    }

    protected Unit getOrigUnitOfPrimalCopy(Unit unit) {
        if (unit.rank() == -1 || this.copiedUnitsBack == null) {
            return null;
        }
        return this.copiedUnitsBack.retrieve(unit);
    }

    protected Unit getDiffOfUnit(Unit unit, ActivityPattern pattern, int diffMode) {
        UnitDiffInfo diffInfo = this.callGraphDifferentiator.getUnitDiffInfo(unit);
        if (diffInfo == null) {
            return null;
        }
        return diffInfo.getDiffForModeAndActivity(diffMode, pattern);
    }

    protected Unit getDiffOfModule(Unit unit) {
        if (unit == null || unit.rank() == -1 || unit.isPredefinedModuleOrTranslationUnit()) {
            return null;
        }
        UnitDiffInfo diffInfo = this.callGraphDifferentiator.getUnitDiffInfo(unit);
        return diffInfo.getDiff();
    }

    protected TapList<ActivityPattern> getPatternsForCallingUnitPattern(ActivityPattern callerPattern, Unit calledUnit) {
        TapList<ActivityPattern> calledActivityPatterns = calledUnit.activityPatterns;
        TapList<ActivityPattern> retList = null;
        if (calledActivityPatterns != null) {
            for (ActivityPattern calledPattern : calledActivityPatterns) {
                if (callerPattern != null && !TapList.contains(calledPattern.callingPatterns(), callerPattern)) continue;
                retList = new TapList<ActivityPattern>(calledPattern, retList);
            }
        }
        return retList;
    }

    protected void setDiffCallGraphAndRootUnits(CallGraph diffCG, TapList<Unit> rootUnits) {
        this.rootUnits = rootUnits;
        this.callersOfRootUnits = Unit.allCallersMulti(rootUnits);
        this.setDiffCallGraph(diffCG);
    }

    protected void setCurUnitEtc(Unit unit) {
        this.curUnit = unit;
        this.curInstruction = null;
        this.traceCurDifferentiation = this.traceDifferentiationUnits != null && (this.traceDifferentiationUnits.head == null || unit != null && TapList.contains(this.traceDifferentiationUnits, unit));
    }

    protected void pushCurUnitEtc(Unit unit) {
        this.stackCurUnits = new TapList<Unit>(this.curUnit, this.stackCurUnits);
        this.setCurUnitEtc(unit);
    }

    protected void popCurUnitEtc() {
        this.setCurUnitEtc((Unit)this.stackCurUnits.head);
        this.stackCurUnits = this.stackCurUnits.tail;
    }

    protected void setCurActivity(ActivityPattern activity) {
        this.curActivity = activity;
    }

    protected void setCurInstruction(Instruction instr) {
        this.curInstruction = instr;
    }

    protected void setCurDiffUnit(Unit diffUnit) {
        this.curDiffUnit = diffUnit;
    }

    protected void pushCurDiffUnit(Unit diffUnit) {
        this.stackCurDiffUnits = new TapList<Unit>(this.curDiffUnit, this.stackCurDiffUnits);
        this.setCurDiffUnit(diffUnit);
    }

    protected void popCurDiffUnit() {
        this.setCurDiffUnit((Unit)this.stackCurDiffUnits.head);
        this.stackCurDiffUnits = this.stackCurDiffUnits.tail;
    }

    protected void setCurFwdDiffUnit(Unit fwdDiffUnit) {
        this.curFwdDiffUnit = fwdDiffUnit;
    }

    protected void setCurDiffSorts(int diffUnitSort, int diffVarSort) {
        if (diffUnitSort != -1) {
            this.curDiffUnitSort = diffUnitSort;
        }
        if (diffVarSort != -1) {
            this.curDiffVarSort = diffVarSort;
        }
    }

    protected void pushCurDiffSorts(int diffUnitSort, int diffVarSort) {
        this.stackCurDiffUnitSorts = new TapIntList(this.curDiffUnitSort, this.stackCurDiffUnitSorts);
        this.stackCurDiffVarSorts = new TapIntList(this.curDiffVarSort, this.stackCurDiffVarSorts);
        this.setCurDiffSorts(diffUnitSort, diffVarSort);
    }

    protected void popCurDiffSorts() {
        this.setCurDiffSorts(this.stackCurDiffUnitSorts.head, this.stackCurDiffVarSorts.head);
        this.stackCurDiffUnitSorts = this.stackCurDiffUnitSorts.tail;
        this.stackCurDiffVarSorts = this.stackCurDiffVarSorts.tail;
    }

    protected void setCurBlock(Block block) {
        this.curBlock = block;
    }

    protected void setCurSymbolTable(SymbolTable symbolTable) {
        this.curSymbolTable = symbolTable;
    }

    protected void pushCurSymbolTable(SymbolTable symbolTable) {
        this.stackCurSymbolTables = new TapList<SymbolTable>(this.curSymbolTable, this.stackCurSymbolTables);
        this.setCurSymbolTable(symbolTable);
    }

    protected void popCurSymbolTable() {
        this.setCurSymbolTable((SymbolTable)this.stackCurSymbolTables.head);
        this.stackCurSymbolTables = this.stackCurSymbolTables.tail;
    }

    protected void setCurFwdSymbolTable(SymbolTable symbolTable) {
        this.curFwdSymbolTable = symbolTable;
    }

    protected void setCurBwdSymbolTable(SymbolTable symbolTable) {
        this.curBwdSymbolTable = symbolTable;
    }

    protected void setCurVectorMap(int[] vectorMap) {
        this.curVectorMap = vectorMap;
    }

    protected void pushCurVectorMap(int[] vectorMap) {
        this.stackCurVectorMaps = new TapList<int[]>(this.curVectorMap, this.stackCurVectorMaps);
        this.setCurVectorMap(vectorMap);
    }

    protected void popCurVectorMap() {
        this.setCurVectorMap((int[])this.stackCurVectorMaps.head);
        this.stackCurVectorMaps = this.stackCurVectorMaps.tail;
    }

    protected void setCurDiffVectorMap(int[] diffVectorMap) {
        this.curDiffVectorMap = diffVectorMap;
    }

    protected void pushCurDiffVectorMap(int[] diffVectorMap) {
        this.stackCurDiffVectorMaps = new TapList<int[]>(this.curDiffVectorMap, this.stackCurDiffVectorMaps);
        this.setCurDiffVectorMap(diffVectorMap);
    }

    protected void popCurDiffVectorMap() {
        this.setCurDiffVectorMap((int[])this.stackCurDiffVectorMaps.head);
        this.stackCurDiffVectorMaps = this.stackCurDiffVectorMaps.tail;
    }

    protected void setCurPtrVectorMap(int[] ptrVectorMap) {
        this.curPtrVectorMap = ptrVectorMap;
    }

    protected void hideActiveTmpZones() {
        this.hiddenActiveTmpZones = this.toActiveTmpZones.tail;
        this.toActiveTmpZones.tail = null;
    }

    protected void resetActiveTmpZones() {
        this.toActiveTmpZones.tail = this.hiddenActiveTmpZones;
        this.hiddenActiveTmpZones = null;
    }

    protected int allocateTmpZone() {
        ++this.toTotalZones.head;
        return this.toTotalZones.head - 1;
    }

    protected void addInHiddenPushPopVariables(ZoneInfo zoneInfo) {
        this.addInHiddenVariables(zoneInfo, this.hiddenPushPopVariables);
    }

    protected void addInHiddenInstrumentedVariables(ZoneInfo zoneInfo) {
        this.addInHiddenVariables(zoneInfo, this.hiddenInstrumentedVariables);
    }

    protected void addInHiddenDiffInitVariables(ZoneInfo zoneInfo) {
        this.addInHiddenVariables(zoneInfo, this.hiddenDiffInitVariables);
    }

    private void addInHiddenVariables(ZoneInfo zoneInfo, TapList<TapPair<Object, TapList<String>>> toHiddenVariables) {
        String rootVarName = null;
        if (zoneInfo.variableNames() != null) {
            rootVarName = (String)zoneInfo.variableNames().head;
        }
        if (rootVarName == null) {
            rootVarName = zoneInfo.description;
        }
        if (rootVarName != null) {
            TapPair place;
            Object key = zoneInfo.declarationUnit;
            if (key == null) {
                key = zoneInfo.commonName;
                place = null;
                TapList inHiddenVariables = toHiddenVariables.tail;
                while (place == null && inHiddenVariables != null) {
                    if (((TapPair)inHiddenVariables.head).first instanceof String && ((String)((TapPair)inHiddenVariables.head).first).equals(key)) {
                        place = (TapPair)inHiddenVariables.head;
                    }
                    inHiddenVariables = inHiddenVariables.tail;
                }
            } else {
                place = TapList.assq(key, toHiddenVariables.tail);
            }
            if (place == null) {
                place = new TapPair<Object, Object>(key, null);
                toHiddenVariables.placdl(place);
            }
            if (!TapList.containsEquals((TapList)place.second, rootVarName)) {
                place.second = new TapList<String>(rootVarName, (TapList)place.second);
            }
        }
    }
}

