/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.differentiation;

import fr.inria.tapenade.analysis.ADActivityAnalyzer;
import fr.inria.tapenade.analysis.ActivityPattern;
import fr.inria.tapenade.analysis.DataFlowAnalyzer;
import fr.inria.tapenade.analysis.ReqExplicit;
import fr.inria.tapenade.differentiation.BlockDifferentiator;
import fr.inria.tapenade.differentiation.DifferentiationEnv;
import fr.inria.tapenade.differentiation.FlowGraphDifferentiator;
import fr.inria.tapenade.differentiation.ProcedureCallDifferentiator;
import fr.inria.tapenade.differentiation.UnitDiffInfo;
import fr.inria.tapenade.differentiation.VarRefDifferentiator;
import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.BasicBlock;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.CallArrow;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.Directive;
import fr.inria.tapenade.representation.EntryBlock;
import fr.inria.tapenade.representation.ExitBlock;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.FunctionTypeSpec;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.InterfaceDecl;
import fr.inria.tapenade.representation.MPIcallInfo;
import fr.inria.tapenade.representation.MemMap;
import fr.inria.tapenade.representation.MixedLanguageInfos;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.PrimitiveTypeSpec;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeDecl;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.UnitStorage;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.VoidTypeSpec;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.Chrono;
import fr.inria.tapenade.utils.Int2ZoneInfo;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.Tree;

public class CallGraphDifferentiator {
    private final DifferentiationEnv adEnv;
    private CallGraph srcCallGraph;
    private CallGraph diffCallGraph;
    private Unit curUnit;
    private Unit curDiffUnit;
    private final UnitStorage<UnitDiffInfo> unitDiffInfos;
    private TapList<TapPair<Unit, UnitDiffInfo>> intrinsicUnitDiffInfos;
    protected UnitStorage<Boolean> unitsHavePrimal;
    protected UnitStorage<Boolean> unitsHaveDiff;
    protected final Chrono unitDiffTimer = new Chrono();

    private FlowGraphDifferentiator flowGraphDifferentiator() {
        return this.adEnv.flowGraphDifferentiator;
    }

    private BlockDifferentiator blockDifferentiator() {
        return this.adEnv.blockDifferentiator;
    }

    private ProcedureCallDifferentiator procedureCallDifferentiator() {
        return this.adEnv.procedureCallDifferentiator;
    }

    private VarRefDifferentiator varRefDifferentiator() {
        return this.adEnv.varRefDifferentiator;
    }

    private boolean multiDirMode() {
        return this.adEnv.multiDirMode;
    }

    private String[][] suffixes() {
        return this.adEnv.suffixes;
    }

    private ADActivityAnalyzer activityAnalyzer() {
        return TapEnv.adActivityAnalyzer();
    }

    private void setCurUnitEtc(Unit unit) {
        this.curUnit = unit;
        TapEnv.setRelatedUnit(unit);
        this.adEnv.setCurUnitEtc(unit);
    }

    private void setCurDiffUnit(Unit diffUnit) {
        this.curDiffUnit = diffUnit;
        this.adEnv.curDiffUnit = diffUnit;
    }

    private int curDiffUnitSort() {
        return this.adEnv.curDiffUnitSort;
    }

    protected CallGraphDifferentiator(DifferentiationEnv adEnv) {
        this.adEnv = adEnv;
        this.unitDiffInfos = new UnitStorage(adEnv.srcCallGraph());
        for (int i = adEnv.srcCallGraph().nbUnits() - 1; i >= 0; --i) {
            Unit unit = adEnv.srcCallGraph().sortedUnit(i);
            assert (unit != null);
            this.unitDiffInfos.store(unit, new UnitDiffInfo(unit, adEnv));
        }
        TapList<Unit> intrinsicUnits = adEnv.srcCallGraph().intrinsicUnits();
        while (intrinsicUnits != null) {
            this.intrinsicUnitDiffInfos = new TapList<TapPair<Unit, UnitDiffInfo>>(new TapPair(intrinsicUnits.head, new UnitDiffInfo((Unit)intrinsicUnits.head, adEnv)), this.intrinsicUnitDiffInfos);
            intrinsicUnits = intrinsicUnits.tail;
        }
    }

    public static CallGraph run(CallGraph origCallGraph, TapList<Unit> rootUnits, String[][] suffixes) {
        DifferentiationEnv newAdEnv = new DifferentiationEnv(origCallGraph, suffixes);
        newAdEnv.callGraphDifferentiator.differentiateDownFrom(rootUnits);
        return newAdEnv.diffCallGraph();
    }

    private void differentiateDownFrom(TapList<Unit> rootUnits) {
        int i;
        TapList<Unit> diffUnits;
        UnitDiffInfo diffInfo;
        int i2;
        TapList<ActivityPattern> activityPatterns;
        Chrono diffTimer = new Chrono();
        TapList<Unit> calledPrimalFormUnits = null;
        this.srcCallGraph = this.adEnv.srcCallGraph();
        for (int i3 = this.srcCallGraph.nbUnits() - 1; i3 >= 0; --i3) {
            this.setCurUnitEtc(this.srcCallGraph.sortedUnit(i3));
            activityPatterns = this.curUnit.activityPatterns;
            while (activityPatterns != null) {
                this.adEnv.setCurActivity((ActivityPattern)activityPatterns.head);
                this.computeCommonActivities(this.adEnv.curActivity());
                if (!this.curUnit.hasSource()) {
                    BoolVector unitCallActive = this.adEnv.curActivity().callActivity();
                    BoolVector unitExitActive = this.adEnv.curActivity().exitActivity();
                    if (unitCallActive != null && unitExitActive != null) {
                        this.augmentExternalEntryExitActivities(unitCallActive, unitExitActive);
                    }
                }
                activityPatterns = activityPatterns.tail;
            }
            if (!this.curUnit.isModule()) continue;
            this.computeModuleCommonActivities(this.curUnit);
        }
        this.adEnv.setCurActivity(null);
        this.setCurUnitEtc(null);
        boolean codeContainsSomethingActive = false;
        TapList<Unit> orderedUnitsRootSTFirst = this.srcCallGraph.buildSortedUnitsList(0, -1, 1);
        this.diffCallGraph = new CallGraph("Differentiation of " + this.srcCallGraph.name() + " under " + rootUnits);
        this.adEnv.setDiffCallGraph(this.diffCallGraph);
        this.diffCallGraph.createRootSymbolTables();
        this.adEnv.setDiffCallGraphAndRootUnits(this.diffCallGraph, rootUnits);
        this.diffCallGraph.usedCommonNames = this.srcCallGraph.usedCommonNames;
        this.diffCallGraph.setBindFortranCType(this.srcCallGraph.bindFortranCType());
        this.diffCallGraph.zoneNbOfNullDest = this.srcCallGraph.zoneNbOfNullDest;
        this.diffCallGraph.zoneNbOfUnknownDest = this.srcCallGraph.zoneNbOfUnknownDest;
        this.diffCallGraph.zoneNbOfAllIOStreams = this.srcCallGraph.zoneNbOfAllIOStreams;
        for (i2 = this.srcCallGraph.nbUnits() - 1; i2 >= 0; --i2) {
            this.setCurUnitEtc(this.srcCallGraph.sortedUnit(i2));
            if (this.curUnit == null || this.curUnit.rank() < 0 || this.curUnit.isModule()) continue;
            activityPatterns = this.curUnit.activityPatterns;
            while (activityPatterns != null) {
                this.adEnv.setCurActivity((ActivityPattern)activityPatterns.head);
                this.annotateActiveCallArgumentsInCurUnit(this.adEnv.curActivity());
                activityPatterns = activityPatterns.tail;
            }
        }
        for (i2 = this.srcCallGraph.nbUnits() - 1; i2 >= 0; --i2) {
            this.setCurUnitEtc(this.srcCallGraph.sortedUnit(i2));
            if (this.curUnit == null || this.curUnit.rank() < 0 || this.curUnit.isModule()) continue;
            activityPatterns = this.curUnit.activityPatterns;
            if ((this.adEnv.traceCurDifferentiation || TapEnv.traceActivity() != null) && activityPatterns != null) {
                TapEnv.printlnOnTrace(" Precompute formalArgsActivity for each activityPattern of Unit " + this.curUnit + ':' + this.curUnit.headTree());
            }
            UnitDiffInfo diffInfo2 = this.getUnitDiffInfo(this.curUnit);
            while (activityPatterns != null) {
                this.adEnv.setCurActivity((ActivityPattern)activityPatterns.head);
                boolean[] formalArgsActivity = ADActivityAnalyzer.formalArgsActivity(this.adEnv.curActivity());
                diffInfo2.setUnitFormalArgsActivityS(this.adEnv.curActivity(), formalArgsActivity);
                if (this.adEnv.traceCurDifferentiation || TapEnv.traceActivity() != null) {
                    TapEnv.printOnTrace(" - wrt activity " + this.adEnv.curActivity() + ", formalArgsActivity is ");
                    if (formalArgsActivity == null) {
                        TapEnv.printOnTrace("null");
                    } else {
                        TapEnv.printOnTrace("[");
                        int nbArgs = Math.min(this.curUnit.formalArgumentsNb(), formalArgsActivity.length - 1);
                        for (int j = 0; j < formalArgsActivity.length; ++j) {
                            if (formalArgsActivity.length == 1) {
                                TapEnv.printOnTrace("->");
                            }
                            TapEnv.printOnTrace("" + formalArgsActivity[j]);
                            if (j + 1 >= formalArgsActivity.length) continue;
                            TapEnv.printOnTrace(j + 1 == nbArgs ? "->" : ", ");
                        }
                        TapEnv.printlnOnTrace("]");
                    }
                }
                if (TapEnv.doActivity() && (this.adEnv.curActivity().isActive() || this.adEnv.curActivity().isContext() && this.curUnit == this.srcCallGraph.getMainUnit())) {
                    calledPrimalFormUnits = this.collectAllCalledPrimal(this.adEnv.curActivity(), calledPrimalFormUnits);
                }
                activityPatterns = activityPatterns.tail;
            }
        }
        this.adEnv.setCurActivity(null);
        this.adEnv.setCurSymbolTable(null);
        this.adEnv.setCurInstruction(null);
        this.setCurUnitEtc(null);
        if (TapEnv.doActivity() && calledPrimalFormUnits != null) {
            calledPrimalFormUnits = Unit.allCalleesMulti(calledPrimalFormUnits);
        }
        TapList<Unit> userUnitsRootSTLast = null;
        TapList<Unit> units = orderedUnitsRootSTFirst;
        while (units != null) {
            Unit userUnit = (Unit)units.head;
            if (!userUnit.isOutside()) {
                userUnitsRootSTLast = new TapList<Unit>(userUnit, userUnitsRootSTLast);
            }
            units = units.tail;
        }
        this.futureUnitsDecision(userUnitsRootSTLast, calledPrimalFormUnits);
        TapList<Unit> inRootUnits = rootUnits;
        while (inRootUnits != null) {
            Unit rootUnit = (Unit)inRootUnits.head;
            if (!rootUnit.mustDifferentiateSplit() && !rootUnit.mustDifferentiateJoint()) {
                rootUnit.maybeCheckpointed = true;
            }
            inRootUnits = inRootUnits.tail;
        }
        for (int i4 = this.srcCallGraph.nbUnits() - 1; i4 >= 0; --i4) {
            BoolVector unitPublicZonesUsed;
            BoolVector unitPublicZonesWritten;
            BoolVector unitPublicZonesRead;
            boolean unitHasInOut;
            this.setCurUnitEtc(this.srcCallGraph.sortedUnit(i4));
            boolean bl = unitHasInOut = this.curUnit.unitInOutR() != null;
            if (unitHasInOut) {
                unitPublicZonesRead = this.curUnit.getTmpALLKINDPossiblyR();
                unitPublicZonesWritten = this.curUnit.getTmpALLKINDPossiblyW();
                unitPublicZonesUsed = unitPublicZonesRead.or(unitPublicZonesWritten);
            } else {
                unitPublicZonesWritten = new BoolVector(this.curUnit.paramElemsNb());
                unitPublicZonesWritten.setTrue();
                unitPublicZonesUsed = new BoolVector(this.curUnit.paramElemsNb());
                unitPublicZonesUsed.setTrue();
                unitPublicZonesRead = null;
            }
            diffInfo = this.getUnitDiffInfo(this.curUnit);
            activityPatterns = this.curUnit.activityPatterns;
            while (activityPatterns != null) {
                this.adEnv.setCurActivity((ActivityPattern)activityPatterns.head);
                if (this.activityAnalyzer().isActiveUnit(this.adEnv.curActivity()) || !TapEnv.doActivity()) {
                    BoolVector unitPublicZonesWithDiff = this.adEnv.curActivity().callActivity().or(this.adEnv.curActivity().exitActivity());
                    if (unitHasInOut && this.adEnv.curActivity().entryReqX() != null) {
                        unitPublicZonesWithDiff.cumulOr(this.adEnv.curActivity().entryReqX().and(unitPublicZonesRead));
                        unitPublicZonesWithDiff.cumulOr(this.adEnv.curActivity().entryAvlX().or(this.adEnv.curActivity().exitReqX()).and(unitPublicZonesWritten));
                    }
                    int nbFormalArgs = this.curUnit.functionTypeSpec().argumentsTypes != null ? 1 + this.curUnit.functionTypeSpec().argumentsTypes.length : 1;
                    BoolVector publicUsefulnessOnCallingSide = this.curUnit.isStandard() ? this.adEnv.curActivity().usefulOnCallingSide() : null;
                    boolean[] diffArgsByValueNeedOverwrite = new boolean[nbFormalArgs];
                    boolean[] diffArgsByValueNeedOnlyIncrement = new boolean[nbFormalArgs];
                    for (int j = nbFormalArgs - 1; j >= 0; --j) {
                        diffArgsByValueNeedOverwrite[j] = false;
                        diffArgsByValueNeedOnlyIncrement[j] = true;
                        if (j != 0 && !this.curUnit.takesArgumentByValue(j, this.curUnit.language())) continue;
                        this.fillPassByValueInfos(this.curUnit.argsPublicRankTrees[j], j, this.curUnit, unitPublicZonesUsed, unitPublicZonesWritten, unitPublicZonesWithDiff, publicUsefulnessOnCallingSide, diffArgsByValueNeedOverwrite, diffArgsByValueNeedOnlyIncrement);
                    }
                    diffInfo.setUnitDiffArgsByValueNeedOverwriteInfoS(this.adEnv.curActivity(), diffArgsByValueNeedOverwrite);
                    diffInfo.setUnitDiffArgsByValueNeedOnlyIncrementInfoS(this.adEnv.curActivity(), diffArgsByValueNeedOnlyIncrement);
                }
                activityPatterns = activityPatterns.tail;
            }
        }
        this.adEnv.setCurActivity(null);
        this.setCurUnitEtc(null);
        this.diffCallGraph.topBlock = new BasicBlock(this.diffCallGraph.globalRootSymbolTable(), null, null);
        this.diffCallGraph.topBlock.copyInstructions(this.srcCallGraph.topBlock, this.adEnv.copiedIncludes);
        if (this.srcCallGraph.nbUnits() > 0) {
            Unit topUnit = this.srcCallGraph.sortedUnit(0);
            assert (topUnit != null);
            if (!topUnit.isFortran()) {
                this.diffCallGraph.topPreComments = this.srcCallGraph.topPreComments == null ? null : this.srcCallGraph.topPreComments.copy();
                this.diffCallGraph.topPostComments = this.srcCallGraph.topPostComments == null ? null : this.srcCallGraph.topPostComments.copy();
                this.diffCallGraph.topPreCommentsBlock = this.srcCallGraph.topPreCommentsBlock == null ? null : this.srcCallGraph.topPreCommentsBlock.copy();
                Tree tree = this.diffCallGraph.topPostCommentsBlock = this.srcCallGraph.topPostCommentsBlock == null ? null : this.srcCallGraph.topPostCommentsBlock.copy();
            }
        }
        int packageDiffSort = TapEnv.mustTangent() ? 1 : (TapEnv.mustAdjoint() ? 2 : 0);
        units = orderedUnitsRootSTFirst;
        while (units != null) {
            this.setCurUnitEtc((Unit)units.head);
            diffInfo = this.getUnitDiffInfo(this.curUnit);
            if (this.curUnit.isPackage() && !this.curUnit.isUndefined()) {
                Unit enclosingUnit = this.curUnit.upperLevelUnit();
                Unit diffEnclosingUnitOfDiff = null;
                if (enclosingUnit != null) {
                    diffEnclosingUnitOfDiff = this.getUnitDiffInfo(enclosingUnit).getDiff();
                }
                Unit diffPackage = this.curUnit.copyUnitExceptSymbolTables(this.diffCallGraph, diffEnclosingUnitOfDiff, null);
                this.initializeDiffUnit(diffPackage, this.curUnit, packageDiffSort, -1);
                if (this.adEnv.traceCurDifferentiation || TapEnv.traceActivity() != null) {
                    TapEnv.printlnOnTrace(" =Prepared diff package for " + this.curUnit + " => " + diffPackage + ", contained in " + diffPackage.upperLevelUnit());
                }
                diffInfo.setDiff(diffPackage);
                if (this.curUnit.isPredefinedModuleOrTranslationUnit()) {
                    diffPackage.setName(this.curUnit.name());
                    diffPackage.setPredefinedModuleOrTranslationUnit();
                } else if (this.unitsHaveDiff.retrieve(this.curUnit) == Boolean.FALSE && this.unitsHavePrimal.retrieve(this.curUnit) == Boolean.FALSE) {
                    diffPackage.setName(this.curUnit.name());
                    diffPackage.setIsDiffPackage(!TapEnv.get().stripPrimalModules);
                } else {
                    diffPackage.setIsDiffPackage(true);
                }
                if (this.adEnv.traceCurDifferentiation) {
                    TapEnv.printlnOnTrace(" ---> " + this.curUnit + " => " + diffPackage + " isDiffPackage?:" + diffPackage.isDiffPackage());
                }
            }
            units = units.tail;
        }
        units = orderedUnitsRootSTFirst;
        while (units != null) {
            this.setCurUnitEtc((Unit)units.head);
            diffInfo = this.getUnitDiffInfo(this.curUnit);
            if (!this.curUnit.isPackage() && this.unitsHavePrimal.retrieve(this.curUnit) == Boolean.TRUE) {
                TapList<Unit> diffsOfContainer;
                Unit principalDiffContainer;
                Unit container = this.curUnit.upperLevelUnit();
                Unit containerOfInterface = this.curUnit.enclosingUnitOfInterface;
                Unit unit = container == null ? null : (principalDiffContainer = container.isPackage() ? this.getUnitDiffInfo(container).getDiff() : diffInfo.getAnyContainingDiffUnit(this.curUnit, container));
                Unit principalDiffInterface = containerOfInterface == null ? null : (containerOfInterface.isPackage() ? this.getUnitDiffInfo(containerOfInterface).getDiff() : diffInfo.getAnyContainingDiffUnit(this.curUnit, containerOfInterface));
                Unit copiedUnit = this.curUnit.copyUnitExceptSymbolTables(this.diffCallGraph, principalDiffContainer, principalDiffInterface);
                copiedUnit.origUnit = this.curUnit;
                copiedUnit.setKind(this.curUnit);
                copiedUnit.sortOfDiffUnit = 0;
                int n = copiedUnit.arrayDimMin = this.curUnit.isFortran() ? 1 : 0;
                if (this.adEnv.traceCurDifferentiation || TapEnv.traceActivity() != null) {
                    TapEnv.printlnOnTrace(" =Prepared copied unit for " + this.curUnit + " => " + copiedUnit + ", contained in " + copiedUnit.upperLevelUnit());
                }
                this.adEnv.copiedUnits.store(this.curUnit, copiedUnit);
                this.adEnv.copiedUnitsBack.store(copiedUnit, this.curUnit);
                TapList<Unit> tapList = diffsOfContainer = container == null ? null : this.getUnitDiffInfo(container).getAllDiffsPlusCopy();
                while (diffsOfContainer != null) {
                    Unit diffContainer = (Unit)diffsOfContainer.head;
                    if (diffContainer != principalDiffContainer) {
                        diffContainer.addLowerLevelUnit(copiedUnit);
                        CallGraph.addCallArrow(diffContainer, 3, copiedUnit);
                    }
                    diffsOfContainer = diffsOfContainer.tail;
                }
            } else {
                this.curUnit.origUnit = this.curUnit;
            }
            if (this.curUnit.isProcedure() || this.curUnit.isVarFunction() || this.curUnit.isInterface()) {
                activityPatterns = this.curUnit.activityPatterns;
                if (activityPatterns == null && this.unitsHaveDiff.retrieve(this.curUnit) == Boolean.TRUE) {
                    ActivityPattern dummyActivityPattern = new ActivityPattern(this.curUnit, true, false, this.adEnv.diffKind);
                    int nbArgs = this.curUnit.functionTypeSpec().argumentsTypes.length;
                    boolean[] allFalseActivity = new boolean[nbArgs + 1];
                    for (int i5 = nbArgs; i5 >= 0; --i5) {
                        allFalseActivity[i5] = false;
                    }
                    diffInfo.setUnitFormalArgsActivityS(dummyActivityPattern, allFalseActivity);
                    activityPatterns = this.curUnit.activityPatterns = new TapList<ActivityPattern>(dummyActivityPattern, null);
                }
                while (activityPatterns != null) {
                    this.adEnv.setCurActivity((ActivityPattern)activityPatterns.head);
                    if (this.patternCreatesDiffCode(this.adEnv.curActivity(), this.curUnit)) {
                        this.createDiffUnits(this.curUnit, this.adEnv.curActivity());
                        codeContainsSomethingActive = true;
                    }
                    activityPatterns = activityPatterns.tail;
                }
                this.adEnv.setCurActivity(null);
            }
            units = units.tail;
        }
        TapList<Unit> intrinsicUnits = this.srcCallGraph.intrinsicUnits();
        while (intrinsicUnits != null) {
            Unit intrinsicUnit = (Unit)intrinsicUnits.head;
            if (!intrinsicUnit.hasPredefinedDerivatives()) {
                this.setCurUnitEtc(intrinsicUnit);
                activityPatterns = this.curUnit.activityPatterns;
                while (activityPatterns != null) {
                    if (this.patternCreatesDiffCode((ActivityPattern)activityPatterns.head, this.curUnit)) {
                        this.createDiffUnits(this.curUnit, (ActivityPattern)activityPatterns.head);
                    }
                    activityPatterns = activityPatterns.tail;
                }
            }
            intrinsicUnits = intrinsicUnits.tail;
        }
        units = this.srcCallGraph.units();
        while (units != null) {
            this.setCurUnitEtc((Unit)units.head);
            if (this.curUnit.rank() >= 0) {
                Unit diffDestUnit;
                Unit destUnit;
                CallArrow origCallArrow;
                TapList<CallArrow> arrows;
                UnitDiffInfo origDiffInfo = this.getUnitDiffInfo(this.curUnit);
                diffUnits = origDiffInfo.getAllDiffsPlusCopy();
                while (diffUnits != null) {
                    this.setCurDiffUnit((Unit)diffUnits.head);
                    boolean diffOrigIsCopy = this.curDiffUnit == this.adEnv.getPrimalCopyOfOrigUnit(this.curUnit);
                    arrows = this.curUnit.callees();
                    while (arrows != null) {
                        origCallArrow = (CallArrow)arrows.head;
                        destUnit = origCallArrow.destination;
                        if ((origCallArrow.isImport() || origCallArrow.isContain()) && destUnit.rank() >= 0) {
                            UnitDiffInfo destDiffInfo = this.getUnitDiffInfo(destUnit);
                            TapList<Unit> destDiffUnits = destDiffInfo.getAllDiffsPlusCopy();
                            while (destDiffUnits != null) {
                                boolean diffDestIsCopy;
                                diffDestUnit = (Unit)destDiffUnits.head;
                                boolean bl = diffDestIsCopy = diffDestUnit == this.adEnv.getPrimalCopyOfOrigUnit(destUnit);
                                if (!diffOrigIsCopy || diffDestIsCopy || origCallArrow.isImport()) {
                                    CallArrow newCallArrow = CallGraph.addCallArrow(this.curDiffUnit, -1, diffDestUnit);
                                    if (origCallArrow.isImport()) {
                                        newCallArrow.setImport(true);
                                    }
                                    if (origCallArrow.isContain()) {
                                        newCallArrow.setContain(true);
                                    }
                                }
                                destDiffUnits = destDiffUnits.tail;
                            }
                        }
                        arrows = arrows.tail;
                    }
                    diffUnits = diffUnits.tail;
                }
                this.setCurDiffUnit(this.adEnv.getPrimalCopyOfOrigUnit(this.curUnit));
                if (this.curDiffUnit != null) {
                    arrows = this.curUnit.callees();
                    while (arrows != null) {
                        origCallArrow = (CallArrow)arrows.head;
                        destUnit = origCallArrow.destination;
                        if (origCallArrow.isCall() && destUnit.rank() >= 0) {
                            diffDestUnit = this.adEnv.getPrimalCopyOfOrigUnit(destUnit);
                            if (diffDestUnit == null) {
                                diffDestUnit = destUnit;
                            }
                            CallGraph.addCallArrow(this.curDiffUnit, 1, diffDestUnit);
                        }
                        arrows = arrows.tail;
                    }
                }
            }
            units = units.tail;
        }
        TapList<Object> rootAssociationsST = new TapList<Object>(null, null);
        this.diffCallGraph.setGlobalRootSymbolTable(this.srcCallGraph.globalRootSymbolTable().smartCopy(rootAssociationsST, this.diffCallGraph, this.diffCallGraph, this.adEnv.copiedUnits, "Diff of "));
        this.diffCallGraph.topBlock.symbolTable = this.diffCallGraph.globalRootSymbolTable();
        this.diffCallGraph.globalRootSymbolTable().declarationsBlock = this.diffCallGraph.topBlock;
        this.diffCallGraph.setFortranRootSymbolTable(this.srcCallGraph.fortranRootSymbolTable().smartCopy(rootAssociationsST, this.diffCallGraph, this.diffCallGraph, this.adEnv.copiedUnits, "Diff of "));
        this.diffCallGraph.fortranRootSymbolTable().declarationsBlock = new BasicBlock(this.diffCallGraph.fortranRootSymbolTable(), null, null);
        this.diffCallGraph.fortranRootSymbolTable().declarationsBlock.copyInstructions(this.srcCallGraph.fortranRootSymbolTable().declarationsBlock, this.adEnv.copiedIncludes);
        this.diffCallGraph.setCRootSymbolTable(this.srcCallGraph.cRootSymbolTable().smartCopy(rootAssociationsST, this.diffCallGraph, this.diffCallGraph, this.adEnv.copiedUnits, "Diff of "));
        this.diffCallGraph.cRootSymbolTable().declarationsBlock = new BasicBlock(this.diffCallGraph.cRootSymbolTable(), null, null);
        this.diffCallGraph.cRootSymbolTable().declarationsBlock.copyInstructions(this.srcCallGraph.cRootSymbolTable().declarationsBlock, this.adEnv.copiedIncludes);
        this.diffCallGraph.setCudaRootSymbolTable(this.srcCallGraph.cudaRootSymbolTable().smartCopy(rootAssociationsST, this.diffCallGraph, this.diffCallGraph, this.adEnv.copiedUnits, "Diff of "));
        this.diffCallGraph.cudaRootSymbolTable().declarationsBlock = new BasicBlock(this.diffCallGraph.cudaRootSymbolTable(), null, null);
        this.diffCallGraph.cudaRootSymbolTable().declarationsBlock.copyInstructions(this.srcCallGraph.cudaRootSymbolTable().declarationsBlock, this.adEnv.copiedIncludes);
        this.diffCallGraph.setCPlusPlusRootSymbolTable(this.srcCallGraph.cPlusPlusRootSymbolTable().smartCopy(rootAssociationsST, this.diffCallGraph, this.diffCallGraph, this.adEnv.copiedUnits, "Diff of "));
        this.diffCallGraph.cPlusPlusRootSymbolTable().declarationsBlock = new BasicBlock(this.diffCallGraph.cPlusPlusRootSymbolTable(), null, null);
        this.diffCallGraph.cPlusPlusRootSymbolTable().declarationsBlock.copyInstructions(this.srcCallGraph.cPlusPlusRootSymbolTable().declarationsBlock, this.adEnv.copiedIncludes);
        TapList<Unit> topUnits = this.srcCallGraph.topUnits();
        while (topUnits != null) {
            Unit topUnit = (Unit)topUnits.head;
            if (topUnit.isTranslationUnit()) {
                this.setCurUnitEtc(topUnit);
                SymbolTable tuST = topUnit.publicSymbolTable();
                SymbolTable diffTUST = tuST.smartCopy(rootAssociationsST, this.getUnitDiffInfo(topUnit).getDiff(), this.diffCallGraph, this.adEnv.copiedUnits, "Diff of ");
                if (this.adEnv.traceCurDifferentiation) {
                    TapEnv.printlnOnTrace("   TrUnit:" + tuST);
                    TapEnv.printlnOnTrace("   ---->> diff TrUnit:" + diffTUST);
                }
                diffTUST.containerFileName = tuST.containerFileName + TapEnv.get().diffFileSuffix;
                diffTUST.isPublic = true;
                diffTUST.setShortName("SymbolTable of Translation Unit (i.e. file) " + diffTUST.containerFileName);
                this.diffCallGraph.addTranslationUnitSymbolTable(diffTUST);
                Unit diffTopUnit = this.getUnitDiffInfo(topUnit).getDiff();
                diffTopUnit.setTranslationUnitSymbolTable(diffTUST);
                diffTopUnit.setPublicSymbolTable(diffTUST);
                diffTopUnit.setOtherName(topUnit);
                topUnit.setOtherName(diffTopUnit);
            }
            topUnits = topUnits.tail;
        }
        if (TapEnv.associationByAddress() && !TapEnv.get().complexStep) {
            boolean needsCaaType = false;
            boolean needsFaaType = false;
            units = this.srcCallGraph.units();
            while (units != null) {
                this.setCurUnitEtc((Unit)units.head);
                if (this.curUnit.rank() >= 0 && this.getUnitDiffInfo(this.curUnit).hasDiffs()) {
                    if (this.curUnit.isC()) {
                        needsCaaType = true;
                    } else if (this.curUnit.isFortran()) {
                        needsFaaType = true;
                    }
                }
                units = units.tail;
            }
            if (needsCaaType) {
                this.createAssocAddressDiffTypesUnit(4);
            }
            if (needsFaaType) {
                this.createAssocAddressDiffTypesUnit(3);
            }
        }
        units = orderedUnitsRootSTFirst;
        while (units != null) {
            this.setCurUnitEtc((Unit)units.head);
            if (this.curUnit.isPackage()) {
                this.setCurDiffUnit(this.getUnitDiffInfo(this.curUnit).getDiff());
                if (this.curDiffUnit != null) {
                    if (this.adEnv.traceCurDifferentiation) {
                        TapEnv.printlnOnTrace("  Creating SymbolTables for diff package " + this.curDiffUnit + " of " + this.curUnit);
                        TapEnv.printlnOnTrace("    given static SymbolTable associations:");
                        SymbolTable.traceShowAssociationsST(rootAssociationsST);
                    }
                    if (this.curUnit.importsSymbolTable() != null) {
                        this.curDiffUnit.setImportsSymbolTable(this.curUnit.importsSymbolTable().smartCopy(rootAssociationsST, this.diffCallGraph, this.diffCallGraph, this.adEnv.copiedUnits, "Diff of "));
                        if (this.adEnv.traceCurDifferentiation) {
                            TapEnv.printlnOnTrace("   import:" + this.curUnit.importsSymbolTable());
                            TapEnv.printlnOnTrace("   ---->> diff import:" + this.curDiffUnit.importsSymbolTable());
                        }
                    }
                    if (this.curUnit.translationUnitSymbolTable() != null) {
                        this.curDiffUnit.setTranslationUnitSymbolTable(this.curUnit.translationUnitSymbolTable().getExistingCopy(rootAssociationsST));
                    }
                    this.createDiffUnitSymbolTables(rootAssociationsST);
                    this.curDiffUnit.orig2copiedBlocks = null;
                    this.curDiffUnit.origPublicSTDeclarationBlock = null;
                    this.curDiffUnit.copyPublicSTDeclarationBlock = null;
                }
            }
            units = units.tail;
        }
        units = orderedUnitsRootSTFirst;
        while (units != null) {
            block168: {
                block166: {
                    block167: {
                        this.setCurUnitEtc((Unit)units.head);
                        if (this.adEnv.traceCurDifferentiation) {
                            TapEnv.printlnOnTrace("  Creating SymbolTables for all diff units of " + this.curUnit);
                        }
                        if (!this.curUnit.isPackage()) break block166;
                        this.setCurDiffUnit(this.getUnitDiffInfo(this.curUnit).getDiff());
                        if (this.curDiffUnit.importsSymbolTable() == null) break block167;
                        this.curDiffUnit.importsSymbolTable().updateImportedFroms(rootAssociationsST);
                        break block168;
                    }
                    if (!this.curUnit.isTranslationUnit() || !this.curUnit.isC()) break block168;
                    this.curDiffUnit.publicSymbolTable().updateImportedFroms(rootAssociationsST);
                    break block168;
                }
                if (this.curUnit.hasSource() || this.curUnit.isInterface()) {
                    SymbolTable importsSymbolTable = this.curUnit.importsSymbolTable();
                    SymbolTable diffImportsSymbolTable = null;
                    SymbolTable contextSymbolTable = importsSymbolTable == null ? this.curUnit.publicSymbolTable().basisSymbolTable() : importsSymbolTable.basisSymbolTable();
                    SymbolTable diffContextSymbolTable = contextSymbolTable.getExistingCopy(rootAssociationsST);
                    UnitDiffInfo diffInfo3 = this.getUnitDiffInfo(this.curUnit);
                    if (diffInfo3.getAllDiffsPlusCopy() != null) {
                        if (diffContextSymbolTable == null) {
                            Unit enclosingUnit = this.curUnit.upperLevelUnit();
                            TapList<Unit> diffEnclosingUnits = this.getUnitDiffInfo(enclosingUnit).getAllDiffs();
                            Unit diffEnclosingUnit = diffEnclosingUnits != null ? (Unit)diffEnclosingUnits.head : this.adEnv.getPrimalCopyOfOrigUnit(enclosingUnit);
                            diffContextSymbolTable = diffEnclosingUnit.privateSymbolTable();
                        }
                        if (importsSymbolTable != null) {
                            TapList<TapPair<SymbolTable, SymbolTable>> contextAssociationsST = new TapList<TapPair<SymbolTable, SymbolTable>>(null, new TapList<TapPair<SymbolTable, SymbolTable>>(new TapPair<SymbolTable, SymbolTable>(contextSymbolTable, diffContextSymbolTable), null));
                            if (this.adEnv.traceCurDifferentiation) {
                                TapEnv.printlnOnTrace("  Creating import SymbolTable for all diff units of " + this.curUnit);
                                TapEnv.printlnOnTrace("    using context SymbolTable association:");
                                SymbolTable.traceShowAssociationsST(contextAssociationsST);
                                TapEnv.printlnOnTrace("   import:" + importsSymbolTable);
                            }
                            diffImportsSymbolTable = importsSymbolTable.smartCopy(contextAssociationsST, this.diffCallGraph, this.diffCallGraph, this.adEnv.copiedUnits, "Diff of ");
                            if (this.adEnv.traceCurDifferentiation) {
                                TapEnv.printlnOnTrace("   ---->> diff import:" + diffImportsSymbolTable);
                            }
                            diffImportsSymbolTable.updateImportedFroms(rootAssociationsST);
                        }
                        diffUnits = diffInfo3.getAllDiffsPlusCopy();
                        while (diffUnits != null) {
                            this.setCurDiffUnit((Unit)diffUnits.head);
                            if (this.curUnit.translationUnitSymbolTable() != null) {
                                this.curDiffUnit.setTranslationUnitSymbolTable(this.curUnit.translationUnitSymbolTable().getExistingCopy(rootAssociationsST));
                            }
                            this.curDiffUnit.setImportsSymbolTable(diffImportsSymbolTable);
                            SymbolTable unitContextSymbolTable = importsSymbolTable != null ? importsSymbolTable : contextSymbolTable;
                            SymbolTable diffUnitContextSymbolTable = diffImportsSymbolTable != null ? diffImportsSymbolTable : diffContextSymbolTable;
                            TapList<TapPair<SymbolTable, SymbolTable>> localRootAssociationsST = new TapList<TapPair<SymbolTable, SymbolTable>>(null, new TapList<TapPair<SymbolTable, SymbolTable>>(new TapPair<SymbolTable, SymbolTable>(unitContextSymbolTable, diffUnitContextSymbolTable), null));
                            if (this.adEnv.traceCurDifferentiation) {
                                TapEnv.printlnOnTrace("  Creating SymbolTables for diff unit " + this.curDiffUnit + " of " + this.curUnit);
                                TapEnv.printlnOnTrace("    keeping local SymbolTable associations:");
                                SymbolTable.traceShowAssociationsST(localRootAssociationsST);
                            }
                            this.createDiffUnitSymbolTables(localRootAssociationsST);
                            if (this.curDiffUnit.privateSymbolTable() != null) {
                                this.curDiffUnit.privateSymbolTable().updateImportedFroms(rootAssociationsST);
                            }
                            this.curDiffUnit.orig2copiedBlocks = null;
                            this.curDiffUnit.origPublicSTDeclarationBlock = null;
                            this.curDiffUnit.copyPublicSTDeclarationBlock = null;
                            if (this.curUnit.isStandard() || this.curUnit.isInterface()) {
                                TapList<SymbolTable> localSymbolTables = this.curUnit.symbolTablesBottomUp();
                                while (localSymbolTables != null) {
                                    ((SymbolTable)localSymbolTables.head).cleanCopySymbolDecls();
                                    localSymbolTables = localSymbolTables.tail;
                                }
                            }
                            diffUnits = diffUnits.tail;
                        }
                    }
                }
            }
            units = units.tail;
        }
        this.diffCallGraph.fortranRootSymbolTable().updateImportedFroms(rootAssociationsST);
        this.diffCallGraph.cRootSymbolTable().updateImportedFroms(rootAssociationsST);
        this.diffCallGraph.globalRootSymbolTable().updateImportedFroms(rootAssociationsST);
        if (TapEnv.inputLanguage() == 4) {
            this.srcCallGraph.cRootSymbolTable().cleanCopySymbolDecls();
        } else if (TapEnv.inputLanguage() != 100) {
            this.srcCallGraph.fortranRootSymbolTable().cleanCopySymbolDecls();
        } else {
            this.srcCallGraph.globalRootSymbolTable().cleanCopySymbolDecls();
            this.srcCallGraph.fortranRootSymbolTable().cleanCopySymbolDecls();
            this.srcCallGraph.cRootSymbolTable().cleanCopySymbolDecls();
        }
        if (this.srcCallGraph.bindFortranCFunctions() != null) {
            this.diffCallGraph.setBindCFortranCFunctions(this.srcCallGraph.bindFortranCFunctions());
        }
        for (int i6 = this.srcCallGraph.nbUnits() - 1; i6 >= 0; --i6) {
            this.setCurUnitEtc(this.srcCallGraph.sortedUnit(i6));
            TapList<SymbolTable> localSymbolTables = this.curUnit.symbolTablesBottomUp();
            while (localSymbolTables != null) {
                ((SymbolTable)localSymbolTables.head).cleanCopySymbolDecls();
                localSymbolTables = localSymbolTables.tail;
            }
        }
        this.setCurUnitEtc(null);
        if (!codeContainsSomethingActive) {
            String rootNames = null;
            inRootUnits = this.adEnv.rootUnits;
            while (inRootUnits != null) {
                rootNames = rootNames == null ? ((Unit)inRootUnits.head).name() : rootNames + ' ' + ((Unit)inRootUnits.head).name();
                inRootUnits = inRootUnits.tail;
            }
            TapEnv.fileWarning(5, -1, "(AD06) Differentiation root procedures (" + rootNames + ") have no active input nor output");
        }
        if (TapEnv.modeIsOverloading()) {
            CallGraphDifferentiator.solveNewSymbolHoldersOfUnits(this.diffCallGraph.topUnits(), this.adEnv.emptyCopiedUnitSuffix);
            this.blockDifferentiator().differentiateDeclarationsOfBlock(this.diffCallGraph.topBlock, 1, null, this.srcCallGraph.cRootSymbolTable(), this.diffCallGraph.cRootSymbolTable(), 4, false);
            CallGraphDifferentiator.solveNewSymbolHoldersOfCallGraphTop(this.diffCallGraph, this.adEnv.emptyCopiedUnitSuffix);
        }
        if (this.multiDirMode()) {
            this.initializeMultiDirNumberMax(this.diffCallGraph.globalRootSymbolTable());
        }
        for (int i7 = this.srcCallGraph.nbUnits() - 1; i7 >= 0; --i7) {
            this.setCurUnitEtc(this.srcCallGraph.sortedUnit(i7));
            if (!this.curUnit.isStandard() && !this.curUnit.isVarFunction() && !this.curUnit.isInterface() && !this.curUnit.isOutside()) continue;
            this.buildFunctionTypeSpecOfDiffUnitsOfCurUnit();
            if (!TapEnv.associationByAddress() || !this.curUnit.isStandard()) continue;
            this.buildFunctionTypeSpecOfCopyUnit();
        }
        TapList<Unit> intrinsicUnits2 = this.srcCallGraph.intrinsicUnits();
        while (intrinsicUnits2 != null) {
            Unit intrinsicUnit = (Unit)intrinsicUnits2.head;
            if (!intrinsicUnit.hasPredefinedDerivatives()) {
                this.setCurUnitEtc(intrinsicUnit);
                this.buildFunctionTypeSpecOfDiffUnitsOfCurUnit();
            }
            intrinsicUnits2 = intrinsicUnits2.tail;
        }
        this.adEnv.setCurActivity(null);
        for (i = this.srcCallGraph.nbUnits() - 1; i >= 0; --i) {
            this.setCurUnitEtc(this.srcCallGraph.sortedUnit(i));
            if (this.curUnit.isPackage()) continue;
            Unit copiedUnit = this.adEnv.getPrimalCopyOfOrigUnit(this.curUnit);
            if (copiedUnit != null) {
                TapList<Instruction> origNonFlow = this.curUnit.nonFlowInstructions;
                while (origNonFlow != null) {
                    Unit copySubUnit;
                    UnitDiffInfo subUnitDiffInfo;
                    Unit definedSrcUnit = (Unit)((Instruction)origNonFlow.head).tree.getAnnotation("Unit");
                    if (definedSrcUnit != null && (subUnitDiffInfo = this.getUnitDiffInfo(definedSrcUnit)) != null && (copySubUnit = subUnitDiffInfo.getCopyForDiff()) != null) {
                        copiedUnit.nonFlowInstructions = TapList.addLast(copiedUnit.nonFlowInstructions, Instruction.createUnitDefinitionStub(copySubUnit, null));
                    }
                    origNonFlow = origNonFlow.tail;
                }
                TapList<Block> blocks = copiedUnit.allBlocks();
                while (blocks != null) {
                    Block block = (Block)blocks.head;
                    TapList<Instruction> instructions = block.instructions;
                    while (instructions != null) {
                        Unit copySubUnit;
                        UnitDiffInfo subUnitDiffInfo;
                        Instruction instr = (Instruction)instructions.head;
                        Unit definedSrcUnit = instr.isUnitDefinitionStub();
                        if (definedSrcUnit != null && (subUnitDiffInfo = this.getUnitDiffInfo(definedSrcUnit)) != null && (copySubUnit = subUnitDiffInfo.getCopyForDiff()) != null) {
                            instr.updateUnitDefinitionStub(copySubUnit);
                        }
                        instructions = instructions.tail;
                    }
                    blocks = blocks.tail;
                }
            }
            if (this.curUnit.isStandard() && TapEnv.debugAdMode() != 0) {
                this.placeDebugMidPointIfNone(this.curUnit);
            }
            activityPatterns = this.curUnit.activityPatterns;
            while (activityPatterns != null) {
                this.adEnv.setCurActivity((ActivityPattern)activityPatterns.head);
                this.adEnv.curUnitIsActiveUnit = this.patternCreatesDiffCode(this.adEnv.curActivity(), this.curUnit);
                this.adEnv.curUnitIsContext = this.adEnv.curActivity().isContext();
                if (this.curUnit.isInterface() || this.unitsHaveDiff.retrieve(this.curUnit) == Boolean.TRUE) {
                    if (this.curUnit.isStandard()) {
                        if (this.patternCreatesDiffCode(this.adEnv.curActivity(), this.curUnit)) {
                            this.flowGraphDifferentiator().differentiateProcedure();
                        }
                    } else if (!this.curUnit.isExternal()) {
                        if (this.curUnit.isVarFunction()) {
                            this.differentiateVarFunctionUnit(this.adEnv.curActivity());
                        } else if (this.curUnit.isInterface()) {
                            if (codeContainsSomethingActive) {
                                this.differentiateInterface();
                            }
                        } else {
                            TapEnv.fileWarning(15, null, "Unit not differentiated: " + this.curUnit);
                        }
                    }
                }
                activityPatterns = activityPatterns.tail;
            }
            this.adEnv.setCurActivity(null);
            this.adEnv.curUnitIsActiveUnit = false;
            this.adEnv.curUnitIsContext = false;
        }
        for (i = this.srcCallGraph.nbUnits() - 1; i >= 0; --i) {
            this.setCurUnitEtc(this.srcCallGraph.sortedUnit(i));
            if (!this.curUnit.isPackage()) continue;
            this.differentiatePackage(this.curUnit, rootAssociationsST);
        }
        this.setCurDiffUnit(null);
        this.setCurUnitEtc(null);
        if (TapEnv.get().oldContext) {
            this.differentiateAllocateInCopiedUnits();
        }
        if (!TapEnv.modeIsOverloading()) {
            CallGraphDifferentiator.solveNewSymbolHoldersOfUnits(this.diffCallGraph.topUnits(), this.adEnv.emptyCopiedUnitSuffix);
            int topBlockMode = TapEnv.mustTangent() ? 1 : (TapEnv.mustAdjoint() ? 2 : 0);
            this.adEnv.pushCurDiffSorts(topBlockMode, topBlockMode);
            if (this.diffCallGraph.topBlock != null && TapList.length(this.diffCallGraph.topBlock.instructions) != 0) {
                if (this.adEnv.traceCurDifferentiation) {
                    TapEnv.printlnOnTrace("");
                    TapEnv.printlnOnTrace("*** NOW Differentiating declarations of " + this.srcCallGraph.cRootSymbolTable().shortName());
                }
                TapEnv.setRelatedLanguage(4);
                this.blockDifferentiator().differentiateDeclarationsOfBlock(this.diffCallGraph.topBlock, topBlockMode, null, this.srcCallGraph.cRootSymbolTable(), this.diffCallGraph.cRootSymbolTable(), 4, false);
                TapEnv.setRelatedLanguage(null);
            }
            TapEnv.setRelatedLanguage(null);
            CallGraphDifferentiator.solveNewSymbolHoldersOfCallGraphTop(this.diffCallGraph, this.adEnv.emptyCopiedUnitSuffix);
            if (TapEnv.associationByAddress() && TapEnv.assocAddressDiffTypesUnit(3) != null) {
                TapEnv.assocAddressDiffTypesUnit(3).publicSymbolTable().solveNewSymbolHolders(this.adEnv.emptyCopiedUnitSuffix);
            }
            this.adEnv.popCurDiffSorts();
        }
        units = this.srcCallGraph.units();
        while (units != null) {
            this.setCurUnitEtc((Unit)units.head);
            for (int diffSort = 0; diffSort < 5; ++diffSort) {
                diffUnits = this.getUnitDiffInfo(this.curUnit).getAllDiffs(diffSort);
                if (this.curUnit.isModule()) {
                    Unit diffModule = this.getUnitDiffInfo(this.curUnit).getDiff();
                    diffUnits = new TapList<Unit>(diffModule, null);
                }
                while (diffUnits != null) {
                    Instruction hdInstr;
                    this.setCurDiffUnit((Unit)diffUnits.head);
                    if (this.curDiffUnit.isInterface() && this.curDiffUnit.entryBlock() != null && (hdInstr = this.curDiffUnit.entryBlock().headInstr()) != null && hdInstr.tree != null) {
                        this.curDiffUnit.setName(ILUtils.getCallFunctionNameString(hdInstr.tree));
                    }
                    if (this.curUnit.otherName() == null || this.curUnit.otherName().equals(this.curUnit)) {
                        this.curUnit.setOtherName(this.curDiffUnit);
                    }
                    this.curDiffUnit.setOtherName(this.curUnit);
                    if (this.curDiffUnit.isStandard() || this.curDiffUnit.isInterface()) {
                        if (diffSort == 0) {
                            this.updateModulesAndCopiedUnitsInCopiedUnit(this.curDiffUnit.privateSymbolTable());
                            this.updateModulesAndCopiedUnitsInCopiedUnit(this.curDiffUnit.publicSymbolTable());
                        }
                        this.updateRenamedTypeDecl(this.curDiffUnit);
                    }
                    this.flowGraphDifferentiator().differentiateSaveList(this.curDiffUnit.privateSymbolTable());
                    CallGraphDifferentiator.solveNewSymbolHoldersOfUnit(this.curDiffUnit, this.adEnv.emptyCopiedUnitSuffix);
                    diffUnits = diffUnits.tail;
                }
            }
            units = units.tail;
        }
        this.setCurDiffUnit(null);
        this.setCurUnitEtc(null);
        CallGraphDifferentiator.solveNewSymbolHoldersOfUnits(this.diffCallGraph.topUnits(), this.adEnv.emptyCopiedUnitSuffix);
        CallGraphDifferentiator.solveNewSymbolHoldersOfCallGraphTop(this.diffCallGraph, this.adEnv.emptyCopiedUnitSuffix);
        this.setCurUnitEtc(null);
        topUnits = this.diffCallGraph.topUnits();
        while (topUnits != null) {
            Unit topUnit = (Unit)topUnits.head;
            if (topUnit.isTranslationUnit() && topUnit.isC() && topUnit.allBlocks() != null) {
                Block topBlock = (Block)topUnit.allBlocks().head;
                if (TapEnv.debugAdMode() != 0) {
                    topBlock.addInstructionAt(ILUtils.build(101, "<adDebug.h>"), 0);
                } else if (TapEnv.mustContext()) {
                    topBlock.addInstructionAt(ILUtils.build(101, "<adContext.h>"), 0);
                }
                TapList<String> newDiffCIncludes = topUnit.newDiffCIncludes;
                while (newDiffCIncludes != null) {
                    topBlock.addInstructionAt(ILUtils.build(101, "<" + (String)newDiffCIncludes.head + ">"), 0);
                    newDiffCIncludes = newDiffCIncludes.tail;
                }
                if (this.adEnv.usesADMM) {
                    topBlock.addInstructionAt(ILUtils.build(101, "<admm.h>"), 0);
                }
                if (TapEnv.mustAdjoint()) {
                    topBlock.addInstructionAt(ILUtils.build(101, "<adStack.h>"), 0);
                }
                if (TapEnv.associationByAddress() && !"AATypes.h".equals(topUnit.name())) {
                    String aaTypesUnitName = "AATypes" + TapEnv.get().diffFileSuffix + ".c";
                    topBlock.addInstructionAt(ILUtils.build(101, "\"" + aaTypesUnitName + "\""), 0);
                }
            }
            topUnits = topUnits.tail;
        }
        this.updateCopiedUnits(false);
        this.updateCopiedUnits(true);
        if (TapEnv.associationByAddress()) {
            this.updateAAInCopiedUnits();
        }
        units = this.srcCallGraph.units();
        while (units != null) {
            this.setCurUnitEtc((Unit)units.head);
            diffUnits = this.getUnitDiffInfo(this.curUnit).getAllDiffsPlusCopy();
            while (diffUnits != null) {
                this.setCurDiffUnit((Unit)diffUnits.head);
                if (this.curUnit.publicSymbolTable() != null && this.curDiffUnit.publicSymbolTable() != null) {
                    this.updateCopiedInterfaceAndExternalDecls(this.curUnit, this.curUnit.publicSymbolTable().getAllTopFunctionDecls(), true);
                }
                if (this.curUnit.privateSymbolTable() != null && this.curDiffUnit.privateSymbolTable() != null) {
                    this.updateCopiedInterfaceAndExternalDecls(this.curUnit, this.curUnit.privateSymbolTable().getAllTopFunctionDecls(), false);
                }
                diffUnits = diffUnits.tail;
            }
            units = units.tail;
        }
        this.updateCopiedExternalDecls(this.srcCallGraph.cRootSymbolTable().getAllTopFunctionDecls(), this.srcCallGraph.cRootSymbolTable(), this.diffCallGraph.cRootSymbolTable());
        TapList<SymbolTable> srcTuSymbolTables = this.srcCallGraph.getTranslationUnitSymbolTables();
        while (srcTuSymbolTables != null) {
            this.updateCopiedExternalDecls(((SymbolTable)srcTuSymbolTables.head).getAllTopFunctionDecls(), (SymbolTable)srcTuSymbolTables.head, ((SymbolTable)srcTuSymbolTables.head).getExistingCopy(rootAssociationsST));
            srcTuSymbolTables = srcTuSymbolTables.tail;
        }
        units = this.srcCallGraph.units();
        while (units != null) {
            this.setCurUnitEtc((Unit)units.head);
            if (this.curUnit.functionTypeSpec() != null && this.curUnit.isAFunction() && (this.curUnit.otherReturnVar() == null || this.curUnit.otherReturnVar().symbol.equals(this.curUnit.name()))) {
                String returnName = this.curUnit.name();
                for (int diffSort = 0; diffSort < 5; ++diffSort) {
                    diffUnits = this.getUnitDiffInfo(this.curUnit).getAllDiffs(diffSort);
                    if (diffSort != 0) continue;
                    while (diffUnits != null) {
                        SymbolTable pubST;
                        VariableDecl oldReturnDecl;
                        Unit copiedUnit = (Unit)diffUnits.head;
                        if (copiedUnit != null && !copiedUnit.name().equals(returnName) && (oldReturnDecl = (pubST = copiedUnit.publicSymbolTable()).getTopVariableDecl(returnName)) != null) {
                            pubST.removeDecl(returnName, 1, true);
                        }
                        diffUnits = diffUnits.tail;
                    }
                }
            }
            units = units.tail;
        }
        this.setCurUnitEtc(null);
        TapEnv.resetRelatedUnit();
        this.buildDifferentiationAssociations();
        TapEnv.printlnOnTrace(10, "@@ Differentiation total time " + diffTimer.elapsed() + " s");
    }

    private void annotateActiveCallArgumentsInCurUnit(ActivityPattern callingActivity) {
        TapList<Block> inAllBlocks = this.curUnit.allBlocks();
        while (inAllBlocks != null) {
            Block block = (Block)inAllBlocks.head;
            SymbolTable symbolTable = block.symbolTable;
            TapList<Instruction> instructions = ((Block)inAllBlocks.head).instructions;
            TapList<BoolVector> blockReqXs = callingActivity.reqXs() == null ? null : callingActivity.reqXs().retrieve(block);
            TapList<BoolVector> blockAvlXs = callingActivity.avlXs() == null ? null : callingActivity.avlXs().retrieve(block);
            BoolVector beforeReqX = blockReqXs == null ? null : (BoolVector)blockReqXs.head;
            BoolVector beforeAvlX = blockAvlXs == null ? null : (BoolVector)blockAvlXs.head;
            int[] blockVectorMap = DataFlowAnalyzer.makeMap3(0, 0, symbolTable.declaredZonesNb(0));
            while (instructions != null) {
                BoolVector afterAvlX;
                BoolVector afterReqX;
                Tree instr = ((Instruction)instructions.head).tree;
                if (blockReqXs != null) {
                    blockReqXs = blockReqXs.tail;
                    afterReqX = (BoolVector)blockReqXs.head;
                } else {
                    afterReqX = null;
                }
                if (blockAvlXs != null) {
                    blockAvlXs = blockAvlXs.tail;
                    afterAvlX = (BoolVector)blockAvlXs.head;
                } else {
                    afterAvlX = null;
                }
                Tree lhsTree = null;
                Tree callTree = null;
                if (instr != null && instr.opCode() == 199) {
                    TapPair<Tree, Tree> declAndInit = ILUtils.splitDeclInit(instr, false, this.curUnit);
                    instr = (Tree)declAndInit.second;
                }
                if (instr != null && (instr.opCode() == 14 || instr.opCode() == 150 || instr.opCode() == 125 || instr.opCode() == 190 || instr.opCode() == 63)) {
                    lhsTree = instr.down(1);
                    instr = instr.down(2);
                }
                if (instr != null && instr.opCode() == 31) {
                    callTree = instr;
                }
                if (callTree != null) {
                    ActivityPattern calledActivity;
                    Unit calledUnit;
                    TapList<?> resultPointerActivity = null;
                    if (lhsTree != null) {
                        TapList<?> writtenZonesTree = symbolTable.treeOfZonesOfValue(lhsTree, null, (Instruction)instructions.head, null);
                        resultPointerActivity = DataFlowAnalyzer.buildInfoBoolTreeOfDeclaredZones(writtenZonesTree, afterReqX, blockVectorMap, null, 0, symbolTable);
                    }
                    if (this.diffCallNeeded(callTree, callingActivity, calledUnit = DataFlowAnalyzer.getCalledUnit(callTree, symbolTable), calledActivity = (ActivityPattern)ActivityPattern.getAnnotationForActivityPattern(callTree, callingActivity, "multiActivityCalleePatterns"), beforeAvlX, afterReqX, resultPointerActivity, block, (Instruction)instructions.head)) {
                        this.annotateActiveCallArgumentsForCall(callTree, lhsTree, CallGraph.getCallArrow(this.curUnit, calledUnit), ILUtils.getArguments(callTree).children(), calledActivity, (Instruction)instructions.head, callingActivity);
                    }
                }
                instructions = instructions.tail;
                beforeReqX = afterReqX;
                beforeAvlX = afterAvlX;
            }
            inAllBlocks = inAllBlocks.tail;
        }
    }

    private void annotateActiveCallArgumentsForCall(Tree expression, Tree lhs, CallArrow arrow, Tree[] actualParams, ActivityPattern calledActivity, Instruction instr, ActivityPattern callerActivity) {
        BoolVector calleeDiffParamsRequired;
        SymbolTable symbolTable = instr.block.symbolTable;
        Unit callingUnit = instr.block.unit();
        int[] vMap = DataFlowAnalyzer.makeMap3(0, 0, symbolTable.declaredZonesNb(0));
        BoolVector boolVector = calleeDiffParamsRequired = calledActivity == null ? null : ADActivityAnalyzer.functionDiffFormalRequired(calledActivity, false);
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace("    Annotating caller SymbolDecl's as active because active or required in call: " + ILUtils.toString(expression));
            TapEnv.printlnOnTrace("        with calledActivity: " + calledActivity);
            TapEnv.printlnOnTrace("        calleeDiffParamsRequired:" + calleeDiffParamsRequired);
        }
        if (calleeDiffParamsRequired != null) {
            BoolVector privateRequired = new BoolVector(DataFlowAnalyzer.mapSize(vMap));
            TapList<Object> actualResultRequired = new TapList<Object>(null, null);
            Tree[] actuallyDiffActualParams = new Tree[actualParams.length];
            for (int i = actualParams.length - 1; i >= 0; --i) {
                actuallyDiffActualParams[i] = (ADActivityAnalyzer.isAnnotatedActive(callerActivity, actualParams[i], symbolTable) || ILUtils.isAWritableIdentVarRef(actualParams[i], symbolTable)) && !symbolTable.varIsIntentIn(actualParams[i]) ? actualParams[i] : null;
            }
            DataFlowAnalyzer.propagateDataToCaller(calleeDiffParamsRequired, lhs, actuallyDiffActualParams, actuallyDiffActualParams.length, privateRequired, vMap, actualResultRequired, instr, arrow, true, true, 0);
            TapList<SymbolDecl> allVariableDecls = symbolTable.getAllVariableDecls();
            while (allVariableDecls != null) {
                TapIntList varRks;
                VariableDecl varDecl = (VariableDecl)allVariableDecls.head;
                TapIntList varZones = ZoneInfo.listAllZones(varDecl.zones(), true);
                if (varZones != null && privateRequired.intersects(varRks = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(varZones, 0, vMap, symbolTable, null))) {
                    if (this.adEnv.traceCurDifferentiation) {
                        TapEnv.printlnOnTrace("      => set active " + varDecl + " (zones ranks in caller-private active zones:" + varRks + ')');
                    }
                    varDecl.setActive();
                    while (varZones != null) {
                        boolean modified;
                        ZoneInfo zoneInfo = DataFlowAnalyzer.extendedDeclaredToZoneInfo(varZones.head, symbolTable, null);
                        int varRk = DataFlowAnalyzer.extendedDeclaredToVectorIndex(varZones.head, 0, vMap, symbolTable, null);
                        if (varRk > 0 && privateRequired.get(varRk) && (modified = varDecl.cumulActiveField(zoneInfo.accessTree))) {
                            varDecl.type().cumulActiveParts(varDecl.activityInfo, symbolTable);
                        }
                        varZones = varZones.tail;
                    }
                }
                allVariableDecls = allVariableDecls.tail;
            }
        }
    }

    private TapList<Unit> collectAllCalledPrimal(ActivityPattern callingActivity, TapList<Unit> collected) {
        TapList<Block> inAllBlocks = this.curUnit.allBlocks();
        while (inAllBlocks != null) {
            Block block = (Block)inAllBlocks.head;
            SymbolTable symbolTable = block.symbolTable;
            TapList<Instruction> instructions = ((Block)inAllBlocks.head).instructions;
            TapList<BoolVector> blockReqXs = callingActivity.reqXs() == null ? null : callingActivity.reqXs().retrieve(block);
            TapList<BoolVector> blockAvlXs = callingActivity.avlXs() == null ? null : callingActivity.avlXs().retrieve(block);
            BoolVector beforeReqX = blockReqXs == null ? null : (BoolVector)blockReqXs.head;
            BoolVector beforeAvlX = blockAvlXs == null ? null : (BoolVector)blockAvlXs.head;
            int[] blockVectorMap = DataFlowAnalyzer.makeMap3(0, 0, symbolTable.declaredZonesNb(0));
            while (instructions != null) {
                BoolVector afterAvlX;
                BoolVector afterReqX;
                Tree instr = ((Instruction)instructions.head).tree;
                if (blockReqXs != null) {
                    blockReqXs = blockReqXs.tail;
                    afterReqX = (BoolVector)blockReqXs.head;
                } else {
                    afterReqX = null;
                }
                if (blockAvlXs != null) {
                    blockAvlXs = blockAvlXs.tail;
                    afterAvlX = (BoolVector)blockAvlXs.head;
                } else {
                    afterAvlX = null;
                }
                Tree lhsTree = null;
                Tree callTree = null;
                if (instr != null && instr.opCode() == 199) {
                    TapPair<Tree, Tree> declAndInit = ILUtils.splitDeclInit(instr, false, this.curUnit);
                    instr = (Tree)declAndInit.second;
                }
                if (instr != null && (instr.opCode() == 14 || instr.opCode() == 150 || instr.opCode() == 125 || instr.opCode() == 190 || instr.opCode() == 63)) {
                    lhsTree = instr.down(1);
                    instr = instr.down(2);
                }
                if (instr != null && instr.opCode() == 31) {
                    callTree = instr;
                }
                if (callTree != null) {
                    Unit calledUnit;
                    TapList<?> resultPointerActivity = null;
                    if (lhsTree != null) {
                        TapList<?> writtenZonesTree = symbolTable.treeOfZonesOfValue(lhsTree, null, (Instruction)instructions.head, null);
                        resultPointerActivity = DataFlowAnalyzer.buildInfoBoolTreeOfDeclaredZones(writtenZonesTree, afterReqX, blockVectorMap, null, 0, symbolTable);
                    }
                    if ((calledUnit = DataFlowAnalyzer.getCalledUnit(callTree, symbolTable)).isStandard()) {
                        ActivityPattern calledActivity = (ActivityPattern)ActivityPattern.getAnnotationForActivityPattern(callTree, callingActivity, "multiActivityCalleePatterns");
                        if (calledActivity != null && calledActivity.isActive() && !this.diffCallNeeded(callTree, callingActivity, calledUnit, calledActivity, beforeAvlX, afterReqX, resultPointerActivity, block, (Instruction)instructions.head)) {
                            ActivityPattern.removeAnnotationForActivityPattern(callTree, callingActivity, "multiActivityCalleePatterns");
                            calledActivity = null;
                        }
                        if (calledActivity == null || !calledActivity.isActive() || TapEnv.mustAdjoint() && calledUnit.mustDifferentiateJoint()) {
                            collected = TapList.addUnlessPresent(collected, calledUnit);
                        }
                    }
                }
                instructions = instructions.tail;
                beforeReqX = afterReqX;
                beforeAvlX = afterAvlX;
            }
            inAllBlocks = inAllBlocks.tail;
        }
        return collected;
    }

    public boolean diffCallNeeded(Tree callTree, ActivityPattern callingActivity, Unit calledUnit, ActivityPattern calledActivity, BoolVector beforeAvlX, BoolVector afterReqX, TapList resultPointerActivity, Block block, Instruction instr) {
        int shapeLength = calledUnit.paramElemsNb();
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printOnTrace("          in " + this.curUnit + " with ActivityPattern@" + (callingActivity == null ? "null" : Integer.toHexString(callingActivity.hashCode())) + ", is this call differentiated " + callTree + " of unit " + calledUnit + " for called ActivityPattern@" + (calledActivity == null ? "null" : Integer.toHexString(calledActivity.hashCode())) + " ?");
            if (calledActivity == null) {
                TapEnv.printlnOnTrace(": no!");
            } else {
                TapEnv.printlnOnTrace(": (" + (this.patternCreatesDiffCode(callingActivity, this.curUnit) && !calledActivity.isDontDiff()) + "&" + (!callingActivity.isContext() || !calledUnit.isExternal()) + "&(" + (ADActivityAnalyzer.isAnnotatedActive(callingActivity, callTree, block.symbolTable) && (calledActivity.callActivity() != null && !calledActivity.callActivity().isFalse(shapeLength) || calledActivity.exitActivity() != null && !calledActivity.exitActivity().isFalse(shapeLength))) + "|" + (beforeAvlX != null && afterReqX != null && TapEnv.reqExplicitAnalyzer().isPointerActiveCall(callTree, this.curUnit, calledUnit, block.symbolTable, instr, beforeAvlX, afterReqX, resultPointerActivity)) + "|" + (!callingActivity.isContext() && MPIcallInfo.isNonBlockingMPI(callTree, calledUnit, block)) + "|" + (calledActivity.isContext() && TapList.contains(this.adEnv.callersOfRootUnits, calledUnit)) + "|" + (callingActivity.isContext() && TapList.contains(this.adEnv.rootUnits, calledUnit)) + "))");
            }
        }
        return this.patternCreatesDiffCode(callingActivity, this.curUnit) && calledActivity != null && !calledActivity.isDontDiff() && (!callingActivity.isContext() || !calledUnit.isExternal()) && (ADActivityAnalyzer.isAnnotatedActive(callingActivity, callTree, block.symbolTable) && (calledActivity.callActivity() != null && !calledActivity.callActivity().isFalse(shapeLength) || calledActivity.exitActivity() != null && !calledActivity.exitActivity().isFalse(shapeLength)) || beforeAvlX != null && afterReqX != null && TapEnv.reqExplicitAnalyzer().isPointerActiveCall(callTree, this.curUnit, calledUnit, block.symbolTable, instr, beforeAvlX, afterReqX, resultPointerActivity) || !callingActivity.isContext() && MPIcallInfo.isNonBlockingMPI(callTree, calledUnit, block) || calledActivity.isContext() && TapList.contains(this.adEnv.callersOfRootUnits, calledUnit) || callingActivity.isContext() && TapList.contains(this.adEnv.rootUnits, calledUnit));
    }

    public boolean[] getUnitFormalArgsActivityS(ActivityPattern activityPattern) {
        UnitDiffInfo diffInfo = this.getUnitDiffInfo(activityPattern.unit());
        boolean[] formalArgsActivity = null;
        if (diffInfo != null) {
            formalArgsActivity = diffInfo.getUnitFormalArgsActivityS(activityPattern);
        }
        if (formalArgsActivity == null) {
            formalArgsActivity = ADActivityAnalyzer.formalArgsActivity(activityPattern);
        }
        return formalArgsActivity;
    }

    private void createAssocAddressDiffTypesUnit(int aaUnitLang) {
        Unit aaTUUnit = this.diffCallGraph.createNewUnit(null, aaUnitLang);
        String suffixLang = ".f03";
        if (aaUnitLang == 4) {
            suffixLang = ".h";
        }
        aaTUUnit.setTranslationUnit("AATypes" + suffixLang);
        SymbolTable tuST = new SymbolTable(this.diffCallGraph.languageRootSymbolTable(aaUnitLang));
        aaTUUnit.setTranslationUnitSymbolTable(tuST);
        aaTUUnit.setPublicSymbolTable(tuST);
        tuST.containerFileName = "AATypes";
        tuST.unit = aaTUUnit;
        tuST.setShortName("AssocByAddress public tuST");
        BasicBlock declBlock = new BasicBlock(tuST, null, null);
        tuST.declarationsBlock = declBlock;
        aaTUUnit.setEntryBlock(new EntryBlock(tuST));
        aaTUUnit.setExitBlock(new ExitBlock(tuST));
        this.diffCallGraph.addTranslationUnitSymbolTable(tuST);
        new FGArrow((Block)aaTUUnit.entryBlock(), -1, 1, (Block)declBlock);
        new FGArrow((Block)declBlock, 0, 0, (Block)aaTUUnit.exitBlock());
        TapList<Block> allBlocks = new TapList<Block>(declBlock, null);
        if (aaUnitLang == 4 || aaUnitLang == 5) {
            declBlock.instructions = new TapList<Instruction>(new Instruction(ILUtils.build(138)), null);
            aaTUUnit.makeFlowGraph(aaTUUnit.entryBlock(), allBlocks, aaTUUnit.exitBlock(), false);
            TapEnv.setAssocAddressDiffTypesUnit(aaTUUnit);
        } else {
            Unit aaDiffTypeUnit = this.diffCallGraph.createNewUnit(aaTUUnit, aaUnitLang);
            declBlock.instructions = new TapList<Instruction>(Instruction.createUnitDefinitionStub(aaDiffTypeUnit, declBlock), null);
            aaTUUnit.makeFlowGraph(aaTUUnit.entryBlock(), allBlocks, aaTUUnit.exitBlock(), false);
            TapEnv.setAssocAddressDiffTypesUnit(aaDiffTypeUnit);
            aaDiffTypeUnit.setName("AATypes");
            aaDiffTypeUnit.setTranslationUnitSymbolTable(tuST);
            SymbolTable st = new SymbolTable(tuST);
            st.setShortName("AssocByAddress public ST");
            st.unit = aaDiffTypeUnit;
            aaDiffTypeUnit.setPublicSymbolTable(st);
            st = new SymbolTable(st);
            st.setShortName("AssocByAddress private ST");
            st.unit = aaDiffTypeUnit;
            aaDiffTypeUnit.setPrivateSymbolTable(st);
            aaDiffTypeUnit.setModule();
            BasicBlock declBlockModule = new BasicBlock(aaDiffTypeUnit.publicSymbolTable(), null, null);
            declBlockModule.instructions = new TapList<Instruction>(new Instruction(ILUtils.build(197, ILUtils.build(96, "ISO_C_BINDING"), ILUtils.build(166))), null);
            aaDiffTypeUnit.setEntryBlock(new EntryBlock(aaDiffTypeUnit.publicSymbolTable()));
            aaDiffTypeUnit.setExitBlock(new ExitBlock(aaDiffTypeUnit.publicSymbolTable()));
            aaDiffTypeUnit.publicSymbolTable().declarationsBlock = declBlockModule;
            new FGArrow((Block)aaDiffTypeUnit.entryBlock(), -1, 1, (Block)declBlockModule);
            new FGArrow((Block)declBlockModule, 0, 0, (Block)aaDiffTypeUnit.exitBlock());
            allBlocks = new TapList<BasicBlock>(declBlockModule, null);
            aaDiffTypeUnit.makeFlowGraph(aaDiffTypeUnit.entryBlock(), allBlocks, aaDiffTypeUnit.exitBlock(), false);
            aaTUUnit.lowerLevelUnits = new TapList<Unit>(aaDiffTypeUnit, null);
            CallGraph.addCallArrow(aaTUUnit, 3, aaDiffTypeUnit);
        }
    }

    private void buildDifferentiationAssociations() {
        this.diffCallGraph.backAssociations = null;
        TapList<Unit> units = this.srcCallGraph.units();
        while (units != null) {
            Unit unit = (Unit)units.head;
            if (unit.rank() >= 0) {
                UnitDiffInfo diffInfo = this.getUnitDiffInfo(unit);
                TapList<Unit> orderedDiffUnits = diffInfo.getAllDiffs();
                Unit copyUnit = this.adEnv.getPrimalCopyOfOrigUnit(unit);
                if (copyUnit != null && !TapList.contains(orderedDiffUnits, copyUnit)) {
                    orderedDiffUnits = TapList.addLast(orderedDiffUnits, copyUnit);
                }
                this.diffCallGraph.backAssociations = new TapList<TapPair<Unit, TapList<Unit>>>(new TapPair<Unit, TapList<Unit>>(unit, orderedDiffUnits), this.diffCallGraph.backAssociations);
            }
            units = units.tail;
        }
    }

    protected UnitDiffInfo getUnitDiffInfo(Unit unit) {
        if (unit.isIntrinsic()) {
            return (UnitDiffInfo)TapList.cassq(unit, this.intrinsicUnitDiffInfos);
        }
        return this.unitDiffInfos.retrieve(unit);
    }

    private void buildFunctionTypeSpecOfDiffUnitsOfCurUnit() {
        if (this.curUnit.isExternal() || this.curUnit.isIntrinsic()) {
            TapList<FunctionDecl> origFuncDecls;
            FunctionDecl origFuncDecl;
            FunctionDecl diffFuncDecl;
            String unitName = this.curUnit.name();
            Tree functionNameTree = ILUtils.build(96, unitName);
            TapList<FunctionDecl> diffFuncDecls = this.diffCallGraph.languageRootSymbolTable(this.curUnit.language()).getFunctionDecl(unitName, null, null, false);
            FunctionDecl functionDecl = diffFuncDecl = diffFuncDecls == null ? null : (FunctionDecl)diffFuncDecls.head;
            if (diffFuncDecl == null) {
                diffFuncDecl = new FunctionDecl(functionNameTree, this.curUnit);
                this.diffCallGraph.languageRootSymbolTable(this.curUnit.language()).addSymbolDecl(diffFuncDecl);
            }
            FunctionDecl functionDecl2 = origFuncDecl = (origFuncDecls = this.srcCallGraph.languageRootSymbolTable(this.curUnit.language()).getFunctionDecl(unitName, null, null, false)) == null ? null : (FunctionDecl)origFuncDecls.head;
            if (origFuncDecl != null) {
                diffFuncDecl.setInstruction(origFuncDecl);
            } else {
                diffFuncDecl.setExternalInstr(true);
            }
        }
        for (int mode = 4; mode > 0; --mode) {
            TapList<ActivityPattern> activityPatterns = this.curUnit.activityPatterns;
            while (activityPatterns != null) {
                this.adEnv.setCurActivity((ActivityPattern)activityPatterns.head);
                this.setCurDiffUnit(this.adEnv.getDiffOfUnit(this.curUnit, this.adEnv.curActivity(), mode));
                if (this.curDiffUnit != null) {
                    boolean isMainProcedure;
                    if (this.multiDirMode()) {
                        this.flowGraphDifferentiator().initializeMultiDirNumberMax();
                    }
                    FunctionTypeSpec diffTypeSpec = this.curUnit.functionTypeSpec();
                    boolean bl = isMainProcedure = this.curUnit == this.srcCallGraph.getMainUnit();
                    if (!(mode != 1 && mode != 2 && mode != 3 && mode != 4 || isMainProcedure)) {
                        diffTypeSpec = this.buildFunctionTypeSpecOfCurDiffUnit(this.adEnv.curActivity(), mode);
                    }
                    if (this.adEnv.traceCurDifferentiation || TapEnv.traceActivity() != null) {
                        TapEnv.printlnOnTrace("Built FunctionTypeSpec of diff Unit:" + this.curDiffUnit + " : " + diffTypeSpec);
                    }
                    this.curDiffUnit.setFunctionTypeSpec(diffTypeSpec);
                    if (isMainProcedure && this.curDiffUnit.isC()) {
                        this.curDiffUnit.publicSymbolTable().removeDecl("main", 0, true);
                    }
                    if (this.curUnit.isExternal() || this.curUnit.isIntrinsic()) {
                        this.curDiffUnit.setExternal();
                        FunctionTypeSpec diffFunctionTypeSpec = this.curDiffUnit.functionTypeSpec();
                        int nbDiffArgs = diffFunctionTypeSpec.argumentsTypes == null ? 0 : diffFunctionTypeSpec.argumentsTypes.length;
                        TapList<Tree> dummyArgsList = null;
                        for (int i = nbDiffArgs; i > 0; --i) {
                            dummyArgsList = new TapList<Tree>(ILUtils.build(96, "_"), dummyArgsList);
                        }
                        this.curDiffUnit.parametersOrModuleNameTree = ILUtils.build(71, dummyArgsList);
                    }
                }
                activityPatterns = activityPatterns.tail;
            }
        }
        this.adEnv.setCurActivity(null);
    }

    private void buildFunctionTypeSpecOfCopyUnit() {
        Unit copiedUnit = this.adEnv.copiedUnits.retrieve(this.curUnit);
        if (copiedUnit != null) {
            WrapperTypeSpec returnType;
            FunctionTypeSpec diffTypeSpec = copiedUnit.functionTypeSpec();
            WrapperTypeSpec[] paramsTypes = diffTypeSpec.argumentsTypes;
            TapList<ActivityPattern> activityPatterns = this.curUnit.activityPatterns;
            WrapperTypeSpec diffReturnType = returnType = diffTypeSpec.returnType;
            TapList<WrapperTypeSpec> diffArgTypes = null;
            while (activityPatterns != null) {
                this.adEnv.setCurActivity((ActivityPattern)activityPatterns.head);
                boolean[] formalArgsActivity = this.getUnitFormalArgsActivityS(this.adEnv.curActivity());
                boolean[] formalArgsPointerActivity = ReqExplicit.formalArgsPointerActivity(this.adEnv.curActivity(), paramsTypes.length);
                if (formalArgsActivity != null) {
                    if (this.curUnit.isAFunction()) {
                        diffReturnType = formalArgsActivity[0] || formalArgsPointerActivity[0] ? returnType.differentiateTypeSpecMemo(copiedUnit.publicSymbolTable(), this.curUnit.publicSymbolTable(), this.curDiffUnitSort(), this.suffixes()[1][3], false, this.multiDirMode(), this.varRefDifferentiator().getMultiDirDimensionMax(), this.curUnit.name(), this.curUnit.name(), null, null) : returnType;
                    }
                    for (int i = paramsTypes.length - 1; i >= 0; --i) {
                        WrapperTypeSpec diffParamType;
                        WrapperTypeSpec paramType = paramsTypes[i];
                        if (formalArgsActivity[i] || formalArgsPointerActivity[i]) {
                            diffParamType = paramType.differentiateTypeSpecMemo(copiedUnit.publicSymbolTable(), this.curUnit.publicSymbolTable(), this.curDiffUnitSort(), this.suffixes()[1][3], false, this.multiDirMode(), this.varRefDifferentiator().getMultiDirDimensionMax(), this.curUnit.name() + "'s arg" + (i + 1), this.curUnit.name() + "_arg" + (i + 1), null, null);
                            if (diffParamType == null) {
                                diffParamType = paramType;
                            } else if (diffParamType.equalsLiterally(paramType)) {
                                diffParamType = paramType;
                            }
                        } else {
                            diffParamType = paramType;
                        }
                        diffArgTypes = new TapList<WrapperTypeSpec>(diffParamType, diffArgTypes);
                    }
                    diffTypeSpec = new FunctionTypeSpec(diffReturnType, diffArgTypes);
                    if (this.adEnv.traceCurDifferentiation || TapEnv.traceActivity() != null) {
                        TapEnv.printlnOnTrace("Built FunctionTypeSpec of copy Unit:" + copiedUnit + " : " + diffTypeSpec);
                    }
                    copiedUnit.setFunctionTypeSpec(diffTypeSpec);
                }
                activityPatterns = activityPatterns.tail;
            }
        }
    }

    private void augmentExternalEntryExitActivities(BoolVector unitCallActive, BoolVector unitExitActive) {
        if (TapEnv.modeIsAdjoint()) {
            unitExitActive.cumulOr(unitCallActive);
        } else {
            unitCallActive.cumulOr(unitExitActive);
            TapIntList resultRks = this.curUnit.publicRankOfResult();
            while (resultRks != null) {
                unitCallActive.set(resultRks.head, false);
                resultRks = resultRks.tail;
            }
        }
    }

    private void futureUnitsDecision(TapList<Unit> unitsRootSTLast, TapList<Unit> calledPrimalFormUnits) {
        TapList<CallArrow> importingArrows;
        Unit unit;
        boolean traceFutureUnitsDecisions;
        boolean bl = traceFutureUnitsDecisions = TapEnv.get().traceDifferentiationUnitNames != null;
        if (traceFutureUnitsDecisions) {
            TapEnv.printlnOnTrace(" Future Units: Units called in Primal form:" + calledPrimalFormUnits);
        }
        Unit importedUnit = null;
        this.unitsHavePrimal = new UnitStorage(this.srcCallGraph);
        this.unitsHaveDiff = new UnitStorage(this.srcCallGraph);
        UnitStorage<Boolean> unitsImportActive = new UnitStorage<Boolean>(this.srcCallGraph);
        UnitStorage<Boolean> unitsImportPrimal = new UnitStorage<Boolean>(this.srcCallGraph);
        TapList<Unit> inUnits = unitsRootSTLast;
        while (inUnits != null) {
            unit = (Unit)inUnits.head;
            this.unitsHavePrimal.store(unit, Boolean.FALSE);
            this.unitsHaveDiff.store(unit, Boolean.FALSE);
            unitsImportActive.store(unit, Boolean.FALSE);
            unitsImportPrimal.store(unit, Boolean.FALSE);
            inUnits = inUnits.tail;
        }
        boolean stabilized = false;
        while (!stabilized) {
            stabilized = true;
            inUnits = unitsRootSTLast;
            while (inUnits != null) {
                unit = (Unit)inUnits.head;
                boolean isActive = false;
                if (this.unitsHaveDiff.retrieve(unit) == Boolean.FALSE) {
                    SymbolDecl activeSymbol;
                    if (unit.isModule() || unit.isClass()) {
                        activeSymbol = this.symbolTableContainsActiveSymbolDecl(unit.publicSymbolTable());
                        if (activeSymbol == null && unit.protectedSymbolTable() != null) {
                            activeSymbol = this.symbolTableContainsActiveSymbolDecl(unit.protectedSymbolTable());
                        }
                        if (activeSymbol == null) {
                            activeSymbol = this.symbolTableContainsActiveSymbolDecl(unit.privateSymbolTable());
                        }
                        boolean bl2 = isActive = activeSymbol != null;
                        if (traceFutureUnitsDecisions && isActive) {
                            TapEnv.printlnOnTrace(" Future Units: package " + unit + " must have Diff because it contains active object " + activeSymbol);
                        }
                    } else if (unit.isTranslationUnit()) {
                        activeSymbol = this.symbolTableContainsActiveSymbolDecl(unit.publicSymbolTable());
                        boolean bl3 = isActive = activeSymbol != null;
                        if (traceFutureUnitsDecisions && isActive) {
                            TapEnv.printlnOnTrace(" Future Units: file " + unit + " must have Diff because it contains an active object " + activeSymbol);
                        }
                    } else {
                        TapList<ActivityPattern> activityPatterns = unit.activityPatterns;
                        while (!isActive && activityPatterns != null) {
                            boolean bl4 = isActive = (((ActivityPattern)activityPatterns.head).isContext() || this.activityAnalyzer().isActiveUnit((ActivityPattern)activityPatterns.head) || TapEnv.reqExplicitAnalyzer() != null && TapEnv.reqExplicitAnalyzer().isPointerActiveUnit((ActivityPattern)activityPatterns.head)) && this.patternCreatesDiffCode((ActivityPattern)activityPatterns.head, unit);
                            if (traceFutureUnitsDecisions && isActive) {
                                TapEnv.printlnOnTrace(" Future Units: Unit " + unit + " must have Diff because it is context or active or pointerActive");
                            }
                            activityPatterns = activityPatterns.tail;
                        }
                    }
                    if (isActive) {
                        this.unitsHaveDiff.store(unit, Boolean.TRUE);
                        stabilized = false;
                        while ((unit = unit.upperLevelUnit()) != null) {
                            this.unitsHaveDiff.store(unit, Boolean.TRUE);
                            if (!traceFutureUnitsDecisions) continue;
                            TapEnv.printlnOnTrace(" Future Units: " + unit + " must have Diff because it contains the previous one");
                        }
                    }
                }
                inUnits = inUnits.tail;
            }
        }
        stabilized = false;
        while (!stabilized) {
            stabilized = true;
            inUnits = unitsRootSTLast;
            while (inUnits != null) {
                unit = (Unit)inUnits.head;
                if (unitsImportActive.retrieve(unit) == Boolean.FALSE) {
                    importingArrows = unit.callees();
                    boolean refersToActiveOrImporting = false;
                    while (importingArrows != null && !refersToActiveOrImporting) {
                        if (((CallArrow)importingArrows.head).isImport()) {
                            importedUnit = ((CallArrow)importingArrows.head).destination;
                            boolean bl5 = refersToActiveOrImporting = this.unitsHaveDiff.retrieve(importedUnit) == Boolean.TRUE || unitsImportActive.retrieve(importedUnit) == Boolean.TRUE;
                            if (traceFutureUnitsDecisions && refersToActiveOrImporting) {
                                TapEnv.printlnOnTrace(" Future Units: Unit " + unit + " imports active because imports " + importedUnit);
                            }
                        }
                        importingArrows = importingArrows.tail;
                    }
                    if (refersToActiveOrImporting) {
                        unitsImportActive.store(unit, Boolean.TRUE);
                        while ((unit = unit.upperLevelUnit()) != null) {
                            unitsImportActive.store(unit, Boolean.TRUE);
                            if (!traceFutureUnitsDecisions) continue;
                            TapEnv.printlnOnTrace(" Future Units: Unit " + unit + " imports active because it contains the previous one");
                        }
                        stabilized = false;
                    }
                }
                inUnits = inUnits.tail;
            }
        }
        inUnits = unitsRootSTLast;
        while (inUnits != null) {
            unit = (Unit)inUnits.head;
            if (unit.isPackage()) {
                if (unitsImportActive.retrieve(unit) == Boolean.TRUE) {
                    this.unitsHaveDiff.store(unit, Boolean.TRUE);
                    if (traceFutureUnitsDecisions) {
                        TapEnv.printlnOnTrace(" Future Units: package " + unit + " must have Diff because it imports active");
                    }
                }
                if (!(unit.isTranslationUnit() || TapEnv.get().stripPrimalModules && this.unitsHaveDiff.retrieve(unit) != Boolean.TRUE || this.unitsHavePrimal.retrieve(unit) == Boolean.TRUE)) {
                    this.unitsHavePrimal.store(unit, Boolean.TRUE);
                    if (traceFutureUnitsDecisions) {
                        TapEnv.printlnOnTrace(" Future Units: package " + unit + " must have Primal because " + (TapEnv.get().stripPrimalModules ? "it must have Diff" : "-nooptim stripprimalmodules"));
                    }
                    this.setAllContainedHavePrimalRec(unit, traceFutureUnitsDecisions, unit);
                }
            }
            inUnits = inUnits.tail;
        }
        inUnits = unitsRootSTLast;
        while (inUnits != null) {
            unit = (Unit)inUnits.head;
            if (!unit.isPackage() && this.unitsHavePrimal.retrieve(unit) != Boolean.TRUE) {
                boolean reason4;
                Unit topContainer;
                for (topContainer = unit.upperLevelUnit(); topContainer != null && !topContainer.isTopInFile(); topContainer = topContainer.upperLevelUnit()) {
                }
                if (traceFutureUnitsDecisions && TapEnv.get().stripPrimalCode && TapEnv.get().stripPrimalEvenIfImportsActive && unitsImportActive.retrieve(unit) == Boolean.TRUE) {
                    TapEnv.printlnOnTrace(" Future Units: NOTE: non-package " + unit + " should have primal because imports active, but option disables this");
                }
                boolean reason1 = !TapEnv.get().stripPrimalCode;
                boolean reason2 = !reason1 && unitsImportActive.retrieve(unit) == Boolean.TRUE && !TapEnv.get().stripPrimalEvenIfImportsActive;
                boolean reason3 = !reason2 && TapList.contains(calledPrimalFormUnits, unit) && (unit.isC() || unit.isFortran2003() && unit.getNameFromBindC() != null && topContainer != null);
                boolean bl6 = reason4 = !reason3 && topContainer != null && this.unitsHaveDiff.retrieve(topContainer) == Boolean.TRUE;
                if (reason1 || reason2 || reason3 || reason4) {
                    TapList<FunctionDecl> cFunctionDecls;
                    if (traceFutureUnitsDecisions) {
                        TapEnv.printlnOnTrace(" Future Units: non-package " + unit + " must have Primal because " + (reason1 ? "-nooptim stripprimalcode" : (reason2 ? "imports active" : (reason3 ? "differentiated code calls primal and is C or bindC" : "is contained in active"))));
                    }
                    this.unitsHavePrimal.store(unit, Boolean.TRUE);
                    String boundUnitName = unit.getNameFromBindC();
                    if (boundUnitName != null && (cFunctionDecls = this.srcCallGraph.cRootSymbolTable().getFunctionDecl(boundUnitName, null, null, false)) != null) {
                        Unit boundUnit = ((FunctionDecl)cFunctionDecls.head).unit();
                        if (traceFutureUnitsDecisions) {
                            TapEnv.printlnOnTrace(" Future Units: " + boundUnit + " must have Primal because it is bound to the previous one");
                        }
                        this.unitsHavePrimal.store(boundUnit, Boolean.TRUE);
                    }
                    while ((unit = unit.upperLevelUnit()) != null) {
                        if (!unit.isTranslationUnit()) continue;
                        this.unitsHaveDiff.store(unit, Boolean.TRUE);
                        if (!traceFutureUnitsDecisions) continue;
                        TapEnv.printlnOnTrace(" Future Units: package " + unit + " must have Diff because it contains the previous one");
                    }
                }
            }
            inUnits = inUnits.tail;
        }
        stabilized = false;
        while (!stabilized) {
            stabilized = true;
            inUnits = unitsRootSTLast;
            while (inUnits != null) {
                unit = (Unit)inUnits.head;
                if (unitsImportPrimal.retrieve(unit) == Boolean.FALSE) {
                    importingArrows = unit.callees();
                    boolean refersToOrCallsPrimalOrImporting = false;
                    if (TapEnv.get().stripPrimalEvenIfImportsActive) {
                        importingArrows = null;
                    }
                    while (importingArrows != null && !refersToOrCallsPrimalOrImporting) {
                        if (((CallArrow)importingArrows.head).isImport()) {
                            importedUnit = ((CallArrow)importingArrows.head).destination;
                            boolean bl7 = refersToOrCallsPrimalOrImporting = this.unitsHavePrimal.retrieve(importedUnit) == Boolean.TRUE || unitsImportPrimal.retrieve(importedUnit) == Boolean.TRUE;
                        }
                        if (traceFutureUnitsDecisions && refersToOrCallsPrimalOrImporting) {
                            TapEnv.printlnOnTrace(" Future Units: " + unit + " must have Primal because imports " + importedUnit + (this.unitsHavePrimal.retrieve(importedUnit) != false ? " that must have Primal" : " that imports Primal"));
                        }
                        importingArrows = importingArrows.tail;
                    }
                    if (!refersToOrCallsPrimalOrImporting) {
                        TapList allCallers = unit.allCallers().tail;
                        boolean primalCaller = TapList.contains(calledPrimalFormUnits, unit);
                        Unit callerUnit = null;
                        Unit calleeUnit = null;
                        while (!primalCaller && allCallers != null) {
                            callerUnit = (Unit)allCallers.head;
                            primalCaller = this.unitsHavePrimal.retrieve(callerUnit) == Boolean.TRUE || unit.isC() && TapEnv.get().standaloneDiff && callerUnit.isTranslationUnit() && this.unitsHaveDiff.retrieve(callerUnit) == Boolean.TRUE || unitsImportPrimal.retrieve(callerUnit) == Boolean.TRUE || TapList.contains(calledPrimalFormUnits, callerUnit);
                            allCallers = allCallers.tail;
                        }
                        if (primalCaller) {
                            TapList allCallees = unit.allCallees().tail;
                            boolean primalCallee = false;
                            while (!primalCallee && allCallees != null) {
                                calleeUnit = (Unit)allCallees.head;
                                primalCallee = this.unitsHavePrimal.retrieve(calleeUnit) == Boolean.TRUE || unitsImportPrimal.retrieve(calleeUnit) == Boolean.TRUE;
                                allCallees = allCallees.tail;
                            }
                            if (unit.isC() || primalCallee || TapEnv.get().standaloneDiff) {
                                refersToOrCallsPrimalOrImporting = true;
                                if (traceFutureUnitsDecisions) {
                                    TapEnv.printlnOnTrace(" Future Units: " + unit + " must have Primal because " + (callerUnit == null ? "it is itself called in Primal form" : "it is called by Primal (or called in Primal form) " + callerUnit) + (unit.isC() ? " and it is C" : (primalCallee ? " and it calls Primal " + calleeUnit : " and one wants a standalone diff code")));
                                }
                            }
                        }
                    }
                    if (refersToOrCallsPrimalOrImporting) {
                        unitsImportPrimal.store(unit, Boolean.TRUE);
                        this.setAllContainedHavePrimalRec(unit, traceFutureUnitsDecisions, unit);
                        for (unit = unit.upperLevelUnit(); unit != null && !unit.isTranslationUnit(); unit = unit.upperLevelUnit()) {
                            unitsImportPrimal.store(unit, Boolean.TRUE);
                            if (!traceFutureUnitsDecisions) continue;
                            TapEnv.printlnOnTrace(" Future Units: " + unit + " must have Primal because it contains the previous one");
                        }
                        stabilized = false;
                    }
                }
                inUnits = inUnits.tail;
            }
        }
        inUnits = unitsRootSTLast;
        while (inUnits != null) {
            unit = (Unit)inUnits.head;
            if (unitsImportPrimal.retrieve(unit) == Boolean.TRUE) {
                this.unitsHavePrimal.store(unit, Boolean.TRUE);
            }
            inUnits = inUnits.tail;
        }
        if (traceFutureUnitsDecisions) {
            inUnits = unitsRootSTLast;
            while (inUnits != null) {
                unit = (Unit)inUnits.head;
                TapEnv.printlnOnTrace(" Future Units Summary: " + unit + " must have Primal:" + this.unitsHavePrimal.retrieve(unit) + " must have Diff:" + this.unitsHaveDiff.retrieve(unit));
                inUnits = inUnits.tail;
            }
        }
    }

    private void setAllContainedHavePrimalRec(Unit unit, boolean traceFutureUnitsDecisions, Unit containerUnit) {
        TapList<Unit> insideUnits = unit.lowerLevelUnits;
        while (insideUnits != null) {
            this.unitsHavePrimal.store((Unit)insideUnits.head, Boolean.TRUE);
            if (traceFutureUnitsDecisions) {
                TapEnv.printlnOnTrace(" Future Units: " + insideUnits.head + " must have Primal because it is contained in " + containerUnit + ", which must have Primal");
            }
            this.setAllContainedHavePrimalRec((Unit)insideUnits.head, traceFutureUnitsDecisions, containerUnit);
            insideUnits = insideUnits.tail;
        }
    }

    private SymbolDecl symbolTableContainsActiveSymbolDecl(SymbolTable symbolTable) {
        boolean result = false;
        SymbolDecl symbolDecl = null;
        TapList<SymbolDecl> symbolDecls = symbolTable.getAllTopSymbolDecls();
        while (symbolDecls != null && !result) {
            Unit unit;
            symbolDecl = (SymbolDecl)symbolDecls.head;
            result = symbolDecl.isA(3) ? this.unitsHaveDiff.retrieve(unit = ((FunctionDecl)symbolDecl).unit()) == Boolean.TRUE : symbolDecl.isActive();
            symbolDecls = symbolDecls.tail;
        }
        return result ? symbolDecl : null;
    }

    private void updateCopiedUnits(boolean updateInterfaceUnits) {
        TapList<Unit> units = this.srcCallGraph.units();
        while (units != null) {
            Unit origCopyUnit;
            this.setCurUnitEtc((Unit)units.head);
            Unit origUnitOfInterface = this.curUnit.getOrigUnitOfInterface(this.srcCallGraph);
            if ((!updateInterfaceUnits && !this.curUnit.isInterface() || updateInterfaceUnits && this.curUnit.isInterface()) && this.curUnit.functionTypeSpec() != null && (this.curUnit.isTopInFile() || this.curUnit.isInterface() && (origUnitOfInterface != null && origUnitOfInterface.importedModules() != null && (origUnitOfInterface.isTopInFile() || origUnitOfInterface.isInterface()) || (this.curUnit.getUnitOfInterface() == this.curUnit || this.curUnit.getUnitOfInterface() == null) && this.curUnit.importedModules() != null)) && (origCopyUnit = this.adEnv.copiedUnits.retrieve(this.curUnit)) != null) {
                String oldUnitName = this.curUnit.name();
                String newUnitName = origCopyUnit.name();
                String oldUnitNameInOrig = null;
                String newUnitNameInOrig = null;
                if (oldUnitName.equals(newUnitName)) {
                    Unit diffTopUnit;
                    boolean origCopyUnitNameIsSet = false;
                    if (origUnitOfInterface != null && (origUnitOfInterface.isTopInFile() || origUnitOfInterface.isInterface() || origUnitOfInterface.importedModules() != null) && (diffTopUnit = this.adEnv.copiedUnits.retrieve(origUnitOfInterface)) != null) {
                        origCopyUnit.setName(diffTopUnit.name());
                        origCopyUnitNameIsSet = true;
                    }
                    if (!origCopyUnitNameIsSet) {
                        Tree callTree = ILUtils.build(31, ILUtils.build(96, oldUnitName));
                        Tree newUnitNameTree = this.varRefDifferentiator().diffSymbolName(null, oldUnitName, origCopyUnit.publicSymbolTable(), false, true, false, callTree, null, false, 0, 0, 1, null);
                        NewSymbolHolder newSymbolHolder = NewSymbolHolder.getNewSymbolHolder(newUnitNameTree);
                        if (newSymbolHolder != null && newSymbolHolder.hasNewFunctionDecl()) {
                            newSymbolHolder.newFunctionDecl().setUnit(origCopyUnit);
                        }
                        for (SymbolTable upperSymbolTable = origCopyUnit.publicSymbolTable(); upperSymbolTable != null; upperSymbolTable = upperSymbolTable.basisSymbolTable()) {
                            upperSymbolTable.solveNewSymbolHolders(this.adEnv.emptyCopiedUnitSuffix);
                        }
                        newUnitName = ILUtils.getIdentString(newUnitNameTree);
                        origCopyUnit.setName(newUnitName);
                        this.curUnit.setOtherName(origCopyUnit);
                        origCopyUnit.setOtherName(this.curUnit);
                    }
                }
                if (origCopyUnit.isAFunction()) {
                    origCopyUnit.setOtherReturnVar(origCopyUnit.publicSymbolTable().getTopVariableDecl(this.curUnit.otherReturnVar() != null ? this.curUnit.otherReturnVar().symbol : oldUnitName));
                }
                TapList<CallArrow> arrows = this.curUnit.callers();
                while (arrows != null) {
                    UnitDiffInfo origDiffInfo = this.getUnitDiffInfo(((CallArrow)arrows.head).origin);
                    TapList<Unit> diffUnits = origDiffInfo.getAllDiffsPlusCopy();
                    while (diffUnits != null) {
                        Unit callerUnit = (Unit)diffUnits.head;
                        this.updateAllUsages(callerUnit, oldUnitName, origCopyUnit);
                        if (!((CallArrow)arrows.head).origin().sameLanguage(((CallArrow)arrows.head).destination.language())) {
                            oldUnitNameInOrig = this.srcCallGraph.getOtherLanguageName(oldUnitName, ((CallArrow)arrows.head).destination().language(), ((CallArrow)arrows.head).origin().language());
                            newUnitNameInOrig = this.diffCallGraph.getOtherLanguageName(newUnitName, ((CallArrow)arrows.head).destination().language(), ((CallArrow)arrows.head).origin().language());
                            this.updateFunctionDeclName(origCopyUnit, oldUnitNameInOrig, newUnitNameInOrig, callerUnit.translationUnitSymbolTable());
                        } else {
                            this.updateFunctionDeclName(origCopyUnit, oldUnitName, newUnitName, callerUnit.translationUnitSymbolTable());
                        }
                        if (((CallArrow)arrows.head).isContain() && callerUnit.isModule()) {
                            this.updateAllAccessDecls(callerUnit.publicSymbolTable().declarationsBlock.instructions, oldUnitName, origCopyUnit);
                            this.updateAllAccessDecls(callerUnit.privateSymbolTable().declarationsBlock.instructions, oldUnitName, origCopyUnit);
                        }
                        diffUnits = diffUnits.tail;
                    }
                    arrows = arrows.tail;
                }
                this.updateAllUsagesInBlock(this.diffCallGraph.topBlock, oldUnitName, origCopyUnit, origCopyUnit.name());
                TapList<SymbolTable> diffTUSTs = this.diffCallGraph.getTranslationUnitSymbolTables();
                while (diffTUSTs != null) {
                    this.updateAllUsagesInBlock(((SymbolTable)diffTUSTs.head).declarationsBlock, oldUnitName, origCopyUnit, origCopyUnit.name());
                    if (oldUnitNameInOrig != null) {
                        this.updateAllUsagesInBlock(((SymbolTable)diffTUSTs.head).declarationsBlock, oldUnitNameInOrig, origCopyUnit, newUnitNameInOrig);
                    }
                    diffTUSTs = diffTUSTs.tail;
                }
                TapList<Unit> importedModules = this.curUnit.importedModules();
                while (importedModules != null) {
                    Unit importedModule = (Unit)importedModules.head;
                    Unit diffImportedModule = this.getUnitDiffInfo(importedModule).getDiff();
                    if (diffImportedModule != null) {
                        this.updateAllUsages(origCopyUnit, importedModule.name(), diffImportedModule);
                    }
                    importedModules = importedModules.tail;
                }
                this.updateFunctionDeclName(origCopyUnit, oldUnitName, newUnitName, this.diffCallGraph.languageRootSymbolTable(this.curUnit.language()));
                this.updateFunctionDeclName(origCopyUnit, oldUnitName, newUnitName, origCopyUnit.translationUnitSymbolTable());
            }
            units = units.tail;
        }
        this.setCurUnitEtc(null);
    }

    private void updateFunctionDeclName(Unit origCopyUnit, String oldUnitName, String newUnitName, SymbolTable symbolTable) {
        if (symbolTable != null && oldUnitName != null) {
            SymbolDecl oldSymbolDecl;
            FunctionDecl funcDecl;
            TapList<FunctionDecl> funcDecls = symbolTable.getFunctionDecl(oldUnitName, null, null, false);
            FunctionDecl functionDecl = funcDecl = funcDecls == null ? null : (FunctionDecl)funcDecls.head;
            if (funcDecl != null && (oldSymbolDecl = symbolTable.getDecl(funcDecl.symbol, funcDecl.kind, true)) != null) {
                Tree treeName = ILUtils.build(96, newUnitName);
                FunctionDecl newFunDecl = new FunctionDecl(treeName, origCopyUnit);
                newFunDecl.setInstruction(oldSymbolDecl);
                oldSymbolDecl.isConsideredRemoved = true;
                if (funcDecl.unit().enclosingUnitOfInterface != null) {
                    newFunDecl.unit().enclosingUnitOfInterface = funcDecl.unit().enclosingUnitOfInterface;
                }
                symbolTable.addSymbolDecl(newFunDecl);
            }
        }
    }

    private void differentiateAllocateInCopiedUnits() {
        TapList<Unit> units = this.srcCallGraph.units();
        while (units != null) {
            this.setCurUnitEtc((Unit)units.head);
            if (!this.curUnit.isOutside() && !this.curUnit.isInterface()) {
                this.setCurDiffUnit(this.adEnv.getPrimalCopyOfOrigUnit(this.curUnit));
                boolean needInitMultiDirMode = this.multiDirMode();
                if (this.curDiffUnit != null) {
                    TapList<Block> allBlocks = this.curDiffUnit.allBlocks();
                    while (allBlocks != null) {
                        TapList<Object> hdCopiedInstrs;
                        Block block = (Block)allBlocks.head;
                        TapList<Instruction> instructions = block.instructions;
                        TapList<Object> tlCopiedInstrs = hdCopiedInstrs = new TapList<Object>(null, null);
                        boolean modified = false;
                        while (instructions != null) {
                            Instruction diffInstr;
                            Tree diffVarTree;
                            Instruction instr = (Instruction)instructions.head;
                            Tree tree = instr.tree;
                            if (tree.opCode() == 14 && tree.down(2).opCode() == 5 && CallGraphDifferentiator.hasActiveGlobalVarDecl(ILUtils.baseName(tree.down(1)), block.symbolTable, this.curDiffUnit.publicSymbolTable().basisSymbolTable())) {
                                modified = true;
                                if (needInitMultiDirMode) {
                                    this.flowGraphDifferentiator().initializeMultiDirMode();
                                    needInitMultiDirMode = false;
                                }
                                diffVarTree = this.varRefDifferentiator().diffVarRef(null, tree.down(1), block.symbolTable, false, tree, this.multiDirMode(), true, null);
                                Tree diffRhs = this.varRefDifferentiator().diffVarRef(null, tree.down(2), block.symbolTable, false, tree, this.multiDirMode(), true, null);
                                diffInstr = new Instruction(ILUtils.build(14, diffVarTree, diffRhs));
                                tlCopiedInstrs = tlCopiedInstrs.placdl(diffInstr);
                            } else if (tree.opCode() == 52 && CallGraphDifferentiator.hasActiveGlobalVarDecl(ILUtils.baseName(tree.down(1)), block.symbolTable, this.curDiffUnit.publicSymbolTable().basisSymbolTable())) {
                                modified = true;
                                if (needInitMultiDirMode) {
                                    this.flowGraphDifferentiator().initializeMultiDirMode();
                                    needInitMultiDirMode = false;
                                }
                                diffVarTree = this.varRefDifferentiator().diffVarRef(null, tree.down(1), block.symbolTable, false, tree, this.multiDirMode(), true, null);
                                diffInstr = new Instruction(ILUtils.build(52, diffVarTree, ILUtils.copy(tree.down(2))));
                                tlCopiedInstrs = tlCopiedInstrs.placdl(diffInstr);
                            }
                            tlCopiedInstrs = tlCopiedInstrs.placdl(instr);
                            instructions = instructions.tail;
                        }
                        if (modified) {
                            block.instructions = hdCopiedInstrs.tail;
                        }
                        allBlocks = allBlocks.tail;
                    }
                }
            }
            units = units.tail;
        }
        this.setCurUnitEtc(null);
        this.setCurDiffUnit(null);
    }

    private static boolean hasActiveGlobalVarDecl(String name, SymbolTable localST, SymbolTable globalST) {
        VariableDecl varDecl = localST.getVariableDecl(name);
        if (varDecl == null || !varDecl.isActiveSymbolDecl()) {
            return false;
        }
        VariableDecl globalVarDecl = globalST.getVariableDecl(name);
        return varDecl == globalVarDecl;
    }

    private void updateCopiedInterfaceAndExternalDecls(Unit unit, TapList<SymbolDecl> functionDecls, boolean inPublicSymbolTable) {
        while (functionDecls != null) {
            boolean change;
            Unit copiedFunctionUnit;
            FunctionDecl functionDecl = (FunctionDecl)functionDecls.head;
            Unit functionUnit = functionDecl.unit();
            if (!functionDecl.symbol.equals(functionUnit.name())) {
                TapList<Unit> srcInterfaceUnits = this.srcCallGraph.interfaceUnits();
                while (srcInterfaceUnits != null) {
                    if (functionDecl.symbol.equals(((Unit)srcInterfaceUnits.head).name())) {
                        functionUnit = (Unit)srcInterfaceUnits.head;
                    }
                    srcInterfaceUnits = srcInterfaceUnits.tail;
                }
            }
            String copiedUnitName = (copiedFunctionUnit = this.adEnv.copiedUnits.retrieve(functionUnit)) != null ? copiedFunctionUnit.name() : functionUnit.name();
            boolean bl = change = !copiedUnitName.equals(functionUnit.name());
            if (change) {
                SymbolTable searchInSymbolTable = inPublicSymbolTable ? unit.publicSymbolTable() : unit.privateSymbolTable();
                if (!functionDecl.hasInterfaceInstruction() && functionDecl.isExternalDeclared(this.curDiffUnit.publicSymbolTable().declarationsBlock.instructions)) {
                    Instruction varDecl;
                    Instruction externalDecl = this.curDiffUnit.publicSymbolTable().declarationsBlock.getOperatorDeclarationInstruction(functionDecl, 74, searchInSymbolTable);
                    if (externalDecl != null) {
                        ILUtils.replaceAllIdentsNamed(externalDecl.tree, functionDecl.symbol, copiedUnitName);
                    }
                    if ((varDecl = this.curDiffUnit.publicSymbolTable().declarationsBlock.getOperatorDeclarationInstruction(functionDecl, 199, searchInSymbolTable)) != null) {
                        ILUtils.replaceAllIdentsNamed(varDecl.tree, functionDecl.symbol, copiedUnitName);
                        varDecl.isDifferentiated = true;
                    }
                }
                TapList<Block> blocks = this.curDiffUnit.allBlocks();
                while (blocks != null) {
                    Block block = (Block)blocks.head;
                    TapList<Instruction> instructions = block.instructions;
                    while (instructions != null) {
                        Instruction instruction = (Instruction)instructions.head;
                        ILUtils.replaceAllCallName(instruction.tree, functionDecl.symbol, copiedUnitName, null, block.symbolTable);
                        instructions = instructions.tail;
                    }
                    blocks = blocks.tail;
                }
            }
            functionDecls = functionDecls.tail;
        }
    }

    private void updateCopiedExternalDecls(TapList<SymbolDecl> functionDecls, SymbolTable srcSymbolTable, SymbolTable diffSymbolTable) {
        while (functionDecls != null) {
            boolean change;
            FunctionDecl functionDecl = (FunctionDecl)functionDecls.head;
            Unit copiedFunctionUnit = this.adEnv.copiedUnits.retrieve(functionDecl.unit());
            String copiedUnitName = functionDecl.unit().name();
            if (copiedFunctionUnit != null) {
                copiedUnitName = copiedFunctionUnit.name();
                if (functionDecl.unit().language() != 4) {
                    copiedUnitName = (String)this.diffCallGraph.getMixedLanguageFunctionName((String)copiedUnitName, (int)1, (int)4).first;
                }
            }
            boolean bl = change = !copiedUnitName.equals(functionDecl.unit().name());
            if (change && functionDecl.isExternalDeclared(srcSymbolTable.declarationsBlock.instructions)) {
                this.updateExternalDecl(functionDecl, srcSymbolTable, diffSymbolTable, copiedUnitName);
            }
            functionDecls = functionDecls.tail;
        }
    }

    private void updateExternalDecl(FunctionDecl functionDecl, SymbolTable srcSymbolTable, SymbolTable diffSymbolTable, String copiedUnitName) {
        Instruction externalDecl = diffSymbolTable.declarationsBlock.getOperatorDeclarationInstruction(functionDecl, 74, srcSymbolTable);
        if (externalDecl == null) {
            externalDecl = diffSymbolTable.declarationsBlock.getOperatorDeclarationInstruction(functionDecl, 199, srcSymbolTable);
        }
        if (externalDecl != null) {
            ILUtils.replaceAllIdentsNamed(externalDecl.tree, functionDecl.symbol, copiedUnitName);
        }
    }

    private void fillPassByValueInfos(TapList publicRanksTree, int argIndex, Unit unit, BoolVector unitPublicZonesUsed, BoolVector unitPublicZonesWritten, BoolVector unitPublicZonesWithDiff, BoolVector publicUsefulnessOnCallingSide, boolean[] diffArgsByValueNeedOverwrite, boolean[] diffArgsByValueNeedOnlyIncrement) {
        block10: {
            if (publicRanksTree == null) break block10;
            if (publicRanksTree.head instanceof TapList) {
                while (publicRanksTree != null) {
                    this.fillPassByValueInfos((TapList)publicRanksTree.head, argIndex, unit, unitPublicZonesUsed, unitPublicZonesWritten, unitPublicZonesWithDiff, publicUsefulnessOnCallingSide, diffArgsByValueNeedOverwrite, diffArgsByValueNeedOnlyIncrement);
                    publicRanksTree = publicRanksTree.tail;
                }
            } else {
                TapIntList publicRanks = (TapIntList)publicRanksTree.head;
                while (publicRanks != null) {
                    int publicRank = publicRanks.head;
                    if (unitPublicZonesWithDiff.get(publicRank)) {
                        if (TypeSpec.isA(unit.paramElemZoneInfo((int)publicRank).type, 6)) {
                            if (argIndex == 0) {
                                diffArgsByValueNeedOverwrite[argIndex] = true;
                            }
                        } else {
                            if (unitPublicZonesUsed.get(publicRank)) {
                                diffArgsByValueNeedOverwrite[argIndex] = true;
                            }
                            ZoneInfo zi = unit.paramElemZoneInfo(publicRank);
                            if (unitPublicZonesWritten.get(publicRank) && (publicUsefulnessOnCallingSide == null || publicUsefulnessOnCallingSide.get(publicRank))) {
                                diffArgsByValueNeedOnlyIncrement[argIndex] = false;
                            }
                        }
                    }
                    publicRanks = publicRanks.tail;
                }
            }
        }
    }

    private void createDiffUnits(Unit unit, ActivityPattern pattern) {
        Unit enclosingUnit = unit.upperLevelUnit();
        UnitDiffInfo unitDiffInfo = this.getUnitDiffInfo(unit);
        Unit diffEnclosingUnitOfTangent = null;
        Unit diffEnclosingUnitOfAdjoint = null;
        if (enclosingUnit != null) {
            UnitDiffInfo enclosingDiffInfo = this.getUnitDiffInfo(enclosingUnit);
            if (enclosingUnit.isPackage()) {
                diffEnclosingUnitOfAdjoint = diffEnclosingUnitOfTangent = enclosingDiffInfo.getDiff();
            } else if (enclosingUnit.activityPatterns == null) {
                diffEnclosingUnitOfAdjoint = diffEnclosingUnitOfTangent = this.adEnv.getPrimalCopyOfOrigUnit(enclosingUnit);
            } else {
                ActivityPattern enclosingPattern = pattern.getCallingActivityPattern(enclosingUnit, new TapList<ActivityPattern>(pattern, null));
                if (TapEnv.mustTangent()) {
                    diffEnclosingUnitOfTangent = enclosingDiffInfo.getTangent(enclosingPattern);
                }
                if (TapEnv.mustAdjoint() && (diffEnclosingUnitOfAdjoint = enclosingDiffInfo.getAdjoint(enclosingPattern)) == null) {
                    diffEnclosingUnitOfAdjoint = enclosingDiffInfo.getSplitBackward(enclosingPattern);
                }
            }
        }
        if (TapEnv.mustTangent()) {
            this.initializeDiffUnit(this.diffCallGraph.createNewUnit(diffEnclosingUnitOfTangent, unit.language()), unit, 1, -4);
            if (this.adEnv.traceCurDifferentiation || TapEnv.traceActivity() != null) {
                TapEnv.printlnOnTrace(" =Prepared tangent unit for " + unit + " wrt activity " + pattern + " => " + this.curDiffUnit + ", contained in " + this.curDiffUnit.upperLevelUnit());
            }
            unitDiffInfo.setTangent(pattern, this.curDiffUnit);
        }
        if (!unit.isModule() && TapEnv.mustAdjoint()) {
            if (unit.mustDifferentiateJoint() || !unit.mustDifferentiateSplit() || pattern.isContext()) {
                this.initializeDiffUnit(this.diffCallGraph.createNewUnit(diffEnclosingUnitOfAdjoint, unit.language()), unit, 2, -3);
                if (this.adEnv.traceCurDifferentiation || TapEnv.traceActivity() != null) {
                    TapEnv.printlnOnTrace(" =Prepared" + (pattern.isContext() ? " context" : "") + " adjoint unit for " + unit + " wrt activity " + pattern + " => " + this.curDiffUnit + ", contained in " + this.curDiffUnit.upperLevelUnit());
                }
                unitDiffInfo.setAdjoint(pattern, this.curDiffUnit);
            }
            if (unit.mustDifferentiateSplit() && !pattern.isContext()) {
                this.initializeDiffUnit(this.diffCallGraph.createNewUnit(diffEnclosingUnitOfAdjoint, unit.language()), unit, 3, -2);
                if (this.adEnv.traceCurDifferentiation || TapEnv.traceActivity() != null) {
                    TapEnv.printlnOnTrace(" =Prepared forward split adjoint unit for " + unit + " wrt activity " + pattern + " => " + this.curDiffUnit + ", contained in " + this.curDiffUnit.upperLevelUnit());
                }
                unitDiffInfo.setSplitForward(pattern, this.curDiffUnit);
                this.initializeDiffUnit(this.diffCallGraph.createNewUnit(diffEnclosingUnitOfAdjoint, unit.language()), unit, 4, -1);
                if (this.adEnv.traceCurDifferentiation || TapEnv.traceActivity() != null) {
                    TapEnv.printlnOnTrace(" =Prepared backward split adjoint unit for " + unit + " wrt activity " + pattern + " => " + this.curDiffUnit + ", contained in " + this.curDiffUnit.upperLevelUnit());
                }
                unitDiffInfo.setSplitBackward(pattern, this.curDiffUnit);
            }
        }
    }

    private void initializeDiffUnit(Unit createdDiffUnit, Unit unit, int sortOfDiffUnit, int orderOffset) {
        this.setCurDiffUnit(createdDiffUnit);
        this.curDiffUnit.setKind(unit);
        this.curDiffUnit.sortOfDiffUnit = sortOfDiffUnit;
        this.curDiffUnit.origUnit = unit;
        int n = this.curDiffUnit.arrayDimMin = unit.isFortran() ? 1 : 0;
        if (unit == this.srcCallGraph.getMainUnit()) {
            this.diffCallGraph.setMainUnit(this.curDiffUnit);
        }
        this.curDiffUnit.userHelp = new TapList<Object>(null, unit.userHelp.tail);
        this.curDiffUnit.formats = unit.formats;
        if (unit.isCalledFromOtherLanguage()) {
            this.curDiffUnit.setCalledFromOtherLanguage();
        }
        if (ILUtils.isNullOrEmptyList(unit.modifiers)) {
            this.curDiffUnit.modifiers = ILUtils.copy(unit.modifiers);
        } else if (unit.modifiers.opCode() == 2) {
            this.curDiffUnit.modifiers = ILUtils.copy(unit.modifiers);
            this.diffCallGraph.addBindFortranCDiffUnit(this.curDiffUnit);
        } else {
            Tree[] origModifiers = unit.modifiers.children();
            TapList<Tree> newModifiers = null;
            for (int i = origModifiers.length - 1; i >= 0; --i) {
                if (origModifiers[i] == null || ILUtils.getIdentString(origModifiers[i]).equals("pure")) continue;
                newModifiers = new TapList<Tree>(ILUtils.copy(origModifiers[i]), newModifiers);
            }
            this.curDiffUnit.modifiers = ILUtils.build(130, newModifiers);
        }
        this.curDiffUnit.setLanguage(unit.language());
        this.curDiffUnit.setLostComments(unit.lostComments());
        this.curDiffUnit.position = unit.getPosition() + orderOffset;
        this.curDiffUnit.preComments = unit.preComments == null ? null : unit.preComments.copy();
        this.curDiffUnit.postComments = unit.postComments == null ? null : unit.postComments.copy();
        this.curDiffUnit.preCommentsBlock = unit.preCommentsBlock == null ? null : unit.preCommentsBlock.copy();
        Tree tree = this.curDiffUnit.postCommentsBlock = unit.postCommentsBlock == null ? null : unit.postCommentsBlock.copy();
        if (unit.isInterface()) {
            this.curDiffUnit.setEntryBlock(new EntryBlock(null));
            this.curDiffUnit.setExitBlock(new ExitBlock(null));
        }
        if (unit.hasArrayNotation()) {
            this.curDiffUnit.setHasArrayNotation();
        }
    }

    public boolean patternCreatesDiffCode(ActivityPattern activityPattern, Unit srcUnit) {
        return !activityPattern.isDontDiff() && !MPIcallInfo.isMessagePassingFunction(srcUnit.name(), srcUnit.language()) && (CallGraphDifferentiator.isOrContainsActingPattern(srcUnit, activityPattern, this.activityAnalyzer(), TapEnv.reqExplicitAnalyzer()) || TapEnv.mustContext() && TapList.contains(this.adEnv.rootUnits, srcUnit) || activityPattern.isContext() && TapList.contains(this.adEnv.callersOfRootUnits, srcUnit));
    }

    private static boolean isOrContainsActingPattern(Unit unit, ActivityPattern activityPattern, ADActivityAnalyzer activityAnalyzer, ReqExplicit reqExplicitAnalyzer) {
        boolean active = CallGraphDifferentiator.isReallyActivePattern(activityPattern, activityAnalyzer, reqExplicitAnalyzer);
        if (!active) {
            TapList<Unit> containedUnits = unit.collectContainedUnits(null);
            while (!active && containedUnits != null) {
                Unit containedUnit = (Unit)containedUnits.head;
                TapList<ActivityPattern> containedUnitActivityPatterns = containedUnit.activityPatterns;
                while (!active && containedUnitActivityPatterns != null) {
                    ActivityPattern containedUnitActivityPattern = (ActivityPattern)containedUnitActivityPatterns.head;
                    if (CallGraphDifferentiator.isReallyActivePattern(containedUnitActivityPattern, activityAnalyzer, reqExplicitAnalyzer) && (activityPattern.isDisconnected() || containedUnitActivityPattern.isCalledBy(unit, activityPattern, new TapList<ActivityPattern>(containedUnitActivityPattern, null)))) {
                        active = true;
                    }
                    containedUnitActivityPatterns = containedUnitActivityPatterns.tail;
                }
                containedUnits = containedUnits.tail;
            }
        }
        return active;
    }

    private static boolean isReallyActivePattern(ActivityPattern activity, ADActivityAnalyzer activityAnalyzer, ReqExplicit reqExplicitAnalyzer) {
        boolean isReallyActive = false;
        if (activity != null) {
            isReallyActive = activityAnalyzer.isActiveUnit(activity) || reqExplicitAnalyzer != null && reqExplicitAnalyzer.isPointerActiveUnit(activity);
        }
        return isReallyActive;
    }

    private void createDiffUnitSymbolTables(TapList<TapPair<SymbolTable, SymbolTable>> contextAssociationsST) {
        if (this.curUnit.isStandard() || this.curUnit.isPackage() || this.curUnit.isInterface() || this.curUnit.isExternal() || this.curUnit.isVarFunction() && this.curUnit.publicSymbolTable() != null) {
            SymbolTable diffPublicSymbolTable = null;
            if (this.curUnit.publicSymbolTable() != null) {
                diffPublicSymbolTable = this.curUnit.publicSymbolTable().smartCopy(contextAssociationsST, this.curDiffUnit, this.diffCallGraph, this.adEnv.copiedUnits, "Diff of ");
                if (this.adEnv.traceCurDifferentiation) {
                    TapEnv.printlnOnTrace("   public:" + this.curUnit.publicSymbolTable());
                    TapEnv.printlnOnTrace("   ---->> diff public:" + diffPublicSymbolTable);
                }
                if (this.curUnit.isProcedure() || this.curUnit.isVarFunction()) {
                    diffPublicSymbolTable.declareFormalParamsLevel();
                }
                this.curDiffUnit.setPublicSymbolTable(diffPublicSymbolTable);
                CallGraphDifferentiator.declareDiffSymbolTableIfNew(this.curDiffUnit, diffPublicSymbolTable);
            }
            if (this.curUnit.privateSymbolTable() != null) {
                SymbolTable diffPrivateSymbolTable = this.curUnit.privateSymbolTable().smartCopy(contextAssociationsST, this.curDiffUnit, this.diffCallGraph, this.adEnv.copiedUnits, "Diff of ");
                if (this.adEnv.traceCurDifferentiation) {
                    TapEnv.printlnOnTrace("   private:" + this.curUnit.privateSymbolTable());
                    TapEnv.printlnOnTrace("   ---->> diff private:" + diffPrivateSymbolTable);
                }
                this.curDiffUnit.setPrivateSymbolTable(diffPrivateSymbolTable);
                CallGraphDifferentiator.declareDiffSymbolTableIfNew(this.curDiffUnit, diffPrivateSymbolTable);
                diffPrivateSymbolTable.saveList = this.curUnit.privateSymbolTable().saveList;
                diffPrivateSymbolTable.nameListList = this.curUnit.privateSymbolTable().nameListList;
            }
            if (this.curDiffUnit.entryBlock() != null) {
                this.curDiffUnit.entryBlock().symbolTable = diffPublicSymbolTable;
            }
            if (this.curDiffUnit.exitBlock() != null) {
                this.curDiffUnit.exitBlock().symbolTable = diffPublicSymbolTable;
            }
            if (this.curUnit.isStandard() || this.curUnit.isInterface() || this.curUnit.isPackage()) {
                TapList<Block> copyBodyBlocks = this.curDiffUnit.allBlocks();
                while (copyBodyBlocks != null) {
                    Block copyBodyBlock = (Block)copyBodyBlocks.head;
                    SymbolTable origST = copyBodyBlock.symbolTable;
                    copyBodyBlock.symbolTable = origST.smartCopy(contextAssociationsST, this.curDiffUnit, this.diffCallGraph, this.adEnv.copiedUnits, "Diff of ");
                    if (this.adEnv.traceCurDifferentiation) {
                        TapEnv.printlnOnTrace("   inside:" + origST);
                        TapEnv.printlnOnTrace("   ---->> diff inside:" + copyBodyBlock.symbolTable + " for Block " + copyBodyBlock);
                    }
                    CallGraphDifferentiator.declareDiffSymbolTableIfNew(this.curDiffUnit, copyBodyBlock.symbolTable);
                    copyBodyBlocks = copyBodyBlocks.tail;
                }
            }
            TapList<SymbolTable> newDiffSymbolTablesTopDown = TapList.reverse(this.curDiffUnit.symbolTablesBottomUp());
            while (newDiffSymbolTablesTopDown != null) {
                SymbolTable newDiffSymbolTable = (SymbolTable)newDiffSymbolTablesTopDown.head;
                if (newDiffSymbolTable.declarationsBlock != null) {
                    newDiffSymbolTable.declarationsBlock.symbolTable = newDiffSymbolTable;
                }
                newDiffSymbolTablesTopDown = newDiffSymbolTablesTopDown.tail;
            }
        }
    }

    private static void solveNewSymbolHoldersOfCallGraphTop(CallGraph diffCallGraph, boolean emptyCopiedUnitSuffix) {
        TapList<SymbolTable> tuSTs = diffCallGraph.getTranslationUnitSymbolTables();
        while (tuSTs != null) {
            ((SymbolTable)tuSTs.head).solveNewSymbolHolders(emptyCopiedUnitSuffix);
            tuSTs = tuSTs.tail;
        }
        diffCallGraph.cudaRootSymbolTable().solveNewSymbolHolders(emptyCopiedUnitSuffix);
        diffCallGraph.cRootSymbolTable().solveNewSymbolHolders(emptyCopiedUnitSuffix);
        diffCallGraph.fortranRootSymbolTable().solveNewSymbolHolders(emptyCopiedUnitSuffix);
        diffCallGraph.globalRootSymbolTable().solveNewSymbolHolders(emptyCopiedUnitSuffix);
        if (TapEnv.associationByAddress()) {
            diffCallGraph.globalRootSymbolTable().solveNewSymbolHolders(emptyCopiedUnitSuffix);
        }
    }

    private static void solveNewSymbolHoldersOfUnits(TapList<Unit> units, boolean emptyCopiedUnitSuffix) {
        while (units != null) {
            if (((Unit)units.head).isTranslationUnit()) {
                CallGraphDifferentiator.solveNewSymbolHoldersOfUnits(((Unit)units.head).lowerLevelUnits, emptyCopiedUnitSuffix);
            }
            CallGraphDifferentiator.solveNewSymbolHoldersOfUnit((Unit)units.head, emptyCopiedUnitSuffix);
            units = units.tail;
        }
    }

    protected static void solveNewSymbolHoldersOfUnit(Unit unit, boolean emptyCopiedUnitSuffix) {
        boolean dirNumberMaxSymbolHolderIsUsed = unit.dirNumberMaxSymbolHolder != null && unit.dirNumberMaxSymbolHolder.isUsed();
        TapList<SymbolTable> listST = unit.symbolTablesBottomUp();
        while (listST != null) {
            ((SymbolTable)listST.head).solveNewSymbolHolders(emptyCopiedUnitSuffix);
            listST = listST.tail;
        }
        if (unit.importsSymbolTable() != null) {
            unit.importsSymbolTable().solveNewSymbolHolders(emptyCopiedUnitSuffix);
        }
        if (dirNumberMaxSymbolHolderIsUsed) {
            unit.dirNumberMaxSymbolHolder.solve(unit.publicSymbolTable(), emptyCopiedUnitSuffix);
            String nbDirsMaxVarName = unit.dirNumberMaxSymbolHolder.finalName();
            if (unit.isFortran() != unit.isTranslationUnit()) {
                TapEnv.pushRelatedUnit(unit);
                TapEnv.fileWarning(15, null, "(AD10) User help requested: constant " + nbDirsMaxVarName + " must hold the maximum number of differentiation directions");
                TapEnv.popRelatedUnit();
                String msg = "the maximum number of differentiation directions";
                unit.userHelp.placdl(new TapPair<String, String>(msg, nbDirsMaxVarName));
            }
        }
    }

    private void computeCommonActivities(ActivityPattern activity) {
        BoolVector diffFormalRequired;
        Unit unit = activity.unit();
        if (unit.hasParamElemsInfo() && (diffFormalRequired = ADActivityAnalyzer.functionDiffFormalRequired(activity, true)) != null) {
            for (int i = unit.paramElemsNb() - 1; i >= 0; --i) {
                ZoneInfo zoneInfo = unit.paramElemZoneInfo(i);
                if (zoneInfo == null || zoneInfo.commonName == null || !diffFormalRequired.get(i)) continue;
                MemMap commonMap = this.adEnv.commonActivityMemoryMap.getSetMemMap(zoneInfo.commonName);
                commonMap.setActiveRegion(zoneInfo.startOffset, zoneInfo.endOffset, zoneInfo.infiniteEndOffset);
                TapList<String> varNames = zoneInfo.variableNames();
                while (varNames != null) {
                    SymbolDecl varDecl = null;
                    if (unit.privateSymbolTable() != null) {
                        varDecl = unit.privateSymbolTable().getVariableDecl((String)varNames.head);
                    }
                    if (varDecl != null) {
                        varDecl.setActive();
                    }
                    varNames = varNames.tail;
                }
            }
        }
    }

    private void computeModuleCommonActivities(Unit unit) {
        TapList<Int2ZoneInfo> zoneInfos = unit.publicSymbolTable().getAdditionalDuplicatedDeclaredZoneInfos()[0];
        while (zoneInfos != null) {
            Int2ZoneInfo iZoneInfo = (Int2ZoneInfo)zoneInfos.head;
            ZoneInfo zoneInfo = iZoneInfo.getZoneInfo();
            if (zoneInfo != null && zoneInfo.kind() == 13 && zoneInfo.commonName != null) {
                MemMap commonMap = this.adEnv.commonActivityMemoryMap.getSetMemMap(zoneInfo.commonName);
                commonMap.setActiveRegion(zoneInfo.startOffset, zoneInfo.endOffset, zoneInfo.infiniteEndOffset);
                TapList<String> varNames = zoneInfo.variableNames();
                while (varNames != null) {
                    SymbolDecl varDecl = null;
                    if (unit.privateSymbolTable() != null) {
                        varDecl = unit.privateSymbolTable().getVariableDecl((String)varNames.head);
                    }
                    if (varDecl != null) {
                        varDecl.setActive();
                    }
                    varNames = varNames.tail;
                }
            }
            zoneInfos = zoneInfos.tail;
        }
    }

    private FunctionTypeSpec buildFunctionTypeSpecOfCurDiffUnit(ActivityPattern pattern, int mode) {
        WrapperTypeSpec[] paramsTypes;
        SymbolTable diffArgsSymbolTable;
        FunctionTypeSpec functionTypeSpec = this.curUnit.functionTypeSpec();
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printlnOnTrace("  Differentiating FunctionTypeSpec of " + this.curUnit + " (of type:" + functionTypeSpec + ") in mode:" + mode + " wrt ActivityPattern:" + pattern);
        }
        boolean vectorDiffOfOutside = this.multiDirMode() && this.curUnit.isOutside();
        ArrayDim extraMultiDirArrayDim = vectorDiffOfOutside ? new ArrayDim(ILUtils.build(59), 0, null, null, -1, 0, 0) : this.varRefDifferentiator().getMultiDirDimensionMax();
        SymbolTable origArgsSymbolTable = this.curUnit.publicSymbolTable();
        if (origArgsSymbolTable == null) {
            origArgsSymbolTable = this.curUnit.externalSymbolTable();
        }
        if ((diffArgsSymbolTable = this.curDiffUnit.publicSymbolTable()) == null) {
            diffArgsSymbolTable = this.curDiffUnit.externalSymbolTable();
        }
        if (this.curDiffUnit.isOutside()) {
            diffArgsSymbolTable = this.diffCallGraph.globalRootSymbolTable();
        }
        if ((paramsTypes = functionTypeSpec.argumentsTypes) == null) {
            FunctionTypeSpec diffFuncType = new FunctionTypeSpec(new WrapperTypeSpec(new VoidTypeSpec()), new WrapperTypeSpec[0]);
            if (this.adEnv.traceCurDifferentiation) {
                TapEnv.printlnOnTrace("  [No info]--> result diff type:" + diffFuncType);
            }
            return diffFuncType;
        }
        WrapperTypeSpec returnType = functionTypeSpec.returnType;
        if (WrapperTypeSpec.isNullOrVoid(returnType)) {
            returnType = null;
        }
        WrapperTypeSpec diffReturnType = null;
        boolean[] formalArgsActivity = this.getUnitFormalArgsActivityS(pattern);
        boolean[] formalArgsPointerActivity = ReqExplicit.formalArgsPointerActivity(pattern, paramsTypes.length);
        boolean[] diffArgsByValueNeedOverwrite = null;
        if (mode == 2 || mode == 4) {
            UnitDiffInfo unitDiffInfo = this.getUnitDiffInfo(this.curUnit);
            diffArgsByValueNeedOverwrite = unitDiffInfo.getUnitDiffArgsByValueNeedOverwriteInfoS(pattern);
        }
        if (this.adEnv.traceCurDifferentiation) {
            int i;
            TapEnv.printOnTrace("    argsActivities: [");
            for (i = 0; i < paramsTypes.length; ++i) {
                if (i > 0) {
                    TapEnv.printOnTrace(", ");
                }
                TapEnv.printOnTrace((formalArgsActivity == null ? "?" : Boolean.valueOf(formalArgsActivity[i])) + ":ptr_" + (formalArgsPointerActivity == null ? "?" : Boolean.valueOf(formalArgsPointerActivity[i])) + ":ow_" + (diffArgsByValueNeedOverwrite == null ? "?" : Boolean.valueOf(diffArgsByValueNeedOverwrite[i + 1])));
            }
            i = paramsTypes.length;
            TapEnv.printlnOnTrace("  --> " + (formalArgsActivity == null ? "?" : Boolean.valueOf(formalArgsActivity[i])) + ":ptr_" + (formalArgsPointerActivity == null ? "?" : Boolean.valueOf(formalArgsPointerActivity[i])) + "]");
        }
        TapList<WrapperTypeSpec> diffArgTypes = null;
        if (this.multiDirMode()) {
            diffArgTypes = new TapList<WrapperTypeSpec>(new WrapperTypeSpec(new PrimitiveTypeSpec("integer")), diffArgTypes);
        }
        if (returnType != null && (formalArgsActivity == null || formalArgsActivity[paramsTypes.length] || formalArgsPointerActivity[paramsTypes.length])) {
            WrapperTypeSpec returnTypeToDiff = vectorDiffOfOutside ? (WrapperTypeSpec)returnType.copy() : returnType;
            diffReturnType = returnTypeToDiff.differentiateTypeSpecMemo(diffArgsSymbolTable, origArgsSymbolTable, this.curDiffUnitSort(), this.suffixes()[1][3], false, this.multiDirMode(), extraMultiDirArrayDim, this.curUnit.name() + "'s result", this.curUnit.name() + "_res", null, null);
            if (diffReturnType == null || diffReturnType.equalsCompilDep(returnType)) {
                diffReturnType = returnType;
            } else if (WrapperTypeSpec.isNullOrVoid(diffReturnType)) {
                diffReturnType = null;
            }
        }
        if (!pattern.isContext() && mode == 2 || mode == 4) {
            if (diffReturnType != null) {
                for (int iReplic = TapEnv.diffReplica() - 1; iReplic >= 0; --iReplic) {
                    diffArgTypes = new TapList<WrapperTypeSpec>(diffReturnType, diffArgTypes);
                }
            }
            diffReturnType = new WrapperTypeSpec(new VoidTypeSpec());
        } else if (diffReturnType != null) {
            if (!pattern.isContext() && !this.procedureCallDifferentiator().diffFunctionIsFunction(this.curUnit)) {
                if (MixedLanguageInfos.passesByValue(this.curUnit.language(), this.curUnit.language())) {
                    diffReturnType = new WrapperTypeSpec(new PointerTypeSpec(diffReturnType, null));
                }
                for (int iReplic = TapEnv.diffReplica() - 1; iReplic >= 0; --iReplic) {
                    diffArgTypes = new TapList<WrapperTypeSpec>(diffReturnType, diffArgTypes);
                }
                diffReturnType = new WrapperTypeSpec(new VoidTypeSpec());
            }
            if (returnType != null && !TapEnv.associationByAddress()) {
                if (MixedLanguageInfos.passesByValue(this.curUnit.language(), this.curUnit.language())) {
                    returnType = new WrapperTypeSpec(new PointerTypeSpec(returnType, null));
                }
                diffArgTypes = new TapList<WrapperTypeSpec>(returnType, diffArgTypes);
            }
        } else if (!pattern.isContext() && !this.procedureCallDifferentiator().diffFunctionIsFunction(this.curUnit)) {
            if (returnType != null) {
                diffArgTypes = new TapList<WrapperTypeSpec>(returnType, diffArgTypes);
            }
            diffReturnType = new WrapperTypeSpec(new VoidTypeSpec());
        } else {
            WrapperTypeSpec wrapperTypeSpec = diffReturnType = returnType != null ? returnType : new WrapperTypeSpec(new VoidTypeSpec());
        }
        if (formalArgsActivity != null) {
            for (int i = paramsTypes.length - 1; i >= 0; --i) {
                WrapperTypeSpec paramType = paramsTypes[i];
                if (formalArgsActivity[i] || formalArgsPointerActivity[i]) {
                    WrapperTypeSpec paramTypeToDiff = vectorDiffOfOutside ? (WrapperTypeSpec)paramType.copy() : paramType;
                    WrapperTypeSpec diffParamType = paramTypeToDiff.differentiateTypeSpecMemo(diffArgsSymbolTable, origArgsSymbolTable, this.curDiffUnitSort(), this.suffixes()[1][3], false, this.multiDirMode(), extraMultiDirArrayDim, this.curUnit.name() + "'s arg" + (i + 1), this.curUnit.name() + "_arg" + (i + 1), null, null);
                    if (diffParamType == null) {
                        diffParamType = paramType;
                    } else if (diffParamType.equalsLiterally(paramType)) {
                        diffParamType = paramType;
                    }
                    if (this.multiDirMode() && !TypeSpec.isA(diffParamType, 3) && this.curUnit.takesArgumentByValue(i + 1, this.curUnit.language()) && (mode == 2 || mode == 4) && diffArgsByValueNeedOverwrite[i + 1]) {
                        diffParamType = new WrapperTypeSpec(new PointerTypeSpec(diffParamType, null));
                    }
                    for (int iReplic = TapEnv.diffReplica() - 1; iReplic >= 0; --iReplic) {
                        diffArgTypes = new TapList<WrapperTypeSpec>(diffParamType, diffArgTypes);
                    }
                }
                if (TapEnv.associationByAddress() && (formalArgsActivity[i] || formalArgsPointerActivity[i])) continue;
                diffArgTypes = new TapList<WrapperTypeSpec>(paramType, diffArgTypes);
            }
        }
        FunctionTypeSpec diffFuncType = new FunctionTypeSpec(diffReturnType, diffArgTypes);
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printlnOnTrace("  --> result diff type:" + diffFuncType);
        }
        return diffFuncType;
    }

    private void differentiateVarFunctionUnit(ActivityPattern activity) {
        Unit sourceUnit = activity.unit();
        UnitDiffInfo sourceDiffInfo = this.getUnitDiffInfo(sourceUnit);
        TapList<Unit> diffUnits = sourceDiffInfo.getAllDiffs(activity);
        while (diffUnits != null) {
            this.setCurDiffUnit((Unit)diffUnits.head);
            this.curDiffUnit.setVarFunction();
            this.flowGraphDifferentiator().initializeMultiDirMode();
            if (this.curDiffUnit == sourceDiffInfo.getAdjoint(activity)) {
                this.curDiffUnit.functionTypeSpec().returnType = new WrapperTypeSpec(new VoidTypeSpec());
            }
            diffUnits = diffUnits.tail;
        }
    }

    private void differentiatePackage(Unit sourceUnit, TapList<TapPair<SymbolTable, SymbolTable>> rootAssociationsST) {
        this.setCurDiffUnit(this.getUnitDiffInfo(sourceUnit).getDiff());
        if (this.curDiffUnit.isDiffPackage().booleanValue()) {
            String sourceName = sourceUnit.name();
            this.unitDiffTimer.reset();
            if (sourceUnit.isFortran() && sourceUnit.isModule()) {
                TapEnv.printOnTrace(15, "@@ Differentiation of module: " + sourceName + (TapEnv.mustTangent() ? " in TGT" : (TapEnv.mustAdjoint() ? " in ADJ" : " in COPY")));
            } else {
                TapEnv.printOnTrace(15, "@@ Differentiation of package: " + sourceName + (TapEnv.mustTangent() ? " in TGT" : (TapEnv.mustAdjoint() ? " in ADJ" : " in COPY")));
            }
            if (this.adEnv.someUnitsAreTraced()) {
                TapEnv.printlnOnTrace(15);
            }
            this.flowGraphDifferentiator().initializeMultiDirMode();
            int sort = TapEnv.mustTangent() ? 1 : (TapEnv.mustAdjoint() ? 2 : 0);
            this.adEnv.setCurDiffSorts(sort, sort);
            if (sourceUnit.isTranslationUnit()) {
                this.curDiffUnit.setName(sourceName);
            } else {
                this.curDiffUnit.parametersOrModuleNameTree = this.varRefDifferentiator().diffSymbolName(null, sourceName, this.curDiffUnit.publicSymbolTable(), false, false, true, null, null, true, 1, 1, 2, null);
                this.curDiffUnit.publicSymbolTable().saveList = sourceUnit.publicSymbolTable().saveList;
                this.flowGraphDifferentiator().differentiateSaveList(this.curDiffUnit.privateSymbolTable());
                this.flowGraphDifferentiator().differentiateSaveList(this.curDiffUnit.protectedSymbolTable());
                this.flowGraphDifferentiator().differentiateSaveList(this.curDiffUnit.publicSymbolTable());
            }
            TapList<Block> diffBlocks = this.curDiffUnit.allBlocks();
            while (diffBlocks != null) {
                Block diffBlock = (Block)diffBlocks.head;
                if (this.adEnv.traceCurDifferentiation) {
                    TapEnv.printlnOnTrace("----------- DIFFERENTIATION OF " + sourceName + " package's Block: " + diffBlock);
                    TapEnv.printlnOnTrace("  Block contents before differentiation:");
                    TapList<Instruction> diffInstrs = diffBlock.instructions;
                    int i = 1;
                    while (diffInstrs != null) {
                        System.out.println("       " + i + " :: " + diffInstrs.head);
                        diffInstrs = diffInstrs.tail;
                        ++i;
                    }
                }
                SymbolTable diffST = diffBlock.symbolTable;
                SymbolTable origST = diffST.getExistingOrig(rootAssociationsST);
                this.blockDifferentiator().differentiateDeclarationsOfBlock(diffBlock, this.curDiffUnitSort() == 1 ? 1 : -1, sourceUnit, origST, diffST, sourceUnit.language(), false);
                if (this.adEnv.traceCurDifferentiation) {
                    TapEnv.printlnOnTrace("  Block contents after differentiation:");
                    TapList<Instruction> diffInstrs = diffBlock.instructions;
                    int i = 1;
                    while (diffInstrs != null) {
                        System.out.println("       " + i + " :: " + diffInstrs.head);
                        diffInstrs = diffInstrs.tail;
                        ++i;
                    }
                }
                diffBlocks = diffBlocks.tail;
            }
            CallGraphDifferentiator.solveNewSymbolHoldersOfUnit(this.curDiffUnit, this.adEnv.emptyCopiedUnitSuffix);
            TapEnv.printlnOnTrace(15, ", time " + this.unitDiffTimer.elapsed() + " s");
        } else {
            TapEnv.printlnOnTrace(15, "@@ " + (sourceUnit.isClass() ? "Class " : (sourceUnit.isModule() ? "Module " : "File ")) + sourceUnit.name() + " not differentiated");
            this.diffCallGraph.deleteUnit(this.curDiffUnit);
        }
    }

    private void differentiateInterface() {
        String unitName = this.curUnit.name();
        TapEnv.printlnOnTrace(15, "@@ Differentiation of interface: " + unitName);
        Tree origCallTree = this.curUnit.headTree();
        for (int mode = 4; mode > 0; --mode) {
            int dSort = mode == 1 ? 1 : 2;
            this.adEnv.setCurDiffSorts(dSort, dSort);
            TapList<ActivityPattern> activityPatterns = this.curUnit.activityPatterns;
            while (activityPatterns != null) {
                ActivityPattern pattern = (ActivityPattern)activityPatterns.head;
                this.setCurDiffUnit(this.adEnv.getDiffOfUnit(this.curUnit, pattern, mode));
                if (this.curDiffUnit != null) {
                    VariableDecl returnVarNameDecl;
                    this.curDiffUnit.setInterface();
                    this.flowGraphDifferentiator().initializeMultiDirMode();
                    SymbolTable diffPublicSymbolTable = this.curDiffUnit.publicSymbolTable();
                    Tree diffCallTree = this.procedureCallDifferentiator().differentiateProcedureHeader(origCallTree, null, null, null, this.curDiffUnit.publicSymbolTable(), this.curUnit.publicSymbolTable(), mode, null);
                    Instruction diffInstruction = new Instruction(diffCallTree);
                    diffInstruction.setPosition(this.curUnit.entryBlock().headInstr());
                    this.curDiffUnit.entryBlock().addInstrTl(diffInstruction);
                    this.curDiffUnit.parametersOrModuleNameTree = ILUtils.getArguments(diffCallTree);
                    if (mode == 2 && this.curUnit.isAFunction() && !this.curUnit.isAContext()) {
                        this.curDiffUnit.functionTypeSpec().returnType = new WrapperTypeSpec(new VoidTypeSpec());
                    }
                    if (!this.multiDirMode() && (returnVarNameDecl = diffPublicSymbolTable.getTopVariableDecl(this.curUnit.name())) == null && this.curUnit.otherReturnVar() != null) {
                        String otherReturnVarName = this.curUnit.otherReturnVar().symbol;
                        returnVarNameDecl = diffPublicSymbolTable.getTopVariableDecl(otherReturnVarName);
                        this.flowGraphDifferentiator().declareDiffIsReturnVar(returnVarNameDecl, this.curUnit, this.curDiffUnit);
                    }
                    Block diffBlock0 = diffPublicSymbolTable.declarationsBlock;
                    diffBlock0.rank = 0;
                    this.curDiffUnit.addBlock(diffBlock0);
                    BasicBlock tmpBlock = new BasicBlock(null, null, null);
                    tmpBlock.copyInstructions((Block)this.curUnit.allBlocks().head, this.adEnv.copiedIncludes);
                    diffBlock0.addInstrDeclTl(tmpBlock.instructions);
                    if (this.curUnit.publicSymbolTable().declarationsBlock.instructions != null) {
                        tmpBlock = new BasicBlock(null, null, null);
                        tmpBlock.copyInstructions(this.curUnit.publicSymbolTable().declarationsBlock, this.adEnv.copiedIncludes);
                        diffBlock0.addInstrDeclTl(tmpBlock.instructions);
                    }
                    this.blockDifferentiator().differentiateDeclarationsOfBlock(diffBlock0, this.curDiffUnitSort() == 1 ? 1 : -1, this.curUnit, this.curUnit.publicSymbolTable(), this.curDiffUnit.privateSymbolTable(), this.curUnit.language(), false);
                    new FGArrow((Block)this.curDiffUnit.entryBlock(), 0, null, (Block)this.curDiffUnit.allBlocks().head, false);
                }
                activityPatterns = activityPatterns.tail;
            }
        }
    }

    protected void collectDiffSubUnits(Unit srcSubUnit, int differentiationMode, TapList<Unit> toDiffSubUnitsFwd, TapList<Unit> toDiffSubUnitsBwd) {
        Unit copySubUnit;
        if (this.adEnv.curUnitIsContext) {
            toDiffSubUnitsBwd = toDiffSubUnitsFwd;
        }
        UnitDiffInfo subUnitDiffInfo = this.getUnitDiffInfo(srcSubUnit);
        Unit unit = copySubUnit = this.unitsHavePrimal.retrieve(srcSubUnit) == Boolean.TRUE ? this.adEnv.getPrimalCopyOfOrigUnit(srcSubUnit) : null;
        if (differentiationMode == 1) {
            toDiffSubUnitsFwd.tail = TapList.union(toDiffSubUnitsFwd.tail, subUnitDiffInfo.getAllDiffs(1));
            if (copySubUnit != null) {
                toDiffSubUnitsFwd.tail = TapList.addLast(toDiffSubUnitsFwd.tail, copySubUnit);
            }
        } else if (differentiationMode == -1) {
            toDiffSubUnitsBwd.tail = TapList.union(toDiffSubUnitsBwd.tail, subUnitDiffInfo.getAllDiffs(2));
            toDiffSubUnitsBwd.tail = TapList.union(toDiffSubUnitsBwd.tail, subUnitDiffInfo.getAllDiffs(3));
            toDiffSubUnitsBwd.tail = TapList.union(toDiffSubUnitsBwd.tail, subUnitDiffInfo.getAllDiffs(4));
            if (copySubUnit != null) {
                toDiffSubUnitsBwd.tail = TapList.addLast(toDiffSubUnitsBwd.tail, copySubUnit);
            }
        } else if (differentiationMode == -2) {
            toDiffSubUnitsFwd.tail = TapList.union(toDiffSubUnitsFwd.tail, subUnitDiffInfo.getAllDiffs(3));
            if (copySubUnit != null) {
                toDiffSubUnitsFwd.tail = TapList.addLast(toDiffSubUnitsFwd.tail, copySubUnit);
            }
            toDiffSubUnitsBwd.tail = TapList.union(toDiffSubUnitsBwd.tail, subUnitDiffInfo.getAllDiffs(2));
            toDiffSubUnitsBwd.tail = TapList.union(toDiffSubUnitsBwd.tail, subUnitDiffInfo.getAllDiffs(4));
        }
    }

    private void initializeMultiDirNumberMax(SymbolTable diffRootST) {
        int arrayDimMin;
        int n = arrayDimMin = TapEnv.relatedLanguageIsC() ? 0 : 1;
        if (TapEnv.get().fixedNbdirsmaxString != null) {
            this.varRefDifferentiator().multiDirDimensionMax = new ArrayDim(ILUtils.buildDimColon(arrayDimMin, ILUtils.build(96, TapEnv.get().fixedNbdirsmaxString)), null, null, null, -1, 0, 0);
        } else if (this.varRefDifferentiator().dirNumberMaxSymbolHolder == null) {
            this.varRefDifferentiator().dirNumberMaxSymbolHolder = new NewSymbolHolder("NBDirsMax");
            this.varRefDifferentiator().dirNumberMaxSymbolHolder.setAsConstantVariable(this.adEnv.integerTypeSpec, null, ILUtils.build(96, "TO_BE_DEFINED"));
            this.varRefDifferentiator().dirNumberMaxSymbolHolder.declarationLevelMustInclude(diffRootST);
            this.varRefDifferentiator().dirNumberMaxSymbolHolder.declare = false;
            this.varRefDifferentiator().multiDirDimensionMax = new ArrayDim(ILUtils.buildDimColon(arrayDimMin, this.varRefDifferentiator().dirNumberMaxSymbolHolder.makeNewRef(diffRootST)), null, null, null, -1, 0, 0);
        }
    }

    protected static void declareDiffSymbolTableIfNew(Unit diffUnit, SymbolTable diffSymbolTable) {
        if (!TapList.contains(diffUnit.symbolTablesBottomUp(), diffSymbolTable)) {
            diffUnit.addDerivedSymbolTable(diffSymbolTable);
        }
    }

    private void updateAllUsages(Unit unit, String oldUnitName, Unit diffUnit) {
        InterfaceDecl newIntfDecl;
        TapList<FunctionDecl> funDecls;
        TapList<Block> blocks = unit.allBlocks();
        String diffFuncName = diffUnit.name();
        if (!unit.sameLanguage(diffUnit.language()) && this.diffCallGraph.getOtherLangFunctionDeclFromBindC(oldUnitName, 1) == null) {
            diffFuncName = (String)this.diffCallGraph.getMixedLanguageFunctionName((String)diffFuncName, (int)diffUnit.language(), (int)unit.language()).first;
            oldUnitName = (String)this.diffCallGraph.getMixedLanguageFunctionName((String)oldUnitName, (int)diffUnit.language(), (int)unit.language()).first;
        }
        if (unit.entryBlock() != null && unit.entryBlock().instructions != null) {
            Instruction instruction = (Instruction)unit.entryBlock().instructions.head;
            ILUtils.replaceAllIdentsNamed(ILUtils.getArguments(instruction.tree), oldUnitName, diffFuncName);
        }
        while (blocks != null) {
            Block block = (Block)blocks.head;
            this.updateAllUsagesInBlock(block, oldUnitName, diffUnit, diffFuncName);
            blocks = blocks.tail;
        }
        SymbolTable funcInPrivateOrPublicST = unit.bodySymbolTable();
        FunctionDecl funDecl = null;
        if (funcInPrivateOrPublicST != null) {
            funDecls = funcInPrivateOrPublicST.getTopFunctionDecl(oldUnitName, null, null, false);
            FunctionDecl functionDecl = funDecl = funDecls == null ? null : (FunctionDecl)funDecls.head;
        }
        if (funDecl == null && unit.publicSymbolTable() != null) {
            funcInPrivateOrPublicST = unit.publicSymbolTable();
            funDecls = funcInPrivateOrPublicST.getTopFunctionDecl(oldUnitName, null, null, false);
            funDecl = funDecls == null ? null : (FunctionDecl)funDecls.head;
        }
        SymbolTable intfInPrivateOrPublicST = unit.bodySymbolTable();
        InterfaceDecl intfDecl = null;
        if (intfInPrivateOrPublicST != null) {
            intfDecl = intfInPrivateOrPublicST.getTopInterfaceDecl(oldUnitName);
        }
        if (intfDecl == null && unit.publicSymbolTable() != null) {
            intfInPrivateOrPublicST = unit.publicSymbolTable();
            intfDecl = intfInPrivateOrPublicST.getTopInterfaceDecl(oldUnitName);
        }
        Tree treeName = ILUtils.build(96, diffFuncName);
        FunctionDecl newFunDecl = new FunctionDecl(treeName, diffUnit);
        if (funDecl != null) {
            if (funDecl.unit().enclosingUnitOfInterface != null) {
                newFunDecl.unit().enclosingUnitOfInterface = funDecl.unit().enclosingUnitOfInterface;
            }
            TapList<String> extraInfo = funDecl.extraInfo();
            newFunDecl.setInstruction(funDecl);
            funDecl.isConsideredRemoved = true;
            funcInPrivateOrPublicST.addSymbolDecl(newFunDecl);
            newFunDecl.setExtraInfo(extraInfo);
        }
        if (intfDecl != null && (newIntfDecl = intfInPrivateOrPublicST.getTopInterfaceDecl(diffUnit.name())) != null) {
            intfInPrivateOrPublicST.removeInterfaceDecl(oldUnitName, intfDecl.kind, true);
        }
    }

    private void updateAllUsagesInBlock(Block block, String oldUnitName, Unit diffUnit, String diffUnitCallName) {
        TapList<Instruction> instructions = block.instructions;
        while (instructions != null) {
            Instruction instruction = (Instruction)instructions.head;
            if (instruction.tree.opCode() == 197) {
                ILUtils.replaceAllIdentsNamed(instruction.tree.down(1), oldUnitName, diffUnitCallName);
            } else if (instruction.tree.opCode() == 199) {
                ILUtils.replaceAllIdentsNamed(instruction.tree.down(3), oldUnitName, diffUnitCallName);
            } else if (instruction.tree.opCode() == 74) {
                ILUtils.replaceAllIdentsNamed(instruction.tree, oldUnitName, diffUnitCallName);
            } else if (instruction.tree.opCode() == 106) {
                Tree interfaces = instruction.tree.down(2);
                for (int i = 1; i <= interfaces.length(); ++i) {
                    Tree oneInterface = interfaces.down(i).down(1);
                    if (oneInterface.opCode() == 89) {
                        if (ILUtils.getIdentString(oneInterface.down(4)).equals(oldUnitName)) {
                            oneInterface.down(4).setValue(diffUnitCallName);
                            if (!diffUnit.isAFunction()) continue;
                            oneInterface.down(4).setAnnotation("explicitReturnVar", ILUtils.build(96, oldUnitName));
                            continue;
                        }
                        Unit sourceUnit = (Unit)oneInterface.down(4).getAnnotation("sourceUnit");
                        if (sourceUnit != null && oldUnitName.equals(sourceUnit.name()) || ILUtils.getIdentString(oneInterface.down(4)).equals(diffUnitCallName)) continue;
                        ILUtils.replaceAllIdentsNamed(oneInterface, oldUnitName, diffUnitCallName);
                        continue;
                    }
                    ILUtils.replaceAllIdentsNamed(oneInterface, oldUnitName, diffUnitCallName);
                }
            }
            ILUtils.replaceAllCallName(instruction.tree, oldUnitName, diffUnitCallName, null, block.symbolTable);
            Tree sourceTree = (Tree)instruction.tree.getAnnotation("sourcetree");
            if (sourceTree != null) {
                ILUtils.replaceAllCallName(sourceTree, oldUnitName, diffUnitCallName, null, block.symbolTable);
            }
            instructions = instructions.tail;
        }
    }

    protected void updateAllUsagesDiffFuncResultName(Unit unit, String oldUnitName, Unit diffUnit, Tree diffFuncResultName) {
        String diffFuncName = diffUnit.name();
        if (!unit.sameLanguage(diffUnit.language()) && this.diffCallGraph.getOtherLangFunctionDeclFromBindC(oldUnitName, 1) == null) {
            diffFuncName = (String)this.diffCallGraph.getMixedLanguageFunctionName((String)diffFuncName, (int)diffUnit.language(), (int)unit.language()).first;
            oldUnitName = (String)this.diffCallGraph.getMixedLanguageFunctionName((String)oldUnitName, (int)diffUnit.language(), (int)unit.language()).first;
        }
        TapList<Block> diffBlocks = diffUnit.allBlocks();
        while (diffBlocks != null) {
            TapList<Instruction> diffInstrs = ((Block)diffBlocks.head).instructions;
            while (diffInstrs != null) {
                ILUtils.replaceAllCallName(((Instruction)diffInstrs.head).tree, oldUnitName, diffFuncName, diffFuncResultName, ((Block)diffBlocks.head).symbolTable);
                diffInstrs = diffInstrs.tail;
            }
            diffBlocks = diffBlocks.tail;
        }
    }

    private void updateAllAccessDecls(TapList<Instruction> instructions, String oldUnitName, Unit diffUnit) {
        while (instructions != null) {
            Instruction instr = (Instruction)instructions.head;
            if (instr.tree.opCode() == 2) {
                ILUtils.replaceAllIdentsNamed(instr.tree.down(2), oldUnitName, diffUnit.name());
            }
            instructions = instructions.tail;
        }
    }

    private void updateRenamedTypeDecl(Unit diffUnit) {
        if (diffUnit.privateSymbolTable() != null) {
            TapList<Instruction> useDecls = diffUnit.privateSymbolTable().declarationsBlock.instructions;
            while (useDecls != null && ((Instruction)useDecls.head).tree.opCode() == 197) {
                Tree[] onlyVisibleTrees;
                Tree useDeclTree = ((Instruction)useDecls.head).tree;
                Tree infoTree = useDeclTree.down(2);
                for (Tree visibleTree : onlyVisibleTrees = infoTree.children()) {
                    NewSymbolHolder sHolder;
                    SymbolDecl symbolDecl;
                    Tree onlyVisibleTree = visibleTree;
                    if (onlyVisibleTree.opCode() != 165 || (symbolDecl = diffUnit.publicSymbolTable().getSymbolDecl(ILUtils.baseName(onlyVisibleTree.down(1)))) == null || !symbolDecl.isA(4) || (sHolder = symbolDecl.getDiffSymbolHolder(0, null, 0)) == null) continue;
                    TypeDecl fromTypeDecl = (TypeDecl)symbolDecl.importedFrom.first;
                    TypeDecl diffTypeDecl = sHolder.newTypeDecl();
                    if (diffTypeDecl.importedFrom == null) {
                        diffTypeDecl.importedFrom = new TapPair<Object, Object>(null, null);
                    }
                    diffTypeDecl.importedFrom.first = fromTypeDecl.getDiffSymbolHolder(0, null, 0).newTypeDecl();
                }
                useDecls = useDecls.tail;
            }
        }
    }

    private void updateModulesAndCopiedUnitsInCopiedUnit(SymbolTable copiedSymbolTable) {
        if (copiedSymbolTable != null && copiedSymbolTable.declarationsBlock != null) {
            TapList<Instruction> declarationInstructions = copiedSymbolTable.declarationsBlock.instructions;
            while (declarationInstructions != null) {
                Tree declarationTree = ((Instruction)declarationInstructions.head).tree;
                if (declarationTree != null) {
                    if (declarationTree.opCode() == 197) {
                        Unit diffModule;
                        String moduleName = ILUtils.getIdentString(declarationTree.down(1));
                        FunctionDecl moduleDecl = copiedSymbolTable.getModuleDecl(moduleName);
                        if (moduleDecl != null && moduleDecl.unit().isDiffPackage().booleanValue() && (diffModule = this.getUnitDiffInfo(moduleDecl.unit()).getDiff()) != null) {
                            declarationTree.setChild(ILUtils.build(96, diffModule.name()), 1);
                        }
                    } else if (declarationTree.opCode() == 106) {
                        this.blockDifferentiator().updateModulesAndCopiedUnitsInCopiedInterface(declarationTree, copiedSymbolTable, 0);
                    }
                }
                declarationInstructions = declarationInstructions.tail;
            }
        }
    }

    private void updateAAInCopiedUnits() {
        for (int i = this.srcCallGraph.nbUnits() - 1; i >= 0; --i) {
            this.setCurUnitEtc(this.adEnv.srcCallGraph().sortedUnit(i));
            Unit origCopyUnit = this.adEnv.copiedUnits.retrieve(this.curUnit);
            if (this.curUnit.isExternal() || origCopyUnit == null) continue;
            TapEnv.printlnOnTrace(15, "@@ Update copied unit: " + this.curUnit);
            this.setCurDiffUnit(origCopyUnit);
            TapList<Block> allOrigBlocks = this.curUnit.allBlocks();
            TapList<Block> allCopyBlocks = origCopyUnit.allBlocks();
            while (allOrigBlocks != null) {
                this.updateAAInCopiedBlock((Block)allOrigBlocks.head, (Block)allCopyBlocks.head);
                allOrigBlocks = allOrigBlocks.tail;
                allCopyBlocks = allCopyBlocks.tail;
            }
        }
    }

    private void updateAAInCopiedBlock(Block origBlock, Block copyBlock) {
        TapList<Instruction> instructions = copyBlock.instructions;
        int rank = 0;
        while (instructions != null) {
            Instruction instruction = (Instruction)instructions.head;
            this.adEnv.setCurInstruction(instruction);
            this.blockDifferentiator().updateAACopiedInstruction(instruction, origBlock, copyBlock, rank);
            this.blockDifferentiator().updateAAInstructionMask(instruction, origBlock.symbolTable, copyBlock.symbolTable);
            instructions = instructions.tail;
            ++rank;
        }
        this.adEnv.setCurInstruction(null);
    }

    private void placeDebugMidPointIfNone(Unit unit) {
        Block middleBlock;
        boolean hasDebugPoint = false;
        TapList<Block> allBlocks = unit.allBlocks();
        while (!hasDebugPoint && allBlocks != null) {
            TapList<Instruction> instructions = ((Block)allBlocks.head).instructions;
            while (!hasDebugPoint && instructions != null) {
                hasDebugPoint = ((Instruction)instructions.head).hasDirective(18) != null;
                instructions = instructions.tail;
            }
            allBlocks = allBlocks.tail;
        }
        if (!hasDebugPoint && (middleBlock = unit.middleNormalBlock()) != null && middleBlock.instructions != null) {
            Instruction middleInstruction = middleBlock.headInstr();
            Directive debugADHereDir = new Directive(18);
            debugADHereDir.arguments = new Tree[3];
            debugADHereDir.arguments[0] = ILUtils.build(96, "middle");
            debugADHereDir.arguments[1] = ILUtils.build(96, ".FALSE.");
            debugADHereDir.arguments[2] = ILUtils.build(96, ".FALSE.");
            middleInstruction.directives = new TapList<Directive>(debugADHereDir, middleInstruction.directives);
        }
    }
}

