/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.differentiation;

import fr.inria.tapenade.analysis.ADActivityAnalyzer;
import fr.inria.tapenade.analysis.ADTBRAnalyzer;
import fr.inria.tapenade.analysis.ActivityPattern;
import fr.inria.tapenade.analysis.DataFlowAnalyzer;
import fr.inria.tapenade.analysis.DiffLivenessAnalyzer;
import fr.inria.tapenade.analysis.ReqExplicit;
import fr.inria.tapenade.differentiation.CallGraphDifferentiator;
import fr.inria.tapenade.differentiation.DiffAssignmentNode;
import fr.inria.tapenade.differentiation.DifferentiationEnv;
import fr.inria.tapenade.differentiation.DynMemoryDifferentiator;
import fr.inria.tapenade.differentiation.ExpressionDifferentiator;
import fr.inria.tapenade.differentiation.FlowGraphDifferentiator;
import fr.inria.tapenade.differentiation.NewBlockGraph;
import fr.inria.tapenade.differentiation.NewBlockGraphNode;
import fr.inria.tapenade.differentiation.ProcedureCallDifferentiator;
import fr.inria.tapenade.differentiation.UnitDiffInfo;
import fr.inria.tapenade.differentiation.VarRefDifferentiator;
import fr.inria.tapenade.representation.AlignmentBoundary;
import fr.inria.tapenade.representation.ArrayDim;
import fr.inria.tapenade.representation.ArrayTypeSpec;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.BlockStorage;
import fr.inria.tapenade.representation.CallArrow;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.CompositeTypeSpec;
import fr.inria.tapenade.representation.Directive;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.FieldDecl;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.FunctionTypeSpec;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.InstructionMask;
import fr.inria.tapenade.representation.InterfaceDecl;
import fr.inria.tapenade.representation.IterDescriptor;
import fr.inria.tapenade.representation.LoopBlock;
import fr.inria.tapenade.representation.MPIcallInfo;
import fr.inria.tapenade.representation.MemMap;
import fr.inria.tapenade.representation.ModifiedTypeSpec;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.RefDescriptor;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TemporaryBlock;
import fr.inria.tapenade.representation.TypeDecl;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.ToInt;
import fr.inria.tapenade.utils.ToObject;
import fr.inria.tapenade.utils.Tree;

public class BlockDifferentiator {
    protected int numRebase = 0;
    protected DifferentiationEnv adEnv;
    protected TapList<NewSymbolHolder> inUseNewSymbolHolders;
    private NewBlockGraph fwdInstructionsGraph;
    private NewBlockGraph bwdInstructionsGraph;
    private TapList<TapTriplet<Tree, Instruction, Instruction>> hdRevDeclarations;
    private TapList<TapTriplet<Tree, Instruction, Instruction>> tlRevDeclarations;
    private TapList<TapTriplet<Tree, Instruction, Instruction>> toTlRevDeclarations;
    private boolean firstFwdDiff = true;
    private Tree waitingComments;
    private Tree waitingCommentsBlock;
    private Instruction fromInclude;
    private TapList<Tree> tempVarsForDebug;
    private TapList<TapTriplet<Boolean, TapList<RefDescriptor>, TapList<RefDescriptor>>> curStaticSaves = null;

    protected BlockDifferentiator(DifferentiationEnv adEnv) {
        this.adEnv = adEnv;
    }

    protected static Tree debugLabel(String name, int num) {
        return ILUtils.build(180, name + (num < 10 ? "0" : "") + num);
    }

    private static boolean usesPassiveFields(Tree expression, SymbolTable symbolTable) {
        if (expression.opCode() == 75 && TapEnv.doActivity() && !BlockDifferentiator.isAnActiveField(expression, symbolTable)) {
            return true;
        }
        if (expression.opCode() == 75 || expression.opCode() == 9 || expression.opCode() == 151) {
            return BlockDifferentiator.usesPassiveFields(expression.down(1), symbolTable);
        }
        return false;
    }

    private static boolean isAnActiveField(Tree expression, SymbolTable symbolTable) {
        int i = ILUtils.getFieldRank(expression.down(2));
        WrapperTypeSpec typeSpec = symbolTable.typeOf(expression.down(1));
        if (typeSpec == null) {
            return false;
        }
        if (TypeSpec.isA(typeSpec = typeSpec.baseTypeSpec(false), 21) && i >= 0) {
            if (TapEnv.doActivity()) {
                return ((CompositeTypeSpec)typeSpec.wrappedType).isDifferentiatedField(i);
            }
            FieldDecl[] fields = ((CompositeTypeSpec)typeSpec.wrappedType).fields;
            return TypeSpec.isDifferentiableType(fields[i].type());
        }
        return false;
    }

    private static boolean moduleNameInModulesList(TapList<Unit> modules, String moduleName) {
        boolean result = false;
        while (!result && modules != null) {
            result = ((Unit)modules.head).name().equals(moduleName);
            modules = modules.tail;
        }
        return result;
    }

    protected static TapList<ActivityPattern> patternsCalledByPattern(Unit calledUnit, ActivityPattern callingPattern) {
        TapList<Object> hdResult;
        TapList<ActivityPattern> calledPatterns = calledUnit.activityPatterns;
        TapList<Object> tlResult = hdResult = new TapList<Object>(null, null);
        while (calledPatterns != null) {
            ActivityPattern calledPattern = (ActivityPattern)calledPatterns.head;
            if ((callingPattern == null || callingPattern.isDisconnected() || calledPattern.isDisconnected() || TapList.contains(calledPattern.callingPatterns(), callingPattern)) && (calledPattern.isActive() || calledPattern.isContext() || calledUnit.isInterface())) {
                tlResult = tlResult.placdl(calledPattern);
            }
            calledPatterns = calledPatterns.tail;
        }
        return hdResult.tail;
    }

    private static void accumulateRW(TapPair<TapList<Tree>, TapList<Tree>> rw, TapPair<TapList<Tree>, TapList<Tree>> rwNew) {
        rw.first = TapList.append((TapList)rwNew.first, (TapList)rw.first);
        rw.second = TapList.append((TapList)rwNew.second, (TapList)rw.second);
    }

    protected static Tree replaceAllocateInExprToInitialize(Tree exprToInitialize) {
        switch (exprToInitialize.opCode()) {
            case 5: {
                exprToInitialize = BlockDifferentiator.replaceAllocateInExprToInitialize(exprToInitialize.down(1));
                break;
            }
            case 9: 
            case 75: 
            case 151: {
                Tree newSon1 = BlockDifferentiator.replaceAllocateInExprToInitialize(exprToInitialize.down(1));
                if (newSon1 == exprToInitialize.down(1)) break;
                exprToInitialize.setChild(ILUtils.copy(newSon1), 1);
                break;
            }
        }
        return exprToInitialize;
    }

    private static boolean containsOpArrayDeclarator(VariableDecl varDecl, int operator) {
        boolean result = false;
        if (varDecl != null && varDecl.hasInstructionWithRootOperatorAndArrayDeclarator(operator)) {
            result = true;
        }
        return result;
    }

    private void removeDecl(TapList<Tree> trees) {
        while (trees != null) {
            Tree decl = (Tree)trees.head;
            decl.parent().removeChild(decl.rankInParent());
            trees = trees.tail;
        }
    }

    private CallGraphDifferentiator callGraphDifferentiator() {
        return this.adEnv.callGraphDifferentiator;
    }

    private FlowGraphDifferentiator flowGraphDifferentiator() {
        return this.adEnv.flowGraphDifferentiator;
    }

    private ProcedureCallDifferentiator procedureCallDifferentiator() {
        return this.adEnv.procedureCallDifferentiator;
    }

    private DynMemoryDifferentiator dynMemoryDifferentiator() {
        return this.adEnv.dynMemoryDifferentiator;
    }

    private ExpressionDifferentiator expressionDifferentiator() {
        return this.adEnv.expressionDifferentiator;
    }

    private VarRefDifferentiator varRefDifferentiator() {
        return this.adEnv.varRefDifferentiator;
    }

    private ADActivityAnalyzer activityAnalyzer() {
        return TapEnv.adActivityAnalyzer();
    }

    private boolean multiDirMode() {
        return this.adEnv.multiDirMode;
    }

    private String[][] suffixes() {
        return this.adEnv.suffixes;
    }

    private Unit curDiffUnit() {
        return this.adEnv.curDiffUnit;
    }

    private Unit curFwdDiffUnit() {
        return this.adEnv.curFwdDiffUnit;
    }

    private int curDiffUnitSort() {
        return this.adEnv.curDiffUnitSort;
    }

    private int curDiffVarSort() {
        return this.adEnv.curDiffVarSort;
    }

    private Block curBlock() {
        return this.adEnv.curBlock;
    }

    private int[] curVectorMap() {
        return this.adEnv.curVectorMap;
    }

    private int[] curDiffVectorMap() {
        return this.adEnv.curDiffVectorMap;
    }

    protected void addInUseNewSymbolHolder(NewSymbolHolder tmpVarHolder) {
        this.inUseNewSymbolHolders = new TapList<NewSymbolHolder>(tmpVarHolder, this.inUseNewSymbolHolders);
    }

    protected void addFuturePlainNodeFwd(Tree tree, InstructionMask whereMask, boolean loopIfMultiDir, TapList<Tree> treesRead, TapList<Tree> treesWritten, TapList<Tree> treesReadBis, TapList<Tree> treesWrittenBis, boolean followPointers, boolean hiddenDep, String description, boolean isMainCorrespondent) {
        if (this.adEnv.traceCurBlock != 0) {
            TapEnv.printlnOnTrace("      -> (FWD+) " + description + " : " + ILUtils.toString(tree, this.adEnv.curActivity()) + (loopIfMultiDir && this.multiDirMode() ? " (multi-dir)" : ""));
        }
        Tree refTree = this.adEnv.curInstruction().tree;
        TapEnv.setSourceCodeCorrespondence(refTree, tree, isMainCorrespondent, true);
        NewBlockGraphNode newNode = new NewBlockGraphNode(4, tree, loopIfMultiDir && this.multiDirMode(), this.adEnv.curInstruction(), whereMask);
        newNode.overwritesUsed = true;
        newNode.recomputeText();
        if (this.fromInclude != null && this.fromInclude.tree != null) {
            newNode.fromInclude = this.fromInclude;
            if (!TapEnv.get().expandDiffIncludeFile) {
                boolean isPrimalCode;
                Instruction diffInclude = this.fromInclude;
                boolean bl = isPrimalCode = treesReadBis == null && treesWrittenBis == null;
                if (!TapEnv.alreadyDiffInclude(diffInclude.tree.stringValue())) {
                    diffInclude = Instruction.differentiateChainedIncludes(diffInclude, this.suffixes()[this.curDiffUnitSort()][1], isPrimalCode);
                }
                newNode.fromInclude = diffInclude;
            }
        }
        if (this.firstFwdDiff) {
            this.firstFwdDiff = false;
            if (this.waitingComments != null) {
                newNode.preComments = ILUtils.appendComments(newNode.preComments, this.waitingComments);
                this.waitingComments = null;
            }
            if (this.waitingCommentsBlock != null) {
                newNode.preCommentsBlock = ILUtils.appendComments(newNode.preCommentsBlock, this.waitingCommentsBlock);
                this.waitingCommentsBlock = null;
            }
        }
        this.fwdInstructionsGraph.addDataDepNode(newNode, true, hiddenDep, followPointers, TapEnv.get().mergeDiffInstructions, treesRead, treesWritten, treesReadBis, treesWrittenBis);
    }

    protected void addFuturePlainNodeBwd(Tree tree, InstructionMask whereMask, boolean loopIfMultiDir, TapList<Tree> treesRead, TapList<Tree> treesWritten, TapList<Tree> treesReadBis, TapList<Tree> treesWrittenBis, boolean followPointers, boolean hiddenDep, String description, boolean isMainCorrespondent) {
        Tree refTree;
        if (this.adEnv.traceCurBlock != 0) {
            TapEnv.printlnOnTrace("      -> (+BWD) " + description + " : " + ILUtils.toString(tree, this.adEnv.curActivity()) + (loopIfMultiDir && this.multiDirMode() ? " (multi-dir)" : ""));
        }
        Tree tree2 = refTree = this.adEnv.curInstruction() == null ? null : this.adEnv.curInstruction().tree;
        if (tree != null && refTree != null) {
            TapEnv.setSourceCodeCorrespondence(refTree, tree, isMainCorrespondent, true);
        }
        NewBlockGraphNode newNode = new NewBlockGraphNode(4, tree, loopIfMultiDir && this.multiDirMode(), this.adEnv.curInstruction(), whereMask);
        newNode.overwritesUsed = true;
        newNode.recomputeText();
        this.bwdInstructionsGraph.addDataDepNode(newNode, false, hiddenDep, followPointers, TapEnv.get().mergeDiffInstructions, treesRead, treesWritten, treesReadBis, treesWrittenBis);
    }

    protected void addFutureSetDiffNodeBwd(DiffAssignmentNode adjAssign, String description) {
        if (this.adEnv.traceCurBlock != 0) {
            TapEnv.printlnOnTrace("      -> (+BWD) " + description + ": " + adjAssign);
        }
        NewBlockGraphNode newNode = new NewBlockGraphNode(3, null, this.multiDirMode(), this.adEnv.curInstruction(), adjAssign.mask);
        newNode.assignedRef = adjAssign.diffRecv;
        newNode.primRecv = adjAssign.primRecv;
        newNode.iReplic = adjAssign.iReplic;
        newNode.overwritesUsed = TapList.intersectTreeEquals(adjAssign.diffW, adjAssign.diffR);
        newNode.diffValue = adjAssign.diffValue;
        newNode.recomputeText();
        this.bwdInstructionsGraph.addDataDepNode(newNode, false, false, false, TapEnv.get().mergeDiffInstructions, adjAssign.primR, adjAssign.primW, adjAssign.diffR, adjAssign.diffW);
    }

    private void addFutureIncrDiffNodeBwd(DiffAssignmentNode adjAssign, String description) {
        if (this.adEnv.traceCurBlock != 0) {
            TapEnv.printlnOnTrace("      -> (+BWD) " + description + ": " + adjAssign);
        }
        NewBlockGraphNode newNode = new NewBlockGraphNode(2, null, this.multiDirMode(), this.adEnv.curInstruction(), adjAssign.mask);
        newNode.assignedRef = adjAssign.diffRecv;
        newNode.primRecv = adjAssign.primRecv;
        newNode.iReplic = adjAssign.iReplic;
        newNode.overwritesUsed = true;
        newNode.diffValue = adjAssign.diffValue;
        newNode.recomputeText();
        this.bwdInstructionsGraph.addDataDepNode(newNode, false, false, false, TapEnv.get().mergeDiffInstructions, adjAssign.primR, adjAssign.primW, adjAssign.diffR, adjAssign.diffW);
    }

    private void addFutureBwdSplitDecl(Tree decl, String description) {
        if (this.adEnv.traceCurBlock != 0) {
            TapEnv.printlnOnTrace("      -> (BWD DECL+) " + description + " : " + decl);
        }
        this.toTlRevDeclarations.tail = this.toTlRevDeclarations.tail.placdl(new TapTriplet<Tree, Instruction, Instruction>(decl, this.adEnv.curInstruction(), this.fromInclude));
    }

    protected void differentiateBlock(Block block, Block fwdBlock, Block bwdBlock, int differentiationMode, ToBool lastTestLive) {
        TapList<Object> hdFwdInstructions;
        BoolVector beforeUseful;
        BoolVector beforeActiv;
        TapList<TapPair<TapList<Instruction>, TapList<Instruction>>> blockRecomputations;
        TapList<TapPair<BoolVector, BoolVector>> blockTBRs;
        TapList<BoolVector> blockAvlXs;
        TapList<BoolVector> blockReqXs;
        TapList<BoolVector> blockUsefulnesses;
        TapList<BoolVector> blockActivities;
        SymbolTable diffSymbolTable;
        boolean isAdj;
        boolean isDebug;
        this.adEnv.traceCurBlock = 0;
        assert (fwdBlock != null);
        if (this.adEnv.traceCurDifferentiation) {
            int n = TapEnv.get().traceBlockRk == -99 ? 1 : (this.adEnv.traceCurBlock = block.rank == TapEnv.get().traceBlockRk ? 2 : 0);
            if (this.adEnv.traceCurBlock != 0) {
                TapEnv.printlnOnTrace("*** NOW Differentiating Block:" + block + " in mode " + differentiationMode + " with pattern " + this.adEnv.curActivity() + ": " + block.instructions);
                TapEnv.printlnOnTrace("  PARALLELCONTROLS: block:" + block.parallelControls + " fwdBlock:" + (fwdBlock == null ? "NULLBLOCK" : fwdBlock.parallelControls) + " bwdBlock:" + (bwdBlock == null ? "NULLBLOCK" : bwdBlock.parallelControls));
            }
        }
        boolean bl = isDebug = TapEnv.debugAdMode() != 0;
        boolean bl2 = isDebug ? TapEnv.debugAdMode() == -1 : (isAdj = this.curDiffUnitSort() == 2);
        String traceFuncPrefix = isDebug ? "adDebug" + (isAdj ? (differentiationMode == 1 ? "Fwd_" : "Bwd_") : "Tgt_") : "adContext" + (isAdj ? "Adj_" : (TapEnv.get().complexStep ? "Cpx_" : "Tgt_"));
        SymbolTable symbolTable = diffSymbolTable = bwdBlock == null || this.adEnv.curUnitIsContext || differentiationMode == 1 ? fwdBlock.symbolTable : bwdBlock.symbolTable;
        if (block.rank == -99) {
            blockActivities = ((TemporaryBlock)block).blockActivities;
            blockUsefulnesses = ((TemporaryBlock)block).blockUsefulnesses;
            blockReqXs = ((TemporaryBlock)block).blockReqXs;
            blockAvlXs = ((TemporaryBlock)block).blockAvlXs;
            blockTBRs = ((TemporaryBlock)block).blockTBRs;
            blockRecomputations = ((TemporaryBlock)block).blockRecomputations;
        } else {
            blockActivities = this.adEnv.unitActivities == null ? null : this.adEnv.unitActivities.retrieve(block);
            blockUsefulnesses = this.adEnv.unitUsefulnesses == null ? null : this.adEnv.unitUsefulnesses.retrieve(block);
            blockReqXs = this.adEnv.unitReqXs == null ? null : this.adEnv.unitReqXs.retrieve(block);
            blockAvlXs = this.adEnv.unitAvlXs == null ? null : this.adEnv.unitAvlXs.retrieve(block);
            blockTBRs = this.adEnv.unitTBRs == null ? null : this.adEnv.unitTBRs.retrieve(block);
            blockRecomputations = this.adEnv.unitRecomputations == null ? null : this.adEnv.unitRecomputations.retrieve(block);
        }
        this.adEnv.setCurBlock(block);
        this.adEnv.setCurSymbolTable(block.symbolTable);
        this.adEnv.setCurFwdSymbolTable(fwdBlock == null ? null : fwdBlock.symbolTable);
        this.adEnv.setCurBwdSymbolTable(bwdBlock == null ? null : bwdBlock.symbolTable);
        TapList<Instruction> instructions = block.instructions;
        this.adEnv.setCurVectorMap(DataFlowAnalyzer.makeMap3(0, 0, this.adEnv.curSymbolTable().declaredZonesNb(0)));
        this.adEnv.setCurDiffVectorMap(DataFlowAnalyzer.makeMap3(0, 0, this.adEnv.curSymbolTable().declaredZonesNb(this.adEnv.diffKind)));
        this.adEnv.setCurPtrVectorMap(DataFlowAnalyzer.makeMap3(0, 0, this.adEnv.curSymbolTable().declaredZonesNb(3)));
        BoolVector boolVector = beforeActiv = blockActivities == null ? null : (BoolVector)blockActivities.head;
        if (!TapEnv.doActivity() && beforeActiv == null) {
            beforeActiv = new BoolVector(DataFlowAnalyzer.mapSize(this.curDiffVectorMap()));
            beforeActiv.setTrue();
        }
        BoolVector boolVector2 = beforeUseful = blockUsefulnesses == null ? null : (BoolVector)blockUsefulnesses.head;
        if (!TapEnv.doActivity() && beforeUseful == null) {
            beforeUseful = new BoolVector(DataFlowAnalyzer.mapSize(this.curDiffVectorMap()));
            beforeUseful.setTrue();
        }
        BoolVector beforeReqX = blockReqXs == null ? null : (BoolVector)blockReqXs.head;
        BoolVector beforeAvlX = blockAvlXs == null ? null : (BoolVector)blockAvlXs.head;
        Tree srcResult = null;
        Tree srcCallTree = null;
        TapList<?> resultPointerActivity = null;
        TapList<Object> containedUnitsFwd = new TapList<Object>(null, null);
        TapList<Object> containedUnitsBwd = new TapList<Object>(null, null);
        this.adEnv.toTotalZones.head = this.adEnv.curSymbolTable().freeDeclaredZone(0);
        this.adEnv.toActiveTmpZones.tail = null;
        this.fwdInstructionsGraph = new NewBlockGraph(this.adEnv, this.adEnv.curSymbolTable(), this.adEnv.curSymbolTable().freeDeclaredZone(0));
        if (!this.multiDirMode() || !TapEnv.get().mergeDiffInstructions || differentiationMode != 1) {
            this.fwdInstructionsGraph.openGroup();
        }
        this.bwdInstructionsGraph = new NewBlockGraph(this.adEnv, this.adEnv.curSymbolTable(), this.adEnv.curSymbolTable().freeDeclaredZone(0) + 5);
        if (this.adEnv.traceCurBlock == 2) {
            this.bwdInstructionsGraph.debug = true;
        }
        if (this.adEnv.traceCurBlock == 2 && this.multiDirMode()) {
            this.fwdInstructionsGraph.debug = true;
        }
        if (!TapEnv.get().mergeDiffInstructions) {
            this.bwdInstructionsGraph.openGroup();
        }
        this.hdRevDeclarations = new TapList<Object>(null, null);
        this.tlRevDeclarations = this.hdRevDeclarations;
        this.toTlRevDeclarations = new TapList<TapTriplet<Tree, Instruction, Instruction>>(null, this.tlRevDeclarations);
        this.waitingComments = null;
        this.waitingCommentsBlock = null;
        boolean modeIsJoint = differentiationMode == -1;
        boolean curUnitIsCopied = !this.adEnv.curActivity().isActive() && this.callGraphDifferentiator().unitsHaveDiff.retrieve(this.adEnv.curUnit()) == Boolean.TRUE;
        TapList<Tree> beforeActivTrees = null;
        TapList<Tree> afterActivTrees = null;
        if (blockRecomputations != null && blockRecomputations.head != null) {
            this.buildBwdRecomputations((TapPair)blockRecomputations.head, beforeActiv, blockActivities != null && blockActivities.tail != null ? (BoolVector)blockActivities.tail.head : null, beforeAvlX, blockReqXs != null && blockReqXs.tail != null ? (BoolVector)blockReqXs.tail.head : null);
        }
        while (instructions != null) {
            BoolVector beforeTBROnDiffPtr;
            BoolVector beforeTBR;
            BoolVector afterAvlX;
            BoolVector afterReqX;
            BoolVector afterUseful;
            BoolVector afterActiv;
            if (blockActivities != null) {
                blockActivities = blockActivities.tail;
                afterActiv = (BoolVector)blockActivities.head;
            } else {
                afterActiv = null;
            }
            if (!TapEnv.doActivity() && afterActiv == null) {
                afterActiv = beforeActiv;
            }
            if (blockUsefulnesses != null) {
                blockUsefulnesses = blockUsefulnesses.tail;
                afterUseful = (BoolVector)blockUsefulnesses.head;
            } else {
                afterUseful = null;
            }
            if (!TapEnv.doActivity() && afterUseful == null) {
                afterUseful = beforeUseful;
            }
            if (blockReqXs != null) {
                blockReqXs = blockReqXs.tail;
                afterReqX = (BoolVector)blockReqXs.head;
            } else {
                afterReqX = null;
            }
            if (blockAvlXs != null) {
                blockAvlXs = blockAvlXs.tail;
                afterAvlX = (BoolVector)blockAvlXs.head;
            } else {
                afterAvlX = null;
            }
            if (blockTBRs != null) {
                beforeTBR = (BoolVector)((TapPair)blockTBRs.head).first;
                beforeTBROnDiffPtr = (BoolVector)((TapPair)blockTBRs.head).second;
                blockTBRs = blockTBRs.tail;
            } else {
                beforeTBR = null;
                beforeTBROnDiffPtr = null;
            }
            if (blockRecomputations != null) {
                blockRecomputations = blockRecomputations.tail;
            }
            this.tempVarsForDebug = null;
            this.adEnv.setCurInstruction((Instruction)instructions.head);
            this.firstFwdDiff = true;
            Tree srcFullTree = this.adEnv.curInstruction().tree;
            Unit definedUnit = (Unit)srcFullTree.getAnnotation("Unit");
            if (definedUnit != null) {
                if (this.adEnv.traceCurBlock != 0) {
                    TapEnv.printlnOnTrace("    --- differentiating definition location of " + definedUnit);
                }
                this.callGraphDifferentiator().collectDiffSubUnits(definedUnit, differentiationMode, containedUnitsFwd, containedUnitsBwd);
                if (this.adEnv.traceCurBlock != 0) {
                    TapEnv.printlnOnTrace("       Cumul contained Units for fwd:" + containedUnitsFwd);
                    TapEnv.printlnOnTrace("       Cumul contained Units for bwd:" + containedUnitsBwd);
                }
            } else {
                TapList<Tree> instructionsOnZones;
                Tree arg;
                TapList<Tree> args;
                ActivityPattern calledActivity;
                Unit calledUnit;
                Tree srcTree;
                TapList<Tree> srcSplitTrees;
                Tree dbadTree;
                Directive debugADHereDir = this.adEnv.curInstruction().hasDirective(18);
                if (TapEnv.debugAdMode() != 0 && debugADHereDir != null && !this.adEnv.curUnitIsContext) {
                    BoolVector activeHere = beforeActiv;
                    if (!TapEnv.doActivity() && activeHere == null) {
                        activeHere = new BoolVector(DataFlowAnalyzer.mapSize(this.curDiffVectorMap()));
                        activeHere.setTrue();
                    }
                    TapList<Tree> activHereTrees = this.collectTrueTrees(activeHere, this.curDiffVectorMap(), this.adEnv.curSymbolTable());
                    String placeName = "PP" + this.flowGraphDifferentiator().debugPointsCounter;
                    ++this.flowGraphDifferentiator().debugPointsCounter;
                    if (debugADHereDir.arguments.length > 0) {
                        placeName = ILUtils.getIdentString(debugADHereDir.arguments[0]);
                    }
                    Tree okHere = null;
                    if (debugADHereDir.arguments.length > 1) {
                        okHere = ILUtils.cleanBoolCopy(debugADHereDir.arguments[1], this.curDiffUnit());
                    }
                    if (okHere == null) {
                        okHere = ILUtils.build(28, this.curDiffUnit().isC() ? "1" : "TRUE");
                    }
                    Tree forcedOkHere = null;
                    if (debugADHereDir.arguments.length > 2) {
                        forcedOkHere = ILUtils.cleanBoolCopy(debugADHereDir.arguments[2], this.curDiffUnit());
                    }
                    if (forcedOkHere == null) {
                        forcedOkHere = ILUtils.build(28, this.curDiffUnit().isC() ? "0" : "FALSE");
                    }
                    dbadTree = this.flowGraphDifferentiator().placeDebugADTests(this.curDiffUnit(), srcFullTree, activeHere, this.curDiffVectorMap(), 0, this.adEnv.curSymbolTable(), this.adEnv.curSymbolTable().declaredZonesNb(this.adEnv.diffKind), placeName, null, okHere, forcedOkHere);
                    if (differentiationMode == 1) {
                        this.addFuturePlainNodeFwd(dbadTree, null, false, null, activHereTrees, null, activHereTrees, true, true, "Debug-instrument actives before debug mark " + placeName + " in tangent", false);
                    } else {
                        this.addFuturePlainNodeBwd(dbadTree, null, false, null, activHereTrees, null, activHereTrees, true, true, "Debug-instrument actives after debug mark " + placeName + " in DifferentiationConstants.ADJOINT", false);
                    }
                }
                if (this.adEnv.traceCurBlock != 0) {
                    String blockDiffMapName = "[s" + this.adEnv.curUnit().rank() + ":r||d" + block.symbolTable.rank() + ":r]";
                    TapEnv.printlnOnTrace("  === Differentiating source Instruction: " + ILUtils.toString(srcFullTree, this.adEnv.curActivity()) + "  " + blockDiffMapName + " " + (beforeActiv == null ? "null" : beforeActiv.toString(this.curDiffVectorMap())) + "=>" + (afterActiv == null ? "null" : afterActiv.toString(this.curDiffVectorMap())));
                }
                this.waitingComments = ILUtils.appendComments(this.waitingComments, this.adEnv.curInstruction().preComments);
                this.waitingCommentsBlock = ILUtils.appendComments(this.waitingCommentsBlock, this.adEnv.curInstruction().preCommentsBlock);
                this.adEnv.toActiveTmpZones.tail = null;
                if (differentiationMode == 1) {
                    srcSplitTrees = new TapList<Tree>(srcFullTree, null);
                } else {
                    srcSplitTrees = new TapList<Object>(null, null);
                    this.splitForADReverse(srcFullTree, false, false, false, srcSplitTrees, modeIsJoint);
                    srcSplitTrees = TapList.nreverse(srcSplitTrees.tail);
                }
                this.adEnv.activeRootCalledFromContext = false;
                if (this.adEnv.curUnitIsContext) {
                    TapList<Tree> inSrcSplitTrees = srcSplitTrees;
                    while (!this.adEnv.activeRootCalledFromContext && inSrcSplitTrees != null) {
                        srcTree = (Tree)inSrcSplitTrees.head;
                        srcResult = null;
                        srcCallTree = null;
                        if (srcTree != null && srcTree.opCode() == 199 && !this.adEnv.curUnit().isFortran9x()) {
                            TapPair<Tree, Tree> declAndInit = ILUtils.splitDeclInit(srcTree, false, this.adEnv.curUnit());
                            srcTree = (Tree)declAndInit.second;
                        }
                        if (srcTree != null && (srcTree.opCode() == 14 || srcTree.opCode() == 150 || srcTree.opCode() == 125 || srcTree.opCode() == 190 || srcTree.opCode() == 63)) {
                            srcResult = srcTree.down(1);
                            srcTree = srcTree.down(2);
                        }
                        if (srcTree != null && srcTree.opCode() == 31) {
                            srcCallTree = srcTree;
                        }
                        if (srcCallTree != null && (calledUnit = DataFlowAnalyzer.getCalledUnit(srcCallTree, this.adEnv.curSymbolTable())).isStandard()) {
                            calledActivity = (ActivityPattern)ActivityPattern.getAnnotationForActivityPattern(srcCallTree, this.adEnv.curActivity(), "multiActivityCalleePatterns");
                            this.adEnv.activeRootCalledFromContext = calledActivity != null && calledActivity.isActive() && !calledActivity.isContext() && calledActivity.diffPattern() != null;
                        }
                        inSrcSplitTrees = inSrcSplitTrees.tail;
                    }
                }
                if (this.adEnv.curUnitIsContext && !this.adEnv.activeRootCalledFromContext && srcFullTree.opCode() != 168) {
                    srcSplitTrees = new TapList<Tree>(srcFullTree, null);
                }
                if (this.adEnv.curUnitIsContext && this.adEnv.activeRootCalledFromContext) {
                    ActivityPattern curCalledActivity = (ActivityPattern)ActivityPattern.getAnnotationForActivityPattern(srcCallTree, this.adEnv.curActivity(), "multiActivityCalleePatterns");
                    Tree[] actualParamTreeS = ILUtils.getArguments(srcCallTree).children();
                    beforeActiv = DataFlowAnalyzer.propagateDataToCallSite(curCalledActivity.callActivity(), srcResult, actualParamTreeS, this.curDiffVectorMap(), this.adEnv.curInstruction(), (CallArrow)srcCallTree.getAnnotation("callArrow"), true, true, this.adEnv.diffKind);
                    afterActiv = DataFlowAnalyzer.propagateDataToCallSite(curCalledActivity.exitActivity(), srcResult, actualParamTreeS, this.curDiffVectorMap(), this.adEnv.curInstruction(), (CallArrow)srcCallTree.getAnnotation("callArrow"), true, true, this.adEnv.diffKind);
                    beforeActivTrees = this.collectTrueTrees(beforeActiv, this.curDiffVectorMap(), this.adEnv.curSymbolTable());
                    afterActivTrees = this.collectTrueTrees(afterActiv, this.curDiffVectorMap(), this.adEnv.curSymbolTable());
                    args = null;
                    if (isDebug && !isAdj) {
                        arg = ILUtils.build(103, 0);
                        args = new TapList<Tree>(arg, null);
                    }
                    arg = ILUtils.build(160, this.curDiffUnit().isC() ? "0.87" : "0.87_8");
                    args = new TapList<Tree>(arg, args);
                    if (isDebug && isAdj) {
                        arg = ILUtils.build(160, this.curDiffUnit().isC() ? "1.e-1" : "0.1_8");
                        args = new TapList<Tree>(arg, args);
                    }
                    if (!isAdj) {
                        boolean singlePrecision = this.hasActiveSinglePrecision(this.adEnv.curSymbolTable(), beforeActiv, afterActiv, this.curDiffVectorMap());
                        String epsValue = singlePrecision ? (this.curDiffUnit().isC() ? "1.e-4" : "1.e-4_8") : (this.curDiffUnit().isC() ? "1.e-8" : "1.e-8_8");
                        arg = ILUtils.build(160, epsValue);
                        args = new TapList<Tree>(arg, args);
                    }
                    dbadTree = ILUtils.buildCall(ILUtils.tapenadeUtilityFunctionName(this.curDiffUnit(), traceFuncPrefix + "init"), ILUtils.build(71, args));
                    this.addFuturePlainNodeFwd(dbadTree, null, false, null, null, null, null, true, true, "Start instrumentation before entering diff fragment", false);
                    instructionsOnZones = this.flowGraphDifferentiator().instructionsOnDeclaredZones(srcFullTree, this.adEnv.curSymbolTable(), diffSymbolTable, isDebug && isAdj ? "adDebugAdj_w" : traceFuncPrefix + "init", this.curDiffUnit(), differentiationMode == 1 ? beforeActiv : afterActiv, this.curDiffVectorMap(), !isDebug || !isAdj, true, true, this.adEnv.curSymbolTable().declaredZonesNb(this.adEnv.diffKind), null);
                    if (isDebug && isAdj) {
                        arg = ILUtils.build(103, 0);
                        args = new TapList<Tree>(arg, null);
                        arg = ILUtils.build(180, differentiationMode == 1 ? "start" : "end");
                        if (this.curDiffUnit().isFortran()) {
                            arg = ILUtils.concatWithNull(arg);
                        }
                        args = new TapList<Tree>(arg, args);
                        dbadTree = ILUtils.buildCall(ILUtils.tapenadeUtilityFunctionName(this.curDiffUnit(), "adDebugAdj_wDisplay"), ILUtils.build(71, args));
                        instructionsOnZones = TapList.append(instructionsOnZones, new TapList<Tree>(dbadTree, null));
                        arg = ILUtils.build(180, differentiationMode == 1 ? "start" : "end");
                        if (this.curDiffUnit().isFortran()) {
                            arg = ILUtils.concatWithNull(arg);
                        }
                        args = new TapList<Tree>(arg, null);
                        dbadTree = ILUtils.build(98, ILUtils.buildCall(ILUtils.tapenadeUtilityFunctionName(this.curDiffUnit(), traceFuncPrefix + "here"), ILUtils.build(71, args)), ILUtils.build(27, instructionsOnZones));
                        instructionsOnZones = new TapList<Tree>(dbadTree, null);
                    }
                    while (instructionsOnZones != null) {
                        this.addFuturePlainNodeFwd((Tree)instructionsOnZones.head, null, false, null, differentiationMode == 1 ? beforeActivTrees : afterActivTrees, null, differentiationMode == 1 ? beforeActivTrees : afterActivTrees, true, true, "Instrument actives before entering diff fragment", false);
                        instructionsOnZones = instructionsOnZones.tail;
                    }
                }
                while (srcSplitTrees != null) {
                    boolean mustSaveTBROnDiffPtr;
                    boolean assignsPointer;
                    String unaryName;
                    srcTree = ILUtils.copy((Tree)srcSplitTrees.head);
                    if (this.adEnv.traceCurBlock != 0) {
                        String oldActiveMark = TapEnv.activeMark();
                        String oldReqXMark = TapEnv.reqXMark();
                        TapEnv.setActiveMark("@");
                        TapEnv.setReqXMark("#");
                        TapEnv.printlnOnTrace("    --- differentiating source Tree: " + ILUtils.toString(srcTree, this.adEnv.curActivity()));
                        TapEnv.setActiveMark(oldActiveMark);
                        TapEnv.setReqXMark(oldReqXMark);
                    }
                    this.inUseNewSymbolHolders = null;
                    this.fromInclude = this.adEnv.curInstruction().fromInclude();
                    boolean hasDeclaration = false;
                    Tree srcDecl = null;
                    Tree srcAction = null;
                    srcResult = null;
                    if (srcTree == null || !ILUtils.isADeclaration(srcTree) && srcTree.opCode() != 51) {
                        srcAction = srcTree;
                    } else if (srcTree.opCode() == 199 && !this.adEnv.curUnit().isFortran9x()) {
                        TapPair<Tree, Tree> declAndInit = ILUtils.splitDeclInit(srcTree, false, this.adEnv.curUnit());
                        srcDecl = (Tree)declAndInit.first;
                        srcAction = (Tree)declAndInit.second;
                        hasDeclaration = true;
                    } else {
                        srcDecl = srcTree;
                        hasDeclaration = true;
                    }
                    srcResult = null;
                    srcCallTree = null;
                    calledUnit = null;
                    calledActivity = null;
                    boolean diffCallNeeded = false;
                    Unit diffCalledUnit = null;
                    boolean normalCheckpointedCall = true;
                    boolean splitAdjointCall = false;
                    if (srcAction != null) {
                        if (srcAction.opCode() == 31) {
                            srcResult = null;
                            srcCallTree = srcAction;
                        } else if (srcAction.opCode() == 14 && srcAction.down(2).opCode() == 31) {
                            srcResult = srcAction.down(1);
                            srcCallTree = srcAction.down(2);
                        } else if (srcAction.opCode() == 14 || srcAction.opCode() == 150 || srcAction.opCode() == 125 || srcAction.opCode() == 190 || srcAction.opCode() == 63) {
                            srcResult = srcAction.down(1);
                        }
                    }
                    if (srcCallTree != null) {
                        calledUnit = DataFlowAnalyzer.getCalledUnit(srcCallTree, this.adEnv.curSymbolTable());
                        calledActivity = (ActivityPattern)ActivityPattern.getAnnotationForActivityPattern(srcCallTree, this.adEnv.curActivity(), "multiActivityCalleePatterns");
                        resultPointerActivity = null;
                        if (srcResult != null) {
                            TapList<?> writtenZonesTree = this.adEnv.curSymbolTable().treeOfZonesOfValue(srcResult, null, this.adEnv.curInstruction(), null);
                            resultPointerActivity = DataFlowAnalyzer.buildInfoBoolTreeOfDeclaredZones(writtenZonesTree, afterReqX, this.curVectorMap(), null, 0, this.adEnv.curSymbolTable());
                        }
                        diffCallNeeded = calledActivity != null && this.callGraphDifferentiator().diffCallNeeded(srcCallTree, this.adEnv.curActivity(), calledUnit, calledActivity, beforeAvlX, afterReqX, resultPointerActivity, block, this.adEnv.curInstruction());
                        diffCalledUnit = calledActivity == null ? null : this.adEnv.getDiffOfUnit(calledUnit, calledActivity, this.curDiffUnitSort());
                        splitAdjointCall = this.adEnv.curInstruction().hasDirective(12) != null || calledUnit.hasDirective(12) != null;
                        normalCheckpointedCall = !this.adEnv.curUnitIsContext && differentiationMode != 1 && !splitAdjointCall;
                    }
                    boolean isMPICall = calledUnit != null && MPIcallInfo.isMessagePassingFunction(calledUnit.name(), calledUnit.language());
                    boolean isIncrement = false;
                    if (srcAction != null && srcAction.opCode() == 194 && (unaryName = ILUtils.getIdentString(srcAction.down(1))) != null && (unaryName.equals("++prefix") || unaryName.equals("++postfix") || unaryName.equals("--prefix") || unaryName.equals("--postfix"))) {
                        isIncrement = true;
                    }
                    boolean bl3 = assignsPointer = srcResult != null && TypeSpec.isA(this.adEnv.curSymbolTable().typeOf(srcResult), 6);
                    if (this.adEnv.traceCurDifferentiation && this.adEnv.traceCurBlock != 0) {
                        TapEnv.printlnOnTrace("        SRCTREE:" + srcTree + " SRCDECL:" + srcDecl + " SRCACTION:" + srcAction + " CALLEDUNIT:" + calledUnit + " DIFFCALLNEEDED:" + diffCallNeeded);
                    }
                    boolean mustSaveTBROther = TapEnv.debugAdMode() == -1 || !TapEnv.removeDeadPrimal() || this.adEnv.curUnitIsContext || curUnitIsCopied || TapEnv.diffLivenessAnalyzer() == null || diffCallNeeded && !normalCheckpointedCall || !this.adEnv.curUnitIsActiveUnit || isMPICall || !TapEnv.removeDeadControl() && !TapEnv.mustAdjoint() || hasDeclaration && srcAction != null && this.isAConstantDeclInit(srcAction);
                    String reasonForMustSaveTBROther = null;
                    if (this.adEnv.traceCurDifferentiation && this.adEnv.traceCurBlock != 0) {
                        reasonForMustSaveTBROther = (TapEnv.debugAdMode() == -1 ? "T|" : "F|") + (!TapEnv.removeDeadPrimal() ? "T|" : "F|") + (this.adEnv.curUnitIsContext ? "T|" : "F|") + (curUnitIsCopied ? "T|" : "F|") + (TapEnv.diffLivenessAnalyzer() == null ? "T|" : "F|") + (diffCallNeeded && !normalCheckpointedCall ? "T|" : "F|") + (!this.adEnv.curUnitIsActiveUnit ? "T|" : "F|") + (isMPICall ? "T|" : "F|") + (!TapEnv.removeDeadControl() && !TapEnv.mustAdjoint() ? "T|" : "F|") + (hasDeclaration && srcAction != null && this.isAConstantDeclInit(srcAction) ? "T|" : "F|");
                    }
                    boolean mustSaveTBR = mustSaveTBROther || srcAction != null && DiffLivenessAnalyzer.isTreeRequiredInDiff(this.adEnv.curActivity(), srcAction, modeIsJoint, false);
                    boolean bl4 = mustSaveTBROnDiffPtr = assignsPointer && (mustSaveTBROther || srcAction != null && DiffLivenessAnalyzer.isTreeRequiredInDiff(this.adEnv.curActivity(), srcAction, modeIsJoint, true));
                    if (this.adEnv.traceCurDifferentiation && this.adEnv.traceCurBlock != 0) {
                        TapEnv.printlnOnTrace("        >> MUSTSAVETBR: (" + reasonForMustSaveTBROther + "(" + (srcAction == null ? "F" : "T&" + (DiffLivenessAnalyzer.isTreeRequiredInDiff(this.adEnv.curActivity(), srcAction, modeIsJoint, false) ? "T" : "F") + (assignsPointer ? " Ptr:" + (DiffLivenessAnalyzer.isTreeRequiredInDiff(this.adEnv.curActivity(), srcAction, modeIsJoint, true) ? "T" : "F") : "")) + ")) => " + mustSaveTBR + (assignsPointer ? " Ptr:" + mustSaveTBROnDiffPtr : ""));
                    }
                    if (lastTestLive != null && instructions.tail == null && srcSplitTrees.tail == null && (mustSaveTBR || this.flowGraphDifferentiator().keepEmptyDiffBlocks)) {
                        lastTestLive.set(true);
                    }
                    String reasonForRemainsInFwdSweep = null;
                    boolean remainsInFwdSweep = mustSaveTBR || lastTestLive != null && lastTestLive.get();
                    boolean remainsInFwdSweepOnDiffPtr = assignsPointer;
                    reasonForRemainsInFwdSweep = (mustSaveTBR ? "T" : "F") + "|" + (lastTestLive != null && lastTestLive.get() ? "T" : "F");
                    if (differentiationMode != 1) {
                        BlockStorage<int[]> mayBeRecomputedS = this.adEnv.curActivity().mayBeRecomputed();
                        BlockStorage<int[]> butRemainsInFwdSweepS = this.adEnv.curActivity().butRemainsInFwdSweep();
                        if (mayBeRecomputedS != null) {
                            boolean diffPtrNotInFwd;
                            boolean primalNotInFwd;
                            boolean bl5 = primalNotInFwd = ActivityPattern.getInstructionBoolInfo(mayBeRecomputedS, this.adEnv.curInstruction(), 1) && !ActivityPattern.getInstructionBoolInfo(butRemainsInFwdSweepS, this.adEnv.curInstruction(), 1);
                            if (primalNotInFwd) {
                                remainsInFwdSweep = false;
                            }
                            boolean bl6 = diffPtrNotInFwd = ActivityPattern.getInstructionBoolInfo(mayBeRecomputedS, this.adEnv.curInstruction(), 2) && !ActivityPattern.getInstructionBoolInfo(butRemainsInFwdSweepS, this.adEnv.curInstruction(), 2);
                            if (diffPtrNotInFwd) {
                                remainsInFwdSweepOnDiffPtr = false;
                            }
                            reasonForRemainsInFwdSweep = "(" + reasonForRemainsInFwdSweep + ")&(" + (primalNotInFwd ? "f" : "t") + (assignsPointer ? (diffPtrNotInFwd ? "f" : "t") : "") + ")";
                        } else {
                            reasonForRemainsInFwdSweep = "(" + reasonForRemainsInFwdSweep + ")&T";
                        }
                    }
                    if (!remainsInFwdSweep && hasDeclaration) {
                        srcTree = srcDecl;
                        remainsInFwdSweep = true;
                        remainsInFwdSweepOnDiffPtr = true;
                        reasonForRemainsInFwdSweep = "(" + reasonForRemainsInFwdSweep + ")|T";
                    } else {
                        reasonForRemainsInFwdSweep = "(" + reasonForRemainsInFwdSweep + ")|F";
                    }
                    if (differentiationMode == 1 && (diffCalledUnit != null || calledUnit != null && !calledUnit.hasPredefinedDerivatives())) {
                        remainsInFwdSweepOnDiffPtr = remainsInFwdSweep = calledUnit != null && !calledUnit.isIntrinsic() && calledUnit.hasPredefinedDerivatives();
                        reasonForRemainsInFwdSweep = "(" + reasonForRemainsInFwdSweep + ")/" + (remainsInFwdSweep ? "T" : "F");
                    }
                    if (this.adEnv.traceCurDifferentiation && this.adEnv.traceCurBlock != 0) {
                        TapEnv.printlnOnTrace("        >> REMAINSINFWDSWEEP: " + reasonForRemainsInFwdSweep + " => " + remainsInFwdSweep + (assignsPointer ? " Ptr:" + remainsInFwdSweepOnDiffPtr : ""));
                    }
                    if (remainsInFwdSweep) {
                        mustSaveTBR = true;
                    }
                    if (remainsInFwdSweepOnDiffPtr) {
                        mustSaveTBROnDiffPtr = true;
                    }
                    if (srcAction != null && srcAction.opCode() == 14 && srcAction.down(2).opCode() == 5) {
                        this.dynMemoryDifferentiator().buildDiffInstructionsOfAssignAllocate(srcAction, differentiationMode, fwdBlock.symbolTable, bwdBlock == null ? null : bwdBlock.symbolTable, beforeActiv, afterActiv, afterReqX, beforeAvlX);
                    } else if (srcAction != null && srcAction.opCode() == 52) {
                        this.dynMemoryDifferentiator().buildDiffInstructionsOfDeallocate(srcAction, differentiationMode, remainsInFwdSweep, fwdBlock.symbolTable, bwdBlock == null ? null : bwdBlock.symbolTable, beforeActiv, afterActiv, afterReqX, beforeAvlX, beforeTBR, beforeTBROnDiffPtr);
                    } else if (isMPICall) {
                        this.procedureCallDifferentiator().buildDiffInstructionsOfMPICall(srcCallTree, srcResult, differentiationMode, calledUnit, calledActivity, MPIcallInfo.getMessagePassingMPIcallInfo(calledUnit.name(), srcCallTree, this.adEnv.curUnit().language(), block), diffCallNeeded, fwdBlock.symbolTable, bwdBlock == null ? null : bwdBlock.symbolTable, beforeActiv, afterActiv, beforeUseful, afterUseful);
                    } else if (!(calledUnit == null || isMPICall || calledUnit.hasPredefinedDerivatives() || calledUnit.name().equals("null"))) {
                        this.procedureCallDifferentiator().buildDiffInstructions(srcCallTree, srcResult, differentiationMode, calledUnit, calledActivity, diffCallNeeded, remainsInFwdSweep, mustSaveTBR, normalCheckpointedCall, splitAdjointCall, fwdBlock.symbolTable, bwdBlock == null ? null : bwdBlock.symbolTable, beforeActiv, afterActiv, beforeUseful, afterUseful, beforeReqX, afterReqX, beforeAvlX);
                    } else if (srcAction != null && this.isAssignment(srcAction)) {
                        Tree[] diffDeclR = new Tree[TapEnv.diffReplica()];
                        if (hasDeclaration) {
                            Instruction copyInstrInDiff = new Instruction(srcTree, null);
                            TapList<Instruction>[] diffDeclarationsR = this.differentiateInstructionDeclaration(this.adEnv.curInstruction(), differentiationMode, copyInstrInDiff, srcDecl, false, diffSymbolTable, block, beforeActiv, afterActiv, beforeUseful, afterUseful, beforeReqX, afterReqX, beforeAvlX, afterAvlX, block.symbolTable.unit.language(), true, false);
                            srcDecl = copyInstrInDiff.tree;
                            TapList errorLostInstructions = null;
                            for (int iReplic = 0; iReplic < diffDeclarationsR.length; ++iReplic) {
                                if (diffDeclarationsR[iReplic] != null) {
                                    diffDeclR[iReplic] = ((Instruction)diffDeclarationsR[iReplic].head).tree;
                                    errorLostInstructions = TapList.append(errorLostInstructions, diffDeclarationsR[iReplic].tail);
                                    continue;
                                }
                                diffDeclR[iReplic] = null;
                            }
                            if (errorLostInstructions != null) {
                                TapEnv.toolError("Problem for buildDiffInstructionsOfPlainAssignment: remaining pieces of diff declaration are lost: " + errorLostInstructions);
                            }
                        }
                        if (diffDeclR.length > 0 && diffDeclR[0] != null && remainsInFwdSweep && TapEnv.debugAdMode() != -1 && TapEnv.removeDeadPrimal() && !this.adEnv.curUnitIsContext && !curUnitIsCopied && TapEnv.diffLivenessAnalyzer() != null && this.adEnv.curUnitIsActiveUnit && !DiffLivenessAnalyzer.isTreeRequiredInDiff(this.adEnv.curActivity(), srcAction, modeIsJoint, false)) {
                            remainsInFwdSweep = false;
                        }
                        this.buildDiffInstructionsOfPlainAssignment(srcAction, srcDecl, diffDeclR, differentiationMode, remainsInFwdSweep, remainsInFwdSweepOnDiffPtr, mustSaveTBR, mustSaveTBROnDiffPtr, beforeActiv, afterActiv, beforeReqX, afterReqX, beforeAvlX);
                    } else if (srcAction == null && hasDeclaration) {
                        Instruction copyInstrInDiff = new Instruction(srcTree, null);
                        TapList<Instruction>[] diffDeclarationsR = this.differentiateInstructionDeclaration(this.adEnv.curInstruction(), differentiationMode, copyInstrInDiff, srcDecl, false, diffSymbolTable, block, beforeActiv, afterActiv, beforeUseful, afterUseful, beforeReqX, afterReqX, beforeAvlX, afterAvlX, block.symbolTable.unit.language(), !this.adEnv.curUnit().isFortran9x(), false);
                        if (copyInstrInDiff.tree != null) {
                            this.buildDiffInstructionsOfPlainDeclaration(copyInstrInDiff.tree, diffDeclarationsR, differentiationMode, remainsInFwdSweep);
                        }
                    } else if (isIncrement) {
                        this.buildDiffInstructionsOfIncrement(srcAction, differentiationMode, remainsInFwdSweep, mustSaveTBR, beforeActiv, afterActiv, afterReqX, beforeAvlX);
                    } else if (srcAction != null && srcAction.opCode() == 168) {
                        this.buildDiffInstructionsOfReturn(srcAction, differentiationMode, remainsInFwdSweep, beforeActiv, afterActiv, afterReqX, beforeAvlX);
                    } else if (ILUtils.isIORead(srcAction)) {
                        this.buildDiffInstructionsOfIORead(srcAction, differentiationMode, remainsInFwdSweep, mustSaveTBR, beforeActiv, afterActiv, beforeUseful, afterUseful);
                    } else if (ILUtils.isParallelController(srcTree)) {
                        this.buildDiffInstructionsOfParallelPragma(srcTree, differentiationMode, beforeActiv);
                    } else {
                        this.buildDiffInstructionsOfOther(hasDeclaration ? srcDecl : srcAction, differentiationMode, remainsInFwdSweep, beforeActiv);
                    }
                    srcSplitTrees = srcSplitTrees.tail;
                }
                if (TapEnv.debugAdMode() == -1 && !this.adEnv.curUnitIsContext && differentiationMode != 1) {
                    while (this.tempVarsForDebug != null) {
                        Tree tempRef = (Tree)this.tempVarsForDebug.head;
                        Tree diffTempRef = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), tempRef, fwdBlock.symbolTable, false, tempRef, false, true, tempRef);
                        this.addFuturePlainNodeBwd(ILUtils.build(14, diffTempRef, ILUtils.build(160, "0.D0")), null, true, null, null, null, new TapList<Tree>(tempRef, null), false, false, "Initialize DIFF OF local temporary " + tempRef + " (due to debugADJ)", false);
                        this.tempVarsForDebug = this.tempVarsForDebug.tail;
                    }
                }
                if (this.adEnv.activeRootCalledFromContext && (differentiationMode == -1 || differentiationMode == -2)) {
                    this.bwdInstructionsGraph.buildInstructions(this.adEnv.curSymbolTable(), fwdBlock.symbolTable, this.adEnv, this.curDiffUnit());
                    TapList<NewBlockGraphNode> bwdNodes = this.bwdInstructionsGraph.nodes;
                    while (bwdNodes != null) {
                        NewBlockGraphNode bwdNode = (NewBlockGraphNode)bwdNodes.head;
                        this.addFuturePlainNodeFwd(bwdNode.tree, bwdNode.whereMask, bwdNode.multiDir, null, null, null, null, true, true, "Transferred from BWD", false);
                        bwdNodes = bwdNodes.tail;
                    }
                    this.bwdInstructionsGraph.reset();
                }
                if (this.adEnv.curUnitIsContext && this.adEnv.activeRootCalledFromContext) {
                    if (!isDebug) {
                        dbadTree = ILUtils.buildCall(ILUtils.tapenadeUtilityFunctionName(this.curDiffUnit(), traceFuncPrefix + "startConclude"), ILUtils.build(71));
                        this.addFuturePlainNodeFwd(dbadTree, null, false, null, null, null, null, true, true, "Start-conclude instrumentation after exiting diff fragment", false);
                    }
                    instructionsOnZones = this.flowGraphDifferentiator().instructionsOnDeclaredZones(srcFullTree, this.adEnv.curSymbolTable(), diffSymbolTable, isDebug && isAdj ? "adDebugAdj_r" : traceFuncPrefix + "conclude", this.curDiffUnit(), differentiationMode == 1 ? afterActiv : beforeActiv, this.curDiffVectorMap(), !isDebug || !isAdj, isDebug && isAdj, isDebug && isAdj, this.adEnv.curSymbolTable().declaredZonesNb(this.adEnv.diffKind), null);
                    if (isDebug && isAdj) {
                        arg = ILUtils.build(103, 0);
                        args = new TapList<Tree>(arg, null);
                        arg = ILUtils.build(180, differentiationMode == 1 ? "end" : "start");
                        if (this.curDiffUnit().isFortran()) {
                            arg = ILUtils.concatWithNull(arg);
                        }
                        args = new TapList<Tree>(arg, args);
                        dbadTree = ILUtils.buildCall(ILUtils.tapenadeUtilityFunctionName(this.curDiffUnit(), "adDebugAdj_rDisplay"), ILUtils.build(71, args));
                        instructionsOnZones = TapList.append(instructionsOnZones, new TapList<Tree>(dbadTree, null));
                        arg = ILUtils.build(180, differentiationMode == 1 ? "end" : "start");
                        if (this.curDiffUnit().isFortran()) {
                            arg = ILUtils.concatWithNull(arg);
                        }
                        args = new TapList<Tree>(arg, null);
                        dbadTree = ILUtils.build(98, ILUtils.buildCall(ILUtils.tapenadeUtilityFunctionName(this.curDiffUnit(), traceFuncPrefix + "here"), ILUtils.build(71, args)), ILUtils.build(27, instructionsOnZones));
                        instructionsOnZones = new TapList<Tree>(dbadTree, null);
                    }
                    while (instructionsOnZones != null) {
                        this.addFuturePlainNodeFwd((Tree)instructionsOnZones.head, null, false, null, differentiationMode == 1 ? afterActivTrees : beforeActivTrees, null, differentiationMode == 1 ? afterActivTrees : beforeActivTrees, true, true, "Instrument actives after exiting diff fragment", false);
                        instructionsOnZones = instructionsOnZones.tail;
                    }
                    traceFuncPrefix = (isDebug ? "adDebug" : "adContext") + (isAdj ? "Adj_" : (TapEnv.get().complexStep ? "Cpx_" : "Tgt_"));
                    dbadTree = ILUtils.buildCall(ILUtils.tapenadeUtilityFunctionName(this.curDiffUnit(), traceFuncPrefix + "conclude"), ILUtils.build(71));
                    this.addFuturePlainNodeFwd(dbadTree, null, false, null, null, null, null, true, true, "Conclude instrumentation after exiting diff fragment", false);
                }
                if (blockRecomputations != null && blockRecomputations.head != null) {
                    this.buildBwdRecomputations((TapPair)blockRecomputations.head, beforeActiv, afterActiv, beforeAvlX, afterReqX);
                }
                this.waitingComments = ILUtils.appendComments(this.waitingComments, this.adEnv.curInstruction().postComments);
                this.waitingCommentsBlock = ILUtils.appendComments(this.waitingCommentsBlock, this.adEnv.curInstruction().postCommentsBlock);
            }
            beforeActiv = afterActiv;
            beforeUseful = afterUseful;
            beforeReqX = afterReqX;
            beforeAvlX = afterAvlX;
            instructions = instructions.tail;
        }
        this.adEnv.setCurInstruction(null);
        if (this.multiDirMode() && TapEnv.get().mergeDiffInstructions) {
            this.fwdInstructionsGraph.condense(this.adEnv.curUnit());
        } else {
            this.fwdInstructionsGraph.closeGroup();
        }
        TapList<NewBlockGraphNode> orderedFwdNodes = this.fwdInstructionsGraph.topoSort();
        TapList<Object> tlFwdInstructions = hdFwdInstructions = new TapList<Object>(null, null);
        Instruction fwdInstruction = null;
        while (orderedFwdNodes != null) {
            NewBlockGraphNode curNode = (NewBlockGraphNode)orderedFwdNodes.head;
            if (curNode.multiDir || curNode.hasManyInstructions()) {
                curNode.gatherMultiInstructions(fwdBlock.symbolTable, this.curDiffUnit(), this.varRefDifferentiator().dirIndexSymbolHolder, this.varRefDifferentiator().multiDirIterDescriptor);
            }
            curNode.buildInstruction(this.adEnv.curSymbolTable(), fwdBlock.symbolTable, this.adEnv, this.curDiffUnit());
            fwdInstruction = curNode.diffInstruction;
            fwdInstruction.block = fwdBlock;
            tlFwdInstructions = tlFwdInstructions.placdl(fwdInstruction);
            orderedFwdNodes = orderedFwdNodes.tail;
        }
        if (fwdInstruction != null && this.waitingComments != null) {
            fwdInstruction.postComments = ILUtils.appendComments(fwdInstruction.postComments, this.waitingComments);
            this.waitingComments = null;
        }
        if (fwdInstruction != null && this.waitingCommentsBlock != null) {
            fwdInstruction.postCommentsBlock = ILUtils.appendComments(fwdInstruction.postCommentsBlock, this.waitingCommentsBlock);
            this.waitingCommentsBlock = null;
        }
        while (containedUnitsFwd.tail != null) {
            this.curFwdDiffUnit().addNonFlowInstruction(Instruction.createUnitDefinitionStub((Unit)containedUnitsFwd.tail.head, fwdBlock));
            containedUnitsFwd = containedUnitsFwd.tail;
        }
        fwdBlock.instructions = hdFwdInstructions.tail;
        this.flattenBlockStatements(fwdBlock);
        if (!this.adEnv.curUnitIsContext && differentiationMode != 1) {
            TapList<Object> hdRevInstructions;
            if (TapEnv.get().mergeDiffInstructions) {
                this.bwdInstructionsGraph.condense(this.adEnv.curUnit());
            } else {
                this.bwdInstructionsGraph.closeGroup();
            }
            this.bwdInstructionsGraph.buildInstructions(this.adEnv.curSymbolTable(), bwdBlock.symbolTable, this.adEnv, this.curDiffUnit());
            if (TapEnv.debugAdMode() == 0) {
                this.bwdInstructionsGraph.condense(this.adEnv.curUnit());
            }
            TapList<NewBlockGraphNode> orderedBwdNodes = this.bwdInstructionsGraph.topoSort();
            TapList<Object> tlRevInstructions = hdRevInstructions = new TapList<Object>(null, null);
            while (orderedBwdNodes != null) {
                Instruction bwdInstruction = ((NewBlockGraphNode)orderedBwdNodes.head).diffInstruction;
                bwdInstruction.block = bwdBlock;
                if (bwdInstruction.tree != null) {
                    if (((NewBlockGraphNode)orderedBwdNodes.head).multiDir) {
                        Tree loopBody = bwdInstruction.tree;
                        bwdInstruction.tree = ILUtils.build(121, ILUtils.build(138), ILUtils.build(138), this.varRefDifferentiator().multiDirIterDescriptor.buildDoHeaderTree(bwdBlock.symbolTable, this.curDiffUnit(), true), loopBody);
                    }
                    tlRevInstructions = tlRevInstructions.placdl(bwdInstruction);
                }
                orderedBwdNodes = orderedBwdNodes.tail;
            }
            while (containedUnitsBwd.tail != null) {
                this.curDiffUnit().addNonFlowInstruction(Instruction.createUnitDefinitionStub((Unit)containedUnitsBwd.tail.head, bwdBlock));
                containedUnitsBwd = containedUnitsBwd.tail;
            }
            bwdBlock.instructions = hdRevInstructions.tail;
            this.flattenBlockStatements(bwdBlock);
            Block revDeclBlock = bwdBlock.symbolTable.declarationsBlock;
            if (revDeclBlock != fwdBlock.symbolTable.declarationsBlock) {
                TapList declarationsForRevDeclBlock = this.hdRevDeclarations.tail;
                while (declarationsForRevDeclBlock != null) {
                    TapTriplet nextDecl = (TapTriplet)declarationsForRevDeclBlock.head;
                    Instruction revDecl = new Instruction((Tree)nextDecl.first);
                    revDecl.setFromIncludeCopy((Instruction)nextDecl.third, true);
                    revDecl.isPhantom = ((Instruction)nextDecl.second).isPhantom;
                    revDecl.setPosition((Instruction)nextDecl.second);
                    if (!revDeclBlock.alreadyPresent(revDecl)) {
                        revDeclBlock.addInstrTl(revDecl);
                    }
                    declarationsForRevDeclBlock = declarationsForRevDeclBlock.tail;
                }
            }
        }
        if (this.adEnv.traceCurBlock != 0) {
            TapEnv.printlnOnTrace(" ==> fwdBlock:" + fwdBlock + " : " + fwdBlock.instructions + " SymbolTable:" + fwdBlock.symbolTable.addressChain());
            if (bwdBlock != null) {
                TapEnv.printlnOnTrace(" ==> bwdBlock:" + bwdBlock + " : " + bwdBlock.instructions + " SymbolTable:" + bwdBlock.symbolTable.addressChain());
            }
            if (this.hdRevDeclarations.tail != null) {
                TapEnv.printlnOnTrace(" ==>+bwdDecls:" + this.hdRevDeclarations.tail + (bwdBlock.symbolTable.declarationsBlock == fwdBlock.symbolTable.declarationsBlock ? " discarded because FWD and BWD blocks share scope" : " added at tail of " + bwdBlock.symbolTable.declarationsBlock + " declaration Block of " + bwdBlock.symbolTable.addressChain()));
            }
        }
    }

    private void buildBwdRecomputations(TapPair<TapList<Instruction>, TapList<Instruction>> recomputations, BoolVector beforeActiv, BoolVector afterActiv, BoolVector beforeAvlX, BoolVector afterReqX) {
        Tree rhs;
        Tree lhs;
        Tree recomputationTree;
        Instruction recomputationInstr;
        TapList recompPrimals = (TapList)recomputations.first;
        while (recompPrimals != null) {
            recomputationInstr = (Instruction)recompPrimals.head;
            recomputationTree = recomputationInstr.tree;
            lhs = recomputationTree.down(1);
            rhs = recomputationTree.down(2);
            this.addFuturePlainNodeBwd(ILUtils.copy(recomputationTree), recomputationInstr.whereMask(), false, ILUtils.usedVarsInExp(recomputationTree, null, false), new TapList<Tree>(lhs, null), null, null, false, false, "Recompute forward", false);
            recompPrimals = recompPrimals.tail;
        }
        TapList recompDiffPtrs = (TapList)recomputations.second;
        while (recompDiffPtrs != null) {
            boolean isActivePointer;
            recomputationInstr = (Instruction)recompDiffPtrs.head;
            recomputationTree = recomputationInstr.tree;
            lhs = recomputationTree.down(1);
            rhs = recomputationTree.down(2);
            WrapperTypeSpec type = this.adEnv.curSymbolTable().typeOf(lhs);
            boolean bl = isActivePointer = TypeSpec.isA(type, 6) && this.pointerIsActiveHere(lhs, beforeActiv, afterActiv, beforeAvlX, afterReqX);
            if (isActivePointer) {
                Tree diffPointerRecomputationTree = ILUtils.build(14, this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), lhs, this.adEnv.curBwdSymbolTable, false, lhs, false, true, null), this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), rhs, this.adEnv.curBwdSymbolTable, false, rhs, false, true, null));
                this.addFuturePlainNodeBwd(diffPointerRecomputationTree, recomputationInstr.whereMask(), false, ILUtils.usedVarsInExp(recomputationTree, null, false), null, new TapList<Tree>(rhs, null), new TapList<Tree>(lhs, null), false, false, "Recompute diff pointer forward", false);
            }
            recompDiffPtrs = recompDiffPtrs.tail;
        }
    }

    private void buildDiffInstructionsOfPlainAssignment(Tree assignment, Tree srcDecl, Tree[] diffDeclR, int differentiationMode, boolean assignmentIsLive, boolean assignmentOnDiffPtrIsLive, boolean mustSaveTBRBeforeInstr, boolean mustSaveTBROnDiffPtrBeforeInstr, BoolVector beforeActiv, BoolVector afterActiv, BoolVector beforeReqX, BoolVector afterReqX, BoolVector beforeAvlX) {
        if (TapEnv.associationByAddress()) {
            this.updateAAInstructionMask(this.adEnv.curInstruction(), this.adEnv.curSymbolTable(), this.adEnv.curFwdSymbolTable);
        }
        if (differentiationMode == 1) {
            this.buildAssignTangentNodes(assignment, srcDecl, diffDeclR, assignmentIsLive, beforeActiv, afterActiv, beforeReqX, afterReqX, beforeAvlX);
        } else if (differentiationMode == -1 || differentiationMode == -2) {
            this.buildAssignAdjointNodes(assignment, srcDecl, diffDeclR, differentiationMode, assignmentIsLive, assignmentOnDiffPtrIsLive, mustSaveTBRBeforeInstr, mustSaveTBROnDiffPtrBeforeInstr, beforeActiv, afterActiv, beforeAvlX, afterReqX);
        }
    }

    private void buildAssignTangentNodes(Tree assignment, Tree srcDecl, Tree[] diffDeclR, boolean assignmentIsLive, BoolVector beforeActiv, BoolVector afterActiv, BoolVector beforeReqX, BoolVector afterReqX, BoolVector beforeAvlX) {
        Tree zeroTree;
        Tree copySrcAssignment;
        TapPair<Object, Object> refsRW = new TapPair<Object, Object>(null, null);
        TapPair<Object, Object> diffRefsRW = new TapPair<Object, Object>(null, null);
        Tree result = assignment.down(1);
        Tree expression = assignment.down(2);
        SymbolTable srcSymbolTable = this.adEnv.curSymbolTable();
        if (this.adEnv.curUnitIsActiveUnit && TapEnv.spareDiffReinitializations()) {
            this.buildDiffPreInitsForTangent(result, expression, srcDecl, beforeActiv, afterActiv, beforeReqX, afterReqX, false, null);
        }
        Tree assignedRef = assignment.opCode() == 194 ? assignment.down(2) : assignment.down(1);
        WrapperTypeSpec lhsTypeSpec = srcSymbolTable.typeOf(assignedRef);
        boolean addNbDirsLoop = false;
        Tree[] diffAssignmentR = new Tree[TapEnv.diffReplica()];
        Tree tree = copySrcAssignment = assignmentIsLive || srcDecl != null ? ILUtils.copy(assignment) : null;
        if (!assignmentIsLive && srcDecl != null && lhsTypeSpec != null && (zeroTree = lhsTypeSpec.buildConstantZero()) != null) {
            copySrcAssignment.setChild(zeroTree, 2);
        }
        boolean diffDeclIsReady = false;
        if ((TypeSpec.isA(lhsTypeSpec, 6) || TypeSpec.isA(lhsTypeSpec, 21) && (!this.multiDirMode() || !this.adEnv.curUnit().isFortran9x())) && expression != null && expression.opCode() != 47 && expression.opCode() != 10) {
            this.adEnv.iReplic = 0;
            while (this.adEnv.iReplic < diffDeclR.length) {
                if (diffDeclR[this.adEnv.iReplic] != null) {
                    diffDeclIsReady = true;
                    refsRW.first = ILUtils.usedVarsInExp(assignment, null, false);
                    diffRefsRW.first = ILUtils.usedVarsInExp(assignment, null, true);
                    diffRefsRW.second = new TapList<Tree>(result, null);
                } else {
                    Tree diffAssignment = null;
                    if (this.writtenExpressionNeedsDiff(assignedRef, beforeActiv, afterActiv, beforeAvlX, afterReqX) && expression.opCode() != 109) {
                        TapPair<Tree, TapList<Tree>[]> diffTreePlus = this.buildDiffOfControlAssignment(assignment, 1, this.adEnv.curFwdSymbolTable, beforeActiv, afterActiv, beforeAvlX, afterReqX);
                        Tree tree2 = diffAssignment = diffTreePlus == null ? null : (Tree)diffTreePlus.first;
                        if (diffAssignment != null && diffAssignment.opCode() == 14 && ILUtils.isNullOrNone(diffAssignment.down(2))) {
                            diffAssignment = null;
                        }
                        if (diffAssignment != null) {
                            TapList[] rwrw = (TapList[])diffTreePlus.second;
                            refsRW.first = rwrw[0];
                            diffRefsRW.first = rwrw[2];
                            diffRefsRW.second = rwrw[3];
                        }
                    }
                    diffAssignmentR[this.adEnv.iReplic] = diffAssignment;
                }
                ++this.adEnv.iReplic;
            }
            this.adEnv.iReplic = 0;
        } else {
            addNbDirsLoop = VarRefDifferentiator.mustAddNbDirsDim(lhsTypeSpec);
            TapList<Object> toPrecomputes = new TapList<Object>(null, null);
            TapList<Object> toPrecomputesDiff = new TapList<Object>(null, null);
            if (this.writtenExpressionNeedsDiff(assignment.down(1), beforeActiv, afterActiv, beforeAvlX, afterReqX)) {
                diffAssignmentR = this.expressionDifferentiator().tangentDifferentiateAssignedExpression(assignment.down(1), assignment.down(2), toPrecomputes, toPrecomputesDiff, copySrcAssignment, beforeActiv, refsRW, diffRefsRW, this.adEnv.curFwdSymbolTable);
                if (this.multiDirMode() && this.adEnv.curUnit().isFortran9x() && expression.opCode() != 10 && !WrapperTypeSpec.canReceiveVectorialDim(lhsTypeSpec, false)) {
                    for (int iReplic = 0; iReplic < diffAssignmentR.length; ++iReplic) {
                        RefDescriptor diffLhsRefDescriptor = new RefDescriptor(assignedRef, null, srcSymbolTable, this.adEnv.curFwdSymbolTable, null, ILUtils.baseTree(diffAssignmentR[iReplic].down(1)), true, this.varRefDifferentiator().multiDirIterDescriptor, this.curDiffUnit());
                        RefDescriptor diffRhsRefDescriptor = new RefDescriptor(assignment.down(2), null, srcSymbolTable, this.adEnv.curFwdSymbolTable, null, ILUtils.baseTree(diffAssignmentR[iReplic].down(2)), true, this.varRefDifferentiator().multiDirIterDescriptor, this.curDiffUnit());
                        diffLhsRefDescriptor.setCompanionVarDescriptor(diffRhsRefDescriptor);
                        diffLhsRefDescriptor.prepareForAssignOrNormDiff(diffRhsRefDescriptor, this.curDiffUnit(), null, false);
                        diffLhsRefDescriptor.mayProtectAccesses = false;
                        diffAssignmentR[iReplic] = diffLhsRefDescriptor.makeAssign(diffRhsRefDescriptor);
                    }
                }
            }
            toPrecomputes = TapList.nreverse(toPrecomputes.tail);
            while (toPrecomputes != null) {
                NewBlockGraphNode futureNode = (NewBlockGraphNode)toPrecomputes.head;
                TapList<Tree> plainR = ILUtils.usedVarsInExp(futureNode.tree, null, true);
                if (futureNode.whereMask != null) {
                    plainR = ILUtils.usedVarsInExp(futureNode.whereMask.getControlTree(), plainR, true);
                }
                this.addFuturePlainNodeFwd(futureNode.tree, futureNode.whereMask, false, plainR, new TapList<Tree>(futureNode.tree.down(1), null), null, null, false, false, "Assign split primal expression", false);
                toPrecomputes = toPrecomputes.tail;
            }
            toPrecomputesDiff = toPrecomputesDiff.tail;
            while (toPrecomputesDiff != null) {
                DiffAssignmentNode futureDiffNode = (DiffAssignmentNode)toPrecomputesDiff.head;
                Tree tree3 = futureDiffNode.diffAssign;
                InstructionMask instructionMask = futureDiffNode.type.isScalar() ? null : this.adEnv.curInstruction().whereMask();
                this.varRefDifferentiator();
                this.addFuturePlainNodeFwd(tree3, instructionMask, VarRefDifferentiator.mustAddNbDirsDim(futureDiffNode.type), futureDiffNode.primR, futureDiffNode.primW, futureDiffNode.diffR, futureDiffNode.diffW, false, false, "Assign split diff expression", false);
                toPrecomputesDiff = toPrecomputesDiff.tail;
            }
        }
        if (copySrcAssignment != null && copySrcAssignment.getAnnotation("hasBeenSplit") == Boolean.TRUE) {
            copySrcAssignment.removeAnnotation("sourcetree");
        }
        if (srcDecl != null && copySrcAssignment != null && copySrcAssignment.opCode() == 14) {
            if ((srcDecl = ILUtils.copy(srcDecl)).down(3).down(1).opCode() != 14) {
                srcDecl.down(3).setChild(ILUtils.build(14, srcDecl.down(3).cutChild(1)), 1);
            }
            srcDecl.down(3).down(1).setChild(copySrcAssignment.cutChild(2), 2);
            copySrcAssignment = null;
        }
        if (srcDecl != null) {
            this.addFuturePlainNodeFwd(srcDecl, null, false, ILUtils.usedVarsInExp(assignment, null, true), new TapList<Tree>(assignment.down(1), null), null, null, false, false, "Copy of primal declaration with primal initializer", false);
        }
        for (int iReplic = 0; iReplic < diffAssignmentR.length; ++iReplic) {
            Tree diffAssignment = diffAssignmentR[iReplic];
            Tree diffDecl = diffDeclR[iReplic];
            if (diffAssignment == null && !diffDeclIsReady && diffDecl != null && diffDecl.down(3).down(1).opCode() == 14) {
                diffDecl = ILUtils.copy(diffDecl);
                diffDecl.down(3).setChild(diffDecl.down(3).down(1).cutChild(1), 1);
            }
            if (diffDecl != null && diffAssignment != null && diffAssignment.opCode() == 14) {
                if ((diffDecl = ILUtils.copy(diffDecl)).down(3).down(1).opCode() != 14) {
                    diffDecl.down(3).setChild(ILUtils.build(14, diffDecl.down(3).cutChild(1)), 1);
                }
                diffDecl.down(3).down(1).setChild(diffAssignment.cutChild(2), 2);
                NewSymbolHolder diffVarFwdSH = NewSymbolHolder.getNewSymbolHolder(ILUtils.baseTree(diffAssignment.down(1)));
                diffVarFwdSH.setInstruction(new Instruction(diffDecl));
                diffVarFwdSH.declare = false;
                diffAssignment = null;
            }
            if (diffDecl != null) {
                this.addFuturePlainNodeFwd(diffDecl, null, false, (TapList)refsRW.first, (TapList)refsRW.second, (TapList)diffRefsRW.first, (TapList)diffRefsRW.second, false, false, "Differentiated declaration with differentiated initializer", true);
            }
            if (diffAssignment == null) continue;
            this.addFuturePlainNodeFwd(diffAssignment, this.adEnv.curInstruction().whereMask(), addNbDirsLoop, (TapList)refsRW.first, (TapList)refsRW.second, (TapList)diffRefsRW.first, (TapList)diffRefsRW.second, false, false, "Differentiated assignment", true);
        }
        if (copySrcAssignment != null) {
            if (TapEnv.associationByAddress()) {
                copySrcAssignment = this.turnAssociationByAddressPrimal(copySrcAssignment, srcSymbolTable, this.adEnv.curFwdSymbolTable, null, false);
            }
            this.addFuturePlainNodeFwd(copySrcAssignment, this.adEnv.curInstruction().whereMask(), false, ILUtils.usedVarsInExp(copySrcAssignment, null, true), new TapList<Tree>(assignment.down(1), null), null, null, false, false, "Copy of primal assignment" + (TapEnv.associationByAddress() ? " (Assoc-by-Address)" : ""), false);
        }
        this.adEnv.curInstruction().isDifferentiated = true;
    }

    private void buildAssignAdjointNodes(Tree assignment, Tree srcDecl, Tree[] diffDeclR, int differentiationMode, boolean assignmentIsLive, boolean assignmentOnDiffPtrIsLive, boolean mustSaveTBRBeforeInstr, boolean mustSaveTBROnDiffPtrBeforeInstr, BoolVector beforeActiv, BoolVector afterActiv, BoolVector beforeAvlX, BoolVector afterReqX) {
        boolean restoreDiff;
        Tree diffDecl = diffDeclR == null || diffDeclR.length < 1 ? null : diffDeclR[0];
        Tree lhs = assignment.down(1);
        Tree expression = assignment.down(2);
        SymbolTable srcSymbolTable = this.adEnv.curSymbolTable();
        boolean separateBwdScope = differentiationMode == -2 || differentiationMode == -1 && !this.adEnv.curUnitIsContext && srcSymbolTable != this.adEnv.curUnit().privateSymbolTable() && srcSymbolTable != this.adEnv.curUnit().publicSymbolTable() && this.adEnv.curBwdSymbolTable != this.adEnv.curFwdSymbolTable;
        boolean removedDeclarator = true;
        block4: while (removedDeclarator) {
            switch (lhs.opCode()) {
                case 11: 
                case 26: 
                case 90: 
                case 153: {
                    lhs = lhs.down(1);
                    removedDeclarator = true;
                    continue block4;
                }
                case 128: {
                    lhs = lhs.down(2);
                    removedDeclarator = true;
                    continue block4;
                }
            }
            removedDeclarator = false;
        }
        Tree diffLhs = null;
        Tree diffRhs = null;
        Tree diffDeclAndAssign = null;
        WrapperTypeSpec assignedType = srcSymbolTable.typeOf(lhs);
        boolean somePointerIsAssigned = TypeSpec.isA(assignedType, 6);
        boolean mustDiffOperation = this.pointerIsActiveHere(lhs, beforeActiv, afterActiv, beforeAvlX, afterReqX);
        SymbolTable symbolTableForLhs = this.adEnv.curFwdSymbolTable;
        if (assignment.getAnnotation("ComesFromAReturn") == Boolean.TRUE) {
            symbolTableForLhs = this.curFwdDiffUnit().publicSymbolTable();
        }
        if (diffDecl != null || somePointerIsAssigned && mustDiffOperation) {
            diffLhs = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), lhs, symbolTableForLhs, false, lhs, false, true, null);
        }
        boolean isAllocatablePointer = srcSymbolTable.varHasModifier(lhs, "allocatable");
        boolean restorePrimal = ADTBRAnalyzer.isTBR(this.adEnv.curActivity(), lhs) && mustSaveTBRBeforeInstr;
        boolean bl = restoreDiff = somePointerIsAssigned && mustDiffOperation && !this.adEnv.curUnitIsContext && ADTBRAnalyzer.isTBROnDiffPtr(this.adEnv.curActivity(), lhs) && mustSaveTBROnDiffPtrBeforeInstr;
        if ((restorePrimal || restoreDiff) && isAllocatablePointer) {
            TapEnv.fileWarning(15, lhs, "(AD07) Data-Flow recovery (TBR) needs to restore allocatable pointer " + ILUtils.toString(lhs) + ", not implemented yet");
        }
        RefDescriptor refDescriptor = null;
        if (restorePrimal || restoreDiff) {
            refDescriptor = new RefDescriptor(lhs, null, srcSymbolTable, this.curDiffUnit().privateSymbolTable(), null, null, false, null, this.curDiffUnit());
            this.prepareRestoreOperations(refDescriptor, null, 0, this.adEnv.curFwdSymbolTable, this.adEnv.curBwdSymbolTable);
        }
        if (somePointerIsAssigned && refDescriptor != null) {
            boolean rebaseDiff;
            boolean rebasePrimal;
            boolean bl2 = restorePrimal && DataFlowAnalyzer.mayPointToRelocated(lhs, false, this.adEnv.curInstruction(), srcSymbolTable, differentiationMode == -1) ? true : (rebasePrimal = false);
            boolean bl3 = restoreDiff && DataFlowAnalyzer.mayPointToRelocated(lhs, true, this.adEnv.curInstruction(), srcSymbolTable, differentiationMode == -1) ? true : (rebaseDiff = false);
            if (rebasePrimal || rebaseDiff) {
                ++this.numRebase;
                Tree rebaseTree = refDescriptor.makeRebase(rebasePrimal ? null : new TapList<Boolean>(Boolean.TRUE, null), rebaseDiff ? null : new TapList<Boolean>(Boolean.TRUE, null), rebaseDiff ? ILUtils.baseTree(diffLhs) : null, TapEnv.debugAdMode() == -1 || TapEnv.debugADMM() ? this.numRebase : -1);
                if (rebaseTree != null) {
                    this.adEnv.usesADMM = true;
                    this.addFuturePlainNodeBwd(rebaseTree, null, false, ILUtils.usedVarsInExp(lhs, null, true), rebasePrimal ? new TapList<Tree>(lhs, null) : null, null, rebaseDiff ? new TapList<Tree>(lhs, null) : null, false, false, "Rebase TBR previous value of assigned pointer " + lhs + " and/or DIFF", false);
                }
            }
        }
        if (somePointerIsAssigned && mustDiffOperation && (assignmentOnDiffPtrIsLive || srcDecl != null)) {
            if (restoreDiff) {
                RefDescriptor refDescriptorDiff = new RefDescriptor(lhs, null, srcSymbolTable, this.curDiffUnit().privateSymbolTable(), null, ILUtils.baseTree(diffLhs), true, null, this.curDiffUnit());
                refDescriptorDiff.prepareForStack(this.curFwdDiffUnit(), 0, null, true);
                refDescriptorDiff.mayProtectAccesses = false;
                this.addFuturePlainNodeFwd(refDescriptorDiff.makePush(), null, false, ILUtils.usedVarsInExp(lhs, null, false), null, new TapList<Tree>(lhs, null), null, false, true, "Store diff control " + ILUtils.toString(lhs, this.adEnv.curActivity()), false);
                refDescriptorDiff.toBranchVariable = this.flowGraphDifferentiator().toBranchVariable;
                this.addFuturePlainNodeBwd(refDescriptorDiff.makePop(), null, false, ILUtils.usedVarsInExp(lhs, null, false), null, null, new TapList<Tree>(lhs, null), false, true, "Restore diff control " + ILUtils.toString(lhs, this.adEnv.curActivity()), false);
            }
            diffRhs = ILUtils.isCallingString(expression, "null", false) ? ILUtils.copy(expression) : this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), expression, this.adEnv.curFwdSymbolTable, false, expression, false, true, null);
            if (diffDecl != null) {
                diffDeclAndAssign = ILUtils.copy(diffDecl);
                if (diffRhs != null) {
                    if (diffDeclAndAssign.down(3).down(1).opCode() != 14) {
                        diffDeclAndAssign.down(3).setChild(ILUtils.build(14, diffDeclAndAssign.down(3).cutChild(1)), 1);
                    }
                    diffDeclAndAssign.down(3).down(1).setChild(diffRhs, 2);
                }
            } else if (diffRhs != null) {
                Tree diffAssign = ILUtils.build(assignment.opCode(), diffLhs, diffRhs);
                this.addFuturePlainNodeFwd(diffAssign, this.adEnv.curInstruction().whereMask(), false, ILUtils.usedVarsInExp(lhs, null, false), null, new TapList<Tree>(expression, null), new TapList<Tree>(lhs, null), false, false, "Diff pointer assignment", true);
            }
        } else if (diffDecl != null) {
            diffDeclAndAssign = ILUtils.copy(diffDecl);
        }
        if (somePointerIsAssigned && diffDecl != null) {
            NewSymbolHolder diffVarFwdSH = NewSymbolHolder.getNewSymbolHolder(ILUtils.baseTree(diffLhs));
            diffVarFwdSH.setInstruction(new Instruction(diffDeclAndAssign != null ? diffDeclAndAssign : diffDecl));
            diffVarFwdSH.declare = false;
        }
        TapList<?> writtenZonesTree = srcSymbolTable.treeOfZonesOfValue(lhs, null, this.adEnv.curInstruction(), null);
        TapIntList writtenZones = ZoneInfo.listAllZones(writtenZonesTree, true);
        boolean writtenTmp = TapIntList.intersects(writtenZones, this.adEnv.toActiveTmpZones.tail);
        TapIntList writtenDiffKindVectorIndices = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(writtenZones, this.adEnv.diffKind, this.curDiffVectorMap(), srcSymbolTable, null);
        TapList<ZoneInfo> zones = DataFlowAnalyzer.mapExtendedDeclaredToZoneInfo(writtenZones, srcSymbolTable, null);
        if (this.writtenExpressionNeedsDiff(lhs, beforeActiv, afterActiv, beforeAvlX, afterReqX)) {
            boolean needSetDiffLhs = (!this.adEnv.curActivity().isContext() || this.adEnv.activeRootCalledFromContext) && (beforeActiv != null && beforeActiv.intersects(writtenDiffKindVectorIndices) || (writtenTmp || writtenDiffKindVectorIndices != null) && (TapEnv.debugAdMode() == -1 || this.adEnv.activeRootCalledFromContext || !TapEnv.spareDiffReinitializations() && ADActivityAnalyzer.haveDifferentiatedVariable(zones)));
            boolean needDiffRhs = !(!ADActivityAnalyzer.isAnnotatedActive(this.adEnv.curActivity(), lhs, srcSymbolTable) && !this.adEnv.activeRootCalledFromContext || !writtenTmp && writtenDiffKindVectorIndices == null);
            TapList<Object> toPrecomputes = new TapList<Object>(null, null);
            TapList<DiffAssignmentNode>[] diffAssignmentNodesR = this.expressionDifferentiator().adjointDifferentiateAssignedExpression(lhs, needSetDiffLhs, expression, needDiffRhs, toPrecomputes, beforeActiv, this.adEnv.curBwdSymbolTable);
            for (int iReplic = 0; iReplic < diffAssignmentNodesR.length; ++iReplic) {
                TapList<DiffAssignmentNode> diffAssignmentNodes = diffAssignmentNodesR[iReplic];
                while (diffAssignmentNodes != null) {
                    DiffAssignmentNode diffAssignmentNode = (DiffAssignmentNode)diffAssignmentNodes.head;
                    if (diffAssignmentNode.action == 2) {
                        ToBool zonesReadTotally = new ToBool(false);
                        TapIntList argZones = ZoneInfo.listAllZones(srcSymbolTable.treeOfZonesOfValue(diffAssignmentNode.primRecv, zonesReadTotally, this.adEnv.curInstruction(), null), true);
                        zones = DataFlowAnalyzer.mapExtendedDeclaredToZoneInfo(argZones, srcSymbolTable, null);
                        boolean argTmp = TapIntList.intersects(argZones, this.adEnv.toActiveTmpZones.tail);
                        TapIntList argDiffKindVectorIndices = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(argZones, this.adEnv.diffKind, this.curDiffVectorMap(), srcSymbolTable, null);
                        if (!((argTmp || argDiffKindVectorIndices != null) && (TapEnv.debugAdMode() == -1 || !TapEnv.spareDiffReinitializations() && ADActivityAnalyzer.haveDifferentiatedVariable(zones)) || afterActiv != null && afterActiv.intersects(argDiffKindVectorIndices) || this.intersectsLhs(diffAssignmentNodes.tail, diffAssignmentNode.primRecv, argZones, this.adEnv.curInstruction(), srcSymbolTable) || !argTmp && !zonesReadTotally.get())) {
                            diffAssignmentNode.action = 3;
                        }
                    }
                    if (diffAssignmentNode.action == 2) {
                        if (!ILUtils.isNullOrNone(diffAssignmentNode.diffValue) && !ILUtils.isZero(diffAssignmentNode.diffValue)) {
                            this.addFutureIncrDiffNodeBwd(diffAssignmentNode, "Increment diff from rhs");
                        }
                    } else if (diffAssignmentNode.diffValue == null || 1 != ILUtils.eqOrDisjointRef(diffAssignmentNode.diffRecv, diffAssignmentNode.diffValue, this.adEnv.curInstruction(), this.adEnv.curInstruction())) {
                        this.addFutureSetDiffNodeBwd(diffAssignmentNode, "Set diff (of lhs?)");
                    }
                    diffAssignmentNodes = diffAssignmentNodes.tail;
                }
            }
            toPrecomputes = toPrecomputes.tail;
            while (toPrecomputes != null) {
                NewBlockGraphNode futureNode = (NewBlockGraphNode)toPrecomputes.head;
                TapList<Tree> plainR = ILUtils.usedVarsInExp(futureNode.tree, null, true);
                if (futureNode.whereMask != null) {
                    plainR = ILUtils.usedVarsInExp(futureNode.whereMask.getControlTree(), plainR, true);
                }
                this.addFuturePlainNodeBwd(futureNode.tree, futureNode.whereMask, false, plainR, new TapList<Tree>(futureNode.tree.down(1), null), null, null, false, false, "Assign split primal expression", false);
                toPrecomputes = toPrecomputes.tail;
            }
        }
        if (restorePrimal) {
            this.addFuturePlainNodeFwd(refDescriptor.makePush(), null, false, ILUtils.usedVarsInExp(lhs, null, true), null, null, null, false, true, "Store TBR value before assign", false);
            refDescriptor.toBranchVariable = this.flowGraphDifferentiator().toBranchVariable;
            this.addFuturePlainNodeBwd(refDescriptor.makePop(), null, false, ILUtils.usedVarsInExp(lhs, null, false), new TapList<Tree>(lhs, null), null, null, false, true, "Restore TBR value before adj assign", false);
        }
        if (!this.adEnv.activeRootCalledFromContext && (assignmentIsLive || srcDecl != null)) {
            Tree zeroTree;
            Tree copySrcAssignment = ILUtils.copy(assignment);
            if (!assignmentIsLive && srcDecl != null && assignedType != null && (zeroTree = assignedType.buildConstantZero()) != null) {
                copySrcAssignment.setChild(zeroTree, 2);
            }
            if (copySrcAssignment.getAnnotation("hasBeenSplit") == Boolean.TRUE) {
                copySrcAssignment.removeAnnotation("sourcetree");
            }
            if (srcDecl != null && copySrcAssignment.opCode() == 14) {
                Tree srcDeclForFwd = ILUtils.copy(srcDecl);
                if (srcDeclForFwd.down(3).down(1).opCode() != 14) {
                    srcDeclForFwd.down(3).setChild(ILUtils.build(14, srcDeclForFwd.down(3).cutChild(1)), 1);
                }
                srcDeclForFwd.down(3).down(1).setChild(copySrcAssignment.cutChild(2), 2);
                copySrcAssignment = srcDeclForFwd;
            }
            if (diffRhs != null && (this.adEnv.curUnitIsContext || differentiationMode == -2) && this.curFwdDiffUnit().isC() && assignment.getAnnotation("ComesFromAReturn") == Boolean.TRUE) {
                copySrcAssignment.setChild(ILUtils.build(151, copySrcAssignment.cutChild(1)), 1);
            }
            if (TapEnv.associationByAddress()) {
                copySrcAssignment = this.turnAssociationByAddressPrimal(copySrcAssignment, srcSymbolTable, this.adEnv.curFwdSymbolTable, null, false);
            }
            this.addFuturePlainNodeFwd(copySrcAssignment, this.adEnv.curInstruction().whereMask(), false, ILUtils.usedVarsInExp(copySrcAssignment, null, false), new TapList<Tree>(assignment.down(1), null), null, null, false, false, "Copy of primal assignment", false);
        }
        if (separateBwdScope) {
            if (srcDecl != null) {
                Tree splitBwdDecl = ILUtils.copy(srcDecl);
                if (splitBwdDecl.opCode() == 199 && splitBwdDecl.down(3).down(1).opCode() == 14) {
                    splitBwdDecl.down(3).setChild(splitBwdDecl.down(3).down(1).cutChild(1), 1);
                }
                this.addFutureBwdSplitDecl(splitBwdDecl, "Copy of primal declaration for SPLIT BWD");
            }
            if (diffDecl != null) {
                this.addFutureBwdSplitDecl(ILUtils.copy(diffDecl), "Differentiated declaration");
            }
        }
        if ((!separateBwdScope || somePointerIsAssigned) && diffDeclAndAssign != null) {
            this.addFuturePlainNodeFwd(diffDeclAndAssign, null, false, ILUtils.usedVarsInExp(lhs, null, false), null, new TapList<Tree>(expression, null), new TapList<Tree>(lhs, null), false, false, "Diff assignment inside diff declarator", true);
        }
        if (this.adEnv.curUnitIsActiveUnit && (TapEnv.debugAdMode() == -1 || TapEnv.spareDiffReinitializations())) {
            TapIntList zonesReadTotally = null;
            TapList<Object> toNecessaryReInits = new TapList<Object>(null, null);
            this.checkArrayActivitySwitches(beforeActiv, afterActiv, zonesReadTotally, toNecessaryReInits, srcSymbolTable, this.adEnv.curBwdSymbolTable, false, null);
            toNecessaryReInits = toNecessaryReInits.tail;
            while (toNecessaryReInits != null) {
                Tree diffInitTree = (Tree)((TapPair)toNecessaryReInits.head).second;
                TapList diffW = (TapList)((TapPair)toNecessaryReInits.head).first;
                this.addFuturePlainNodeBwd(diffInitTree, null, false, null, null, null, diffW, false, false, "Needed array diff init before adj assign (because array activity switches)", false);
                toNecessaryReInits = toNecessaryReInits.tail;
            }
        }
    }

    private boolean intersectsLhs(TapList<DiffAssignmentNode> diffAssignmentNodes, Tree tree, TapIntList treeZones, Instruction instr, SymbolTable symbolTable) {
        boolean intersects = false;
        while (diffAssignmentNodes != null && !intersects) {
            Tree key = ((DiffAssignmentNode)diffAssignmentNodes.head).primRecv;
            TapIntList keyZones = ZoneInfo.listAllZones(symbolTable.treeOfZonesOfValue(key, null, instr, null), true);
            intersects = TapIntList.intersects(treeZones, keyZones) && -1 != ILUtils.eqOrDisjointRef(tree, key, instr, instr);
            diffAssignmentNodes = diffAssignmentNodes.tail;
        }
        return intersects;
    }

    private boolean writtenExpressionNeedsDiff(Tree expression, BoolVector beforeActiv, BoolVector afterActiv, BoolVector beforeAvlX, BoolVector afterReqX) {
        if (TapEnv.get().complexStep) {
            return false;
        }
        SymbolTable symbolTable = this.adEnv.curSymbolTable();
        TapList<?> accessibleZoneTree = symbolTable.treeOfZonesOfValue(expression, new ToBool(false), this.adEnv.curInstruction(), null);
        if (accessibleZoneTree != null) {
            accessibleZoneTree = TapList.copyTree(accessibleZoneTree);
            DataFlowAnalyzer.includePointedElementsInTree(accessibleZoneTree, null, null, true, symbolTable, this.adEnv.curInstruction(), null, false, false);
        }
        TapIntList accessibleZones = ZoneInfo.listAllZones(accessibleZoneTree, true);
        boolean accessibleTmp = TapIntList.intersects(accessibleZones, this.adEnv.toActiveTmpZones.tail);
        TapIntList accessibleVectorIndices = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(accessibleZones, 0, this.curVectorMap(), symbolTable, null);
        TapIntList accessibleDiffKindVectorIndices = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(accessibleZones, this.adEnv.diffKind, this.curDiffVectorMap(), symbolTable, null);
        TapList<ZoneInfo> zones = DataFlowAnalyzer.mapExtendedDeclaredToZoneInfo(accessibleZones, symbolTable, null);
        boolean isAnnotatedActive = ADActivityAnalyzer.isAnnotatedActive(this.adEnv.curActivity(), expression, symbolTable);
        BoolVector contextDiffRequired = symbolTable.getRequiredDiffVars(this.adEnv.curActivity());
        boolean usesPassiveFields = BlockDifferentiator.usesPassiveFields(expression, symbolTable);
        WrapperTypeSpec expressionType = symbolTable.typeOf(expression);
        boolean expressionNeedsDiff = !(usesPassiveFields || (TapEnv.doActivity() || !accessibleTmp && accessibleDiffKindVectorIndices == null) && !isAnnotatedActive && ((afterReqX == null || !accessibleTmp && !afterReqX.intersects(accessibleVectorIndices)) && (beforeAvlX == null || !accessibleTmp && !beforeAvlX.intersects(accessibleVectorIndices)) && (!TapEnv.mustContext() || beforeActiv != null || afterActiv != null || (contextDiffRequired == null || !contextDiffRequired.intersects(accessibleDiffKindVectorIndices)) && !ADActivityAnalyzer.haveDifferentiatedVariable(zones)) || !expressionType.containsAPointer() && expression.opCode() != 5 && expression.opCode() != 52) && (afterReqX == null || accessibleDiffKindVectorIndices == null || !accessibleTmp && !afterReqX.intersects(accessibleVectorIndices) || TypeSpec.isA(expressionType, 6)) && (accessibleDiffKindVectorIndices == null || beforeActiv == null || afterActiv == null || !this.adEnv.activeRootCalledFromContext && !ADActivityAnalyzer.haveDifferentiatedVariable(zones) || (!this.adEnv.activeRootCalledFromContext || !beforeActiv.intersects(accessibleDiffKindVectorIndices) && !afterActiv.intersects(accessibleDiffKindVectorIndices)) && TapEnv.spareDiffReinitializations() && !ILUtils.isAccessedThroughPointer(expression)));
        return expressionNeedsDiff;
    }

    protected void buildDiffPreInitsForTangent(Tree lhs, Tree rhs, Tree srcDecl, BoolVector beforeActiv, BoolVector afterActiv, BoolVector beforeReqX, BoolVector afterReqX, boolean onlyOnLocals, TapList<ZoneInfo> toInitialized) {
        Tree initTree;
        SymbolTable srcSymbolTable = this.adEnv.curSymbolTable();
        if (srcDecl == null) {
            ToBool total = new ToBool(false);
            TapIntList zonesWrittenTotally = srcSymbolTable.listOfZonesOfValue(lhs, total, this.adEnv.curInstruction());
            if (!total.get() || this.adEnv.curInstruction().getWhereMask() != null) {
                zonesWrittenTotally = null;
            }
            TapList<Object> toNecessaryInitsUS = new TapList<Object>(null, null);
            this.checkArrayActivitySwitches(afterActiv, beforeActiv, zonesWrittenTotally, toNecessaryInitsUS, srcSymbolTable, this.adEnv.curFwdSymbolTable, onlyOnLocals, toInitialized);
            toNecessaryInitsUS = toNecessaryInitsUS.tail;
            while (toNecessaryInitsUS != null) {
                initTree = (Tree)((TapPair)toNecessaryInitsUS.head).second;
                TapList diffW = (TapList)((TapPair)toNecessaryInitsUS.head).first;
                this.addFuturePlainNodeFwd(initTree, null, false, ILUtils.usedVarsInExp(initTree, null, false), null, null, diffW, false, false, "Needed array diff init (because array activity switches)", false);
                toNecessaryInitsUS = toNecessaryInitsUS.tail;
            }
        }
        if (TypeSpec.isA(srcSymbolTable.typeOf(lhs), 6)) {
            TapIntList writtenZones = ZoneInfo.listAllZones(srcSymbolTable.treeOfZonesOfValue(lhs, null, this.adEnv.curInstruction(), null), true);
            TapIntList writtenIndices = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(writtenZones, 0, this.curVectorMap(), srcSymbolTable, null);
            if (afterReqX != null && afterReqX.intersects(writtenIndices)) {
                TapList<ZoneInfo> zonesToCheck = srcSymbolTable.collectAddressTakenZones(rhs, this.adEnv.curInstruction(), null);
                while (zonesToCheck != null) {
                    ZoneInfo zoneToCheck = (ZoneInfo)zonesToCheck.head;
                    int rankInActive = DataFlowAnalyzer.zoneInfoToVectorIndex(zoneToCheck, 3, this.adEnv.diffKind, this.curDiffVectorMap(), null);
                    int rankInReqX = DataFlowAnalyzer.zoneInfoToVectorIndex(zoneToCheck, 3, 0, this.curVectorMap(), null);
                    if (rankInActive > 0 && beforeActiv != null && beforeReqX != null && !beforeActiv.get(rankInActive) && !beforeReqX.get(rankInReqX)) {
                        Tree[] initTreeR = this.makeDiffInitialization(zoneToCheck.accessTree, srcSymbolTable, this.adEnv.curFwdSymbolTable, null, zoneToCheck, true, null, true);
                        for (int iReplic = 0; iReplic < initTreeR.length; ++iReplic) {
                            initTree = initTreeR[iReplic];
                            if (initTree == null) continue;
                            this.addFuturePlainNodeFwd(initTree, null, false, ILUtils.usedVarsInExp(lhs, ILUtils.usedVarsInExp(rhs, null, false), false), null, null, new TapList<Tree>(zoneToCheck.accessTree, null), false, false, "Needed pointed diff pre-init", false);
                        }
                    }
                    zonesToCheck = zonesToCheck.tail;
                }
            }
        }
    }

    private void buildDiffInstructionsOfPlainDeclaration(Tree srcTree, TapList<Instruction>[] diffDeclarationsR, int differentiationMode, boolean primalIsLive) {
        boolean separateBwdScope = differentiationMode == -2 || differentiationMode == -1 && !this.adEnv.curUnitIsContext && this.adEnv.curSymbolTable() != this.adEnv.curUnit().privateSymbolTable() && this.adEnv.curSymbolTable() != this.adEnv.curUnit().publicSymbolTable() && this.adEnv.curBwdSymbolTable != this.adEnv.curFwdSymbolTable;
        TapList<Tree> readBySrcDecl = ILUtils.usedVarsInExp(srcTree, null, false);
        TapList<Tree> writtenBySrcDecl = null;
        if (srcTree.opCode() != 101 && srcTree.down(3) != null && srcTree.down(3).opCode() == 54) {
            Tree[] declarators = srcTree.down(3).children();
            for (int i = declarators.length - 1; i >= 0; --i) {
                Tree oneDeclarator = ILUtils.baseTree(declarators[i]);
                if (oneDeclarator == null || oneDeclarator.opCode() != 96) continue;
                writtenBySrcDecl = new TapList<Tree>(oneDeclarator, writtenBySrcDecl);
            }
        }
        boolean addInFuturePlainNodeFwd = true;
        if (primalIsLive && srcTree.opCode() != 197) {
            if (srcTree.getAnnotation("hasBeenSplit") == Boolean.TRUE) {
                srcTree.removeAnnotation("sourcetree");
            }
            if (srcTree.opCode() == 199) {
                Tree[] declarators = srcTree.down(3).children();
                for (int i = declarators.length - 1; i >= 0; --i) {
                    NewSymbolHolder diffVarFwdSH = NewSymbolHolder.getNewSymbolHolder(ILUtils.baseTree(declarators[i]));
                    if (diffVarFwdSH == null) continue;
                    diffVarFwdSH.setInstruction(new Instruction(srcTree));
                    diffVarFwdSH.declare = false;
                }
                if (declarators.length == 0 && TapEnv.associationByAddress()) {
                    addInFuturePlainNodeFwd = false;
                }
            }
            if (addInFuturePlainNodeFwd) {
                this.addFuturePlainNodeFwd(srcTree, null, false, readBySrcDecl, writtenBySrcDecl, null, null, false, false, "Copy of primal plain declaration", false);
            }
        }
        for (int iReplic = 0; iReplic < diffDeclarationsR.length; ++iReplic) {
            TapList<Instruction> diffDeclarations = diffDeclarationsR[iReplic];
            Tree diffDecl = null;
            if (diffDeclarations != null) {
                diffDecl = ((Instruction)diffDeclarations.head).tree;
                diffDeclarations = diffDeclarations.tail;
            }
            if (separateBwdScope) {
                if (srcTree.opCode() != 197) {
                    this.addFutureBwdSplitDecl(ILUtils.copy(srcTree), "Copy of primal plain declaration for SPLIT BWD");
                } else {
                    this.addFuturePlainNodeFwd(ILUtils.copy(diffDecl), null, false, readBySrcDecl, null, null, null, false, false, "Differentiated use declaration", false);
                }
                if (diffDecl != null) {
                    this.addFutureBwdSplitDecl(diffDecl, "Differentiated plain declaration");
                }
            } else if (diffDecl != null) {
                this.addFuturePlainNodeFwd(diffDecl, null, false, readBySrcDecl, null, null, writtenBySrcDecl, false, false, "Differentiated plain declaration", true);
            }
            while (diffDeclarations != null) {
                diffDecl = ((Instruction)diffDeclarations.head).tree;
                if (separateBwdScope) {
                    this.addFutureBwdSplitDecl(diffDecl, "Remaining part of differentiated declaration");
                } else {
                    this.addFuturePlainNodeFwd(diffDecl, null, false, readBySrcDecl, null, null, writtenBySrcDecl, false, false, "Remaining part of differentiated declaration", false);
                }
                diffDeclarations = diffDeclarations.tail;
            }
        }
    }

    private void buildDiffInstructionsOfIncrement(Tree srcTree, int differentiationMode, boolean primalIsLive, boolean mustSaveTBRBeforeInstr, BoolVector beforeActiv, BoolVector afterActiv, BoolVector afterReqX, BoolVector beforeAvlX) {
        String unaryOper;
        if (TapEnv.associationByAddress()) {
            this.updateAAInstructionMask(this.adEnv.curInstruction(), this.adEnv.curSymbolTable(), this.adEnv.curFwdSymbolTable);
        }
        String bwdOp = (unaryOper = ILUtils.getIdentString(srcTree.down(1))).equals("--prefix") || unaryOper.equals("--postfix") ? "++prefix" : "--prefix";
        Tree incrExp = srcTree.down(2);
        WrapperTypeSpec type = this.adEnv.curSymbolTable().typeOf(incrExp);
        boolean isActivePointer = TypeSpec.isA(type, 6) && this.pointerIsActiveHere(incrExp, beforeActiv, afterActiv, beforeAvlX, afterReqX);
        this.adEnv.iReplic = 0;
        while (this.adEnv.iReplic < TapEnv.diffReplica()) {
            Tree diffIncrExp = null;
            if (isActivePointer) {
                diffIncrExp = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), incrExp, this.adEnv.curFwdSymbolTable, false, srcTree, false, true, null);
                Tree diffTreeFwd = ILUtils.build(194, ILUtils.build(96, unaryOper), diffIncrExp);
                this.addFuturePlainNodeFwd(diffTreeFwd, null, false, ILUtils.usedVarsInExp(incrExp, null, true), null, new TapList<Tree>(incrExp, null), new TapList<Tree>(incrExp, null), false, false, "fwd increment of diff pointer", false);
            }
            if ((differentiationMode == -1 || differentiationMode == -2) && isActivePointer && !this.adEnv.curUnitIsContext) {
                Tree diffTreeBwd = ILUtils.build(194, ILUtils.build(96, bwdOp), ILUtils.copy(diffIncrExp));
                this.addFuturePlainNodeBwd(diffTreeBwd, null, false, ILUtils.usedVarsInExp(incrExp, null, true), null, new TapList<Tree>(incrExp, null), new TapList<Tree>(incrExp, null), false, false, "bwd decrement of diff pointer", false);
            }
            ++this.adEnv.iReplic;
        }
        this.adEnv.iReplic = 0;
        if (mustSaveTBRBeforeInstr && (differentiationMode == -1 || differentiationMode == -2)) {
            Tree reverseIncremTree = ILUtils.build(194, ILUtils.build(96, bwdOp), ILUtils.copy(incrExp));
            this.addFuturePlainNodeBwd(reverseIncremTree, null, false, new TapList<Tree>(incrExp, null), new TapList<Tree>(incrExp, null), null, null, false, false, "bwd decrement of primal variable", true);
        }
        if (primalIsLive || differentiationMode == 1) {
            this.addFuturePlainNodeFwd(ILUtils.copy(srcTree), this.adEnv.curInstruction().whereMask(), false, ILUtils.usedVarsInExp(incrExp, null, true), new TapList<Tree>(incrExp, null), null, null, false, false, "Copy of primal increment instruction", false);
        }
    }

    private void buildDiffInstructionsOfReturn(Tree srcReturn, int differentiationMode, boolean primalIsLive, BoolVector beforeActiv, BoolVector afterActiv, BoolVector afterReqX, BoolVector beforeAvlX) {
        Tree returnedExp = srcReturn.down(1);
        WrapperTypeSpec returnedType = this.adEnv.curSymbolTable().typeOf(returnedExp);
        boolean addNbDirsLoop = VarRefDifferentiator.mustAddNbDirsDim(returnedType);
        Tree[] diffTreeR = null;
        Tree diffTree = null;
        Tree copyTree = null;
        if (differentiationMode == 1) {
            boolean mustDiffOperation;
            TapList refsR = null;
            TapList refsW = null;
            TapList diffRefsR = null;
            TapList diffRefsW = null;
            boolean[] formalArgsActivity = this.callGraphDifferentiator().getUnitFormalArgsActivityS(this.adEnv.curActivity());
            boolean resultIsActive = formalArgsActivity[formalArgsActivity.length - 1];
            boolean bl = mustDiffOperation = resultIsActive && !ILUtils.isNullOrNone(returnedExp);
            if (returnedType != null && returnedType.containsAPointer()) {
                if (mustDiffOperation) {
                    diffTreeR = new Tree[TapEnv.diffReplica()];
                    this.adEnv.iReplic = 0;
                    while (this.adEnv.iReplic < diffTreeR.length) {
                        Tree diffVar = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), returnedExp, this.adEnv.curFwdSymbolTable, false, srcReturn, false, true, null);
                        if (TapEnv.diffReplica() > 1) {
                            int tailIndexInDiffArgs = -TapEnv.diffReplica() + this.adEnv.iReplic;
                            Tree diffResultVar = ILUtils.getArguments(this.curDiffUnit().entryBlock().headTree()).down(tailIndexInDiffArgs);
                            diffTree = ILUtils.build(14, ILUtils.copy(diffResultVar), diffVar);
                        } else {
                            diffTree = ILUtils.build(168, diffVar, ILUtils.copy(srcReturn.down(2)));
                        }
                        diffTreeR[this.adEnv.iReplic] = diffTree;
                        ++this.adEnv.iReplic;
                    }
                    this.adEnv.iReplic = 0;
                    refsR = ILUtils.usedVarsInExp(returnedExp, null, false);
                    refsW = null;
                    diffRefsR = new TapList(returnedExp, null);
                    diffRefsW = new TapList(returnedExp, null);
                }
            } else {
                TapPair<Object, Object> refsRW = new TapPair<Object, Object>(null, null);
                TapPair<Object, Object> diffRefsRW = new TapPair<Object, Object>(null, null);
                ToObject<Tree> toReturnedExp = new ToObject<Tree>(returnedExp);
                if (mustDiffOperation && (this.multiDirMode() || TapEnv.diffReplica() > 1 || this.curDiffUnit().functionTypeSpec().isAFunction())) {
                    diffTreeR = this.tangentDiffExpr(toReturnedExp, beforeActiv, refsRW, diffRefsRW);
                    for (int iReplic = 0; iReplic < diffTreeR.length; ++iReplic) {
                        diffTree = diffTreeR[iReplic];
                        if (this.adEnv.curUnit().isC() && diffTree == null) {
                            diffTree = returnedType != null && returnedType.wrappedType != null ? returnedType.wrappedType.buildConstantZero() : ILUtils.build(160, "0.0");
                        }
                        if (TapEnv.diffReplica() > 1) {
                            int tailIndexInDiffArgs = -TapEnv.diffReplica() + iReplic;
                            Tree diffResultVar = ILUtils.getArguments(this.curDiffUnit().entryBlock().headTree()).down(tailIndexInDiffArgs);
                            diffTree = ILUtils.build(14, ILUtils.copy(diffResultVar), diffTree);
                        } else if (this.multiDirMode() && this.adEnv.curUnit() != this.adEnv.srcCallGraph().getMainUnit()) {
                            Tree diffResultVar = ILUtils.getArguments(this.curDiffUnit().entryBlock().headTree()).down(-2);
                            Tree diffDimensions = ILUtils.build(71, this.varRefDifferentiator().dirIndexSymbolHolder.makeNewRef(this.adEnv.curFwdSymbolTable));
                            diffTree = ILUtils.build(14, ILUtils.build(9, ILUtils.copy(diffResultVar), diffDimensions), diffTree);
                        } else {
                            diffTree = ILUtils.build(168, diffTree);
                        }
                        diffTreeR[iReplic] = diffTree;
                    }
                }
                srcReturn = ILUtils.build(168, toReturnedExp.obj(), ILUtils.copy(srcReturn.down(2)));
                refsR = (TapList)refsRW.first;
                refsW = (TapList)refsRW.second;
                diffRefsR = (TapList)diffRefsRW.first;
                diffRefsW = (TapList)diffRefsRW.second;
            }
            copyTree = ILUtils.removeSourceCodeAnnot(ILUtils.copy(srcReturn));
            if (primalIsLive && !ILUtils.isNullOrNone(returnedExp)) {
                boolean builtSomeDiffTree;
                boolean bl2 = builtSomeDiffTree = diffTreeR != null && diffTreeR.length > 0 && diffTreeR[0] != null;
                if (!builtSomeDiffTree && !resultIsActive && this.curFwdDiffUnit().isFortran() && this.adEnv.curUnit().isAFunction()) {
                    Tree returnVar;
                    String returnVarName;
                    String string = returnVarName = this.adEnv.curUnit().otherReturnVar() == null ? this.adEnv.curUnit().name() : this.adEnv.curUnit().otherReturnVar().symbol;
                    if ("main".equals(returnVarName)) {
                        returnVarName = "mainResult";
                    }
                    this.flowGraphDifferentiator().returnedVariable = returnVar = ILUtils.build(96, returnVarName);
                    Tree returnPrimalInDiff = ILUtils.build(14, ILUtils.copy(returnVar), ILUtils.copy(copyTree.cutChild(1)));
                    this.addFuturePlainNodeFwd(returnPrimalInDiff, null, false, ILUtils.usedVarsInExp(srcReturn.down(1), null, true), null, null, null, false, false, "Prepare return of primal result because no diff result", true);
                    copyTree.setChild(ILUtils.copy(returnVar), 1);
                }
                if (builtSomeDiffTree && this.adEnv.curUnit().isC() && !TapEnv.associationByAddress() && this.adEnv.curUnit() != this.adEnv.srcCallGraph().getMainUnit()) {
                    int tailIndexInDiffArgs = TapEnv.diffReplica() > 1 ? -1 - TapEnv.diffReplica() : (this.multiDirMode() ? -3 : -1);
                    Tree returnedTree = ILUtils.getArguments(this.curDiffUnit().entryBlock().headTree()).down(tailIndexInDiffArgs);
                    if (returnedTree != null) {
                        returnedTree = ILUtils.copy(returnedTree.down(1));
                        copyTree = ILUtils.build(14, ILUtils.build(151, returnedTree), copyTree.cutChild(1));
                    }
                }
            }
            if (primalIsLive) {
                this.addFuturePlainNodeFwd(copyTree, null, false, ILUtils.usedVarsInExp(returnedExp, null, true), null, null, null, false, false, "Copy primal return instruction", true);
            }
            if (diffTreeR != null) {
                for (int iReplic = 0; iReplic < diffTreeR.length; ++iReplic) {
                    if (diffTreeR[iReplic] == null) continue;
                    this.addFuturePlainNodeFwd(diffTreeR[iReplic], null, addNbDirsLoop, refsR, refsW, diffRefsR, diffRefsW, false, false, "Differentiated return instruction", true);
                }
            }
        } else if ((differentiationMode == -1 || differentiationMode == -2) && this.adEnv.curUnitIsContext) {
            this.addFuturePlainNodeFwd(ILUtils.removeSourceCodeAnnot(ILUtils.copy(srcReturn)), null, false, ILUtils.usedVarsInExp(returnedExp, null, true), null, null, null, false, false, "Copy primal return instruction (context)", true);
        }
    }

    private void buildDiffInstructionsOfIORead(Tree tree, int differentiationMode, boolean primalIsLive, boolean mustSaveTBRBeforeInstr, BoolVector beforeActiv, BoolVector afterActiv, BoolVector beforeUseful, BoolVector afterUseful) {
        TapPair refsRW;
        TapList<IterDescriptor> iterators = this.multiDirMode() ? new TapList<IterDescriptor>(this.varRefDifferentiator().multiDirIterDescriptor, null) : null;
        TapList<TapTriplet<Tree, TapPair<TapList<Tree>, TapList<Tree>>, TapPair<TapList<Tree>, TapList<Tree>>>> initTrees = this.reinitializeDiffIOVars(tree.down(3), differentiationMode == 1 ? this.adEnv.curFwdSymbolTable : this.adEnv.curBwdSymbolTable, iterators, beforeActiv, afterActiv, beforeUseful, afterUseful);
        if (differentiationMode == 1) {
            while (initTrees != null) {
                TapTriplet diffTriplet = (TapTriplet)initTrees.head;
                Tree diffTree = (Tree)diffTriplet.first;
                refsRW = (TapPair)diffTriplet.second;
                TapPair diffRefsRW = (TapPair)diffTriplet.third;
                this.addFuturePlainNodeFwd(diffTree, null, false, (TapList)refsRW.first, (TapList)refsRW.second, (TapList)diffRefsRW.first, (TapList)diffRefsRW.second, false, false, "Needed diff init before IO-read", false);
                initTrees = initTrees.tail;
            }
        } else if (differentiationMode == -1 || differentiationMode == -2) {
            TapTriplet diffTriplet;
            TapList<Tree> overwrittenTBRExprs = mustSaveTBRBeforeInstr ? this.hasTBRexps(tree.down(3), null) : null;
            TapList<TapTriplet<Tree, TapPair<TapList<Tree>, TapList<Tree>>, TapPair<TapList<Tree>, TapList<Tree>>>> inInitTrees = initTrees;
            while (inInitTrees != null) {
                diffTriplet = (TapTriplet)inInitTrees.head;
                TapList refsW = (TapList)((TapPair)diffTriplet.second).second;
                while (refsW != null) {
                    if (ADTBRAnalyzer.isTBR(this.adEnv.curActivity(), (Tree)refsW.head) && !TapList.contains(overwrittenTBRExprs, refsW.head)) {
                        overwrittenTBRExprs = new TapList<Tree>((Tree)refsW.head, overwrittenTBRExprs);
                    }
                    refsW = refsW.tail;
                }
                inInitTrees = inInitTrees.tail;
            }
            while (overwrittenTBRExprs != null) {
                Tree overwrittenExp = (Tree)overwrittenTBRExprs.head;
                RefDescriptor refDescriptor = new RefDescriptor(overwrittenExp, null, this.adEnv.curSymbolTable(), this.curFwdDiffUnit().privateSymbolTable(), null, null, false, null, this.curDiffUnit());
                if (refDescriptor.isChannelOrIO()) {
                    TapEnv.fileWarning(15, tree, "(AD07) Data-Flow recovery (TBR) on this I-O call needs to save the I-O state");
                } else if (this.adEnv.curSymbolTable().varHasModifier(overwrittenExp, "allocatable")) {
                    TapEnv.fileWarning(15, tree, "(AD07) Data-Flow recovery (TBR) on this I-O call needs to restore allocatable pointer " + ILUtils.toString(overwrittenExp) + ", not implemented yet");
                } else {
                    this.prepareRestoreOperations(refDescriptor, null, 0, this.adEnv.curFwdSymbolTable, this.adEnv.curBwdSymbolTable);
                    TapList<Tree> subExpsRead = ILUtils.usedVarsInExp(overwrittenExp, null, false);
                    this.addFuturePlainNodeFwd(refDescriptor.makePush(), null, false, new TapList<Tree>(overwrittenExp, subExpsRead), null, null, null, false, true, "Store TBR value before IO-read", false);
                    refDescriptor.toBranchVariable = this.flowGraphDifferentiator().toBranchVariable;
                    this.addFuturePlainNodeBwd(refDescriptor.makePop(), null, false, subExpsRead, new TapList<Tree>(overwrittenExp, null), null, null, false, true, "Restore TBR value before IO-read", false);
                }
                overwrittenTBRExprs = overwrittenTBRExprs.tail;
            }
            while (initTrees != null) {
                diffTriplet = (TapTriplet)initTrees.head;
                Tree diffTree = (Tree)diffTriplet.first;
                refsRW = (TapPair)diffTriplet.second;
                TapPair diffRefsRW = (TapPair)diffTriplet.third;
                this.addFuturePlainNodeBwd(diffTree, null, false, (TapList)refsRW.first, (TapList)refsRW.second, (TapList)diffRefsRW.first, (TapList)diffRefsRW.second, false, false, "Reinitialize diff due to IO-read", false);
                initTrees = initTrees.tail;
            }
        }
        if (primalIsLive || differentiationMode == 1) {
            Tree copyTree = ILUtils.removeSourceCodeAnnot(ILUtils.copy(tree));
            refsRW = new TapPair(null, null);
            if (TapEnv.associationByAddress()) {
                copyTree = this.turnAssociationByAddressPrimal(copyTree, this.adEnv.curSymbolTable(), this.adEnv.curFwdSymbolTable, null, false);
            }
            this.fillRefsRW(tree, refsRW);
            this.addFuturePlainNodeFwd(copyTree, null, false, (TapList)refsRW.first, (TapList)refsRW.second, null, null, false, false, "Copy IO-read", true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Tree turnAssociationByAddressPrimal(Tree expr, SymbolTable srcSymbolTable, SymbolTable destSymbolTable, WrapperTypeSpec contextTypeSpec, boolean onlyPrimalCode) {
        switch (expr.opCode()) {
            case 9: 
            case 75: 
            case 96: 
            case 151: {
                if (!onlyPrimalCode && TapEnv.get().complexStep && this.adEnv.curActivity() != null && ADActivityAnalyzer.isAnnotatedActive(this.adEnv.curActivity(), expr, srcSymbolTable)) return expr;
                WrapperTypeSpec exprType = srcSymbolTable.typeOf(expr);
                String varName = ILUtils.baseName(expr);
                VariableDecl varDecl = srcSymbolTable.getVariableOrConstantDecl(varName);
                if (varDecl == null) return expr;
                WrapperTypeSpec baseExprType = exprType.baseTypeSpec(true);
                VariableDecl diffVarDecl = destSymbolTable.getVariableOrConstantDecl(varName);
                if (baseExprType != null && baseExprType.isDifferentiablePlainType() && varDecl.isActiveSymbolDecl() && (contextTypeSpec == null || varDecl.type().wrappedType().diffTypeSpec != null && !contextTypeSpec.equalsNeglectSizes(varDecl.type().wrappedType().diffTypeSpec))) {
                    boolean isVarDeclOfCopiedUnit = this.curDiffUnit().isAFunction() && this.curDiffUnit().isFortran() && this.curDiffUnit().name().equals(varName);
                    if (onlyPrimalCode) return ILUtils.build(75, ILUtils.copy(expr), ILUtils.build(96, TapEnv.assocAddressValueSuffix()));
                    if (isVarDeclOfCopiedUnit) {
                        return ILUtils.build(75, ILUtils.copy(expr), ILUtils.build(96, TapEnv.assocAddressValueSuffix()));
                    }
                    expr = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), expr, destSymbolTable, this.varRefDifferentiator().isCurFunctionName(varName), expr, false, true, null);
                    if (expr.opCode() != 75) return expr;
                    expr.setChild(ILUtils.build(96, TapEnv.assocAddressValueSuffix()), 2);
                    return expr;
                }
                if (contextTypeSpec == null) return expr;
                if (diffVarDecl.type().wrappedType().diffTypeSpec == null) return expr;
                if (contextTypeSpec.equalsCompilDep(diffVarDecl.type().wrappedType().diffTypeSpec)) return expr;
            }
            case 31: {
                Tree[] args = ILUtils.getArguments(expr).children();
                FunctionTypeSpec functionTypeSpec = null;
                Unit functionUnit = null;
                Object callArrowAnnot = expr.getAnnotation("callArrow");
                if (callArrowAnnot != null) {
                    CallArrow callArrow = (CallArrow)callArrowAnnot;
                    functionUnit = callArrow.destination;
                    Unit copiedCalledUnit = this.adEnv.copiedUnits.retrieve(functionUnit);
                    functionTypeSpec = copiedCalledUnit != null ? copiedCalledUnit.functionTypeSpec() : functionUnit.functionTypeSpec();
                }
                boolean[] formalArgsActivity = null;
                if (functionUnit != null) {
                    ActivityPattern calledActivity = (ActivityPattern)ActivityPattern.getAnnotationForActivityPattern(expr, this.adEnv.curActivity(), "multiActivityCalleePatterns");
                    UnitDiffInfo diffInfo = this.callGraphDifferentiator().getUnitDiffInfo(functionUnit);
                    formalArgsActivity = diffInfo.getUnitFormalArgsActivityS(calledActivity);
                }
                WrapperTypeSpec argType = null;
                int i = args.length - 1;
                while (i >= 0) {
                    boolean actualActive;
                    String varName;
                    if (functionTypeSpec != null && functionTypeSpec.argumentsTypes.length > i) {
                        argType = functionTypeSpec.argumentsTypes[i];
                    }
                    VariableDecl varDecl = (varName = ILUtils.baseName(args[i])) == null ? null : srcSymbolTable.getVariableDecl(varName);
                    boolean bl = actualActive = varDecl == null ? false : varDecl.isActiveSymbolDecl();
                    if (argType == null || !argType.equalsCompilIndep(destSymbolTable.typeOf(args[i])) || TapEnv.get().complexStep && actualActive && (formalArgsActivity == null || !formalArgsActivity[i + 1])) {
                        Tree newArg = this.turnAssociationByAddressPrimal(args[i], srcSymbolTable, destSymbolTable, argType, onlyPrimalCode);
                        ILUtils.getArguments(expr).setChild(newArg, i + 1);
                    }
                    --i;
                }
                return expr;
            }
            case 14: {
                WrapperTypeSpec callResultType = null;
                if (expr.down(2).opCode() == 31 && this.curDiffUnit() == this.adEnv.copiedUnits.retrieve(this.adEnv.curUnit())) {
                    callResultType = destSymbolTable.typeOf(expr.down(2));
                }
                expr.setChild(this.turnAssociationByAddressPrimal(expr.down(2), srcSymbolTable, destSymbolTable, callResultType, onlyPrimalCode), 2);
                if (TapEnv.get().complexStep) return expr;
                expr.setChild(this.turnAssociationByAddressPrimal(expr.down(1), srcSymbolTable, destSymbolTable, callResultType, onlyPrimalCode), 1);
                return expr;
            }
            default: {
                if (expr.isAtom()) return expr;
                Tree[] children = expr.children();
                int i = children.length - 1;
                while (i >= 0) {
                    expr.setChild(this.turnAssociationByAddressPrimal(children[i], srcSymbolTable, destSymbolTable, null, onlyPrimalCode), i + 1);
                    --i;
                }
                return expr;
            }
        }
        return expr;
    }

    private void buildDiffInstructionsOfParallelPragma(Tree pragma, int differentiationMode, BoolVector beforeActiv) {
        Directive scopingsDirective = this.adEnv.curInstruction().hasDirective(differentiationMode == 1 ? 25 : 26);
        TapList<Object> toClausesGivenScoping = new TapList<Object>(null, null);
        TapList<Object> toForcedAtomicScopingNames = new TapList<Object>(null, null);
        TapList<Object> toForcedOtherScopingNames = new TapList<Object>(null, null);
        if (scopingsDirective != null) {
            Directive.analyzeMultithreadScopings(scopingsDirective.arguments[0], !this.adEnv.curUnit().isFortran(), toClausesGivenScoping, toForcedAtomicScopingNames, toForcedOtherScopingNames);
        }
        TapList<String> forcedScopingNames = TapList.append(toForcedAtomicScopingNames.tail, toForcedOtherScopingNames.tail);
        this.curBlock().headInstr().tree.setAnnotation("forcedScopingNames", forcedScopingNames);
        if (differentiationMode == 1) {
            Tree newClausesTree = null;
            if (ILUtils.isIdent(pragma.down(1), "OMP", true)) {
                Tree[] clauses = pragma.down(2).children();
                TapList<Tree> newClauses = null;
                for (int i = clauses.length - 1; i >= 0; --i) {
                    Tree clause = clauses[i];
                    Tree diffClause = null;
                    switch (clause.opCode()) {
                        case 77: 
                        case 114: 
                        case 157: 
                        case 174: {
                            Tree diffIdents = this.diffClauseIdents(clause.down(1), this.adEnv.curFwdSymbolTable, null, null, null, null, forcedScopingNames);
                            if (ILUtils.isNullOrEmptyList(diffIdents)) break;
                            diffClause = ILUtils.build(clause.opCode(), diffIdents);
                            break;
                        }
                        case 162: {
                            Tree diffIdents = this.diffClauseIdents(clause.down(2), this.adEnv.curFwdSymbolTable, null, null, null, null, forcedScopingNames);
                            if (ILUtils.isNullOrEmptyList(diffIdents)) break;
                            if (!ILUtils.isIdent(clause.down(1), "+", true)) {
                                TapEnv.fileError(clause, "Only OpenMP sum-reductions can be differentiated.");
                                break;
                            }
                            diffClause = ILUtils.build(162, ILUtils.copy(clause.down(1)), diffIdents);
                            break;
                        }
                        case 141: 
                        case 172: {
                            break;
                        }
                        default: {
                            TapEnv.toolWarning(-1, "(Differentiate parallel clause, tangent) Unexpected operator: " + clause.opName());
                        }
                    }
                    if (diffClause != null) {
                        newClauses = new TapList<Tree>(diffClause, newClauses);
                    }
                    newClauses = new TapList<Tree>(ILUtils.copy(clause), newClauses);
                }
                newClauses = this.addGivenDiffScopings(toClausesGivenScoping.tail, newClauses, this.adEnv.curFwdSymbolTable);
                newClausesTree = ILUtils.build(71, newClauses);
            } else if (ILUtils.isIdent(pragma.down(1), "CUDA", true)) {
                newClausesTree = ILUtils.copy(pragma.down(2));
            }
            Tree diffPragma = ILUtils.build(pragma.opCode(), ILUtils.copy(pragma.down(1)), newClausesTree, null);
            this.addFuturePlainNodeFwd(diffPragma, null, false, null, null, null, null, false, true, "Tangent diff Parallel Pragma", true);
        } else {
            Tree bwdPragma;
            Tree fwdPragma;
            boolean isCuda = ILUtils.isIdent(pragma.down(1), "CUDA", true);
            BoolVector onlyReadSmallActivePrimals = null;
            if (beforeActiv != null && !isCuda) {
                TapIntList varZones;
                TapTriplet<TapList<FGArrow>, TapList<Block>, TapList<FGArrow>> frontier = this.adEnv.curUnit().getFrontierOfParallelRegion(this.curBlock());
                int[] vectorMap = this.curVectorMap();
                TapPair<BoolVector, BoolVector> inOuts = TapEnv.inOutAnalyzer().getInOutOfRegion(frontier, this.adEnv.curUnit());
                BoolVector activesAllKind = DataFlowAnalyzer.changeKind(beforeActiv, this.curDiffVectorMap(), this.adEnv.diffKind, vectorMap, 0, this.adEnv.curSymbolTable());
                onlyReadSmallActivePrimals = activesAllKind.and((BoolVector)inOuts.first).minus((BoolVector)inOuts.second);
                for (int i = vectorMap[2]; i < vectorMap[3]; ++i) {
                    int knownSize;
                    if (!onlyReadSmallActivePrimals.get(i)) continue;
                    ZoneInfo zi = DataFlowAnalyzer.vectorIndexToZoneInfo(i, 3, 0, vectorMap, this.adEnv.curSymbolTable());
                    int n = knownSize = zi == null ? -1 : zi.knownSize(this.adEnv.curSymbolTable());
                    if (knownSize != -1 && knownSize <= 99) continue;
                    onlyReadSmallActivePrimals.set(i, false);
                }
                toForcedAtomicScopingNames = toForcedAtomicScopingNames.tail;
                while (toForcedAtomicScopingNames != null) {
                    VariableDecl variableDecl = this.adEnv.curSymbolTable().getVariableDecl((String)toForcedAtomicScopingNames.head);
                    varZones = variableDecl == null ? null : DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(ZoneInfo.listAllZones(variableDecl.zones(), false), 0, vectorMap, this.adEnv.curSymbolTable(), null);
                    onlyReadSmallActivePrimals.set(varZones, false);
                    toForcedAtomicScopingNames = toForcedAtomicScopingNames.tail;
                }
                toForcedOtherScopingNames = toForcedOtherScopingNames.tail;
                while (toForcedOtherScopingNames != null) {
                    VariableDecl variableDecl = this.adEnv.curSymbolTable().getVariableDecl((String)toForcedOtherScopingNames.head);
                    varZones = variableDecl == null ? null : DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(ZoneInfo.listAllZones(variableDecl.zones(), false), 0, vectorMap, this.adEnv.curSymbolTable(), null);
                    onlyReadSmallActivePrimals.set(varZones, true);
                    toForcedOtherScopingNames = toForcedOtherScopingNames.tail;
                }
                this.curBlock().headInstr().tree.setAnnotation("onlyReadSmallActivePrimals", onlyReadSmallActivePrimals);
            }
            if (isCuda) {
                fwdPragma = ILUtils.copy(pragma);
            } else {
                fwdPragma = ILUtils.copy(pragma);
                Tree srcSchedule = ILUtils.getRemoveSchedule(fwdPragma);
                this.curBlock().headInstr().tree.setAnnotation("srcSchedule", srcSchedule);
            }
            this.addFuturePlainNodeFwd(fwdPragma, null, false, null, null, null, null, false, true, "Copy of primal Parallel Pragma", false);
            if (isCuda) {
                bwdPragma = ILUtils.copy(pragma);
            } else {
                TapList<Tree> newClauses = null;
                TapList<Tree> bwdPrivatePreInits = null;
                TapList<Tree> bwdPrivatePostInits = null;
                Tree[] clauses = pragma.down(2).children();
                if (clauses.length > 0) {
                    BoolVector conflictFreeAdjointSharedVars = null;
                    if (this.curBlock().headInstr().tree.opCode() == 145) {
                        conflictFreeAdjointSharedVars = TapEnv.multithreadAnalyzer().getConflictFreeSharedAdjointZones(this.curBlock());
                    }
                    for (int i = clauses.length - 1; i >= 0; --i) {
                        Tree clause = clauses[i];
                        Tree diffClause = null;
                        switch (clause.opCode()) {
                            case 174: {
                                ToObject<Object> toReductionIdents = new ToObject<Object>(null);
                                Tree diffIdents = this.diffClauseIdents(clause.down(1), this.adEnv.curBwdSymbolTable, null, conflictFreeAdjointSharedVars, onlyReadSmallActivePrimals, toReductionIdents, forcedScopingNames);
                                if (toReductionIdents.obj() != null) {
                                    newClauses = new TapList<Tree>(ILUtils.build(162, ILUtils.build(96, "+"), toReductionIdents.obj()), newClauses);
                                }
                                if (ILUtils.isNullOrEmptyList(diffIdents)) break;
                                diffClause = ILUtils.build(174, diffIdents);
                                break;
                            }
                            case 157: {
                                ToObject<Object> toInits = new ToObject<Object>(null);
                                Tree diffIdents = this.diffClauseIdents(clause.down(1), this.adEnv.curBwdSymbolTable, toInits, null, null, null, forcedScopingNames);
                                if (ILUtils.isNullOrEmptyList(diffIdents)) break;
                                diffClause = ILUtils.build(157, diffIdents);
                                bwdPrivatePreInits = TapList.append(bwdPrivatePreInits, BlockDifferentiator.listOfCutChildren(toInits.obj()));
                                break;
                            }
                            case 77: {
                                Tree diffIdents = this.diffClauseIdents(clause.down(1), this.adEnv.curBwdSymbolTable, null, null, null, null, forcedScopingNames);
                                if (ILUtils.isNullOrEmptyList(diffIdents)) break;
                                diffClause = ILUtils.build(162, ILUtils.build(96, "+"), diffIdents);
                                break;
                            }
                            case 114: {
                                ToObject<Object> toInits = new ToObject<Object>(null);
                                Tree diffIdents = this.diffClauseIdents(clause.down(1), this.adEnv.curBwdSymbolTable, toInits, null, null, null, forcedScopingNames);
                                if (ILUtils.isNullOrEmptyList(diffIdents)) break;
                                diffClause = ILUtils.build(77, diffIdents);
                                bwdPrivatePreInits = new TapList<Tree>(ILUtils.build(98, ILUtils.build(96, "isNotLastThread"), ILUtils.copy(toInits.obj())), bwdPrivatePreInits);
                                bwdPrivatePostInits = TapList.append(bwdPrivatePostInits, BlockDifferentiator.listOfCutChildren(ILUtils.copy(toInits.obj())));
                                break;
                            }
                            case 162: {
                                Tree diffIdents = this.diffClauseIdents(clause.down(2), this.adEnv.curBwdSymbolTable, null, null, null, null, forcedScopingNames);
                                if (ILUtils.isNullOrEmptyList(diffIdents)) break;
                                if (!ILUtils.isIdent(clause.down(1), "+", true)) {
                                    TapEnv.fileError(clause, "Only OpenMP sum-reductions can be differentiated.");
                                    break;
                                }
                                diffClause = ILUtils.build(77, diffIdents);
                                break;
                            }
                            case 141: 
                            case 172: {
                                break;
                            }
                            default: {
                                TapEnv.toolWarning(-1, "(Differentiate parallel clause, adjoint) Unexpected operator: " + clause.opName());
                            }
                        }
                        if (diffClause != null) {
                            newClauses = new TapList<Tree>(diffClause, newClauses);
                        }
                        if (clause.opCode() == 172) continue;
                        newClauses = new TapList<Tree>(ILUtils.copy(clause), newClauses);
                    }
                }
                newClauses = this.addGivenDiffScopings(toClausesGivenScoping.tail, newClauses, this.adEnv.curBwdSymbolTable);
                bwdPragma = ILUtils.build(pragma.opCode(), ILUtils.copy(pragma.down(1)), ILUtils.build(71, newClauses), null);
                bwdPragma.setAnnotation("bwdOMPPrivateInits", new TapPair<Object, Object>(bwdPrivatePreInits, bwdPrivatePostInits));
            }
            this.addFuturePlainNodeBwd(bwdPragma, null, false, null, null, null, null, false, true, "Adjoint of Parallel Pragma", false);
        }
    }

    private boolean containsShared(Tree[] clauses) {
        boolean contains = false;
        for (int i = clauses.length - 1; !contains && i >= 0; --i) {
            if (clauses[i].opCode() != 174) continue;
            contains = true;
        }
        return contains;
    }

    protected static BoolVector getOnlyReadSmallActivePrimals(Block usageBlock) {
        Instruction parallelRegionInstr = TapList.last(usageBlock.parallelControls);
        return parallelRegionInstr == null ? null : (BoolVector)parallelRegionInstr.tree.getAnnotation("onlyReadSmallActivePrimals");
    }

    protected static TapList<String> getForcedScopingNames(Block usageBlock) {
        Instruction parallelRegionInstr = TapList.last(usageBlock.parallelControls);
        return parallelRegionInstr == null ? null : (TapList)parallelRegionInstr.tree.getAnnotation("forcedScopingNames");
    }

    private Tree diffClauseIdents(Tree identsTree, SymbolTable diffSymbolTable, ToObject<Tree> toInits, BoolVector zonesConflictFree, BoolVector zonesApart, ToObject<Tree> toIdentsTreeApart, TapList<String> forcedScopingNames) {
        Tree[] idents = identsTree.children();
        TapList<Tree> newIdents = null;
        TapList<Tree> newIdentsApart = null;
        TapList<Tree> zeroInits = null;
        int[] vectorMap = this.curVectorMap();
        for (int i = idents.length - 1; i >= 0; --i) {
            TapIntList varZones;
            VariableDecl variableDecl;
            String baseName = ILUtils.baseName(idents[i]);
            if (baseName == null || TapList.containsString(forcedScopingNames, baseName, !this.adEnv.curUnit().isFortran()) || (variableDecl = diffSymbolTable.getVariableDecl(baseName)) == null || !variableDecl.isActiveSymbolDecl()) continue;
            Tree newTree = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), idents[i], diffSymbolTable, false, identsTree, false, true, null);
            TapIntList tapIntList = varZones = zonesApart == null ? null : ZoneInfo.listAllZones(variableDecl.zones(), false);
            if (zonesConflictFree != null && DataFlowAnalyzer.containsExtendedDeclared(zonesConflictFree, vectorMap, 0, varZones, null, this.adEnv.curSymbolTable(), null)) {
                newIdents = new TapList<Tree>(newTree, newIdents);
                continue;
            }
            if (zonesApart != null && DataFlowAnalyzer.intersectsExtendedDeclared(zonesApart, vectorMap, 0, varZones, null, this.adEnv.curSymbolTable(), null)) {
                newIdentsApart = new TapList<Tree>(newTree, newIdentsApart);
                continue;
            }
            newIdents = new TapList<Tree>(newTree, newIdents);
            if (toInits == null) continue;
            Tree[] zeroInitR = this.makeDiffInitialization(idents[i], this.adEnv.curSymbolTable(), diffSymbolTable, null, null, false, null, true);
            for (int iReplic = 0; iReplic < zeroInitR.length; ++iReplic) {
                Tree zeroInit = zeroInitR[iReplic];
                zeroInits = new TapList<Tree>(zeroInit, zeroInits);
            }
        }
        if (toInits != null && zeroInits != null) {
            toInits.setObj(ILUtils.build(27, zeroInits));
        }
        if (toIdentsTreeApart != null) {
            toIdentsTreeApart.setObj(newIdentsApart == null ? null : ILUtils.build(97, newIdentsApart));
        }
        return newIdents == null ? null : ILUtils.build(97, newIdents);
    }

    private static TapList<Tree> listOfCutChildren(Tree tree) {
        TapList<Tree> result = null;
        for (int i = tree.length(); i > 0; --i) {
            result = new TapList<Tree>(tree.cutChild(i), result);
        }
        return result;
    }

    private TapList<Tree> addGivenDiffScopings(TapList<Tree> clausesGivenScoping, TapList<Tree> clauses, SymbolTable diffSymbolTable) {
        while (clausesGivenScoping != null) {
            Tree givenClause;
            int rankOfIdents = (givenClause = (Tree)clausesGivenScoping.head).opCode() == 162 ? 2 : 1;
            Tree givenNames = givenClause.down(rankOfIdents);
            Tree diffGivenNames = this.diffClauseIdents(givenNames, diffSymbolTable, null, null, null, null, null);
            if (!ILUtils.isNullOrEmptyList(diffGivenNames)) {
                givenClause.setChild(diffGivenNames, rankOfIdents);
                clauses = new TapList<Tree>(givenClause, clauses);
            }
            clausesGivenScoping = clausesGivenScoping.tail;
        }
        return clauses;
    }

    private void buildDiffInstructionsOfOther(Tree tree, int differentiationMode, boolean primalIsLive, BoolVector beforeActiv) {
        if (TapEnv.associationByAddress()) {
            this.updateAAInstructionMask(this.adEnv.curInstruction(), this.adEnv.curSymbolTable(), this.adEnv.curFwdSymbolTable);
        }
        TapPair<Object, Object> refsRW = new TapPair<Object, Object>(null, null);
        TapPair<Object, Object> diffRefsRW = new TapPair<Object, Object>(null, null);
        if (tree.opCode() == 98 && TapEnv.valid() && differentiationMode == 1) {
            TapList<Tree> switchExpressions = this.collectSwitchExpressions(tree.down(1), null);
            while (switchExpressions != null) {
                Tree switchExpression = (Tree)switchExpressions.head;
                ToObject<Tree> toSwitchExp = new ToObject<Tree>(switchExpression);
                Tree[] diffTreeR = this.tangentDiffExpr(toSwitchExp, beforeActiv, refsRW, diffRefsRW);
                Tree diffTree = diffTreeR[0];
                switchExpression = toSwitchExp.obj();
                if (diffTree != null) {
                    String typeName = this.adEnv.curSymbolTable().typeOf(switchExpression).buildTypeNameForProcName(new TapList<Object>(null, null), this.adEnv.curSymbolTable());
                    Tree validityTest = ILUtils.buildCall(ILUtils.build(96, "validity_domain_" + typeName), ILUtils.build(71, switchExpression, diffTree));
                    this.addFuturePlainNodeFwd(validityTest, null, false, (TapList)refsRW.first, (TapList)refsRW.second, (TapList)diffRefsRW.first, (TapList)diffRefsRW.second, false, false, "Domain of validity test for conditional", false);
                }
                switchExpressions = switchExpressions.tail;
            }
        }
        if (primalIsLive) {
            this.fillRefsRW(tree, refsRW);
            Tree copyTree = ILUtils.removeSourceCodeAnnot(ILUtils.copy(tree));
            if (TapEnv.associationByAddress()) {
                copyTree = this.turnAssociationByAddressPrimal(copyTree, this.adEnv.curSymbolTable(), this.adEnv.curFwdSymbolTable, null, false);
            }
            if (copyTree.getAnnotation("hasBeenSplit") == Boolean.TRUE) {
                copyTree.removeAnnotation("sourcetree");
            }
            this.addFuturePlainNodeFwd(copyTree, this.adEnv.curInstruction().whereMask(), false, (TapList)refsRW.first, (TapList)refsRW.second, null, null, false, false, "Copy of primal tree", false);
        }
    }

    protected Tree[] tangentDiffExpr(ToObject<Tree> toPrimalExpr, BoolVector beforeActiv, TapPair<TapList<Tree>, TapList<Tree>> primRW, TapPair<TapList<Tree>, TapList<Tree>> diffRW) {
        TapList<Object> toPrecomputes = new TapList<Object>(null, null);
        TapList<Object> toPrecomputesDiff = new TapList<Object>(null, null);
        Tree[] diffExpressionR = this.expressionDifferentiator().tangentDifferentiatePlainExpression(toPrimalExpr, toPrecomputes, toPrecomputesDiff, beforeActiv, primRW, diffRW, this.adEnv.curFwdSymbolTable);
        toPrecomputes = TapList.nreverse(toPrecomputes.tail);
        while (toPrecomputes != null) {
            NewBlockGraphNode futureNode = (NewBlockGraphNode)toPrecomputes.head;
            this.addFuturePlainNodeFwd(futureNode.tree, null, false, ILUtils.usedVarsInExp(futureNode.tree, null, true), new TapList<Tree>(futureNode.tree.down(1), null), null, null, false, false, "Assign split primal expression", false);
            toPrecomputes = toPrecomputes.tail;
        }
        toPrecomputesDiff = toPrecomputesDiff.tail;
        while (toPrecomputesDiff != null) {
            DiffAssignmentNode futureDiffNode = (DiffAssignmentNode)toPrecomputesDiff.head;
            Tree tree = futureDiffNode.diffAssign;
            InstructionMask instructionMask = futureDiffNode.type.isScalar() ? null : this.adEnv.curInstruction().whereMask();
            this.varRefDifferentiator();
            this.addFuturePlainNodeFwd(tree, instructionMask, VarRefDifferentiator.mustAddNbDirsDim(futureDiffNode.type), futureDiffNode.primR, futureDiffNode.primW, futureDiffNode.diffR, futureDiffNode.diffW, false, false, "Assign split diff expression", false);
            toPrecomputesDiff = toPrecomputesDiff.tail;
        }
        return diffExpressionR;
    }

    private boolean isAssignment(Tree srcAction) {
        int oper = srcAction.opCode();
        return oper == 14 || oper == 150 || oper == 125;
    }

    protected boolean pointerIsActiveHere(Tree varRef, BoolVector beforeActiv, BoolVector afterActiv, BoolVector beforeAvlX, BoolVector afterReqX) {
        TapList<?> accessibleZoneTree = this.adEnv.curSymbolTable().treeOfZonesOfValue(varRef, null, this.adEnv.curInstruction(), null);
        if (accessibleZoneTree != null && varRef.opCode() == 168) {
            accessibleZoneTree = TapList.copyTree(accessibleZoneTree);
            DataFlowAnalyzer.includePointedElementsInTree(accessibleZoneTree, null, null, true, this.adEnv.curSymbolTable(), this.adEnv.curInstruction(), null, false, false);
        }
        TapIntList accessibleZones = ZoneInfo.listAllZones(accessibleZoneTree, true);
        boolean accessibleTmp = TapIntList.intersects(accessibleZones, this.adEnv.toActiveTmpZones.tail);
        TapIntList accessibleVectorIndices = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(accessibleZones, 0, this.curVectorMap(), this.adEnv.curSymbolTable(), null);
        TapIntList accessibleDiffKindVectorIndices = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(accessibleZones, this.adEnv.diffKind, this.curDiffVectorMap(), this.adEnv.curSymbolTable(), null);
        TapList<ZoneInfo> zonesList = DataFlowAnalyzer.mapExtendedDeclaredToZoneInfo(accessibleZones, this.adEnv.curSymbolTable(), null);
        BoolVector contextDiffRequired = this.adEnv.curSymbolTable().getRequiredDiffVars(this.adEnv.curActivity());
        boolean isActivePointer = afterReqX != null && (accessibleTmp || afterReqX.intersects(accessibleVectorIndices)) || beforeAvlX != null && (accessibleTmp || beforeAvlX.intersects(accessibleVectorIndices)) || beforeActiv == null && afterActiv == null && contextDiffRequired != null && contextDiffRequired.intersects(accessibleDiffKindVectorIndices) || ADActivityAnalyzer.haveDifferentiatedVariable(zonesList);
        return isActivePointer;
    }

    private TapPair<Tree, TapList<Tree>[]> buildDiffOfControlAssignment(Tree tree, int differentiationMode, SymbolTable fwdSymbolTable, BoolVector beforeActiv, BoolVector afterActiv, BoolVector beforeAvlX, BoolVector afterReqX) {
        TapPair<Tree, TapList[]> fwdDiffControlTree = null;
        Tree assignedVar = tree.down(1);
        boolean removedDeclarator = true;
        block4: while (removedDeclarator) {
            switch (assignedVar.opCode()) {
                case 26: 
                case 90: 
                case 153: {
                    assignedVar = assignedVar.down(1);
                    removedDeclarator = true;
                    continue block4;
                }
                case 128: {
                    assignedVar = assignedVar.down(2);
                    removedDeclarator = true;
                    continue block4;
                }
            }
            removedDeclarator = false;
        }
        WrapperTypeSpec assignedType = this.adEnv.curSymbolTable().typeOf(assignedVar);
        boolean somePointerIsAssigned = assignedType != null && assignedType.containsAPointer();
        boolean mustDiffOperation = this.pointerIsActiveHere(assignedVar, beforeActiv, afterActiv, beforeAvlX, afterReqX);
        if ((TypeSpec.isA(assignedType, 21) || somePointerIsAssigned && mustDiffOperation) && (differentiationMode == 1 || this.adEnv.curUnitIsContext)) {
            Tree diffLHS = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), tree.down(1), fwdSymbolTable, false, tree.down(1), false, true, null);
            Tree diffRHS = ILUtils.isCallingString(tree.down(2), "null", false) ? ILUtils.copy(tree.down(2)) : this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), tree.down(2), fwdSymbolTable, false, tree.down(2), false, true, null);
            Tree diffControlAssign = ILUtils.build(tree.opCode(), diffLHS, diffRHS);
            if (differentiationMode == -2 && !this.curFwdDiffUnit().isFortran() && tree.getAnnotation("ComesFromAReturn") == Boolean.TRUE) {
                diffControlAssign.setChild(ILUtils.build(151, diffControlAssign.cutChild(1)), 1);
            }
            TapList[] rwrw = new TapList[]{ILUtils.usedVarsInExp(tree.down(1), null, false), null, new TapList<Tree>(tree.down(2), null), new TapList<Tree>(assignedVar, null)};
            fwdDiffControlTree = new TapPair<Tree, TapList[]>(diffControlAssign, rwrw);
        }
        return fwdDiffControlTree;
    }

    private Tree splitForADReverse(Tree tree, boolean resultIsExpected, boolean resultIsAssigned, boolean resultIsLive, TapList<Tree> toSplitTrees, boolean modeIsJoint) {
        boolean isRequiredInAdjoint = DiffLivenessAnalyzer.isTreeRequiredInDiff(this.adEnv.curActivity(), tree, modeIsJoint, false);
        boolean isDiffPtrRequiredInAdjoint = DiffLivenessAnalyzer.isTreeRequiredInDiff(this.adEnv.curActivity(), tree, modeIsJoint, true);
        boolean isAnnotatedActive = ADActivityAnalyzer.isAnnotatedActive(this.adEnv.curActivity(), tree, this.adEnv.curSymbolTable());
        switch (tree.opCode()) {
            case 14: {
                Tree lhs = this.splitForADReverse(tree.down(1), false, false, isRequiredInAdjoint, toSplitTrees, modeIsJoint);
                Tree rhs = this.splitForADReverse(tree.down(2), true, true, isRequiredInAdjoint, toSplitTrees, modeIsJoint);
                ReqExplicit.copyAnnotation(this.adEnv.curActivity(), tree.down(1), lhs);
                ADTBRAnalyzer.copyAnnotation(this.adEnv.curActivity(), tree.down(1), lhs);
                TapIntList lhsZones = ZoneInfo.listAllZones(this.adEnv.curSymbolTable().treeOfZonesOfValue(lhs, null, this.adEnv.curInstruction(), null), true);
                boolean splitHere = this.possibleAliasInAssign(lhs, lhsZones, this.adEnv.curInstruction().whereMask(), rhs, this.adEnv.curInstruction().whereMask(), false);
                if (splitHere) {
                    rhs = this.splitSubExpression(rhs, TapEnv.disambigNewName("tmp"), this.adEnv.curSymbolTable().typeOf(lhs), toSplitTrees, lhs, this.adEnv.curSymbolTable(), isRequiredInAdjoint, isDiffPtrRequiredInAdjoint, modeIsJoint);
                    this.registerTempVarForDebug(rhs);
                }
                Tree newAssign = ILUtils.build(14, lhs, rhs);
                TapPair completeCallTBRInfo = null;
                ActivityPattern curCalledActivity = null;
                if (splitHere && tree.down(2).opCode() == 31) {
                    completeCallTBRInfo = (TapPair)ActivityPattern.getAnnotationForActivityPattern(ILUtils.getArguments(tree.down(2)), this.adEnv.curActivity(), "TBR");
                    curCalledActivity = (ActivityPattern)ActivityPattern.getAnnotationForActivityPattern(ILUtils.getArguments(tree.down(2)), this.adEnv.curActivity(), "multiActivityCalleePatterns");
                }
                if (curCalledActivity != null) {
                    ActivityPattern.setAnnotationForActivityPattern(newAssign.down(1), this.adEnv.curActivity(), "multiActivityCalleePatterns", curCalledActivity);
                }
                if (completeCallTBRInfo != null) {
                    boolean resultIsSbkOnDiffPtr;
                    boolean resultIsSbk;
                    boolean resultIsSnpOnDiffPtr;
                    TapList[][] tbrOnArgs = (TapList[][])completeCallTBRInfo.first;
                    TapList[] snpArgs = tbrOnArgs[0];
                    TapList[] snpArgsOnDiffPtr = tbrOnArgs[1];
                    TapList[] sbkArgs = tbrOnArgs[2];
                    TapList[] sbkArgsOnDiffPtr = tbrOnArgs[3];
                    int resultIndex = snpArgs.length - 1;
                    boolean resultIsSnp = TapList.oneTrue(snpArgs[resultIndex]);
                    if (resultIsSnp) {
                        snpArgs[resultIndex] = new TapList<Boolean>(Boolean.FALSE, null);
                    }
                    boolean bl = resultIsSnpOnDiffPtr = snpArgsOnDiffPtr != null && TapList.oneTrue(snpArgsOnDiffPtr[resultIndex]);
                    if (resultIsSnpOnDiffPtr) {
                        snpArgsOnDiffPtr[resultIndex] = new TapList<Boolean>(Boolean.FALSE, null);
                    }
                    boolean bl2 = resultIsSbk = sbkArgs != null && TapList.oneTrue(sbkArgs[resultIndex]);
                    if (resultIsSbk) {
                        sbkArgs[resultIndex] = new TapList<Boolean>(Boolean.FALSE, null);
                    }
                    boolean bl3 = resultIsSbkOnDiffPtr = sbkArgsOnDiffPtr != null && TapList.oneTrue(sbkArgsOnDiffPtr[resultIndex]);
                    if (resultIsSbkOnDiffPtr) {
                        sbkArgsOnDiffPtr[resultIndex] = new TapList<Boolean>(Boolean.FALSE, null);
                    }
                    if (resultIsSnp || resultIsSnpOnDiffPtr || resultIsSbk || resultIsSbkOnDiffPtr) {
                        ActivityPattern.setAnnotationForActivityPattern(newAssign.down(1), this.adEnv.curActivity(), "TBR", new boolean[]{resultIsSnp || resultIsSbk, resultIsSnpOnDiffPtr || resultIsSbkOnDiffPtr});
                    }
                }
                if (isRequiredInAdjoint) {
                    DiffLivenessAnalyzer.setTreeRequiredInDiff(this.adEnv.curActivity(), newAssign, modeIsJoint, false);
                }
                if (isDiffPtrRequiredInAdjoint) {
                    DiffLivenessAnalyzer.setTreeRequiredInDiff(this.adEnv.curActivity(), newAssign, modeIsJoint, true);
                }
                if (isAnnotatedActive) {
                    ADActivityAnalyzer.setAnnotatedActive(this.adEnv.curActivity(), newAssign);
                }
                toSplitTrees.placdl(newAssign);
                return ILUtils.copy(lhs);
            }
            case 31: {
                int i;
                TapList[] paramsW;
                FunctionTypeSpec functionTypeSpec;
                int nDZ = this.adEnv.curSymbolTable().declaredZonesNb(0);
                Unit calledUnit = DataFlowAnalyzer.getCalledUnit(tree, this.adEnv.curSymbolTable());
                ActivityPattern curCalledActivity = (ActivityPattern)ActivityPattern.getAnnotationForActivityPattern(tree, this.adEnv.curActivity(), "multiActivityCalleePatterns");
                Tree[] args = ILUtils.getArguments(tree).children();
                int nbArgs = args.length;
                boolean functionIsIntrinsicWithSeparableDiff = calledUnit.isIntrinsic() && calledUnit.diffInfo != null;
                boolean[] formalArgsActivity = null;
                if (curCalledActivity != null && !functionIsIntrinsicWithSeparableDiff) {
                    formalArgsActivity = this.callGraphDifferentiator().getUnitFormalArgsActivityS(curCalledActivity);
                }
                if ((functionTypeSpec = (FunctionTypeSpec)tree.getAnnotation("functionTypeSpec")) == null) {
                    functionTypeSpec = calledUnit.functionTypeSpec();
                }
                TapList<Tree> newArgs = null;
                CallArrow callArrow = CallGraph.getCallArrow(this.adEnv.curUnit(), calledUnit);
                BoolVector callW = new BoolVector(nDZ);
                if (calledUnit.unitInOutW() != null) {
                    paramsW = DataFlowAnalyzer.propagateCalleeDataToCallSite(calledUnit.unitInOutPossiblyW(), callW, null, null, true, tree, this.adEnv.curInstruction(), callArrow, this.curVectorMap(), 0, null, null, false, false);
                } else {
                    paramsW = new TapList[nbArgs + 1];
                    for (i = nbArgs; i >= 0; --i) {
                        paramsW[i] = new TapList<Boolean>(Boolean.FALSE, null);
                    }
                }
                for (i = nbArgs - 1; i >= 0; --i) {
                    Tree argTree = this.splitForADReverse(args[i], true, false, isRequiredInAdjoint, toSplitTrees, modeIsJoint);
                    WrapperTypeSpec actualType = this.adEnv.curSymbolTable().typeOf(args[i]);
                    if (!functionIsIntrinsicWithSeparableDiff && argTree.opCode() != 138 && argTree.opCode() != 134 && formalArgsActivity != null && i < formalArgsActivity.length - 1 && formalArgsActivity[i] && (actualType == null || actualType.wrappedType == null || actualType.wrappedType.isDifferentiated(null)) && (!ILUtils.isAWritableVarRef(argTree, this.adEnv.curSymbolTable()) && !ILUtils.isExpressionNumConstant(argTree) && argTree.opCode() != 4 || ExpressionDifferentiator.getCost(argTree) > 30 && !TapList.oneTrue(paramsW[i + 1]))) {
                        argTree = this.splitSubExpression(argTree, TapEnv.disambigNewName("arg" + i), functionTypeSpec.argumentsTypes[i], toSplitTrees, argTree, this.adEnv.curSymbolTable(), DiffLivenessAnalyzer.isTreeRequiredInDiff(this.adEnv.curActivity(), argTree, modeIsJoint, false), DiffLivenessAnalyzer.isTreeRequiredInDiff(this.adEnv.curActivity(), argTree, modeIsJoint, true), modeIsJoint);
                        this.registerTempVarForDebug(argTree);
                    }
                    newArgs = new TapList<Tree>(argTree, newArgs);
                }
                Tree newCall = ILUtils.buildCall(ILUtils.copy(ILUtils.getCalledName(tree)), ILUtils.build(71, newArgs));
                if (isAnnotatedActive) {
                    ADActivityAnalyzer.setAnnotatedActive(this.adEnv.curActivity(), newCall);
                }
                ReqExplicit.copyAnnotation(this.adEnv.curActivity(), tree, newCall);
                ADTBRAnalyzer.copyAnnotation(this.adEnv.curActivity(), tree, newCall);
                Object annotation = ActivityPattern.getAnnotationForActivityPattern(tree, this.adEnv.curActivity(), "multiActivityCalleePatterns");
                if (annotation != null) {
                    ActivityPattern.setAnnotationForActivityPattern(newCall, this.adEnv.curActivity(), "multiActivityCalleePatterns", annotation);
                }
                if (isRequiredInAdjoint) {
                    DiffLivenessAnalyzer.setTreeRequiredInDiff(this.adEnv.curActivity(), newCall, modeIsJoint, false);
                }
                if (isDiffPtrRequiredInAdjoint) {
                    DiffLivenessAnalyzer.setTreeRequiredInDiff(this.adEnv.curActivity(), newCall, modeIsJoint, true);
                }
                if ((annotation = tree.getAnnotation("functionTypeSpec")) != null) {
                    newCall.setAnnotation("functionTypeSpec", annotation);
                }
                if ((annotation = tree.getAnnotation("arrayReturnTypeSpec")) != null) {
                    newCall.setAnnotation("arrayReturnTypeSpec", annotation);
                }
                if ((annotation = tree.getAnnotation("sourcetree")) != null) {
                    newCall.setAnnotation("sourcetree", annotation);
                }
                if ((annotation = tree.getAnnotation("callArrow")) != null) {
                    newCall.setAnnotation("callArrow", annotation);
                }
                if (this.curDiffUnit().isFortran() && calledUnit.isAFunction() && calledUnit.isFortran() || resultIsExpected) {
                    boolean isActiveCall;
                    boolean bl = isActiveCall = this.adEnv.curUnitIsActiveUnit && ADActivityAnalyzer.isAnnotatedActive(this.adEnv.curActivity(), tree, this.adEnv.curSymbolTable());
                    if (!(resultIsAssigned && resultIsLive || resultIsAssigned && !isRequiredInAdjoint || !isActiveCall || functionIsIntrinsicWithSeparableDiff)) {
                        WrapperTypeSpec localTypeSpec = (WrapperTypeSpec)tree.getAnnotation("arrayReturnTypeSpec");
                        if (localTypeSpec == null) {
                            localTypeSpec = functionTypeSpec.returnType;
                        }
                        if (formalArgsActivity != null && formalArgsActivity[formalArgsActivity.length - 1]) {
                            newCall = this.splitSubExpression(newCall, TapEnv.disambigNewName("res"), localTypeSpec, toSplitTrees, null, this.adEnv.curSymbolTable(), isRequiredInAdjoint, isDiffPtrRequiredInAdjoint, modeIsJoint);
                            this.registerTempVarForDebug(newCall);
                        } else {
                            this.adEnv.hideActiveTmpZones();
                            newCall = this.splitSubExpression(newCall, TapEnv.disambigNewName("res"), localTypeSpec, toSplitTrees, null, this.adEnv.curSymbolTable(), isRequiredInAdjoint, isDiffPtrRequiredInAdjoint, modeIsJoint);
                            this.adEnv.resetActiveTmpZones();
                        }
                        TapPair completeCallTBRInfo = (TapPair)ActivityPattern.getAnnotationForActivityPattern(tree, this.adEnv.curActivity(), "TBR");
                        if (completeCallTBRInfo != null) {
                            boolean resultIsSbkOnDiffPtr;
                            boolean resultIsSbk;
                            boolean resultIsSnpOnDiffPtr;
                            TapList[][] tbrOnArgs = (TapList[][])completeCallTBRInfo.first;
                            TapList[] snpArgs = tbrOnArgs[0];
                            TapList[] snpArgsOnDiffPtr = tbrOnArgs[1];
                            TapList[] sbkArgs = tbrOnArgs[2];
                            TapList[] sbkArgsOnDiffPtr = tbrOnArgs[3];
                            int resultIndex = snpArgs.length - 1;
                            boolean resultIsSnp = TapList.oneTrue(snpArgs[resultIndex]);
                            if (resultIsSnp) {
                                snpArgs[resultIndex] = new TapList<Boolean>(Boolean.FALSE, null);
                            }
                            boolean bl4 = resultIsSnpOnDiffPtr = snpArgsOnDiffPtr != null && TapList.oneTrue(snpArgsOnDiffPtr[resultIndex]);
                            if (resultIsSnpOnDiffPtr) {
                                snpArgsOnDiffPtr[resultIndex] = new TapList<Boolean>(Boolean.FALSE, null);
                            }
                            boolean bl5 = resultIsSbk = sbkArgs != null && TapList.oneTrue(sbkArgs[resultIndex]);
                            if (resultIsSbk) {
                                sbkArgs[resultIndex] = new TapList<Boolean>(Boolean.FALSE, null);
                            }
                            boolean bl6 = resultIsSbkOnDiffPtr = sbkArgsOnDiffPtr != null && TapList.oneTrue(sbkArgsOnDiffPtr[resultIndex]);
                            if (resultIsSbkOnDiffPtr) {
                                sbkArgsOnDiffPtr[resultIndex] = new TapList<Boolean>(Boolean.FALSE, null);
                            }
                        }
                    }
                    return newCall;
                }
                toSplitTrees.placdl(newCall);
                return ILUtils.build(138);
            }
            case 75: {
                Tree fieldTreeCopy = ILUtils.copy(tree.down(2));
                Tree newTree = ILUtils.build(75, this.splitForADReverse(tree.down(1), false, false, isRequiredInAdjoint, toSplitTrees, modeIsJoint), fieldTreeCopy);
                if (isAnnotatedActive) {
                    ADActivityAnalyzer.setAnnotatedActive(this.adEnv.curActivity(), newTree);
                }
                ReqExplicit.copyAnnotation(this.adEnv.curActivity(), tree, newTree);
                ADTBRAnalyzer.copyAnnotation(this.adEnv.curActivity(), tree, newTree);
                if (isRequiredInAdjoint) {
                    DiffLivenessAnalyzer.setTreeRequiredInDiff(this.adEnv.curActivity(), newTree, modeIsJoint, false);
                }
                if (isDiffPtrRequiredInAdjoint) {
                    DiffLivenessAnalyzer.setTreeRequiredInDiff(this.adEnv.curActivity(), newTree, modeIsJoint, true);
                }
                return newTree;
            }
            case 9: {
                Tree newTree = ILUtils.build(9, this.splitForADReverse(tree.down(1), false, false, isRequiredInAdjoint, toSplitTrees, modeIsJoint), this.splitForADReverse(tree.down(2), true, false, isRequiredInAdjoint, toSplitTrees, modeIsJoint));
                if (isAnnotatedActive) {
                    ADActivityAnalyzer.setAnnotatedActive(this.adEnv.curActivity(), newTree);
                }
                ReqExplicit.copyAnnotation(this.adEnv.curActivity(), tree, newTree);
                ADTBRAnalyzer.copyAnnotation(this.adEnv.curActivity(), tree, newTree);
                if (isRequiredInAdjoint) {
                    DiffLivenessAnalyzer.setTreeRequiredInDiff(this.adEnv.curActivity(), newTree, modeIsJoint, false);
                }
                if (isDiffPtrRequiredInAdjoint) {
                    DiffLivenessAnalyzer.setTreeRequiredInDiff(this.adEnv.curActivity(), newTree, modeIsJoint, true);
                }
                return newTree;
            }
            case 151: {
                Tree newTree = ILUtils.build(151, this.splitForADReverse(tree.down(1), false, false, isRequiredInAdjoint, toSplitTrees, modeIsJoint), this.splitForADReverse(tree.down(2), true, false, isRequiredInAdjoint, toSplitTrees, modeIsJoint));
                if (isAnnotatedActive) {
                    ADActivityAnalyzer.setAnnotatedActive(this.adEnv.curActivity(), newTree);
                }
                ReqExplicit.copyAnnotation(this.adEnv.curActivity(), tree, newTree);
                ADTBRAnalyzer.copyAnnotation(this.adEnv.curActivity(), tree, newTree);
                if (isRequiredInAdjoint) {
                    DiffLivenessAnalyzer.setTreeRequiredInDiff(this.adEnv.curActivity(), newTree, modeIsJoint, false);
                }
                if (isDiffPtrRequiredInAdjoint) {
                    DiffLivenessAnalyzer.setTreeRequiredInDiff(this.adEnv.curActivity(), newTree, modeIsJoint, true);
                }
                return newTree;
            }
            case 96: {
                Tree newTree = ILUtils.copy(tree);
                if (isAnnotatedActive) {
                    ADActivityAnalyzer.setAnnotatedActive(this.adEnv.curActivity(), newTree);
                }
                ReqExplicit.copyAnnotation(this.adEnv.curActivity(), tree, newTree);
                ADTBRAnalyzer.copyAnnotation(this.adEnv.curActivity(), tree, newTree);
                if (isRequiredInAdjoint) {
                    DiffLivenessAnalyzer.setTreeRequiredInDiff(this.adEnv.curActivity(), newTree, modeIsJoint, false);
                }
                if (isDiffPtrRequiredInAdjoint) {
                    DiffLivenessAnalyzer.setTreeRequiredInDiff(this.adEnv.curActivity(), newTree, modeIsJoint, true);
                }
                return newTree;
            }
            case 12: {
                return ILUtils.build(12, this.splitForADReverse(tree.down(1), true, false, isRequiredInAdjoint, toSplitTrees, modeIsJoint), this.splitForADReverse(tree.down(2), true, false, isRequiredInAdjoint, toSplitTrees, modeIsJoint), this.splitForADReverse(tree.down(3), true, false, isRequiredInAdjoint, toSplitTrees, modeIsJoint));
            }
            case 3: 
            case 6: 
            case 18: 
            case 22: 
            case 24: 
            case 42: 
            case 62: 
            case 68: 
            case 92: 
            case 95: 
            case 110: 
            case 115: 
            case 116: 
            case 122: 
            case 126: 
            case 133: 
            case 137: 
            case 143: 
            case 155: 
            case 169: 
            case 182: 
            case 207: {
                Tree newTree = ILUtils.build(tree.opCode(), this.splitForADReverse(tree.down(1), true, false, isRequiredInAdjoint, toSplitTrees, modeIsJoint), this.splitForADReverse(tree.down(2), true, false, isRequiredInAdjoint, toSplitTrees, modeIsJoint));
                if (isAnnotatedActive) {
                    ADActivityAnalyzer.setAnnotatedActive(this.adEnv.curActivity(), newTree);
                }
                if (tree.getAnnotation("boolean") != null) {
                    newTree.setAnnotation("boolean", "boolean");
                }
                ADTBRAnalyzer.copyAnnotation(this.adEnv.curActivity(), tree, newTree);
                ReqExplicit.copyAnnotation(this.adEnv.curActivity(), tree, newTree);
                return newTree;
            }
            case 124: 
            case 139: 
            case 176: {
                Tree newTree = ILUtils.build(tree.opCode(), this.splitForADReverse(tree.down(1), true, false, isRequiredInAdjoint, toSplitTrees, modeIsJoint));
                if (isAnnotatedActive) {
                    ADActivityAnalyzer.setAnnotatedActive(this.adEnv.curActivity(), newTree);
                }
                return newTree;
            }
            case 99: {
                Tree newTree = ILUtils.build(99, this.splitForADReverse(tree.down(1), true, false, isRequiredInAdjoint, toSplitTrees, modeIsJoint), this.splitForADReverse(tree.down(2), true, false, isRequiredInAdjoint, toSplitTrees, modeIsJoint), this.splitForADReverse(tree.down(3), true, false, isRequiredInAdjoint, toSplitTrees, modeIsJoint));
                if (isAnnotatedActive) {
                    ADActivityAnalyzer.setAnnotatedActive(this.adEnv.curActivity(), newTree);
                }
                return newTree;
            }
            case 194: {
                Tree newTree;
                String operName = ILUtils.getIdentString(tree.down(1));
                if (operName != null && (operName.equals("++prefix") || operName.equals("++postfix") || operName.equals("--prefix") || operName.equals("--postfix"))) {
                    Tree isolatedUnary = ILUtils.copy(tree);
                    if (isRequiredInAdjoint) {
                        DiffLivenessAnalyzer.setTreeRequiredInDiff(this.adEnv.curActivity(), isolatedUnary, modeIsJoint, false);
                    }
                    if (isDiffPtrRequiredInAdjoint) {
                        DiffLivenessAnalyzer.setTreeRequiredInDiff(this.adEnv.curActivity(), isolatedUnary, modeIsJoint, true);
                    }
                    if (isAnnotatedActive) {
                        ADActivityAnalyzer.setAnnotatedActive(this.adEnv.curActivity(), isolatedUnary);
                    }
                    toSplitTrees.placdl(isolatedUnary);
                    newTree = ILUtils.copy(tree.down(2));
                    if (isAnnotatedActive) {
                        ADActivityAnalyzer.setAnnotatedActive(this.adEnv.curActivity(), newTree);
                    }
                    if (operName.equals("++postfix")) {
                        newTree = ILUtils.build(3, newTree, ILUtils.build(103, 1));
                    } else if (operName.equals("--postfix")) {
                        newTree = ILUtils.build(182, newTree, ILUtils.build(103, 1));
                    }
                    if (isAnnotatedActive) {
                        ADActivityAnalyzer.setAnnotatedActive(this.adEnv.curActivity(), newTree);
                    }
                } else {
                    newTree = ILUtils.build(194, ILUtils.copy(tree.down(1)), this.splitForADReverse(tree.down(2), true, false, isRequiredInAdjoint, toSplitTrees, modeIsJoint));
                    if (isAnnotatedActive) {
                        ADActivityAnalyzer.setAnnotatedActive(this.adEnv.curActivity(), newTree);
                    }
                }
                return newTree;
            }
            case 32: {
                Tree newTree = ILUtils.build(32, ILUtils.copy(tree.down(1)), this.splitForADReverse(tree.down(2), true, false, isRequiredInAdjoint, toSplitTrees, modeIsJoint));
                if (isAnnotatedActive) {
                    ADActivityAnalyzer.setAnnotatedActive(this.adEnv.curActivity(), newTree);
                }
                return newTree;
            }
            case 109: {
                Tree newTree = ILUtils.build(109, ILUtils.copy(tree.down(1)), ILUtils.copy(tree.down(2)), this.splitForADReverse(tree.down(3), true, false, isRequiredInAdjoint, toSplitTrees, modeIsJoint));
                DiffLivenessAnalyzer.copyTreeRequiredInDiff(this.adEnv.curActivity(), tree, newTree);
                toSplitTrees.placdl(newTree);
                return newTree;
            }
            case 168: {
                if (this.adEnv.curUnit().isC() && !ILUtils.isNullOrNone(tree.down(1)) && tree.down(1).opCode() != 103) {
                    String returnVarName;
                    Tree splitReturnedExpr = this.splitForADReverse(tree.down(1), true, true, isRequiredInAdjoint, toSplitTrees, modeIsJoint);
                    String string = returnVarName = this.adEnv.curUnit().otherReturnVar() == null ? this.adEnv.curUnit().name() : this.adEnv.curUnit().otherReturnVar().symbol;
                    if ("main".equals(returnVarName)) {
                        returnVarName = "mainResult";
                    }
                    Tree returnVar = ILUtils.build(96, returnVarName);
                    if (isAnnotatedActive) {
                        ADActivityAnalyzer.setAnnotatedActive(this.adEnv.curActivity(), returnVar);
                    }
                    this.flowGraphDifferentiator().returnedVariable = returnVar;
                    Tree returnAssign = ILUtils.build(14, returnVar, ILUtils.copy(splitReturnedExpr));
                    if (!this.curFwdDiffUnit().isFortran()) {
                        returnAssign.setAnnotation("ComesFromAReturn", Boolean.TRUE);
                    }
                    if (isRequiredInAdjoint || !modeIsJoint) {
                        DiffLivenessAnalyzer.setTreeRequiredInDiff(this.adEnv.curActivity(), returnAssign, modeIsJoint, false);
                    }
                    if (isDiffPtrRequiredInAdjoint || !modeIsJoint) {
                        DiffLivenessAnalyzer.setTreeRequiredInDiff(this.adEnv.curActivity(), returnAssign, modeIsJoint, true);
                    }
                    toSplitTrees.placdl(returnAssign);
                } else {
                    toSplitTrees.placdl(ILUtils.copy(tree));
                }
                return null;
            }
            case 184: {
                Tree newTree = ILUtils.build(184, this.splitForADReverse(tree.down(1), true, false, isRequiredInAdjoint, toSplitTrees, modeIsJoint), ILUtils.copy(tree.down(2)));
                DiffLivenessAnalyzer.copyTreeRequiredInDiff(this.adEnv.curActivity(), tree, newTree);
                toSplitTrees.placdl(newTree);
                return null;
            }
            case 98: {
                Tree newTree = ILUtils.build(98, this.splitForADReverse(tree.down(1), true, false, isRequiredInAdjoint, toSplitTrees, modeIsJoint), ILUtils.copy(tree.down(2)), ILUtils.copy(tree.down(3)));
                DiffLivenessAnalyzer.copyTreeRequiredInDiff(this.adEnv.curActivity(), tree, newTree);
                toSplitTrees.placdl(newTree);
                return null;
            }
            case 205: {
                Tree newTree = ILUtils.build(205, this.splitForADReverse(tree.down(1), true, false, isRequiredInAdjoint, toSplitTrees, modeIsJoint), ILUtils.copy(tree.down(2)), ILUtils.copy(tree.down(3)));
                DiffLivenessAnalyzer.copyTreeRequiredInDiff(this.adEnv.curActivity(), tree, newTree);
                toSplitTrees.placdl(newTree);
                return null;
            }
            case 121: {
                Tree newTree = ILUtils.build(121, ILUtils.copy(tree.down(1)), ILUtils.copy(tree.down(2)), this.splitForADReverse(tree.down(3), true, false, isRequiredInAdjoint, toSplitTrees, modeIsJoint), ILUtils.copy(tree.down(4)));
                DiffLivenessAnalyzer.copyTreeRequiredInDiff(this.adEnv.curActivity(), tree, newTree);
                toSplitTrees.placdl(newTree);
                return null;
            }
            case 64: {
                Tree result = ILUtils.copy(tree);
                ADTBRAnalyzer.copyAnnotation(this.adEnv.curActivity(), tree.down(1), result.down(1));
                DiffLivenessAnalyzer.copyTreeRequiredInDiff(this.adEnv.curActivity(), tree, result);
                return result;
            }
            case 15: 
            case 30: 
            case 40: 
            case 94: 
            case 144: 
            case 145: 
            case 179: {
                toSplitTrees.placdl(ILUtils.copy(tree));
                return null;
            }
            case 5: 
            case 20: 
            case 28: 
            case 43: 
            case 79: 
            case 80: 
            case 103: 
            case 111: 
            case 118: 
            case 134: 
            case 138: 
            case 160: 
            case 180: 
            case 181: 
            case 189: 
            case 196: 
            case 206: {
                return ILUtils.copy(tree);
            }
            case 10: 
            case 71: {
                Tree[] expressions = tree.children();
                TapList<Tree> newExpressions = null;
                for (int i = expressions.length - 1; i >= 0; --i) {
                    Tree newExpression = this.splitForADReverse(expressions[i], true, false, isRequiredInAdjoint, toSplitTrees, modeIsJoint);
                    newExpressions = new TapList<Tree>(newExpression, newExpressions);
                }
                return ILUtils.build(tree.opCode(), newExpressions);
            }
            case 2: 
            case 39: 
            case 45: 
            case 49: 
            case 51: 
            case 52: 
            case 69: 
            case 74: 
            case 90: 
            case 101: 
            case 106: 
            case 108: 
            case 135: 
            case 140: 
            case 171: 
            case 192: 
            case 197: 
            case 199: 
            case 202: {
                toSplitTrees.placdl(ILUtils.copy(tree));
                return ILUtils.copy(tree);
            }
            case 4: 
            case 29: 
            case 35: 
            case 41: 
            case 78: 
            case 104: 
            case 129: {
                return ILUtils.copy(tree);
            }
        }
        TapEnv.toolWarning(-1, "(Split expression for reverse AD) Unexpected operator: " + tree.opName());
        return ILUtils.copy(tree);
    }

    private void registerTempVarForDebug(Tree tempVar) {
        if (TapEnv.debugAdMode() == -1) {
            this.tempVarsForDebug = new TapList<Tree>(tempVar, this.tempVarsForDebug);
        }
    }

    private boolean possibleAliasInAssign(Tree lhs, TapIntList lhsZones, InstructionMask lhsMask, Tree tree, InstructionMask treeMask, boolean acrossCall) {
        switch (tree.opCode()) {
            case 9: 
            case 75: 
            case 96: 
            case 151: {
                TapIntList treeZones = ZoneInfo.listAllZones(this.adEnv.curSymbolTable().treeOfZonesOfValue(tree, null, this.adEnv.curInstruction(), null), true);
                TapIntList treeDiffKindVectorIndices = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(treeZones, this.adEnv.diffKind, this.curDiffVectorMap(), this.adEnv.curSymbolTable(), null);
                TapIntList lhsDiffKindVectorIndices = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(lhsZones, this.adEnv.diffKind, this.curDiffVectorMap(), this.adEnv.curSymbolTable(), null);
                boolean commonMemory = TapIntList.intersects(lhsDiffKindVectorIndices, treeDiffKindVectorIndices);
                WrapperTypeSpec exprTypeSpec = this.adEnv.curSymbolTable().typeOf(lhs);
                boolean differentMasks = !exprTypeSpec.isScalar() && !InstructionMask.equalMasks(lhsMask, treeMask);
                int intersectionStatus = ILUtils.eqOrDisjointRef(lhs, tree, this.adEnv.curInstruction(), this.adEnv.curInstruction());
                boolean imperfectIdentity = acrossCall ? intersectionStatus != -1 : intersectionStatus == 0;
                return commonMemory && (imperfectIdentity || differentMasks);
            }
            case 3: 
            case 42: 
            case 62: 
            case 126: 
            case 133: 
            case 155: 
            case 182: {
                return this.possibleAliasInAssign(lhs, lhsZones, lhsMask, tree.down(1), treeMask, acrossCall) || this.possibleAliasInAssign(lhs, lhsZones, lhsMask, tree.down(2), treeMask, acrossCall);
            }
            case 99: {
                return this.possibleAliasInAssign(lhs, lhsZones, lhsMask, tree.down(2), treeMask, acrossCall) || this.possibleAliasInAssign(lhs, lhsZones, lhsMask, tree.down(3), treeMask, acrossCall);
            }
            case 124: 
            case 176: {
                return this.possibleAliasInAssign(lhs, lhsZones, lhsMask, tree.down(1), treeMask, acrossCall);
            }
            case 32: 
            case 194: {
                return this.possibleAliasInAssign(lhs, lhsZones, lhsMask, tree.down(2), treeMask, acrossCall);
            }
            case 31: {
                Unit calledUnit = DataFlowAnalyzer.getCalledUnit(tree, this.adEnv.curSymbolTable());
                Tree[] actualArgs = ILUtils.getArguments(tree).children();
                int nbArgs = actualArgs.length;
                if (calledUnit.unitInOutR() != null && !calledUnit.hasPredefinedDerivatives()) {
                    if (TapIntList.intersects(lhsZones, this.adEnv.toActiveTmpZones.tail)) {
                        return true;
                    }
                    CallArrow callArrow = CallGraph.getCallArrow(this.adEnv.curUnit(), calledUnit);
                    int nDZ = this.adEnv.curSymbolTable().declaredZonesNb(0);
                    BoolVector callAccess = new BoolVector(nDZ);
                    DataFlowAnalyzer.propagateCalleeDataToCallSite(calledUnit.unitInOutPossiblyRorW(), callAccess, null, actualArgs, true, tree, this.adEnv.curInstruction(), callArrow, this.curDiffVectorMap(), 0, null, null, true, false);
                    TapIntList lhsVectorIndices = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(lhsZones, 0, this.curVectorMap(), this.adEnv.curSymbolTable(), null);
                    if (callAccess.intersects(lhsVectorIndices)) {
                        return true;
                    }
                }
                if (calledUnit.isStandard() || calledUnit.isExternal() || calledUnit.isVarFunction() || calledUnit.isInterface()) {
                    acrossCall = true;
                }
                if ("sum".equals(calledUnit.name().toLowerCase())) {
                    Tree maskArg = ILUtils.getOptionalMask(actualArgs, this.adEnv.curSymbolTable());
                    treeMask = maskArg == null ? null : new InstructionMask(maskArg, null);
                } else if ("spread".equals(calledUnit.name().toLowerCase())) {
                    treeMask = null;
                }
                boolean possibleAlias = false;
                while (!possibleAlias && nbArgs > 0) {
                    possibleAlias = this.possibleAliasInAssign(lhs, lhsZones, lhsMask, actualArgs[--nbArgs], treeMask, acrossCall);
                }
                return possibleAlias;
            }
            case 10: {
                boolean possibleAlias = false;
                Tree[] expressions = tree.children();
                for (int i = expressions.length - 1; i >= 0; --i) {
                    boolean sonAlias = this.possibleAliasInAssign(lhs, lhsZones, lhsMask, expressions[i], null, acrossCall);
                    if (!sonAlias) continue;
                    possibleAlias = true;
                }
                return possibleAlias;
            }
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 28: 
            case 29: 
            case 35: 
            case 40: 
            case 41: 
            case 43: 
            case 64: 
            case 68: 
            case 71: 
            case 78: 
            case 79: 
            case 80: 
            case 92: 
            case 94: 
            case 95: 
            case 98: 
            case 101: 
            case 103: 
            case 104: 
            case 109: 
            case 110: 
            case 111: 
            case 115: 
            case 116: 
            case 121: 
            case 122: 
            case 129: 
            case 134: 
            case 137: 
            case 138: 
            case 139: 
            case 143: 
            case 160: 
            case 168: 
            case 169: 
            case 179: 
            case 180: 
            case 181: 
            case 184: 
            case 189: 
            case 196: 
            case 206: 
            case 207: {
                return false;
            }
        }
        TapEnv.toolWarning(-1, "(Split aliases for reverse AD) Unexpected operator: " + tree.opName());
        return false;
    }

    private Tree splitSubExpression(Tree expression, String name, WrapperTypeSpec type, TapList<Tree> toSplitTrees, Tree oldLhs, SymbolTable symbolTable, boolean requiredInAdjoint, boolean diffPtrRequiredInAdjoint, boolean modeIsJoint) {
        boolean expressionIsActive = ADActivityAnalyzer.isAnnotatedActive(this.adEnv.curActivity(), expression, this.adEnv.curSymbolTable());
        Tree arrayAccessTree = null;
        if (type == null || type.wrappedType == null || type.wrappedType.containsUndefinedType()) {
            TapEnv.fileWarning(15, expression, "(AD16) Could not find type for temporary variable " + name + " to hold " + ILUtils.toString(expression, this.adEnv.curActivity()) + ", please check");
        }
        if (WrapperTypeSpec.isFree(type) || TypeSpec.isA(type, 9)) {
            type = this.adEnv.realTypeSpec;
        }
        boolean arrayTriplet = false;
        if (TypeSpec.isA(type, 2) && oldLhs != null && ILUtils.containsArrayTriplet(oldLhs)) {
            arrayTriplet = true;
            arrayAccessTree = ILUtils.findArrayTriplet(oldLhs);
            if (oldLhs.opCode() == 9) {
                type = symbolTable.typeOf(oldLhs);
                ((ArrayTypeSpec)type.wrappedType).checkDimensions(arrayAccessTree, symbolTable);
            }
        }
        NewSymbolHolder newSymbolHolder = new NewSymbolHolder(name);
        newSymbolHolder.setHintRootTree(oldLhs);
        newSymbolHolder.setHintArrayTreeForCallSize(oldLhs);
        String hintNameInIdent = name;
        String hintNameInText = name;
        Tree hintTreeInSize = null;
        if (newSymbolHolder.hintRootTree != null) {
            hintNameInIdent = ILUtils.buildNameInIdent(newSymbolHolder.hintRootTree);
            hintNameInText = ILUtils.buildNameInText(newSymbolHolder.hintRootTree);
        }
        if (newSymbolHolder.hintArrayTreeForCallSize != null) {
            hintTreeInSize = ILUtils.buildSizeArgument1(newSymbolHolder.hintArrayTreeForCallSize, symbolTable);
        }
        type = type.checkNoneDimensionsOfNewSH(hintNameInText, hintNameInIdent, hintTreeInSize, this.adEnv.curFwdSymbolTable, newSymbolHolder);
        newSymbolHolder.setAsVariable(type, null);
        newSymbolHolder.declarationLevelMustInclude(this.adEnv.curFwdSymbolTable);
        Tree newDecl = ILUtils.build(199, ILUtils.build(130), type.wrappedType.generateTree(null, null, null, true, null), ILUtils.build(54, newSymbolHolder.makeNewRef(this.adEnv.curFwdSymbolTable)));
        if (modeIsJoint) {
            Instruction newInstr = new Instruction(newDecl);
            newInstr.setPosition(this.adEnv.curInstruction());
            newSymbolHolder.setInstruction(newInstr);
            newSymbolHolder.newVariableDecl().setInstruction(newInstr);
        } else {
            Instruction newInstr = new Instruction(newDecl);
            newInstr.setPosition(this.adEnv.curInstruction());
            newSymbolHolder.setInstruction(newInstr);
            newInstr = new Instruction(newDecl);
            newInstr.setPosition(this.adEnv.curInstruction());
            newSymbolHolder.setInstruction(newInstr);
            newSymbolHolder.newVariableDecl().setInstruction(newInstr);
        }
        newSymbolHolder.zone = this.adEnv.allocateTmpZone();
        this.adEnv.toActiveTmpZones.tail = new TapIntList(newSymbolHolder.zone, this.adEnv.toActiveTmpZones.tail);
        Tree newRef = newSymbolHolder.makeNewRef(this.adEnv.curFwdSymbolTable);
        if (arrayTriplet) {
            newRef = ILUtils.build(9, newRef, ILUtils.keepArrayTriplet(arrayAccessTree.down(2)));
        }
        if (expressionIsActive) {
            ADActivityAnalyzer.setAnnotatedActive(this.adEnv.curActivity(), newRef);
        }
        if (expressionIsActive || requiredInAdjoint) {
            newSymbolHolder.newVariableDecl().setActive();
        }
        Tree newAssign = ILUtils.build(14, newRef, expression);
        if (requiredInAdjoint) {
            DiffLivenessAnalyzer.setTreeRequiredInDiff(this.adEnv.curActivity(), newAssign, modeIsJoint, false);
        }
        if (diffPtrRequiredInAdjoint) {
            DiffLivenessAnalyzer.setTreeRequiredInDiff(this.adEnv.curActivity(), newAssign, modeIsJoint, true);
        }
        toSplitTrees.placdl(newAssign);
        newRef = newSymbolHolder.makeNewRef(this.adEnv.curFwdSymbolTable);
        if (arrayTriplet) {
            newRef = ILUtils.build(9, newRef, ILUtils.keepArrayTriplet(arrayAccessTree.down(2)));
        }
        if (expressionIsActive) {
            ADActivityAnalyzer.setAnnotatedActive(this.adEnv.curActivity(), newRef);
        }
        return newRef;
    }

    private Tree differentiateInitDeclarator(WrapperTypeSpec diffTypeSpec, int differentiationMode, Tree diffDecl, SymbolTable diffSymbolTable, BoolVector beforeActiv, BoolVector afterActiv, BoolVector afterReqX, BoolVector beforeAvlX, Tree declarator, boolean declarationOnly) {
        Tree rhsDiff;
        if (this.adEnv.curUnit() == null || this.adEnv.curUnit().isPackage() || differentiationMode != 1 && !this.adEnv.curUnitIsContext) {
            rhsDiff = diffTypeSpec.wrappedType.buildConstantZero();
        } else {
            WrapperTypeSpec lhsTypeSpec = this.adEnv.curSymbolTable().typeOf(declarator.down(1));
            if (this.adEnv.traceCurBlock != 0) {
                TapEnv.printlnOnTrace("   (sublevel)-- differentiating initialization instruction: " + ILUtils.toString(declarator, this.adEnv.curUnit().language(), this.adEnv.curActivity()) + " lhsTypeSpec:" + lhsTypeSpec + " " + beforeActiv + "=>" + afterActiv);
            }
            if (TypeSpec.isA(lhsTypeSpec, 6)) {
                TapPair<Tree, TapList<Tree>[]> diffTreePlus = this.buildDiffOfControlAssignment(declarator, differentiationMode, diffSymbolTable, beforeActiv, afterActiv, beforeAvlX, afterReqX);
                Tree diffDeclTree = diffTreePlus == null ? null : (Tree)diffTreePlus.first;
                rhsDiff = diffDeclTree == null ? null : ILUtils.copy(diffDeclTree.down(2));
            } else {
                boolean passiveDeclarationInitialization = false;
                int iReplicSave = this.adEnv.iReplic;
                if (declarator.opCode() == 14) {
                    Tree declaratorLhs = declarator.down(1);
                    int arrayCount = 0;
                    while (declaratorLhs.opCode() == 11) {
                        declaratorLhs = declaratorLhs.down(1);
                        ++arrayCount;
                    }
                    declaratorLhs = ILUtils.copy(declaratorLhs);
                    while (arrayCount != 0) {
                        declaratorLhs = ILUtils.build(151, declaratorLhs, ILUtils.build(103, 0));
                        --arrayCount;
                    }
                    Tree[] diffLhsTreeR = this.tangentDiffExpr(new ToObject<Tree>(declaratorLhs), beforeActiv, new TapPair<Object, Object>(null, null), new TapPair<Object, Object>(null, null));
                    boolean bl = passiveDeclarationInitialization = diffLhsTreeR == null || diffLhsTreeR.length == 0 || diffLhsTreeR[0] == null;
                }
                if (passiveDeclarationInitialization || declarationOnly) {
                    rhsDiff = null;
                } else {
                    Tree[] rhsDiffR;
                    Tree declaratorExp = declarator;
                    if (declaratorExp.opCode() == 14) {
                        declaratorExp = declaratorExp.down(2);
                    }
                    if ((rhsDiff = (rhsDiffR = this.tangentDiffExpr(new ToObject<Tree>(declaratorExp), beforeActiv, new TapPair<Object, Object>(null, null), new TapPair<Object, Object>(null, null)))[0]) == null) {
                        rhsDiff = lhsTypeSpec.buildConstantZero();
                    }
                }
                this.adEnv.iReplic = iReplicSave;
            }
            if (this.adEnv.traceCurBlock != 0) {
                TapEnv.printlnOnTrace("   (sublevel)-- returns assignment to " + diffDecl + " := " + rhsDiff);
            }
        }
        return ILUtils.isNullOrNone(rhsDiff) ? null : ILUtils.build(14, diffDecl, rhsDiff);
    }

    protected void updateAACopiedInstruction(Instruction instruction, Block srcBlock, Block copyBlock, int rank) {
        if (!instruction.isDifferentiated) {
            Tree tree = instruction.tree;
            if (tree != null && (ILUtils.isADeclaration(tree) || tree.opCode() == 51)) {
                if (tree.opCode() != 39 && tree.opCode() != 197 && tree.opCode() != 101 && tree.opCode() != 89) {
                    Instruction copyInstrInDiff = new Instruction(tree, null);
                    TapList<Instruction>[] diffDeclarationsR = this.differentiateInstructionDeclaration(instruction, 1, copyInstrInDiff, tree, false, copyBlock.symbolTable, srcBlock, null, null, null, null, null, null, null, null, copyBlock.symbolTable.unit.language(), !this.adEnv.curUnit().isFortran9x(), false);
                    TapList<Instruction> diffDeclarations = diffDeclarationsR[0];
                    Tree diffDecl = null;
                    if (diffDeclarations != null) {
                        diffDecl = ((Instruction)diffDeclarations.head).tree;
                        diffDeclarations = diffDeclarations.tail;
                        if (diffDeclarations != null) {
                            TapEnv.toolError("  Problem for updateAACopiedInstruction: remaining pieces of diff declaration are lost: " + diffDeclarations);
                        }
                    }
                    if (diffDecl != null) {
                        copyBlock.addInstructionAt(diffDecl, rank);
                    }
                }
            } else {
                instruction.tree = this.turnAssociationByAddressPrimal(tree, srcBlock.symbolTable, copyBlock.symbolTable, null, true);
            }
            instruction.isDifferentiated = true;
        }
    }

    protected void updateAAInstructionMask(Instruction instruction, SymbolTable srcSymbolTable, SymbolTable destSymbolTable) {
        InstructionMask srcMask = instruction.whereMask();
        if (srcMask != null && !srcMask.controlInstruction.isDifferentiated) {
            srcMask.setControlTree(this.turnAssociationByAddressPrimal(srcMask.getControlTree(), srcSymbolTable, destSymbolTable, null, true));
            srcMask.controlInstruction.isDifferentiated = true;
        }
    }

    private void fillRefsRW(Tree srcTree, TapPair<TapList<Tree>, TapList<Tree>> srcRefsRW) {
        srcRefsRW.first = null;
        srcRefsRW.second = null;
        int opCode = srcTree.opCode();
        String unaryOper = null;
        if (opCode == 194) {
            unaryOper = ILUtils.getIdentString(srcTree.down(1));
        }
        if (opCode == 14) {
            srcRefsRW.first = ILUtils.usedVarsInExp(srcTree.down(1), (TapList)srcRefsRW.first, false);
            srcRefsRW.first = ILUtils.usedVarsInExp(srcTree.down(2), (TapList)srcRefsRW.first, true);
            srcRefsRW.second = new TapList<Tree>(srcTree.down(1), null);
        } else if (ILUtils.isIORead(srcTree)) {
            srcRefsRW.first = ILUtils.usedVarsInExp(srcTree.down(2), (TapList)srcRefsRW.first, true);
            srcRefsRW.first = ILUtils.usedVarsInExp(srcTree.down(3), (TapList)srcRefsRW.first, false);
            srcRefsRW.second = ILUtils.addTreeInList(srcTree.down(3), (TapList)srcRefsRW.second);
        } else if (opCode == 194 && unaryOper != null && (unaryOper.equals("++prefix") || unaryOper.equals("++postfix") || unaryOper.equals("--prefix") || unaryOper.equals("--postfix"))) {
            srcRefsRW.first = ILUtils.usedVarsInExp(srcTree.down(2), (TapList)srcRefsRW.first, false);
            srcRefsRW.second = new TapList<Tree>(srcTree.down(2), null);
        } else {
            srcRefsRW.first = ILUtils.usedVarsInExp(srcTree, (TapList)srcRefsRW.first, true);
        }
    }

    private TapList<Tree> hasTBRexps(Tree expression, TapList<Tree> listTrees) {
        if (ADTBRAnalyzer.isTBR(this.adEnv.curActivity(), expression)) {
            listTrees = new TapList<Tree>(expression, listTrees);
        } else if (!expression.isAtom()) {
            Tree[] subTrees = expression.children();
            for (int i = subTrees.length - 1; i >= 0; --i) {
                listTrees = this.hasTBRexps(subTrees[i], listTrees);
            }
        }
        return listTrees;
    }

    private boolean isAConstantDeclInit(Tree action) {
        Tree[] assignments = action.opCode() == 27 ? action.children() : new Tree[]{action};
        boolean constantFound = false;
        for (int i = assignments.length - 1; !constantFound && i >= 0; --i) {
            if (assignments[i].opCode() != 14) continue;
            String varName = ILUtils.baseName(assignments[i].down(1));
            if (this.adEnv.curSymbolTable().getConstantDecl(varName) == null) continue;
            constantFound = true;
        }
        return constantFound;
    }

    private TapList<Instruction>[] differentiateInstructionDeclaration(Instruction instruction, int differentiationMode, Instruction copyInstrInDiff, Tree tree, boolean allDiffModesInside, SymbolTable diffSymbolTable, Block block, BoolVector beforeActiv, BoolVector afterActiv, BoolVector beforeUseful, BoolVector afterUseful, BoolVector beforeReqX, BoolVector afterReqX, BoolVector beforeAvlX, BoolVector afterAvlX, int origLanguage, boolean declarationOnly, boolean forInterface) {
        if (this.adEnv.traceCurDifferentiation && this.adEnv.traceCurBlock != 0) {
            TapEnv.printlnOnTrace("          Differentiate declaration instruction " + tree);
        }
        TapList[] diffDeclarationsR = null;
        if (!instruction.isDifferentiated) {
            boolean copyInstrIsDiffSpecific = false;
            switch (tree.opCode()) {
                case 199: {
                    diffDeclarationsR = new TapList[TapEnv.diffReplica()];
                    this.adEnv.iReplic = 0;
                    while (this.adEnv.iReplic < diffDeclarationsR.length) {
                        int adjointModeSplit;
                        TapList<Object> hdDiffDeclarations;
                        TapList<Object> tlDiffDeclarations = hdDiffDeclarations = new TapList<Object>(null, null);
                        if (allDiffModesInside) {
                            if (TapEnv.mustTangent()) {
                                this.adEnv.pushCurDiffSorts(1, 1);
                                tlDiffDeclarations = this.differentiateVarDeclaration(tree, tlDiffDeclarations, differentiationMode, block, diffSymbolTable, instruction, copyInstrInDiff, beforeActiv, afterActiv, beforeUseful, afterUseful, beforeReqX, afterReqX, beforeAvlX, afterAvlX, 1, origLanguage, declarationOnly, forInterface);
                                this.adEnv.popCurDiffSorts();
                            }
                            if (TapEnv.mustAdjoint()) {
                                this.adEnv.pushCurDiffSorts(2, 2);
                                adjointModeSplit = this.getAdjointModeSplit(tree, diffSymbolTable);
                                tlDiffDeclarations = this.differentiateVarDeclaration(tree, tlDiffDeclarations, differentiationMode, block, diffSymbolTable, instruction, copyInstrInDiff, beforeActiv, afterActiv, beforeUseful, afterUseful, beforeReqX, afterReqX, beforeAvlX, afterAvlX, adjointModeSplit, origLanguage, declarationOnly, forInterface);
                                if (adjointModeSplit == 3) {
                                    tlDiffDeclarations = this.differentiateVarDeclaration(tree, tlDiffDeclarations, differentiationMode, block, diffSymbolTable, instruction, copyInstrInDiff, beforeActiv, afterActiv, beforeUseful, afterUseful, beforeReqX, afterReqX, beforeAvlX, afterAvlX, 4, origLanguage, declarationOnly, forInterface);
                                }
                                this.adEnv.popCurDiffSorts();
                            }
                        } else {
                            adjointModeSplit = this.getAdjointModeSplit(tree, diffSymbolTable);
                            tlDiffDeclarations = this.differentiateVarDeclaration(tree, tlDiffDeclarations, differentiationMode, block, diffSymbolTable, instruction, copyInstrInDiff, beforeActiv, afterActiv, beforeUseful, afterUseful, beforeReqX, afterReqX, beforeAvlX, afterAvlX, adjointModeSplit, origLanguage, declarationOnly, forInterface);
                            if (adjointModeSplit == 3) {
                                tlDiffDeclarations = this.differentiateVarDeclaration(tree, tlDiffDeclarations, differentiationMode, block, diffSymbolTable, instruction, copyInstrInDiff, beforeActiv, afterActiv, beforeUseful, afterUseful, beforeReqX, afterReqX, beforeAvlX, afterAvlX, 4, origLanguage, declarationOnly, forInterface);
                            }
                        }
                        if ((hdDiffDeclarations = hdDiffDeclarations.tail) != null) {
                            instruction.isDifferentiated = true;
                        }
                        copyInstrIsDiffSpecific = this.willBeNodiff(tree, this.adEnv.curSymbolTable());
                        diffDeclarationsR[this.adEnv.iReplic] = hdDiffDeclarations;
                        ++this.adEnv.iReplic;
                    }
                    this.adEnv.iReplic = 0;
                    break;
                }
                case 2: {
                    Instruction instructionResult;
                    TapList<Instruction> diffDeclarations;
                    Tree result;
                    if (this.adEnv.traceCurBlock != 0) {
                        TapEnv.printlnOnTrace(" Differentiating accessDecl declaration");
                        TapEnv.printlnOnTrace("      " + ILUtils.toString(tree, this.adEnv.curActivity()));
                    }
                    if (tree.down(2).opCode() == 192) {
                        result = this.differentiateTypeDeclaration(diffSymbolTable, tree.down(2));
                        if (result != null) {
                            result = ILUtils.build(2, ILUtils.copy(tree.down(1)), result);
                        }
                    } else if (ILUtils.isIdentOf(tree.down(1), new String[]{"in", "out", "inout", "const", "constant", "optional", "allocatable"}, false)) {
                        result = null;
                        if (TapEnv.associationByAddress()) {
                            copyInstrInDiff.tree = ILUtils.build(138);
                        }
                    } else {
                        TapList<Tree> diffDecls = this.diffDeclNames(tree, allDiffModesInside, diffSymbolTable);
                        Tree diffBind = tree.down(1);
                        diffBind = diffBind.opCode() == 2 && diffBind.down(1).opCode() == 96 && diffBind.down(1).stringValue().equals("bind") ? this.diffBindCVarName(diffBind) : ILUtils.copy(diffBind);
                        Tree tree2 = result = diffDecls == null ? null : ILUtils.build(2, diffBind, ILUtils.build(tree.down(2).opCode(), diffDecls));
                    }
                    if (result == null) {
                        diffDeclarations = null;
                    } else {
                        instructionResult = new Instruction();
                        instructionResult.tree = result;
                        instructionResult.isDifferentiated = true;
                        diffDeclarations = new TapList<Instruction>(instructionResult, null);
                        instruction.isDifferentiated = true;
                    }
                    if (this.adEnv.traceCurBlock != 0) {
                        TapEnv.printlnOnTrace("   -->");
                        TapEnv.printlnOnTrace("      " + ILUtils.toString(result, this.adEnv.curActivity()));
                    }
                    diffDeclarationsR = new TapList[]{diffDeclarations};
                    break;
                }
                case 101: {
                    if (!TapEnv.isStdIncludeName(tree.stringValue())) {
                        Instruction.differentiateChainedIncludes(instruction, null, true);
                    }
                    diffDeclarationsR = new TapList[]{null};
                    break;
                }
                case 51: {
                    Instruction instructionResult;
                    TapList<Instruction> diffDeclarations;
                    Tree diffData1 = this.diffListDecls(tree.down(1), tree, diffSymbolTable, null, null, null);
                    if (diffData1 != null) {
                        Tree firstVar = ILUtils.baseTree(tree.down(1).down(1));
                        VariableDecl varDecl = this.adEnv.curSymbolTable().getVariableDecl(ILUtils.baseName(firstVar));
                        WrapperTypeSpec typeSpec = varDecl.type();
                        Tree result = typeSpec.wrappedType.buildConstantZero();
                        int length = ILUtils.buildIterativeLength(diffData1, this.adEnv.curFwdSymbolTable);
                        if (length > 1) {
                            result = ILUtils.build(133, ILUtils.build(103, length), result);
                        }
                        result = ILUtils.build(51, diffData1, ILUtils.build(71, result));
                        instructionResult = new Instruction(result);
                        instructionResult.isDifferentiated = true;
                        diffDeclarations = new TapList<Instruction>(instructionResult, null);
                        diffDeclarationsR = new TapList[]{diffDeclarations};
                        instruction.isDifferentiated = true;
                        if (!TapEnv.associationByAddress()) break;
                        copyInstrInDiff.tree = tree = this.turnAssociationByAddressPrimal(tree, this.adEnv.curSymbolTable(), this.adEnv.curFwdSymbolTable, null, false);
                        break;
                    }
                    diffDeclarationsR = new TapList[]{null};
                    break;
                }
                case 106: {
                    Tree result;
                    Instruction instructionResult;
                    boolean splitInterface = false;
                    TapList<Object> differentiatedInterfaces = new TapList<Object>(null, null);
                    TapList<Instruction> diffDeclarations = null;
                    if (allDiffModesInside) {
                        if (TapEnv.mustAdjoint()) {
                            this.adEnv.pushCurDiffSorts(2, 2);
                            splitInterface = this.mustDifferentiateInterfaceSplit(tree);
                            if (splitInterface) {
                                result = this.differentiateInterfaceDeclaration(tree, 4, block, diffSymbolTable, copyInstrInDiff, differentiatedInterfaces);
                                if (result != null) {
                                    instructionResult = new Instruction();
                                    instructionResult.tree = result;
                                    instructionResult.isDifferentiated = true;
                                    diffDeclarations = new TapList<Instruction>(instructionResult, diffDeclarations);
                                }
                                if ((result = this.differentiateInterfaceDeclaration(tree, 3, block, diffSymbolTable, copyInstrInDiff, differentiatedInterfaces)) != null) {
                                    instructionResult = new Instruction();
                                    instructionResult.tree = result;
                                    instructionResult.isDifferentiated = true;
                                    diffDeclarations = new TapList<Instruction>(instructionResult, diffDeclarations);
                                }
                            } else {
                                result = this.differentiateInterfaceDeclaration(tree, 2, block, diffSymbolTable, copyInstrInDiff, differentiatedInterfaces);
                                if (result != null) {
                                    instructionResult = new Instruction();
                                    instructionResult.tree = result;
                                    instructionResult.isDifferentiated = true;
                                    diffDeclarations = new TapList<Instruction>(instructionResult, diffDeclarations);
                                }
                            }
                            this.adEnv.popCurDiffSorts();
                        }
                        if (TapEnv.mustTangent()) {
                            this.adEnv.pushCurDiffSorts(1, 1);
                            result = this.differentiateInterfaceDeclaration(tree, 1, block, diffSymbolTable, copyInstrInDiff, differentiatedInterfaces);
                            if (result != null) {
                                instructionResult = new Instruction();
                                instructionResult.tree = result;
                                instructionResult.isDifferentiated = true;
                                diffDeclarations = new TapList<Instruction>(instructionResult, diffDeclarations);
                            }
                            this.adEnv.popCurDiffSorts();
                        }
                    } else {
                        if (differentiationMode == -1) {
                            splitInterface = this.mustDifferentiateInterfaceSplit(tree);
                        }
                        if (splitInterface) {
                            result = this.differentiateInterfaceDeclaration(tree, 4, block, diffSymbolTable, copyInstrInDiff, differentiatedInterfaces);
                            if (result != null) {
                                instructionResult = new Instruction();
                                instructionResult.tree = result;
                                instructionResult.isDifferentiated = true;
                                diffDeclarations = new TapList<Instruction>(instructionResult, diffDeclarations);
                            }
                            if ((result = this.differentiateInterfaceDeclaration(tree, 3, block, diffSymbolTable, copyInstrInDiff, differentiatedInterfaces)) != null) {
                                instructionResult = new Instruction();
                                instructionResult.tree = result;
                                instructionResult.isDifferentiated = true;
                                diffDeclarations = new TapList<Instruction>(instructionResult, diffDeclarations);
                            }
                        } else {
                            int diffMode = differentiationMode == 1 ? 1 : 2;
                            result = this.differentiateInterfaceDeclaration(tree, diffMode, block, diffSymbolTable, copyInstrInDiff, differentiatedInterfaces);
                            if (result != null) {
                                instructionResult = new Instruction();
                                instructionResult.tree = result;
                                instructionResult.isDifferentiated = true;
                                diffDeclarations = new TapList<Instruction>(instructionResult, diffDeclarations);
                            }
                        }
                    }
                    diffDeclarationsR = new TapList[]{diffDeclarations};
                    if (diffDeclarations != null) {
                        instruction.isDifferentiated = true;
                    }
                    this.adEnv.setCurInstruction(instruction);
                    break;
                }
                case 197: {
                    Tree result = this.differentiateUseDeclaration(ILUtils.copy(tree), diffSymbolTable);
                    Instruction instructionResult = new Instruction(result);
                    instructionResult.isDifferentiated = true;
                    instructionResult.preComments = instruction.preComments;
                    instructionResult.postComments = instruction.postComments;
                    instructionResult.preCommentsBlock = instruction.preCommentsBlock;
                    instructionResult.postCommentsBlock = instruction.postCommentsBlock;
                    TapList<Instruction> diffDeclarations = new TapList<Instruction>(instructionResult, null);
                    diffDeclarationsR = new TapList[]{diffDeclarations};
                    break;
                }
                case 138: {
                    diffDeclarationsR = new TapList[]{null};
                    break;
                }
                case 39: 
                case 69: {
                    Instruction instructionResult;
                    TapList<Instruction> diffDeclarations;
                    if (TapEnv.associationByAddress()) {
                        diffDeclarationsR = new TapList[]{null};
                        break;
                    }
                    diffDeclarationsR = new TapList[TapEnv.diffReplica()];
                    this.adEnv.iReplic = 0;
                    while (this.adEnv.iReplic < diffDeclarationsR.length) {
                        diffDeclarations = null;
                        Tree result = null;
                        TapList<Object> toExtraDiffDeclarations = new TapList<Object>(null, null);
                        if (tree.opCode() == 39) {
                            result = this.differentiateCommonDeclaration(diffSymbolTable, tree, toExtraDiffDeclarations);
                        } else if (tree.opCode() == 69) {
                            result = this.differentiateEquivalenceDeclaration(diffSymbolTable, tree);
                        }
                        while (toExtraDiffDeclarations.tail != null) {
                            instructionResult = new Instruction((Tree)toExtraDiffDeclarations.tail.head);
                            instructionResult.isDifferentiated = true;
                            instruction.isDifferentiated = true;
                            diffDeclarations = new TapList<Instruction>(instructionResult, diffDeclarations);
                            toExtraDiffDeclarations = toExtraDiffDeclarations.tail;
                        }
                        if (result != null) {
                            instructionResult = new Instruction(result);
                            instructionResult.isDifferentiated = true;
                            instruction.isDifferentiated = true;
                            diffDeclarations = new TapList<Instruction>(instructionResult, diffDeclarations);
                        }
                        diffDeclarationsR[this.adEnv.iReplic] = diffDeclarations;
                        ++this.adEnv.iReplic;
                    }
                    this.adEnv.iReplic = 0;
                    break;
                }
                case 171: 
                case 202: {
                    Instruction instructionResult;
                    if (TapEnv.associationByAddress()) {
                        diffDeclarationsR = new TapList[]{null};
                        break;
                    }
                    TapList<Tree> diffDecls = this.diffDeclNames(tree, allDiffModesInside, diffSymbolTable);
                    Tree result = diffDecls == null ? null : ILUtils.build(tree.opCode(), diffDecls);
                    TapList<Instruction> diffDeclarations = null;
                    if (result != null) {
                        instructionResult = new Instruction(result);
                        instructionResult.isDifferentiated = true;
                        instruction.isDifferentiated = true;
                        diffDeclarations = new TapList<Instruction>(instructionResult, diffDeclarations);
                    }
                    diffDeclarationsR = new TapList[]{diffDeclarations};
                    break;
                }
                case 192: {
                    Instruction instructionResult;
                    Tree result = this.differentiateTypeDeclaration(diffSymbolTable, tree);
                    TapList<Instruction> diffDeclarations = null;
                    if (result != null) {
                        instructionResult = new Instruction(result);
                        instructionResult.isDifferentiated = true;
                        instruction.isDifferentiated = true;
                        diffDeclarations = new TapList<Instruction>(instructionResult, diffDeclarations);
                    }
                    diffDeclarationsR = new TapList[]{diffDeclarations};
                    break;
                }
                case 74: 
                case 108: {
                    Instruction instructionResult;
                    TapList<Tree> diffDecls = this.diffDeclNames(tree, allDiffModesInside, diffSymbolTable);
                    Tree result = diffDecls == null ? null : ILUtils.build(74, diffDecls);
                    TapList<Instruction> diffDeclarations = null;
                    if (result != null) {
                        instructionResult = new Instruction(result);
                        instructionResult.isDifferentiated = true;
                        instruction.isDifferentiated = true;
                        diffDeclarations = new TapList<Instruction>(instructionResult, diffDeclarations);
                    }
                    diffDeclarationsR = new TapList[]{diffDeclarations};
                    break;
                }
                case 45: 
                case 135: {
                    diffDeclarationsR = new TapList[]{null};
                    break;
                }
                default: {
                    Instruction instructionResult;
                    TapEnv.toolWarning(-1, "(Differentiation of declaration) Unexpected operator: " + tree.opName());
                    TapList<Tree> diffDecls = this.diffDeclNames(tree, allDiffModesInside, diffSymbolTable);
                    Tree result = diffDecls == null ? null : ILUtils.build(tree.opCode(), diffDecls);
                    TapList<Instruction> diffDeclarations = null;
                    if (result != null) {
                        instructionResult = new Instruction(result);
                        instructionResult.isDifferentiated = true;
                        instruction.isDifferentiated = true;
                        diffDeclarations = new TapList<Instruction>(instructionResult, diffDeclarations);
                    }
                    diffDeclarationsR = new TapList[]{diffDeclarations};
                    break;
                }
            }
            if (instruction.fromInclude() != null) {
                if (instruction.tree != null && instruction.tree.opCode() == 101 && instruction.fromInclude().tree == null) {
                    if (this.adEnv.traceCurDifferentiation && this.adEnv.traceCurBlock != 0) {
                        TapEnv.printlnOnTrace("          include was inlined!");
                    }
                    copyInstrInDiff.tree = null;
                } else {
                    instruction.fromInclude().setIncludeOfDiffInstructions(copyInstrInDiff, copyInstrIsDiffSpecific, diffDeclarationsR, this.suffixes()[this.curDiffUnitSort()][1]);
                }
            }
        } else {
            diffDeclarationsR = new TapList[]{null};
        }
        if (this.adEnv.traceCurDifferentiation && this.adEnv.traceCurBlock != 0) {
            if (diffDeclarationsR.length > 0) {
                TapList inDiffDeclarations = diffDeclarationsR[0];
                while (inDiffDeclarations != null) {
                    TapEnv.printlnOnTrace("          --> differentiated decl: " + ((Instruction)inDiffDeclarations.head).tree + (diffDeclarationsR.length == 1 ? "" : " *" + diffDeclarationsR.length + "replicas"));
                    inDiffDeclarations = inDiffDeclarations.tail;
                }
            }
            TapEnv.printlnOnTrace("          --> copied  source decl: " + copyInstrInDiff.tree);
        }
        return diffDeclarationsR;
    }

    private int getAdjointModeSplit(Tree tree, SymbolTable diffSymbolTable) {
        int adjointModeSplit = 0;
        if (TapEnv.mustAdjoint() && tree.down(3).length() != 0) {
            boolean seenHereAsAFunction;
            String symbolName = ILUtils.baseName(tree.down(3).down(1));
            SymbolDecl symbolDecl = diffSymbolTable.getSymbolDecl(symbolName);
            boolean bl = seenHereAsAFunction = symbolDecl != null && symbolDecl.isA(3);
            if (seenHereAsAFunction) {
                FunctionDecl funDecl;
                TapList<FunctionDecl> funDecls = diffSymbolTable.getFunctionDecl(symbolName, null, null, false);
                FunctionDecl functionDecl = funDecl = funDecls == null ? null : (FunctionDecl)funDecls.head;
                if (funDecl != null) {
                    Unit declaredUnit = funDecl.unit();
                    if (declaredUnit.origUnit != null && declaredUnit.origUnit != declaredUnit) {
                        declaredUnit = declaredUnit.origUnit;
                    }
                    if (declaredUnit.mustDifferentiateSplit()) {
                        adjointModeSplit = 3;
                    }
                }
            }
        }
        return adjointModeSplit;
    }

    private boolean willBeNodiff(Tree tree, SymbolTable sourceSymbolTable) {
        boolean result = false;
        Tree[] declarators = tree.down(3).children();
        for (int i = declarators.length - 1; i >= 0 && !result; --i) {
            String funcName;
            TapList<FunctionDecl> funcDecls;
            FunctionDecl funcDecl;
            Tree declarator = declarators[i];
            if (declarator == null) continue;
            if (declarator.opCode() == 14) {
                declarator = declarator.down(1);
            }
            FunctionDecl functionDecl = funcDecl = (funcDecls = sourceSymbolTable.getFunctionDecl(funcName = ILUtils.baseName(declarator), null, null, false)) == null ? null : (FunctionDecl)funcDecls.head;
            if (funcDecl == null || funcDecl.unit() == null || !funcDecl.unit().isStandard() || !this.callGraphDifferentiator().unitsHavePrimal.retrieve(funcDecl.unit()).booleanValue()) continue;
            result = true;
        }
        return result;
    }

    private TapList<Instruction> differentiateVarDeclaration(Tree tree, TapList<Instruction> newDeclarations, int differentiationMode, Block block, SymbolTable diffSymbolTable, Instruction instruction, Instruction copyInstrInDiff, BoolVector beforeActiv, BoolVector afterActiv, BoolVector beforeUseful, BoolVector afterUseful, BoolVector beforeReqX, BoolVector afterReqX, BoolVector beforeAvlX, BoolVector afterAvlX, int adjointSplitMode, int origLanguage, boolean declarationOnly, boolean forInterface) {
        Instruction diffInstruction;
        Tree splitTree;
        TapList<Object> hdSimpleDeclarators;
        TapList<Object> toNewPrimalDeclarations = new TapList<Object>(null, null);
        Tree[] declarators = tree.down(3).children();
        TapList<Object> tlSimpleDeclarators = hdSimpleDeclarators = new TapList<Object>(null, null);
        for (Tree value : declarators) {
            VariableDecl varDecl;
            Tree declarator = ILUtils.copy(value);
            String varName = declarator == null ? null : ILUtils.baseName(declarator);
            VariableDecl variableDecl = varDecl = varName == null ? null : diffSymbolTable.getVariableOrConstantDecl(varName);
            if (varDecl != null && varDecl.isATrueSymbolDecl && varDecl.hasOtherCombinableDeclarationPart()) {
                splitTree = ILUtils.build(199, ILUtils.copy(tree.down(1)), ILUtils.copy(tree.down(2)), ILUtils.build(54, declarator));
                diffInstruction = this.differentiateVarDeclarationOne(splitTree, differentiationMode, block, diffSymbolTable, instruction, copyInstrInDiff, toNewPrimalDeclarations, beforeActiv, afterActiv, afterReqX, beforeAvlX, adjointSplitMode, origLanguage, declarationOnly, forInterface);
                while (toNewPrimalDeclarations.tail != null) {
                    newDeclarations = newDeclarations.placdl((Instruction)toNewPrimalDeclarations.tail.head);
                    toNewPrimalDeclarations.tail = toNewPrimalDeclarations.tail.tail;
                }
                if (diffInstruction == null) continue;
                newDeclarations = newDeclarations.placdl(diffInstruction);
                continue;
            }
            tlSimpleDeclarators = tlSimpleDeclarators.placdl(declarator);
        }
        if (hdSimpleDeclarators.tail != null) {
            splitTree = ILUtils.build(199, ILUtils.copy(tree.down(1)), ILUtils.copy(tree.down(2)), ILUtils.build(54, hdSimpleDeclarators.tail));
            diffInstruction = this.differentiateVarDeclarationOne(splitTree, differentiationMode, block, diffSymbolTable, instruction, copyInstrInDiff, toNewPrimalDeclarations, beforeActiv, afterActiv, afterReqX, beforeAvlX, adjointSplitMode, origLanguage, declarationOnly, forInterface);
            while (toNewPrimalDeclarations.tail != null) {
                newDeclarations = newDeclarations.placdl((Instruction)toNewPrimalDeclarations.tail.head);
                toNewPrimalDeclarations.tail = toNewPrimalDeclarations.tail.tail;
            }
            if (diffInstruction != null) {
                newDeclarations = newDeclarations.placdl(diffInstruction);
            }
        }
        return newDeclarations;
    }

    private Instruction differentiateVarDeclarationOne(Tree tree, int differentiationMode, Block block, SymbolTable diffSymbolTable, Instruction instruction, Instruction copyInstrInDiff, TapList<Instruction> toNewPrimalDeclarations, BoolVector beforeActiv, BoolVector afterActiv, BoolVector afterReqX, BoolVector beforeAvlX, int adjointSplitMode, int origLanguage, boolean declarationOnly, boolean forInterface) {
        boolean hasDiffNames;
        Unit funcDeclUnit;
        FunctionDecl funcDecl;
        TapList<FunctionDecl> funcDecls;
        VariableDecl varDecl;
        Tree varTree;
        String varName;
        Tree declarator;
        int i;
        TapList<Object> hdNewDeclarators;
        boolean traceHere = false;
        Instruction instructionResult = new Instruction(ILUtils.build(138));
        Tree mainTypeTree = tree.down(2);
        WrapperTypeSpec mainType = TypeSpec.build(mainTypeTree, block.symbolTable, instruction, new TapList<Object>(null, null), new TapList<Object>(null, null), new TapList<Object>(null, null), new ToBool(false), null);
        boolean mainTypeIsArray = mainType.containsArray();
        Tree declarators = tree.down(3);
        int nbDecls = declarators.length();
        WrapperTypeSpec typeSpec = new WrapperTypeSpec(null);
        WrapperTypeSpec diffTypeSpec = null;
        WrapperTypeSpec resultDiffTypeSpec = null;
        WrapperTypeSpec prevDiffTypeSpec = null;
        NewSymbolHolder newSH = null;
        Tree proposedDiffTypeTree = null;
        TapList<Object> tlNewDeclarators = hdNewDeclarators = new TapList<Object>(null, null);
        TapList<Tree> toRemoveDecls = null;
        Tree[] modifiers = null;
        boolean containsArrayDeclarator = false;
        boolean[] containsArrayDeclaratorS = new boolean[nbDecls];
        boolean containsPointerDeclarator = false;
        boolean containsSizedDeclarator = false;
        boolean containsDimDeclaration = false;
        boolean[] containsDimDeclarationS = new boolean[nbDecls];
        boolean[] needDiffArrayDeclarationS = new boolean[nbDecls];
        VariableDecl[] varDecls = new VariableDecl[nbDecls];
        SymbolDecl diffSymbolDecl = null;
        boolean[] isDiffLocalDeclared = new boolean[nbDecls];
        WrapperTypeSpec[] diffTypeSpecs = new WrapperTypeSpec[nbDecls];
        TapList<Object> origAccessChecks = null;
        TapList<Object> diffAccessChecks = null;
        Tree typeSpecTree = null;
        WrapperTypeSpec funcDeclDiffReturnType = null;
        boolean runAgain = false;
        boolean[] formalArgsPointerActivity = null;
        if (this.adEnv.curUnit() != null && this.adEnv.curUnit().functionTypeSpec() != null) {
            if (this.adEnv.curActivity() != null) {
                formalArgsPointerActivity = ReqExplicit.formalArgsPointerActivity(this.adEnv.curActivity(), this.adEnv.curUnit().functionTypeSpec().argumentsTypes.length);
            } else {
                formalArgsPointerActivity = new boolean[this.adEnv.curUnit().functionTypeSpec().argumentsTypes.length + 1];
                for (int i2 = formalArgsPointerActivity.length - 1; i2 >= 0; --i2) {
                    formalArgsPointerActivity[i2] = false;
                }
            }
        }
        boolean[] formalArgsActivity = null;
        if (this.adEnv.curUnit() != null && this.adEnv.curUnit().functionTypeSpec() != null && this.adEnv.curActivity() != null) {
            formalArgsActivity = this.callGraphDifferentiator().getUnitFormalArgsActivityS(this.adEnv.curActivity());
        }
        for (i = 1; i <= declarators.length(); ++i) {
            declarator = declarators.down(i);
            if (declarator == null) continue;
            Tree declaratorNoAssign = declarator;
            if (declarator.opCode() == 14) {
                declaratorNoAssign = declarator.down(1);
            }
            varName = ILUtils.baseName(declaratorNoAssign);
            varTree = ILUtils.build(96, varName);
            varDecl = diffSymbolTable.getVariableOrConstantDecl(varName);
            if (varDecl != null && !varDecl.isATrueSymbolDecl) {
                varDecl = null;
            }
            containsDimDeclarationS[i - 1] = false;
            needDiffArrayDeclarationS[i - 1] = false;
            if ((varDecl == null || varDecl.isActiveSymbolDecl()) && declaratorNoAssign.opCode() == 11) {
                containsArrayDeclaratorS[i - 1] = true;
                containsArrayDeclarator = true;
            }
            if (declaratorNoAssign.opCode() == 175) {
                containsSizedDeclarator = true;
            }
            if (declaratorNoAssign.opCode() == 153) {
                containsPointerDeclarator = true;
            }
            funcDecl = (funcDecls = diffSymbolTable.getFunctionDecl(varName, null, null, false)) != null ? (FunctionDecl)funcDecls.head : null;
            TapList<FunctionDecl> basisFuncDecls = diffSymbolTable.basisSymbolTable().getFunctionDecl(varName, null, null, false);
            FunctionDecl basisFuncDecl = basisFuncDecls != null ? (FunctionDecl)basisFuncDecls.head : null;
            if (funcDecl != null && funcDecl.unit().isExternal() && basisFuncDecl.unit() != funcDecl.unit()) {
                TapEnv.toolError("Removing local external declaration of " + funcDecl.unit() + " in " + this.adEnv.curUnit() + " in " + diffSymbolTable.shortName());
                diffSymbolTable.removeDecl(funcDecl.symbol, 3, true);
                funcDecl = basisFuncDecl;
            }
            if (this.mixedLanguage(funcDecl) && funcDecl.importedFrom != null && ((SymbolDecl)funcDecl.importedFrom.first).hasDiffSymbolHolders()) {
                newSH = ((SymbolDecl)funcDecl.importedFrom.first).getDiffSymbolHolder(this.curDiffUnitSort(), null, 0);
            }
            if (funcDecl == null) {
                funcDeclUnit = null;
            } else {
                funcDeclUnit = funcDecl.unit();
                if (funcDeclUnit.origUnit != null) {
                    funcDeclUnit = funcDeclUnit.origUnit;
                }
            }
            if (declaratorNoAssign.opCode() == 90) {
                varDecl = null;
                if (funcDecl != null) {
                    typeSpec = funcDeclUnit.functionTypeSpec().returnType;
                }
            }
            boolean bl = containsDimDeclarationS[i - 1] = varDecl != null && (varDecl.hasInstructionWithRootOperator(202, null) || BlockDifferentiator.containsOpArrayDeclarator(varDecl, 2));
            if (containsDimDeclarationS[i - 1] && varDecl.isActiveSymbolDecl()) {
                containsDimDeclaration = true;
            }
            if (newSH == null) {
                newSH = NewSymbolHolder.getNewSymbolHolder(declarator);
            }
            hasDiffNames = true;
            if (newSH != null && newSH.derivationFrom == null) {
                varDecl = newSH.newVariableDecl();
                hasDiffNames = varDecl.hasDiffSymbolHolders();
                if (differentiationMode == 3) {
                    hasDiffNames = formalArgsPointerActivity[varDecl.formalArgRankInOrigUnit - 1];
                }
                funcDecl = newSH.newFunctionDecl();
                newSH.setInstruction(instructionResult);
                varDecl.setInstruction(instructionResult);
            }
            if (forInterface && hasDiffNames && formalArgsActivity != null && varDecl != null && varDecl.formalArgRankInOrigUnit > 0 && varDecl.formalArgRankInOrigUnit < formalArgsActivity.length && !formalArgsActivity[varDecl.formalArgRankInOrigUnit - 1]) {
                hasDiffNames = false;
            }
            funcDeclDiffReturnType = null;
            if (funcDecl != null) {
                UnitDiffInfo diffInfo = this.callGraphDifferentiator().getUnitDiffInfo(funcDeclUnit);
                if (diffInfo != null) {
                    funcDeclDiffReturnType = adjointSplitMode == 3 ? diffInfo.getDiffReturnType(adjointSplitMode) : diffInfo.getDiffReturnType(this.curDiffUnitSort());
                }
                if (funcDeclDiffReturnType == null && declarator.opCode() != 90) {
                    funcDecl = null;
                }
                if (mainTypeTree.opCode() == 129) {
                    modifiers = mainTypeTree.down(1).children();
                }
            }
            if (varDecl != null && varDecl.isActiveSymbolDecl() && hasDiffNames || funcDeclDiffReturnType != null) {
                boolean containsDeclaratorOrVarDimDecl = containsArrayDeclaratorS[i - 1] || containsDimDeclaration || containsPointerDeclarator;
                boolean localMultiDirMode = this.multiDirMode() && !containsDeclaratorOrVarDimDecl && funcDecl == null;
                boolean throughPointer = false;
                isDiffLocalDeclared[i - 1] = false;
                if (varDecl != null) {
                    typeSpec = varDecl.type();
                    if (typeSpec.containsArray() && declarator.opCode() != 11 && !mainTypeIsArray) {
                        typeSpec = (WrapperTypeSpec)typeSpec.peelDimensionsTo(typeSpec, typeSpec, new TapList<Object>(null, null));
                        localMultiDirMode = false;
                    }
                    if (varDecl.fromImplicitType() != null) {
                        typeSpec = (WrapperTypeSpec)varDecl.fromImplicitType();
                    }
                    if (this.adEnv.curUnit() != null && origLanguage != this.adEnv.curUnit().language()) {
                        TypeDecl otherTypeDecl = this.adEnv.diffCallGraph().getOtherBindType(typeSpec);
                        if (otherTypeDecl != null) {
                            typeSpec = otherTypeDecl.typeSpec;
                        } else if (this.adEnv.curUnit().isC()) {
                            if (TypeSpec.isA(typeSpec, 6)) {
                                typeSpec = ((PointerTypeSpec)typeSpec.wrappedType).destinationType;
                            }
                            if (mainTypeTree.opCode() == 129) {
                                modifiers = mainTypeTree.down(1).children();
                            }
                        }
                    }
                    isDiffLocalDeclared[i - 1] = this.varRefDifferentiator().paramHasOnlyLocalDiff(this.adEnv.curActivity(), varTree, varDecl);
                } else if (funcDecl != null) {
                    typeSpec = funcDecl.returnTypeSpec();
                    if (funcDecl.fromImplicitType() != null) {
                        typeSpec = (WrapperTypeSpec)funcDecl.fromImplicitType();
                    }
                }
                if (containsDeclaratorOrVarDimDecl) {
                    while (TypeSpec.isA(typeSpec, 6)) {
                        typeSpec = ((PointerTypeSpec)typeSpec.wrappedType).destinationType;
                        throughPointer = true;
                    }
                }
                if (containsDeclaratorOrVarDimDecl) {
                    while (TypeSpec.isA(typeSpec, 2)) {
                        typeSpec = typeSpec.wrappedType.elementType();
                    }
                }
                if (containsSizedDeclarator && TypeSpec.isA(typeSpec, 5)) {
                    typeSpec = typeSpec.wrappedType.elementType();
                }
                if ((diffTypeSpec = typeSpec.differentiateTypeSpecMemo(diffSymbolTable, this.adEnv.curSymbolTable(), this.curDiffUnitSort(), this.suffixes()[this.curDiffUnitSort()][3], !throughPointer && isDiffLocalDeclared[i - 1], localMultiDirMode, this.varRefDifferentiator().getMultiDirDimensionMax(), varName, varName, varTree, null)) == null) {
                    diffTypeSpec = typeSpec;
                    if (TapEnv.relatedLanguageIsFortran() && varDecl != null && !varDecl.hasInstructionWithRootOperator(2, "allocatable") && throughPointer) {
                        diffTypeSpec = new WrapperTypeSpec(new PointerTypeSpec(typeSpec, null));
                    }
                }
                if (mainTypeTree.opCode() == 129 && (varDecl != null && varDecl.extraInfo() != null && diffTypeSpec != null || varDecl == null && funcDecl != null && funcDeclDiffReturnType == null || TypeSpec.isA(typeSpec, 21) || ILUtils.getBindCValue(tree, i) != null || ILUtils.containsModifier("extern", instruction.tree, true))) {
                    modifiers = mainTypeTree.down(1).children();
                }
                if (varDecl != null && typeSpec != varDecl.type()) {
                    resultDiffTypeSpec = diffTypeSpec;
                    if (diffTypeSpec == null) {
                        resultDiffTypeSpec = typeSpec;
                        proposedDiffTypeTree = mainTypeTree;
                    }
                }
                if (prevDiffTypeSpec != null && !diffTypeSpec.equalsCompilIndep(prevDiffTypeSpec)) {
                    if (TypeSpec.isA(diffTypeSpec, 2)) {
                        for (int j = 0; j < i; ++j) {
                            needDiffArrayDeclarationS[j] = true;
                        }
                        if (TypeSpec.isA(prevDiffTypeSpec, 2)) {
                            prevDiffTypeSpec = prevDiffTypeSpec.wrappedType.elementType();
                            diffTypeSpec = diffTypeSpec.wrappedType.elementType();
                        }
                        resultDiffTypeSpec = prevDiffTypeSpec;
                    } else if (TypeSpec.isA(prevDiffTypeSpec, 2)) {
                        runAgain = true;
                    }
                } else {
                    prevDiffTypeSpec = diffTypeSpec;
                }
                if (varDecl == null && funcDecl != null && funcDecl.unit().isFortran() && TypeSpec.isA(diffTypeSpec, 2)) {
                    resultDiffTypeSpec = diffTypeSpec.wrappedType.elementType();
                }
            }
            if (varDecl != null) {
                TapIntList lzones = ZoneInfo.listAllZones(varDecl.zones(), false);
                TapList<String> toRegister = null;
                TapList<String> toRegisterDiff = null;
                while (lzones != null) {
                    ZoneInfo zoneInfo = DataFlowAnalyzer.extendedDeclaredToZoneInfo(lzones.head, block.symbolTable, null);
                    if (zoneInfo != null) {
                        if (zoneInfo.relocated || zoneInfo.rebased) {
                            toRegister = new TapList<String>(ILUtils.toString(zoneInfo.accessTree), toRegister);
                        }
                        if (zoneInfo.relocatedDiff || zoneInfo.rebasedDiff) {
                            toRegisterDiff = new TapList<String>(ILUtils.toString(zoneInfo.accessTree), toRegisterDiff);
                        }
                    }
                    lzones = lzones.tail;
                }
                if (toRegister != null) {
                    TapEnv.toolError("  Problem in " + this.adEnv.curUnit().name() + ": local variable " + varDecl.symbol + " must be ADMM_register'ed due to " + toRegister);
                }
                if (toRegisterDiff != null) {
                    TapEnv.toolError("  Problem in " + this.adEnv.curUnit().name() + ": diff of local variable " + varDecl.symbol + " must be ADMM_register'ed due to " + toRegisterDiff);
                }
            }
            varDecls[i - 1] = varDecl;
            diffTypeSpecs[i - 1] = diffTypeSpec;
        }
        if (runAgain) {
            for (i = 1; i <= declarators.length(); ++i) {
                declarator = declarators.down(i);
                if (declarator == null || varDecls[i - 1] == null || !varDecls[i - 1].isActiveSymbolDecl() || diffTypeSpec == diffTypeSpecs[i - 1] || !TypeSpec.isA(diffTypeSpecs[i - 1], 2)) continue;
                needDiffArrayDeclarationS[i - 1] = true;
            }
        }
        if (resultDiffTypeSpec != null) {
            typeSpecTree = diffTypeSpec.generateTree(diffSymbolTable, null, null, true, null);
        }
        for (i = 1; i <= declarators.length(); ++i) {
            Tree headerTree;
            Tree diffDecl;
            declarator = declarators.down(i);
            if (declarator == null) continue;
            varName = ILUtils.baseName(declarator);
            Tree hintTreeSize = varTree = ILUtils.build(96, varName);
            varDecl = diffSymbolTable.getVariableOrConstantDecl(varName);
            if (varDecl != null && !varDecl.isATrueSymbolDecl) {
                varDecl = null;
            }
            FunctionDecl functionDecl = funcDecl = (funcDecls = diffSymbolTable.getFunctionDecl(varName, null, null, false)) == null ? null : (FunctionDecl)funcDecls.head;
            if (declarator.opCode() == 90) {
                varDecl = null;
            }
            if (TapEnv.associationByAddress() && varDecl != null && funcDecl != null && this.isCurUnitReturn(funcDecl)) {
                varDecl = null;
            }
            if (varDecl != null) {
                boolean mustReviewModifiers;
                boolean mustDifferentiateDeclarator;
                TypeDecl otherTypeDecl;
                TapList<String> extraInfo = varDecl.extraInfo();
                Tree copyVarTree = ILUtils.copy(tree);
                Tree decli = declarator;
                VariableDecl diffVarDecl = null;
                hasDiffNames = true;
                if (differentiationMode == 3) {
                    hasDiffNames = varDecl.formalArgRankInOrigUnit > 0 && varDecl.formalArgRankInOrigUnit < formalArgsPointerActivity.length ? formalArgsPointerActivity[varDecl.formalArgRankInOrigUnit - 1] : false;
                }
                if (hasDiffNames && forInterface && formalArgsActivity != null && varDecl.formalArgRankInOrigUnit > 0 && varDecl.formalArgRankInOrigUnit < formalArgsActivity.length && !formalArgsActivity[varDecl.formalArgRankInOrigUnit - 1]) {
                    hasDiffNames = false;
                }
                WrapperTypeSpec varDeclTypeSpec = varDecl.type();
                if (this.adEnv.curUnit() != null && origLanguage != this.adEnv.curUnit().language() && (otherTypeDecl = this.adEnv.diffCallGraph().getOtherBindType(varDeclTypeSpec)) != null) {
                    varDeclTypeSpec = otherTypeDecl.typeSpec;
                }
                if (needDiffArrayDeclarationS[i - 1] && decli.opCode() != 11 && decli.opCode() != 175) {
                    typeSpecTree = varDeclTypeSpec.generateTree(diffSymbolTable, null, null, true, null);
                    if (TypeSpec.isA(varDecl.type(), 2)) {
                        decli = ILUtils.buildArrayDeclarator(this.adEnv.curUnit().language(), ILUtils.copy(decli), ILUtils.copy(typeSpecTree.down(2)));
                    }
                }
                if (differentiationMode == 1 && varDecl.isActiveSymbolDecl() && hasDiffNames && funcDecl != null && this.adEnv.curUnit().isFortran() && funcDecl.symbol.equals(this.adEnv.curUnit().name()) && funcDecl.isElemental()) {
                    varDecl.setExtraInfo(new TapList<String>("out", varDecl.extraInfo()));
                    if (modifiers == null) {
                        modifiers = new Tree[]{ILUtils.build(96, "out")};
                    }
                }
                diffDecl = decli;
                TapList<String> diffExtraInfo = null;
                boolean isFuncReturnVar = false;
                if (this.adEnv.curUnit().isFortran() && (differentiationMode == 1 && !this.multiDirMode() || differentiationMode == 3 || this.adEnv.curActivity() != null && this.adEnv.curActivity().isContext()) && (!TypeSpec.isA(varDeclTypeSpec, 2) || varDeclTypeSpec.isCharacter() || varDeclTypeSpec.isString())) {
                    String returnVarName = this.adEnv.curUnit().otherReturnVar() == null ? this.adEnv.curUnit().name() : this.adEnv.curUnit().otherReturnVar().symbol;
                    isFuncReturnVar = varDecl.symbol.equals(returnVarName);
                }
                boolean diffFunctionIsFunction = !this.multiDirMode() && !this.adEnv.curUnit().usedAsElementalResult;
                boolean bl = mustDifferentiateDeclarator = varDecl.isActiveSymbolDecl() && hasDiffNames && (!isFuncReturnVar || !diffFunctionIsFunction);
                if (!(!isFuncReturnVar || !diffFunctionIsFunction || varDecl.isActiveSymbolDecl() && hasDiffNames || formalArgsActivity == null || (differentiationMode != 3 ? formalArgsActivity[formalArgsActivity.length - 1] : formalArgsPointerActivity[formalArgsActivity.length - 1]))) {
                    toRemoveDecls = new TapList<Tree>(copyInstrInDiff.tree.down(3).down(i), toRemoveDecls);
                }
                if (mustDifferentiateDeclarator) {
                    Tree diffDeclBaseTree;
                    if (!TapEnv.associationByAddress()) {
                        diffDecl = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), decli, diffSymbolTable, false, copyVarTree, containsArrayDeclarator && !containsDimDeclarationS[i - 1] || resultDiffTypeSpec == null && diffTypeSpec == null || diffTypeSpec == varDecl.type(), true, hintTreeSize);
                    }
                    if (varDecl.formalArgRank > 0 && varDecl.passesByValue(this.adEnv.curUnit()) && diffSymbolTable.basisSymbolTable().isFormalParamsLevel()) {
                        VariableDecl diffVarDecl2 = diffSymbolTable.getTopVariableDecl(ILUtils.baseName(diffDecl));
                        VariableDecl diffVarDeclPublic = diffSymbolTable.basisSymbolTable().getVariableDeclOfRank(varDecl.formalArgRank + 1);
                        if (diffVarDecl2 != null && diffVarDeclPublic != null) {
                            diffDecl = ILUtils.build(96, diffVarDeclPublic.symbol);
                        }
                    }
                    if ((newSH = NewSymbolHolder.getNewSymbolHolder(diffDeclBaseTree = ILUtils.baseTree(diffDecl))) != null) {
                        if (newSH.newFunctionDecl() != null) {
                            diffDeclBaseTree.setAnnotation("isFunctionName", Boolean.TRUE);
                        }
                        if (diffSymbolDecl == null && (diffSymbolDecl = newSH.newVariableDecl()) == null) {
                            diffSymbolDecl = newSH.newFunctionDecl();
                        }
                        newSH.setVarDeclTreeAlreadyPlacedFor(diffSymbolTable);
                        if (!TapEnv.relatedLanguageIsC() && funcDecl != null && funcDecl.symbol.equals(this.adEnv.curUnit().name()) && funcDecl.isElemental()) {
                            if (differentiationMode == 1) {
                                newSH.newVariableDecl.setExtraInfo(new TapList<String>("out", newSH.extraInfo()));
                            } else if (differentiationMode == -1) {
                                newSH.newVariableDecl.setExtraInfo(new TapList<String>("in", newSH.extraInfo()));
                            }
                        }
                        newSH.setInstruction(instructionResult);
                        newSH.newVariableDecl().setInstruction(newSH.instruction());
                        newSH.newVariableDecl().setInstruction(varDecl);
                    }
                    diffVarDecl = newSH != null ? newSH.newVariableDecl() : diffSymbolTable.getVariableOrConstantDecl(ILUtils.baseName(diffDecl));
                    diffExtraInfo = diffVarDecl != null ? diffVarDecl.extraInfo() : null;
                }
                boolean bl2 = TapList.containsOneOfStrings(extraInfo, new String[]{"in", "out", "inout", "constant", "optional", "value", "allocatable"}, !TapEnv.relatedLanguageIsFortran()) || TapList.containsOneOfStrings(varDecl.accessInfo, new String[]{"const"}, !TapEnv.relatedLanguageIsFortran()) || TapList.containsOneOfStrings(diffExtraInfo, new String[]{"in", "out", "inout", "constant", "optional", "value", "allocatable"}, !TapEnv.relatedLanguageIsFortran()) || ILUtils.containsModifier("out", instruction.tree, false) || ILUtils.containsModifier("constant", instruction.tree, false) || ILUtils.containsModifier("const", instruction.tree, true) ? true : (mustReviewModifiers = false);
                if (mustReviewModifiers || varDecl.hasInstructionWithRootOperator(2, "out")) {
                    boolean isLocalDeclared = this.adEnv.curUnit().isStandard() && varDecl.formalArgRankInOrigUnit == -2;
                    origAccessChecks = new TapList<AccessCheck>(new AccessCheck(varDecl, varDecl, isLocalDeclared, null), origAccessChecks);
                }
                if (!mustDifferentiateDeclarator) continue;
                if (mustReviewModifiers || ILUtils.containsModifier("optional", instruction.tree, false)) {
                    diffAccessChecks = new TapList<AccessCheck>(new AccessCheck(diffVarDecl, varDecl, isDiffLocalDeclared[i - 1], newSH), diffAccessChecks);
                }
                if (TypeSpec.isA(typeSpec, 5) || TapEnv.associationByAddress() && TypeSpec.isA(typeSpec, 21)) {
                    modifiers = ILUtils.removeSizeModifiers(modifiers);
                }
                if (declarator.opCode() == 14) {
                    typeSpec = varDecl.type();
                    WrapperTypeSpec diffVarTypeSpec = typeSpec.differentiateTypeSpecMemo(diffSymbolTable, this.adEnv.curSymbolTable(), this.curDiffUnitSort(), this.suffixes()[this.curDiffUnitSort()][3], isDiffLocalDeclared[i - 1], this.multiDirMode(), this.varRefDifferentiator().getMultiDirDimensionMax(), varName, varName, varTree, null);
                    if (diffVarTypeSpec == null) {
                        diffVarTypeSpec = typeSpec;
                    }
                    ILUtils.turnAssignFromInitDecl(declarator);
                    Tree diffDeclInit = this.differentiateInitDeclarator(diffVarTypeSpec, differentiationMode, diffDecl, diffSymbolTable, beforeActiv, afterActiv, afterReqX, beforeAvlX, declarator, declarationOnly);
                    ILUtils.resetAssignFromInitDecl(declarator);
                    if (diffDeclInit != null) {
                        diffDecl = diffDeclInit;
                    }
                }
                if (resultDiffTypeSpec != null && !containsDimDeclarationS[i - 1] && typeSpecTree != null && typeSpecTree.opCode() == 11) {
                    diffDecl = ILUtils.buildArrayDeclarator(this.adEnv.curUnit().language(), diffDecl, ILUtils.copy(typeSpecTree.down(2)));
                }
                if (diffDecl != null) {
                    tlNewDeclarators = tlNewDeclarators.placdl(diffDecl);
                }
                if (!TapEnv.associationByAddress()) continue;
                toRemoveDecls = new TapList<Tree>(copyInstrInDiff.tree.down(3).down(i), toRemoveDecls);
                continue;
            }
            if (funcDecl == null) continue;
            funcDeclUnit = funcDecl.unit();
            if (funcDeclUnit.origUnit != null) {
                funcDeclUnit = funcDeclUnit.origUnit;
            }
            TapList<ActivityPattern> funcDiffPatterns = this.adEnv.getPatternsForCallingUnitPattern(this.adEnv.curActivity(), funcDeclUnit);
            if (TapEnv.associationByAddress() && this.adEnv.curDiffUnit == this.adEnv.copiedUnits.retrieve(this.adEnv.curUnit())) {
                funcDiffPatterns = null;
            }
            if (funcDeclUnit == this.adEnv.curUnit() && varDecl != null && ((headerTree = this.curDiffUnit().entryBlock().headInstr().tree) == null || ILUtils.getCalledName(headerTree) == null || ILUtils.getCalledName(headerTree).getAnnotation("explicitReturnVar") == null)) {
                funcDiffPatterns = new TapList<ActivityPattern>(this.adEnv.curActivity(), funcDiffPatterns);
            }
            if (TapEnv.associationByAddress() && this.adEnv.copiedUnits.retrieve(funcDeclUnit) != null) {
                toRemoveDecls = new TapList<Tree>(copyInstrInDiff.tree.down(3).down(i), toRemoveDecls);
                Unit funcDiffUnit = this.adEnv.copiedUnits.retrieve(funcDeclUnit);
                Tree diffDecl2 = ILUtils.copy(varTree);
                diffDecl2.setAnnotation("isFunctionName", Boolean.TRUE);
                diffDecl2 = this.copyAndAdaptDeclarator(declarator, diffDecl2, funcDiffUnit, diffSymbolTable);
                WrapperTypeSpec primalCopyResultTypeSpec = funcDiffUnit.functionTypeSpec().returnType;
                Tree primalDeclarationTree = this.buildDiffVarDeclarationTree(diffSymbolTable, primalCopyResultTypeSpec, primalCopyResultTypeSpec, null, new TapList<Tree>(diffDecl2, null), this.removeDuplicateModifiers(modifiers, primalCopyResultTypeSpec), null);
                Instruction primalDeclarationInstruction = new Instruction(primalDeclarationTree);
                primalDeclarationInstruction.isDifferentiated = true;
                toNewPrimalDeclarations.placdl(primalDeclarationInstruction);
            }
            while (funcDiffPatterns != null) {
                ActivityPattern curCalledPattern = (ActivityPattern)funcDiffPatterns.head;
                UnitDiffInfo diffInfo = this.callGraphDifferentiator().getUnitDiffInfo(funcDeclUnit);
                int curDiffMode = this.curDiffUnitSort() == 2 && funcDeclUnit.mustDifferentiateSplit() ? adjointSplitMode : this.curDiffUnitSort();
                if (curCalledPattern != null && curCalledPattern.isContext() && adjointSplitMode == 3) {
                    curDiffMode = 2;
                }
                Unit funcDiffUnit = null;
                if (diffInfo != null) {
                    diffDecl = null;
                    if (curDiffMode != 0 && (funcDiffUnit = diffInfo.getDiffForModeAndActivity(curDiffMode, curCalledPattern)) != null) {
                        boolean forceAddNewDeclaration;
                        newSH = funcDecl.getDiffSymbolHolder(curDiffMode, curCalledPattern, 0);
                        boolean bl = forceAddNewDeclaration = declarator.opCode() == 90 && (newSH == null || newSH.instruction() == null || this.adEnv.curInstruction().fromInclude() != null);
                        if (forceAddNewDeclaration || funcDiffUnit.functionTypeSpec() != null && !TypeSpec.isA(funcDiffUnit.functionTypeSpec().returnType, 9)) {
                            diffDecl = this.varRefDifferentiator().diffSymbolName(curCalledPattern, varName, diffSymbolTable, false, true, false, tree, null, false, curDiffMode, curDiffMode, 1, null);
                        }
                    }
                    if (diffDecl != null) {
                        newSH = NewSymbolHolder.getNewSymbolHolder(ILUtils.baseTree(diffDecl));
                        if (newSH != null) {
                            newSH.setVarDeclTreeAlreadyPlacedFor(diffSymbolTable);
                            newSH.setInstruction(instructionResult);
                            if (diffSymbolDecl == null) {
                                diffSymbolDecl = newSH.newFunctionDecl();
                            }
                        }
                        diffDecl.setAnnotation("isFunctionName", Boolean.TRUE);
                        diffDecl = this.copyAndAdaptDeclarator(declarator, diffDecl, funcDiffUnit, diffSymbolTable);
                        tlNewDeclarators = tlNewDeclarators.placdl(diffDecl);
                        if (funcDiffUnit.functionTypeSpec() != null) {
                            resultDiffTypeSpec = funcDiffUnit.functionTypeSpec().returnType;
                            if (varDecl == null && funcDecl != null && funcDecl.unit().isFortran() && TypeSpec.isA(resultDiffTypeSpec, 2)) {
                                resultDiffTypeSpec = resultDiffTypeSpec.wrappedType.elementType();
                            }
                            modifiers = ILUtils.removeSizeModifiers(modifiers);
                        }
                        if (funcDiffUnit.getForwardDeclaration() == null) {
                            funcDiffUnit.setForwardDeclaration(instructionResult);
                        }
                    }
                }
                funcDiffPatterns = funcDiffPatterns.tail;
            }
        }
        modifiers = this.removeDuplicateModifiers(modifiers, diffTypeSpec);
        Tree diffVarDeclarationTree = null;
        if (hdNewDeclarators.tail != null) {
            diffVarDeclarationTree = this.buildDiffVarDeclarationTree(diffSymbolTable, typeSpec, resultDiffTypeSpec == null ? diffTypeSpec : resultDiffTypeSpec, proposedDiffTypeTree, hdNewDeclarators.tail, modifiers, diffSymbolDecl);
        }
        if (diffVarDeclarationTree != null) {
            instructionResult.tree = diffVarDeclarationTree;
            instructionResult.isDifferentiated = true;
        }
        while (origAccessChecks != null) {
            BlockDifferentiator.checkAccessModifiers(copyInstrInDiff.tree, (AccessCheck)origAccessChecks.head, block, diffSymbolTable, true, differentiationMode);
            origAccessChecks = origAccessChecks.tail;
        }
        while (diffAccessChecks != null) {
            BlockDifferentiator.checkAccessModifiers(instructionResult.tree, (AccessCheck)diffAccessChecks.head, block, diffSymbolTable, false, differentiationMode);
            diffAccessChecks = diffAccessChecks.tail;
        }
        if (instructionResult.tree == null || ILUtils.isNullOrEmptyList(instructionResult.tree.down(3))) {
            instructionResult = null;
        }
        if (toRemoveDecls != null) {
            this.removeDecl(toRemoveDecls);
            if (ILUtils.isNullOrEmptyList(copyInstrInDiff.tree.down(3))) {
                copyInstrInDiff.tree = ILUtils.build(138);
            }
        }
        return diffVarDeclarationTree == null ? null : instructionResult;
    }

    private Tree copyAndAdaptDeclarator(Tree declarator, Tree newDecl, Unit funcDiffUnit, SymbolTable diffSymbolTable) {
        while (declarator.opCode() == 153) {
            declarator = declarator.down(1);
        }
        if (declarator.opCode() == 90) {
            Tree diffCallTypedTree;
            Tree newFunDecl = ILUtils.copy(declarator);
            newFunDecl.setChild(newDecl, 1);
            SymbolTable argsListSymbolTable = funcDiffUnit.publicSymbolTable();
            if (argsListSymbolTable == null) {
                argsListSymbolTable = diffSymbolTable;
            }
            if ((diffCallTypedTree = ILUtils.build(8, funcDiffUnit.generateHeaderParamsList(argsListSymbolTable))).length() != 0) {
                newFunDecl.setChild(diffCallTypedTree, 2);
            } else {
                newFunDecl.setChild(ILUtils.build(138), 2);
            }
            return newFunDecl;
        }
        return newDecl;
    }

    private boolean isCurUnitReturn(FunctionDecl funcDecl) {
        return funcDecl.unit() != null && funcDecl.unit().origUnit == this.curDiffUnit().origUnit;
    }

    private static void checkAccessModifiers(Tree declaration, AccessCheck accessToCheck, Block inDiffBlock, SymbolTable diffSymbolTable, boolean onPrimalDecl, int diffMode) {
        boolean declRemoved = false;
        VariableDecl varDecl = accessToCheck.decl;
        VariableDecl origVarDecl = accessToCheck.primalDecl;
        if (diffMode == -1 || diffMode == -2) {
            TapList<String> extraInfo = origVarDecl.extraInfo();
            TapList.replaceExtraInfoValue(extraInfo, "out", "inout");
            origVarDecl.setExtraInfo(extraInfo);
        }
        if (declaration != null) {
            if (declaration.down(3).length() == 1) {
                Instruction instr;
                if (!onPrimalDecl && origVarDecl.hasOtherInstruction()) {
                    declaration.setChild(varDecl.type().generateTree(diffSymbolTable, null, null, true, null), 2);
                }
                TapList<Tree> extraModifiers = null;
                TapList<String> extraInfo = varDecl.extraInfo();
                while (extraInfo != null) {
                    String extraModifier = (String)extraInfo.head;
                    if (!(extraModifier.equals("save") && origVarDecl.hasInstructionWithRootOperator(171, null) || ILUtils.contains(declaration, 130, extraModifier) != null || diffMode == -1 && extraModifier.equals("out") || onPrimalDecl && (!extraModifier.equals("out") || origVarDecl.hasOtherInstruction()))) {
                        extraModifiers = new TapList<Tree>(ILUtils.build(96, extraModifier), extraModifiers);
                    }
                    extraInfo = extraInfo.tail;
                }
                if (extraModifiers != null) {
                    declaration.setChild(ILUtils.build(129, ILUtils.build(130, TapList.reverse(extraModifiers)), declaration.cutChild(2)), 2);
                }
                if (declaration.down(2).opCode() == 129) {
                    if (ILUtils.containsModifier("out", declaration, false) && (diffMode == -1 || !TapList.containsEquals(varDecl.extraInfo(), "out"))) {
                        ILUtils.peelModifier(declaration, "out");
                    } else if (ILUtils.containsModifier("in", declaration, false) && !TapList.containsEquals(varDecl.extraInfo(), "in")) {
                        ILUtils.peelModifier(declaration, "in");
                    } else if (ILUtils.containsModifier("inout", declaration, false) && !TapList.containsEquals(varDecl.extraInfo(), "inout")) {
                        ILUtils.peelModifier(declaration, "inout");
                    } else if (ILUtils.containsModifier("constant", declaration, false) && !TapList.containsEquals(varDecl.extraInfo(), "constant")) {
                        ILUtils.peelModifier(declaration, "constant");
                    } else if (ILUtils.containsModifier("const", declaration, true) && !varDecl.isCconst()) {
                        ILUtils.peelModifier(declaration, "const");
                    }
                }
                if (!TapList.containsEquals(origVarDecl.extraInfo(), "out") && origVarDecl.hasInstructionWithRootOperator(2, "out") && (instr = inDiffBlock.getOperatorDeclarationInstruction(varDecl, 2, diffSymbolTable)) != null) {
                    instr.tree = ILUtils.build(138);
                }
            } else {
                if (declaration.down(2).opCode() != 129 && varDecl.extraInfo() != null) {
                    String modifier = (String)varDecl.extraInfo().head;
                    if (TapEnv.relatedUnit() == inDiffBlock.unit() && !varDecl.hasInstructionWithRootOperator(2, modifier)) {
                        BlockDifferentiator.removeDeclFromInstruction(varDecl, declaration);
                        declRemoved = true;
                    }
                } else if (declaration.down(2).opCode() == 129 && ILUtils.containsModifier("out", declaration, false) && !TapList.containsEquals(varDecl.extraInfo(), "out")) {
                    ILUtils.peelModifier(declaration, "out");
                }
                if (declaration.down(2).opCode() == 129 && ILUtils.containsModifier("optional", declaration, false) && !TapList.containsEquals(varDecl.extraInfo(), "optional")) {
                    BlockDifferentiator.removeDeclFromInstruction(varDecl, declaration);
                    declRemoved = true;
                    declaration = null;
                } else if (declaration.down(2).opCode() == 129 && ILUtils.containsModifier("constant", declaration, false) && !TapList.containsEquals(varDecl.extraInfo(), "constant")) {
                    BlockDifferentiator.removeDeclFromInstruction(varDecl, declaration);
                    declRemoved = true;
                    declaration = null;
                } else if (declaration.down(2).opCode() == 129 && ILUtils.containsModifier("const", declaration, true) && !varDecl.isCconst()) {
                    BlockDifferentiator.removeDeclFromInstruction(varDecl, declaration);
                    declRemoved = true;
                    declaration = null;
                }
            }
            if (accessToCheck.isLocalDeclared && declaration != null && declaration.down(2).opCode() == 129) {
                varDecl.formalArgRank = -2;
                if (declaration.down(3).length() == 1) {
                    if (!onPrimalDecl) {
                        Tree[] originalModifiers = declaration.down(2).down(1).children();
                        TapList<Tree> remainingModifiers = null;
                        for (int i = originalModifiers.length - 1; i >= 0; --i) {
                            if (ILUtils.isIdentOf(originalModifiers[i], new String[]{"in", "out", "inout", "constant", "const", "optional"}, false)) continue;
                            remainingModifiers = new TapList<Tree>(originalModifiers[i], remainingModifiers);
                        }
                        if (remainingModifiers == null) {
                            declaration.setChild(ILUtils.copy(declaration.down(2).down(2)), 2);
                        } else {
                            declaration.down(2).setChild(ILUtils.build(130, remainingModifiers), 1);
                        }
                    }
                } else {
                    BlockDifferentiator.removeDeclFromInstruction(varDecl, declaration);
                    declRemoved = true;
                }
            }
        }
        if (declRemoved && accessToCheck.newSH != null) {
            accessToCheck.newSH.setInstruction(null);
        }
    }

    private static void removeDeclFromInstruction(VariableDecl varDecl, Tree declaration) {
        int rankDecl = 0;
        NewSymbolHolder varSymbolHolder = null;
        for (int i = 1; i <= declaration.down(3).length() && rankDecl == 0; ++i) {
            Tree curDecl = ILUtils.baseTree(declaration.down(3).down(i));
            assert (curDecl != null);
            if (curDecl.opCode() != 96 || !curDecl.stringValue().equals(varDecl.symbol)) continue;
            varSymbolHolder = NewSymbolHolder.getNewSymbolHolder(curDecl);
            rankDecl = i;
        }
        if (rankDecl > 0) {
            declaration.down(3).removeChild(rankDecl);
            if (varSymbolHolder != null) {
                varSymbolHolder.setVarDeclTreeNotAlreadyPlaced();
            }
        }
        varDecl.setNullInstruction();
    }

    private Tree[] removeDuplicateModifiers(Tree[] modifiers, TypeSpec existingTypeSpec) {
        Tree[] keptTrees = null;
        if (modifiers != null) {
            int i;
            Tree presentModifier = null;
            if (TypeSpec.isA(existingTypeSpec, 5)) {
                TypeSpec insideDiffType = existingTypeSpec;
                while (insideDiffType instanceof WrapperTypeSpec) {
                    insideDiffType = ((WrapperTypeSpec)insideDiffType).wrappedType;
                }
                presentModifier = ((ModifiedTypeSpec)insideDiffType).sizeModifier;
            }
            TapList<Tree> keptModifiers = null;
            for (i = modifiers.length - 1; i >= 0; --i) {
                if (presentModifier != null && modifiers[i].equalsTree(presentModifier)) continue;
                keptModifiers = new TapList<Tree>(modifiers[i], keptModifiers);
            }
            if (keptModifiers != null) {
                keptTrees = new Tree[TapList.length(keptModifiers)];
                for (i = 0; i < keptTrees.length; ++i) {
                    keptTrees[i] = (Tree)keptModifiers.head;
                    keptModifiers = keptModifiers.tail;
                }
            }
        }
        return keptTrees;
    }

    private Tree buildDiffVarDeclarationTree(SymbolTable diffSymbolTable, WrapperTypeSpec typeSpec, WrapperTypeSpec diffTypeSpec, Tree proposedDiffTypeTree, TapList<Tree> newDeclarators, Tree[] modifiers, SymbolDecl diffSymbolDecl) {
        Tree diffTypeTree = ILUtils.isNullOrNone(proposedDiffTypeTree) ? this.genDiffTypeTree(diffSymbolTable, typeSpec, diffTypeSpec, modifiers) : ILUtils.copy(proposedDiffTypeTree);
        if (this.curDiffUnitSort() == 2 || !TapEnv.doActivity()) {
            diffTypeTree = ILUtils.peelInOutConstValueModifier(diffTypeTree);
        }
        diffTypeTree = ILUtils.peelConstModifier(diffTypeTree);
        Tree diffVarDeclarationTree = ILUtils.build(199, ILUtils.build(130), diffTypeTree, ILUtils.build(54, newDeclarators));
        NewSymbolHolder annot = NewSymbolHolder.getNewSymbolHolder(diffTypeTree);
        if (annot != null && diffSymbolDecl != null) {
            TypeDecl diffTypeDecl = annot.newTypeDecl();
            diffSymbolDecl.dependsOn = new TapList<SymbolDecl>(diffTypeDecl, diffSymbolDecl.dependsOn);
        }
        return diffVarDeclarationTree;
    }

    protected boolean mixedLanguage(FunctionDecl funcDecl) {
        return funcDecl != null && funcDecl.unit() != null && (this.adEnv.curUnit() == null && funcDecl.unit().isFortran() || this.adEnv.curUnit() != null && funcDecl.unit().language() != this.adEnv.curUnit().language());
    }

    private Tree differentiateTypeDeclaration(SymbolTable diffSymbolTable, Tree tree) {
        WrapperTypeSpec diffTypeSpec;
        Instruction instructionResult = new Instruction(ILUtils.build(138));
        Tree result = null;
        Tree typeNameTree = tree.down(1);
        TypeDecl typeDecl = null;
        if (!ILUtils.isNullOrNone(typeNameTree)) {
            typeDecl = diffSymbolTable.getTypeDecl(ILUtils.getIdentString(typeNameTree));
        } else if (!ILUtils.isNullOrNone(tree.down(2).down(1))) {
            typeDecl = diffSymbolTable.getTypeDecl("struct " + ILUtils.getIdentString(tree.down(2).down(1)));
        }
        if (!(typeDecl == null || !typeDecl.isATrueSymbolDecl || !this.multiDirMode() && !typeDecl.typeSpec.needsADiffType(null) || !typeDecl.typeSpec.isDifferentiated(null) || (diffTypeSpec = typeDecl.typeSpec.differentiateTypeSpecMemo(diffSymbolTable, this.adEnv.curSymbolTable(), this.curDiffUnitSort(), this.suffixes()[this.curDiffUnitSort()][3], false, this.multiDirMode(), this.varRefDifferentiator().getMultiDirDimensionMax(), typeDecl.symbol, typeDecl.symbol, ILUtils.build(96, typeDecl.symbol), null)) == null || diffTypeSpec.equalsCompilDep(typeDecl.typeSpec) || TypeSpec.isA(diffTypeSpec, 21) && ((CompositeTypeSpec)diffTypeSpec.wrappedType).isEmpty())) {
            Tree diffTypeNameTree;
            diffTypeSpec.wrappedType.diffFromTypeDecl = typeDecl;
            Tree diffTypeSpecTree = diffTypeSpec.wrappedType.generateTree(diffSymbolTable, null, null, false, null);
            NewSymbolHolder diffTypeSymbolHolder = typeDecl.typeSpec.wrappedType.diffTypeDeclSymbolHolder;
            if (diffTypeSymbolHolder == null) {
                diffTypeSymbolHolder = typeDecl.getDiffSymbolHolder(0, null, 0);
            }
            if (diffTypeSymbolHolder != null) {
                diffTypeNameTree = diffTypeSymbolHolder.makeNewRef(diffSymbolTable);
                diffTypeSymbolHolder.setTypeDeclTreeAlreadyPlacedFor(diffSymbolTable);
                diffTypeSymbolHolder.setInstruction(instructionResult);
                diffTypeSymbolHolder.newTypeDecl().setInstruction(instructionResult);
            } else {
                String diffTypeName = diffTypeSpec.wrappedType.typeDeclName();
                if (diffTypeName == null) {
                    diffTypeName = TapEnv.extendStringWithSuffix(typeDecl.symbol, this.suffixes()[this.curDiffUnitSort()][3]);
                }
                diffTypeNameTree = ILUtils.build(96, diffTypeName);
            }
            if (diffTypeSpecTree.opCode() == 161 && diffTypeSpecTree.down(1).opCode() == 138 && typeDecl.symbol.startsWith("struct ")) {
                diffTypeSpecTree.setChild(diffTypeNameTree, 1);
                diffTypeNameTree = ILUtils.copy(diffTypeNameTree);
            }
            if (ILUtils.isNullOrNone(typeNameTree)) {
                diffTypeNameTree = ILUtils.build(138);
            }
            if (tree.down(2).opCode() == 161 && ILUtils.isNullOrNoneOrEmptyList(tree.down(2).down(3))) {
                diffTypeSpecTree.setChild(ILUtils.build(138), 3);
            }
            result = ILUtils.build(192, diffTypeNameTree, diffTypeSpecTree);
        }
        if (result != null) {
            instructionResult.tree = result;
        }
        return result;
    }

    private Tree differentiateUseDeclaration(Tree diffTree, SymbolTable diffSymbolTable) {
        block21: {
            Unit diffModule;
            Unit origModule;
            String moduleName = ILUtils.getIdentString(diffTree.down(1));
            FunctionDecl moduleDecl = this.adEnv.curSymbolTable().getModuleDecl(moduleName);
            if (this.adEnv.traceCurBlock != 0) {
                TapEnv.printlnOnTrace(" Differentiating use declaration: " + ILUtils.toString(diffTree, this.adEnv.curActivity()));
                TapEnv.printlnOnTrace("    moduleDecl:" + moduleDecl + " found in " + this.adEnv.curSymbolTable());
            }
            if (moduleDecl == null || (origModule = moduleDecl.unit()).isPredefinedModuleOrTranslationUnit() || (diffModule = this.callGraphDifferentiator().getUnitDiffInfo(origModule).getDiff()) == null || !diffModule.isDiffPackage().booleanValue()) break block21;
            Tree diffModuleName = this.varRefDifferentiator().diffSymbolName(null, moduleName, this.curDiffUnit().privateSymbolTable(), false, false, true, null, null, false, 1, 1, 2, null);
            diffTree.setChild(diffModuleName, 1);
            Tree restrictionsTree = diffTree.down(2);
            if (ILUtils.isNullOrNone(restrictionsTree)) break block21;
            Tree[] onlyVisibleTrees = restrictionsTree.children();
            TapList<Tree> diffOnlyVisibleTrees = null;
            Tree diffRemoteExpr = null;
            Tree diffLocalName = null;
            for (int i = onlyVisibleTrees.length; i > 0; --i) {
                Tree onlyVisibleTree;
                block22: {
                    SymbolDecl localSymbolDecl;
                    Tree localName;
                    Tree remoteExpr;
                    block25: {
                        block24: {
                            block23: {
                                NewSymbolHolder typeDeclSH;
                                WrapperTypeSpec typeSpec;
                                WrapperTypeSpec diffTypeSpec;
                                boolean isRenamed;
                                onlyVisibleTree = restrictionsTree.cutChild(i);
                                boolean bl = isRenamed = onlyVisibleTree.opCode() == 165;
                                if (isRenamed) {
                                    remoteExpr = onlyVisibleTree.down(2);
                                    localName = onlyVisibleTree.down(1);
                                } else {
                                    remoteExpr = onlyVisibleTree;
                                    localName = onlyVisibleTree;
                                }
                                localSymbolDecl = localName.opCode() == 96 ? this.curDiffUnit().publicSymbolTable().getSymbolDecl(ILUtils.baseName(localName)) : (!localName.isAtom() && localName.down(1).opCode() == 138 ? this.curDiffUnit().publicSymbolTable().getSymbolDecl(ILUtils.baseName(localName)) : null);
                                if (localSymbolDecl == null) break block22;
                                if (!localSymbolDecl.isA(4)) break block23;
                                if (!localSymbolDecl.isActiveSymbolDecl() || (diffTypeSpec = (typeSpec = ((TypeDecl)localSymbolDecl).type()).differentiateTypeSpecMemo(diffSymbolTable, this.adEnv.curSymbolTable(), this.curDiffUnitSort(), this.suffixes()[this.curDiffUnitSort()][3], false, this.multiDirMode(), this.varRefDifferentiator().getMultiDirDimensionMax(), ILUtils.baseName(localName), ILUtils.baseName(localName), localName, null)) == null) break block22;
                                ((TypeDecl)localSymbolDecl).activeTypeDecl(diffSymbolTable, diffTypeSpec, this.suffixes()[this.curDiffUnitSort()][3]);
                                TypeDecl remoteTypeDecl = (TypeDecl)localSymbolDecl;
                                if (isRenamed) {
                                    remoteTypeDecl = (TypeDecl)remoteTypeDecl.importedFrom.first;
                                }
                                if ((typeDeclSH = remoteTypeDecl.getDiffSymbolHolder(0, null, 0)) != null) {
                                    diffRemoteExpr = typeDeclSH.makeNewRef(diffModule.publicSymbolTable());
                                }
                                NewSymbolHolder sHolder = localSymbolDecl.getDiffSymbolHolder(0, null, 0);
                                diffLocalName = null;
                                if (sHolder != null) {
                                    diffLocalName = sHolder.makeNewRef(this.curDiffUnit().publicSymbolTable());
                                    if (isRenamed && typeDeclSH != null) {
                                        if (sHolder.newTypeDecl().importedFrom == null) {
                                            sHolder.newTypeDecl().importedFrom = new TapPair<Object, Object>(null, null);
                                        }
                                        sHolder.newTypeDecl().importedFrom.first = remoteTypeDecl.getDiffSymbolHolder(0, null, 0).newTypeDecl();
                                    }
                                } else if (typeDeclSH != null) {
                                    diffLocalName = ILUtils.build(96, TapEnv.extendStringWithSuffix(ILUtils.baseName(localName), this.suffixes()[this.curDiffUnitSort()][3]));
                                }
                                if (diffLocalName == null) break block22;
                                if (remoteExpr != localName) {
                                    diffLocalName = ILUtils.build(165, diffLocalName, diffRemoteExpr);
                                }
                                diffOnlyVisibleTrees = new TapList<Tree>(diffLocalName, diffOnlyVisibleTrees);
                                break block22;
                            }
                            if (localSymbolDecl != null && !localSymbolDecl.isA(1) && (TapEnv.doActivity() || !localSymbolDecl.isA(5))) break block24;
                            if (!localSymbolDecl.isActiveSymbolDecl()) break block22;
                            diffRemoteExpr = this.varRefDifferentiator().diffSymbolTree(this.adEnv.curActivity(), remoteExpr, diffModule.publicSymbolTable(), true, false, false, onlyVisibleTree, false, this.curDiffVarSort(), this.curDiffUnitSort(), 0, null);
                            diffLocalName = this.varRefDifferentiator().diffSymbolTree(this.adEnv.curActivity(), localName, this.curDiffUnit().publicSymbolTable(), true, false, false, onlyVisibleTree, false, this.curDiffVarSort(), this.curDiffUnitSort(), 0, null);
                            if (diffLocalName == null) break block22;
                            if (remoteExpr != localName) {
                                diffLocalName = ILUtils.build(165, diffLocalName, diffRemoteExpr);
                            }
                            diffOnlyVisibleTrees = new TapList<Tree>(diffLocalName, diffOnlyVisibleTrees);
                            break block22;
                        }
                        if (!localSymbolDecl.isA(16)) break block25;
                        if (!localSymbolDecl.isActiveSymbolDecl() && !((InterfaceDecl)localSymbolDecl).mustHaveADiff(this.activityAnalyzer())) break block22;
                        diffRemoteExpr = this.varRefDifferentiator().diffSymbolTree(this.adEnv.curActivity(), remoteExpr, diffModule.publicSymbolTable(), false, true, false, onlyVisibleTree, false, this.curDiffVarSort(), this.curDiffUnitSort(), 1, null);
                        diffLocalName = this.varRefDifferentiator().diffSymbolTree(this.adEnv.curActivity(), localName, this.curDiffUnit().publicSymbolTable(), false, true, false, onlyVisibleTree, false, this.curDiffVarSort(), this.curDiffUnitSort(), 1, null);
                        if (diffLocalName == null) break block22;
                        if (remoteExpr != localName) {
                            diffLocalName = ILUtils.build(165, diffLocalName, diffRemoteExpr);
                        }
                        diffOnlyVisibleTrees = new TapList<Tree>(diffLocalName, diffOnlyVisibleTrees);
                        break block22;
                    }
                    if (localSymbolDecl.isA(3)) {
                        Unit calledUnit = ((FunctionDecl)localSymbolDecl).unit();
                        if (calledUnit.origUnit != null) {
                            calledUnit = calledUnit.origUnit;
                        }
                        TapList<ActivityPattern> patternsCalledHere = BlockDifferentiator.patternsCalledByPattern(calledUnit, this.adEnv.curActivity());
                        while (patternsCalledHere != null) {
                            ActivityPattern calledPattern = (ActivityPattern)patternsCalledHere.head;
                            if (this.callGraphDifferentiator().patternCreatesDiffCode(calledPattern, calledUnit)) {
                                diffRemoteExpr = this.varRefDifferentiator().diffSymbolTree(calledPattern, remoteExpr, diffModule.publicSymbolTable(), false, true, false, onlyVisibleTree, false, this.curDiffVarSort(), this.curDiffUnitSort(), 1, null);
                                diffLocalName = this.varRefDifferentiator().diffSymbolTree(calledPattern, localName, this.curDiffUnit().publicSymbolTable(), false, true, false, onlyVisibleTree, false, this.curDiffVarSort(), this.curDiffUnitSort(), 1, null);
                                if (diffLocalName != null) {
                                    if (remoteExpr != localName) {
                                        diffLocalName = ILUtils.build(165, diffLocalName, diffRemoteExpr);
                                    }
                                    diffOnlyVisibleTrees = new TapList<Tree>(diffLocalName, diffOnlyVisibleTrees);
                                }
                            }
                            patternsCalledHere = patternsCalledHere.tail;
                        }
                    }
                }
                diffOnlyVisibleTrees = new TapList<Tree>(onlyVisibleTree, diffOnlyVisibleTrees);
            }
            diffTree.setChild(ILUtils.build(restrictionsTree.opCode(), diffOnlyVisibleTrees), 2);
        }
        if (this.adEnv.traceCurBlock != 0) {
            TapEnv.printlnOnTrace(" --> Differentiated use declaration: " + ILUtils.toString(diffTree, this.adEnv.curActivity()));
        }
        return diffTree;
    }

    private boolean mustDifferentiateInterfaceSplit(Tree tree) {
        boolean result = false;
        for (int i = tree.down(2).length(); i > 0; --i) {
            Unit interfaceUnit;
            Unit diffInterfaceUnit;
            FunctionDecl functionDecl;
            TapList<FunctionDecl> functionDecls;
            String interfaceUnitName;
            if (tree.down(2).down(i).opCode() == 105) {
                Tree interfaceFunction = tree.down(2).down(i).down(1);
                interfaceUnitName = ILUtils.getUnitName(interfaceFunction);
                if (interfaceUnitName == null || interfaceUnitName.startsWith("pushPointer") || interfaceUnitName.startsWith("popPointer") || interfaceUnitName.startsWith("lookPointer")) continue;
                functionDecls = this.adEnv.curSymbolTable().getFunctionDecl(interfaceUnitName, null, null, false);
                FunctionDecl functionDecl2 = functionDecl = functionDecls == null ? null : (FunctionDecl)functionDecls.head;
                if (functionDecl == null || (diffInterfaceUnit = this.adEnv.getDiffOfUnit(interfaceUnit = functionDecl.unit(), this.adEnv.curActivity(), this.curDiffUnitSort())) != null || !interfaceUnit.mustDifferentiateSplit()) continue;
                result = true;
                continue;
            }
            if (tree.down(2).down(i).opCode() != 132) continue;
            Tree[] moduleNames = tree.down(2).down(i).children();
            for (int j = moduleNames.length - 1; j >= 0; --j) {
                interfaceUnitName = ILUtils.getIdentString(moduleNames[j]);
                functionDecls = this.adEnv.curSymbolTable().getFunctionDecl(interfaceUnitName, null, null, false);
                if (functionDecls == null) continue;
                functionDecl = (FunctionDecl)functionDecls.head;
                assert (functionDecl != null);
                interfaceUnit = functionDecl.unit();
                diffInterfaceUnit = this.adEnv.getDiffOfUnit(interfaceUnit, this.adEnv.curActivity(), this.curDiffUnitSort());
                if (this.callGraphDifferentiator().unitsHaveDiff.retrieve(interfaceUnit) != Boolean.TRUE && (!TapEnv.mustContext() || !interfaceUnit.isAContext()) || diffInterfaceUnit != null || !interfaceUnit.mustDifferentiateSplit()) continue;
                result = true;
            }
        }
        return result;
    }

    private Tree differentiateInterfaceDeclaration(Tree tree, int interfaceDiffMode, Block block, SymbolTable diffSymbolTable, Instruction copyInstrInDiff, TapList<Unit> differentiatedInterfaces) {
        if (this.adEnv.traceCurBlock != 0) {
            TapEnv.printlnOnTrace(" Differentiating interface declaration ");
            TapEnv.printlnOnTrace("      " + ILUtils.toString(tree, this.adEnv.curActivity()));
            TapEnv.printlnOnTrace("      for activity " + this.adEnv.curActivity() + ", in mode " + interfaceDiffMode);
        }
        int origLanguage = block.symbolTable.unit.language();
        TapList<Tree> diffInterfaces = null;
        TapList<Object> diffNSHlist = null;
        copyInstrInDiff.tree = ILUtils.copy(copyInstrInDiff.tree);
        this.updateModulesAndCopiedUnitsInCopiedInterface(copyInstrInDiff.tree, diffSymbolTable, 0);
        TapList<Object> generatedDiffInterfaces = differentiatedInterfaces.tail;
        for (int i = tree.down(2).length(); i > 0; --i) {
            Unit diffInterfaceUnit;
            ActivityPattern patternAround;
            Unit interfaceUnit;
            FunctionDecl functionDecl;
            TapList<FunctionDecl> functionDecls;
            String interfaceUnitName;
            Tree interfaceElement = tree.down(2).down(i);
            if (interfaceElement.opCode() == 105) {
                Tree interfaceFunction = interfaceElement.down(1);
                interfaceUnitName = ILUtils.getUnitName(interfaceFunction);
                if (!(interfaceUnitName == null || interfaceUnitName.startsWith("pushPointer") || interfaceUnitName.startsWith("popPointer") || interfaceUnitName.startsWith("lookPointer"))) {
                    functionDecls = this.adEnv.curSymbolTable().getFunctionDecl(interfaceUnitName, null, null, false);
                    FunctionDecl functionDecl2 = functionDecl = functionDecls == null ? null : (FunctionDecl)functionDecls.head;
                    if (functionDecl != null) {
                        TapList<TapPair<ActivityPattern, Unit>> patternsAndUnitsCalledHere;
                        interfaceUnit = functionDecl.unit();
                        UnitDiffInfo interfaceUnitInfo = this.callGraphDifferentiator().getUnitDiffInfo(interfaceUnit);
                        if (interfaceUnitInfo == null) {
                            TapEnv.toolError("Empty diff info on interface Unit " + interfaceUnit + " on " + ILUtils.toString(interfaceElement));
                            patternsAndUnitsCalledHere = null;
                        } else if (this.adEnv.curActivity() != null && this.adEnv.curActivity().isDisconnected()) {
                            patternsAndUnitsCalledHere = interfaceUnitInfo.getAllDiffPatternsAndUnits(interfaceDiffMode);
                        } else if (this.adEnv.curActivity() == null) {
                            patternsAndUnitsCalledHere = interfaceUnitInfo.getAllDiffPatternsAndUnits(interfaceDiffMode);
                            if (interfaceDiffMode == 2) {
                                patternsAndUnitsCalledHere = TapList.append(patternsAndUnitsCalledHere, interfaceUnitInfo.getAllDiffPatternsAndUnits(3));
                                patternsAndUnitsCalledHere = TapList.append(patternsAndUnitsCalledHere, interfaceUnitInfo.getAllDiffPatternsAndUnits(4));
                            }
                        } else {
                            TapList<ActivityPattern> patternsCalledHere = BlockDifferentiator.patternsCalledByPattern(interfaceUnit, this.adEnv.curActivity());
                            if (patternsCalledHere == null) {
                                patternsAndUnitsCalledHere = null;
                            } else {
                                ActivityPattern patternCalledHere = (ActivityPattern)patternsCalledHere.head;
                                Unit diffU = this.adEnv.getDiffOfUnit(interfaceUnit, patternCalledHere, interfaceDiffMode);
                                patternsAndUnitsCalledHere = diffU == null ? null : new TapList<TapPair<ActivityPattern, Unit>>(new TapPair<ActivityPattern, Unit>(patternCalledHere, diffU), null);
                                if (patternsCalledHere.tail != null) {
                                    TapEnv.toolError("There are two or more activity patterns for diff interface " + interfaceUnitName + " called by " + this.adEnv.curActivity());
                                }
                            }
                        }
                        patternAround = this.adEnv.curActivity();
                        if (this.adEnv.traceCurDifferentiation) {
                            TapEnv.printlnOnTrace("   -- differentiating interface of " + interfaceUnitName + " for activities-units " + patternsAndUnitsCalledHere);
                        }
                        while (patternsAndUnitsCalledHere != null) {
                            this.adEnv.setCurActivity((ActivityPattern)((TapPair)patternsAndUnitsCalledHere.head).first);
                            diffInterfaceUnit = (Unit)((TapPair)patternsAndUnitsCalledHere.head).second;
                            Unit oldCurUnit = this.adEnv.curUnit();
                            this.adEnv.setCurUnitEtc(interfaceUnit);
                            this.adEnv.pushCurDiffUnit(diffInterfaceUnit);
                            Tree diffInterfaceNameTree = this.varRefDifferentiator().diffSymbolName(this.adEnv.curActivity(), interfaceUnitName, diffSymbolTable.basisSymbolTable(), false, true, false, interfaceElement, null, false, diffInterfaceUnit.sortOfDiffUnit, diffInterfaceUnit.sortOfDiffUnit, 1, null);
                            boolean mustDiffInterfaceTree = false;
                            if (interfaceDiffMode == 3) {
                                mustDiffInterfaceTree = true;
                            } else if (diffInterfaceUnit != null && (this.callGraphDifferentiator().unitsHaveDiff.retrieve(interfaceUnit) == Boolean.TRUE || TapEnv.mustContext() && interfaceUnit.isAContext())) {
                                mustDiffInterfaceTree = true;
                                NewSymbolHolder diffInterfaceUnitNSH = NewSymbolHolder.getNewSymbolHolder(diffInterfaceNameTree);
                                diffNSHlist = new TapList<NewSymbolHolder>(diffInterfaceUnitNSH, diffNSHlist);
                                if (interfaceDiffMode == 4) {
                                    Tree diffInterfaceNameTreeFWD = this.varRefDifferentiator().diffSymbolName(this.adEnv.curActivity(), interfaceUnitName, diffSymbolTable.basisSymbolTable(), false, true, false, interfaceElement, null, false, 3, 3, 1, null);
                                    diffInterfaceUnitNSH = NewSymbolHolder.getNewSymbolHolder(diffInterfaceNameTreeFWD);
                                    diffNSHlist = new TapList<NewSymbolHolder>(diffInterfaceUnitNSH, diffNSHlist);
                                }
                            }
                            if (mustDiffInterfaceTree && !TapList.contains(generatedDiffInterfaces, diffInterfaceUnit)) {
                                generatedDiffInterfaces = new TapList<Unit>(diffInterfaceUnit, generatedDiffInterfaces);
                                if (this.adEnv.traceCurDifferentiation) {
                                    TapEnv.printlnOnTrace("BUILDDIFFINTERFACETREE " + interfaceElement + " DIFF OF UNIT " + interfaceUnit + " DIFF " + diffInterfaceUnit + " CURUNIT: " + this.adEnv.curUnit());
                                }
                                Tree diffInterfaceTree = this.buildDiffInterfaceTree(interfaceDiffMode, origLanguage, interfaceElement, interfaceUnit, diffInterfaceUnit, diffInterfaceNameTree);
                                if (this.adEnv.traceCurDifferentiation) {
                                    TapEnv.printlnOnTrace("====>DIFFINTERFACETREE " + diffInterfaceTree);
                                }
                                diffInterfaces = new TapList<Tree>(diffInterfaceTree, diffInterfaces);
                            }
                            this.adEnv.setCurUnitEtc(oldCurUnit);
                            this.adEnv.popCurDiffUnit();
                            patternsAndUnitsCalledHere = patternsAndUnitsCalledHere.tail;
                        }
                        this.adEnv.setCurActivity(patternAround);
                    }
                }
                differentiatedInterfaces.tail = generatedDiffInterfaces;
                continue;
            }
            if (interfaceElement.opCode() == 132) {
                Tree[] moduleNames = interfaceElement.children();
                TapList<Tree> diffModuleNames = null;
                for (int j = moduleNames.length - 1; j >= 0; --j) {
                    interfaceUnitName = ILUtils.getIdentString(moduleNames[j]);
                    functionDecls = this.adEnv.curSymbolTable().getFunctionDecl(interfaceUnitName, null, null, false);
                    if (functionDecls == null) continue;
                    functionDecl = (FunctionDecl)functionDecls.head;
                    assert (functionDecl != null);
                    interfaceUnit = functionDecl.unit();
                    UnitDiffInfo interfaceUnitInfo = this.callGraphDifferentiator().getUnitDiffInfo(interfaceUnit);
                    patternAround = this.adEnv.curActivity();
                    TapList<ActivityPattern> patternsCalledHere = this.adEnv.curActivity() == null || this.adEnv.curActivity().isDisconnected() ? interfaceUnitInfo.getAllDiffPatterns(interfaceDiffMode) : BlockDifferentiator.patternsCalledByPattern(interfaceUnit, this.adEnv.curActivity());
                    while (patternsCalledHere != null) {
                        this.adEnv.setCurActivity((ActivityPattern)patternsCalledHere.head);
                        diffInterfaceUnit = this.adEnv.getDiffOfUnit(interfaceUnit, this.adEnv.curActivity(), interfaceDiffMode);
                        if ((this.callGraphDifferentiator().unitsHaveDiff.retrieve(interfaceUnit) == Boolean.TRUE || TapEnv.mustContext() && interfaceUnit.isAContext()) && diffInterfaceUnit != null) {
                            Tree diffInterfaceNameTree = this.varRefDifferentiator().diffSymbolName(this.adEnv.curActivity(), interfaceUnitName, diffSymbolTable.basisSymbolTable(), false, true, false, interfaceElement, null, false, interfaceDiffMode, interfaceDiffMode, 1, null);
                            NewSymbolHolder diffInterfaceUnitNSH = NewSymbolHolder.getNewSymbolHolder(diffInterfaceNameTree);
                            diffNSHlist = new TapList<NewSymbolHolder>(diffInterfaceUnitNSH, diffNSHlist);
                            diffModuleNames = new TapList<Tree>(diffInterfaceNameTree, diffModuleNames);
                        }
                        patternsCalledHere = patternsCalledHere.tail;
                    }
                    this.adEnv.setCurActivity(patternAround);
                }
                if (diffModuleNames == null) continue;
                Tree resulti = ILUtils.build(132, diffModuleNames);
                diffInterfaces = new TapList<Tree>(resulti, diffInterfaces);
                continue;
            }
            TapEnv.toolWarning(-1, "(Differentiating interface declaration) Differentiation of " + ILUtils.toString(interfaceElement, this.adEnv.curActivity()) + " ignored.");
        }
        Tree newDiffInterface = null;
        if (diffInterfaces != null) {
            NewSymbolHolder diffInterfaceUnitNSH;
            Tree diffInterfaceNameTree;
            if (ILUtils.isNullOrNone(tree.down(1))) {
                diffInterfaceNameTree = ILUtils.build(138);
            } else {
                Tree nameTree = tree.down(1);
                if (ILUtils.getIdentString(nameTree) == null) {
                    nameTree = ILUtils.build(96, nameTree.opName());
                }
                diffInterfaceNameTree = this.varRefDifferentiator().diffSymbolTree(this.adEnv.curActivity(), nameTree, diffSymbolTable.basisSymbolTable(), false, true, false, null, false, interfaceDiffMode, interfaceDiffMode, 1, null);
                diffInterfaceUnitNSH = NewSymbolHolder.getNewSymbolHolder(diffInterfaceNameTree);
                diffNSHlist = new TapList<NewSymbolHolder>(diffInterfaceUnitNSH, diffNSHlist);
            }
            newDiffInterface = ILUtils.build(106, diffInterfaceNameTree, ILUtils.build(107, diffInterfaces), ILUtils.build(138));
            this.updateModulesAndCopiedUnitsInCopiedInterface(newDiffInterface, diffSymbolTable, interfaceDiffMode);
            Instruction tmpDiffInstruction = new Instruction(newDiffInterface);
            while (diffNSHlist != null) {
                diffInterfaceUnitNSH = (NewSymbolHolder)diffNSHlist.head;
                if (diffInterfaceUnitNSH != null) {
                    diffInterfaceUnitNSH.setInstruction(tmpDiffInstruction);
                }
                diffNSHlist = diffNSHlist.tail;
            }
        }
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printlnOnTrace("   --> ");
            TapEnv.printlnOnTrace("      " + ILUtils.toString(newDiffInterface, this.adEnv.curActivity()));
        }
        return newDiffInterface;
    }

    private Tree buildDiffInterfaceTree(int interfaceDiffMode, int origLanguage, Tree interfaceFunction, Unit interfaceUnit, Unit diffInterfaceUnit, Tree diffInterfaceNameTree) {
        Tree explicitReturnVar;
        TapList<Object> toDiffTrees;
        Instruction returnInstr;
        Tree returnVarDeclaration;
        Tree varNameTree;
        int j;
        String funcName = this.adEnv.curUnit().name();
        Tree typeSpecTree = this.adEnv.curUnit().functionTypeSpec().returnType.generateTree(diffInterfaceUnit.publicSymbolTable(), null, null, true, null);
        Tree headTree = ILUtils.copy(this.adEnv.curUnit().headTree());
        Tree[] interfaceContents = interfaceFunction.down(1).down(6).children();
        boolean origResultDeclaredInContents = false;
        if (interfaceFunction.down(1).down(5).length() != 0) {
            Tree params = interfaceFunction.down(1).down(5).down(1).down(3);
            assert (headTree != null);
            Tree headTreeVars = headTree.down(3);
            int paramsNb = Math.min(headTreeVars.length(), params.length());
            Tree[] headTreeVar = new Tree[paramsNb];
            String[] paramsVar = new String[paramsNb];
            for (j = 0; j < paramsNb; ++j) {
                headTreeVar[j] = headTreeVars.down(j + 1);
                paramsVar[j] = ILUtils.baseName(params.down(j + 1));
            }
            for (j = interfaceContents.length - 1; j >= 0; --j) {
                if (interfaceContents[j].opCode() != 199) continue;
                if (this.adEnv.curUnit().isAFunction() && ILUtils.declaresVariable(interfaceContents[j], funcName)) {
                    origResultDeclaredInContents = true;
                }
                for (int k = 0; k < paramsNb; ++k) {
                    ILUtils.replaceIdentStringOccurences(interfaceContents[j], paramsVar[k], ILUtils.copy(headTreeVar[k]));
                }
            }
        }
        Tree diffCallTree = this.procedureCallDifferentiator().differentiateProcedureHeader(headTree, null, null, null, diffInterfaceUnit.publicSymbolTable(), this.adEnv.curUnit().publicSymbolTable(), interfaceDiffMode, null);
        diffInterfaceUnit.parametersOrModuleNameTree = ILUtils.getArguments(diffCallTree);
        Tree diffArgs = ILUtils.build(200, diffInterfaceUnit.generateHeaderParamsList(diffInterfaceUnit.publicSymbolTable()));
        if (interfaceUnit.functionTypeSpec() != null && interfaceUnit.functionTypeSpec().variableArgList) {
            diffArgs.addChild(ILUtils.build(203), diffArgs.length() + 1);
        }
        Block blockOfDeclarations = new Block(diffInterfaceUnit.publicSymbolTable(), null, null);
        for (j = interfaceContents.length - 1; j >= 0; --j) {
            blockOfDeclarations.addInstrHd(ILUtils.copy(interfaceContents[j]));
        }
        this.differentiateDeclarationsOfBlock(blockOfDeclarations, interfaceDiffMode, interfaceUnit, interfaceUnit.publicSymbolTable(), diffInterfaceUnit.privateSymbolTable(), origLanguage, true);
        if (diffInterfaceUnit.isAFunction() && interfaceDiffMode == 3) {
            TapList<Instruction> newDeclarations = blockOfDeclarations.instructions;
            while (newDeclarations != null) {
                Tree newDecl = ((Instruction)newDeclarations.head).tree;
                TapList<SymbolDecl> symbolDecls = blockOfDeclarations.symbolDeclDeclared(newDecl, diffInterfaceUnit.publicSymbolTable());
                while (symbolDecls != null) {
                    if (((SymbolDecl)symbolDecls.head).symbol.equals(interfaceUnit.name())) {
                        ILUtils.replaceIdentStringOccurences(newDecl, interfaceUnit.name(), ILUtils.copy(diffInterfaceNameTree));
                    }
                    symbolDecls = symbolDecls.tail;
                }
                newDeclarations = newDeclarations.tail;
            }
        }
        if (this.multiDirMode()) {
            Tree newNbdirsVar = this.varRefDifferentiator().buildDirNumberReference(diffInterfaceUnit.publicSymbolTable());
            Tree newNbdirsDecl = ILUtils.build(199, ILUtils.build(130), this.adEnv.integerTypeSpec.generateTree(null, null, null, true, null), ILUtils.build(54, newNbdirsVar));
            blockOfDeclarations.addInstrTl(newNbdirsDecl);
        }
        boolean[] formalArgsActivity = this.callGraphDifferentiator().getUnitFormalArgsActivityS(this.adEnv.curActivity());
        Tree returnTypeTree = null;
        returnTypeTree = !diffInterfaceUnit.isAFunction() ? ILUtils.build(204) : diffInterfaceUnit.buildReturnTypeTree(null, null, new ToObject<Object>(null), null);
        if (this.adEnv.curUnit().isAFunction() && !origResultDeclaredInContents && formalArgsActivity[formalArgsActivity.length - 1] && (this.adEnv.curActivity().isContext() || this.curDiffUnitSort() != 2) && this.curDiffUnitSort() != 4) {
            varNameTree = ILUtils.build(96, funcName);
            returnVarDeclaration = ILUtils.build(199, ILUtils.build(130), typeSpecTree, ILUtils.build(54, varNameTree));
            returnInstr = new Instruction(returnVarDeclaration);
            blockOfDeclarations.addInstrTl(returnInstr);
        }
        if (this.adEnv.curUnit().isAFunction() && interfaceFunction.down(1).down(2).opCode() != 138 && (this.curDiffUnitSort() != 2 || formalArgsActivity[formalArgsActivity.length - 1]) && ILUtils.isNullOrNoneOrVoid(returnTypeTree)) {
            varNameTree = ILUtils.build(96, funcName);
            if (this.curDiffUnitSort() == 2) {
                varNameTree = interfaceDiffMode == 3 ? this.varRefDifferentiator().diffSymbolName(this.adEnv.curActivity(), funcName, diffInterfaceUnit.publicSymbolTable(), false, true, false, interfaceFunction, null, false, interfaceDiffMode, interfaceDiffMode, 1, null) : this.varRefDifferentiator().diffSymbolName(this.adEnv.curActivity(), funcName, diffInterfaceUnit.publicSymbolTable(), true, false, false, interfaceFunction, null, false, this.curDiffVarSort(), interfaceDiffMode, 1, null);
            }
            returnVarDeclaration = ILUtils.build(199, ILUtils.build(130), ILUtils.copy(typeSpecTree), ILUtils.build(54, varNameTree));
            returnInstr = new Instruction(returnVarDeclaration);
            blockOfDeclarations.addInstrTl(returnInstr);
        }
        TapList<Object> headDiffTrees = toDiffTrees = new TapList<Object>(null, null);
        while (blockOfDeclarations.instructions != null) {
            Instruction instr = (Instruction)blockOfDeclarations.instructions.head;
            toDiffTrees = toDiffTrees.placdl(instr.tree);
            blockOfDeclarations.instructions = blockOfDeclarations.instructions.tail;
        }
        Tree bindTree = (Tree)interfaceFunction.down(1).down(4).getAnnotation("bind");
        Tree diffBindTree = ILUtils.copy(bindTree);
        if (diffBindTree != null) {
            if (diffBindTree.opCode() == 2) {
                Tree[] bindExprs = diffBindTree.down(2).children();
                Tree diffBindNameTree = null;
                for (int i = 0; i < bindExprs.length && diffBindNameTree == null; ++i) {
                    if (bindExprs[i].opCode() != 134 || !ILUtils.isIdent(bindExprs[i].down(1), "name", false)) continue;
                    diffBindNameTree = bindExprs[i];
                }
                if (diffBindNameTree != null) {
                    UnitDiffInfo otherLangDiffInfo;
                    Unit otherLangDiffUnit;
                    Unit otherLangSourceUnit;
                    String otherLangName = diffBindNameTree.down(2).stringValue();
                    TapList<FunctionDecl> otherLangFuncDecls = this.adEnv.srcCallGraph().cRootSymbolTable().getFunctionDecl(otherLangName, null, null, false);
                    Unit unit = otherLangSourceUnit = otherLangFuncDecls == null ? null : ((FunctionDecl)otherLangFuncDecls.head).unit();
                    if (otherLangSourceUnit != null && (otherLangDiffUnit = (otherLangDiffInfo = this.callGraphDifferentiator().getUnitDiffInfo(otherLangSourceUnit)).getDiffForModeAndActivity(interfaceDiffMode, this.adEnv.curActivity())) != null) {
                        Tree diffHead = otherLangDiffUnit.headTree();
                        diffBindNameTree.setChild(ILUtils.copy(ILUtils.getCalledName(diffHead)), 2);
                    }
                }
            }
            diffInterfaceNameTree.setAnnotation("bind", diffBindTree);
        }
        if ((explicitReturnVar = (Tree)ILUtils.getCalledName(diffCallTree).getAnnotation("explicitReturnVar")) != null) {
            diffInterfaceNameTree.setAnnotation("explicitReturnVar", explicitReturnVar);
        }
        diffInterfaceNameTree.setAnnotation("sourceUnit", interfaceUnit);
        return ILUtils.build(105, ILUtils.build(89, ILUtils.copy(interfaceFunction.down(1).down(1)), returnTypeTree, ILUtils.build(138), diffInterfaceNameTree, diffArgs, ILUtils.build(27, headDiffTrees.tail)));
    }

    protected void differentiateDeclarationsOfBlock(Block diffBlock, int differentiationMode, Unit unit, SymbolTable originalST, SymbolTable curDiffST, int origLanguage, boolean forInterface) {
        boolean allDiffModesInside;
        this.adEnv.pushCurSymbolTable(originalST);
        boolean oldCurUnitIsContext = this.adEnv.curUnitIsContext;
        if (unit != null) {
            this.adEnv.pushCurUnitEtc(unit);
            this.adEnv.pushCurVectorMap(DataFlowAnalyzer.makeMap3(0, 0, this.adEnv.curSymbolTable().declaredZonesNb(0)));
            this.adEnv.pushCurDiffVectorMap(DataFlowAnalyzer.makeMap3(0, 0, this.adEnv.curSymbolTable().declaredZonesNb(this.adEnv.diffKind)));
            if (this.adEnv.curUnit().hasParamElemsInfo() && TapEnv.mustContext() && this.adEnv.curActivity() != null) {
                this.adEnv.curUnitIsContext = this.activityAnalyzer().unitIsContext(this.adEnv.curActivity());
            }
        }
        boolean bl = allDiffModesInside = unit == null || unit.isPackage();
        if (TapEnv.assocAddressDiffTypesUnit(3) != null && this.adEnv.curUnit().isFortran()) {
            this.moduleImportsAATypesModule(curDiffST);
        }
        TapList<Instruction> hdDeclarations = new TapList<Instruction>(null, diffBlock.instructions);
        TapList<Instruction> inDeclarations = hdDeclarations;
        TapList<Instruction> newDeclarationsDone = null;
        int previousBlockTraceLevel = this.adEnv.traceCurBlock;
        this.adEnv.traceCurBlock = 0;
        if (this.adEnv.traceCurDifferentiation) {
            this.adEnv.traceCurBlock = 1;
            TapEnv.printlnOnTrace("");
            TapEnv.printlnOnTrace("*** NOW Differentiating Declarations of Block: @" + Integer.toHexString(diffBlock.hashCode()) + " " + diffBlock);
        }
        while (inDeclarations.tail != null) {
            this.adEnv.setCurInstruction((Instruction)inDeclarations.tail.head);
            boolean removePrimalDeclaration = false;
            if (!TapList.contains(newDeclarationsDone, this.adEnv.curInstruction())) {
                TapList<Object> newDeclarations = null;
                Unit definedUnit = this.adEnv.curInstruction().isUnitDefinitionStub();
                if (definedUnit != null) {
                    UnitDiffInfo defUnitDiffInfo;
                    if (this.adEnv.traceCurDifferentiation) {
                        TapEnv.printlnOnTrace("    --- differentiating definition location of " + definedUnit);
                    }
                    if ((defUnitDiffInfo = this.callGraphDifferentiator().getUnitDiffInfo(definedUnit)) != null) {
                        Unit copiedDefUnit;
                        Unit unit2 = copiedDefUnit = this.callGraphDifferentiator().unitsHavePrimal.retrieve(definedUnit) == Boolean.TRUE ? defUnitDiffInfo.getCopyForDiff() : null;
                        if (copiedDefUnit == null) {
                            removePrimalDeclaration = true;
                        } else {
                            this.adEnv.curInstruction().updateUnitDefinitionStub(copiedDefUnit);
                        }
                        if (definedUnit.isModule()) {
                            removePrimalDeclaration = true;
                            if (copiedDefUnit != null) {
                                newDeclarations = new TapList<Instruction>(this.adEnv.curInstruction(), null);
                            }
                        } else if (!definedUnit.isPackage()) {
                            TapList<Unit> diffDefUnits = allDiffModesInside ? defUnitDiffInfo.getAllDiffs() : defUnitDiffInfo.getAllDiffs(differentiationMode);
                            diffDefUnits = TapList.nreverse(diffDefUnits);
                            newDeclarations = null;
                            while (diffDefUnits != null) {
                                newDeclarations = new TapList<Instruction>(Instruction.createUnitDefinitionStub((Unit)diffDefUnits.head, diffBlock), newDeclarations);
                                diffDefUnits = diffDefUnits.tail;
                            }
                        }
                    }
                } else if (this.adEnv.curInstruction().isADeclaration()) {
                    if (this.adEnv.traceCurDifferentiation) {
                        TapEnv.printlnOnTrace("    --- differentiating declaration " + this.adEnv.curInstruction());
                    }
                    TapList<Instruction>[] newDeclarationsR = this.differentiateInstructionDeclaration(this.adEnv.curInstruction(), differentiationMode, this.adEnv.curInstruction(), this.adEnv.curInstruction().tree, allDiffModesInside, curDiffST, diffBlock, null, null, null, null, null, null, null, null, origLanguage, false, forInterface);
                    if (this.adEnv.curInstruction().tree == null || this.adEnv.curInstruction().tree.opCode() == 138 || this.adEnv.curInstruction().tree.opCode() == 197 && !ILUtils.isIdent(this.adEnv.curInstruction().tree.down(1), "aatypes", false)) {
                        removePrimalDeclaration = true;
                    }
                    newDeclarations = null;
                    for (int iReplic = 0; iReplic < newDeclarationsR.length; ++iReplic) {
                        newDeclarations = TapList.append(newDeclarations, newDeclarationsR[iReplic]);
                    }
                }
                if (definedUnit == null) {
                    if (removePrimalDeclaration) {
                        inDeclarations.tail = inDeclarations.tail.tail;
                    } else {
                        inDeclarations = inDeclarations.tail;
                    }
                }
                while (newDeclarations != null) {
                    Instruction newDeclaration = (Instruction)newDeclarations.head;
                    if (this.adEnv.traceCurDifferentiation) {
                        TapEnv.printlnOnTrace("      -> (DIFF DECL BLOCK+) " + newDeclaration);
                    }
                    inDeclarations = inDeclarations.placdl(newDeclaration);
                    if (newDeclaration.block == null) {
                        newDeclaration.block = diffBlock;
                    }
                    newDeclarationsDone = new TapList<Instruction>(newDeclaration, newDeclarationsDone);
                    newDeclarations = newDeclarations.tail;
                }
                if (definedUnit == null) continue;
                if (removePrimalDeclaration) {
                    inDeclarations.tail = inDeclarations.tail.tail;
                    continue;
                }
                inDeclarations = inDeclarations.tail;
                continue;
            }
            inDeclarations = inDeclarations.tail;
        }
        diffBlock.instructions = hdDeclarations.tail;
        if (unit != null) {
            this.adEnv.popCurDiffVectorMap();
            this.adEnv.popCurVectorMap();
            this.adEnv.popCurUnitEtc();
            this.adEnv.curUnitIsContext = oldCurUnitIsContext;
        }
        if (this.adEnv.traceCurDifferentiation) {
            TapEnv.printlnOnTrace("*** DiffBlock @" + Integer.toHexString(diffBlock.hashCode()) + " ---> " + diffBlock.instructions);
        }
        this.adEnv.traceCurBlock = previousBlockTraceLevel;
        this.adEnv.popCurSymbolTable();
    }

    private void moduleImportsAATypesModule(SymbolTable symbolTable) {
        if (symbolTable.unit != null && symbolTable.unit.isFortran()) {
            Unit origDiffUnit = symbolTable.unit;
            symbolTable = symbolTable.unit.publicSymbolTable();
            while (!(symbolTable.unit == null || symbolTable.unit.upperLevelUnit() == null || symbolTable.unit.isModule() || symbolTable.unit.isTranslationUnit() || symbolTable.unit.upperLevelUnit().isTranslationUnit())) {
                symbolTable = symbolTable.unit.upperLevelUnit().publicSymbolTable();
            }
            if (symbolTable.basisSymbolTable() != null && symbolTable.unit.isModule() && symbolTable == symbolTable.unit.privateSymbolTable()) {
                symbolTable = symbolTable.basisSymbolTable();
            }
            if (symbolTable.unit != null && !symbolTable.isTranslationUnitSymbolTable()) {
                Tree useDeclTree = ILUtils.build(197, ILUtils.build(96, TapEnv.assocAddressDiffTypesUnit(3).name()), ILUtils.build(166));
                Instruction useInstr = new Instruction(useDeclTree);
                useInstr.isDifferentiated = true;
                symbolTable.declarationsBlock.addInstrHdIfNotPresent(useInstr);
                CallGraph.addCallArrow(symbolTable.unit, 2, TapEnv.assocAddressDiffTypesUnit(3));
                if (symbolTable.unit.language() != 3) {
                    TapEnv.commandWarning(-1, "-association by address option generates FORTRAN2003");
                    origDiffUnit.setLanguageAndUp(3);
                    Unit origUnit = origDiffUnit.origUnit;
                    UnitDiffInfo diffInfo = this.callGraphDifferentiator().getUnitDiffInfo(origUnit);
                    TapList<Unit> diffUnits = diffInfo.getAllDiffsPlusCopy();
                    while (diffUnits != null) {
                        ((Unit)diffUnits.head).setLanguageAndUp(3);
                        diffUnits = diffUnits.tail;
                    }
                }
            }
        }
    }

    protected void updateModulesAndCopiedUnitsInCopiedInterface(Tree copyTree, SymbolTable diffSymbolTable, int diffMode) {
        Tree newUnitNameTree;
        TapList<FunctionDecl> privateInterfaces = this.adEnv.curUnit().privateSymbolTable().getAllInterfacedFunctionDecls();
        TapList<FunctionDecl> publicInterfaces = this.adEnv.curUnit().publicSymbolTable().getAllInterfacedFunctionDecls();
        TapList<Unit> usedModulesInDefinition = null;
        usedModulesInDefinition = this.buildModulesList(usedModulesInDefinition, privateInterfaces);
        usedModulesInDefinition = this.buildModulesList(usedModulesInDefinition, publicInterfaces);
        TapList<String> usedModulesInInterface = ILUtils.getModulesFromInterfaceDecl(copyTree);
        while (usedModulesInInterface != null) {
            boolean isDifferentiated;
            String moduleName = (String)usedModulesInInterface.head;
            FunctionDecl moduleDecl = diffSymbolTable.getModuleDecl(moduleName);
            Unit moduleUnit = moduleDecl == null ? null : moduleDecl.unit();
            boolean bl = isDifferentiated = moduleUnit != null && moduleUnit.origUnit != null;
            if (!TapEnv.associationByAddress() || !"AATypes".equals(moduleName)) {
                if (!isDifferentiated && !BlockDifferentiator.moduleNameInModulesList(usedModulesInDefinition, moduleName)) {
                    ILUtils.removeUsedModuleFromInterfaceDecl(copyTree, moduleName);
                    TapEnv.fileWarning(15, copyTree, "(AD30) " + moduleName + " removed from interface declaration");
                } else {
                    Unit diffModule = this.callGraphDifferentiator().getUnitDiffInfo(moduleUnit).getDiff();
                    if (diffModule != null && diffModule.isDiffPackage().booleanValue()) {
                        newUnitNameTree = this.varRefDifferentiator().diffSymbolName(null, moduleName, diffSymbolTable, false, false, true, null, null, false, 1, 1, 2, null);
                        ILUtils.replaceUsedModule(copyTree, moduleName, newUnitNameTree);
                    }
                }
            }
            usedModulesInInterface = usedModulesInInterface.tail;
        }
        Tree[] interfaces = copyTree.down(2).children();
        for (int i = interfaces.length - 1; i >= 0; --i) {
            Unit origCopyInterfacedUnit;
            Unit interfacedUnit;
            Tree interfaceTree = interfaces[i];
            if (interfaceTree.opCode() != 105 || interfaceTree.down(1).opCode() != 89) continue;
            Tree functionInterfaceTree = interfaceTree.down(1);
            String interfacedName = ILUtils.getIdentString(functionInterfaceTree.down(4));
            TapList<FunctionDecl> interfacedDecls = this.adEnv.curUnit().privateSymbolTable().getFunctionDecl(interfacedName, null, null, false);
            FunctionDecl interfacedDecl = interfacedDecls == null ? null : (FunctionDecl)interfacedDecls.head;
            Unit unit = interfacedUnit = interfacedDecl == null ? null : interfacedDecl.unit();
            if (interfacedUnit != null && interfacedUnit.functionTypeSpec() != null && (interfacedUnit.isTopInFile() || interfacedUnit.isInterface()) && interfacedUnit.importedModules() != null && (origCopyInterfacedUnit = this.adEnv.copiedUnits.retrieve(interfacedUnit)) != null) {
                Tree oldUnitNameTree = functionInterfaceTree.cutChild(4);
                newUnitNameTree = this.varRefDifferentiator().diffSymbolName(this.adEnv.curActivity(), interfacedName, diffSymbolTable, false, true, false, null, null, false, 0, 0, 1, null);
                Tree existingExplicitReturn = (Tree)oldUnitNameTree.getAnnotation("explicitReturnVar");
                if (interfacedUnit.isAFunction()) {
                    newUnitNameTree.setAnnotation("explicitReturnVar", ILUtils.isNullOrNone(existingExplicitReturn) ? ILUtils.build(96, interfacedName) : existingExplicitReturn);
                }
                functionInterfaceTree.setChild(newUnitNameTree, 4);
            }
            Tree bindTree = (Tree)functionInterfaceTree.down(4).getAnnotation("bind");
            if (diffMode == 0 && bindTree != null) {
                Tree primalBindTree = ILUtils.copy(bindTree);
                functionInterfaceTree.down(4).setAnnotation("bind", primalBindTree);
                if (primalBindTree.opCode() == 2) {
                    Tree[] bindExprs = primalBindTree.down(2).children();
                    Tree primalBindNameTree = null;
                    for (int ii = 0; ii < bindExprs.length && primalBindNameTree == null; ++ii) {
                        if (bindExprs[ii].opCode() != 134 || !ILUtils.isIdent(bindExprs[ii].down(1), "name", false)) continue;
                        primalBindNameTree = bindExprs[ii];
                    }
                    if (primalBindNameTree != null) {
                        String otherLangName = primalBindNameTree.down(2).stringValue();
                        Tree newOtherLangNameTree = this.varRefDifferentiator().diffSymbolName(this.adEnv.curActivity(), otherLangName, diffSymbolTable, false, true, false, null, null, false, 0, 0, 1, null);
                        primalBindNameTree.setChild(newOtherLangNameTree, 2);
                    }
                }
            }
            if (!TapEnv.associationByAddress() || TapEnv.get().complexStep) continue;
            Tree useDeclTree = ILUtils.build(197, ILUtils.build(96, TapEnv.assocAddressDiffTypesUnit(3).name()), ILUtils.build(166));
            functionInterfaceTree.down(6).addChild(useDeclTree, 1);
        }
    }

    private TapList<Unit> buildModulesList(TapList<Unit> modules, TapList<FunctionDecl> functions) {
        while (functions != null) {
            FunctionDecl func = (FunctionDecl)functions.head;
            modules = TapList.union(modules, func.unit().importedModules());
            modules = TapList.union(modules, func.unit().otherImportedModules);
            functions = functions.tail;
        }
        return modules;
    }

    private Tree diffListDecls(Tree tree, Tree contextExpression, SymbolTable diffSymbolTable, MemMap activityMap, ToInt offset, TapList<Tree> toExtraDiffDeclarations) {
        switch (tree.opCode()) {
            case 110: {
                Tree result = this.diffListDecls(tree.down(1), contextExpression, diffSymbolTable, null, null, null);
                if (result != null) {
                    result = ILUtils.build(110, result, ILUtils.copy(tree.down(2)));
                }
                return result;
            }
            case 69: 
            case 71: 
            case 201: {
                Tree[] refs = tree.children();
                TapList<Tree> diffRefs = null;
                for (int i = 0; i < refs.length; ++i) {
                    Tree diffRef = this.diffListDecls(refs[i], contextExpression, diffSymbolTable, activityMap, offset, toExtraDiffDeclarations);
                    if (diffRef == null) continue;
                    diffRefs = new TapList<Tree>(diffRef, diffRefs);
                }
                return diffRefs == null ? null : ILUtils.build(tree.opCode(), TapList.nreverse(diffRefs));
            }
        }
        String baseName = ILUtils.baseName(tree);
        SymbolDecl symbolDecl = baseName == null ? null : diffSymbolTable.getSymbolDecl(baseName);
        int size = symbolDecl instanceof VariableDecl ? symbolDecl.type().size() : 0;
        Tree result = null;
        boolean activeRegion = false;
        if (offset != null) {
            activeRegion = activityMap.isActiveRegion(offset.get(), size <= 0 ? -1 : size, size <= 0);
        }
        if (symbolDecl != null && symbolDecl.isA(1) && (symbolDecl.isActiveSymbolDecl() || activeRegion)) {
            Tree diffDeclarator = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), tree, diffSymbolTable, false, contextExpression, false, true, null);
            if (offset == null || activeRegion) {
                result = diffDeclarator;
            } else if (diffDeclarator.opCode() == 11) {
                toExtraDiffDeclarations.placdl(ILUtils.build(202, diffDeclarator));
            }
        }
        if (offset != null) {
            offset.set(offset.get() + size);
        }
        return result;
    }

    private Tree differentiateCommonDeclaration(SymbolTable diffSymbolTable, Tree commonTree, TapList<Tree> toExtraDiffDeclarations) {
        String commonName;
        Tree diffCommonTree = null;
        String commonNameInMap = commonName = ILUtils.getIdentString(commonTree.down(1));
        if (commonName == null || commonName.isEmpty()) {
            commonName = "//";
            commonNameInMap = "";
        }
        MemMap commonActivityMap = this.adEnv.commonActivityMemoryMap.getSetMemMap(commonNameInMap);
        Tree diffElements = this.diffListDecls(commonTree.down(2), commonTree, diffSymbolTable, commonActivityMap, new ToInt(0), toExtraDiffDeclarations);
        if (diffElements != null) {
            String diffCommonName = this.differentiateCommonName(commonName, this.curDiffUnitSort());
            diffCommonTree = ILUtils.build(39, ILUtils.build(96, diffCommonName), diffElements);
        }
        return diffCommonTree;
    }

    protected String differentiateCommonName(String commonName, int diffSort) {
        String primalRootCommonName = commonName.substring(1, commonName.length() - 1);
        if ("".equals(primalRootCommonName)) {
            primalRootCommonName = "blank";
        }
        String diffRootCommonName = TapEnv.extendStringWithSuffix(primalRootCommonName, this.suffixes()[diffSort][1]);
        String diffCommonName = "/" + diffRootCommonName + "/";
        int counter = 0;
        while (TapList.containsEquals(this.adEnv.diffCallGraph().usedCommonNames, diffCommonName)) {
            diffCommonName = "/" + diffRootCommonName + counter + "/";
            ++counter;
        }
        return diffCommonName;
    }

    private Tree differentiateEquivalenceDeclaration(SymbolTable diffSymbolTable, Tree equivTree) {
        return this.diffListDecls(equivTree, equivTree, diffSymbolTable, null, null, null);
    }

    private TapList<Tree> diffDeclNames(Tree declTree, boolean allDiffModesInside, SymbolTable diffSymbolTable) {
        TapList<Tree> result = null;
        if (allDiffModesInside) {
            if (TapEnv.mustTangent()) {
                this.adEnv.pushCurDiffSorts(1, 1);
                result = this.diffDeclNames(declTree, diffSymbolTable);
                this.adEnv.popCurDiffSorts();
            }
            if (TapEnv.mustAdjoint()) {
                this.adEnv.pushCurDiffSorts(2, 2);
                result = TapList.append(result, this.diffDeclNames(declTree, diffSymbolTable));
                this.adEnv.popCurDiffSorts();
            }
        } else {
            result = this.diffDeclNames(declTree, diffSymbolTable);
        }
        return result;
    }

    private TapList<Tree> diffDeclNames(Tree declTree, SymbolTable diffSymbolTable) {
        boolean inAccessDecl = false;
        String accessDeclModifier = null;
        if (declTree.opCode() == 2) {
            if (ILUtils.isAccessDeclValue(declTree, "in") || ILUtils.isAccessDeclValue(declTree, "out") || ILUtils.isAccessDeclValue(declTree, "inout") || ILUtils.isAccessDeclValue(declTree, "optional")) {
                inAccessDecl = true;
                accessDeclModifier = declTree.down(1).stringValue();
            }
            declTree = declTree.down(2);
        }
        Tree[] declNames = declTree.children();
        TapList<Tree> result = null;
        Tree contextTree = declTree;
        for (int i = declNames.length - 1; i >= 0; --i) {
            int startOffset;
            String baseName = ILUtils.baseName(declNames[i]);
            if (baseName == null) continue;
            SymbolDecl symbolDecl = diffSymbolTable.getSymbolDecl(baseName);
            if (symbolDecl != null) {
                boolean intrinsicHasInlinedDerivatives;
                Tree diffTree;
                if (symbolDecl.isA(1) && symbolDecl.isActiveSymbolDecl() && (!inAccessDecl || !this.varRefDifferentiator().paramHasOnlyLocalDiff(this.adEnv.curActivity(), declNames[i], (VariableDecl)symbolDecl))) {
                    VariableDecl diffVarDecl;
                    NewSymbolHolder sHolder;
                    if (declTree.opCode() != 171) {
                        contextTree = declNames[i];
                    }
                    diffTree = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), declNames[i], diffSymbolTable, false, contextTree, false, true, null);
                    if (inAccessDecl && (sHolder = NewSymbolHolder.getNewSymbolHolder(diffTree)) != null && (diffVarDecl = sHolder.newVariableDecl()) != null && !diffVarDecl.hasModifier(accessDeclModifier)) {
                        diffTree = null;
                    }
                    if (diffTree != null) {
                        result = new TapList<Tree>(diffTree, result);
                    }
                }
                if (symbolDecl.isA(16) && ((InterfaceDecl)symbolDecl).mustHaveADiff(this.activityAnalyzer())) {
                    Tree interfaceNameTree = declNames[i];
                    if (ILUtils.getIdentString(interfaceNameTree) == null) {
                        interfaceNameTree = ILUtils.build(96, interfaceNameTree.opName());
                    }
                    Tree diffInterfaceNameTree = this.varRefDifferentiator().diffSymbolTree(this.adEnv.curActivity(), interfaceNameTree, diffSymbolTable.basisSymbolTable(), false, true, false, null, false, this.curDiffUnitSort(), this.curDiffUnitSort(), 1, null);
                    result = new TapList<Tree>(diffInterfaceNameTree, result);
                }
                if (!symbolDecl.isA(3)) continue;
                FunctionDecl functionDecl = (FunctionDecl)symbolDecl;
                Unit funcUnit = functionDecl.unit();
                if (funcUnit.origUnit != null) {
                    funcUnit = funcUnit.origUnit;
                }
                if (MPIcallInfo.isMessagePassingFunction(funcUnit.name(), funcUnit.language()) || !symbolDecl.isActiveSymbolDecl() && !TapList.containsEquals(this.adEnv.curUnit().activeCalledNames, baseName) && (this.adEnv.curUnit() != null || !funcUnit.isFortran()) && funcUnit.language() == this.adEnv.curUnit().language()) continue;
                boolean bl = intrinsicHasInlinedDerivatives = funcUnit.diffInfo != null;
                if (!intrinsicHasInlinedDerivatives && functionDecl.isIntrinsic() && declTree.opCode() == 108) {
                    Unit origIntrinsicFunctionUnit = this.adEnv.srcCallGraph().getAnyIntrinsicUnit(symbolDecl.symbol);
                    intrinsicHasInlinedDerivatives = origIntrinsicFunctionUnit.diffInfo != null;
                }
                TapList<ActivityPattern> patternsCalledHere = BlockDifferentiator.patternsCalledByPattern(funcUnit, this.adEnv.curActivity());
                while (patternsCalledHere != null) {
                    ActivityPattern calledPattern = (ActivityPattern)patternsCalledHere.head;
                    if (calledPattern.isActive()) {
                        if (this.curDiffUnitSort() == 2 && funcUnit.mustDifferentiateSplit() && !intrinsicHasInlinedDerivatives) {
                            diffTree = this.varRefDifferentiator().findDiffFuncName(calledPattern, functionDecl, 4, diffSymbolTable, declTree, true, false);
                            result = new TapList<Tree>(diffTree, result);
                            diffTree = this.varRefDifferentiator().findDiffFuncName(calledPattern, functionDecl, 3, diffSymbolTable, declTree, true, false);
                            result = new TapList<Tree>(diffTree, result);
                        }
                        if (!(this.curDiffUnitSort() == 2 && !funcUnit.mustDifferentiateJoint() && funcUnit.mustDifferentiateSplit() || intrinsicHasInlinedDerivatives)) {
                            diffTree = this.varRefDifferentiator().findDiffFuncName(calledPattern, functionDecl, this.curDiffUnitSort(), diffSymbolTable, declTree, true, false);
                            result = new TapList<Tree>(diffTree, result);
                        }
                    }
                    patternsCalledHere = patternsCalledHere.tail;
                }
                continue;
            }
            MemMap commonActivityMap = this.adEnv.commonActivityMemoryMap.getSetMemMap(baseName);
            if (commonActivityMap == null || commonActivityMap.boundaries.tail == null || ((AlignmentBoundary)commonActivityMap.boundaries.tail.head).infiniteOffset || !commonActivityMap.isActiveRegion(startOffset = ((AlignmentBoundary)commonActivityMap.boundaries.tail.head).offset, -1, true)) continue;
            result = new TapList<Tree>(ILUtils.build(96, this.differentiateCommonName(baseName, this.curDiffUnitSort())), result);
        }
        return result;
    }

    private void flattenBlockStatements(Block block) {
        TapList<Instruction> hdInstructions;
        TapList<Instruction> inInstructions = hdInstructions = new TapList<Instruction>(null, block.instructions);
        while (inInstructions.tail != null) {
            Instruction instruction = (Instruction)inInstructions.tail.head;
            if (instruction == null || instruction.tree == null) {
                inInstructions.tail = inInstructions.tail.tail;
                continue;
            }
            if ((instruction.whereMask() == null || instruction.whereMask().isEmpty()) && instruction.tree.opCode() == 27) {
                Tree[] subTrees = instruction.tree.children();
                inInstructions.tail = inInstructions.tail.tail;
                for (int i = subTrees.length; i > 0; --i) {
                    Tree subTree = instruction.tree.cutChild(i);
                    Instruction subInstr = new Instruction(subTree, null, block);
                    inInstructions.tail = new TapList<Instruction>(subInstr, inInstructions.tail);
                }
                continue;
            }
            inInstructions = inInstructions.tail;
        }
        block.instructions = hdInstructions.tail;
    }

    private TapList<TapTriplet<Tree, TapPair<TapList<Tree>, TapList<Tree>>, TapPair<TapList<Tree>, TapList<Tree>>>> reinitializeDiffIOVars(Tree tree, SymbolTable diffSymbolTable, TapList<IterDescriptor> iterators, BoolVector beforeActiv, BoolVector afterActiv, BoolVector beforeUseful, BoolVector afterUseful) {
        TapList<Object> hdInitTrees = new TapList<Object>(null, null);
        this.reinitializeDiffIOVars(tree, hdInitTrees, diffSymbolTable, iterators, beforeActiv, afterActiv, beforeUseful, afterUseful);
        return hdInitTrees.tail;
    }

    private TapList<TapTriplet<Tree, TapPair<TapList<Tree>, TapList<Tree>>, TapPair<TapList<Tree>, TapList<Tree>>>> reinitializeDiffIOVars(Tree tree, TapList<TapTriplet<Tree, TapPair<TapList<Tree>, TapList<Tree>>, TapPair<TapList<Tree>, TapList<Tree>>>> tlInitTrees, SymbolTable diffSymbolTable, TapList<IterDescriptor> iterators, BoolVector beforeActiv, BoolVector afterActiv, BoolVector beforeUseful, BoolVector afterUseful) {
        switch (tree.opCode()) {
            case 71: {
                Tree[] expressions;
                for (Tree expression : expressions = tree.children()) {
                    tlInitTrees = this.reinitializeDiffIOVars(expression, tlInitTrees, diffSymbolTable, iterators, beforeActiv, afterActiv, beforeUseful, afterUseful);
                }
                break;
            }
            case 110: {
                TapList<Object> hdSubInitTreesResult;
                Tree doTree = tree.down(2);
                IterDescriptor iterator = new IterDescriptor(doTree);
                TapList<Object> hdSubInitTrees = new TapList<Object>(null, null);
                this.reinitializeDiffIOVars(tree.down(1), hdSubInitTrees, diffSymbolTable, new TapList<IterDescriptor>(iterator, iterators), beforeActiv, afterActiv, beforeUseful, afterUseful);
                TapList<Object> inSubInitTrees = hdSubInitTrees = hdSubInitTrees.tail;
                TapPair<Object, Object> diffRefsRW = new TapPair<Object, Object>(null, null);
                TapPair<TapList<Tree>, TapList<Tree>> refsRW = new TapPair<TapList<Tree>, TapList<Tree>>(ILUtils.usedVarsInExp(doTree, null, false), new TapList<Tree>(doTree.down(1), null));
                TapList<Object> inSubInitTreesResult = hdSubInitTreesResult = new TapList<Object>(null, null);
                while (inSubInitTrees != null) {
                    TapTriplet initTriplet = (TapTriplet)inSubInitTrees.head;
                    BlockDifferentiator.accumulateRW(refsRW, (TapPair)initTriplet.second);
                    BlockDifferentiator.accumulateRW(diffRefsRW, (TapPair)initTriplet.third);
                    inSubInitTreesResult.head = initTriplet.first;
                    inSubInitTreesResult = inSubInitTreesResult.tail;
                    inSubInitTrees = inSubInitTrees.tail;
                }
                if (hdSubInitTrees == null) break;
                tlInitTrees = tlInitTrees.placdl(new TapTriplet<Tree, TapPair<TapList<Tree>, TapList<Tree>>, TapPair<Object, Object>>(ILUtils.build(121, ILUtils.build(138), ILUtils.build(138), iterator.buildDoHeaderTree(diffSymbolTable, this.curDiffUnit(), true), ILUtils.build(27, hdSubInitTreesResult)), refsRW, diffRefsRW));
                break;
            }
            case 9: 
            case 75: 
            case 96: {
                TapIntList writtenZones = ZoneInfo.listAllZones(this.adEnv.curSymbolTable().treeOfZonesOfValue(tree, null, this.adEnv.curInstruction(), null), true);
                boolean writtenTmp = TapIntList.intersects(writtenZones, this.adEnv.toActiveTmpZones.tail);
                TapIntList writtenDiffKindVectorIndices = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(writtenZones, this.adEnv.diffKind, this.curDiffVectorMap(), this.adEnv.curSymbolTable(), null);
                TapList<ZoneInfo> zones = DataFlowAnalyzer.mapExtendedDeclaredToZoneInfo(writtenZones, this.adEnv.curSymbolTable(), null);
                if (beforeActiv != null && beforeActiv.intersects(writtenDiffKindVectorIndices)) {
                    TapEnv.fileWarning(15, tree, "(AD05) Active variable " + ILUtils.toString(tree, this.adEnv.curUnit().language(), this.adEnv.curActivity()) + " overwritten by I-O");
                }
                if ((TapEnv.spareDiffReinitializations() && TapEnv.debugAdMode() == 0 && !ILUtils.isAccessedThroughPointer(tree) || !ADActivityAnalyzer.haveDifferentiatedVariable(zones) || !writtenTmp && writtenDiffKindVectorIndices == null) && (afterUseful == null || !ADActivityAnalyzer.haveDifferentiatedVariable(zones) || !writtenTmp && !afterUseful.intersects(writtenDiffKindVectorIndices))) break;
                Tree[] diffInitTreeR = this.makeDiffInitialization(tree, this.adEnv.curSymbolTable(), diffSymbolTable, this.adEnv.curFwdSymbolTable, null, false, null, true);
                TapList<Tree> refsR = ILUtils.usedVarsInExp(tree, null, false);
                for (int iReplic = 0; iReplic < diffInitTreeR.length; ++iReplic) {
                    Tree diffInitTree = diffInitTreeR[iReplic];
                    if (diffInitTree == null) continue;
                    tlInitTrees = tlInitTrees.placdl(new TapTriplet<Tree, TapPair<TapList<Tree>, Object>, TapPair<Object, TapList<Tree>>>(diffInitTree, new TapPair<TapList<Tree>, Object>(refsR, null), new TapPair<Object, TapList<Tree>>(null, new TapList<Tree>(tree, null))));
                }
                break;
            }
            case 138: {
                break;
            }
            default: {
                TapEnv.toolWarning(-1, "(Reinitializing diffs of variables overwritten by I-O) Unexpected operator: " + tree.opName());
            }
        }
        return tlInitTrees;
    }

    private void checkArrayActivitySwitches(BoolVector activHereOne, BoolVector activHereZero, TapIntList zonesAccessedTotally, TapList<TapPair<TapList<Tree>, Tree>> toNecessaryReInits, SymbolTable srcSymbolTable, SymbolTable diffSymbolTable, boolean onlyOnLocals, TapList<ZoneInfo> toInitialized) {
        ZoneInfo zoneInfo;
        if (activHereOne == null || activHereZero == null) {
            return;
        }
        int nDdZ = srcSymbolTable.declaredZonesNb(this.adEnv.diffKind);
        TapList<Object> zonesToInit = null;
        int localLimitZ = 0;
        SymbolTable paramsSymbolTable = this.adEnv.curUnit().publicSymbolTable();
        if (this.curDiffUnitSort() == 1 && paramsSymbolTable != null) {
            localLimitZ = paramsSymbolTable.declaredZonesNb(this.adEnv.diffKind);
        }
        for (int i = nDdZ - 1; i >= 0; --i) {
            WrapperTypeSpec typeOfExpr;
            if (TapIntList.contains(zonesAccessedTotally, DataFlowAnalyzer.zoneRkToExtendedDeclared(i, 3, this.adEnv.diffKind, srcSymbolTable, null)) || activHereZero.get(i) || !activHereOne.get(i)) continue;
            zoneInfo = srcSymbolTable.declaredZoneInfo(i, this.adEnv.diffKind);
            if (onlyOnLocals && i < localLimitZ && !zoneInfo.isResult() || this.varRefDifferentiator().isOnlyIncrementedDiff(this.adEnv.curActivity(), zoneInfo)) continue;
            Tree exprToInit = zoneInfo.accessTree;
            if (exprToInit != null && exprToInit.opCode() == 5) {
                exprToInit = exprToInit.down(1);
            }
            if ((typeOfExpr = srcSymbolTable.typeOf(exprToInit)) == null || typeOfExpr.getAllDimensions() == null && (!this.adEnv.curUnit().isC() || !ILUtils.isAccessedThroughPointer(exprToInit)) || TapList.contains(zonesToInit, zoneInfo)) continue;
            Tree exprToInitnoalloc = ILUtils.copy(exprToInit);
            exprToInitnoalloc = BlockDifferentiator.replaceAllocateInExprToInitialize(exprToInitnoalloc);
            TapIntList accessibleZones = ZoneInfo.listAllZones(srcSymbolTable.treeOfZonesOfValue(exprToInitnoalloc, null, this.adEnv.curInstruction(), null), false);
            boolean accessible = false;
            while (!accessible && accessibleZones != null) {
                accessible = accessibleZones.head != -2;
                accessibleZones = accessibleZones.tail;
            }
            if (!accessible) continue;
            zonesToInit = new TapList<ZoneInfo>(zoneInfo, zonesToInit);
        }
        while (zonesToInit != null) {
            zoneInfo = (ZoneInfo)zonesToInit.head;
            Tree[] diffInitTreeR = this.makeDiffInitialization(zoneInfo.accessTree, srcSymbolTable, diffSymbolTable, null, zoneInfo, true, null, true);
            Tree diffWrittenTree = ILUtils.copy(zoneInfo.accessTree);
            diffWrittenTree = BlockDifferentiator.replaceAllocateInExprToInitialize(diffWrittenTree);
            for (int iReplic = 0; iReplic < diffInitTreeR.length; ++iReplic) {
                Tree diffInitTree = diffInitTreeR[iReplic];
                if (diffInitTree == null) continue;
                toNecessaryReInits.placdl(new TapPair<TapList<Tree>, Tree>(new TapList<Tree>(diffWrittenTree, null), diffInitTree));
            }
            if (toInitialized != null) {
                toInitialized.placdl(zoneInfo);
            }
            zonesToInit = zonesToInit.tail;
        }
    }

    protected Tree[] makeDiffInitialization(Tree exprToInitialize, SymbolTable defSymbolTable, SymbolTable usageSymbolTable, SymbolTable otherUsageSymbolTable, ZoneInfo fromZoneInfo, boolean protectAccesses, TapList ignoreStructure, boolean ignorePointed) {
        exprToInitialize = ILUtils.copy(exprToInitialize);
        exprToInitialize = BlockDifferentiator.replaceAllocateInExprToInitialize(exprToInitialize);
        String baseVarName = ILUtils.baseName(exprToInitialize);
        Tree baseVarTree = ILUtils.baseTree(exprToInitialize);
        if (baseVarName == null || baseVarTree == null) {
            TapEnv.toolWarning(-1, "(Build diff initialization) Unexpected expression: " + exprToInitialize);
            return null;
        }
        boolean isCurUnitName = baseVarName.equals(this.adEnv.curUnit().name());
        WrapperTypeSpec type = defSymbolTable.typeOf(exprToInitialize);
        Tree[] resultR = new Tree[TapEnv.diffReplica()];
        this.adEnv.iReplic = 0;
        while (this.adEnv.iReplic < resultR.length) {
            Tree diffBaseVar = this.varRefDifferentiator().diffSymbolTree(this.adEnv.curActivity(), baseVarTree, usageSymbolTable, true, this.curDiffUnitSort() == 1 && !this.multiDirMode() && isCurUnitName, false, null, false, this.curDiffVarSort(), this.curDiffUnitSort(), 0, baseVarTree);
            resultR[this.adEnv.iReplic] = RefDescriptor.makeInitialize(this.curDiffUnit(), exprToInitialize, type, type, baseVarTree, defSymbolTable, usageSymbolTable, otherUsageSymbolTable, diffBaseVar, true, this.multiDirMode() ? this.varRefDifferentiator().multiDirMaxIterDescriptor : null, fromZoneInfo, protectAccesses, ignoreStructure, ignorePointed);
            ++this.adEnv.iReplic;
        }
        this.adEnv.iReplic = 0;
        return resultR;
    }

    protected Tree makeDiffInitializationOneReplica(Tree exprToInitialize, SymbolTable defSymbolTable, SymbolTable usageSymbolTable, SymbolTable otherUsageSymbolTable, ZoneInfo fromZoneInfo, boolean protectAccesses, TapList ignoreStructure, boolean ignorePointed) {
        exprToInitialize = ILUtils.copy(exprToInitialize);
        exprToInitialize = BlockDifferentiator.replaceAllocateInExprToInitialize(exprToInitialize);
        String baseVarName = ILUtils.baseName(exprToInitialize);
        Tree baseVarTree = ILUtils.baseTree(exprToInitialize);
        if (baseVarName == null || baseVarTree == null) {
            TapEnv.toolWarning(-1, "(Build diff initialization) Unexpected expression: " + exprToInitialize);
            return null;
        }
        boolean isCurUnitName = baseVarName.equals(this.adEnv.curUnit().name());
        WrapperTypeSpec type = defSymbolTable.typeOf(exprToInitialize);
        if (defSymbolTable == this.adEnv.curUnit().publicSymbolTable() && this.adEnv.curUnit().privateSymbolTable() != null) {
            defSymbolTable = this.adEnv.curUnit().privateSymbolTable();
        }
        Tree diffRootIdent = this.varRefDifferentiator().diffVarRef(this.adEnv.curActivity(), exprToInitialize, usageSymbolTable, false, exprToInitialize, this.multiDirMode(), this.multiDirMode(), ILUtils.copy(exprToInitialize));
        RefDescriptor lhsRefDescriptor = new RefDescriptor(diffRootIdent, null, defSymbolTable, usageSymbolTable, null, null, true, null, this.curDiffUnit());
        lhsRefDescriptor.setHintArrayTreeForCallSize(exprToInitialize);
        lhsRefDescriptor.prepareForInitialize(this.curDiffUnit(), null, true);
        return lhsRefDescriptor.makeInitialize();
    }

    protected void prepareRestoreOperations(RefDescriptor refDescriptor, RefDescriptor refDescriptorRestore, int knownMultiplicity, SymbolTable fwdSymbolTable, SymbolTable bwdSymbolTable) {
        RefDescriptor saveVarRefDescriptor = this.tryStaticTape(this.curBlock(), knownMultiplicity, "ad_save", refDescriptor.completeType, fwdSymbolTable, bwdSymbolTable);
        if (saveVarRefDescriptor != null && saveVarRefDescriptor.completeType != null && saveVarRefDescriptor.completeType.wrappedType != null) {
            refDescriptor.forceStaticSave(saveVarRefDescriptor);
            if (refDescriptorRestore != null) {
                refDescriptorRestore.forceStaticSave(saveVarRefDescriptor);
            }
            refDescriptor.prepareForAssignOrNormDiff(saveVarRefDescriptor, refDescriptorRestore == null ? this.curDiffUnit() : this.curFwdDiffUnit(), null, true);
            if (refDescriptorRestore != null) {
                refDescriptorRestore.prepareForAssignOrNormDiff(saveVarRefDescriptor, this.curDiffUnit(), null, true);
            }
        } else {
            int ppLabel = TapEnv.getNewPushPopNumber();
            refDescriptor.prepareForStack(refDescriptorRestore == null ? this.curDiffUnit() : this.curFwdDiffUnit(), ppLabel, null, true);
            if (refDescriptorRestore != null) {
                refDescriptorRestore.prepareForStack(this.curDiffUnit(), ppLabel, null, true);
            }
            if (refDescriptor.holdsAPointer || refDescriptorRestore != null && refDescriptorRestore.holdsAPointer) {
                this.adEnv.curDiffUnitPushesPointers = true;
            }
        }
    }

    protected void pushStaticSaves(TapTriplet<Boolean, TapList<RefDescriptor>, TapList<RefDescriptor>> staticSaves) {
        this.curStaticSaves = new TapList<TapTriplet<Boolean, TapList<RefDescriptor>, TapList<RefDescriptor>>>(staticSaves, this.curStaticSaves);
    }

    protected void popStaticSaves() {
        this.curStaticSaves = this.curStaticSaves.tail;
    }

    protected RefDescriptor tryStaticTape(Block block, int knownMultiplicity, String staticVarName, WrapperTypeSpec staticVarRootType, SymbolTable fwdDiffSymbolTable, SymbolTable diffSymbolTable) {
        TapList<LoopBlock> toIterationsBetween;
        ArrayTypeSpec arrayTypeSpec;
        ArrayDim[] checkedDimensions;
        if (block == null || knownMultiplicity == 2 || !TapEnv.get().staticTape && (TapEnv.multithreadAnalyzer() == null || !TapEnv.multithreadAnalyzer().isGPU(this.adEnv.curUnit()))) {
            return null;
        }
        if (TypeSpec.isA(staticVarRootType, 9) || TypeSpec.isA(staticVarRootType, 6)) {
            return null;
        }
        if (TypeSpec.isA(staticVarRootType, 2) && (checkedDimensions = (arrayTypeSpec = (ArrayTypeSpec)staticVarRootType.wrappedType).checkNoneDimensions(arrayTypeSpec.dimensions(), !diffSymbolTable.isFormalParamsLevel(), false, null, "", null, null, null, diffSymbolTable, null)) != null) {
            return null;
        }
        TapList<LoopBlock> iterationsBetween = this.flowGraphDifferentiator().getIterationsBetweenPushAndPop(block);
        if (iterationsBetween != null && iterationsBetween.head == null) {
            if (this.curFwdDiffUnit() != this.curDiffUnit()) {
                return null;
            }
            iterationsBetween = iterationsBetween.tail;
        }
        boolean hasStaticIterationSpace = true;
        TapList<LoopBlock> inIterationsBetween = toIterationsBetween = new TapList<LoopBlock>(null, iterationsBetween);
        while (inIterationsBetween.tail != null) {
            if (((LoopBlock)inIterationsBetween.tail.head).isFixedPoint) {
                inIterationsBetween.tail = inIterationsBetween.tail.tail;
                continue;
            }
            if (knownMultiplicity == 1 && inIterationsBetween.tail.tail == null) {
                inIterationsBetween.tail = inIterationsBetween.tail.tail;
                continue;
            }
            if (((LoopBlock)inIterationsBetween.tail.head).staticIterationLength() == null) {
                hasStaticIterationSpace = false;
            }
            inIterationsBetween = inIterationsBetween.tail;
        }
        iterationsBetween = toIterationsBetween.tail;
        if (!hasStaticIterationSpace) {
            return null;
        }
        RefDescriptor saveVarRefDescriptor = null;
        if (this.curStaticSaves == null || ((TapTriplet)this.curStaticSaves.head).first == Boolean.FALSE) {
            NewSymbolHolder saveVarHolder = new NewSymbolHolder(staticVarName);
            WrapperTypeSpec saveVarType = this.addStaticIterationDimensions(staticVarRootType, iterationsBetween);
            saveVarHolder.setAsVariable(saveVarType, null);
            saveVarHolder.declarationLevelMustInclude(diffSymbolTable);
            Tree saveVarRef = saveVarHolder.makeNewRef(diffSymbolTable);
            saveVarRef = this.addStaticIterationIndices(saveVarRef, iterationsBetween, saveVarType);
            saveVarRefDescriptor = new RefDescriptor(saveVarRef, null, staticVarRootType, null, diffSymbolTable, this.curDiffUnit().privateSymbolTable(), fwdDiffSymbolTable, null, false, null, this.curDiffUnit());
            if (diffSymbolTable != fwdDiffSymbolTable) {
                saveVarHolder.setOtherDefSymbolTable(fwdDiffSymbolTable);
            }
            if (this.curStaticSaves != null) {
                ((TapTriplet)this.curStaticSaves.head).third = ((TapList)((TapTriplet)this.curStaticSaves.head).third).placdl(saveVarRefDescriptor);
            }
        } else {
            ((TapTriplet)this.curStaticSaves.head).third = ((TapList)((TapTriplet)this.curStaticSaves.head).third).tail;
            saveVarRefDescriptor = (RefDescriptor)((TapList)((TapTriplet)this.curStaticSaves.head).third).head;
        }
        return saveVarRefDescriptor;
    }

    private WrapperTypeSpec addStaticIterationDimensions(WrapperTypeSpec rootTypeSpec, TapList<LoopBlock> iterationsBetween) {
        WrapperTypeSpec copyRootTypeSpec;
        TapList<Integer> iterSpace = null;
        while (iterationsBetween != null) {
            iterSpace = new TapList<Integer>(((LoopBlock)iterationsBetween.head).staticIterationLength(), iterSpace);
            iterationsBetween = iterationsBetween.tail;
        }
        if (iterSpace == null) {
            return rootTypeSpec;
        }
        TapList<ArrayDim> existingDimensions = rootTypeSpec.getAllDimensions();
        if (existingDimensions == null) {
            ArrayDim[] dimensions = new ArrayDim[TapList.length(iterSpace)];
            int i = dimensions.length - 1;
            while (iterSpace != null) {
                int diml = (Integer)iterSpace.head;
                dimensions[i] = new ArrayDim(null, 1, diml, null, -1, 0, 0);
                --i;
                iterSpace = iterSpace.tail;
            }
            return new WrapperTypeSpec(new ArrayTypeSpec(rootTypeSpec, dimensions));
        }
        TypeSpec arrayTypeSpecInside = copyRootTypeSpec = (WrapperTypeSpec)rootTypeSpec.copy();
        while (arrayTypeSpecInside.kind() != 2) {
            arrayTypeSpecInside = ((TypeSpec)arrayTypeSpecInside).wrappedType();
        }
        ArrayTypeSpec existingArray = (ArrayTypeSpec)arrayTypeSpecInside;
        ArrayDim[] newDimensions = new ArrayDim[existingArray.dimensions().length + TapList.length(iterSpace)];
        int i = 0;
        int j = 0;
        while (iterSpace != null) {
            int diml = (Integer)iterSpace.head;
            newDimensions[i] = new ArrayDim(null, 1, diml, null, -1, 0, 0);
            ++i;
            iterSpace = iterSpace.tail;
        }
        while (i < newDimensions.length) {
            newDimensions[i] = existingArray.dimensions()[j];
            ++i;
            ++j;
        }
        existingArray.setDimensions(newDimensions);
        return copyRootTypeSpec;
    }

    private Tree addStaticIterationIndices(Tree rootTree, TapList<LoopBlock> iterationsBetween, WrapperTypeSpec saveVarType) {
        TapList<Tree> indices = null;
        while (iterationsBetween != null) {
            indices = new TapList<Tree>(((LoopBlock)iterationsBetween.head).staticNormalizedIndex(), indices);
            iterationsBetween = iterationsBetween.tail;
        }
        if (indices == null) {
            return rootTree;
        }
        TapList<ArrayDim> otherDims = saveVarType.getAllDimensions();
        for (int doneDims = TapList.length(indices); doneDims > 0; --doneDims) {
            otherDims = otherDims.tail;
        }
        while (otherDims != null) {
            indices = new TapList<Tree>(ILUtils.build(12), indices);
            otherDims = otherDims.tail;
        }
        indices = TapList.reverse(indices);
        return ILUtils.build(9, rootTree, ILUtils.build(71, indices));
    }

    private TapList<Tree> collectSwitchExpressions(Tree test, TapList<Tree> expressions) {
        switch (test.opCode()) {
            case 68: 
            case 92: 
            case 95: 
            case 115: 
            case 122: 
            case 137: {
                return new TapList<Tree>(ILUtils.buildSmartAddSub(ILUtils.copy(test.down(1)), -1, ILUtils.copy(test.down(2))), expressions);
            }
            case 6: 
            case 143: 
            case 207: {
                expressions = this.collectSwitchExpressions(test.down(1), expressions);
                return this.collectSwitchExpressions(test.down(2), expressions);
            }
            case 139: {
                return this.collectSwitchExpressions(test.down(1), expressions);
            }
        }
        return expressions;
    }

    private Tree genDiffTypeTree(SymbolTable diffSymbolTable, WrapperTypeSpec typeSpec, WrapperTypeSpec diffTypeSpec, Tree[] modifiers) {
        Tree typeTree;
        if (diffTypeSpec != null) {
            diffTypeSpec = diffTypeSpec.equalsDiffTypeSpecAndTypeSpec();
        }
        if (diffTypeSpec == null || diffTypeSpec == typeSpec) {
            diffTypeSpec = typeSpec;
        }
        if (diffTypeSpec.wrappedType != null && diffTypeSpec.wrappedType.diffTypeDeclSymbolHolder != null) {
            if (typeSpec.wrappedType.getRenamedTypeDeclName(this.adEnv.curUnit()) == null) {
                typeTree = diffTypeSpec.wrappedType.diffTypeDeclSymbolHolder.makeNewRef(diffSymbolTable);
            } else {
                TypeDecl typeDecl = diffSymbolTable.getTypeDecl(typeSpec.wrappedType.getRenamedTypeDeclName(this.adEnv.curUnit()));
                typeTree = this.getDiffTypeDeclTree(diffSymbolTable, this.suffixes()[this.curDiffUnitSort()][3], diffTypeSpec, typeDecl);
            }
        } else {
            typeTree = diffTypeSpec.generateTree(diffSymbolTable, null, null, true, null);
        }
        if (modifiers != null) {
            TapList<Tree> identModifiers = null;
            Tree dimensionModifier = null;
            for (int i = modifiers.length - 1; i >= 0; --i) {
                Tree tree = modifiers[i];
                if (tree.opCode() == 96 && !tree.stringValue().equals("pointer")) {
                    identModifiers = new TapList<Tree>(ILUtils.copy(tree), identModifiers);
                    continue;
                }
                if (tree.opCode() == 60) {
                    dimensionModifier = ILUtils.copy(tree);
                    continue;
                }
                if (tree.opCode() != 2 || tree.down(1).opCode() != 96 || !tree.down(1).stringValue().equals("bind")) continue;
                identModifiers = new TapList<Tree>(this.diffBindCVarName(tree), identModifiers);
            }
            if (dimensionModifier != null && !this.multiDirMode()) {
                this.putBackOriginalDimensions(typeTree, dimensionModifier);
            }
            if (identModifiers != null) {
                typeTree = ILUtils.build(129, ILUtils.build(130, identModifiers), typeTree);
            }
        }
        return typeTree;
    }

    private void putBackOriginalDimensions(Tree typeTree, Tree dimColonsBack) {
        Tree inTypeTree = typeTree;
        Tree dimColonsFound = null;
        block5: while (inTypeTree != null) {
            switch (inTypeTree.opCode()) {
                case 13: {
                    dimColonsFound = inTypeTree.down(2);
                    inTypeTree = inTypeTree.down(1);
                    continue block5;
                }
                case 154: 
                case 164: {
                    inTypeTree = inTypeTree.down(1);
                    continue block5;
                }
                case 129: {
                    inTypeTree = inTypeTree.down(2);
                    continue block5;
                }
            }
            inTypeTree = null;
        }
        if (dimColonsFound != null) {
            int i;
            for (i = dimColonsFound.length(); i > 0; --i) {
                dimColonsFound.removeChild(1);
            }
            for (i = dimColonsBack.length(); i > 0; --i) {
                dimColonsFound.addChild(dimColonsBack.cutChild(i), 1);
            }
        }
    }

    private Tree diffBindCVarName(Tree tree) {
        VariableDecl varDeclC;
        if (tree.down(2).length() == 1) {
            return ILUtils.copy(tree);
        }
        Tree diffBind = ILUtils.copy(tree);
        String bindVarName = tree.down(2).down(2).down(2).stringValue();
        SymbolTable rootCSymbolTable = this.adEnv.diffCallGraph().cRootSymbolTable();
        if (rootCSymbolTable != null && (varDeclC = rootCSymbolTable.getVariableDecl(bindVarName)) != null && varDeclC.isActiveSymbolDecl()) {
            Tree diffDecl = this.varRefDifferentiator().diffSymbolName(this.adEnv.curActivity(), bindVarName, rootCSymbolTable, true, false, false, null, null, false, this.curDiffVarSort(), this.curDiffUnitSort(), 0, null);
            diffBind.down(2).down(2).setChild(diffDecl, 2);
        }
        return diffBind;
    }

    private Tree getDiffTypeDeclTree(SymbolTable diffSymbolTable, String fSuffix, WrapperTypeSpec differentiatedTypeSpec, TypeDecl typeDecl) {
        Tree diffTypeDeclTree = null;
        NewSymbolHolder nSH = typeDecl.getDiffSymbolHolder(0, null, 0);
        if (nSH == null) {
            typeDecl.activeTypeDecl(diffSymbolTable, differentiatedTypeSpec, fSuffix);
            nSH = typeDecl.getDiffSymbolHolder(0, null, 0);
        }
        if (nSH != null) {
            diffTypeDeclTree = nSH.makeNewRef(diffSymbolTable);
        }
        return diffTypeDeclTree;
    }

    protected TapList<Tree> collectTrueTrees(BoolVector boolVector, int[] map, SymbolTable srcSymbolTable) {
        if (boolVector == null) {
            return null;
        }
        TapList<Tree> result = null;
        for (int z = srcSymbolTable.declaredZonesNb(this.adEnv.diffKind) - 1; z >= 0; --z) {
            Tree zoneInfoVisibleAccessTree;
            ZoneInfo zoneInfo;
            if (!boolVector.get(z) || (zoneInfo = srcSymbolTable.declaredZoneInfo(z, this.adEnv.diffKind)) == null || zoneInfo.isHidden || zoneInfo.accessTree == null || zoneInfo.comesFromAllocate() || (zoneInfoVisibleAccessTree = srcSymbolTable.buildZoneVisibleAccessTree(zoneInfo)) == null) continue;
            result = ILUtils.addTreeInList(zoneInfoVisibleAccessTree, result);
        }
        return result;
    }

    private boolean hasActiveSinglePrecision(SymbolTable srcSymbolTable, BoolVector activeAtEntry, BoolVector activeAtExit, int[] map) {
        boolean foundSinglePrecision = false;
        int lastDeclaredZone = srcSymbolTable.declaredZonesNb(this.adEnv.diffKind);
        for (int z = lastDeclaredZone - 1; z >= 0 && !foundSinglePrecision; --z) {
            ZoneInfo zoneInfo;
            if ((activeAtEntry == null || !activeAtEntry.get(z)) && (activeAtExit == null || !activeAtExit.get(z)) || (zoneInfo = srcSymbolTable.declaredZoneInfo(z, this.adEnv.diffKind)) == null || zoneInfo.isHidden || zoneInfo.accessTree == null || zoneInfo.comesFromAllocate()) continue;
            WrapperTypeSpec zoneType = zoneInfo.type;
            int precision = zoneInfo.typeSizeModifier;
            if (precision == -1) {
                precision = zoneType.precisionSize();
            }
            if (zoneType.isRealBase()) {
                if (precision != -3 && (precision <= 0 || precision >= 8)) continue;
                foundSinglePrecision = true;
                continue;
            }
            if (!zoneType.isComplexBase() || precision != -3 && (precision <= 0 || precision >= 16)) continue;
            foundSinglePrecision = true;
        }
        return foundSinglePrecision;
    }

    private final class AccessCheck {
        VariableDecl decl;
        VariableDecl primalDecl;
        boolean isLocalDeclared;
        NewSymbolHolder newSH;

        private AccessCheck(VariableDecl decl, VariableDecl primalDecl, boolean isLocalDeclared, NewSymbolHolder newSH) {
            this.decl = decl;
            this.primalDecl = primalDecl;
            this.isLocalDeclared = isLocalDeclared;
            this.newSH = newSH;
        }
    }
}

