/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.analysis;

import fr.inria.tapenade.analysis.ADActivityAnalyzer;
import fr.inria.tapenade.analysis.ActivityPattern;
import fr.inria.tapenade.analysis.DataFlowAnalyzer;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.BlockStorage;
import fr.inria.tapenade.representation.CallArrow;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.DiffRoot;
import fr.inria.tapenade.representation.HeaderBlock;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.MPIcallInfo;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.BoolMatrix;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.Tree;

public final class ReqExplicit
extends DataFlowAnalyzer {
    private static final int BOTTOMUP_1 = 1;
    private static final int TOPDOWN_2 = 2;
    private static final int BOTTOMUP_3 = 3;
    private static final int TOPDOWN_4 = 4;
    private BlockStorage<BoolVector> infosDown;
    private BlockStorage<BoolVector> infosCycleDown;
    private BlockStorage<BoolVector> infosUp;
    private BlockStorage<BoolVector> infosCycleUp;
    private BlockStorage<BoolMatrix> reqXEffectsDown;
    private BlockStorage<BoolMatrix> reqXEffectsUp;
    private BlockStorage<BoolVector> reqXEffectsAddedDown;
    private BlockStorage<BoolVector> reqXEffectsAddedUp;
    private BlockStorage<BoolVector> avlXEffectsVisibleDown;
    private BlockStorage<BoolVector> avlXEffectsVisibleUp;
    private BlockStorage<BoolVector> avlXEffectsAddedDown;
    private BlockStorage<BoolVector> avlXEffectsAddedUp;
    private BoolVector infoTmp;
    private BoolVector infoTmpCycle;
    private BoolMatrix reqXEffectTmp;
    private BoolVector reqXEffectAddedTmp;
    private BoolVector avlXEffectVisibleTmp;
    private BoolVector avlXEffectAddedTmp;
    private BoolVector additionalInfo;
    private BoolMatrix additionalReqXEffect;
    private BoolVector additionalReqXEffectAdded;
    private BoolVector additionalAvlXEffectAdded;
    private BoolVector additionalAvlXEffectVisible;
    private final int diffKind;
    private int cgPhase;
    private int[] vectorMap;
    private String vectorMapName;
    private int[] vectorMapExit;
    private String vectorMapExitName;
    private int[] diffVectorMap;
    private BlockStorage<TapList<BoolVector>> unitActivities;
    private BlockStorage<TapList<BoolVector>> unitUsefulnesses;
    private BlockStorage<TapList<BoolVector>> unitReqXInfos;
    private BlockStorage<TapList<BoolVector>> curUnitInfos;

    private ReqExplicit(CallGraph callGraph) {
        super(callGraph, "Storage Activity analysis", TapEnv.traceReqExplicit());
        this.conservativeValue = true;
        this.diffKind = TapEnv.diffKind();
    }

    public static void runAnalysis(CallGraph callGraph, TapList<DiffRoot> rootUnits) {
        TapEnv.setReqExplicitAnalyzer(new ReqExplicit(callGraph));
        TapEnv.reqExplicitAnalyzer().run(DiffRoot.collectUnits(rootUnits));
    }

    public static boolean[] formalArgsPointerActivity(ActivityPattern pattern, int nbArgs) {
        Unit unit = pattern.unit();
        boolean[] result = new boolean[nbArgs + 1];
        for (int i = result.length - 1; i >= 0; --i) {
            result[i] = false;
        }
        if (unit.hasParamElemsInfo()) {
            block5: for (int i = unit.paramElemsNb() - 1; i >= 0; --i) {
                ZoneInfo zoneInfo = unit.paramElemZoneInfo(i);
                if (zoneInfo == null) continue;
                switch (zoneInfo.kind()) {
                    case 7: {
                        if (!ReqExplicit.isPointerActiveArg(pattern, i)) continue block5;
                        result[zoneInfo.index - 1] = true;
                        continue block5;
                    }
                    case 10: {
                        if (!ReqExplicit.isPointerActiveArg(pattern, i)) continue block5;
                        result[nbArgs] = true;
                        continue block5;
                    }
                }
            }
        }
        return result;
    }

    public static boolean isPointerActiveArg(ActivityPattern curActivity, int rankInShape) {
        boolean result;
        Unit unit = curActivity.unit();
        if (!unit.hasParamElemsInfo()) {
            return false;
        }
        BoolVector exitReqX = curActivity.exitReqX();
        BoolVector entryAvlX = curActivity.entryAvlX();
        if (exitReqX == null && entryAvlX == null) {
            return false;
        }
        BoolVector entryReqX = curActivity.entryReqX();
        if (TypeSpec.isA(unit.paramElemZoneInfo((int)rankInShape).type, 6)) {
            boolean rkW = true;
            boolean rkRorW = true;
            if (unit.unitInOutR != null) {
                rkW = ReqExplicit.dataOfParamElemOLD(unit.unitInOutW, rankInShape, 0, unit) || ReqExplicit.dataOfParamElemOLD(unit.unitInOutRW, rankInShape, 0, unit);
                rkRorW = rkW || ReqExplicit.dataOfParamElemOLD(unit.unitInOutR, rankInShape, 0, unit);
            }
            result = rkW && exitReqX != null && exitReqX.get(rankInShape) || rkW && entryAvlX != null && entryAvlX.get(rankInShape) || rkRorW && entryReqX != null && entryReqX.get(rankInShape);
        } else {
            result = entryReqX != null && entryReqX.get(rankInShape);
        }
        return result;
    }

    public static void setAnnotatedReqX(ActivityPattern pattern, Tree tree) {
        if (tree != null) {
            ActivityPattern.setAnnotationForActivityPattern(tree, pattern, "ReqXExpr", Boolean.TRUE);
        }
    }

    public static boolean isAnnotatedReqX(ActivityPattern pattern, Tree tree) {
        if (tree == null) {
            return false;
        }
        Object annotationReqX = ActivityPattern.getAnnotationForActivityPattern(tree, pattern, "ReqXExpr");
        return annotationReqX != null && (Boolean)annotationReqX != false;
    }

    public static void copyAnnotation(ActivityPattern curActivity, Tree fromTree, Tree toTree) {
        Object annotationReqX = ActivityPattern.getAnnotationForActivityPattern(fromTree, curActivity, "ReqXExpr");
        if (annotationReqX != null) {
            ActivityPattern.setAnnotationForActivityPattern(toTree, curActivity, "ReqXExpr", annotationReqX);
        }
    }

    @Override
    protected void run(TapList<Unit> rootUnits) {
        TapList<Unit> allCallees;
        String topAnalysisName = this.curAnalysisName;
        TapList<Unit> tapList = allCallees = rootUnits == null ? this.curCallGraph.sortedComputationalUnits() : Unit.allCalleesMulti(rootUnits);
        while (allCallees != null) {
            this.curUnit = (Unit)allCallees.head;
            if ((this.curUnit.isStandard() || this.curUnit.isExternal()) && this.curUnit.activityPatterns == null) {
                ActivityPattern passiveActivityPattern = new ActivityPattern(this.curUnit, true, false, this.diffKind);
                this.curUnit.activityPatterns = new TapList<ActivityPattern>(passiveActivityPattern, this.curUnit.activityPatterns);
            }
            allCallees = allCallees.tail;
        }
        if (TapEnv.mustContext()) {
            TapList<Unit> callersOfRootUnits = Unit.allCallersMulti(rootUnits);
            TapList<Unit> contextUnits = Unit.allCalleesMultiAvoiding(callersOfRootUnits, rootUnits);
            while (contextUnits != null) {
                this.curUnit = (Unit)contextUnits.head;
                if (this.curUnit.isStandard() && !TapList.contains(this.curCallGraph.getRecursivityUnits(), this.curUnit)) {
                    ActivityPattern contextActivityPattern = new ActivityPattern(this.curUnit, true, false, this.diffKind);
                    this.curUnit.activityPatterns = new TapList<ActivityPattern>(contextActivityPattern, this.curUnit.activityPatterns);
                    contextActivityPattern.setContext(true);
                }
                contextUnits = contextUnits.tail;
            }
            rootUnits = null;
        }
        this.cgPhase = 1;
        this.curAnalysisName = "Bottom-up Required Active Storage Analysis";
        this.runBottomUpAnalysis(rootUnits);
        this.cgPhase = 2;
        this.curAnalysisName = "Top-down Required Active Storage Analysis";
        this.runTopDownAnalysis(rootUnits);
        this.curActivity.setReqXEffects(null);
        this.curActivity.setReqXEffectsAdded(null);
        this.cgPhase = 3;
        this.curAnalysisName = "Bottom-up Present Active Storage Analysis";
        this.runBottomUpAnalysis(rootUnits);
        this.cgPhase = 4;
        this.curAnalysisName = "Top-down Present Active Storage Analysis";
        this.runTopDownAnalysis(rootUnits);
        this.curActivity.setAvlXEffectsVisible(null);
        this.curActivity.setAvlXEffectsAdded(null);
        this.topDownContexts = null;
        this.curAnalysisName = topAnalysisName;
        this.cleanEmptyActivities();
    }

    @Override
    protected Object initializeCGForUnit() {
        TapList<ActivityPattern> activities = this.curUnit.activityPatterns;
        while (activities != null) {
            this.curActivity = (ActivityPattern)activities.head;
            switch (this.cgPhase) {
                case 1: {
                    if (this.curUnit.rank() < 0) break;
                    if (this.curUnit.hasParamElemsInfo() && (this.curUnit.isExternal() || this.curUnit.isVarFunction())) {
                        if (this.curActivity.reqXEffects() == null) {
                            this.curActivity.setReqXEffects(this.buildDefaultReqXEffect(this.curUnit));
                            this.curActivity.setReqXEffectsAdded(this.buildDefaultReqXEffectAdded(this.curUnit));
                        }
                    } else {
                        this.curActivity.setReqXEffects(null);
                        this.curActivity.setReqXEffectsAdded(null);
                    }
                    if (!this.curUnit.hasParamElemsInfo()) break;
                    int shapeLength = this.curUnit.paramElemsNb();
                    this.curActivity.setEntryReqX(new BoolVector(shapeLength));
                    this.curActivity.setExitReqX(new BoolVector(shapeLength));
                    if (this.curUnit.publicSymbolTable() == null) break;
                    this.vectorMap = ReqExplicit.makeMap3(this.curUnit, 0);
                    this.vectorMapName = "[s" + this.curUnit.rank() + ":a||d" + this.curUnit.publicSymbolTable().rank() + ":a]";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    if (this.curUnit.rank() < 0) break;
                    if (this.curUnit.hasParamElemsInfo() && (this.curUnit.isExternal() || this.curUnit.isVarFunction())) {
                        if (this.curActivity.avlXEffectsVisible() != null) break;
                        this.curActivity.setAvlXEffectsVisible(this.buildDefaultAvlXEffectVisible(this.curUnit));
                        this.curActivity.setAvlXEffectsAdded(this.buildDefaultAvlXEffectAdded(this.curUnit));
                        break;
                    }
                    this.curActivity.setAvlXEffectsVisible(null);
                    this.curActivity.setAvlXEffectsAdded(null);
                    break;
                }
                default: {
                    if (!this.curUnit.hasParamElemsInfo()) break;
                    int shapeLength = this.curUnit.paramElemsNb();
                    this.curActivity.setEntryAvlX(new BoolVector(shapeLength));
                    this.curActivity.setExitAvlX(new BoolVector(shapeLength));
                }
            }
            activities = activities.tail;
        }
        return null;
    }

    @Override
    protected boolean analyze() {
        TapList<ActivityPattern> activities = this.curUnit.activityPatterns;
        int activityNb = TapList.length(activities);
        int activityRk = 0;
        boolean analysisIsOutOfDate = false;
        while (activities != null) {
            this.curActivity = (ActivityPattern)activities.head;
            ++activityRk;
            if (this.curUnit.hasSource()) {
                TapEnv.printOnTrace(15, " (ActivityPattern " + activityRk + "/" + activityNb + " @" + Integer.toHexString(this.curActivity.hashCode()) + ":)");
            }
            switch (this.cgPhase) {
                case 1: {
                    analysisIsOutOfDate = this.analyzeBackward(null, null, null) || analysisIsOutOfDate;
                    break;
                }
                case 2: {
                    this.curUnitInfos = this.curActivity.reqXs();
                    if (this.curUnitInfos == null) {
                        this.curUnitInfos = new BlockStorage(this.curUnit);
                        this.curActivity.setReqXs(this.curUnitInfos);
                    }
                    this.analyzeBackward(null, null, null);
                    break;
                }
                case 3: {
                    this.unitReqXInfos = this.curActivity.reqXs();
                    if (this.unitReqXInfos == null) {
                        this.unitReqXInfos = new BlockStorage(this.curUnit);
                        this.curActivity.setReqXs(this.unitReqXInfos);
                    }
                    analysisIsOutOfDate = this.analyzeForward(null, null, null) || analysisIsOutOfDate;
                    break;
                }
                default: {
                    this.unitReqXInfos = this.curActivity.reqXs();
                    if (this.unitReqXInfos == null) {
                        this.unitReqXInfos = new BlockStorage(this.curUnit);
                        this.curActivity.setReqXs(this.unitReqXInfos);
                    }
                    this.curUnitInfos = this.curActivity.avlXs();
                    if (this.curUnitInfos == null) {
                        this.curUnitInfos = new BlockStorage(this.curUnit);
                        this.curActivity.setAvlXs(this.curUnitInfos);
                    }
                    this.analyzeForward(null, null, null);
                }
            }
            activities = activities.tail;
        }
        return analysisIsOutOfDate;
    }

    @Override
    protected void terminateCGForUnit() {
        TapList<ActivityPattern> activities = this.curUnit.activityPatterns;
        while (activities != null) {
            this.curActivity = (ActivityPattern)activities.head;
            if (this.cgPhase == 2) {
                this.curUnitInfos = this.curActivity.reqXs();
                BoolVector entryReqX = (BoolVector)this.curUnitInfos.retrieve((Block)this.curUnit.entryBlock()).head;
                if (entryReqX != null) {
                    if (this.curActivity.entryReqX() == null) {
                        this.curActivity.setEntryReqX(entryReqX);
                    } else {
                        this.curActivity.entryReqX().cumulOr(entryReqX);
                    }
                }
            } else if (this.cgPhase == 4) {
                this.curUnitInfos = this.curActivity.avlXs();
                BoolVector exitAvlX = (BoolVector)this.curUnitInfos.retrieve((Block)this.curUnit.exitBlock()).head;
                if (exitAvlX != null) {
                    if (this.curActivity.exitAvlX() == null) {
                        this.curActivity.setExitAvlX(exitAvlX);
                    } else {
                        this.curActivity.exitAvlX().cumulOr(exitAvlX);
                    }
                }
            }
            activities = activities.tail;
        }
    }

    @Override
    protected void setCurBlockEtc(Block block) {
        super.setCurBlockEtc(block);
        if (block == null) {
            this.vectorMapExit = null;
            this.vectorMapExitName = "[?]";
            this.vectorMap = null;
            this.vectorMapName = "[?]";
            this.diffVectorMap = null;
        } else {
            if (this.cgPhase == 1 || this.cgPhase == 3) {
                this.vectorMapExit = ReqExplicit.makeMap3(0, 0, this.curUnit.publicSymbolTable().declaredZonesNb(0));
                this.vectorMapExitName = "[s" + this.curUnit.rank() + ":a||d" + this.curUnit.publicSymbolTable().rank() + ":a]";
            }
            this.vectorMap = ReqExplicit.makeMap3(0, 0, this.nDZ);
            this.vectorMapName = "[s" + this.curUnit.rank() + ":a||d" + this.curSymbolTable.rank() + ":a]";
            this.diffVectorMap = ReqExplicit.makeMap3(0, 0, this.curSymbolTable.declaredZonesNb(this.diffKind));
        }
    }

    @Override
    protected void initializeUnit() {
        this.setCurBlockEtc(this.curUnit.entryBlock());
        if (this.cgPhase == 1 || this.cgPhase == 2) {
            this.unitActivities = this.curActivity.activities();
            this.unitUsefulnesses = this.curActivity.usefulnesses();
        }
        switch (this.cgPhase) {
            case 1: {
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace();
                    TapEnv.printlnOnTrace(" ============== REQUIRED ACTIVE STORAGE ANALYSIS [bottom-up] OF UNIT " + this.curUnit.name() + "(ActivityPattern @" + Integer.toHexString(this.curActivity.hashCode()) + ") : ==============");
                    this.traceDisplayPrivateZones(this.curUnit, this.vectorMap, 0);
                    TapEnv.printlnOnTrace();
                }
                this.reqXEffectsUp = new BlockStorage(this.curUnit);
                this.reqXEffectsDown = new BlockStorage(this.curUnit);
                this.reqXEffectsAddedUp = new BlockStorage(this.curUnit);
                this.reqXEffectsAddedDown = new BlockStorage(this.curUnit);
                break;
            }
            case 2: {
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace();
                    TapEnv.printlnOnTrace(" ============== REQUIRED ACTIVE STORAGE ANALYSIS [top-down] OF UNIT " + this.curUnit.name() + "(ActivityPattern @" + Integer.toHexString(this.curActivity.hashCode()) + ") : ==============");
                    this.traceDisplayPrivateZones(this.curUnit, this.vectorMap, 0);
                    TapEnv.printlnOnTrace();
                }
                this.infosUp = new BlockStorage(this.curUnit);
                this.infosDown = new BlockStorage(this.curUnit);
                this.infosCycleUp = new BlockStorage(this.curUnit);
                this.infosCycleDown = new BlockStorage(this.curUnit);
                break;
            }
            case 3: {
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace();
                    TapEnv.printlnOnTrace(" ============== PRESENT ACTIVE STORAGE ANALYSIS [bottom-up] OF UNIT " + this.curUnit.name() + "(ActivityPattern @" + Integer.toHexString(this.curActivity.hashCode()) + ") : ==============");
                    this.traceDisplayPrivateZones(this.curUnit, this.vectorMap, 0);
                    TapEnv.printlnOnTrace();
                }
                this.avlXEffectsVisibleUp = new BlockStorage(this.curUnit);
                this.avlXEffectsVisibleDown = new BlockStorage(this.curUnit);
                this.avlXEffectsAddedUp = new BlockStorage(this.curUnit);
                this.avlXEffectsAddedDown = new BlockStorage(this.curUnit);
                break;
            }
            default: {
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace();
                    TapEnv.printlnOnTrace(" ============== PRESENT ACTIVE STORAGE ANALYSIS [top-down] OF UNIT " + this.curUnit.name() + "(ActivityPattern @" + Integer.toHexString(this.curActivity.hashCode()) + ") : ==============");
                    this.traceDisplayPrivateZones(this.curUnit, this.vectorMap, 0);
                    TapEnv.printlnOnTrace();
                }
                this.infosUp = new BlockStorage(this.curUnit);
                this.infosDown = new BlockStorage(this.curUnit);
                this.infosCycleUp = new BlockStorage(this.curUnit);
                this.infosCycleDown = new BlockStorage(this.curUnit);
            }
        }
        this.setCurBlockEtc(null);
    }

    @Override
    protected void initializeInitBlock() {
        switch (this.cgPhase) {
            case 1: {
                BoolMatrix initMatrix = new BoolMatrix(this.curUnit.hasTooManyZones(), ReqExplicit.mapSize(this.vectorMap), ReqExplicit.mapSize(this.vectorMapExit));
                initMatrix.setIdentity();
                this.reqXEffectsUp.store(this.curBlock, initMatrix);
                BoolVector initVector = new BoolVector(ReqExplicit.mapSize(this.vectorMap));
                this.reqXEffectsAddedUp.store(this.curBlock, initVector);
                break;
            }
            case 2: {
                BoolVector initReqX = this.curActivity.exitReqX();
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace();
                    TapEnv.printlnOnTrace("   initialized ReqX of :" + this.curBlock + " to " + initReqX);
                }
                this.infosUp.store(this.curBlock, initReqX);
                break;
            }
            case 3: {
                BoolVector initVector = new BoolVector(ReqExplicit.mapSize(this.vectorMap));
                initVector.setTrue();
                this.avlXEffectsVisibleDown.store(this.curBlock, initVector);
                initVector = new BoolVector(ReqExplicit.mapSize(this.vectorMap));
                this.avlXEffectsAddedDown.store(this.curBlock, initVector);
                break;
            }
            default: {
                BoolVector initAvlX = this.curActivity.entryAvlX();
                if (this.curActivity.entryReqX() != null) {
                    initAvlX.cumulOr(this.curActivity.entryReqX());
                }
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace();
                    TapEnv.printlnOnTrace("   initialized AvlX of :" + this.curBlock + " to " + initAvlX);
                }
                this.infosDown.store(this.curBlock, initAvlX);
                break;
            }
        }
    }

    @Override
    protected void terminateFGForBlock() {
        switch (this.cgPhase) {
            case 2: {
                TapList<Object> toReqXs = new TapList<Object>(null, null);
                this.infoTmp = this.infosDown.retrieve(this.curBlock);
                if (this.infoTmp == null) {
                    this.infoTmp = new BoolVector(this.nDZ);
                }
                this.infoTmpCycle = this.infosCycleDown.retrieve(this.curBlock);
                this.propagateAndStoreReqXThroughBlock(this.curBlock, toReqXs);
                this.curUnitInfos.store(this.curBlock, toReqXs.tail);
                break;
            }
            case 4: {
                TapList<Object> toAvlXs = new TapList<Object>(null, null);
                this.infoTmp = this.infosUp.retrieve(this.curBlock);
                if (this.infoTmp == null) {
                    this.infoTmp = new BoolVector(this.nDZ);
                }
                this.infoTmpCycle = this.infosCycleUp.retrieve(this.curBlock);
                this.propagateAndStoreAvlXThroughBlock(this.curBlock, toAvlXs);
                this.curUnitInfos.store(this.curBlock, toAvlXs.tail);
                break;
            }
        }
    }

    @Override
    protected boolean terminateUnit() {
        switch (this.cgPhase) {
            case 1: {
                this.setCurBlockEtc(this.curUnit.entryBlock());
                this.accumulateValuesFromDownstream();
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("  == Private Effect info at the entry Block:");
                    TapEnv.printlnOnTrace("    reqXEffect: " + this.vectorMapName + "*" + this.vectorMapExitName);
                    TapEnv.dumpBoolMatrixOnTrace(this.reqXEffectTmp, this.vectorMap, this.vectorMapExit);
                    TapEnv.printlnOnTrace("    reqXEffectAdded:  " + this.reqXEffectAddedTmp);
                    TapEnv.printlnOnTrace();
                }
                if (this.reqXEffectTmp == null) {
                    this.initializeCumulValue();
                }
                boolean resultChanged = false;
                BoolMatrix oldUnitReqXEffect = this.curActivity.reqXEffects();
                if (oldUnitReqXEffect == null || !this.reqXEffectTmp.equalsBoolMatrix(oldUnitReqXEffect)) {
                    this.curActivity.setReqXEffects(this.reqXEffectTmp);
                    resultChanged = true;
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace(" == NEW reqXEffect for unit " + this.curUnit.name() + "(ActivityPattern @" + Integer.toHexString(this.curActivity.hashCode()) + ") is:");
                        TapEnv.dumpOnTrace(this.reqXEffectTmp);
                        TapEnv.printlnOnTrace();
                    }
                }
                BoolVector unitReqXEffectAdded = this.reqXEffectAddedTmp;
                BoolVector oldUnitReqXEffectAdded = this.curActivity.reqXEffectsAdded();
                if (oldUnitReqXEffectAdded == null || !unitReqXEffectAdded.equals(oldUnitReqXEffectAdded, this.nDZ)) {
                    this.curActivity.setReqXEffectsAdded(unitReqXEffectAdded);
                    resultChanged = true;
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace(" == NEW reqXEffectAdded for unit " + this.curUnit.name() + "(ActivityPattern @" + Integer.toHexString(this.curActivity.hashCode()) + ") is:" + unitReqXEffectAdded);
                    }
                }
                this.setCurBlockEtc(null);
                this.reqXEffectsUp = null;
                this.reqXEffectsDown = null;
                this.reqXEffectsAddedUp = null;
                this.reqXEffectsAddedDown = null;
                return resultChanged;
            }
            case 2: {
                this.curUnitInfos.store(this.curUnit.exitBlock(), new TapList<BoolVector>(this.infosUp.retrieve(this.curUnit.exitBlock()), null));
                this.curUnitInfos.store(this.curUnit.entryBlock(), new TapList<BoolVector>(this.infosDown.retrieve(this.curUnit.entryBlock()), null));
                this.infosUp = null;
                this.infosDown = null;
                this.infosCycleUp = null;
                this.infosCycleDown = null;
                return true;
            }
            case 3: {
                BoolVector oldUnitAvlXEffectAdded;
                this.setCurBlockEtc(this.curUnit.exitBlock());
                this.accumulateValuesFromUpstream();
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("  == Private Effect info at the exit Block:");
                    TapEnv.printlnOnTrace("    avlXEffectVisible: " + this.avlXEffectVisibleTmp);
                    TapEnv.printlnOnTrace("    avlXEffectAdded:   " + this.avlXEffectAddedTmp);
                }
                if (this.avlXEffectVisibleTmp == null) {
                    this.initializeCumulValue();
                }
                boolean resultChanged = false;
                BoolVector oldUnitAvlXEffectVisible = this.curActivity.avlXEffectsVisible();
                if (oldUnitAvlXEffectVisible == null || !this.avlXEffectVisibleTmp.equals(oldUnitAvlXEffectVisible, this.nDZ)) {
                    this.curActivity.setAvlXEffectsVisible(this.avlXEffectVisibleTmp);
                    resultChanged = true;
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace(" == NEW avlXEffectVisible for unit " + this.curUnit.name() + " is:" + this.avlXEffectVisibleTmp);
                    }
                }
                if ((oldUnitAvlXEffectAdded = this.curActivity.avlXEffectsAdded()) == null || !this.avlXEffectAddedTmp.equals(oldUnitAvlXEffectAdded, this.nDZ)) {
                    this.curActivity.setAvlXEffectsAdded(this.avlXEffectAddedTmp);
                    resultChanged = true;
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace(" == NEW avlXEffectAdded   for unit " + this.curUnit.name() + " is:" + this.avlXEffectAddedTmp);
                    }
                }
                this.setCurBlockEtc(null);
                this.avlXEffectsVisibleUp = null;
                this.avlXEffectsVisibleDown = null;
                this.avlXEffectsAddedUp = null;
                this.avlXEffectsAddedDown = null;
                return resultChanged;
            }
        }
        this.curUnitInfos.store(this.curUnit.entryBlock(), new TapList<BoolVector>(this.infosDown.retrieve(this.curUnit.entryBlock()), null));
        this.curUnitInfos.store(this.curUnit.exitBlock(), new TapList<BoolVector>(this.infosUp.retrieve(this.curUnit.exitBlock()), null));
        this.unitActivities = null;
        this.unitUsefulnesses = null;
        this.infosUp = null;
        this.infosDown = null;
        this.infosCycleUp = null;
        this.infosCycleDown = null;
        return true;
    }

    @Override
    protected void setEmptyCumulAndCycleValues() {
        switch (this.cgPhase) {
            case 1: {
                this.reqXEffectTmp = null;
                this.reqXEffectAddedTmp = null;
                break;
            }
            case 3: {
                this.avlXEffectVisibleTmp = null;
                this.avlXEffectAddedTmp = null;
                break;
            }
            default: {
                this.infoTmp = null;
                this.infoTmpCycle = null;
            }
        }
    }

    @Override
    protected boolean getValueFlowingThrough() {
        Block origin = this.curArrow.origin;
        if (this.cgPhase == 3) {
            this.additionalAvlXEffectVisible = this.avlXEffectsVisibleDown.retrieve(origin);
            this.additionalAvlXEffectAdded = this.avlXEffectsAddedDown.retrieve(origin);
            if (TapEnv.traceCurAnalysis()) {
                TapEnv.printlnOnTrace();
                TapEnv.printlnOnTrace("   === Flowing across " + this.curArrow + ": v" + this.additionalAvlXEffectVisible + " a" + this.additionalAvlXEffectAdded);
            }
            return this.additionalAvlXEffectVisible != null;
        }
        this.additionalInfo = ReqExplicit.runSpecialCycleAnalysis(origin) && this.curArrow.containsCase(1) ? this.infosCycleDown.retrieve(origin) : this.infosDown.retrieve(origin);
        if (TapEnv.traceCurAnalysis()) {
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace("   === Flowing across " + this.curArrow + ": " + this.additionalInfo);
        }
        return this.additionalInfo != null;
    }

    @Override
    protected boolean getValueFlowingBack() {
        Block destination = this.curArrow.destination;
        if (this.cgPhase == 1) {
            this.additionalReqXEffect = this.reqXEffectsUp.retrieve(destination);
            this.additionalReqXEffectAdded = this.reqXEffectsAddedUp.retrieve(destination);
            return this.additionalReqXEffect != null;
        }
        this.additionalInfo = ReqExplicit.runSpecialCycleAnalysis(destination) && this.curArrow.finalCycle() == destination.enclosingLoop() ? this.infosCycleUp.retrieve(destination) : this.infosUp.retrieve(destination);
        if (this.additionalInfo == null) {
            return false;
        }
        if (TapEnv.traceCurAnalysis()) {
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace("   === Flowing back across " + this.curArrow + ": " + this.additionalInfo);
        }
        return true;
    }

    @Override
    protected void cumulValueWithAdditional(SymbolTable commonSymbolTable) {
        int commonLength = commonSymbolTable.declaredZonesNb(0);
        switch (this.cgPhase) {
            case 1: {
                if (this.reqXEffectTmp == null) {
                    this.reqXEffectTmp = new BoolMatrix(this.curUnit.hasTooManyZones(), ReqExplicit.mapSize(this.vectorMap), ReqExplicit.mapSize(this.vectorMapExit));
                }
                this.reqXEffectTmp.cumulOr(this.additionalReqXEffect, true, commonLength);
                if (this.reqXEffectAddedTmp == null) {
                    this.reqXEffectAddedTmp = new BoolVector(ReqExplicit.mapSize(this.vectorMap));
                }
                this.reqXEffectAddedTmp.cumulOr(this.additionalReqXEffectAdded, commonLength);
                break;
            }
            case 3: {
                if (this.avlXEffectVisibleTmp == null) {
                    this.avlXEffectVisibleTmp = new BoolVector(ReqExplicit.mapSize(this.vectorMap));
                }
                this.avlXEffectVisibleTmp.cumulOr(this.additionalAvlXEffectVisible, commonLength);
                if (this.avlXEffectAddedTmp == null) {
                    this.avlXEffectAddedTmp = new BoolVector(ReqExplicit.mapSize(this.vectorMap));
                }
                this.avlXEffectAddedTmp.cumulOr(this.additionalAvlXEffectAdded, commonLength);
                break;
            }
            default: {
                if (this.infoTmp == null) {
                    this.infoTmp = new BoolVector(this.nDZ);
                }
                this.infoTmp.cumulOr(this.additionalInfo, commonLength);
            }
        }
    }

    @Override
    protected void cumulCycleValueWithAdditional(SymbolTable commonSymbolTable) {
        switch (this.cgPhase) {
            case 1: 
            case 3: {
                this.cumulValueWithAdditional(commonSymbolTable);
                break;
            }
            default: {
                int commonLength = commonSymbolTable.declaredZonesNb(0);
                if (this.infoTmpCycle == null) {
                    this.infoTmpCycle = new BoolVector(this.nDZ);
                }
                this.infoTmpCycle.cumulOr(this.additionalInfo, commonLength);
            }
        }
    }

    @Override
    protected void initializeCumulValue() {
        if (this.cgPhase == 1) {
            this.reqXEffectTmp = new BoolMatrix(this.curUnit.hasTooManyZones(), ReqExplicit.mapSize(this.vectorMap), ReqExplicit.mapSize(this.vectorMapExit));
            this.reqXEffectTmp.setExplicitZero();
            this.reqXEffectAddedTmp = new BoolVector(ReqExplicit.mapSize(this.vectorMap));
        } else if (this.cgPhase == 2) {
            this.infoTmp = new BoolVector(this.nDZ);
        } else if (this.cgPhase == 3) {
            this.avlXEffectVisibleTmp = new BoolVector(ReqExplicit.mapSize(this.vectorMap));
            this.avlXEffectAddedTmp = new BoolVector(ReqExplicit.mapSize(this.vectorMap));
        }
    }

    @Override
    protected boolean compareUpstreamValues() {
        switch (this.cgPhase) {
            case 1: {
                this.reqXEffectsUp.store(this.curBlock, this.reqXEffectTmp.copy());
                this.reqXEffectsAddedUp.store(this.curBlock, this.reqXEffectAddedTmp.copy());
                return true;
            }
            case 3: {
                boolean modified = false;
                BoolVector oldAvlXEffectVisible = this.avlXEffectsVisibleUp.retrieve(this.curBlock);
                int compareLength = ReqExplicit.mapSize(this.vectorMap);
                if (!(this.avlXEffectVisibleTmp == null || oldAvlXEffectVisible != null && this.avlXEffectVisibleTmp.equals(oldAvlXEffectVisible, compareLength))) {
                    this.avlXEffectsVisibleUp.store(this.curBlock, this.avlXEffectVisibleTmp.copy());
                    modified = true;
                }
                BoolVector oldAvlXEffectAdded = this.avlXEffectsAddedUp.retrieve(this.curBlock);
                if (!(this.avlXEffectAddedTmp == null || oldAvlXEffectAdded != null && this.avlXEffectAddedTmp.equals(oldAvlXEffectAdded, compareLength))) {
                    this.avlXEffectsAddedUp.store(this.curBlock, this.avlXEffectAddedTmp.copy());
                    modified = true;
                }
                return modified;
            }
        }
        return this.compareWithStorage(this.infoTmp, this.infoTmpCycle, this.nDZ, this.infosUp, this.infosCycleUp);
    }

    @Override
    protected boolean compareDownstreamValues() {
        switch (this.cgPhase) {
            case 1: {
                boolean modified = false;
                int compareLength = ReqExplicit.mapSize(this.vectorMap);
                BoolMatrix oldReqXEffect = this.reqXEffectsDown.retrieve(this.curBlock);
                if (!(this.reqXEffectTmp == null || oldReqXEffect != null && this.reqXEffectTmp.equalsBoolMatrix(oldReqXEffect))) {
                    this.reqXEffectsDown.store(this.curBlock, this.reqXEffectTmp.copy());
                    modified = true;
                }
                BoolVector oldReqXEffectAdded = this.reqXEffectsAddedDown.retrieve(this.curBlock);
                if (!(this.reqXEffectAddedTmp == null || oldReqXEffectAdded != null && this.reqXEffectAddedTmp.equals(oldReqXEffectAdded, compareLength))) {
                    this.reqXEffectsAddedDown.store(this.curBlock, this.reqXEffectAddedTmp.copy());
                    modified = true;
                }
                return modified;
            }
            case 3: {
                boolean modified = false;
                int compareLength = ReqExplicit.mapSize(this.vectorMap);
                BoolVector oldAvlXEffectVisible = this.avlXEffectsVisibleDown.retrieve(this.curBlock);
                if (!(this.avlXEffectVisibleTmp == null || oldAvlXEffectVisible != null && this.avlXEffectVisibleTmp.equals(oldAvlXEffectVisible, compareLength))) {
                    this.avlXEffectsVisibleDown.store(this.curBlock, this.avlXEffectVisibleTmp.copy());
                    modified = true;
                }
                BoolVector oldAvlXEffectAdded = this.avlXEffectsAddedDown.retrieve(this.curBlock);
                if (!(this.avlXEffectAddedTmp == null || oldAvlXEffectAdded != null && this.avlXEffectAddedTmp.equals(oldAvlXEffectAdded, compareLength))) {
                    this.avlXEffectsAddedDown.store(this.curBlock, this.avlXEffectAddedTmp.copy());
                    modified = true;
                }
                return modified;
            }
        }
        return this.compareWithStorage(this.infoTmp, this.infoTmpCycle, this.nDZ, this.infosDown, this.infosCycleDown);
    }

    @Override
    protected boolean compareChannelZoneDataUpstream(int mpZone, Block refBlock) {
        return false;
    }

    @Override
    protected boolean compareChannelZoneDataDownstream(int mpZone, Block refBlock) {
        return false;
    }

    @Override
    protected boolean propagateValuesBackwardThroughBlock() {
        if (this.cgPhase == 1) {
            return this.propagateReqXEffectsThroughBlock(this.curBlock);
        }
        return this.propagateAndStoreReqXThroughBlock(this.curBlock, null);
    }

    @Override
    protected boolean propagateValuesForwardThroughBlock() {
        if (this.cgPhase == 3) {
            return this.propagateAvlXEffectsThroughBlock(this.curBlock);
        }
        return this.propagateAndStoreAvlXThroughBlock(this.curBlock, null);
    }

    private boolean propagateReqXEffectsThroughBlock(Block block) {
        BoolVector beforeActiv = null;
        BoolVector afterActiv = null;
        BoolVector afterUseful = null;
        TapList<BoolVector> blockActivities = null;
        TapList<BoolVector> blockUsefulnesses = null;
        if (this.unitActivities != null) {
            blockActivities = TapList.reverse(this.unitActivities.retrieve(block));
            beforeActiv = (BoolVector)blockActivities.head;
        }
        if (this.unitUsefulnesses != null) {
            blockUsefulnesses = TapList.reverse(this.unitUsefulnesses.retrieve(block));
            afterUseful = (BoolVector)blockUsefulnesses.head;
        }
        if (TapEnv.traceCurAnalysis()) {
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace("   === Going up through Block " + block + " ===");
            TapEnv.printlnOnTrace("    reqXEffect: " + this.vectorMapName + "*" + this.vectorMapExitName);
            TapEnv.dumpBoolMatrixOnTrace(this.reqXEffectTmp, this.vectorMap, this.vectorMapExit);
            TapEnv.printlnOnTrace("    reqXEffectAdded:   " + this.reqXEffectAddedTmp);
            TapEnv.printlnOnTrace();
        }
        TapList<Instruction> instructions = TapList.reverse(block.instructions);
        while (instructions != null) {
            this.curInstruction = (Instruction)instructions.head;
            if (blockActivities != null) {
                afterActiv = beforeActiv;
                blockActivities = blockActivities.tail;
                beforeActiv = (BoolVector)blockActivities.head;
            }
            this.reqXEffectThroughExpression(this.curInstruction.tree, -1, null, null, this.reqXEffectTmp, this.reqXEffectAddedTmp, beforeActiv, afterActiv, afterUseful);
            if (TapEnv.traceCurAnalysis()) {
                TapEnv.printlnOnTrace(">>> Now gone upstream across instruction:" + ILUtils.toString(this.curInstruction.tree));
                TapEnv.printlnOnTrace("    reqXEffect: " + this.vectorMapName + "*" + this.vectorMapExitName);
                TapEnv.dumpBoolMatrixOnTrace(this.reqXEffectTmp, this.vectorMap, this.vectorMapExit);
                TapEnv.printlnOnTrace("    reqXEffectAdded:   " + this.reqXEffectAddedTmp);
                TapEnv.printlnOnTrace();
            }
            if (blockUsefulnesses != null) {
                blockUsefulnesses = blockUsefulnesses.tail;
                afterUseful = (BoolVector)blockUsefulnesses.head;
            }
            instructions = instructions.tail;
        }
        this.curInstruction = null;
        return true;
    }

    private boolean propagateAndStoreReqXThroughBlock(Block block, TapList<BoolVector> recordList) {
        BoolVector recordInfo;
        if (TapEnv.traceCurAnalysis()) {
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace("   === Going up through Block " + block + " ===");
        }
        BoolVector beforeActiv = null;
        BoolVector afterActiv = null;
        BoolVector afterUseful = null;
        TapList<BoolVector> blockActivities = null;
        TapList<BoolVector> blockUsefulnesses = null;
        if (this.unitActivities != null) {
            blockActivities = TapList.reverse(this.unitActivities.retrieve(block));
            beforeActiv = (BoolVector)blockActivities.head;
        }
        if (this.unitUsefulnesses != null) {
            blockUsefulnesses = TapList.reverse(this.unitUsefulnesses.retrieve(block));
            afterUseful = (BoolVector)blockUsefulnesses.head;
        }
        this.setUniqueAccessZones(block);
        TapList<Instruction> instructions = block.instructions;
        Instruction initialDo = null;
        boolean runSpecialCycleAnalysis = ReqExplicit.runSpecialCycleAnalysis(block);
        Tree doTree = null;
        if (runSpecialCycleAnalysis) {
            initialDo = (Instruction)instructions.head;
            if (initialDo != null) {
                doTree = initialDo.tree.down(3);
            }
            instructions = instructions.tail;
        }
        if (TapEnv.traceCurAnalysis()) {
            TapEnv.printlnOnTrace("    ReqX:" + this.vectorMapName + " " + this.infoTmp.toString(this.vectorMap) + " (cycling:" + (this.infoTmpCycle == null ? "null" : this.infoTmpCycle.toString(this.vectorMap)) + ")");
        }
        if (recordList != null) {
            recordInfo = this.infoTmp.copy();
            if (this.infoTmpCycle != null) {
                recordInfo.cumulOr(this.infoTmpCycle);
            }
            recordList.tail = new TapList<BoolVector>(recordInfo, null);
            ADActivityAnalyzer.setOnceActiveZonesAndAnnotateDiffDeclsAndTypes(this.infoTmp, this.curSymbolTable, 0, this.nDZ);
        }
        instructions = TapList.reverse(instructions);
        while (instructions != null) {
            this.curInstruction = (Instruction)instructions.head;
            if (blockActivities != null) {
                afterActiv = beforeActiv;
                blockActivities = blockActivities.tail;
                beforeActiv = (BoolVector)blockActivities.head;
            }
            if (recordList != null && TapEnv.modeIsAdjoint()) {
                Tree callExpr = this.curInstruction.tree;
                Tree lhsExpr = null;
                if (callExpr.opCode() == 14 || callExpr.opCode() == 150 || callExpr.opCode() == 125 || callExpr.opCode() == 190 || callExpr.opCode() == 63) {
                    lhsExpr = callExpr.down(1);
                    callExpr = callExpr.down(2);
                }
                if (callExpr.opCode() == 31) {
                    this.curCalledUnit = ReqExplicit.getCalledUnit(callExpr, this.curSymbolTable);
                    if (this.curCalledUnit != null && !"null".equals(this.curCalledUnit.name())) {
                        CallArrow arrow = CallGraph.getCallArrow(this.curUnit, this.curCalledUnit);
                        BoolVector callSiteW = new BoolVector(ReqExplicit.mapSize(this.vectorMap));
                        ReqExplicit.propagateCalleeDataToCallSite(this.curCalledUnit.unitInOutPossiblyW(), callSiteW, lhsExpr, ILUtils.getArguments(callExpr).children(), true, callExpr, this.curInstruction, arrow, this.vectorMap, 0, null, null, false, false);
                        if (!this.curActivity.isContext() && this.infoTmp.intersects(callSiteW, ReqExplicit.mapSize(this.vectorMap)) && this.curInstruction.hasDirective(12) == null && this.curCalledUnit.hasDirective(12) == null) {
                            String diffPointersSet = null;
                            boolean mustSendMessage = false;
                            callSiteW.cumulAnd(this.infoTmp);
                            for (int i = ReqExplicit.mapSize(this.vectorMap) - 1; i >= 0; --i) {
                                if (!callSiteW.get(i)) continue;
                                ZoneInfo zoneInfo = this.vectorIndexToZoneInfo(i, ReqExplicit.getMapClass(i, this.vectorMap), 0, this.vectorMap);
                                if (zoneInfo.ptrZoneNb == -1) continue;
                                mustSendMessage = true;
                                diffPointersSet = zoneInfo.accessTreePrint(this.curUnit.language()) + (diffPointersSet == null ? "" : ", " + diffPointersSet);
                            }
                            if (mustSendMessage) {
                                TapEnv.fileWarning(5, callExpr, "(AD21) This call to " + this.curCalledUnit.name() + " might set pointers that are differentiated (" + diffPointersSet + "). If this is really the case, then this call must not be checkpointed.");
                            }
                        }
                    }
                }
            }
            this.reqXThroughExpression(this.curInstruction.tree, 0, null, this.infoTmp, beforeActiv, afterActiv, afterUseful, recordList != null);
            if (runSpecialCycleAnalysis && this.infoTmpCycle != null) {
                this.reqXThroughExpression(this.curInstruction.tree, 0, null, this.infoTmpCycle, beforeActiv, afterActiv, afterUseful, recordList != null);
            }
            if (TapEnv.traceCurAnalysis()) {
                TapEnv.printlnOnTrace("  Now gone upstream across instruction:" + ILUtils.toString(this.curInstruction.tree));
                TapEnv.printlnOnTrace("    ReqX:" + this.vectorMapName + " " + this.infoTmp.toString(this.vectorMap) + " (cycling:" + (this.infoTmpCycle == null ? "null" : this.infoTmpCycle.toString(this.vectorMap)) + ")");
            }
            if (recordList != null) {
                recordInfo = this.infoTmp.copy();
                if (this.infoTmpCycle != null) {
                    recordInfo.cumulOr(this.infoTmpCycle);
                }
                recordList.tail = new TapList<BoolVector>(recordInfo, recordList.tail);
                ADActivityAnalyzer.setOnceActiveZonesAndAnnotateDiffDeclsAndTypes(this.infoTmp, this.curSymbolTable, 0, this.nDZ);
            }
            if (blockUsefulnesses != null) {
                blockUsefulnesses = blockUsefulnesses.tail;
                afterUseful = (BoolVector)blockUsefulnesses.head;
            }
            instructions = instructions.tail;
        }
        if (initialDo != null) {
            this.curInstruction = initialDo;
            if (blockActivities != null) {
                afterActiv = beforeActiv;
                blockActivities = blockActivities.tail;
                beforeActiv = (BoolVector)blockActivities.head;
            }
            this.reqXThroughExpression(doTree.down(1), 1, null, this.infoTmp, beforeActiv, afterActiv, afterUseful, recordList != null);
            this.reqXThroughExpression(doTree.down(4), -1, null, this.infoTmp, beforeActiv, afterActiv, afterUseful, recordList != null);
            this.reqXThroughExpression(doTree.down(3), -1, null, this.infoTmp, beforeActiv, afterActiv, afterUseful, recordList != null);
            if (runSpecialCycleAnalysis && this.infoTmpCycle != null) {
                this.reqXThroughExpression(doTree.down(1), 1, null, this.infoTmpCycle, beforeActiv, afterActiv, afterUseful, recordList != null);
                this.reqXThroughExpression(doTree.down(4), -1, null, this.infoTmpCycle, beforeActiv, afterActiv, afterUseful, recordList != null);
                this.reqXThroughExpression(doTree.down(3), -1, null, this.infoTmpCycle, beforeActiv, afterActiv, afterUseful, recordList != null);
            }
        }
        BoolVector infoTmpCycleUp = null;
        if (runSpecialCycleAnalysis) {
            if (this.infoTmpCycle != null) {
                infoTmpCycleUp = this.infoTmpCycle.copy();
                infoTmpCycleUp.setDeclared(((HeaderBlock)block).localizedZones, this.vectorMap, false);
            } else {
                infoTmpCycleUp = new BoolVector(this.nDZ);
            }
            if (this.infoTmp != null) {
                infoTmpCycleUp.cumulOr(this.infoTmp);
            }
            if (this.infoTmpCycle != null) {
                if (this.infoTmp == null) {
                    this.infoTmp = this.infoTmpCycle.copy();
                } else {
                    this.infoTmp.cumulAnd(this.directEntryExitMask((HeaderBlock)block, this.vectorMap, 0));
                }
                this.infoTmp.cumulOr(this.infoTmpCycle);
            }
        }
        this.infoTmpCycle = infoTmpCycleUp;
        if (initialDo != null) {
            this.reqXThroughExpression(doTree.down(2), -1, null, this.infoTmp, beforeActiv, afterActiv, afterUseful, recordList != null);
            if (TapEnv.traceCurAnalysis()) {
                TapEnv.printlnOnTrace("  Now gone upstream across initial DO:" + ILUtils.toString(doTree));
                TapEnv.printlnOnTrace("    ReqX:" + this.vectorMapName + " " + this.infoTmp.toString(this.vectorMap) + " (cycling:" + (this.infoTmpCycle == null ? "null" : this.infoTmpCycle.toString(this.vectorMap)) + ")");
            }
            if (recordList != null) {
                BoolVector recordInfo2 = this.infoTmp.copy();
                if (this.infoTmpCycle != null) {
                    recordInfo2.cumulOr(this.infoTmpCycle);
                }
                recordList.tail = new TapList<BoolVector>(recordInfo2, recordList.tail);
                ADActivityAnalyzer.setOnceActiveZonesAndAnnotateDiffDeclsAndTypes(this.infoTmp, this.curSymbolTable, 0, this.nDZ);
            }
        }
        this.curInstruction = null;
        this.uniqueAccessZones = null;
        return true;
    }

    private boolean propagateAvlXEffectsThroughBlock(Block block) {
        TapList<BoolVector> blockReqXs;
        if (TapEnv.traceCurAnalysis()) {
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace("   === Going down through Block " + block + " ===");
            TapEnv.printlnOnTrace("        avlXEffectVisible: " + this.avlXEffectVisibleTmp);
            TapEnv.printlnOnTrace("        avlXEffectAdded:   " + this.avlXEffectAddedTmp);
        }
        if ((blockReqXs = this.unitReqXInfos.retrieve(block)) != null) {
            blockReqXs = blockReqXs.tail;
        }
        TapList<Instruction> instructions = block.instructions;
        while (instructions != null) {
            this.curInstruction = (Instruction)instructions.head;
            this.avlXEffectThroughExpression(this.curInstruction.tree, null, this.avlXEffectVisibleTmp, this.avlXEffectAddedTmp, blockReqXs == null ? null : (BoolVector)blockReqXs.head);
            if (TapEnv.traceCurAnalysis()) {
                TapEnv.printlnOnTrace("        Now gone downstream across instruction:" + ILUtils.toString(this.curInstruction.tree));
                TapEnv.printlnOnTrace("        avlXEffectVisible: " + this.avlXEffectVisibleTmp);
                TapEnv.printlnOnTrace("        avlXEffectAdded:   " + this.avlXEffectAddedTmp);
            }
            if (blockReqXs != null) {
                blockReqXs = blockReqXs.tail;
            }
            instructions = instructions.tail;
        }
        this.curInstruction = null;
        return true;
    }

    private boolean propagateAndStoreAvlXThroughBlock(Block block, TapList<BoolVector> recordList) {
        if (this.infoTmp != null) {
            if (this.infoTmpCycle != null) {
                this.infoTmp.cumulOr(this.infoTmpCycle);
            }
        } else {
            this.infoTmp = this.infoTmpCycle;
        }
        TapList<BoolVector> blockReqXs = this.unitReqXInfos.retrieve(block);
        if (TapEnv.traceCurAnalysis()) {
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace("   === Going down through Block " + block + " ===");
            TapEnv.printlnOnTrace("        AvlX:" + this.infoTmp);
        }
        if (blockReqXs != null) {
            this.infoTmp.cumulOr((BoolVector)blockReqXs.head);
            if (TapEnv.traceCurAnalysis()) {
                TapEnv.printlnOnTrace("    --> AvlX:" + this.infoTmp + " after adding ReqX:" + blockReqXs.head);
            }
            blockReqXs = blockReqXs.tail;
        }
        if (recordList != null) {
            BoolVector recordInfo = this.infoTmp.copy();
            recordList = recordList.placdl(recordInfo);
        }
        TapList<Instruction> instructions = block.instructions;
        while (instructions != null) {
            this.curInstruction = (Instruction)instructions.head;
            this.avlXThroughExpression(this.curInstruction.tree, null, this.infoTmp, blockReqXs == null ? null : (BoolVector)blockReqXs.head);
            if (blockReqXs != null) {
                this.infoTmp.cumulOr((BoolVector)blockReqXs.head);
            }
            if (TapEnv.traceCurAnalysis()) {
                TapEnv.printlnOnTrace("        Now gone across instruction:" + ILUtils.toString(this.curInstruction.tree));
                TapEnv.printlnOnTrace("        AvlX:" + this.vectorMapName + " " + this.infoTmp.toString(this.vectorMap));
            }
            if (blockReqXs != null) {
                blockReqXs = blockReqXs.tail;
            }
            if (recordList != null) {
                recordList = recordList.placdl(this.infoTmp.copy());
            }
            instructions = instructions.tail;
        }
        if (ReqExplicit.runSpecialCycleAnalysis(block)) {
            this.infoTmpCycle = this.infoTmp.copy();
        }
        this.curInstruction = null;
        return true;
    }

    private void reqXEffectThroughExpression(Tree expression, int act, TapList treeRE, TapList treeREA, BoolMatrix reqXEffect, BoolVector reqXEffectAdded, BoolVector beforeActiv, BoolVector afterActiv, BoolVector afterUseful) {
        switch (expression.opCode()) {
            case 14: 
            case 52: 
            case 63: 
            case 125: 
            case 140: 
            case 150: 
            case 168: 
            case 190: {
                boolean totalAccess;
                Tree lhs;
                boolean isReturn;
                boolean deallocOrNullify = expression.opCode() == 52 || expression.opCode() == 140;
                boolean bl = isReturn = expression.opCode() == 168;
                if (isReturn) {
                    String returnVarName = this.curUnit.otherReturnVar() == null ? this.curUnit.name() : this.curUnit.otherReturnVar().symbol;
                    lhs = ILUtils.build(96, returnVarName);
                } else {
                    lhs = expression.down(1);
                }
                Object rhs = isReturn ? expression.down(1) : (deallocOrNullify ? null : expression.down(2));
                ToBool lhsTotal = new ToBool(false);
                TapList<?> writtenZonesTree = this.curSymbolTable.treeOfZonesOfValue(lhs, lhsTotal, this.curInstruction, null);
                if (isReturn && writtenZonesTree != null) {
                    writtenZonesTree = TapList.copyTree(writtenZonesTree);
                    this.includePointedElementsInTree(writtenZonesTree, null, null, true, false, false);
                    TapList.removeNonWritableZones(writtenZonesTree);
                }
                boolean bl2 = totalAccess = this.referenceIsTotal(lhsTotal.get(), writtenZonesTree) && expression.opCode() == 14 && (!this.inADeclaration || !this.curUnit.isFortran());
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("  Start propagating ReqX Effect upstream through: " + ILUtils.toString(expression) + " written zones: " + writtenZonesTree + (totalAccess ? "(total)" : "(non-total)"));
                }
                if (!deallocOrNullify) {
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace("  downcoming ReqX effect trees          treeRE: " + treeRE + " and treeREA: " + treeREA);
                    }
                    treeRE = TapList.cumulWithOper(treeRE, this.buildInfoPRZVTreeOfExtendedDeclared(writtenZonesTree, reqXEffect, 0, this.vectorMap), 91);
                    treeREA = TapList.cumulWithOper(treeREA, ReqExplicit.buildInfoBoolTreeOfDeclaredZones(writtenZonesTree, reqXEffectAdded, this.vectorMap, null, 0, this.curSymbolTable), 91);
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace("  modified ReqX effect trees with lhs treeRE: " + treeRE + " and treeREA: " + treeREA);
                    }
                }
                this.reqXEffectThroughExpression(lhs, 1, treeRE, treeREA, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                if (totalAccess) {
                    this.setInfoPRZVTreeToExtendedDeclaredZones(reqXEffect, this.vectorMapExit, writtenZonesTree, new TapList<BoolVector>(new BoolVector(ReqExplicit.mapSize(this.vectorMapExit)), null), null, true, 0);
                    this.setInfoBoolTreeToExtendedDeclaredZones(reqXEffectAdded, this.vectorMap, writtenZonesTree, false, null, true, 0);
                } else {
                    this.setInfoPRZVTreeToExtendedDeclaredZones(reqXEffect, this.vectorMapExit, writtenZonesTree, new TapList<BoolVector>(new BoolVector(ReqExplicit.mapSize(this.vectorMapExit)), null), null, false, 0);
                }
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("  propagating to rhs: treeRE: " + treeRE + " and treeREA: " + treeREA);
                }
                if (!deallocOrNullify && !ILUtils.isNullOrNone((Tree)rhs)) {
                    this.reqXEffectThroughExpression((Tree)rhs, -1, treeRE, treeREA, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                }
                if (!TapEnv.traceCurAnalysis()) break;
                TapEnv.printlnOnTrace("  >Done propagating reqX Effect upstream through: " + ILUtils.toString(expression));
                break;
            }
            case 9: 
            case 75: 
            case 96: 
            case 151: {
                if (act != 0) {
                    boolean diffExprExists;
                    boolean diffExprExistsA = this.diffExprExists(expression, treeREA, act, beforeActiv, afterActiv, afterUseful);
                    BoolVector conditionDiffExpr = new BoolVector(reqXEffect.nCols);
                    ReqExplicit.cumulOr(treeRE, conditionDiffExpr, true);
                    boolean bl = diffExprExists = !conditionDiffExpr.isFalse(reqXEffect.nCols);
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace("     " + (act == -1 ? "READ" : (act == 1 ? "WRITTEN" : "UNUSED")) + " var reference " + ILUtils.toString(expression) + " differentiated:" + diffExprExistsA + " or " + conditionDiffExpr);
                    }
                    if (diffExprExists || diffExprExistsA) {
                        TapIntList usedPointerRanks = this.collectUsedPointerRanks(expression, null, false);
                        if (TapEnv.traceCurAnalysis()) {
                            TapEnv.printlnOnTrace("          usedPointerRanks of " + expression + " : " + usedPointerRanks);
                        }
                        if (diffExprExistsA) {
                            reqXEffectAdded.set(usedPointerRanks, true);
                        }
                        if (diffExprExists) {
                            reqXEffect.cumulRows(usedPointerRanks, conditionDiffExpr);
                        }
                    }
                }
                if (act == -1 && (treeRE != null || treeREA != null)) {
                    TapList<?> accessedZonesTree = this.curSymbolTable.treeOfZonesOfValue(expression, null, this.curInstruction, null);
                    if (accessedZonesTree != null) {
                        accessedZonesTree = TapList.copyTree(accessedZonesTree);
                        this.includePointedElementsInTree(accessedZonesTree, null, null, true, false, true);
                    }
                    if (treeRE != null) {
                        this.setInfoPRZVTreeToExtendedDeclaredZones(reqXEffect, this.vectorMapExit, accessedZonesTree, treeRE, null, false, 0);
                    }
                    if (treeREA != null) {
                        this.setInfoBoolTreeToExtendedDeclaredZones(reqXEffectAdded, this.vectorMap, accessedZonesTree, treeREA, null, false, 0);
                    }
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace("  RHS of assignment (zones:" + accessedZonesTree + ')');
                        TapEnv.printlnOnTrace("   received treeRE: " + treeRE + " and treeREA: " + treeREA);
                    }
                }
                if (expression.opCode() == 96) break;
                this.reqXEffectThroughExpression(expression.down(1), 0, null, null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                if (expression.opCode() == 75) break;
                this.reqXEffectThroughExpression(expression.down(2), 0, null, null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                break;
            }
            case 4: {
                TapList<Object> tmpAccessedZonesTree;
                if (act == 0) break;
                Tree inside = expression.down(1);
                int insideOp = inside.opCode();
                if (insideOp == 151) {
                    this.reqXEffectThroughExpression(inside.down(1), act, treeRE, treeREA, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                    this.reqXEffectThroughExpression(inside.down(2), 0, null, null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                    break;
                }
                if (treeRE == null && treeREA == null) break;
                if (insideOp == 75) {
                    TapList<?> accessedZonesTreeOfStruct = this.curSymbolTable.treeOfZonesOfValue(inside.down(1), null, this.curInstruction, null);
                    if (accessedZonesTreeOfStruct != null) {
                        accessedZonesTreeOfStruct = TapList.copyTree(accessedZonesTreeOfStruct);
                        this.includePointedElementsInTree(accessedZonesTreeOfStruct, null, null, true, false, true);
                    }
                    int fieldRank = ILUtils.getFieldRank(inside.down(2));
                    tmpAccessedZonesTree = new TapList<Object>(null, new TapList<Object>(TapList.nth(accessedZonesTreeOfStruct, fieldRank), null));
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace("     (address of field) ref-expression:" + expression + " with tmpZones:" + tmpAccessedZonesTree + "   receives treeRE: " + treeRE + " and treeREA: " + treeREA);
                    }
                } else {
                    tmpAccessedZonesTree = this.curSymbolTable.treeOfZonesOfValue(inside, null, this.curInstruction, null);
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace("     (address of ref) ref-expression:" + expression + " with zones:" + tmpAccessedZonesTree + "   receives treeRE: " + treeRE + " and treeREA: " + treeREA);
                    }
                }
                if (treeRE != null) {
                    this.setInfoPRZVTreeToExtendedDeclaredZones(reqXEffect, this.vectorMapExit, tmpAccessedZonesTree, treeRE, null, false, 0);
                }
                if (treeREA == null) break;
                this.setInfoBoolTreeToExtendedDeclaredZones(reqXEffectAdded, this.vectorMap, tmpAccessedZonesTree, treeREA, null, false, 0);
                break;
            }
            case 31: {
                this.curCalledUnit = ReqExplicit.getCalledUnit(expression, this.curSymbolTable);
                ActivityPattern curCalledActivity = (ActivityPattern)ActivityPattern.getAnnotationForActivityPattern(expression, this.curActivity, "multiActivityCalleePatterns");
                if (curCalledActivity == null) {
                    curCalledActivity = this.curCalledUnit.isExternal() || this.curCalledUnit.isIntrinsic() ? this.createTemporaryDummyEmptyActivityPattern(this.curCalledUnit) : this.getOrCreateCalledActivityPattern(this.curActivity, this.curCalledUnit, expression);
                }
                if (this.curCalledUnit == null || !this.curCalledUnit.hasParamElemsInfo()) break;
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("  Start propagating ReqX Effect upstream through call: " + ILUtils.toString(expression));
                    TapEnv.printlnOnTrace("    called Activity Pattern:" + curCalledActivity);
                    TapEnv.printlnOnTrace("    reqXEffect arriving from downstream: " + this.vectorMapName + "*" + this.vectorMapExitName);
                    TapEnv.dumpBoolMatrixOnTrace(reqXEffect, this.vectorMap, this.vectorMapExit);
                    TapEnv.printlnOnTrace("    and reqXEffectAdded: " + this.vectorMapName + " " + reqXEffectAdded);
                }
                CallArrow arrow = CallGraph.getCallArrow(this.curUnit, this.curCalledUnit);
                Tree[] actualParams = ILUtils.getArguments(expression).children();
                int nbActualParams = actualParams.length;
                BoolMatrix calleeRE = this.getReqXEffect(curCalledActivity);
                BoolVector calleeREA = this.getReqXEffectAdded(curCalledActivity);
                BoolVector calleeTouched = this.curCalledUnit.unitInOutPossiblyRorW();
                if (calleeTouched != null) {
                    this.removeNotUsedAtAll(calleeTouched, calleeRE, calleeREA);
                }
                BoolVector touched = new BoolVector(this.nDZ);
                ReqExplicit.propagateCalleeDataToCallSite(calleeTouched, touched, null, actualParams, true, expression, this.curInstruction, arrow, this.vectorMap, 0, null, null, false, false);
                TapList[] paramDataS = new TapList[1 + nbActualParams];
                for (int i = nbActualParams; i >= 1; --i) {
                    paramDataS[i] = null;
                }
                paramDataS[0] = treeRE;
                BoolMatrix onCalleeRE = ReqExplicit.propagateCallSiteDataToCallee(reqXEffect, paramDataS, null, actualParams, false, expression, this.curInstruction, arrow, this.vectorMap, 0, false);
                paramDataS[0] = treeREA;
                BoolVector onCalleeREA = ReqExplicit.propagateCallSiteDataToCallee(reqXEffectAdded, paramDataS, null, actualParams, false, expression, this.curInstruction, arrow, this.vectorMap, 0, false);
                onCalleeREA.cumulAnd(calleeTouched);
                String calledMapName = "[x" + this.curCalledUnit.rank() + ":a]";
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("    downcoming ReqX Effect info on callee: " + calledMapName + "*" + calledMapName);
                    TapEnv.dumpOnTrace(onCalleeRE);
                    TapEnv.printlnOnTrace("     and REA on callee: " + calledMapName + " " + onCalleeREA);
                    TapEnv.printlnOnTrace();
                }
                if (curCalledActivity.exitReqX() != null) {
                    curCalledActivity.exitReqX().cumulOr(onCalleeREA);
                }
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("  (note touched:" + touched);
                    TapEnv.printlnOnTrace("        and RoW:" + this.curCalledUnit.unitInOutPossiblyRorW() + ")");
                    TapEnv.printlnOnTrace("    pushed through calleeRE: " + calledMapName + "*" + calledMapName);
                    TapEnv.dumpOnTrace(calleeRE);
                    TapEnv.printlnOnTrace("     and calleeREA: " + calledMapName + " " + calleeREA);
                    TapEnv.printlnOnTrace();
                }
                onCalleeRE = calleeRE.times(onCalleeRE);
                onCalleeREA = calleeRE.times(onCalleeREA).or(calleeREA);
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("    gives upgoing ReqX Effect info on callee: " + calledMapName + "*" + calledMapName);
                    TapEnv.dumpOnTrace(onCalleeRE);
                    TapEnv.printlnOnTrace("     and REA on callee: " + calledMapName + " " + onCalleeREA);
                    TapEnv.printlnOnTrace();
                }
                if (curCalledActivity.entryReqX() != null) {
                    curCalledActivity.entryReqX().cumulOr(onCalleeREA);
                }
                BoolVector callSiteKilled = new BoolVector(this.nDZ);
                ReqExplicit.propagateCalleeDataToCallSite(this.curCalledUnit.unitInOutCertainlyW(), callSiteKilled, null, actualParams, true, expression, this.curInstruction, arrow, this.vectorMap, 0, null, null, false, true);
                TapList[] argsRE = ReqExplicit.propagateCalleeDataToCallSite(onCalleeRE, reqXEffect, null, null, true, expression, this.curInstruction, arrow, this.vectorMap, 0, touched, callSiteKilled.not(), true, calleeTouched);
                TapList[] argsREA = ReqExplicit.propagateCalleeDataToCallSite(onCalleeREA, reqXEffectAdded, null, null, true, expression, this.curInstruction, arrow, this.vectorMap, 0, null, callSiteKilled.not(), true, false);
                if (ADActivityAnalyzer.isAnnotatedActive(this.curActivity, expression, this.curSymbolTable) || TapEnv.mustContext()) {
                    ReqExplicit.propagateDiffParamsRequired(expression, null, arrow, actualParams, curCalledActivity, this.curInstruction, this.curActivity);
                }
                boolean[] formalArgsActive = ADActivityAnalyzer.formalArgsActivity(curCalledActivity);
                if (TapEnv.traceCurAnalysis() && nbActualParams > 0) {
                    TapEnv.printlnOnTrace("     now pushing up through actual args:");
                }
                for (int i = nbActualParams - 1; i >= 0; --i) {
                    boolean diffExprExists;
                    boolean diffExprExistsA = TapList.oneTrue(argsREA[1 + i]) || formalArgsActive != null && i < formalArgsActive.length && formalArgsActive[i];
                    BoolVector conditionDiffExpr = new BoolVector(reqXEffect.nCols);
                    ReqExplicit.cumulOr(argsRE[1 + i], conditionDiffExpr, true);
                    boolean bl = diffExprExists = !conditionDiffExpr.isFalse(reqXEffect.nCols);
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace("       #" + (i + 1) + ": " + argsRE[1 + i] + ", unconditional:" + argsREA[1 + i]);
                    }
                    if ((diffExprExists || diffExprExistsA) && formalArgsActive != null && i < formalArgsActive.length && formalArgsActive[i] && this.curUnit.language() != this.curCalledUnit.language() && !arrow.takesArgumentByValue(i + 1) && argsREA[1 + i].tail != null) {
                        argsREA[1 + i].head = Boolean.TRUE;
                    }
                    this.reqXEffectThroughExpression(actualParams[i], -1, argsRE[1 + i], argsREA[1 + i], reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                    if (!diffExprExists && !diffExprExistsA) continue;
                    TapIntList usedPointerRanks = this.collectUsedPointerRanks(actualParams[i], null, false);
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace("       also arg is pointer-active, usedPointerRanks=" + usedPointerRanks);
                    }
                    if (diffExprExistsA) {
                        reqXEffectAdded.set(usedPointerRanks, true);
                    }
                    if (!diffExprExists) continue;
                    reqXEffect.cumulRows(usedPointerRanks, conditionDiffExpr);
                }
                if (!TapEnv.traceCurAnalysis()) break;
                TapEnv.printlnOnTrace();
                TapEnv.printlnOnTrace("  >Done propagating ReqX Effect upstream through call: " + ILUtils.toString(expression));
                TapEnv.printlnOnTrace("    reqXEffect propagated upstream: " + this.vectorMapName + "*" + this.vectorMapExitName);
                TapEnv.dumpBoolMatrixOnTrace(reqXEffect, this.vectorMap, this.vectorMapExit);
                TapEnv.printlnOnTrace("     and reqXEffectAdded: " + this.vectorMapName + " " + reqXEffectAdded);
                break;
            }
            case 3: 
            case 182: {
                boolean argIsPointer = TypeSpec.isA(this.curSymbolTable.typeOf(expression.down(1)), 6);
                this.reqXEffectThroughExpression(expression.down(1), -1, argIsPointer ? treeRE : null, argIsPointer ? treeREA : null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                argIsPointer = TypeSpec.isA(this.curSymbolTable.typeOf(expression.down(2)), 6);
                this.reqXEffectThroughExpression(expression.down(2), -1, argIsPointer ? treeRE : null, argIsPointer ? treeREA : null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                break;
            }
            case 6: 
            case 18: 
            case 22: 
            case 24: 
            case 42: 
            case 43: 
            case 62: 
            case 68: 
            case 92: 
            case 95: 
            case 110: 
            case 115: 
            case 116: 
            case 122: 
            case 126: 
            case 133: 
            case 137: 
            case 143: 
            case 155: 
            case 169: 
            case 207: {
                this.reqXEffectThroughExpression(expression.down(1), -1, null, null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                this.reqXEffectThroughExpression(expression.down(2), -1, null, null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                break;
            }
            case 80: 
            case 98: 
            case 124: 
            case 139: 
            case 176: 
            case 184: 
            case 189: 
            case 196: 
            case 205: 
            case 206: {
                this.reqXEffectThroughExpression(expression.down(1), -1, null, null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                break;
            }
            case 11: {
                this.reqXEffectThroughExpression(expression.down(1), 1, null, null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                break;
            }
            case 194: {
                boolean argIsPointer = TypeSpec.isA(this.curSymbolTable.typeOf(expression.down(2)), 6);
                this.reqXEffectThroughExpression(expression.down(2), act, argIsPointer ? treeRE : null, argIsPointer ? treeREA : null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                break;
            }
            case 32: 
            case 47: 
            case 134: {
                this.reqXEffectThroughExpression(expression.down(2), act, null, null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                break;
            }
            case 121: {
                this.reqXEffectThroughExpression(expression.down(3), act, null, null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                break;
            }
            case 64: 
            case 82: {
                this.reqXEffectThroughExpression(expression.down(1), 1, null, null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                this.reqXEffectThroughExpression(expression.down(2), -1, null, null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                this.reqXEffectThroughExpression(expression.down(3), -1, null, null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                this.reqXEffectThroughExpression(expression.down(4), -1, null, null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                break;
            }
            case 81: {
                this.reqXEffectThroughExpression(expression.down(1), -1, null, null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                this.reqXEffectThroughExpression(expression.down(2), -1, null, null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                break;
            }
            case 79: {
                this.reqXEffectThroughExpression(expression.down(1), -1, null, null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                this.reqXEffectThroughExpression(expression.down(2), -1, null, null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                this.reqXEffectThroughExpression(expression.down(3), 1, null, null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                break;
            }
            case 99: {
                this.reqXEffectThroughExpression(expression.down(1), -1, null, null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                this.reqXEffectThroughExpression(expression.down(2), -1, null, null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                this.reqXEffectThroughExpression(expression.down(3), -1, null, null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                break;
            }
            case 12: {
                this.reqXEffectThroughExpression(expression.down(1), -1, null, null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                this.reqXEffectThroughExpression(expression.down(2), -1, null, null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                this.reqXEffectThroughExpression(expression.down(3), -1, null, null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                break;
            }
            case 10: 
            case 71: 
            case 83: {
                Tree[] sons = expression.children();
                for (int i = sons.length - 1; i >= 0; --i) {
                    this.reqXEffectThroughExpression(sons[i], act, null, null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                }
                break;
            }
            case 199: {
                Tree[] decls = expression.down(3).children();
                this.inADeclaration = true;
                for (int i = decls.length - 1; i >= 0; --i) {
                    if (decls[i].opCode() != 14) continue;
                    ILUtils.turnAssignFromInitDecl(decls[i]);
                    this.reqXEffectThroughExpression(decls[i], -1, null, null, reqXEffect, reqXEffectAdded, beforeActiv, afterActiv, afterUseful);
                    ILUtils.resetAssignFromInitDecl(decls[i]);
                }
                this.inADeclaration = false;
                break;
            }
            case 144: 
            case 145: {
                break;
            }
            case 36: 
            case 46: 
            case 56: 
            case 89: {
                break;
            }
            case 2: 
            case 5: 
            case 13: 
            case 15: 
            case 20: 
            case 28: 
            case 29: 
            case 30: 
            case 35: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 49: 
            case 51: 
            case 67: 
            case 69: 
            case 74: 
            case 78: 
            case 85: 
            case 91: 
            case 94: 
            case 101: 
            case 103: 
            case 104: 
            case 106: 
            case 108: 
            case 109: 
            case 111: 
            case 118: 
            case 129: 
            case 135: 
            case 138: 
            case 154: 
            case 160: 
            case 161: 
            case 171: 
            case 177: 
            case 179: 
            case 180: 
            case 181: 
            case 192: 
            case 195: 
            case 197: 
            case 202: 
            case 204: {
                break;
            }
            default: {
                TapEnv.toolWarning(-1, "(ReqX Effect analysis) Unexpected operator: " + expression.opName());
            }
        }
    }

    private void reqXThroughExpression(Tree expression, int act, TapList reqXTree, BoolVector reqX, BoolVector beforeActiv, BoolVector afterActiv, BoolVector afterUseful, boolean lastSweep) {
        boolean exprIsPointer = false;
        if (lastSweep) {
            exprIsPointer = TypeSpec.isA(this.curSymbolTable.typeOf(expression), 6);
        }
        if (lastSweep && exprIsPointer && TapList.oneTrue(reqXTree)) {
            ReqExplicit.setAnnotatedReqX(this.curActivity, expression);
        }
        switch (expression.opCode()) {
            case 14: 
            case 52: 
            case 63: 
            case 125: 
            case 140: 
            case 150: 
            case 168: 
            case 190: {
                boolean totalAccess;
                Tree lhs;
                boolean isReturn;
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("  Start propagating ReqX upstream through: " + ILUtils.toString(expression));
                    TapEnv.printlnOnTrace("    downcoming ReqX:" + this.vectorMapName + " " + reqX.toString(this.vectorMap));
                }
                boolean deallocOrNullify = expression.opCode() == 52 || expression.opCode() == 140;
                boolean bl = isReturn = expression.opCode() == 168;
                if (isReturn) {
                    String returnVarName = this.curUnit.otherReturnVar() == null ? this.curUnit.name() : this.curUnit.otherReturnVar().symbol;
                    lhs = ILUtils.build(96, returnVarName);
                } else {
                    lhs = expression.down(1);
                }
                Object rhs = isReturn ? expression.down(1) : (deallocOrNullify ? null : expression.down(2));
                ToBool lhsTotal = new ToBool(false);
                TapList<?> writtenZonesTree = this.curSymbolTable.treeOfZonesOfValue(lhs, lhsTotal, this.curInstruction, null);
                if (isReturn && writtenZonesTree != null) {
                    writtenZonesTree = TapList.copyTree(writtenZonesTree);
                    this.includePointedElementsInTree(writtenZonesTree, null, null, true, false, false);
                }
                TapList.removeNonWritableZones(writtenZonesTree);
                boolean bl2 = totalAccess = this.referenceIsTotal(lhsTotal.get(), writtenZonesTree) && expression.opCode() == 14 && (!this.inADeclaration || !this.curUnit.isFortran());
                if (!deallocOrNullify) {
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace("    and downcoming ReqX tree     : " + reqXTree);
                    }
                    reqXTree = TapList.cumulWithOper(reqXTree, ReqExplicit.buildInfoBoolTreeOfDeclaredZones(writtenZonesTree, reqX, this.vectorMap, null, 0, this.curSymbolTable), 91);
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace("    modified ReqX tree with lhs: " + writtenZonesTree + " => " + reqXTree);
                    }
                }
                if (!isReturn) {
                    this.reqXThroughExpression(lhs, 1, reqXTree, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                    if (totalAccess) {
                        this.setInfoBoolTreeToExtendedDeclaredZones(reqX, this.vectorMap, writtenZonesTree, false, null, true, 0);
                    }
                }
                if (lastSweep && exprIsPointer && TapList.oneTrue(reqXTree)) {
                    if (!isReturn) {
                        ReqExplicit.setAnnotatedReqX(this.curActivity, lhs);
                    } else {
                        ReqExplicit.setAnnotatedReqX(this.curActivity, (Tree)rhs);
                    }
                    ReqExplicit.setAnnotatedReqX(this.curActivity, expression);
                }
                if (!deallocOrNullify) {
                    this.reqXThroughExpression((Tree)rhs, -1, reqXTree, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                }
                if (!TapEnv.traceCurAnalysis()) break;
                TapEnv.printlnOnTrace("  >Done propagating ReqX upstream through: " + ILUtils.toString(expression));
                break;
            }
            case 9: 
            case 75: 
            case 96: 
            case 151: {
                boolean diffExprExists;
                if (act != 0 && (diffExprExists = this.diffExprExists(expression, reqXTree, act, beforeActiv, afterActiv, afterUseful))) {
                    TapIntList usedPointerRanks = this.collectUsedPointerRanks(expression, null, true);
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace("          usedPointerRanks of " + expression + " : " + usedPointerRanks);
                    }
                    reqX.set(usedPointerRanks, true);
                }
                if (act == -1 && reqXTree != null) {
                    TapList<?> accessedZonesTree = this.curSymbolTable.treeOfZonesOfValue(expression, null, this.curInstruction, null);
                    if (accessedZonesTree != null) {
                        accessedZonesTree = TapList.copyTree(accessedZonesTree);
                        this.includePointedElementsInTree(accessedZonesTree, null, null, true, false, true);
                    }
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace("     ref-expression:" + expression + " with zones:" + accessedZonesTree + " accessed " + (act == -1 ? "Read" : "Write") + " to provide for " + reqXTree);
                    }
                    this.setInfoBoolTreeToExtendedDeclaredZones(reqX, this.vectorMap, accessedZonesTree, reqXTree, null, false, 0);
                    if (lastSweep && TapList.oneTrue(reqXTree)) {
                        this.setRefAnnotatedReqX(this.curActivity, expression);
                    }
                }
                if (expression.opCode() == 96) break;
                this.reqXThroughExpression(expression.down(1), 0, null, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                if (expression.opCode() == 75) break;
                this.reqXThroughExpression(expression.down(2), 0, null, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                break;
            }
            case 4: {
                if (act == 0 || !TapList.oneTrue(reqXTree)) break;
                Tree inside = expression.down(1);
                int insideOp = inside.opCode();
                if (insideOp == 151) {
                    this.reqXThroughExpression(inside.down(1), act, reqXTree, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                    this.reqXThroughExpression(inside.down(2), 0, null, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                    break;
                }
                if (insideOp == 75) {
                    TapList<?> accessedZonesTreeOfStruct = this.curSymbolTable.treeOfZonesOfValue(inside.down(1), null, this.curInstruction, null);
                    int fieldRank = ILUtils.getFieldRank(inside.down(2));
                    TapList<Object> tmpAccessedZonesTree = new TapList<Object>(null, new TapList<Object>(TapList.nth(accessedZonesTreeOfStruct, fieldRank), null));
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace("     (address of field) ref-expression:" + expression + " with tmpZones:" + tmpAccessedZonesTree + " accessed " + (act == -1 ? "Read" : "Write") + " to provide for " + reqXTree);
                    }
                    this.setInfoBoolTreeToExtendedDeclaredZones(reqX, this.vectorMap, tmpAccessedZonesTree, reqXTree, null, false, 0);
                }
                TapList<?> accessedZonesTree = this.curSymbolTable.treeOfZonesOfValue(ILUtils.baseTree(inside), null, this.curInstruction, null);
                this.setInfoBoolTreeToExtendedDeclaredZones(reqX, this.vectorMap, accessedZonesTree, true, null, false, 0);
                break;
            }
            case 31: {
                this.curCalledUnit = ReqExplicit.getCalledUnit(expression, this.curSymbolTable);
                if (this.curCalledUnit == null || !this.curCalledUnit.hasParamElemsInfo()) break;
                ActivityPattern curCalledActivity = (ActivityPattern)ActivityPattern.getAnnotationForActivityPattern(expression, this.curActivity, "multiActivityCalleePatterns");
                if (curCalledActivity == null) {
                    curCalledActivity = this.getOrCreateCalledActivityPattern(this.curActivity, this.curCalledUnit, expression);
                }
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("  Start propagating ReqX upstream through call: " + ILUtils.toString(expression));
                    TapEnv.printlnOnTrace("    called Activity Pattern:" + curCalledActivity);
                    TapEnv.printlnOnTrace("    downcoming ReqX:" + this.vectorMapName + " " + reqX.toString(this.vectorMap));
                }
                CallArrow arrow = CallGraph.getCallArrow(this.curUnit, this.curCalledUnit);
                Tree[] actualParams = ILUtils.getArguments(expression).children();
                int nbActualParams = actualParams.length;
                BoolMatrix calleeRE = this.getReqXEffect(curCalledActivity);
                BoolVector calleeREA = this.getReqXEffectAdded(curCalledActivity);
                BoolVector calleeTouched = this.curCalledUnit.unitInOutPossiblyRorW();
                if (calleeTouched != null) {
                    this.removeNotUsedAtAll(calleeTouched, calleeRE, calleeREA);
                }
                BoolVector touched = new BoolVector(this.nDZ);
                ReqExplicit.propagateCalleeDataToCallSite(calleeTouched, touched, null, actualParams, true, expression, this.curInstruction, arrow, this.vectorMap, 0, null, null, false, false);
                TapList[] paramDataS = new TapList[1 + nbActualParams];
                for (int i = nbActualParams; i >= 1; --i) {
                    paramDataS[i] = null;
                }
                paramDataS[0] = reqXTree;
                BoolVector onCalleeReqX = ReqExplicit.propagateCallSiteDataToCallee(reqX, paramDataS, null, actualParams, false, expression, this.curInstruction, arrow, this.vectorMap, 0, false);
                onCalleeReqX.cumulAnd(calleeTouched);
                String calledMapName = "[x" + this.curCalledUnit.rank() + ":a]";
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("  (note touched:" + calledMapName + " " + calleeTouched + " )");
                    TapEnv.printlnOnTrace("  expressed on callee:" + calledMapName + " " + onCalleeReqX);
                }
                if (!onCalleeReqX.isFalse(this.curCalledUnit.paramElemsNb()) && lastSweep) {
                    ReqExplicit.setAnnotatedReqX(this.curActivity, ILUtils.getCalledName(expression));
                }
                if (!(this.curCalledUnit.isIntrinsic() || this.curCalledUnit.isInterface() || this.curCalledUnit.isVarFunction())) {
                    BoolVector calledContext = curCalledActivity.exitReqX();
                    if (calledContext == null) {
                        curCalledActivity.setExitReqX(onCalleeReqX.copy());
                        this.curCalledUnit.analysisIsOutOfDateUp = true;
                    } else if (calledContext.cumulOrGrows(onCalleeReqX, this.curCalledUnit.paramElemsNb())) {
                        this.curCalledUnit.analysisIsOutOfDateUp = true;
                    }
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace("    accumulated into the callee's context --> " + calledMapName + " " + curCalledActivity.exitReqX());
                    }
                } else if (curCalledActivity.exitReqX() != null) {
                    curCalledActivity.exitReqX().cumulOr(onCalleeReqX);
                }
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("    pushed through calleeRE:");
                    TapEnv.dumpOnTrace(calleeRE);
                    TapEnv.printlnOnTrace("     and calleeREA:" + calledMapName + " " + calleeREA);
                }
                onCalleeReqX = calleeRE.times(onCalleeReqX).or(calleeREA);
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("    gives upgoing ReqX:" + calledMapName + " " + onCalleeReqX);
                }
                if (curCalledActivity.entryReqX() != null) {
                    curCalledActivity.entryReqX().cumulOr(onCalleeReqX);
                }
                BoolVector callSiteKilled = new BoolVector(this.nDZ);
                ReqExplicit.propagateCalleeDataToCallSite(this.curCalledUnit.unitInOutCertainlyW(), callSiteKilled, null, actualParams, true, expression, this.curInstruction, arrow, this.vectorMap, 0, null, null, false, true);
                TapList[] argsReqX = ReqExplicit.propagateCalleeDataToCallSite(onCalleeReqX, reqX, null, null, true, expression, this.curInstruction, arrow, this.vectorMap, 0, null, callSiteKilled.not(), true, false);
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("    expressed as ReqX on call site:" + this.vectorMapName + " " + reqX.toString(this.vectorMap));
                    if (nbActualParams > 0) {
                        TapEnv.printlnOnTrace("     and pushing up through actual args:");
                    }
                }
                boolean[] formalArgsActive = ADActivityAnalyzer.formalArgsActivity(curCalledActivity);
                for (int i = nbActualParams - 1; i >= 0; --i) {
                    boolean diffExprExists;
                    boolean bl = diffExprExists = (TapList.oneTrue(argsReqX[1 + i]) || formalArgsActive != null && i < formalArgsActive.length && formalArgsActive[i]) && ILUtils.isAVarRef(actualParams[i], this.curSymbolTable);
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace("       #" + (i + 1) + ": " + argsReqX[1 + i]);
                    }
                    this.reqXThroughExpression(actualParams[i], -1, argsReqX[1 + i], reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                    if (!diffExprExists) continue;
                    TapIntList usedPointerRanks = this.collectUsedPointerRanks(actualParams[i], null, true);
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace("       also arg is pointer-active, usedPointerRanks=" + usedPointerRanks);
                    }
                    reqX.set(usedPointerRanks, true);
                }
                if (!TapEnv.traceCurAnalysis()) break;
                TapEnv.printlnOnTrace("  >Done propagating ReqX upstream through call: " + ILUtils.toString(expression) + " ==> " + this.vectorMapName + " " + reqX.toString(this.vectorMap));
                break;
            }
            case 3: 
            case 182: {
                boolean argIsPointer = TypeSpec.isA(this.curSymbolTable.typeOf(expression.down(1)), 6);
                this.reqXThroughExpression(expression.down(1), -1, argIsPointer ? reqXTree : null, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                argIsPointer = TypeSpec.isA(this.curSymbolTable.typeOf(expression.down(2)), 6);
                this.reqXThroughExpression(expression.down(2), -1, argIsPointer ? reqXTree : null, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                break;
            }
            case 6: 
            case 18: 
            case 22: 
            case 24: 
            case 42: 
            case 43: 
            case 62: 
            case 68: 
            case 92: 
            case 95: 
            case 110: 
            case 115: 
            case 116: 
            case 122: 
            case 126: 
            case 133: 
            case 137: 
            case 143: 
            case 155: 
            case 169: 
            case 207: {
                this.reqXThroughExpression(expression.down(1), -1, null, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                this.reqXThroughExpression(expression.down(2), -1, null, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                break;
            }
            case 80: 
            case 98: 
            case 124: 
            case 139: 
            case 176: 
            case 184: 
            case 189: 
            case 196: 
            case 205: 
            case 206: {
                this.reqXThroughExpression(expression.down(1), -1, null, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                break;
            }
            case 11: {
                this.reqXThroughExpression(expression.down(1), 1, null, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                break;
            }
            case 194: {
                boolean argIsPointer = TypeSpec.isA(this.curSymbolTable.typeOf(expression.down(2)), 6);
                this.reqXThroughExpression(expression.down(2), -1, argIsPointer ? reqXTree : null, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                break;
            }
            case 32: 
            case 47: 
            case 134: {
                this.reqXThroughExpression(expression.down(2), act, null, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                break;
            }
            case 121: {
                this.reqXThroughExpression(expression.down(3), act, null, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                break;
            }
            case 64: 
            case 82: {
                this.reqXThroughExpression(expression.down(1), 1, null, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                this.reqXThroughExpression(expression.down(2), -1, null, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                this.reqXThroughExpression(expression.down(3), -1, null, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                this.reqXThroughExpression(expression.down(4), -1, null, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                break;
            }
            case 81: {
                this.reqXThroughExpression(expression.down(1), -1, null, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                this.reqXThroughExpression(expression.down(2), -1, null, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                break;
            }
            case 79: {
                this.reqXThroughExpression(expression.down(1), -1, null, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                this.reqXThroughExpression(expression.down(2), -1, null, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                this.reqXThroughExpression(expression.down(3), 1, null, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                break;
            }
            case 12: 
            case 99: {
                this.reqXThroughExpression(expression.down(1), -1, null, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                this.reqXThroughExpression(expression.down(2), -1, null, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                this.reqXThroughExpression(expression.down(3), -1, null, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                break;
            }
            case 10: 
            case 71: 
            case 83: {
                Tree[] sons = expression.children();
                for (int i = sons.length - 1; i >= 0; --i) {
                    this.reqXThroughExpression(sons[i], act, null, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                }
                break;
            }
            case 199: {
                Tree[] decls = expression.down(3).children();
                this.inADeclaration = true;
                for (int i = decls.length - 1; i >= 0; --i) {
                    if (decls[i].opCode() != 14) continue;
                    ILUtils.turnAssignFromInitDecl(decls[i]);
                    this.reqXThroughExpression(decls[i], -1, null, reqX, beforeActiv, afterActiv, afterUseful, lastSweep);
                    ILUtils.resetAssignFromInitDecl(decls[i]);
                }
                this.inADeclaration = false;
                break;
            }
            case 144: 
            case 145: {
                break;
            }
            case 36: 
            case 46: 
            case 56: 
            case 89: {
                break;
            }
            case 2: 
            case 5: 
            case 13: 
            case 15: 
            case 20: 
            case 28: 
            case 29: 
            case 30: 
            case 35: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 49: 
            case 51: 
            case 67: 
            case 69: 
            case 74: 
            case 78: 
            case 85: 
            case 91: 
            case 94: 
            case 101: 
            case 103: 
            case 104: 
            case 106: 
            case 108: 
            case 109: 
            case 111: 
            case 118: 
            case 129: 
            case 135: 
            case 138: 
            case 154: 
            case 160: 
            case 161: 
            case 171: 
            case 177: 
            case 179: 
            case 180: 
            case 181: 
            case 192: 
            case 195: 
            case 197: 
            case 202: 
            case 204: {
                break;
            }
            default: {
                TapEnv.toolWarning(-1, "(ReqX analysis) Unexpected operator: " + expression.opName());
            }
        }
    }

    private void removeNotUsedAtAll(BoolVector publicUsed, BoolMatrix publicRE, BoolVector publicREA) {
        if (publicREA != null && publicRE != null && publicRE.rows != null) {
            BoolVector used = publicREA.copy();
            for (int i = publicRE.nRows - 1; i >= 0; --i) {
                BoolVector rowi = publicRE.rows[i];
                if (rowi == null) continue;
                used.cumulOr(rowi);
                used.set(i, true);
            }
            publicUsed.cumulAnd(used);
        }
    }

    private boolean diffExprExists(Tree expression, TapList reqXTree, int action, BoolVector beforeActiv, BoolVector afterActiv, BoolVector afterUseful) {
        TapList<?> exprZonesTree;
        if (TapList.oneTrue(reqXTree)) {
            return true;
        }
        Tree expr = expression;
        boolean exprIsPointer = TypeSpec.isA(this.curSymbolTable.typeOf(expression), 6);
        if (exprIsPointer) {
            expr = ILUtils.build(151, ILUtils.copy(expression), ILUtils.build(138));
        }
        if ((exprZonesTree = this.curSymbolTable.treeOfZonesOfValue(expr, null, this.curInstruction, null)) != null) {
            exprZonesTree = TapList.copyTree(exprZonesTree);
            this.includePointedElementsInTree(exprZonesTree, null, null, true, false, true);
        }
        TapIntList exprZonesList = ZoneInfo.listAllZones(exprZonesTree, true);
        TapIntList diffKindZonesList = this.mapExtendedDeclaredToVectorIndex(exprZonesList, this.diffKind, this.diffVectorMap);
        TapIntList publicRanksList = ReqExplicit.extendedDeclaredToPublicRanks(exprZonesList, this.curSymbolTable);
        BoolVector staticActiv = this.curActivity.staticActivity();
        boolean diffExprExists = !TapEnv.doActivity() && diffKindZonesList != null || ADActivityAnalyzer.isAnnotatedActive(this.curActivity, expression, this.curSymbolTable) && (action == -1 && (beforeActiv != null && beforeActiv.intersects(diffKindZonesList) || staticActiv != null && staticActiv.intersects(publicRanksList)) || action == 1 && (afterActiv != null && afterActiv.intersects(diffKindZonesList) || staticActiv != null && staticActiv.intersects(publicRanksList) || afterUseful != null && afterUseful.intersects(diffKindZonesList)));
        return diffExprExists;
    }

    private void avlXEffectThroughExpression(Tree expression, Tree lhs, BoolVector avlXEffectVisible, BoolVector avlXEffectAdded, BoolVector reqX) {
        switch (expression.opCode()) {
            case 14: 
            case 52: 
            case 63: 
            case 125: 
            case 140: 
            case 150: 
            case 168: 
            case 190: {
                boolean totalAccess;
                boolean isReturn;
                boolean deallocOrNullify = expression.opCode() == 52 || expression.opCode() == 140;
                boolean bl = isReturn = expression.opCode() == 168;
                if (isReturn) {
                    String returnVarName = this.curUnit.otherReturnVar() == null ? this.curUnit.name() : this.curUnit.otherReturnVar().symbol;
                    lhs = ILUtils.build(96, returnVarName);
                } else {
                    lhs = expression.down(1);
                }
                Object rhs = isReturn ? expression.down(1) : (deallocOrNullify ? null : expression.down(2));
                ToBool lhsTotal = new ToBool(false);
                TapList<?> writtenZonesTree = this.curSymbolTable.treeOfZonesOfValue(lhs, lhsTotal, this.curInstruction, null);
                boolean bl2 = totalAccess = this.referenceIsTotal(lhsTotal.get(), writtenZonesTree) && expression.opCode() == 14 && (!this.inADeclaration || !this.curUnit.isFortran());
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("  Start propagating AvlX effect downstream through: " + ILUtils.toString(expression) + " written zones: " + writtenZonesTree + (totalAccess ? "(total)" : "(non-total)"));
                }
                if (!deallocOrNullify) {
                    this.avlXEffectThroughExpression((Tree)rhs, lhs, avlXEffectVisible, avlXEffectAdded, reqX);
                }
                if (!isReturn) {
                    this.avlXEffectThroughExpression(lhs, null, avlXEffectVisible, avlXEffectAdded, reqX);
                    if (totalAccess) {
                        this.setInfoBoolTreeToExtendedDeclaredZones(avlXEffectVisible, this.vectorMap, writtenZonesTree, false, null, true, 0);
                        this.setInfoBoolTreeToExtendedDeclaredZones(avlXEffectAdded, this.vectorMap, writtenZonesTree, false, null, true, 0);
                    }
                }
                if (!deallocOrNullify) {
                    TapIntList writtenIndicesList = this.mapExtendedDeclaredToVectorIndex(ZoneInfo.listAllZones(writtenZonesTree, true), 0, this.vectorMap);
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace("  writtenIndicesList: " + writtenIndicesList + " intersects ReqX: " + reqX + (reqX.intersects(writtenIndicesList) ? " yes!" : " no!"));
                    }
                    if (reqX.intersects(writtenIndicesList)) {
                        avlXEffectAdded.set(writtenIndicesList, true);
                    }
                }
                if (!TapEnv.traceCurAnalysis()) break;
                TapEnv.printlnOnTrace("  >Done propagating AvlX effect downstream through: " + ILUtils.toString(expression));
                TapEnv.printlnOnTrace("   -->avlXEffectVisible:" + avlXEffectVisible);
                TapEnv.printlnOnTrace("   -->avlXEffectAdded  :" + avlXEffectAdded);
                break;
            }
            case 31: {
                this.curCalledUnit = ReqExplicit.getCalledUnit(expression, this.curSymbolTable);
                ActivityPattern curCalledActivity = (ActivityPattern)ActivityPattern.getAnnotationForActivityPattern(expression, this.curActivity, "multiActivityCalleePatterns");
                if (this.curCalledUnit == null || curCalledActivity == null || !this.curCalledUnit.hasParamElemsInfo()) break;
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("  Start propagating AvlX effect downstream through call: " + ILUtils.toString(expression));
                    TapEnv.printlnOnTrace("    called Activity Pattern:" + curCalledActivity);
                    TapEnv.printlnOnTrace("    avlXEffectVisible:" + avlXEffectVisible);
                    TapEnv.printlnOnTrace("    avlXEffectAdded  :" + avlXEffectAdded);
                }
                CallArrow arrow = CallGraph.getCallArrow(this.curUnit, this.curCalledUnit);
                Tree[] actualParams = ILUtils.getArguments(expression).children();
                Unit savedCalledUnit = this.curCalledUnit;
                for (int i = actualParams.length - 1; i >= 0; --i) {
                    this.avlXEffectThroughExpression(actualParams[i], null, avlXEffectVisible, avlXEffectAdded, reqX);
                }
                this.curCalledUnit = savedCalledUnit;
                BoolVector onCalleeAEV = ReqExplicit.propagateCallSiteDataToCallee(avlXEffectVisible, null, null, actualParams, true, expression, this.curInstruction, arrow, this.vectorMap, 0, true);
                BoolVector onCalleeAEA = ReqExplicit.propagateCallSiteDataToCallee(avlXEffectAdded, null, null, actualParams, true, expression, this.curInstruction, arrow, this.vectorMap, 0, true);
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("     expressed on callee as Visible:   " + onCalleeAEV);
                    TapEnv.printlnOnTrace("                         and Added:    " + onCalleeAEA);
                }
                BoolVector calleeAEV = this.getAvlXEffectVisible(curCalledActivity);
                BoolVector calleeAEA = this.getAvlXEffectAdded(curCalledActivity);
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("     keep only Visible through callee: " + calleeAEV);
                    TapEnv.printlnOnTrace("     add Added by callee:              " + calleeAEA);
                }
                onCalleeAEV.cumulAnd(calleeAEV);
                onCalleeAEA.cumulAnd(calleeAEV);
                onCalleeAEA.cumulOr(calleeAEA);
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("     --> gives upstream Visible:       " + onCalleeAEV);
                    TapEnv.printlnOnTrace("     -->              and Added:       " + onCalleeAEA);
                }
                ReqExplicit.propagateCalleeDataToCallSite(onCalleeAEV, avlXEffectVisible, null, actualParams, false, expression, this.curInstruction, arrow, this.vectorMap, 0, null, null, false, false);
                ReqExplicit.propagateCalleeDataToCallSite(onCalleeAEA, avlXEffectAdded, null, actualParams, false, expression, this.curInstruction, arrow, this.vectorMap, 0, null, null, false, false);
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("  >Done propagating AvlX effect downstream through call: " + ILUtils.toString(expression));
                    TapEnv.printlnOnTrace("    avlXEffectVisible:" + avlXEffectVisible);
                    TapEnv.printlnOnTrace("    avlXEffectAdded  :" + avlXEffectAdded);
                }
                SymbolTable calleePublicSymbolTable = this.curCalledUnit.publicSymbolTable();
                if (!ADActivityAnalyzer.isAnnotatedActive(this.curActivity, expression, this.curSymbolTable) && (!TapEnv.mustContext() || calleePublicSymbolTable == null && !MPIcallInfo.isNonBlockingMPI(expression, this.curCalledUnit, this.curBlock))) break;
                ReqExplicit.propagateDiffParamsRequired(expression, lhs, arrow, actualParams, curCalledActivity, this.curInstruction, this.curActivity);
                break;
            }
            case 36: 
            case 46: 
            case 56: 
            case 89: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                if (expression.isAtom()) break;
                Tree[] subTrees = expression.children();
                for (int i = subTrees.length - 1; i >= 0; --i) {
                    this.avlXEffectThroughExpression(subTrees[i], null, avlXEffectVisible, avlXEffectAdded, reqX);
                }
            }
        }
    }

    private static void propagateDiffParamsRequired(Tree expression, Tree lhs, CallArrow arrow, Tree[] actualParams, ActivityPattern calledActivity, Instruction instr, ActivityPattern callingActivity) {
        BoolVector calleeDiffParamsRequired;
        SymbolTable symbolTable = instr.block.symbolTable;
        Unit callingUnit = instr.block.unit();
        BoolVector boolVector = calleeDiffParamsRequired = calledActivity == null ? null : ADActivityAnalyzer.functionDiffFormalRequired(calledActivity, false);
        if (calleeDiffParamsRequired != null) {
            TapList<Object> actualResultRequired = new TapList<Object>(null, null);
            Tree[] actuallyDiffActualParams = new Tree[actualParams.length];
            for (int i = actualParams.length - 1; i >= 0; --i) {
                actuallyDiffActualParams[i] = (ADActivityAnalyzer.isAnnotatedActive(callingActivity, actualParams[i], symbolTable) || ILUtils.isAWritableIdentVarRef(actualParams[i], symbolTable)) && !symbolTable.varIsIntentIn(actualParams[i]) ? actualParams[i] : null;
            }
            int ndrz = symbolTable.declaredZonesNb(TapEnv.diffKind());
            int[] dvMap = ReqExplicit.makeMap3(0, 0, ndrz);
            BoolVector privateRequiredDiffk = new BoolVector(ReqExplicit.mapSize(dvMap));
            ReqExplicit.propagateDataToCaller(calleeDiffParamsRequired, lhs, actuallyDiffActualParams, actuallyDiffActualParams.length, privateRequiredDiffk, dvMap, actualResultRequired, instr, arrow, true, true, TapEnv.diffKind());
            SymbolTable callerContextSymbolTable = callingUnit.externalSymbolTable();
            for (SymbolTable callerSymbolTable = symbolTable; callerSymbolTable != callerContextSymbolTable; callerSymbolTable = callerSymbolTable.basisSymbolTable()) {
                callerSymbolTable.setOrCumulRequiredDiffVars(callingActivity, privateRequiredDiffk);
                ndrz = callerSymbolTable.declaredZonesNb(TapEnv.diffKind());
                BoolVector tmpzv = new BoolVector(ndrz);
                tmpzv.cumulOr(privateRequiredDiffk, ndrz);
                privateRequiredDiffk = tmpzv;
            }
        }
    }

    private void avlXThroughExpression(Tree expression, Tree lhs, BoolVector avlX, BoolVector reqX) {
        switch (expression.opCode()) {
            case 14: 
            case 52: 
            case 63: 
            case 125: 
            case 140: 
            case 150: 
            case 168: 
            case 190: {
                boolean totalAccess;
                boolean isReturn;
                boolean deallocOrNullify = expression.opCode() == 52 || expression.opCode() == 140;
                boolean bl = isReturn = expression.opCode() == 168;
                if (isReturn) {
                    String returnVarName = this.curUnit.otherReturnVar() == null ? this.curUnit.name() : this.curUnit.otherReturnVar().symbol;
                    lhs = ILUtils.build(96, returnVarName);
                } else {
                    lhs = expression.down(1);
                }
                Object rhs = isReturn ? expression.down(1) : (deallocOrNullify ? null : expression.down(2));
                ToBool lhsTotal = new ToBool(false);
                TapList<?> writtenZonesTree = this.curSymbolTable.treeOfZonesOfValue(lhs, lhsTotal, this.curInstruction, null);
                boolean bl2 = totalAccess = this.referenceIsTotal(lhsTotal.get(), writtenZonesTree) && expression.opCode() == 14 && (!this.inADeclaration || !this.curUnit.isFortran());
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("  Start propagating AvlX downstream through: " + ILUtils.toString(expression) + " written zones: " + writtenZonesTree + (totalAccess ? "(total)" : "(non-total)"));
                }
                if (!deallocOrNullify) {
                    this.avlXThroughExpression((Tree)rhs, lhs, avlX, reqX);
                }
                if (!isReturn) {
                    this.avlXThroughExpression(lhs, null, avlX, reqX);
                    if (totalAccess) {
                        this.setInfoBoolTreeToExtendedDeclaredZones(avlX, this.vectorMap, writtenZonesTree, false, null, true, 0);
                    }
                }
                if (!deallocOrNullify) {
                    TapIntList writtenIndicesList = this.mapExtendedDeclaredToVectorIndex(ZoneInfo.listAllZones(writtenZonesTree, true), 0, this.vectorMap);
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace("  writtenIndicesList: " + writtenIndicesList + " intersects ReqX:" + this.vectorMapName + " " + (reqX != null ? reqX.toString(this.vectorMap) : "Null") + (reqX != null && reqX.intersects(writtenIndicesList) ? " yes!" : " no!"));
                    }
                    if (reqX != null && reqX.intersects(writtenIndicesList)) {
                        avlX.set(writtenIndicesList, true);
                    }
                }
                if (!TapEnv.traceCurAnalysis()) break;
                TapEnv.printlnOnTrace("  >Done propagating AvlX downstream through: " + ILUtils.toString(expression));
                TapEnv.printlnOnTrace("   -->AvlX:" + this.vectorMapName + " " + avlX.toString(this.vectorMap));
                break;
            }
            case 31: {
                this.curCalledUnit = ReqExplicit.getCalledUnit(expression, this.curSymbolTable);
                ActivityPattern curCalledActivity = (ActivityPattern)ActivityPattern.getAnnotationForActivityPattern(expression, this.curActivity, "multiActivityCalleePatterns");
                if (curCalledActivity == null) {
                    curCalledActivity = this.getOrCreateCalledActivityPattern(this.curActivity, this.curCalledUnit, expression);
                }
                if (this.curCalledUnit == null || !this.curCalledUnit.hasParamElemsInfo()) break;
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("  Start propagating AvlX downstream through call: " + ILUtils.toString(expression));
                    TapEnv.printlnOnTrace("    called Activity Pattern:" + curCalledActivity);
                    TapEnv.printlnOnTrace("    AvlX:" + this.vectorMapName + " " + avlX.toString(this.vectorMap));
                }
                CallArrow arrow = CallGraph.getCallArrow(this.curUnit, this.curCalledUnit);
                Tree[] actualParams = ILUtils.getArguments(expression).children();
                Unit savedCalledUnit = this.curCalledUnit;
                for (int i = actualParams.length - 1; i >= 0; --i) {
                    this.avlXThroughExpression(actualParams[i], null, avlX, reqX);
                }
                this.curCalledUnit = savedCalledUnit;
                BoolVector onCalleeAvlX = ReqExplicit.propagateCallSiteDataToCallee(avlX, null, null, actualParams, true, expression, this.curInstruction, arrow, this.vectorMap, 0, true);
                String calledMapName = "[x" + this.curCalledUnit.rank() + ":a]";
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("     expressed on callee as:" + calledMapName + " " + onCalleeAvlX);
                }
                if (!(this.curCalledUnit.isIntrinsic() || this.curCalledUnit.isInterface() || this.curCalledUnit.isVarFunction())) {
                    BoolVector calledContext = curCalledActivity.entryAvlX();
                    if (calledContext == null) {
                        curCalledActivity.setEntryAvlX(onCalleeAvlX.copy());
                        this.curCalledUnit.analysisIsOutOfDateDown = true;
                    } else if (calledContext.cumulOrGrows(onCalleeAvlX, this.curCalledUnit.paramElemsNb())) {
                        this.curCalledUnit.analysisIsOutOfDateDown = true;
                    }
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace("     accumulated callee's context  --> " + curCalledActivity.entryAvlX());
                    }
                }
                BoolVector calleeAEV = this.getAvlXEffectVisible(curCalledActivity);
                BoolVector calleeAEA = this.getAvlXEffectAdded(curCalledActivity);
                onCalleeAvlX.cumulAnd(calleeAEV);
                onCalleeAvlX.cumulOr(calleeAEA);
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("     keep only visible through callee: " + calleeAEV);
                    TapEnv.printlnOnTrace("     add added by callee:              " + calleeAEA);
                    TapEnv.printlnOnTrace("     --> gives:                        " + onCalleeAvlX);
                }
                if (curCalledActivity.exitAvlX() == null) {
                    curCalledActivity.setExitAvlX(onCalleeAvlX);
                } else {
                    curCalledActivity.exitAvlX().cumulOr(onCalleeAvlX);
                }
                BoolVector touched = new BoolVector(this.nDZ);
                ReqExplicit.propagateCalleeDataToCallSite(this.curCalledUnit.unitInOutPossiblyRorW(), touched, null, actualParams, true, expression, this.curInstruction, arrow, this.vectorMap, 0, null, null, false, false);
                ReqExplicit.propagateCalleeDataToCallSite(onCalleeAvlX, avlX, null, actualParams, false, expression, this.curInstruction, arrow, this.vectorMap, 0, touched, null, false, false);
                if (!TapEnv.traceCurAnalysis()) break;
                TapEnv.printlnOnTrace("  >Done propagating AvlX downstream through call: " + ILUtils.toString(expression));
                TapEnv.printlnOnTrace("   -->avlX:" + this.vectorMapName + " " + avlX.toString(this.vectorMap));
                break;
            }
            case 36: 
            case 46: 
            case 56: 
            case 89: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                if (expression.isAtom()) break;
                Tree[] subTrees = expression.children();
                for (int i = subTrees.length - 1; i >= 0; --i) {
                    this.avlXThroughExpression(subTrees[i], null, avlX, reqX);
                }
            }
        }
    }

    private ActivityPattern getOrCreateCalledActivityPattern(ActivityPattern callingActivity, Unit calledUnit, Tree callExpression) {
        ActivityPattern existingActivity;
        ActivityPattern calledActivity = null;
        TapList<ActivityPattern> calledActivityPatternS = calledUnit.activityPatterns;
        while (calledActivity == null && calledActivityPatternS != null) {
            existingActivity = (ActivityPattern)calledActivityPatternS.head;
            if (callingActivity.isContext() == existingActivity.isContext() || callingActivity.isContext() && existingActivity.diffPattern() != null) {
                calledActivity = existingActivity;
            }
            calledActivityPatternS = calledActivityPatternS.tail;
        }
        if (calledActivity == null) {
            calledActivity = new ActivityPattern(calledUnit, null, null, true, this.diffKind);
            calledActivity.registerCallingActivityPattern(callingActivity);
            calledActivity.setContext(callingActivity.isContext());
            if (!callingActivity.isContext()) {
                ActivityPattern contextPattern = null;
                calledActivityPatternS = calledUnit.activityPatterns;
                while (contextPattern == null && calledActivityPatternS != null) {
                    existingActivity = (ActivityPattern)calledActivityPatternS.head;
                    if (existingActivity.isContext()) {
                        contextPattern = existingActivity;
                    }
                    calledActivityPatternS = calledActivityPatternS.tail;
                }
                if (contextPattern != null) {
                    calledActivity.copyReqExplicitInfos(contextPattern);
                }
            }
            calledUnit.activityPatterns = new TapList<ActivityPattern>(calledActivity, calledUnit.activityPatterns);
            if (TapEnv.traceCurAnalysis()) {
                TapEnv.printlnOnTrace("     in passing, created an ActivityPattern for " + calledUnit + ":" + calledActivity);
            }
        }
        calledActivity.registerCallingActivityPattern(callingActivity);
        ActivityPattern.setAnnotationForActivityPattern(callExpression, callingActivity, "multiActivityCalleePatterns", calledActivity);
        return calledActivity;
    }

    private ActivityPattern createTemporaryDummyEmptyActivityPattern(Unit calledUnit) {
        int size = calledUnit.paramElemsNb();
        BoolVector emptyVaried = new BoolVector(size);
        BoolVector emptyUseful = new BoolVector(size);
        ActivityPattern dummyActivity = new ActivityPattern(calledUnit, emptyVaried, emptyUseful, true, this.diffKind);
        return dummyActivity;
    }

    private TapIntList collectUsedPointerRanks(Tree expression, TapIntList accumulator, boolean annotateReqX) {
        switch (expression.opCode()) {
            case 4: 
            case 9: 
            case 75: 
            case 124: {
                return this.collectUsedPointerRanks(expression.down(1), accumulator, annotateReqX);
            }
            case 32: 
            case 134: 
            case 194: {
                return this.collectUsedPointerRanks(expression.down(2), accumulator, annotateReqX);
            }
            case 151: {
                if (annotateReqX) {
                    ReqExplicit.setAnnotatedReqX(this.curActivity, expression.down(1));
                }
                TapIntList pointerRanks = this.mapExtendedDeclaredToVectorIndex(ZoneInfo.listAllZones(this.curSymbolTable.treeOfZonesOfValue(expression.down(1), null, this.curInstruction, null), true), 0, this.vectorMap);
                accumulator = TapIntList.quickUnion(accumulator, pointerRanks);
                return this.collectUsedPointerRanks(expression.down(1), accumulator, annotateReqX);
            }
            case 10: {
                Tree[] children = expression.children();
                for (int i = 0; i < children.length; ++i) {
                    accumulator = this.collectUsedPointerRanks(children[i], accumulator, annotateReqX);
                }
                return accumulator;
            }
            case 3: 
            case 6: 
            case 18: 
            case 22: 
            case 24: 
            case 42: 
            case 43: 
            case 62: 
            case 68: 
            case 92: 
            case 95: 
            case 115: 
            case 116: 
            case 122: 
            case 133: 
            case 137: 
            case 143: 
            case 155: 
            case 169: 
            case 182: 
            case 207: {
                accumulator = this.collectUsedPointerRanks(expression.down(1), accumulator, annotateReqX);
                return this.collectUsedPointerRanks(expression.down(2), accumulator, annotateReqX);
            }
            case 144: 
            case 145: {
                return accumulator;
            }
            case 36: 
            case 46: 
            case 56: 
            case 89: {
                return accumulator;
            }
            case 20: 
            case 28: 
            case 29: 
            case 35: 
            case 41: 
            case 78: 
            case 96: 
            case 103: 
            case 104: 
            case 111: 
            case 138: 
            case 160: 
            case 176: 
            case 180: 
            case 204: {
                return accumulator;
            }
            case 31: 
            case 99: {
                return accumulator;
            }
        }
        TapEnv.toolWarning(-1, "(Collect used pointer ranks) Unexpected operator: " + expression.opName());
        return accumulator;
    }

    private BoolMatrix getReqXEffect(ActivityPattern calledActivity) {
        Unit calledUnit = null;
        if (calledActivity != null) {
            calledUnit = calledActivity.unit();
        }
        if (calledUnit == null) {
            return null;
        }
        if (calledUnit.rank() <= 0) {
            return this.buildDefaultReqXEffect(calledUnit);
        }
        BoolMatrix reqXEffect = calledActivity.reqXEffects();
        if (reqXEffect == null) {
            reqXEffect = this.buildDefaultReqXEffect(calledUnit);
        }
        return reqXEffect;
    }

    private BoolVector getReqXEffectAdded(ActivityPattern calledActivity) {
        Unit calledUnit = null;
        if (calledActivity != null) {
            calledUnit = calledActivity.unit();
        }
        if (calledUnit == null) {
            return null;
        }
        if (calledUnit.rank() <= 0) {
            return this.buildDefaultReqXEffectAdded(calledUnit);
        }
        BoolVector reqXEffectAdded = calledActivity.reqXEffectsAdded();
        if (reqXEffectAdded == null) {
            reqXEffectAdded = this.buildDefaultReqXEffectAdded(calledUnit);
        }
        return reqXEffectAdded;
    }

    private BoolVector getAvlXEffectVisible(ActivityPattern calledActivity) {
        Unit calledUnit = null;
        if (calledActivity != null) {
            calledUnit = calledActivity.unit();
        }
        if (calledUnit == null) {
            return null;
        }
        if (calledUnit.rank() <= 0) {
            return this.buildDefaultAvlXEffectVisible(calledUnit);
        }
        BoolVector avlXEffectVisible = calledActivity.avlXEffectsVisible();
        if (avlXEffectVisible == null) {
            avlXEffectVisible = this.buildDefaultAvlXEffectVisible(calledUnit);
        }
        return avlXEffectVisible;
    }

    private BoolVector getAvlXEffectAdded(ActivityPattern calledActivity) {
        Unit calledUnit = null;
        if (calledActivity != null) {
            calledUnit = calledActivity.unit();
        }
        if (calledUnit == null) {
            return null;
        }
        if (calledUnit.rank() <= 0) {
            return this.buildDefaultAvlXEffectAdded(calledUnit);
        }
        BoolVector avlXEffectAdded = calledActivity.avlXEffectsAdded();
        if (avlXEffectAdded == null) {
            avlXEffectAdded = this.buildDefaultAvlXEffectAdded(calledUnit);
        }
        return avlXEffectAdded;
    }

    private BoolMatrix buildDefaultReqXEffect(Unit calledUnit) {
        int n = calledUnit.paramElemsNb();
        BoolMatrix result = new BoolMatrix(n, n);
        result.setIdentity();
        BoolVector pointerZonesMask = ReqExplicit.buildPublicPointerZoneMask(calledUnit);
        BoolVector tmpPubK = calledUnit.getTmpALLKINDK();
        BoolVector nonReqX = pointerZonesMask.and(tmpPubK);
        for (int i = n - 1; i >= 0; --i) {
            if (!nonReqX.get(i)) continue;
            result.rows[i] = new BoolVector(n);
        }
        return result;
    }

    private BoolVector buildDefaultReqXEffectAdded(Unit calledUnit) {
        BoolVector pointerZonesMask = ReqExplicit.buildPublicPointerZoneMask(calledUnit);
        if (this.curUnit.isFortran9x() && ("associated".equals(calledUnit.name()) || "allocated".equals(calledUnit.name()))) {
            pointerZonesMask.setFalse();
        }
        BoolVector tmpPubR = calledUnit.getTmpALLKINDPossiblyR();
        return pointerZonesMask.and(tmpPubR);
    }

    private BoolVector buildDefaultAvlXEffectVisible(Unit calledUnit) {
        BoolVector pointerZonesMask = ReqExplicit.buildPublicPointerZoneMask(calledUnit);
        pointerZonesMask.setTrue();
        BoolVector tmpPubK = calledUnit.getTmpALLKINDK();
        return pointerZonesMask.minus(tmpPubK);
    }

    private BoolVector buildDefaultAvlXEffectAdded(Unit calledUnit) {
        int n = calledUnit.paramElemsNb();
        return new BoolVector(n);
    }

    public boolean isPointerActiveCall(Tree callTree, Unit callingUnit, Unit calledUnit, SymbolTable callSymbolTable, Instruction callInstruction, BoolVector avlX, BoolVector reqX, TapList reqXResult) {
        CallArrow arrow = CallGraph.getCallArrow(callingUnit, calledUnit);
        this.setCurUnitEtc(callingUnit);
        this.curCalledUnit = calledUnit;
        this.curSymbolTable = callSymbolTable;
        this.nDZ = callSymbolTable.declaredZonesNb(0);
        this.vectorMap = ReqExplicit.makeMap3(0, 0, this.nDZ);
        this.vectorMapName = "[||d" + callSymbolTable.rank() + ":a]";
        Tree[] actualParams = ILUtils.getArguments(callTree).children();
        this.curInstruction = callInstruction;
        this.setUniqueAccessZones(this.curInstruction.block);
        BoolVector reqOrAvl = null;
        if (reqX != null) {
            BoolVector downstreamCallReqX;
            reqOrAvl = downstreamCallReqX = this.propagateExitDataBwdToCallee(reqX, this.vectorMap, reqXResult, null, arrow, actualParams, 0, false, null, false, false);
        }
        if (avlX != null) {
            BoolVector upstreamCallAvlX = this.propagateEntryDataFwdToCallee(avlX, this.vectorMap, this.infoTreesOfRefArgs(actualParams, avlX, this.vectorMap, 0), null, arrow, actualParams, 0, false);
            reqOrAvl = reqOrAvl == null ? upstreamCallAvlX : reqOrAvl.or(upstreamCallAvlX);
        }
        BoolVector pointerZonesMask = ReqExplicit.buildPublicPointerZoneMask(calledUnit);
        assert (reqOrAvl != null);
        reqOrAvl = reqOrAvl.and(pointerZonesMask);
        if (calledUnit.unitInOutR != null) {
            BoolVector tmpPubW = calledUnit.getTmpALLKINDPossiblyW();
            reqOrAvl = reqOrAvl.and(tmpPubW);
        }
        this.uniqueAccessZones = null;
        this.setCurUnitEtc(null);
        return !reqOrAvl.isFalse(calledUnit.paramElemsNb());
    }

    public boolean isPointerActiveUnit(ActivityPattern curActivity) {
        BoolVector activePointers;
        Unit unit = curActivity.unit();
        if (!unit.hasParamElemsInfo()) {
            return false;
        }
        int len = unit.paramElemsNb();
        BoolVector exitReqX = curActivity.exitReqX();
        BoolVector entryAvlX = curActivity.entryAvlX();
        if (exitReqX == null || exitReqX.isFalse(len)) {
            if (entryAvlX == null || entryAvlX.isFalse(len)) {
                if (!TapEnv.mustContext()) {
                    return false;
                }
                activePointers = new BoolVector(len);
                for (int i = len - 1; i >= 0; --i) {
                    ZoneInfo zi = unit.paramElemZoneInfo(i);
                    if (zi == null || !zi.isOnceActive() && (zi.from == null || !zi.from.isOnceActive())) continue;
                    activePointers.set(i, true);
                }
            } else {
                activePointers = entryAvlX;
            }
        } else {
            activePointers = entryAvlX == null ? exitReqX : entryAvlX.or(exitReqX);
        }
        BoolVector pointerZonesMask = ReqExplicit.buildPublicPointerZoneMask(unit);
        BoolVector reqXVect = activePointers.and(pointerZonesMask);
        if (unit.unitInOutR != null) {
            BoolVector tmpPubW = unit.getTmpALLKINDPossiblyW();
            reqXVect = reqXVect.and(tmpPubW);
        }
        return !reqXVect.isFalse(len);
    }

    private void setRefAnnotatedReqX(ActivityPattern pattern, Tree tree) {
        ReqExplicit.setAnnotatedReqX(pattern, tree);
        if (tree.opCode() == 9 || tree.opCode() == 151 || tree.opCode() == 75 || tree.opCode() == 4) {
            this.setRefAnnotatedReqX(pattern, tree.down(1));
        }
    }

    public BoolVector diffZonesManaged(ActivityPattern pattern) {
        if (!pattern.unit().hasParamElemsInfo()) {
            return null;
        }
        BoolVector exitReqX = pattern.exitReqX();
        BoolVector entryAvlX = pattern.entryAvlX();
        if (exitReqX == null && entryAvlX == null) {
            return null;
        }
        BoolVector pointerZonesMask = ReqExplicit.buildPublicPointerZoneMask(pattern.unit());
        BoolVector activePointers = exitReqX == null ? entryAvlX : (entryAvlX == null ? exitReqX : entryAvlX.or(exitReqX));
        BoolVector result = activePointers.and(pointerZonesMask);
        if (pattern.unit().unitInOutR != null) {
            BoolVector tmpPubW = pattern.unit().getTmpALLKINDPossiblyW();
            result = result.and(tmpPubW);
        }
        return result;
    }

    public BoolVector diffZonesRequired(ActivityPattern pattern) {
        Unit unit = pattern.unit();
        BoolVector reqXVect = null;
        BoolVector entryReqX = pattern.entryReqX();
        if (entryReqX != null) {
            BoolVector pointerZonesMask = ReqExplicit.buildPublicPointerZoneMask(unit);
            reqXVect = pointerZonesMask.and(entryReqX);
            if (unit.unitInOutR != null) {
                BoolVector tmpPubRoW = unit.getTmpALLKINDPossiblyRoW();
                reqXVect = reqXVect.and(tmpPubRoW);
            }
        }
        return reqXVect;
    }

    private void cleanEmptyActivities() {
        for (int i = this.curCallGraph.nbUnits() - 1; i >= 0; --i) {
            this.setCurUnitEtc(this.curCallGraph.sortedUnit(i));
            if (!this.curUnit.isStandard()) continue;
        }
    }
}

