/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.analysis;

import com.microsoft.z3.BoolExpr;
import com.microsoft.z3.Context;
import com.microsoft.z3.Expr;
import com.microsoft.z3.FuncDecl;
import com.microsoft.z3.Solver;
import com.microsoft.z3.Sort;
import com.microsoft.z3.Status;
import com.microsoft.z3.StringSymbol;
import com.microsoft.z3.Symbol;
import fr.inria.tapenade.analysis.ADActivityAnalyzer;
import fr.inria.tapenade.analysis.ActivityPattern;
import fr.inria.tapenade.analysis.DataFlowAnalyzer;
import fr.inria.tapenade.differentiation.CallGraphDifferentiator;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.BlockStorage;
import fr.inria.tapenade.representation.CallArrow;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.HeaderBlock;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.LoopBlock;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.UnitStorage;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.ToObject;
import fr.inria.tapenade.utils.Tree;
import java.util.HashMap;

public final class MultithreadAnalyzer
extends DataFlowAnalyzer {
    private int phase;
    private static final int FIND_SHARED_1 = 1;
    private UnitStorage<ParallelInfoOfUnit> parallelInfosOfUnits = null;
    private UnitStorage<BlockStorage<ParallelInfoOfBlock>> parallelInfosOfUnitsBlocks = null;
    private BlockStorage<MTContext> blockContexts;
    private TapList<MTContext> existingContexts;
    private BlockStorage<TapList<MTInstances>> blockInstances;
    private ParallelInfoOfBlock entryFrontierParallelInfo = null;
    private BlockStorage<ParallelInfoOfBlock> unitBlocksParallelInfos;
    private int sliceID = 0;
    private int[] curVectorMap;
    MTInstances freeInstances;
    BlockStorage<MTInstances> blockInstancesBefore;
    BlockStorage<MTInstances> blockInstancesAfter;
    BlockStorage<BoolVector> loopModifiedZones;

    public MultithreadAnalyzer(CallGraph cg) {
        super(cg, "Analysis of multithread clauses", TapEnv.traceMultithread());
    }

    public static void runAnalysis(CallGraph callGraph) {
        MultithreadAnalyzer analyzer = new MultithreadAnalyzer(callGraph);
        TapEnv.setMultithreadAnalyzer(analyzer);
        analyzer.run();
    }

    public void run() {
        this.phase = 1;
        this.parallelInfosOfUnits = new UnitStorage(this.curCallGraph);
        this.parallelInfosOfUnitsBlocks = new UnitStorage(this.curCallGraph);
        TapList<Unit> topUnits = this.nonCalledUnits(this.curCallGraph.sortedComputationalUnits());
        this.runTopDownAnalysis(topUnits);
    }

    private TapList<Unit> nonCalledUnits(TapList<Unit> units) {
        TapList<Object> hdRes;
        TapList<Object> tlRes = hdRes = new TapList<Object>(null, null);
        while (units != null) {
            if (((Unit)units.head).isStandard() && ((Unit)units.head).callersThatCall() == null) {
                tlRes = tlRes.placdl(units.head);
            }
            units = units.tail;
        }
        return hdRes.tail;
    }

    public boolean isGPU(Unit unit) {
        ParallelInfoOfUnit unitResult = this.parallelInfosOfUnits.retrieve(unit);
        return unitResult != null && unitResult.isGPU;
    }

    public BoolVector getSharedZonesOfUnit(Unit unit) {
        ParallelInfoOfUnit unitResult = this.parallelInfosOfUnits.retrieve(unit);
        return unitResult == null ? null : unitResult.sharedVariables;
    }

    public BoolVector getSharedZonesOfBlock(Block block) {
        BlockStorage<ParallelInfoOfBlock> unitBlocksResult = this.parallelInfosOfUnitsBlocks.retrieve(block.unit());
        ParallelInfoOfBlock blockResults = unitBlocksResult == null ? null : unitBlocksResult.retrieve(block);
        return blockResults == null || !blockResults.inParallelContext ? null : blockResults.sharedVariables;
    }

    public BoolVector getConflictFreeSharedAdjointZones(Block block) {
        Unit unit;
        ParallelInfoOfBlock blockResults;
        Block parallelRegionBlock = block;
        if (block.parallelControls != null) {
            parallelRegionBlock = TapList.last(block.parallelControls).block;
        }
        return (blockResults = this.parallelInfosOfUnitsBlocks.retrieve(unit = parallelRegionBlock.unit()).retrieve(parallelRegionBlock)) == null ? null : blockResults.conflictFreeSharedAdjointVariables;
    }

    @Override
    protected Object initializeCGForUnit() {
        if (this.phase == 1) {
            this.parallelInfosOfUnitsBlocks.store(this.curUnit, new BlockStorage(this.curUnit));
            ParallelInfoOfUnit parallelInfoOfUnit = new ParallelInfoOfUnit(this.curUnit);
            this.parallelInfosOfUnits.store(this.curUnit, parallelInfoOfUnit);
            return parallelInfoOfUnit;
        }
        return null;
    }

    @Override
    protected void initializeCGForRootUnit() {
        if (this.phase == 1) {
            ParallelInfoOfUnit parallelInfoOfRootUnit = this.parallelInfosOfUnits.retrieve(this.curUnit);
            int shapeLength = this.curUnit.paramElemsNb();
            BoolVector allShared = new BoolVector(shapeLength);
            allShared.setTrue();
            parallelInfoOfRootUnit.sharedVariables.setCopy(allShared, shapeLength);
        }
    }

    @Override
    protected boolean analyze() {
        TapList<ActivityPattern> activities;
        boolean hasChanged = false;
        if (this.phase == 1 && (activities = this.curUnit.activityPatterns) != null) {
            if (activities.tail == null) {
                this.curActivity = (ActivityPattern)activities.head;
                hasChanged = this.analyzeStatically(new TapList<Block>(this.curUnit.entryBlock(), null), null);
            } else {
                System.out.println("NOT YET IMPLEMENTED: multithread analysis when unit has several ActivityPattern's");
            }
        }
        return hasChanged;
    }

    @Override
    protected void terminateCGForUnit() {
    }

    @Override
    protected boolean terminateUnit() {
        return true;
    }

    @Override
    protected void initializeUnit() {
        if (this.phase == 1) {
            this.unitBlocksParallelInfos = this.parallelInfosOfUnitsBlocks.retrieve(this.curUnit);
        }
    }

    @Override
    protected void initializeInitBlock() {
        if (this.phase == 1) {
            this.unitBlocksParallelInfos.store(this.curBlock, this.curBlock == this.curUnit.entryBlock() ? this.unitParallelInfoToEntryBlockInfo(this.curUnit) : this.entryFrontierParallelInfo);
        }
    }

    private ParallelInfoOfBlock unitParallelInfoToEntryBlockInfo(Unit unit) {
        ParallelInfoOfUnit unitParallelInfo = (ParallelInfoOfUnit)this.topDownContext(unit);
        int[] entryMap = MultithreadAnalyzer.makeMap3(this.curSymbolTable, 0);
        BoolVector entrySharedVariables = this.propagateUnitDataInside(unitParallelInfo.sharedVariables, 0, entryMap);
        ParallelInfoOfBlock newInfo = new ParallelInfoOfBlock();
        newInfo.inParallelContext = unitParallelInfo.inParallelContext;
        newInfo.isGPU = unitParallelInfo.isGPU;
        newInfo.nbVars = MultithreadAnalyzer.mapSize(entryMap);
        newInfo.sharedVariables = entrySharedVariables;
        ParallelInfoOfBlock.access$802(newInfo, new SharedVarUses[newInfo.nbVars]);
        ParallelInfoOfBlock.access$902(newInfo, new SharedVarUses[newInfo.nbVars]);
        for (int i = 0; i < newInfo.nbVars; ++i) {
            if (newInfo.inParallelContext && entrySharedVariables.get(i)) {
                ZoneInfo zi = MultithreadAnalyzer.vectorIndexToZoneInfo(i, MultithreadAnalyzer.getMapClass(i, entryMap), 0, entryMap, this.curSymbolTable);
                ((ParallelInfoOfBlock)newInfo).sharedPrimalUses[i] = new SharedVarUses(zi);
                ((ParallelInfoOfBlock)newInfo).sharedAdjointUses[i] = new SharedVarUses(zi);
                continue;
            }
            ((ParallelInfoOfBlock)newInfo).sharedPrimalUses[i] = null;
            ((ParallelInfoOfBlock)newInfo).sharedAdjointUses[i] = null;
        }
        return newInfo;
    }

    @Override
    protected void propagateValuesStaticallyThroughBlock() {
        if (TapEnv.traceCurAnalysis()) {
            TapEnv.printlnOnTrace(" PROPAGATE THROUGH " + this.curBlock);
        }
        if (this.phase == 1) {
            ParallelInfoOfBlock controllerParallelInfo;
            Block parallelControllerBlock = this.curBlock.parallelControls == null ? null : ((Instruction)this.curBlock.parallelControls.head).block;
            SymbolTable controllerScope = this.curBlock.symbolTable;
            if (controllerScope.declarationsBlock == this.curBlock) {
                controllerScope = controllerScope.basisSymbolTable();
            }
            Block scopeControllerBlock = controllerScope == this.curUnit.publicSymbolTable() ? this.curUnit.entryBlock() : controllerScope.declarationsBlock;
            Block controllerBlock = parallelControllerBlock != null && parallelControllerBlock.symbolTable.nestedIn(controllerScope) ? parallelControllerBlock : scopeControllerBlock;
            ParallelInfoOfBlock currentParallelInfo = controllerParallelInfo = this.unitBlocksParallelInfos.retrieve(controllerBlock);
            if (TapEnv.traceCurAnalysis()) {
                TapEnv.printlnOnTrace("   parallel info before block entry:" + currentParallelInfo);
            }
            if (this.curBlock.isParallelController()) {
                currentParallelInfo = currentParallelInfo.copyAndAddClauses(this.curBlock.headInstr().tree);
                if (((Instruction)this.curBlock.instructions.head).tree.opCode() == 145) {
                    currentParallelInfo.toParallelLoopHeaders = new TapList<Object>(null, null);
                } else if (((Instruction)this.curBlock.instructions.head).tree.opCode() == 144) {
                    HeaderBlock loopHeader = (HeaderBlock)((FGArrow)this.curBlock.flow().head).destination;
                    currentParallelInfo.toParallelLoopHeaders.placdl(loopHeader.instructions.head);
                }
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("   new parallel info of parallel controller :" + currentParallelInfo);
                }
            } else if (this.curBlock == this.curBlock.symbolTable.declarationsBlock) {
                currentParallelInfo = currentParallelInfo.copyAndAddScope(this.curBlock.symbolTable);
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("   new parallel info entering new scope :" + currentParallelInfo);
                }
            }
            this.unitBlocksParallelInfos.store(this.curBlock, currentParallelInfo);
            TapList<Instruction> instrs = this.curBlock.instructions;
            while (instrs != null) {
                this.curInstruction = (Instruction)instrs.head;
                Tree instrTree = this.curInstruction.tree;
                int opCode = instrTree.opCode();
                Tree callTree = null;
                if (opCode == 31) {
                    callTree = instrTree;
                } else if (opCode == 14 && instrTree.down(2).opCode() == 31) {
                    callTree = instrTree.down(2);
                }
                if (callTree != null) {
                    this.addBlockParallelInfoIntoCalledUnitInfo(currentParallelInfo, callTree);
                }
                instrs = instrs.tail;
            }
        }
    }

    private void addBlockParallelInfoIntoCalledUnitInfo(ParallelInfoOfBlock blockParallelInfo, Tree callTree) {
        Unit calledUnit = MultithreadAnalyzer.getCalledUnit(callTree, this.curSymbolTable);
        assert (calledUnit != null);
        if (!calledUnit.isIntrinsic()) {
            if (TapEnv.traceCurAnalysis()) {
                TapEnv.printlnOnTrace("   Accumulate " + blockParallelInfo + " into " + calledUnit + " called by " + callTree);
            }
            CallArrow callArrow = CallGraph.getCallArrow(this.curUnit, calledUnit);
            int[] callerMap = MultithreadAnalyzer.makeMap3(0, 0, this.curSymbolTable.declaredZonesNb(0));
            Tree[] actualParams = ILUtils.getArguments(callTree).children();
            int nbArgs = actualParams.length;
            TapList[] argsParallelInfo = new TapList[nbArgs];
            for (int i = nbArgs - 1; i >= 0; --i) {
                Tree argTree = actualParams[i];
                TapList argZones = this.curSymbolTable.treeOfZonesOfValue(argTree, null, this.curInstruction, null);
                argZones = TapList.copyTree(argZones);
                MultithreadAnalyzer.includePointedElementsInTree(argZones, null, null, true, this.curSymbolTable, this.curInstruction, calledUnit, true, true);
                TapList<?> sharedInfoTree = MultithreadAnalyzer.buildInfoBoolTreeOfDeclaredZones(argZones, blockParallelInfo.sharedVariables, callerMap, null, 0, this.curSymbolTable);
                TapList inArgZonesTop = argZones;
                while (inArgZonesTop != null && inArgZonesTop.head instanceof TapList) {
                    inArgZonesTop = (TapList)inArgZonesTop.head;
                }
                TapIntList rootZones = inArgZonesTop == null ? null : (TapIntList)inArgZonesTop.head;
                boolean declaredShared = false;
                while (rootZones != null && !declaredShared) {
                    ZoneInfo zi = this.extendedDeclaredToZoneInfo(rootZones.head);
                    if (this.isCudaDeclaredShared(zi)) {
                        declaredShared = true;
                    }
                    rootZones = rootZones.tail;
                }
                if (declaredShared) {
                    this.setPointedLevelTrue(sharedInfoTree, 1);
                }
                argsParallelInfo[i] = sharedInfoTree;
            }
            BoolVector calleeNewSharedVariables = this.propagateEntryDataFwdToCallee(blockParallelInfo.sharedVariables, callerMap, argsParallelInfo, null, callArrow, null, 0, false);
            if (TapEnv.traceCurAnalysis()) {
                TapEnv.printlnOnTrace("   Accumulated shared zones: " + calleeNewSharedVariables);
            }
            ParallelInfoOfUnit callerUnitParallelInfo = (ParallelInfoOfUnit)this.topDownContext(this.curUnit);
            ParallelInfoOfUnit calledUnitParallelInfo = (ParallelInfoOfUnit)this.topDownContext(calledUnit);
            if (blockParallelInfo.inParallelContext && !calledUnitParallelInfo.inParallelContext) {
                calledUnitParallelInfo.inParallelContext = true;
                calledUnitParallelInfo.isGPU = callerUnitParallelInfo.isGPU || blockParallelInfo.isGPU;
                calledUnit.analysisIsOutOfDateDown = true;
            }
            if (calledUnitParallelInfo.sharedVariables.cumulOrGrows(calleeNewSharedVariables, calledUnit.paramElemsNb())) {
                calledUnit.analysisIsOutOfDateDown = true;
            }
        }
    }

    private boolean isCudaDeclaredShared(ZoneInfo zi) {
        SymbolDecl zoneSymbolDecl = zi == null ? null : zi.ownerSymbolDecl;
        return zoneSymbolDecl != null && (zoneSymbolDecl.hasModifier("__device__") || zoneSymbolDecl.hasModifier("__shared__") || zoneSymbolDecl.hasModifier("__managed__"));
    }

    private void setPointedLevelTrue(TapList boolTree, int depth) {
        if (boolTree != null) {
            if (boolTree.head instanceof TapList) {
                this.setPointedLevelTrue((TapList)boolTree.head, depth);
                this.setPointedLevelTrue(boolTree.tail, depth);
            } else {
                if (depth == 0) {
                    boolTree.head = Boolean.TRUE;
                }
                if (depth > 0) {
                    this.setPointedLevelTrue(boolTree.tail, depth - 1);
                }
            }
        }
    }

    private Expr[] treeToZ3Exprs(Tree t, HashMap<String, FuncDecl> idents, Context ctx) {
        Tree[] sons;
        switch (t.opCode()) {
            case 71: {
                sons = t.children();
                break;
            }
            default: {
                System.out.println("WARNING: Unexpected opcode for " + t + " in treeToZ3Exprs. This is probably going to crash.");
                return null;
            }
        }
        Expr[] operands = new Expr[sons.length];
        for (int i = 0; i < sons.length; ++i) {
            operands[i] = this.treeToZ3Expr(sons[i], idents, ctx);
        }
        return operands;
    }

    private Expr treeToZ3Expr(Tree t, HashMap<String, FuncDecl> idents, Context ctx) {
        switch (t.opCode()) {
            case 3: {
                Expr operand1 = this.treeToZ3Expr(t.down(1), idents, ctx);
                Expr operand2 = this.treeToZ3Expr(t.down(2), idents, ctx);
                return ctx.mkAdd(new Expr[]{operand1, operand2});
            }
            case 182: {
                Expr operand1 = this.treeToZ3Expr(t.down(1), idents, ctx);
                Expr operand2 = this.treeToZ3Expr(t.down(2), idents, ctx);
                return ctx.mkSub(new Expr[]{operand1, operand2});
            }
            case 124: {
                Expr operand1 = this.treeToZ3Expr(t.down(1), idents, ctx);
                return ctx.mkSub(new Expr[]{ctx.mkInt(0), operand1});
            }
            case 133: {
                Expr operand1 = this.treeToZ3Expr(t.down(1), idents, ctx);
                Expr operand2 = this.treeToZ3Expr(t.down(2), idents, ctx);
                return ctx.mkMul(new Expr[]{operand1, operand2});
            }
            case 126: {
                Expr operand1 = this.treeToZ3Expr(t.down(1), idents, ctx);
                Expr operand2 = this.treeToZ3Expr(t.down(2), idents, ctx);
                return ctx.mkMod(operand1, operand2);
            }
            case 62: {
                Expr operand1 = this.treeToZ3Expr(t.down(1), idents, ctx);
                Expr operand2 = this.treeToZ3Expr(t.down(2), idents, ctx);
                return ctx.mkDiv(operand1, operand2);
            }
            case 155: {
                Expr operand1 = this.treeToZ3Expr(t.down(1), idents, ctx);
                Expr operand2 = this.treeToZ3Expr(t.down(2), idents, ctx);
                return ctx.mkPower(operand1, operand2);
            }
            case 103: {
                return ctx.mkInt(t.intValue());
            }
            case 160: {
                System.out.println("Warning: floating point constants in index expressions may lead to incorrect parallelism");
                return ctx.mkReal(t.stringValue());
            }
            case 12: {
                StringSymbol symbol = ctx.mkSymbol("slice_" + this.sliceID++);
                return ctx.mkFuncDecl((Symbol)symbol, new Sort[0], (Sort)ctx.getIntSort()).apply(new Expr[0]);
            }
            case 9: {
                Expr[] indicesByDimension = this.treeToZ3Exprs(t.down(2), idents, ctx);
                return this.makeZ3FuncDecl(t.down(1), indicesByDimension, idents, ctx, "");
            }
            case 96: {
                return this.makeZ3FuncDecl(t, null, idents, ctx, "");
            }
            case 75: {
                return this.makeZ3FuncDecl(t.down(2), null, idents, ctx, t.down(1).stringValue() + "%");
            }
        }
        System.out.println("WARNING: Unexpected opcode for " + t + " in treeToZ3Expr. This is probably going to crash.");
        return null;
    }

    private Expr makeZ3FuncDecl(Tree t, Expr[] indices, HashMap<String, FuncDecl> idents, Context ctx, String prefix) {
        FuncDecl funcd;
        String funcname = prefix + t.stringValue();
        if (!idents.containsKey(t.stringValue())) {
            Sort[] domain;
            StringSymbol symbol = ctx.mkSymbol(funcname);
            if (indices != null) {
                domain = new Sort[indices.length];
                for (int i = 0; i < indices.length; ++i) {
                    domain[i] = ctx.getIntSort();
                }
            } else {
                domain = new Sort[]{};
            }
            funcd = ctx.mkFuncDecl((Symbol)symbol, domain, (Sort)ctx.getIntSort());
            idents.put(funcname, funcd);
        } else {
            funcd = idents.get(funcname);
        }
        if (indices == null) {
            return funcd.apply(new Expr[0]);
        }
        return funcd.apply(indices);
    }

    public void analyzeSharedAdjointConflicts(Unit unit, ActivityPattern activity, CallGraphDifferentiator cgDifferentiator) {
        this.setCurUnitEtc(unit);
        this.curActivity = activity;
        this.buildContexts();
        if (TapEnv.traceCurAnalysis()) {
            System.out.println("BUILT CONTEXTS OF UNIT: " + this.curUnit);
            this.dumpExistingContexts();
            TapList<Block> bl1 = this.curUnit.allBlocks();
            while (bl1 != null) {
                MTContext context = this.blockContexts.retrieve((Block)bl1.head);
                System.out.println("Block " + bl1.head + " has context " + (context == null ? "NONE" : Integer.valueOf(context.rank)));
                bl1 = bl1.tail;
            }
        }
        this.buildInstances();
        if (TapEnv.traceCurAnalysis()) {
            System.out.println("BUILT INSTANCES OF UNIT: " + this.curUnit);
            TapList<Block> lb2 = this.curUnit.allBlocks();
            while (lb2 != null) {
                System.out.println("Instances through Block " + lb2.head);
                TapList<MTInstances> instancesList = this.blockInstances.retrieve((Block)lb2.head);
                while (instancesList != null) {
                    System.out.println("    " + instancesList.head);
                    instancesList = instancesList.tail;
                }
                lb2 = lb2.tail;
            }
        }
        if (TapEnv.traceCurAnalysis()) {
            System.out.println("ENUMERATE PRIMAL AND DIFF USES OF MULTITHREAD SHARED VARIABLES OF UNIT: " + this.curUnit);
        }
        this.collectAllSharedUses(cgDifferentiator);
        TapList<Block> allBlocks = this.curUnit.allBlocks();
        while (allBlocks != null) {
            Block block = (Block)allBlocks.head;
            if (block.isParallelController() && ((Instruction)block.instructions.head).tree.opCode() == 145) {
                this.setCurBlockEtc(block);
                this.curVectorMap = DataFlowAnalyzer.makeMap3(unit, block, 0);
                ParallelInfoOfBlock parallelRegionInfo = this.parallelInfosOfUnitsBlocks.retrieve(unit).retrieve(block);
                TapList<String> parallelLoopIndicesWithInstance = null;
                TapList parallelLoopHeaders = ((ParallelInfoOfBlock)parallelRegionInfo).toParallelLoopHeaders.tail;
                while (parallelLoopHeaders != null) {
                    Instruction parallelLoopInstr = (Instruction)parallelLoopHeaders.head;
                    Tree loopIndex = parallelLoopInstr.tree.down(3).down(1);
                    TapIntList indexZones = this.curSymbolTable.listOfZonesOfValue(loopIndex, null, null);
                    indexZones = MultithreadAnalyzer.mapExtendedDeclaredToVectorIndex(indexZones, 0, this.curVectorMap, this.curSymbolTable, null);
                    parallelRegionInfo.sharedVariables.set(indexZones, false);
                    Tree loopIndexCopy = ILUtils.copy(loopIndex);
                    MTInstances loopHeaderInstances = (MTInstances)this.blockInstances.retrieve((Block)parallelLoopInstr.block).tail.head;
                    MultithreadAnalyzer.attachInstances(loopIndexCopy, loopHeaderInstances, parallelLoopInstr, true);
                    parallelLoopIndicesWithInstance = new TapList<String>(loopIndexCopy.stringValue(), parallelLoopIndicesWithInstance);
                    parallelLoopHeaders = parallelLoopHeaders.tail;
                }
                if (TapEnv.traceCurAnalysis()) {
                    System.out.println("BUILD CONFLICT-FREE KNOWLEDGE FOR PARALLEL REGION " + block);
                }
                this.buildConflicts(parallelRegionInfo, false);
                if (TapEnv.traceCurAnalysis()) {
                    System.out.println("BUILD CONFLICT-FREE QUESTIONS FOR PARALLEL REGION " + block);
                }
                this.buildConflicts(parallelRegionInfo, true);
                if (TapEnv.traceCurAnalysis()) {
                    System.out.println("PARALLEL LOOPS IN PARALLEL REGION ARE:" + ((ParallelInfoOfBlock)parallelRegionInfo).toParallelLoopHeaders.tail);
                    this.dumpExistingContexts();
                }
                BoolVector conflictFreeZones = new BoolVector(MultithreadAnalyzer.mapSize(this.curVectorMap));
                conflictFreeZones.setFalse();
                if (TapEnv.doOpenMPZ3()) {
                    try {
                        HashMap<String, String> cfg = new HashMap<String, String>();
                        cfg.put("model", "true");
                        Context ctx = new Context(cfg);
                        Solver z3Solver = ctx.mkSolver();
                        conflictFreeZones.setTrue();
                        int z3KnowledgeModelSize = 0;
                        int z3QuestionQueries = 0;
                        TapList<MTContext> inExistingContexts = this.existingContexts;
                        while (inExistingContexts != null) {
                            Expr[] rhs;
                            Expr[] lhs;
                            MTContext context;
                            HashMap<String, FuncDecl> variableIdentsInZ3 = new HashMap<String, FuncDecl>();
                            while (parallelLoopIndicesWithInstance != null) {
                                String index = (String)parallelLoopIndicesWithInstance.head;
                                String jndex = index + "_prime";
                                StringSymbol indexSymbol = ctx.mkSymbol(index);
                                StringSymbol jndexSymbol = ctx.mkSymbol(jndex);
                                Sort[] indexDomain = new Sort[]{};
                                FuncDecl indexFunc = ctx.mkFuncDecl((Symbol)indexSymbol, indexDomain, (Sort)ctx.getIntSort());
                                FuncDecl jndexFunc = ctx.mkFuncDecl((Symbol)jndexSymbol, indexDomain, (Sort)ctx.getIntSort());
                                BoolExpr loopIndicesDistinct = ctx.mkNot((Expr)ctx.mkEq(indexFunc.apply(new Expr[0]), jndexFunc.apply(new Expr[0])));
                                if (TapEnv.traceCurAnalysis()) {
                                    System.out.println("adding inequality (loop counters): " + loopIndicesDistinct);
                                }
                                z3Solver.add(new Expr[]{loopIndicesDistinct});
                                ++z3KnowledgeModelSize;
                                variableIdentsInZ3.put(index, indexFunc);
                                variableIdentsInZ3.put(jndex, jndexFunc);
                                parallelLoopIndicesWithInstance = parallelLoopIndicesWithInstance.tail;
                            }
                            if (TapEnv.traceCurAnalysis()) {
                                System.out.println("ASSEMBLE KNOWLEDGE ABOUT CONTEXT (WITH PARENTS):" + inExistingContexts.head);
                            }
                            TapList<MTContext> parentContexts = inExistingContexts;
                            while (parentContexts != null) {
                                context = (MTContext)parentContexts.head;
                                TapList<TapTriplet<Tree, Tree, ZoneInfo>> knowledge = context.knowledge;
                                while (knowledge != null) {
                                    TapTriplet fact = (TapTriplet)knowledge.head;
                                    lhs = this.treeToZ3Exprs((Tree)fact.first, variableIdentsInZ3, ctx);
                                    rhs = this.treeToZ3Exprs((Tree)fact.second, variableIdentsInZ3, ctx);
                                    BoolExpr distinct = ctx.mkFalse();
                                    for (int i = 0; i < lhs.length; ++i) {
                                        distinct = ctx.mkOr(new Expr[]{ctx.mkNot((Expr)ctx.mkEq(lhs[i], rhs[i])), distinct});
                                    }
                                    if (TapEnv.traceCurAnalysis()) {
                                        System.out.println("adding inequality: " + distinct);
                                    }
                                    z3Solver.add(new Expr[]{distinct});
                                    ++z3KnowledgeModelSize;
                                    knowledge = knowledge.tail;
                                }
                                parentContexts = ((MTContext)parentContexts.head).largerContexts;
                            }
                            Status status = z3Solver.check();
                            if (TapEnv.traceCurAnalysis()) {
                                if (status == Status.SATISFIABLE) {
                                    System.out.println("The knowledge model is SATISFIABLE");
                                } else if (status == Status.UNKNOWN) {
                                    System.out.println("The knowledge model is UNKNOWN");
                                } else {
                                    System.out.println("The knowledge model is UNSATISFIABLE");
                                }
                            }
                            context = (MTContext)inExistingContexts.head;
                            TapList<TapTriplet<Tree, Tree, ZoneInfo>> questions = context.questions;
                            while (questions != null) {
                                TapTriplet question = (TapTriplet)questions.head;
                                if (TapEnv.traceCurAnalysis()) {
                                    System.out.println("asking question: " + question);
                                }
                                if (question.first == null || question.second == null) {
                                    if (TapEnv.traceCurAnalysis()) {
                                        System.out.println("The question involves one total access, cannot be shared");
                                    }
                                    conflictFreeZones.set(((ZoneInfo)question.third).zoneNb, false);
                                } else {
                                    lhs = this.treeToZ3Exprs((Tree)question.first, variableIdentsInZ3, ctx);
                                    rhs = this.treeToZ3Exprs((Tree)question.second, variableIdentsInZ3, ctx);
                                    BoolExpr equal = ctx.mkTrue();
                                    for (int i = 0; i < lhs.length; ++i) {
                                        equal = ctx.mkAnd(new Expr[]{ctx.mkEq(lhs[i], rhs[i]), equal});
                                    }
                                    if (TapEnv.traceCurAnalysis()) {
                                        System.out.println("adding equality: " + equal);
                                    }
                                    z3Solver.push();
                                    z3Solver.add(new Expr[]{equal});
                                    status = z3Solver.check();
                                    ++z3QuestionQueries;
                                    if (status == Status.SATISFIABLE) {
                                        if (TapEnv.traceCurAnalysis()) {
                                            System.out.println("The question model is SATISFIABLE");
                                        }
                                        conflictFreeZones.set(((ZoneInfo)question.third).zoneNb, false);
                                    } else if (status == Status.UNKNOWN) {
                                        if (TapEnv.traceCurAnalysis()) {
                                            System.out.println("The question model is UNKNOWN");
                                        }
                                        conflictFreeZones.set(((ZoneInfo)question.third).zoneNb, false);
                                    } else if (TapEnv.traceCurAnalysis()) {
                                        System.out.println("The question model is UNSATISFIABLE");
                                    }
                                    z3Solver.pop();
                                }
                                questions = questions.tail;
                            }
                            parallelRegionInfo.conflictFreeSharedAdjointVariables = conflictFreeZones;
                            inExistingContexts = inExistingContexts.tail;
                        }
                        if (TapEnv.traceCurAnalysis()) {
                            System.out.println("CONFLICT-FREE SHARED ADJOINT ZONES FOR PARALLEL REGION " + block + " ARE " + conflictFreeZones);
                            System.out.println("Z3 STATS: knowledge model size " + z3KnowledgeModelSize + " numQuestionQueries " + z3QuestionQueries);
                        }
                    }
                    catch (UnsatisfiedLinkError e) {
                        System.out.println("PROBLEM WITH Z3 INSTALLATION: " + e);
                        TapEnv.setDoOpenMPZ3(false);
                        conflictFreeZones.setFalse();
                    }
                }
            }
            allBlocks = allBlocks.tail;
        }
        this.setCurBlockEtc(null);
    }

    public void collectAllSharedUses(CallGraphDifferentiator cgDifferentiator) {
        TapList<Block> allBlocks = this.curUnit.allBlocks();
        while (allBlocks != null) {
            Block block = (Block)allBlocks.head;
            this.curSymbolTable = block.symbolTable;
            this.curVectorMap = DataFlowAnalyzer.makeMap3(this.curUnit, block, 0);
            BoolVector sharedZones = this.getSharedZonesOfBlock(block);
            if (block.parallelControls != null && sharedZones != null && !sharedZones.isFalse(DataFlowAnalyzer.mapSize(this.curVectorMap))) {
                ParallelInfoOfBlock blockResults = this.parallelInfosOfUnitsBlocks.retrieve(this.curUnit).retrieve(block);
                SharedVarUses[] sharedPrimalUses = blockResults.sharedPrimalUses;
                SharedVarUses[] sharedAdjointUses = blockResults.sharedAdjointUses;
                TapList<MTInstances> instancesList = this.blockInstances.retrieve(block);
                TapList<Instruction> instrs = block.instructions;
                while (instrs != null) {
                    this.curInstruction = (Instruction)instrs.head;
                    Tree instrTree = this.curInstruction.tree;
                    MTInstances instances = (MTInstances)instancesList.head;
                    int opCode = instrTree.opCode();
                    Tree callResult = null;
                    Tree functionCall = null;
                    Unit calledUnit = null;
                    if (opCode == 31) {
                        functionCall = instrTree;
                    } else if (opCode == 14 && instrTree.down(2).opCode() == 31) {
                        functionCall = instrTree.down(2);
                        callResult = instrTree.down(1);
                    }
                    if (functionCall != null) {
                        calledUnit = DataFlowAnalyzer.getCalledUnit(functionCall, this.curSymbolTable);
                    }
                    if (calledUnit != null && !calledUnit.hasPredefinedDerivatives()) {
                        ActivityPattern calledActivity = (ActivityPattern)ActivityPattern.getAnnotationForActivityPattern(functionCall, this.curActivity, "multiActivityCalleePatterns");
                        boolean diffCallNeeded = calledActivity != null;
                        Tree[] args = ILUtils.getArguments(functionCall).children();
                        boolean[] formalArgsActivity = cgDifferentiator.getUnitFormalArgsActivityS(calledActivity);
                        if (callResult != null && this.refExpressionIsShared(callResult, sharedZones)) {
                            this.collectOneSharedVarUse(callResult, instances, this.curInstruction, false, sharedPrimalUses);
                            if (diffCallNeeded && formalArgsActivity[formalArgsActivity.length - 1] && ADActivityAnalyzer.isAnnotatedActive(this.curActivity, callResult, this.curSymbolTable)) {
                                this.collectOneSharedVarUse(callResult, instances, this.curInstruction, false, sharedAdjointUses);
                            }
                        }
                        for (int i = args.length - 1; i >= 0; --i) {
                            this.collectAllSharedVarUsesInExpression(args[i], sharedZones, instances, diffCallNeeded && formalArgsActivity[i], null, sharedPrimalUses, sharedAdjointUses);
                            if (!ILUtils.isAVarRef(args[i], this.curSymbolTable) || !this.refExpressionIsShared(args[i], sharedZones)) continue;
                            this.collectOneSharedVarUse(args[i], instances, this.curInstruction, false, sharedPrimalUses);
                        }
                    } else if (opCode == 14) {
                        boolean lhsIsShared;
                        ToObject<Object> toAddedTree;
                        Tree rhs;
                        Tree lhs = instrTree.down(1);
                        boolean increments = this.detectIncrement(lhs, rhs = instrTree.down(2), toAddedTree = new ToObject<Object>(null));
                        if (increments) {
                            rhs = toAddedTree.obj();
                        }
                        if (lhsIsShared = this.refExpressionIsShared(lhs, sharedZones)) {
                            this.collectOneSharedVarUse(lhs, instances, this.curInstruction, false, sharedPrimalUses);
                        }
                        boolean activeResult = ADActivityAnalyzer.isAnnotatedActive(this.curActivity, lhs, this.curSymbolTable);
                        ToBool oneAdjointInRhs = new ToBool(false);
                        this.collectAllSharedVarUsesInExpression(rhs, sharedZones, instances, activeResult, oneAdjointInRhs, sharedPrimalUses, sharedAdjointUses);
                        if (activeResult && lhsIsShared) {
                            if (!increments) {
                                this.collectOneSharedVarUse(lhs, instances, this.curInstruction, false, sharedAdjointUses);
                            } else if (oneAdjointInRhs.get()) {
                                this.collectOneSharedVarUse(lhs, instances, this.curInstruction, true, sharedAdjointUses);
                            }
                        }
                    }
                    instancesList = instancesList.tail;
                    instrs = instrs.tail;
                }
            }
            allBlocks = allBlocks.tail;
        }
        this.curSymbolTable = null;
        this.curVectorMap = null;
        this.curInstruction = null;
    }

    private void collectAllSharedVarUsesInExpression(Tree expression, BoolVector sharedZones, MTInstances instances, boolean activeResult, ToBool oneAdjointInRhs, SharedVarUses[] sharedPrimalUses, SharedVarUses[] sharedAdjointUses) {
        if (!ILUtils.isNullOrNone(expression)) {
            switch (expression.opCode()) {
                case 31: {
                    Tree[] args = ILUtils.getArguments(expression).children();
                    for (int i = args.length - 1; i >= 0; --i) {
                        this.collectAllSharedVarUsesInExpression(args[i], sharedZones, instances, activeResult, oneAdjointInRhs, sharedPrimalUses, sharedAdjointUses);
                    }
                    break;
                }
                case 9: 
                case 75: 
                case 96: 
                case 151: {
                    if (!this.refExpressionIsShared(expression, sharedZones)) break;
                    this.collectOneSharedVarUse(expression, instances, this.curInstruction, true, sharedPrimalUses);
                    if (!activeResult || !ADActivityAnalyzer.isAnnotatedActive(this.curActivity, expression, this.curSymbolTable)) break;
                    this.collectOneSharedVarUse(expression, instances, this.curInstruction, false, sharedAdjointUses);
                    if (oneAdjointInRhs == null) break;
                    oneAdjointInRhs.set(true);
                    break;
                }
                case 3: 
                case 62: 
                case 126: 
                case 133: 
                case 155: 
                case 182: {
                    this.collectAllSharedVarUsesInExpression(expression.down(1), sharedZones, instances, activeResult, oneAdjointInRhs, sharedPrimalUses, sharedAdjointUses);
                    this.collectAllSharedVarUsesInExpression(expression.down(2), sharedZones, instances, activeResult, oneAdjointInRhs, sharedPrimalUses, sharedAdjointUses);
                    break;
                }
                case 124: {
                    this.collectAllSharedVarUsesInExpression(expression.down(1), sharedZones, instances, activeResult, oneAdjointInRhs, sharedPrimalUses, sharedAdjointUses);
                    break;
                }
                case 32: 
                case 194: {
                    this.collectAllSharedVarUsesInExpression(expression.down(2), sharedZones, instances, activeResult, oneAdjointInRhs, sharedPrimalUses, sharedAdjointUses);
                    break;
                }
                case 99: {
                    this.collectAllSharedVarUsesInExpression(expression.down(2), sharedZones, instances, activeResult, oneAdjointInRhs, sharedPrimalUses, sharedAdjointUses);
                    this.collectAllSharedVarUsesInExpression(expression.down(3), sharedZones, instances, activeResult, oneAdjointInRhs, sharedPrimalUses, sharedAdjointUses);
                    break;
                }
                case 10: 
                case 47: 
                case 110: {
                    break;
                }
            }
        }
    }

    public void collectOneSharedVarUse(Tree expr, MTInstances instances, Instruction instr, boolean justRead, SharedVarUses[] sharedVarUses) {
        TapIntList exprZones = ZoneInfo.listAllZones(this.curSymbolTable.treeOfZonesOfValue(expr, null, instr, null), false);
        TapIntList exprRanks = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(exprZones, 0, this.curVectorMap, this.curSymbolTable, null);
        Tree instancedExpr = ILUtils.copy(expr);
        MultithreadAnalyzer.attachInstances(instancedExpr, instances, instr, false);
        while (exprRanks != null) {
            int rank = exprRanks.head;
            if (rank >= 0 && sharedVarUses[rank] != null) {
                sharedVarUses[rank].collectOneUse(instancedExpr, instr.block, justRead);
            }
            exprRanks = exprRanks.tail;
        }
    }

    private boolean detectIncrement(Tree lhs, Tree rhs, ToObject<Tree> toAddedTree) {
        toAddedTree.setObj(null);
        if (rhs.opCode() == 3) {
            if (lhs.equalsTree(rhs.down(1))) {
                toAddedTree.setObj(rhs.down(2));
            } else if (lhs.equalsTree(rhs.down(2))) {
                toAddedTree.setObj(rhs.down(1));
            }
        } else if (rhs.opCode() == 182 && lhs.equalsTree(rhs.down(1))) {
            toAddedTree.setObj(rhs.down(2));
        }
        return toAddedTree.obj() != null;
    }

    private boolean refExpressionIsShared(Tree expr, BoolVector sharedZones) {
        TapIntList exprZones = ZoneInfo.listAllZones(this.curSymbolTable.treeOfZonesOfValue(expr, null, this.curInstruction, null), false);
        return DataFlowAnalyzer.intersectsExtendedDeclared(sharedZones, this.curVectorMap, 0, exprZones, null, this.curSymbolTable, null);
    }

    public static void attachInstances(Tree expr, MTInstances instances, Instruction instr, boolean inIndex) {
        if (expr == null) {
            return;
        }
        switch (expr.opCode()) {
            case 96: {
                TapIntList zones;
                if (!inIndex || (zones = instr.block.symbolTable.listOfZonesOfValue(expr, null, instr)) == null) break;
                if (zones.tail != null) {
                    System.out.println("Searching instance for Z3: identifier " + expr + " has more than one zone " + zones);
                }
                expr.setAnnotation("withoutInstance", expr.stringValue());
                expr.setValue(expr.stringValue() + "_" + instances.getInstance(zones.head));
                break;
            }
            case 75: {
                MultithreadAnalyzer.attachInstances(expr.down(1), instances, instr, inIndex);
                break;
            }
            case 173: {
                MultithreadAnalyzer.attachInstances(expr.down(2), instances, instr, inIndex);
                break;
            }
            case 31: {
                MultithreadAnalyzer.attachInstances(ILUtils.getArguments(expr), instances, instr, inIndex);
                break;
            }
            case 4: 
            case 37: {
                break;
            }
            case 9: 
            case 151: {
                MultithreadAnalyzer.attachInstances(expr.down(1), instances, instr, inIndex);
                MultithreadAnalyzer.attachInstances(expr.down(2), instances, instr, true);
                break;
            }
            default: {
                Tree[] subTrees = expr.children();
                if (subTrees == null) break;
                for (int i = subTrees.length - 1; i >= 0; --i) {
                    MultithreadAnalyzer.attachInstances(subTrees[i], instances, instr, inIndex);
                }
            }
        }
    }

    public void buildConflicts(ParallelInfoOfBlock parallelRegionInfo, boolean isQuestion) {
        SharedVarUses[] sharedUses = isQuestion ? parallelRegionInfo.sharedAdjointUses : parallelRegionInfo.sharedPrimalUses;
        for (int i = MultithreadAnalyzer.mapSize(this.curVectorMap) - 1; i >= 0; --i) {
            if (sharedUses[i] == null || sharedUses[i].writeUses == null) continue;
            sharedUses[i].storeConflictsIntoContexts(parallelRegionInfo, isQuestion);
        }
    }

    public void buildContexts() {
        this.blockContexts = new BlockStorage(this.curUnit);
        TapList<Object> toExistingContexts = new TapList<Object>(null, null);
        int numberOfContexts = 0;
        TapList<Block> allBlocks = this.curUnit.allBlocks();
        while (allBlocks != null) {
            Block block = (Block)allBlocks.head;
            if (block.parallelControls != null) {
                TapList<Object> toLargerContexts = new TapList<Object>(null, null);
                TapList<Object> toSmallerContexts = new TapList<Object>(null, null);
                MTContext blockContext = this.findSameContext(block, toExistingContexts.tail, toLargerContexts, toSmallerContexts);
                if (blockContext == null) {
                    blockContext = new MTContext(this.curUnit);
                    blockContext.rank = numberOfContexts++;
                    toExistingContexts.placdl(blockContext);
                    blockContext.largerContexts = toLargerContexts.tail;
                    toSmallerContexts = toSmallerContexts.tail;
                    while (toSmallerContexts != null) {
                        ((MTContext)toSmallerContexts.head).largerContexts = new TapList<MTContext>(blockContext, ((MTContext)toSmallerContexts.head).largerContexts);
                        toSmallerContexts = toSmallerContexts.tail;
                    }
                }
                blockContext.addBlock(block);
                this.blockContexts.store(block, blockContext);
            }
            allBlocks = allBlocks.tail;
        }
        this.existingContexts = TapList.nreverse(toExistingContexts.tail);
    }

    private MTContext findSameContext(Block block, TapList<MTContext> inExistingContexts, TapList<MTContext> toLargerContexts, TapList<MTContext> toSmallerContexts) {
        MTContext found = null;
        while (found == null && inExistingContexts != null) {
            MTContext context = (MTContext)inExistingContexts.head;
            if (context.isPredecessorOf(block) || context.isSuccessorOf(block)) {
                if (context.isSucceededBy(block) || context.isPrecededBy(block)) {
                    found = context;
                } else {
                    toLargerContexts.placdl(context);
                }
            } else if (context.isSucceededBy(block) || context.isPrecededBy(block)) {
                toSmallerContexts.placdl(context);
            }
            inExistingContexts = inExistingContexts.tail;
        }
        return found;
    }

    public void dumpExistingContexts() {
        TapList<MTContext> inExistingContexts = this.existingContexts;
        while (inExistingContexts != null) {
            System.out.println("Context " + inExistingContexts.head);
            inExistingContexts = inExistingContexts.tail;
        }
    }

    public void buildInstances() {
        MTInstances curInstances;
        int nbZones;
        Block block;
        this.blockInstances = new BlockStorage(this.curUnit);
        this.blockInstancesBefore = new BlockStorage(this.curUnit);
        this.blockInstancesAfter = new BlockStorage(this.curUnit);
        this.loopModifiedZones = new BlockStorage(this.curUnit);
        TapList<Block> allBlocks = this.curUnit.allBlocks();
        while (allBlocks != null) {
            block = (Block)allBlocks.head;
            nbZones = block.symbolTable.declaredZonesNb(0);
            if (block.isParallelController() && ((Instruction)block.instructions.head).tree.opCode() == 145) {
                curInstances = new MTInstances(nbZones, 0);
                this.freeInstances = new MTInstances(nbZones, 1);
                this.blockInstancesAfter.store(block, curInstances);
            } else if (block.parallelControls != null) {
                curInstances = this.joinInstances(this.fromBlocksAbove(block.backFlow()), nbZones);
                this.blockInstancesBefore.store(block, curInstances);
                TapList<MTInstances> instancesList = new TapList<MTInstances>(curInstances, null);
                this.blockInstances.store(block, instancesList);
                TapList<MTInstances> tlInstancesList = instancesList;
                TapList<Instruction> instructions = block.instructions;
                while (instructions != null) {
                    curInstances = this.propagateInstances(curInstances, (Instruction)instructions.head, nbZones);
                    tlInstancesList = tlInstancesList.placdl(curInstances);
                    instructions = instructions.tail;
                }
                this.blockInstancesAfter.store(block, curInstances);
            }
            allBlocks = allBlocks.tail;
        }
        allBlocks = this.curUnit.allBlocks();
        while (allBlocks != null) {
            block = (Block)allBlocks.head;
            nbZones = block.symbolTable.declaredZonesNb(0);
            if (block.isParallelController() && ((Instruction)block.instructions.head).tree.opCode() == 145) {
                curInstances = new MTInstances(nbZones, 0);
                this.freeInstances = new MTInstances(nbZones, 1);
                this.blockInstancesAfter.store(block, curInstances);
            } else if (block.parallelControls != null) {
                curInstances = this.joinInstances(this.fromBlocksAbove(block.backFlow()), nbZones);
                TapList<FGArrow> loopingArrows = this.fromBlocksBelow(block.backFlow());
                if (loopingArrows != null) {
                    MTInstances beforeOnFirstSweep = this.blockInstancesBefore.retrieve(block);
                    MTInstances loopingOnFirstSweep = this.joinInstances(loopingArrows, nbZones);
                    BoolVector loopOverwrites = this.differentInstances(beforeOnFirstSweep, loopingOnFirstSweep, nbZones);
                    this.loopModifiedZones.store(block, loopOverwrites);
                    this.newInstanceIfLoopOverwrites(curInstances, loopOverwrites, nbZones);
                }
                TapList<MTInstances> instancesList = new TapList<MTInstances>(curInstances, null);
                this.blockInstances.store(block, instancesList);
                TapList<MTInstances> tlInstancesList = instancesList;
                TapList<Instruction> instructions = block.instructions;
                while (instructions != null) {
                    curInstances = this.propagateInstances(curInstances, (Instruction)instructions.head, nbZones);
                    tlInstancesList = tlInstancesList.placdl(curInstances);
                    instructions = instructions.tail;
                }
                this.blockInstancesAfter.store(block, curInstances);
            }
            allBlocks = allBlocks.tail;
        }
        this.blockInstancesBefore = null;
        this.blockInstancesAfter = null;
        this.loopModifiedZones = null;
        this.freeInstances = null;
    }

    private TapList<FGArrow> fromBlocksAbove(TapList<FGArrow> backFlow) {
        TapList result = null;
        while (backFlow != null) {
            if (((FGArrow)backFlow.head).origin.rank < ((FGArrow)backFlow.head).destination.rank) {
                result = new TapList(backFlow.head, result);
            }
            backFlow = backFlow.tail;
        }
        return result;
    }

    private TapList<FGArrow> fromBlocksBelow(TapList<FGArrow> backFlow) {
        TapList result = null;
        while (backFlow != null) {
            if (((FGArrow)backFlow.head).origin.rank >= ((FGArrow)backFlow.head).destination.rank) {
                result = new TapList(backFlow.head, result);
            }
            backFlow = backFlow.tail;
        }
        return result;
    }

    private MTInstances joinInstances(TapList<FGArrow> incomings, int nbZones) {
        MTInstances result = new MTInstances(nbZones, -1);
        while (incomings != null) {
            HeaderBlock exitedHeader;
            BoolVector loopOverwrites;
            Block origin = ((FGArrow)incomings.head).origin;
            MTInstances arriving = this.blockInstancesAfter.retrieve(origin);
            Block topmostPopped = ((FGArrow)incomings.head).topmostPop();
            if (topmostPopped != origin && (loopOverwrites = this.loopModifiedZones.retrieve(exitedHeader = ((LoopBlock)topmostPopped).header())) != null) {
                for (int i = 0; i < nbZones; ++i) {
                    if (!loopOverwrites.get(i)) continue;
                    result.setInstance(i, -2);
                }
            }
            block6: for (int i = 0; i < nbZones; ++i) {
                switch (result.getInstance(i)) {
                    case -2: {
                        continue block6;
                    }
                    case -1: {
                        result.setInstance(i, arriving.getInstance(i));
                        continue block6;
                    }
                    default: {
                        if (result.getInstance(i) == arriving.getInstance(i)) continue block6;
                        result.setInstance(i, -2);
                    }
                }
            }
            incomings = incomings.tail;
        }
        for (int i = 0; i < nbZones; ++i) {
            if (result.getInstance(i) != -2 && result.getInstance(i) != -1) continue;
            int freeI = this.freeInstances.getInstance(i);
            this.freeInstances.setInstance(i, freeI + 1);
            result.setInstance(i, freeI);
        }
        return result;
    }

    private MTInstances propagateInstances(MTInstances instancesBefore, Instruction instr, int nbZones) {
        BoolVector zonesWrittenHere = new BoolVector(nbZones);
        zonesWrittenHere.setFalse();
        MultithreadAnalyzer.collectZonesWrittenByExpression(instr.tree, 0, zonesWrittenHere, instr);
        MTInstances result = new MTInstances(nbZones, -1);
        for (int i = 0; i < nbZones; ++i) {
            if (zonesWrittenHere.get(i)) {
                int freeI = this.freeInstances.getInstance(i);
                this.freeInstances.setInstance(i, freeI + 1);
                result.setInstance(i, freeI);
                continue;
            }
            result.setInstance(i, instancesBefore.getInstance(i));
        }
        return result;
    }

    private BoolVector differentInstances(MTInstances before, MTInstances looping, int nbZones) {
        BoolVector result = new BoolVector(nbZones);
        for (int i = 0; i < nbZones; ++i) {
            if (before.getInstance(i) == looping.getInstance(i)) continue;
            result.set(i, true);
        }
        return result;
    }

    private void newInstanceIfLoopOverwrites(MTInstances instances, BoolVector loopOverwrites, int nbZones) {
        for (int i = 0; i < nbZones; ++i) {
            if (!loopOverwrites.get(i)) continue;
            int freeI = this.freeInstances.getInstance(i);
            this.freeInstances.setInstance(i, freeI + 1);
            instances.setInstance(i, freeI);
        }
    }

    private static final class MTInstances {
        int[] insts;

        public MTInstances(int nbZones, int initVal) {
            this.insts = new int[nbZones];
            for (int i = nbZones - 1; i >= 0; --i) {
                this.insts[i] = initVal;
            }
        }

        public int getInstance(int zone) {
            return this.insts[zone];
        }

        public void setInstance(int zone, int newVal) {
            this.insts[zone] = newVal;
        }

        public String toString() {
            if (this.insts == null) {
                return "?";
            }
            String res = "]";
            for (int i = this.insts.length - 1; i >= 0; --i) {
                res = i + "->" + this.insts[i] + " " + res;
            }
            return "[" + res;
        }
    }

    private static final class MTContext {
        int rank;
        BoolVector contents;
        BoolVector predecessors;
        BoolVector successors;
        TapList<MTContext> largerContexts;
        TapList<TapTriplet<Tree, Tree, ZoneInfo>> knowledge;
        TapList<TapTriplet<Tree, Tree, ZoneInfo>> questions;

        MTContext(Unit unit) {
            this.contents = new BoolVector(unit.nbBlocks + 1);
            this.predecessors = new BoolVector(unit.nbBlocks + 1);
            this.successors = new BoolVector(unit.nbBlocks + 1);
            this.largerContexts = null;
            this.knowledge = null;
            this.questions = null;
        }

        void addBlock(Block block) {
            this.contents.set(block.rank + 1, true);
            this.predecessors.cumulOr(block.dominator);
            this.successors.cumulOr(block.postDominator);
        }

        boolean isPredecessorOf(Block block) {
            return this.contents.intersects(block.dominator, block.unit().nbBlocks + 1);
        }

        boolean isPrecededBy(Block block) {
            return this.predecessors.get(block.rank + 1);
        }

        boolean isSuccessorOf(Block block) {
            return this.contents.intersects(block.postDominator, block.unit().nbBlocks + 1);
        }

        boolean isSucceededBy(Block block) {
            return this.successors.get(block.rank + 1);
        }

        public static void storeConflictPair(Tree access1, MTContext context1, Tree access2, MTContext context2, ZoneInfo zoneInfo, boolean isQuestion) {
            MTContext targetContext = null;
            if (isQuestion) {
                targetContext = context1 == context2 || TapList.contains(context1.largerContexts, context2) ? context2 : (TapList.contains(context2.largerContexts, context1) ? context1 : MTContext.commonEnclosing(context1, context2));
                targetContext.questions = new TapList<TapTriplet<Tree, Tree, ZoneInfo>>(new TapTriplet<Tree, Tree, ZoneInfo>(access1, access2, zoneInfo), targetContext.questions);
            } else {
                if (context1 == context2 || TapList.contains(context1.largerContexts, context2)) {
                    targetContext = context1;
                } else if (TapList.contains(context2.largerContexts, context1)) {
                    targetContext = context2;
                }
                if (targetContext != null) {
                    targetContext.knowledge = new TapList<TapTriplet<Tree, Tree, ZoneInfo>>(new TapTriplet<Tree, Tree, ZoneInfo>(access1, access2, zoneInfo), targetContext.knowledge);
                }
            }
        }

        public static MTContext commonEnclosing(MTContext context1, MTContext context2) {
            MTContext result = null;
            TapList<MTContext> enclosing1 = context1.largerContexts;
            while (enclosing1 != null) {
                if (TapList.contains(context2.largerContexts, enclosing1.head) && (result == null || result.rank < ((MTContext)enclosing1.head).rank)) {
                    result = (MTContext)enclosing1.head;
                }
                enclosing1 = enclosing1.tail;
            }
            return result;
        }

        public String toString() {
            String largerStr = "";
            TapList<MTContext> inLargerContexts = this.largerContexts;
            while (inLargerContexts != null) {
                largerStr = largerStr + "," + ((MTContext)inLargerContexts.head).rank;
                inLargerContexts = inLargerContexts.tail;
            }
            String knowledgeText = "";
            if (this.knowledge != null) {
                TapList<TapTriplet<Tree, Tree, ZoneInfo>> inKnowledge = this.knowledge;
                while (inKnowledge != null) {
                    knowledgeText = knowledgeText + ILUtils.toString((Tree)((TapTriplet)inKnowledge.head).first) + " =/= " + ILUtils.toString((Tree)((TapTriplet)inKnowledge.head).second);
                    inKnowledge = inKnowledge.tail;
                    if (inKnowledge == null) continue;
                    knowledgeText = knowledgeText + " ; ";
                }
                knowledgeText = " Knowledge: " + knowledgeText;
            }
            String questionsText = "";
            if (this.questions != null) {
                TapList<TapTriplet<Tree, Tree, ZoneInfo>> inQuestions = this.questions;
                while (inQuestions != null) {
                    questionsText = questionsText + "[zone#" + ((ZoneInfo)((TapTriplet)inQuestions.head).third).zoneNb + "]" + ILUtils.toString((Tree)((TapTriplet)inQuestions.head).first) + " =/= " + ILUtils.toString((Tree)((TapTriplet)inQuestions.head).second);
                    inQuestions = inQuestions.tail;
                    if (inQuestions == null) continue;
                    questionsText = questionsText + " ; ";
                }
                questionsText = " Questions: " + questionsText;
            }
            return this.rank + ":" + this.contents + " largerContexts:{" + largerStr + "}" + knowledgeText + questionsText;
        }
    }

    private final class SharedVarUses {
        ZoneInfo zoneInfo;
        TapList<TapPair<Tree, MTContext>> readUses = null;
        TapList<TapPair<Tree, MTContext>> writeUses = null;

        public SharedVarUses(ZoneInfo zi) {
            this.zoneInfo = zi;
        }

        public void collectOneUse(Tree newUse, Block block, boolean justRead) {
            TapList<TapPair<Tree, MTContext>> uses = justRead ? this.readUses : this.writeUses;
            MTContext newContext = (MTContext)MultithreadAnalyzer.this.blockContexts.retrieve(block);
            boolean alreadyPresent = false;
            while (uses != null && !alreadyPresent) {
                if (((Tree)((TapPair)uses.head).first).equalsTree(newUse)) {
                    MTContext oldContext = (MTContext)((TapPair)uses.head).second;
                    if (newContext == oldContext || TapList.contains(newContext.largerContexts, oldContext)) {
                        alreadyPresent = true;
                    } else if (TapList.contains(oldContext.largerContexts, newContext)) {
                        ((TapPair)uses.head).second = newContext;
                        alreadyPresent = true;
                    }
                }
                uses = uses.tail;
            }
            if (!alreadyPresent) {
                if (justRead) {
                    this.readUses = new TapList<TapPair<Tree, MTContext>>(new TapPair<Tree, MTContext>(newUse, newContext), this.readUses);
                } else {
                    this.writeUses = new TapList<TapPair<Tree, MTContext>>(new TapPair<Tree, MTContext>(newUse, newContext), this.writeUses);
                }
            }
        }

        private void attachPrimesTo(Tree expression, ParallelInfoOfBlock parallelRegionInfo) {
            if (expression == null) {
                return;
            }
            switch (expression.opCode()) {
                case 96: {
                    String nameWithoutInstance;
                    if (TapEnv.traceCurAnalysis()) {
                        System.out.println("ATTACHPRIMES TO " + expression + " SHARED " + parallelRegionInfo.sharedVariables);
                    }
                    if ((nameWithoutInstance = (String)expression.getAnnotation("withoutInstance")) == null) {
                        nameWithoutInstance = expression.stringValue();
                    }
                    TapIntList argZonesList = MultithreadAnalyzer.this.curSymbolTable.listOfZonesOfValue(ILUtils.build(96, nameWithoutInstance), null, null);
                    int[] curVectorMap = DataFlowAnalyzer.makeMap3(MultithreadAnalyzer.this.curUnit, MultithreadAnalyzer.this.curBlock, 0);
                    TapIntList argZonesRanks = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(argZonesList, 0, curVectorMap, MultithreadAnalyzer.this.curSymbolTable, null);
                    if (parallelRegionInfo.sharedVariables.intersects(argZonesRanks)) break;
                    expression.setValue(expression.stringValue() + "_prime");
                    break;
                }
                case 75: {
                    this.attachPrimesTo(expression.down(1), parallelRegionInfo);
                    break;
                }
                case 173: {
                    this.attachPrimesTo(expression.down(2), parallelRegionInfo);
                    break;
                }
                case 31: {
                    this.attachPrimesTo(expression.down(3), parallelRegionInfo);
                    break;
                }
                case 4: 
                case 37: {
                    break;
                }
                default: {
                    Tree[] subTrees = expression.children();
                    if (subTrees == null) break;
                    for (int i = subTrees.length - 1; i >= 0; --i) {
                        this.attachPrimesTo(subTrees[i], parallelRegionInfo);
                    }
                }
            }
        }

        public void storeConflictsIntoContexts(ParallelInfoOfBlock parallelRegionInfo, boolean isQuestion) {
            TapList<TapPair<Tree, MTContext>> inWriteUses = this.writeUses;
            while (inWriteUses != null) {
                Tree writeUse = (Tree)((TapPair)inWriteUses.head).first;
                MTContext writeContext = (MTContext)((TapPair)inWriteUses.head).second;
                if (writeUse.opCode() == 9) {
                    writeUse = writeUse.down(2);
                    this.storeConflictWrtOthers(parallelRegionInfo, writeUse, writeContext, inWriteUses, isQuestion);
                    this.storeConflictWrtOthers(parallelRegionInfo, writeUse, writeContext, this.readUses, isQuestion);
                } else if (isQuestion) {
                    this.storeConflictWrtOthers(parallelRegionInfo, null, writeContext, inWriteUses, isQuestion);
                    this.storeConflictWrtOthers(parallelRegionInfo, null, writeContext, this.readUses, isQuestion);
                }
                inWriteUses = inWriteUses.tail;
            }
        }

        private void storeConflictWrtOthers(ParallelInfoOfBlock parallelRegionInfo, Tree oneUse, MTContext oneContext, TapList<TapPair<Tree, MTContext>> otherUses, boolean isQuestion) {
            Tree oneUsePrime = ILUtils.copy(oneUse);
            this.attachPrimesTo(oneUsePrime, parallelRegionInfo);
            while (otherUses != null) {
                Tree otherUse = (Tree)((TapPair)otherUses.head).first;
                MTContext otherContext = (MTContext)((TapPair)otherUses.head).second;
                if (otherUse.opCode() == 9) {
                    otherUse = otherUse.down(2);
                    Tree otherUsePrime = ILUtils.copy(otherUse);
                    this.attachPrimesTo(otherUsePrime, parallelRegionInfo);
                    MTContext.storeConflictPair(oneUsePrime, oneContext, otherUse, otherContext, this.zoneInfo, isQuestion);
                    MTContext.storeConflictPair(oneUse, oneContext, otherUsePrime, otherContext, this.zoneInfo, isQuestion);
                } else if (isQuestion) {
                    MTContext.storeConflictPair(oneUse, oneContext, null, otherContext, this.zoneInfo, true);
                    MTContext.storeConflictPair(null, oneContext, oneUse, otherContext, this.zoneInfo, true);
                }
                otherUses = otherUses.tail;
            }
        }

        public String toString() {
            return "r" + TapList.length(this.readUses) + "w" + TapList.length(this.writeUses);
        }
    }

    private final class ParallelInfoOfBlock {
        private boolean inParallelContext = false;
        public boolean isGPU = false;
        private BoolVector sharedVariables;
        private BoolVector conflictFreeSharedAdjointVariables = null;
        private TapList<Instruction> toParallelLoopHeaders;
        private int nbVars;
        private SharedVarUses[] sharedPrimalUses;
        private SharedVarUses[] sharedAdjointUses;

        private ParallelInfoOfBlock() {
        }

        private ParallelInfoOfBlock copyAndAddClauses(Tree parallelPragma) {
            boolean isOpenMP = ILUtils.isIdent(parallelPragma.down(1), "OMP", true);
            ParallelInfoOfBlock newInfo = new ParallelInfoOfBlock();
            newInfo.toParallelLoopHeaders = this.toParallelLoopHeaders;
            newInfo.inParallelContext = true;
            newInfo.nbVars = this.nbVars;
            if (!this.inParallelContext && isOpenMP) {
                newInfo.sharedVariables = new BoolVector(this.nbVars);
                newInfo.sharedVariables.setTrue();
            } else {
                newInfo.isGPU = true;
                newInfo.sharedVariables = this.sharedVariables.copy();
            }
            if (isOpenMP) {
                Tree[] clauses = parallelPragma.down(2).children();
                block3: for (int i = clauses.length - 1; i >= 0; --i) {
                    Tree clause = clauses[i];
                    switch (clause.opCode()) {
                        case 77: 
                        case 114: 
                        case 157: 
                        case 162: {
                            Tree[] privateIdents = clause.down(1).children();
                            if (privateIdents == null) continue block3;
                            for (int j = privateIdents.length - 1; j >= 0; --j) {
                                VariableDecl variableDecl = MultithreadAnalyzer.this.curSymbolTable.getVariableDecl(ILUtils.getIdentString(privateIdents[j]));
                                TapIntList variableZones = ZoneInfo.listAllZones(variableDecl == null ? null : variableDecl.zones(), true);
                                newInfo.sharedVariables.set(variableZones, false);
                            }
                            continue block3;
                        }
                    }
                }
                TapList additionalPrivates = (TapList)parallelPragma.getAnnotation("futurePrivatesFwd");
                while (additionalPrivates != null) {
                    NewSymbolHolder nsh = (NewSymbolHolder)additionalPrivates.head;
                    if (nsh.newSolvedVariableDecl != null) {
                        TapIntList variableZones = ZoneInfo.listAllZones(nsh.newSolvedVariableDecl.zones(), true);
                        newInfo.sharedVariables.set(variableZones, false);
                    }
                    additionalPrivates = additionalPrivates.tail;
                }
            }
            newInfo.sharedPrimalUses = new SharedVarUses[this.nbVars];
            newInfo.sharedAdjointUses = new SharedVarUses[this.nbVars];
            int[] scopeMap = DataFlowAnalyzer.makeMap3(MultithreadAnalyzer.this.curSymbolTable, 0);
            for (int i = 0; i < this.nbVars; ++i) {
                if (this.sharedVariables.get(i) && this.sharedPrimalUses[i] != null) {
                    newInfo.sharedPrimalUses[i] = this.sharedPrimalUses[i];
                    newInfo.sharedAdjointUses[i] = this.sharedAdjointUses[i];
                    continue;
                }
                if (newInfo.sharedVariables.get(i)) {
                    ZoneInfo zi = DataFlowAnalyzer.vectorIndexToZoneInfo(i, DataFlowAnalyzer.getMapClass(i, scopeMap), 0, scopeMap, MultithreadAnalyzer.this.curSymbolTable);
                    newInfo.sharedPrimalUses[i] = new SharedVarUses(zi);
                    newInfo.sharedAdjointUses[i] = new SharedVarUses(zi);
                    continue;
                }
                newInfo.sharedPrimalUses[i] = null;
                newInfo.sharedAdjointUses[i] = null;
            }
            return newInfo;
        }

        private ParallelInfoOfBlock copyAndAddScope(SymbolTable symbolTable) {
            int i;
            ParallelInfoOfBlock newInfo = new ParallelInfoOfBlock();
            newInfo.toParallelLoopHeaders = this.toParallelLoopHeaders;
            newInfo.inParallelContext = this.inParallelContext;
            newInfo.isGPU = this.isGPU;
            int[] scopeMap = DataFlowAnalyzer.makeMap3(0, 0, symbolTable.declaredZonesNb(0));
            newInfo.nbVars = DataFlowAnalyzer.mapSize(scopeMap);
            newInfo.sharedVariables = this.sharedVariables.copy(this.nbVars, newInfo.nbVars);
            for (i = this.nbVars; i < newInfo.nbVars; ++i) {
                ZoneInfo zi = MultithreadAnalyzer.this.vectorIndexToZoneInfo(i, 3, 0, scopeMap);
                while (zi != null && zi.targetZoneOf != null) {
                    zi = zi.targetZoneOf;
                }
                if (this.inParallelContext && !MultithreadAnalyzer.this.isCudaDeclaredShared(zi)) continue;
                newInfo.sharedVariables.set(i, true);
            }
            newInfo.sharedPrimalUses = new SharedVarUses[newInfo.nbVars];
            newInfo.sharedAdjointUses = new SharedVarUses[newInfo.nbVars];
            for (i = 0; i < newInfo.nbVars; ++i) {
                if (i < this.nbVars) {
                    newInfo.sharedPrimalUses[i] = this.sharedPrimalUses[i];
                    newInfo.sharedAdjointUses[i] = this.sharedAdjointUses[i];
                    continue;
                }
                newInfo.sharedPrimalUses[i] = null;
                newInfo.sharedAdjointUses[i] = null;
            }
            return newInfo;
        }

        public String toString() {
            String primalUsesString = "";
            if (this.sharedPrimalUses == null) {
                primalUsesString = "empty!";
            } else {
                for (int i = 0; i < this.sharedPrimalUses.length; ++i) {
                    primalUsesString = primalUsesString + (this.sharedPrimalUses[i] == null ? "_" : this.sharedPrimalUses[i]) + ", ";
                }
            }
            String adjointUsesString = "";
            if (this.sharedPrimalUses == null) {
                adjointUsesString = "empty!";
            } else {
                for (int i = 0; i < this.sharedPrimalUses.length; ++i) {
                    adjointUsesString = adjointUsesString + (this.sharedPrimalUses[i] == null ? "_" : this.sharedPrimalUses[i]) + ", ";
                }
            }
            return "ParallelInfoOfBlock (//:" + this.inParallelContext + ")(GPU:" + this.isGPU + ") shared:" + this.sharedVariables + " ConflictFree:" + this.conflictFreeSharedAdjointVariables + "\n   primalUses :" + primalUsesString + "\n   adjointUses:" + adjointUsesString;
        }

        static /* synthetic */ SharedVarUses[] access$802(ParallelInfoOfBlock x0, SharedVarUses[] x1) {
            x0.sharedPrimalUses = x1;
            return x1;
        }

        static /* synthetic */ SharedVarUses[] access$902(ParallelInfoOfBlock x0, SharedVarUses[] x1) {
            x0.sharedAdjointUses = x1;
            return x1;
        }
    }

    private static final class ParallelInfoOfUnit {
        public boolean inParallelContext = false;
        public boolean isGPU = false;
        private BoolVector sharedVariables;

        private ParallelInfoOfUnit(Unit unit) {
            int shapeLength = unit.paramElemsNb();
            this.sharedVariables = new BoolVector(shapeLength);
        }

        public String toString() {
            return "//info of U:" + this.inParallelContext + this.isGPU + " shared:" + this.sharedVariables;
        }
    }
}

