/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.analysis;

import fr.inria.tapenade.analysis.DataFlowAnalyzer;
import fr.inria.tapenade.analysis.InOutAnalyzer;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.BlockStorage;
import fr.inria.tapenade.representation.CallArrow;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.HeaderBlock;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.BoolMatrix;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.Tree;

public final class DepsAnalyzer
extends DataFlowAnalyzer {
    private BlockStorage<BoolMatrix> depsIn;
    private BlockStorage<BoolMatrix> depsOut;
    private BlockStorage<BoolMatrix> depsThrough;
    private BoolMatrix tmpDep;
    private int nUDZ = -9;
    private final int[] curBlockMap = DepsAnalyzer.makeMap3(-9, 0, 0);
    private final int[] entryMap = DepsAnalyzer.makeMap3(-9, 0, 0);

    private DepsAnalyzer(CallGraph cg) {
        super(cg, "Plain dependency analysis", TapEnv.traceDeps());
    }

    public static void runAnalysis(CallGraph callGraph, TapList<Unit> rootUnits) {
        TapEnv.setDepsAnalyzer(new DepsAnalyzer(callGraph));
        TapEnv.depsAnalyzer().run(rootUnits);
    }

    private static BoolMatrix buildDefaultExternalDependencies(Unit calledUnit) {
        boolean maybeDiffAndModified;
        int i;
        BoolVector unitN = calledUnit.unitInOutN();
        BoolVector unitR = calledUnit.unitInOutPossiblyR();
        BoolVector unitW = calledUnit.unitInOutPossiblyW();
        if (!calledUnit.hasParamElemsInfo()) {
            return null;
        }
        int n = calledUnit.paramElemsNb();
        BoolMatrix result = new BoolMatrix(n, n);
        result.setIdentity();
        BoolVector depLine = new BoolVector(n);
        int returnIndex = -1;
        for (i = 0; i < n; ++i) {
            if (calledUnit.paramElemZoneInfo(i) == null || !calledUnit.paramElemZoneInfo(i).isResult()) continue;
            returnIndex = i;
        }
        for (i = 0; i < n; ++i) {
            maybeDiffAndModified = calledUnit.paramElemZoneInfo(i) != null ? calledUnit.paramElemZoneInfo((int)i).zoneNb != -1 : false;
            if (!maybeDiffAndModified || i == returnIndex || !unitR.get(i)) continue;
            depLine.set(i, true);
        }
        for (i = 0; i < n; ++i) {
            maybeDiffAndModified = calledUnit.paramElemZoneInfo(i) != null ? calledUnit.paramElemZoneInfo((int)i).zoneNb != -1 : false;
            if (!maybeDiffAndModified || !unitW.get(i)) continue;
            BoolVector depLineCopy = depLine.copy();
            if (i != returnIndex && unitN.get(i)) {
                depLineCopy.set(i, true);
            }
            result.setRow(i, depLineCopy);
        }
        return result;
    }

    protected static BoolMatrix buildDefaultIntrinsicDependencies(Unit calledUnit) {
        BoolMatrix result;
        BoolVector unitR = calledUnit.unitInOutPossiblyR();
        if (calledUnit.hasParamElemsInfo()) {
            int i;
            int n = calledUnit.paramElemsNb();
            result = new BoolMatrix(n, n);
            result.setIdentity();
            BoolVector depLine = new BoolVector(n);
            int returnIndex = -1;
            for (i = 0; i < n; ++i) {
                if (!calledUnit.paramElemZoneInfo(i).isResult()) continue;
                returnIndex = i;
            }
            for (i = 0; i < n; ++i) {
                boolean isInDep;
                boolean bl = isInDep = calledUnit.paramElemZoneInfo((int)i).zoneNb != -1;
                if (!isInDep || i == returnIndex || !unitR.get(i)) continue;
                depLine.set(i, true);
            }
            if (returnIndex != -1) {
                result.setRow(returnIndex, depLine);
            }
        } else {
            result = new BoolMatrix(0, 0);
        }
        return result;
    }

    @Override
    public void setCurUnitEtc(Unit unit) {
        super.setCurUnitEtc(unit);
        if (unit == null || unit.publicSymbolTable() == null) {
            this.nUDZ = -9;
            this.curBlockMap[1] = -9;
            this.curBlockMap[2] = -9;
            this.curBlockMap[3] = -9;
            this.entryMap[1] = -9;
            this.entryMap[2] = -9;
            this.entryMap[3] = -9;
        } else {
            this.nUDZ = unit.publicSymbolTable().declaredZonesNb(0);
            this.curBlockMap[1] = 0;
            this.curBlockMap[2] = 0;
            this.curBlockMap[3] = -9;
            this.entryMap[1] = 0;
            this.entryMap[2] = 0;
            this.entryMap[3] = this.nUDZ;
        }
    }

    @Override
    protected Object initializeCGForUnit() {
        if (this.curUnit.isExternal() || this.curUnit.isVarFunction() || this.curUnit.isInterface() || this.curUnit.isRenamed() || this.curUnit.isModule()) {
            if (this.curUnit.plainDependencies == null) {
                this.curUnit.plainDependencies = DepsAnalyzer.buildDefaultExternalDependencies(this.curUnit);
            }
        } else if (this.curUnit.isIntrinsic()) {
            if (this.curUnit.plainDependencies == null) {
                this.curUnit.plainDependencies = DepsAnalyzer.buildDefaultIntrinsicDependencies(this.curUnit);
            }
        } else {
            this.curUnit.plainDependencies = null;
        }
        return null;
    }

    @Override
    protected void initializeUnit() {
        this.depsIn = new BlockStorage(this.curUnit);
        this.depsOut = new BlockStorage(this.curUnit);
        this.depsThrough = new BlockStorage(this.curUnit);
        if (TapEnv.traceCurAnalysis()) {
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace(" =============  PLAIN DEPS ANALYSIS OF UNIT " + this.curUnit.name() + " : ============");
            this.curSymbolTable = this.curUnit.privateSymbolTable();
            if (this.curSymbolTable == null) {
                this.curSymbolTable = this.curUnit.publicSymbolTable();
            }
            this.nDZ = this.curSymbolTable.declaredZonesNb(0);
            if (this.nDZ > 0) {
                TapEnv.printOnTrace(" D:");
            }
            for (int i = 0; i < this.nDZ; ++i) {
                ZoneInfo zi = this.zoneRkToZoneInfo(i, 3, 0);
                if (zi == null) continue;
                TapEnv.printOnTrace(" [" + i + "]" + zi.description);
            }
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace();
        }
    }

    @Override
    protected void initializeInitBlock() {
        BoolMatrix initIdentity = new BoolMatrix(this.nDZ, this.nDZ);
        initIdentity.setIdentity();
        this.depsOut.store(this.curBlock, initIdentity);
    }

    @Override
    protected void setCurBlockEtc(Block block) {
        super.setCurBlockEtc(block);
        this.curBlockMap[3] = block == null ? -9 : this.nDZ;
    }

    @Override
    protected void initializeFGForBlock() {
        BoolMatrix deps = new BoolMatrix(this.nDZ, this.nDZ);
        deps.setIdentity();
        TapList<Instruction> instructions = this.curBlock.instructions;
        ToBool arrives = new ToBool(true);
        while (instructions != null) {
            this.curInstruction = (Instruction)instructions.head;
            this.depsThroughExpression(deps, this.curInstruction.tree, arrives);
            instructions = instructions.tail;
        }
        if (!arrives.get()) {
            deps = null;
        }
        this.curInstruction = null;
        this.depsThrough.store(this.curBlock, deps);
        if (TapEnv.traceCurAnalysis()) {
            TapEnv.printlnOnTrace(" == Plain Deps through " + this.curBlock + " is:");
            TapEnv.dumpBoolMatrixOnTrace(deps, this.curBlockMap, this.curBlockMap);
            TapEnv.printlnOnTrace();
        }
    }

    @Override
    protected boolean accumulateValuesFromUpstream() {
        this.tmpDep = this.accumulateDepIn(this.curBlock);
        return this.tmpDep != null;
    }

    @Override
    protected boolean compareUpstreamValues() {
        BoolMatrix depOld = this.depsIn.retrieve(this.curBlock);
        if (depOld == null || !this.tmpDep.equalsBoolMatrix(depOld)) {
            this.depsIn.store(this.curBlock, this.tmpDep);
            return true;
        }
        return false;
    }

    @Override
    protected boolean propagateValuesForwardThroughBlock() {
        BoolMatrix depThrough = this.depsThrough.retrieve(this.curBlock);
        if (depThrough != null) {
            this.tmpDep.rows = depThrough.times((BoolMatrix)this.tmpDep).rows;
            return true;
        }
        this.tmpDep = null;
        return false;
    }

    @Override
    protected boolean compareDownstreamValues() {
        BoolMatrix depOld = this.depsOut.retrieve(this.curBlock);
        if (depOld == null || !this.tmpDep.equalsBoolMatrix(depOld)) {
            this.depsOut.store(this.curBlock, this.tmpDep);
            return true;
        }
        return false;
    }

    @Override
    protected boolean compareChannelZoneDataDownstream(int mpZone, Block refBlock) {
        int rowIndex = this.zoneRkToVectorIndex(mpZone, 3, 0, this.curBlockMap);
        BoolMatrix refDep = this.depsOut.retrieve(refBlock);
        BoolVector refRow = refDep.getRow(rowIndex);
        BoolVector newRow = this.tmpDep.getRow(rowIndex);
        if (!(newRow == null || refRow != null && refRow.contains(newRow, this.entryMap[3]))) {
            refDep.overwriteDeps(new TapIntList(rowIndex, null), newRow, false);
            return true;
        }
        return false;
    }

    @Override
    protected boolean terminateUnit() {
        this.tmpDep = this.accumulateDepIn(this.curUnit.exitBlock);
        this.depsIn = null;
        this.depsOut = null;
        this.depsThrough = null;
        if (this.tmpDep == null) {
            return false;
        }
        if (TapEnv.traceCurAnalysis()) {
            TapEnv.printlnOnTrace(" == Plain Deps entering exit Block :");
            TapEnv.dumpBoolMatrixOnTrace(this.tmpDep, this.entryMap, this.entryMap);
            TapEnv.printlnOnTrace();
        }
        for (int i = this.tmpDep.nRows - 1; i >= 0; --i) {
            BoolVector row = this.tmpDep.getRow(i);
            if (row == null) continue;
            row.cumulOr(this.curUnit.zonesUsedInDeclarations);
        }
        BoolMatrix oldPlainDep = this.curUnit.plainDependencies;
        if (oldPlainDep != null && this.tmpDep.equalsBoolMatrix(oldPlainDep)) {
            return false;
        }
        this.curUnit.plainDependencies = this.tmpDep;
        if (TapEnv.traceCurAnalysis()) {
            TapEnv.printlnOnTrace(" == Plain Deps effect stored for unit " + this.curUnit.name() + " is:");
            TapEnv.dumpOnTrace(this.tmpDep);
            TapEnv.printlnOnTrace();
        }
        return true;
    }

    private TapList depsThroughExpression(BoolMatrix deps, Tree expression, ToBool arrives) {
        switch (expression.opCode()) {
            case 14: 
            case 63: 
            case 125: 
            case 150: 
            case 190: {
                boolean totalAccess;
                BoolVector controlDeps;
                TapList<BoolVector> rhsDeps = this.depsThroughExpression(deps, expression.down(2), arrives);
                if (rhsDeps == null) {
                    rhsDeps = new TapList<BoolVector>(new BoolVector(DepsAnalyzer.mapSize(this.curBlockMap)), null);
                }
                if ((controlDeps = this.curUnit.buildControlDepsOf(this.curInstruction, this.curBlock)) != null) {
                    DepsAnalyzer.orInfoPRZVTrees(controlDeps, rhsDeps);
                }
                Tree lhs = expression.down(1);
                this.depsThroughExpression(deps, lhs, arrives);
                ToBool lhsTotal = new ToBool(false);
                TapList<?> writtenZonesTree = this.curSymbolTable.treeOfZonesOfValue(lhs, lhsTotal, this.curInstruction, null);
                boolean bl = totalAccess = this.referenceIsTotal(lhsTotal.get(), writtenZonesTree) && expression.opCode() == 14 && (!this.curUnit.isFortran() || !this.inADeclaration);
                if (TapEnv.traceCurAnalysis()) {
                    TapIntList rksList = this.mapExtendedDeclaredToVectorIndex(ZoneInfo.listAllZones(writtenZonesTree, true), 0, this.curBlockMap);
                    TapEnv.printlnOnTrace("Upon " + ILUtils.toString(expression) + ", " + writtenZonesTree + " (=>rks:" + rksList + ") receives (total:" + totalAccess + ") " + rhsDeps.toString(this.curBlockMap));
                }
                this.setInfoPRZVTreeToExtendedDeclaredZones(deps, this.curBlockMap, writtenZonesTree, rhsDeps, null, totalAccess, 0);
                return rhsDeps;
            }
            case 31: {
                int i;
                Unit calledUnit = DepsAnalyzer.getCalledUnit(expression, this.curSymbolTable);
                BoolMatrix calleeDeps = this.getPlainDeps(calledUnit);
                if (calleeDeps == null) {
                    if (arrives != null) {
                        arrives.set(false);
                    }
                    return null;
                }
                calleeDeps = DepsAnalyzer.filterByValue(calleeDeps, calledUnit);
                CallArrow arrow = CallGraph.getCallArrow(this.curUnit, calledUnit);
                Tree[] actualParams = ILUtils.getArguments(expression).children();
                TapList[] paramDeps = new TapList[1 + actualParams.length];
                for (i = actualParams.length; i > 0; --i) {
                    paramDeps[i] = this.depsThroughExpression(deps, actualParams[i - 1], arrives);
                }
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace();
                    TapEnv.printlnOnTrace(" ---------- Plain Deps Analysis of procedure call " + ILUtils.toString(expression) + " : ----------");
                    TapEnv.printlnOnTrace("    incoming plain deps Upstream:");
                    TapEnv.dumpBoolMatrixOnTrace(deps, this.curBlockMap, this.curBlockMap);
                    for (i = 0; i < paramDeps.length; ++i) {
                        TapEnv.printlnOnTrace("    paramDeps[" + i + (i == 0 ? "=result" : "") + "] = " + paramDeps[i]);
                    }
                    TapEnv.printlnOnTrace();
                }
                BoolVector passesThroughCall = new BoolVector(deps.nRows);
                DepsAnalyzer.propagateCalleeDataToCallSite(calledUnit.unitInOutPossiblyW(), passesThroughCall, null, actualParams, true, expression, this.curInstruction, arrow, this.curBlockMap, 0, null, null, false, false);
                BoolVector callSiteKilled = new BoolVector(deps.nRows);
                DepsAnalyzer.propagateCalleeDataToCallSite(calledUnit.unitInOutCertainlyW(), callSiteKilled, null, actualParams, true, expression, this.curInstruction, arrow, this.curBlockMap, 0, null, null, false, true);
                BoolMatrix depsOnCallee = DepsAnalyzer.propagateCallSiteDataToCallee(deps, paramDeps, null, actualParams, true, expression, this.curInstruction, arrow, this.curBlockMap, 0, false);
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace();
                    TapEnv.printlnOnTrace("    propagated on callee entry:");
                    TapEnv.dumpOnTrace(depsOnCallee);
                    TapEnv.printlnOnTrace();
                    TapEnv.printlnOnTrace("    composed with callee plain Deps:");
                    TapEnv.dumpOnTrace(calleeDeps);
                    TapEnv.printlnOnTrace();
                }
                depsOnCallee = calleeDeps.times(depsOnCallee);
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("    gives on callee exit:");
                    TapEnv.dumpOnTrace(depsOnCallee);
                    TapEnv.printlnOnTrace();
                    TapEnv.printlnOnTrace("    passesThroughCall: " + passesThroughCall);
                    TapEnv.printlnOnTrace("    passesAroundCall:  " + callSiteKilled.not());
                    TapEnv.printlnOnTrace();
                }
                TapList[] paramDataS = DepsAnalyzer.propagateCalleeDataToCallSite(depsOnCallee, deps, null, actualParams, false, expression, this.curInstruction, arrow, this.curBlockMap, 0, passesThroughCall, callSiteKilled.not(), false, null);
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("    outgoing plain deps Downstream:");
                    TapEnv.dumpOnTrace(deps);
                    TapEnv.printlnOnTrace();
                    TapEnv.printlnOnTrace("    and outgoing for result:" + paramDataS[0]);
                }
                return paramDataS[0];
            }
            case 75: {
                TapList valueDependency = this.depsThroughExpression(deps, expression.down(1), arrives);
                Object result = TapList.nth(valueDependency, ILUtils.getFieldRank(expression.down(2)));
                if (result instanceof BoolVector) {
                    return new TapList<Object>(result, null);
                }
                return (TapList)result;
            }
            case 9: {
                Tree[] indexes = expression.down(2).children();
                BoolVector indexesDep = new BoolVector(this.nDZ);
                for (int i = indexes.length - 1; i >= 0; --i) {
                    DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, indexes[i], arrives), indexesDep, false);
                }
                TapList result = this.depsThroughExpression(deps, expression.down(1), arrives);
                DepsAnalyzer.orInfoPRZVTrees(indexesDep, result);
                return result;
            }
            case 11: 
            case 26: 
            case 153: {
                return null;
            }
            case 96: {
                TapList<?> zones = this.curSymbolTable.treeOfZonesOfValue(expression, null, this.curInstruction, null);
                if (zones == null) {
                    return null;
                }
                zones = TapList.copyTree(zones);
                this.includePointedElementsInTree(zones, null, null, true, false, true);
                return this.buildInfoPRZVTreeOfExtendedDeclared(zones, deps, 0, this.curBlockMap);
            }
            case 151: {
                BoolVector offsetDep = new BoolVector(this.nDZ);
                DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, expression.down(2), arrives), offsetDep, false);
                DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, expression.down(1), arrives), offsetDep, false);
                TapList<?> zones = this.curSymbolTable.treeOfZonesOfValue(expression, null, this.curInstruction, null);
                if (zones == null) {
                    return null;
                }
                zones = TapList.copyTree(zones);
                this.includePointedElementsInTree(zones, null, null, true, false, true);
                TapList result = this.buildInfoPRZVTreeOfExtendedDeclared(zones, deps, 0, this.curBlockMap);
                DepsAnalyzer.orInfoPRZVTrees(offsetDep, result);
                return result;
            }
            case 3: 
            case 62: 
            case 126: 
            case 133: 
            case 155: 
            case 182: {
                return TapList.cumulWithOper(this.depsThroughExpression(deps, expression.down(1), arrives), this.depsThroughExpression(deps, expression.down(2), arrives), 91);
            }
            case 124: 
            case 139: 
            case 176: {
                return this.depsThroughExpression(deps, expression.down(1), arrives);
            }
            case 32: 
            case 134: 
            case 194: {
                return this.depsThroughExpression(deps, expression.down(2), arrives);
            }
            case 109: {
                int i;
                TapIntList writtenZonesList;
                TapList<?> writtenZonesTree;
                int zoneIO = this.curCallGraph.zoneNbOfAllIOStreams;
                String ioAction = ILUtils.getIdentString(expression.down(1));
                boolean writesInVars = ioAction.equals("read") || ioAction.equals("accept") || ioAction.equals("decode");
                BoolVector usedZones = this.curUnit.buildControlDepsOf(this.curInstruction, this.curBlock);
                if (usedZones == null) {
                    usedZones = new BoolVector(DepsAnalyzer.mapSize(this.curBlockMap));
                }
                usedZones.setDeclared(zoneIO, this.curBlockMap, true);
                BoolVector writtenZones = new BoolVector(DepsAnalyzer.mapSize(this.curBlockMap));
                writtenZones.setDeclared(zoneIO, this.curBlockMap, true);
                BoolVector totalWrittenZones = new BoolVector(DepsAnalyzer.mapSize(this.curBlockMap));
                ToBool total = new ToBool(false);
                ToBool totally = new ToBool(false);
                ToBool written = new ToBool(false);
                Tree[] ioArgs = expression.down(3).children();
                for (int i2 = ioArgs.length - 1; i2 >= 0; --i2) {
                    if (writesInVars) {
                        writtenZonesTree = this.curSymbolTable.treeOfZonesOfValue(ioArgs[i2], total, this.curInstruction, null);
                        writtenZonesList = ZoneInfo.listAllZones(writtenZonesTree, true);
                        writtenZones.setDeclared(writtenZonesList, this.curBlockMap, true);
                        if (!total.get()) continue;
                        totalWrittenZones.setDeclared(writtenZonesList, this.curBlockMap, true);
                        continue;
                    }
                    DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, ioArgs[i2], arrives), usedZones, false);
                }
                Tree[] ioSpecs = expression.down(2).children();
                for (i = ioSpecs.length - 1; i >= 0; --i) {
                    Tree ioSpecTree = InOutAnalyzer.getIOeffectOfIOspec(ioSpecs[i], i, ioAction, written, totally, this.curSymbolTable);
                    if (written.get()) {
                        writtenZonesTree = this.curSymbolTable.treeOfZonesOfValue(ioSpecTree, total, this.curInstruction, null);
                        writtenZonesList = ZoneInfo.listAllZones(writtenZonesTree, true);
                        writtenZones.setDeclared(writtenZonesList, this.curBlockMap, true);
                        if (!total.get() || !totally.get()) continue;
                        totalWrittenZones.setDeclared(writtenZonesList, this.curBlockMap, true);
                        continue;
                    }
                    DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, ioSpecTree, arrives), usedZones, false);
                }
                for (i = this.nDZ - 1; i >= 0; --i) {
                    if (!writtenZones.get(i)) continue;
                    if (totalWrittenZones.get(i)) {
                        deps.setExplicitZeroRow(i);
                    }
                    if (deps.isImplicitIdentityRow(i)) {
                        deps.setExplicitIdentityRow(i);
                    }
                    deps.getRow(i).cumulOr(usedZones);
                }
                return null;
            }
            case 6: 
            case 10: 
            case 12: 
            case 18: 
            case 22: 
            case 24: 
            case 42: 
            case 43: 
            case 47: 
            case 52: 
            case 68: 
            case 71: 
            case 83: 
            case 92: 
            case 95: 
            case 115: 
            case 116: 
            case 122: 
            case 137: 
            case 140: 
            case 143: 
            case 169: 
            case 207: {
                Tree[] exprs = expression.children();
                BoolVector resultDep = new BoolVector(this.nDZ);
                for (int i = exprs.length - 1; i >= 0; --i) {
                    DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, exprs[i], arrives), resultDep, false);
                }
                return new TapList<BoolVector>(resultDep, null);
            }
            case 98: 
            case 184: 
            case 189: 
            case 196: 
            case 206: {
                BoolVector conditionDep = new BoolVector(this.nDZ);
                DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, expression.down(1), arrives), conditionDep, false);
                int testZone = this.curUnit.testZoneOfControllerBlock(this.curBlock);
                if (testZone >= 0) {
                    deps.setRow(testZone, conditionDep);
                }
                return null;
            }
            case 5: {
                return this.depsThroughExpression(deps, expression.down(2), arrives);
            }
            case 79: {
                this.depsThroughExpression(deps, expression.down(1), arrives);
                this.depsThroughExpression(deps, expression.down(2), arrives);
                this.depsThroughExpression(deps, expression.down(3), arrives);
                return null;
            }
            case 99: {
                return TapList.cumulWithOper(TapList.copyTree(this.depsThroughExpression(deps, expression.down(2), arrives)), this.depsThroughExpression(deps, expression.down(3), arrives), 91);
            }
            case 205: {
                BoolVector conditionDep = new BoolVector(this.nDZ);
                DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, expression.down(1), arrives), conditionDep, false);
                int testZone = this.curUnit.testZoneOfControllerWhere(this.curInstruction);
                deps.setRow(testZone, conditionDep);
                return null;
            }
            case 186: {
                this.depsThroughExpression(deps, expression.down(2), arrives);
                return null;
            }
            case 121: {
                this.depsThroughExpression(deps, expression.down(3), arrives);
                return null;
            }
            case 80: {
                this.depsThroughExpression(deps, expression.down(1), arrives);
                this.depsThroughExpression(deps, expression.down(2), arrives);
                return null;
            }
            case 81: {
                this.depsThroughExpression(deps, expression.down(1), arrives);
                this.depsThroughExpression(deps, expression.down(2), arrives);
                return null;
            }
            case 64: 
            case 82: {
                BoolVector boundsDep = new BoolVector(DepsAnalyzer.mapSize(this.curBlockMap));
                TapIntList indexZones = this.curSymbolTable.listOfZonesOfValue(expression.down(1), null, this.curInstruction);
                DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, expression.down(2), arrives), boundsDep, false);
                DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, expression.down(3), arrives), boundsDep, false);
                DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, expression.down(4), arrives), boundsDep, false);
                TapIntList iter = indexZones;
                while (iter != null) {
                    boundsDep.setDeclared(iter.head, this.curBlockMap, true);
                    iter = iter.tail;
                }
                deps.overwriteDeps(indexZones, boundsDep, true);
                int testZone = this.curUnit.testZoneOfControllerBlock(this.curBlock);
                if (testZone >= 0) {
                    deps.setRow(testZone, boundsDep);
                }
                return null;
            }
            case 110: {
                BoolVector resultDep = new BoolVector(this.nDZ);
                TapIntList indexZones = this.curSymbolTable.listOfZonesOfValue(expression.down(2).down(1), null, this.curInstruction);
                DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, expression.down(2).down(2), arrives), resultDep, false);
                DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, expression.down(2).down(3), arrives), resultDep, false);
                DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, expression.down(2).down(4), arrives), resultDep, false);
                deps.overwriteDeps(indexZones, resultDep, true);
                DepsAnalyzer.cumulOr(this.depsThroughExpression(deps, expression.down(1), arrives), resultDep, false);
                return new TapList<BoolVector>(resultDep, null);
            }
            case 179: {
                if (arrives != null) {
                    arrives.set(false);
                }
                return null;
            }
            case 168: {
                TapList result = null;
                this.depsThroughExpression(deps, expression.down(2), arrives);
                if (!ILUtils.isNullOrNone(expression.down(1))) {
                    String returnVarName = this.curUnit.otherReturnVar() == null ? this.curUnit.name() : this.curUnit.otherReturnVar().symbol;
                    Tree assignTree = ILUtils.turnReturnIntoAssign(expression, returnVarName);
                    result = this.depsThroughExpression(deps, assignTree, arrives);
                    ILUtils.resetReturnFromAssign(expression, assignTree);
                }
                return result;
            }
            case 144: 
            case 145: {
                return null;
            }
            case 36: 
            case 46: 
            case 56: 
            case 89: {
                return null;
            }
            case 2: 
            case 4: 
            case 13: 
            case 15: 
            case 20: 
            case 28: 
            case 29: 
            case 30: 
            case 35: 
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 49: 
            case 51: 
            case 69: 
            case 74: 
            case 78: 
            case 94: 
            case 101: 
            case 103: 
            case 104: 
            case 106: 
            case 108: 
            case 111: 
            case 118: 
            case 129: 
            case 135: 
            case 138: 
            case 154: 
            case 160: 
            case 171: 
            case 177: 
            case 180: 
            case 181: 
            case 192: 
            case 197: 
            case 202: 
            case 204: {
                return null;
            }
            case 199: {
                Tree[] decls = expression.down(3).children();
                this.inADeclaration = true;
                for (int i = decls.length - 1; i >= 0; --i) {
                    if (decls[i].opCode() != 14) continue;
                    ILUtils.turnAssignFromInitDecl(decls[i]);
                    this.depsThroughExpression(deps, decls[i], arrives);
                    ILUtils.resetAssignFromInitDecl(decls[i]);
                }
                this.inADeclaration = false;
                return null;
            }
        }
        TapEnv.toolWarning(-1, "(Compute plain dependencies) Unexpected operator : " + expression.opName());
        return null;
    }

    private BoolMatrix accumulateDepIn(Block block) {
        BoolMatrix depIn = null;
        TapList<FGArrow> arrows = block.backFlow();
        while (arrows != null) {
            Block origin = ((FGArrow)arrows.head).origin;
            BoolMatrix depIncoming = this.depsOut.retrieve(origin);
            if (depIncoming != null) {
                if (depIn == null) {
                    depIn = new BoolMatrix(this.nDZ, this.nUDZ);
                }
                BoolVector saveDep = null;
                int rowIdx = -1;
                SymbolTable origSymbolTable = origin.symbolTable;
                if (block.instructions != null) {
                    TapIntList listOfZones;
                    boolean doCaseAndNotInACycle;
                    Tree expression = TapList.last(block.instructions).tree;
                    boolean bl = doCaseAndNotInACycle = block instanceof HeaderBlock && expression.opCode() == 121 && expression.down(3).opCode() == 64 && !((FGArrow)arrows.head).inACycle;
                    if (doCaseAndNotInACycle && (listOfZones = origSymbolTable.listOfZonesOfValue(expression.down(3).down(1), null, this.curInstruction)) != null) {
                        rowIdx = this.extendedDeclaredToVectorIndex(listOfZones.head, 0, DepsAnalyzer.makeMap3(0, 0, origSymbolTable.declaredZonesNb(0)));
                        saveDep = depIncoming.getRow(rowIdx);
                        if (saveDep != null) {
                            saveDep = saveDep.copy();
                        }
                        depIncoming.setExplicitZeroRow(rowIdx);
                    }
                }
                SymbolTable commonSymbolTable = block.symbolTable.getCommonRoot(origSymbolTable);
                depIn.cumulOr(depIncoming, true, commonSymbolTable.declaredZonesNb(0));
                if (rowIdx != -1) {
                    depIncoming.setRow(rowIdx, saveDep);
                }
            }
            arrows = arrows.tail;
        }
        return depIn;
    }

    private BoolMatrix getPlainDeps(Unit calledUnit) {
        BoolMatrix unitDependency;
        if (calledUnit == null) {
            return null;
        }
        if (calledUnit.isIntrinsic()) {
            unitDependency = calledUnit.plainDependencies;
            if (unitDependency == null) {
                calledUnit.plainDependencies = unitDependency = DepsAnalyzer.buildDefaultIntrinsicDependencies(calledUnit);
            }
        } else if (calledUnit.isVarFunction()) {
            unitDependency = DepsAnalyzer.buildDefaultExternalDependencies(calledUnit);
        } else {
            unitDependency = calledUnit.plainDependencies;
            if (unitDependency == null && calledUnit.isExternal()) {
                calledUnit.plainDependencies = unitDependency = DepsAnalyzer.buildDefaultExternalDependencies(calledUnit);
            }
        }
        return unitDependency;
    }
}

