/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.analysis;

import fr.inria.tapenade.analysis.ActivityPattern;
import fr.inria.tapenade.analysis.PointerAnalyzer;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.BlockStorage;
import fr.inria.tapenade.representation.CallArrow;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.EntryBlock;
import fr.inria.tapenade.representation.ExitBlock;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.HeaderBlock;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.LoopBlock;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.PublicInfo;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.UnitStorage;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.BoolMatrix;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.Chrono;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.Tree;

public class DataFlowAnalyzer {
    protected static final int READ = -1;
    protected static final int WRITE = 1;
    protected static final int NOACT = 0;
    private static final String[] mapClassNames = new String[]{"zero", "SE", "NP/K", "D", "FP"};
    protected final CallGraph curCallGraph;
    private final Chrono unitAnalysisTimer = new Chrono();
    protected Unit curUnit;
    protected ActivityPattern curActivity;
    protected Unit curCalledUnit;
    protected int nDZ = -9;
    protected Block curBlock;
    protected FGArrow curArrow;
    protected Instruction curInstruction;
    protected SymbolTable curSymbolTable;
    protected String curAnalysisName;
    protected TapList<Unit> tracedUnits;
    protected boolean inADeclaration;
    protected UnitStorage topDownContexts;
    protected BoolVector uniqueAccessZones;
    protected boolean conservativeValue = true;
    private int sweeps;
    public boolean filterByValue = true;

    protected Object topDownContext(Unit unit) {
        return this.topDownContexts.retrieve(unit);
    }

    protected void setTopDownContext(Unit unit, Object context) {
        this.topDownContexts.store(unit, context);
    }

    protected DataFlowAnalyzer(CallGraph callGraph, String analysisName, TapList<String> traceAnalysisUnitNames) {
        this.curCallGraph = callGraph;
        this.curAnalysisName = analysisName;
        this.tracedUnits = callGraph.getUnits(traceAnalysisUnitNames);
    }

    private static boolean isCGCycleHead(Unit unit) {
        TapList<CallArrow> arrows = unit.callers();
        boolean isCGCycleHead = false;
        while (!isCGCycleHead && arrows != null) {
            Unit caller = ((CallArrow)arrows.head).origin;
            isCGCycleHead = caller.rank() >= 0 && caller.rank() >= unit.rank();
            arrows = arrows.tail;
        }
        return isCGCycleHead;
    }

    private static void markCallersOutOfDate(Unit unit) {
        TapList<CallArrow> arrows = unit.callers();
        while (arrows != null) {
            Unit caller = ((CallArrow)arrows.head).origin;
            caller.analysisIsOutOfDateUp = true;
            arrows = arrows.tail;
        }
    }

    private static boolean isCGCycleTail(Unit unit) {
        TapList<CallArrow> arrows = unit.callees();
        boolean isCGCycleTail = false;
        while (!isCGCycleTail && arrows != null) {
            Unit callee = ((CallArrow)arrows.head).destination;
            isCGCycleTail = callee.rank() >= 0 && callee.rank() <= unit.rank();
            arrows = arrows.tail;
        }
        return isCGCycleTail;
    }

    private static void markCalleesOutOfDate(Unit unit) {
        TapList<CallArrow> arrows = unit.callees();
        while (arrows != null) {
            Unit callee = ((CallArrow)arrows.head).destination;
            callee.analysisIsOutOfDateDown = true;
            arrows = arrows.tail;
        }
    }

    private static void markFlowOutOfDate(TapList<FGArrow> arrows, TapList<FGArrow> excludedExitArrows) {
        while (arrows != null) {
            if (!TapList.contains(excludedExitArrows, arrows.head)) {
                ((FGArrow)arrows.head).destination.analysisIsOutOfDate = true;
            }
            arrows = arrows.tail;
        }
    }

    private static void markBackFlowOutOfDate(TapList<FGArrow> arrows, TapList<FGArrow> excludedEntryArrows) {
        while (arrows != null) {
            if (!TapList.contains(excludedEntryArrows, arrows.head)) {
                ((FGArrow)arrows.head).origin.analysisIsOutOfDate = true;
            }
            arrows = arrows.tail;
        }
    }

    public static Unit getCalledUnit(Tree expression, SymbolTable symbolTable) {
        WrapperTypeSpec[] types;
        String unitName;
        Object annot = expression.getAnnotation("callArrow");
        if (annot != null) {
            return ((CallArrow)annot).destination;
        }
        FunctionDecl functionDecl = null;
        if (symbolTable != null && (unitName = ILUtils.getCallFunctionNameString(expression)) != null && (functionDecl = symbolTable.getTypedFunctionDecl(unitName, null, types = symbolTable.typesOf(ILUtils.getArguments(expression)), false, expression)) == null) {
            TapList<FunctionDecl> functionDecls = symbolTable.getFunctionDecl(unitName, null, null, false);
            functionDecl = functionDecls == null ? null : (FunctionDecl)functionDecls.head;
        }
        return functionDecl == null ? null : functionDecl.unit();
    }

    public static BoolVector propagateUnitDataOutside(BoolVector privateData, int whichKind, int[] vectorMap, boolean valuesCarryInfo, Unit unit) {
        BoolVector result = new BoolVector(unit.translator.length);
        BoolVector constantZones = unit.entryBlock().constantZones;
        if (privateData != null) {
            for (int i = unit.translator.length - 1; i >= 0; --i) {
                TapIntList indices;
                PublicInfo publicInfo = unit.translator[i];
                if (!valuesCarryInfo && publicInfo.kind() == 7 && publicInfo.zone.targetZoneOf == null && !constantZones.get(publicInfo.zone.zoneNb) || !privateData.intersects(indices = DataFlowAnalyzer.mapZoneRkToVectorIndex(publicInfo.ranks(whichKind), 3, whichKind, vectorMap, null))) continue;
                result.set(i, true);
            }
        }
        return result;
    }

    public static BoolVector propagateUnitDataInside(BoolVector publicData, int whichKind, int[] vectorMap, Unit unit) {
        BoolVector result = new BoolVector(DataFlowAnalyzer.mapSize(vectorMap));
        for (int i = unit.translator.length - 1; i >= 0; --i) {
            if (!publicData.get(i)) continue;
            PublicInfo publicInfo = unit.translator[i];
            result.set(DataFlowAnalyzer.mapZoneRkToVectorIndex(publicInfo.ranks(whichKind), 3, whichKind, vectorMap, null), true);
        }
        return result;
    }

    public static BoolVector convertPublicInfoFromUnitToUnit(BoolVector dataOnFromUnit, Unit fromUnit, Unit toUnit) {
        if (fromUnit.translator == null || toUnit.translator == null) {
            return dataOnFromUnit.copy();
        }
        BoolVector dataOnToUnit = new BoolVector(toUnit.translator.length);
        for (int i = fromUnit.translator.length - 1; i >= 0; --i) {
            if (!dataOnFromUnit.get(i)) continue;
            ZoneInfo fromZone = fromUnit.paramElemZoneInfo(i);
            for (int j = toUnit.translator.length - 1; j >= 0; --j) {
                if (!DataFlowAnalyzer.matchingPublicInfos(fromZone, toUnit.paramElemZoneInfo(j))) continue;
                dataOnToUnit.set(j, true);
            }
        }
        return dataOnToUnit;
    }

    private static boolean matchingPublicInfos(ZoneInfo info1, ZoneInfo info2) {
        if (info1 == null || info2 == null || info1.kind() != info2.kind()) {
            return false;
        }
        switch (info1.kind()) {
            case 7: {
                return info1.index == info2.index && !ILUtils.disjointPath(info1.accessTree, info2.accessTree);
            }
            case 10: {
                return !ILUtils.disjointPath(info1.accessTree, info2.accessTree);
            }
            case 12: 
            case 13: {
                if (info1.isCommon()) {
                    return info1.commonName.equals(info2.commonName) && (info1.containsOffset(info2.startOffset) || info2.containsOffset(info1.startOffset));
                }
                return info1 == info2;
            }
        }
        TapEnv.toolError("(matchingPublicInfos) failing to compare " + info1 + " and " + info2);
        return false;
    }

    public static TapList[] propagateEntryDataBwdToCaller(BoolVector publicEntryData, BoolVector privateDataInTransit, int[] vectorMap, Instruction instruction, CallArrow arrow, Tree[] actualParamTreeS, int whichKind) {
        return DataFlowAnalyzer.propagateDataToCaller(publicEntryData, null, null, actualParamTreeS.length, privateDataInTransit, vectorMap, null, instruction, arrow, true, true, whichKind);
    }

    public static TapList<?> propagateExitDataFwdToCaller(BoolVector publicExitData, BoolVector privateDataInTransit, int[] vectorMap, Instruction instruction, CallArrow arrow, Tree[] actualParamTreeS, int whichKind) {
        TapList<Object> resultData = new TapList<Object>(null, null);
        DataFlowAnalyzer.propagateDataToCaller(publicExitData, null, actualParamTreeS, actualParamTreeS.length, privateDataInTransit, vectorMap, resultData, instruction, arrow, true, false, whichKind);
        return resultData;
    }

    public static TapList[] propagateDataToCallee(BoolVector privateData, int[] vectorMap, Tree actualResultTree, Tree[] actualParamTreeS, TapList actualResultData, TapIntList tmpZones, Instruction instruction, CallArrow arrow, boolean valuesCarryInfo, int whichKind) {
        TapIntList totalAccessZones;
        TapList<?> actualParamZonesTree;
        int nbParams = actualParamTreeS.length;
        SymbolTable symbolTable = instruction.block.symbolTable;
        ToBool total = new ToBool();
        BoolVector transitOutsideParams = new BoolVector(DataFlowAnalyzer.mapSize(vectorMap));
        transitOutsideParams.setTrue();
        TapList[] callerParamDataS = new TapList[nbParams];
        for (int i = nbParams - 1; i >= 0; --i) {
            actualParamZonesTree = symbolTable.treeOfZonesOfValue(actualParamTreeS[i], total, instruction, null);
            if (actualParamZonesTree != null) {
                actualParamZonesTree = TapList.copyTree(actualParamZonesTree);
                DataFlowAnalyzer.includePointedElementsInTree(actualParamZonesTree, total, null, true, symbolTable, instruction, arrow.destination, false, true);
                if (arrow.takesArgumentByValue(i + 1) && !valuesCarryInfo) {
                    DataFlowAnalyzer.removeInfoOnTopLevel(actualParamZonesTree);
                }
                if (total.get()) {
                    totalAccessZones = ZoneInfo.listAllZones(actualParamZonesTree, true);
                    DataFlowAnalyzer.setExtendedDeclared(transitOutsideParams, vectorMap, whichKind, totalAccessZones, false, symbolTable);
                }
            }
            callerParamDataS[i] = DataFlowAnalyzer.buildInfoBoolTreeOfDeclaredZones(actualParamZonesTree, privateData, vectorMap, tmpZones, whichKind, symbolTable);
        }
        if (actualResultTree != null && actualResultData != null) {
            TapList<?> resultData;
            actualParamZonesTree = symbolTable.treeOfZonesOfValue(actualResultTree, total, instruction, null);
            if (actualParamZonesTree != null) {
                actualParamZonesTree = TapList.copyTree(actualParamZonesTree);
                DataFlowAnalyzer.includePointedElementsInTree(actualParamZonesTree, total, null, true, symbolTable, instruction, arrow.destination, false, true);
                if (total.get()) {
                    totalAccessZones = ZoneInfo.listAllZones(actualParamZonesTree, true);
                    DataFlowAnalyzer.setExtendedDeclared(transitOutsideParams, vectorMap, whichKind, totalAccessZones, false, symbolTable);
                }
            }
            actualResultData.head = (resultData = DataFlowAnalyzer.buildInfoBoolTreeOfDeclaredZones(actualParamZonesTree, privateData, vectorMap, tmpZones, whichKind, symbolTable)) != null ? resultData.head : Boolean.FALSE;
        }
        privateData.cumulAnd(transitOutsideParams);
        return callerParamDataS;
    }

    public static TapList[] propagateDataToCaller(BoolVector publicData, Tree actualResultTree, Tree[] actualParamTreeS, int nbParams, BoolVector privateData, int[] vectorMap, TapList resultData, Instruction instruction, CallArrow arrow, boolean cumulOr, boolean valuesCarryInfo, int whichKind) {
        int i;
        boolean traceHere = TapEnv.traceThisCallArrow(arrow);
        if (traceHere) {
            TapEnv.printlnOnTrace("  propagateDataToCaller publicData :" + publicData);
            TapEnv.printlnOnTrace("    into privateData:" + privateData);
            TapEnv.printlnOnTrace("    Instruction:" + instruction + " CallArrow:" + arrow);
        }
        SymbolTable symbolTable = instruction.block.symbolTable;
        TapList[] callerParamDataS = null;
        TapList[] actualParamZonesTreeS = null;
        BoolVector publicZonesPossiblyRorW = arrow.destination.getTmpALLKINDPossiblyRoW();
        if (actualParamTreeS == null) {
            callerParamDataS = new TapList[nbParams];
            for (int i2 = nbParams - 1; i2 >= 0; --i2) {
                callerParamDataS[i2] = new TapList<Boolean>(Boolean.FALSE, null);
            }
        } else {
            nbParams = actualParamTreeS.length;
            actualParamZonesTreeS = new TapList[nbParams];
            ToBool total = new ToBool();
            for (int i3 = nbParams - 1; i3 >= 0; --i3) {
                TapList<?> actualParamZonesTree = symbolTable.treeOfZonesOfValue(actualParamTreeS[i3], total, instruction, null);
                if (actualParamZonesTree != null) {
                    actualParamZonesTree = TapList.copyTree(actualParamZonesTree);
                    DataFlowAnalyzer.includePointedElementsInTree(actualParamZonesTree, total, null, true, symbolTable, instruction, arrow.destination, false, true);
                    if (arrow.takesArgumentByValue(i3 + 1) && !valuesCarryInfo) {
                        DataFlowAnalyzer.removeInfoOnTopLevel(actualParamZonesTree);
                    }
                }
                actualParamZonesTreeS[i3] = actualParamZonesTree;
                if (!traceHere) continue;
                TapEnv.printlnOnTrace("actualParamZonesTreeS[" + i3 + "] == " + actualParamZonesTreeS[i3] + " for " + actualParamTreeS[i3]);
            }
        }
        TapList<?> actualResultZonesTree = null;
        if (actualResultTree == null) {
            if (resultData == null) {
                resultData = new TapList<Object>(null, null);
            }
            resultData.head = Boolean.FALSE;
            resultData.tail = null;
        } else {
            actualResultZonesTree = symbolTable.treeOfZonesOfValue(actualResultTree, null, instruction, null);
        }
        for (i = arrow.translator.length - 1; i >= 0; --i) {
            PublicInfo publicZoneInfo = arrow.translator[i];
            if (traceHere) {
                TapEnv.printlnOnTrace(" ARROW.TRANSLATOR " + i + " IS " + publicZoneInfo);
            }
            if (publicZoneInfo == null) continue;
            boolean publicZoneData = publicData.get(i);
            TapIntList callerAccessedIndices = null;
            switch (publicZoneInfo.kind()) {
                case 10: {
                    TapList<?> toLocation;
                    if (actualResultTree == null) {
                        toLocation = TapList.getSetFieldLocation(resultData, publicZoneInfo.zone.accessTree, true);
                        if (publicZoneData) {
                            toLocation.head = Boolean.TRUE;
                            break;
                        }
                        if (toLocation.head != null) break;
                        toLocation.head = Boolean.FALSE;
                        break;
                    }
                    if (privateData == null) break;
                    callerAccessedIndices = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(ZoneInfo.listAllZones(TapList.getSetFieldLocation(actualResultZonesTree, publicZoneInfo.zone.accessTree, false), false), whichKind, vectorMap, symbolTable, arrow.destination);
                    break;
                }
                case 7: {
                    TapList<?> toLocation;
                    if (publicZoneInfo.getParamRank() == 0) {
                        if (privateData == null) break;
                        callerAccessedIndices = DataFlowAnalyzer.getIndicesAccessedInCaller(publicZoneInfo.ranks(0), 3, whichKind, vectorMap, instruction, arrow.destination);
                        break;
                    }
                    if (publicZoneInfo.getParamRank() > nbParams) break;
                    if (actualParamTreeS == null) {
                        if (traceHere) {
                            TapEnv.printlnOnTrace(" getSetFieldLocation of accessTree of " + publicZoneInfo.zone + " INSIDE " + callerParamDataS[publicZoneInfo.getParamRank() - 1]);
                        }
                        toLocation = TapList.getSetFieldLocation(callerParamDataS[publicZoneInfo.getParamRank() - 1], publicZoneInfo.zone.accessTree, true);
                        if (traceHere) {
                            TapEnv.printlnOnTrace("   -> " + toLocation + " INSIDE " + callerParamDataS[publicZoneInfo.getParamRank() - 1] + " TO BE SET TO " + publicZoneData);
                        }
                        if (!publicZonesPossiblyRorW.get(i)) break;
                        if (publicZoneData) {
                            toLocation.head = Boolean.TRUE;
                            break;
                        }
                        if (toLocation.head != null) break;
                        toLocation.head = Boolean.FALSE;
                        break;
                    }
                    if (privateData == null) break;
                    if (traceHere) {
                        TapEnv.printlnOnTrace("publicZoneInfo:" + publicZoneInfo + " public data for this zone is:" + publicZoneData);
                        TapEnv.printlnOnTrace(" privateData:" + privateData);
                        TapEnv.printlnOnTrace(" zone:" + publicZoneInfo.zone + " coversFurther:" + publicZoneInfo.coversFurther);
                        TapEnv.printlnOnTrace(" accessTree:" + publicZoneInfo.zone.accessTree);
                    }
                    callerAccessedIndices = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(ZoneInfo.listAllZones(TapList.getSetFieldLocation(actualParamZonesTreeS[publicZoneInfo.getParamRank() - 1], publicZoneInfo.zone.accessTree, false), publicZoneInfo.coversFurther), whichKind, vectorMap, symbolTable, arrow.destination);
                    if (!traceHere) break;
                    TapEnv.printlnOnTrace("callerAccessedIndices:" + callerAccessedIndices);
                    break;
                }
                default: {
                    if (privateData == null) break;
                    callerAccessedIndices = DataFlowAnalyzer.getIndicesAccessedInCaller(publicZoneInfo.ranks(0), 3, whichKind, vectorMap, instruction, arrow.destination);
                    if (!traceHere) break;
                    TapEnv.printlnOnTrace("   getIndicesAccessedInCaller " + publicZoneInfo + "  ===> " + callerAccessedIndices);
                }
            }
            if (privateData == null) continue;
            while (callerAccessedIndices != null) {
                if (cumulOr) {
                    if (publicZoneData) {
                        privateData.set(callerAccessedIndices.head, true);
                    }
                } else if (!publicZoneData) {
                    privateData.set(callerAccessedIndices.head, false);
                }
                callerAccessedIndices = callerAccessedIndices.tail;
            }
        }
        if (!valuesCarryInfo && callerParamDataS != null) {
            for (i = 0; i < callerParamDataS.length; ++i) {
                if (!arrow.takesArgumentByValue(i + 1)) continue;
                DataFlowAnalyzer.removeInfoOnTopLevel(callerParamDataS[i]);
            }
        }
        if (traceHere && callerParamDataS != null) {
            TapEnv.printlnOnTrace("    final privateData:" + privateData);
            for (i = 0; i < callerParamDataS.length; ++i) {
                TapEnv.printlnOnTrace("   callerParamDataS[" + i + "] = " + callerParamDataS[i]);
            }
        }
        return callerParamDataS;
    }

    public static TapList[] addZeroIndexTEMPORARY(TapList[] array) {
        TapList[] result = new TapList[array.length + 1];
        result[0] = null;
        for (int i = array.length - 1; i >= 0; --i) {
            result[i + 1] = array[i];
        }
        return result;
    }

    public static TapList[] removeZeroIndexTEMPORARY(TapList[] array) {
        TapList[] result = new TapList[array.length - 1];
        for (int i = array.length - 1; i > 0; --i) {
            result[i - 1] = array[i];
        }
        return result;
    }

    public static BoolVector propagateCallSiteDataToCallee(BoolVector callSiteData, TapList[] callSiteParamDataS, Tree actualResultTree, Tree[] actualParamTreeS, boolean onEntry, Tree callTree, Instruction callInstruction, CallArrow callArrow, int[] callSiteMap, int whichKind, boolean propagateEvenByValue) {
        boolean paramZoneAnnotationAbsent;
        boolean traceHere;
        boolean bl = traceHere = TapEnv.traceCurAnalysis() && TapEnv.traceThisCallArrow(callArrow);
        if (traceHere) {
            TapEnv.printlnOnTrace("------------------- start propagateCallSiteDataToCallee (BoolVector) -----------");
            TapEnv.printlnOnTrace("  propagateCallSiteDataToCallee ON " + (onEntry ? "ENTRY" : "EXIT") + ", callSiteData:" + callSiteData);
            TapEnv.printlnOnTrace("    Instruction:" + callInstruction + " CallArrow:" + callArrow);
        }
        Unit calledUnit = callArrow.destination;
        int calleeZoneNb = calledUnit.publicZonesNumber(whichKind);
        boolean takeAddressOfParams = callArrow.origin.isFortran() && calledUnit.isC();
        boolean takeDerefOfParams = callArrow.origin.isC() && calledUnit.isFortran();
        BoolVector coversFurther = callArrow.coversFurther;
        if (coversFurther != null) {
            BoolVector calleeZonesPossiblyRorW = calledUnit.getTmpALLKINDPossiblyRoW();
            coversFurther.cumulAnd(calleeZonesPossiblyRorW);
        }
        SymbolTable callSiteSymbolTable = callInstruction.block.symbolTable;
        int nbParams = callSiteParamDataS != null ? callSiteParamDataS.length - 1 : actualParamTreeS.length;
        TapList[] actualParamZonesTreeS = (TapList[])callTree.getAnnotation("actualParamZonesTreeS");
        boolean[] actualParamTotalS = (boolean[])callTree.getAnnotation("actualParamTotalS");
        TapList actualResultZonesTree = null;
        boolean bl2 = paramZoneAnnotationAbsent = actualParamZonesTreeS == null || actualParamTotalS == null;
        if (paramZoneAnnotationAbsent) {
            actualParamZonesTreeS = new TapList[nbParams];
            actualParamTotalS = new boolean[nbParams];
        }
        for (int i = 0; i <= nbParams; ++i) {
            if (callSiteParamDataS == null || callSiteParamDataS[i] == null) {
                if (i == 0) {
                    if (actualResultTree != null) {
                        actualResultZonesTree = callSiteSymbolTable.treeOfZonesOfValue(actualResultTree, null, callInstruction, null);
                    }
                    if (!traceHere) continue;
                    TapEnv.printlnOnTrace("    actualResultZonesTree is " + actualResultZonesTree);
                    continue;
                }
                if (paramZoneAnnotationAbsent && actualParamTreeS != null && actualParamTreeS[i - 1] != null) {
                    TapList<?> actualParamZonesTree = callSiteSymbolTable.treeOfZonesOfValue(actualParamTreeS[i - 1], null, callInstruction, null);
                    if (actualParamZonesTree != null && i != 0) {
                        actualParamZonesTree = TapList.copyTree(actualParamZonesTree);
                        DataFlowAnalyzer.includePointedElementsInTree(actualParamZonesTree, null, null, true, callSiteSymbolTable, callInstruction, calledUnit, false, true);
                    }
                    actualParamZonesTreeS[i - 1] = actualParamZonesTree;
                    actualParamTotalS[i - 1] = false;
                }
                if (!traceHere) continue;
                TapEnv.printlnOnTrace("    actualParamZonesTree of arg#" + i + " is " + actualParamZonesTreeS[i - 1] + " total:" + actualParamTotalS[i - 1]);
                continue;
            }
            if (!traceHere) continue;
            TapEnv.printlnOnTrace("    callSiteParamDataS[" + i + (i == 0 ? "=result" : "") + "] = " + callSiteParamDataS[i]);
        }
        int globalKindZoneNb = calledUnit.globalZonesNumber(whichKind);
        BoolVector dataCopy = callSiteData.copy();
        PointerAnalyzer.replaceActualsByInitials(dataCopy, callTree, whichKind);
        BoolVector calleeData = dataCopy.copy(globalKindZoneNb, calleeZoneNb);
        if (traceHere) {
            TapEnv.printlnOnTrace("   calleeData after copying " + globalKindZoneNb + " globals:" + calleeData);
        }
        int globalZoneNb = calledUnit.globalZonesNumber(0);
        for (int i = calledUnit.paramElemsNb() - 1; i >= globalZoneNb; --i) {
            ZoneInfo zi = calledUnit.paramElemZoneInfo(i);
            if (traceHere) {
                System.out.println("      INDEX " + i + " ZONEINFO:" + zi);
            }
            int paramRk = zi.index;
            if ((!zi.isParameter() || 0 >= paramRk || paramRk > nbParams) && (!zi.isResult() || onEntry)) continue;
            Tree zoneAccessTree = zi.accessTree;
            boolean skipZI = false;
            if (paramRk > 0) {
                if (takeDerefOfParams && !zi.passesByValue(calledUnit, 4)) {
                    zoneAccessTree = ILUtils.addPointerAccessAtBase(ILUtils.copy(zoneAccessTree));
                } else if (takeAddressOfParams) {
                    if (TypeSpec.isA(zi.type, 6) && (ILUtils.isNullOrNone(zi.accessTree) || zi.accessTree.opCode() == 96)) {
                        skipZI = true;
                    } else {
                        zoneAccessTree = ILUtils.addAddressOfAtBase(ILUtils.copy(zoneAccessTree));
                    }
                }
            }
            if (skipZI) continue;
            if (callSiteParamDataS != null && callSiteParamDataS[paramRk] != null) {
                if (!TapList.oneTrue(TapList.getSetFieldLocation(callSiteParamDataS[paramRk], zoneAccessTree, false))) continue;
                calleeData.set(zi.kindZoneNb(whichKind), true);
                continue;
            }
            TapList actualParamZonesTree = paramRk == 0 ? actualResultZonesTree : actualParamZonesTreeS[paramRk - 1];
            if (onEntry || paramRk == 0 || propagateEvenByValue || zoneAccessTree == null || ILUtils.isAccessedThroughPointer(zoneAccessTree) || !callArrow.takesArgumentByValue(paramRk)) {
                TapList<?> actualParamElement = TapList.getSetFieldLocation(actualParamZonesTree, zoneAccessTree, false);
                if (traceHere) {
                    System.out.println("        zoneAccessTree:" + zoneAccessTree + " through zones tree:" + actualParamZonesTree + " reaches subtree:" + actualParamElement);
                }
                TapIntList callSiteAccessedIndices = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(ZoneInfo.listAllZones(actualParamElement, paramRk > 0 && coversFurther != null && coversFurther.get(i)), whichKind, callSiteMap, callSiteSymbolTable, calledUnit);
                if (traceHere) {
                    System.out.println("          leading to vector indices:" + callSiteAccessedIndices);
                }
                if (!callSiteData.intersects(callSiteAccessedIndices)) continue;
                calleeData.set(zi.kindZoneNb(whichKind), true);
                continue;
            }
            if (!traceHere) continue;
            System.out.println("        top part (" + zoneAccessTree + ") of actual parameter " + actualParamZonesTree + " is only passed by value");
        }
        if (traceHere) {
            TapEnv.printlnOnTrace("   final calleeData:" + calleeData);
            TapEnv.printlnOnTrace("------------------- end propagateCallSiteDataToCallee (BoolVector) -------------");
        }
        return calleeData;
    }

    public static TapList[] propagateCalleeDataToCallSite(BoolVector calleeData, BoolVector callSiteData, Tree actualResultTree, Tree[] actualParamTreeS, boolean onEntry, Tree callTree, Instruction instruction, CallArrow arrow, int[] callSiteMap, int whichKind, BoolVector passesThroughCall, BoolVector passesAroundCall, boolean valuesCarryInfo, boolean onlyWhenTotal) {
        int i;
        boolean traceHere;
        boolean bl = traceHere = TapEnv.traceCurAnalysis() && TapEnv.traceThisCallArrow(arrow);
        if (traceHere) {
            TapEnv.printlnOnTrace("------------------- start propagateCalleeDataToCallSite (BoolVector) -----------");
            TapEnv.printlnOnTrace("propagateCalleeDataToCallSite ON " + (onEntry ? "ENTRY" : "EXIT") + ", calleeData :" + calleeData);
            TapEnv.printlnOnTrace("  INTO callSiteData:" + callSiteData);
            TapEnv.printlnOnTrace("  Instruction:" + instruction + " CallArrow:" + arrow);
            TapEnv.printlnOnTrace("  passesThroughCall:" + passesThroughCall);
            TapEnv.printlnOnTrace("  passesAroundCall: " + passesAroundCall);
        }
        Unit calledUnit = arrow.destination;
        BoolVector coversFurther = arrow.coversFurther;
        BoolVector calleeZonesPossiblyRorW = calledUnit.getTmpALLKINDPossiblyRoW();
        SymbolTable callSiteSymbolTable = instruction.block.symbolTable;
        int callSiteZoneNb = callSiteSymbolTable.freeDeclaredZone(whichKind);
        int nbParams = ILUtils.getArguments(callTree).length();
        TapList[] callSiteParamDataS = actualParamTreeS == null || actualResultTree == null ? new TapList[nbParams + 1] : null;
        TapList[] actualParamZonesTreeS = new TapList[nbParams];
        boolean[] actualParamTotalS = new boolean[nbParams];
        TapList<?> actualResultZonesTree = null;
        ToBool total = new ToBool(false);
        for (int i2 = nbParams; i2 >= 0; --i2) {
            if (i2 == 0 ? actualResultTree == null : actualParamTreeS == null || actualParamTreeS[i2 - 1] == null) {
                callSiteParamDataS[i2] = new TapList<Boolean>(Boolean.FALSE, null);
                continue;
            }
            Tree argTree = i2 == 0 ? actualResultTree : actualParamTreeS[i2 - 1];
            total.set(false);
            TapList<?> actualParamZonesTree = callSiteSymbolTable.treeOfZonesOfValue(argTree, total, instruction, null);
            if (actualParamZonesTree != null && i2 != 0) {
                actualParamZonesTree = TapList.copyTree(actualParamZonesTree);
                DataFlowAnalyzer.includePointedElementsInTree(actualParamZonesTree, total, null, true, callSiteSymbolTable, instruction, calledUnit, false, true);
                if (arrow.takesArgumentByValue(i2) && !valuesCarryInfo) {
                    DataFlowAnalyzer.removeInfoOnTopLevel(actualParamZonesTree);
                }
            }
            if (i2 == 0) {
                actualResultZonesTree = actualParamZonesTree;
                if (!traceHere) continue;
                TapEnv.printlnOnTrace("   actualResultZonesTree == " + actualResultZonesTree + " for result");
                continue;
            }
            actualParamZonesTreeS[i2 - 1] = actualParamZonesTree;
            actualParamTotalS[i2 - 1] = total.get();
            if (!traceHere) continue;
            TapEnv.printlnOnTrace("   actualParamZonesTreeS[" + (i2 - 1) + "] == " + actualParamZonesTreeS[i2 - 1] + " for " + actualParamTreeS[i2 - 1]);
        }
        if (callSiteData != null) {
            if (passesAroundCall != null) {
                callSiteData.cumulAnd(passesAroundCall, callSiteZoneNb);
            }
            int globalKindZoneNb = calledUnit.globalZonesNumber(whichKind);
            BoolVector dataOnGlobals = calleeData.copy(globalKindZoneNb, callSiteZoneNb);
            if (globalKindZoneNb != 0) {
                PointerAnalyzer.replaceInitialsByActuals(dataOnGlobals, callTree, whichKind, callSiteZoneNb);
            }
            if (passesThroughCall != null) {
                dataOnGlobals.cumulAnd(passesThroughCall);
            }
            callSiteData.cumulOr(dataOnGlobals, callSiteZoneNb);
            if (traceHere) {
                TapEnv.printlnOnTrace("  callSiteData after wiping killed and copying " + globalKindZoneNb + " globals:" + callSiteData);
            }
        }
        boolean takeAddressOfParam = arrow.origin.isFortran() && calledUnit.isC();
        boolean takeDerefOfParam = arrow.origin.isC() && calledUnit.isFortran();
        int globalZoneNb = calledUnit.globalZonesNumber(0);
        block5: for (i = calledUnit.paramElemsNb() - 1; i >= globalZoneNb; --i) {
            ZoneInfo zi = calledUnit.paramElemZoneInfo(i);
            int ki = i;
            if (whichKind != 0) {
                ki = zi.kindZoneNb(whichKind);
            }
            if (ki < 0) continue;
            switch (zi.kind()) {
                case 7: {
                    TapList<?> toLocation;
                    int paramRk;
                    boolean calleeZoneData = DataFlowAnalyzer.dataOfParamElem(calleeData, ki);
                    if (traceHere) {
                        TapEnv.printlnOnTrace("   callee data is " + calleeZoneData + " for elementary param #" + i + " from param#" + zi.index + ", ZoneInfo:" + zi + " kindZone:" + ki);
                    }
                    if (0 >= (paramRk = zi.index) || paramRk > nbParams || onlyWhenTotal && !actualParamTotalS[paramRk - 1]) continue block5;
                    Tree zoneAccessTree = zi.accessTree;
                    boolean skipZI = false;
                    if (takeDerefOfParam && !zi.passesByValue(calledUnit, 4)) {
                        zoneAccessTree = ILUtils.addPointerAccessAtBase(ILUtils.copy(zoneAccessTree));
                    } else if (takeAddressOfParam) {
                        if (TypeSpec.isA(zi.type, 6) && (ILUtils.isNullOrNone(zi.accessTree) || zi.accessTree.opCode() == 96)) {
                            skipZI = true;
                        } else {
                            zoneAccessTree = ILUtils.addAddressOfAtBase(ILUtils.copy(zoneAccessTree));
                        }
                    }
                    if (skipZI) continue block5;
                    if (actualParamTreeS == null || actualParamTreeS[paramRk - 1] == null) {
                        if (traceHere) {
                            TapEnv.printlnOnTrace("    getSetFieldLocation of accessTree of " + zi + " INSIDE " + callSiteParamDataS[paramRk]);
                        }
                        toLocation = TapList.getSetFieldLocation(callSiteParamDataS[paramRk], zoneAccessTree, true);
                        if (traceHere) {
                            TapEnv.printlnOnTrace("     -> " + toLocation + " INSIDE " + callSiteParamDataS[paramRk] + " WILL RECEIVE " + calleeZoneData);
                        }
                        if (!calleeZonesPossiblyRorW.get(i)) continue block5;
                        if (calleeZoneData) {
                            toLocation.head = Boolean.TRUE;
                            continue block5;
                        }
                        if (toLocation.head != null) continue block5;
                        toLocation.head = Boolean.FALSE;
                        continue block5;
                    }
                    if (callSiteData == null) continue block5;
                    if (traceHere) {
                        TapEnv.printlnOnTrace("    zone:" + zi + " coversFurther:" + (coversFurther != null && coversFurther.get(i)));
                        TapEnv.printlnOnTrace("    accessTree:" + zoneAccessTree);
                    }
                    TapIntList callSiteAccessedIndices = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(ZoneInfo.listAllZones(TapList.getSetFieldLocation(actualParamZonesTreeS[paramRk - 1], zoneAccessTree, false), coversFurther != null && coversFurther.get(i)), whichKind, callSiteMap, callSiteSymbolTable, calledUnit);
                    if (traceHere) {
                        TapEnv.printlnOnTrace("    callSiteAccessedIndices:" + callSiteAccessedIndices);
                    }
                    if (!calleeZoneData) continue block5;
                    while (callSiteAccessedIndices != null) {
                        DataFlowAnalyzer.updateDataInTransit(callSiteData, callSiteAccessedIndices.head, true, passesThroughCall, passesAroundCall);
                        callSiteAccessedIndices = callSiteAccessedIndices.tail;
                    }
                    continue block5;
                }
                case 10: {
                    TapList<?> toLocation;
                    boolean calleeZoneData = DataFlowAnalyzer.dataOfParamElem(calleeData, ki);
                    if (traceHere) {
                        TapEnv.printlnOnTrace("   callee data is " + calleeZoneData + " for elementary param #" + i + " from RESULT, ZoneInfo:" + zi + " kindZone:" + ki);
                    }
                    if (actualResultTree == null) {
                        toLocation = TapList.getSetFieldLocation(callSiteParamDataS[0], zi.accessTree, true);
                        if (calleeZoneData) {
                            toLocation.head = Boolean.TRUE;
                            continue block5;
                        }
                        if (toLocation.head != null) continue block5;
                        toLocation.head = Boolean.FALSE;
                        continue block5;
                    }
                    if (callSiteData == null) continue block5;
                    TapIntList callSiteAccessedIndices = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(ZoneInfo.listAllZones(TapList.getSetFieldLocation(actualResultZonesTree, zi.accessTree, false), false), whichKind, callSiteMap, callSiteSymbolTable, calledUnit);
                    if (!calleeZoneData) continue block5;
                    while (callSiteAccessedIndices != null) {
                        DataFlowAnalyzer.updateDataInTransit(callSiteData, callSiteAccessedIndices.head, true, passesThroughCall, passesAroundCall);
                        callSiteAccessedIndices = callSiteAccessedIndices.tail;
                    }
                    continue block5;
                }
            }
        }
        if (!valuesCarryInfo && callSiteParamDataS != null) {
            for (i = 1; i < callSiteParamDataS.length; ++i) {
                if (!arrow.takesArgumentByValue(i)) continue;
                DataFlowAnalyzer.removeInfoOnTopLevel(callSiteParamDataS[i]);
            }
        }
        if (traceHere) {
            TapEnv.printlnOnTrace("final callSiteData:" + callSiteData);
            if (callSiteParamDataS != null) {
                for (i = 0; i < callSiteParamDataS.length; ++i) {
                    if (callSiteParamDataS[i] == null) continue;
                    TapEnv.printlnOnTrace("callSiteParamDataS[" + i + (i == 0 ? "=result" : "") + "] = " + callSiteParamDataS[i]);
                }
            }
            TapEnv.printlnOnTrace("------------------- end propagateCalleeDataToCallSite (BoolVector) -------------");
        }
        return callSiteParamDataS;
    }

    public static BoolMatrix propagateCallSiteDataToCallee(BoolMatrix callSiteData, TapList[] callSiteParamDataS, Tree actualResultTree, Tree[] actualParamTreeS, boolean onEntry, Tree callTree, Instruction callInstruction, CallArrow callArrow, int[] callSiteMap, int whichKind, boolean propagateEvenByValue) {
        boolean paramZoneAnnotationAbsent;
        boolean traceHere;
        boolean bl = traceHere = TapEnv.traceCurAnalysis() && TapEnv.traceThisCallArrow(callArrow);
        if (traceHere) {
            TapEnv.printlnOnTrace("------------------- start propagateCallSiteDataToCallee (BoolMatrix) -----------");
            TapEnv.printlnOnTrace("  propagateCallSiteDataToCallee ON " + (onEntry ? "ENTRY" : "EXIT") + ", callSiteData:");
            TapEnv.dumpOnTrace(callSiteData);
            TapEnv.printlnOnTrace("    Instruction:" + callInstruction + " CallArrow:" + callArrow);
        }
        Unit calledUnit = callArrow.destination;
        int calleeZoneNb = calledUnit.publicZonesNumber(whichKind);
        boolean takeAddressOfParams = callArrow.origin.isFortran() && calledUnit.isC();
        boolean takeDerefOfParams = callArrow.origin.isC() && calledUnit.isFortran();
        BoolVector coversFurther = callArrow.coversFurther;
        if (coversFurther != null) {
            BoolVector calleeZonesPossiblyRorW = calledUnit.getTmpALLKINDPossiblyRoW();
            coversFurther.cumulAnd(calleeZonesPossiblyRorW);
        }
        SymbolTable callSiteSymbolTable = callInstruction.block.symbolTable;
        int nbParams = callSiteParamDataS != null ? callSiteParamDataS.length - 1 : actualParamTreeS.length;
        TapList[] actualParamZonesTreeS = (TapList[])callTree.getAnnotation("actualParamZonesTreeS");
        boolean[] actualParamTotalS = (boolean[])callTree.getAnnotation("actualParamTotalS");
        TapList actualResultZonesTree = null;
        boolean bl2 = paramZoneAnnotationAbsent = actualParamZonesTreeS == null || actualParamTotalS == null;
        if (paramZoneAnnotationAbsent) {
            actualParamZonesTreeS = new TapList[nbParams];
            actualParamTotalS = new boolean[nbParams];
        }
        for (int i = 0; i <= nbParams; ++i) {
            if (callSiteParamDataS == null || callSiteParamDataS[i] == null) {
                if (i == 0) {
                    if (actualResultTree != null) {
                        actualResultZonesTree = callSiteSymbolTable.treeOfZonesOfValue(actualResultTree, null, callInstruction, null);
                    }
                    if (!traceHere) continue;
                    TapEnv.printlnOnTrace("    actualResultZonesTree is " + actualResultZonesTree);
                    continue;
                }
                if (paramZoneAnnotationAbsent && actualParamTreeS != null && actualParamTreeS[i - 1] != null) {
                    TapList<?> actualParamZonesTree = callSiteSymbolTable.treeOfZonesOfValue(actualParamTreeS[i - 1], null, callInstruction, null);
                    if (actualParamZonesTree != null && i != 0) {
                        actualParamZonesTree = TapList.copyTree(actualParamZonesTree);
                        DataFlowAnalyzer.includePointedElementsInTree(actualParamZonesTree, null, null, true, callSiteSymbolTable, callInstruction, calledUnit, false, true);
                    }
                    actualParamZonesTreeS[i - 1] = actualParamZonesTree;
                    actualParamTotalS[i - 1] = false;
                }
                if (!traceHere) continue;
                TapEnv.printlnOnTrace("    actualParamZonesTree of arg#" + i + " is " + actualParamZonesTreeS[i - 1] + " total:" + actualParamTotalS[i - 1]);
                continue;
            }
            if (!traceHere) continue;
            TapEnv.printlnOnTrace("    callSiteParamDataS[" + i + (i == 0 ? "=result" : "") + "] = " + callSiteParamDataS[i]);
        }
        int globalKindZoneNb = calledUnit.globalZonesNumber(whichKind);
        BoolMatrix dataCopy = new BoolMatrix(callSiteData.nRows, callSiteData.nCols);
        dataCopy.rows = new BoolVector[callSiteData.nRows];
        for (int i = 0; i < callSiteData.nRows; ++i) {
            dataCopy.rows[i] = callSiteData.rows[i];
        }
        if (traceHere) {
            TapList actualInitials;
            TapList[] actualInitials4 = (TapList[])callTree.getAnnotation("pointersActualInitialDests");
            TapList tapList = actualInitials = actualInitials4 == null ? null : actualInitials4[whichKind];
            while (actualInitials != null) {
                TapEnv.printlnOnTrace("      Using initial " + ((TapPair)actualInitials.head).first + " for actuals " + ((TapPair)actualInitials.head).second);
                actualInitials = actualInitials.tail;
            }
        }
        PointerAnalyzer.replaceActualsByInitials(dataCopy, callTree, whichKind);
        BoolMatrix calleeData = new BoolMatrix(calleeZoneNb, callSiteData.nCols);
        calleeData.rows = new BoolVector[calleeZoneNb];
        for (int i = 0; i < calleeZoneNb; ++i) {
            calleeData.rows[i] = i < globalKindZoneNb ? dataCopy.rows[i] : null;
        }
        if (traceHere) {
            TapEnv.printlnOnTrace("  calleeData after copying " + globalKindZoneNb + " globals:");
            TapEnv.dumpOnTrace(calleeData);
        }
        int globalZoneNb = calledUnit.globalZonesNumber(0);
        for (int i = calledUnit.paramElemsNb() - 1; i >= globalZoneNb; --i) {
            ZoneInfo zi = calledUnit.paramElemZoneInfo(i);
            if (traceHere) {
                System.out.println("      INDEX " + i + " ZONEINFO:" + zi);
            }
            int paramRk = zi.index;
            if ((!zi.isParameter() || 0 >= paramRk || paramRk > nbParams) && (!zi.isResult() || onEntry)) continue;
            Tree zoneAccessTree = zi.accessTree;
            boolean skipZI = false;
            if (paramRk > 0) {
                if (takeDerefOfParams && !zi.passesByValue(calledUnit, 4)) {
                    zoneAccessTree = ILUtils.addPointerAccessAtBase(ILUtils.copy(zoneAccessTree));
                } else if (takeAddressOfParams) {
                    if (TypeSpec.isA(zi.type, 6) && (ILUtils.isNullOrNone(zi.accessTree) || zi.accessTree.opCode() == 96)) {
                        skipZI = true;
                    } else {
                        zoneAccessTree = ILUtils.addAddressOfAtBase(ILUtils.copy(zoneAccessTree));
                    }
                }
            }
            if (skipZI) continue;
            if (callSiteParamDataS != null && callSiteParamDataS[paramRk] != null) {
                BoolVector cumul = TapList.cumulOr(TapList.getSetFieldLocation(callSiteParamDataS[paramRk], zoneAccessTree, false));
                if (cumul == null) continue;
                calleeData.rows[zi.kindZoneNb((int)whichKind)] = cumul;
                continue;
            }
            TapList actualParamZonesTree = paramRk == 0 ? actualResultZonesTree : actualParamZonesTreeS[paramRk - 1];
            BoolVector calleeRow = calleeData.rows[zi.kindZoneNb(whichKind)];
            if (calleeRow == null) {
                calleeRow = new BoolVector(callSiteData.nCols);
            }
            if (onEntry || paramRk == 0 || propagateEvenByValue || zoneAccessTree == null || ILUtils.isAccessedThroughPointer(zoneAccessTree) || !callArrow.takesArgumentByValue(paramRk)) {
                TapList<?> actualParamElement = TapList.getSetFieldLocation(actualParamZonesTree, zoneAccessTree, false);
                if (traceHere) {
                    System.out.println("        zoneAccessTree:" + zoneAccessTree + " through zones tree:" + actualParamZonesTree + " reaches subtree:" + actualParamElement);
                }
                TapIntList callSiteAccessedIndices = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(ZoneInfo.listAllZones(actualParamElement, paramRk > 0 && coversFurther != null && coversFurther.get(i)), whichKind, callSiteMap, callSiteSymbolTable, calledUnit);
                if (traceHere) {
                    System.out.println("          leading to vector indices:" + callSiteAccessedIndices);
                }
                while (callSiteAccessedIndices != null) {
                    BoolVector callSiteRow = callSiteData.rows[callSiteAccessedIndices.head];
                    if (callSiteRow != null) {
                        calleeRow.cumulOr(callSiteRow);
                    } else if (callSiteAccessedIndices.head < callSiteData.nCols) {
                        calleeRow.set(callSiteAccessedIndices.head, true);
                    }
                    callSiteAccessedIndices = callSiteAccessedIndices.tail;
                }
            } else if (traceHere) {
                System.out.println("        top part (" + zoneAccessTree + ") of actual parameter " + actualParamZonesTree + " is only passed by value");
            }
            calleeData.rows[zi.kindZoneNb((int)whichKind)] = calleeRow;
        }
        if (traceHere) {
            TapEnv.printlnOnTrace("   final calleeData:");
            TapEnv.dumpOnTrace(calleeData);
            TapEnv.printlnOnTrace("------------------- end propagateCallSiteDataToCallee (BoolMatrix) -------------");
        }
        return calleeData;
    }

    public static TapList[] propagateCalleeDataToCallSite(BoolMatrix calleeData, BoolMatrix callSiteData, Tree actualResultTree, Tree[] actualParamTreeS, boolean onEntry, Tree callTree, Instruction instruction, CallArrow arrow, int[] callSiteMap, int whichKind, BoolVector passesThroughCall, BoolVector passesAroundCall, boolean valuesCarryInfo, BoolVector calleeMask) {
        int i;
        int i2;
        boolean traceHere = TapEnv.traceCurAnalysis() && TapEnv.traceThisCallArrow(arrow);
        Unit calledUnit = arrow.destination;
        if (traceHere) {
            TapEnv.printlnOnTrace("------------------- start propagateCalleeDataToCallSite (BoolMatrix) -----------");
            TapEnv.printlnOnTrace("  propagateCalleeDataToCallSite ON " + (onEntry ? "ENTRY" : "EXIT") + ", calleeData :");
            TapEnv.dumpOnTrace(calleeData);
            TapEnv.printlnOnTrace("    INTO callSiteData:");
            if (callSiteData == null) {
                TapEnv.printlnOnTrace("     null, not requested.");
            } else {
                TapEnv.dumpOnTrace(callSiteData);
            }
            TapEnv.printlnOnTrace("    Instruction:" + instruction + " CallArrow:" + arrow);
            TapEnv.printlnOnTrace("    passesThroughCall:" + passesThroughCall);
            TapEnv.printlnOnTrace("    passesAroundCall: " + passesAroundCall);
            TapEnv.printlnOnTrace("    Callee Mask:      " + calleeMask);
        }
        BoolVector coversFurther = arrow.coversFurther;
        BoolVector calleeZonesPossiblyRorW = calledUnit.getTmpALLKINDPossiblyRoW();
        SymbolTable callSiteSymbolTable = instruction.block.symbolTable;
        int nbParams = ILUtils.getArguments(callTree).length();
        TapList[] callSiteParamDataS = actualParamTreeS == null || actualResultTree == null ? new TapList[nbParams + 1] : null;
        TapList[] actualParamZonesTreeS = new TapList[nbParams];
        boolean[] actualParamTotalS = new boolean[nbParams];
        ToBool total = new ToBool(false);
        if (actualParamTreeS == null) {
            for (int i3 = nbParams; i3 > 0; --i3) {
                callSiteParamDataS[i3] = new TapList<Object>(null, null);
            }
        } else {
            for (i2 = nbParams - 1; i2 >= 0; --i2) {
                total.set(false);
                TapList<?> actualParamZonesTree = callSiteSymbolTable.treeOfZonesOfValue(actualParamTreeS[i2], total, instruction, null);
                if (actualParamZonesTree != null) {
                    actualParamZonesTree = TapList.copyTree(actualParamZonesTree);
                    DataFlowAnalyzer.includePointedElementsInTree(actualParamZonesTree, total, null, true, callSiteSymbolTable, instruction, calledUnit, false, true);
                    if (arrow.takesArgumentByValue(i2 + 1) && !valuesCarryInfo) {
                        DataFlowAnalyzer.removeInfoOnTopLevel(actualParamZonesTree);
                    }
                }
                actualParamZonesTreeS[i2] = actualParamZonesTree;
                actualParamTotalS[i2] = total.get();
                if (!traceHere) continue;
                TapEnv.printlnOnTrace("actualParamZonesTreeS[" + i2 + "] == " + actualParamZonesTreeS[i2] + " for " + actualParamTreeS[i2]);
            }
        }
        TapList<?> actualResultZonesTree = null;
        if (actualResultTree == null) {
            callSiteParamDataS[0] = new TapList<Object>(null, null);
        } else {
            actualResultZonesTree = callSiteSymbolTable.treeOfZonesOfValue(actualResultTree, null, instruction, null);
        }
        if (callSiteData != null) {
            int i4;
            if (passesAroundCall != null) {
                for (i2 = callSiteData.nRows - 1; i2 >= 0; --i2) {
                    if (passesAroundCall.get(i2)) continue;
                    callSiteData.setRow(i2, new BoolVector(callSiteData.nCols));
                }
            }
            int globalKindZoneNb = calledUnit.globalZonesNumber(whichKind);
            BoolMatrix dataCopy = new BoolMatrix(callSiteData.nRows, calleeData.nCols);
            dataCopy.rows = new BoolVector[dataCopy.nRows];
            for (i4 = 0; i4 < dataCopy.nRows; ++i4) {
                dataCopy.rows[i4] = i4 < calleeData.nRows && (calleeMask == null || calleeMask.get(i4)) ? calleeData.rows[i4] : null;
            }
            PointerAnalyzer.replaceInitialsByActuals(dataCopy, callTree, whichKind);
            for (i4 = 0; i4 < callSiteData.nRows; ++i4) {
                if (i4 >= globalKindZoneNb || dataCopy.rows[i4] == null) continue;
                DataFlowAnalyzer.updateDataInTransit(callSiteData, i4, dataCopy.rows[i4], passesThroughCall, passesAroundCall);
            }
            if (traceHere) {
                TapEnv.printlnOnTrace("  callSiteData after wiping killed and copying " + globalKindZoneNb + " globals:");
                TapEnv.dumpOnTrace(callSiteData);
            }
        }
        boolean takeAddressOfParam = arrow.origin.isFortran() && calledUnit.isC();
        boolean takeDerefOfParam = arrow.origin.isC() && calledUnit.isFortran();
        int globalZoneNb = calledUnit.globalZonesNumber(0);
        block9: for (i = calledUnit.paramElemsNb() - 1; i >= globalZoneNb; --i) {
            ZoneInfo zi = calledUnit.paramElemZoneInfo(i);
            int ki = i;
            if (whichKind != 0) {
                ki = zi.kindZoneNb(whichKind);
            }
            if (ki < 0 || calleeMask != null && !calleeMask.get(ki)) continue;
            BoolVector calleeZoneData = DataFlowAnalyzer.dataOfParamElem(calleeData, ki);
            switch (zi.kind()) {
                case 7: {
                    int paramRk;
                    if (traceHere) {
                        TapEnv.printlnOnTrace("  callee data is " + calleeZoneData + " for elementary param #" + i + " from param#" + zi.index + ", ZoneInfo:" + zi + " kindZone:" + ki);
                    }
                    if (0 >= (paramRk = zi.index) || paramRk > nbParams) continue block9;
                    Tree zoneAccessTree = zi.accessTree;
                    boolean skipZI = false;
                    if (takeDerefOfParam && !zi.passesByValue(calledUnit, 4)) {
                        zoneAccessTree = ILUtils.addPointerAccessAtBase(ILUtils.copy(zoneAccessTree));
                    } else if (takeAddressOfParam) {
                        if (TypeSpec.isA(zi.type, 6) && (ILUtils.isNullOrNone(zi.accessTree) || zi.accessTree.opCode() == 96)) {
                            skipZI = true;
                        } else {
                            zoneAccessTree = ILUtils.addAddressOfAtBase(ILUtils.copy(zoneAccessTree));
                        }
                    }
                    if (skipZI) continue block9;
                    if (actualParamTreeS == null) {
                        if (traceHere) {
                            TapEnv.printlnOnTrace("   getSetFieldLocation of accessTree of " + zi + " INSIDE " + callSiteParamDataS[paramRk]);
                        }
                        TapList<?> toLocation = TapList.getSetFieldLocation(callSiteParamDataS[paramRk], zoneAccessTree, true);
                        if (traceHere) {
                            TapEnv.printlnOnTrace("   -> " + toLocation + " INSIDE " + callSiteParamDataS[paramRk] + " WILL RECEIVE " + calleeZoneData);
                        }
                        if (!calleeZonesPossiblyRorW.get(i)) continue block9;
                        if (toLocation.head instanceof BoolVector) {
                            ((BoolVector)toLocation.head).cumulOr(calleeZoneData);
                            continue block9;
                        }
                        toLocation.head = calleeZoneData;
                        continue block9;
                    }
                    if (callSiteData == null) continue block9;
                    if (traceHere) {
                        TapEnv.printlnOnTrace("   zone:" + zi + " coversFurther:" + (coversFurther != null && coversFurther.get(i)));
                        TapEnv.printlnOnTrace("   accessTree:" + zoneAccessTree);
                    }
                    TapIntList callSiteAccessedIndices = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(ZoneInfo.listAllZones(TapList.getSetFieldLocation(actualParamZonesTreeS[paramRk - 1], zoneAccessTree, false), coversFurther != null && coversFurther.get(i)), whichKind, callSiteMap, callSiteSymbolTable, calledUnit);
                    if (traceHere) {
                        TapEnv.printlnOnTrace("   callSiteAccessedIndices:" + callSiteAccessedIndices);
                    }
                    while (callSiteAccessedIndices != null) {
                        DataFlowAnalyzer.updateDataInTransit(callSiteData, callSiteAccessedIndices.head, calleeZoneData, passesThroughCall, passesAroundCall);
                        callSiteAccessedIndices = callSiteAccessedIndices.tail;
                    }
                    continue block9;
                }
                case 10: {
                    if (traceHere) {
                        TapEnv.printlnOnTrace("  callee data is " + calleeZoneData + " for elementary param #" + i + " from RESULT, ZoneInfo:" + zi + " kindZone:" + ki);
                    }
                    if (actualResultTree == null) {
                        TapList<?> toLocation = TapList.getSetFieldLocation(callSiteParamDataS[0], zi.accessTree, true);
                        if (toLocation.head instanceof BoolVector) {
                            ((BoolVector)toLocation.head).cumulOr(calleeZoneData);
                            continue block9;
                        }
                        toLocation.head = calleeZoneData;
                        continue block9;
                    }
                    if (callSiteData == null) continue block9;
                    TapIntList callSiteAccessedIndices = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(ZoneInfo.listAllZones(TapList.getSetFieldLocation(actualResultZonesTree, zi.accessTree, false), false), whichKind, callSiteMap, callSiteSymbolTable, calledUnit);
                    while (callSiteAccessedIndices != null) {
                        DataFlowAnalyzer.updateDataInTransit(callSiteData, callSiteAccessedIndices.head, calleeZoneData, null, passesAroundCall);
                        callSiteAccessedIndices = callSiteAccessedIndices.tail;
                    }
                    continue block9;
                }
            }
        }
        if (!valuesCarryInfo && callSiteParamDataS != null) {
            for (i = 1; i < callSiteParamDataS.length; ++i) {
                if (!arrow.takesArgumentByValue(i)) continue;
                DataFlowAnalyzer.removeInfoOnTopLevel(callSiteParamDataS[i]);
            }
        }
        if (traceHere) {
            TapEnv.printlnOnTrace("   final callSiteData:");
            if (callSiteData == null) {
                TapEnv.printlnOnTrace("     null, not requested.");
            } else {
                TapEnv.dumpOnTrace(callSiteData);
            }
            if (callSiteParamDataS != null) {
                for (i = 0; i < callSiteParamDataS.length; ++i) {
                    TapEnv.printlnOnTrace("   callSiteParamDataS[" + i + (i == 0 ? "=result" : "") + "] = " + callSiteParamDataS[i]);
                }
            }
            TapEnv.printlnOnTrace("------------------- end propagateCalleeDataToCallSite (BoolMatrix) -------------");
        }
        return callSiteParamDataS;
    }

    private static void updateDataInTransit(BoolVector dataInTransit, int index, boolean value, BoolVector passesThroughCall, BoolVector passesAroundCall) {
        boolean addInfoThroughCall;
        boolean bl = addInfoThroughCall = passesThroughCall == null || passesThroughCall.get(index);
        if (addInfoThroughCall) {
            boolean alsoInfoBeforeCall;
            boolean bl2 = alsoInfoBeforeCall = passesAroundCall == null || passesAroundCall.get(index);
            if (alsoInfoBeforeCall) {
                if (value) {
                    dataInTransit.set(index, true);
                }
            } else {
                dataInTransit.set(index, value);
            }
        }
    }

    private static void updateDataInTransit(BoolMatrix dataInTransit, int index, BoolVector rowThroughCall, BoolVector passesThroughCall, BoolVector passesAroundCall) {
        boolean addInfoThroughCall;
        boolean bl = addInfoThroughCall = passesThroughCall == null || passesThroughCall.get(index);
        if (addInfoThroughCall) {
            boolean alsoInfoBeforeCall;
            boolean bl2 = alsoInfoBeforeCall = passesAroundCall == null || passesAroundCall.get(index);
            if (alsoInfoBeforeCall) {
                if (rowThroughCall != null) {
                    if (dataInTransit.rows[index] == null) {
                        dataInTransit.rows[index] = new BoolVector(dataInTransit.nCols);
                        dataInTransit.rows[index].set(index, true);
                    }
                    dataInTransit.rows[index].cumulOr(rowThroughCall);
                }
            } else {
                dataInTransit.rows[index] = rowThroughCall;
            }
        }
    }

    public static boolean dataOfParamElemOLD(BoolVector calleeData, int paramElemIndex, int whichKind, Unit callee) {
        if (!callee.hasSource()) {
            return calleeData.get(paramElemIndex);
        }
        PublicInfo calleeZoneInfo = callee.paramElemPublicInfo(paramElemIndex);
        TapIntList calleeAccessedIndices = DataFlowAnalyzer.mapZoneRkToVectorIndex(calleeZoneInfo.ranks(whichKind), 3, whichKind, DataFlowAnalyzer.makeMap3(callee, whichKind), callee);
        return calleeData.intersects(calleeAccessedIndices);
    }

    public static boolean dataOfParamElem(BoolVector calleeData, int paramElemIndex) {
        return calleeData.get(paramElemIndex);
    }

    public static BoolVector dataOfParamElem(BoolMatrix calleeData, int paramElemIndex) {
        return calleeData.rows[paramElemIndex];
    }

    public static BoolVector turnPublicTEMPORARY(BoolVector privateData, int whichKind, Unit callee) {
        if (privateData == null) {
            return null;
        }
        if (!callee.hasSource()) {
            return privateData.copy();
        }
        return DataFlowAnalyzer.propagateUnitDataOutside(privateData, whichKind, DataFlowAnalyzer.makeMap3(callee, whichKind), true, callee);
    }

    public static BoolVector propagateDataToCallSite(BoolVector publicData, Tree actualResultTree, Tree[] actualParamTreeS, int[] vectorMap, Instruction instruction, CallArrow arrow, boolean cumulOr, boolean valuesCarryInfo, int whichKind) {
        boolean traceHere = TapEnv.traceThisCallArrow(arrow);
        if (traceHere) {
            TapEnv.printlnOnTrace("  propagateDataToCallSite publicData :" + publicData);
            TapEnv.printlnOnTrace("    Instruction:" + instruction + " CallArrow:" + arrow);
        }
        BoolVector privateData = new BoolVector(DataFlowAnalyzer.mapSize(vectorMap));
        BoolVector publicZonesPossiblyRorW = arrow.destination.getTmpALLKINDPossiblyRoW();
        SymbolTable symbolTable = instruction.block.symbolTable;
        int nbParams = actualParamTreeS.length;
        TapList[] actualParamZonesTreeS = new TapList[nbParams];
        ToBool total = new ToBool();
        BoolMatrix identityPointerInfo = DataFlowAnalyzer.buildDummyIdentityPointerInfo(symbolTable, arrow.origin);
        for (int i = nbParams - 1; i >= 0; --i) {
            TapList<?> actualParamZonesTree = symbolTable.treeOfZonesOfValue(actualParamTreeS[i], total, null, identityPointerInfo);
            if (actualParamZonesTree != null) {
                actualParamZonesTree = TapList.copyTree(actualParamZonesTree);
                DataFlowAnalyzer.includePointedElementsInTree(actualParamZonesTree, total, identityPointerInfo, true, symbolTable, null, arrow.destination, false, true);
                if (arrow.takesArgumentByValue(i + 1) && !valuesCarryInfo) {
                    DataFlowAnalyzer.removeInfoOnTopLevel(actualParamZonesTree);
                }
            }
            actualParamZonesTreeS[i] = actualParamZonesTree;
            if (!traceHere) continue;
            TapEnv.printlnOnTrace("actualParamZonesTreeS[" + i + "] == " + actualParamZonesTreeS[i] + " for actual arg:" + actualParamTreeS[i]);
        }
        TapList<?> actualResultZonesTree = symbolTable.treeOfZonesOfValue(actualResultTree, null, null, identityPointerInfo);
        for (int i = arrow.translator.length - 1; i >= 0; --i) {
            PublicInfo publicZoneInfo = arrow.translator[i];
            if (publicZoneInfo == null) continue;
            boolean publicZoneData = publicData.get(i);
            TapIntList callerAccessedIndices = null;
            switch (publicZoneInfo.kind()) {
                case 10: {
                    callerAccessedIndices = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(ZoneInfo.listAllZones(TapList.getSetFieldLocation(actualResultZonesTree, publicZoneInfo.zone.accessTree, false), false), whichKind, vectorMap, symbolTable, arrow.destination);
                    break;
                }
                case 7: {
                    if (publicZoneInfo.getParamRank() == 0) {
                        callerAccessedIndices = DataFlowAnalyzer.mapZoneRkToVectorIndex(publicZoneInfo.ranks(whichKind), 3, whichKind, vectorMap, arrow.destination);
                        break;
                    }
                    if (publicZoneInfo.getParamRank() > nbParams || !publicZonesPossiblyRorW.get(i)) break;
                    if (traceHere) {
                        TapEnv.printlnOnTrace("publicZoneInfo:" + publicZoneInfo + " public data for this zone is:" + publicZoneData);
                        TapEnv.printlnOnTrace(" zone:" + publicZoneInfo.zone);
                        TapEnv.printlnOnTrace(" accessTree:" + publicZoneInfo.zone.accessTree);
                        TapEnv.printlnOnTrace(" pick accessTree location in:" + actualParamZonesTreeS[publicZoneInfo.getParamRank() - 1]);
                    }
                    callerAccessedIndices = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(ZoneInfo.listAllZones(TapList.getSetFieldLocation(actualParamZonesTreeS[publicZoneInfo.getParamRank() - 1], publicZoneInfo.zone.accessTree, false), false), whichKind, vectorMap, symbolTable, arrow.destination);
                    if (!traceHere) break;
                    TapEnv.printlnOnTrace("callerAccessedIndices:" + callerAccessedIndices);
                    break;
                }
                default: {
                    if (traceHere) {
                        TapEnv.printlnOnTrace("global publicZoneInfo:" + publicZoneInfo + " public data for this zone is:" + publicZoneData);
                        TapEnv.printlnOnTrace(" zone:" + publicZoneInfo.zone);
                    }
                    callerAccessedIndices = DataFlowAnalyzer.mapZoneRkToVectorIndex(publicZoneInfo.ranks(whichKind), 3, whichKind, vectorMap, arrow.destination);
                    if (!traceHere) break;
                    TapEnv.printlnOnTrace("callerAccessedIndices " + publicZoneInfo + "  ===> " + callerAccessedIndices);
                }
            }
            while (callerAccessedIndices != null) {
                if (cumulOr) {
                    if (publicZoneData) {
                        privateData.set(callerAccessedIndices.head, true);
                    }
                } else if (!publicZoneData) {
                    privateData.set(callerAccessedIndices.head, false);
                }
                callerAccessedIndices = callerAccessedIndices.tail;
            }
        }
        if (traceHere) {
            TapEnv.printlnOnTrace("  propagateDataToCallSite returns :" + privateData);
        }
        return privateData;
    }

    public static TapList propagateExitDataFwdToCallerResult(BoolVector publicExitData, CallArrow arrow) {
        TapList<Boolean> resultData = new TapList<Boolean>(Boolean.FALSE, null);
        for (int i = arrow.translator.length - 1; i >= 0; --i) {
            PublicInfo publicZoneInfo = arrow.translator[i];
            if (publicZoneInfo == null || publicZoneInfo.kind() != 10) continue;
            TapList<?> toLocation = TapList.getSetFieldLocation(resultData, publicZoneInfo.zone.accessTree, true);
            if (publicExitData.get(i)) {
                toLocation.head = Boolean.TRUE;
                continue;
            }
            if (toLocation.head != null) continue;
            toLocation.head = Boolean.FALSE;
        }
        return resultData;
    }

    private static BoolMatrix buildDummyIdentityPointerInfo(SymbolTable symbolTable, Unit unit) {
        int nDPZ = symbolTable.declaredZonesNb(3);
        int nDZ = symbolTable.declaredZonesNb(0);
        BoolMatrix result = new BoolMatrix(nDPZ, nDZ);
        result.setIdentity();
        return result;
    }

    private static TapIntList getIndicesAccessedInCaller(TapIntList zoneRks, int mapClass, int vectorKind, int[] vectorMap, Instruction instruction, Unit calledUnit) {
        TapIntList vectorIndices = null;
        SymbolTable symbolTable = instruction.block.symbolTable;
        while (zoneRks != null) {
            int extendedRk = DataFlowAnalyzer.zoneRkToExtendedDeclared(zoneRks.head, mapClass, 0, symbolTable, calledUnit);
            TapIntList aliasesList = DataFlowAnalyzer.presentAliasesOf(extendedRk, instruction, calledUnit);
            while (aliasesList != null) {
                int vectorIndex = DataFlowAnalyzer.extendedDeclaredToVectorIndex(aliasesList.head, vectorKind, vectorMap, symbolTable, calledUnit);
                if (vectorIndex >= 0) {
                    vectorIndices = new TapIntList(vectorIndex, vectorIndices);
                }
                aliasesList = aliasesList.tail;
            }
            zoneRks = zoneRks.tail;
        }
        return vectorIndices;
    }

    private static TapIntList presentAliasesOf(int extendedRk, Instruction instruction, Unit calledUnit) {
        SymbolTable symbolTable = instruction.block.symbolTable;
        ZoneInfo zoneInfo = DataFlowAnalyzer.extendedDeclaredToZoneInfo(extendedRk, symbolTable, calledUnit);
        if (zoneInfo == null) {
            return null;
        }
        if (zoneInfo.targetZoneOf == null || zoneInfo.accessTree == null) {
            return new TapIntList(extendedRk, null);
        }
        int zoneInfoClass = DataFlowAnalyzer.extendedDeclaredToClass(extendedRk, symbolTable);
        TapIntList aliasesOfSubPointer = DataFlowAnalyzer.presentAliasesOf(DataFlowAnalyzer.zoneInfoToExtendedDeclared(zoneInfo.targetZoneOf, zoneInfoClass, symbolTable, calledUnit), instruction, calledUnit);
        PointerTypeSpec pointerType = (PointerTypeSpec)zoneInfo.targetZoneOf.type.wrappedType;
        TapList<Object> destinationZonesTree = symbolTable.getPointerDestinationZonesTreeHere(aliasesOfSubPointer, instruction, null, null, pointerType.destinationType, calledUnit, true);
        destinationZonesTree = new TapList<Object>(null, destinationZonesTree);
        return ZoneInfo.listAllZones(TapList.getSetFieldLocation(destinationZonesTree, ILUtils.pathFromPointerAccess(zoneInfo.accessTree), false), false);
    }

    public static BoolVector buildPublicPointerZoneMask(Unit unit) {
        int length = unit.paramElemsNb();
        BoolVector result = new BoolVector(length);
        result.setFalse();
        for (int i = length - 1; i >= 0; --i) {
            WrapperTypeSpec dType;
            WrapperTypeSpec pType = unit.paramElemZoneInfo((int)i).type;
            if (!TypeSpec.isA(pType, 6) || (dType = ((PointerTypeSpec)pType.wrappedType).destinationType) != null && dType.wrappedType != null && !TypeSpec.isA(dType.wrappedType, 10) && !dType.wrappedType.isDifferentiated(null)) continue;
            result.set(i, true);
        }
        return result;
    }

    public void includePointedElementsInTree(TapList zonesTree, ToBool total, BoolMatrix pointerDests, boolean recursive, boolean isCalled, boolean upstream) {
        int[] vectorMap = DataFlowAnalyzer.makeMap3(0, 0, this.curSymbolTable.declaredZonesNb(0));
        int nbDestsZones = DataFlowAnalyzer.mapSize(vectorMap);
        BoolVector topDestZones = new BoolVector(nbDestsZones);
        TapIntList trueRanks = this.mapExtendedDeclaredToVectorIndex(ZoneInfo.listAllZones(zonesTree, false), 0, vectorMap);
        topDestZones.set(trueRanks, true);
        DataFlowAnalyzer.includePointedElementsInTreeRec(zonesTree, new TapList<Object>(null, null), new TapList<Object>(null, null), new TapList(new TapPair<BoolVector, TapList>(topDestZones, zonesTree), null), total, pointerDests, recursive, this.curSymbolTable, this.curInstruction, this.curCalledUnit, isCalled, upstream, nbDestsZones);
    }

    public static void includePointedElementsInTree(TapList zonesTree, ToBool total, BoolMatrix pointerDests, boolean recursive, SymbolTable symbolTable, Instruction instruction, Unit calledUnit, boolean isCalled, boolean upstream) {
        int[] vectorMap = DataFlowAnalyzer.makeMap3(0, 0, symbolTable.declaredZonesNb(0));
        int nbDestsZones = DataFlowAnalyzer.mapSize(vectorMap);
        BoolVector topDestZones = new BoolVector(nbDestsZones);
        TapIntList trueRanks = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(ZoneInfo.listAllZones(zonesTree, false), 0, vectorMap, symbolTable, null);
        topDestZones.set(trueRanks, true);
        DataFlowAnalyzer.includePointedElementsInTreeRec(zonesTree, new TapList<Object>(null, null), new TapList<Object>(null, null), new TapList(new TapPair<BoolVector, TapList>(topDestZones, zonesTree), null), total, pointerDests, recursive, symbolTable, instruction, calledUnit, isCalled, upstream, nbDestsZones);
    }

    private static void includePointedElementsInTreeRec(TapList zonesTree, TapList<TapList> dejaVu, TapList dejaVuPointerLists, TapList<TapPair<BoolVector, TapList<?>>> dejaVuPointerDests, ToBool total, BoolMatrix pointerDests, boolean recursive, SymbolTable symbolTable, Instruction instruction, Unit calledUnit, boolean isCalled, boolean upstream, int nbDestsZones) {
        while (zonesTree != null) {
            if (TapList.contains(dejaVu.tail, zonesTree)) {
                zonesTree = null;
                continue;
            }
            dejaVu.placdl(zonesTree);
            if (zonesTree.head instanceof TapList) {
                DataFlowAnalyzer.includePointedElementsInTreeRec((TapList)zonesTree.head, dejaVu, dejaVuPointerLists, dejaVuPointerDests, total, pointerDests, recursive, symbolTable, instruction, calledUnit, isCalled, upstream, nbDestsZones);
                zonesTree = zonesTree.tail;
                continue;
            }
            if (!(zonesTree.head instanceof TapIntList)) {
                zonesTree = zonesTree.tail;
                continue;
            }
            if (zonesTree.tail == null) {
                TapPair<BoolVector, TapList<?>> alreadyDoneDests;
                TapList<?> alreadyDone = DataFlowAnalyzer.pointerListAlreadyDone((TapIntList)zonesTree.head, dejaVuPointerLists.tail);
                if (alreadyDone != null) {
                    zonesTree.tail = alreadyDone.tail;
                    zonesTree = null;
                    continue;
                }
                BoolVector destZones = DataFlowAnalyzer.buildPointerDestinationZones((TapIntList)zonesTree.head, nbDestsZones, pointerDests, symbolTable, instruction, calledUnit, isCalled, upstream);
                TapPair<BoolVector, TapList<?>> tapPair = alreadyDoneDests = destZones == null ? null : DataFlowAnalyzer.pointerDestsAlreadyDone(destZones, dejaVuPointerDests, nbDestsZones);
                if (alreadyDoneDests != null) {
                    zonesTree.tail = (TapList)alreadyDoneDests.second;
                    zonesTree = null;
                    continue;
                }
                zonesTree.tail = DataFlowAnalyzer.buildPointerDestinationTree((TapIntList)zonesTree.head, total, pointerDests, symbolTable, instruction, calledUnit, isCalled, upstream);
                dejaVuPointerLists.placdl(zonesTree);
                if (destZones != null) {
                    assert (dejaVuPointerDests != null);
                    dejaVuPointerDests.placdl(new TapPair(destZones, zonesTree.tail));
                }
                zonesTree = recursive ? zonesTree.tail : null;
                continue;
            }
            zonesTree = null;
        }
    }

    private static BoolVector buildPointerDestinationZones(TapIntList zonesList, int nbDestsZones, BoolMatrix pointerDests, SymbolTable symbolTable, Instruction instruction, Unit calledUnit, boolean isCalled, boolean upstream) {
        Block block = instruction != null ? instruction.block : symbolTable.declarationsBlock;
        int[] rowMap = DataFlowAnalyzer.makeMap3(0, 0, symbolTable.declaredZonesNb(3));
        BoolVector result = new BoolVector(nbDestsZones);
        boolean hasPointers = false;
        while (zonesList != null) {
            int pointerRowIndex = DataFlowAnalyzer.extendedDeclaredToVectorIndex(zonesList.head, 3, rowMap, symbolTable, isCalled ? calledUnit : null);
            if (pointerRowIndex != -1) {
                hasPointers = true;
                BoolVector newDests = symbolTable.getPointerDestinationVector(pointerRowIndex, instruction, block, pointerDests, upstream);
                if (newDests != null) {
                    result.cumulOr(newDests);
                }
            }
            zonesList = zonesList.tail;
        }
        return hasPointers ? result : null;
    }

    private static TapPair<BoolVector, TapList<?>> pointerDestsAlreadyDone(BoolVector destZones, TapList<TapPair<BoolVector, TapList<?>>> dejaVuPointerDests, int nbDestsZones) {
        TapPair found = null;
        while (dejaVuPointerDests != null && found == null) {
            if (destZones.equals((BoolVector)((TapPair)dejaVuPointerDests.head).first, nbDestsZones)) {
                found = (TapPair)dejaVuPointerDests.head;
            }
            dejaVuPointerDests = dejaVuPointerDests.tail;
        }
        return found;
    }

    private static TapList buildPointerDestinationTree(TapIntList zonesList, ToBool total, BoolMatrix pointerDests, SymbolTable symbolTable, Instruction instruction, Unit calledUnit, boolean isCalled, boolean upstream) {
        TapList<?> allDestinations = null;
        while (zonesList != null) {
            TapList newDestination;
            int zoneRk = zonesList.head;
            ZoneInfo zoneInfo = DataFlowAnalyzer.extendedDeclaredToZoneInfo(zoneRk, symbolTable, isCalled ? calledUnit : null);
            if (zoneInfo != null && zoneInfo.ptrZoneNb != -1 && (newDestination = symbolTable.getPointerDestinationZonesTreeHere(new TapIntList(zoneRk, null), instruction, null, pointerDests, ((PointerTypeSpec)zoneInfo.type.wrappedType).destinationType, calledUnit, upstream)) != null) {
                allDestinations = TapList.cumulWithOper(allDestinations, newDestination, 91);
            }
            zonesList = zonesList.tail;
        }
        if (total != null && TapList.oneNonSingleton(allDestinations)) {
            total.set(false);
        }
        return allDestinations;
    }

    private static TapList<?> pointerListAlreadyDone(TapIntList zonesList, TapList<?> dejaVuPointerLists) {
        TapList found = null;
        while (found == null && dejaVuPointerLists != null) {
            if (TapIntList.equalLists((TapIntList)((TapList)dejaVuPointerLists.head).head, zonesList)) {
                found = (TapList)dejaVuPointerLists.head;
            }
            dejaVuPointerLists = dejaVuPointerLists.tail;
        }
        return found;
    }

    private static boolean isPointerZones(int paramRank, Tree[] actualParamTreeS, SymbolTable symbolTable, Instruction instruction, Unit calledUnit) {
        boolean result = false;
        TapList<?> zonesTree = symbolTable.treeOfZonesOfValue(actualParamTreeS[paramRank], new ToBool(), instruction, null);
        if (zonesTree != null && zonesTree.head instanceof TapIntList) {
            int zoneRk = ((TapIntList)zonesTree.head).head;
            result = DataFlowAnalyzer.zoneIsPointer(zoneRk, symbolTable, calledUnit);
        }
        return result;
    }

    public static void removeInfoOnTopLevel(TapList<?> zonesTree) {
        if (zonesTree != null) {
            if (zonesTree.head instanceof TapList) {
                while (zonesTree != null) {
                    DataFlowAnalyzer.removeInfoOnTopLevel((TapList)zonesTree.head);
                    zonesTree = zonesTree.tail;
                }
            } else {
                zonesTree.head = null;
            }
        }
    }

    public static void removeInfoOnTopLevel(TapList zonesTree, Object replacementValue) {
        if (zonesTree != null) {
            if (zonesTree.head instanceof TapList) {
                while (zonesTree != null) {
                    DataFlowAnalyzer.removeInfoOnTopLevel((TapList)zonesTree.head, replacementValue);
                    zonesTree = zonesTree.tail;
                }
            } else {
                zonesTree.head = replacementValue;
            }
        }
    }

    protected static void cumulOr(TapList<?> boolVectorTree, BoolVector result, boolean followPointers) {
        DataFlowAnalyzer.cumulOrRec(boolVectorTree, result, followPointers, new TapList<Object>(null, null));
    }

    private static void cumulOrRec(TapList<?> boolVectorTree, BoolVector result, boolean followPointers, TapList<TapList> dejaVu) {
        while (boolVectorTree != null) {
            if (TapList.contains(dejaVu.tail, boolVectorTree)) {
                boolVectorTree = null;
                continue;
            }
            dejaVu.placdl(boolVectorTree);
            if (boolVectorTree.head instanceof TapList) {
                DataFlowAnalyzer.cumulOrRec((TapList)boolVectorTree.head, result, followPointers, dejaVu);
                boolVectorTree = boolVectorTree.tail;
                continue;
            }
            if (boolVectorTree.head instanceof BoolVector) {
                result.cumulOr((BoolVector)boolVectorTree.head);
                boolVectorTree = followPointers ? boolVectorTree.tail : null;
                continue;
            }
            boolVectorTree = boolVectorTree.tail;
        }
    }

    public static void orInfoPRZVTrees(BoolVector info, TapList<?> infoTree) {
        DataFlowAnalyzer.orInfoPRZVTreesRec(info, infoTree, new TapList<Object>(null, null));
    }

    private static void orInfoPRZVTreesRec(BoolVector info, TapList infoTree, TapList<TapList> dejaVu) {
        while (infoTree != null) {
            if (TapList.contains(dejaVu.tail, infoTree)) {
                infoTree = null;
                continue;
            }
            dejaVu.placdl(infoTree);
            if (infoTree.head instanceof TapList) {
                DataFlowAnalyzer.orInfoPRZVTreesRec(info, (TapList)infoTree.head, dejaVu);
            } else if (infoTree.head == null) {
                infoTree.head = info.copy();
            } else {
                ((BoolVector)infoTree.head).cumulOr(info);
            }
            infoTree = infoTree.tail;
        }
    }

    public static boolean runSpecialCycleAnalysis(Block block) {
        return block instanceof HeaderBlock && block.isACleanDoLoop();
    }

    public static int commonNDZofFrontierDestinations(TapList<FGArrow> frontier, int kind) {
        int result = -1;
        while (frontier != null) {
            FGArrow arrow = (FGArrow)frontier.head;
            int newndz = arrow.destination.symbolTable.declaredZonesNb(kind);
            if (result == -1 || result > newndz) {
                result = newndz;
            }
            frontier = frontier.tail;
        }
        return Math.max(result, 0);
    }

    public static int commonNDZofFrontierOrigins(TapList<FGArrow> frontier, int kind) {
        int result = -1;
        while (frontier != null) {
            FGArrow arrow = (FGArrow)frontier.head;
            int newndz = arrow.origin.symbolTable.declaredZonesNb(kind);
            if (result == -1 || result > newndz) {
                result = newndz;
            }
            frontier = frontier.tail;
        }
        return Math.max(result, 0);
    }

    public static int commonNDZofFrontierArrows(TapList<FGArrow> frontier, int kind) {
        int result = -1;
        while (frontier != null) {
            FGArrow arrow = (FGArrow)frontier.head;
            int newndz = arrow.commonSymbolTable().declaredZonesNb(kind);
            if (result == -1 || result > newndz) {
                result = newndz;
            }
            frontier = frontier.tail;
        }
        return Math.max(result, 0);
    }

    public static Tree modifyAccessTreeForUniqueAccess(int declaredIndex, Tree accessTree, Block block) {
        Tree typicalAccessTree = accessTree;
        LoopBlock enclosingLoop = block.enclosingLoop();
        if (enclosingLoop != null) {
            TapIntList uniqueAccessZones = enclosingLoop.header().uniqueAccessZones;
            TapList<Tree> uniqueAccessTrees = enclosingLoop.header().uniqueAccessTrees;
            while (uniqueAccessZones != null && uniqueAccessZones.head != declaredIndex) {
                uniqueAccessZones = uniqueAccessZones.tail;
                uniqueAccessTrees = uniqueAccessTrees.tail;
            }
            if (uniqueAccessZones != null) {
                typicalAccessTree = (Tree)uniqueAccessTrees.head;
            }
        }
        return typicalAccessTree;
    }

    public static String namesOfPublicZones(BoolVector selectedZones, Unit unit) {
        String namesList = null;
        for (int i = unit.paramElemsNb() - 1; i >= 0; --i) {
            if (!selectedZones.get(i)) continue;
            ZoneInfo zoneInfo = unit.paramElemZoneInfo(i);
            PublicInfo publicInfo = unit.paramElemPublicInfo(i);
            String varName = zoneInfo.accessTreePrint(unit.language());
            namesList = namesList == null ? "" : ", " + namesList;
            namesList = varName + namesList;
        }
        return namesList;
    }

    public static TapList<?> buildInfoBoolTreeOfDeclaredZones(TapList<?> zonesTree, BoolVector info, int[] vectorMap, TapIntList extraInfoZones, int whichKind, SymbolTable symbolTable) {
        return DataFlowAnalyzer.buildInfoBoolTreeOfDeclaredZonesRec(zonesTree, info, vectorMap, extraInfoZones, whichKind, symbolTable, new TapList<Object>(null, null));
    }

    private static TapList<?> buildInfoBoolTreeOfDeclaredZonesRec(TapList<?> zonesTree, BoolVector info, int[] vectorMap, TapIntList extraInfoZones, int whichKind, SymbolTable symbolTable, TapList<TapPair<TapList, TapList>> dejaVu) {
        TapList<Object> hdBoolsTree;
        TapList<Object> tlBoolsTree = hdBoolsTree = new TapList<Object>(null, null);
        while (zonesTree != null) {
            TapList cycle = (TapList)TapList.cassq(zonesTree, dejaVu.tail);
            if (cycle != null) {
                tlBoolsTree.tail = cycle.tail;
                zonesTree = null;
                continue;
            }
            dejaVu.placdl(new TapPair(zonesTree, tlBoolsTree));
            Object boolsSubTree = zonesTree.head instanceof TapList ? DataFlowAnalyzer.buildInfoBoolTreeOfDeclaredZonesRec((TapList)zonesTree.head, info, vectorMap, extraInfoZones, whichKind, symbolTable, dejaVu) : Boolean.valueOf(info != null && DataFlowAnalyzer.intersectsExtendedDeclared(info, vectorMap, whichKind, (TapIntList)zonesTree.head, extraInfoZones, symbolTable, null));
            tlBoolsTree = tlBoolsTree.placdl(boolsSubTree);
            zonesTree = zonesTree.tail;
        }
        return hdBoolsTree.tail;
    }

    public static TapList<?> buildInfoBoolTreeOfDeclaredZonesAll(TapList<?> zonesTree, BoolVector info, int[] vectorMap, TapIntList extraInfoZones, int whichKind, SymbolTable symbolTable) {
        return DataFlowAnalyzer.buildInfoBoolTreeOfDeclaredZonesAllRec(zonesTree, info, vectorMap, extraInfoZones, whichKind, symbolTable, new TapList<Object>(null, null));
    }

    private static TapList buildInfoBoolTreeOfDeclaredZonesAllRec(TapList zonesTree, BoolVector info, int[] vectorMap, TapIntList extraInfoZones, int whichKind, SymbolTable symbolTable, TapList<TapPair<TapList, TapList>> dejaVu) {
        TapList<Object> hdBoolsTree;
        TapList<Object> tlBoolsTree = hdBoolsTree = new TapList<Object>(null, null);
        while (zonesTree != null) {
            TapList cycle = (TapList)TapList.cassq(zonesTree, dejaVu.tail);
            if (cycle != null) {
                tlBoolsTree.tail = cycle.tail;
                zonesTree = null;
                continue;
            }
            dejaVu.placdl(new TapPair<TapList, TapList<Object>>(zonesTree, tlBoolsTree));
            Object boolsSubTree = zonesTree.head instanceof TapList ? DataFlowAnalyzer.buildInfoBoolTreeOfDeclaredZonesAllRec((TapList)zonesTree.head, info, vectorMap, extraInfoZones, whichKind, symbolTable, dejaVu) : Boolean.valueOf(info != null && DataFlowAnalyzer.containsExtendedDeclared(info, vectorMap, whichKind, (TapIntList)zonesTree.head, extraInfoZones, symbolTable, null));
            tlBoolsTree = tlBoolsTree.placdl(boolsSubTree);
            zonesTree = zonesTree.tail;
        }
        return hdBoolsTree.tail;
    }

    public static TapList buildInfoBoolTreeOfPointers(TapList zonesTree, int[] ptrVectorMap, SymbolTable symbolTable) {
        return DataFlowAnalyzer.buildInfoBoolTreeOfPointersRec(zonesTree, ptrVectorMap, symbolTable, new TapList<Object>(null, null));
    }

    private static TapList buildInfoBoolTreeOfPointersRec(TapList zonesTree, int[] ptrVectorMap, SymbolTable symbolTable, TapList<TapPair<TapList, TapList>> dejaVu) {
        TapList<Object> hdBoolsTree;
        TapList<Object> tlBoolsTree = hdBoolsTree = new TapList<Object>(null, null);
        while (zonesTree != null) {
            TapIntList ptrIndices;
            TapList cycle = (TapList)TapList.cassq(zonesTree, dejaVu.tail);
            if (cycle != null) {
                tlBoolsTree.tail = cycle.tail;
                zonesTree = null;
                continue;
            }
            dejaVu.placdl(new TapPair<TapList, TapList<Object>>(zonesTree, tlBoolsTree));
            Object boolsSubTree = zonesTree.head instanceof TapList ? DataFlowAnalyzer.buildInfoBoolTreeOfPointersRec((TapList)zonesTree.head, ptrVectorMap, symbolTable, dejaVu) : Boolean.valueOf((ptrIndices = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex((TapIntList)zonesTree.head, 3, ptrVectorMap, symbolTable, null)) != null);
            tlBoolsTree = tlBoolsTree.placdl(boolsSubTree);
            zonesTree = zonesTree.tail;
        }
        return hdBoolsTree.tail;
    }

    public static void setExtendedDeclared(BoolVector info, int[] vectorMap, int kind, TapIntList extendedDeclaredZones, boolean value, SymbolTable symbolTable) {
        while (extendedDeclaredZones != null) {
            DataFlowAnalyzer.setExtendedDeclared(info, vectorMap, kind, extendedDeclaredZones.head, value, symbolTable);
            extendedDeclaredZones = extendedDeclaredZones.tail;
        }
    }

    public static void setExtendedDeclared(BoolVector info, int[] vectorMap, int kind, int extendedDeclaredZone, boolean value, SymbolTable symbolTable) {
        info.set(DataFlowAnalyzer.extendedDeclaredToVectorIndex(extendedDeclaredZone, kind, vectorMap, symbolTable, null), value);
    }

    public static boolean intersectsExtendedDeclared(BoolVector info, int[] vectorMap, int kind, Tree expression, ToBool total, Instruction instruction, TapIntList extraInfoZones, SymbolTable symbolTable, Unit calledUnit) {
        return DataFlowAnalyzer.intersectsExtendedDeclared(info, vectorMap, kind, ZoneInfo.listAllZones(symbolTable.treeOfZonesOfValue(expression, total, instruction, null), true), extraInfoZones, symbolTable, calledUnit);
    }

    public static boolean intersectsExtendedDeclared(BoolVector info, int[] vectorMap, int kind, TapIntList extendedDeclaredZones, TapIntList extraInfoZones, SymbolTable symbolTable, Unit calledUnit) {
        boolean intersects = false;
        while (!intersects && extendedDeclaredZones != null) {
            int zone = extendedDeclaredZones.head;
            if (zone != -1) {
                int index;
                if (TapIntList.contains(extraInfoZones, zone)) {
                    intersects = true;
                } else if (info != null && (index = DataFlowAnalyzer.extendedDeclaredToVectorIndex(zone, kind, vectorMap, symbolTable, calledUnit)) != -1) {
                    intersects = info.get(index);
                }
            }
            extendedDeclaredZones = extendedDeclaredZones.tail;
        }
        return intersects;
    }

    public static boolean containsExtendedDeclared(BoolVector info, int[] vectorMap, int kind, TapIntList extendedDeclaredZones, TapIntList extraInfoZones, SymbolTable symbolTable, Unit calledUnit) {
        boolean allTrue = true;
        while (allTrue && extendedDeclaredZones != null) {
            int index;
            int zone = extendedDeclaredZones.head;
            if (zone != -1 && !TapIntList.contains(extraInfoZones, zone) && (index = DataFlowAnalyzer.extendedDeclaredToVectorIndex(zone, kind, vectorMap, symbolTable, calledUnit)) != -1 && !info.get(index)) {
                allTrue = false;
            }
            extendedDeclaredZones = extendedDeclaredZones.tail;
        }
        return allTrue;
    }

    public static boolean zoneIsPointer(int zoneRk, SymbolTable symbolTable, Unit calledUnit) {
        ZoneInfo zoneInfo = DataFlowAnalyzer.extendedDeclaredToZoneInfo(zoneRk, symbolTable, calledUnit);
        return zoneInfo != null && zoneInfo.ptrZoneNb != -1;
    }

    public static int getMapClass(int globalRk, int[] zoneMap) {
        int mapClass;
        for (mapClass = zoneMap.length; mapClass > 0 && globalRk < zoneMap[mapClass - 1]; --mapClass) {
        }
        if (0 < mapClass && mapClass < zoneMap.length) {
            return mapClass;
        }
        return -1;
    }

    public static int[] makeMap3(int nb1, int nb2, int nb3) {
        return new int[]{0, nb1, nb1 + nb2, nb1 + nb2 + nb3};
    }

    public static int[] makeMap3(Unit unit, int zoneKind) {
        return DataFlowAnalyzer.makeMap3(0, 0, unit.publicSymbolTable().declaredZonesNb(zoneKind));
    }

    public static int[] makeMap3(Unit unit, Block block, int zoneKind) {
        return DataFlowAnalyzer.makeMap3(0, 0, block.symbolTable.declaredZonesNb(zoneKind));
    }

    public static int[] makeMap3(SymbolTable symbolTable, int zoneKind) {
        return DataFlowAnalyzer.makeMap3(0, 0, symbolTable.declaredZonesNb(zoneKind));
    }

    public static int[] makeMap4(int nbSE, int nbNP, int nbD, int nbFP) {
        return new int[]{0, nbSE, nbSE + nbNP, nbSE + nbNP + nbD, nbSE + nbNP + nbD + nbFP};
    }

    public static int mapSize(int[] map) {
        return map[map.length - 1];
    }

    protected static int[] changeCommonDeclared(int[] map3, int newNDZ) {
        return new int[]{0, map3[1], map3[2], map3[2] + newNDZ};
    }

    public static String showMap(int[] map) {
        String result = "";
        for (int i = 1; i < map.length; ++i) {
            result = map[i] > map[i - 1] ? result + map[i - 1] + "->" + (map[i] - 1) : result + "()";
            if (i >= map.length - 1) continue;
            result = result + " ";
        }
        return result;
    }

    private static String infoToString(BoolVector info, int[] infoMap, int kind, Unit unit, SymbolTable symbolTable) {
        String kindLetter;
        if (info == null) {
            return "null";
        }
        switch (kind) {
            case 0: {
                kindLetter = "a";
                break;
            }
            case 1: {
                kindLetter = "r";
                break;
            }
            case 2: {
                kindLetter = "i";
                break;
            }
            case 3: {
                kindLetter = "p";
                break;
            }
            default: {
                kindLetter = "?";
            }
        }
        return "[s" + unit.rank() + ':' + kindLetter + "||d" + symbolTable.rank() + ':' + kindLetter + "] " + info.toString(infoMap);
    }

    public static String infoToStringWithDiffPtr(BoolVector info, int[] infoMap, BoolVector infoOnDiffPtr, int[] infoMapOnDiffPtr, Unit unit, SymbolTable symbolTable) {
        String ptrString = "";
        if (infoOnDiffPtr != null) {
            ptrString = " Ptr:" + DataFlowAnalyzer.infoToString(infoOnDiffPtr, infoMapOnDiffPtr, 3, unit, symbolTable);
        }
        return DataFlowAnalyzer.infoToString(info, infoMap, 0, unit, symbolTable) + ptrString;
    }

    public static BoolVector changeKind(BoolVector oldInfo, int[] oldMap, int oldKind, int[] newMap, int newKind, SymbolTable symbolTable) {
        BoolVector newInfo = new BoolVector(DataFlowAnalyzer.mapSize(newMap));
        newInfo.setFalse();
        for (int cls = oldMap.length - 1; cls > 0; --cls) {
            for (int index = oldMap[cls] - 1; index >= oldMap[cls - 1]; --index) {
                int newIndex;
                ZoneInfo zi;
                if (!oldInfo.get(index) || (zi = DataFlowAnalyzer.vectorIndexToZoneInfo(index, cls, oldKind, oldMap, symbolTable)) == null || (newIndex = DataFlowAnalyzer.zoneInfoToVectorIndex(zi, cls, newKind, newMap, null)) < 0) continue;
                newInfo.set(newIndex, true);
            }
        }
        return newInfo;
    }

    public static boolean mayPointToRelocated(Tree expression, boolean onDiff, Instruction instruction, SymbolTable symbolTable, boolean inJointDiffCode) {
        Tree destinationTree = ILUtils.build(151, ILUtils.copy(expression));
        TapIntList destinationZones = ZoneInfo.listAllZones(symbolTable.treeOfZonesOfValue(destinationTree, null, instruction, null), false);
        boolean mayPointToRelocated = false;
        BoolVector constantZones = inJointDiffCode && instruction.block != null ? instruction.block.constantZones : null;
        int[] inOutMap = DataFlowAnalyzer.makeMap3(symbolTable.unit, 0);
        while (!mayPointToRelocated && destinationZones != null) {
            int rk = destinationZones.head;
            ZoneInfo destinationZoneInfo = DataFlowAnalyzer.extendedDeclaredToZoneInfo(rk, symbolTable, null);
            int i = DataFlowAnalyzer.extendedDeclaredToVectorIndex(rk, 0, inOutMap, symbolTable, null);
            if (!(destinationZoneInfo == null || i < 0 || constantZones != null && constantZones.get(i))) {
                mayPointToRelocated = !TapEnv.get().refineADMM || (onDiff ? destinationZoneInfo.relocatedDiff : destinationZoneInfo.relocated);
            }
            destinationZones = destinationZones.tail;
        }
        return mayPointToRelocated;
    }

    protected void run(TapList<Unit> rootUnits) {
        this.runBottomUpAnalysis(rootUnits);
    }

    protected final void runStatically() {
        TapList<Unit> units = this.curCallGraph.sortedComputationalUnits();
        while (units != null) {
            this.setCurUnitEtc((Unit)units.head);
            if (this.curUnit.hasSource()) {
                this.analyze();
            }
            units = units.tail;
        }
        this.setCurUnitEtc(null);
    }

    protected final void runTopDownAnalysis(TapList<Unit> rootUnits) {
        TapList<Unit> allCallees;
        Chrono totalAnalysisTimer = new Chrono();
        TapList<Unit> units = allCallees = rootUnits == null ? this.curCallGraph.sortedComputationalUnits() : Unit.allCalleesMulti(rootUnits);
        this.topDownContexts = new UnitStorage(this.curCallGraph);
        this.unitAnalysisTimer.reset();
        while (units != null) {
            this.setCurUnitEtc((Unit)units.head);
            this.curUnit.isCGCycle = DataFlowAnalyzer.isCGCycleTail(this.curUnit);
            this.setTopDownContext(this.curUnit, this.initializeCGForUnit());
            this.curUnit.analysisIsOutOfDateDown = true;
            units = units.tail;
        }
        while (rootUnits != null) {
            this.setCurUnitEtc((Unit)rootUnits.head);
            this.initializeCGForRootUnit();
            rootUnits = rootUnits.tail;
        }
        TapEnv.printlnOnTrace(15, "@@ " + this.curAnalysisName + " initialization (" + this.unitAnalysisTimer.elapsed() + " s)");
        boolean runAgainCG = true;
        while (runAgainCG) {
            runAgainCG = false;
            units = allCallees;
            while (!runAgainCG && units != null) {
                this.setCurUnitEtc((Unit)units.head);
                if (this.curUnit.analysisIsOutOfDateDown) {
                    this.curUnit.analysisIsOutOfDateDown = false;
                    if (this.curUnit.hasSource()) {
                        TapEnv.printOnTrace(15, "@@ " + this.curAnalysisName + " for unit " + this.curUnit.name() + " ");
                        this.sweeps = 0;
                        this.unitAnalysisTimer.reset();
                    }
                    this.analyze();
                    runAgainCG = this.calleeOutOfDateBefore(allCallees, this.curUnit);
                    if (this.curUnit.hasSource()) {
                        TapEnv.printlnOnTrace(15, "  " + this.sweeps + " sweeps, " + this.unitAnalysisTimer.elapsed() + " s");
                    }
                }
                units = units.tail;
            }
        }
        units = allCallees;
        while (units != null) {
            this.setCurUnitEtc((Unit)units.head);
            if (this.curUnit.hasSource()) {
                this.terminateCGForUnit();
            }
            units = units.tail;
        }
        TapEnv.printlnOnTrace(10, "@@ " + this.curAnalysisName + " total time " + totalAnalysisTimer.elapsed() + " s");
        this.setCurUnitEtc(null);
    }

    protected final void runBottomUpAnalysis(TapList<Unit> rootUnits) {
        TapList<Unit> allCalleesReverse;
        Chrono totalAnalysisTimer = new Chrono();
        TapList<Unit> units = allCalleesReverse = TapList.reverse(rootUnits == null ? this.curCallGraph.sortedComputationalUnits() : Unit.allCalleesMulti(rootUnits));
        this.unitAnalysisTimer.reset();
        while (units != null) {
            this.setCurUnitEtc((Unit)units.head);
            this.curUnit.isCGCycle = DataFlowAnalyzer.isCGCycleHead(this.curUnit);
            this.initializeCGForUnit();
            this.curUnit.analysisIsOutOfDateUp = true;
            units = units.tail;
        }
        TapEnv.printlnOnTrace(15, "@@ " + this.curAnalysisName + " initialization (" + this.unitAnalysisTimer.elapsed() + " s)");
        boolean runAgainCG = true;
        while (runAgainCG) {
            runAgainCG = false;
            units = allCalleesReverse;
            while (!runAgainCG && units != null) {
                this.setCurUnitEtc((Unit)units.head);
                if (this.curUnit.analysisIsOutOfDateUp && this.curUnit.hasSource()) {
                    TapEnv.printOnTrace(15, "@@ " + this.curAnalysisName + " for unit " + this.curUnit.name() + " ");
                    this.curUnit.analysisIsOutOfDateUp = false;
                    this.sweeps = 0;
                    this.unitAnalysisTimer.reset();
                    if (this.analyze()) {
                        DataFlowAnalyzer.markCallersOutOfDate(this.curUnit);
                        runAgainCG = this.curUnit.isCGCycle;
                        if (!runAgainCG) {
                            runAgainCG = this.mpiRecvOutOfDate();
                        }
                    }
                    TapEnv.printlnOnTrace(15, " : " + this.sweeps + " sweeps, " + this.unitAnalysisTimer.elapsed() + " s");
                }
                units = units.tail;
            }
        }
        units = allCalleesReverse;
        while (units != null) {
            this.setCurUnitEtc((Unit)units.head);
            if (this.curUnit.hasSource()) {
                this.terminateCGForUnit();
            }
            units = units.tail;
        }
        TapEnv.printlnOnTrace(10, "@@ " + this.curAnalysisName + " total time " + totalAnalysisTimer.elapsed() + " s");
        this.setCurUnitEtc(null);
    }

    protected final void runBottomUpTopDownAnalysis(TapList<Unit> rootUnits) {
        Chrono totalAnalysisTimer = new Chrono();
        TapList<Unit> allCalleesDown = rootUnits == null ? this.curCallGraph.sortedComputationalUnits() : Unit.allCalleesMulti(rootUnits);
        TapList<Unit> allCalleesUp = TapList.reverse(allCalleesDown);
        this.unitAnalysisTimer.reset();
        this.topDownContexts = new UnitStorage(this.curCallGraph);
        TapList<Unit> units = allCalleesDown;
        while (units != null) {
            this.setCurUnitEtc((Unit)units.head);
            this.setTopDownContext(this.curUnit, this.initializeCGForUnit());
            this.curUnit.analysisIsOutOfDateUp = true;
            this.curUnit.analysisIsOutOfDateDown = false;
            units = units.tail;
        }
        while (rootUnits != null) {
            this.setCurUnitEtc((Unit)rootUnits.head);
            this.initializeCGForRootUnit();
            rootUnits = rootUnits.tail;
            this.curUnit.analysisIsOutOfDateDown = true;
        }
        TapEnv.printlnOnTrace(15, "@@ " + this.curAnalysisName + " initialization (" + this.unitAnalysisTimer.elapsed() + " s)");
        boolean runAgainCG2 = true;
        while (runAgainCG2) {
            runAgainCG2 = false;
            boolean runAgainCG = true;
            while (runAgainCG) {
                runAgainCG = false;
                units = allCalleesUp;
                while (!runAgainCG && units != null) {
                    if (((Unit)units.head).analysisIsOutOfDateUp && ((Unit)units.head).hasSource()) {
                        this.setCurUnitEtc((Unit)units.head);
                        TapEnv.printOnTrace(15, "@@ Bottom-up " + this.curAnalysisName + " for unit " + this.curUnit.name() + " ");
                        this.curUnit.analysisIsOutOfDateUp = false;
                        this.sweeps = 0;
                        this.unitAnalysisTimer.reset();
                        if (this.analyzeInBottomUp()) {
                            DataFlowAnalyzer.markCallersOutOfDate(this.curUnit);
                            runAgainCG = this.curUnit.isCGCycle;
                            if (!runAgainCG) {
                                runAgainCG = this.mpiRecvOutOfDate();
                            }
                        }
                        this.curUnit.analysisIsOutOfDateDown = true;
                        TapEnv.printlnOnTrace(15, "  " + this.sweeps + " sweeps, " + this.unitAnalysisTimer.elapsed() + " s");
                    }
                    units = units.tail;
                }
            }
            runAgainCG = true;
            while (runAgainCG) {
                runAgainCG = false;
                units = allCalleesDown;
                while (!runAgainCG && units != null) {
                    if (((Unit)units.head).analysisIsOutOfDateDown && ((Unit)units.head).hasSource()) {
                        this.setCurUnitEtc((Unit)units.head);
                        TapEnv.printOnTrace(15, "@@ Top-down " + this.curAnalysisName + " for unit " + this.curUnit.name() + " ");
                        this.curUnit.analysisIsOutOfDateDown = false;
                        this.sweeps = 0;
                        this.unitAnalysisTimer.reset();
                        if (this.analyzeInTopDown()) {
                            DataFlowAnalyzer.markCallersOutOfDate(this.curUnit);
                            runAgainCG2 = true;
                        } else {
                            runAgainCG = this.calleeOutOfDateBefore(allCalleesDown, this.curUnit);
                        }
                        TapEnv.printlnOnTrace(15, "  " + this.sweeps + " sweeps, " + this.unitAnalysisTimer.elapsed() + " s");
                    }
                    units = units.tail;
                }
            }
        }
        units = allCalleesDown;
        while (units != null) {
            if (((Unit)units.head).hasSource()) {
                this.setCurUnitEtc((Unit)units.head);
                this.terminateCGForUnit();
            }
            units = units.tail;
        }
        TapEnv.printlnOnTrace(10, "@@ " + this.curAnalysisName + " total time " + totalAnalysisTimer.elapsed() + " s");
        this.setCurUnitEtc(null);
    }

    private void showState(TapList<Unit> allUnits, Unit cU, boolean bottomup) {
        String line = "";
        while (allUnits != null) {
            Unit uu = (Unit)allUnits.head;
            line = uu.analysisIsOutOfDateUp ? line + (uu == cU ? "U" : ">") : (uu.analysisIsOutOfDateDown ? line + (uu == cU ? "D" : "<") : line + ".");
            allUnits = allUnits.tail;
        }
        System.out.println("TBRSTATE:" + line);
    }

    protected boolean analyzeInBottomUp() {
        return false;
    }

    protected boolean analyzeInTopDown() {
        return false;
    }

    protected boolean analyze() {
        return this.analyzeForward(null, null, null);
    }

    public final boolean analyzeStatically(TapList<Block> initBlocks, TapList<Block> insideBlocks) {
        boolean hasChanged = false;
        if (this.curUnit.hasSource()) {
            if (insideBlocks == null) {
                insideBlocks = this.curUnit.allBlocks;
            }
            this.initializeUnit();
            TapList<Block> blockS = initBlocks;
            while (blockS != null) {
                this.setCurBlockEtc((Block)blockS.head);
                this.initializeInitBlock();
                blockS = blockS.tail;
            }
            blockS = insideBlocks;
            while (blockS != null) {
                this.setCurBlockEtc((Block)blockS.head);
                blockS = blockS.tail;
                this.propagateValuesStaticallyThroughBlock();
            }
            ++this.sweeps;
            hasChanged = this.terminateUnit();
            this.setCurBlockEtc(null);
        }
        return hasChanged;
    }

    public final boolean analyzeForward(TapList<FGArrow> entryArrows, TapList<Block> insideBlocks, TapList<FGArrow> exitArrows) {
        if (this.curUnit.hasSource()) {
            Chrono unitInitializationTimer = new Chrono();
            boolean analyzeFullUnit = entryArrows == null && insideBlocks == null && exitArrows == null;
            TapList<Block> initBlocks = entryArrows == null ? new TapList<EntryBlock>(this.curUnit.entryBlock(), null) : this.mapOrigin(entryArrows);
            if (insideBlocks == null) {
                insideBlocks = this.curUnit.allBlocks;
            }
            TapList<Block> termBlocks = exitArrows == null ? new TapList<ExitBlock>(this.curUnit.exitBlock(), null) : this.mapDestination(exitArrows);
            this.initializeUnit();
            TapList<Block> blockS = initBlocks;
            while (blockS != null) {
                this.setCurBlockEtc((Block)blockS.head);
                this.initializeInitBlock();
                blockS = blockS.tail;
            }
            blockS = insideBlocks;
            while (blockS != null) {
                this.setCurBlockEtc((Block)blockS.head);
                this.initializeFGForBlock();
                this.curBlock.analysisIsOutOfDate = true;
                blockS = blockS.tail;
            }
            TapEnv.printOnTrace(20, " (init " + unitInitializationTimer.elapsed() + " s) ");
            boolean runAgainFG = true;
            while (runAgainFG) {
                TapEnv.printOnTrace(20, "|");
                runAgainFG = false;
                ++this.sweeps;
                blockS = insideBlocks;
                while (!runAgainFG && blockS != null) {
                    this.setCurBlockEtc((Block)blockS.head);
                    blockS = blockS.tail;
                    if (!this.curBlock.analysisIsOutOfDate) continue;
                    this.curBlock.analysisIsOutOfDate = false;
                    if (!this.accumulateValuesFromUpstream()) continue;
                    if (this.compareUpstreamValues()) {
                        TapEnv.printOnTrace(20, "o");
                        if (!this.propagateValuesForwardThroughBlock()) continue;
                        if (this.compareDownstreamValues()) {
                            DataFlowAnalyzer.markFlowOutOfDate(this.curBlock.flow(), exitArrows);
                            if (this.curBlock.isFGCycleTail) {
                                runAgainFG = true;
                            }
                        }
                        if (!this.compareDownstreamChannelValuesWithInitial(initBlocks)) continue;
                        DataFlowAnalyzer.markFlowOutOfDate(entryArrows == null ? this.curUnit.entryBlock().flow() : entryArrows, exitArrows);
                        runAgainFG = true;
                        continue;
                    }
                    TapEnv.printOnTrace(20, ".");
                }
            }
            TapEnv.printOnTrace(20, "| ");
            blockS = insideBlocks;
            while (blockS != null) {
                this.setCurBlockEtc((Block)blockS.head);
                this.terminateFGForBlock();
                blockS = blockS.tail;
            }
            blockS = termBlocks;
            while (blockS != null) {
                this.setCurBlockEtc((Block)blockS.head);
                if (!TapList.contains(insideBlocks, this.curBlock)) {
                    if (this.accumulateValuesFromUpstream()) {
                        this.compareUpstreamValues();
                    }
                    this.terminateTermBlock();
                }
                blockS = blockS.tail;
            }
            this.setCurBlockEtc(null);
            if (analyzeFullUnit) {
                this.setCurBlockEtc(this.curUnit.exitBlock());
                boolean hasChanged = this.terminateUnit();
                this.setCurBlockEtc(null);
                return hasChanged;
            }
            return false;
        }
        return false;
    }

    public final boolean analyzeBackward(TapList<FGArrow> entryArrows, TapList<Block> insideBlocks, TapList<FGArrow> exitArrows) {
        if (this.curUnit.hasSource()) {
            Chrono unitInitializationTimer = new Chrono();
            boolean analyzeFullUnit = entryArrows == null && insideBlocks == null && exitArrows == null;
            TapList<Block> initBlocks = exitArrows == null ? new TapList<ExitBlock>(this.curUnit.exitBlock(), null) : this.mapDestination(exitArrows);
            if (insideBlocks == null) {
                insideBlocks = this.curUnit.allBlocks;
            }
            TapList<Block> termBlocks = entryArrows == null ? new TapList<EntryBlock>(this.curUnit.entryBlock(), null) : this.mapOrigin(entryArrows);
            insideBlocks = TapList.reverse(insideBlocks);
            this.initializeUnit();
            TapList<Block> blockS = insideBlocks;
            while (blockS != null) {
                this.setCurBlockEtc((Block)blockS.head);
                this.initializeFGForBlock();
                this.curBlock.analysisIsOutOfDate = true;
                blockS = blockS.tail;
            }
            blockS = initBlocks;
            while (blockS != null) {
                this.setCurBlockEtc((Block)blockS.head);
                this.initializeInitBlock();
                blockS = blockS.tail;
            }
            TapEnv.printOnTrace(20, " (init " + unitInitializationTimer.elapsed() + " s) ");
            boolean runAgainFG = true;
            while (runAgainFG) {
                TapEnv.printOnTrace(20, "|");
                runAgainFG = false;
                ++this.sweeps;
                blockS = insideBlocks;
                while (!runAgainFG && blockS != null) {
                    this.setCurBlockEtc((Block)blockS.head);
                    blockS = blockS.tail;
                    if (!this.curBlock.analysisIsOutOfDate) continue;
                    this.curBlock.analysisIsOutOfDate = false;
                    if (!this.accumulateValuesFromDownstream()) continue;
                    if (this.compareDownstreamValues()) {
                        TapEnv.printOnTrace(20, "o");
                        if (!this.propagateValuesBackwardThroughBlock()) continue;
                        if (this.compareUpstreamValues()) {
                            DataFlowAnalyzer.markBackFlowOutOfDate(this.curBlock.backFlow(), entryArrows);
                            if (this.curBlock.isFGCycleHead) {
                                runAgainFG = true;
                            }
                        }
                        if (!this.compareUpstreamChannelValuesWithInitial(initBlocks)) continue;
                        DataFlowAnalyzer.markBackFlowOutOfDate(exitArrows == null ? this.curUnit.exitBlock().backFlow() : exitArrows, entryArrows);
                        runAgainFG = true;
                        continue;
                    }
                    TapEnv.printOnTrace(20, ".");
                }
            }
            TapEnv.printOnTrace(20, "| ");
            blockS = insideBlocks;
            while (blockS != null) {
                this.setCurBlockEtc((Block)blockS.head);
                this.terminateFGForBlock();
                blockS = blockS.tail;
            }
            blockS = termBlocks;
            while (blockS != null) {
                this.setCurBlockEtc((Block)blockS.head);
                if (!TapList.contains(insideBlocks, this.curBlock)) {
                    if (this.accumulateValuesFromDownstream()) {
                        this.compareDownstreamValues();
                    }
                    this.terminateTermBlock();
                }
                blockS = blockS.tail;
            }
            this.setCurBlockEtc(null);
            if (analyzeFullUnit) {
                this.setCurBlockEtc(this.curUnit.entryBlock());
                boolean hasChanged = this.terminateUnit();
                this.setCurBlockEtc(null);
                return hasChanged;
            }
            return false;
        }
        return false;
    }

    public void setCurUnitEtc(Unit unit) {
        this.curUnit = unit;
        if (this.curUnit != null) {
            TapEnv.setRelatedUnit(this.curUnit);
        }
        TapEnv.setTraceCurAnalysis(this.tracedUnits != null && (this.tracedUnits.head == null || this.curUnit != null && TapList.contains(this.tracedUnits, this.curUnit)));
        if (this.curUnit == null) {
            this.setCurBlockEtc(null);
        }
    }

    protected Object initializeCGForUnit() {
        TapEnv.printlnOnTrace(15, this.curAnalysisName + " calling default empty initializeCGForUnit()");
        return null;
    }

    protected void initializeCGForRootUnit() {
        TapEnv.printlnOnTrace(15, this.curAnalysisName + " calling default empty initializeCGForRootUnit()");
    }

    protected void initializeUnit() {
        TapEnv.printlnOnTrace(15, this.curAnalysisName + " calling default empty initializeUnit()");
    }

    protected void initializeInitBlock() {
        TapEnv.printlnOnTrace(15, this.curAnalysisName + " calling default empty initializeInitBlock()");
    }

    protected void setCurBlockEtc(Block block) {
        this.curBlock = block == null && this.curUnit != null && this.curUnit.publicSymbolTable() != null ? this.curUnit.entryBlock() : block;
        this.curSymbolTable = this.curBlock == null ? (this.curUnit == null ? null : this.curUnit.publicSymbolTable()) : this.curBlock.symbolTable;
        this.nDZ = this.curSymbolTable == null ? -9 : this.curSymbolTable.declaredZonesNb(0);
    }

    protected void initializeFGForBlock() {
    }

    protected boolean accumulateValuesFromUpstream() {
        TapList<FGArrow> arrows = this.curBlock.backFlow();
        boolean runSpecialCycleAnalysis = DataFlowAnalyzer.runSpecialCycleAnalysis(this.curBlock);
        boolean somethingFlows = false;
        this.setEmptyCumulAndCycleValues();
        while (arrows != null) {
            this.curArrow = (FGArrow)arrows.head;
            if (this.getValueFlowingThrough()) {
                somethingFlows = true;
                if (runSpecialCycleAnalysis && this.curArrow.inACycle) {
                    this.cumulCycleValueWithAdditional(this.curSymbolTable.getCommonRoot(this.curArrow.origin.symbolTable));
                } else {
                    this.cumulValueWithAdditional(this.curSymbolTable.getCommonRoot(this.curArrow.origin.symbolTable));
                }
            }
            arrows = arrows.tail;
        }
        return somethingFlows;
    }

    protected boolean accumulateValuesFromDownstream() {
        TapList<FGArrow> arrows = this.curBlock.flow();
        boolean runSpecialCycleAnalysis = DataFlowAnalyzer.runSpecialCycleAnalysis(this.curBlock);
        boolean somethingFlows = false;
        this.setEmptyCumulAndCycleValues();
        if (arrows != null) {
            while (arrows != null) {
                this.curArrow = (FGArrow)arrows.head;
                if (this.getValueFlowingBack()) {
                    somethingFlows = true;
                    if (runSpecialCycleAnalysis && this.curArrow.containsCase(1)) {
                        this.cumulCycleValueWithAdditional(this.curSymbolTable.getCommonRoot(this.curArrow.destination.symbolTable));
                    } else {
                        this.cumulValueWithAdditional(this.curSymbolTable.getCommonRoot(this.curArrow.destination.symbolTable));
                    }
                }
                arrows = arrows.tail;
            }
        } else {
            this.initializeCumulValue();
            somethingFlows = true;
        }
        return somethingFlows;
    }

    protected void setEmptyCumulAndCycleValues() {
        TapEnv.printlnOnTrace(20, this.curAnalysisName + " calling default empty setEmptyCumulAndCycleValues()");
    }

    protected boolean getValueFlowingThrough() {
        TapEnv.printlnOnTrace(20, this.curAnalysisName + " calling default empty getValueFlowingThrough()");
        return false;
    }

    protected boolean getValueFlowingBack() {
        TapEnv.printlnOnTrace(20, this.curAnalysisName + " calling default empty getValueFlowingBack()");
        return false;
    }

    protected void cumulValueWithAdditional(SymbolTable commonSymbolTable) {
        TapEnv.printlnOnTrace(20, this.curAnalysisName + " calling default empty cumulValueWithAdditional()");
    }

    protected void cumulCycleValueWithAdditional(SymbolTable commonSymbolTable) {
        TapEnv.printlnOnTrace(20, this.curAnalysisName + " calling default empty cumulCycleValueWithAdditional()");
    }

    protected void initializeCumulValue() {
        TapEnv.printlnOnTrace(20, this.curAnalysisName + " calling default empty initializeCumulValue()");
    }

    protected boolean compareUpstreamValues() {
        TapEnv.printlnOnTrace(20, this.curAnalysisName + " calling default empty compareUpstreamValues()");
        return false;
    }

    protected boolean compareUpstreamChannelValuesWithInitial(TapList<Block> initBlocks) {
        boolean initHasIncreased = false;
        TapIntList allMessagePassingChannelZones = this.curCallGraph.getAllMessagePassingChannelZones();
        while (initBlocks != null) {
            Block initBlock = (Block)initBlocks.head;
            TapIntList inAllChannelZones = allMessagePassingChannelZones;
            while (inAllChannelZones != null) {
                if (this.compareChannelZoneDataUpstream(inAllChannelZones.head, initBlock)) {
                    initHasIncreased = true;
                }
                inAllChannelZones = inAllChannelZones.tail;
            }
            initBlocks = initBlocks.tail;
        }
        return initHasIncreased;
    }

    protected boolean compareChannelZoneDataUpstream(int mpZone, Block refBlock) {
        TapEnv.printlnOnTrace(20, this.curAnalysisName + " calling default empty compareChannelZoneDataUpstream()");
        return false;
    }

    private boolean compareDownstreamChannelValuesWithInitial(TapList<Block> initBlocks) {
        boolean initHasIncreased = false;
        TapIntList allMessagePassingChannelZones = this.curCallGraph.getAllMessagePassingChannelZones();
        while (initBlocks != null) {
            Block initBlock = (Block)initBlocks.head;
            TapIntList inAllChannelZones = allMessagePassingChannelZones;
            while (inAllChannelZones != null) {
                if (this.compareChannelZoneDataDownstream(inAllChannelZones.head, initBlock)) {
                    initHasIncreased = true;
                }
                inAllChannelZones = inAllChannelZones.tail;
            }
            initBlocks = initBlocks.tail;
        }
        return initHasIncreased;
    }

    protected boolean compareChannelZoneDataDownstream(int mpZone, Block refBlock) {
        TapEnv.printlnOnTrace(20, this.curAnalysisName + " calling default empty compareChannelZoneDataDownstream()");
        return false;
    }

    protected boolean compareDownstreamValues() {
        TapEnv.printlnOnTrace(20, this.curAnalysisName + " calling default empty compareDownstreamValues()");
        return false;
    }

    protected boolean compareWithStorage(BoolVector newInfo, BoolVector newInfoCycle, int length, BlockStorage<BoolVector> storedInfos, BlockStorage<BoolVector> storedInfosCycle) {
        boolean modified = false;
        BoolVector oldInfo = storedInfos.retrieve(this.curBlock);
        if (!(newInfo == null || oldInfo != null && newInfo.equals(oldInfo, length))) {
            modified = true;
            storedInfos.store(this.curBlock, newInfo.copy());
        }
        if (DataFlowAnalyzer.runSpecialCycleAnalysis(this.curBlock)) {
            oldInfo = storedInfosCycle.retrieve(this.curBlock);
            if (!(newInfoCycle == null || oldInfo != null && newInfoCycle.equals(oldInfo, length))) {
                modified = true;
                storedInfosCycle.store(this.curBlock, newInfoCycle.copy());
            }
        }
        return modified;
    }

    protected boolean compareWithStorage(BoolVector newInfo, BoolVector newInfoOnDiffPtr, BoolVector newInfoCycle, BoolVector newInfoCycleOnDiffPtr, int length, int lengthOnDiffPtr, BlockStorage<TapPair<BoolVector, BoolVector>> storedInfos, BlockStorage<TapPair<BoolVector, BoolVector>> storedInfosCycle) {
        boolean modified = false;
        TapPair<BoolVector, BoolVector> oldInfo = storedInfos.retrieve(this.curBlock);
        if (newInfo != null || newInfoOnDiffPtr != null) {
            if (oldInfo == null) {
                oldInfo = new TapPair<Object, Object>(null, null);
                storedInfos.store(this.curBlock, oldInfo);
            }
            if (!(newInfo == null || oldInfo.first != null && newInfo.equals((BoolVector)oldInfo.first, length))) {
                modified = true;
                oldInfo.first = newInfo.copy();
            }
            if (!(newInfoOnDiffPtr == null || oldInfo.second != null && newInfoOnDiffPtr.equals((BoolVector)oldInfo.second, lengthOnDiffPtr))) {
                modified = true;
                oldInfo.second = newInfoOnDiffPtr.copy();
            }
        }
        if (DataFlowAnalyzer.runSpecialCycleAnalysis(this.curBlock)) {
            oldInfo = storedInfosCycle.retrieve(this.curBlock);
            if (newInfoCycle != null || newInfoCycleOnDiffPtr != null) {
                if (oldInfo == null) {
                    oldInfo = new TapPair<Object, Object>(null, null);
                    storedInfosCycle.store(this.curBlock, oldInfo);
                }
                if (!(newInfoCycle == null || oldInfo.first != null && newInfoCycle.equals((BoolVector)oldInfo.first, length))) {
                    modified = true;
                    oldInfo.first = newInfoCycle.copy();
                }
                if (!(newInfoCycleOnDiffPtr == null || oldInfo.second != null && newInfoCycleOnDiffPtr.equals((BoolVector)oldInfo.second, lengthOnDiffPtr))) {
                    modified = true;
                    oldInfo.second = newInfoCycleOnDiffPtr.copy();
                }
            }
        }
        return modified;
    }

    protected void propagateValuesStaticallyThroughBlock() {
        TapList<Instruction> instructions = this.curBlock.instructions;
        while (instructions != null) {
            this.curInstruction = (Instruction)instructions.head;
            this.propagateValuesStaticallyThroughExpression();
            instructions = instructions.tail;
        }
        this.curInstruction = null;
    }

    protected boolean propagateValuesForwardThroughBlock() {
        TapList<Instruction> instructions = this.curBlock.instructions;
        boolean arrives = true;
        while (arrives && instructions != null) {
            this.curInstruction = (Instruction)instructions.head;
            arrives = this.propagateValuesForwardThroughExpression();
            instructions = instructions.tail;
        }
        this.curInstruction = null;
        return arrives;
    }

    protected void propagateValuesStaticallyThroughExpression() {
        TapEnv.printlnOnTrace(20, this.curAnalysisName + " calling default empty propagateValuesStaticallyThroughExpression() on " + this.curInstruction);
    }

    protected boolean propagateValuesForwardThroughExpression() {
        TapEnv.printlnOnTrace(20, this.curAnalysisName + " calling default empty propagateValuesForwardThroughExpression()");
        return true;
    }

    protected boolean propagateValuesBackwardThroughBlock() {
        TapList<Instruction> instructions = TapList.reverse(this.curBlock.instructions);
        boolean arrives = true;
        while (arrives && instructions != null) {
            this.curInstruction = (Instruction)instructions.head;
            arrives = this.propagateValuesBackwardThroughExpression();
            instructions = instructions.tail;
        }
        this.curInstruction = null;
        return arrives;
    }

    protected boolean propagateValuesBackwardThroughExpression() {
        TapEnv.printlnOnTrace(20, this.curAnalysisName + " calling default empty propagateValuesBackwardThroughExpression()");
        return true;
    }

    protected void terminateFGForBlock() {
    }

    protected void terminateTermBlock() {
    }

    protected boolean terminateUnit() {
        TapEnv.printlnOnTrace(15, this.curAnalysisName + " calling default empty terminateUnit()");
        return true;
    }

    protected void terminateCGForUnit() {
    }

    private boolean calleeOutOfDateAbove(Unit unit) {
        boolean result = false;
        TapList<CallArrow> arrows = unit.callees();
        while (!result && arrows != null) {
            Unit callee = ((CallArrow)arrows.head).destination;
            result = callee.rank() >= 0 && callee.rank() <= unit.rank() && callee.analysisIsOutOfDateDown;
            arrows = arrows.tail;
        }
        if (!result && this.curCallGraph.MPIRecvCalls != null) {
            result = this.mpiRecvOutOfDate();
        }
        return result;
    }

    private boolean calleeOutOfDateBefore(TapList<Unit> allCallees, Unit unit) {
        boolean outOfDate = false;
        while (!outOfDate && allCallees != null && allCallees.head != unit) {
            outOfDate = ((Unit)allCallees.head).analysisIsOutOfDateDown;
            allCallees = allCallees.tail;
        }
        if (!outOfDate) {
            outOfDate = unit.analysisIsOutOfDateDown;
        }
        if (!outOfDate && this.curCallGraph.MPIRecvCalls != null) {
            outOfDate = this.mpiRecvOutOfDate();
        }
        return outOfDate;
    }

    private boolean mpiRecvOutOfDate() {
        boolean outOfDate = false;
        TapList<Unit> recvUnits = this.curCallGraph.MPIRecvCalls;
        while (!outOfDate && recvUnits != null) {
            outOfDate = ((Unit)recvUnits.head).analysisIsOutOfDateDown;
            recvUnits = recvUnits.tail;
        }
        return outOfDate;
    }

    public BoolMatrix propagateUnitDataOutside(BoolMatrix privateData, int whichKind) {
        BoolMatrix publicData;
        int nbRows = this.curUnit.translator.length;
        BoolMatrix transferMatrix = this.curUnit.transferMatrix(whichKind);
        if (transferMatrix == null) {
            publicData = this.curUnit.transferTransposed(privateData, whichKind);
            publicData = this.curUnit.transferTransposed(publicData, whichKind);
        } else {
            publicData = transferMatrix.timesTransposed(privateData);
            publicData = transferMatrix.timesTransposed(publicData);
        }
        int nbCols = this.curUnit.publicSymbolTable().declaredZonesNb(whichKind);
        BoolVector rowi = null;
        TapIntList sparseRowi = null;
        for (int i = nbRows - 1; i >= 0; --i) {
            boolean allImplicitIdentity = true;
            if (transferMatrix == null) {
                PublicInfo publicInfo = this.curUnit.translator[i];
                sparseRowi = publicInfo.ranks(whichKind);
            } else {
                rowi = transferMatrix.getRow(i);
            }
            for (int j = nbCols - 1; j >= 0 && allImplicitIdentity; --j) {
                if (privateData.getRow(j) == null || !(transferMatrix == null ? TapIntList.contains(sparseRowi, j) : rowi.get(j))) continue;
                allImplicitIdentity = false;
            }
            if (!allImplicitIdentity) continue;
            publicData.setIdentityRow(i);
        }
        return publicData;
    }

    public BoolVector propagateUnitDataInside(BoolVector publicData, int whichKind, int[] vectorMap) {
        BoolVector result = new BoolVector(DataFlowAnalyzer.mapSize(vectorMap));
        for (int i = this.curUnit.translator.length - 1; i >= 0; --i) {
            if (!publicData.get(i)) continue;
            PublicInfo publicInfo = this.curUnit.translator[i];
            result.set(this.mapZoneRkToVectorIndex(publicInfo.ranks(whichKind), 3, whichKind, vectorMap), true);
        }
        return result;
    }

    public BoolMatrix propagateEntryDataFwdToCallee(BoolMatrix privateDataInTransit, int[] privateRowMap, TapList[] actualParamDataS, BoolVector publicTouched, CallArrow arrow, Tree[] actualParamTreeS, int whichKind, boolean transit) {
        int i;
        TapList[] actualParamZonesTreeS = new TapList[actualParamDataS.length];
        boolean[] actualParamTotalS = new boolean[actualParamDataS.length];
        BoolVector publicZonesPossiblyRorW = arrow.destination.getTmpALLKINDPossiblyRoW();
        if (transit) {
            ToBool total = new ToBool();
            for (int i2 = actualParamTreeS.length - 1; i2 >= 0; --i2) {
                TapList<?> actualParamZonesTree = this.curSymbolTable.treeOfZonesOfValue(actualParamTreeS[i2], total, this.curInstruction, null);
                if (actualParamZonesTree != null) {
                    actualParamZonesTree = TapList.copyTree(actualParamZonesTree);
                    this.includePointedElementsInTree(actualParamZonesTree, total, null, true, false, true);
                    if (arrow.takesArgumentByValue(i2 + 1)) {
                        DataFlowAnalyzer.removeInfoOnTopLevel(actualParamZonesTree);
                    }
                    actualParamTotalS[i2] = this.referenceIsTotal(total.get(), actualParamZonesTree);
                } else {
                    actualParamTotalS[i2] = false;
                }
                actualParamZonesTreeS[i2] = actualParamZonesTree;
            }
        }
        BoolVector transitOutsideCall = new BoolVector(DataFlowAnalyzer.mapSize(privateRowMap));
        transitOutsideCall.setTrue();
        BoolMatrix publicEntryData = new BoolMatrix(arrow.translator.length, privateDataInTransit.nCols);
        publicEntryData.rows = new BoolVector[arrow.translator.length];
        for (i = arrow.translator.length - 1; i >= 0; --i) {
            PublicInfo publicZoneInfo = arrow.translator[i];
            BoolVector publicZoneData = new BoolVector(privateDataInTransit.nCols);
            if (publicZoneInfo != null) {
                boolean totallyAffected;
                TapIntList callerAccessedIndices = null;
                boolean maybeAffectedByCall = transit && (publicTouched == null || publicTouched.get(i));
                switch (publicZoneInfo.kind()) {
                    case 10: {
                        break;
                    }
                    case 7: {
                        if (publicZoneInfo.getParamRank() == 0) {
                            callerAccessedIndices = DataFlowAnalyzer.getIndicesAccessedInCaller(publicZoneInfo.ranks(0), 3, whichKind, privateRowMap, this.curInstruction, this.curCalledUnit);
                            break;
                        }
                        if (publicZoneInfo.getParamRank() > actualParamTreeS.length || !publicZonesPossiblyRorW.get(i)) break;
                        TapList<?> actualParamElement = TapList.getSetFieldLocation(actualParamZonesTreeS[publicZoneInfo.getParamRank() - 1], publicZoneInfo.zone.accessTree, false);
                        TapList<?> toLocation = TapList.getSetFieldLocation(actualParamDataS[publicZoneInfo.getParamRank() - 1], publicZoneInfo.zone.accessTree, false);
                        DataFlowAnalyzer.cumulOr(toLocation, publicZoneData, publicZoneInfo.coversFurther);
                        if (!maybeAffectedByCall || !actualParamTotalS[publicZoneInfo.getParamRank() - 1] || actualParamElement == null || actualParamElement.head instanceof TapList) break;
                        this.setExtendedDeclared(transitOutsideCall, privateRowMap, whichKind, ZoneInfo.listAllZones(actualParamElement, false), false);
                        break;
                    }
                    default: {
                        callerAccessedIndices = DataFlowAnalyzer.getIndicesAccessedInCaller(publicZoneInfo.ranks(0), 3, whichKind, privateRowMap, this.curInstruction, this.curCalledUnit);
                    }
                }
                boolean bl = totallyAffected = callerAccessedIndices != null && callerAccessedIndices.tail == null;
                while (callerAccessedIndices != null) {
                    int index = callerAccessedIndices.head;
                    BoolVector privateZoneData = privateDataInTransit.getExplicitRow(index);
                    publicZoneData.cumulOr(privateZoneData);
                    if (maybeAffectedByCall && totallyAffected) {
                        transitOutsideCall.set(index, false);
                    }
                    callerAccessedIndices = callerAccessedIndices.tail;
                }
            }
            publicEntryData.setRow(i, publicZoneData);
        }
        if (transit) {
            for (i = privateDataInTransit.nRows - 1; i >= 0; --i) {
                if (transitOutsideCall.get(i)) continue;
                privateDataInTransit.setExplicitZeroRow(i);
            }
        }
        return publicEntryData;
    }

    public BoolMatrix propagateExitDataBwdToCallee(BoolMatrix privateDataInTransit, int[] privateRowMap, int whichKind, TapList resultData, Tree[] actualParamTreeS, CallArrow arrow, boolean diffMaybePassedByRef, boolean transit, BoolVector publicTouched) {
        int i;
        TapList[] actualParamZonesTreeS = new TapList[actualParamTreeS.length];
        boolean[] actualParamTotalS = new boolean[actualParamTreeS.length];
        BoolVector publicZonesPossiblyRorW = arrow.destination.getTmpALLKINDPossiblyRoW();
        ToBool total = new ToBool();
        Unit calledUnit = arrow.destination;
        int nbFormalParams = calledUnit.formalArgumentsNb();
        for (int i2 = Math.min(actualParamTreeS.length - 1, nbFormalParams - 1); i2 >= 0; --i2) {
            TapList<?> actualParamZonesTree = this.curSymbolTable.treeOfZonesOfValue(actualParamTreeS[i2], total, this.curInstruction, null);
            if (actualParamZonesTree != null) {
                actualParamZonesTree = TapList.copyTree(actualParamZonesTree);
                this.includePointedElementsInTree(actualParamZonesTree, total, null, true, false, true);
                actualParamTotalS[i2] = this.referenceIsTotal(total.get(), actualParamZonesTree);
                if (!(!arrow.takesArgumentByValue(i2 + 1) || diffMaybePassedByRef && DataFlowAnalyzer.argIsOnlyRead(arrow.destination, i2 + 1))) {
                    DataFlowAnalyzer.removeInfoOnTopLevel(actualParamZonesTree);
                }
            } else {
                actualParamTotalS[i2] = false;
            }
            actualParamZonesTreeS[i2] = actualParamZonesTree;
        }
        BoolVector transitOnlyThroughCall = new BoolVector(DataFlowAnalyzer.mapSize(privateRowMap));
        transitOnlyThroughCall.setFalse();
        BoolMatrix publicExitData = new BoolMatrix(arrow.translator.length, privateDataInTransit.nCols);
        publicExitData.rows = new BoolVector[arrow.translator.length];
        for (i = arrow.translator.length - 1; i >= 0; --i) {
            PublicInfo publicZoneInfo = arrow.translator[i];
            BoolVector publicZoneData = new BoolVector(privateDataInTransit.nCols);
            if (publicZoneInfo != null) {
                TapIntList callerAccessedIndices = null;
                boolean actualArgIsTotal = true;
                boolean formalArgIsAffected = transit && (publicTouched == null || publicTouched.get(i));
                switch (publicZoneInfo.kind()) {
                    case 10: {
                        TapList<?> toLocation = TapList.getSetFieldLocation(resultData, publicZoneInfo.zone.accessTree, false);
                        DataFlowAnalyzer.cumulOr(toLocation, publicZoneData, false);
                        break;
                    }
                    case 7: {
                        if (publicZoneInfo.getParamRank() == 0) {
                            callerAccessedIndices = DataFlowAnalyzer.getIndicesAccessedInCaller(publicZoneInfo.ranks(0), 3, whichKind, privateRowMap, this.curInstruction, calledUnit);
                            actualArgIsTotal = callerAccessedIndices != null && callerAccessedIndices.tail == null;
                            break;
                        }
                        if (publicZoneInfo.getParamRank() > actualParamTreeS.length || !publicZonesPossiblyRorW.get(i)) break;
                        TapList<Object> actualParamElement = TapList.getSetFieldLocation(actualParamZonesTreeS[publicZoneInfo.getParamRank() - 1], publicZoneInfo.zone.accessTree, false);
                        if (actualParamElement == null || !(actualParamElement.head instanceof TapList)) {
                            actualArgIsTotal = actualParamTotalS[publicZoneInfo.getParamRank() - 1];
                        }
                        if (!publicZoneInfo.coversFurther && actualParamElement != null) {
                            actualParamElement = new TapList(actualParamElement.head, null);
                        }
                        callerAccessedIndices = this.mapExtendedDeclaredToVectorIndex(ZoneInfo.listAllZones(actualParamElement, false), whichKind, privateRowMap);
                        break;
                    }
                    default: {
                        callerAccessedIndices = DataFlowAnalyzer.getIndicesAccessedInCaller(publicZoneInfo.ranks(0), 3, whichKind, privateRowMap, this.curInstruction, calledUnit);
                        boolean bl = actualArgIsTotal = callerAccessedIndices != null && callerAccessedIndices.tail == null;
                    }
                }
                while (callerAccessedIndices != null) {
                    int index = callerAccessedIndices.head;
                    BoolVector privateZoneData = privateDataInTransit.getExplicitRow(index);
                    publicZoneData.cumulOr(privateZoneData);
                    if (formalArgIsAffected && actualArgIsTotal) {
                        transitOnlyThroughCall.set(index, true);
                    }
                    callerAccessedIndices = callerAccessedIndices.tail;
                }
            }
            publicExitData.setRow(i, publicZoneData);
        }
        if (transit) {
            for (i = privateDataInTransit.nRows - 1; i >= 0; --i) {
                if (!transitOnlyThroughCall.get(i)) continue;
                privateDataInTransit.setExplicitZeroRow(i);
            }
        }
        return publicExitData;
    }

    public TapList[] propagateEntryDataBwdToCaller(BoolMatrix publicEntryData, BoolMatrix privateDataInTransit, int[] privateRowMap, int whichKind, int nbParams, CallArrow arrow, BoolVector publicTouched) {
        BoolVector publicZonesPossiblyRorW = arrow.destination.getTmpALLKINDPossiblyRoW();
        TapList[] callerParamDataS = new TapList[nbParams];
        for (int i = nbParams - 1; i >= 0; --i) {
            callerParamDataS[i] = new TapList<Object>(null, null);
        }
        for (int i = arrow.translator.length - 1; i >= 0; --i) {
            PublicInfo publicZoneInfo = arrow.translator[i];
            if (publicZoneInfo == null || publicTouched != null && !publicTouched.get(i)) continue;
            BoolVector publicZoneData = publicEntryData.getRow(i);
            TapIntList callerAccessedIndices = null;
            switch (publicZoneInfo.kind()) {
                case 10: {
                    break;
                }
                case 7: {
                    if (publicZoneInfo.getParamRank() == 0) {
                        callerAccessedIndices = DataFlowAnalyzer.getIndicesAccessedInCaller(publicZoneInfo.ranks(0), 3, whichKind, privateRowMap, this.curInstruction, arrow.destination);
                        break;
                    }
                    if (publicZoneInfo.getParamRank() > nbParams) break;
                    TapList<?> toLocation = TapList.getSetFieldLocation(callerParamDataS[publicZoneInfo.getParamRank() - 1], publicZoneInfo.zone.accessTree, true);
                    if (!publicZonesPossiblyRorW.get(i)) break;
                    if (toLocation.head instanceof BoolVector) {
                        ((BoolVector)toLocation.head).cumulOr(publicZoneData);
                        break;
                    }
                    toLocation.head = publicZoneData;
                    break;
                }
                default: {
                    callerAccessedIndices = DataFlowAnalyzer.getIndicesAccessedInCaller(publicZoneInfo.ranks(0), 3, whichKind, privateRowMap, this.curInstruction, arrow.destination);
                }
            }
            while (callerAccessedIndices != null) {
                int index = callerAccessedIndices.head;
                if (privateDataInTransit.isImplicitIdentityRow(index)) {
                    privateDataInTransit.setExplicitIdentityRow(index);
                }
                privateDataInTransit.getRow(index).cumulOr(publicZoneData);
                callerAccessedIndices = callerAccessedIndices.tail;
            }
        }
        return callerParamDataS;
    }

    public TapList propagateExitDataFwdToCaller(BoolMatrix publicExitData, BoolMatrix privateDataInTransit, int[] privateRowMap, BoolVector publicTouched, CallArrow arrow, Tree[] actualParamTreeS, int whichKind) {
        TapList[] actualParamZonesTreeS = new TapList[actualParamTreeS.length];
        BoolVector publicZonesPossiblyRorW = arrow.destination.getTmpALLKINDPossiblyRoW();
        ToBool total = new ToBool();
        for (int i = actualParamTreeS.length - 1; i >= 0; --i) {
            TapList<?> actualParamZonesTree = this.curSymbolTable.treeOfZonesOfValue(actualParamTreeS[i], total, this.curInstruction, null);
            if (actualParamZonesTree != null) {
                actualParamZonesTree = TapList.copyTree(actualParamZonesTree);
                this.includePointedElementsInTree(actualParamZonesTree, total, null, true, false, true);
                if (arrow.takesArgumentByValue(i + 1)) {
                    DataFlowAnalyzer.removeInfoOnTopLevel(actualParamZonesTree);
                }
            }
            actualParamZonesTreeS[i] = actualParamZonesTree;
        }
        TapList<Object> resultData = new TapList<Object>(null, null);
        for (int i = arrow.translator.length - 1; i >= 0; --i) {
            PublicInfo publicZoneInfo = arrow.translator[i];
            if (publicZoneInfo == null || publicTouched != null && !publicTouched.get(i)) continue;
            BoolVector publicZoneData = publicExitData.getRow(i);
            TapIntList callerAccessedIndices = null;
            switch (publicZoneInfo.kind()) {
                case 10: {
                    TapList<?> toLocation = TapList.getSetFieldLocation(resultData, publicZoneInfo.zone.accessTree, true);
                    if (toLocation.head instanceof BoolVector) {
                        ((BoolVector)toLocation.head).cumulOr(publicZoneData);
                        break;
                    }
                    toLocation.head = publicZoneData;
                    break;
                }
                case 7: {
                    if (publicZoneInfo.getParamRank() == 0) {
                        callerAccessedIndices = DataFlowAnalyzer.getIndicesAccessedInCaller(publicZoneInfo.ranks(0), 3, whichKind, privateRowMap, this.curInstruction, this.curCalledUnit);
                        break;
                    }
                    if (publicZoneInfo.getParamRank() > actualParamTreeS.length || !publicZonesPossiblyRorW.get(i)) break;
                    callerAccessedIndices = this.mapExtendedDeclaredToVectorIndex(ZoneInfo.listAllZones(TapList.getSetFieldLocation(actualParamZonesTreeS[publicZoneInfo.getParamRank() - 1], publicZoneInfo.zone.accessTree, false), publicZoneInfo.coversFurther), whichKind, privateRowMap);
                    break;
                }
                default: {
                    callerAccessedIndices = DataFlowAnalyzer.getIndicesAccessedInCaller(publicZoneInfo.ranks(0), 3, whichKind, privateRowMap, this.curInstruction, this.curCalledUnit);
                }
            }
            while (callerAccessedIndices != null) {
                int index = callerAccessedIndices.head;
                if (privateDataInTransit.isImplicitIdentityRow(index)) {
                    privateDataInTransit.setExplicitIdentityRow(index);
                }
                privateDataInTransit.getRow(index).cumulOr(publicZoneData);
                callerAccessedIndices = callerAccessedIndices.tail;
            }
        }
        return resultData;
    }

    public BoolVector propagateEntryDataFwdToCallee(BoolVector privateDataInTransit, int[] vectorMap, TapList[] actualParamDataS, BoolVector publicTouched, CallArrow arrow, Tree[] actualParamTreeS, int whichKind, boolean transit) {
        TapList[] actualParamZonesTreeS = new TapList[actualParamDataS.length];
        boolean[] actualParamTotalS = new boolean[actualParamDataS.length];
        BoolVector publicZonesPossiblyRorW = arrow.destination.getTmpALLKINDPossiblyRoW();
        if (transit) {
            ToBool total = new ToBool();
            for (int i = actualParamTreeS.length - 1; i >= 0; --i) {
                TapList<?> actualParamZonesTree = this.curSymbolTable.treeOfZonesOfValue(actualParamTreeS[i], total, this.curInstruction, null);
                if (actualParamZonesTree != null) {
                    actualParamZonesTree = TapList.copyTree(actualParamZonesTree);
                    this.includePointedElementsInTree(actualParamZonesTree, total, null, true, false, true);
                    if (arrow.takesArgumentByValue(i + 1)) {
                        DataFlowAnalyzer.removeInfoOnTopLevel(actualParamZonesTree);
                    }
                    actualParamTotalS[i] = this.referenceIsTotal(total.get(), actualParamZonesTree);
                } else {
                    actualParamTotalS[i] = false;
                }
                actualParamZonesTreeS[i] = actualParamZonesTree;
            }
        }
        BoolVector transitOutsideCall = new BoolVector(DataFlowAnalyzer.mapSize(vectorMap));
        transitOutsideCall.setTrue();
        BoolVector publicEntryData = new BoolVector(arrow.translator.length);
        for (int i = arrow.translator.length - 1; i >= 0; --i) {
            PublicInfo publicZoneInfo = arrow.translator[i];
            boolean publicZoneData = false;
            if (publicZoneInfo != null) {
                boolean totallyAffected;
                TapIntList callerAccessedIndices = null;
                boolean maybeAffectedByCall = transit && (publicTouched == null || publicTouched.get(i));
                switch (publicZoneInfo.kind()) {
                    case 10: {
                        break;
                    }
                    case 7: {
                        if (publicZoneInfo.getParamRank() == 0) {
                            callerAccessedIndices = DataFlowAnalyzer.getIndicesAccessedInCaller(publicZoneInfo.ranks(0), 3, whichKind, vectorMap, this.curInstruction, this.curCalledUnit);
                            break;
                        }
                        if (publicZoneInfo.getParamRank() > actualParamDataS.length || !publicZonesPossiblyRorW.get(i)) break;
                        TapList<?> actualParamElement = TapList.getSetFieldLocation(actualParamZonesTreeS[publicZoneInfo.getParamRank() - 1], publicZoneInfo.zone.accessTree, false);
                        TapList<?> toLocation = TapList.getSetFieldLocation(actualParamDataS[publicZoneInfo.getParamRank() - 1], publicZoneInfo.zone.accessTree, false);
                        boolean bl = publicZoneData = publicZoneInfo.coversFurther ? TapList.oneTrue(toLocation) : TapList.oneTrueInHead(toLocation);
                        if (!maybeAffectedByCall || !actualParamTotalS[publicZoneInfo.getParamRank() - 1] || actualParamElement == null || actualParamElement.head instanceof TapList) break;
                        this.setExtendedDeclared(transitOutsideCall, vectorMap, whichKind, ZoneInfo.listAllZones(actualParamElement, false), false);
                        break;
                    }
                    default: {
                        callerAccessedIndices = DataFlowAnalyzer.getIndicesAccessedInCaller(publicZoneInfo.ranks(0), 3, whichKind, vectorMap, this.curInstruction, this.curCalledUnit);
                    }
                }
                boolean bl = totallyAffected = callerAccessedIndices != null && callerAccessedIndices.tail == null;
                while (callerAccessedIndices != null) {
                    int index = callerAccessedIndices.head;
                    boolean privateZoneData = privateDataInTransit.get(index);
                    if (privateZoneData) {
                        publicZoneData = true;
                    }
                    if (maybeAffectedByCall && totallyAffected) {
                        transitOutsideCall.set(index, false);
                    }
                    callerAccessedIndices = callerAccessedIndices.tail;
                }
            }
            publicEntryData.set(i, publicZoneData);
        }
        if (transit) {
            privateDataInTransit.cumulAnd(transitOutsideCall);
        }
        return publicEntryData;
    }

    public BoolVector propagateExitDataBwdToCallee(BoolVector privateDataInTransit, int[] vectorMap, TapList resultData, TapIntList moreTrueZones, CallArrow arrow, Tree[] actualParamTreeS, int whichKind, boolean transit, BoolVector publicTouched, boolean diffMaybePassedByRef, boolean resetValue) {
        TapList[] actualParamZonesTreeS = new TapList[actualParamTreeS.length];
        boolean[] actualParamTotalS = new boolean[actualParamTreeS.length];
        BoolVector publicZonesPossiblyRorW = arrow.destination.getTmpALLKINDPossiblyRoW();
        ToBool total = new ToBool();
        Unit calledUnit = arrow.destination;
        int nbFormalParams = calledUnit.formalArgumentsNb();
        for (int i = Math.min(actualParamTreeS.length - 1, nbFormalParams - 1); i >= 0; --i) {
            TapList<?> actualParamZonesTree = this.curSymbolTable.treeOfZonesOfValue(actualParamTreeS[i], total, this.curInstruction, null);
            if (actualParamZonesTree != null) {
                actualParamZonesTree = TapList.copyTree(actualParamZonesTree);
                this.includePointedElementsInTree(actualParamZonesTree, total, null, true, false, true);
                actualParamTotalS[i] = this.referenceIsTotal(total.get(), actualParamZonesTree);
                if (this.filterByValue && arrow.takesArgumentByValue(i + 1) && (!diffMaybePassedByRef || !DataFlowAnalyzer.argIsOnlyRead(arrow.destination, i + 1))) {
                    DataFlowAnalyzer.removeInfoOnTopLevel(actualParamZonesTree);
                }
            } else {
                actualParamTotalS[i] = false;
            }
            actualParamZonesTreeS[i] = actualParamZonesTree;
        }
        BoolVector transitOutsideCall = new BoolVector(DataFlowAnalyzer.mapSize(vectorMap));
        transitOutsideCall.setTrue();
        if (arrow.translator == null) {
            TapEnv.toolWarning(-1, "null arrow translator for " + arrow);
            return null;
        }
        BoolVector publicExitData = new BoolVector(arrow.translator.length);
        for (int i = arrow.translator.length - 1; i >= 0; --i) {
            PublicInfo publicZoneInfo = arrow.translator[i];
            boolean publicZoneData = false;
            boolean maybeUsedByCall = true;
            if (publicZoneInfo != null) {
                TapIntList callerAccessedIndices = null;
                boolean totallyAffected = true;
                maybeUsedByCall = !transit || publicTouched == null || publicTouched.get(i);
                switch (publicZoneInfo.kind()) {
                    case 10: {
                        TapList<?> toLocation = TapList.getSetFieldLocation(resultData, publicZoneInfo.zone.accessTree, false);
                        publicZoneData = TapList.oneTrueInHead(toLocation);
                        break;
                    }
                    case 7: {
                        if (publicZoneInfo.getParamRank() == 0) {
                            callerAccessedIndices = DataFlowAnalyzer.getIndicesAccessedInCaller(publicZoneInfo.ranks(0), 3, whichKind, vectorMap, this.curInstruction, calledUnit);
                            totallyAffected = callerAccessedIndices != null && callerAccessedIndices.tail == null;
                            break;
                        }
                        if (publicZoneInfo.getParamRank() > actualParamTreeS.length || !publicZonesPossiblyRorW.get(i)) break;
                        TapList<Object> actualParamElement = TapList.getSetFieldLocation(actualParamZonesTreeS[publicZoneInfo.getParamRank() - 1], publicZoneInfo.zone.accessTree, false);
                        if (actualParamElement == null || !(actualParamElement.head instanceof TapList)) {
                            totallyAffected = actualParamTotalS[publicZoneInfo.getParamRank() - 1];
                        }
                        if (!publicZoneInfo.coversFurther && actualParamElement != null) {
                            actualParamElement = new TapList(actualParamElement.head, null);
                        }
                        callerAccessedIndices = this.mapExtendedDeclaredToVectorIndex(ZoneInfo.listAllZones(actualParamElement, false), whichKind, vectorMap);
                        break;
                    }
                    default: {
                        callerAccessedIndices = DataFlowAnalyzer.getIndicesAccessedInCaller(publicZoneInfo.ranks(0), 3, whichKind, vectorMap, this.curInstruction, calledUnit);
                        boolean bl = totallyAffected = callerAccessedIndices != null && callerAccessedIndices.tail == null;
                    }
                }
                while (callerAccessedIndices != null) {
                    boolean privateZoneData;
                    int index = callerAccessedIndices.head;
                    if (index < vectorMap[3]) {
                        privateZoneData = privateDataInTransit.get(index);
                        if (totallyAffected && maybeUsedByCall) {
                            transitOutsideCall.set(index, false);
                        }
                    } else {
                        privateZoneData = TapIntList.contains(moreTrueZones, index - vectorMap[2]);
                    }
                    if (privateZoneData) {
                        publicZoneData = true;
                    }
                    callerAccessedIndices = callerAccessedIndices.tail;
                }
            }
            if (!maybeUsedByCall) continue;
            publicExitData.set(i, publicZoneData);
        }
        if (transit) {
            if (resetValue) {
                privateDataInTransit.cumulOr(transitOutsideCall.not());
            } else {
                privateDataInTransit.cumulAnd(transitOutsideCall);
            }
        }
        return publicExitData;
    }

    public TapList[] infoTreesOfRefArgs(Tree[] actualParams, BoolVector info, int[] vectorMap, int whichKind) {
        int nbArgs = actualParams.length;
        TapList[] infoTreesOfArgs = new TapList[nbArgs];
        for (int i = nbArgs - 1; i >= 0; --i) {
            TapList<?> argZones;
            Tree argTree = actualParams[i];
            if (argTree != null) {
                argZones = TapList.copyTree(this.curSymbolTable.treeOfZonesOfValue(argTree, null, this.curInstruction, null));
                this.includePointedElementsInTree(argZones, null, null, true, true, true);
            } else {
                argZones = null;
            }
            infoTreesOfArgs[i] = DataFlowAnalyzer.buildInfoBoolTreeOfDeclaredZones(argZones, info, vectorMap, null, whichKind, this.curSymbolTable);
        }
        return infoTreesOfArgs;
    }

    public boolean referenceIsTotal(boolean totalRef, TapList zonesTree) {
        TapIntList zonesList = ZoneInfo.listAllZones(zonesTree, true);
        int maxDeclZone = this.curInstruction.block.symbolTable.declaredZonesNb(0);
        return this.curInstruction.getWhereMask() == null && !this.oneZoneIsMultiple(zonesList) && (totalRef && this.allPartsAreUniqueScalar(zonesTree, new TapList<Object>(null, null)) || zonesList != null && zonesList.head > 0 && zonesList.head < maxDeclZone && zonesList.tail == null && this.uniqueAccessZones != null && this.uniqueAccessZones.get(zonesList.head));
    }

    private boolean allPartsAreUniqueScalar(TapList zonesTree, TapList<TapList> dejaVu) {
        if (this.curUnit.isFortran()) {
            return true;
        }
        boolean allOK = true;
        while (allOK && zonesTree != null) {
            if (TapList.contains(dejaVu.tail, zonesTree)) {
                zonesTree = null;
                continue;
            }
            dejaVu.placdl(zonesTree);
            if (zonesTree.head instanceof TapList) {
                allOK = this.allPartsAreUniqueScalar((TapList)zonesTree.head, dejaVu);
            } else if (zonesTree.head != null) {
                TapIntList zonesList = (TapIntList)zonesTree.head;
                allOK = zonesList.tail == null && this.zoneIsScalar(zonesList.head);
            }
            zonesTree = zonesTree.tail;
        }
        return allOK;
    }

    public boolean oneZoneIsMultiple(TapIntList zonesList) {
        boolean found = false;
        while (!found && zonesList != null) {
            ZoneInfo zoneInfo = this.extendedDeclaredToZoneInfo(zonesList.head);
            if (zoneInfo != null && zoneInfo.multiple) {
                found = true;
            }
            zonesList = zonesList.tail;
        }
        return found;
    }

    private static boolean argIsOnlyRead(Unit unit, int i) {
        return unit.unitInOutW() != null && !unit.getTmpALLKINDPossiblyW().intersects(ZoneInfo.listAllZones(unit.argsPublicRankTrees[i], true)) && (unit.unitInOutRW() == null || !unit.getTmpALLKINDRW().intersects(ZoneInfo.listAllZones(unit.argsPublicRankTrees[i], true)));
    }

    public static void collectZonesWrittenByExpression(Tree expr, int act, BoolVector written, Instruction instr) {
        switch (expr.opCode()) {
            case 31: {
                break;
            }
            case 14: 
            case 63: 
            case 125: 
            case 150: 
            case 152: 
            case 190: {
                DataFlowAnalyzer.collectZonesWrittenByExpression(expr.down(1), 1, written, instr);
                DataFlowAnalyzer.collectZonesWrittenByExpression(expr.down(2), -1, written, instr);
                break;
            }
            case 9: 
            case 75: 
            case 96: 
            case 151: {
                if (act != 1) break;
                SymbolTable symbolTable = instr.block.symbolTable;
                int[] map = DataFlowAnalyzer.makeMap3(symbolTable, 0);
                TapIntList valueZones = symbolTable.listOfZonesOfValue(expr, null, instr);
                valueZones = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(valueZones, 0, map, symbolTable, null);
                written.set(valueZones, true);
                break;
            }
            case 121: {
                if (expr.down(3).opCode() != 64) break;
                DataFlowAnalyzer.collectZonesWrittenByExpression(expr.down(3).down(1), 1, written, instr);
            }
        }
    }

    private boolean isPointerZones(int paramRank, Tree[] actualParamTreeS) {
        boolean result = false;
        TapList<?> zonesTree = this.curSymbolTable.treeOfZonesOfValue(actualParamTreeS[paramRank], new ToBool(), this.curInstruction, null);
        if (zonesTree != null && zonesTree.head instanceof TapIntList) {
            int zoneRk = ((TapIntList)zonesTree.head).head;
            result = this.zoneIsPointer(zoneRk);
        }
        return result;
    }

    public final TapList buildInfoPRZVTreeOfExtendedDeclared(TapList zonesTree, BoolMatrix matrix, int whichKind, int[] rowMap) {
        return this.buildInfoPRZVTreeOfExtendedDeclaredRec(zonesTree, matrix, whichKind, rowMap, new TapList<Object>(null, null));
    }

    private TapList buildInfoPRZVTreeOfExtendedDeclaredRec(TapList zonesTree, BoolMatrix matrix, int whichKind, int[] rowMap, TapList<TapPair<TapList, TapList>> dejaVu) {
        TapList<Object> hdPRZVsTree;
        TapList<Object> tlPRZVsTree = hdPRZVsTree = new TapList<Object>(null, null);
        while (zonesTree != null) {
            Object przvsSubTree;
            TapList cycle = (TapList)TapList.cassq(zonesTree, dejaVu.tail);
            if (cycle != null) {
                tlPRZVsTree.tail = cycle.tail;
                zonesTree = null;
                continue;
            }
            dejaVu.placdl(new TapPair<TapList, TapList<Object>>(zonesTree, tlPRZVsTree));
            if (zonesTree.head instanceof TapList) {
                przvsSubTree = this.buildInfoPRZVTreeOfExtendedDeclaredRec((TapList)zonesTree.head, matrix, whichKind, rowMap, dejaVu);
            } else {
                int nbColumns = matrix.nCols;
                BoolVector result = new BoolVector(nbColumns);
                TapIntList zones = (TapIntList)zonesTree.head;
                while (zones != null) {
                    int rowIndex = this.extendedDeclaredToVectorIndex(zones.head, whichKind, rowMap);
                    if (rowIndex >= 0) {
                        BoolVector row = matrix.getRow(rowIndex);
                        if (row == null) {
                            if (rowIndex < nbColumns) {
                                result.set(rowIndex, true);
                            }
                        } else {
                            result.cumulOr(row);
                        }
                    }
                    zones = zones.tail;
                }
                przvsSubTree = result;
            }
            tlPRZVsTree = tlPRZVsTree.placdl(przvsSubTree);
            zonesTree = zonesTree.tail;
        }
        return hdPRZVsTree.tail;
    }

    public final void setInfoBoolMatrixAtRowsColumns(BoolMatrix matrix, TapList rowZonesTree, int rowOffset, TapList columnZonesTree, int columnOffset) {
        this.setInfoBoolMatrixAtRowsColumnsRec(matrix, rowZonesTree, rowOffset, columnZonesTree, columnOffset, new TapList<Object>(null, null));
    }

    private void setInfoBoolMatrixAtRowsColumnsRec(BoolMatrix matrix, TapList rowZonesTree, int rowOffset, TapList columnZonesTree, int columnOffset, TapList<TapList> dejaVu) {
        while (rowZonesTree != null && columnZonesTree != null) {
            TapIntList columns;
            TapIntList rows;
            if (TapList.contains(dejaVu.tail, rowZonesTree)) {
                rowZonesTree = null;
                continue;
            }
            dejaVu.placdl(rowZonesTree);
            if (rowZonesTree.head instanceof TapList) {
                if (columnZonesTree.head instanceof TapList) {
                    this.setInfoBoolMatrixAtRowsColumnsRec(matrix, (TapList)rowZonesTree.head, rowOffset, (TapList)columnZonesTree.head, columnOffset, dejaVu);
                    rows = null;
                    columns = null;
                } else {
                    rows = ZoneInfo.listAllZones((TapList)rowZonesTree.head, true);
                    columns = (TapIntList)columnZonesTree.head;
                }
            } else {
                rows = (TapIntList)rowZonesTree.head;
                columns = columnZonesTree.head instanceof TapList ? ZoneInfo.listAllZones((TapList)columnZonesTree.head, true) : (TapIntList)columnZonesTree.head;
            }
            while (rows != null) {
                int row = rows.head;
                if (row > 0) {
                    TapIntList inColumns = columns;
                    while (inColumns != null) {
                        int column = inColumns.head;
                        matrix.set(row + rowOffset, column + columnOffset, true);
                        inColumns = inColumns.tail;
                    }
                }
                rows = rows.tail;
            }
            rowZonesTree = rowZonesTree.tail;
            columnZonesTree = columnZonesTree.tail;
        }
    }

    public void setUniqueAccessZones(Block block) {
        this.uniqueAccessZones = new BoolVector(block.symbolTable.declaredZonesNb(0));
        LoopBlock enclosingLoop = block.enclosingLoop();
        if (enclosingLoop != null) {
            this.uniqueAccessZones.set(enclosingLoop.header().uniqueAccessZones, true);
        }
    }

    public void setRefValue(Tree refTree, int kind, BoolVector info, int[] infoMap, boolean value, boolean followPointers) {
        TapList<?> argZonesTree = this.curSymbolTable.treeOfZonesOfValue(refTree, null, this.curInstruction, null);
        if (followPointers) {
            argZonesTree = TapList.copyTree(argZonesTree);
            this.includePointedElementsInTree(argZonesTree, null, null, true, true, true);
        }
        this.setExtendedDeclared(info, infoMap, kind, ZoneInfo.listAllZones(argZonesTree, true), value);
    }

    public final boolean loopRunsAtLeastOnce(HeaderBlock block) {
        Instruction instr = block.lastInstr();
        boolean result = false;
        if (instr == null || instr.tree.opCode() != 121) {
            return false;
        }
        Tree loopControl = instr.tree.down(3);
        if (loopControl.opCode() == 64) {
            Tree loopFrom = loopControl.down(2);
            Tree loopTo = loopControl.down(3);
            Tree loopStride = loopControl.down(4);
            if (ILUtils.isNullOrNone(loopStride)) {
                loopStride = ILUtils.build(103, 1);
            }
            if (ILUtils.evalsToGTZero(loopStride)) {
                result = ILUtils.evalsToGEZero(ILUtils.subTree(ILUtils.copy(loopTo), ILUtils.copy(loopFrom)));
            } else if (ILUtils.evalsToLTZero(loopStride)) {
                result = ILUtils.evalsToGEZero(ILUtils.subTree(ILUtils.copy(loopFrom), ILUtils.copy(loopTo)));
            }
        }
        return result;
    }

    protected final BoolVector directEntryExitMask(HeaderBlock header, int[] vectorMap, int whichKind) {
        BoolVector mask = new BoolVector(DataFlowAnalyzer.mapSize(vectorMap));
        if (this.loopRunsAtLeastOnce(header)) {
            TapIntList topUniqueAccessHere = header.topUniqueAccessZones;
            TapIntList loopCompleteZones = header.loopCompleteZones;
            while (topUniqueAccessHere != null) {
                ZoneInfo zi;
                int declaredZone = topUniqueAccessHere.head;
                if (!TapIntList.contains(loopCompleteZones, declaredZone) && (zi = header.symbolTable.declaredZoneInfo(declaredZone, 0)) != null && zi.kindZoneNb(whichKind) != -1) {
                    mask.setDeclared(zi.kindZoneNb(whichKind), vectorMap, true);
                }
                topUniqueAccessHere = topUniqueAccessHere.tail;
            }
        } else {
            mask.setTrue();
        }
        return mask;
    }

    public final TapIntList declaredZonesNotFromEntryToExit(HeaderBlock header, int whichKind) {
        TapIntList maskedZones = null;
        if (this.loopRunsAtLeastOnce(header)) {
            TapIntList topUniqueAccessHere = header.topUniqueAccessZones;
            TapIntList loopCompleteZones = header.loopCompleteZones;
            while (topUniqueAccessHere != null) {
                ZoneInfo zi;
                int declaredZone = topUniqueAccessHere.head;
                if (!TapIntList.contains(loopCompleteZones, declaredZone) && (zi = header.symbolTable.declaredZoneInfo(declaredZone, 0)) != null && zi.kindZoneNb(whichKind) != -1) {
                    maskedZones = new TapIntList(zi.kindZoneNb(whichKind), maskedZones);
                }
                topUniqueAccessHere = topUniqueAccessHere.tail;
            }
        }
        return maskedZones;
    }

    protected final void traceDisplayPrivateZones(Unit unit, int[] map, int kind) {
        this.curSymbolTable = unit.bodySymbolTable();
        if (this.curSymbolTable == null) {
            this.curSymbolTable = unit.publicSymbolTable();
        }
        for (int classIndex = 1; classIndex < map.length; ++classIndex) {
            if (map[classIndex] - map[classIndex - 1] <= 0) continue;
            TapEnv.printOnTrace(" " + mapClassNames[classIndex] + ':');
            for (int i = map[classIndex - 1]; i < map[classIndex]; ++i) {
                ZoneInfo zi = this.vectorIndexToZoneInfo(i, classIndex, kind, map);
                TapEnv.printOnTrace(" [" + i + "]" + (zi == null ? "?" : zi.description));
            }
        }
        TapEnv.printlnOnTrace();
    }

    public final void setInfoPRZVTreeToExtendedDeclaredZones(BoolMatrix matrix, int[] vectorMap, TapList zonesTree, TapList przvsTree, TapList mask, boolean totalSet, int whichKind) {
        this.setInfoPRZVTreeToExtendedDeclaredZonesRec(matrix, vectorMap, zonesTree, przvsTree, mask, totalSet, whichKind, new TapList<Object>(null, null));
    }

    private void setInfoPRZVTreeToExtendedDeclaredZonesRec(BoolMatrix matrix, int[] vectorMap, TapList zonesTree, TapList przvsTree, TapList mask, boolean totalSet, int whichKind, TapList<TapList> dejaVu) {
        if (przvsTree != null && przvsTree.tail == null && przvsTree.head instanceof BoolVector && zonesTree != null && zonesTree.tail != null && zonesTree.head instanceof TapIntList) {
            zonesTree = new TapList(zonesTree.head, null);
        }
        if (TapList.lengthWithCycle(zonesTree) == TapList.length(przvsTree)) {
            while (zonesTree != null && przvsTree != null) {
                if (TapList.contains(dejaVu.tail, zonesTree)) {
                    zonesTree = null;
                    continue;
                }
                dejaVu.placdl(zonesTree);
                if (przvsTree.head instanceof TapList) {
                    if (zonesTree.head instanceof TapList) {
                        this.setInfoPRZVTreeToExtendedDeclaredZonesRec(matrix, vectorMap, (TapList)zonesTree.head, (TapList)przvsTree.head, mask != null && mask.head instanceof TapList ? (TapList)mask.head : mask, totalSet, whichKind, dejaVu);
                    } else if (this.allowedByMaskHead(mask)) {
                        BoolVector onePRZV = new BoolVector(DataFlowAnalyzer.mapSize(vectorMap));
                        DataFlowAnalyzer.cumulOr((TapList)przvsTree.head, onePRZV, false);
                        TapIntList zones = (TapIntList)zonesTree.head;
                        zones = this.mapExtendedDeclaredToVectorIndex(zones, whichKind, vectorMap);
                        matrix.overwriteDeps(zones, onePRZV, totalSet);
                    }
                } else if (przvsTree.head != null && this.allowedByMaskHead(mask)) {
                    TapIntList zones = zonesTree.head instanceof TapList ? ZoneInfo.listAllZones((TapList)zonesTree.head, true) : (TapIntList)zonesTree.head;
                    zones = this.mapExtendedDeclaredToVectorIndex(zones, whichKind, vectorMap);
                    matrix.overwriteDeps(zones, (BoolVector)przvsTree.head, totalSet);
                }
                zonesTree = zonesTree.tail;
                przvsTree = przvsTree.tail;
                mask = mask == null ? null : mask.tail;
            }
        } else {
            BoolVector newVal = new BoolVector(matrix.nCols);
            DataFlowAnalyzer.cumulOr(przvsTree, newVal, false);
            TapIntList zones = this.mapExtendedDeclaredToVectorIndex(ZoneInfo.listAllZones(zonesTree, false), whichKind, vectorMap);
            matrix.overwriteDeps(zones, newVal, totalSet);
        }
    }

    public final void setInfoBoolTreeToExtendedDeclaredZones(BoolVector infos, int[] vectorMap, TapList zonesTree, boolean newVal, TapList mask, boolean totalSet, int whichKind) {
        this.setInfoBoolTreeToExtendedDeclaredZonesRec(infos, vectorMap, zonesTree, newVal, mask, totalSet, whichKind, new TapList<Object>(null, null));
    }

    private void setInfoBoolTreeToExtendedDeclaredZonesRec(BoolVector infos, int[] vectorMap, TapList zonesTree, boolean newVal, TapList mask, boolean totalSet, int whichKind, TapList<TapList> dejaVu) {
        while (zonesTree != null) {
            if (TapList.contains(dejaVu.tail, zonesTree)) {
                zonesTree = null;
                continue;
            }
            dejaVu.placdl(zonesTree);
            if (zonesTree.head instanceof TapList) {
                this.setInfoBoolTreeToExtendedDeclaredZonesRec(infos, vectorMap, (TapList)zonesTree.head, newVal, mask != null && mask.head instanceof TapList ? (TapList)mask.head : mask, totalSet, whichKind, dejaVu);
            } else if (this.allowedByMaskHead(mask)) {
                this.conservativeSetExtendedDeclared(infos, vectorMap, (TapIntList)zonesTree.head, newVal, this.conservativeValue, totalSet, whichKind, this.curSymbolTable);
            }
            zonesTree = zonesTree.tail;
            mask = mask == null ? null : mask.tail;
        }
    }

    public final void setInfoBoolTreeToExtendedDeclaredZones(BoolVector infos, int[] vectorMap, TapList zonesTree, TapList boolsTree, TapList mask, boolean totalSet, int whichKind) {
        this.setInfoBoolTreeToExtendedDeclaredZonesRec(infos, vectorMap, zonesTree, boolsTree, mask, totalSet, whichKind, new TapList<Object>(null, null));
    }

    private void setInfoBoolTreeToExtendedDeclaredZonesRec(BoolVector infos, int[] vectorMap, TapList zonesTree, TapList boolsTree, TapList mask, boolean totalSet, int whichKind, TapList<TapList> dejaVu) {
        if (boolsTree != null && boolsTree.tail == null && boolsTree.head instanceof Boolean && zonesTree != null && zonesTree.tail != null && zonesTree.head instanceof TapIntList) {
            zonesTree = new TapList(zonesTree.head, null);
        }
        if (TapList.lengthWithCycle(zonesTree) == TapList.lengthWithCycle(boolsTree)) {
            while (zonesTree != null && boolsTree != null) {
                if (TapList.contains(dejaVu.tail, zonesTree)) {
                    zonesTree = null;
                    continue;
                }
                dejaVu.placdl(zonesTree);
                if (boolsTree.head instanceof TapList) {
                    if (zonesTree.head instanceof TapList) {
                        this.setInfoBoolTreeToExtendedDeclaredZonesRec(infos, vectorMap, (TapList)zonesTree.head, (TapList)boolsTree.head, mask != null && mask.head instanceof TapList ? (TapList)mask.head : mask, totalSet, whichKind, dejaVu);
                    } else if (this.allowedByMaskHead(mask)) {
                        this.conservativeSetExtendedDeclared(infos, vectorMap, (TapIntList)zonesTree.head, TapList.oneTrueInHead(boolsTree), this.conservativeValue, totalSet, whichKind, this.curSymbolTable);
                    }
                } else if (boolsTree.head != null && this.allowedByMaskHead(mask)) {
                    TapIntList zones = zonesTree.head instanceof TapList ? ZoneInfo.listAllZones((TapList)zonesTree.head, true) : (TapIntList)zonesTree.head;
                    this.conservativeSetExtendedDeclared(infos, vectorMap, zones, (Boolean)boolsTree.head, this.conservativeValue, totalSet, whichKind, this.curSymbolTable);
                }
                zonesTree = zonesTree.tail;
                boolsTree = boolsTree.tail;
                mask = mask == null ? null : mask.tail;
            }
        } else {
            boolean newVal = TapList.oneTrue(boolsTree);
            TapIntList zonesList = ZoneInfo.listAllZones(zonesTree, false);
            this.conservativeSetExtendedDeclared(infos, vectorMap, zonesList, newVal, this.conservativeValue, totalSet, whichKind, this.curSymbolTable);
        }
    }

    private boolean allowedByMaskHead(TapList<?> mask) {
        if (mask == null) {
            return true;
        }
        if (mask.head instanceof Boolean) {
            return (Boolean)mask.head;
        }
        return TapList.oneTrueInHead(mask);
    }

    private TapList<Block> mapOrigin(TapList<FGArrow> arrows) {
        TapList<Object> hdOrigins;
        TapList<Object> tlOrigins = hdOrigins = new TapList<Object>(null, null);
        while (arrows != null) {
            tlOrigins = tlOrigins.placdl(((FGArrow)arrows.head).origin);
            arrows = arrows.tail;
        }
        return hdOrigins.tail;
    }

    private TapList<Block> mapDestination(TapList<FGArrow> arrows) {
        TapList<Object> hdDestinations;
        TapList<Object> tlDestinations = hdDestinations = new TapList<Object>(null, null);
        while (arrows != null) {
            tlDestinations = tlDestinations.placdl(((FGArrow)arrows.head).destination);
            arrows = arrows.tail;
        }
        return hdDestinations.tail;
    }

    private void conservativeSetExtendedDeclared(BoolVector infos, int[] vectorMap, TapIntList zones, boolean newVal, boolean conservativeVal, boolean total, int whichKind, SymbolTable symbolTable) {
        while (zones != null) {
            int index;
            ZoneInfo zoneInfo = DataFlowAnalyzer.extendedDeclaredToZoneInfo(zones.head, symbolTable, null);
            if (zoneInfo != null && zoneInfo.zoneNb > 1 && (index = this.extendedDeclaredToVectorIndex(zones.head, whichKind, vectorMap)) >= 0 && newVal != infos.get(index)) {
                if (total && !zoneInfo.multiple) {
                    infos.set(index, newVal);
                } else {
                    infos.set(index, conservativeVal);
                }
            }
            zones = zones.tail;
        }
    }

    public final void setExtendedDeclared(BoolVector info, int[] vectorMap, int kind, TapIntList extendedDeclaredZones, boolean value) {
        while (extendedDeclaredZones != null) {
            this.setExtendedDeclared(info, vectorMap, kind, extendedDeclaredZones.head, value);
            extendedDeclaredZones = extendedDeclaredZones.tail;
        }
    }

    public final void setExtendedDeclared(BoolVector info, int[] vectorMap, int kind, int extendedDeclaredZone, boolean value) {
        info.set(this.extendedDeclaredToVectorIndex(extendedDeclaredZone, kind, vectorMap), value);
    }

    public final boolean zoneIsScalar(int zoneRk) {
        ZoneInfo zoneInfo = this.extendedDeclaredToZoneInfo(zoneRk);
        return zoneInfo != null && zoneInfo.accessIndexes == null && zoneInfo.targetZoneOf == null;
    }

    public final boolean zoneIsPointer(int zoneRk) {
        ZoneInfo zoneInfo = this.extendedDeclaredToZoneInfo(zoneRk);
        return zoneInfo != null && zoneInfo.ptrZoneNb != -1;
    }

    private final String infoToString(BoolVector info, int[] infoMap, int kind) {
        return DataFlowAnalyzer.infoToString(info, infoMap, kind, this.curUnit, this.curSymbolTable);
    }

    protected final String infoToStringWithDiffPtr(BoolVector info, int[] infoMap, BoolVector infoOnDiffPtr, int[] infoMapOnDiffPtr) {
        String ptrString = "";
        if (infoOnDiffPtr != null) {
            ptrString = " Ptr:" + this.infoToString(infoOnDiffPtr, infoMapOnDiffPtr, 3);
        }
        return this.infoToString(info, infoMap, 0) + ptrString;
    }

    private final String infoToStringWithCycle(BoolVector info, int[] infoMap, int kind, BoolVector infoCycle) {
        String cycleString = "";
        if (infoCycle != null) {
            cycleString = " (cycling:" + this.infoToString(infoCycle, infoMap, kind) + ')';
        }
        return this.infoToString(info, infoMap, kind) + cycleString;
    }

    protected final String infoToStringWithDiffPtrWithCycle(BoolVector info, int[] infoMap, BoolVector infoOnDiffPtr, int[] infoMapOnDiffPtr, BoolVector infoCycle, BoolVector infoCycleOnDiffPtr) {
        String cycleString = "";
        if (infoCycle != null || infoCycleOnDiffPtr != null) {
            cycleString = " (cycling:" + this.infoToStringWithDiffPtr(infoCycle, infoMap, infoCycleOnDiffPtr, infoMapOnDiffPtr) + ')';
        }
        return this.infoToStringWithDiffPtr(info, infoMap, infoOnDiffPtr, infoMapOnDiffPtr) + cycleString;
    }

    public final int vectorIndexToExtendedDeclared(int index, int indexClass, int zoneKind, int[] vectorMap) {
        switch (indexClass) {
            case 3: {
                index -= vectorMap[2];
                if (zoneKind != 0) {
                    ZoneInfo zoneInfo = this.curSymbolTable.declaredZoneInfo(index, zoneKind);
                    index = zoneInfo.zoneNb;
                }
                return index;
            }
            case 4: {
                index -= vectorMap[3];
                if (zoneKind != 0) {
                    ZoneInfo zoneInfo = this.curCalledUnit.publicSymbolTable().declaredZoneInfo(index + this.curCalledUnit.publicSymbolTable().firstDeclaredZone(zoneKind), zoneKind);
                    index = zoneInfo.zoneNb - this.curCalledUnit.publicSymbolTable().firstDeclaredZone(0);
                }
                return index + this.nDZ;
            }
        }
        return -1;
    }

    public static int vectorIndexToExtendedDeclared(int index, int indexClass, int zoneKind, int[] vectorMap, SymbolTable symbolTable) {
        switch (indexClass) {
            case 3: {
                index -= vectorMap[2];
                if (zoneKind != 0) {
                    ZoneInfo zoneInfo = symbolTable.declaredZoneInfo(index, zoneKind);
                    index = zoneInfo.zoneNb;
                }
                return index;
            }
            case 4: {
                index -= vectorMap[3];
                if (zoneKind != 0) {
                    TapEnv.toolWarning(-1, "Missing called unit at DFA0");
                    return -1;
                }
                return index + symbolTable.declaredZonesNb(0);
            }
        }
        return -1;
    }

    public final ZoneInfo vectorIndexToZoneInfo(int index, int indexClass, int zoneKind, int[] vectorMap) {
        switch (indexClass) {
            case 3: {
                return this.curSymbolTable.declaredZoneInfo(index - vectorMap[indexClass - 1], zoneKind);
            }
            case 4: {
                return this.curCalledUnit.publicSymbolTable().localDeclaredZoneInfo(index - vectorMap[indexClass - 1] + this.curCalledUnit.publicSymbolTable().firstDeclaredZone(zoneKind), zoneKind);
            }
        }
        return null;
    }

    public static ZoneInfo vectorIndexToZoneInfo(int index, int indexClass, int zoneKind, int[] vectorMap, SymbolTable symbolTable) {
        switch (indexClass) {
            case 3: {
                return symbolTable.declaredZoneInfo(index - vectorMap[indexClass - 1], zoneKind);
            }
            case 4: {
                TapEnv.toolWarning(-1, "Missing called unit at DFA1");
                return null;
            }
        }
        return null;
    }

    public final int extendedDeclaredToVectorIndex(int extendedRk, int zoneKind, int[] vectorMap) {
        if (extendedRk == -1) {
            return -1;
        }
        if (zoneKind == 0) {
            if (extendedRk < 0) {
                return -1;
            }
            if (extendedRk < this.nDZ) {
                if (extendedRk < this.curCallGraph.numberOfDummyRootZones) {
                    return -1;
                }
                return extendedRk + vectorMap[2];
            }
            if (vectorMap.length > 4) {
                return extendedRk - this.nDZ + vectorMap[3];
            }
            return -1;
        }
        if (extendedRk < 0) {
            return -1;
        }
        if (extendedRk < this.nDZ) {
            if (extendedRk < this.curCallGraph.numberOfDummyRootZones) {
                return -1;
            }
            ZoneInfo zi = this.curSymbolTable.declaredZoneInfo(extendedRk, 0);
            int kZoneNb = zi == null ? -1 : zi.kindZoneNb(zoneKind);
            return kZoneNb == -1 ? -1 : kZoneNb + vectorMap[2];
        }
        if (vectorMap.length > 4) {
            ZoneInfo zi = this.curCalledUnit.publicSymbolTable().localDeclaredZoneInfo(extendedRk - this.nDZ + this.curCalledUnit.publicSymbolTable().firstDeclaredZone(0), 0);
            int kZoneNb = zi == null ? -1 : zi.kindZoneNb(zoneKind);
            return kZoneNb == -1 ? -1 : kZoneNb + vectorMap[3];
        }
        return -1;
    }

    public static int extendedDeclaredToVectorIndex(int extendedRk, int zoneKind, int[] vectorMap, SymbolTable symbolTable, Unit calledUnit) {
        if (extendedRk == -1) {
            return -1;
        }
        int nDZ0 = symbolTable.declaredZonesNb(0);
        Unit unit = symbolTable.unit;
        if (zoneKind == 0) {
            if (extendedRk < 0) {
                return -1;
            }
            if (extendedRk < nDZ0) {
                if (extendedRk < symbolTable.getCallGraph().numberOfDummyRootZones) {
                    return -1;
                }
                return extendedRk + vectorMap[2];
            }
            if (vectorMap.length > 4) {
                return extendedRk - nDZ0 + vectorMap[3];
            }
            return -1;
        }
        if (extendedRk < 0) {
            return -1;
        }
        if (extendedRk < nDZ0) {
            if (extendedRk < symbolTable.getCallGraph().numberOfDummyRootZones) {
                return -1;
            }
            ZoneInfo zi = symbolTable.declaredZoneInfo(extendedRk, 0);
            int kZoneNb = zi == null ? -1 : zi.kindZoneNb(zoneKind);
            return kZoneNb == -1 ? -1 : kZoneNb + vectorMap[2];
        }
        if (vectorMap.length > 4) {
            ZoneInfo zi = calledUnit.publicSymbolTable().localDeclaredZoneInfo(extendedRk - nDZ0 + calledUnit.publicSymbolTable().firstDeclaredZone(0), 0);
            int kZoneNb = zi == null ? -1 : zi.kindZoneNb(zoneKind);
            return kZoneNb == -1 ? -1 : kZoneNb + vectorMap[3];
        }
        return -1;
    }

    public final TapIntList mapExtendedDeclaredToVectorIndex(TapIntList extendedRks, int zoneKind, int[] vectorMap) {
        TapIntList hdResult;
        TapIntList tlResult = hdResult = new TapIntList(-1, null);
        while (extendedRks != null) {
            int index = this.extendedDeclaredToVectorIndex(extendedRks.head, zoneKind, vectorMap);
            if (index >= 0) {
                tlResult = tlResult.placdl(index);
            }
            extendedRks = extendedRks.tail;
        }
        return hdResult.tail;
    }

    public static TapIntList mapExtendedDeclaredToVectorIndex(TapIntList extendedRks, int zoneKind, int[] vectorMap, SymbolTable symbolTable, Unit calledUnit) {
        TapIntList hdResult;
        TapIntList tlResult = hdResult = new TapIntList(-1, null);
        while (extendedRks != null) {
            int index = DataFlowAnalyzer.extendedDeclaredToVectorIndex(extendedRks.head, zoneKind, vectorMap, symbolTable, calledUnit);
            if (index >= 0) {
                tlResult = tlResult.placdl(index);
            }
            extendedRks = extendedRks.tail;
        }
        return hdResult.tail;
    }

    public final ZoneInfo extendedDeclaredToZoneInfo(int extendedRk) {
        if (extendedRk < 0) {
            return null;
        }
        if (extendedRk < this.nDZ) {
            return this.curSymbolTable.declaredZoneInfo(extendedRk, 0);
        }
        if (this.curCalledUnit == null || this.curCalledUnit.publicSymbolTable() == null || this.curCalledUnit.publicSymbolTable().hasNoDeclaredZoneInfos(0)) {
            return null;
        }
        return this.curCalledUnit.publicSymbolTable().localDeclaredZoneInfo(extendedRk - this.nDZ + this.curCalledUnit.publicSymbolTable().firstDeclaredZone(0), 0);
    }

    public static ZoneInfo extendedDeclaredToZoneInfo(int extendedRk, SymbolTable symbolTable, Unit calledUnit) {
        int nDZ0 = symbolTable.declaredZonesNb(0);
        Unit unit = symbolTable.unit;
        if (extendedRk < 0) {
            return null;
        }
        if (extendedRk < nDZ0) {
            return symbolTable.declaredZoneInfo(extendedRk, 0);
        }
        if (calledUnit == null || calledUnit.publicSymbolTable() == null || calledUnit.publicSymbolTable().hasNoDeclaredZoneInfos(0)) {
            return null;
        }
        return calledUnit.publicSymbolTable().localDeclaredZoneInfo(extendedRk - nDZ0 + calledUnit.publicSymbolTable().firstDeclaredZone(0), 0);
    }

    public static TapList<ZoneInfo> mapExtendedDeclaredToZoneInfo(TapIntList extendedRks, SymbolTable symbolTable, Unit calledUnit) {
        TapList<Object> hdResult;
        TapList<Object> tlResult = hdResult = new TapList<Object>(null, null);
        while (extendedRks != null) {
            ZoneInfo zoneInfo = DataFlowAnalyzer.extendedDeclaredToZoneInfo(extendedRks.head, symbolTable, calledUnit);
            if (zoneInfo != null) {
                tlResult = tlResult.placdl(zoneInfo);
            }
            extendedRks = extendedRks.tail;
        }
        return hdResult.tail;
    }

    public static TapIntList extendedDeclaredToPublicRanks(TapIntList extendedRks, SymbolTable symbolTable) {
        TapIntList result = null;
        Unit unit = symbolTable.unit;
        for (int i = unit.translator.length - 1; i >= 0; --i) {
            PublicInfo publicInfo = unit.translator[i];
            if (publicInfo == null) continue;
            TapIntList rks = publicInfo.ranks(0);
            boolean found = false;
            while (!found && rks != null) {
                found = TapIntList.contains(extendedRks, rks.head);
                rks = rks.tail;
            }
            if (!found) continue;
            result = new TapIntList(i, result);
        }
        return result;
    }

    public final int extendedDeclaredToClass(int extendedRk) {
        if (extendedRk < 0) {
            return -1;
        }
        if (extendedRk < this.nDZ) {
            return 3;
        }
        return 4;
    }

    public static int extendedDeclaredToClass(int extendedRk, SymbolTable symbolTable) {
        if (extendedRk < 0) {
            return -1;
        }
        if (extendedRk < symbolTable.declaredZonesNb(0)) {
            return 3;
        }
        return 4;
    }

    public final int zoneRkToVectorIndex(int zoneRk, int zoneClass, int zoneKind, int[] vectorMap) {
        if (zoneClass == 4) {
            int firstFormalArgRk = this.curCalledUnit.isStandard() || this.curCalledUnit.isInterface() ? this.curCalledUnit.publicSymbolTable().firstDeclaredZone(zoneKind) : this.curCalledUnit.externalSymbolTable().freeDeclaredZone(zoneKind);
            zoneRk -= firstFormalArgRk;
        }
        if (zoneRk < 0) {
            return -1;
        }
        return (zoneRk += vectorMap[zoneClass - 1]) < vectorMap[zoneClass] ? zoneRk : -1;
    }

    public static int zoneRkToVectorIndex(int zoneRk, int zoneClass, int zoneKind, int[] vectorMap, Unit calledUnit) {
        if (zoneClass == 4) {
            int firstFormalArgRk = calledUnit.isStandard() || calledUnit.isInterface() ? calledUnit.publicSymbolTable().firstDeclaredZone(zoneKind) : calledUnit.externalSymbolTable().freeDeclaredZone(zoneKind);
            zoneRk -= firstFormalArgRk;
        }
        if (zoneRk < 0) {
            return -1;
        }
        return (zoneRk += vectorMap[zoneClass - 1]) < vectorMap[zoneClass] ? zoneRk : -1;
    }

    public final TapIntList mapZoneRkToVectorIndex(TapIntList zoneRks, int zoneClass, int zoneKind, int[] vectorMap) {
        TapIntList hdResult;
        TapIntList tlResult = hdResult = new TapIntList(-1, null);
        while (zoneRks != null) {
            int index = this.zoneRkToVectorIndex(zoneRks.head, zoneClass, zoneKind, vectorMap);
            if (index >= 0) {
                tlResult = tlResult.placdl(index);
            }
            zoneRks = zoneRks.tail;
        }
        return hdResult.tail;
    }

    public static TapIntList mapZoneRkToVectorIndex(TapIntList zoneRks, int zoneClass, int zoneKind, int[] vectorMap, Unit calledUnit) {
        TapIntList hdResult;
        TapIntList tlResult = hdResult = new TapIntList(-1, null);
        while (zoneRks != null) {
            int index = DataFlowAnalyzer.zoneRkToVectorIndex(zoneRks.head, zoneClass, zoneKind, vectorMap, calledUnit);
            if (index >= 0) {
                tlResult = tlResult.placdl(index);
            }
            zoneRks = zoneRks.tail;
        }
        return hdResult.tail;
    }

    public final int zoneRkToExtendedDeclared(int zoneRk, int zoneClass, int zoneKind) {
        if (zoneRk < 0) {
            return -1;
        }
        if (zoneKind != 0) {
            ZoneInfo zoneInfo = this.zoneRkToZoneInfo(zoneRk, zoneClass, zoneKind);
            if (zoneInfo == null || zoneInfo.zoneNb < 0) {
                return -1;
            }
            zoneRk = zoneInfo.zoneNb;
        }
        switch (zoneClass) {
            case 3: {
                return zoneRk;
            }
            case 4: {
                return zoneRk - this.curCalledUnit.publicSymbolTable().firstDeclaredZone(0) + this.nDZ;
            }
        }
        return -1;
    }

    public static int zoneRkToExtendedDeclared(int zoneRk, int zoneClass, int zoneKind, SymbolTable symbolTable, Unit calledUnit) {
        if (zoneRk < 0) {
            return -1;
        }
        if (zoneKind != 0) {
            ZoneInfo zoneInfo = DataFlowAnalyzer.zoneRkToZoneInfo(zoneRk, zoneClass, zoneKind, symbolTable, calledUnit);
            if (zoneInfo == null || zoneInfo.zoneNb < 0) {
                return -1;
            }
            zoneRk = zoneInfo.zoneNb;
        }
        switch (zoneClass) {
            case 3: {
                return zoneRk;
            }
            case 4: {
                return zoneRk - calledUnit.publicSymbolTable().firstDeclaredZone(0) + symbolTable.declaredZonesNb(0);
            }
        }
        return -1;
    }

    public final ZoneInfo zoneRkToZoneInfo(int zoneRk, int zoneClass, int zoneKind) {
        switch (zoneClass) {
            case 3: {
                return this.curSymbolTable.declaredZoneInfo(zoneRk, zoneKind);
            }
            case 4: {
                if (this.curCalledUnit.isStandard() || this.curCalledUnit.isInterface()) {
                    return this.curCalledUnit.publicSymbolTable().declaredZoneInfo(zoneRk, zoneKind);
                }
                ZoneInfo zi = null;
                for (int i = this.curCalledUnit.paramElemsNb() - 1; zi == null && i >= 0; --i) {
                    if (this.curCalledUnit.paramElemZoneInfo(i).kindZoneNb(zoneKind) != zoneRk) continue;
                    zi = this.curCalledUnit.paramElemZoneInfo(i);
                }
                return zi;
            }
        }
        return null;
    }

    public static ZoneInfo zoneRkToZoneInfo(int zoneRk, int zoneClass, int zoneKind, SymbolTable symbolTable, Unit calledUnit) {
        switch (zoneClass) {
            case 3: {
                return symbolTable.declaredZoneInfo(zoneRk, zoneKind);
            }
            case 4: {
                if (calledUnit.isStandard() || calledUnit.isInterface()) {
                    return calledUnit.publicSymbolTable().declaredZoneInfo(zoneRk, zoneKind);
                }
                ZoneInfo zi = null;
                for (int i = calledUnit.paramElemsNb() - 1; zi == null && i >= 0; --i) {
                    if (calledUnit.paramElemZoneInfo(i).kindZoneNb(zoneKind) != zoneRk) continue;
                    zi = calledUnit.paramElemZoneInfo(i);
                }
                return zi;
            }
        }
        return null;
    }

    public static int zoneRkToPublicRk(int zoneRk, int zoneKind, Unit calledUnit) {
        if (!calledUnit.hasParamElemsInfo()) {
            return -1;
        }
        int nbPublicZones = calledUnit.paramElemsNb();
        int foundI = -1;
        for (int i = nbPublicZones - 1; i >= 0 && foundI == -1; --i) {
            if (calledUnit.paramElemZoneInfo(i).kindZoneNb(zoneKind) != zoneRk) continue;
            foundI = i;
        }
        return foundI;
    }

    public static TapIntList mapZoneRkToPublicRk(TapIntList zoneRks, int zoneKind, Unit calledUnit) {
        TapIntList hdResult;
        TapIntList tlResult = hdResult = new TapIntList(-1, null);
        while (zoneRks != null) {
            int index = DataFlowAnalyzer.zoneRkToPublicRk(zoneRks.head, zoneKind, calledUnit);
            if (index >= 0) {
                tlResult = tlResult.placdl(index);
            }
            zoneRks = zoneRks.tail;
        }
        return hdResult.tail;
    }

    public final int zoneInfoToVectorIndex(ZoneInfo zoneInfo, int zoneClass, int zoneKind, int[] vectorMap) {
        if (zoneInfo.kindZoneNb(zoneKind) == -1) {
            return -1;
        }
        if (zoneClass == 4) {
            return vectorMap[3] + zoneInfo.kindZoneNb(zoneKind) - this.curCalledUnit.publicSymbolTable().firstDeclaredZone(zoneKind);
        }
        return vectorMap[zoneClass - 1] + zoneInfo.kindZoneNb(zoneKind);
    }

    public static int zoneInfoToVectorIndex(ZoneInfo zoneInfo, int zoneClass, int zoneKind, int[] vectorMap, Unit calledUnit) {
        if (zoneInfo.kindZoneNb(zoneKind) == -1) {
            return -1;
        }
        if (zoneClass == 4) {
            return vectorMap[3] + zoneInfo.kindZoneNb(zoneKind) - calledUnit.publicSymbolTable().firstDeclaredZone(zoneKind);
        }
        return vectorMap[zoneClass - 1] + zoneInfo.kindZoneNb(zoneKind);
    }

    public final int zoneInfoToExtendedDeclared(ZoneInfo zoneInfo, int zoneClass) {
        switch (zoneClass) {
            case 3: {
                return zoneInfo.zoneNb;
            }
            case 4: {
                return zoneInfo.zoneNb - this.curCalledUnit.publicSymbolTable().firstDeclaredZone(0) + this.curSymbolTable.declaredZonesNb(0);
            }
        }
        return this.curCallGraph.zoneNbOfUnknownDest;
    }

    public static int zoneInfoToExtendedDeclared(ZoneInfo zoneInfo, int zoneClass, SymbolTable symbolTable, Unit calledUnit) {
        switch (zoneClass) {
            case 3: {
                return zoneInfo.zoneNb;
            }
            case 4: {
                return zoneInfo.zoneNb - calledUnit.publicSymbolTable().firstDeclaredZone(0) + symbolTable.declaredZonesNb(0);
            }
        }
        return symbolTable.getCallGraph().zoneNbOfUnknownDest;
    }

    public static BoolMatrix filterByValue(BoolMatrix publicDeps, Unit unit) {
        if (publicDeps != null) {
            TapIntList byValueRows = null;
            for (int i = publicDeps.nRows - 1; i >= 0; --i) {
                ZoneInfo zi = unit.paramElemZoneInfo(i);
                if (zi == null || !zi.passesByValue(unit, unit.language())) continue;
                byValueRows = new TapIntList(i, byValueRows);
            }
            if (byValueRows != null) {
                publicDeps = publicDeps.copy();
                while (byValueRows != null) {
                    publicDeps.setRow(byValueRows.head, null);
                    byValueRows = byValueRows.tail;
                }
            }
        }
        return publicDeps;
    }
}

