/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.analysis;

import fr.inria.tapenade.analysis.DataFlowAnalyzer;
import fr.inria.tapenade.analysis.DiffLivenessAnalyzer;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.BlockStorage;
import fr.inria.tapenade.representation.DiffPattern;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.utils.BoolMatrix;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.Tree;
import java.io.IOException;

public final class ActivityPattern {
    private Unit unit;
    private DiffPattern diffPattern;
    private TapList<ActivityPattern> callingPatterns;
    private BoolVector callActivity;
    private BoolVector exitActivity;
    private BoolVector callUsefulness;
    private BoolVector exitUsefulness;
    private BoolVector usefulOnCallingSide;
    private TapTriplet<Unit, BoolVector, BoolVector>[] varFunctionADActivities;
    private BoolVector zonesOfVarsHaveDiff;
    private BoolVector zonesMPIiReceived;
    private int zonesMPIiReceivedLength;
    private boolean generalizable;
    private BoolVector staticActivity;
    private BlockStorage<TapList<BoolVector>> activities;
    private BlockStorage<TapList<BoolVector>> usefulnesses;
    private BlockStorage<TapList<BoolVector>> reqXs;
    private BlockStorage<TapList<BoolVector>> avlXs;
    private BoolVector entryReqX;
    private BoolVector exitReqX;
    private BoolVector entryAvlX;
    private BoolVector exitAvlX;
    private BoolMatrix reqXEffects;
    private BoolVector reqXEffectsAdded;
    private BoolVector avlXEffectsVisible;
    private BoolVector avlXEffectsAdded;
    private BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> diffLivenesses;
    private BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> diffLivenessesCkp;
    private BoolVector entryDiffLivenessesCkp;
    private BoolVector entryDiffLivenessesCkpOnDiffPtr;
    private TapList<TapPair<Block, TapPair<BoolVector, BoolVector>>> fragmentDiffLivenessesCkp = null;
    private BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> diffOverwrites;
    private BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> diffOverwritesCkp;
    private BoolVector entryDiffOverwritesCkp;
    private BoolVector entryDiffOverwritesCkpOnDiffPtr;
    private BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> tbrs;
    private BoolVector localExitTBR;
    private BoolVector localExitTBROnDiffPtr;
    private BlockStorage<TapList<TapPair<TapList<Instruction>, TapList<Instruction>>>> recomps;
    private BoolVector adTBRTopDownContext;
    private BoolVector adTBRTopDownContextOnDiffPtr;
    private BlockStorage<int[]> mayBeRecomputed;
    private BlockStorage<int[]> butRemainsInFwdSweep;
    private boolean isForcedActive;
    private boolean dontDiff;
    private boolean isContext;
    private DiffLivenessAnalyzer.Context diffLivenessTopDownContext;
    private BoolVector usefulOnExit;
    private BoolVector variedOnCall;

    public ActivityPattern(Unit unit, boolean generalizable, boolean forceActive, int diffKind) {
        this.unit = unit;
        this.generalizable = generalizable;
        this.isForcedActive = forceActive;
        this.initTypes(diffKind);
    }

    public ActivityPattern(Unit unit, BoolVector variedOnCall, BoolVector usefulOnExit, boolean generalizable, int diffKind) {
        this.unit = unit;
        this.variedOnCall = variedOnCall;
        this.usefulOnExit = usefulOnExit;
        this.generalizable = generalizable;
        this.initTypes(diffKind);
    }

    public void copyReqExplicitInfos(ActivityPattern model) {
        if (model.reqXEffects != null) {
            this.reqXEffects = model.reqXEffects.copy();
        }
        if (model.reqXEffectsAdded != null) {
            this.reqXEffectsAdded = model.reqXEffectsAdded.copy();
        }
        if (model.avlXEffectsVisible != null) {
            this.avlXEffectsVisible = model.avlXEffectsVisible.copy();
        }
        if (model.avlXEffectsAdded != null) {
            this.avlXEffectsAdded = model.avlXEffectsAdded.copy();
        }
        if (model.entryReqX != null) {
            this.entryReqX = model.entryReqX.copy();
        }
        if (model.exitReqX != null) {
            this.exitReqX = model.exitReqX.copy();
        }
        if (model.entryAvlX != null) {
            this.entryAvlX = model.entryAvlX.copy();
        }
        if (model.exitAvlX != null) {
            this.exitAvlX = model.exitAvlX.copy();
        }
    }

    public static void walkUpToPatternOf(ActivityPattern pattern, Unit unit, TapList<ActivityPattern> collected, TapList<ActivityPattern> dejaVu) {
        if (!TapList.contains(dejaVu.tail, pattern)) {
            dejaVu.placdl(pattern);
            if (pattern.unit == unit) {
                collected.placdl(pattern);
            } else {
                TapList<ActivityPattern> inCallingPatterns = pattern.callingPatterns;
                while (inCallingPatterns != null) {
                    ActivityPattern.walkUpToPatternOf((ActivityPattern)inCallingPatterns.head, unit, collected, dejaVu);
                    inCallingPatterns = inCallingPatterns.tail;
                }
            }
        }
    }

    public static void setAnnotationForActivityPattern(Tree tree, ActivityPattern pattern, String name, Object val) {
        TapPair<ActivityPattern, Object> patternPair;
        TapPair<String, Object> annotPair = tree.getAnnotationPair(name);
        if (annotPair == null) {
            annotPair = tree.setAnnotation(name, null);
        }
        if ((patternPair = TapList.assq(pattern, (TapList)annotPair.second)) == null) {
            patternPair = new TapPair<ActivityPattern, Object>(pattern, null);
            annotPair.second = new TapList(patternPair, (TapList)annotPair.second);
        }
        patternPair.second = val;
    }

    public static void removeAnnotationForActivityPattern(Tree tree, ActivityPattern pattern, String name) {
        TapPair annotPair = tree.getAnnotationPair(name);
        if (annotPair != null) {
            TapList<Object> toPatternAList;
            TapList<Object> inPatternAList = toPatternAList = new TapList<Object>(null, (TapList)annotPair.second);
            while (inPatternAList.tail != null) {
                if (((TapPair)inPatternAList.tail.head).first == pattern) {
                    inPatternAList.tail = inPatternAList.tail.tail;
                    continue;
                }
                inPatternAList = inPatternAList.tail;
            }
            annotPair.second = toPatternAList.tail;
        }
    }

    public static Object getAnnotationForActivityPattern(Tree tree, ActivityPattern pattern, String name) {
        TapPair annotPair = tree.getAnnotationPair(name);
        if (annotPair != null) {
            return TapList.cassq(pattern, (TapList)annotPair.second);
        }
        return null;
    }

    public static void setInstructionBoolInfo(BlockStorage<int[]> info, Instruction instruction, int infoRk, boolean value) {
        Block block = instruction.block;
        if (block.rank >= 0) {
            int[] intArray = info.retrieve(block);
            int rank = block.instructions.rank(instruction);
            int code = intArray[rank];
            if (infoRk == 1) {
                if (!(value && code % 2 == 0 || value || code % 2 == 0)) {
                    ++code;
                }
            } else if (infoRk == 2) {
                if (value && code % 4 < 2) {
                    code += 2;
                } else if (!value && code % 4 >= 2) {
                    code -= 2;
                }
            } else {
                TapEnv.toolWarning(-1, "(setInstructionBoolInfo) infoRk=" + infoRk + " not implemented ");
            }
            intArray[rank] = ++code;
        }
    }

    public static boolean getInstructionBoolInfo(BlockStorage<int[]> info, Instruction instruction, int infoRk) {
        Block block = instruction.block;
        if (block.rank < 0) {
            return false;
        }
        int[] intArray = info.retrieve(block);
        int rank = block.instructions.rank(instruction);
        int code = intArray[rank];
        if (infoRk == 1) {
            return code % 2 != 0;
        }
        if (infoRk == 2) {
            return code % 4 >= 2;
        }
        TapEnv.toolWarning(-1, "(setInstructionBoolInfo) infoRk=" + infoRk + " not implemented ");
        return false;
    }

    public Unit unit() {
        return this.unit;
    }

    public DiffPattern diffPattern() {
        return this.diffPattern;
    }

    public void setDiffPattern(DiffPattern diffPattern) {
        this.diffPattern = diffPattern;
    }

    public TapList<ActivityPattern> callingPatterns() {
        return this.callingPatterns;
    }

    public BoolVector callActivity() {
        return this.callActivity;
    }

    public void setCallActivity(BoolVector callActivity) {
        this.callActivity = callActivity;
    }

    public BoolVector exitActivity() {
        return this.exitActivity;
    }

    public void setExitActivity(BoolVector exitActivity) {
        this.exitActivity = exitActivity;
    }

    public BoolVector callUsefulness() {
        return this.callUsefulness;
    }

    public void setCallUsefulness(BoolVector callUsefulness) {
        this.callUsefulness = callUsefulness;
    }

    public BoolVector exitUsefulness() {
        return this.exitUsefulness;
    }

    public void setExitUsefulness(BoolVector exitUsefulness) {
        this.exitUsefulness = exitUsefulness;
    }

    public BoolVector usefulOnCallingSide() {
        return this.usefulOnCallingSide;
    }

    public void setUsefulOnCallingSide(BoolVector usefulnessOnCallingSide) {
        this.usefulOnCallingSide = usefulnessOnCallingSide;
    }

    public TapTriplet<Unit, BoolVector, BoolVector>[] varFunctionADActivities() {
        return this.varFunctionADActivities;
    }

    public BoolVector zonesOfVarsHaveDiff() {
        return this.zonesOfVarsHaveDiff;
    }

    public BoolVector zonesMPIiReceived() {
        return this.zonesMPIiReceived;
    }

    public int zonesMPIiReceivedLength() {
        return this.zonesMPIiReceivedLength;
    }

    public boolean isGeneralizable() {
        return this.generalizable;
    }

    public BoolVector staticActivity() {
        return this.staticActivity;
    }

    public void setStaticActivity(BoolVector staticActivity) {
        this.staticActivity = staticActivity;
    }

    public BlockStorage<TapList<BoolVector>> activities() {
        return this.activities;
    }

    public void setActivities(BlockStorage<TapList<BoolVector>> activities) {
        this.activities = activities;
    }

    public BlockStorage<TapList<BoolVector>> usefulnesses() {
        return this.usefulnesses;
    }

    public void setUsefulnesses(BlockStorage<TapList<BoolVector>> usefulnesses) {
        this.usefulnesses = usefulnesses;
    }

    public BlockStorage<TapList<BoolVector>> reqXs() {
        return this.reqXs;
    }

    public void setReqXs(BlockStorage<TapList<BoolVector>> reqXs) {
        this.reqXs = reqXs;
    }

    public BlockStorage<TapList<BoolVector>> avlXs() {
        return this.avlXs;
    }

    public void setAvlXs(BlockStorage<TapList<BoolVector>> avlXs) {
        this.avlXs = avlXs;
    }

    public BoolVector entryReqX() {
        return this.entryReqX;
    }

    public void setEntryReqX(BoolVector entryReqX) {
        this.entryReqX = entryReqX;
    }

    public BoolVector exitReqX() {
        return this.exitReqX;
    }

    public void setExitReqX(BoolVector exitReqX) {
        this.exitReqX = exitReqX;
    }

    public BoolVector entryAvlX() {
        return this.entryAvlX;
    }

    public void setEntryAvlX(BoolVector entryAvlX) {
        this.entryAvlX = entryAvlX;
    }

    public BoolVector exitAvlX() {
        return this.exitAvlX;
    }

    public void setExitAvlX(BoolVector exitAvlX) {
        this.exitAvlX = exitAvlX;
    }

    public BoolMatrix reqXEffects() {
        return this.reqXEffects;
    }

    public void setReqXEffects(BoolMatrix reqXEffects) {
        this.reqXEffects = reqXEffects;
    }

    public BoolVector reqXEffectsAdded() {
        return this.reqXEffectsAdded;
    }

    public void setReqXEffectsAdded(BoolVector reqXEffectsAdded) {
        this.reqXEffectsAdded = reqXEffectsAdded;
    }

    public BoolVector avlXEffectsVisible() {
        return this.avlXEffectsVisible;
    }

    public void setAvlXEffectsVisible(BoolVector avlXEffectsVisible) {
        this.avlXEffectsVisible = avlXEffectsVisible;
    }

    public BoolVector avlXEffectsAdded() {
        return this.avlXEffectsAdded;
    }

    public void setAvlXEffectsAdded(BoolVector avlXEffectsAdded) {
        this.avlXEffectsAdded = avlXEffectsAdded;
    }

    public BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> diffLivenesses() {
        return this.diffLivenesses;
    }

    public void setDiffLivenesses(BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> diffLivenesses) {
        this.diffLivenesses = diffLivenesses;
    }

    public BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> diffLivenessesCkp() {
        return this.diffLivenessesCkp;
    }

    public void setDiffLivenessesCkp(BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> diffLivenessesCkp) {
        this.diffLivenessesCkp = diffLivenessesCkp;
    }

    public BoolVector entryDiffLivenessesCkp() {
        return this.entryDiffLivenessesCkp;
    }

    public void setEntryDiffLivenessesCkp(BoolVector entryDiffLivenessesCkp) {
        this.entryDiffLivenessesCkp = entryDiffLivenessesCkp;
    }

    public BoolVector entryDiffLivenessesCkpOnDiffPtr() {
        return this.entryDiffLivenessesCkpOnDiffPtr;
    }

    public void setEntryDiffLivenessesCkpOnDiffPtr(BoolVector entryDiffLivenessesCkpOnDiffPtr) {
        this.entryDiffLivenessesCkpOnDiffPtr = entryDiffLivenessesCkpOnDiffPtr;
    }

    public TapPair<BoolVector, BoolVector> fragmentDiffLivenessesCkp(Block ckpBlock) {
        return (TapPair)TapList.cassq(ckpBlock, this.fragmentDiffLivenessesCkp);
    }

    public void setFragmentDiffLivenessesCkp(Block ckpBlock, TapPair<BoolVector, BoolVector> info) {
        TapPair<Block, Object> found = TapList.assq(ckpBlock, this.fragmentDiffLivenessesCkp);
        if (found == null) {
            found = new TapPair<Block, Object>(ckpBlock, null);
            this.fragmentDiffLivenessesCkp = new TapList<TapPair<Block, TapPair<BoolVector, BoolVector>>>(found, this.fragmentDiffLivenessesCkp);
        }
        found.second = info;
    }

    public BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> diffOverwrites() {
        return this.diffOverwrites;
    }

    public void setDiffOverwrites(BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> diffOverwrites) {
        this.diffOverwrites = diffOverwrites;
    }

    public BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> diffOverwritesCkp() {
        return this.diffOverwritesCkp;
    }

    public void setDiffOverwritesCkp(BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> diffOverwritesCkp) {
        this.diffOverwritesCkp = diffOverwritesCkp;
    }

    public BoolVector entryDiffOverwritesCkp() {
        return this.entryDiffOverwritesCkp;
    }

    public void setEntryDiffOverwritesCkp(BoolVector entryDiffOverwritesCkp) {
        this.entryDiffOverwritesCkp = entryDiffOverwritesCkp;
    }

    public BoolVector entryDiffOverwritesCkpOnDiffPtr() {
        return this.entryDiffOverwritesCkpOnDiffPtr;
    }

    public void setEntryDiffOverwritesCkpOnDiffPtr(BoolVector entryDiffOverwritesCkpOnDiffPtr) {
        this.entryDiffOverwritesCkpOnDiffPtr = entryDiffOverwritesCkpOnDiffPtr;
    }

    public BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> tbrs() {
        return this.tbrs;
    }

    public void setTbrs(BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> tbrs) {
        this.tbrs = tbrs;
    }

    public BoolVector localExitTBR() {
        return this.localExitTBR;
    }

    public void setLocalExitTBR(BoolVector localExitTBR) {
        this.localExitTBR = localExitTBR;
    }

    public BoolVector localExitTBROnDiffPtr() {
        return this.localExitTBROnDiffPtr;
    }

    public void setLocalExitTBROnDiffPtr(BoolVector localExitTBROnDiffPtr) {
        this.localExitTBROnDiffPtr = localExitTBROnDiffPtr;
    }

    public BlockStorage<TapList<TapPair<TapList<Instruction>, TapList<Instruction>>>> recomps() {
        return this.recomps;
    }

    public void setRecomps(BlockStorage<TapList<TapPair<TapList<Instruction>, TapList<Instruction>>>> recomps) {
        this.recomps = recomps;
    }

    public BoolVector adTBRTopDownContext() {
        return this.adTBRTopDownContext;
    }

    public void setAdTBRTopDownContext(BoolVector adTBRTopDownContext) {
        this.adTBRTopDownContext = adTBRTopDownContext;
    }

    public BoolVector adTBRTopDownContextOnDiffPtr() {
        return this.adTBRTopDownContextOnDiffPtr;
    }

    public void setAdTBRTopDownContextOnDiffPtr(BoolVector adTBRTopDownContextOnDiffPtr) {
        this.adTBRTopDownContextOnDiffPtr = adTBRTopDownContextOnDiffPtr;
    }

    public BlockStorage<int[]> mayBeRecomputed() {
        return this.mayBeRecomputed;
    }

    public BlockStorage<int[]> butRemainsInFwdSweep() {
        return this.butRemainsInFwdSweep;
    }

    public boolean isForcedActive() {
        return this.isForcedActive;
    }

    public void setForcedActive(boolean forcedActive) {
        this.isForcedActive = forcedActive;
    }

    public boolean isDontDiff() {
        return this.dontDiff;
    }

    public void setDontDiff(boolean dontDiff) {
        this.dontDiff = dontDiff;
    }

    public boolean isContext() {
        return this.isContext;
    }

    public void setContext(boolean context) {
        this.isContext = context;
    }

    public DiffLivenessAnalyzer.Context diffLivenessTopDownContext() {
        return this.diffLivenessTopDownContext;
    }

    public void setDiffLivenessTopDownContext(DiffLivenessAnalyzer.Context diffLivenessTopDownContext) {
        this.diffLivenessTopDownContext = diffLivenessTopDownContext;
    }

    public BoolVector variedOnCall() {
        return this.variedOnCall;
    }

    public BoolVector usefulOnExit() {
        return this.usefulOnExit;
    }

    private void initTypes(int diffKind) {
        if (this.unit != null && this.unit.hasParamElemsInfo()) {
            int shapeLength = this.unit.paramElemsNb();
            this.callActivity = new BoolVector(shapeLength);
            this.exitActivity = new BoolVector(shapeLength);
            if (this.unit.privateSymbolTable() != null) {
                int[] diffMap = DataFlowAnalyzer.makeMap3(0, 0, this.unit.privateSymbolTable() == null ? 0 : this.unit.privateSymbolTable().declaredZonesNb(diffKind));
                this.zonesOfVarsHaveDiff = new BoolVector(DataFlowAnalyzer.mapSize(diffMap));
                this.zonesMPIiReceived = new BoolVector(DataFlowAnalyzer.mapSize(diffMap));
                this.zonesMPIiReceivedLength = DataFlowAnalyzer.mapSize(diffMap);
            }
            int nbArgs = this.unit.formalArgumentsNb();
            this.varFunctionADActivities = new TapTriplet[nbArgs];
            for (int i = nbArgs - 1; i >= 0; --i) {
                this.varFunctionADActivities[i] = null;
            }
        }
    }

    public void registerCallingActivityPattern(ActivityPattern callingPattern) {
        if (!TapList.contains(this.callingPatterns, callingPattern)) {
            this.callingPatterns = new TapList<ActivityPattern>(callingPattern, this.callingPatterns);
        }
    }

    public boolean isCalledBy(Unit caller, ActivityPattern callerActivityPattern, TapList<ActivityPattern> dejaVu) {
        TapList<ActivityPattern> inCallingPatterns = this.callingPatterns;
        boolean called = false;
        while (!called && inCallingPatterns != null) {
            ActivityPattern callingPattern = (ActivityPattern)inCallingPatterns.head;
            if (callingPattern != null && !TapList.contains(dejaVu, callingPattern)) {
                called = callingPattern == callerActivityPattern && callingPattern.unit == caller || callingPattern.isCalledBy(caller, callerActivityPattern, new TapList<ActivityPattern>(callingPattern, dejaVu));
            }
            inCallingPatterns = inCallingPatterns.tail;
        }
        return called;
    }

    public ActivityPattern getCallingActivityPattern(Unit caller, TapList<ActivityPattern> dejaVu) {
        TapList<ActivityPattern> inCallingPatterns = this.callingPatterns;
        ActivityPattern found = null;
        while (found == null && inCallingPatterns != null) {
            ActivityPattern callingPattern = (ActivityPattern)inCallingPatterns.head;
            if (callingPattern != null && !TapList.contains(dejaVu, callingPattern)) {
                found = callingPattern.unit == caller ? callingPattern : callingPattern.getCallingActivityPattern(caller, new TapList<ActivityPattern>(callingPattern, dejaVu));
            }
            inCallingPatterns = inCallingPatterns.tail;
        }
        return found;
    }

    public void initializeMayBeRecomputed() {
        this.mayBeRecomputed = new BlockStorage(this.unit);
        TapList<Block> blocks = this.unit.allBlocks();
        while (blocks != null) {
            Block block = (Block)blocks.head;
            int[] intArray = new int[TapList.length(block.instructions)];
            for (int i = intArray.length - 1; i >= 0; --i) {
                intArray[i] = 0;
            }
            this.mayBeRecomputed.store(block, intArray);
            blocks = blocks.tail;
        }
    }

    public void initializeButRemainsInFwdSweep() {
        this.butRemainsInFwdSweep = new BlockStorage(this.unit);
        TapList<Block> blocks = this.unit.allBlocks();
        while (blocks != null) {
            Block block = (Block)blocks.head;
            int[] intArray = new int[TapList.length(block.instructions)];
            for (int i = intArray.length - 1; i >= 0; --i) {
                intArray[i] = 0;
            }
            this.butRemainsInFwdSweep.store(block, intArray);
            blocks = blocks.tail;
        }
    }

    public boolean isDisconnected() {
        return this.diffPattern == null && this.callingPatterns == null;
    }

    public boolean isActive() {
        if (this.isForcedActive) {
            return true;
        }
        int shapeLength = this.unit.paramElemsNb();
        return this.callActivity != null && this.exitActivity != null && !this.callActivity.isFalse(shapeLength) && !this.exitActivity.isFalse(shapeLength) || TapEnv.reqExplicitAnalyzer() != null && TapEnv.reqExplicitAnalyzer().isPointerActiveUnit(this);
    }

    public void dump() throws IOException {
        int[] unitPublicMap = new int[]{0, this.unit.paramElemsNb()};
        String unitPublicMapName = "[x" + this.unit.rank() + ":a]";
        TapEnv.print("     " + this.toString() + " called by {");
        TapList<ActivityPattern> callers = this.callingPatterns();
        while (callers != null) {
            TapEnv.print(" @" + Integer.toHexString(((ActivityPattern)callers.head).hashCode()));
            callers = callers.tail;
        }
        TapEnv.println(this.diffPattern() != null ? "} also a diff root: " + this.diffPattern() : "}");
        TapEnv.print("       activity:");
        TapEnv.dumpBoolVector(this.callActivity(), unitPublicMap, unitPublicMapName);
        TapEnv.print("=>");
        TapEnv.dumpBoolVector(this.exitActivity(), unitPublicMap, unitPublicMapName);
        TapEnv.println((this.isForcedActive() ? " forcedActive" : "") + (this.isDontDiff() ? " dontDiff" : ""));
        TapEnv.print("       ReqX:    ");
        TapEnv.dumpBoolVector(this.entryReqX(), unitPublicMap, unitPublicMapName);
        TapEnv.print("=>");
        TapEnv.dumpBoolVector(this.exitReqX(), unitPublicMap, unitPublicMapName);
        TapEnv.println();
        TapEnv.print("       AvlX:    ");
        TapEnv.dumpBoolVector(this.entryAvlX(), unitPublicMap, unitPublicMapName);
        TapEnv.print("=>");
        TapEnv.dumpBoolVector(this.exitAvlX(), unitPublicMap, unitPublicMapName);
    }

    public String toString() {
        String result = "AP@" + Integer.toHexString(this.hashCode()) + " {";
        if (this.callingPatterns != null) {
            result = result + "called, ";
        }
        if (this.diffPattern != null) {
            result = result + "diffRoot, ";
        }
        if (this.isContext) {
            result = result + "context, ";
        }
        if (this.diffPattern == null && this.callingPatterns == null) {
            result = result + "not connected, ";
        }
        if (this.isForcedActive) {
            result = result + "forcedActive, ";
        }
        if (this.dontDiff) {
            result = result + "but don't diff, ";
        }
        return result + "on " + this.unit + "}";
    }
}

