/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.analysis;

import fr.inria.tapenade.analysis.ADActivityAnalyzer;
import fr.inria.tapenade.analysis.ActivityPattern;
import fr.inria.tapenade.analysis.DataFlowAnalyzer;
import fr.inria.tapenade.analysis.DiffLivenessAnalyzer;
import fr.inria.tapenade.analysis.InOutAnalyzer;
import fr.inria.tapenade.analysis.ReqExplicit;
import fr.inria.tapenade.representation.AtomFuncDerivative;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.BlockStorage;
import fr.inria.tapenade.representation.CallArrow;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.HeaderBlock;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.InstructionMask;
import fr.inria.tapenade.representation.LoopBlock;
import fr.inria.tapenade.representation.MPIcallInfo;
import fr.inria.tapenade.representation.NewSymbolHolder;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.ToInt;
import fr.inria.tapenade.utils.Tree;

public final class ADTBRAnalyzer
extends DataFlowAnalyzer {
    private static final int BOTTOMUP_1 = 1;
    private static final int TOPDOWN_2 = 2;
    private BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> curUnitTBRs;
    private BlockStorage<TapPair<BoolVector, BoolVector>> tbrsDown;
    private BlockStorage<TapPair<BoolVector, BoolVector>> tbrsCycleDown;
    private BlockStorage<TapPair<BoolVector, BoolVector>> tbrsUp;
    private BlockStorage<TapPair<BoolVector, BoolVector>> tbrsCycleUp;
    private BoolVector tbrTmp;
    private BoolVector tbrTmpOnDiffPtr;
    private BoolVector tbrTmpCycle;
    private BoolVector tbrTmpCycleOnDiffPtr;
    private BoolVector additionalTBR;
    private BoolVector additionalTBROnDiffPtr;
    private BlockStorage<TapIntList> cleanLoopIndexZones;
    private BlockStorage<TapList<TapPair<TapList<Instruction>, TapList<Instruction>>>> curUnitRecomps;
    private BlockStorage<int[]> curUnitMayBeRecomputeds;
    private BlockStorage<int[]> curUnitButRemainsInFwdSweeps;
    private BlockStorage<RecompInfo[]> recompsDown;
    private BlockStorage<RecompInfo[]> recompsCycleDown;
    private BlockStorage<RecompInfo[]> recompsUp;
    private BlockStorage<RecompInfo[]> recompsCycleUp;
    private RecompInfo[] recompTmp;
    private RecompInfo[] recompTmpCycle;
    private RecompInfo[] additionalRecomp;
    private BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> curUnitDiffLivenesses;
    private BlockStorage<TapList<TapPair<BoolVector, BoolVector>>> curUnitDiffOverwrites;
    private int nDPZ;
    private int[] vectorMap;
    private int[] pointerVectorMap;
    private int phase;

    private ADTBRAnalyzer(CallGraph callGraph) {
        super(callGraph, "TBR Analysis", TapEnv.traceTBR());
        this.conservativeValue = true;
    }

    public static void runAnalysis(CallGraph callgraph, TapList<Unit> rootUnits) {
        TapEnv.setADTBRAnalyzer(new ADTBRAnalyzer(callgraph));
        TapEnv.adTbrAnalyzer().run(rootUnits);
    }

    private static boolean findBlockLoopKindIsDoLoop(Block block) {
        if (block instanceof HeaderBlock) {
            Instruction loopInstr = block.headInstr();
            LoopBlock loopBlock = block.enclosingLoop();
            return loopBlock.entryBlocks != null && loopBlock.entryBlocks.tail == null && loopBlock.exitBlocks.tail == null && loopBlock.exitBlocks.head == block && loopBlock.exitArrows != null && block.instructions != null && block.instructions.tail == null && block.headInstr().tree.opCode() == 121 && loopInstr.tree.down(3).opCode() == 64 && loopInstr.hasDirective(13) == null;
        }
        return false;
    }

    public static boolean isTBROnDiffPtr(ActivityPattern curActivity, Tree tree) {
        Object annotationTBR = ActivityPattern.getAnnotationForActivityPattern(tree, curActivity, "TBR");
        return annotationTBR != null && ((boolean[])annotationTBR)[1];
    }

    public static boolean isTBR(ActivityPattern curActivity, Tree tree) {
        Object annotationTBR = ActivityPattern.getAnnotationForActivityPattern(tree, curActivity, "TBR");
        return annotationTBR != null && ((boolean[])annotationTBR)[0];
    }

    public static boolean isTBRindex(ActivityPattern curActivity, Tree indexTree) {
        Object annotationTBR = ActivityPattern.getAnnotationForActivityPattern(indexTree, curActivity, "TBR");
        return annotationTBR != null;
    }

    public static boolean isTBRindexOnLoopEntry(ActivityPattern curActivity, Tree indexTree) {
        Object annotationTBR = ActivityPattern.getAnnotationForActivityPattern(indexTree, curActivity, "TBR");
        return annotationTBR != null && ((TapIntList)annotationTBR).head == 1;
    }

    public static boolean isTBRindexOnLoopCycle(ActivityPattern curActivity, Tree indexTree) {
        Object annotationTBR = ActivityPattern.getAnnotationForActivityPattern(indexTree, curActivity, "TBR");
        return annotationTBR != null && ((TapIntList)annotationTBR).tail.head == 1;
    }

    public static void copyAnnotation(ActivityPattern curActivity, Tree fromTree, Tree toTree) {
        Object annotationTBR = ActivityPattern.getAnnotationForActivityPattern(fromTree, curActivity, "TBR");
        if (annotationTBR != null) {
            ActivityPattern.setAnnotationForActivityPattern(toTree, curActivity, "TBR", annotationTBR);
        }
    }

    private static boolean isTreeRequiredInDiff(ActivityPattern curActivity, Tree tree, boolean onDiffPtr) {
        return tree == null || DiffLivenessAnalyzer.isTreeRequiredInDiff(curActivity, tree, true, onDiffPtr) || DiffLivenessAnalyzer.isTreeRequiredInDiff(curActivity, tree, false, onDiffPtr);
    }

    @Override
    protected void run(TapList<Unit> rootUnits) {
        this.runBottomUpTopDownAnalysis(rootUnits);
    }

    public void setCurUnitActivity(ActivityPattern activity) {
        this.curActivity = activity;
    }

    public void setPhaseSubGraph() {
        this.phase = 2;
    }

    @Override
    public void setCurUnitEtc(Unit unit) {
        super.setCurUnitEtc(unit);
        this.nDPZ = this.curSymbolTable == null ? -9 : this.curSymbolTable.declaredZonesNb(3);
    }

    @Override
    protected Object initializeCGForUnit() {
        TapList<ActivityPattern> activities = this.curUnit.activityPatterns;
        while (activities != null) {
            this.curActivity = (ActivityPattern)activities.head;
            int lengthAll = this.curUnit.publicZonesNumber(0);
            int lengthPtr = this.curUnit.publicZonesNumber(3);
            this.curActivity.setAdTBRTopDownContext(new BoolVector(lengthAll));
            this.curActivity.setAdTBRTopDownContextOnDiffPtr(new BoolVector(lengthPtr));
            activities = activities.tail;
        }
        return null;
    }

    @Override
    protected void initializeCGForRootUnit() {
        TapList<ActivityPattern> activities = this.curUnit.activityPatterns;
        while (activities != null) {
            this.curActivity = (ActivityPattern)activities.head;
            if (!TapEnv.doTBR() && !TapEnv.get().dontSaveUnused) {
                this.curActivity.adTBRTopDownContext().setTrue();
                for (int i = this.curCallGraph.numberOfDummyRootZones - 1; i >= 0; --i) {
                    this.curActivity.adTBRTopDownContext().set(i, false);
                }
            }
            activities = activities.tail;
        }
    }

    @Override
    protected boolean analyze() {
        TapList<ActivityPattern> activities = this.curUnit.activityPatterns;
        boolean hasChanged = false;
        while (activities != null) {
            this.curActivity = (ActivityPattern)activities.head;
            if (this.curUnit.hasSource()) {
                TapEnv.printOnTrace(15, " (ActivityPattern @" + Integer.toHexString(this.curActivity.hashCode()) + ":)");
            }
            this.prepareStorageForUnit(this.curUnit);
            hasChanged = this.analyzeForward(null, null, null) || hasChanged;
            activities = activities.tail;
        }
        return hasChanged;
    }

    @Override
    protected boolean analyzeInBottomUp() {
        this.phase = 1;
        return this.analyze();
    }

    @Override
    protected boolean analyzeInTopDown() {
        this.phase = 2;
        return this.analyze();
    }

    public void prepareStorageForUnit(Unit unit) {
        this.curUnitTBRs = this.curActivity.tbrs();
        if (this.curUnitTBRs == null) {
            this.curUnitTBRs = new BlockStorage(unit);
            this.curActivity.setTbrs(this.curUnitTBRs);
        }
        this.curUnitRecomps = this.curActivity.recomps();
        if (this.curUnitRecomps == null) {
            this.curUnitRecomps = new BlockStorage(unit);
            this.curActivity.setRecomps(this.curUnitRecomps);
        }
        if (this.curActivity.mayBeRecomputed() == null) {
            this.curActivity.initializeMayBeRecomputed();
        }
        this.curUnitMayBeRecomputeds = this.curActivity.mayBeRecomputed();
        if (this.curActivity.butRemainsInFwdSweep() == null) {
            this.curActivity.initializeButRemainsInFwdSweep();
        }
        this.curUnitButRemainsInFwdSweeps = this.curActivity.butRemainsInFwdSweep();
    }

    @Override
    protected void initializeUnit() {
        this.tbrsUp = new BlockStorage(this.curUnit);
        this.tbrsDown = new BlockStorage(this.curUnit);
        this.tbrsCycleUp = new BlockStorage(this.curUnit);
        this.tbrsCycleDown = new BlockStorage(this.curUnit);
        this.curSymbolTable = this.curUnit.privateSymbolTable();
        if (this.curSymbolTable == null) {
            this.curSymbolTable = this.curUnit.publicSymbolTable();
        }
        this.vectorMap = ADTBRAnalyzer.makeMap3(0, 0, this.curSymbolTable == null ? 0 : this.curSymbolTable.declaredZonesNb(0));
        this.pointerVectorMap = ADTBRAnalyzer.makeMap3(0, 0, this.curSymbolTable == null ? 0 : this.curSymbolTable.declaredZonesNb(3));
        if (TapEnv.traceCurAnalysis()) {
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace(" ========== " + (this.phase == 1 ? "BOTTOM-UP" : "TOP-DOWN") + " REVERSE RESTORATION (==TBR) ANALYSIS OF UNIT " + this.curUnit.name() + " : ==========");
            TapEnv.printlnOnTrace(" Activity context of this analysis: " + this.curActivity);
            for (int i = 0; i < ADTBRAnalyzer.mapSize(this.vectorMap); ++i) {
                ZoneInfo zi = this.vectorIndexToZoneInfo(i, ADTBRAnalyzer.getMapClass(i, this.vectorMap), 0, this.vectorMap);
                if (zi == null) continue;
                TapEnv.printOnTrace(" [" + i + "]" + zi.accessTreePrint(this.curUnit.language()));
            }
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace();
        }
        this.curUnitDiffLivenesses = null;
        this.curUnitDiffOverwrites = null;
        if (this.phase == 2 && TapEnv.doRecompute()) {
            this.recompsUp = new BlockStorage(this.curUnit);
            this.recompsDown = new BlockStorage(this.curUnit);
            this.recompsCycleUp = new BlockStorage(this.curUnit);
            this.recompsCycleDown = new BlockStorage(this.curUnit);
            this.cleanLoopIndexZones = new BlockStorage(this.curUnit);
            if (TapEnv.diffLivenessAnalyzer() != null) {
                this.curUnitDiffLivenesses = this.curActivity.diffLivenesses();
                if (this.curUnitDiffLivenesses == null && this.curActivity.diffLivenessesCkp() != null) {
                    this.curUnitDiffLivenesses = this.curActivity.diffLivenessesCkp();
                }
                this.curUnitDiffOverwrites = this.curActivity.diffOverwrites();
                if (this.curUnitDiffOverwrites == null && this.curActivity.diffOverwritesCkp() != null) {
                    this.curUnitDiffOverwrites = this.curActivity.diffOverwritesCkp();
                }
            }
        }
    }

    @Override
    protected void setCurBlockEtc(Block block) {
        super.setCurBlockEtc(block);
        int n = this.nDPZ = this.curSymbolTable == null ? -9 : this.curSymbolTable.declaredZonesNb(3);
        if (block != null) {
            this.vectorMap = ADTBRAnalyzer.makeMap3(0, 0, this.nDZ);
            this.pointerVectorMap = ADTBRAnalyzer.makeMap3(0, 0, this.nDPZ);
        }
    }

    @Override
    protected void initializeInitBlock() {
        BoolVector initTBR = null;
        BoolVector initTBROnDiffPtr = null;
        RecompInfo[] initRecomp = null;
        if (this.phase == 1) {
            initTBR = new BoolVector(ADTBRAnalyzer.mapSize(this.vectorMap));
            initTBROnDiffPtr = new BoolVector(ADTBRAnalyzer.mapSize(this.pointerVectorMap));
        } else if (this.phase == 2) {
            if (TapEnv.doRecompute()) {
                initRecomp = this.initialRecompInfoArray();
                this.recompsDown.store(this.curBlock, initRecomp);
            }
            if (this.curBlock == this.curUnit.entryBlock) {
                initTBR = this.curActivity.adTBRTopDownContext();
                initTBROnDiffPtr = this.curActivity.adTBRTopDownContextOnDiffPtr();
                if (!TapEnv.doTBR() && !TapEnv.get().dontSaveUnused) {
                    this.setExtendedDeclared(initTBR, this.vectorMap, 0, this.curUnit.entryBlock.initializedLocalZones(), true);
                    this.setExtendedDeclared(initTBROnDiffPtr, this.pointerVectorMap, 3, this.curUnit.entryBlock.initializedLocalZones(), true);
                }
            } else {
                initTBR = new BoolVector(ADTBRAnalyzer.mapSize(this.vectorMap));
                initTBROnDiffPtr = new BoolVector(ADTBRAnalyzer.mapSize(this.pointerVectorMap));
                if (ADTBRAnalyzer.runSpecialCycleAnalysis(this.curBlock)) {
                    this.tbrsCycleDown.store(this.curBlock, new TapPair<BoolVector, BoolVector>(initTBR, initTBROnDiffPtr));
                    if (TapEnv.doRecompute()) {
                        this.recompsCycleDown.store(this.curBlock, initRecomp);
                    }
                }
            }
        }
        this.tbrsDown.store(this.curBlock, new TapPair<BoolVector, Object>(initTBR, initTBROnDiffPtr));
    }

    @Override
    protected void initializeFGForBlock() {
        if (this.phase == 2 && TapEnv.doRecompute()) {
            TapIntList indexZones = null;
            for (LoopBlock enclosingLoop = this.curBlock.enclosingLoop(); enclosingLoop != null; enclosingLoop = enclosingLoop.enclosingLoop()) {
                HeaderBlock headerBlock = enclosingLoop.header();
                if (headerBlock == null || !headerBlock.isACleanDoLoop() || headerBlock.dirtyOverwrittenIndex) continue;
                Instruction doInstr = (Instruction)headerBlock.instructions.head;
                Tree index = doInstr.tree.down(3).down(1);
                ToBool total = new ToBool(true);
                TapIntList izones = this.curSymbolTable.listOfZonesOfValue(index, total, doInstr);
                if (!total.get() || izones == null || izones.tail != null) continue;
                indexZones = new TapIntList(izones.head, indexZones);
            }
            this.cleanLoopIndexZones.store(this.curBlock, indexZones);
            TapList<Instruction> instructions = this.curBlock.instructions;
            while (instructions != null) {
                ActivityPattern.setInstructionBoolInfo(this.curUnitMayBeRecomputeds, (Instruction)instructions.head, 1, false);
                ActivityPattern.setInstructionBoolInfo(this.curUnitMayBeRecomputeds, (Instruction)instructions.head, 2, false);
                ActivityPattern.setInstructionBoolInfo(this.curUnitButRemainsInFwdSweeps, (Instruction)instructions.head, 1, false);
                ActivityPattern.setInstructionBoolInfo(this.curUnitButRemainsInFwdSweeps, (Instruction)instructions.head, 2, false);
                instructions = instructions.tail;
            }
        }
    }

    @Override
    protected void terminateFGForBlock() {
        if (this.phase == 2) {
            TapPair<BoolVector, BoolVector> tbrCycleUp;
            TapPair<BoolVector, BoolVector> tbrUp = this.tbrsUp.retrieve(this.curBlock);
            this.tbrTmp = tbrUp == null ? null : (BoolVector)tbrUp.first;
            BoolVector boolVector = this.tbrTmpOnDiffPtr = tbrUp == null ? null : (BoolVector)tbrUp.second;
            if (this.tbrTmp == null) {
                this.tbrTmp = new BoolVector(this.nDZ);
            }
            if (this.tbrTmpOnDiffPtr == null) {
                this.tbrTmpOnDiffPtr = new BoolVector(this.nDPZ);
            }
            this.tbrTmpCycle = (tbrCycleUp = this.tbrsCycleUp.retrieve(this.curBlock)) == null ? null : (BoolVector)tbrCycleUp.first;
            BoolVector boolVector2 = this.tbrTmpCycleOnDiffPtr = tbrCycleUp == null ? null : (BoolVector)tbrCycleUp.second;
            if (TapEnv.doRecompute()) {
                this.recompTmp = this.recompsUp.retrieve(this.curBlock);
                if (this.recompTmp == null) {
                    this.recompTmp = this.initialRecompInfoArray();
                }
                this.recompTmpCycle = this.recompsCycleUp.retrieve(this.curBlock);
            }
            TapList<Object> hdListTBRs = new TapList<Object>(null, null);
            TapList<Object> hdListRecomps = new TapList<Object>(null, null);
            this.propagateAndStoreThroughBlock(this.curBlock, hdListTBRs, hdListRecomps);
            this.curUnitTBRs.store(this.curBlock, hdListTBRs.tail);
            this.curUnitRecomps.store(this.curBlock, hdListRecomps.tail);
        }
    }

    @Override
    protected void terminateTermBlock() {
        if (this.phase == 2) {
            BoolVector termCycleInfoOnDiffPtr;
            BoolVector termCycleInfo;
            TapPair<BoolVector, BoolVector> tbrUp;
            TapList<TapPair<BoolVector, BoolVector>> termBlockInfos = this.curUnitTBRs.retrieve(this.curBlock);
            if (termBlockInfos == null) {
                termBlockInfos = new TapList<Object>(null, new TapList<Object>(null, null));
                this.curUnitTBRs.store(this.curBlock, termBlockInfos);
            }
            BoolVector termInfo = (tbrUp = this.tbrsUp.retrieve(this.curBlock)) == null ? null : (BoolVector)tbrUp.first;
            termInfo = termInfo == null ? new BoolVector(this.nDZ) : termInfo.copy();
            BoolVector termInfoOnDiffPtr = tbrUp == null ? null : (BoolVector)tbrUp.second;
            termInfoOnDiffPtr = termInfoOnDiffPtr == null ? new BoolVector(this.nDPZ) : termInfoOnDiffPtr.copy();
            TapPair<BoolVector, BoolVector> tbrCycleUp = this.tbrsCycleUp.retrieve(this.curBlock);
            BoolVector boolVector = termCycleInfo = tbrCycleUp == null ? null : (BoolVector)tbrCycleUp.first;
            if (termCycleInfo != null) {
                termInfo.cumulOr(termCycleInfo);
            }
            BoolVector boolVector2 = termCycleInfoOnDiffPtr = tbrCycleUp == null ? null : (BoolVector)tbrCycleUp.second;
            if (termCycleInfoOnDiffPtr != null) {
                termInfoOnDiffPtr.cumulOr(termCycleInfoOnDiffPtr);
            }
            termBlockInfos.head = new TapPair<BoolVector, BoolVector>(termInfo, termInfoOnDiffPtr);
            if (TapEnv.doRecompute()) {
                int i;
                this.recompTmp = this.recompsUp.retrieve(this.curBlock);
                this.recompTmpCycle = this.recompsCycleUp.retrieve(this.curBlock);
                if (this.recompTmp != null) {
                    for (i = this.recompTmp.length - 1; i >= 0; --i) {
                        if (this.recompTmp[i] == null) continue;
                        if (!this.recompTmp[i].usedForPrimal) {
                            this.setInstructionRemainsInFwdSweep(this.recompTmp, i, 1);
                        }
                        if (this.recompTmp[i].usedForDiffPtr) continue;
                        this.setInstructionRemainsInFwdSweep(this.recompTmp, i, 2);
                    }
                }
                if (this.recompTmpCycle != null) {
                    for (i = this.recompTmpCycle.length - 1; i >= 0; --i) {
                        if (this.recompTmpCycle[i] == null) continue;
                        if (!this.recompTmpCycle[i].usedForPrimal) {
                            this.setInstructionRemainsInFwdSweep(this.recompTmpCycle, i, 1);
                        }
                        if (this.recompTmpCycle[i].usedForDiffPtr) continue;
                        this.setInstructionRemainsInFwdSweep(this.recompTmpCycle, i, 2);
                    }
                }
            }
        }
    }

    @Override
    protected boolean compareChannelZoneDataUpstream(int mpZone, Block refBlock) {
        return false;
    }

    @Override
    protected boolean compareChannelZoneDataDownstream(int mpZone, Block refBlock) {
        return false;
    }

    @Override
    protected boolean terminateUnit() {
        BoolVector exitTBROnDiffPtr;
        boolean hasChangedUp = false;
        TapPair<BoolVector, BoolVector> tbrUp = this.tbrsUp.retrieve(this.curUnit.exitBlock);
        BoolVector exitTBR = tbrUp == null ? null : (BoolVector)tbrUp.first;
        BoolVector boolVector = exitTBROnDiffPtr = tbrUp == null ? null : (BoolVector)tbrUp.second;
        if (exitTBROnDiffPtr != null) {
            exitTBROnDiffPtr = exitTBROnDiffPtr.minus(this.curActivity.adTBRTopDownContextOnDiffPtr());
        }
        if (this.curActivity.localExitTBR() == null) {
            hasChangedUp = exitTBR != null || exitTBROnDiffPtr != null;
        } else {
            boolean bl = hasChangedUp = !this.curActivity.localExitTBR().contains(exitTBR, ADTBRAnalyzer.mapSize(this.vectorMap)) || !this.curActivity.localExitTBROnDiffPtr().contains(exitTBROnDiffPtr, ADTBRAnalyzer.mapSize(this.pointerVectorMap));
        }
        if (hasChangedUp) {
            this.curActivity.setLocalExitTBR(this.curActivity.localExitTBR() == null ? exitTBR : exitTBR.or(this.curActivity.localExitTBR()));
            this.curActivity.setLocalExitTBROnDiffPtr(this.curActivity.localExitTBROnDiffPtr() == null ? exitTBROnDiffPtr : exitTBROnDiffPtr.or(this.curActivity.localExitTBROnDiffPtr()));
        }
        if (this.phase == 2) {
            this.curUnitTBRs.store(this.curUnit.entryBlock, new TapList<TapPair<BoolVector, BoolVector>>(this.tbrsDown.retrieve(this.curUnit.entryBlock), null));
            this.curUnitTBRs.store(this.curUnit.exitBlock, new TapList<TapPair<BoolVector, BoolVector>>(this.tbrsUp.retrieve(this.curUnit.exitBlock), null));
            this.tbrsUp = null;
            this.tbrsDown = null;
            this.tbrsCycleUp = null;
            this.tbrsCycleDown = null;
        }
        return hasChangedUp;
    }

    public TapPair<BoolVector, BoolVector> getFrontierTBR(TapList<FGArrow> frontier) {
        int resNDZ = ADTBRAnalyzer.commonNDZofFrontierDestinations(frontier, 0);
        int resNDPZ = ADTBRAnalyzer.commonNDZofFrontierDestinations(frontier, 3);
        BoolVector result = new BoolVector(resNDZ);
        BoolVector resultOnDiffPtr = new BoolVector(resNDPZ);
        this.curUnitTBRs = this.curActivity.tbrs();
        while (frontier != null) {
            FGArrow arrow = (FGArrow)frontier.head;
            TapList<TapPair<BoolVector, BoolVector>> tbrS = this.curUnitTBRs.retrieve(arrow.origin);
            if (tbrS != null) {
                int commonLength = arrow.commonSymbolTable().declaredZonesNb(0);
                int commonLengthOnDiffPtr = arrow.commonSymbolTable().declaredZonesNb(3);
                TapPair<BoolVector, BoolVector> lastTBRinfo = TapList.last(tbrS);
                result.cumulOr((BoolVector)lastTBRinfo.first, commonLength);
                resultOnDiffPtr.cumulOr((BoolVector)lastTBRinfo.second, commonLengthOnDiffPtr);
            }
            frontier = frontier.tail;
        }
        return new TapPair<BoolVector, BoolVector>(result, resultOnDiffPtr);
    }

    @Override
    protected void setEmptyCumulAndCycleValues() {
        this.tbrTmp = null;
        this.tbrTmpOnDiffPtr = null;
        this.tbrTmpCycle = null;
        this.tbrTmpCycleOnDiffPtr = null;
        if (this.phase == 2 && TapEnv.doRecompute()) {
            this.recompTmp = null;
            this.recompTmpCycle = null;
        }
    }

    @Override
    protected boolean getValueFlowingThrough() {
        TapPair<BoolVector, BoolVector> retrievedFromOrig;
        if (TapEnv.traceCurAnalysis()) {
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace("   === Flowing across " + this.curArrow + ':');
        }
        Block origin = this.curArrow.origin;
        SymbolTable arrowSymbolTable = this.curArrow.commonSymbolTable();
        int nDZcommon = arrowSymbolTable.declaredZonesNb(0);
        int nDZcommonOnDiffPtr = arrowSymbolTable.declaredZonesNb(3);
        if (ADTBRAnalyzer.runSpecialCycleAnalysis(origin) && this.curArrow.containsCase(1)) {
            retrievedFromOrig = this.tbrsCycleDown.retrieve(origin);
            if (this.phase == 2 && TapEnv.doRecompute()) {
                this.additionalRecomp = this.recompsCycleDown.retrieve(origin);
            }
        } else {
            retrievedFromOrig = this.tbrsDown.retrieve(origin);
            if (this.phase == 2 && TapEnv.doRecompute()) {
                this.additionalRecomp = this.recompsDown.retrieve(origin);
            }
        }
        this.additionalTBR = retrievedFromOrig == null ? null : (BoolVector)retrievedFromOrig.first;
        BoolVector boolVector = this.additionalTBROnDiffPtr = retrievedFromOrig == null ? null : (BoolVector)retrievedFromOrig.second;
        if (this.phase == 2 && TapEnv.doRecompute()) {
            int nDZorig = origin.symbolTable.declaredZonesNb(0);
            int nDZdest = this.curArrow.destination.symbolTable.declaredZonesNb(0);
            if (this.additionalRecomp != null) {
                TapPair<BoolVector, BoolVector> lastDiffOverwrites;
                TapList<TapPair<BoolVector, BoolVector>> diffOverwritesList = null;
                if (this.curUnitDiffOverwrites != null) {
                    diffOverwritesList = this.curUnitDiffOverwrites.retrieve(origin);
                }
                BoolVector diffOverwritesAfter = null;
                if (diffOverwritesList != null && (lastDiffOverwrites = TapList.last(diffOverwritesList)) != null) {
                    diffOverwritesAfter = (BoolVector)lastDiffOverwrites.first;
                }
                this.additionalRecomp = this.removeRecompOutOfScope(this.additionalRecomp, nDZorig, nDZcommon, nDZdest, this.cleanLoopIndexZones.retrieve(origin), diffOverwritesAfter, this.additionalTBR);
            }
        }
        if (this.phase == 2 && this.additionalTBR != null && (this.curArrow.destination != this.curUnit.exitBlock || this.curUnit.mustDifferentiateSplit())) {
            this.markDestinationsRebased(this.additionalTBR, this.additionalTBROnDiffPtr, origin, arrowSymbolTable);
        }
        if (TapEnv.traceCurAnalysis()) {
            if (this.additionalTBR != null) {
                int[] commonVectorMap = ADTBRAnalyzer.changeCommonDeclared(this.vectorMap, nDZcommon);
                int[] commonVectorMapOnDiffPtr = ADTBRAnalyzer.changeCommonDeclared(this.pointerVectorMap, nDZcommonOnDiffPtr);
                TapEnv.printlnOnTrace("      TBR:" + this.infoToStringWithDiffPtr(this.additionalTBR, commonVectorMap, this.additionalTBROnDiffPtr, commonVectorMapOnDiffPtr));
            }
            if (this.phase == 2 && TapEnv.doRecompute() && this.additionalRecomp != null) {
                TapEnv.printlnOnTrace("      Available recomputations:");
                for (int k = 0; k < this.additionalRecomp.length; ++k) {
                    if (this.additionalRecomp[k] == null) continue;
                    TapEnv.printlnOnTrace((k > 9 ? "        " : "         ") + k + " >> " + this.additionalRecomp[k]);
                }
            }
        }
        if (this.additionalTBR != null && origin instanceof HeaderBlock && origin.instructions != null && this.curArrow == origin.getFGArrowTestCase(30, 0) && ((HeaderBlock)origin).headInstr().hasDirective(13) != null) {
            TapPair<BoolVector, BoolVector> useCb = this.curActivity.fragmentDiffLivenessesCkp(origin);
            TapPair<BoolVector, BoolVector> rwC = this.curUnit.fragmentInOutCkp(origin);
            if (rwC != null) {
                TapList<FGArrow> flowToII = origin.backFlow();
                BoolVector tbrBeforeII = new BoolVector(nDZcommon);
                BoolVector tbrBeforeIIOnDiffPtr = new BoolVector(nDZcommonOnDiffPtr);
                while (flowToII != null) {
                    if (!((FGArrow)flowToII.head).isCyclingArrow() && (retrievedFromOrig = this.tbrsDown.retrieve(((FGArrow)flowToII.head).origin)) != null) {
                        if (retrievedFromOrig.first != null) {
                            tbrBeforeII.cumulOr((BoolVector)retrievedFromOrig.first);
                        }
                        if (retrievedFromOrig.second != null) {
                            tbrBeforeIIOnDiffPtr.cumulOr((BoolVector)retrievedFromOrig.second);
                        }
                    }
                    flowToII = flowToII.tail;
                }
                BoolVector newAdditionalTBR = tbrBeforeII.copy();
                newAdditionalTBR.cumulOr(useCb != null ? (BoolVector)useCb.first : (BoolVector)rwC.first);
                newAdditionalTBR.cumulMinus((BoolVector)rwC.second);
                BoolVector newAdditionalTBROnDiffPtr = tbrBeforeIIOnDiffPtr.copy();
                for (int iptr = 0; iptr < nDZcommonOnDiffPtr; ++iptr) {
                    int i = arrowSymbolTable.declaredZoneInfo(iptr, 3).kindZoneNb(0);
                    if (((BoolVector)rwC.second).get(i)) {
                        newAdditionalTBROnDiffPtr.set(iptr, false);
                        continue;
                    }
                    if (!(useCb != null ? ((BoolVector)useCb.second).get(iptr) : ((BoolVector)rwC.first).get(i))) continue;
                    newAdditionalTBROnDiffPtr.set(iptr, true);
                }
                this.additionalTBR.cumulAnd(newAdditionalTBR, nDZcommon);
                this.additionalTBROnDiffPtr.cumulAnd(newAdditionalTBROnDiffPtr, nDZcommonOnDiffPtr);
                if (TapEnv.traceCurAnalysis()) {
                    int[] commonVectorMap = ADTBRAnalyzer.changeCommonDeclared(this.vectorMap, nDZcommon);
                    int[] commonVectorMapOnDiffPtr = ADTBRAnalyzer.changeCommonDeclared(this.pointerVectorMap, nDZcommonOnDiffPtr);
                    TapEnv.printlnOnTrace("      TBR recomputed because origin " + origin + " is checkpointed");
                    TapEnv.printlnOnTrace("      TBR:" + this.infoToStringWithDiffPtr(this.additionalTBR, commonVectorMap, this.additionalTBROnDiffPtr, commonVectorMapOnDiffPtr));
                }
            }
        }
        return this.additionalTBR != null || this.phase == 2 && TapEnv.doRecompute() && this.additionalRecomp != null;
    }

    @Override
    protected void cumulValueWithAdditional(SymbolTable commonSymbolTable) {
        if (this.tbrTmp == null) {
            this.tbrTmp = new BoolVector(this.nDZ);
        }
        if (this.tbrTmpOnDiffPtr == null) {
            this.tbrTmpOnDiffPtr = new BoolVector(this.nDPZ);
        }
        int commonLength = commonSymbolTable.declaredZonesNb(0);
        int commonLengthOnDiffPtr = commonSymbolTable.declaredZonesNb(3);
        if (this.additionalTBR != null) {
            this.tbrTmp.cumulOr(this.additionalTBR, commonLength);
        }
        if (this.additionalTBROnDiffPtr != null) {
            this.tbrTmpOnDiffPtr.cumulOr(this.additionalTBROnDiffPtr, commonLengthOnDiffPtr);
        }
        if (this.phase == 2 && TapEnv.doRecompute() && this.additionalRecomp != null) {
            this.recompTmp = this.recompCumulOr(this.recompTmp, this.additionalRecomp, commonLength);
        }
    }

    @Override
    protected void cumulCycleValueWithAdditional(SymbolTable commonSymbolTable) {
        if (this.tbrTmpCycle == null) {
            this.tbrTmpCycle = new BoolVector(this.nDZ);
        }
        if (this.tbrTmpCycleOnDiffPtr == null) {
            this.tbrTmpCycleOnDiffPtr = new BoolVector(this.nDPZ);
        }
        int commonLength = commonSymbolTable.declaredZonesNb(0);
        int commonLengthOnDiffPtr = commonSymbolTable.declaredZonesNb(3);
        if (this.additionalTBR != null) {
            this.tbrTmpCycle.cumulOr(this.additionalTBR, commonLength);
        }
        if (this.additionalTBROnDiffPtr != null) {
            this.tbrTmpCycleOnDiffPtr.cumulOr(this.additionalTBROnDiffPtr, commonLengthOnDiffPtr);
        }
        if (this.phase == 2 && TapEnv.doRecompute() && this.additionalRecomp != null) {
            this.recompTmpCycle = this.recompCumulOr(this.recompTmpCycle, this.additionalRecomp, commonLength);
        }
    }

    @Override
    protected boolean compareDownstreamValues() {
        boolean tbrChanged = this.compareWithStorage(this.tbrTmp, this.tbrTmpOnDiffPtr, this.tbrTmpCycle, this.tbrTmpCycleOnDiffPtr, this.nDZ, this.nDPZ, this.tbrsDown, this.tbrsCycleDown);
        boolean recompChanged = false;
        if (this.phase == 2 && TapEnv.doRecompute()) {
            recompChanged = this.compareWithStorage(this.recompTmp, this.recompTmpCycle, this.recompsDown, this.recompsCycleDown);
        }
        return tbrChanged || recompChanged;
    }

    @Override
    protected boolean compareUpstreamValues() {
        boolean tbrChanged = this.compareWithStorage(this.tbrTmp, this.tbrTmpOnDiffPtr, this.tbrTmpCycle, this.tbrTmpCycleOnDiffPtr, this.nDZ, this.nDPZ, this.tbrsUp, this.tbrsCycleUp);
        boolean recompChanged = false;
        if (this.phase == 2 && TapEnv.doRecompute()) {
            recompChanged = this.compareWithStorage(this.recompTmp, this.recompTmpCycle, this.recompsUp, this.recompsCycleUp);
        }
        return tbrChanged || recompChanged;
    }

    private boolean compareWithStorage(RecompInfo[] newInfo, RecompInfo[] newInfoCycle, BlockStorage<RecompInfo[]> storedInfos, BlockStorage<RecompInfo[]> storedInfosCycle) {
        boolean modified = false;
        RecompInfo[] oldInfo = storedInfos.retrieve(this.curBlock);
        if (!(newInfo == null || oldInfo != null && this.equalRecompInfos(newInfo, oldInfo))) {
            modified = true;
            storedInfos.store(this.curBlock, this.recompCopy(newInfo));
        }
        if (ADTBRAnalyzer.runSpecialCycleAnalysis(this.curBlock)) {
            oldInfo = storedInfosCycle.retrieve(this.curBlock);
            if (!(newInfoCycle == null || oldInfo != null && this.equalRecompInfos(newInfoCycle, oldInfo))) {
                modified = true;
                storedInfosCycle.store(this.curBlock, this.recompCopy(newInfoCycle));
            }
        }
        return modified;
    }

    @Override
    protected boolean propagateValuesForwardThroughBlock() {
        return this.propagateAndStoreThroughBlock(this.curBlock, null, null);
    }

    private boolean propagateAndStoreThroughBlock(Block block, TapList<TapPair<BoolVector, BoolVector>> tbrRecordList, TapList<TapPair<TapList<Instruction>, TapList<Instruction>>> recompRecordList) {
        BoolVector recordInfo;
        TapPair<TapList<Instruction>, TapList<Instruction>> recomputationList;
        TapPair<BoolVector, BoolVector> lastChanceZones;
        ToBool total;
        if (TapEnv.traceCurAnalysis()) {
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace("   === Going down through Block " + block + " ===");
        }
        TapList<Instruction> instructions = block.instructions;
        TapList<TapPair<BoolVector, BoolVector>> diffLivenessesList = null;
        if (this.curUnitDiffLivenesses != null) {
            diffLivenessesList = this.curUnitDiffLivenesses.retrieve(block);
        }
        TapList<TapPair<BoolVector, BoolVector>> diffOverwritesList = null;
        if (this.curUnitDiffOverwrites != null) {
            diffOverwritesList = this.curUnitDiffOverwrites.retrieve(block);
        }
        TapPair diffLivenessesAfter = diffLivenessesList == null ? new TapPair(null, null) : (TapPair)diffLivenessesList.head;
        TapPair diffOverwritesAfter = diffOverwritesList == null ? new TapPair(null, null) : (TapPair)diffOverwritesList.head;
        this.setUniqueAccessZones(block);
        if (ADTBRAnalyzer.runSpecialCycleAnalysis(block)) {
            this.curInstruction = (Instruction)instructions.head;
            Tree doTree = this.curInstruction.tree.down(3);
            if (this.tbrTmp != null) {
                this.tbrAndRecomputabilityThroughExpression(doTree.down(2), this.tbrTmp, this.tbrTmpOnDiffPtr, this.recompTmp, diffOverwritesList == null ? null : (BoolVector)((TapPair)diffOverwritesList.tail.head).first, new ToBool(true));
                Tree doIndexTree = doTree.down(1);
                ToBool total2 = new ToBool(false);
                TapIntList indexZones = ZoneInfo.listAllZones(this.curSymbolTable.treeOfZonesOfValue(doIndexTree, total2, this.curInstruction, null), true);
                if (this.requiredZones(indexZones, this.tbrTmp)) {
                    this.setTBRindexOnLoopEntry(doIndexTree);
                }
                if (this.phase == 2 && TapEnv.doRecompute()) {
                    BoolVector zonesNotUsableInRecompute = new BoolVector(this.nDZ);
                    zonesNotUsableInRecompute.set(indexZones, true);
                    this.fixpointDependents(this.recompTmp, zonesNotUsableInRecompute, this.cleanLoopIndexZones.retrieve(block), (BoolVector)diffOverwritesAfter.first, this.tbrTmp, this.nDZ);
                    if (this.recompTmpCycle != null) {
                        this.fixpointDependents(this.recompTmpCycle, zonesNotUsableInRecompute, this.cleanLoopIndexZones.retrieve(block), (BoolVector)diffOverwritesAfter.first, this.tbrTmp, this.nDZ);
                    }
                }
            }
            if (this.tbrTmpCycle != null) {
                if (ADTBRAnalyzer.findBlockLoopKindIsDoLoop(block)) {
                    if (((HeaderBlock)block).dirtyOverwrittenIndex) {
                        this.setTBRindexOnLoopCycle(doTree.down(1));
                    }
                    total = new ToBool(false);
                    TapIntList writtenZonesList = ZoneInfo.listAllZones(this.curSymbolTable.treeOfZonesOfValue(doTree.down(1), total, this.curInstruction, null), true);
                    if (total.get()) {
                        this.setExtendedDeclared(this.tbrTmpCycle, this.vectorMap, 0, writtenZonesList, false);
                        if (this.phase == 2 && TapEnv.doRecompute() && this.recompTmpCycle != null) {
                            this.setExtendedDeclared(this.recompTmpCycle, this.vectorMap, writtenZonesList, null);
                        }
                    }
                }
                BoolVector tbrTmpCycleMemo = this.tbrTmpCycle.copy();
                BoolVector tbrTmpCycleMemoOnDiffPtr = this.tbrTmpCycleOnDiffPtr.copy();
                this.tbrTmpCycle.setDeclared(((HeaderBlock)block).localizedZones, this.vectorMap, false);
                RecompInfo[] recompTmpCycleMemo = null;
                TapIntList loopLocalZones = ((HeaderBlock)block).localizedZones;
                if (this.phase == 2 && TapEnv.doRecompute()) {
                    recompTmpCycleMemo = this.recompCopy(this.recompTmpCycle);
                    if (this.recompTmpCycle != null) {
                        while (loopLocalZones != null) {
                            this.recompTmpCycle[loopLocalZones.head] = new RecompInfo(null, null);
                            loopLocalZones = loopLocalZones.tail;
                        }
                    }
                }
                if (this.tbrTmp != null) {
                    this.tbrTmpCycle.cumulOr(this.tbrTmp);
                }
                if (this.tbrTmpOnDiffPtr != null) {
                    this.tbrTmpCycleOnDiffPtr.cumulOr(this.tbrTmpOnDiffPtr);
                }
                if (this.phase == 2 && TapEnv.doRecompute() && this.recompTmp != null) {
                    this.recompTmpCycle = this.recompCumulOr(this.recompTmpCycle, this.recompTmp);
                }
                if (this.tbrTmp == null) {
                    this.tbrTmp = tbrTmpCycleMemo;
                    this.tbrTmpOnDiffPtr = tbrTmpCycleMemoOnDiffPtr;
                    this.recompTmp = recompTmpCycleMemo;
                } else {
                    this.tbrTmp.cumulAnd(this.directEntryExitMask((HeaderBlock)block, this.vectorMap, 0));
                    this.tbrTmp.cumulOr(tbrTmpCycleMemo);
                    this.tbrTmpOnDiffPtr.cumulAnd(this.directEntryExitMask((HeaderBlock)block, this.pointerVectorMap, 3));
                    this.tbrTmpOnDiffPtr.cumulOr(tbrTmpCycleMemoOnDiffPtr);
                    if (this.phase == 2 && TapEnv.doRecompute()) {
                        this.recompTmp = this.recompCumulOr(this.recompTmp, recompTmpCycleMemo);
                    }
                }
            } else {
                this.tbrTmpCycle = this.tbrTmp.copy();
                this.tbrTmpCycleOnDiffPtr = this.tbrTmpOnDiffPtr.copy();
                if (this.phase == 2 && TapEnv.doRecompute()) {
                    this.recompTmpCycle = this.recompCopy(this.recompTmp);
                }
            }
        } else if (block instanceof HeaderBlock && block.isADoLoop()) {
            this.curInstruction = (Instruction)instructions.head;
            Tree doIndexTree = this.curInstruction.tree.down(3).down(1);
            total = new ToBool(false);
            TapIntList indexZones = ZoneInfo.listAllZones(this.curSymbolTable.treeOfZonesOfValue(doIndexTree, total, this.curInstruction, null), true);
            if (this.tbrTmp != null && (this.requiredZones(indexZones, this.tbrTmp) || ((HeaderBlock)block).dirtyOverwrittenIndex && DiffLivenessAnalyzer.isTreeOrSubtreeRequiredInDiff(this.curActivity, this.curInstruction.tree, true))) {
                this.setTBRindexOnLoopEntry(doIndexTree);
                this.setTBRindexOnLoopCycle(doIndexTree);
            }
        }
        ToBool arrives = new ToBool(true);
        ToBool arrivesC = new ToBool(true);
        while (instructions != null) {
            this.curInstruction = (Instruction)instructions.head;
            if (TapEnv.traceCurAnalysis()) {
                TapEnv.printlnOnTrace("      TBR=" + this.infoToStringWithDiffPtrWithCycle(this.tbrTmp, this.vectorMap, this.tbrTmpOnDiffPtr, this.pointerVectorMap, this.tbrTmpCycle, this.tbrTmpCycleOnDiffPtr));
            }
            TapPair diffLivenessesBefore = diffLivenessesAfter;
            if (diffLivenessesList != null && (diffLivenessesList = diffLivenessesList.tail) != null) {
                diffLivenessesAfter = (TapPair)diffLivenessesList.head;
            }
            TapPair diffOverwritesBefore = diffOverwritesAfter;
            if (diffOverwritesList != null && (diffOverwritesList = diffOverwritesList.tail) != null) {
                diffOverwritesAfter = (TapPair)diffOverwritesList.head;
            }
            if (this.phase == 2 && TapEnv.doRecompute() && this.recompTmp != null && this.recompTmpCycle == null && diffLivenessesAfter.first != null) {
                lastChanceZones = new TapPair(((BoolVector)diffLivenessesAfter.first).copy(), diffLivenessesAfter.second);
                recomputationList = this.selectAvailableRecomputations(diffOverwritesBefore, diffLivenessesBefore, lastChanceZones);
                if (recompRecordList != null) {
                    recompRecordList = recompRecordList.placdl(recomputationList);
                }
            }
            if (tbrRecordList != null) {
                recordInfo = this.tbrTmp.copy();
                if (this.tbrTmpCycle != null) {
                    recordInfo.cumulOr(this.tbrTmpCycle);
                }
                BoolVector recordInfoOnDiffPtr = this.tbrTmpOnDiffPtr.copy();
                if (this.tbrTmpCycleOnDiffPtr != null) {
                    recordInfoOnDiffPtr.cumulOr(this.tbrTmpCycleOnDiffPtr);
                }
                tbrRecordList = tbrRecordList.placdl(new TapPair<BoolVector, BoolVector>(recordInfo, recordInfoOnDiffPtr));
            }
            if (TapEnv.traceCurAnalysis()) {
                TapEnv.printlnOnTrace("    Now going downstream across instruction:" + ILUtils.toString(this.curInstruction.tree));
            }
            if (this.tbrTmp != null) {
                this.tbrAndRecomputabilityThroughExpression(this.curInstruction.tree, this.tbrTmp, this.tbrTmpOnDiffPtr, this.recompTmp, (BoolVector)diffOverwritesAfter.first, arrives);
            }
            if (this.tbrTmpCycle != null) {
                this.tbrAndRecomputabilityThroughExpression(this.curInstruction.tree, this.tbrTmpCycle, this.tbrTmpCycleOnDiffPtr, this.recompTmpCycle, (BoolVector)diffOverwritesAfter.first, arrivesC);
            }
            instructions = instructions.tail;
        }
        if (TapEnv.traceCurAnalysis()) {
            TapEnv.printlnOnTrace("      TBR=" + this.infoToStringWithDiffPtrWithCycle(this.tbrTmp, this.vectorMap, this.tbrTmpOnDiffPtr, this.pointerVectorMap, this.tbrTmpCycle, this.tbrTmpCycleOnDiffPtr));
            TapEnv.printlnOnTrace("    Now at the end of Block:" + block);
        }
        this.curInstruction = null;
        if (this.phase == 2 && TapEnv.doRecompute() && this.recompTmp != null && this.recompTmpCycle == null && diffLivenessesAfter.first != null) {
            lastChanceZones = new TapPair<BoolVector, BoolVector>(new BoolVector(this.nDZ), new BoolVector(this.nDPZ));
            TapList<FGArrow> arrows = block.flow();
            boolean goesToExit = false;
            int minDZ = this.nDZ;
            int minDPZ = this.nDPZ;
            while (arrows != null) {
                int commonDPZ;
                int commonDZ;
                if (((FGArrow)arrows.head).destination == this.curUnit.exitBlock) {
                    goesToExit = true;
                }
                if ((commonDZ = ((FGArrow)arrows.head).commonSymbolTable().declaredZonesNb(0)) < minDZ) {
                    minDZ = commonDZ;
                }
                if ((commonDPZ = ((FGArrow)arrows.head).commonSymbolTable().declaredZonesNb(3)) < minDPZ) {
                    minDPZ = commonDPZ;
                }
                arrows = arrows.tail;
            }
            if (goesToExit) {
                ((BoolVector)lastChanceZones.first).setTrue();
                ((BoolVector)lastChanceZones.second).setTrue();
            } else {
                int i;
                for (i = minDZ; i < this.nDZ; ++i) {
                    ((BoolVector)lastChanceZones.first).set(i, true);
                }
                for (i = minDPZ; i < this.nDPZ; ++i) {
                    ((BoolVector)lastChanceZones.second).set(i, true);
                }
            }
            recomputationList = this.selectAvailableRecomputations(diffOverwritesAfter, diffLivenessesAfter, lastChanceZones);
            if (recompRecordList != null) {
                recompRecordList = recompRecordList.placdl(recomputationList);
            }
        }
        if (tbrRecordList != null) {
            recordInfo = this.tbrTmp.copy();
            if (this.tbrTmpCycle != null) {
                recordInfo.cumulOr(this.tbrTmpCycle);
            }
            BoolVector recordInfoOnDiffPtr = this.tbrTmpOnDiffPtr.copy();
            if (this.tbrTmpCycleOnDiffPtr != null) {
                recordInfoOnDiffPtr.cumulOr(this.tbrTmpCycleOnDiffPtr);
            }
            tbrRecordList = tbrRecordList.placdl(new TapPair<BoolVector, BoolVector>(recordInfo, recordInfoOnDiffPtr));
        }
        this.uniqueAccessZones = null;
        return arrives.get() && arrivesC.get();
    }

    TapPair<TapList<Instruction>, TapList<Instruction>> selectAvailableRecomputations(TapPair<BoolVector, BoolVector> diffOverwrites, TapPair<BoolVector, BoolVector> diffLivenesses, TapPair<BoolVector, BoolVector> lastChanceZones) {
        if (TapEnv.traceCurAnalysis()) {
            TapEnv.printlnOnTrace("      Available recomputations are:");
            for (int k = 0; k < this.recompTmp.length; ++k) {
                if (this.recompTmp[k] == null) continue;
                TapEnv.printlnOnTrace((k > 9 ? "        " : "         ") + k + " >> " + this.recompTmp[k]);
            }
            TapEnv.printlnOnTrace("       overWritten=" + this.infoToStringWithDiffPtr((BoolVector)diffOverwrites.first, this.vectorMap, (BoolVector)diffOverwrites.second, this.pointerVectorMap) + " diffLiveness=" + this.infoToStringWithDiffPtr((BoolVector)diffLivenesses.first, this.vectorMap, (BoolVector)diffLivenesses.second, this.pointerVectorMap) + " lastChance=" + this.infoToStringWithDiffPtr((BoolVector)lastChanceZones.first, this.vectorMap, (BoolVector)lastChanceZones.second, this.pointerVectorMap));
        }
        TapList<Instruction> recomputationListPrimal = null;
        TapList<Instruction> recomputationListOnDiffPtr = null;
        TapIntList recomp3z = null;
        while ((recomp3z = this.placeRecomputationHere(this.recompTmp, diffOverwrites, diffLivenesses, lastChanceZones)) != null) {
            boolean aboutAPointer;
            int recompRk = recomp3z.head;
            int primalZ = recomp3z.tail.head;
            Instruction recompInstr = this.recompTmp[recompRk].instruction;
            this.tbrTmp.cumulOr(this.recompTmp[recompRk].neededAvailableZones);
            if (primalZ != -1) {
                this.tbrTmp.set(primalZ, false);
                recomputationListPrimal = new TapList<Instruction>(recompInstr, recomputationListPrimal);
                this.recompTmp[recompRk].usedForPrimal = true;
            }
            int diffPtrZ = -1;
            boolean bl = aboutAPointer = recomp3z.tail.tail != null;
            if (aboutAPointer && (diffPtrZ = recomp3z.tail.tail.head) != -1) {
                this.tbrTmpOnDiffPtr.set(diffPtrZ, false);
                recomputationListOnDiffPtr = new TapList<Instruction>(recompInstr, recomputationListOnDiffPtr);
                this.recompTmp[recompRk].usedForDiffPtr = true;
            }
            if (TapEnv.traceCurAnalysis()) {
                TapEnv.printlnOnTrace("  Place recomputation here: " + ILUtils.toString(recompInstr.tree) + (aboutAPointer ? (primalZ == -1 ? "" : ", for primal") + (diffPtrZ == -1 ? "" : ", for diffPtr") : ""));
                TapEnv.printlnOnTrace("    => and TBR becomes:" + this.infoToStringWithDiffPtr(this.tbrTmp, this.vectorMap, this.tbrTmpOnDiffPtr, this.pointerVectorMap));
            }
            BoolVector zonesNotUsableInRecompute = new BoolVector(this.nDZ);
            zonesNotUsableInRecompute.set(recompRk, true);
            this.fixpointDependents(this.recompTmp, zonesNotUsableInRecompute, this.cleanLoopIndexZones.retrieve(this.curBlock), (BoolVector)diffOverwrites.first, this.tbrTmp, this.nDZ);
            if (!this.recompTmp[recompRk].usedForPrimal || !this.recompTmp[recompRk].usedForDiffPtr && aboutAPointer) continue;
            this.recompTmp[recompRk] = null;
        }
        return new TapPair<TapList<Instruction>, TapList<Instruction>>(TapList.nreverse(recomputationListPrimal), TapList.nreverse(recomputationListOnDiffPtr));
    }

    private TapIntList placeRecomputationHere(RecompInfo[] recompInfos, TapPair<BoolVector, BoolVector> diffOverwrites, TapPair<BoolVector, BoolVector> diffLivenesses, TapPair<BoolVector, BoolVector> lastChanceZones) {
        TapIntList result = null;
        int indexFound = -1;
        int rkFound = -1;
        int rkFoundOnDiffPtr = -1;
        int indexPtr = -1;
        for (int index = recompInfos.length - 1; indexFound == -1 && index >= 0; --index) {
            ZoneInfo zi;
            indexPtr = -1;
            if (recompInfos[index] == null) continue;
            if (this.tbrTmp.get(index) && ((BoolVector)diffOverwrites.first).get(index) && !((BoolVector)diffLivenesses.first).get(index) && (!this.otherNeeds(recompInfos, index) || lastChanceZones.first != null && ((BoolVector)lastChanceZones.first).get(index))) {
                indexFound = index;
                rkFound = index;
            }
            if (index >= 0 && (zi = this.vectorIndexToZoneInfo(index, 3, 0, this.vectorMap)) != null && zi.ptrZoneNb != -1) {
                indexPtr = zi.ptrZoneNb;
            }
            if (indexPtr == -1 || !this.tbrTmpOnDiffPtr.get(indexPtr) || !((BoolVector)diffOverwrites.second).get(indexPtr) || ((BoolVector)diffLivenesses.second).get(indexPtr) || this.otherNeeds(recompInfos, index) && (lastChanceZones.second == null || !((BoolVector)lastChanceZones.second).get(indexPtr))) continue;
            indexFound = index;
            rkFoundOnDiffPtr = indexPtr;
        }
        if (indexFound != -1) {
            result = indexPtr == -1 ? new TapIntList(indexFound, new TapIntList(rkFound, null)) : new TapIntList(indexFound, new TapIntList(rkFound, new TapIntList(rkFoundOnDiffPtr, null)));
        }
        return result;
    }

    private void tbrAndRecomputabilityThroughExpression(Tree instrTree, BoolVector tbr, BoolVector tbrOnDiffPtr, RecompInfo[] recomp, BoolVector diffOverwritesAfter, ToBool arrives) {
        Tree[] sons;
        TapIntList valueZonesList;
        Tree index;
        TapIntList writtenZonesList = null;
        int[] diffVectorMap = ADTBRAnalyzer.makeMap3(0, 0, this.curSymbolTable.declaredZonesNb(TapEnv.diffKind()));
        boolean adjRequiresInstr = TapEnv.debugAdMode() == -1 || !TapEnv.removeDeadPrimal() || TapEnv.diffLivenessAnalyzer() == null || ADTBRAnalyzer.isTreeRequiredInDiff(this.curActivity, instrTree, false);
        RecompInfo newRecompInfo = null;
        if (instrTree.opCode() == 168 && !ILUtils.isNullOrNone(instrTree.down(1))) {
            String returnVarName = this.curUnit.otherReturnVar() == null ? this.curUnit.name() : this.curUnit.otherReturnVar().symbol;
            Tree assignReturn = ILUtils.build(14, ILUtils.build(96, returnVarName), ILUtils.copy(instrTree.down(1)));
            if (ADActivityAnalyzer.isAnnotatedActive(this.curActivity, instrTree.down(1), this.curSymbolTable)) {
                ADActivityAnalyzer.setAnnotatedActive(this.curActivity, assignReturn.down(1));
            }
            instrTree = assignReturn;
        }
        int opCode = instrTree.opCode();
        Tree callResult = null;
        Tree functionCall = null;
        ToBool total = new ToBool(false);
        Unit calledUnit = null;
        if (opCode == 31) {
            functionCall = instrTree;
        } else if (opCode == 14 && instrTree.down(2).opCode() == 31) {
            functionCall = instrTree.down(2);
            callResult = instrTree.down(1);
        }
        if (functionCall != null) {
            calledUnit = ADTBRAnalyzer.getCalledUnit(functionCall, this.curSymbolTable);
        }
        if (calledUnit != null && !calledUnit.hasPredefinedDerivatives()) {
            if (calledUnit.unitInOutW == null) {
                arrives.set(false);
            } else {
                TapList<?> writtenZonesTree = this.curSymbolTable.treeOfZonesOfValue(callResult, null, this.curInstruction, null);
                writtenZonesList = ZoneInfo.listAllZones(writtenZonesTree, true);
                CallArrow arrow = CallGraph.getCallArrow(this.curUnit, calledUnit);
                Tree[] actualParams = ILUtils.getArguments(functionCall).children();
                int nbArgs = actualParams.length;
                boolean[] argsTotal = new boolean[nbArgs + 1];
                TapList[] argsZones = new TapList[nbArgs + 1];
                BoolVector tbrUpstreamCall = tbr.copy();
                BoolVector tbrUpstreamCallOnDiffPtr = tbrOnDiffPtr.copy();
                for (int i = nbArgs; i >= 0; --i) {
                    Tree argTree;
                    Tree tree = argTree = i == nbArgs ? callResult : actualParams[i];
                    if (argTree != null) {
                        boolean argHasDiff = ADActivityAnalyzer.isAnnotatedActive(this.curActivity, argTree, this.curSymbolTable) || ReqExplicit.isAnnotatedReqX(this.curActivity, argTree);
                        argsZones[i] = this.findRequiredZonesAndTBR(argTree, true, argHasDiff, tbr, tbrOnDiffPtr, total, this.curSymbolTable);
                        if (i != nbArgs) {
                            argsZones[i] = TapList.copyTree(argsZones[i]);
                            ADTBRAnalyzer.includePointedElementsInTree(argsZones[i], total, null, true, this.curSymbolTable, this.curInstruction, calledUnit, false, true);
                        }
                        argsTotal[i] = this.referenceIsTotal(total.get(), argsZones[i]);
                        continue;
                    }
                    argsZones[i] = null;
                    argsTotal[i] = false;
                }
                if (this.phase == 2 && TapEnv.doRecompute() && recomp != null) {
                    BoolVector functionW = new BoolVector(this.nDZ);
                    TapList[] outCArgs = ADTBRAnalyzer.propagateCalleeDataToCallSite(calledUnit.unitInOutPossiblyW(), functionW, null, null, true, functionCall, this.curInstruction, arrow, this.vectorMap, 0, null, null, false, false);
                    for (int i = nbArgs; i >= 0; --i) {
                        this.setInfoBoolTreeToExtendedDeclaredZones(functionW, this.vectorMap, argsZones[i], true, i == nbArgs ? new TapList(Boolean.TRUE, null) : outCArgs[i + 1], true, 0);
                    }
                    this.setZonesNonRecomputable(recomp, functionW, this.cleanLoopIndexZones.retrieve(this.curBlock), diffOverwritesAfter, tbr, this.nDZ);
                }
                if (ADTBRAnalyzer.isTreeRequiredInDiff(this.curActivity, functionCall, false)) {
                    adjRequiresInstr = true;
                }
                if (MPIcallInfo.isMessagePassingFunction(calledUnit.name(), calledUnit.language())) {
                    adjRequiresInstr = true;
                }
                ActivityPattern calledActivity = (ActivityPattern)ActivityPattern.getAnnotationForActivityPattern(functionCall, this.curActivity, "multiActivityCalleePatterns");
                BoolVector sbk = new BoolVector(this.nDZ);
                BoolVector sbkOnDiffPtr = new BoolVector(this.nDPZ);
                TapList[] sbkArgs = new TapList[nbArgs + 1];
                TapList[] sbkArgsOnDiffPtr = new TapList[nbArgs + 1];
                BoolVector snp = new BoolVector(this.nDZ);
                BoolVector snpOnDiffPtr = new BoolVector(this.nDPZ);
                TapList[] snpArgs = new TapList[nbArgs + 1];
                TapList[] snpArgsOnDiffPtr = new TapList[nbArgs + 1];
                BoolVector tbrC = new BoolVector(this.nDZ);
                BoolVector tbrCOnDiffPtr = new BoolVector(this.nDPZ);
                TapList[] tbrCArgs = new TapList[nbArgs];
                TapList[] tbrCArgsOnDiffPtr = new TapList[nbArgs];
                BoolVector tbrD = new BoolVector(this.nDZ);
                BoolVector tbrDOnDiffPtr = new BoolVector(this.nDPZ);
                BoolVector popped = new BoolVector(this.nDZ);
                BoolVector poppedOnDiffPtr = new BoolVector(this.nDPZ);
                this.computeCheckpointingSetsWithDiffPtrForCall(tbr, tbrOnDiffPtr, tbrUpstreamCall, tbrUpstreamCallOnDiffPtr, snp, snpOnDiffPtr, snpArgs, snpArgsOnDiffPtr, sbk, sbkOnDiffPtr, sbkArgs, sbkArgsOnDiffPtr, tbrC, tbrCOnDiffPtr, tbrCArgs, tbrCArgsOnDiffPtr, tbrD, tbrDOnDiffPtr, popped, poppedOnDiffPtr, arrow, functionCall, argsZones, argsTotal, adjRequiresInstr);
                tbr.setCopy(tbrD);
                tbrOnDiffPtr.setCopy(tbrDOnDiffPtr);
                if (this.phase == 2) {
                    TapList[][] tbrOnArgs = new TapList[][]{snpArgs, snpArgsOnDiffPtr, sbkArgs, sbkArgsOnDiffPtr};
                    BoolVector[] tbrOnGlobs = new BoolVector[]{snp, snpOnDiffPtr, sbk, sbkOnDiffPtr};
                    ActivityPattern.setAnnotationForActivityPattern(functionCall, this.curActivity, "TBR", new TapPair<TapList[][], BoolVector[]>(tbrOnArgs, tbrOnGlobs));
                    this.markDestinationsRebased(popped, poppedOnDiffPtr);
                    if (calledActivity != null && !calledUnit.isIntrinsic()) {
                        BoolVector calledContextOnDiffPtr;
                        BoolVector calledContext = calledActivity.adTBRTopDownContext();
                        if (calledContext != null && calledContext.cumulOrGrows(ADTBRAnalyzer.propagateCallSiteDataToCallee(tbrC, ADTBRAnalyzer.addZeroIndexTEMPORARY(tbrCArgs), null, null, true, functionCall, this.curInstruction, arrow, this.vectorMap, 0, false), calledUnit.publicZonesNumber(0))) {
                            calledUnit.analysisIsOutOfDateDown = true;
                        }
                        if ((calledContextOnDiffPtr = calledActivity.adTBRTopDownContextOnDiffPtr()) != null && calledContextOnDiffPtr.cumulOrGrows(ADTBRAnalyzer.propagateCallSiteDataToCallee(tbrCOnDiffPtr, ADTBRAnalyzer.addZeroIndexTEMPORARY(tbrCArgsOnDiffPtr), null, null, true, functionCall, this.curInstruction, arrow, this.pointerVectorMap, 3, false), calledUnit.publicZonesNumber(3))) {
                            calledUnit.analysisIsOutOfDateDown = true;
                        }
                    }
                }
                if (callResult != null && adjRequiresInstr) {
                    TapIntList resultZones = ZoneInfo.listAllZones(argsZones[nbArgs], true);
                    boolean mustRestore = this.requiredZones(resultZones, tbr);
                    boolean mustRestoreOnDiffPtr = this.requiredZonesOnDiffPtr(resultZones, tbrOnDiffPtr);
                    if (this.phase == 2) {
                        ActivityPattern.setAnnotationForActivityPattern(callResult, this.curActivity, "TBR", new boolean[]{mustRestore, mustRestoreOnDiffPtr});
                        this.markDestinationsRebased(resultZones, mustRestore, mustRestoreOnDiffPtr);
                    }
                    if (argsTotal[nbArgs]) {
                        this.setExtendedDeclared(tbr, this.vectorMap, 0, resultZones, false);
                        this.setExtendedDeclared(tbrOnDiffPtr, this.pointerVectorMap, 3, resultZones, false);
                    }
                }
            }
        } else if (opCode == 109) {
            ToBool writtenTotal = new ToBool(false);
            boolean isIORead = ILUtils.isIORead(instrTree);
            Tree[] exprs = instrTree.down(3).children();
            BoolVector zonesOverwritten = new BoolVector(this.nDZ);
            for (int i = exprs.length - 1; i >= 0; --i) {
                Tree expr = exprs[i];
                if (isIORead) {
                    TapList<?> exprWrittenZonesTree = this.curSymbolTable.treeOfZonesOfValue(expr, writtenTotal, this.curInstruction, null);
                    TapIntList exprWrittenZonesList = ZoneInfo.listAllZones(exprWrittenZonesTree, false);
                    boolean mustRestore = this.requiredZones(exprWrittenZonesList, tbr);
                    if (this.phase == 2) {
                        ActivityPattern.setAnnotationForActivityPattern(expr, this.curActivity, "TBR", new boolean[]{mustRestore, false});
                        this.markDestinationsRebased(exprWrittenZonesList, mustRestore, false);
                        if (TapEnv.doRecompute() && recomp != null) {
                            this.setExtendedDeclared(zonesOverwritten, this.vectorMap, 0, exprWrittenZonesList, true);
                        }
                    }
                    if (adjRequiresInstr && this.referenceIsTotal(writtenTotal.get(), exprWrittenZonesTree)) {
                        this.setExtendedDeclared(tbr, this.vectorMap, 0, exprWrittenZonesList, false);
                    }
                    writtenZonesList = TapIntList.union(writtenZonesList, exprWrittenZonesList);
                }
                this.tbrAndRecomputabilityThroughExpression(expr, tbr, tbrOnDiffPtr, null, diffOverwritesAfter, arrives);
            }
            if (this.phase == 2 && TapEnv.doRecompute() && recomp != null) {
                this.setZonesNonRecomputable(recomp, zonesOverwritten, this.cleanLoopIndexZones.retrieve(this.curBlock), diffOverwritesAfter, tbr, this.nDZ);
            }
        } else if (opCode == 14) {
            TapIntList valueZonesList2;
            Tree lhs = instrTree.down(1);
            Tree rhs = instrTree.down(2);
            TapList<?> writtenZonesTree = this.curSymbolTable.treeOfZonesOfValue(lhs, total, this.curInstruction, null);
            writtenZonesList = ZoneInfo.listAllZones(writtenZonesTree, false);
            TapIntList writtenDiffKindVectorIndices = ADTBRAnalyzer.mapExtendedDeclaredToVectorIndex(writtenZonesList, TapEnv.diffKind(), diffVectorMap, this.curSymbolTable, null);
            if (ADActivityAnalyzer.isAnnotatedActive(this.curActivity, lhs, this.curSymbolTable) || writtenDiffKindVectorIndices != null && TapEnv.debugAdMode() == -1) {
                if (!TapEnv.doTBR() && TapEnv.get().dontSaveUnused) {
                    valueZonesList2 = ZoneInfo.listAllZones(this.findRequiredZonesAndTBR(rhs, true, true, tbr, tbrOnDiffPtr, null, this.curSymbolTable), true);
                    this.setExtendedDeclared(tbr, this.vectorMap, 0, valueZonesList2, true);
                    this.setExtendedDeclared(tbrOnDiffPtr, this.pointerVectorMap, 3, valueZonesList2, true);
                    this.findRequiredZonesAndTBR(lhs, false, true, tbr, tbrOnDiffPtr, null, this.curSymbolTable);
                } else {
                    WrapperTypeSpec assignedType = this.curSymbolTable.typeOf(lhs);
                    if (assignedType == null || !assignedType.containsAPointer()) {
                        ToInt lhsDiffUsage = new ToInt(0);
                        if (ADActivityAnalyzer.isAnnotatedActive(this.curActivity, rhs, this.curSymbolTable)) {
                            this.collectZonesUsedByDiffRhs(rhs, lhs, lhsDiffUsage, false, true, tbr, tbrOnDiffPtr);
                        }
                        if (lhsDiffUsage.get() != 1) {
                            this.collectAllDiffExpression(lhs, tbr, tbrOnDiffPtr);
                        }
                    }
                }
            }
            boolean mustRestore = this.requiredZones(writtenZonesList, tbr);
            boolean mustRestoreOnDiffPtr = this.requiredZonesOnDiffPtr(writtenZonesList, tbrOnDiffPtr);
            boolean adjRequiresInstrOnDiffPtr = TapEnv.debugAdMode() == -1 || !TapEnv.removeDeadPrimal() || TapEnv.diffLivenessAnalyzer() == null || ADTBRAnalyzer.isTreeRequiredInDiff(this.curActivity, instrTree, true);
            Boolean isInitialization = (Boolean)lhs.getAnnotation("IsInitialization");
            if (isInitialization != null && isInitialization.booleanValue()) {
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("  Assignment " + ILUtils.toString(instrTree) + " is an initialization: no restoration needed.");
                }
                mustRestore = false;
                mustRestoreOnDiffPtr = false;
            }
            if (this.phase == 2) {
                ActivityPattern.setAnnotationForActivityPattern(lhs, this.curActivity, "TBR", new boolean[]{mustRestore, mustRestoreOnDiffPtr});
                this.markDestinationsRebased(writtenZonesList, mustRestore, mustRestoreOnDiffPtr);
                if (TapEnv.doRecompute() && recomp != null) {
                    BoolVector zonesOverwritten = new BoolVector(this.nDZ);
                    this.setExtendedDeclared(zonesOverwritten, this.vectorMap, 0, writtenZonesList, true);
                    this.setZonesNonRecomputable(recomp, zonesOverwritten, this.cleanLoopIndexZones.retrieve(this.curBlock), diffOverwritesAfter, tbr, this.nDZ);
                    if (total.get() && this.curInstruction.getWhereMask() == null && writtenZonesList != null && writtenZonesList.tail == null && (adjRequiresInstr || adjRequiresInstrOnDiffPtr) && this.approxRecomputeCost(instrTree) < 20) {
                        BoolVector usedZones = this.curSymbolTable.zonesUsedByExp(instrTree, this.curInstruction);
                        int writtenZone = writtenZonesList.head;
                        newRecompInfo = new RecompInfo(this.curInstruction, usedZones);
                        if (!usedZones.get(writtenZone) && newRecompInfo.isValidNow(recomp, this.cleanLoopIndexZones.retrieve(this.curBlock), diffOverwritesAfter, tbr, this.nDZ)) {
                            this.setExtendedDeclared(recomp, this.vectorMap, writtenZone, newRecompInfo);
                            ActivityPattern.setInstructionBoolInfo(this.curUnitMayBeRecomputeds, this.curInstruction, 1, adjRequiresInstr);
                            ActivityPattern.setInstructionBoolInfo(this.curUnitMayBeRecomputeds, this.curInstruction, 2, adjRequiresInstrOnDiffPtr);
                            if (TapEnv.traceCurAnalysis()) {
                                int k2 = this.extendedDeclaredToVectorIndex(writtenZone, 0, this.vectorMap);
                                TapEnv.printlnOnTrace("      New Available recomp: " + k2 + " >> " + newRecompInfo);
                            }
                        } else {
                            ActivityPattern.setInstructionBoolInfo(this.curUnitMayBeRecomputeds, this.curInstruction, 1, false);
                            ActivityPattern.setInstructionBoolInfo(this.curUnitMayBeRecomputeds, this.curInstruction, 2, false);
                            newRecompInfo = null;
                        }
                    }
                }
            }
            if (mustRestore || mustRestoreOnDiffPtr) {
                this.collectAllPrimalExpression(lhs, tbr);
            }
            if (adjRequiresInstr && this.referenceIsTotal(total.get(), writtenZonesTree)) {
                this.setExtendedDeclared(tbr, this.vectorMap, 0, writtenZonesList, false);
                this.setExtendedDeclared(tbrOnDiffPtr, this.pointerVectorMap, 3, writtenZonesList, false);
            }
            if (rhs.opCode() == 5) {
                valueZonesList2 = ZoneInfo.listAllZones(this.findRequiredZonesAndTBR(lhs, true, true, tbr, tbrOnDiffPtr, null, this.curSymbolTable), true);
                this.setExtendedDeclared(tbr, this.vectorMap, 0, valueZonesList2, true);
                if (ReqExplicit.isAnnotatedReqX(this.curActivity, lhs)) {
                    this.setExtendedDeclared(tbrOnDiffPtr, this.pointerVectorMap, 3, valueZonesList2, true);
                }
            }
        } else if (opCode == 64) {
            this.tbrAndRecomputabilityThroughExpression(instrTree.down(2), tbr, tbrOnDiffPtr, null, diffOverwritesAfter, arrives);
            this.tbrAndRecomputabilityThroughExpression(instrTree.down(3), tbr, tbrOnDiffPtr, null, diffOverwritesAfter, arrives);
            this.tbrAndRecomputabilityThroughExpression(instrTree.down(4), tbr, tbrOnDiffPtr, null, diffOverwritesAfter, arrives);
            index = instrTree.down(1);
            TapList<?> writtenZonesTree = this.curSymbolTable.treeOfZonesOfValue(index, total, this.curInstruction, null);
            writtenZonesList = ZoneInfo.listAllZones(writtenZonesTree, true);
            if (adjRequiresInstr && this.referenceIsTotal(total.get(), writtenZonesTree)) {
                tbr.setDeclared(writtenZonesList, this.vectorMap, false);
            }
            for (int i = 2; i <= 4; ++i) {
                Tree bound = instrTree.down(i);
                if (!InOutAnalyzer.isCheapDuplicableConstant(bound, this.curBlock, this.curInstruction)) continue;
                BoolVector usedZones = this.curBlock.symbolTable.zonesUsedByExp(bound, this.curInstruction);
                tbr.cumulOr(usedZones);
            }
        } else if (opCode == 205) {
            valueZonesList = ZoneInfo.listAllZones(this.findRequiredZonesAndTBR(instrTree.down(1), true, false, tbr, null, total, this.curSymbolTable), true);
            this.setExtendedDeclared(tbr, this.vectorMap, 0, valueZonesList, true);
        } else if (opCode == 110) {
            this.tbrAndRecomputabilityThroughExpression(instrTree.down(1), tbr, tbrOnDiffPtr, null, diffOverwritesAfter, arrives);
            index = instrTree.down(2).down(1);
            TapList<?> writtenZonesTree = this.curSymbolTable.treeOfZonesOfValue(index, total, this.curInstruction, null);
            writtenZonesList = ZoneInfo.listAllZones(writtenZonesTree, false);
            if (this.requiredZones(writtenZonesList, tbr) && this.phase == 2) {
                ActivityPattern.setAnnotationForActivityPattern(index, this.curActivity, "TBR", new boolean[]{true, false});
                this.markDestinationsRebased(writtenZonesList, true, false);
            }
            this.tbrAndRecomputabilityThroughExpression(instrTree.down(2), tbr, tbrOnDiffPtr, null, diffOverwritesAfter, arrives);
        } else if (opCode == 52) {
            valueZonesList = ZoneInfo.listAllZones(this.findRequiredZonesAndTBR(instrTree.down(1), true, true, tbr, tbrOnDiffPtr, total, this.curSymbolTable), true);
            if (total.get()) {
                this.setExtendedDeclared(tbr, this.vectorMap, 0, valueZonesList, false);
                this.setExtendedDeclared(tbrOnDiffPtr, this.pointerVectorMap, 3, valueZonesList, false);
            }
        } else if (opCode != 98 && (sons = instrTree.children()) != null) {
            for (int i = sons.length - 1; i >= 0; --i) {
                this.tbrAndRecomputabilityThroughExpression(sons[i], tbr, tbrOnDiffPtr, null, diffOverwritesAfter, arrives);
            }
        }
        if (this.phase == 2 && TapEnv.doRecompute() && recomp != null && adjRequiresInstr && newRecompInfo == null) {
            BoolVector usedZones = this.curSymbolTable.zonesUsedByExp(instrTree, this.curInstruction);
            InstructionMask curMask = this.curInstruction.getWhereMask();
            while (curMask != null) {
                usedZones.cumulOr(this.curSymbolTable.zonesUsedByExp(curMask.getControlTree(), curMask.controlInstruction));
                curMask = curMask.enclosingMask;
            }
            this.setInstructionRemainsInFwdSweepOnZones(recomp, usedZones, 1);
        }
        if (!TapEnv.doTBR() && !TapEnv.get().dontSaveUnused) {
            this.setExtendedDeclared(tbr, this.vectorMap, 0, writtenZonesList, true);
            this.setExtendedDeclared(tbrOnDiffPtr, this.pointerVectorMap, 3, writtenZonesList, true);
        }
    }

    private void collectZonesUsedByDiffRhs(Tree expression, Tree lhs, ToInt lhsDiffUsage, boolean allPrimal, boolean partialIsOne, BoolVector tbr, BoolVector tbrOnDiffPtr) {
        switch (expression.opCode()) {
            case 31: {
                int i;
                Unit calledUnit = ADTBRAnalyzer.getCalledUnit(expression, this.curSymbolTable);
                AtomFuncDerivative funcDerivative = (AtomFuncDerivative)calledUnit.diffInfo;
                Tree[] paramExprs = ILUtils.getArguments(expression).children();
                if ("sum".equals(calledUnit.name()) || "spread".equals(calledUnit.name())) {
                    for (i = paramExprs.length - 1; i > 0; --i) {
                        this.collectAllPrimalExpression(paramExprs[i], tbr);
                    }
                }
                if (funcDerivative != null && (this.curUnit.isFortran() ? ILUtils.isIdentOf(ILUtils.getCalledName(expression), new String[]{"complex", "cmplx", "dcmplx", "sngl", "dble", "real", "dreal", "aimag", "dimag", "conjg", "dconjg"}, false) : ILUtils.isIdentOf(ILUtils.getCalledName(expression), new String[]{"creal", "cimag", "conj"}, true))) {
                    this.collectZonesUsedByDiffRhs(paramExprs[0], lhs, lhsDiffUsage, allPrimal, false, tbr, tbrOnDiffPtr);
                    int doneIndex = 0;
                    if (paramExprs.length >= 2 && ILUtils.isIdentOf(ILUtils.getCalledName(expression), new String[]{"complex", "cmplx", "dcmplx"}, false)) {
                        this.collectZonesUsedByDiffRhs(paramExprs[1], lhs, lhsDiffUsage, allPrimal, false, tbr, tbrOnDiffPtr);
                        doneIndex = 1;
                    }
                    for (int i2 = doneIndex + 1; i2 < paramExprs.length; ++i2) {
                        this.collectAllPrimalExpression(paramExprs[i2], tbr);
                    }
                }
                if (funcDerivative != null) {
                    funcDerivative.matches(expression);
                    paramExprs = funcDerivative.getParamExprs();
                }
                for (i = paramExprs.length - 1; i >= 0; --i) {
                    boolean exprAllPrimal = allPrimal;
                    if (!allPrimal) {
                        if (funcDerivative == null) {
                            this.collectAllPrimalExpression(paramExprs[i], tbr);
                            exprAllPrimal = true;
                        } else {
                            this.collectAllPrimalExpression(funcDerivative.buildPartialDerivative(i), tbr);
                        }
                    }
                    if (!ADActivityAnalyzer.isAnnotatedActive(this.curActivity, paramExprs[i], this.curSymbolTable)) continue;
                    this.collectZonesUsedByDiffRhs(paramExprs[i], lhs, lhsDiffUsage, exprAllPrimal, false, tbr, tbrOnDiffPtr);
                }
                break;
            }
            case 9: 
            case 75: 
            case 96: 
            case 151: {
                if (1 == ILUtils.eqOrDisjointRef(expression, lhs, this.curInstruction, this.curInstruction)) {
                    lhsDiffUsage.set(lhsDiffUsage.get() == 0 && partialIsOne ? 1 : 999);
                    break;
                }
                lhsDiffUsage.set(999);
                this.collectAllDiffExpression(expression, tbr, tbrOnDiffPtr);
                break;
            }
            case 3: {
                if (ADActivityAnalyzer.isAnnotatedActive(this.curActivity, expression.down(1), this.curSymbolTable)) {
                    this.collectZonesUsedByDiffRhs(expression.down(1), lhs, lhsDiffUsage, allPrimal, partialIsOne, tbr, tbrOnDiffPtr);
                }
                if (!ADActivityAnalyzer.isAnnotatedActive(this.curActivity, expression.down(2), this.curSymbolTable)) break;
                this.collectZonesUsedByDiffRhs(expression.down(2), lhs, lhsDiffUsage, allPrimal, partialIsOne, tbr, tbrOnDiffPtr);
                break;
            }
            case 182: {
                if (ADActivityAnalyzer.isAnnotatedActive(this.curActivity, expression.down(1), this.curSymbolTable)) {
                    this.collectZonesUsedByDiffRhs(expression.down(1), lhs, lhsDiffUsage, allPrimal, partialIsOne, tbr, tbrOnDiffPtr);
                }
                if (!ADActivityAnalyzer.isAnnotatedActive(this.curActivity, expression.down(2), this.curSymbolTable)) break;
                this.collectZonesUsedByDiffRhs(expression.down(2), lhs, lhsDiffUsage, allPrimal, false, tbr, tbrOnDiffPtr);
                break;
            }
            case 133: {
                boolean active1 = ADActivityAnalyzer.isAnnotatedActive(this.curActivity, expression.down(1), this.curSymbolTable);
                boolean active2 = ADActivityAnalyzer.isAnnotatedActive(this.curActivity, expression.down(2), this.curSymbolTable);
                if (active1) {
                    if (!allPrimal) {
                        this.collectAllPrimalExpression(expression.down(2), tbr);
                    }
                    this.collectZonesUsedByDiffRhs(expression.down(1), lhs, lhsDiffUsage, allPrimal || active2, false, tbr, tbrOnDiffPtr);
                }
                if (!active2) break;
                if (!allPrimal) {
                    this.collectAllPrimalExpression(expression.down(1), tbr);
                }
                this.collectZonesUsedByDiffRhs(expression.down(2), lhs, lhsDiffUsage, allPrimal || active1, false, tbr, tbrOnDiffPtr);
                break;
            }
            case 62: {
                boolean active1 = ADActivityAnalyzer.isAnnotatedActive(this.curActivity, expression.down(1), this.curSymbolTable);
                boolean active2 = ADActivityAnalyzer.isAnnotatedActive(this.curActivity, expression.down(2), this.curSymbolTable);
                if (!allPrimal) {
                    this.collectAllPrimalExpression(expression.down(2), tbr);
                }
                if (active1) {
                    this.collectZonesUsedByDiffRhs(expression.down(1), lhs, lhsDiffUsage, allPrimal || active2, false, tbr, tbrOnDiffPtr);
                }
                if (!active2) break;
                if (!allPrimal) {
                    this.collectAllPrimalExpression(expression.down(1), tbr);
                }
                this.collectZonesUsedByDiffRhs(expression.down(2), lhs, lhsDiffUsage, true, false, tbr, tbrOnDiffPtr);
                break;
            }
            case 126: 
            case 155: {
                if (!allPrimal) {
                    this.collectAllPrimalExpression(expression, tbr);
                }
                if (ADActivityAnalyzer.isAnnotatedActive(this.curActivity, expression.down(1), this.curSymbolTable)) {
                    this.collectZonesUsedByDiffRhs(expression.down(1), lhs, lhsDiffUsage, true, false, tbr, tbrOnDiffPtr);
                }
                if (!ADActivityAnalyzer.isAnnotatedActive(this.curActivity, expression.down(2), this.curSymbolTable)) break;
                this.collectZonesUsedByDiffRhs(expression.down(2), lhs, lhsDiffUsage, true, false, tbr, tbrOnDiffPtr);
                break;
            }
            case 124: 
            case 194: {
                this.collectZonesUsedByDiffRhs(expression.down(1), lhs, lhsDiffUsage, allPrimal, false, tbr, tbrOnDiffPtr);
                break;
            }
            case 32: 
            case 134: {
                this.collectZonesUsedByDiffRhs(expression.down(2), lhs, lhsDiffUsage, allPrimal, false, tbr, tbrOnDiffPtr);
                break;
            }
            case 10: {
                Tree[] expressions = expression.children();
                for (int i = expressions.length - 1; i >= 0; --i) {
                    this.collectZonesUsedByDiffRhs(expressions[i], lhs, lhsDiffUsage, allPrimal, false, tbr, tbrOnDiffPtr);
                }
                break;
            }
            case 99: {
                if (!allPrimal) {
                    this.collectAllPrimalExpression(expression.down(1), tbr);
                }
                if (ADActivityAnalyzer.isAnnotatedActive(this.curActivity, expression.down(1), this.curSymbolTable)) {
                    this.collectZonesUsedByDiffRhs(expression.down(1), lhs, lhsDiffUsage, allPrimal, false, tbr, tbrOnDiffPtr);
                }
                if (!ADActivityAnalyzer.isAnnotatedActive(this.curActivity, expression.down(2), this.curSymbolTable)) break;
                this.collectZonesUsedByDiffRhs(expression.down(2), lhs, lhsDiffUsage, allPrimal, false, tbr, tbrOnDiffPtr);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 28: 
            case 42: 
            case 43: 
            case 68: 
            case 92: 
            case 95: 
            case 103: 
            case 111: 
            case 115: 
            case 116: 
            case 118: 
            case 122: 
            case 129: 
            case 137: 
            case 143: 
            case 160: 
            case 169: 
            case 176: 
            case 180: 
            case 181: 
            case 207: {
                break;
            }
            default: {
                TapEnv.toolWarning(-1, "(Expressions used in adjoint) Unexpected operator: " + expression.opName() + " in " + ILUtils.toString(expression));
            }
        }
    }

    private void collectAllPrimalExpression(Tree expression, BoolVector tbr) {
        TapIntList valueZonesList = ZoneInfo.listAllZones(this.findRequiredZonesAndTBR(expression, true, false, tbr, null, null, this.curSymbolTable), true);
        this.setExtendedDeclared(tbr, this.vectorMap, 0, valueZonesList, true);
    }

    private void collectAllDiffExpression(Tree expression, BoolVector tbr, BoolVector tbrOnDiffPtr) {
        TapIntList valueZonesList = ZoneInfo.listAllZones(this.findRequiredZonesAndTBR(expression, false, true, tbr, tbrOnDiffPtr, null, this.curSymbolTable), true);
        this.setExtendedDeclared(tbrOnDiffPtr, this.pointerVectorMap, 3, valueZonesList, true);
    }

    private void computeCheckpointingSetsWithDiffPtrForCall(BoolVector tbr, BoolVector tbrOnDiffPtr, BoolVector tbrUC, BoolVector tbrUCOnDiffPtr, BoolVector snp, BoolVector snpOnDiffPtr, TapList[] snpArgs, TapList[] snpArgsOnDiffPtr, BoolVector sbk, BoolVector sbkOnDiffPtr, TapList[] sbkArgs, TapList[] sbkArgsOnDiffPtr, BoolVector tbrC, BoolVector tbrCOnDiffPtr, TapList[] tbrCArgs, TapList[] tbrCArgsOnDiffPtr, BoolVector tbrD, BoolVector tbrDOnDiffPtr, BoolVector popped, BoolVector poppedOnDiffPtr, CallArrow callArrow, Tree callTree, TapList[] argsZones, boolean[] argsTotal, boolean adjRequiresCall) {
        Unit calledUnit = callArrow.destination;
        boolean thisCallIsSplitAdj = this.curInstruction.hasDirective(12) != null || calledUnit.hasDirective(12) != null;
        boolean useLazySnapshot = true;
        boolean thisCallIsActive = ADActivityAnalyzer.isAnnotatedActive(this.curActivity, callTree, this.curSymbolTable);
        boolean calleeAcceptsTBR = !thisCallIsActive || !calledUnit.isExternal();
        ActivityPattern calledActivity = (ActivityPattern)ActivityPattern.getAnnotationForActivityPattern(callTree, this.curActivity, "multiActivityCalleePatterns");
        if (thisCallIsActive && !thisCallIsSplitAdj) {
            calledUnit.maybeCheckpointed = true;
        }
        Tree[] argTrees = ILUtils.getArguments(callTree).children();
        int nbArgs = argTrees.length;
        BoolVector pwC = null;
        BoolVector pwCOnDiffPtr = null;
        TapList[] pwCArgs = null;
        if (calledUnit.unitInOutW != null && !thisCallIsSplitAdj && (thisCallIsActive || adjRequiresCall)) {
            pwC = new BoolVector(this.nDZ);
            pwCArgs = ADTBRAnalyzer.propagateCalleeDataToCallSite(calledUnit.unitInOutPossiblyW(), pwC, null, null, true, callTree, this.curInstruction, callArrow, this.vectorMap, 0, null, null, false, false);
            pwCArgs = ADTBRAnalyzer.removeZeroIndexTEMPORARY(pwCArgs);
            pwCOnDiffPtr = this.curSymbolTable.focusToKind(pwC, 3);
            for (int i = nbArgs - 1; i >= 0; --i) {
                pwCArgs[i] = TapList.cumulWithOper(pwCArgs[i], ADTBRAnalyzer.buildInfoBoolTreeOfDeclaredZones(argsZones[i], pwC, this.vectorMap, null, 0, this.curSymbolTable), 91);
                if (!callArrow.takesArgumentByValue(i + 1)) continue;
                ADTBRAnalyzer.removeInfoOnTopLevel(pwCArgs[i], Boolean.FALSE);
            }
        }
        TapList[] tbrArgs = new TapList[nbArgs];
        TapList[] tbrArgsOnDiffPtr = new TapList[nbArgs];
        if (!useLazySnapshot || !calleeAcceptsTBR) {
            for (int i = nbArgs - 1; i >= 0; --i) {
                tbrArgs[i] = ADTBRAnalyzer.buildInfoBoolTreeOfDeclaredZones(argsZones[i], tbr, this.vectorMap, null, 0, this.curSymbolTable);
                tbrArgsOnDiffPtr[i] = ADTBRAnalyzer.buildInfoBoolTreeOfDeclaredZones(argsZones[i], tbrOnDiffPtr, this.pointerVectorMap, null, 3, this.curSymbolTable);
            }
        }
        TapList[] tbrUCArgs = new TapList[nbArgs];
        TapList[] tbrUCArgsOnDiffPtr = new TapList[nbArgs];
        if (useLazySnapshot && !calleeAcceptsTBR) {
            for (int i = nbArgs - 1; i >= 0; --i) {
                tbrUCArgs[i] = ADTBRAnalyzer.buildInfoBoolTreeOfDeclaredZones(argsZones[i], tbrUC, this.vectorMap, null, 0, this.curSymbolTable);
                tbrUCArgsOnDiffPtr[i] = ADTBRAnalyzer.buildInfoBoolTreeOfDeclaredZones(argsZones[i], tbrUCOnDiffPtr, this.pointerVectorMap, null, 3, this.curSymbolTable);
            }
        }
        BoolVector killC = null;
        BoolVector killCOnDiffPtr = null;
        BoolVector tbrF = null;
        BoolVector tbrFOnDiffPtr = null;
        if (thisCallIsSplitAdj) {
            killC = new BoolVector(this.nDZ);
            ADTBRAnalyzer.propagateCalleeDataToCallSite(calledUnit.unitInOutCertainlyW(), killC, null, argTrees, true, callTree, this.curInstruction, callArrow, this.vectorMap, 0, null, null, false, true);
            killCOnDiffPtr = this.curSymbolTable.focusToKind(killC, 3);
            tbrF = new BoolVector(this.nDZ);
            tbrFOnDiffPtr = new BoolVector(this.nDPZ);
            if (calledActivity != null && calledActivity.localExitTBR() != null) {
                ADTBRAnalyzer.propagateCalleeDataToCallSite(calledActivity.localExitTBR(), tbrF, null, argTrees, true, callTree, this.curInstruction, callArrow, this.vectorMap, 0, null, null, true, false);
                ADTBRAnalyzer.propagateCalleeDataToCallSite(calledActivity.localExitTBROnDiffPtr(), tbrFOnDiffPtr, null, argTrees, true, callTree, this.curInstruction, callArrow, this.pointerVectorMap, 3, null, null, true, false);
            }
        }
        BoolVector useCb = null;
        BoolVector useCbOnDiffPtr = null;
        TapList[] useCbArgs = null;
        TapList[] useCbArgsOnDiffPtr = null;
        if (!thisCallIsSplitAdj) {
            int i;
            int i2;
            BoolVector calleeDiffLiveness = null;
            if (TapEnv.diffLivenessAnalyzer() == null || !TapEnv.removeDeadPrimal()) {
                calleeDiffLiveness = calledUnit.unitInOutPossiblyR();
            } else if (calledActivity != null) {
                calleeDiffLiveness = TapEnv.diffLivenessAnalyzer().getDiffLiveness(calledActivity);
            }
            useCb = new BoolVector(this.nDZ);
            if (thisCallIsActive && calleeDiffLiveness != null) {
                useCbArgs = ADTBRAnalyzer.propagateCalleeDataToCallSite(calleeDiffLiveness, useCb, null, null, true, callTree, this.curInstruction, callArrow, this.vectorMap, 0, null, null, true, false);
                useCbArgs = ADTBRAnalyzer.removeZeroIndexTEMPORARY(useCbArgs);
                for (i2 = nbArgs - 1; i2 >= 0; --i2) {
                    useCbArgs[i2] = TapList.cumulWithOper(useCbArgs[i2], ADTBRAnalyzer.buildInfoBoolTreeOfDeclaredZones(argsZones[i2], useCb, this.vectorMap, null, 0, this.curSymbolTable), 91);
                }
            } else {
                useCbArgs = new TapList[nbArgs];
                for (i2 = nbArgs - 1; i2 >= 0; --i2) {
                    useCbArgs[i2] = ADTBRAnalyzer.buildInfoBoolTreeOfDeclaredZones(argsZones[i2], null, null, null, 0, this.curSymbolTable);
                }
            }
            BoolVector calleeDiffLivenessOnDiffPtr = null;
            if (TapEnv.diffLivenessAnalyzer() == null || !TapEnv.removeDeadPrimal()) {
                calleeDiffLivenessOnDiffPtr = calledUnit.focusToKind(calledUnit.unitInOutPossiblyR(), 3);
            } else if (calledActivity != null) {
                calleeDiffLivenessOnDiffPtr = TapEnv.diffLivenessAnalyzer().getDiffLivenessOnDiffPtr(calledActivity);
            }
            useCbOnDiffPtr = new BoolVector(this.nDPZ);
            if (thisCallIsActive && calleeDiffLivenessOnDiffPtr != null) {
                useCbArgsOnDiffPtr = ADTBRAnalyzer.propagateCalleeDataToCallSite(calleeDiffLivenessOnDiffPtr, useCbOnDiffPtr, null, null, true, callTree, this.curInstruction, callArrow, this.pointerVectorMap, 3, null, null, true, false);
                useCbArgsOnDiffPtr = ADTBRAnalyzer.removeZeroIndexTEMPORARY(useCbArgsOnDiffPtr);
                for (i = nbArgs - 1; i >= 0; --i) {
                    useCbArgsOnDiffPtr[i] = TapList.cumulWithOper(useCbArgsOnDiffPtr[i], ADTBRAnalyzer.buildInfoBoolTreeOfDeclaredZones(argsZones[i], useCbOnDiffPtr, this.pointerVectorMap, null, 3, this.curSymbolTable), 91);
                }
            } else {
                useCbArgsOnDiffPtr = new TapList[nbArgs];
                for (i = nbArgs - 1; i >= 0; --i) {
                    useCbArgsOnDiffPtr[i] = ADTBRAnalyzer.buildInfoBoolTreeOfDeclaredZones(argsZones[i], null, null, null, 3, this.curSymbolTable);
                }
            }
        }
        BoolVector outC = null;
        BoolVector outCOnDiffPtr = null;
        TapList[] outCArgs = null;
        TapList[] outCArgsOnDiffPtr = null;
        if (!thisCallIsSplitAdj) {
            outC = new BoolVector(this.nDZ);
            outCOnDiffPtr = new BoolVector(this.nDPZ);
            if (adjRequiresCall && pwC != null) {
                outC = pwC;
                outCArgs = pwCArgs;
                outCOnDiffPtr = pwCOnDiffPtr;
                outCArgsOnDiffPtr = pwCArgs;
            } else {
                outCArgs = new TapList[nbArgs];
                outCArgsOnDiffPtr = new TapList[nbArgs];
                for (int i = nbArgs - 1; i >= 0; --i) {
                    outCArgs[i] = ADTBRAnalyzer.buildInfoBoolTreeOfDeclaredZones(argsZones[i], null, null, null, 0, this.curSymbolTable);
                    outCArgsOnDiffPtr[i] = ADTBRAnalyzer.buildInfoBoolTreeOfDeclaredZones(argsZones[i], null, null, null, 3, this.curSymbolTable);
                }
            }
        }
        boolean[] argsNonConstant = new boolean[nbArgs + 1];
        if (!thisCallIsSplitAdj) {
            for (int i = nbArgs; i >= 0; --i) {
                argsNonConstant[i] = ZoneInfo.listAllZones(argsZones[i], true) != null;
            }
        }
        BoolVector outCb = null;
        BoolVector outCbOnDiffPtr = null;
        TapList[] outCbArgs = null;
        TapList[] outCbArgsOnDiffPtr = null;
        if (!thisCallIsSplitAdj && !calleeAcceptsTBR) {
            outCb = new BoolVector(this.nDZ);
            outCbOnDiffPtr = new BoolVector(this.nDPZ);
            if (thisCallIsActive && pwC != null) {
                outCb = pwC;
                outCbArgs = pwCArgs;
                outCbOnDiffPtr = pwCOnDiffPtr;
                outCbArgsOnDiffPtr = pwCArgs;
            } else {
                outCbArgs = new TapList[nbArgs];
                outCbArgsOnDiffPtr = new TapList[nbArgs];
                for (int i = nbArgs - 1; i >= 0; --i) {
                    outCbArgs[i] = ADTBRAnalyzer.buildInfoBoolTreeOfDeclaredZones(argsZones[i], null, null, null, 0, this.curSymbolTable);
                    outCbArgsOnDiffPtr[i] = ADTBRAnalyzer.buildInfoBoolTreeOfDeclaredZones(argsZones[i], null, null, null, 3, this.curSymbolTable);
                }
            }
        }
        BoolVector outDb = null;
        BoolVector outDbOnDiffPtr = null;
        if (!thisCallIsSplitAdj && !useLazySnapshot) {
            outDb = this.curBlock.constantZones != null ? this.curBlock.constantZones.not() : callArrow.origin.unitInOutPossiblyW();
            outDbOnDiffPtr = ADTBRAnalyzer.changeKind(outDb, this.vectorMap, 0, this.pointerVectorMap, 3, this.curSymbolTable);
        }
        if (TapEnv.traceCurAnalysis()) {
            TapEnv.printlnOnTrace("        On call " + callArrow);
            TapEnv.printOnTrace("          tbr  = " + this.infoToStringWithDiffPtr(tbr, this.vectorMap, tbrOnDiffPtr, this.pointerVectorMap) + " ");
            TapEnv.dumpOnTrace(tbrArgs);
            TapEnv.printOnTrace(" Ptr:");
            TapEnv.dumpOnTrace(tbrArgsOnDiffPtr);
            TapEnv.printlnOnTrace();
            if (thisCallIsSplitAdj) {
                TapEnv.printlnOnTrace("          killC= " + this.infoToStringWithDiffPtr(killC, this.vectorMap, killCOnDiffPtr, this.pointerVectorMap));
                TapEnv.printlnOnTrace("          tbrF = " + this.infoToStringWithDiffPtr(tbrF, this.vectorMap, tbrFOnDiffPtr, this.pointerVectorMap));
            }
            if (!thisCallIsSplitAdj) {
                TapEnv.printOnTrace("          outC = " + this.infoToStringWithDiffPtr(outC, this.vectorMap, outCOnDiffPtr, this.pointerVectorMap) + " ");
                TapEnv.dumpOnTrace(outCArgs);
                TapEnv.printOnTrace(" Ptr:");
                TapEnv.dumpOnTrace(outCArgsOnDiffPtr);
                TapEnv.printlnOnTrace();
                TapEnv.printOnTrace("          useCb= " + this.infoToStringWithDiffPtr(useCb, this.vectorMap, useCbOnDiffPtr, this.pointerVectorMap) + " ");
                TapEnv.dumpOnTrace(useCbArgs);
                TapEnv.printOnTrace(" Ptr:");
                TapEnv.dumpOnTrace(useCbArgsOnDiffPtr);
                TapEnv.printlnOnTrace();
                if (!useLazySnapshot || !calleeAcceptsTBR) {
                    TapEnv.printOnTrace("          outCb= " + this.infoToStringWithDiffPtr(outCb, this.vectorMap, outCbOnDiffPtr, this.pointerVectorMap) + " ");
                    TapEnv.dumpOnTrace(outCbArgs);
                    TapEnv.printOnTrace(" Ptr:");
                    TapEnv.dumpOnTrace(outCbArgsOnDiffPtr);
                    TapEnv.printlnOnTrace();
                }
                if (useLazySnapshot && !calleeAcceptsTBR) {
                    TapEnv.printOnTrace("          tbrUC= " + this.infoToStringWithDiffPtr(tbrUC, this.vectorMap, tbrUCOnDiffPtr, this.pointerVectorMap) + " ");
                    TapEnv.dumpOnTrace(tbrUCArgs);
                    TapEnv.printOnTrace(" Ptr:");
                    TapEnv.dumpOnTrace(tbrUCArgsOnDiffPtr);
                    TapEnv.printlnOnTrace();
                }
                if (!useLazySnapshot) {
                    TapEnv.printlnOnTrace("          outDb= " + this.infoToStringWithDiffPtr(outDb, this.vectorMap, outDbOnDiffPtr, this.pointerVectorMap));
                }
            }
        }
        this.computeCheckpointingSets(tbr, tbrArgs, outC, outCArgs, useCb, useCbArgs, outCb, outCbArgs, outDb, tbrUC, tbrUCArgs, killC, tbrF, snp, snpArgs, sbk, sbkArgs, tbrC, tbrCArgs, tbrD, popped, this.vectorMap, 0, argTrees, argsZones, argsTotal, argsNonConstant, adjRequiresCall, thisCallIsSplitAdj, useLazySnapshot, calleeAcceptsTBR);
        this.computeCheckpointingSets(tbrOnDiffPtr, tbrArgsOnDiffPtr, outCOnDiffPtr, outCArgsOnDiffPtr, useCbOnDiffPtr, useCbArgsOnDiffPtr, outCbOnDiffPtr, outCbArgsOnDiffPtr, outDbOnDiffPtr, tbrUCOnDiffPtr, tbrUCArgsOnDiffPtr, killCOnDiffPtr, tbrFOnDiffPtr, snpOnDiffPtr, snpArgsOnDiffPtr, sbkOnDiffPtr, sbkArgsOnDiffPtr, tbrCOnDiffPtr, tbrCArgsOnDiffPtr, tbrDOnDiffPtr, poppedOnDiffPtr, this.pointerVectorMap, 3, argTrees, argsZones, argsTotal, argsNonConstant, adjRequiresCall, thisCallIsSplitAdj, useLazySnapshot, calleeAcceptsTBR);
        if (TapEnv.traceCurAnalysis()) {
            if (!thisCallIsSplitAdj) {
                TapEnv.printOnTrace("          >snp = " + this.infoToStringWithDiffPtr(snp, this.vectorMap, snpOnDiffPtr, this.pointerVectorMap) + " ");
                TapEnv.dumpOnTrace(snpArgs);
                TapEnv.printOnTrace(" Ptr:");
                TapEnv.dumpOnTrace(snpArgsOnDiffPtr);
                TapEnv.printlnOnTrace();
                TapEnv.printOnTrace("          >sbk = " + this.infoToStringWithDiffPtr(sbk, this.vectorMap, sbkOnDiffPtr, this.pointerVectorMap) + " ");
                TapEnv.dumpOnTrace(sbkArgs);
                TapEnv.printOnTrace(" Ptr:");
                TapEnv.dumpOnTrace(sbkArgsOnDiffPtr);
                TapEnv.printlnOnTrace();
            }
            TapEnv.printOnTrace("          >tbrC= " + this.infoToStringWithDiffPtr(tbrC, this.vectorMap, tbrCOnDiffPtr, this.pointerVectorMap) + " ");
            TapEnv.dumpOnTrace(tbrCArgs);
            TapEnv.printOnTrace(" Ptr:");
            TapEnv.dumpOnTrace(tbrCArgsOnDiffPtr);
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace("          >tbrD= " + this.infoToStringWithDiffPtr(tbrD, this.vectorMap, tbrDOnDiffPtr, this.pointerVectorMap));
        }
    }

    private void computeCheckpointingSets(BoolVector tbr, TapList[] tbrArgs, BoolVector outC, TapList[] outCArgs, BoolVector useCb, TapList[] useCbArgs, BoolVector outCb, TapList[] outCbArgs, BoolVector outDb, BoolVector tbrUC, TapList[] tbrUCArgs, BoolVector killC, BoolVector tbrF, BoolVector snp, TapList[] snpArgs, BoolVector sbk, TapList[] sbkArgs, BoolVector tbrC, TapList[] tbrCArgs, BoolVector tbrD, BoolVector poppedZones, int[] map, int setKind, Tree[] argTrees, TapList[] argsZones, boolean[] argsTotal, boolean[] argsNonConstant, boolean adjRequiresCall, boolean thisCallIsSplitAdj, boolean useLazySnapshot, boolean calleeAcceptsTBR) {
        int i;
        int nbArgs = argTrees.length;
        if (thisCallIsSplitAdj) {
            snp.setFalse();
            sbk.setFalse();
            for (i = nbArgs; i >= 0; --i) {
                snpArgs[i] = null;
                sbkArgs[i] = null;
            }
            tbrD.setCopy(tbr);
            tbrD.cumulMinus(killC);
            tbrD.cumulOr(tbrF);
            tbrC.setCopy(tbr);
            for (i = nbArgs - 1; i >= 0; --i) {
                tbrCArgs[i] = ADTBRAnalyzer.buildInfoBoolTreeOfDeclaredZones(argsZones[i], tbr, map, null, setKind, this.curSymbolTable);
            }
            sbkArgs[nbArgs] = ADTBRAnalyzer.buildInfoBoolTreeOfDeclaredZones(argsZones[nbArgs], tbrUC, map, null, setKind, this.curSymbolTable);
            snpArgs[nbArgs] = new TapList<Boolean>(Boolean.FALSE, null);
        } else {
            TapList<?> argInfo;
            if (useLazySnapshot) {
                if (calleeAcceptsTBR) {
                    int i2;
                    tbrC.setCopy(tbr);
                    for (i2 = nbArgs - 1; i2 >= 0; --i2) {
                        tbrCArgs[i2] = ADTBRAnalyzer.buildInfoBoolTreeOfDeclaredZones(argsZones[i2], tbr, map, null, setKind, this.curSymbolTable);
                    }
                    sbk.setFalse();
                    for (i2 = nbArgs; i2 >= 0; --i2) {
                        sbkArgs[i2] = ADTBRAnalyzer.buildInfoBoolTreeOfDeclaredZones(argsZones[i2], null, null, null, setKind, this.curSymbolTable);
                    }
                    snp.setCopy(useCb);
                    snp.cumulOr(tbr);
                    snp.cumulAnd(outC);
                    for (i2 = nbArgs - 1; i2 >= 0; --i2) {
                        if (argsNonConstant[i2]) {
                            argInfo = TapList.copyTree(useCbArgs[i2]);
                            argInfo = TapList.cumulWithOper(argInfo, tbrCArgs[i2], 91);
                            snpArgs[i2] = TapList.cumulWithOper(argInfo, outCArgs[i2], 92);
                            continue;
                        }
                        snpArgs[i2] = null;
                    }
                    tbrD.setCopy(tbr);
                    tbrD.cumulOr(useCb);
                    tbrD.cumulMinus(outC);
                    for (i2 = nbArgs - 1; i2 >= 0; --i2) {
                        if (!argsNonConstant[i2]) continue;
                        argInfo = TapList.copyTree(tbrCArgs[i2]);
                        argInfo = TapList.cumulWithOper(argInfo, useCbArgs[i2], 91);
                        argInfo = TapList.cumulWithOper(argInfo, outCArgs[i2], 93);
                        this.setInfoBoolTreeToExtendedDeclaredZones(tbrD, map, argsZones[i2], true, argInfo, true, setKind);
                        if (!TapEnv.doTBR() || !argsTotal[i2]) continue;
                        this.setInfoBoolTreeToExtendedDeclaredZones(tbrD, map, argsZones[i2], false, snpArgs[i2], true, setKind);
                    }
                } else {
                    int i3;
                    sbk.setCopy(tbr);
                    sbk.cumulAnd(outCb);
                    for (i3 = nbArgs - 1; i3 >= 0; --i3) {
                        if (argsNonConstant[i3]) {
                            argInfo = TapList.copyTree(tbrUCArgs[i3]);
                            sbkArgs[i3] = TapList.cumulWithOper(argInfo, outCbArgs[i3], 92);
                            continue;
                        }
                        sbkArgs[i3] = null;
                    }
                    snp.setCopy(tbr);
                    snp.cumulMinus(outCb);
                    snp.cumulOr(useCb);
                    snp.cumulAnd(outC);
                    for (i3 = nbArgs - 1; i3 >= 0; --i3) {
                        if (argsNonConstant[i3]) {
                            argInfo = TapList.copyTree(tbrArgs[i3]);
                            argInfo = TapList.cumulWithOper(argInfo, outCbArgs[i3], 93);
                            argInfo = TapList.cumulWithOper(argInfo, sbkArgs[i3], 93);
                            argInfo = TapList.cumulWithOper(argInfo, useCbArgs[i3], 91);
                            snpArgs[i3] = TapList.cumulWithOper(argInfo, outCArgs[i3], 92);
                            continue;
                        }
                        snpArgs[i3] = null;
                    }
                    tbrC.setFalse();
                    for (i3 = nbArgs - 1; i3 >= 0; --i3) {
                        tbrCArgs[i3] = ADTBRAnalyzer.buildInfoBoolTreeOfDeclaredZones(argsZones[i3], null, null, null, setKind, this.curSymbolTable);
                    }
                    tbrD.setCopy(tbr);
                    tbrD.cumulOr(useCb);
                    tbrD.cumulMinus(outC);
                    for (i3 = nbArgs - 1; i3 >= 0; --i3) {
                        if (!argsNonConstant[i3]) continue;
                        argInfo = TapList.copyTree(tbrArgs[i3]);
                        argInfo = TapList.cumulWithOper(argInfo, useCbArgs[i3], 91);
                        argInfo = TapList.cumulWithOper(argInfo, outCArgs[i3], 93);
                        this.setInfoBoolTreeToExtendedDeclaredZones(tbrD, map, argsZones[i3], true, argInfo, true, setKind);
                        if (!TapEnv.doTBR() || !argsTotal[i3]) continue;
                        argInfo = TapList.copyTree(snpArgs[i3]);
                        this.setInfoBoolTreeToExtendedDeclaredZones(tbrD, map, argsZones[i3], false, argInfo, true, setKind);
                    }
                }
            } else {
                int i4;
                sbk.setCopy(tbr);
                sbk.cumulAnd(outCb);
                for (int i5 = nbArgs - 1; i5 >= 0; --i5) {
                    if (argsNonConstant[i5]) {
                        argInfo = TapList.copyTree(tbrArgs[i5]);
                        sbkArgs[i5] = TapList.cumulWithOper(argInfo, outCbArgs[i5], 92);
                        continue;
                    }
                    sbkArgs[i5] = null;
                }
                BoolVector tmp2 = outDb.copy();
                tmp2.cumulAnd(useCb);
                tmp2.cumulMinus(tbr);
                tmp2.cumulMinus(outC);
                snp.setCopy(tbr);
                snp.cumulMinus(outCb);
                snp.cumulOr(useCb);
                snp.cumulAnd(outC);
                snp.cumulOr(tmp2);
                for (i4 = nbArgs - 1; i4 >= 0; --i4) {
                    if (argsNonConstant[i4]) {
                        argInfo = TapList.copyTree(tbrArgs[i4]);
                        argInfo = TapList.cumulWithOper(argInfo, outCbArgs[i4], 93);
                        argInfo = TapList.cumulWithOper(argInfo, sbkArgs[i4], 93);
                        argInfo = TapList.cumulWithOper(argInfo, outCArgs[i4], 92);
                        TapList<?> argInfo2 = ADTBRAnalyzer.buildInfoBoolTreeOfDeclaredZones(argsZones[i4], outDb, map, null, setKind, this.curSymbolTable);
                        argInfo2 = TapList.cumulWithOper(argInfo2, useCbArgs[i4], 92);
                        argInfo2 = TapList.cumulWithOper(argInfo2, tbrArgs[i4], 93);
                        argInfo2 = TapList.cumulWithOper(argInfo2, sbkArgs[i4], 93);
                        argInfo2 = TapList.cumulWithOper(argInfo2, outCArgs[i4], 93);
                        snpArgs[i4] = TapList.cumulWithOper(argInfo, argInfo2, 91);
                        continue;
                    }
                    snpArgs[i4] = null;
                }
                tbrC.setFalse();
                for (i4 = nbArgs - 1; i4 >= 0; --i4) {
                    tbrCArgs[i4] = ADTBRAnalyzer.buildInfoBoolTreeOfDeclaredZones(argsZones[i4], null, null, null, setKind, this.curSymbolTable);
                }
                tbrD.setCopy(tbr);
                tbrD.cumulAnd(outDb);
                tbrD.cumulMinus(outC);
                for (i4 = nbArgs - 1; i4 >= 0; --i4) {
                    if (!argsNonConstant[i4]) continue;
                    argInfo = ADTBRAnalyzer.buildInfoBoolTreeOfDeclaredZones(argsZones[i4], outDb, map, null, setKind, this.curSymbolTable);
                    argInfo = TapList.cumulWithOper(argInfo, tbrArgs[i4], 92);
                    argInfo = TapList.cumulWithOper(argInfo, outCArgs[i4], 93);
                    this.setInfoBoolTreeToExtendedDeclaredZones(tbrD, map, argsZones[i4], true, argInfo, true, setKind);
                    if (!argsTotal[i4]) continue;
                    argInfo = TapList.copyTree(snpArgs[i4]);
                    argInfo = TapList.cumulWithOper(argInfo, sbkArgs[i4], 91);
                    this.setInfoBoolTreeToExtendedDeclaredZones(tbrD, map, argsZones[i4], false, argInfo, true, setKind);
                }
            }
            if (adjRequiresCall && argsNonConstant[nbArgs]) {
                snpArgs[nbArgs] = ADTBRAnalyzer.buildInfoBoolTreeOfDeclaredZones(argsZones[nbArgs], tbr, map, null, setKind, this.curSymbolTable);
                if (TapEnv.doTBR() && argsTotal[nbArgs]) {
                    this.setInfoBoolTreeToExtendedDeclaredZones(tbrD, map, argsZones[nbArgs], false, snpArgs[nbArgs], true, setKind);
                }
            } else {
                snpArgs[nbArgs] = new TapList<Boolean>(Boolean.FALSE, null);
            }
        }
        for (i = nbArgs; i >= 0; --i) {
            this.setInfoBoolTreeToExtendedDeclaredZones(poppedZones, map, argsZones[i], snpArgs[i], null, false, setKind);
            this.setInfoBoolTreeToExtendedDeclaredZones(poppedZones, map, argsZones[i], sbkArgs[i], null, false, setKind);
        }
        poppedZones.cumulOr(snp);
        poppedZones.cumulOr(sbk);
        for (i = nbArgs; i >= 0; --i) {
            TapList snpArgi = snpArgs[i];
            if (i == nbArgs && snpArgi != null && snpArgi.tail == null && snpArgi.head == Boolean.FALSE) {
                snpArgi = null;
            }
            this.setTBRinPathToRestored(argsZones[i], snpArgi, sbkArgs[i], tbrD, map, setKind, new TapList<Object>(null, null));
        }
    }

    private boolean setTBRinPathToRestored(TapList<?> zones, TapList<?> path1, TapList<?> path2, BoolVector tbr, int[] map, int kind, TapList<TapList<?>> dejaVu) {
        boolean containsTrue = false;
        if (zones != null && !TapList.contains(dejaVu, zones)) {
            if (zones.head == null || zones.head instanceof TapIntList) {
                dejaVu.placdl(zones);
                containsTrue = this.setTBRinPathToRestored(zones.tail, path1 == null ? null : path1.tail, path2 == null ? null : path2.tail, tbr, map, kind, dejaVu);
                if (containsTrue) {
                    this.setExtendedDeclared(tbr, map, kind, (TapIntList)zones.head, true);
                }
                containsTrue = containsTrue || TapList.oneTrueInHead(path1) || TapList.oneTrueInHead(path2);
            } else {
                while (zones != null && !TapList.contains(dejaVu, zones)) {
                    dejaVu.placdl(zones);
                    if (zones.head != null) {
                        boolean trueBelow = this.setTBRinPathToRestored((TapList)zones.head, path1 == null ? null : (TapList)path1.head, path2 == null ? null : (TapList)path2.head, tbr, map, kind, dejaVu);
                        containsTrue = containsTrue || trueBelow;
                    }
                    zones = zones.tail;
                    path1 = path1 == null ? null : path1.tail;
                    path2 = path2 == null ? null : path2.tail;
                }
            }
        }
        return containsTrue;
    }

    private TapList findRequiredZonesAndTBR(Tree expression, boolean onPrimal, boolean onDiff, BoolVector tbr, BoolVector tbrOnDiffPtr, ToBool total, SymbolTable symbolTable) {
        switch (expression.opCode()) {
            case 31: {
                Tree[] realArgs;
                for (Tree realArg : realArgs = ILUtils.getArguments(expression).children()) {
                    TapList valueZones = this.findRequiredZonesAndTBR(realArg, onPrimal, false, tbr, tbrOnDiffPtr, null, symbolTable);
                    this.setExtendedDeclared(tbr, this.vectorMap, 0, ZoneInfo.listAllZones(valueZones, true), true);
                }
                return null;
            }
            case 99: {
                TapList valueZones = this.findRequiredZonesAndTBR(expression.down(1), onPrimal, false, tbr, tbrOnDiffPtr, null, symbolTable);
                this.setExtendedDeclared(tbr, this.vectorMap, 0, ZoneInfo.listAllZones(valueZones, true), true);
                TapList valueZonesTrue = this.findRequiredZonesAndTBR(expression.down(2), onPrimal, false, tbr, tbrOnDiffPtr, total, symbolTable);
                valueZones = this.findRequiredZonesAndTBR(expression.down(3), onPrimal, false, tbr, tbrOnDiffPtr, total, symbolTable);
                if (total != null) {
                    total.set(false);
                }
                return TapList.cumulWithOper(TapList.copyTree(valueZones), valueZonesTrue, 91);
            }
            case 9: {
                TapList valueZones;
                Tree[] indexes = expression.down(2).children();
                for (int i = indexes.length - 1; i >= 0; --i) {
                    valueZones = this.findRequiredZonesAndTBR(indexes[i], true, false, tbr, tbrOnDiffPtr, null, symbolTable);
                    this.setExtendedDeclared(tbr, this.vectorMap, 0, ZoneInfo.listAllZones(valueZones, true), true);
                }
                valueZones = this.findRequiredZonesAndTBR(expression.down(1), onPrimal, onDiff, tbr, tbrOnDiffPtr, total, symbolTable);
                if (total != null) {
                    total.set(false);
                }
                return valueZones;
            }
            case 10: 
            case 12: 
            case 181: {
                Tree[] sons = expression.children();
                for (int i = sons.length - 1; i >= 0; --i) {
                    TapList valueZones = this.findRequiredZonesAndTBR(sons[i], true, false, tbr, tbrOnDiffPtr, null, symbolTable);
                    this.setExtendedDeclared(tbr, this.vectorMap, 0, ZoneInfo.listAllZones(valueZones, true), true);
                }
                return null;
            }
            case 75: {
                TapList valueZones = this.findRequiredZonesAndTBR(expression.down(1), onPrimal, onDiff, tbr, tbrOnDiffPtr, total, symbolTable);
                Object result = TapList.nth(valueZones, ILUtils.getFieldRank(expression.down(2)));
                if (result instanceof TapIntList) {
                    return new TapList<Object>(result, null);
                }
                return (TapList)result;
            }
            case 151: {
                TapList valueZones = this.findRequiredZonesAndTBR(expression.down(1), onPrimal, onDiff, tbr, tbrOnDiffPtr, total, symbolTable);
                if (onPrimal) {
                    this.setExtendedDeclared(tbr, this.vectorMap, 0, ZoneInfo.listAllZones(valueZones, true), true);
                }
                if (onDiff) {
                    this.setExtendedDeclared(tbrOnDiffPtr, this.pointerVectorMap, 3, ZoneInfo.listAllZones(valueZones, true), true);
                }
                valueZones = this.findRequiredZonesAndTBR(expression.down(2), true, false, tbr, tbrOnDiffPtr, total, symbolTable);
                this.setExtendedDeclared(tbr, this.vectorMap, 0, ZoneInfo.listAllZones(valueZones, true), true);
                return symbolTable.treeOfZonesOfValue(expression, total, this.curInstruction, null);
            }
            case 96: {
                VariableDecl variableDecl = symbolTable.getVariableDecl(ILUtils.getIdentString(expression));
                if (variableDecl == null) {
                    return null;
                }
                if (total != null) {
                    total.set(true);
                }
                return variableDecl.zones();
            }
            case 4: {
                TapList valueZones = this.findRequiredZonesAndTBR(expression.down(1), onPrimal, onDiff, tbr, tbrOnDiffPtr, total, symbolTable);
                return new TapList<Object>(null, valueZones);
            }
            case 3: 
            case 6: 
            case 18: 
            case 22: 
            case 24: 
            case 42: 
            case 43: 
            case 62: 
            case 68: 
            case 92: 
            case 95: 
            case 115: 
            case 116: 
            case 122: 
            case 126: 
            case 133: 
            case 137: 
            case 143: 
            case 155: 
            case 169: 
            case 182: 
            case 207: {
                TapList valueZones = this.findRequiredZonesAndTBR(expression.down(1), true, false, tbr, tbrOnDiffPtr, null, symbolTable);
                this.setExtendedDeclared(tbr, this.vectorMap, 0, ZoneInfo.listAllZones(valueZones, true), true);
                valueZones = this.findRequiredZonesAndTBR(expression.down(2), true, false, tbr, tbrOnDiffPtr, null, symbolTable);
                this.setExtendedDeclared(tbr, this.vectorMap, 0, ZoneInfo.listAllZones(valueZones, true), true);
                return null;
            }
            case 124: 
            case 139: 
            case 176: 
            case 189: 
            case 196: 
            case 206: {
                TapList valueZones = this.findRequiredZonesAndTBR(expression.down(1), true, false, tbr, tbrOnDiffPtr, null, symbolTable);
                this.setExtendedDeclared(tbr, this.vectorMap, 0, ZoneInfo.listAllZones(valueZones, true), true);
                return null;
            }
            case 32: 
            case 134: 
            case 194: {
                TapList valueZones = this.findRequiredZonesAndTBR(expression.down(2), true, false, tbr, tbrOnDiffPtr, null, symbolTable);
                this.setExtendedDeclared(tbr, this.vectorMap, 0, ZoneInfo.listAllZones(valueZones, true), true);
                return null;
            }
            case 98: {
                TapList valueZones = this.findRequiredZonesAndTBR(expression.down(1), true, false, tbr, tbrOnDiffPtr, null, symbolTable);
                this.setExtendedDeclared(tbr, this.vectorMap, 0, ZoneInfo.listAllZones(valueZones, true), true);
                valueZones = this.findRequiredZonesAndTBR(expression.down(2), true, false, tbr, tbrOnDiffPtr, total, symbolTable);
                this.setExtendedDeclared(tbr, this.vectorMap, 0, ZoneInfo.listAllZones(valueZones, true), true);
                valueZones = this.findRequiredZonesAndTBR(expression.down(3), true, false, tbr, tbrOnDiffPtr, total, symbolTable);
                this.setExtendedDeclared(tbr, this.vectorMap, 0, ZoneInfo.listAllZones(valueZones, true), true);
                return null;
            }
            case 36: 
            case 46: 
            case 56: 
            case 89: {
                return null;
            }
            case 20: 
            case 28: 
            case 78: 
            case 103: 
            case 104: 
            case 111: 
            case 118: 
            case 138: 
            case 160: 
            case 180: {
                return null;
            }
        }
        TapEnv.toolWarning(-1, "(Find zones required by expression) Unexpected operator: " + expression.opName());
        return null;
    }

    private void setTBRindexOnLoopEntry(Tree indexTree) {
        Object tbrAnnot = ActivityPattern.getAnnotationForActivityPattern(indexTree, this.curActivity, "TBR");
        if (tbrAnnot == null) {
            TapIntList annotValue = new TapIntList(1, new TapIntList(0, null));
            ActivityPattern.setAnnotationForActivityPattern(indexTree, this.curActivity, "TBR", annotValue);
        } else {
            TapIntList annotValue = (TapIntList)tbrAnnot;
            annotValue.head = 1;
        }
    }

    private void setTBRindexOnLoopCycle(Tree indexTree) {
        Object tbrAnnot = ActivityPattern.getAnnotationForActivityPattern(indexTree, this.curActivity, "TBR");
        if (tbrAnnot == null) {
            TapIntList annotValue = new TapIntList(0, new TapIntList(1, null));
            ActivityPattern.setAnnotationForActivityPattern(indexTree, this.curActivity, "TBR", annotValue);
        } else {
            TapIntList annotValue = (TapIntList)tbrAnnot;
            annotValue.tail.head = 1;
        }
    }

    private boolean requiredZones(TapIntList zones, BoolVector tbr) {
        if (tbr == null || zones == null || zones.head >= this.nDZ) {
            return false;
        }
        return ADTBRAnalyzer.intersectsExtendedDeclared(tbr, this.vectorMap, 0, zones, null, this.curSymbolTable, null);
    }

    private boolean requiredZonesOnDiffPtr(TapIntList zones, BoolVector tbrOnDiffPtr) {
        if (tbrOnDiffPtr == null || zones == null || zones.head >= this.nDZ) {
            return false;
        }
        return ADTBRAnalyzer.intersectsExtendedDeclared(tbrOnDiffPtr, this.pointerVectorMap, 3, zones, null, this.curSymbolTable, null);
    }

    private RecompInfo[] recompCumulOr(RecompInfo[] recompCumul, RecompInfo[] additionalRecomp) {
        if (additionalRecomp == null) {
            return recompCumul;
        }
        if (recompCumul == null) {
            return this.recompCopy(additionalRecomp);
        }
        return this.recompCumulOr(recompCumul, additionalRecomp, recompCumul.length);
    }

    private RecompInfo[] recompCumulOr(RecompInfo[] recompCumul, RecompInfo[] additionalRecomp, int commonLength) {
        if (additionalRecomp == null) {
            return recompCumul;
        }
        if (recompCumul == null) {
            recompCumul = new RecompInfo[this.nDZ];
            for (int i = this.nDZ - 1; i >= commonLength; --i) {
                recompCumul[i] = null;
            }
            if (commonLength >= 0) {
                System.arraycopy(additionalRecomp, 0, recompCumul, 0, commonLength);
            }
        } else {
            for (int i = commonLength - 1; i >= 0; --i) {
                if (recompCumul[i] == null) {
                    this.setInstructionRemainsInFwdSweep(additionalRecomp, i, 1);
                    this.setInstructionRemainsInFwdSweep(additionalRecomp, i, 2);
                    continue;
                }
                if (recompCumul[i].instruction == null) {
                    recompCumul[i] = additionalRecomp[i];
                    continue;
                }
                if (additionalRecomp[i] != null && additionalRecomp[i].instruction == null) continue;
                RecompInfo newRecompCumul = recompCumul[i].or(additionalRecomp[i]);
                if (newRecompCumul == null) {
                    this.setInstructionRemainsInFwdSweep(additionalRecomp, i, 1);
                    this.setInstructionRemainsInFwdSweep(additionalRecomp, i, 2);
                    this.setInstructionRemainsInFwdSweep(recompCumul, i, 1);
                    this.setInstructionRemainsInFwdSweep(recompCumul, i, 2);
                }
                recompCumul[i] = newRecompCumul;
            }
        }
        return recompCumul;
    }

    private RecompInfo[] recompCopy(RecompInfo[] recompInfos) {
        if (recompInfos == null) {
            return null;
        }
        RecompInfo[] copy = new RecompInfo[recompInfos.length];
        System.arraycopy(recompInfos, 0, copy, 0, copy.length - 1 + 1);
        return copy;
    }

    private boolean equalRecompInfos(RecompInfo[] recompInfosNew, RecompInfo[] recompInfosRef) {
        if (recompInfosRef.length != recompInfosNew.length) {
            return false;
        }
        boolean equ = true;
        for (int i = recompInfosRef.length - 1; equ && i >= 0; --i) {
            equ = recompInfosRef[i] == null ? recompInfosNew[i] == null : (recompInfosNew[i] == null ? false : (recompInfosRef[i].instruction == null ? recompInfosNew[i].instruction == null : recompInfosRef[i].instruction == recompInfosNew[i].instruction));
        }
        return equ;
    }

    private void setZonesNonRecomputable(RecompInfo[] recompInfos, BoolVector zonesOverwritten, TapIntList cleanLoopIndexDeclaredZones, BoolVector modifiedTillEndCkpZones, BoolVector tbr, int zonesNb) {
        int i;
        TapList<Instruction> recompInstructions = null;
        for (i = recompInfos.length - 1; i >= 0; --i) {
            if (recompInfos[i] == null || !zonesOverwritten.get(i)) continue;
            recompInstructions = new TapList<Instruction>(recompInfos[i].instruction, recompInstructions);
        }
        for (i = recompInfos.length - 1; i >= 0; --i) {
            if (recompInfos[i] == null || !TapList.contains(recompInstructions, recompInfos[i].instruction)) continue;
            this.setInstructionRemainsInFwdSweep(recompInfos, i, 1);
            this.setInstructionRemainsInFwdSweep(recompInfos, i, 2);
            recompInfos[i] = null;
        }
        this.fixpointDependents(recompInfos, zonesOverwritten, cleanLoopIndexDeclaredZones, modifiedTillEndCkpZones, tbr, zonesNb);
    }

    private RecompInfo[] removeRecompOutOfScope(RecompInfo[] recompInfos, int origNZ, int interNZ, int destNZ, TapIntList cleanLoopIndexDeclaredZones, BoolVector modifiedTillEndCkpZones, BoolVector tbr) {
        int i;
        RecompInfo[] result = new RecompInfo[destNZ];
        for (i = interNZ; i < origNZ; ++i) {
            this.setInstructionRemainsInFwdSweep(recompInfos, i, 1);
            this.setInstructionRemainsInFwdSweep(recompInfos, i, 2);
        }
        for (i = interNZ; i < destNZ; ++i) {
            result[i] = null;
        }
        for (i = interNZ - 1; i >= 0; --i) {
            if (recompInfos[i] == null) {
                result[i] = null;
                continue;
            }
            BoolVector oldNeeded = recompInfos[i].neededAvailableZones;
            boolean neededOutOfScope = false;
            for (int j = interNZ; j < origNZ; ++j) {
                if (!oldNeeded.get(j)) continue;
                neededOutOfScope = true;
            }
            if (neededOutOfScope) {
                this.setInstructionRemainsInFwdSweep(recompInfos, i, 1);
                this.setInstructionRemainsInFwdSweep(recompInfos, i, 2);
                result[i] = null;
                continue;
            }
            BoolVector newNeeded = new BoolVector(destNZ);
            newNeeded.cumulOr(oldNeeded, interNZ);
            result[i] = new RecompInfo(recompInfos[i].instruction, newNeeded);
        }
        this.fixpointDependents(result, null, cleanLoopIndexDeclaredZones, modifiedTillEndCkpZones, tbr, interNZ);
        return result;
    }

    private void fixpointDependents(RecompInfo[] recompInfos, BoolVector zonesNotUsableInRecompute, TapIntList cleanLoopIndexDeclaredZones, BoolVector modifiedTillEndCkpZones, BoolVector tbr, int zonesNb) {
        boolean fixpoint = false;
        while (!fixpoint) {
            fixpoint = true;
            for (int i = recompInfos.length - 1; i >= 0; --i) {
                if (recompInfos[i] == null || recompInfos[i].isValidNow(recompInfos, cleanLoopIndexDeclaredZones, modifiedTillEndCkpZones, tbr, zonesNb) && (zonesNotUsableInRecompute == null || !zonesNotUsableInRecompute.intersects(recompInfos[i].neededAvailableZones, recompInfos.length))) continue;
                this.setInstructionRemainsInFwdSweep(recompInfos, i, 1);
                this.setInstructionRemainsInFwdSweep(recompInfos, i, 2);
                recompInfos[i] = null;
                fixpoint = false;
            }
        }
    }

    private void setInstructionRemainsInFwdSweepOnZones(RecompInfo[] recompInfos, BoolVector zones, int infoRk) {
        for (int i = recompInfos.length - 1; i >= 0; --i) {
            if (!zones.get(i)) continue;
            this.setInstructionRemainsInFwdSweep(recompInfos, i, infoRk);
        }
    }

    private void setInstructionRemainsInFwdSweep(RecompInfo[] recompInfos, int zoneRecompIndex, int infoRk) {
        if (recompInfos[zoneRecompIndex] != null && recompInfos[zoneRecompIndex].instruction != null) {
            ActivityPattern.setInstructionBoolInfo(this.curUnitButRemainsInFwdSweeps, recompInfos[zoneRecompIndex].instruction, infoRk, true);
            if (TapEnv.traceCurAnalysis()) {
                TapEnv.printlnOnTrace("      => REMAINS in fwd sweep (" + zoneRecompIndex + ") for " + (infoRk == 1 ? "primal" : "diffPtr") + ": " + recompInfos[zoneRecompIndex].instruction);
            }
            this.setInstructionRemainsInFwdSweepOnZones(recompInfos, recompInfos[zoneRecompIndex].neededAvailableZones, 1);
            if (infoRk == 2) {
                this.setInstructionRemainsInFwdSweepOnZones(recompInfos, recompInfos[zoneRecompIndex].neededAvailableZones, 2);
            }
        }
    }

    private void setExtendedDeclared(RecompInfo[] recompInfos, int[] vectorMap, TapIntList extendedDeclaredZones, RecompInfo value) {
        while (extendedDeclaredZones != null) {
            this.setExtendedDeclared(recompInfos, vectorMap, extendedDeclaredZones.head, value);
            extendedDeclaredZones = extendedDeclaredZones.tail;
        }
    }

    private void setExtendedDeclared(RecompInfo[] recompInfos, int[] vectorMap, int extendedDeclaredZone, RecompInfo value) {
        int index = this.extendedDeclaredToVectorIndex(extendedDeclaredZone, 0, vectorMap);
        if (index >= 0) {
            recompInfos[index] = value;
        }
    }

    private RecompInfo[] initialRecompInfoArray() {
        RecompInfo[] recompInfos = new RecompInfo[this.nDZ];
        for (int i = this.nDZ - 1; i >= 0; --i) {
            recompInfos[i] = null;
        }
        return recompInfos;
    }

    private boolean otherNeeds(RecompInfo[] recompInfos, int neededRank) {
        for (int i = recompInfos.length - 1; i >= 0; --i) {
            if (recompInfos[i] == null || recompInfos[i].neededAvailableZones == null || !recompInfos[i].neededAvailableZones.get(neededRank)) continue;
            return true;
        }
        return false;
    }

    private void markDestinationsRebased(TapIntList poppedZones, boolean poppedPtr, boolean poppedDiffPtr) {
        int[] ptrColMap = ADTBRAnalyzer.makeMap3(0, 0, this.curSymbolTable.declaredZonesNb(0));
        BoolVector destinationZones = new BoolVector(ADTBRAnalyzer.mapSize(ptrColMap));
        BoolVector destinationDiffZones = new BoolVector(ADTBRAnalyzer.mapSize(ptrColMap));
        while (poppedZones != null) {
            ZoneInfo zone;
            if (poppedZones.head >= 0 && (zone = this.curSymbolTable.declaredZoneInfo(poppedZones.head, 0)) != null && zone.ptrZoneNb != -1 && (poppedPtr || poppedDiffPtr)) {
                this.cumulPointerDestinations(zone, poppedPtr, poppedDiffPtr, destinationZones, destinationDiffZones, this.curBlock, this.curInstruction, true);
            }
            poppedZones = poppedZones.tail;
        }
        this.markAllocatableZonesRebased(destinationZones, destinationDiffZones, this.curSymbolTable);
    }

    private void markDestinationsRebased(BoolVector popped, BoolVector poppedOnDiffPtr) {
        int[] ptrColMap = ADTBRAnalyzer.makeMap3(0, 0, this.curSymbolTable.declaredZonesNb(0));
        BoolVector destinationZones = new BoolVector(ADTBRAnalyzer.mapSize(ptrColMap));
        BoolVector destinationDiffZones = new BoolVector(ADTBRAnalyzer.mapSize(ptrColMap));
        for (int i = this.curSymbolTable.declaredZonesNb(0) - 1; i >= 0; --i) {
            boolean poppedDiffPtr;
            ZoneInfo zone = this.curSymbolTable.declaredZoneInfo(i, 0);
            if (zone == null || zone.ptrZoneNb == -1) continue;
            int rk = this.zoneInfoToVectorIndex(zone, 3, 0, this.vectorMap);
            boolean poppedPtr = rk > 0 && popped.get(rk);
            rk = this.zoneInfoToVectorIndex(zone, 3, 3, this.pointerVectorMap);
            boolean bl = poppedDiffPtr = rk > 0 && poppedOnDiffPtr.get(rk);
            if (!poppedPtr && !poppedDiffPtr) continue;
            this.cumulPointerDestinations(zone, poppedPtr, poppedDiffPtr, destinationZones, destinationDiffZones, this.curBlock, this.curInstruction, true);
        }
        this.markAllocatableZonesRebased(destinationZones, destinationDiffZones, this.curSymbolTable);
    }

    private void markDestinationsRebased(BoolVector tbr, BoolVector tbrOnDiffPtr, Block origin, SymbolTable commonSymbolTable) {
        int[] ptrColMap = ADTBRAnalyzer.makeMap3(0, 0, origin.symbolTable.declaredZonesNb(0));
        BoolVector destinationZones = new BoolVector(ADTBRAnalyzer.mapSize(ptrColMap));
        BoolVector destinationDiffZones = new BoolVector(ADTBRAnalyzer.mapSize(ptrColMap));
        for (int i = commonSymbolTable.declaredZonesNb(0); i < origin.symbolTable.declaredZonesNb(0); ++i) {
            boolean poppedDiffPtr;
            ZoneInfo zone = origin.symbolTable.declaredZoneInfo(i, 0);
            if (zone == null || zone.ptrZoneNb == -1) continue;
            int rk = this.zoneInfoToVectorIndex(zone, 3, 0, this.vectorMap);
            boolean poppedPtr = rk > 0 && tbr.get(rk);
            rk = this.zoneInfoToVectorIndex(zone, 3, 3, this.pointerVectorMap);
            boolean bl = poppedDiffPtr = rk > 0 && tbrOnDiffPtr.get(rk);
            if (!poppedPtr && !poppedDiffPtr) continue;
            this.cumulPointerDestinations(zone, poppedPtr, poppedDiffPtr, destinationZones, destinationDiffZones, origin, origin.lastInstr(), false);
        }
        this.markAllocatableZonesRebased(destinationZones, destinationDiffZones, origin.symbolTable);
    }

    private void cumulPointerDestinations(ZoneInfo zone, boolean poppedPtr, boolean poppedDiffPtr, BoolVector destinationZones, BoolVector destinationDiffZones, Block atBlock, Instruction atInstruction, boolean upstream) {
        BoolVector zoneDestinations;
        int rowRk = zone.ptrZoneNb;
        if (rowRk >= 0 && (zoneDestinations = this.curSymbolTable.getPointerDestinationVector(rowRk, atInstruction, atBlock, null, upstream)) != null) {
            if (poppedPtr) {
                destinationZones.cumulOr(zoneDestinations);
            }
            if (poppedDiffPtr) {
                destinationDiffZones.cumulOr(zoneDestinations);
            }
        }
    }

    private void markAllocatableZonesRebased(BoolVector destinationZones, BoolVector destinationDiffZones, SymbolTable symbolTable) {
        ZoneInfo zone;
        int i;
        boolean oneDestinationIsRelocated = false;
        for (i = symbolTable.declaredZonesNb(0) - 1; i >= 0; --i) {
            zone = symbolTable.declaredZoneInfo(i, 0);
            if (zone == null || (!zone.relocated || !destinationZones.get(i)) && (!zone.relocatedDiff || !destinationDiffZones.get(i))) continue;
            oneDestinationIsRelocated = true;
        }
        if (oneDestinationIsRelocated) {
            for (i = symbolTable.declaredZonesNb(0) - 1; i >= 0; --i) {
                zone = symbolTable.declaredZoneInfo(i, 0);
                if (zone == null) continue;
                if (destinationZones.get(i)) {
                    zone.rebased = true;
                }
                if (destinationDiffZones.get(i)) {
                    zone.rebasedDiff = true;
                }
                if (!destinationZones.get(i) && !destinationDiffZones.get(i) || this.curUnit.publicSymbolTable().firstDeclaredZone(0) > i || i >= this.curUnit.publicSymbolTable().freeDeclaredZone(0)) continue;
                TapEnv.toolError("  Problem on " + ILUtils.toString(this.curInstruction.tree) + " in " + this.curUnit.name() + ": rebased info on formal argument " + ILUtils.toString(zone.accessTree) + " must be attached to its actual memory zone. Requires -nooptim refineADMM");
            }
        }
    }

    private int approxRecomputeCost(Tree tree) {
        switch (tree.opCode()) {
            case 14: {
                return 1 + this.approxRecomputeCost(tree.down(1)) + this.approxRecomputeCost(tree.down(2));
            }
            case 96: {
                return NewSymbolHolder.isANewSymbolRef(tree) ? 1000 : 1;
            }
            case 9: {
                return this.approxRecomputeCost(tree.down(1)) + this.approxRecomputeCost(tree.down(2));
            }
            case 75: {
                return this.approxRecomputeCost(tree.down(1));
            }
            case 4: {
                return this.approxRecomputeCost(tree.down(1));
            }
            case 151: {
                return 1 + this.approxRecomputeCost(tree.down(1)) + this.approxRecomputeCost(tree.down(2));
            }
            case 42: 
            case 155: {
                return 2 + this.approxRecomputeCost(tree.down(1)) + this.approxRecomputeCost(tree.down(2));
            }
            case 3: 
            case 6: 
            case 18: 
            case 22: 
            case 24: 
            case 43: 
            case 62: 
            case 68: 
            case 92: 
            case 95: 
            case 115: 
            case 116: 
            case 122: 
            case 126: 
            case 133: 
            case 137: 
            case 143: 
            case 169: 
            case 182: 
            case 207: {
                return 1 + this.approxRecomputeCost(tree.down(1)) + this.approxRecomputeCost(tree.down(2));
            }
            case 124: 
            case 139: 
            case 176: {
                return 1 + this.approxRecomputeCost(tree.down(1));
            }
            case 32: 
            case 194: {
                return 1 + this.approxRecomputeCost(tree.down(2));
            }
            case 10: 
            case 12: 
            case 71: {
                Tree[] expressions = tree.children();
                int cost = 0;
                for (int i = expressions.length - 1; i >= 0; --i) {
                    cost += this.approxRecomputeCost(expressions[i]);
                }
                return cost;
            }
            case 99: {
                return this.approxRecomputeCost(tree.down(1)) + this.approxRecomputeCost(tree.down(2)) + this.approxRecomputeCost(tree.down(3));
            }
            case 20: 
            case 28: 
            case 29: 
            case 35: 
            case 41: 
            case 78: 
            case 103: 
            case 104: 
            case 111: 
            case 118: 
            case 129: 
            case 138: 
            case 154: 
            case 160: 
            case 180: {
                return 0;
            }
            case 5: 
            case 31: 
            case 52: 
            case 98: 
            case 110: 
            case 134: 
            case 140: 
            case 189: 
            case 196: 
            case 206: {
                return 1000;
            }
        }
        TapEnv.toolWarning(-1, "(Evaluating cost of recomputable statement) Unexpected operator: " + tree.opName());
        return 1000;
    }

    private final class RecompInfo {
        private final Instruction instruction;
        private final BoolVector neededAvailableZones;
        boolean usedForPrimal = false;
        boolean usedForDiffPtr = false;

        private RecompInfo(Instruction instruction, BoolVector neededAvailableZones) {
            this.instruction = instruction;
            this.neededAvailableZones = neededAvailableZones;
        }

        private RecompInfo or(RecompInfo info2) {
            if (info2 == null || info2.instruction == null || info2.instruction != this.instruction) {
                return null;
            }
            BoolVector orNeededAvailableZones = null;
            if (this.neededAvailableZones == null) {
                if (info2.neededAvailableZones != null) {
                    orNeededAvailableZones = info2.neededAvailableZones.copy();
                }
            } else {
                orNeededAvailableZones = this.neededAvailableZones.copy();
                if (info2.neededAvailableZones != null) {
                    orNeededAvailableZones.cumulOr(info2.neededAvailableZones);
                }
            }
            return new RecompInfo(this.instruction, orNeededAvailableZones);
        }

        private boolean isValidNow(RecompInfo[] recompInfos, TapIntList cleanLoopIndexDeclaredZones, BoolVector modifiedTillEndCkpZones, BoolVector tbr, int zonesNb) {
            BoolVector availableNow = new BoolVector(ADTBRAnalyzer.this.nDZ);
            if (modifiedTillEndCkpZones != null) {
                availableNow.cumulOr(modifiedTillEndCkpZones.not(), zonesNb);
            }
            if (tbr != null) {
                availableNow.cumulOr(tbr, zonesNb);
            }
            ADTBRAnalyzer.this.setExtendedDeclared(availableNow, ADTBRAnalyzer.this.vectorMap, 0, cleanLoopIndexDeclaredZones, true);
            for (int rank = recompInfos.length - 1; rank >= 0; --rank) {
                if (recompInfos[rank] == null) continue;
                availableNow.set(rank, true);
            }
            return availableNow.contains(this.neededAvailableZones, ADTBRAnalyzer.this.nDZ);
        }

        public String toString() {
            return "RECOMP:" + this.instruction + (this.usedForPrimal ? ", not for primal" : "") + (this.usedForDiffPtr ? ", not for diffPtr" : "") + ", depsOn:" + this.neededAvailableZones;
        }
    }
}

