/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.tapenade.analysis;

import fr.inria.tapenade.analysis.ActivityPattern;
import fr.inria.tapenade.analysis.DataFlowAnalyzer;
import fr.inria.tapenade.analysis.ReqExplicit;
import fr.inria.tapenade.representation.Block;
import fr.inria.tapenade.representation.BlockStorage;
import fr.inria.tapenade.representation.CallArrow;
import fr.inria.tapenade.representation.CallGraph;
import fr.inria.tapenade.representation.CompositeTypeSpec;
import fr.inria.tapenade.representation.DiffPattern;
import fr.inria.tapenade.representation.DiffRoot;
import fr.inria.tapenade.representation.EntryBlock;
import fr.inria.tapenade.representation.ExitBlock;
import fr.inria.tapenade.representation.FGArrow;
import fr.inria.tapenade.representation.FunctionDecl;
import fr.inria.tapenade.representation.FunctionTypeSpec;
import fr.inria.tapenade.representation.HeaderBlock;
import fr.inria.tapenade.representation.ILUtils;
import fr.inria.tapenade.representation.Instruction;
import fr.inria.tapenade.representation.MPIcallInfo;
import fr.inria.tapenade.representation.PointerTypeSpec;
import fr.inria.tapenade.representation.PublicInfo;
import fr.inria.tapenade.representation.SymbolDecl;
import fr.inria.tapenade.representation.SymbolTable;
import fr.inria.tapenade.representation.TapEnv;
import fr.inria.tapenade.representation.TapList;
import fr.inria.tapenade.representation.TypeDecl;
import fr.inria.tapenade.representation.TypeSpec;
import fr.inria.tapenade.representation.Unit;
import fr.inria.tapenade.representation.UnitStorage;
import fr.inria.tapenade.representation.VariableDecl;
import fr.inria.tapenade.representation.WrapperTypeSpec;
import fr.inria.tapenade.representation.ZoneInfo;
import fr.inria.tapenade.utils.BoolMatrix;
import fr.inria.tapenade.utils.BoolVector;
import fr.inria.tapenade.utils.Operator;
import fr.inria.tapenade.utils.TapIntList;
import fr.inria.tapenade.utils.TapPair;
import fr.inria.tapenade.utils.TapTriplet;
import fr.inria.tapenade.utils.ToBool;
import fr.inria.tapenade.utils.Tree;

public final class ADActivityAnalyzer
extends DataFlowAnalyzer {
    private static final int BOTTOMUP_1 = 1;
    private static final int TOPDOWN_2 = 2;
    private static final int VARIED = 1;
    private static final int USEFUL = 2;
    private static final int STATICACTIVITY = 3;
    private static final int VARIED_ON_CALL = 0;
    private static final int USEFUL_ON_EXIT = 1;
    private static final int STATIC_ACTIVE = 2;
    private static final int USEFUL_ON_CALLING_SIDE = 3;
    private BlockStorage<BoolMatrix> depsIn;
    private BlockStorage<BoolMatrix> depsOut;
    private BlockStorage<BoolMatrix> depsThrough;
    private BoolMatrix tmpDep;
    private BoolVector curUnitZonesOfVarsHaveDiff;
    private BlockStorage<BoolVector> infosDown;
    private BlockStorage<BoolVector> infosCycleDown;
    private BlockStorage<BoolVector> infosUp;
    private BlockStorage<BoolVector> infosCycleUp;
    private BoolVector infoTmp;
    private BoolVector infoTmpCycle;
    private BoolVector additionalInfo;
    private BoolVector curStaticActivity;
    private final TapList<DiffRoot> diffRoots;
    private final int diffKind;
    private int nDRZ = -9;
    private int nUDRZ = -9;
    private final int[] curBlockMap = ADActivityAnalyzer.makeMap3(-9, 0, 0);
    private final int[] entryMap = ADActivityAnalyzer.makeMap3(-9, 0, 0);
    private final UnitStorage<BoolMatrix> dependencies;
    private int cgPhase;
    private int fgPhase;
    private BoolVector[] filteredContext = new BoolVector[2];
    private BlockStorage<TapList<BoolVector>> curUnitInfos;
    private TapList<TapPair<Unit, TapList<TapPair<Tree, TapTriplet<BoolVector[], Boolean[], Instruction>>>>> callContextsBuffer = null;
    private BoolVector entryFrontierVariedZones;
    private BoolVector exitFrontierUsefulZones;

    ADActivityAnalyzer(CallGraph cg, TapList<DiffRoot> diffRoots, int diffKind) {
        super(cg, "AD activity analysis", TapEnv.traceActivity());
        this.conservativeValue = true;
        this.diffRoots = diffRoots;
        this.diffKind = diffKind;
        this.dependencies = new UnitStorage(cg);
        TapList<Unit> allUnits = cg.sortedUnits();
        while (allUnits != null) {
            Unit unit = (Unit)allUnits.head;
            this.dependencies.store(unit, unit.unitADDependencies);
            allUnits = allUnits.tail;
        }
    }

    public static TapPair<TapList<BoolVector>, TapList<BoolVector>> saveFrontierActivity(TapList<FGArrow> entryArrows, TapList<FGArrow> exitArrows, ActivityPattern curActivity) {
        Block block;
        TapList<Object> hdResult;
        TapPair<Object, Object> result = new TapPair<Object, Object>(null, null);
        TapList<Object> tlResult = hdResult = new TapList<Object>(null, null);
        while (entryArrows != null) {
            block = ((FGArrow)entryArrows.head).origin;
            BoolVector entryActiv = TapList.last(curActivity.activities().retrieve(block));
            tlResult = tlResult.placdl(entryActiv);
            entryArrows = entryArrows.tail;
        }
        result.first = hdResult.tail;
        hdResult.tail = null;
        tlResult = hdResult;
        while (exitArrows != null) {
            block = ((FGArrow)exitArrows.head).destination;
            BoolVector exitUseful = (BoolVector)curActivity.usefulnesses().retrieve((Block)block).head;
            tlResult = tlResult.placdl(exitUseful);
            exitArrows = exitArrows.tail;
        }
        result.second = hdResult.tail;
        return result;
    }

    public static void runAnalysis(CallGraph callGraph, TapList<DiffRoot> diffRoots, int diffKind) {
        TapEnv.setADActivityAnalyzer(new ADActivityAnalyzer(callGraph, diffRoots, diffKind));
        if (TapEnv.doActivity()) {
            TapEnv.adActivityAnalyzer().run(DiffRoot.collectUnits(diffRoots));
        } else {
            TapEnv.adActivityAnalyzer().runNoActivity(DiffRoot.collectUnits(diffRoots));
        }
    }

    protected static boolean hasOneAnnotatedActive(ActivityPattern curActivity, Tree ioArg, SymbolTable symbolTable) {
        boolean result;
        if (ILUtils.isAVarRef(ioArg, symbolTable)) {
            result = ADActivityAnalyzer.isAnnotatedActive(curActivity, ioArg, symbolTable);
        } else if (ioArg.opCode() == 110) {
            result = ADActivityAnalyzer.hasOneAnnotatedActive(curActivity, ioArg.down(1), symbolTable);
        } else if (ioArg.opCode() == 71) {
            boolean oneActive = false;
            Tree[] sons = ioArg.children();
            for (int i = sons.length - 1; !oneActive && i >= 0; --i) {
                oneActive = ADActivityAnalyzer.hasOneAnnotatedActive(curActivity, sons[i], symbolTable);
            }
            result = oneActive;
        } else {
            result = false;
        }
        return result;
    }

    public static void setAnnotatedActive(ActivityPattern pattern, Tree tree) {
        if (tree != null) {
            ActivityPattern.setAnnotationForActivityPattern(tree, pattern, "ActiveExpr", Boolean.TRUE);
        }
    }

    public static boolean isAnnotatedActive(ActivityPattern pattern, Tree tree, SymbolTable symbolTable) {
        if (tree == null) {
            return false;
        }
        if (symbolTable == null || TapEnv.doActivity()) {
            if (tree.opCode() == 31) {
                return ADActivityAnalyzer.isAnnotatedActive(pattern, ILUtils.getCalledName(tree));
            }
            return ADActivityAnalyzer.isAnnotatedActive(pattern, tree);
        }
        if (tree.opCode() == 31) {
            Unit calledUnit = DataFlowAnalyzer.getCalledUnit(tree, symbolTable);
            assert (calledUnit != null);
            if (calledUnit.activityPatterns != null) {
                ActivityPattern noActivityPattern = (ActivityPattern)calledUnit.activityPatterns.head;
                return noActivityPattern.isActive();
            }
            if (!TapEnv.isDistribVersion()) {
                TapEnv.toolError("Recovery case: -nooptim activity but no default ActivityPattern set for " + calledUnit + ", should not happen");
            }
            boolean oneDifferentiableParam = false;
            for (int i = calledUnit.paramElemsNb() - 1; !oneDifferentiableParam && i >= 0; --i) {
                ZoneInfo zoneInfo = calledUnit.paramElemZoneInfo(i);
                if (zoneInfo.realZoneNb == -1) continue;
                oneDifferentiableParam = true;
            }
            return oneDifferentiableParam;
        }
        WrapperTypeSpec exprType = symbolTable.typeOf(tree);
        return exprType == null || exprType.wrappedType == null || TypeSpec.isDifferentiableType(exprType.wrappedType);
    }

    private static boolean isAnnotatedActive(ActivityPattern pattern, Tree tree) {
        if (tree == null) {
            return false;
        }
        Object annotationActiveExpr = ActivityPattern.getAnnotationForActivityPattern(tree, pattern, "ActiveExpr");
        return annotationActiveExpr != null && (Boolean)annotationActiveExpr != false;
    }

    public static boolean oneSymbolDeclIsActive(TapList<SymbolDecl> symbolDecls) {
        boolean oneIsActive = false;
        while (symbolDecls != null && !oneIsActive) {
            oneIsActive = symbolDecls.head != null && ((SymbolDecl)symbolDecls.head).isActiveSymbolDecl();
            symbolDecls = symbolDecls.tail;
        }
        return oneIsActive;
    }

    private static boolean isDifferentiableZoneInfo(ZoneInfo zoneInfo, int diffKind, boolean diffConstants) {
        if (zoneInfo.ownerSymbolDecl != null) {
            return zoneInfo.ownerSymbolDecl.isDifferentiableSymbolDecl(diffKind, diffConstants);
        }
        WrapperTypeSpec typeSpec = zoneInfo.type;
        return typeSpec == null || typeSpec.wrappedType == null || TypeSpec.isDifferentiableType(typeSpec.wrappedType);
    }

    protected static BoolVector buildDefaultIntrinsicCallActivity(Unit intrinsicUnit, int diffKind) {
        BoolVector result;
        BoolVector unitR = intrinsicUnit.getTmpALLKINDPossiblyR();
        if (intrinsicUnit.hasParamElemsInfo()) {
            int n = intrinsicUnit.paramElemsNb();
            result = new BoolVector(n);
            for (int i = 0; i < n; ++i) {
                boolean isDifferentiable;
                boolean bl = isDifferentiable = intrinsicUnit.paramElemZoneInfo(i).kindZoneNb(diffKind) != -1;
                if (!isDifferentiable || !unitR.get(i)) continue;
                result.set(i, true);
            }
        } else {
            result = new BoolVector(0);
        }
        return result;
    }

    private static TapIntList buildRootVarZones(TapList<TapList<String>> varPathNames, Unit unit, TapList<TapIntList> tlPathZones, Block location) {
        TapIntList resultZones = null;
        while (varPathNames != null) {
            TapIntList privateZonesInDefUnit;
            FGArrow entryArrow;
            TapList<String> varPathName = (TapList<String>)varPathNames.head;
            SymbolTable curST = unit.privateSymbolTable();
            if (curST == null) {
                curST = unit.publicSymbolTable();
            }
            Unit curUnit = unit;
            TapList curZones = null;
            TypeSpec curType = null;
            int curTypeKind = 3;
            String curPath = null;
            while (varPathName != null) {
                curPath = curPath != null ? curPath + "." : "";
                String curString = (String)varPathName.head;
                if (!curST.isCaseDependent()) {
                    curString = curString.toLowerCase();
                }
                if (curTypeKind == 3) {
                    SymbolDecl symbolDecl = curST.getSymbolDecl(curString);
                    if (symbolDecl == null) {
                        TapEnv.commandWarning(-1, curPath + curString + " is not defined for procedure " + unit.name());
                        curPath = curPath + DiffRoot.rebuildIdentifier(varPathName);
                        varPathName = null;
                    } else {
                        switch (symbolDecl.kind()) {
                            case 3: {
                                curUnit = ((FunctionDecl)symbolDecl).unit();
                                if (curUnit.isOutside()) {
                                    TapEnv.commandWarning(-1, curPath + curString + " is not defined for procedure " + unit.name());
                                    varPathName = null;
                                }
                                curTypeKind = 3;
                                curST = curUnit.privateSymbolTable();
                                if (curST == null) {
                                    curST = curUnit.publicSymbolTable();
                                }
                                curPath = curPath + curString;
                                break;
                            }
                            case 1: {
                                curZones = symbolDecl.zones();
                                curType = symbolDecl.type().wrappedType;
                                curTypeKind = curType != null ? curType.kind() : 7;
                                curPath = curPath + curString;
                                break;
                            }
                            default: {
                                TapEnv.commandWarning(-1, curPath + curString + " is not a variable for procedure " + unit.name());
                                curPath = curPath + DiffRoot.rebuildIdentifier(varPathName);
                                varPathName = null;
                                break;
                            }
                        }
                    }
                } else if (curTypeKind != 21) {
                    TapEnv.commandWarning(-1, "Variable " + curPath + " for procedure " + unit.name() + " is not of structured type");
                    curPath = curPath + DiffRoot.rebuildIdentifier(varPathName);
                    varPathName = null;
                } else {
                    CompositeTypeSpec recordType = (CompositeTypeSpec)curType;
                    assert (recordType != null);
                    int fieldRank = recordType.namedFieldRank(curString);
                    if (fieldRank < 0) {
                        TapEnv.commandWarning(-1, "No component named " + curString + " in variable " + curPath + " for procedure " + unit.name());
                        curPath = curPath + DiffRoot.rebuildIdentifier(varPathName);
                        varPathName = null;
                    } else {
                        curType = recordType.fields[fieldRank].type().wrappedType;
                        curTypeKind = curType.kind();
                        while (curZones.head instanceof TapIntList) {
                            curZones = curZones.tail;
                        }
                        Object subList = TapList.nth(curZones, fieldRank);
                        if (subList instanceof TapList) {
                            curZones = (TapList)subList;
                        } else {
                            TapEnv.commandWarning(-1, "Could not analyze component named " + curString + " in variable " + curPath + " for procedure " + unit.name());
                            curPath = curPath + DiffRoot.rebuildIdentifier(varPathName);
                            varPathName = null;
                        }
                        curPath = curPath + curString;
                    }
                }
                while (curTypeKind == 2 || curTypeKind == 5 || curTypeKind == 6) {
                    if (curTypeKind == 6) {
                        assert (curType != null);
                        curZones = curUnit.publicSymbolTable().getPointerDestinationZonesTreeHere(ZoneInfo.listAllZones(curZones, true), null, location, null, ((PointerTypeSpec)curType).destinationType, null, true);
                        curType = ((PointerTypeSpec)curType).destinationType.wrappedType;
                    } else {
                        assert (curType != null);
                        curType = curType.baseTypeSpec((boolean)true).wrappedType;
                    }
                    assert (curType != null);
                    curTypeKind = curType.kind();
                }
                if (varPathName == null) continue;
                varPathName = varPathName.tail;
            }
            curZones = TapList.copyTree(curZones);
            Instruction locInstr = location.rank == -1 ? ((entryArrow = location.getFGArrowTestCase(-1, 1)) == null ? null : entryArrow.destination.headInstr()) : location.headInstr();
            if (curST != null) {
                DataFlowAnalyzer.includePointedElementsInTree(curZones, null, null, true, curST, locInstr, null, false, true);
            }
            if ((privateZonesInDefUnit = ZoneInfo.listAllZones(curZones, true)) == null) {
                TapEnv.commandWarning(-1, curPath + " is not a variable for procedure " + unit.name());
            } else {
                TapIntList publicZonesInDefUnit = curUnit.translateDeclaredToPublicZones(privateZonesInDefUnit);
                TapIntList publicZonesInRootUnit = curUnit == unit ? publicZonesInDefUnit : curUnit.translateToCallerZones(publicZonesInDefUnit, unit);
                publicZonesInRootUnit = TapIntList.remove(publicZonesInRootUnit, curUnit.callGraph().zoneNbOfNullDest);
                if ((publicZonesInRootUnit = TapIntList.remove(publicZonesInRootUnit, curUnit.callGraph().zoneNbOfUnknownDest)) == null) {
                    TapEnv.commandWarning(-1, curPath + " is not a visible argument at " + (location == curUnit.entryBlock() ? "entry" : "exit") + " of procedure " + unit.name());
                } else {
                    TapIntList realZonesInRootUnit = unit.actuallyDifferentiableZones(publicZonesInRootUnit);
                    if (realZonesInRootUnit == null) {
                        TapEnv.commandWarning(-1, curPath + " is not of a differentiable type in procedure " + unit.name());
                    } else {
                        tlPathZones = tlPathZones.placdl(realZonesInRootUnit);
                        while (realZonesInRootUnit != null) {
                            resultZones = TapIntList.addIntoSorted(resultZones, realZonesInRootUnit.head);
                            realZonesInRootUnit = realZonesInRootUnit.tail;
                        }
                    }
                }
            }
            varPathNames = varPathNames.tail;
        }
        return resultZones;
    }

    public static boolean haveDifferentiatedVariable(TapList<ZoneInfo> zones) {
        boolean haveDiff = false;
        while (!haveDiff && zones != null) {
            ZoneInfo zi = (ZoneInfo)zones.head;
            haveDiff = zi.isOnceActive() || zi.from != null && zi.from.isOnceActive();
            zones = zones.tail;
        }
        return haveDiff;
    }

    public static boolean[] formalArgsActivity(ActivityPattern pattern) {
        Unit unit;
        Unit unit2 = unit = pattern == null ? null : pattern.unit();
        if (unit == null || unit.functionTypeSpec() == null || unit.functionTypeSpec().argumentsTypes == null) {
            return null;
        }
        FunctionTypeSpec functionTypeSpec = unit.functionTypeSpec();
        int nbArgs = functionTypeSpec.argumentsTypes.length;
        BoolVector functionDiffParamsRequired = ADActivityAnalyzer.functionDiffFormalRequired(pattern, false);
        boolean[] resultActivity = new boolean[nbArgs + 1];
        for (int i = resultActivity.length - 1; i >= 0; --i) {
            resultActivity[i] = false;
        }
        if (unit.hasParamElemsInfo()) {
            int shapeLength = unit.paramElemsNb();
            block5: for (int i = shapeLength - 1; i >= 0; --i) {
                ZoneInfo zoneInfo = unit.paramElemZoneInfo(i);
                if (zoneInfo == null) continue;
                switch (zoneInfo.kind()) {
                    case 7: {
                        if (zoneInfo.index - 1 >= nbArgs || resultActivity[zoneInfo.index - 1]) continue block5;
                        WrapperTypeSpec argTypeSpec = functionTypeSpec.argumentsTypes[zoneInfo.index - 1];
                        if (!TapEnv.doActivity()) {
                            if (argTypeSpec != null && TypeSpec.isDifferentiableType(argTypeSpec.wrappedType)) {
                                resultActivity[zoneInfo.index - 1] = true;
                            }
                        } else if (zoneInfo.ptrZoneNb != -1 && unit.exitBlock() != null) {
                            if (functionDiffParamsRequired.get(i)) {
                                resultActivity[zoneInfo.index - 1] = true;
                            }
                        } else if (ADActivityAnalyzer.isActiveArg(i, functionDiffParamsRequired, argTypeSpec, TapEnv.diffKind())) {
                            resultActivity[zoneInfo.index - 1] = true;
                        }
                        if (resultActivity[zoneInfo.index - 1] || !ReqExplicit.isPointerActiveArg(pattern, i)) continue block5;
                        resultActivity[zoneInfo.index - 1] = true;
                        continue block5;
                    }
                    case 10: {
                        if (resultActivity[nbArgs]) continue block5;
                        WrapperTypeSpec argTypeSpec = functionTypeSpec.returnType;
                        if (!TapEnv.doActivity()) {
                            if (argTypeSpec != null && TypeSpec.isDifferentiableType(argTypeSpec.wrappedType)) {
                                resultActivity[nbArgs] = true;
                            }
                        } else if (zoneInfo.ptrZoneNb != -1 && unit.exitBlock() != null && unit.pointerEffect != null) {
                            if (functionDiffParamsRequired.get(i)) {
                                resultActivity[nbArgs] = true;
                            }
                        } else if (ADActivityAnalyzer.isActiveArg(i, functionDiffParamsRequired, argTypeSpec, TapEnv.diffKind())) {
                            resultActivity[nbArgs] = true;
                        }
                        if (resultActivity[nbArgs] || !ReqExplicit.isPointerActiveArg(pattern, i)) continue block5;
                        resultActivity[nbArgs] = true;
                        continue block5;
                    }
                }
            }
        }
        return resultActivity;
    }

    public static BoolVector functionDiffFormalRequired(ActivityPattern pattern, boolean withPointers) {
        Unit unit = pattern.unit();
        SymbolTable unitSymbolTable = unit.publicSymbolTable();
        BoolVector functionDiffParamsRequired = null;
        if (unitSymbolTable != null && unit.translator != null) {
            BoolVector privateFunctionDiffRequired = unitSymbolTable.getRequiredDiffVars(pattern);
            BoolVector patternZonesOfVarsHaveDiff = pattern.zonesOfVarsHaveDiff();
            if (patternZonesOfVarsHaveDiff != null) {
                if (privateFunctionDiffRequired == null) {
                    privateFunctionDiffRequired = patternZonesOfVarsHaveDiff;
                } else {
                    privateFunctionDiffRequired = privateFunctionDiffRequired.copy();
                    privateFunctionDiffRequired.cumulOr(patternZonesOfVarsHaveDiff);
                }
            }
            if (privateFunctionDiffRequired != null) {
                int[] unitMap = ADActivityAnalyzer.makeMap3(unit, TapEnv.diffKind());
                functionDiffParamsRequired = ADActivityAnalyzer.propagateUnitDataOutside(privateFunctionDiffRequired, TapEnv.diffKind(), unitMap, true, unit);
                ADActivityAnalyzer.removeEasyLocalDeclaredAndUnavailableOutside(functionDiffParamsRequired, unit);
            } else {
                functionDiffParamsRequired = new BoolVector(unit.translator.length);
            }
        }
        if (unit.hasParamElemsInfo() && TapEnv.doActivity() && functionDiffParamsRequired != null) {
            BoolVector functionZonesWritten;
            BoolVector functionZonesWithDiffOnCall = pattern.callActivity();
            BoolVector possiblyW = unit.unitInOutPossiblyW();
            BoolVector boolVector = functionZonesWritten = possiblyW == null ? null : unit.getTmpALLKINDPossiblyW();
            if (pattern.entryReqX() != null) {
                BoolVector reqXAndRead = pattern.entryReqX();
                if (unit.isC()) {
                    BoolVector functionZonesRead = unit.getTmpALLKINDPossiblyR();
                    reqXAndRead = reqXAndRead.and(functionZonesRead);
                }
                functionZonesWithDiffOnCall = functionZonesWithDiffOnCall.or(reqXAndRead);
            }
            if (pattern.entryAvlX() != null) {
                functionZonesWithDiffOnCall = functionZonesWithDiffOnCall.or(pattern.entryAvlX().and(functionZonesWritten));
            }
            BoolVector functionZonesWithDiffOnExit = pattern.exitActivity();
            if (pattern.exitReqX() != null) {
                functionZonesWithDiffOnExit = functionZonesWithDiffOnExit.or(pattern.exitReqX().and(functionZonesWritten));
            }
            if (pattern.exitAvlX() != null) {
                functionZonesWithDiffOnExit = functionZonesWithDiffOnExit.or(pattern.exitAvlX().and(functionZonesWritten));
            }
            int shapeLength = unit.paramElemsNb();
            block4: for (int i = shapeLength - 1; i >= 0; --i) {
                ZoneInfo zoneInfo = unit.paramElemZoneInfo(i);
                if (zoneInfo == null) continue;
                switch (zoneInfo.kind()) {
                    case 7: {
                        if (zoneInfo.ptrZoneNb == -1 || unit.exitBlock() == null) continue block4;
                        TapIntList entryDestsList = ZoneInfo.listAllZones(zoneInfo.targetZonesTree, true);
                        entryDestsList = ADActivityAnalyzer.mapZoneRkToPublicRk(entryDestsList, 0, unit);
                        if (functionZonesWithDiffOnCall != null && functionZonesWithDiffOnCall.intersects(entryDestsList)) {
                            functionDiffParamsRequired.set(i, true);
                            continue block4;
                        }
                        if (unit.pointerEffect == null) continue block4;
                        TapIntList destsList = new TapIntList(-1, null);
                        BoolVector dejaVuVector = new BoolVector(shapeLength);
                        ADActivityAnalyzer.followExitPointers(i, destsList, unit, dejaVuVector, shapeLength);
                        if (functionZonesWithDiffOnExit == null || !functionZonesWithDiffOnExit.intersects(destsList.tail)) continue block4;
                        functionDiffParamsRequired.set(i, true);
                        continue block4;
                    }
                    case 10: {
                        if (zoneInfo.ptrZoneNb == -1 || unit.exitBlock() == null || unit.pointerEffect == null) continue block4;
                        TapIntList destsList = new TapIntList(-1, null);
                        BoolVector dejaVuVector = new BoolVector(shapeLength);
                        ADActivityAnalyzer.followExitPointers(i, destsList, unit, dejaVuVector, shapeLength);
                        if (functionZonesWithDiffOnExit == null || !functionZonesWithDiffOnExit.intersects(destsList.tail)) continue block4;
                        functionDiffParamsRequired.set(i, true);
                        continue block4;
                    }
                }
            }
        }
        BoolVector formalsWithDiff = pattern.callActivity().or(pattern.exitActivity());
        if (withPointers) {
            if (pattern.entryReqX() != null) {
                formalsWithDiff.cumulOr(pattern.entryReqX());
            }
            if (pattern.exitReqX() != null) {
                formalsWithDiff.cumulOr(pattern.exitReqX());
            }
            if (pattern.entryAvlX() != null) {
                formalsWithDiff.cumulOr(pattern.entryAvlX());
            }
            if (pattern.exitAvlX() != null) {
                formalsWithDiff.cumulOr(pattern.exitAvlX());
            }
        }
        functionDiffParamsRequired = functionDiffParamsRequired == null ? formalsWithDiff : functionDiffParamsRequired.or(formalsWithDiff);
        return functionDiffParamsRequired;
    }

    private static void removeEasyLocalDeclaredAndUnavailableOutside(BoolVector requiredDiffParams, Unit unit) {
        FunctionTypeSpec functionTypeSpec = unit.functionTypeSpec();
        if (unit.hasParamElemsInfo() && functionTypeSpec != null) {
            for (int i = unit.paramElemsNb() - 1; i >= 0; --i) {
                ZoneInfo zoneInfo = unit.paramElemZoneInfo(i);
                if (zoneInfo == null || !zoneInfo.isCommon() && (!zoneInfo.isParameter() || zoneInfo.index > functionTypeSpec.argumentsTypes.length || functionTypeSpec.argumentsTypes[zoneInfo.index - 1] == null || !functionTypeSpec.argumentsTypes[zoneInfo.index - 1].easilyDeclared())) continue;
                requiredDiffParams.set(i, false);
            }
        }
    }

    private static void followExitPointers(int index, TapIntList result, Unit unit, BoolVector dejaVuVector, int shapeLength) {
        if (index < shapeLength && !dejaVuVector.get(index)) {
            dejaVuVector.set(index, true);
            ZoneInfo zoneInfo = unit.paramElemZoneInfo(index);
            if (zoneInfo != null) {
                if (zoneInfo.ptrZoneNb != -1 && unit.pointerEffect != null) {
                    TapIntList exitDestsList;
                    BoolVector exitDests = unit.pointerEffect.getRow(index);
                    if (exitDests == null) {
                        TapIntList entryDestsList = ZoneInfo.listAllZones(zoneInfo.targetZonesTree, true);
                        exitDestsList = ADActivityAnalyzer.mapZoneRkToPublicRk(entryDestsList, 0, unit);
                    } else {
                        exitDestsList = exitDests.trueIndexList(shapeLength);
                    }
                    while (exitDestsList != null) {
                        ADActivityAnalyzer.followExitPointers(exitDestsList.head, result, unit, dejaVuVector, shapeLength);
                        exitDestsList = exitDestsList.tail;
                    }
                } else {
                    result.placdl(index);
                }
            }
        }
    }

    public static boolean isActiveArg(int zoneRk, BoolVector functionActivity, WrapperTypeSpec argType, int diffKind) {
        if (functionActivity == null) {
            return argType == null || TypeSpec.isDifferentiableType(argType.wrappedType);
        }
        return functionActivity.get(zoneRk);
    }

    private static String namesWithProperty(TapList<TapList<String>> names, TapList publicZonesList, BoolVector property) {
        String result = null;
        while (publicZonesList != null) {
            TapIntList publicZones = (TapIntList)publicZonesList.head;
            if (publicZones != null && property.contains(publicZones)) {
                String name = DiffRoot.rebuildIdentifier((TapList)names.head);
                result = result == null ? name : result + ", " + name;
            }
            publicZonesList = publicZonesList.tail;
            names = names.tail;
        }
        return result;
    }

    private static BoolMatrix buildDefaultADDependencies(Unit unit, int diffKind) {
        BoolVector unitW = unit.getTmpALLKINDPossiblyW();
        if (!unit.hasParamElemsInfo() || unitW == null) {
            return new BoolMatrix(0, 0);
        }
        int n = unit.paramElemsNb();
        BoolVector unitR = unit.getTmpALLKINDPossiblyR();
        BoolVector unitN = unit.getTmpALLKINDN();
        BoolMatrix result = new BoolMatrix(n, n);
        result.setIdentity();
        BoolVector depLine = new BoolVector(n);
        depLine.setFalse();
        BoolVector depLineZero = new BoolVector(n);
        depLineZero.setFalse();
        TapIntList returnIndices = null;
        for (int i = 0; i < n; ++i) {
            ZoneInfo zi = unit.paramElemZoneInfo(i);
            if (zi == null) continue;
            if (zi.kindZoneNb(diffKind) != -1) {
                if (unitW.get(i)) {
                    returnIndices = new TapIntList(i, returnIndices);
                }
                if (!unitR.get(i)) continue;
                depLine.set(i, true);
                continue;
            }
            if (!unitW.get(i)) continue;
            result.setRow(i, depLineZero);
        }
        while (returnIndices != null) {
            int ri = returnIndices.head;
            BoolVector depLineCopy = depLine.copy();
            if (unitN.get(ri)) {
                depLineCopy.set(ri, true);
            }
            result.setRow(ri, depLineCopy);
            returnIndices = returnIndices.tail;
        }
        return result;
    }

    private static BoolMatrix getPublicDeps(Unit unit, UnitStorage<BoolMatrix> dependencies, int diffKind) {
        BoolMatrix result;
        if (unit.isIntrinsic()) {
            result = unit.unitADDependencies;
            if (result == null) {
                result = ADActivityAnalyzer.buildDefaultADDependencies(unit, diffKind);
            }
        } else {
            result = dependencies.retrieve(unit);
            if (result == null && (unit.isExternal() || unit.isVarFunction() || unit.isInterface())) {
                result = ADActivityAnalyzer.buildDefaultADDependencies(unit, diffKind);
                dependencies.store(unit, result);
            }
        }
        return result;
    }

    public void setPhaseVaried(BoolVector variedEntries, BlockStorage<TapList<BoolVector>> curUnitVariednesses) {
        this.cgPhase = 2;
        this.fgPhase = 1;
        this.entryFrontierVariedZones = variedEntries;
        this.curUnitInfos = curUnitVariednesses;
    }

    public void setPhaseUseful(BoolVector usefulExits, BlockStorage<TapList<BoolVector>> curUnitUsefulnesses) {
        this.cgPhase = 2;
        this.fgPhase = 2;
        this.exitFrontierUsefulZones = usefulExits;
        this.curUnitInfos = curUnitUsefulnesses;
    }

    public void reMergeAndAnnotate(TapList<Block> portionBlocks, ActivityPattern activity) {
        this.curActivity = activity;
        while (portionBlocks != null) {
            Block block = (Block)portionBlocks.head;
            TapList<BoolVector> blockUsefulnesses = activity.usefulnesses().retrieve(block);
            TapList<BoolVector> blockVariednesses = activity.activities().retrieve(block);
            TapList<BoolVector> blockU = blockUsefulnesses;
            TapList<BoolVector> blockV = blockVariednesses;
            while (blockU != null && blockV != null) {
                ((BoolVector)blockV.head).cumulAnd((BoolVector)blockU.head);
                blockU = blockU.tail;
                blockV = blockV.tail;
            }
            this.removeActivityAnnotations(block);
            assert (blockVariednesses != null);
            assert (blockUsefulnesses != null);
            this.curUnitZonesOfVarsHaveDiff = activity.zonesOfVarsHaveDiff();
            this.presetActivityAnnotations(block, false, blockVariednesses, blockUsefulnesses);
            portionBlocks = portionBlocks.tail;
        }
    }

    private void runNoActivity(TapList<Unit> rootUnits) {
        TapList<Unit> allUnits = TapList.append(this.curCallGraph.sortedUnits(), this.curCallGraph.intrinsicUnits());
        TapList<Unit> calleeUnits = rootUnits == null ? null : Unit.allCalleesMulti(rootUnits);
        for (Unit unit : allUnits) {
            BoolVector tmpPubW;
            if (!unit.isIntrinsic() && !unit.isExternal() && !unit.isInterface() && (!unit.isStandard() || calleeUnits != null && !TapList.contains(calleeUnits, unit))) continue;
            DiffRoot unitDiffRoot = null;
            TapList<DiffRoot> inDiffRoots = this.diffRoots;
            while (unitDiffRoot == null && inDiffRoots != null) {
                if (((DiffRoot)inDiffRoots.head).unit() == unit) {
                    unitDiffRoot = (DiffRoot)inDiffRoots.head;
                }
                inDiffRoots = inDiffRoots.tail;
            }
            ActivityPattern noActivityPattern = new ActivityPattern(unit, true, false, this.diffKind);
            if (unitDiffRoot != null && unitDiffRoot.diffPatterns() != null) {
                noActivityPattern.setDiffPattern((DiffPattern)unitDiffRoot.diffPatterns().head);
            }
            int shapeLen = unit.paramElemsNb();
            BoolVector diffTypeZones = new BoolVector(shapeLen);
            for (int i = shapeLen - 1; i >= 0; --i) {
                ZoneInfo zoneInfo = unit.paramElemZoneInfo(i);
                diffTypeZones.set(i, ADActivityAnalyzer.isDifferentiableZoneInfo(zoneInfo, TapEnv.diffKind(), true));
            }
            if (unit.unitInOutPossiblyW() != null && !(tmpPubW = unit.getTmpALLKINDPossiblyW()).and(diffTypeZones).isFalse(shapeLen)) {
                BoolVector unitPossiblyRorW = unit.getTmpALLKINDPossiblyRoW();
                for (int i = shapeLen - 1; i >= 0; --i) {
                    if (!unitPossiblyRorW.get(i) && !unit.paramElemZoneInfo(i).isCommon() || !diffTypeZones.get(i)) continue;
                    noActivityPattern.callActivity().set(i, true);
                    noActivityPattern.exitActivity().set(i, true);
                }
            }
            unit.activityPatterns = new TapList<ActivityPattern>(noActivityPattern, null);
        }
    }

    @Override
    protected void run(TapList<Unit> rootUnits) {
        TapList<ActivityPattern> activities;
        String topAnalysisName = this.curAnalysisName;
        this.cgPhase = 1;
        this.curAnalysisName = "Bottom-up AD dependency analysis";
        this.tracedUnits = this.curCallGraph.getUnits(TapEnv.traceADDeps());
        this.runBottomUpAnalysis(rootUnits);
        this.cgPhase = 2;
        this.curAnalysisName = "Top-down AD activity analysis";
        this.tracedUnits = this.curCallGraph.getUnits(TapEnv.traceActivity());
        this.runTopDownAnalysis(rootUnits);
        TapList<Unit> calledIntrinsics = this.curCallGraph.intrinsicUnits();
        while (calledIntrinsics != null) {
            this.setCurUnitEtc((Unit)calledIntrinsics.head);
            TapList<ActivityPattern> activityPatterns = this.curUnit.activityPatterns;
            while (activityPatterns != null) {
                this.curActivity = (ActivityPattern)activityPatterns.head;
                this.computeUnitFrontierActivities(this.curUnit, this.curActivity, this.curActivity.variedOnCall(), this.curActivity.usefulOnExit());
                activityPatterns = activityPatterns.tail;
            }
            calledIntrinsics = calledIntrinsics.tail;
        }
        TapList<Unit> inUnits = TapList.reverse(rootUnits == null ? this.curCallGraph.units() : Unit.allCalleesMulti(rootUnits));
        while (inUnits != null) {
            this.setCurUnitEtc((Unit)inUnits.head);
            activities = this.curUnit.activityPatterns;
            while (activities != null) {
                this.curActivity = (ActivityPattern)activities.head;
                if (this.curUnit.hasSource()) {
                    this.checkCalledFunctionsActivities();
                }
                activities = activities.tail;
            }
            inUnits = inUnits.tail;
        }
        inUnits = rootUnits;
        while (inUnits != null) {
            this.setCurUnitEtc((Unit)inUnits.head);
            activities = this.curUnit.activityPatterns;
            while (activities != null) {
                this.curActivity = (ActivityPattern)activities.head;
                if (this.curUnit.entryBlock() != null) {
                    this.setCurBlockEtc(this.curUnit.entryBlock());
                    Tree rootCallTree = this.curUnit.entryBlock().headTree();
                    if (rootCallTree != null) {
                        Unit restoreCurUnit = this.curUnit;
                        this.curUnit = null;
                        this.checkCalledFunctionsActivitiesInTree(rootCallTree);
                        this.curUnit = restoreCurUnit;
                    }
                    this.setCurBlockEtc(null);
                }
                activities = activities.tail;
            }
            inUnits = inUnits.tail;
        }
        this.setCurUnitEtc(null);
        this.curAnalysisName = topAnalysisName;
    }

    @Override
    public void setCurUnitEtc(Unit unit) {
        super.setCurUnitEtc(unit);
        this.nDRZ = this.curSymbolTable == null ? -9 : this.curSymbolTable.declaredZonesNb(this.diffKind);
        this.curBlockMap[1] = 0;
        this.curBlockMap[2] = 0;
        this.curBlockMap[3] = this.nDRZ;
        if (this.curUnit == null || this.curUnit.publicSymbolTable() == null) {
            this.nUDRZ = -9;
            this.entryMap[1] = -9;
            this.entryMap[2] = -9;
            this.entryMap[3] = -9;
        } else {
            this.nUDRZ = this.curUnit.publicSymbolTable().declaredZonesNb(this.diffKind);
            this.entryMap[1] = 0;
            this.entryMap[2] = 0;
            this.entryMap[3] = this.nUDRZ;
        }
    }

    @Override
    protected Object initializeCGForUnit() {
        if (this.cgPhase == 1) {
            if (this.curUnit.isExternal() || this.curUnit.isVarFunction() || this.curUnit.isInterface() || this.curUnit.isRenamed() || this.curUnit.isModule() || !this.curUnit.isIntrinsic() && !this.curUnit.hasSource()) {
                if (this.curUnit.rank() > 0 && this.dependencies.retrieve(this.curUnit) == null) {
                    BoolMatrix result = ADActivityAnalyzer.buildDefaultADDependencies(this.curUnit, this.diffKind);
                    this.dependencies.store(this.curUnit, result);
                }
            } else if (!this.curUnit.isIntrinsic() && this.curUnit.rank() > 0 && this.dependencies.retrieve(this.curUnit) == null) {
                this.dependencies.store(this.curUnit, null);
            }
            return null;
        }
        if (this.curUnit.hasParamElemsInfo()) {
            if (TapEnv.traceCurAnalysis()) {
                TapEnv.printlnOnTrace(" initializing unit: " + this.curUnit);
            }
            this.curUnit.activityPatterns = null;
            return null;
        }
        return null;
    }

    @Override
    protected void initializeCGForRootUnit() {
        int shapeLength = this.curUnit.paramElemsNb();
        boolean canGeneralizeActivity = this.curUnit.hasDirective(27) == null;
        TapList<DiffRoot> inDiffRoots = this.diffRoots;
        while (inDiffRoots != null) {
            TapList<DiffPattern> diffPatterns;
            DiffRoot thisDiffRoot = (DiffRoot)inDiffRoots.head;
            if (thisDiffRoot.unit() == this.curUnit && (diffPatterns = thisDiffRoot.diffPatterns()) != null) {
                for (DiffPattern diffPattern : diffPatterns) {
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace(" initializing rootUnit: " + this.curUnit + " with diffPattern " + diffPattern);
                    }
                    TapList<Object> hdPathZones = new TapList<Object>(null, null);
                    diffPattern.setIndepsZones(ADActivityAnalyzer.buildRootVarZones(diffPattern.indepsPathNames(), this.curUnit, hdPathZones, this.curUnit.entryBlock()));
                    diffPattern.setIndepsPathZones(hdPathZones.tail);
                    BoolVector rootVarieds = new BoolVector(shapeLength);
                    if (diffPattern.indepsZones() != null) {
                        rootVarieds.set(diffPattern.indepsZones(), true);
                    } else {
                        rootVarieds.setTrue();
                    }
                    hdPathZones.tail = null;
                    diffPattern.setDepsZones(ADActivityAnalyzer.buildRootVarZones(diffPattern.depsPathNames(), this.curUnit, hdPathZones, this.curUnit.exitBlock()));
                    diffPattern.setDepsPathZones(hdPathZones.tail);
                    BoolVector rootUsefuls = new BoolVector(shapeLength);
                    if (diffPattern.depsZones() != null) {
                        rootUsefuls.set(diffPattern.depsZones(), true);
                    } else {
                        rootUsefuls.setTrue();
                    }
                    for (int i = shapeLength - 1; i >= 0; --i) {
                        ZoneInfo zoneInfo = this.curUnit.paramElemZoneInfo(i);
                        if (zoneInfo != null && this.diffKind != 0 && !ADActivityAnalyzer.isDifferentiableZoneInfo(zoneInfo, this.diffKind, !TapEnv.doActivity())) {
                            rootVarieds.set(i, false);
                            rootUsefuls.set(i, false);
                        }
                        if (zoneInfo == null || !zoneInfo.isResult()) continue;
                        rootVarieds.set(i, false);
                    }
                    this.warnAboutRemanentVars(rootVarieds, rootUsefuls, this.curUnit);
                    BoolVector staticActivity = new BoolVector(this.curUnit.paramElemsNb());
                    this.filterVariedUsefulWithDeps(rootVarieds, rootUsefuls, this.curUnit, diffPattern, staticActivity);
                    BoolVector rootUsefulOnCallingSide = rootUsefuls.copy();
                    ActivityPattern thisActivity = new ActivityPattern(this.curUnit, rootVarieds, rootUsefuls, canGeneralizeActivity, this.diffKind);
                    thisActivity.setDiffPattern(diffPattern);
                    thisActivity.setStaticActivity(staticActivity);
                    thisActivity.setUsefulOnCallingSide(rootUsefulOnCallingSide);
                    this.curUnit.activityPatterns = new TapList<ActivityPattern>(thisActivity, this.curUnit.activityPatterns);
                }
            }
            inDiffRoots = inDiffRoots.tail;
        }
    }

    private void warnAboutRemanentVars(BoolVector rootVarieds, BoolVector rootUsefuls, Unit unit) {
        int shapeLength = this.curUnit.paramElemsNb();
        BoolVector remanentVarsMask = new BoolVector(shapeLength);
        for (int i = shapeLength - 1; i >= 0; --i) {
            ZoneInfo zoneInfo = this.curUnit.paramElemZoneInfo(i);
            if (zoneInfo == null || !zoneInfo.isRemanentLocal() || this.diffKind != 0 && !ADActivityAnalyzer.isDifferentiableZoneInfo(zoneInfo, this.diffKind, !TapEnv.doActivity())) continue;
            remanentVarsMask.set(i, true);
        }
        BoolMatrix unitPublicDeps = ADActivityAnalyzer.getPublicDeps(unit, this.dependencies, this.diffKind);
        BoolVector dangerousRemanents = remanentVarsMask.copy();
        if (unitPublicDeps != null) {
            BoolVector variedRemanents = unitPublicDeps.times(rootVarieds).and(remanentVarsMask);
            while (variedRemanents.cumulOrGrows(unitPublicDeps.times(variedRemanents).and(remanentVarsMask), shapeLength)) {
            }
            dangerousRemanents.cumulAnd(variedRemanents);
            BoolVector usefulRemanents = unitPublicDeps.leftTimes(rootUsefuls).and(remanentVarsMask);
            while (usefulRemanents.cumulOrGrows(unitPublicDeps.leftTimes(usefulRemanents).and(remanentVarsMask), shapeLength)) {
            }
            dangerousRemanents.cumulAnd(usefulRemanents);
        }
        String dangerousRemanentNames = null;
        for (int i = shapeLength - 1; i >= 0; --i) {
            if (!dangerousRemanents.get(i) || rootVarieds.get(i) && rootUsefuls.get(i)) continue;
            dangerousRemanentNames = (dangerousRemanentNames == null ? "" : dangerousRemanentNames + ", ") + ILUtils.toString(this.curUnit.paramElemZoneInfo((int)i).accessTree);
        }
        if (dangerousRemanentNames != null) {
            TapEnv.fileWarning(15, unit.headTree(), "(AD08) Head routine " + unit.name() + " has remanent variables " + dangerousRemanentNames + " that one may want to declare as (in)dependents in case of repeated calls");
        }
    }

    @Override
    protected boolean analyze() {
        if (this.cgPhase == 1) {
            if (TapEnv.traceCurAnalysis()) {
                TapEnv.printlnOnTrace();
                TapEnv.printlnOnTrace(" ============== AD DEPENDENCY ANALYSIS OF UNIT " + this.curUnit.name() + " : ==============");
                this.traceDisplayPrivateZones(this.curUnit, ADActivityAnalyzer.makeMap3(0, 0, this.curUnit.privateSymbolTable().declaredZonesNb(this.diffKind)), this.diffKind);
                TapEnv.printlnOnTrace();
            }
            return this.analyzeForward(null, null, null);
        }
        BoolMatrix unitPublicDeps = ADActivityAnalyzer.getPublicDeps(this.curUnit, this.dependencies, this.diffKind);
        if ((unitPublicDeps = ADActivityAnalyzer.filterByValue(unitPublicDeps, this.curUnit)) != null && this.curUnit.hasParamElemsInfo()) {
            TapList<ActivityPattern> activityPatterns = this.curUnit.activityPatterns;
            while (activityPatterns != null) {
                this.curActivity = (ActivityPattern)activityPatterns.head;
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace(" analysis of " + this.curUnit + " for ActivityPattern " + this.curActivity + " with diffPattern " + this.curActivity.diffPattern());
                }
                this.curStaticActivity = this.curUnit.hasSource() ? this.propagateUnitDataInside(this.curActivity.staticActivity(), this.diffKind, this.entryMap) : null;
                this.filteredContext = new BoolVector[2];
                this.filteredContext[0] = this.curActivity.variedOnCall();
                this.filteredContext[1] = this.curActivity.usefulOnExit();
                BoolVector unitCallVariedness = this.filteredContext[0];
                BoolVector unitExitUsefulness = this.filteredContext[1];
                int shapeLength = this.curUnit.paramElemsNb();
                if (!unitCallVariedness.isFalse(shapeLength) || !unitExitUsefulness.isFalse(shapeLength)) {
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace();
                        TapEnv.printlnOnTrace(" =============  AD ACTIVITY ANALYSIS OF UNIT " + this.curUnit.name() + " : ============");
                        TapEnv.printlnOnTrace(" Activity context of this analysis: " + this.curActivity);
                        TapEnv.printlnOnTrace();
                        for (int i = 0; i < shapeLength; ++i) {
                            ZoneInfo zi = this.curUnit.paramElemZoneInfo(i);
                            if (zi == null) continue;
                            TapEnv.printOnTrace(" [" + i + "]" + zi.accessTreePrint(this.curUnit.language()));
                        }
                        TapEnv.printlnOnTrace();
                        TapEnv.printlnOnTrace("   UNIT's (DIFF-)DEPS:");
                        TapEnv.dumpOnTrace(unitPublicDeps);
                        TapEnv.printlnOnTrace("    CONTEXT: " + unitCallVariedness.toString(shapeLength) + "->" + unitExitUsefulness.toString(shapeLength) + " + STATIC: " + (this.curStaticActivity == null ? "Null" : this.curActivity.staticActivity().toString(shapeLength)));
                        TapEnv.printlnOnTrace();
                    } else if (this.curUnit.hasSource()) {
                        TapEnv.printOnTrace(15, "context [" + unitCallVariedness.toString(shapeLength) + "]->[" + unitExitUsefulness.toString(shapeLength) + "] ");
                    }
                    if (this.curUnit.hasSource()) {
                        if (TapEnv.traceCurAnalysis()) {
                            this.setCurBlockEtc(this.curUnit.allBlocks == null ? this.curUnit.entryBlock() : (Block)this.curUnit.allBlocks.head);
                            this.traceDisplayPrivateZones(this.curUnit, this.curBlockMap, this.diffKind);
                            this.setCurBlockEtc(null);
                        }
                        if (TapEnv.traceCurAnalysis()) {
                            TapEnv.printlnOnTrace("       =======  FORWARD VARIED: =======");
                        }
                        this.curUnitInfos = this.curActivity.activities();
                        if (this.curUnitInfos == null) {
                            this.curUnitInfos = new BlockStorage(this.curUnit);
                            this.curActivity.setActivities(this.curUnitInfos);
                        }
                        this.fgPhase = 1;
                        this.analyzeForward(null, null, null);
                        BlockStorage<TapList<BoolVector>> curUnitVariednesses = this.curUnitInfos;
                        if (TapEnv.traceCurAnalysis()) {
                            TapEnv.printlnOnTrace("       =======  BACKWARD USEFUL: ======");
                        }
                        this.curUnitInfos = this.curActivity.usefulnesses();
                        if (this.curUnitInfos == null) {
                            this.curUnitInfos = new BlockStorage(this.curUnit);
                            this.curActivity.setUsefulnesses(this.curUnitInfos);
                        }
                        this.fgPhase = 2;
                        this.analyzeBackward(null, null, null);
                        BlockStorage<TapList<BoolVector>> curUnitUsefulnesses = this.curUnitInfos;
                        this.accumulateBufferizedCallContexts();
                        this.mergeUsefulnessIntoVariedness(this.curUnit, curUnitUsefulnesses, curUnitVariednesses);
                        this.curActivity.setActivities(curUnitVariednesses);
                        this.curActivity.setUsefulnesses(curUnitUsefulnesses);
                    }
                    this.computeUnitFrontierActivities(this.curUnit, this.curActivity, unitCallVariedness, unitExitUsefulness);
                    if (TapEnv.traceCurAnalysis()) {
                        if (this.curUnit.hasSource()) {
                            TapEnv.printlnOnTrace();
                            BlockStorage<TapList<BoolVector>> curUnitActivities = this.curActivity.activities();
                            BoolVector unitEntryActivityInside = (BoolVector)curUnitActivities.retrieve((Block)this.curUnit.entryBlock()).head;
                            BoolVector unitExitActivityInside = (BoolVector)curUnitActivities.retrieve((Block)this.curUnit.exitBlock()).head;
                            TapEnv.printlnOnTrace("    Expected inside entry activity: " + unitEntryActivityInside);
                            TapEnv.printlnOnTrace("    Expected inside  exit activity: " + unitExitActivityInside);
                        }
                        TapEnv.printlnOnTrace("    Unit outside call activity: " + this.curActivity.callActivity());
                        TapEnv.printlnOnTrace("    Unit outside exit activity: " + this.curActivity.exitActivity());
                        TapEnv.printlnOnTrace();
                    }
                } else {
                    this.curActivity.callActivity().setCopy(unitCallVariedness);
                    if (this.curUnit.hasSource() && this.curStaticActivity != null) {
                        if (TapEnv.traceCurAnalysis()) {
                            TapEnv.printlnOnTrace();
                            TapEnv.printlnOnTrace(" =============  AD ACTIVITY STATIC PROPAGATION OF UNIT " + this.curUnit.name() + " : ============");
                            TapEnv.printlnOnTrace(" Activity context of this analysis: " + this.curActivity);
                            TapEnv.printlnOnTrace();
                        }
                        this.fgPhase = 3;
                        this.analyzeStatically(null, null);
                        this.accumulateBufferizedCallContexts();
                    }
                }
                activityPatterns = activityPatterns.tail;
            }
            this.curStaticActivity = null;
        }
        return false;
    }

    @Override
    protected void propagateValuesStaticallyThroughExpression() {
        Tree expression = this.curInstruction.tree;
        Tree lhs = null;
        int expressionCode = expression.opCode();
        if (expression.opCode() == 14 || expression.opCode() == 150 || expression.opCode() == 125 || expression.opCode() == 190 || expression.opCode() == 63) {
            lhs = expression.down(1);
            expression = expression.down(2);
        }
        if (expression.opCode() == 31) {
            Unit calledUnit;
            this.curCalledUnit = calledUnit = ADActivityAnalyzer.getCalledUnit(expression, this.curSymbolTable);
            MPIcallInfo messagePassingInfo = MPIcallInfo.getMessagePassingMPIcallInfo(calledUnit.name(), expression, this.curUnit.language(), this.curBlock);
            if (messagePassingInfo == null) {
                CallArrow arrow = CallGraph.getCallArrow(this.curUnit, calledUnit);
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace(" ---------- Static propagation of activity on procedure call " + ILUtils.toString(expression) + " : ----------");
                }
                this.bufferizeCallContext(calledUnit, expression, null, null, null, 3);
            }
        }
    }

    private void computeUnitFrontierActivities(Unit unit, ActivityPattern curActivity, BoolVector unitCallVariedness, BoolVector unitExitUsefulness) {
        BlockStorage<TapList<BoolVector>> curUnitActivities = curActivity.activities();
        BoolVector unitCallActivity = unitCallVariedness.copy();
        BoolVector unitExitActivity = unitExitUsefulness.copy();
        BoolVector unitCallActivityOutside = unitCallVariedness.copy();
        BoolVector unitExitActivityOutside = unitExitUsefulness.copy();
        BoolVector sideEffectInUnit = null;
        BoolVector sideEffectInCaller = null;
        if (unit.hasSource()) {
            sideEffectInUnit = this.sideEffectInUnit(unit);
            sideEffectInCaller = this.sideEffectInCaller(unit);
            sideEffectInCaller.cumulMinus(sideEffectInUnit);
        }
        boolean isMessagePassing = MPIcallInfo.isMessagePassingFunction(unit.name(), unit.language());
        BoolMatrix unitPublicDeps = ADActivityAnalyzer.getPublicDeps(unit, this.dependencies, this.diffKind);
        assert (unitPublicDeps != null);
        BoolVector callUsefuls = unitPublicDeps.leftTimes(unitExitActivity);
        BoolVector exitVarieds = unitPublicDeps.times(unitCallActivity);
        if (DiffRoot.findUnit(this.diffRoots, unit) == null && !isMessagePassing) {
            BoolVector callUsefulsModified = callUsefuls.copy();
            BoolVector exitVariedsModified = exitVarieds.copy();
            if (TapEnv.debugAdMode() == 1) {
                BoolVector tmpPubR = unit.getTmpALLKINDPossiblyR();
                callUsefulsModified.cumulOr(tmpPubR);
                BoolVector tmpPubW = unit.getTmpALLKINDPossiblyW();
                exitVariedsModified.cumulOr(tmpPubW);
            }
            if (!TapEnv.debugActivity() && TapEnv.doUsefulness()) {
                unitCallActivityOutside.cumulAnd(callUsefulsModified);
                unitExitActivityOutside.cumulAnd(exitVariedsModified);
            }
            if (unit.hasSource()) {
                callUsefulsModified.cumulOr(sideEffectInCaller);
                exitVariedsModified.cumulOr(sideEffectInCaller);
            }
            if (!TapEnv.debugActivity() && TapEnv.doUsefulness()) {
                unitCallActivity.cumulAnd(callUsefulsModified);
                unitExitActivity.cumulAnd(exitVariedsModified);
            }
        }
        if (unit.hasSource()) {
            BoolVector modifiedInUnit = this.getFinalModifiedZones(unitPublicDeps, unitCallActivity, unitExitActivity);
            BoolVector modifiedInUnitT = this.getFinalModifiedZonesT(unitPublicDeps, unitCallActivity, unitExitActivity);
            assert (sideEffectInCaller != null);
            unitCallActivity.cumulOr(sideEffectInCaller.and(modifiedInUnitT));
            unitExitActivity.cumulOr(sideEffectInCaller.and(modifiedInUnit));
            unitCallActivity.cumulMinus(sideEffectInUnit);
            unitExitActivity.cumulMinus(sideEffectInUnit);
            this.setCurBlockEtc(unit.entryBlock());
            if (!TapEnv.debugActivity() && TapEnv.doUsefulness()) {
                curUnitActivities.retrieve((Block)unit.entryBlock()).head = this.propagateUnitDataInside(unitCallActivity, this.diffKind, this.curBlockMap);
                curUnitActivities.retrieve((Block)unit.exitBlock()).head = this.propagateUnitDataInside(unitExitActivity, this.diffKind, this.curBlockMap);
            }
            this.setCurBlockEtc(null);
        }
        curActivity.callActivity().setCopy(unitCallActivityOutside);
        if (TapEnv.debugActivity() || !TapEnv.doUsefulness()) {
            curActivity.setExitUsefulness(unitExitActivityOutside);
            curActivity.setCallUsefulness(callUsefuls);
            curActivity.setExitActivity(exitVarieds);
        } else {
            curActivity.setExitActivity(unitExitActivityOutside);
        }
    }

    @Override
    protected void initializeUnit() {
        if (this.cgPhase == 1) {
            this.depsIn = new BlockStorage(this.curUnit);
            this.depsOut = new BlockStorage(this.curUnit);
            this.depsThrough = new BlockStorage(this.curUnit);
        } else {
            this.infosUp = new BlockStorage(this.curUnit);
            this.infosDown = new BlockStorage(this.curUnit);
            this.infosCycleUp = new BlockStorage(this.curUnit);
            this.infosCycleDown = new BlockStorage(this.curUnit);
        }
    }

    @Override
    protected void setCurBlockEtc(Block block) {
        super.setCurBlockEtc(block);
        this.curBlockMap[3] = this.nDRZ = this.curSymbolTable == null ? -9 : this.curSymbolTable.declaredZonesNb(this.diffKind);
    }

    @Override
    protected void initializeInitBlock() {
        if (this.cgPhase == 1) {
            BoolMatrix initIdentity = new BoolMatrix(this.nDRZ, this.nDRZ);
            initIdentity.setIdentity();
            this.depsOut.store(this.curBlock, initIdentity);
        } else if (this.fgPhase == 1) {
            if (this.curBlock == this.curUnit.entryBlock()) {
                this.infosDown.store(this.curBlock, this.propagateUnitDataInside(this.filteredContext[0], this.diffKind, this.curBlockMap));
            } else {
                this.infosDown.store(this.curBlock, this.entryFrontierVariedZones);
                if (ADActivityAnalyzer.runSpecialCycleAnalysis(this.curBlock)) {
                    this.infosCycleDown.store(this.curBlock, this.entryFrontierVariedZones);
                }
            }
        } else if (this.curBlock == this.curUnit.exitBlock()) {
            this.infosUp.store(this.curBlock, this.propagateUnitDataInside(this.filteredContext[1], this.diffKind, this.curBlockMap));
        } else {
            this.infosUp.store(this.curBlock, this.exitFrontierUsefulZones);
            if (ADActivityAnalyzer.runSpecialCycleAnalysis(this.curBlock)) {
                this.infosCycleUp.store(this.curBlock, this.exitFrontierUsefulZones);
            }
        }
    }

    @Override
    protected void initializeFGForBlock() {
        if (this.cgPhase == 1) {
            BoolMatrix deps = new BoolMatrix(this.nDRZ, this.nDRZ);
            deps.setIdentity();
            TapList<Instruction> instructions = this.curBlock.instructions;
            ToBool arrives = new ToBool(true);
            while (instructions != null) {
                this.curInstruction = (Instruction)instructions.head;
                this.depsThroughExpression(deps, this.curInstruction.tree, arrives);
                instructions = instructions.tail;
            }
            if (!arrives.get()) {
                deps = null;
            }
            this.curInstruction = null;
            this.depsThrough.store(this.curBlock, deps);
            if (TapEnv.traceCurAnalysis()) {
                TapEnv.printlnOnTrace(" == AD Deps through " + this.curBlock + " is:");
                TapEnv.dumpBoolMatrixOnTrace(deps, this.curBlockMap, this.curBlockMap);
                TapEnv.printlnOnTrace();
            }
        }
    }

    @Override
    protected boolean accumulateValuesFromUpstream() {
        if (this.cgPhase == 1) {
            this.tmpDep = this.accumulateDepIn(this.curBlock);
            return this.tmpDep != null;
        }
        return super.accumulateValuesFromUpstream();
    }

    @Override
    protected void setEmptyCumulAndCycleValues() {
        this.infoTmp = null;
        this.infoTmpCycle = null;
    }

    @Override
    protected boolean getValueFlowingThrough() {
        Block origin = this.curArrow.origin;
        this.additionalInfo = ADActivityAnalyzer.runSpecialCycleAnalysis(origin) && this.curArrow.containsCase(1) ? this.infosCycleDown.retrieve(origin) : this.infosDown.retrieve(origin);
        return this.additionalInfo != null;
    }

    @Override
    protected boolean getValueFlowingBack() {
        Block destination = this.curArrow.destination;
        this.additionalInfo = ADActivityAnalyzer.runSpecialCycleAnalysis(destination) && this.curArrow.finalCycle() == destination.enclosingLoop() ? this.infosCycleUp.retrieve(destination) : this.infosUp.retrieve(destination);
        return this.additionalInfo != null;
    }

    @Override
    protected void initializeCumulValue() {
        this.infoTmp = new BoolVector(this.nDRZ);
    }

    @Override
    protected void cumulValueWithAdditional(SymbolTable commonSymbolTable) {
        if (this.infoTmp == null) {
            this.infoTmp = new BoolVector(this.nDRZ);
        }
        int commonLength = commonSymbolTable.declaredZonesNb(this.diffKind);
        this.infoTmp.cumulOr(this.additionalInfo, commonLength);
    }

    @Override
    protected void cumulCycleValueWithAdditional(SymbolTable commonSymbolTable) {
        if (this.infoTmpCycle == null) {
            this.infoTmpCycle = new BoolVector(this.nDRZ);
        }
        int commonLength = commonSymbolTable.declaredZonesNb(this.diffKind);
        this.infoTmpCycle.cumulOr(this.additionalInfo, commonLength);
    }

    @Override
    protected boolean compareDownstreamValues() {
        if (this.cgPhase == 1) {
            BoolMatrix oldDep = this.depsOut.retrieve(this.curBlock);
            if (oldDep == null || !this.tmpDep.equalsBoolMatrix(oldDep)) {
                this.depsOut.store(this.curBlock, this.tmpDep);
                return true;
            }
            return false;
        }
        return this.compareWithStorage(this.infoTmp, this.infoTmpCycle, this.nDRZ, this.infosDown, this.infosCycleDown);
    }

    @Override
    protected boolean compareChannelZoneDataDownstream(int mpZone, Block refBlock) {
        boolean result = false;
        int mpIndex = this.extendedDeclaredToVectorIndex(mpZone, this.diffKind, this.curBlockMap);
        if (mpIndex >= 0) {
            if (this.cgPhase == 1) {
                BoolMatrix refDep = this.depsOut.retrieve(refBlock);
                BoolVector refRow = refDep.getRow(mpIndex);
                BoolVector newRow = this.tmpDep.getRow(mpIndex);
                if (!(newRow == null || refRow != null && refRow.contains(newRow, this.entryMap[3]))) {
                    refDep.overwriteDeps(new TapIntList(mpIndex, null), newRow, false);
                    result = true;
                }
            } else {
                BoolVector infoTmpCopy = this.infoTmp.copy();
                if (ADActivityAnalyzer.runSpecialCycleAnalysis(this.curBlock)) {
                    infoTmpCopy.cumulOr(this.infoTmpCycle);
                }
                BoolVector refInfo = this.infosDown.retrieve(refBlock);
                if (infoTmpCopy.get(mpIndex) && !refInfo.get(mpIndex)) {
                    refInfo.set(mpIndex, true);
                    result = true;
                }
            }
        }
        return result;
    }

    @Override
    protected boolean compareUpstreamValues() {
        if (this.cgPhase == 1) {
            BoolMatrix oldDep = this.depsIn.retrieve(this.curBlock);
            if (oldDep == null || !this.tmpDep.equalsBoolMatrix(oldDep)) {
                this.depsIn.store(this.curBlock, this.tmpDep.copy());
                return true;
            }
            return false;
        }
        return this.compareWithStorage(this.infoTmp, this.infoTmpCycle, this.nDRZ, this.infosUp, this.infosCycleUp);
    }

    @Override
    protected boolean compareChannelZoneDataUpstream(int mpZone, Block refBlock) {
        boolean result = false;
        int mpIndex = this.extendedDeclaredToVectorIndex(mpZone, this.diffKind, this.curBlockMap);
        if (mpIndex >= 0 && this.cgPhase == 2) {
            BoolVector infoTmpCopy = this.infoTmp.copy();
            if (ADActivityAnalyzer.runSpecialCycleAnalysis(this.curBlock)) {
                infoTmpCopy.cumulOr(this.infoTmpCycle);
            }
            BoolVector refInfo = this.infosUp.retrieve(refBlock);
            if (infoTmpCopy.get(mpIndex) && !refInfo.get(mpIndex)) {
                refInfo.set(mpIndex, true);
                result = true;
            }
        }
        return result;
    }

    @Override
    protected boolean propagateValuesForwardThroughBlock() {
        if (this.cgPhase == 1) {
            BoolMatrix depThrough = this.depsThrough.retrieve(this.curBlock);
            if (depThrough != null) {
                this.tmpDep.rows = depThrough.times((BoolMatrix)this.tmpDep).rows;
                return true;
            }
            this.tmpDep = null;
            return false;
        }
        return this.propagateAndStoreVariednessThroughBlock(null);
    }

    private boolean propagateAndStoreVariednessThroughBlock(TapList<BoolVector> recordList) {
        TapList<Instruction> instructions = this.curBlock.instructions;
        if (TapEnv.traceCurAnalysis()) {
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace("--- Going down through Block " + this.curBlock + " ---");
        }
        if (this.infoTmpCycle != null) {
            this.infoTmp.cumulOr(this.infoTmpCycle);
            this.infoTmpCycle = null;
        }
        if (TapEnv.traceCurAnalysis()) {
            TapEnv.printlnOnTrace("    Varied:" + this.infoTmp);
        }
        if (recordList != null) {
            BoolVector recordInfo = this.infoTmp.copy();
            recordList = recordList.placdl(recordInfo);
        }
        if (ADActivityAnalyzer.runSpecialCycleAnalysis(this.curBlock)) {
            this.curInstruction = (Instruction)instructions.head;
            Tree doTree = this.curInstruction.tree.down(3);
            if (this.infoTmp != null) {
                this.variednessThroughExpression(doTree.down(2), this.infoTmp, null, false);
            }
            if (this.infoTmpCycle != null) {
                BoolVector infoTmpCycleMemo = this.infoTmpCycle.copy();
                TapIntList localizedZones = this.curSymbolTable.getDeclaredKindZones(((HeaderBlock)this.curBlock).localizedZones, this.diffKind, true);
                this.infoTmpCycle.setDeclared(localizedZones, this.curBlockMap, false);
                if (this.infoTmp != null) {
                    this.infoTmpCycle.cumulOr(this.infoTmp);
                }
                if (this.infoTmp != null) {
                    infoTmpCycleMemo.cumulOr(this.infoTmp);
                }
                this.infoTmp = infoTmpCycleMemo;
            } else {
                this.infoTmpCycle = this.infoTmp.copy();
            }
        }
        ToBool arrives = new ToBool(true);
        ToBool arrivesC = new ToBool(true);
        while (instructions != null) {
            this.curInstruction = (Instruction)instructions.head;
            if (recordList != null) {
                this.checkVariedIO(this.infoTmp, this.curInstruction.tree);
                this.checkVariedBadCast(this.infoTmp, this.curInstruction.tree, this.curUnit);
            }
            if (this.infoTmp != null) {
                this.variednessThroughExpression(this.curInstruction.tree, this.infoTmp, arrives, false);
            }
            if (this.infoTmpCycle != null) {
                this.variednessThroughExpression(this.curInstruction.tree, this.infoTmpCycle, arrivesC, false);
            }
            if (TapEnv.traceCurAnalysis()) {
                TapEnv.printlnOnTrace("    Varied:" + this.infoTmp + (this.infoTmpCycle == null ? "" : " (cycling:" + this.infoTmpCycle + ')'));
            }
            if (recordList != null) {
                assert (this.infoTmp != null);
                BoolVector recordInfo = this.infoTmp.copy();
                if (this.infoTmpCycle != null) {
                    recordInfo.cumulOr(this.infoTmpCycle);
                }
                recordList = recordList.placdl(recordInfo);
            }
            instructions = instructions.tail;
        }
        this.curInstruction = null;
        return arrives.get() && arrivesC.get();
    }

    @Override
    protected boolean propagateValuesBackwardThroughBlock() {
        return this.propagateAndStoreUsefulnessThroughBlock(null);
    }

    private boolean propagateAndStoreUsefulnessThroughBlock(TapList<BoolVector> recordList) {
        if (TapEnv.traceCurAnalysis()) {
            TapEnv.printlnOnTrace();
            TapEnv.printlnOnTrace("--- Going up through Block " + this.curBlock + " ---");
        }
        if (this.infoTmpCycle != null) {
            this.infoTmp.cumulOr(this.infoTmpCycle);
            this.infoTmpCycle = null;
        }
        TapList<Instruction> instructions = this.curBlock.instructions;
        Instruction initialDo = null;
        boolean runSpecialCycleAnalysis = ADActivityAnalyzer.runSpecialCycleAnalysis(this.curBlock);
        Tree doTree = null;
        if (runSpecialCycleAnalysis) {
            initialDo = (Instruction)instructions.head;
            if (initialDo != null) {
                doTree = initialDo.tree.down(3);
            }
            instructions = instructions.tail;
        }
        instructions = TapList.reverse(instructions);
        if (TapEnv.traceCurAnalysis()) {
            TapEnv.printlnOnTrace("    Useful:" + this.infoTmp);
        }
        if (recordList != null) {
            BoolVector recordInfo = this.infoTmp.copy();
            recordList.tail = new TapList<BoolVector>(recordInfo, null);
        }
        ToBool arrives = new ToBool(true);
        ToBool arrivesC = new ToBool(true);
        while (instructions != null) {
            this.curInstruction = (Instruction)instructions.head;
            if (recordList != null) {
                this.checkUsefulIO(this.infoTmp, this.curInstruction.tree);
                this.checkUsefulBadCast(this.infoTmp, this.curInstruction.tree, this.curUnit);
            }
            this.usefulnessThroughExpression(this.curInstruction.tree, null, this.infoTmp, arrives, false);
            if (runSpecialCycleAnalysis && this.infoTmpCycle != null) {
                this.usefulnessThroughExpression(this.curInstruction.tree, null, this.infoTmpCycle, arrivesC, false);
            }
            if (TapEnv.traceCurAnalysis()) {
                TapEnv.printlnOnTrace("    Useful:" + this.infoTmp + (this.infoTmpCycle == null ? "" : " (cycling:" + this.infoTmpCycle + ')'));
            }
            if (recordList != null) {
                BoolVector recordInfo = this.infoTmp.copy();
                if (this.infoTmpCycle != null) {
                    recordInfo.cumulOr(this.infoTmpCycle);
                }
                recordList.tail = new TapList<BoolVector>(recordInfo, recordList.tail);
            }
            instructions = instructions.tail;
        }
        if (initialDo != null) {
            this.curInstruction = initialDo;
            this.usefulnessThroughExpression(doTree.down(1), null, this.infoTmp, arrives, false);
            this.usefulnessThroughExpression(doTree.down(3), null, this.infoTmp, arrives, false);
            this.usefulnessThroughExpression(doTree.down(4), null, this.infoTmp, arrives, false);
            if (runSpecialCycleAnalysis && this.infoTmpCycle != null) {
                this.usefulnessThroughExpression(doTree.down(1), null, this.infoTmpCycle, arrivesC, false);
                this.usefulnessThroughExpression(doTree.down(3), null, this.infoTmpCycle, arrivesC, false);
                this.usefulnessThroughExpression(doTree.down(4), null, this.infoTmpCycle, arrivesC, false);
            }
        }
        BoolVector infoTmpCycleUp = null;
        if (runSpecialCycleAnalysis) {
            if (this.infoTmpCycle != null) {
                infoTmpCycleUp = this.infoTmpCycle.copy();
                TapIntList localizedZones = this.curSymbolTable.getDeclaredKindZones(((HeaderBlock)this.curBlock).localizedZones, this.diffKind, true);
                infoTmpCycleUp.setDeclared(localizedZones, this.curBlockMap, false);
            } else {
                infoTmpCycleUp = new BoolVector(this.nDRZ);
            }
            if (this.infoTmp != null) {
                infoTmpCycleUp.cumulOr(this.infoTmp);
            }
            if (this.infoTmp != null) {
                if (this.infoTmpCycle == null) {
                    this.infoTmpCycle = new BoolVector(this.nDRZ);
                }
                this.infoTmpCycle.cumulOr(this.infoTmp);
            }
            this.infoTmp = this.infoTmpCycle;
        }
        this.infoTmpCycle = infoTmpCycleUp;
        if (initialDo != null) {
            this.usefulnessThroughExpression(doTree.down(2), null, this.infoTmp, arrives, false);
            if (TapEnv.traceCurAnalysis()) {
                TapEnv.printlnOnTrace("    Useful:" + this.infoTmp + (this.infoTmpCycle == null ? "" : " (cycling:" + this.infoTmpCycle + ')'));
            }
            if (recordList != null) {
                BoolVector recordInfo = this.infoTmp.copy();
                if (this.infoTmpCycle != null) {
                    recordInfo.cumulOr(this.infoTmpCycle);
                }
                recordList.tail = new TapList<BoolVector>(recordInfo, recordList.tail);
            }
        }
        this.curInstruction = null;
        return true;
    }

    @Override
    protected void terminateFGForBlock() {
        if (this.cgPhase == 2) {
            TapList<Object> toInfos = new TapList<Object>(null, null);
            if (this.fgPhase == 1) {
                this.infoTmp = this.infosUp.retrieve(this.curBlock);
                this.infoTmpCycle = this.infosCycleUp.retrieve(this.curBlock);
            } else {
                this.infoTmp = this.infosDown.retrieve(this.curBlock);
                this.infoTmpCycle = this.infosCycleDown.retrieve(this.curBlock);
            }
            if (this.infoTmp == null) {
                this.infoTmp = new BoolVector(this.nDRZ);
            }
            if (this.fgPhase == 1) {
                this.propagateAndStoreVariednessThroughBlock(toInfos);
            } else {
                this.propagateAndStoreUsefulnessThroughBlock(toInfos);
            }
            this.curUnitInfos.store(this.curBlock, toInfos.tail);
        }
    }

    @Override
    protected void terminateTermBlock() {
        if (this.cgPhase == 2) {
            TapList<BoolVector> termBlockInfos = this.curUnitInfos.retrieve(this.curBlock);
            if (termBlockInfos == null) {
                termBlockInfos = new TapList<Object>(null, new TapList<Object>(null, null));
                this.curUnitInfos.store(this.curBlock, termBlockInfos);
            }
            if (this.fgPhase == 1) {
                BoolVector termInfo = this.infosUp.retrieve(this.curBlock);
                termInfo = termInfo == null ? new BoolVector(this.nDRZ) : termInfo.copy();
                BoolVector termCycleInfo = this.infosCycleUp.retrieve(this.curBlock);
                if (termCycleInfo != null) {
                    termInfo.cumulOr(termCycleInfo);
                }
                termBlockInfos.head = termInfo;
            } else {
                TapList<BoolVector> toLastInfo = TapList.toLast(termBlockInfos);
                if (toLastInfo != null) {
                    BoolVector termInfo = this.infosDown.retrieve(this.curBlock);
                    termInfo = termInfo == null ? new BoolVector(this.nDRZ) : termInfo.copy();
                    BoolVector termCycleInfo = this.infosCycleDown.retrieve(this.curBlock);
                    if (termCycleInfo != null) {
                        termInfo.cumulOr(termCycleInfo);
                    }
                    toLastInfo.head = termInfo;
                }
            }
        }
    }

    @Override
    protected boolean terminateUnit() {
        if (this.cgPhase == 1) {
            this.tmpDep = this.accumulateDepIn(this.curUnit.exitBlock());
            this.depsIn = null;
            this.depsOut = null;
            this.depsThrough = null;
            if (this.tmpDep == null) {
                return false;
            }
            if (TapEnv.traceCurAnalysis()) {
                TapEnv.printlnOnTrace(" == AD Deps entering exit Block :");
                TapEnv.dumpBoolMatrixOnTrace(this.tmpDep, this.entryMap, this.entryMap);
                TapEnv.printlnOnTrace();
            }
            BoolMatrix unitDep = this.propagateUnitDataOutside(this.tmpDep, this.diffKind);
            BoolMatrix oldUnitDep = this.dependencies.retrieve(this.curUnit);
            if (oldUnitDep != null && unitDep.equalsBoolMatrix(oldUnitDep)) {
                return false;
            }
            this.dependencies.store(this.curUnit, unitDep);
            if (TapEnv.traceCurAnalysis()) {
                TapEnv.printlnOnTrace(" == Public AD Deps effect stored for unit " + this.curUnit.name() + " is:");
                TapEnv.dumpOnTrace(unitDep);
                TapEnv.printlnOnTrace();
            }
            return true;
        }
        if (this.fgPhase != 3) {
            this.curUnitInfos.store(this.curUnit.entryBlock(), new TapList<BoolVector>(this.infosDown.retrieve(this.curUnit.entryBlock()), null));
            this.curUnitInfos.store(this.curUnit.exitBlock(), new TapList<BoolVector>(this.infosUp.retrieve(this.curUnit.exitBlock()), null));
        }
        return false;
    }

    @Override
    protected void terminateCGForUnit() {
        if (this.curUnit.hasSource()) {
            TapList<ActivityPattern> activityPatterns = this.curUnit.activityPatterns;
            while (activityPatterns != null) {
                this.curActivity = (ActivityPattern)activityPatterns.head;
                this.curUnit.activeCalledNames = null;
                if (this.curActivity.activities() != null) {
                    this.presetActivityAnnotations(this.curUnit, this.curActivity);
                }
                activityPatterns = activityPatterns.tail;
            }
        }
    }

    private BoolVector sideEffectInCaller(Unit unit) {
        BoolVector sideEffectInCaller = new BoolVector(unit.paramElemsNb());
        TapList<CallArrow> callers = unit.callers();
        while (callers != null) {
            CallArrow callerArrow = (CallArrow)callers.head;
            boolean somethingActive = false;
            TapList<ActivityPattern> activityPatterns = callerArrow.origin.activityPatterns;
            while (activityPatterns != null && !somethingActive) {
                if (((ActivityPattern)activityPatterns.head).activities() != null) {
                    somethingActive = true;
                }
                activityPatterns = activityPatterns.tail;
            }
            if (somethingActive) {
                PublicInfo[] translator = callerArrow.translator();
                for (int i = translator.length - 1; i >= 0; --i) {
                    if (translator[i] == null || translator[i].kind() != 8 || !this.isHiddenAllocatable(translator[i].ranks(0), callerArrow.origin)) continue;
                    sideEffectInCaller.set(i, true);
                }
            }
            callers = callers.tail;
        }
        return sideEffectInCaller;
    }

    private BoolVector sideEffectInUnit(Unit unit) {
        BoolVector sideEffectInUnit = new BoolVector(unit.paramElemsNb());
        PublicInfo[] translator = unit.translator;
        if (translator == null) {
            sideEffectInUnit.setTrue();
        } else {
            for (int i = translator.length - 1; i >= 0; --i) {
                if (translator[i] == null || translator[i].kind() != 8 || !this.isHiddenAllocatable(translator[i].ranks(0), unit)) continue;
                sideEffectInUnit.set(i, true);
            }
        }
        return sideEffectInUnit;
    }

    private boolean isHiddenAllocatable(TapIntList declaredZones, Unit unit) {
        boolean hidden = false;
        SymbolTable symbolTable = unit.privateSymbolTable();
        if (symbolTable == null) {
            symbolTable = unit.publicSymbolTable();
        }
        while (!hidden && declaredZones != null) {
            WrapperTypeSpec allocatedType;
            ZoneInfo zoneInfo = symbolTable.declaredZoneInfo(declaredZones.head, 0);
            if (zoneInfo == null || zoneInfo.isHidden) {
                return true;
            }
            Tree allocVar = ILUtils.getAllocatedRef(zoneInfo.accessTree);
            if (allocVar != null && ((allocatedType = symbolTable.typeOf(allocVar)) == null || allocatedType.baseTypeName() == null || allocatedType.baseTypeName().equals("Undefined"))) {
                hidden = true;
            }
            declaredZones = declaredZones.tail;
        }
        return hidden;
    }

    private void filterVariedUsefulWithDeps(BoolVector varieds, BoolVector usefuls, Unit unit, DiffPattern thisDiffPattern, BoolVector collectedFilteredActives) {
        boolean isRoot;
        BoolMatrix unitPublicDeps = ADActivityAnalyzer.getPublicDeps(unit, this.dependencies, this.diffKind);
        unitPublicDeps = ADActivityAnalyzer.filterByValue(unitPublicDeps, unit);
        boolean bl = isRoot = thisDiffPattern != null;
        if (!(unitPublicDeps == null || isRoot && TapEnv.get().fixInterface || TapEnv.debugActivity() || !TapEnv.doUsefulness())) {
            int shapeLength = unit.paramElemsNb();
            if (TapEnv.traceCurAnalysis()) {
                TapEnv.printlnOnTrace("  NOW FILTERING:[" + varieds.toString(shapeLength) + "] -> [" + usefuls.toString(shapeLength) + "] through unit " + unit + " (root:" + isRoot + ')');
                TapEnv.printlnOnTrace("   UNIT's (DIFF-)DEPS:");
                TapEnv.dumpOnTrace(unitPublicDeps);
            }
            BoolVector initVarieds = isRoot ? varieds.copy() : null;
            BoolVector initUsefuls = isRoot ? usefuls.copy() : null;
            this.updateVariedUsefulWithDeps(varieds, usefuls, unit, unitPublicDeps, collectedFilteredActives);
            if (isRoot) {
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("interm.result:  [" + varieds.toString(shapeLength) + "] -> [" + usefuls.toString(shapeLength) + "]");
                    TapEnv.printlnOnTrace("    now adding diff vars in filtered because root unit!");
                }
                this.addDiffVarsForRootUnit(varieds, usefuls, unit.publicRankOfResult(), unitPublicDeps, unit);
                BoolVector removed = varieds.not();
                removed.cumulAnd(initVarieds);
                String messageNames = ADActivityAnalyzer.namesWithProperty(thisDiffPattern.indepsPathNames(), thisDiffPattern.indepsPathZones(), removed);
                if (messageNames != null) {
                    TapEnv.commandWarning(13, "Input variable(s) " + messageNames + " have no differentiable influence in " + unit.name() + ": removed from independents");
                }
                removed = usefuls.not();
                removed.cumulAnd(initUsefuls);
                messageNames = ADActivityAnalyzer.namesWithProperty(thisDiffPattern.depsPathNames(), thisDiffPattern.depsPathZones(), removed);
                if (messageNames != null) {
                    TapEnv.commandWarning(13, "Output variable(s) " + messageNames + " are not influenced differentiably in " + unit.name() + ": removed from dependents");
                }
                BoolVector added = initVarieds.not();
                added.cumulAnd(varieds);
                messageNames = ADActivityAnalyzer.namesOfPublicZones(added, unit);
                if (messageNames != null) {
                    TapEnv.commandWarning(13, "Input variable(s) " + messageNames + " have their derivative modified in " + unit.name() + ": added to independents");
                }
                added = initUsefuls.not();
                added.cumulAnd(usefuls);
                messageNames = ADActivityAnalyzer.namesOfPublicZones(added, unit);
                if (messageNames != null) {
                    TapEnv.commandWarning(13, "Output variable(s) " + messageNames + " have their derivative modified in " + unit.name() + ": added to dependents");
                }
            }
            if (TapEnv.traceCurAnalysis()) {
                TapEnv.printlnOnTrace("       FILTERED:[" + varieds.toString(shapeLength) + "] -> [" + usefuls.toString(shapeLength) + "]" + (collectedFilteredActives == null ? "" : " plus static actives: [" + collectedFilteredActives.toString(shapeLength) + "]"));
            }
        }
    }

    private void updateVariedUsefulWithDeps(BoolVector variedOnCall, BoolVector usefulOnExit, Unit unit, BoolMatrix deps, BoolVector collectedFilteredActives) {
        int i;
        if (collectedFilteredActives != null) {
            collectedFilteredActives.setCopy(variedOnCall);
            if (usefulOnExit == null) {
                System.out.println("Mystery: usefulOnExit is " + usefulOnExit + " in updateVariedUsefulWithDeps()");
                TapEnv.toolError("Mystery: usefulOnExit is " + usefulOnExit + " in updateVariedUsefulWithDeps()");
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("Mystery: usefulOnExit is " + usefulOnExit + " in updateVariedUsefulWithDeps()");
                }
            }
            collectedFilteredActives.cumulAnd(usefulOnExit);
        }
        BoolMatrix depsNoDiag = deps.copy();
        for (int i2 = deps.nRows - 1; i2 >= 0; --i2) {
            depsNoDiag.set(i2, i2, false);
        }
        BoolVector rowsFromNoVaried = depsNoDiag.times(variedOnCall);
        BoolVector colsToNoUseful = depsNoDiag.leftTimes(usefulOnExit);
        for (i = deps.nRows - 1; i >= 0; --i) {
            if (!colsToNoUseful.get(i) && !usefulOnExit.get(i)) {
                variedOnCall.set(i, false);
            }
            if (!rowsFromNoVaried.get(i) && !variedOnCall.get(i)) {
                usefulOnExit.set(i, false);
            }
            if (!deps.isImplicitIdentityRow(i) || rowsFromNoVaried.get(i) || colsToNoUseful.get(i)) continue;
            variedOnCall.set(i, false);
            usefulOnExit.set(i, false);
        }
        this.putBackSharingZones(variedOnCall, usefulOnExit, unit);
        if (collectedFilteredActives != null) {
            collectedFilteredActives.cumulMinus(variedOnCall);
            collectedFilteredActives.cumulMinus(usefulOnExit);
            for (i = unit.externalShape.length - 1; i >= 0; --i) {
                if (!collectedFilteredActives.get(i) || unit.externalShape[i] == null || unit.externalShape[i].kindZoneNb(this.diffKind) != -1) continue;
                collectedFilteredActives.set(i, false);
            }
        }
    }

    public void putBackSharingZones(BoolVector variedOnCall, BoolVector usefulOnExit, Unit unit) {
        if (unit != null && unit.publicSymbolTable() != null && unit.hasSource()) {
            SymbolTable symbolTable = unit.publicSymbolTable();
            int[] unitVectorMap = ADActivityAnalyzer.makeMap3(unit, this.diffKind);
            BoolVector reallyVaried = ADActivityAnalyzer.propagateUnitDataInside(variedOnCall, this.diffKind, unitVectorMap, unit);
            BoolVector reallyUseful = ADActivityAnalyzer.propagateUnitDataInside(usefulOnExit, this.diffKind, unitVectorMap, unit);
            BoolVector extendedVaried = reallyVaried.copy();
            BoolVector extendedUseful = reallyUseful.copy();
            for (int i = ADActivityAnalyzer.mapSize(unitVectorMap) - 1; i >= 0; --i) {
                TapList<String> otherNames;
                if (!reallyVaried.get(i) && !reallyUseful.get(i)) continue;
                ZoneInfo iInfo = ADActivityAnalyzer.vectorIndexToZoneInfo(i, ADActivityAnalyzer.getMapClass(i, unitVectorMap), this.diffKind, unitVectorMap, symbolTable);
                TapList<String> tapList = otherNames = iInfo == null ? null : iInfo.variableNames();
                while (otherNames != null) {
                    VariableDecl variableDecl = symbolTable.getVariableDecl((String)otherNames.head);
                    if (variableDecl != null) {
                        TapList<?> otherZones = TapList.getSetFieldLocation(variableDecl.zones(), iInfo.accessTree, false);
                        TapIntList zz2 = ZoneInfo.listAllZones(otherZones, false);
                        zz2 = ADActivityAnalyzer.mapExtendedDeclaredToVectorIndex(zz2, this.diffKind, unitVectorMap, symbolTable, null);
                        if (reallyVaried.get(i)) {
                            extendedVaried.set(zz2, true);
                        }
                        if (reallyUseful.get(i)) {
                            extendedUseful.set(zz2, true);
                        }
                    }
                    otherNames = otherNames.tail;
                }
            }
            variedOnCall.cumulOr(ADActivityAnalyzer.propagateUnitDataOutside(extendedVaried, this.diffKind, unitVectorMap, false, unit));
            usefulOnExit.cumulOr(ADActivityAnalyzer.propagateUnitDataOutside(extendedUseful, this.diffKind, unitVectorMap, false, unit));
        }
    }

    private void addDiffVarsForRootUnit(BoolVector variedOnCall, BoolVector usefulOnExit, TapIntList resultRks, BoolMatrix deps, Unit unit) {
        if (TapEnv.modeIsTangent() || TapEnv.debugAdMode() == -1) {
            usefulOnExit.cumulOr(variedOnCall.and(ADActivityAnalyzer.getRootModifiedZones(deps, variedOnCall, unit)));
        }
        if (TapEnv.modeIsAdjoint() || TapEnv.debugAdMode() == -1) {
            variedOnCall.cumulOr(usefulOnExit.and(ADActivityAnalyzer.getRootModifiedZonesT(deps, usefulOnExit)));
            while (resultRks != null) {
                variedOnCall.set(resultRks.head, false);
                resultRks = resultRks.tail;
            }
        }
    }

    public static BoolVector getUpdateModifiedZones(BoolMatrix deps, BoolVector variedOnCall, Unit unit) {
        int i;
        BoolVector result = deps.times(variedOnCall).or(variedOnCall);
        for (i = deps.nRows - 1; i >= 0; --i) {
            ZoneInfo zi;
            if (!result.get(i) || (zi = unit.paramElemZoneInfo(i)) == null || !zi.passesByValue(unit, unit.language())) continue;
            result.set(i, false);
        }
        for (i = deps.nRows - 1; i >= 0; --i) {
            if (deps.rows[i] != null) continue;
            result.set(i, false);
        }
        return result;
    }

    private BoolVector getFinalModifiedZones(BoolMatrix deps, BoolVector variedOnCall, BoolVector usefulOnExit) {
        BoolVector rowZero = new BoolVector(deps.nRows);
        BoolVector rowNonZeroNonId = new BoolVector(deps.nRows);
        rowZero.setFalse();
        rowNonZeroNonId.setFalse();
        for (int i = deps.nRows - 1; i >= 0; --i) {
            if (deps.rows[i] == null) continue;
            if (deps.rows[i].isFalse(deps.nRows)) {
                rowZero.set(i, true);
                continue;
            }
            rowNonZeroNonId.set(i, true);
        }
        return variedOnCall.and(rowZero).or(usefulOnExit.and(rowNonZeroNonId));
    }

    private static BoolVector getRootModifiedZones(BoolMatrix deps, BoolVector variedOnCall, Unit unit) {
        return ADActivityAnalyzer.getUpdateModifiedZones(deps, variedOnCall, unit);
    }

    public static BoolVector getUpdateModifiedZonesT(BoolMatrix deps, BoolVector usefulOnExit) {
        BoolVector columnNotIdentity = new BoolVector(deps.nCols);
        for (int i = deps.nRows - 1; i >= 0; --i) {
            if (deps.rows[i] == null) continue;
            columnNotIdentity.set(i, true);
            if (!usefulOnExit.get(i)) continue;
            columnNotIdentity.cumulOr(deps.rows[i]);
        }
        BoolVector result = deps.leftTimes(usefulOnExit).or(usefulOnExit);
        result.cumulAnd(columnNotIdentity);
        return result;
    }

    private BoolVector getFinalModifiedZonesT(BoolMatrix deps, BoolVector variedOnCall, BoolVector usefulOnExit) {
        BoolVector activeColumns = new BoolVector(deps.nCols);
        BoolVector nonZeroColumns = new BoolVector(deps.nCols);
        for (int i = deps.nRows - 1; i >= 0; --i) {
            if (deps.rows[i] == null) {
                nonZeroColumns.set(i, true);
                continue;
            }
            nonZeroColumns.cumulOr(deps.rows[i]);
            if (!usefulOnExit.get(i)) continue;
            activeColumns.cumulOr(deps.rows[i]);
        }
        return nonZeroColumns.and(usefulOnExit).or(activeColumns.and(variedOnCall));
    }

    private static BoolVector getRootModifiedZonesT(BoolMatrix deps, BoolVector usefulOnExit) {
        return ADActivityAnalyzer.getUpdateModifiedZonesT(deps, usefulOnExit);
    }

    protected static void setOnceActiveZonesAndAnnotateDiffDeclsAndTypes(BoolVector activeZones, SymbolTable symbolTable, int kind, int thisKindNDZ) {
        ZoneInfo zoneInfo;
        if (activeZones != null) {
            for (int i = thisKindNDZ; i >= 0; --i) {
                zoneInfo = symbolTable.declaredZoneInfo(i, kind);
                if (zoneInfo == null || !activeZones.get(i)) continue;
                zoneInfo.setOnceActive();
            }
        }
        for (int i = symbolTable.declaredZonesNb(kind) - 1; i >= 0; --i) {
            boolean modified;
            zoneInfo = symbolTable.declaredZoneInfo(i, kind);
            if (zoneInfo == null || zoneInfo.accessTree == null || zoneInfo.realZoneNb == -1 && zoneInfo.ptrZoneNb == -1 && TapEnv.diffKind() != 0 || !zoneInfo.isOnceActive()) continue;
            Tree accessTree = zoneInfo.accessTree;
            String accessName = ILUtils.baseName(accessTree);
            if (accessName == null || !(zoneInfo.ownerSymbolDecl instanceof VariableDecl)) {
                if (zoneInfo.rootAccessType == null) continue;
                TapList<Object> newActivityInfo = new TapList<Object>(null, null);
                TapList<?> toLeaf = TapList.getSetFieldLocation(newActivityInfo, zoneInfo.accessTree, true);
                toLeaf.head = Boolean.TRUE;
                zoneInfo.rootAccessType.cumulActiveParts(newActivityInfo, symbolTable);
                continue;
            }
            VariableDecl localVarDecl = symbolTable.getVariableDecl(accessName);
            VariableDecl ownerVarDecl = (VariableDecl)zoneInfo.ownerSymbolDecl;
            if (ownerVarDecl != null) {
                if (!zoneInfo.isHidden) {
                    ownerVarDecl.setActive();
                }
                if (modified = ownerVarDecl.cumulActiveField(accessTree)) {
                    ADActivityAnalyzer.setActiveTypeDecl(ownerVarDecl, symbolTable);
                    ownerVarDecl.type().cumulActiveParts(ownerVarDecl.activityInfo, symbolTable);
                }
            }
            if (localVarDecl == null || ownerVarDecl == null || localVarDecl == ownerVarDecl || !TapList.sameTree(localVarDecl.zones(), ownerVarDecl.zones())) continue;
            if (!zoneInfo.isHidden) {
                localVarDecl.setActive();
            }
            if (!(modified = localVarDecl.cumulActiveField(accessTree))) continue;
            ADActivityAnalyzer.setActiveTypeDecl(localVarDecl, symbolTable);
            localVarDecl.type().cumulActiveParts(localVarDecl.activityInfo, symbolTable);
        }
    }

    private static void setActiveTypeDecl(VariableDecl variableDecl, SymbolTable symbolTable) {
        WrapperTypeSpec typeSpec = variableDecl.type().baseTypeSpec(false);
        VariableDecl cRootVarDecl = TapEnv.get().origCallGraph().cRootSymbolTable().getVariableDecl(variableDecl.symbol);
        if (cRootVarDecl != null) {
            cRootVarDecl.setActive();
        }
        if (variableDecl.importedFrom != null) {
            ((SymbolDecl)variableDecl.importedFrom.first).setActive();
        }
        if (TypeSpec.isA(typeSpec.wrappedType, 21)) {
            String typeName = typeSpec.wrappedType.typeDeclName();
            if (typeName == null) {
                typeName = ((CompositeTypeSpec)typeSpec.wrappedType).name;
            }
            if (typeName != null) {
                TypeDecl typeDecl = symbolTable.getTypeDecl(typeName);
                if (typeDecl == null && (typeDecl = ADActivityAnalyzer.getTypeDeclInModules(symbolTable.unit.importedModules(), typeName)) == null) {
                    typeDecl = ADActivityAnalyzer.getTypeDeclInModules(symbolTable.unit.otherImportedModules, typeName);
                }
                if (typeDecl != null) {
                    typeDecl.setActive();
                }
            }
        }
    }

    private static TypeDecl getTypeDeclInModules(TapList<Unit> modules, String typeName) {
        TypeDecl result = null;
        while (modules != null && result == null) {
            result = ((Unit)modules.head).publicSymbolTable().getTypeDecl(typeName);
            if (result == null) {
                result = ((Unit)modules.head).privateSymbolTable().getTypeDecl(typeName);
            }
            modules = modules.tail;
        }
        return result;
    }

    private void mergeUsefulnessIntoVariedness(Unit unit, BlockStorage<TapList<BoolVector>> usefulnessesOut, BlockStorage<TapList<BoolVector>> variednessesIn) {
        TapList<Block> blocks = unit.allBlocks();
        this.setCurBlockEtc(unit.entryBlock());
        this.mergeUsefulnessIntoVariedness(usefulnessesOut.retrieve(unit.entryBlock()), variednessesIn.retrieve(unit.entryBlock()), unit.entryBlock().symbolTable);
        while (blocks != null) {
            Block block = (Block)blocks.head;
            this.setCurBlockEtc(block);
            this.mergeUsefulnessIntoVariedness(usefulnessesOut.retrieve(block), variednessesIn.retrieve(block), block.symbolTable);
            blocks = blocks.tail;
        }
        this.setCurBlockEtc(unit.exitBlock());
        this.mergeUsefulnessIntoVariedness(usefulnessesOut.retrieve(unit.exitBlock()), variednessesIn.retrieve(unit.exitBlock()), unit.exitBlock().symbolTable);
        this.setCurBlockEtc(null);
    }

    private void mergeUsefulnessIntoVariedness(TapList<BoolVector> usefulList, TapList<BoolVector> variedList, SymbolTable symbolTable) {
        while (variedList != null && usefulList != null) {
            if (!TapEnv.debugActivity() && TapEnv.doUsefulness()) {
                ((BoolVector)variedList.head).cumulAnd((BoolVector)usefulList.head);
            }
            ADActivityAnalyzer.setOnceActiveZonesAndAnnotateDiffDeclsAndTypes((BoolVector)variedList.head, symbolTable, this.diffKind, this.nDRZ);
            variedList = variedList.tail;
            usefulList = usefulList.tail;
        }
    }

    private void presetActivityAnnotations(Unit unit, ActivityPattern pattern) {
        if (TapEnv.traceCurAnalysis()) {
            TapEnv.printlnOnTrace(" Preset activity annotations on unit:" + this.curUnit + " with diffPattern " + pattern);
        }
        BlockStorage<TapList<BoolVector>> unitActivities = pattern.activities();
        BlockStorage<TapList<BoolVector>> unitUsefulnesses = pattern.usefulnesses();
        this.curUnitZonesOfVarsHaveDiff = pattern.zonesOfVarsHaveDiff();
        TapList<Block> inBlocks = new TapList<Block>(unit.exitBlock(), new TapList<Block>(unit.entryBlock(), unit.allBlocks()));
        boolean curAnalysisWasTraced = TapEnv.traceCurAnalysis();
        if (curAnalysisWasTraced) {
            TapEnv.setTraceCurAnalysis(false);
        }
        while (inBlocks != null) {
            Block block = (Block)inBlocks.head;
            this.presetActivityAnnotations(block, curAnalysisWasTraced, unitActivities.retrieve(block), unitUsefulnesses.retrieve(block));
            inBlocks = inBlocks.tail;
        }
        if (curAnalysisWasTraced) {
            TapEnv.setTraceCurAnalysis(true);
        }
        this.setFormalArgsActivity(pattern);
        this.setCurBlockEtc(unit.entryBlock());
        BoolVector activityAtBoundary = ((BoolVector)unitActivities.retrieve((Block)unit.entryBlock()).head).copy();
        activityAtBoundary.cumulOr((BoolVector)unitActivities.retrieve((Block)unit.exitBlock()).head);
        if (TapEnv.traceCurAnalysis()) {
            TapEnv.printlnOnTrace(" Activity at boundary of " + unit);
            TapEnv.printlnOnTrace("entry :" + unitActivities.retrieve((Block)unit.entryBlock()).head);
            TapEnv.printlnOnTrace(" exit :" + unitActivities.retrieve((Block)unit.exitBlock()).head);
        }
        ADActivityAnalyzer.setOnceActiveZonesAndAnnotateDiffDeclsAndTypes(activityAtBoundary, this.curSymbolTable, this.diffKind, this.nDRZ);
        this.setCurBlockEtc(null);
    }

    private void presetActivityAnnotations(Block block, boolean traceResults, TapList<BoolVector> blockActivities, TapList<BoolVector> blockUsefulnesses) {
        this.setCurBlockEtc(block);
        TapList<Instruction> instructions = this.curBlock.instructions;
        BoolVector downstreamActive = (BoolVector)blockActivities.head;
        blockActivities = blockActivities.tail;
        blockUsefulnesses = blockUsefulnesses.tail;
        int nbZonesForZonesOfVarsHaveDiff = block instanceof EntryBlock || block instanceof ExitBlock ? block.unit().publicSymbolTable().zonesNb(this.diffKind) : block.unit().privateSymbolTable().zonesNb(this.diffKind);
        this.curUnitZonesOfVarsHaveDiff.cumulOr(downstreamActive, nbZonesForZonesOfVarsHaveDiff);
        if (traceResults) {
            TapEnv.printlnOnTrace("   Block " + this.curBlock);
        }
        while (instructions != null) {
            if (blockActivities != null) {
                this.curInstruction = (Instruction)instructions.head;
                BoolVector upstreamActive = downstreamActive;
                downstreamActive = (BoolVector)blockActivities.head;
                blockActivities = blockActivities.tail;
                BoolVector downstreamUseful = (BoolVector)blockUsefulnesses.head;
                blockUsefulnesses = blockUsefulnesses.tail;
                if (this.curSymbolTable.isFormalParamsLevel() || this.curSymbolTable.basisSymbolTable().isFormalParamsLevel()) {
                    this.curUnitZonesOfVarsHaveDiff.cumulOr(downstreamActive);
                }
                Tree tree = this.curInstruction.tree;
                this.variednessThroughExpression(tree, upstreamActive.copy(), null, true);
                this.usefulnessThroughExpression(tree, null, downstreamUseful.copy(), null, true);
                this.presetActivityAnnotations(tree, false, false, false, upstreamActive, downstreamActive, downstreamUseful, false);
                if (traceResults) {
                    TapEnv.printlnOnTrace("     => " + ILUtils.toString(tree, this.curActivity));
                }
            }
            instructions = instructions.tail;
        }
        this.curInstruction = null;
    }

    private void setFormalArgsActivity(ActivityPattern pattern) {
        Tree headerTree = pattern.unit().entryBlock().headTree();
        assert (headerTree != null);
        Tree[] formalArgs = ILUtils.getArguments(headerTree).children();
        boolean[] formalArgsActivity = ADActivityAnalyzer.formalArgsActivity(pattern);
        for (int i = formalArgs.length - 1; i >= 0; --i) {
            SymbolDecl argDecl;
            String argName;
            if (!formalArgsActivity[i] || (argName = ILUtils.getIdentString(formalArgs[i])) == null || (argDecl = pattern.unit().privateSymbolTable().getSymbolDecl(argName)) == null) continue;
            argDecl.setActive();
        }
    }

    private TapList presetActivityAnnotations(Tree tree, boolean diffNeeded, boolean read, boolean written, BoolVector upstreamActive, BoolVector downstreamActive, BoolVector downstreamUseful, boolean insideRef) {
        if (tree != null) {
            TapList variedAnnot = (TapList)ActivityPattern.getAnnotationForActivityPattern(tree, this.curActivity, "Varied");
            TapList usefulAnnot = (TapList)ActivityPattern.getAnnotationForActivityPattern(tree, this.curActivity, "Useful");
            ActivityPattern.removeAnnotationForActivityPattern(tree, this.curActivity, "Varied");
            ActivityPattern.removeAnnotationForActivityPattern(tree, this.curActivity, "Useful");
            TapList<?> activTree = null;
            if (TapList.oneTrue(variedAnnot) && TapList.oneTrue(usefulAnnot)) {
                activTree = TapList.copyTree(variedAnnot);
                activTree = TapList.cumulWithOper(activTree, usefulAnnot, 92);
            }
            if (TapEnv.valid() && tree.opCode() == 98) {
                diffNeeded = true;
            }
            TapIntList referencedZones = null;
            boolean active = false;
            switch (tree.opCode()) {
                case 14: 
                case 63: 
                case 125: 
                case 150: 
                case 190: {
                    this.presetActivityAnnotations(tree.down(1), false, false, true, upstreamActive, downstreamActive, downstreamUseful, false);
                    this.presetActivityAnnotations(tree.down(2), diffNeeded || ADActivityAnalyzer.isAnnotatedActive(this.curActivity, tree.down(1)), true, false, upstreamActive, downstreamActive, downstreamUseful, false);
                    if (!ADActivityAnalyzer.isAnnotatedActive(this.curActivity, tree.down(2))) break;
                    ADActivityAnalyzer.setAnnotatedActive(this.curActivity, tree);
                    break;
                }
                case 9: 
                case 11: 
                case 75: 
                case 96: 
                case 151: {
                    VariableDecl varDecl;
                    String pointerName;
                    TapList<?> accessibleZoneTree;
                    ToBool total = new ToBool(false);
                    if (!insideRef) {
                        referencedZones = this.curSymbolTable.listOfZonesOfValue(tree, total, this.curInstruction);
                    }
                    if ((accessibleZoneTree = this.curSymbolTable.treeOfZonesOfValue(tree, total, this.curInstruction, null)) != null) {
                        accessibleZoneTree = TapList.copyTree(accessibleZoneTree);
                        this.includePointedElementsInTree(accessibleZoneTree, null, null, true, false, true);
                    }
                    TapIntList accessibleZones = ZoneInfo.listAllZones(accessibleZoneTree, true);
                    TapIntList accessibleDiffKindVectorIndices = DataFlowAnalyzer.mapExtendedDeclaredToVectorIndex(accessibleZones, this.diffKind, this.curBlockMap, this.curSymbolTable, null);
                    boolean bl = active = read && diffNeeded && upstreamActive != null && upstreamActive.intersects(accessibleDiffKindVectorIndices) && TapList.oneTrue(activTree) || written && downstreamActive != null && downstreamActive.intersects(accessibleDiffKindVectorIndices);
                    if (tree.opCode() != 96) {
                        this.presetActivityAnnotations(tree.down(1), false, false, false, upstreamActive, downstreamActive, downstreamUseful, true);
                    }
                    if (tree.opCode() == 9 || tree.opCode() == 151) {
                        this.presetActivityAnnotations(tree.down(2), false, true, false, upstreamActive, downstreamActive, downstreamUseful, false);
                    }
                    if (!active) break;
                    ADActivityAnalyzer.setAnnotatedActive(this.curActivity, tree);
                    Tree activeRoot = tree;
                    if (tree.opCode() == 151) {
                        activeRoot = tree.down(1);
                        if (activeRoot != null && (activeRoot.opCode() == 3 || activeRoot.opCode() == 182) && TypeSpec.isA(this.curSymbolTable.typeOf(activeRoot.down(1)), 6)) {
                            activeRoot = activeRoot.down(1);
                        }
                        if (activeRoot != null && activeRoot.opCode() == 3 && TypeSpec.isA(this.curSymbolTable.typeOf(activeRoot.down(2)), 6)) {
                            activeRoot = activeRoot.down(2);
                        }
                    }
                    if (activeRoot != null && (pointerName = ILUtils.baseName(activeRoot)) != null && (varDecl = this.curSymbolTable.getVariableDecl(pointerName)) != null) {
                        varDecl.setActive();
                    }
                    TapIntList extendedZones = this.curSymbolTable.listOfZonesOfValue(tree, null, this.curInstruction);
                    while (extendedZones != null) {
                        if (extendedZones.head < this.curUnit.privateSymbolTable().declaredZonesNb(this.diffKind)) {
                            int diffKindRank = this.extendedDeclaredToVectorIndex(extendedZones.head, this.diffKind, this.curBlockMap);
                            this.curUnitZonesOfVarsHaveDiff.set(diffKindRank, true);
                        }
                        extendedZones = extendedZones.tail;
                    }
                    break;
                }
                case 168: {
                    diffNeeded = true;
                    if (!ILUtils.isNullOrNone(tree.down(1))) {
                        String returnVarName = this.curUnit.otherReturnVar() == null ? this.curUnit.name() : this.curUnit.otherReturnVar().symbol;
                        Tree identReturn = ILUtils.build(96, returnVarName);
                        referencedZones = this.curSymbolTable.listOfZonesOfValue(identReturn, null, this.curInstruction);
                    }
                    this.presetActivityAnnotations(tree.down(1), true, read, written, upstreamActive, downstreamActive, downstreamUseful, false);
                    this.presetActivityAnnotations(tree.down(2), false, read, written, upstreamActive, downstreamActive, downstreamUseful, false);
                    break;
                }
                case 179: {
                    break;
                }
                case 31: {
                    TapIntList channelZones;
                    boolean thisCallActive;
                    Unit calledUnit = ADActivityAnalyzer.getCalledUnit(tree, this.curSymbolTable);
                    ActivityPattern curCalledActivity = (ActivityPattern)ActivityPattern.getAnnotationForActivityPattern(tree, this.curActivity, "multiActivityCalleePatterns");
                    MPIcallInfo messagePassingInfo = MPIcallInfo.getMessagePassingMPIcallInfo(calledUnit.name(), tree, this.curUnit.language(), this.curBlock);
                    int shapeLength = calledUnit.paramElemsNb();
                    CallArrow arrow = CallGraph.getCallArrow(this.curUnit, calledUnit);
                    Tree[] actualParams = ILUtils.getArguments(tree).children();
                    TapList[] paramsCallActivities = new TapList[actualParams.length];
                    TapList[] argsRead = ADActivityAnalyzer.propagateCalleeDataToCallSite(calledUnit.unitInOutPossiblyR(), null, null, null, true, tree, this.curInstruction, arrow, null, 0, null, null, true, false);
                    TapList[] argsWritten = ADActivityAnalyzer.propagateCalleeDataToCallSite(calledUnit.unitInOutPossiblyW(), null, null, null, true, tree, this.curInstruction, arrow, null, 0, null, null, false, false);
                    BoolVector globCallPublicActivity = null;
                    BoolVector globExitPublicActivity = null;
                    if (curCalledActivity != null) {
                        globCallPublicActivity = curCalledActivity.callActivity();
                        globExitPublicActivity = curCalledActivity.exitActivity();
                    }
                    boolean callIsPassive = globCallPublicActivity != null && globCallPublicActivity.isFalse(shapeLength) && globExitPublicActivity != null && globExitPublicActivity.isFalse(shapeLength);
                    boolean[] formalArgsActivity = ADActivityAnalyzer.formalArgsActivity(curCalledActivity);
                    for (int i = actualParams.length - 1; i >= 0; --i) {
                        if (formalArgsActivity != null && i >= formalArgsActivity.length) continue;
                        boolean diffChildNeeded = diffNeeded || !callIsPassive && formalArgsActivity != null && formalArgsActivity[i];
                        paramsCallActivities[i] = this.presetActivityAnnotations(actualParams[i], diffChildNeeded, TapList.oneTrue(argsRead[i + 1]), TapList.oneTrue(argsWritten[i + 1]), upstreamActive, downstreamActive, downstreamUseful, false);
                    }
                    this.curCalledUnit = calledUnit;
                    BoolVector publicContextVoC = this.propagateEntryDataFwdToCallee(upstreamActive, this.curBlockMap, paramsCallActivities, null, arrow, actualParams, this.diffKind, false);
                    BoolVector publicContextUoE = this.propagateExitDataBwdToCallee(downstreamActive, this.curBlockMap, activTree, null, arrow, actualParams, this.diffKind, false, null, false, false);
                    if (!(calledUnit.rank() < 0 || messagePassingInfo != null && messagePassingInfo.isPointToPoint())) {
                        if (globCallPublicActivity != null) {
                            publicContextVoC.cumulAnd(globCallPublicActivity);
                        }
                        if (globExitPublicActivity != null) {
                            publicContextUoE.cumulAnd(globExitPublicActivity);
                        }
                    }
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace(" ON CALL :" + tree + " [" + upstreamActive + "]->[" + downstreamActive + "]");
                        TapEnv.printlnOnTrace("    privatized as: [" + publicContextVoC + "]=>[" + publicContextUoE + "]");
                    }
                    this.filterVariedUsefulWithDeps(publicContextVoC, publicContextUoE, calledUnit, null, null);
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace("      filtered as: [" + publicContextVoC + "]=>[" + publicContextUoE + "]");
                    }
                    boolean bl = thisCallActive = !publicContextVoC.isFalse(shapeLength) && !publicContextUoE.isFalse(shapeLength);
                    if (!thisCallActive && messagePassingInfo != null && messagePassingInfo.isOnDifferentiableType() && ADActivityAnalyzer.intersectsExtendedDeclared(upstreamActive, this.curBlockMap, this.diffKind, channelZones = messagePassingInfo.findMessagePassingChannelZones(this.curCallGraph), null, this.curSymbolTable, calledUnit)) {
                        thisCallActive = true;
                    }
                    if (thisCallActive) {
                        ADActivityAnalyzer.setAnnotatedActive(this.curActivity, ILUtils.getCalledName(tree));
                        if (!TapList.containsEquals(this.curUnit.activeCalledNames, calledUnit.name())) {
                            this.curUnit.activeCalledNames = new TapList<String>(calledUnit.name(), this.curUnit.activeCalledNames);
                        }
                    }
                    if (!thisCallActive || calledUnit.isIntrinsic()) break;
                    int nbArgs = actualParams.length;
                    if (nbArgs > calledUnit.functionTypeSpec().argumentsTypes.length) {
                        nbArgs = calledUnit.functionTypeSpec().argumentsTypes.length;
                    }
                    BoolVector privateFormalActivity = new BoolVector(ADActivityAnalyzer.mapSize(this.curBlockMap));
                    if (globCallPublicActivity != null) {
                        ADActivityAnalyzer.propagateDataToCaller(globCallPublicActivity, null, actualParams, actualParams.length, privateFormalActivity, this.curBlockMap, null, this.curInstruction, arrow, true, true, this.diffKind);
                    }
                    if (globExitPublicActivity != null) {
                        ADActivityAnalyzer.propagateDataToCaller(globExitPublicActivity, null, actualParams, actualParams.length, privateFormalActivity, this.curBlockMap, null, this.curInstruction, arrow, true, false, this.diffKind);
                    }
                    if (formalArgsActivity == null) break;
                    for (int i = nbArgs - 1; i >= 0; --i) {
                        if (i >= formalArgsActivity.length - 1 || !formalArgsActivity[i] || !ILUtils.isAVarRef(actualParams[i], this.curSymbolTable) || this.curSymbolTable.varIsIntentIn(actualParams[i])) continue;
                        VariableDecl actualArgDecl = this.curSymbolTable.getVariableDecl(ILUtils.baseName(actualParams[i]));
                        if (actualArgDecl.isDifferentiableSymbolDecl(this.diffKind, !TapEnv.doActivity())) {
                            actualArgDecl.setActive();
                        }
                        if (!ILUtils.isAWritableIdentVarRef(actualParams[i], this.curSymbolTable)) continue;
                        TapIntList zones = this.curSymbolTable.listOfZonesOfValue(actualParams[i], null, this.curInstruction);
                        while (zones != null) {
                            int diffIndex;
                            ZoneInfo zoneInfo = this.extendedDeclaredToZoneInfo(zones.head);
                            if (zoneInfo != null && (diffIndex = this.zoneInfoToVectorIndex(zoneInfo, this.extendedDeclaredToClass(zones.head), this.diffKind, this.curBlockMap)) >= 0 && privateFormalActivity.get(diffIndex)) {
                                zoneInfo.setOnceActive();
                            }
                            zones = zones.tail;
                        }
                    }
                    break;
                }
                case 109: {
                    String ioAction = ILUtils.getIdentString(tree.down(1));
                    boolean writesInVars = ioAction.equals("read") || ioAction.equals("accept") || ioAction.equals("decode");
                    this.presetActivityAnnotations(tree.down(3), false, !writesInVars, writesInVars, upstreamActive, downstreamActive, downstreamUseful, false);
                    if (!writesInVars) break;
                    if (ADActivityAnalyzer.hasOneAnnotatedActive(this.curActivity, tree.down(3), this.curSymbolTable)) {
                        ADActivityAnalyzer.setAnnotatedActive(this.curActivity, tree);
                    }
                    this.setDifferentiatedIOActive(tree.down(3), upstreamActive);
                    break;
                }
                case 5: 
                case 52: {
                    break;
                }
                case 4: {
                    this.presetActivityAnnotations(tree.down(1), diffNeeded, read, true, upstreamActive, downstreamActive, downstreamUseful, false);
                    if (!ADActivityAnalyzer.isAnnotatedActive(this.curActivity, tree.down(1))) break;
                    ADActivityAnalyzer.setAnnotatedActive(this.curActivity, tree);
                    break;
                }
                case 199: {
                    Tree[] declarators = tree.down(3).children();
                    for (int i = declarators.length - 1; i >= 0; --i) {
                        this.presetActivityAnnotations(declarators[i], false, true, false, upstreamActive, downstreamActive, downstreamUseful, false);
                    }
                    break;
                }
                case 10: {
                    Tree[] values = tree.children();
                    for (int i = values.length - 1; i >= 0; --i) {
                        this.presetActivityAnnotations(values[i], diffNeeded, true, false, upstreamActive, downstreamActive, downstreamUseful, false);
                    }
                    break;
                }
                default: {
                    if (tree.isAtom()) break;
                    Tree[] subTrees = tree.children();
                    for (int i = subTrees.length - 1; i >= 0; --i) {
                        this.presetActivityAnnotations(subTrees[i], diffNeeded, read, written, upstreamActive, downstreamActive, downstreamUseful, false);
                    }
                }
            }
            if (diffNeeded && TapList.oneTrue(activTree) || active) {
                ADActivityAnalyzer.setAnnotatedActive(this.curActivity, tree);
            }
            if (TapList.oneTrue(activTree) || active) {
                TapIntList extendedZones = referencedZones;
                while (extendedZones != null) {
                    if (extendedZones.head < this.curUnit.privateSymbolTable().declaredZonesNb(this.diffKind)) {
                        int diffKindRank = this.extendedDeclaredToVectorIndex(extendedZones.head, this.diffKind, this.curBlockMap);
                        this.curUnitZonesOfVarsHaveDiff.set(diffKindRank, true);
                    }
                    extendedZones = extendedZones.tail;
                }
            }
            return activTree;
        }
        return null;
    }

    private void setDifferentiatedIOActive(Tree ioArg, BoolVector zonesActiveHere) {
        if (ILUtils.isAVarRef(ioArg, this.curSymbolTable)) {
            if (ADActivityAnalyzer.intersectsExtendedDeclared(zonesActiveHere, this.curBlockMap, this.diffKind, ioArg, null, this.curInstruction, null, this.curSymbolTable, null)) {
                this.curSymbolTable.getVariableDecl(ILUtils.baseName(ioArg)).setActive();
            }
        } else if (ioArg.opCode() == 110) {
            this.setDifferentiatedIOActive(ioArg.down(1), zonesActiveHere);
        } else if (ioArg.opCode() == 71) {
            for (int i = 1; i <= ioArg.length(); ++i) {
                this.setDifferentiatedIOActive(ioArg.down(i), zonesActiveHere);
            }
        }
    }

    private void removeActivityAnnotations(Block block) {
        TapList<Instruction> instructions = block.instructions;
        while (instructions != null) {
            this.removeActivityAnnotations(((Instruction)instructions.head).tree);
            instructions = instructions.tail;
        }
    }

    private void removeActivityAnnotations(Tree tree) {
        if (tree != null) {
            if (!tree.isAtom()) {
                Tree[] sons = tree.children();
                for (int i = sons.length - 1; i >= 0; --i) {
                    this.removeActivityAnnotations(sons[i]);
                }
            }
            ActivityPattern.removeAnnotationForActivityPattern(tree, this.curActivity, "ActiveExpr");
        }
    }

    private TapList depsThroughExpression(BoolMatrix deps, Tree expression, ToBool arrives) {
        switch (expression.opCode()) {
            case 14: 
            case 63: 
            case 125: 
            case 150: 
            case 190: {
                boolean totalAccess;
                TapList<BoolVector> rhsDeps = this.depsThroughExpression(deps, expression.down(2), arrives);
                Tree lhs = expression.down(1);
                this.depsThroughExpression(deps, lhs, arrives);
                ToBool lhsTotal = new ToBool(false);
                TapList writtenZonesTree = this.curSymbolTable.treeOfZonesOfValue(lhs, lhsTotal, this.curInstruction, null);
                if (this.curUnit.isFortran() && TypeSpec.isA(this.curSymbolTable.typeOf(lhs), 21)) {
                    writtenZonesTree = this.curSymbolTable.includePointedElementsInZonesTree(writtenZonesTree, this.curInstruction, null, true);
                }
                boolean bl = totalAccess = this.referenceIsTotal(lhsTotal.get(), writtenZonesTree) && expression.opCode() == 14 && this.curInstruction.getWhereMask() == null && (!this.inADeclaration || !this.curUnit.isFortran());
                if (rhsDeps == null) {
                    rhsDeps = new TapList<BoolVector>(new BoolVector(ADActivityAnalyzer.mapSize(this.curBlockMap)), null);
                }
                if (TapEnv.traceCurAnalysis()) {
                    TapIntList rksList = this.mapExtendedDeclaredToVectorIndex(ZoneInfo.listAllZones(writtenZonesTree, true), this.diffKind, this.curBlockMap);
                    TapEnv.printlnOnTrace("Upon " + ILUtils.toString(expression) + ", " + writtenZonesTree + " (=>rks:" + rksList + ") receives (total:" + totalAccess + ") " + rhsDeps.toString(this.curBlockMap));
                }
                this.setInfoPRZVTreeToExtendedDeclaredZones(deps, this.curBlockMap, writtenZonesTree, rhsDeps, null, totalAccess, this.diffKind);
                return rhsDeps;
            }
            case 31: {
                Unit calledUnit;
                this.curCalledUnit = calledUnit = ADActivityAnalyzer.getCalledUnit(expression, this.curSymbolTable);
                TapList rrr = null;
                assert (calledUnit != null);
                MPIcallInfo messagePassingInfo = MPIcallInfo.getMessagePassingMPIcallInfo(calledUnit.name(), expression, this.curUnit.language(), this.curBlock);
                if (messagePassingInfo != null && messagePassingInfo.isPointToPoint()) {
                    Tree exprFromChannels;
                    Tree exprToChannels;
                    TapList<TapIntList> messagePassingChannels = new TapList<TapIntList>(messagePassingInfo.findMessagePassingChannelZones(this.curCallGraph), null);
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace();
                        TapEnv.printlnOnTrace(" ---------- AD Deps Analysis of message-passing call " + ILUtils.toString(expression) + " : ----------");
                        TapEnv.printlnOnTrace("    incoming AD deps Upstream:");
                        TapEnv.dumpBoolMatrixOnTrace(deps, this.curBlockMap, this.curBlockMap);
                        TapEnv.printlnOnTrace();
                        TapEnv.printlnOnTrace("    channels:" + messagePassingChannels + " from channel info " + messagePassingInfo);
                    }
                    if ((exprToChannels = messagePassingInfo.sentExprToChannel()) != null) {
                        TapList<BoolVector> sentDeps;
                        if (calledUnit.isC() && TypeSpec.isA(this.curSymbolTable.typeOf(exprToChannels), 6)) {
                            exprToChannels = ILUtils.build(151, ILUtils.copy(exprToChannels));
                        }
                        if ((sentDeps = this.depsThroughExpression(deps, exprToChannels, arrives)) == null) {
                            sentDeps = new TapList<BoolVector>(new BoolVector(ADActivityAnalyzer.mapSize(this.curBlockMap)), null);
                        }
                        if (TapEnv.traceCurAnalysis()) {
                            TapEnv.printlnOnTrace("    Deps sent to channel: " + sentDeps);
                        }
                        this.setInfoPRZVTreeToExtendedDeclaredZones(deps, this.curBlockMap, messagePassingChannels, sentDeps, null, false, this.diffKind);
                    }
                    if ((exprFromChannels = messagePassingInfo.receivedExprFromChannel()) != null) {
                        ToBool toTotal = new ToBool(false);
                        if (calledUnit.isC() && TypeSpec.isA(this.curSymbolTable.typeOf(exprFromChannels), 6)) {
                            exprFromChannels = ILUtils.build(151, ILUtils.copy(exprFromChannels));
                        }
                        TapList<?> writtenZonesTree = this.curSymbolTable.treeOfZonesOfValue(exprFromChannels, toTotal, this.curInstruction, null);
                        boolean totalAccess = this.referenceIsTotal(toTotal.get(), writtenZonesTree);
                        TapList receivedDeps = this.buildInfoPRZVTreeOfExtendedDeclared(messagePassingChannels, deps, this.diffKind, this.curBlockMap);
                        if (TapEnv.traceCurAnalysis()) {
                            TapEnv.printlnOnTrace("    Deps received from channel: " + receivedDeps);
                        }
                        this.setInfoPRZVTreeToExtendedDeclaredZones(deps, this.curBlockMap, writtenZonesTree, receivedDeps, null, totalAccess, this.diffKind);
                        TapIntList channelZones = ZoneInfo.listAllZones(messagePassingChannels, true);
                        while (channelZones != null) {
                            int chZ = channelZones.head;
                            int chRow = this.extendedDeclaredToVectorIndex(chZ, this.diffKind, this.curBlockMap);
                            int chCol = this.extendedDeclaredToVectorIndex(chZ, this.diffKind, this.entryMap);
                            if (deps != null && deps.rows[chRow] == null) {
                                deps.rows[chRow] = new BoolVector(ADActivityAnalyzer.mapSize(this.curBlockMap));
                                deps.rows[chRow].set(chCol, true);
                            }
                            channelZones = channelZones.tail;
                        }
                    }
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace("    outgoing AD deps Downstream:");
                        TapEnv.dumpBoolMatrixOnTrace(deps, this.curBlockMap, this.curBlockMap);
                        TapEnv.printlnOnTrace();
                    }
                } else {
                    int i;
                    BoolMatrix calleePublicDiffDeps = ADActivityAnalyzer.getPublicDeps(calledUnit, this.dependencies, this.diffKind);
                    if ((calleePublicDiffDeps = ADActivityAnalyzer.filterByValue(calleePublicDiffDeps, calledUnit)) == null) {
                        if (arrives != null) {
                            arrives.set(false);
                        }
                        return null;
                    }
                    CallArrow arrow = CallGraph.getCallArrow(this.curUnit, calledUnit);
                    Tree[] actualParams = ILUtils.getArguments(expression).children();
                    TapList[] paramDeps = new TapList[actualParams.length];
                    for (i = actualParams.length - 1; i >= 0; --i) {
                        paramDeps[i] = this.depsThroughExpression(deps, actualParams[i], arrives);
                    }
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace();
                        TapEnv.printlnOnTrace(" ---------- AD Deps Analysis of procedure call " + ILUtils.toString(expression) + " : ----------");
                        TapEnv.printlnOnTrace("    incoming AD deps Upstream:");
                        TapEnv.dumpBoolMatrixOnTrace(deps, this.curBlockMap, this.curBlockMap);
                        if (actualParams.length > 0) {
                            TapEnv.printlnOnTrace("    and params deps:");
                            for (i = 0; i < actualParams.length; ++i) {
                                TapEnv.printlnOnTrace("      [" + (i + 1) + "] : " + paramDeps[i]);
                            }
                        }
                    }
                    BoolVector tmpPubW = calledUnit.getTmpALLKINDPossiblyW();
                    BoolMatrix publicDeps = this.propagateEntryDataFwdToCallee(deps, this.curBlockMap, paramDeps, tmpPubW, arrow, actualParams, this.diffKind, true);
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace();
                        TapEnv.printlnOnTrace("    made as incoming public:");
                        for (int i2 = 0; i2 < calledUnit.paramElemsNb(); ++i2) {
                            ZoneInfo zi = calledUnit.paramElemZoneInfo(i2);
                            if (zi == null) continue;
                            TapEnv.printOnTrace(" [" + i2 + "]" + zi.accessTreePrint(this.curUnit.language()));
                        }
                        TapEnv.printlnOnTrace();
                        TapEnv.dumpBoolMatrixOnTrace(publicDeps, null, this.curBlockMap);
                        TapEnv.printlnOnTrace();
                        TapEnv.printlnOnTrace("    composed with callee public AD Deps:");
                        TapEnv.dumpOnTrace(calleePublicDiffDeps);
                        TapEnv.printlnOnTrace();
                    }
                    publicDeps = calleePublicDiffDeps.times(publicDeps);
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace("    gives outgoing public:");
                        TapEnv.dumpBoolMatrixOnTrace(publicDeps, null, this.curBlockMap);
                        TapEnv.printlnOnTrace();
                    }
                    rrr = this.propagateExitDataFwdToCaller(publicDeps, deps, this.curBlockMap, tmpPubW, arrow, actualParams, this.diffKind);
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace("    and outgoing AD deps Downstream:");
                        TapEnv.dumpBoolMatrixOnTrace(deps, this.curBlockMap, this.curBlockMap);
                        TapEnv.printlnOnTrace();
                        TapEnv.printlnOnTrace("    plus result AD Deps: " + rrr.toString(this.curBlockMap));
                        TapEnv.printlnOnTrace(" --------------------------------------------------------------------------");
                        TapEnv.printlnOnTrace();
                    }
                }
                return rrr;
            }
            case 75: {
                TapList valueDependency = this.depsThroughExpression(deps, expression.down(1), arrives);
                Object result = TapList.nth(valueDependency, ILUtils.getFieldRank(expression.down(2)));
                if (result instanceof BoolVector) {
                    return new TapList<Object>(result, null);
                }
                return (TapList)result;
            }
            case 9: {
                this.depsThroughExpression(deps, expression.down(2), arrives);
                return this.depsThroughExpression(deps, expression.down(1), arrives);
            }
            case 11: 
            case 26: 
            case 153: {
                return null;
            }
            case 151: {
                this.depsThroughExpression(deps, expression.down(2), arrives);
            }
            case 96: {
                TapList<?> zones = TapList.copyTree(this.curSymbolTable.treeOfZonesOfValue(expression, null, this.curInstruction, null));
                if (zones == null) {
                    return null;
                }
                this.includePointedElementsInTree(zones, null, null, true, false, true);
                return this.buildInfoPRZVTreeOfExtendedDeclared(zones, deps, this.diffKind, this.curBlockMap);
            }
            case 3: 
            case 42: 
            case 62: 
            case 126: 
            case 133: 
            case 155: 
            case 182: {
                return TapList.cumulWithOper(this.depsOnlyForReal(this.depsThroughExpression(deps, expression.down(1), arrives), expression.down(1)), this.depsOnlyForReal(this.depsThroughExpression(deps, expression.down(2), arrives), expression.down(2)), 91);
            }
            case 124: {
                return this.depsOnlyForReal(this.depsThroughExpression(deps, expression.down(1), arrives), expression.down(1));
            }
            case 109: {
                ToBool exprTotal = new ToBool(false);
                String ioAction = ILUtils.getIdentString(expression.down(1));
                boolean writesInVars = ioAction.equals("read") || ioAction.equals("accept") || ioAction.equals("decode");
                Tree[] writtenRefs = expression.down(3).children();
                for (int i = writtenRefs.length - 1; i >= 0; --i) {
                    this.depsThroughExpression(deps, writtenRefs[i], arrives);
                    if (!writesInVars) continue;
                    TapIntList writtenZones = this.curSymbolTable.listOfZonesOfValue(writtenRefs[i], exprTotal, this.curInstruction);
                    writtenZones = this.mapExtendedDeclaredToVectorIndex(writtenZones, this.diffKind, this.curBlockMap);
                    deps.overwriteDeps(writtenZones, null, exprTotal.get());
                }
                return null;
            }
            case 71: 
            case 83: {
                Tree[] indexes = expression.children();
                for (int i = indexes.length - 1; i >= 0; --i) {
                    this.depsThroughExpression(deps, indexes[i], arrives);
                }
                return null;
            }
            case 10: {
                Tree[] expressions = expression.children();
                TapList<?> cumulDeps = null;
                for (int i = expressions.length - 1; i >= 0; --i) {
                    cumulDeps = TapList.cumulWithOper(cumulDeps, this.depsThroughExpression(deps, expressions[i], arrives), 91);
                }
                return cumulDeps;
            }
            case 47: {
                Tree[] expressions = expression.down(3).children();
                TapList<TapList> result = null;
                for (int i = expressions.length - 1; i >= 0; --i) {
                    result = new TapList<TapList>(this.depsThroughExpression(deps, expressions[i], arrives), result);
                }
                return result;
            }
            case 98: 
            case 139: 
            case 184: 
            case 189: 
            case 196: 
            case 205: 
            case 206: {
                this.depsThroughExpression(deps, expression.down(1), arrives);
                return null;
            }
            case 99: {
                this.depsThroughExpression(deps, expression.down(1), arrives);
                return TapList.cumulWithOper(TapList.copyTree(this.depsOnlyForReal(this.depsThroughExpression(deps, expression.down(2), arrives), expression.down(2))), this.depsOnlyForReal(this.depsThroughExpression(deps, expression.down(3), arrives), expression.down(3)), 91);
            }
            case 134: 
            case 186: {
                this.depsThroughExpression(deps, expression.down(2), arrives);
                return null;
            }
            case 32: 
            case 194: {
                return this.depsOnlyForReal(this.depsThroughExpression(deps, expression.down(2), arrives), expression.down(2));
            }
            case 121: {
                this.depsThroughExpression(deps, expression.down(3), arrives);
                return null;
            }
            case 80: {
                this.depsThroughExpression(deps, expression.down(1), arrives);
                this.depsThroughExpression(deps, expression.down(2), arrives);
                return null;
            }
            case 64: 
            case 82: {
                this.depsThroughExpression(deps, expression.down(2), arrives);
                this.depsThroughExpression(deps, expression.down(3), arrives);
                this.depsThroughExpression(deps, expression.down(4), arrives);
                return null;
            }
            case 81: {
                this.depsThroughExpression(deps, expression.down(1), arrives);
                this.depsThroughExpression(deps, expression.down(2), arrives);
                return null;
            }
            case 12: 
            case 79: {
                this.depsThroughExpression(deps, expression.down(1), arrives);
                this.depsThroughExpression(deps, expression.down(2), arrives);
                this.depsThroughExpression(deps, expression.down(3), arrives);
                return null;
            }
            case 110: {
                this.depsThroughExpression(deps, expression.down(2), arrives);
                Tree[] expressions = expression.down(1).children();
                TapList<?> cumulDeps = null;
                for (int i = expressions.length - 1; i >= 0; --i) {
                    cumulDeps = TapList.cumulWithOper(cumulDeps, this.depsThroughExpression(deps, expressions[i], arrives), 91);
                }
                return cumulDeps;
            }
            case 6: 
            case 18: 
            case 22: 
            case 24: 
            case 43: 
            case 68: 
            case 92: 
            case 95: 
            case 115: 
            case 116: 
            case 122: 
            case 137: 
            case 143: 
            case 169: 
            case 207: {
                this.depsThroughExpression(deps, expression.down(1), arrives);
                this.depsThroughExpression(deps, expression.down(2), arrives);
                return null;
            }
            case 168: {
                TapList result = null;
                this.depsThroughExpression(deps, expression.down(2), arrives);
                if (!ILUtils.isNullOrNone(expression.down(1))) {
                    String returnVarName = this.curUnit.otherReturnVar() == null ? this.curUnit.name() : this.curUnit.otherReturnVar().symbol;
                    Tree assignTree = ILUtils.turnReturnIntoAssign(expression, returnVarName);
                    result = this.depsThroughExpression(deps, assignTree, arrives);
                    ILUtils.resetReturnFromAssign(expression, assignTree);
                }
                return result;
            }
            case 179: {
                if (arrives != null) {
                    arrives.set(false);
                }
                return null;
            }
            case 4: {
                return new TapList<Object>(null, this.depsThroughExpression(deps, expression.down(1), arrives));
            }
            case 5: 
            case 15: 
            case 20: 
            case 28: 
            case 30: 
            case 40: 
            case 94: 
            case 103: 
            case 111: 
            case 118: 
            case 138: 
            case 160: 
            case 177: 
            case 180: 
            case 181: {
                return null;
            }
            case 52: 
            case 140: {
                this.depsThroughExpression(deps, expression.down(1), arrives);
                return null;
            }
            case 176: {
                return this.depsThroughExpression(deps, expression.down(1), arrives);
            }
            case 36: 
            case 46: 
            case 56: 
            case 89: {
                return null;
            }
            case 144: 
            case 145: {
                return null;
            }
            case 2: 
            case 13: 
            case 29: 
            case 35: 
            case 39: 
            case 41: 
            case 45: 
            case 49: 
            case 51: 
            case 67: 
            case 69: 
            case 74: 
            case 78: 
            case 91: 
            case 101: 
            case 104: 
            case 106: 
            case 108: 
            case 129: 
            case 135: 
            case 154: 
            case 161: 
            case 171: 
            case 192: 
            case 195: 
            case 197: 
            case 202: 
            case 204: {
                return null;
            }
            case 199: {
                Tree[] decls = expression.down(3).children();
                this.inADeclaration = true;
                for (int i = decls.length - 1; i >= 0; --i) {
                    if (decls[i].opCode() != 14) continue;
                    ILUtils.turnAssignFromInitDecl(decls[i]);
                    this.depsThroughExpression(deps, decls[i], arrives);
                    ILUtils.resetAssignFromInitDecl(decls[i]);
                }
                this.inADeclaration = false;
                return null;
            }
        }
        TapEnv.toolWarning(-1, "(Compute AD dependencies) Unexpected operator : " + expression.opName());
        return null;
    }

    private TapList variednessThroughExpression(Tree expression, BoolVector varieds, ToBool arrives, boolean annotate) {
        TapList<Object> resultVariedness = null;
        switch (expression.opCode()) {
            case 14: 
            case 63: 
            case 125: 
            case 150: 
            case 190: {
                boolean totalAccess;
                Tree lhs = expression.down(1);
                resultVariedness = this.variednessThroughExpression(expression.down(2), varieds, arrives, annotate);
                if (resultVariedness == null) {
                    resultVariedness = new TapList(Boolean.FALSE, null);
                }
                TapList<?> lhsVariedness = this.variednessThroughExpression(lhs, varieds, arrives, annotate);
                ToBool lhsTotal = new ToBool(false);
                TapList writtenZonesTree = this.curSymbolTable.treeOfZonesOfValue(lhs, lhsTotal, this.curInstruction, null);
                if (this.curUnit.isFortran() && TypeSpec.isA(this.curSymbolTable.typeOf(lhs), 21)) {
                    writtenZonesTree = this.curSymbolTable.includePointedElementsInZonesTree(writtenZonesTree, this.curInstruction, null, true);
                }
                boolean bl = totalAccess = this.referenceIsTotal(lhsTotal.get(), writtenZonesTree) && expression.opCode() == 14 && (!this.inADeclaration || !this.curUnit.isFortran());
                if (TapEnv.traceCurAnalysis()) {
                    TapIntList rksList = this.mapExtendedDeclaredToVectorIndex(ZoneInfo.listAllZones(writtenZonesTree, true), this.diffKind, this.curBlockMap);
                    TapEnv.printlnOnTrace("     through " + ILUtils.toString(expression) + ", " + writtenZonesTree + " (=>rks:" + rksList + ") receives (total:" + totalAccess + ") " + resultVariedness.toString(null));
                }
                this.setInfoBoolTreeToExtendedDeclaredZones(varieds, this.curBlockMap, writtenZonesTree, resultVariedness, null, totalAccess, this.diffKind);
                if (!annotate) break;
                lhsVariedness = TapList.copyTree(lhsVariedness);
                lhsVariedness = TapList.cumulWithOper(lhsVariedness, resultVariedness, 91);
                ActivityPattern.setAnnotationForActivityPattern(lhs, this.curActivity, "Varied", lhsVariedness);
                break;
            }
            case 31: {
                Unit calledUnit = ADActivityAnalyzer.getCalledUnit(expression, this.curSymbolTable);
                assert (calledUnit != null);
                CallArrow arrow = CallGraph.getCallArrow(this.curUnit, calledUnit);
                Tree[] actualParams = ILUtils.getArguments(expression).children();
                TapList[] paramVariednesses = new TapList[actualParams.length];
                for (int i = actualParams.length - 1; i >= 0; --i) {
                    paramVariednesses[i] = this.variednessThroughExpression(actualParams[i], varieds, arrives, annotate);
                }
                this.curCalledUnit = calledUnit;
                MPIcallInfo messagePassingInfo = MPIcallInfo.getMessagePassingMPIcallInfo(calledUnit.name(), expression, this.curUnit.language(), this.curBlock);
                if (messagePassingInfo != null && messagePassingInfo.isPointToPoint()) {
                    Tree exprFromChannels;
                    TapList<TapIntList> messagePassingChannels = new TapList<TapIntList>(messagePassingInfo.findMessagePassingChannelZones(this.curCallGraph), null);
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace("    ---------- Message-Passing call " + ILUtils.toString(expression) + " on channels " + messagePassingChannels);
                    }
                    BoolVector inputPublicVariedness = this.propagateEntryDataFwdToCallee(varieds, this.curBlockMap, paramVariednesses, null, arrow, null, this.diffKind, false);
                    boolean channelsVaried = TapList.oneTrue(ADActivityAnalyzer.buildInfoBoolTreeOfDeclaredZones(messagePassingChannels, varieds, this.curBlockMap, null, this.diffKind, this.curSymbolTable));
                    this.bufferizeCallContext(calledUnit, expression, inputPublicVariedness, channelsVaried, null, 0);
                    Tree exprToChannels = messagePassingInfo.sentExprToChannel();
                    if (exprToChannels != null) {
                        if (calledUnit.isC() && TypeSpec.isA(this.curSymbolTable.typeOf(exprToChannels), 6)) {
                            exprToChannels = ILUtils.build(151, ILUtils.copy(exprToChannels));
                        }
                        if ((resultVariedness = this.variednessThroughExpression(exprToChannels, varieds, arrives, annotate)) == null) {
                            resultVariedness = new TapList<Boolean>(Boolean.FALSE, null);
                        }
                        this.setInfoBoolTreeToExtendedDeclaredZones(varieds, this.curBlockMap, messagePassingChannels, resultVariedness, null, false, this.diffKind);
                        if (TapEnv.traceCurAnalysis()) {
                            TapEnv.printlnOnTrace("    set channels to " + resultVariedness);
                            TapEnv.printlnOnTrace("    --> " + varieds);
                        }
                    }
                    if ((exprFromChannels = messagePassingInfo.receivedExprFromChannel()) == null) break;
                    if (calledUnit.isC() && TypeSpec.isA(this.curSymbolTable.typeOf(exprFromChannels), 6)) {
                        exprFromChannels = ILUtils.build(151, ILUtils.copy(exprFromChannels));
                    }
                    TapList<?> receivedVarieds = ADActivityAnalyzer.buildInfoBoolTreeOfDeclaredZones(messagePassingChannels, varieds, this.curBlockMap, null, this.diffKind, this.curSymbolTable);
                    ToBool toTotal = new ToBool(false);
                    TapList<?> writtenZonesTree = this.curSymbolTable.treeOfZonesOfValue(exprFromChannels, toTotal, this.curInstruction, null);
                    boolean totalAccess = this.referenceIsTotal(toTotal.get(), writtenZonesTree);
                    this.setInfoBoolTreeToExtendedDeclaredZones(varieds, this.curBlockMap, writtenZonesTree, receivedVarieds, null, totalAccess, this.diffKind);
                    if (!TapEnv.traceCurAnalysis()) break;
                    TapEnv.printlnOnTrace("    received " + receivedVarieds + " from channels, put into " + writtenZonesTree);
                    TapEnv.printlnOnTrace("    --> " + varieds);
                    break;
                }
                BoolMatrix calleePublicDeps = ADActivityAnalyzer.getPublicDeps(calledUnit, this.dependencies, this.diffKind);
                calleePublicDeps = ADActivityAnalyzer.filterByValue(calleePublicDeps, calledUnit);
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace();
                    TapEnv.printlnOnTrace("    ---------- Fwd Varied through procedure call " + ILUtils.toString(expression) + " : ----------");
                    TapEnv.printlnOnTrace("    Incoming fwd varied: " + varieds);
                    TapEnv.printOnTrace("    and for parameters:[");
                    for (int i = 0; i < paramVariednesses.length; ++i) {
                        TapEnv.printOnTrace((i == 0 ? "" : ", ") + paramVariednesses[i]);
                    }
                    TapEnv.printlnOnTrace("]");
                }
                BoolVector tmpPubW = calledUnit.getTmpALLKINDPossiblyW();
                BoolVector inputPublicVariedness = this.propagateEntryDataFwdToCallee(varieds, this.curBlockMap, paramVariednesses, tmpPubW, arrow, actualParams, this.diffKind, true);
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("    Propagate unaffected: " + varieds);
                    TapEnv.printOnTrace("    External shape of called Unit " + calledUnit + ": ");
                    for (int i = 0; i < calledUnit.paramElemsNb(); ++i) {
                        ZoneInfo zi = calledUnit.paramElemZoneInfo(i);
                        if (zi == null) continue;
                        TapEnv.printOnTrace(" [" + i + "]" + zi.accessTreePrint(this.curUnit.language()));
                    }
                    TapEnv.printlnOnTrace();
                    TapEnv.printlnOnTrace("    Bufferizes incoming public varied: " + inputPublicVariedness.toString(calledUnit.paramElemsNb()));
                    TapEnv.printlnOnTrace("    Now going through callee public AD Deps:");
                    TapEnv.dumpOnTrace(calleePublicDeps);
                }
                this.bufferizeCallContext(calledUnit, expression, inputPublicVariedness, null, null, 0);
                if (calleePublicDeps != null) {
                    inputPublicVariedness = calleePublicDeps.times(inputPublicVariedness);
                } else {
                    inputPublicVariedness = new BoolVector(arrow.translator.length);
                    if (arrives != null) {
                        arrives.set(false);
                    }
                }
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("    Gives outgoing public varied: " + inputPublicVariedness.toString(calledUnit.paramElemsNb()));
                }
                if (calledUnit.unitInOutW() != null) {
                    inputPublicVariedness = inputPublicVariedness.and(tmpPubW);
                }
                resultVariedness = ADActivityAnalyzer.propagateExitDataFwdToCaller(inputPublicVariedness, varieds, this.curBlockMap, this.curInstruction, arrow, actualParams, this.diffKind);
                if (!TapEnv.traceCurAnalysis()) break;
                TapEnv.printlnOnTrace("    Gives outgoing fwd varied: " + varieds);
                TapEnv.printlnOnTrace("    Plus result's fwd varied: " + resultVariedness.toString(null));
                TapEnv.printlnOnTrace("    --------------------------------------------------------------------------");
                TapEnv.printlnOnTrace();
                break;
            }
            case 71: 
            case 83: {
                Tree[] expressions = expression.children();
                for (int i = expressions.length - 1; i >= 0; --i) {
                    this.variednessThroughExpression(expressions[i], varieds, arrives, annotate);
                }
                break;
            }
            case 10: {
                Tree[] expressions = expression.children();
                for (int i = expressions.length - 1; i >= 0; --i) {
                    resultVariedness = TapList.cumulWithOper(resultVariedness, this.variednessThroughExpression(expressions[i], varieds, arrives, annotate), 91);
                }
                break;
            }
            case 47: {
                Tree[] expressions = expression.down(3).children();
                for (int i = expressions.length - 1; i >= 0; --i) {
                    resultVariedness = new TapList<TapList>(this.variednessThroughExpression(expressions[i], varieds, arrives, annotate), resultVariedness);
                }
                break;
            }
            case 75: {
                TapList valueVariedness = this.variednessThroughExpression(expression.down(1), varieds, arrives, annotate);
                Object result = TapList.nth(valueVariedness, ILUtils.getFieldRank(expression.down(2)));
                if (result instanceof Boolean) {
                    resultVariedness = new TapList<Object>(result, null);
                    break;
                }
                resultVariedness = (TapList)result;
                break;
            }
            case 4: {
                resultVariedness = new TapList(null, this.variednessThroughExpression(expression.down(1), varieds, arrives, annotate));
                break;
            }
            case 151: {
                this.variednessThroughExpression(expression.down(1), varieds, arrives, annotate);
                this.variednessThroughExpression(expression.down(2), varieds, arrives, annotate);
                TapList<?> zones = TapList.copyTree(this.curSymbolTable.treeOfZonesOfValue(expression, null, this.curInstruction, null));
                if (zones == null) break;
                this.includePointedElementsInTree(zones, null, null, true, false, true);
                resultVariedness = ADActivityAnalyzer.buildInfoBoolTreeOfDeclaredZones(zones, varieds, this.curBlockMap, null, this.diffKind, this.curSymbolTable);
                break;
            }
            case 9: {
                this.variednessThroughExpression(expression.down(2), varieds, arrives, annotate);
                resultVariedness = this.variednessThroughExpression(expression.down(1), varieds, arrives, annotate);
                break;
            }
            case 96: {
                TapList<?> zones = TapList.copyTree(this.curSymbolTable.treeOfZonesOfValue(expression, null, this.curInstruction, null));
                if (zones == null) break;
                this.includePointedElementsInTree(zones, null, null, true, false, true);
                resultVariedness = ADActivityAnalyzer.buildInfoBoolTreeOfDeclaredZones(zones, varieds, this.curBlockMap, null, this.diffKind, this.curSymbolTable);
                break;
            }
            case 3: 
            case 42: 
            case 62: 
            case 126: 
            case 133: 
            case 155: 
            case 182: {
                resultVariedness = TapList.copyTree(this.activityOnlyForReal(this.variednessThroughExpression(expression.down(1), varieds, arrives, annotate), expression.down(1)));
                resultVariedness = TapList.cumulWithOper(resultVariedness, this.activityOnlyForReal(this.variednessThroughExpression(expression.down(2), varieds, arrives, annotate), expression.down(2)), 91);
                break;
            }
            case 124: {
                resultVariedness = this.activityOnlyForReal(this.variednessThroughExpression(expression.down(1), varieds, arrives, annotate), expression.down(1));
                break;
            }
            case 109: {
                ToBool writtenTotal = new ToBool(false);
                boolean isIORead = ILUtils.isIORead(expression);
                Tree[] exprs = expression.down(3).children();
                for (int i = exprs.length - 1; i >= 0; --i) {
                    Tree expr = exprs[i];
                    this.variednessThroughExpression(expr, varieds, arrives, annotate);
                    if (!isIORead) continue;
                    TapList<?> writtenZonesTree = this.curSymbolTable.treeOfZonesOfValue(expr, writtenTotal, this.curInstruction, null);
                    if (!this.referenceIsTotal(writtenTotal.get(), writtenZonesTree)) continue;
                    this.setInfoBoolTreeToExtendedDeclaredZones(varieds, this.curBlockMap, writtenZonesTree, false, null, true, this.diffKind);
                    if (!annotate) continue;
                    ActivityPattern.setAnnotationForActivityPattern(expr, this.curActivity, "Varied", null);
                }
                break;
            }
            case 98: 
            case 139: 
            case 184: 
            case 189: 
            case 196: 
            case 205: 
            case 206: {
                this.variednessThroughExpression(expression.down(1), varieds, arrives, annotate);
                break;
            }
            case 99: {
                this.variednessThroughExpression(expression.down(1), varieds, arrives, annotate);
                resultVariedness = TapList.copyTree(this.activityOnlyForReal(this.variednessThroughExpression(expression.down(2), varieds, arrives, annotate), expression.down(2)));
                resultVariedness = TapList.cumulWithOper(resultVariedness, this.activityOnlyForReal(this.variednessThroughExpression(expression.down(3), varieds, arrives, annotate), expression.down(3)), 91);
                break;
            }
            case 134: {
                this.variednessThroughExpression(expression.down(2), varieds, arrives, annotate);
                break;
            }
            case 32: 
            case 194: {
                resultVariedness = this.variednessThroughExpression(expression.down(2), varieds, arrives, annotate);
                break;
            }
            case 121: {
                this.variednessThroughExpression(expression.down(3), varieds, arrives, annotate);
                break;
            }
            case 80: {
                this.variednessThroughExpression(expression.down(1), varieds, arrives, annotate);
                this.variednessThroughExpression(expression.down(2), varieds, arrives, annotate);
                break;
            }
            case 64: 
            case 82: {
                this.variednessThroughExpression(expression.down(2), varieds, arrives, annotate);
                this.variednessThroughExpression(expression.down(3), varieds, arrives, annotate);
                this.variednessThroughExpression(expression.down(4), varieds, arrives, annotate);
                break;
            }
            case 81: {
                this.variednessThroughExpression(expression.down(1), varieds, arrives, annotate);
                this.variednessThroughExpression(expression.down(2), varieds, arrives, annotate);
                break;
            }
            case 79: {
                this.variednessThroughExpression(expression.down(1), varieds, arrives, annotate);
                this.variednessThroughExpression(expression.down(2), varieds, arrives, annotate);
                this.variednessThroughExpression(expression.down(3), varieds, arrives, annotate);
                break;
            }
            case 12: {
                this.variednessThroughExpression(expression.down(1), varieds, arrives, annotate);
                this.variednessThroughExpression(expression.down(2), varieds, arrives, annotate);
                this.variednessThroughExpression(expression.down(3), varieds, arrives, annotate);
                break;
            }
            case 6: 
            case 18: 
            case 22: 
            case 24: 
            case 43: 
            case 68: 
            case 92: 
            case 95: 
            case 115: 
            case 116: 
            case 122: 
            case 137: 
            case 143: 
            case 169: 
            case 207: {
                this.variednessThroughExpression(expression.down(1), varieds, arrives, annotate);
                this.variednessThroughExpression(expression.down(2), varieds, arrives, annotate);
                break;
            }
            case 110: {
                Tree[] expressions = expression.down(1).children();
                for (int i = expressions.length - 1; i >= 0; --i) {
                    resultVariedness = TapList.cumulWithOper(resultVariedness, this.variednessThroughExpression(expressions[i], varieds, arrives, annotate), 91);
                }
                break;
            }
            case 15: 
            case 20: 
            case 28: 
            case 30: 
            case 40: 
            case 94: 
            case 103: 
            case 111: 
            case 118: 
            case 138: 
            case 160: 
            case 180: 
            case 181: {
                break;
            }
            case 179: {
                if (arrives == null) break;
                arrives.set(false);
                break;
            }
            case 168: {
                this.variednessThroughExpression(expression.down(2), varieds, arrives, annotate);
                if (ILUtils.isNullOrNone(expression.down(1))) break;
                resultVariedness = this.variednessThroughExpression(expression.down(1), varieds, arrives, annotate);
                if (resultVariedness == null) {
                    resultVariedness = new TapList<Boolean>(Boolean.FALSE, null);
                }
                String returnVarName = this.curUnit.otherReturnVar() == null ? this.curUnit.name() : this.curUnit.otherReturnVar().symbol;
                Tree lhs = ILUtils.build(96, returnVarName);
                ToBool lhsTotal = new ToBool(false);
                TapList<?> writtenZonesTree = this.curSymbolTable.treeOfZonesOfValue(lhs, lhsTotal, this.curInstruction, null);
                this.setInfoBoolTreeToExtendedDeclaredZones(varieds, this.curBlockMap, writtenZonesTree, resultVariedness, null, true, this.diffKind);
                break;
            }
            case 5: {
                break;
            }
            case 52: 
            case 140: {
                break;
            }
            case 11: 
            case 26: 
            case 153: 
            case 176: {
                resultVariedness = this.variednessThroughExpression(expression.down(1), varieds, arrives, annotate);
                break;
            }
            case 36: 
            case 46: 
            case 56: 
            case 89: {
                break;
            }
            case 2: 
            case 13: 
            case 29: 
            case 35: 
            case 41: 
            case 45: 
            case 49: 
            case 51: 
            case 67: 
            case 74: 
            case 78: 
            case 91: 
            case 101: 
            case 104: 
            case 106: 
            case 108: 
            case 129: 
            case 135: 
            case 154: 
            case 161: 
            case 171: 
            case 192: 
            case 195: 
            case 197: 
            case 202: 
            case 204: {
                break;
            }
            case 39: {
                break;
            }
            case 69: {
                break;
            }
            case 144: 
            case 145: {
                break;
            }
            case 199: {
                int i;
                Tree[] expressions = expression.down(3).children();
                TapList[] varied = new TapList[expressions.length];
                int rankFirstInit = -1;
                this.inADeclaration = true;
                for (i = 0; i <= expressions.length - 1; ++i) {
                    if (expressions[i].opCode() != 14) continue;
                    ILUtils.turnAssignFromInitDecl(expressions[i]);
                    varied[i] = this.variednessThroughExpression(expressions[i], varieds, arrives, annotate);
                    ILUtils.resetAssignFromInitDecl(expressions[i]);
                    if (rankFirstInit != -1) continue;
                    rankFirstInit = i;
                }
                this.inADeclaration = false;
                if (rankFirstInit == -1) break;
                resultVariedness = TapList.copyTree(this.activityOnlyForReal(varied[rankFirstInit], expressions[rankFirstInit]));
                for (i = rankFirstInit + 1; i <= expressions.length - 1; ++i) {
                    if (varied[i] == null) continue;
                    resultVariedness = TapList.cumulWithOper(resultVariedness, this.activityOnlyForReal(varied[i], expressions[i]), 91);
                }
                break;
            }
            default: {
                TapEnv.toolWarning(-1, "(Compute AD variedness) Unexpected operator: " + expression.opName());
            }
        }
        if (annotate) {
            ActivityPattern.setAnnotationForActivityPattern(expression, this.curActivity, "Varied", resultVariedness);
        }
        return resultVariedness;
    }

    private void usefulnessThroughExpression(Tree expression, TapList usefulness, BoolVector usefuls, ToBool arrives, boolean annotate) {
        if (annotate) {
            ActivityPattern.setAnnotationForActivityPattern(expression, this.curActivity, "Useful", usefulness);
        }
        switch (expression.opCode()) {
            case 14: 
            case 63: 
            case 125: 
            case 150: 
            case 190: {
                Tree lhs = expression.down(1);
                ToBool lhsTotal = new ToBool(false);
                TapList writtenZonesTree = this.curSymbolTable.treeOfZonesOfValue(lhs, lhsTotal, this.curInstruction, null);
                if (this.curUnit.isFortran() && TypeSpec.isA(this.curSymbolTable.typeOf(lhs), 21)) {
                    writtenZonesTree = this.curSymbolTable.includePointedElementsInZonesTree(writtenZonesTree, this.curInstruction, null, true);
                }
                boolean totalAccess = this.referenceIsTotal(lhsTotal.get(), writtenZonesTree) && expression.opCode() == 14 && (!this.inADeclaration || !this.curUnit.isFortran());
                usefulness = TapList.cumulWithOper(usefulness, ADActivityAnalyzer.buildInfoBoolTreeOfDeclaredZones(writtenZonesTree, usefuls, this.curBlockMap, null, this.diffKind, this.curSymbolTable), 91);
                if (annotate) {
                    ActivityPattern.setAnnotationForActivityPattern(expression, this.curActivity, "Useful", usefulness);
                }
                if (TapEnv.traceCurAnalysis()) {
                    TapIntList rksList = this.mapExtendedDeclaredToVectorIndex(ZoneInfo.listAllZones(writtenZonesTree, true), this.diffKind, this.curBlockMap);
                    TapEnv.printlnOnTrace("     up through " + ILUtils.toString(expression) + ", " + writtenZonesTree + " (=>rks:" + rksList + ") provides (total:" + totalAccess + ") " + usefulness.toString(null));
                }
                if (totalAccess) {
                    this.setInfoBoolTreeToExtendedDeclaredZones(usefuls, this.curBlockMap, writtenZonesTree, false, null, true, this.diffKind);
                }
                this.usefulnessThroughExpression(expression.down(2), usefulness, usefuls, arrives, annotate);
                this.usefulnessThroughExpression(lhs, null, usefuls, arrives, annotate);
                if (!annotate) break;
                ActivityPattern.setAnnotationForActivityPattern(lhs, this.curActivity, "Useful", usefulness);
                break;
            }
            case 31: {
                int i;
                BoolVector inputPublicUsefulness;
                Unit calledUnit = ADActivityAnalyzer.getCalledUnit(expression, this.curSymbolTable);
                assert (calledUnit != null);
                CallArrow arrow = CallGraph.getCallArrow(this.curUnit, calledUnit);
                Tree[] actualParams = ILUtils.getArguments(expression).children();
                MPIcallInfo messagePassingInfo = MPIcallInfo.getMessagePassingMPIcallInfo(calledUnit.name(), expression, this.curUnit.language(), this.curBlock);
                if (messagePassingInfo != null && messagePassingInfo.isPointToPoint()) {
                    Tree exprToChannels;
                    TapList<TapIntList> messagePassingChannels = new TapList<TapIntList>(messagePassingInfo.findMessagePassingChannelZones(this.curCallGraph), null);
                    if (TapEnv.traceCurAnalysis()) {
                        TapEnv.printlnOnTrace("    ---------- Message-Passing call " + ILUtils.toString(expression) + " on channels " + messagePassingChannels);
                    }
                    BoolVector outputPublicUsefulness = this.propagateExitDataBwdToCallee(usefuls, this.curBlockMap, null, null, arrow, actualParams, this.diffKind, false, null, true, false);
                    boolean channelsUseful = TapList.oneTrue(ADActivityAnalyzer.buildInfoBoolTreeOfDeclaredZones(messagePassingChannels, usefuls, this.curBlockMap, null, this.diffKind, this.curSymbolTable));
                    this.bufferizeCallContext(calledUnit, expression, outputPublicUsefulness, channelsUseful, null, 1);
                    Tree exprFromChannels = messagePassingInfo.receivedExprFromChannel();
                    if (exprFromChannels != null) {
                        if (calledUnit.isC() && TypeSpec.isA(this.curSymbolTable.typeOf(exprFromChannels), 6)) {
                            exprFromChannels = ILUtils.build(151, ILUtils.copy(exprFromChannels));
                        }
                        ToBool toTotal = new ToBool(false);
                        TapList<?> writtenZonesTree = this.curSymbolTable.treeOfZonesOfValue(exprFromChannels, toTotal, this.curInstruction, null);
                        TapList<?> receivedUsefuls = ADActivityAnalyzer.buildInfoBoolTreeOfDeclaredZones(writtenZonesTree, usefuls, this.curBlockMap, null, this.diffKind, this.curSymbolTable);
                        if (this.referenceIsTotal(toTotal.get(), writtenZonesTree)) {
                            this.setInfoBoolTreeToExtendedDeclaredZones(usefuls, this.curBlockMap, writtenZonesTree, false, null, true, this.diffKind);
                        }
                        this.setInfoBoolTreeToExtendedDeclaredZones(usefuls, this.curBlockMap, messagePassingChannels, receivedUsefuls, null, false, this.diffKind);
                        if (TapEnv.traceCurAnalysis()) {
                            TapEnv.printlnOnTrace("    set channels to " + receivedUsefuls + " ( computed from " + writtenZonesTree + ')');
                            TapEnv.printlnOnTrace("    --> " + usefuls);
                        }
                    }
                    if ((exprToChannels = messagePassingInfo.sentExprToChannel()) == null) break;
                    if (calledUnit.isC() && TypeSpec.isA(this.curSymbolTable.typeOf(exprToChannels), 6)) {
                        exprToChannels = ILUtils.build(151, ILUtils.copy(exprToChannels));
                    }
                    usefulness = TapList.cumulWithOper(usefulness, ADActivityAnalyzer.buildInfoBoolTreeOfDeclaredZones(messagePassingChannels, usefuls, this.curBlockMap, null, this.diffKind, this.curSymbolTable), 91);
                    this.usefulnessThroughExpression(exprToChannels, usefulness, usefuls, arrives, annotate);
                    if (!TapEnv.traceCurAnalysis()) break;
                    TapEnv.printlnOnTrace("    propagating " + usefulness + " back from channels into " + exprToChannels);
                    TapEnv.printlnOnTrace("    --> " + usefuls);
                    break;
                }
                BoolMatrix calleePublicDeps = ADActivityAnalyzer.getPublicDeps(calledUnit, this.dependencies, this.diffKind);
                calleePublicDeps = ADActivityAnalyzer.filterByValue(calleePublicDeps, calledUnit);
                this.curCalledUnit = calledUnit;
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace();
                    TapEnv.printlnOnTrace("    ---------- Bwd Useful up through procedure call " + ILUtils.toString(expression) + " : ----------");
                    TapEnv.printlnOnTrace("    Downcoming bwd useful: " + usefuls);
                    TapEnv.printlnOnTrace("    Plus result's bwd useful:" + (usefulness == null ? "null" : usefulness.toString(null)));
                }
                BoolVector publicUsefulOnCallingSide = null;
                if (calledUnit.isStandard()) {
                    this.filterByValue = false;
                    publicUsefulOnCallingSide = this.propagateExitDataBwdToCallee(usefuls, this.curBlockMap, usefulness, null, arrow, actualParams, this.diffKind, false, null, true, false);
                    this.filterByValue = true;
                }
                BoolVector outputPublicUsefulness = this.propagateExitDataBwdToCallee(usefuls, this.curBlockMap, usefulness, null, arrow, actualParams, this.diffKind, true, null, true, false);
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printOnTrace("    External shape of called Unit: ");
                    for (int i2 = 0; i2 < calledUnit.paramElemsNb(); ++i2) {
                        ZoneInfo zi = calledUnit.paramElemZoneInfo(i2);
                        if (zi == null) continue;
                        TapEnv.printOnTrace(" [" + i2 + "]" + zi.accessTreePrint(this.curUnit.language()));
                    }
                    TapEnv.printlnOnTrace();
                    TapEnv.printlnOnTrace("    Bufferizes downcoming public useful: " + outputPublicUsefulness.toString(calledUnit.paramElemsNb()));
                    TapEnv.printlnOnTrace("    Now going through callee public AD Deps:");
                    TapEnv.dumpOnTrace(calleePublicDeps);
                }
                this.bufferizeCallContext(calledUnit, expression, outputPublicUsefulness, null, publicUsefulOnCallingSide, 1);
                if (calleePublicDeps != null) {
                    BoolVector tmpPubK = calledUnit.getTmpALLKINDK();
                    inputPublicUsefulness = outputPublicUsefulness.minus(tmpPubK);
                    inputPublicUsefulness.cumulOr(calleePublicDeps.leftTimes(outputPublicUsefulness));
                } else {
                    inputPublicUsefulness = new BoolVector(arrow.translator.length);
                    if (arrives != null) {
                        arrives.set(false);
                    }
                }
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("    Gives upgoing public useful: " + inputPublicUsefulness.toString(calledUnit.paramElemsNb()));
                }
                TapList[] paramUsefulnesses = ADActivityAnalyzer.propagateEntryDataBwdToCaller(inputPublicUsefulness, usefuls, this.curBlockMap, this.curInstruction, arrow, actualParams, this.diffKind);
                if (TapEnv.traceCurAnalysis()) {
                    TapEnv.printlnOnTrace("    Gives upgoing bwd useful: " + usefuls);
                    TapEnv.printOnTrace("    Plus params bwd useful: [");
                    for (i = 0; i < actualParams.length; ++i) {
                        TapEnv.printOnTrace(paramUsefulnesses[i] + (i == actualParams.length - 1 ? "" : ","));
                    }
                    TapEnv.printlnOnTrace("]");
                    TapEnv.printlnOnTrace("    --------------------------------------------------------------------------");
                    TapEnv.printlnOnTrace();
                }
                for (i = actualParams.length - 1; i >= 0; --i) {
                    this.usefulnessThroughExpression(actualParams[i], paramUsefulnesses[i], usefuls, arrives, annotate);
                }
                break;
            }
            case 151: {
                this.usefulnessThroughExpression(expression.down(2), null, usefuls, arrives, annotate);
                TapList<Boolean> upperUsefulness = new TapList<Boolean>(Boolean.FALSE, usefulness);
                this.usefulnessThroughExpression(expression.down(1), upperUsefulness, usefuls, arrives, annotate);
                break;
            }
            case 75: {
                WrapperTypeSpec exprType = this.curSymbolTable.typeOf(expression.down(1));
                TapList<Object> upperUsefulness = usefulness;
                if (TypeSpec.isA(exprType, 21)) {
                    CompositeTypeSpec recordType = (CompositeTypeSpec)exprType.nestedLevelType();
                    int nbFields = recordType.fields.length;
                    upperUsefulness = null;
                    String fieldName = ILUtils.getIdentString(expression.down(2));
                    if (!this.curSymbolTable.isCaseDependent()) {
                        fieldName = fieldName.toLowerCase();
                    }
                    int fieldRank = recordType.namedFieldRank(fieldName);
                    for (int i = nbFields - 1; i >= 0; --i) {
                        upperUsefulness = i == fieldRank ? new TapList(usefulness, upperUsefulness) : new TapList<TapList<Boolean>>(new TapList<Boolean>(Boolean.FALSE, null), upperUsefulness);
                    }
                } else if (TypeSpec.isA(exprType, 23)) {
                    // empty if block
                }
                this.usefulnessThroughExpression(expression.down(1), upperUsefulness, usefuls, arrives, annotate);
                break;
            }
            case 9: {
                this.usefulnessThroughExpression(expression.down(2), null, usefuls, arrives, annotate);
            }
            case 96: {
                TapList<?> zonesTree = TapList.copyTree(this.curSymbolTable.treeOfZonesOfValue(expression, null, this.curInstruction, null));
                this.includePointedElementsInTree(zonesTree, null, null, true, false, true);
                this.setInfoBoolTreeToExtendedDeclaredZones(usefuls, this.curBlockMap, zonesTree, usefulness, null, false, this.diffKind);
                break;
            }
            case 3: 
            case 42: 
            case 62: 
            case 126: 
            case 133: 
            case 155: 
            case 182: {
                this.usefulnessThroughExpression(expression.down(1), usefulness, usefuls, arrives, annotate);
                this.usefulnessThroughExpression(expression.down(2), usefulness, usefuls, arrives, annotate);
                break;
            }
            case 124: {
                this.usefulnessThroughExpression(expression.down(1), usefulness, usefuls, arrives, annotate);
                break;
            }
            case 32: 
            case 194: {
                this.usefulnessThroughExpression(expression.down(2), usefulness, usefuls, arrives, annotate);
                break;
            }
            case 98: 
            case 139: 
            case 184: 
            case 189: 
            case 196: 
            case 205: 
            case 206: {
                TapList<Boolean> usefulTest = null;
                if (TapEnv.valid()) {
                    usefulTest = new TapList<Boolean>(Boolean.TRUE, null);
                }
                this.usefulnessThroughExpression(expression.down(1), usefulTest, usefuls, arrives, annotate);
                break;
            }
            case 99: {
                this.usefulnessThroughExpression(expression.down(1), null, usefuls, arrives, annotate);
                this.usefulnessThroughExpression(expression.down(2), usefulness, usefuls, arrives, annotate);
                this.usefulnessThroughExpression(expression.down(3), usefulness, usefuls, arrives, annotate);
                break;
            }
            case 109: {
                ToBool writtenTotal = new ToBool(false);
                boolean isIORead = ILUtils.isIORead(expression);
                Tree[] exprs = expression.down(3).children();
                for (int i = exprs.length - 1; i >= 0; --i) {
                    Tree expr = exprs[i];
                    if (isIORead) {
                        TapList<?> writtenZonesTree = this.curSymbolTable.treeOfZonesOfValue(expr, writtenTotal, this.curInstruction, null);
                        if (this.referenceIsTotal(writtenTotal.get(), writtenZonesTree)) {
                            this.setInfoBoolTreeToExtendedDeclaredZones(usefuls, this.curBlockMap, writtenZonesTree, false, null, true, this.diffKind);
                        }
                    }
                    this.usefulnessThroughExpression(expr, null, usefuls, arrives, annotate);
                }
                break;
            }
            case 121: {
                this.usefulnessThroughExpression(expression.down(3), null, usefuls, arrives, annotate);
                break;
            }
            case 80: {
                this.usefulnessThroughExpression(expression.down(1), null, usefuls, arrives, annotate);
                this.usefulnessThroughExpression(expression.down(2), null, usefuls, arrives, annotate);
                break;
            }
            case 64: 
            case 82: {
                this.usefulnessThroughExpression(expression.down(2), null, usefuls, arrives, annotate);
                this.usefulnessThroughExpression(expression.down(3), null, usefuls, arrives, annotate);
                this.usefulnessThroughExpression(expression.down(4), null, usefuls, arrives, annotate);
                break;
            }
            case 81: {
                this.usefulnessThroughExpression(expression.down(1), null, usefuls, arrives, annotate);
                this.usefulnessThroughExpression(expression.down(2), null, usefuls, arrives, annotate);
                break;
            }
            case 79: {
                this.usefulnessThroughExpression(expression.down(1), null, usefuls, arrives, annotate);
                this.usefulnessThroughExpression(expression.down(2), null, usefuls, arrives, annotate);
                this.usefulnessThroughExpression(expression.down(3), null, usefuls, arrives, annotate);
                break;
            }
            case 12: {
                this.usefulnessThroughExpression(expression.down(1), null, usefuls, arrives, annotate);
                this.usefulnessThroughExpression(expression.down(2), null, usefuls, arrives, annotate);
                this.usefulnessThroughExpression(expression.down(3), null, usefuls, arrives, annotate);
                break;
            }
            case 110: {
                this.usefulnessThroughExpression(expression.down(2), null, usefuls, arrives, annotate);
                Tree[] expressions = expression.down(1).children();
                for (int i = expressions.length - 1; i >= 0; --i) {
                    this.usefulnessThroughExpression(expressions[i], usefulness, usefuls, arrives, annotate);
                }
                break;
            }
            case 6: 
            case 18: 
            case 22: 
            case 24: 
            case 43: 
            case 68: 
            case 92: 
            case 95: 
            case 115: 
            case 116: 
            case 122: 
            case 137: 
            case 143: 
            case 169: 
            case 207: {
                TapList<Boolean> childUsefulness = null;
                if (TapEnv.valid()) {
                    childUsefulness = new TapList<Boolean>(Boolean.TRUE, null);
                }
                this.usefulnessThroughExpression(expression.down(1), childUsefulness, usefuls, arrives, annotate);
                this.usefulnessThroughExpression(expression.down(2), childUsefulness, usefuls, arrives, annotate);
                break;
            }
            case 71: 
            case 83: {
                Tree[] sons = expression.children();
                for (int i = sons.length - 1; i >= 0; --i) {
                    this.usefulnessThroughExpression(sons[i], null, usefuls, arrives, annotate);
                }
                break;
            }
            case 10: {
                Tree[] sons = expression.children();
                for (int i = sons.length - 1; i >= 0; --i) {
                    this.usefulnessThroughExpression(sons[i], usefulness, usefuls, arrives, annotate);
                }
                break;
            }
            case 47: {
                Tree[] expressions;
                for (Tree tree : expressions = expression.down(3).children()) {
                    TapList nextUsefulness;
                    if (usefulness == null) {
                        nextUsefulness = null;
                    } else if (usefulness.head instanceof TapList) {
                        nextUsefulness = (TapList)usefulness.head;
                        usefulness = usefulness.tail;
                    } else {
                        nextUsefulness = usefulness;
                    }
                    this.usefulnessThroughExpression(tree, nextUsefulness, usefuls, arrives, annotate);
                }
                break;
            }
            case 15: 
            case 20: 
            case 28: 
            case 40: 
            case 94: 
            case 103: 
            case 111: 
            case 118: 
            case 134: 
            case 138: 
            case 160: 
            case 180: 
            case 181: {
                break;
            }
            case 179: {
                if (arrives == null) break;
                arrives.set(false);
                break;
            }
            case 168: {
                ToBool lhsTotal;
                this.usefulnessThroughExpression(expression.down(2), null, usefuls, arrives, annotate);
                if (ILUtils.isNullOrNone(expression.down(1))) break;
                String returnVarName = this.curUnit.otherReturnVar() == null ? this.curUnit.name() : this.curUnit.otherReturnVar().symbol;
                Tree lhs = ILUtils.build(96, returnVarName);
                TapList<?> writtenZonesTree = this.curSymbolTable.treeOfZonesOfValue(lhs, lhsTotal = new ToBool(false), this.curInstruction, null);
                if (writtenZonesTree != null) {
                    this.includePointedElementsInTree(writtenZonesTree, null, null, true, false, false);
                }
                usefulness = TapList.cumulWithOper(usefulness, ADActivityAnalyzer.buildInfoBoolTreeOfDeclaredZones(writtenZonesTree, usefuls, this.curBlockMap, null, this.diffKind, this.curSymbolTable), 91);
                if (annotate) {
                    ActivityPattern.setAnnotationForActivityPattern(expression, this.curActivity, "Useful", usefulness);
                }
                this.usefulnessThroughExpression(expression.down(1), usefulness, usefuls, arrives, annotate);
                break;
            }
            case 4: {
                TapList<?> zonesTree = this.curSymbolTable.treeOfZonesOfValue(expression, null, this.curInstruction, null);
                this.setInfoBoolTreeToExtendedDeclaredZones(usefuls, this.curBlockMap, zonesTree, usefulness, null, false, this.diffKind);
                this.usefulnessThroughExpression(expression.down(1), usefulness == null ? null : usefulness.tail, usefuls, arrives, annotate);
                break;
            }
            case 5: {
                break;
            }
            case 52: 
            case 140: {
                this.usefulnessThroughExpression(expression.down(1), null, usefuls, arrives, annotate);
                break;
            }
            case 176: {
                this.usefulnessThroughExpression(expression.down(1), null, usefuls, arrives, annotate);
                break;
            }
            case 36: 
            case 46: 
            case 56: 
            case 89: {
                break;
            }
            case 11: 
            case 26: 
            case 153: {
                this.usefulnessThroughExpression(expression.down(1), null, usefuls, arrives, annotate);
                break;
            }
            case 2: 
            case 13: 
            case 29: 
            case 30: 
            case 35: 
            case 39: 
            case 41: 
            case 45: 
            case 49: 
            case 51: 
            case 67: 
            case 69: 
            case 74: 
            case 78: 
            case 91: 
            case 101: 
            case 104: 
            case 106: 
            case 108: 
            case 129: 
            case 135: 
            case 154: 
            case 161: 
            case 171: 
            case 192: 
            case 195: 
            case 197: 
            case 202: 
            case 204: {
                break;
            }
            case 144: 
            case 145: {
                break;
            }
            case 199: {
                Tree[] sons = expression.down(3).children();
                this.inADeclaration = true;
                for (int i = 0; i <= sons.length - 1; ++i) {
                    if (sons[i].opCode() != 14) continue;
                    ILUtils.turnAssignFromInitDecl(sons[i]);
                    this.usefulnessThroughExpression(sons[i], null, usefuls, arrives, annotate);
                    ILUtils.resetAssignFromInitDecl(sons[i]);
                }
                this.inADeclaration = false;
                break;
            }
            default: {
                TapEnv.toolWarning(-1, "(Compute AD usefulness) Unexpected operator: " + expression.opName());
            }
        }
    }

    private void bufferizeCallContext(Unit calledUnit, Tree callExpression, BoolVector context, Boolean channelContext, BoolVector publicUsefulOnCallingSide, int contextSort) {
        TapTriplet<BoolVector[], Boolean[], Instruction> ctxt3;
        Boolean[] channelContextPair;
        BoolVector[] callSiteContext;
        TapList callSitesContexts;
        TapPair callSiteContextCell;
        TapPair<Unit, Object> unitContexts = TapList.assq(calledUnit, this.callContextsBuffer);
        if (unitContexts == null) {
            unitContexts = new TapPair<Unit, Object>(calledUnit, null);
            this.callContextsBuffer = new TapList<TapPair<Unit, TapList<TapPair<Tree, TapTriplet<BoolVector[], Boolean[], Instruction>>>>>(unitContexts, this.callContextsBuffer);
        }
        if ((callSiteContextCell = TapList.assq(callExpression, callSitesContexts = (TapList)unitContexts.second)) == null) {
            callSiteContext = new BoolVector[4];
            for (int i = 3; i >= 0; --i) {
                callSiteContext[i] = null;
            }
            channelContextPair = channelContext != null ? new Boolean[2] : null;
            ctxt3 = new TapTriplet<BoolVector[], Boolean[], Instruction>(callSiteContext, channelContextPair, this.curInstruction);
            unitContexts.second = new TapList<TapPair<Tree, TapTriplet<BoolVector[], Boolean[], Instruction>>>(new TapPair<Tree, TapTriplet<BoolVector[], Boolean[], Instruction>>(callExpression, ctxt3), callSitesContexts);
        } else {
            ctxt3 = (TapTriplet<BoolVector[], Boolean[], Instruction>)callSiteContextCell.second;
            callSiteContext = (BoolVector[])ctxt3.first;
            channelContextPair = (Boolean[])ctxt3.second;
        }
        if (contextSort == 3) {
            if (callSiteContext[0] == null) {
                callSiteContext[0] = new BoolVector(calledUnit.paramElemsNb());
            }
            if (callSiteContext[1] == null) {
                callSiteContext[1] = new BoolVector(calledUnit.paramElemsNb());
            }
        } else {
            if (callSiteContext[contextSort] == null) {
                callSiteContext[contextSort] = context;
            } else {
                callSiteContext[contextSort].cumulOr(context, calledUnit.paramElemsNb());
            }
            if (channelContext != null && channelContextPair != null && channelContext.booleanValue()) {
                channelContextPair[contextSort] = Boolean.TRUE;
            }
        }
        if (publicUsefulOnCallingSide != null) {
            if (callSiteContext[3] == null) {
                callSiteContext[3] = publicUsefulOnCallingSide;
            } else {
                callSiteContext[3].cumulOr(publicUsefulOnCallingSide);
            }
        }
        if (this.curStaticActivity != null && callSiteContext[2] == null) {
            CallArrow callArrow = CallGraph.getCallArrow(this.curUnit, calledUnit);
            BoolVector extendedStaticActivity = this.curStaticActivity.copy(ADActivityAnalyzer.mapSize(this.entryMap), ADActivityAnalyzer.mapSize(this.curBlockMap));
            TapList[] actualParamDataS = new TapList[ILUtils.getArguments(callExpression).length()];
            for (int i = actualParamDataS.length - 1; i >= 0; --i) {
                actualParamDataS[i] = new TapList<Object>(null, null);
            }
            callSiteContext[2] = this.propagateEntryDataFwdToCallee(extendedStaticActivity, this.curBlockMap, actualParamDataS, null, callArrow, null, this.diffKind, false);
        }
    }

    private void accumulateBufferizedCallContexts() {
        if (TapEnv.traceCurAnalysis() && this.callContextsBuffer != null) {
            TapEnv.printlnOnTrace("       =======  CALL CONTEXTS SUMMARY: ======");
        }
        while (this.callContextsBuffer != null) {
            TapPair unitContexts = (TapPair)this.callContextsBuffer.head;
            Unit calledUnit = (Unit)unitContexts.first;
            BoolMatrix calleePublicDeps = ADActivityAnalyzer.getPublicDeps(calledUnit, this.dependencies, this.diffKind);
            if (calleePublicDeps != null) {
                int shapeLength = calledUnit.paramElemsNb();
                TapList callSitesContexts = (TapList)unitContexts.second;
                while (callSitesContexts != null) {
                    Tree callSiteTree = (Tree)((TapPair)callSitesContexts.head).first;
                    TapTriplet ctxt3 = (TapTriplet)((TapPair)callSitesContexts.head).second;
                    BoolVector[] callSiteContext = (BoolVector[])ctxt3.first;
                    boolean traceCalledUnitAnalysis = TapList.contains(this.tracedUnits, calledUnit);
                    MPIcallInfo messagePassingInfo = MPIcallInfo.getMessagePassingMPIcallInfo(calledUnit.name(), callSiteTree, this.curUnit.language(), ((Instruction)ctxt3.third).block);
                    if (TapEnv.traceCurAnalysis() || traceCalledUnitAnalysis) {
                        TapEnv.printlnOnTrace();
                        TapEnv.printlnOnTrace("         encountered new context for " + calledUnit + " at " + ILUtils.toString(callSiteTree) + " in " + ((Instruction)ctxt3.third).block + " of " + ((Instruction)ctxt3.third).block.unit());
                        TapEnv.printlnOnTrace("                " + (callSiteContext[0] == null ? "null" : "[" + callSiteContext[0].toString(shapeLength) + "]") + " -> " + (callSiteContext[1] == null ? "null" : "[" + callSiteContext[1].toString(shapeLength) + "]") + " plus static actives: [" + callSiteContext[2].toString(shapeLength) + "] and messagePassingInfo:" + messagePassingInfo);
                    }
                    if (messagePassingInfo == null) {
                        BoolVector additionalStaticActivity = new BoolVector(shapeLength);
                        this.filterVariedUsefulWithDeps(callSiteContext[0], callSiteContext[1], calledUnit, null, additionalStaticActivity);
                        callSiteContext[2].cumulOr(additionalStaticActivity);
                    }
                    if (callSiteContext[0].isFalse(shapeLength) && callSiteContext[1].isFalse(shapeLength)) {
                        if (TapEnv.traceCurAnalysis() || traceCalledUnitAnalysis) {
                            TapEnv.printlnOnTrace("            new filtered context is inactive: don't create a new activity pattern");
                        }
                    } else {
                        ActivityPattern totalActivity;
                        boolean callSiteMustSpecialize = calledUnit.hasDirective(27) != null || ((Instruction)ctxt3.third).hasDirective(27) != null;
                        ActivityPattern existingGeneralizableContext = null;
                        int distanceFromGeneralizable = 2 * shapeLength;
                        ActivityPattern existingContainingContext = null;
                        int distanceFromContaining = 2 * shapeLength;
                        ActivityPattern existingEqualContext = null;
                        TapList<ActivityPattern> existingContexts = calledUnit.activityPatterns;
                        if (existingContexts != null) {
                            for (ActivityPattern existingContext : existingContexts) {
                                if (existingContext.variedOnCall().equals(callSiteContext[0], shapeLength) && existingContext.usefulOnExit().equals(callSiteContext[1], shapeLength) && existingContext.staticActivity().equals(callSiteContext[2], shapeLength)) {
                                    existingEqualContext = existingContext;
                                    continue;
                                }
                                if (callSiteMustSpecialize) continue;
                                int distanceFromContext = existingContext.variedOnCall().distance(callSiteContext[0], shapeLength) + existingContext.usefulOnExit().distance(callSiteContext[1], shapeLength);
                                if (existingContext.variedOnCall().contains(callSiteContext[0], shapeLength) && existingContext.usefulOnExit().contains(callSiteContext[1], shapeLength) && existingContext.staticActivity().contains(callSiteContext[2], shapeLength) && distanceFromContext <= distanceFromContaining) {
                                    existingContainingContext = existingContext;
                                    distanceFromContaining = distanceFromContext;
                                }
                                if (!existingContext.isGeneralizable() || distanceFromContext > distanceFromGeneralizable) continue;
                                existingGeneralizableContext = existingContext;
                                distanceFromGeneralizable = distanceFromContext;
                            }
                        }
                        if (existingEqualContext != null) {
                            totalActivity = existingEqualContext;
                            existingEqualContext.registerCallingActivityPattern(this.curActivity);
                            existingEqualContext.staticActivity().cumulOr(callSiteContext[2]);
                            if (callSiteContext[3] != null) {
                                if (existingEqualContext.usefulOnCallingSide() == null) {
                                    existingEqualContext.setUsefulOnCallingSide(callSiteContext[3]);
                                } else {
                                    existingEqualContext.usefulOnCallingSide().cumulOr(callSiteContext[3]);
                                }
                            }
                            if (TapEnv.traceCurAnalysis() || traceCalledUnitAnalysis) {
                                TapEnv.printlnOnTrace("            found existing same activity context @" + Integer.toHexString(existingEqualContext.hashCode()) + " for " + calledUnit + ":");
                                TapEnv.printlnOnTrace("                [" + existingEqualContext.variedOnCall().toString(shapeLength) + "] -> [" + existingEqualContext.usefulOnExit().toString(shapeLength) + "] plus static actives: [" + existingEqualContext.staticActivity().toString(shapeLength) + "]");
                            }
                        } else if (existingContainingContext != null) {
                            totalActivity = existingContainingContext;
                            existingContainingContext.registerCallingActivityPattern(this.curActivity);
                            existingContainingContext.staticActivity().cumulOr(callSiteContext[2]);
                            if (callSiteContext[3] != null) {
                                if (existingContainingContext.usefulOnCallingSide() == null) {
                                    existingContainingContext.setUsefulOnCallingSide(callSiteContext[3]);
                                } else {
                                    existingContainingContext.usefulOnCallingSide().cumulOr(callSiteContext[3]);
                                }
                            }
                            if (TapEnv.traceCurAnalysis() || traceCalledUnitAnalysis) {
                                TapEnv.printlnOnTrace("            see it as included in existing context @" + Integer.toHexString(existingContainingContext.hashCode()) + " for " + calledUnit + ":");
                                TapEnv.printlnOnTrace("                [" + existingContainingContext.variedOnCall().toString(shapeLength) + "] -> [" + existingContainingContext.usefulOnExit().toString(shapeLength) + "] plus static actives: [" + existingContainingContext.staticActivity().toString(shapeLength) + "]");
                            }
                        } else if (existingGeneralizableContext != null) {
                            totalActivity = existingGeneralizableContext;
                            existingGeneralizableContext.registerCallingActivityPattern(this.curActivity);
                            if (TapEnv.traceCurAnalysis() || traceCalledUnitAnalysis) {
                                TapEnv.printlnOnTrace("            acumulate it into existing activity context @" + Integer.toHexString(existingGeneralizableContext.hashCode()) + " for " + calledUnit + ":");
                                TapEnv.printlnOnTrace("                [" + existingGeneralizableContext.variedOnCall().toString(shapeLength) + "] -> [" + existingGeneralizableContext.usefulOnExit().toString(shapeLength) + "] plus static actives: [" + existingGeneralizableContext.staticActivity().toString(shapeLength) + "]");
                            }
                            if (existingGeneralizableContext.variedOnCall().cumulOrGrows(callSiteContext[0], shapeLength)) {
                                calledUnit.analysisIsOutOfDateDown = true;
                            }
                            if (existingGeneralizableContext.usefulOnExit().cumulOrGrows(callSiteContext[1], shapeLength)) {
                                calledUnit.analysisIsOutOfDateDown = true;
                            }
                            if (existingGeneralizableContext.staticActivity().cumulOrGrows(callSiteContext[2], shapeLength)) {
                                calledUnit.analysisIsOutOfDateDown = true;
                            }
                            if (callSiteContext[3] != null) {
                                if (existingGeneralizableContext.usefulOnCallingSide() == null) {
                                    existingGeneralizableContext.setUsefulOnCallingSide(callSiteContext[3]);
                                } else {
                                    existingGeneralizableContext.usefulOnCallingSide().cumulOr(callSiteContext[3]);
                                }
                            }
                            if (TapEnv.traceCurAnalysis() || traceCalledUnitAnalysis) {
                                TapEnv.printlnOnTrace("            that " + (calledUnit.analysisIsOutOfDateDown ? "becomes" : "remains") + ":");
                                TapEnv.printlnOnTrace("                [" + existingGeneralizableContext.variedOnCall().toString(shapeLength) + "] -> [" + existingGeneralizableContext.usefulOnExit().toString(shapeLength) + "] plus static actives: [" + existingGeneralizableContext.staticActivity().toString(shapeLength) + "]");
                                if (calledUnit.analysisIsOutOfDateDown) {
                                    TapEnv.printlnOnTrace("            => larger context, requires reanalysis of " + calledUnit);
                                }
                            }
                            if (calledUnit.isIntrinsic()) {
                                this.computeUnitFrontierActivities(calledUnit, totalActivity, callSiteContext[0], callSiteContext[1]);
                            }
                        } else {
                            ActivityPattern newContext = new ActivityPattern(calledUnit, callSiteContext[0], callSiteContext[1], !callSiteMustSpecialize, this.diffKind);
                            newContext.registerCallingActivityPattern(this.curActivity);
                            newContext.setStaticActivity(callSiteContext[2]);
                            if (callSiteContext[3] != null) {
                                newContext.setUsefulOnCallingSide(callSiteContext[3]);
                            }
                            calledUnit.analysisIsOutOfDateDown = true;
                            calledUnit.activityPatterns = new TapList<ActivityPattern>(newContext, calledUnit.activityPatterns);
                            if (TapEnv.traceCurAnalysis() || traceCalledUnitAnalysis) {
                                TapEnv.printlnOnTrace("            prepend it as a new activity context @" + Integer.toHexString(newContext.hashCode()) + " for " + calledUnit + ":");
                                TapEnv.printlnOnTrace("                [" + newContext.variedOnCall().toString(shapeLength) + "] -> [" + newContext.usefulOnExit().toString(shapeLength) + "] plus static actives: [" + newContext.staticActivity().toString(shapeLength) + "]");
                                TapEnv.printlnOnTrace("             => requires reanalysis of " + calledUnit);
                            }
                            if (calledUnit.isIntrinsic()) {
                                this.computeUnitFrontierActivities(calledUnit, newContext, callSiteContext[0], callSiteContext[1]);
                            }
                            totalActivity = newContext;
                        }
                        ActivityPattern.setAnnotationForActivityPattern(callSiteTree, this.curActivity, "multiActivityCalleePatterns", totalActivity);
                    }
                    callSitesContexts = callSitesContexts.tail;
                }
            }
            this.callContextsBuffer = this.callContextsBuffer.tail;
        }
    }

    private void checkVariedBadCast(BoolVector varieds, Tree expression, Unit curUnit) {
        Unit calledUnit;
        Operator operator = expression.operator();
        if (operator.code == 31 && (calledUnit = ADActivityAnalyzer.getCalledUnit(expression, this.curSymbolTable)) != null && calledUnit.unitInOutR() != null) {
            CallArrow arrow = CallGraph.getCallArrow(curUnit, calledUnit);
            Tree[] actualParams = ILUtils.getArguments(expression).children();
            BoolVector copyVarieds = varieds.copy();
            TapList[] paramVariednesses = new TapList[actualParams.length];
            for (int i = actualParams.length - 1; i >= 0; --i) {
                paramVariednesses[i] = this.variednessThroughExpression(actualParams[i], copyVarieds, null, false);
            }
            BoolVector publicVariedness = this.propagateEntryDataFwdToCallee(copyVarieds, this.curBlockMap, paramVariednesses, null, arrow, actualParams, this.diffKind, false);
            for (int i = calledUnit.paramElemsNb() - 1; i >= 0; --i) {
                WrapperTypeSpec typeSpec;
                if (!publicVariedness.get(i) || !ADActivityAnalyzer.dataOfParamElemOLD(calledUnit.unitInOutPossiblyR(), i, 0, calledUnit)) continue;
                ZoneInfo zi = calledUnit.paramElemZoneInfo(i);
                TypeSpec formalType = zi.type.wrappedType;
                if (formalType == null && !zi.isHidden && zi.accessTree != null && zi.accessTree.opCode() != 96 && calledUnit.publicSymbolTable() != null && (typeSpec = calledUnit.publicSymbolTable().typeOf(ILUtils.baseTree(zi.accessTree))) != null) {
                    formalType = typeSpec.wrappedType;
                }
                if (TypeSpec.isDifferentiableType(formalType)) continue;
                TapEnv.fileWarning(15, expression, "(AD01) Actual argument " + zi.publicName() + " of " + calledUnit.name() + " is varied while formal argument is non-differentiable");
            }
        }
        if (!expression.isAtom()) {
            Tree[] subTrees = expression.children();
            for (int i = subTrees.length - 1; i >= 0; --i) {
                this.checkVariedBadCast(varieds, subTrees[i], curUnit);
            }
        }
    }

    private void checkUsefulBadCast(BoolVector usefuls, Tree expression, Unit curUnit) {
        Unit calledUnit;
        Operator operator = expression.operator();
        if (operator.code == 31 && (calledUnit = ADActivityAnalyzer.getCalledUnit(expression, this.curSymbolTable)) != null && calledUnit.unitInOutW() != null) {
            CallArrow arrow = CallGraph.getCallArrow(curUnit, calledUnit);
            Tree[] actualParams = ILUtils.getArguments(expression).children();
            BoolVector copyUsefuls = usefuls.copy();
            TapList<Boolean> resultUsefulness = new TapList<Boolean>(Boolean.FALSE, null);
            BoolVector publicUsefulness = this.propagateExitDataBwdToCallee(copyUsefuls, this.curBlockMap, resultUsefulness, null, arrow, actualParams, this.diffKind, false, null, false, false);
            for (int i = calledUnit.paramElemsNb() - 1; i >= 0; --i) {
                WrapperTypeSpec typeSpec;
                if (!publicUsefulness.get(i) || !ADActivityAnalyzer.dataOfParamElemOLD(calledUnit.unitInOutPossiblyW(), i, 0, calledUnit)) continue;
                ZoneInfo zi = calledUnit.paramElemZoneInfo(i);
                TypeSpec formalType = zi.type.wrappedType;
                if (formalType == null && !zi.isHidden && zi.accessTree != null && zi.accessTree.opCode() != 96 && calledUnit.publicSymbolTable() != null && (typeSpec = calledUnit.publicSymbolTable().typeOf(ILUtils.baseTree(zi.accessTree))) != null) {
                    formalType = typeSpec.wrappedType;
                }
                if (TypeSpec.isDifferentiableType(formalType)) continue;
                TapEnv.fileWarning(15, expression, "(AD02) Actual output " + zi.publicName() + " of " + calledUnit.name() + " is useful while formal result is non-differentiable");
            }
        }
        if (!expression.isAtom()) {
            Tree[] subTrees = expression.children();
            for (int i = subTrees.length - 1; i >= 0; --i) {
                this.checkUsefulBadCast(usefuls, subTrees[i], curUnit);
            }
        }
    }

    private void checkVariedIO(BoolVector varieds, Tree tree) {
        Tree fileTree;
        if (ILUtils.isIOWrite(tree) && (fileTree = this.accessesToFile(tree.down(2))) != null) {
            tree = tree.down(3);
            for (int i = tree.length(); i > 0; --i) {
                Tree expr = tree.down(i);
                TapIntList readZonesList = ZoneInfo.listAllZones(this.curSymbolTable.treeOfZonesOfValue(expr, null, this.curInstruction, null), true);
                if (!ADActivityAnalyzer.intersectsExtendedDeclared(varieds, this.curBlockMap, this.diffKind, readZonesList, null, this.curSymbolTable, null)) continue;
                TapEnv.fileWarning(15, expr, "(AD03) Varied variable " + ILUtils.toString(expr, this.curUnit.language()) + " written by I-O to file " + ILUtils.toString(fileTree));
            }
        }
    }

    private void checkUsefulIO(BoolVector usefuls, Tree tree) {
        Tree fileTree;
        if (ILUtils.isIORead(tree) && (fileTree = this.accessesToFile(tree.down(2))) != null) {
            tree = tree.down(3);
            for (int i = tree.length(); i > 0; --i) {
                Tree expr = tree.down(i);
                TapIntList writtenZonesList = ZoneInfo.listAllZones(this.curSymbolTable.treeOfZonesOfValue(expr, null, this.curInstruction, null), true);
                if (!ADActivityAnalyzer.intersectsExtendedDeclared(usefuls, this.curBlockMap, this.diffKind, writtenZonesList, null, this.curSymbolTable, null)) continue;
                TapEnv.fileWarning(15, expr, "(AD04) Useful variable " + ILUtils.toString(expr, this.curUnit.language()) + " read by I-O from file " + ILUtils.toString(fileTree));
            }
        }
    }

    private Tree accessesToFile(Tree ioSpecs) {
        Tree[] specs = ioSpecs.children();
        if (specs.length == 0) {
            return null;
        }
        int destination = specs[0].opCode();
        if (destination != 138 && destination != 177) {
            return specs[0];
        }
        return null;
    }

    private String diffParamsOf(BoolVector unitCallVariedness, BoolVector unitExitUsefulness, ZoneInfo[] externalShape) {
        String result = "";
        int shapeLength = externalShape == null ? -1 : externalShape.length;
        for (int i = 0; i < shapeLength; ++i) {
            if (!unitCallVariedness.get(i) && !unitExitUsefulness.get(i)) continue;
            String inout = unitCallVariedness.get(i) ? (unitExitUsefulness.get(i) ? "(in;out)" : "(in)") : "(out)";
            assert (externalShape != null);
            ZoneInfo argInfo = externalShape[i];
            result = result + ' ' + argInfo.publicName() + '=' + inout;
        }
        return result;
    }

    private void checkCalledFunctionsActivities() {
        TapList<Block> allBlocks = this.curUnit.allBlocks;
        while (allBlocks != null) {
            this.setCurBlockEtc((Block)allBlocks.head);
            TapList<Instruction> instructions = this.curBlock.instructions;
            while (instructions != null) {
                if (((Instruction)instructions.head).tree != null) {
                    this.checkCalledFunctionsActivitiesInTree(((Instruction)instructions.head).tree);
                }
                instructions = instructions.tail;
            }
            allBlocks = allBlocks.tail;
        }
        this.setCurBlockEtc(null);
    }

    public boolean unitIsContext(ActivityPattern pattern) {
        Unit unit = pattern.unit();
        int nbPubZ = unit.paramElemsNb();
        BoolVector callActivity = pattern.callActivity();
        BoolVector exitActivity = pattern.exitActivity();
        return !(callActivity != null && !callActivity.isFalse(nbPubZ) || exitActivity != null && !exitActivity.isFalse(nbPubZ));
    }

    private void checkCalledFunctionsActivitiesInTree(Tree tree) {
        block20: {
            block19: {
                if (tree.opCode() != 31) break block19;
                Unit calledUnit = ADActivityAnalyzer.getCalledUnit(tree, this.curSymbolTable);
                ActivityPattern curCalledActivity = (ActivityPattern)ActivityPattern.getAnnotationForActivityPattern(tree, this.curActivity, "multiActivityCalleePatterns");
                if (calledUnit != null && curCalledActivity != null && calledUnit.hasParamElemsInfo() && !calledUnit.hasSource() && !MPIcallInfo.isMessagePassingFunction(calledUnit.name(), this.curUnit.language())) {
                    BoolVector unitCallActivity = curCalledActivity.callActivity();
                    BoolVector unitExitActivity = curCalledActivity.exitActivity();
                    int shapeLength = calledUnit.paramElemsNb();
                    if (!(shapeLength <= 0 || unitCallActivity == null || unitExitActivity == null || unitCallActivity.isFalse(shapeLength) && unitExitActivity.isFalse(shapeLength))) {
                        String diffVars;
                        FunctionDecl funcDecl;
                        TapList<FunctionDecl> funcDecls = this.curSymbolTable.getFunctionDecl(calledUnit.name(), null, null, false);
                        FunctionDecl functionDecl = funcDecl = funcDecls == null ? null : (FunctionDecl)funcDecls.head;
                        if (funcDecl != null) {
                            funcDecl.setActive();
                        }
                        if (calledUnit.isVarFunction() || calledUnit.isInterface()) {
                            this.accumulateVarFunctionADActivity(this.curUnit, this.curActivity, null, ILUtils.getCalledNameString(tree), new TapTriplet<Unit, BoolVector, BoolVector>(calledUnit, unitCallActivity, unitExitActivity));
                        }
                        if (!(calledUnit.isInterface() || calledUnit.hasPredefinedDerivatives() || (diffVars = this.diffParamsOf(unitCallActivity, unitExitActivity, calledUnit.externalShape)).contains("%message_passing_channel_"))) {
                            TapEnv.fileWarning(15, tree, "(AD09) Please provide a differential of function " + calledUnit.name() + " for arguments" + diffVars);
                        }
                    }
                }
                Tree[] actualParams = ILUtils.getArguments(tree).children();
                TapTriplet<Unit, BoolVector, BoolVector>[] calledVarFunctionInfos = null;
                if (calledUnit != null && curCalledActivity != null) {
                    calledVarFunctionInfos = curCalledActivity.varFunctionADActivities();
                }
                if (calledVarFunctionInfos == null) break block20;
                int minArgsLength = Math.min(actualParams.length, calledVarFunctionInfos.length);
                for (int i = minArgsLength - 1; i >= 0; --i) {
                    int calledUnitLength;
                    if (actualParams[i].opCode() != 96) continue;
                    String passedName = ILUtils.getIdentString(actualParams[i]);
                    TapList<FunctionDecl> passedDecls = this.curSymbolTable.getFunctionDecl(passedName, null, null, false);
                    FunctionDecl passedDecl = passedDecls == null ? null : (FunctionDecl)passedDecls.head;
                    SymbolDecl passedNameSymbolDecl = this.curSymbolTable.getSymbolDecl(passedName);
                    if (passedDecl == null || passedNameSymbolDecl == null || !passedNameSymbolDecl.isA(3) && !passedNameSymbolDecl.isA(6) && !passedNameSymbolDecl.isA(16)) continue;
                    Unit passedUnit = passedDecl.unit();
                    TapTriplet<Unit, BoolVector, BoolVector> calledVarFunctionInfo = calledVarFunctionInfos[i];
                    int n = calledUnitLength = calledUnit.hasParamElemsInfo() ? calledUnit.paramElemsNb() : -1;
                    if (!(calledVarFunctionInfo != null || calledUnit.hasSource() || calledUnitLength == -1 || curCalledActivity.callActivity().isFalse(calledUnitLength) && curCalledActivity.exitActivity().isFalse(calledUnitLength) || passedUnit != null && passedUnit.hasSource())) {
                        calledVarFunctionInfos[i] = calledVarFunctionInfo = new TapTriplet<Unit, BoolVector, BoolVector>(passedUnit, new BoolVector(0), new BoolVector(0));
                    }
                    if (calledVarFunctionInfo == null) continue;
                    passedDecl.setActive();
                    ADActivityAnalyzer.setAnnotatedActive(this.curActivity, actualParams[i]);
                    if (this.curUnit != null) {
                        if (passedUnit != null) {
                            ActivityPattern passedUnitActivityPattern;
                            if (passedUnit.activityPatterns == null) {
                                passedUnitActivityPattern = new ActivityPattern(passedUnit, true, true, this.diffKind);
                                if (passedUnit.isStandard()) {
                                    passedUnitActivityPattern.setDontDiff(true);
                                }
                                passedUnit.activityPatterns = new TapList<ActivityPattern>(passedUnitActivityPattern, null);
                            } else {
                                passedUnitActivityPattern = (ActivityPattern)passedUnit.activityPatterns.head;
                                passedUnitActivityPattern.setForcedActive(true);
                            }
                            passedUnitActivityPattern.registerCallingActivityPattern(this.curActivity);
                            BoolVector newInfo = ADActivityAnalyzer.convertPublicInfoFromUnitToUnit((BoolVector)calledVarFunctionInfo.second, (Unit)calledVarFunctionInfo.first, passedUnit);
                            BoolVector cumulInfo = passedUnitActivityPattern.callActivity();
                            if (cumulInfo == null) {
                                passedUnitActivityPattern.setCallActivity(newInfo);
                            } else {
                                cumulInfo.cumulOr(newInfo);
                            }
                            newInfo = ADActivityAnalyzer.convertPublicInfoFromUnitToUnit((BoolVector)calledVarFunctionInfo.third, (Unit)calledVarFunctionInfo.first, passedUnit);
                            cumulInfo = passedUnitActivityPattern.exitActivity();
                            if (cumulInfo == null) {
                                passedUnitActivityPattern.setExitActivity(newInfo);
                            } else {
                                cumulInfo.cumulOr(newInfo);
                            }
                        }
                        this.accumulateVarFunctionADActivity(this.curUnit, this.curActivity, null, passedName, calledVarFunctionInfo);
                        this.accumulateVarFunctionADActivity(calledUnit, curCalledActivity, tree, passedName, calledVarFunctionInfo);
                    }
                    if (passedUnit == null || passedUnit.isInterface()) continue;
                    String diffVars = this.diffParamsOf((BoolVector)calledVarFunctionInfo.second, (BoolVector)calledVarFunctionInfo.third, ((Unit)calledVarFunctionInfo.first).externalShape);
                    TapEnv.fileWarning(15, actualParams[i], "(AD09) Please provide a differential of function " + passedUnit.name() + (diffVars.isEmpty() ? "" : " for arguments" + diffVars));
                }
                break block20;
            }
            if (!tree.isAtom()) {
                Tree[] subTrees = tree.children();
                for (int i = subTrees.length - 1; i >= 0; --i) {
                    this.checkCalledFunctionsActivitiesInTree(subTrees[i]);
                }
            }
        }
    }

    private void accumulateVarFunctionADActivity(Unit unit, ActivityPattern unitActivity, Tree callTree, String argName, TapTriplet<Unit, BoolVector, BoolVector> activityUsefulness) {
        if (callTree == null) {
            callTree = unit.entryBlock().headTree();
        }
        assert (callTree != null);
        Tree[] formalParams = ILUtils.getArguments(callTree).children();
        TapTriplet<Unit, BoolVector, BoolVector>[] varFunctionInfos = unitActivity.varFunctionADActivities();
        for (int i = formalParams.length - 1; i >= 0; --i) {
            Tree arg = formalParams[i];
            if (arg.opCode() != 96 || !ILUtils.getIdentString(arg).equals(argName)) continue;
            if (varFunctionInfos[i] == null) {
                varFunctionInfos[i] = activityUsefulness;
                continue;
            }
            ((BoolVector)varFunctionInfos[i].second).cumulOr((BoolVector)activityUsefulness.second);
            ((BoolVector)varFunctionInfos[i].third).cumulOr((BoolVector)activityUsefulness.third);
        }
    }

    public boolean isActiveUnit(Unit unit) {
        TapList<ActivityPattern> activityPatterns = unit.activityPatterns;
        while (activityPatterns != null) {
            ActivityPattern curActivity = (ActivityPattern)activityPatterns.head;
            if (this.isActiveUnit(curActivity)) {
                return true;
            }
            activityPatterns = activityPatterns.tail;
        }
        return false;
    }

    public boolean isActiveUnit(ActivityPattern pattern) {
        Unit unit = pattern.unit();
        if (unit.isModule()) {
            return false;
        }
        if (unit.rank() < 0) {
            if (pattern.isActive()) {
                BoolMatrix unitPublicDeps = ADActivityAnalyzer.getPublicDeps(unit, this.dependencies, this.diffKind);
                assert (unitPublicDeps != null);
                int shapeLength = unitPublicDeps.nRows;
                BoolVector dummyVoC = new BoolVector(shapeLength);
                dummyVoC.setTrue();
                BoolVector dummyUoE = new BoolVector(shapeLength);
                dummyUoE.setTrue();
                this.filterVariedUsefulWithDeps(dummyVoC, dummyUoE, unit, null, null);
                return TypeSpec.isDifferentiableType(unit.functionTypeSpec()) && !dummyVoC.isFalse(shapeLength) && !dummyUoE.isFalse(shapeLength);
            }
            return false;
        }
        if (!unit.hasParamElemsInfo()) {
            TapList<CallArrow> callers = unit.callers();
            boolean activeCaller = false;
            while (!activeCaller && callers != null) {
                if (((CallArrow)callers.head).isCall()) {
                    Unit callerUnit = ((CallArrow)callers.head).origin;
                    TapList<ActivityPattern> callerActivities = callerUnit.activityPatterns;
                    while (!activeCaller && callerActivities != null) {
                        activeCaller = this.isActiveUnit((ActivityPattern)callerActivities.head);
                        callerActivities = callerActivities.tail;
                    }
                }
                callers = callers.tail;
            }
            return activeCaller;
        }
        return pattern.isActive();
    }

    private TapList activityOnlyForReal(TapList exprActivity, Tree expr) {
        if (this.diffKind == 1 || this.curSymbolTable.typeOf(expr).isRealOrComplexBase()) {
            return exprActivity;
        }
        return null;
    }

    private TapList depsOnlyForReal(TapList exprDeps, Tree expr) {
        if (this.diffKind == 1 || this.curSymbolTable.typeOf(expr).isRealOrComplexBase()) {
            return exprDeps;
        }
        return null;
    }

    private BoolMatrix accumulateDepIn(Block block) {
        BoolMatrix depIn = null;
        TapList<FGArrow> arrows = block.backFlow();
        while (arrows != null) {
            Block origin = ((FGArrow)arrows.head).origin;
            BoolMatrix depIncoming = this.depsOut.retrieve(origin);
            if (depIncoming != null) {
                if (depIn == null) {
                    int nUDRZ = this.curUnit.publicSymbolTable().declaredZonesNb(this.diffKind);
                    depIn = new BoolMatrix(this.nDRZ, nUDRZ);
                }
                SymbolTable commonSymbolTable = block.symbolTable.getCommonRoot(origin.symbolTable);
                depIn.cumulOr(depIncoming, true, commonSymbolTable.declaredZonesNb(this.diffKind));
            }
            arrows = arrows.tail;
        }
        return depIn;
    }

    public BoolMatrix getPublicDeps(Unit unit) {
        return ADActivityAnalyzer.getPublicDeps(unit, this.dependencies, this.diffKind);
    }
}

