/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.frontc;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PreprocessorInfoChannel {
    private final Hashtable lineLists = new Hashtable();
    private int firstValidTokenNumber;
    private int maxTokenNumber;

    public void addLineForTokenNumber(Object line, Integer toknum) {
        if (this.lineLists.containsKey(toknum)) {
            Vector lines = (Vector)this.lineLists.get(toknum);
            lines.addElement(line);
        } else {
            Vector<Object> lines = new Vector<Object>();
            lines.addElement(line);
            this.lineLists.put(toknum, lines);
            if (this.maxTokenNumber < toknum) {
                this.maxTokenNumber = toknum;
            }
        }
    }

    public int getMaxTokenNumber() {
        return this.maxTokenNumber;
    }

    public Vector extractLinesPrecedingTokenNumber(Integer toknum) {
        Vector lines = new Vector();
        if (toknum == null) {
            return lines;
        }
        for (int i = this.firstValidTokenNumber; i < toknum; ++i) {
            Vector tokenLineVector;
            Integer inti = i;
            if (!this.lineLists.containsKey(inti) || (tokenLineVector = (Vector)this.lineLists.get(inti)) == null) continue;
            Enumeration tokenLines = tokenLineVector.elements();
            while (tokenLines.hasMoreElements()) {
                lines.addElement(tokenLines.nextElement());
            }
            this.lineLists.remove(inti);
        }
        this.firstValidTokenNumber = toknum;
        return lines;
    }

    public Vector extractLinesBetweenTokenNumbers(Integer first, Integer last) {
        Vector lines = new Vector();
        if (first == null || last == null) {
            return lines;
        }
        for (int i = first.intValue(); i < last; ++i) {
            Vector tokenLineVector;
            Integer inti = i;
            if (!this.lineLists.containsKey(inti) || (tokenLineVector = (Vector)this.lineLists.get(inti)) == null) continue;
            Enumeration tokenLines = tokenLineVector.elements();
            while (tokenLines.hasMoreElements()) {
                lines.addElement(tokenLines.nextElement());
            }
            this.lineLists.remove(inti);
        }
        return lines;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PreprocessorInfoChannel:\n");
        for (int i = 0; i <= this.maxTokenNumber + 1; ++i) {
            Vector tokenLineVector;
            Integer inti = i;
            if (!this.lineLists.containsKey(inti) || (tokenLineVector = (Vector)this.lineLists.get(inti)) == null) continue;
            Enumeration tokenLines = tokenLineVector.elements();
            while (tokenLines.hasMoreElements()) {
                sb.append(inti).append(":").append(tokenLines.nextElement()).append('\n');
            }
        }
        return sb.toString();
    }
}

