/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.frontc;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import fr.inria.frontc.CToken;
import fr.inria.frontc.STDCTokenTypes;
import fr.inria.frontc.StdC2IL;
import fr.inria.frontc.StdCLexer;
import fr.inria.frontc.StdCParser;
import fr.inria.frontc.TNode;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;

public class C2IL {
    private final boolean txtIL;
    private final String input_name;
    private final String output_name;
    private boolean originalSourceOnly;
    private DataInputStream input;
    private PrintStream output;

    public C2IL() {
        this.txtIL = false;
        this.input_name = "-";
        this.output_name = "-";
    }

    public C2IL(String file_name) {
        this.txtIL = false;
        this.input_name = file_name;
        this.output_name = "-";
    }

    public C2IL(String in, String out) {
        this.txtIL = false;
        this.input_name = in;
        this.output_name = out;
    }

    public C2IL(String file_name, boolean b) {
        this.txtIL = b;
        this.input_name = file_name;
        this.output_name = "-";
    }

    private C2IL(String in, String out, boolean b) {
        this.txtIL = b;
        this.input_name = in;
        this.output_name = out;
    }

    public static void main(String[] args) {
        boolean textMode = false;
        String outName = "";
        boolean originalSourceOnly = false;
        block12: for (int c = 0; c < args.length; ++c) {
            String a;
            switch (a = args[c]) {
                case "-text": {
                    textMode = true;
                    continue block12;
                }
                case "-o": {
                    outName = args[++c];
                    continue block12;
                }
                case "-s": {
                    originalSourceOnly = true;
                    continue block12;
                }
                default: {
                    try {
                        C2IL converter = new C2IL(a, outName, textMode);
                        converter.setConvertOriginalSourceOnly(originalSourceOnly);
                        converter.convert();
                        continue block12;
                    }
                    catch (Exception e) {
                        System.err.println("exception: " + e);
                    }
                }
            }
        }
    }

    private void initialize_input(String file_name) throws FileNotFoundException {
        this.input = file_name.equals("-") || file_name.isEmpty() ? new DataInputStream(System.in) : new DataInputStream(new FileInputStream(file_name));
    }

    private void initialize_output(String fName) throws FileNotFoundException {
        this.output = fName.equals("-") || fName.isEmpty() ? new PrintStream(System.out) : new PrintStream(fName);
    }

    private void close_files() throws IOException {
        this.output.close();
        this.input.close();
    }

    private void setConvertOriginalSourceOnly(boolean b) {
        this.originalSourceOnly = b;
    }

    private void convert() throws IOException {
        this.initialize_input(this.input_name);
        this.initialize_output(this.output_name);
        StdCLexer lexer = new StdCLexer(this.input);
        lexer.setTokenObjectClass(CToken.class.getName());
        lexer.initGnuLiterals();
        lexer.setOriginalSource(this.input_name);
        StdCParser parser = new StdCParser(lexer);
        int indexCpp = this.input_name.indexOf("_preprocessed.c");
        String origInputFileName = this.input_name;
        if (indexCpp > 0) {
            origInputFileName = this.input_name.substring(0, this.input_name.indexOf("_preprocessed.c"));
        }
        parser.inputFileName = origInputFileName;
        parser.setASTNodeClass(TNode.class.getName());
        TNode.setTokenVocabulary(STDCTokenTypes.class.getName());
        StdC2IL c2il = new StdC2IL(origInputFileName, lexer.getPreprocessorInfoChannel(), this.output);
        c2il.setASTNodeClass(TNode.class.getName());
        c2il.setTextIL(this.txtIL);
        c2il.setConvertOriginalSourceOnly(this.originalSourceOnly);
        try {
            parser.translationUnit();
            c2il.translationUnit(parser.getAST());
        }
        catch (RecognitionException | TokenStreamException e) {
            System.err.println("Fatal IO error:\n" + e);
            return;
        }
        this.close_files();
    }
}

