%% HotSpotter Version 1.5
%% 05/10/00, v1.4, solid modeling function is added
%% 05/14/00, v1.5, anisotropic material option added
%%
%%==================================================================
%% 'Model': 
%%      Change the model parameters. 
%%
%% 'wave nums':  
%%      Input the hot spot number(s) here, following the 
%%      general Matlab format. For example, 2,5,8,11 and 
%%      2 5 8 11 and 2:3:11 are the same thing. 
%%
%% 'sld speed': 
%%      Specify a sliding speed (rad/s) in here if you want 
%%      to get the growth rate and the migration speed for a 
%%      specific sliding speed, or leave it blank if you want 
%%      to compute the critical speed instead.
%%
%% 'Start': 
%%      Start running the program. When the program ends, you 
%%      will see 'Congratulations....'. 
%%
%% 'show mesh': 
%%      You can always check the mesh at any time.
%%
%% 'show results': 
%%      Check results after running the program. 
%%===================================================================  
function tei

clear global;

global r z r0 a b;
global m E af nu K cp rou;
global AnisC AnisD AnisFlag;
global HndlList01 HndlList02 HndlList2 HndlList3 HndlList4 textwinHndl;
global GeomParam MatlParam MiscParam AnisParam AnisFlag;
global LayerNm MatNm;
global M F H S w m modenum;
global VECTOR eigvalue;
global HsVect HsVectStr OmegaInp;
global ShowOption MtOption SurfOption;
global FigureTitleName textwin StartText;
global LayerLabelFlag MessageTextFlag UIprintFlag;
global SaveFileName LoadFileName MatlFileName;


format short e;
warning off;
close all;
LayerLabelFlag=1;MessageTextFlag=1;UIprintFlag=0;

FigureTitleName=strcat(...
   'HotSpotter 2.41,  Copyright 2000,  The Regents of the U',...
   'niversity of Michigan,  All Rights Reserved');
%%SaveFileName='property.d';
%%LoadFileName='property.d';
%%MatlFileName='material_Lib.ml';
%%[GeomParam,MatlParam,MiscParam,AnisParam,AnisFlag]=Read_Param(LoadFileName, MatlFileName);
%%HsVectStr=MiscParam{4};
%%OmegaInp=MiscParam{5};
HsVect=[];
VECTOR=[];
textwin=[];
textwin{1}='Welcome to use Hotspotter! ';
textwin{2}='To load your model and material library, please click the menu ''FILE'' then the submenu ''Load'' on the menubar.';
textwin{3}='Try ''sample_2layers'' as your first exercise.';
%figurePos=get(0,'DefaultFigurePosition');
scrnsz=get(0,'screensize');
figurePos=scrnsz; 
%if scrnsz(3)<1000, figurePos=[50,50,650,450];
%else figurePos=[137,50,750,600];
end;
  %  figurePos=[125,75,1150,850];
   figNumber=figure( ...
      'Name',...
      FigureTitleName,...
      'NumberTitle','off', ...
      'DoubleBuffer','on', ...
      'menubar','none', ...
      'Visible','off', ...
      'Color',[1 1 1]*0.8, ...
      'BackingStore','on',...
	    'position',figurePos);
   axes( ...
      'Units','normalized', ...
      'Position',[0.1 0.33 0.66 0.6], ...
      'Visible','off', ...
      'DrawMode','fast', ...
      'NextPlot','add');
   
   StartText={'HOTSPOTTER',...
              'Version 2.41',...
	           'Copyright \copyright 2000',...
	           'The Regents of the University of Michigan',...
             'All Rights Reserved'};
text(-0.1,0.25,StartText{1}, ...
      'HorizontalAlignment','center','FontSize',16,'FontWeight','bold');
text(-0.1,0.1,StartText{2}, ...
      'HorizontalAlignment','center','FontSize',16,'FontWeight','bold');
text(-0.1,-0.2,StartText{3},...
      'HorizontalAlignment','center','FontSize',12,'FontWeight','bold');
text(-0.1,-0.35,StartText{4}, ...
      'HorizontalAlignment','center','FontSize',12,'FontWeight','bold');
text(-0.1,-0.5,StartText{5}, ...
      'HorizontalAlignment','center','FontSize',12,'FontWeight','bold');
axis([-1 1 -1 1]);

menu0=uimenu(1,'label','FILE');
menu01=uimenu('parent',menu0,'label','Load','callback','myeval(51.5);');
menu02=uimenu('parent',menu0,'label','Save Model','callback','myeval(52);');
menu03=uimenu('parent',menu0,'label','Save Material Library','callback','myeval(53);');
menu04=uimenu('parent',menu0,'label','See Result File','callback','edit(''result.rst'');');
menu05=uimenu('parent',menu0,'label','Print Plot','callback','myeval(115);');
menu06=uimenu('parent',menu0,'label','Help','callback','myeval(5000);');
menu07=uimenu('parent',menu0,'label','Exit','callback','close all;');


menu1=uimenu(1,'label','MAIN');  
menu11=uimenu('parent',menu1,'label','Start','callback','tei_loop;');
menu12=uimenu('parent',menu1,'label','My model','callback','myinput;');
menu13=uimenu('parent',menu1,'label','Show model','callback','myeval(101);');
menu14=uimenu('parent',menu1,'label','Show mesh','callback','myeval(102);');
menu15=uimenu('parent',menu1,'label','Show result','callback','myeval(4000);');

menu2=uimenu(1,'label','RESULT');  
menu21=uimenu('parent',menu2,'label','Show mesh','callback','myeval(103);');
menu22=uimenu('parent',menu2,'label','T cross section','callback','myeval(104);');
menu23=uimenu('parent',menu2,'label','T surface','callback','myeval(105);');
menu24=uimenu('parent',menu2,'label','T thickness','callback','myeval(108);');
menu25=uimenu('parent',menu2,'label','Growth rate','callback','myeval(117);');
menu26=uimenu('parent',menu2,'label','Critical speed','callback','myeval(110);');
menu27=uimenu('parent',menu2,'label','Migration speed','callback','myeval(111);');

menu3=uimenu(1,'label','MODE');
uimenu(menu3,'label','First mode','callback','myeval(113);');
uimenu(menu3,'label','Next mode','callback','myeval(114);');
uimenu(menu3,'label','Prev mode','callback','myeval(112);');
uimenu(menu3,'label','+5 mode','callback','myeval(114.1);');
uimenu(menu3,'label','-5 mode','callback','myeval(114.2);');
uimenu(menu3,'label','First surface','callback','myeval(107.1);');
uimenu(menu3,'label','Next surface','callback','myeval(106);');
uimenu(menu3,'label','Prev surface','callback','myeval(107);');
uimenu(menu3,'label','T thru z (standard)','callback','myeval(108);');
uimenu(menu3,'label','T thru z (enlarged)','callback','myeval(109);');

menu4=uimenu(1,'label','SET');
uimenu(menu4,'label','set Grid on','callback','grid on;');
uimenu(menu4,'label','set Grid off','callback','grid off;');
uimenu(menu4,'label','set Grey Color','callback','graymap;');
uimenu(menu4,'label','set Default Color','callback','colormap(''default'');');
uimenu(menu4,'label','set TextLayer on','callback','myeval(0.1);');
uimenu(menu4,'label','set TextLayer off','callback','myeval(0.2);');
uimenu(menu4,'label','set Footnote on','callback','myeval(0.3);');
uimenu(menu4,'label','set Footnote off','callback','myeval(0.4);');
uimenu(menu4,'label','set PrintUI on','callback','myeval(0.5);');
uimenu(menu4,'label','set PrintUI off','callback','myeval(0.6);');



%=============================
uicontrol( ...
      'Style','frame', ...
      'Units','normalized', ...
      'Position',[0.03,0.03,0.74,0.21] ...
      );

textwinHndl=uicontrol( ...
      'Style','list', ...
      'Units','normalized', ...
      'Position',[0.04 0.04 0.72 0.19], ...
      'min',0,...
      'max',2000,...
      'value',[],...
      'BackgroundColor',[1 1 1]);


   %===================================
   % Information for all buttons
   labelColor=[0.8 0.8 0.8];
   yInitPos=0.96;
   xPos=0.82;
   btnLen=0.14;
   btnWid0=0.08;
   % Spacing between the button and the next command's label
   spacing0=0.055;
   
   %====================================
   % The CONSOLE frame
   frmBorder=0.015;
   yPos=0.04-frmBorder;
   frmPos=[xPos-frmBorder yPos btnLen+2*frmBorder 0.9+2*frmBorder];
   h=uicontrol( ...
      'Style','frame', ...
      'Units','normalized', ...
      'Position',frmPos, ...
      'BackgroundColor',[0 0 0.6]);
   
   spacing=spacing0*0.6;
   btnWid=btnWid0*1.;
   
   %====================================
   % The edit model button
   btnNumber=1;
   yPos=0.90-(btnNumber-1)*(btnWid+spacing)-0.3*btnWid;
   labelStr='My model';
   callbackStr='myinput;';
   %Setting userdata to -1 (=stop) will stop the demo.
   %callbackStr='set(gca,''Userdata'',-1)';
   
   % Generic button information
   btnPos=[xPos yPos-spacing btnLen btnWid];
   PrpHndl=uicontrol( ...
      'Style','pushbutton', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'FontSize',12,...
      'Callback',callbackStr);
   
      
    
   %=====================================
   %The ShowModel button
   
   btnNumber=2;
   yPos=0.90-(btnNumber-1)*(btnWid+spacing)-0.3*btnWid;
   labelStr='Show model';
   callbackStr='myeval(101);';
   
   % Generic button information
   btnPos=[xPos yPos-spacing btnLen btnWid];
   showmodelHndl=uicontrol( ...
      'Style','pushbutton', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'FontSize',12,...
      'Callback',callbackStr);
   
   %=====================================
   %The ShowMesh button
   
   btnNumber=3;
   yPos=0.90-(btnNumber-1)*(btnWid+spacing)-0.3*btnWid;
   labelStr='Show mesh';
   callbackStr='myeval(102);';
   
   % Generic button information
   btnPos=[xPos yPos-spacing btnLen btnWid];
   meshHndl=uicontrol( ...
      'Style','pushbutton', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'FontSize',12,...
      'Callback',callbackStr);
   
  %====================================
   % The START button
   btnNumber=4;
   yPos=0.90-(btnNumber-1)*(btnWid+spacing)-0.3*btnWid;
   labelStr='Run';
   cmdStr='start';
   callbackStr='tei_loop;';
   
   % Generic button information
   btnPos=[xPos yPos-spacing btnLen btnWid];
   startHndl=uicontrol( ...
      'Style','pushbutton', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'FontSize',12,...
      'Callback',callbackStr);

   %=====================================
   %The ShowResult button
   
   btnNumber=5;
   yPos=0.90-(btnNumber-1)*(btnWid+spacing)-0.3*btnWid;
   labelStr='Show result';
   callbackStr='myeval(4000);';
   
   % Generic button information
   btnPos=[xPos yPos-spacing btnLen btnWid];
   showrsHndl=uicontrol( ...
      'Style','pushbutton', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'FontSize',12,...
      'Callback',callbackStr);

   
   %====================================
   % The INFO button
   btnNumber=7;
   yPos=0.90-(btnNumber-1)*(btnWid+spacing)-0.3*btnWid;
   btnPos=[xPos yPos-spacing btnLen btnWid];
   labelStr='Help';
   callbackStr='myeval(5000);';
   infoHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'FontSize',12,...
      'Callback',callbackStr);
      
   %====================================
   % The CLOSE button
   btnNumber=8;
   yPos=0.90-(btnNumber-1)*(btnWid+spacing)-0.3*btnWid;
   btnPos=[xPos yPos-spacing btnLen btnWid];
   labelStr='Quit';
   callbackStr='close all;';
   closeHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'FontSize',12,...
      'Callback',callbackStr);
   
   
      
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   % show buttons
   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   %====================================
   % The mesh button
   spacing=0.34*spacing0;
   btnWid=btnWid0*0.88;
   
   btnNumber=1;
   yPos=0.88-(btnNumber-1)*(btnWid+spacing);
   labelStr='Mesh';
   callbackStr='myeval(103);';
   btnPos=[xPos yPos-spacing btnLen btnWid];
   smeshHndl=uicontrol( ...
      'Style','pushbutton', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'Callback',callbackStr);
   
   
   %====================================
   % The cross section show button
   btnNumber=2;
   yPos=0.88-(btnNumber-1)*(btnWid+spacing);
   labelStr='T cross';
   callbackStr='myeval(104);';
   btnPos=[xPos yPos-spacing btnLen btnWid];
   crossHndl=uicontrol( ...
      'Style','pushbutton', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'Callback',callbackStr);
   
   %====================================
   % The surface show button
   btnNumber=3;
   yPos=0.88-(btnNumber-1)*(btnWid+spacing);
   labelStr='T surface';
   callbackStr='myeval(105);';
   btnPos=[xPos yPos-spacing btnLen btnWid];
   surfaceHndl=uicontrol( ...
      'Style','pushbutton', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'Callback',callbackStr);
   
      %====================================
   % The thickness 1st button
   btnNumber=4;
   yPos=0.88-(btnNumber-1)*(btnWid+spacing);
   labelStr='T thickness';
   callbackStr='myeval(108);';
   btnPos=[xPos yPos-spacing btnLen btnWid];
   thickHndl=uicontrol( ...
      'Style','pushbutton', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'Callback',callbackStr);
   
   
   %====================================
   % The v_b button
   btnNumber=5;
   yPos=0.88-(btnNumber-1)*(btnWid+spacing);
   labelStr='Growth rate';
   callbackStr='myeval(117);';
   btnPos=[xPos yPos-spacing btnLen btnWid];
   vbHndl=uicontrol( ...
      'Style','pushbutton', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'Callback',callbackStr); 
   
   %====================================
   % The n_v button
   btnNumber=6;
   yPos=0.88-(btnNumber-1)*(btnWid+spacing);
   labelStr='Crt speed';
   callbackStr='myeval(110);';
   btnPos=[xPos yPos-spacing btnLen btnWid];
   nvHndl=uicontrol( ...
      'Style','pushbutton', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'Callback',callbackStr);
   
   %====================================
   % The n_c button
   btnNumber=7;
   yPos=0.88-(btnNumber-1)*(btnWid+spacing);
   labelStr='Mig speed';
   callbackStr='myeval(111);';
   btnPos=[xPos yPos-spacing btnLen btnWid];
   ncHndl=uicontrol( ...
      'Style','pushbutton', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'Callback',callbackStr);
   
      	
   %====================================
   % The print button
   btnNumber=9;
   yPos=0.88-(btnNumber-1)*(btnWid+spacing);
   btnPos=[xPos yPos-spacing btnLen btnWid];   
   labelStr='print as';
   callbackStr='myeval(115);';
   prntHndl=uicontrol( ...
      'Style','pushbutton', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'Callback',callbackStr);   
   %====================================
   % The back button
   btnNumber=10;
   yPos=0.88-(btnNumber-1)*(btnWid+spacing);
   btnPos=[xPos yPos-spacing btnLen btnWid];   
   labelStr='<< Back';
   callbackStr='myeval(116);';
   sbackHndl=uicontrol( ...
      'Style','pushbutton', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'Callback',callbackStr);   
   
   % Uncover the figure
  
  HndlList01=[startHndl PrpHndl  meshHndl showmodelHndl showrsHndl ...
             infoHndl closeHndl];
  HndlList02=[smeshHndl, crossHndl,surfaceHndl,thickHndl,vbHndl,...
              nvHndl,ncHndl,prntHndl,sbackHndl];
  HndlList=[HndlList01,HndlList02];
  set(figNumber,'Visible','on','UserData',HndlList);
  set(HndlList02,'Visible','off');
  set([HndlList01,HndlList02],'Fontsize',10,'FontWeight','demi');
  
  set(HndlList01,'Visible','on');

tstring1={'start running program',...
          'edit model parameters',...
          'show FEM mesh',...
          'show 3D solid model',...
          'show computational results',...
          'help information',...
          'exit program'};

tstring2={'show FEM mesh',...
          'show cross section temperature',...
          'show surface temperature',...
          'show temp thru thickness',...
          'sliding speed vs growth rate',...
          'hot-spot-num vs critical speed',...
          'hot-spot-num vs migration speed',...
          'print figure to file',...
          'return to main menu'};
for i=1:length(HndlList01); set(HndlList01(i),'TooltipString',tstring1{i});end;
for i=1:length(HndlList02);set(HndlList02(i),'tooltipstring',tstring2{i});end;

for i=1:5; set(HndlList01(i),'enable','off');end;
set(textwinHndl,'string',textwin,'listboxtop',length(textwin));
%%drawnow;
