function xfig(FigOption,mymodelflag)
global HndlList5 LoadFileName MatlFileName SaveFileName PrintName;
global printnameHndl loadnameHndl matlfileHndl; 
global savenameHndl mlayHndl mlayVec;
global xfigokHndl;

if ismember(3,get(0,'children')), close(3);end;
figurePos=[300,300,300,120]; 

switch FigOption,
case 1,   % load file
figurePos=[300,300,450,120];
fig_mini=figure( ...
      'Name','Load Model: select model file left and material libary right', ...
      'NumberTitle','off', ...
      'Color',[1,1,1]*0.8, ...
      'MenuBar','none',...
      'position',figurePos);   
   
   fileStr=dir('*.d');
   [xpath,PopupStr,xex,xver]=fileparts(fileStr(1).name);
   for i=2:length(fileStr),
       [xpath,xname,xex,xver]=fileparts(fileStr(i).name);
       PopupStr=strcat(PopupStr,'|',xname); 
   end;
   LoadFileName=fileStr(1).name;

   if mymodelflag==1,  %mymodel window open
   callbackStr='myeval(200);';
   else 
   callbackStr='myeval(200.5);';
   end;
   xfigokHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[0.3,0.1,0.2,0.3], ...
      'String','OK', ...
      'FontSize',12,'fontweight','demi',...
      'Callback',callbackStr);
   
   uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[0.55,0.1,0.2,0.3], ...
      'String','Cancel', ...
      'FontSize',12,'fontweight','demi',...
      'Callback','close(gcf)');
   
   callbackStr='myeval(201);';
   btnPos=[0.1,0.6,0.4,0.3];
   loadnameHndl=uicontrol( ...
      'Style','popup', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',PopupStr, ...
      'FontSize',12,'fontweight','demi',...
      'BackgroundColor',[1 1 1]*0.95,...
      'HorizontalAlignment','center',...
      'Callback',callbackStr);
   
   matlfileStr=dir('*.ml');
   [xpath,PopupStr,xex,xver]=fileparts(matlfileStr(1).name);
   for i=2:length(matlfileStr),
           [xpath,xname,xex,xver]=fileparts(matlfileStr(i).name); 
           PopupStr=strcat(PopupStr,'|',xname); 
   end;
   MatlFileName=matlfileStr(1).name;

   callbackStr='myeval(201.1);';
   btnPos=[0.55,0.6,0.4,0.3];
   matlfileHndl=uicontrol( ...
      'Style','popup', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',PopupStr, ...
      'FontSize',12,'fontweight','demi',...
      'BackgroundColor',[1 1 1]*0.95,...
      'HorizontalAlignment','center',...
      'Callback',callbackStr);


case 2,  %save file
   fig_mini=figure( ...
      'Name','Save Model', ...
      'NumberTitle','off', ...
      'Color',[1,1,1]*0.8, ...
      'MenuBar','none',...
      'position',figurePos);
   
   SaveFileName=LoadFileName;
     
   callbackStr='myeval(202);';
   uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[0.1,0.1,0.3,0.3], ...
      'String','OK', ...
      'FontSize',12,'fontweight','demi',...
      'Callback',callbackStr);
   
   uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[0.6,0.1,0.3,0.3], ...
      'String','Cancel', ...
      'FontSize',12,'fontweight','demi',...
      'Callback','close(gcf)');
   
   callbackStr='myeval(203);';
   btnPos=[0.1,0.6,0.8,0.3];
  [xpath,xname,xex,xver]=fileparts(SaveFileName);
   savenameHndl=uicontrol( ...
      'Style','edit', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',xname,...
      'FontSize',12,'fontweight','demi',...
      'BackgroundColor',[1 1 1]*0.95,...
      'HorizontalAlignment','left',...
      'Callback',callbackStr);
case 2.2,  %save mat lib
   figurePos=[300,300,300,120];
   fig_mini=figure( ...
      'Name','Save Material Library', ...
      'NumberTitle','off', ...
      'Color',[1,1,1]*0.8, ...
      'MenuBar','none',...
      'position',figurePos);
        
   callbackStr='myeval(202.1);';
   uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[0.1,0.1,0.3,0.3], ...
      'String','OK', ...
      'FontSize',12,'fontweight','demi',...
      'Callback',callbackStr);
   
   uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[0.6,0.1,0.3,0.3], ...
      'String','Cancel', ...
      'FontSize',12,'fontweight','demi',...
      'Callback','close(gcf)');
   
   callbackStr='myeval(203.1);';
   btnPos=[0.1,0.6,0.8,0.3];
  [xpath,xname,xex,xver]=fileparts(MatlFileName);

   savenameHndl=uicontrol( ...
      'Style','edit', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',xname,...
      'FontSize',12,'fontweight','demi',...
      'HorizontalAlignment','left',...
      'BackgroundColor',[1 1 1]*0.95,...
      'Callback',callbackStr);

case 3,   % print
     fig_mini=figure( ...
      'Name','Print File (.eps,.ps or .jpg)', ...
      'NumberTitle','off', ...
      'Color',[1,1,1]*0.8, ...
      'MenuBar','none',...
      'position',figurePos);
   
   PrintName='';
   callbackStr='myeval(204);';    
   uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[0.1,0.1,0.3,0.4], ...
      'String','OK', ...
      'FontSize',12,'fontweight','demi',...
      'Callback',callbackStr);
   
   uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[0.6,0.1,0.3,0.4], ...
      'String','Cancel', ...
      'FontSize',12,'fontweight','demi',...
      'Callback','close(gcf)');
   
   callbackStr='myeval(205);';
   btnPos=[0.1,0.6,0.8,0.3];
   printnameHndl=uicontrol( ...
      'Style','edit', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',PrintName,...
      'FontSize',12,'fontweight','demi',...
      'BackgroundColor',[1 1 1]*0.95,...
      'HorizontalAlignment','left',...
      'Callback',callbackStr);

case 4, %multi layer insert

 fig_mini=figure( ...
      'Name','insert layers', ...
      'NumberTitle','off', ...
      'Color',[1,1,1]*0.8, ...
      'MenuBar','none',...
      'position',figurePos);
        
   callbackStr='myeval(10.1);';
   uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[0.1,0.1,0.3,0.4], ...
      'String','OK', ...
      'FontSize',12,'fontweight','demi',...
      'Callback',callbackStr);
   
   uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[0.6,0.1,0.3,0.4], ...
      'String','Cancel', ...
      'FontSize',12,'fontweight','demi',...
      'Callback','close(gcf)');
   
   btnPos=[0.1,0.6,0.8,0.3];
   if isempty(mlayVec)==1, ShowStr='';
   else ShowStr=num2str(mlayVec); end;
   mlayHndl=uicontrol( ...
      'Style','edit', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'FontSize',12,'fontweight','demi',...
      'string',ShowStr,...
      'BackgroundColor',[1 1 1]*0.95,...
      'HorizontalAlignment','left',...
      'Callback','');

case 5,  % multi layer delete
fig_mini=figure( ...
      'Name','delete layers', ...
      'NumberTitle','off', ...
      'Color',[1,1,1]*0.8, ...
      'MenuBar','none',...
      'position',figurePos);
        
   callbackStr='myeval(11.1);';
   uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[0.1,0.1,0.3,0.4], ...
      'String','OK', ...
      'FontSize',12,'fontweight','demi',...
      'Callback',callbackStr);
   
   uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',[0.6,0.1,0.3,0.4], ...
      'String','Cancel', ...
      'FontSize',12,'fontweight','demi',...
      'Callback','close(gcf)');
   
   btnPos=[0.1,0.6,0.8,0.3];
   if isempty(mlayVec)==1, ShowStr='';
   else ShowStr=num2str(mlayVec); end;
   mlayHndl=uicontrol( ...
      'Style','edit', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'FontSize',12,'fontweight','demi',...
      'string',ShowStr,...
      'BackgroundColor',[1 1 1]*0.95,...
      'HorizontalAlignment','left',...
      'Callback','');

end; %switch
 
