function myinput

global HndlList2 HndlList3 HndlList4;
global GeomParam MatlParam MiscParam AnisParam AnisFlag;
global MatlEvalStr MiscEvalStr LayerEvalStr;
global LayerNm MatNm;
global FigureTitleName;
global allfontsize buttonsHndl;

framebgcolor='default'; 

if ismember(2,get(0,'children')), close(2);end;
prop_stat_text_color=[1 1 1];
SaveFileName='property.d';
LoadFileName='property.d';
if isempty(GeomParam)  % never load file
      [GeomParam,MatlParam,MiscParam,AnisParam,AnisFlag]=Read_Param(LoadFileName);
end;
LayerNm=1;
MatNm=1;
MatlPopup=MatlParam{1}{1};
for i=2:length(MatlParam);
   MatlPopup=strcat(MatlPopup,'|',MatlParam{i}{1});
end;

%figurePos=get(0,'DefaultFigurePosition');
%figurePos=[50,100,800,500]; 
scrnsz=get(0,'screensize');
scrncenterx=scrnsz(3)*0.5;scrncentery=scrnsz(4)*0.5;
scrnxwid=0.75*scrnsz(3);scrnywid=0.375*scrnsz(3); %%need change to resize
figurePos=round([scrncenterx-scrnxwid/2,scrncentery-scrnywid/2,...
           scrnxwid,scrnywid]);

%%figurePos=[0.09,0.08,0.82,0.4]*scrnsz(3);
%if scrnsz(3)>1000,   figurePos=[92,100,840,500];
%else figurePos=[100,200,600,400];end;
   fig_input=figure( ...
      'Name', ...
      FigureTitleName,...
      'NumberTitle','off', ...
      'Color',[1,1,1]*0.5, ...
      'MenuBar','none',...
      'position',figurePos);
   axes( ...
      'Units','normalized', ...
      'Position',[0.12 0.2 0.6 0.6], ...
      'Visible','off', ...
      'DrawMode','fast', ...
      'NextPlot','add');
   
axis([-1 1 -1 1]);
menui0=uimenu(fig_input,'label','FILE');
 
menui01=uimenu('parent',menui0,'label','Load','callback','myeval(51);');
menui02=uimenu('parent',menui0,'label','Save Model','callback','myeval(52);');
menui03=uimenu('parent',menui0,'label','Save Matl Library','callback','myeval(53);');
 

   %===================================
   % Information for all buttons
   labelColor=[0.8 0.8 0.8];
   yInitPos=0.90;
   xPos=0.46;
   btnLen=0.15;
   btnWid=0.05;
   spacing=0.03;
   
   
   %====================================
   % The CONSOLE frame
   frmBorder=0.02;
   yPos=0.05-frmBorder;
   frmPos=[xPos-frmBorder-0.11 yPos btnLen+2*frmBorder+0.22 0.9+2*frmBorder];
   frame1=uicontrol( ...
      'Style','frame', ...
      'Units','normalized', ...
      'backgroundcolor',framebgcolor, ...
      'Position',frmPos, ...
      'String','hello',...
      'ForegroundColor',[1,1,1]);
      
   %====================================
   % The layer #
   xPos=xPos+0.01;
   yPos=0.90;
   btnPos=[xPos-0.1 yPos-spacing btnLen btnWid];
   layertextHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','Layer #');   
   
   callbackStr='';
   
  % strcat(...
  %    'LayerNm=str2num(get(layerHndl,''String''));',...
  %    'GeomParam{LayerNm}{1}=num2str(get(whichmatHndl,''Value''));',...
  %    'GeomParam{LayerNm}{2}=num2str(get(movingHndl,''Value''));',...
  %    'GeomParam{LayerNm}{3}=get(inrHndl,''String'');',...
   %   'GeomParam{LayerNm}{4}=get(outrHndl,''String'');',...
   %   'GeomParam{LayerNm}{5}=get(thickHndl,''String'');'...
   %   );
      
   btnPos=[xPos yPos-spacing btnLen btnWid];
   layerHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'Callback',callbackStr);
   %====================================
   % mat
   yPos=0.90-(btnWid+spacing);
   btnPos=[xPos-0.1 yPos-spacing btnLen btnWid];
   textmatHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','Material ', ...
      'HorizontalAlignment','left');   
   
      callbackStr='myeval(1);';
      btnPos=[xPos yPos-spacing btnLen btnWid];
      whichmatHndl=uicontrol( ...
      'Style','popup', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'Callback',callbackStr);
   
   %====================================
   % The moving
   yPos=0.90-2*(btnWid+spacing);
   btnPos=[xPos-0.1 yPos-spacing btnLen btnWid];
   textmovingHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','Type');   
   
       callbackStr='myeval(2);';
       btnPos=[xPos yPos-spacing btnLen btnWid];
       movingHndl=uicontrol( ...
      'Style','popup', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','stator|rotor', ...
      'Callback',callbackStr...
      );
   
%====================================
   % The botm surf
   yPos=0.90-3*(btnWid+spacing);
   btnPos=[xPos-0.1 yPos-spacing btnLen btnWid];
   textbtmHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','Fric B.C.');   
   
       callbackStr='myeval(2.1);';
       btnPos=[xPos yPos-spacing btnLen btnWid];
       btmHndl=uicontrol( ...
      'Style','popup', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','normal|frictionless contact', ...
      'Callback',callbackStr...
      );


   %====================================
   % The inner r
   yPos=0.90-4*(btnWid+spacing);
   btnPos=[xPos-0.1 yPos-spacing btnLen btnWid];
   textinrHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','Inner R');   
   
      callbackStr='myeval(3);';
      btnPos=[xPos yPos-spacing btnLen btnWid];
      inrHndl=uicontrol( ...
      'Style','edit', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'Callback',callbackStr);
   
   %====================================
   % The outer r
   
   yPos=0.90-5*(btnWid+spacing);
   btnPos=[xPos-0.1 yPos-spacing btnLen btnWid];
   textoutrHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','Outer R');      
   
      
      callbackStr='myeval(4);';
      btnPos=[xPos yPos-spacing btnLen btnWid];
      outrHndl=uicontrol( ...
      'Style','edit', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'Callback',callbackStr);
   %====================================
   % The thickness
   yPos=0.90-6*(btnWid+spacing);
   btnPos=[xPos-0.1 yPos-spacing btnLen btnWid];
   textthickHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','Thickness');   
   
     
      callbackStr='myeval(5);';
      btnPos=[xPos yPos-spacing btnLen btnWid];
      thickHndl=uicontrol( ...
      'Style','edit', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'Callback',callbackStr);
      
   
 %=====================================
   %The layer_back2begin_button
   
   yPos=0.90-9*(btnWid+spacing);
   callbackStr='myeval(6);';
   btnPos=[xPos-0.1, yPos-spacing-btnWid,...
          (btnLen+0.1)/4, btnWid*2];
   layerbeginHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','|<<', ...
      'Callback',callbackStr);
 %=====================================
   %The layer_back_button
   
   callbackStr='myeval(7);';   
   btnPos=[xPos-0.1+(btnLen+0.1)/4 yPos-spacing-btnWid ...
       (btnLen+0.1)/4 btnWid*2];
   layerbackHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','<prev', ...
      'Callback',callbackStr);
   
   
   %====================================
   % The layer_next button
   btnPos=[xPos-0.1+(btnLen+0.1)/2 yPos-spacing-btnWid ...
         (btnLen+0.1)/4 btnWid*2];
   callbackStr='myeval(8);';
    layernextHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','next >', ...
      'Callback',callbackStr);
   
   %=====================================
   %The layer_next2end_button
   
   callbackStr='myeval(9);';
   btnPos=[xPos-0.1+0.75*(btnLen+0.1), yPos-spacing-btnWid,...
          (btnLen+0.1)/4, btnWid*2];
   layerendHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','>>|', ...
      'Callback',callbackStr);
   
   %====================================
   % The layer_insert button
   yPos=0.90-9*(btnWid+spacing)+2*btnWid;
   btnPos=[xPos-0.1+(btnLen+0.1)/4,yPos-spacing-btnWid, ...
         (btnLen+0.1)/4,btnWid*2];
   callbackStr='myeval(10);';
             
   layerinsertHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','add', ...
      'Callback',callbackStr);
   
   %====================================
   % The delete button
   btnPos=[xPos-0.1+(btnLen+0.1)/2,...
         yPos-spacing-btnWid, (btnLen+0.1)/4, btnWid*2];
   callbackStr='myeval(11);';          
   layerdelHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','delete', ...
      'Callback',callbackStr);
         
   %====================================
   % The multi_layer_insert button
   yPos=0.90-9*(btnWid+spacing)+2*btnWid;
   btnPos=[xPos-0.1,yPos-spacing-btnWid, ...
         (btnLen+0.1)/4,btnWid*2];
   callbackStr='xfig(4);';
             
   mlayerinsertHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','Mcopy', ...
      'Callback',callbackStr);
   
   %====================================
   % The multi_layer_delete button
   btnPos=[xPos-0.1+(btnLen+0.1)*3/4,...
         yPos-spacing-btnWid, (btnLen+0.1)/4, btnWid*2];
   callbackStr='xfig(5);';          
   mlayerdelHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','Mdel', ...
      'Callback',callbackStr);

   
   %%%%%%%%%%%%%%%%%%
   %% material data
   %%%%%%%%%%%%%%%%%%
   
   %====================================
   % The frame
   xPos=0.77;
   frmBorder=0.02;
   yPos=0.05-frmBorder;
   frmPos=[xPos-frmBorder-0.1 yPos btnLen+2*frmBorder+0.14 0.9+2*frmBorder];
   h2=uicontrol( ...
      'Style','frame', ...
      'Units','normalized', ...
      'Position',frmPos, ...
      'BackgroundColor',framebgcolor,...
      'String','hello',...
      'ForegroundColor',[1,1,1]);
   
   
   %====================================
   % The mat #
   xPos=xPos+0.01;
   yPos=0.90;
   btnPos=[xPos-0.1 yPos-spacing btnLen btnWid];
   matnumtextHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','Material #');
   btnPos=[xPos yPos-spacing btnLen*0.2 btnWid];
   matnmHndl=uicontrol( ...
      'Style','text', ...    
      'Units','normalized', ...
      'Position',btnPos ...
   );
   
   %=====================================
   % anisotropic
   btnPos=[xPos+0.05 yPos-spacing+0.015 btnLen*0.6+0.01 btnWid*0.7];
   callbackStr='anis;';
   iso_anisHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'FontWeight','demi',...
      'Position',btnPos, ...
      'Callback',callbackStr ...
   );
   
   %====================================
   % The matname
   yPos=0.9-(btnWid+spacing);
   btnPos=[xPos-0.1 yPos-spacing btnLen btnWid];
   textmatnameHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','Name');   
   
      
      callbackStr='myeval(12);';
        
      %Setting userdata to -1 (=stop) will stop the demo.
      %callbackStr='set(gca,''Userdata'',-1)';
      btnPos=[xPos yPos-spacing btnLen btnWid];
      matnameHndl=uicontrol( ...
      'Style','edit', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'Callback',callbackStr);
   
   %====================================
   % The modulus
   
   yPos=0.90-(btnWid+spacing)*2;
   btnPos=[xPos-0.1 yPos-spacing btnLen btnWid];
   textmdHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','Modulus');   
   
   callbackStr='myeval(22);';
   btnPos=[xPos yPos-spacing btnLen btnWid];
   modulusHndl=uicontrol( ...
      'Style','edit', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'Callback',callbackStr);
   
   %====================================
   % The static cond
   yPos=0.90-3*(btnWid+spacing);
   btnPos=[xPos-0.1 yPos-spacing btnLen btnWid];
   textspeedHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','Conductvty');      
   
   callbackStr='myeval(23);';
   btnPos=[xPos yPos-spacing btnLen btnWid];
   condHndl=uicontrol( ...
      'Style','edit', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'Callback',callbackStr);
   %====================================
   % The static expansion
   yPos=0.90-4*(btnWid+spacing);
   btnPos=[xPos-0.1 yPos-spacing btnLen btnWid];
   textexpHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','Expansion');   
   
   callbackStr='myeval(24);';
   btnPos=[xPos yPos-spacing btnLen btnWid];
   expansionHndl=uicontrol( ...
      'Style','edit', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'Callback',callbackStr);
   
   %====================================
   % The density
 
   yPos=0.90-5*(btnWid+spacing);
   btnPos=[xPos-0.1 yPos-spacing btnLen btnWid];
   textdenHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','Density');   
      
   callbackStr='myeval(25);';
   btnPos=[xPos yPos-spacing btnLen btnWid];
   densityHndl=uicontrol( ...
      'Style','edit', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'Callback',callbackStr);
   
   
   %====================================
   % The static specific
   yPos=0.90-6*(btnWid+spacing);
   btnPos=[xPos-0.1 yPos-spacing btnLen btnWid];
   textspecHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','Spec Heat');   
   
  
   callbackStr='myeval(26);';
   btnPos=[xPos yPos-spacing btnLen btnWid];
   specificHndl=uicontrol( ...
      'Style','edit', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'Callback',callbackStr);
   %====================================
   % The poisson
   yPos=0.90-7*(btnWid+spacing);
   btnPos=[xPos-0.1 yPos-spacing btnLen btnWid];
   textpoisHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','Poisson');   
   
   callbackStr='myeval(27);';
   btnPos=[xPos yPos-spacing btnLen btnWid];
   poissonHndl=uicontrol( ...
      'Style','edit', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'Callback',callbackStr);
         
   
   
   %=====================================
   %The mat_back 
  
   yPos=0.90-9*(btnWid+spacing);
   labelStr='<prev';
   callbackStr='myeval(29);';
   btnPos=[xPos-0.1+(btnLen+0.1)*0,yPos-spacing-btnWid, ...
         (btnLen+0.1)/4,btnWid*2];
   matbackHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'Callback',callbackStr);

   
   %====================================
   % The mat_next button
   btnPos=[xPos-0.1+(btnLen+0.1)/4,yPos-spacing-btnWid, ...
         (btnLen+0.1)/4,btnWid*2];
   labelStr='next>';
   callbackStr='myeval(30);';
      
   matnextHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'Callback',callbackStr);
   %====================================
   % The mat_insert button
   btnPos=[xPos-0.1+(btnLen+0.1)/2,yPos-spacing-btnWid, ...
         (btnLen+0.1)/4,btnWid*2];
   callbackStr='myeval(31);';
             
   matinsertHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','add', ...
      'Callback',callbackStr);
   
   %====================================
   % mat delete button
   btnPos=[xPos-0.1+(btnLen+0.1)*0.75,...
         yPos-spacing-btnWid, (btnLen+0.1)/4, btnWid*2];
   callbackStr='myeval(32);';
             
   matdelHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','delete', ...
      'Callback',callbackStr);
            
   
   %%%%%%%%%%%%%
   %% frame 3
   %%%%%%%%%%%%%
   xPos=0.15;
   yPos=0.05-frmBorder;
   frmPos=[xPos-frmBorder-0.11 yPos btnLen+2*frmBorder+0.13 0.9+2*frmBorder];
   uicontrol( ...
      'Style','frame', ...
      'Units','normalized', ...
      'backgroundcolor',framebgcolor, ...
      'Position',frmPos, ...
      'String','hello',...
      'ForegroundColor',[1,1,1]);
   
   xPos=xPos+0.01;
   yPos=0.90-(btnWid+spacing)*0;
   btnPos=[xPos-0.1 yPos-spacing btnLen*1.8 btnWid];
   textheadHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','All in SI units (m,kg,s)');   
  
  
   %====================================
   % The static 1st bound

   yPos=0.90-(btnWid+spacing)*1;
   labelStr='1st B.C.';
   btnPos=[xPos-0.1 yPos-spacing btnLen btnWid];
   text1stbcHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr);   
   
labelStr='free|symmetric|anti-symmetric|fixed|floating|cyclic|2PointSym|2PointFixed|2PointFloating';
      callbackStr='myeval(41);';
      btnPos=[xPos yPos-spacing btnLen btnWid];
      bc1Hndl=uicontrol( ...
      'Style','popup', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'Value',str2num(MiscParam{1}),...
      'Callback',callbackStr);
      
   %====================================
   % The static 2nd bound
   
   yPos=0.90-(btnWid+spacing)*2;
   labelStr='2nd B.C.';
   btnPos=[xPos-0.1 yPos-spacing btnLen btnWid];
   text2ndbcHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr);   
   
      labelStr='free|symmetric|anti-symmetric|fixed|floating|cyclic|2PointSym|2PointFixed|2PointFloating';
      callbackStr='myeval(42);';
      btnPos=[xPos yPos-spacing btnLen btnWid];
      bc2Hndl=uicontrol( ...
      'Style','popup', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'Value',str2num(MiscParam{2}),...
      'Callback',callbackStr);
   
   
   %%%%%%%%%%%
   % mesh size
   %%%%%%%%%%%
   
   yPos=0.90-3*(btnWid+spacing);
   labelStr='mesh size';
   btnPos=[xPos-0.1 yPos-spacing btnLen btnWid];
   textmeshHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr);   
   
   
   labelStr='super coarse|very coarse|coarse|medium|fine|very fine|super fine';
   callbackStr='myeval(43);';
   btnPos=[xPos yPos-spacing btnLen btnWid];
   meshsizeHndl=uicontrol( ...
      'Style','popup', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'Value',str2num(MiscParam{3}),...
      'String',labelStr,...
      'Callback',callbackStr);
      
   %====================================
   % The HSNUM
   yPos=0.90-4*(btnWid+spacing);
   btnPos=[xPos-0.1 yPos-spacing btnLen*0.7 btnWid];;
   texthsHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String','hotspot num');
   
   
   cmdStr='HtSptNm';
   %%callbackStr='MiscParam{4}=get(HndlList4(4),''string'');';
callbackStr='myeval(44);';
   btnPos=[xPos yPos-spacing btnLen btnWid];
   HsHndl=uicontrol( ...
      'Style','edit', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'Callback',callbackStr);
   
   %====================================
   % slidng
   yPos=0.90-5*(btnWid+spacing);
   labelStr='sld speed (rad/s)';
   btnPos=[xPos-0.1 yPos-spacing-0.02 btnLen*0.7 btnWid*1.5];
   textspdHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr);      
   
   callbackStr='myeval(45);';
   btnPos=[xPos yPos-spacing btnLen btnWid];
   SldSpdHndl=uicontrol( ...
      'Style','edit', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'Callback',callbackStr);
      
   %============================================
   % The pad angle

   yPos=0.90-(btnWid+spacing)*6;
   labelStr='pad angle (for brake)';
   btnPos=[xPos-0.1 yPos-spacing-0.02 btnLen*0.7 btnWid*1.5];
   textpadangHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'TooltipString','clutch:360; brake:<360');   
   
   callbackStr='myeval(46);';
   btnPos=[xPos yPos-spacing btnLen btnWid];
   PadAngleHndl=uicontrol( ...
      'Style','edit', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'TooltipString','360 for clutch; <360 for brake',...
      'Callback',callbackStr);

   %============================================
   % The friction

   yPos=0.90-(btnWid+spacing)*7;
   labelStr='fric coeff';
   btnPos=[xPos-0.1 yPos-spacing-0.02 btnLen*0.7 btnWid*1.5];
   textfricHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'TooltipString','frictional coefficient');   
   
   callbackStr='myeval(47);';
   btnPos=[xPos yPos-spacing btnLen btnWid];
   fricHndl=uicontrol( ...
      'Style','edit', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'TooltipString','frictional coefficient',...
      'Callback',callbackStr);

   % The load button
   yPos=0.90-9*(btnWid+spacing);
   btnPos=[xPos-0.1+(btnLen+0.1)*0,...
         yPos-spacing-btnWid, (btnLen+0.1)/3, btnWid*2];
   labelStr='Load';
   callbackStr='myeval(51);';
   loadHndl=[];
   %%loadHndl=uicontrol( ...
   %%   'Style','push', ...
   %%   'Units','normalized', ...
   %%   'Position',btnPos, ...
   %%   'String',labelStr, ...
   %%   'Callback',callbackStr);
        
  %====================================
   % The save geom button
   btnPos=[xPos-0.1+(btnLen+0.1)/3,...
         yPos-spacing-btnWid, (btnLen+0.1)/3, btnWid*2];
   labelStr='SaveGeom';
   callbackStr='myeval(52);';
   saveHndl=[];
   %%saveHndl=uicontrol( ...
   %% 'Style','push', ...
   %% 'Units','normalized', ...
   %% 'Position',btnPos, ...
   %% 'String',labelStr, ...
   %% 'Callback',callbackStr);
   %====================================
   % save mat lib button
   yPos=0.90-9*(btnWid+spacing);
   btnPos=[xPos-0.1+(btnLen+0.1)*2/3,...
         yPos-spacing-btnWid, (btnLen+0.1)/3, btnWid*2];
   labelStr='SaveMatl';
   callbackStr='myeval(53);';
   mischelpHndl=[];
  %% mischelpHndl=uicontrol( ...
  %%  'Style','push', ...
  %%    'Units','normalized', ...
  %%    'Position',btnPos, ...
  %%    'String',labelStr, ...
  %%    'Callback',callbackStr);
        
  %====================================
   % The CLOSE button
   btnPos=[xPos-0.1+(btnLen+0.1)*0,...
         yPos-spacing-btnWid, (btnLen+0.1)/2, btnWid*2];
   labelStr='Close';
   callbackStr='close(gcf)';
   misccloseHndl=[];
   misccloseHndl=uicontrol( ...
      'Style','push', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'String',labelStr, ...
      'Callback',callbackStr);


%======================================
% initialize all handles

HndlList2=[...
layerHndl,whichmatHndl,movingHndl,btmHndl,inrHndl,outrHndl,thickHndl];

HndlList3=...
[matnameHndl,modulusHndl,condHndl,expansionHndl,...
densityHndl,specificHndl,poissonHndl,...
matnmHndl,iso_anisHndl];   

HndlList4=[bc1Hndl,bc2Hndl,meshsizeHndl,HsHndl,SldSpdHndl,PadAngleHndl,fricHndl];
  
textsHndl=...
[layertextHndl,layerHndl,textmatHndl,textheadHndl,...
textmovingHndl,textbtmHndl,textinrHndl,textoutrHndl,textthickHndl,matnumtextHndl,...
matnmHndl,textmatnameHndl,textmdHndl,textspeedHndl,textexpHndl,...
textdenHndl,textspecHndl,textpoisHndl,text1stbcHndl,...
text2ndbcHndl,textmeshHndl,texthsHndl,textspdHndl,textpadangHndl,textfricHndl...
];

editsHndl=[...
whichmatHndl,movingHndl,btmHndl,inrHndl,outrHndl,thickHndl,...
HndlList3(1:7),HndlList4];

buttonsHndl=[...
layerbeginHndl,layerbackHndl,layernextHndl,iso_anisHndl,...
layerendHndl,layerinsertHndl,mlayerdelHndl,mlayerinsertHndl,...
layerdelHndl,matbackHndl,matnextHndl,matinsertHndl,...
matdelHndl,misccloseHndl];

tstring3={...
'stator or rotor',...
'frictional surf or frictionless surf',...
'inner radius',...
'outer radius',...
'layer thickness',...
'material ID number',...
'material ID number',...
'material name',...
'Young''s Modulus',...
'Thermal Conductivity',...
'Thermal Expansion Coefficient',...
'Density',...
'Specific Heat',...
'Poisson''s Ratio',...
'boundary cond at the bottom surf',...
'boundary cond at the top surf',...
'mesh size',...
'Hot spot number(s)',...
'Sliding speed in rad/s',...
'Friction Coefficient',...
};
for i=5:24;set(textsHndl(i),'tooltipstring',tstring3{i-4});end;

myeval(1000);
myeval(2000);
myeval(3000);
   
set(textsHndl,...
   'FontSize',allfontsize,...
   'backgroundcolor',framebgcolor, ...
   'HorizontalAlignment','left',...
   'FontWeight','demi'...
    );
  
set(editsHndl,...         
   'FontSize',allfontsize,...
   'BackgroundColor',[1 1 1]*0.95,...
   'HorizontalAlignment','left',...
   'FontWeight','bold'...
    );   
    
set(buttonsHndl,...
   'FontSize',allfontsize,...
   'FontWeight','demi'...
    );
    
%%set([HsHndl,SldSpdHndl,PadAngleHndl],'HorizontalAlignment','center'); 
