function anis
 
global AnisC AnisD AnisFlag AnisHndl;
global HndlList01 HndlList02 HndlList2 HndlList3 HndlList4;
global GeomParam MatlParam MiscParam AnisParam AnisFlag;
global LayerNm MatNm;
global FigureTitleName;
global allfontsize aniscancelHndl;

framebgcolor=[1 1 1]*0.8;
editbgcolor=[1 1 1];
if ismember(3,get(0,'children')), close(3);end;
scrnsz=get(0,'screensize');
figurePos=[0.2,0.2,0.6,0.3]*scrnsz(3);
 %%  figurePos=[20,250,800,350];
   fig_anis=figure( ...
      'Name', ...
      'Anisotropic properties (left: stress-strain matrix, right:thermal expansion matrix)',...
      'NumberTitle','off', ...
      'Color',framebgcolor, ...
      'MenuBar','none',...
      'position',figurePos);
   axes( ...
      'Units','normalized', ...
      'Position',[0.12 0.2 0.6 0.6], ...
      'Visible','off', ...
      'DrawMode','fast', ...
      'NextPlot','add');
   
 axis([-1 1 -1 1]);
   
   %===================================
   % Information for all buttons
   labelColor=[0.8 0.8 0.8];
   yInitPos=0.90;
   xPos=0.05;
   yPos=0.275;
   btnLen=0.1;
   btnWid=0.07;
   spacing=0.03;
   
   
   yPos=0.8;
   for i=1:6,
     for j=i:6,
        callbackStr='myeval(300);';
      btnPos=[xPos+1.15*btnLen*(j-1) yPos-1.4*btnWid*(i-1) btnLen btnWid];
      anisHndl(i,j)=uicontrol( ...
      'Style','edit', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'FontSize',allfontsize,...
      'FontWeight','demi',...
      'BackgroundColor',editbgcolor,...
      'Callback',callbackStr);
     end;
  end;
  
  
  AnisTextStr{1}='(rr)';
  AnisTextStr{2}='(zz)';
  AnisTextStr{3}='(tt)';
  AnisTextStr{4}='(rz)';
  AnisTextStr{5}='(zt)';
  AnisTextStr{6}='(rt)';
  
  for j=1:6,
   btnPos=[xPos+1.15*btnLen*(j-1) yPos-1.4*btnWid*(-1)-0.02 btnLen btnWid];
      uicontrol( ...
      'Style','text', ...
      'String',AnisTextStr{j},...
      'Units','normalized', ...
      'Position',btnPos, ...
      'FontSize',allfontsize,...
      'FontWeight','demi',...
      'BackgroundColor',framebgcolor ...
     );
    btnPos=[xPos+1.15*btnLen*6 yPos-1.4*btnWid*(j-1)-0.01 btnLen btnWid];
      uicontrol( ...
      'Style','text', ...
      'String',AnisTextStr{j},...
      'Units','normalized', ...
      'Position',btnPos, ...
      'FontSize',allfontsize,...
      'FontWeight','demi',...
      'BackgroundColor',framebgcolor ...
     );
  end;
  
  
  for i=1:6,
     callbackStr='myeval(301);';
     btnPos=[xPos+1.15*btnLen*7 yPos-1.4*btnWid*(i-1) btnLen btnWid];
      anisHndl(i,7)=uicontrol( ...
      'Style','edit', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'FontSize',allfontsize,...
      'BackgroundColor',editbgcolor ,...
      'FontWeight','demi',...
      'Callback',callbackStr);
end;
%====================================
% The mat #
yPos=0.05;
   btnPos=[xPos yPos btnLen btnWid];
   anismatnumtextHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'BackgroundColor',framebgcolor, ...
      'FontSize',allfontsize,...
      'FontWeight','demi',...
      'String','Material ');
   btnPos=[xPos+0.11 yPos btnLen*0.2 btnWid];
   anismatnmHndl=uicontrol( ...
      'Style','text', ...    
      'Units','normalized', ...
      'BackgroundColor',framebgcolor, ...
      'FontSize',allfontsize,...
      'FontWeight','demi',...
      'String',num2str(MatNm),...
      'Position',btnPos ...
   );
   
   %====================================
   % The matname
   btnPos=[xPos+btnLen*2 yPos btnLen btnWid];
   anistextnameHndl=uicontrol( ...
      'Style','text', ...
      'Units','normalized', ...
      'Position',btnPos, ...
       'BackgroundColor',framebgcolor, ...
       'FontSize',allfontsize,...
       'FontWeight','demi',...
      'String','Name');
   
   callbackStr='myeval(302);';
         
      %Setting userdata to -1 (=stop) will stop the demo.
      %callbackStr='set(gca,''Userdata'',-1)';
      btnPos=[xPos+3*btnLen yPos+0.015 btnLen*1.75 btnWid];
      anisnameHndl=uicontrol( ...
      'Style','edit', ...
      'Units','normalized', ...
      'Position',btnPos, ...
      'BackgroundColor',editbgcolor, ...
      'FontSize',allfontsize,...
      'FontWeight','demi',...
      'String',MatlParam{MatNm}{1},...
      'Callback',callbackStr);
   
   %====================================
   % apply, unapply and cancel)
   btnPos=[xPos+0.005+5.4*btnLen 0.05 btnLen*1.2 btnWid*1.5];
   callbackStr='myeval(303);';
   anisokHndl=uicontrol( ...
   'Style','push', ...
   'String','Apply',...
      'Units','normalized', ...
      'Position',btnPos, ...
      'FontSize',allfontsize,...
      'FontWeight','demi',...
      'Callback',callbackStr);
      
   btnPos=[xPos+0.005+6.6*btnLen 0.05 btnLen*1.2 btnWid*1.5];
   callbackStr='myeval(304);';
   anisunapplyHndl=uicontrol( ...
   'Style','push', ...
   'String','Unapply',...
      'Units','normalized', ...
      'Position',btnPos, ...
      'FontSize',allfontsize,...
      'FontWeight','demi',...
      'Callback',callbackStr);    
      
   
btnPos=[xPos+0.005+7.8*btnLen 0.05 btnLen*1.2 btnWid*1.5];  
aniscancelHndl=uicontrol( ...
   'Style','push', ...
   'String','Cancel',...
    'Units','normalized', ...
      'Position',btnPos, ...
      'FontSize',allfontsize,...
      'FontWeight','demi',...
      'Callback','close(gcf)');
   
   %=====================
   % initialize
   if AnisFlag(MatNm)==1,
   for i=1:6,
      for j=i:7,
         set(anisHndl(i,j),'String',AnisParam{MatNm}{i,j});
      end;
   end;
  else 
    for i=1:6,
      for j=i:7,
         if j<4 | j==i | (j==7 & i<4),
         set(anisHndl(i,j),'String','');
         else
         set(anisHndl(i,j),'String','0');
         end;
        AnisParam{MatNm}{i,j}='0';
      end;
   end;
end;
  
